{"vars":[{"line":127,"name":"base","containerName":"","kind":2},{"definition":"sub","detail":"($self)","children":[{"line":144,"containerName":"name","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"name","kind":13,"name":"$self","line":146},{"line":146,"containerName":"name","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"name","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).","parameters":[{"label":"$self"}],"label":"name($self)"},"line":143,"kind":12,"range":{"start":{"line":143,"character":0},"end":{"character":9999,"line":148}}},{"detail":"($self)","definition":"sub","containerName":"main::","name":"description","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"description","line":166},{"line":168,"name":"$self","kind":13,"containerName":"description"},{"kind":12,"containerName":"description","name":"throw_not_implemented","line":168}],"signature":{"label":"description($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional)."},"range":{"start":{"character":0,"line":165},"end":{"line":170,"character":9999}},"kind":12,"line":165},{"signature":{"label":"species($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional)."},"range":{"start":{"character":0,"line":187},"end":{"character":9999,"line":192}},"kind":12,"line":187,"detail":"($self)","definition":"sub","containerName":"main::","name":"species","children":[{"definition":"my","line":188,"containerName":"species","localvar":"my","kind":13,"name":"$self"},{"name":"$self","containerName":"species","kind":13,"line":190},{"line":190,"name":"throw_not_implemented","containerName":"species","kind":12}]},{"children":[{"definition":"my","line":210,"name":"$self","kind":13,"localvar":"my","containerName":"comment"},{"line":212,"name":"$self","kind":13,"containerName":"comment"},{"line":212,"kind":12,"containerName":"comment","name":"throw_not_implemented"}],"name":"comment","containerName":"main::","definition":"sub","detail":"($self)","line":209,"range":{"end":{"line":214,"character":9999},"start":{"character":0,"line":209}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).","label":"comment($self)"}},{"children":[{"line":231,"localvar":"my","containerName":"each_gene_symbol","kind":13,"name":"$self","definition":"my"},{"name":"$self","containerName":"each_gene_symbol","kind":13,"line":233},{"line":233,"name":"throw_not_implemented","kind":12,"containerName":"each_gene_symbol"}],"name":"each_gene_symbol","containerName":"main::","definition":"sub","detail":"($self)","line":230,"range":{"start":{"character":0,"line":230},"end":{"character":9999,"line":235}},"kind":12,"signature":{"label":"each_gene_symbol($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}]}},{"signature":{"label":"add_gene_symbols($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"line":251,"character":0},"end":{"character":9999,"line":256}},"line":251,"detail":"($self)","definition":"sub","name":"add_gene_symbols","containerName":"main::","children":[{"definition":"my","line":252,"localvar":"my","kind":13,"containerName":"add_gene_symbols","name":"$self"},{"line":254,"name":"$self","containerName":"add_gene_symbols","kind":13},{"containerName":"add_gene_symbols","kind":12,"name":"throw_not_implemented","line":254}]},{"line":269,"range":{"start":{"character":0,"line":269},"end":{"character":9999,"line":274}},"kind":12,"signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_gene_symbols($self)"},"children":[{"localvar":"my","kind":13,"containerName":"remove_gene_symbols","name":"$self","line":270,"definition":"my"},{"line":272,"name":"$self","kind":13,"containerName":"remove_gene_symbols"},{"name":"throw_not_implemented","kind":12,"containerName":"remove_gene_symbols","line":272}],"containerName":"main::","name":"remove_gene_symbols","definition":"sub","detail":"($self)"},{"kind":12,"range":{"start":{"character":0,"line":294},"end":{"character":9999,"line":299}},"line":294,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :","label":"each_Variant($self)"},"containerName":"main::","name":"each_Variant","children":[{"line":295,"name":"$self","kind":13,"localvar":"my","containerName":"each_Variant","definition":"my"},{"name":"$self","containerName":"each_Variant","kind":13,"line":297},{"line":297,"kind":12,"containerName":"each_Variant","name":"throw_not_implemented"}],"detail":"($self)","definition":"sub"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":315,"name":"$self","kind":13,"localvar":"my","containerName":"add_Variants"},{"line":317,"name":"$self","containerName":"add_Variants","kind":13},{"line":317,"name":"throw_not_implemented","kind":12,"containerName":"add_Variants"}],"name":"add_Variants","containerName":"main::","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).","parameters":[{"label":"$self"}],"label":"add_Variants($self)"},"line":314,"range":{"end":{"character":9999,"line":319},"start":{"character":0,"line":314}},"kind":12},{"range":{"end":{"line":338,"character":9999},"start":{"line":333,"character":0}},"kind":12,"line":333,"signature":{"label":"remove_Variants($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :"},"containerName":"main::","name":"remove_Variants","children":[{"definition":"my","line":334,"name":"$self","kind":13,"localvar":"my","containerName":"remove_Variants"},{"kind":13,"containerName":"remove_Variants","name":"$self","line":336},{"line":336,"containerName":"remove_Variants","kind":12,"name":"throw_not_implemented"}],"detail":"($self)","definition":"sub"},{"detail":"($self)","definition":"sub","name":"each_Reference","containerName":"main::","children":[{"definition":"my","line":355,"localvar":"my","containerName":"each_Reference","kind":13,"name":"$self"},{"kind":13,"containerName":"each_Reference","name":"$self","line":357},{"kind":12,"containerName":"each_Reference","name":"throw_not_implemented","line":357}],"signature":{"label":"each_Reference($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":359,"character":9999},"start":{"character":0,"line":354}},"line":354},{"signature":{"label":"add_References($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).","parameters":[{"label":"$self"}]},"line":375,"range":{"end":{"character":9999,"line":380},"start":{"character":0,"line":375}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","containerName":"add_References","kind":13,"name":"$self","line":376},{"line":378,"containerName":"add_References","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"add_References","line":378}],"containerName":"main::","name":"add_References"},{"containerName":"main::","name":"remove_References","children":[{"definition":"my","name":"$self","containerName":"remove_References","localvar":"my","kind":13,"line":395},{"line":397,"containerName":"remove_References","kind":13,"name":"$self"},{"kind":12,"containerName":"remove_References","name":"throw_not_implemented","line":397}],"detail":"($self)","definition":"sub","range":{"end":{"line":399,"character":9999},"start":{"line":394,"character":0}},"kind":12,"line":394,"signature":{"label":"remove_References($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","parameters":[{"label":"$self"}]}},{"containerName":"main::","name":"each_CytoPosition","children":[{"kind":13,"localvar":"my","containerName":"each_CytoPosition","name":"$self","line":416,"definition":"my"},{"name":"$self","kind":13,"containerName":"each_CytoPosition","line":418},{"line":418,"containerName":"each_CytoPosition","kind":12,"name":"throw_not_implemented"}],"detail":"($self)","definition":"sub","range":{"start":{"line":415,"character":0},"end":{"character":9999,"line":420}},"kind":12,"line":415,"signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_CytoPosition($self)"}},{"signature":{"label":"add_CytoPositions($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).","parameters":[{"label":"$self"}]},"line":436,"range":{"start":{"line":436,"character":0},"end":{"line":441,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"line":437,"name":"$self","localvar":"my","kind":13,"containerName":"add_CytoPositions","definition":"my"},{"line":439,"name":"$self","containerName":"add_CytoPositions","kind":13},{"containerName":"add_CytoPositions","kind":12,"name":"throw_not_implemented","line":439}],"containerName":"main::","name":"add_CytoPositions"},{"signature":{"label":"remove_CytoPositions($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :"},"line":455,"range":{"start":{"line":455,"character":0},"end":{"character":9999,"line":460}},"kind":12,"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"remove_CytoPositions","kind":13,"name":"$self","line":456,"definition":"my"},{"line":458,"name":"$self","containerName":"remove_CytoPositions","kind":13},{"line":458,"name":"throw_not_implemented","containerName":"remove_CytoPositions","kind":12}],"containerName":"main::","name":"remove_CytoPositions"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :","label":"each_Correlate($self)"},"kind":12,"range":{"end":{"character":9999,"line":484},"start":{"character":0,"line":479}},"line":479,"detail":"($self)","definition":"sub","containerName":"main::","name":"each_Correlate","children":[{"name":"$self","localvar":"my","containerName":"each_Correlate","kind":13,"line":480,"definition":"my"},{"line":482,"name":"$self","kind":13,"containerName":"each_Correlate"},{"line":482,"name":"throw_not_implemented","kind":12,"containerName":"each_Correlate"}]},{"range":{"end":{"line":507,"character":9999},"start":{"character":0,"line":502}},"kind":12,"line":502,"signature":{"label":"add_Correlates($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).","parameters":[{"label":"$self"}]},"name":"add_Correlates","containerName":"main::","children":[{"definition":"my","line":503,"name":"$self","localvar":"my","containerName":"add_Correlates","kind":13},{"name":"$self","kind":13,"containerName":"add_Correlates","line":505},{"name":"throw_not_implemented","containerName":"add_Correlates","kind":12,"line":505}],"detail":"($self)","definition":"sub"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :","label":"remove_Correlates($self)"},"range":{"start":{"character":0,"line":521},"end":{"line":526,"character":9999}},"kind":12,"line":521,"detail":"($self)","definition":"sub","name":"remove_Correlates","containerName":"main::","children":[{"line":522,"localvar":"my","kind":13,"containerName":"remove_Correlates","name":"$self","definition":"my"},{"containerName":"remove_Correlates","kind":13,"name":"$self","line":524},{"line":524,"kind":12,"containerName":"remove_Correlates","name":"throw_not_implemented"}]},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"each_Measure","line":545,"definition":"my"},{"kind":13,"containerName":"each_Measure","name":"$self","line":547},{"line":547,"name":"throw_not_implemented","containerName":"each_Measure","kind":12}],"containerName":"main::","name":"each_Measure","definition":"sub","detail":"($self)","line":544,"range":{"end":{"line":549,"character":9999},"start":{"character":0,"line":544}},"kind":12,"signature":{"label":"each_Measure($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :","parameters":[{"label":"$self"}]}},{"kind":12,"range":{"start":{"character":0,"line":565},"end":{"character":9999,"line":570}},"line":565,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).","label":"add_Measures($self)"},"containerName":"main::","name":"add_Measures","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"add_Measures","line":566,"definition":"my"},{"kind":13,"containerName":"add_Measures","name":"$self","line":568},{"line":568,"name":"throw_not_implemented","containerName":"add_Measures","kind":12}],"detail":"($self)","definition":"sub"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"remove_Measures","children":[{"definition":"my","line":585,"localvar":"my","containerName":"remove_Measures","kind":13,"name":"$self"},{"line":587,"kind":13,"containerName":"remove_Measures","name":"$self"},{"line":587,"name":"throw_not_implemented","containerName":"remove_Measures","kind":12}],"signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_Measures($self)"},"kind":12,"range":{"end":{"line":589,"character":9999},"start":{"line":584,"character":0}},"line":584},{"containerName":"main::","name":"each_keyword","children":[{"name":"$self","localvar":"my","containerName":"each_keyword","kind":13,"line":606,"definition":"my"},{"line":608,"name":"$self","containerName":"each_keyword","kind":13},{"line":608,"containerName":"each_keyword","kind":12,"name":"throw_not_implemented"}],"detail":"($self)","definition":"sub","range":{"end":{"line":610,"character":9999},"start":{"line":605,"character":0}},"kind":12,"line":605,"signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"each_keyword($self)"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).","label":"add_keywords($self)"},"kind":12,"range":{"end":{"character":9999,"line":631},"start":{"line":626,"character":0}},"line":626,"detail":"($self)","definition":"sub","name":"add_keywords","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"add_keywords","name":"$self","line":627},{"line":629,"containerName":"add_keywords","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"add_keywords","line":629}]},{"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"remove_keywords","kind":13,"line":646},{"line":648,"containerName":"remove_keywords","kind":13,"name":"$self"},{"kind":12,"containerName":"remove_keywords","name":"throw_not_implemented","line":648}],"name":"remove_keywords","containerName":"main::","signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_keywords($self)"},"line":645,"range":{"start":{"character":0,"line":645},"end":{"line":650,"character":9999}},"kind":12},{"definition":"sub","detail":"($self)","children":[{"line":667,"name":"$self","localvar":"my","containerName":"each_DBLink","kind":13,"definition":"my"},{"line":669,"name":"$self","kind":13,"containerName":"each_DBLink"},{"name":"throw_not_implemented","containerName":"each_DBLink","kind":12,"line":669}],"name":"each_DBLink","containerName":"main::","signature":{"label":"each_DBLink($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :","parameters":[{"label":"$self"}]},"line":666,"range":{"end":{"line":671,"character":9999},"start":{"line":666,"character":0}},"kind":12},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":688,"kind":13,"localvar":"my","containerName":"add_DBLinks","name":"$self"},{"name":"$self","containerName":"add_DBLinks","kind":13,"line":690},{"line":690,"name":"throw_not_implemented","kind":12,"containerName":"add_DBLinks"}],"name":"add_DBLinks","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).","label":"add_DBLinks($self)"},"line":687,"kind":12,"range":{"start":{"character":0,"line":687},"end":{"line":692,"character":9999}}},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":707,"name":"$self","localvar":"my","kind":13,"containerName":"remove_DBLinks"},{"line":709,"name":"$self","kind":13,"containerName":"remove_DBLinks"},{"line":709,"containerName":"remove_DBLinks","kind":12,"name":"throw_not_implemented"}],"name":"remove_DBLinks","containerName":"main::","signature":{"label":"remove_DBLinks($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :","parameters":[{"label":"$self"}]},"line":706,"range":{"end":{"line":711,"character":9999},"start":{"character":0,"line":706}},"kind":12},{"kind":12,"range":{"start":{"character":0,"line":730},"end":{"line":735,"character":9999}},"line":730,"signature":{"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_Genotype($self)"},"name":"each_Genotype","containerName":"main::","children":[{"line":731,"name":"$self","localvar":"my","kind":13,"containerName":"each_Genotype","definition":"my"},{"line":733,"name":"$self","containerName":"each_Genotype","kind":13},{"containerName":"each_Genotype","kind":12,"name":"throw_not_implemented","line":733}],"detail":"($self)","definition":"sub"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":752,"containerName":"add_Genotypes","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"add_Genotypes","name":"$self","line":754},{"name":"throw_not_implemented","kind":12,"containerName":"add_Genotypes","line":754}],"containerName":"main::","name":"add_Genotypes","signature":{"label":"add_Genotypes($self)","documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".","parameters":[{"label":"$self"}]},"line":751,"kind":12,"range":{"end":{"character":9999,"line":756},"start":{"character":0,"line":751}}},{"name":"remove_Genotypes","containerName":"main::","children":[{"definition":"my","line":771,"kind":13,"localvar":"my","containerName":"remove_Genotypes","name":"$self"},{"name":"$self","containerName":"remove_Genotypes","kind":13,"line":773},{"line":773,"name":"throw_not_implemented","kind":12,"containerName":"remove_Genotypes"}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":775},"start":{"character":0,"line":770}},"kind":12,"line":770,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhenotypeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::PhenotypeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::PhenotypeI - An interface for classes modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This interface provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::PhenotypeI;\nuse base qw(Bio::Root::RootI);\n\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # name\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n     my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # description\n\n\n\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # species\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # comment\n\n\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();                 \n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );                  \n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();                 \n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );                  \n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".\n\n\nsub add_Genotypes {\n    my ( $self ) = @_;\n\n    $self->throw_not_implemented();\n    \n} # add_Genotypes\n\n\n=head2 remove_Genotypes\n\n Title   : remove_Genotypes\n Usage   : $obj->remove_Genotypes();\n Function: Deletes (and returns) the list of \"Genotype\" objects\n           associated with this phenotype.\n Returns : A list of \"Genotype\" objects.\n Args    :","label":"remove_Genotypes($self)"}}],"version":5}