{"vars":[{"name":"base","kind":2,"containerName":"","line":98},{"line":100,"range":{"end":{"line":121,"character":9999},"start":{"character":0,"line":100}},"kind":12,"signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":102},{"line":102,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":103,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$class","line":103},{"name":"@args","kind":13,"containerName":"new","line":103},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$id","line":105},{"name":"$name","containerName":"new","kind":13,"line":105},{"line":105,"containerName":"new","kind":13,"name":"$description"},{"line":105,"name":"$comment","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":105},{"name":"_rearrange","kind":12,"containerName":"new","line":106},{"name":"@args","containerName":"new","kind":13,"line":112},{"kind":13,"containerName":"new","name":"$self","line":114},{"name":"$id","containerName":"new","kind":13,"line":116},{"containerName":"new","kind":13,"name":"$self","line":116},{"line":116,"name":"id","kind":12,"containerName":"new"},{"line":116,"name":"$id","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$name","line":117},{"name":"$self","containerName":"new","kind":13,"line":117},{"line":117,"kind":12,"containerName":"new","name":"name"},{"line":117,"name":"$name","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$description","line":118},{"kind":13,"containerName":"new","name":"$self","line":118},{"name":"description","containerName":"new","kind":12,"line":118},{"line":118,"containerName":"new","kind":13,"name":"$description"},{"name":"$self","kind":13,"containerName":"new","line":120}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"name":"SUPER","containerName":"new","kind":12,"line":103},{"line":136,"range":{"end":{"line":140,"character":9999},"start":{"line":136,"character":0}},"kind":12,"signature":{"label":"id($self,$value)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"definition":"my","line":137,"containerName":"id","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"id","name":"$value","line":137},{"line":138,"name":"$self","kind":13,"containerName":"id"},{"line":138,"name":"$value","kind":13,"containerName":"id"},{"kind":13,"containerName":"id","name":"$value","line":138},{"containerName":"id","kind":13,"name":"$self","line":139}],"name":"id","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"line":154,"kind":12,"range":{"end":{"line":158,"character":9999},"start":{"line":154,"character":0}},"signature":{"label":"name($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional)."},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"name","line":155,"definition":"my"},{"containerName":"name","kind":13,"name":"$value","line":155},{"kind":13,"containerName":"name","name":"$self","line":156},{"line":156,"name":"$value","kind":13,"containerName":"name"},{"line":156,"name":"$value","kind":13,"containerName":"name"},{"line":157,"name":"$self","kind":13,"containerName":"name"}],"containerName":"main::","name":"name","definition":"sub","detail":"($self,$value)"},{"children":[{"name":"$self","localvar":"my","containerName":"description","kind":13,"line":173,"definition":"my"},{"line":173,"name":"$value","kind":13,"containerName":"description"},{"line":174,"containerName":"description","kind":13,"name":"$self"},{"line":174,"name":"$value","containerName":"description","kind":13},{"line":174,"containerName":"description","kind":13,"name":"$value"},{"containerName":"description","kind":13,"name":"$self","line":175}],"name":"description","containerName":"main::","definition":"sub","detail":"($self,$value)","line":172,"kind":12,"range":{"start":{"character":0,"line":172},"end":{"character":9999,"line":176}},"signature":{"label":"description($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional)."}},{"kind":12,"range":{"end":{"character":9999,"line":194},"start":{"line":192,"character":0}},"line":192,"signature":{"label":"add_synonym($self,@values)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).","parameters":[{"label":"$self"},{"label":"@values"}]},"containerName":"main::","name":"add_synonym","children":[{"line":193,"containerName":"add_synonym","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":193,"name":"@values","kind":13,"containerName":"add_synonym"},{"name":"$self","containerName":"add_synonym","kind":13,"line":194}],"detail":"($self,@values)","definition":"sub"},{"name":"@values","containerName":null,"kind":13,"line":194},{"line":208,"range":{"end":{"line":210,"character":9999},"start":{"character":0,"line":208}},"kind":12,"definition":"sub","children":[{"line":209,"name":"$self","containerName":"each_synonym","localvar":"my","kind":13,"definition":"my"},{"containerName":"each_synonym","kind":13,"name":"$self","line":210}],"containerName":"main::","name":"each_synonym"},{"name":"purge_synonyms","containerName":"main::","children":[{"line":223,"name":"$self","localvar":"my","containerName":"purge_synonyms","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"purge_synonyms","line":224}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":225,"character":9999},"start":{"character":0,"line":222}},"line":222,"signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n    push( @{ $self->{ \"_synonyms\" } }, @values );\n}\n\n=head2 each_synonym\n\n Title   : each_synonym()\n Usage   : @gs = $obj->each_synonym();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_synonym {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_synonyms\" } };\n}\n\n=head2 purge_synonyms\n\n Usage   : $obj->purge_synonym();\n Function: Deletes  the list of synonyms to this term.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"purge_synonyms($self)"}},{"range":{"start":{"line":251,"character":0},"end":{"character":9999,"line":258}},"kind":12,"line":251,"signature":{"parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n    push( @{ $self->{ \"_synonyms\" } }, @values );\n}\n\n=head2 each_synonym\n\n Title   : each_synonym()\n Usage   : @gs = $obj->each_synonym();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_synonym {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_synonyms\" } };\n}\n\n=head2 purge_synonyms\n\n Usage   : $obj->purge_synonym();\n Function: Deletes  the list of synonyms to this term.\n Returns : A list of scalars.\n Args    :\n\n\nsub purge_synonyms {\n    my ( $self ) = @_;\n    $self->{ \"_synonyms\" } = [];\n}\n\n\n=head2 Twig management\n\nEach MeSH term belongs to a complex tree like hierachy of terms where\neach term can appear multiple times. The immediately surrounding nodes\nof the tree are modelled in twigs.\n\nSee: L<Bio::Phenotype::MeSH::Twig>.\n\n\n=head2 add_twig\n\n Title   : add_twig\n Usage   : $obj->add_twig( @twigs );\n           or\n           $obj->add_twig( $twig );\n Function: Pushes one or more twig term names [scalars, most likely Strings]\n           into the list of twigs.\n Returns : \n Args    : scalar(s).","label":"add_twig($self,@values)"},"name":"add_twig","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"add_twig","kind":13,"name":"$self","line":252},{"containerName":"add_twig","kind":13,"name":"@values","line":252},{"definition":"my","line":253,"localvar":"my","containerName":"add_twig","kind":13,"name":"$twig"},{"name":"@values","containerName":"add_twig","kind":13,"line":253},{"line":254,"name":"$self","containerName":"add_twig","kind":13},{"line":254,"name":"warn","containerName":"add_twig","kind":12},{"line":255,"containerName":"add_twig","kind":13,"name":"$twig"},{"line":255,"name":"isa","containerName":"add_twig","kind":12},{"name":"$twig","kind":13,"containerName":"add_twig","line":256},{"line":256,"kind":12,"containerName":"add_twig","name":"term"},{"line":256,"name":"$self","kind":13,"containerName":"add_twig"},{"line":257,"containerName":"add_twig","kind":13,"name":"$self"},{"name":"$twig","kind":13,"containerName":"add_twig","line":257}],"detail":"($self,@values)","definition":"sub"},{"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"each_twig","line":274,"definition":"my"},{"line":275,"name":"$self","containerName":"each_twig","kind":13}],"name":"each_twig","containerName":"main::","line":273,"kind":12,"range":{"start":{"character":0,"line":273},"end":{"character":9999,"line":275}}},{"name":"purge_twigs","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"purge_twigs","line":288},{"name":"$self","kind":13,"containerName":"purge_twigs","line":289}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":290,"character":9999},"start":{"line":287,"character":0}},"line":287,"signature":{"label":"purge_twigs($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::MeSH::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho, heikki-at-bioperl-dot-org\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::MeSH::Term - A MeSH term\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::MeSH::Term;\n\n  # create a term object\n  my $term = Bio::Phenotype::MeSH::Term->new\n      (-id => 'D000001',\n       -name => 'Dietary Fats',\n       -description => 'dietary fats are...'\n      );\n\n  # get a Bio::Phenotype::MeSH::Twig somehow...\n  $term->add_twig($twig1);\n\n\n=head1 DESCRIPTION\n\nThis class keeps information about MeSH terms. MeSH stands for Medical\nSubject Headings and is one of the ways for annotaing biomedical\nliterature.  The terminology is maintained by National Library of\nMedicine of USA . See http://www.nlm.nih.gov/mesh/meshhome.html.\n\nIn addition to id, name and description a term can know about its\nsurrounding terms (Bio::Phenotype::MeSH::Twig) in the term hierarchy.\n\nThis class is mainly used from Bio::DB::MeSH which retrieves terms\nover the Web.\n\n=head1 SEE ALSO\n\nL<Bio::DB::MeSH>, \nL<Bio::Phenotype::MeSH::Twig>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::MeSH::Term;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n\n    my( $class,@args ) = @_;\n    my $self = $class->SUPER::new( @args );\n\n    my ( $id, $name, $description, $comment ) = $self->_rearrange\n        ( [ qw( ID\n                NAME\n                DESCRIPTION\n                SPECIES\n                COMMENT\n              ) ],\n          @args );\n\n    $self->{\"_twigs\"} = [];\n\n    $id            && $self->id( $id );\n    $name          && $self->name( $name );\n    $description   && $self->description( $description );\n\n    return $self;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id( \"r1\" );\n           or\n           print $obj->id();\n Function: Set/get for the id.\n Returns : A id [scalar].\n Args    : A id [scalar] (optional).\n\n\nsub id {\n    my ( $self, $value ) = @_;\n    $self->{ \"_id\" } = $value if defined $value;\n    return $self->{ \"_id\" };\n}\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name.\n Returns : A name [scalar].\n Args    : A name [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n    $self->{ \"_name\" } = $value if defined $value;\n    return $self->{ \"_name\" };\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"r1\" );\n           or\n           print $obj->description();\n Function: Set/get for the description.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n    $self->{ \"_description\" } = $value if defined $value;\n    return $self->{ \"_description\" };\n}\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $obj->add_synonym( @synonyms );\n           or\n           $obj->add_synonym( $synonym );\n Function: Pushes one or more synonyms for the term  term\n           into the list of synonyms.\n Returns : \n Args    : scalar(s).\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n    push( @{ $self->{ \"_synonyms\" } }, @values );\n}\n\n=head2 each_synonym\n\n Title   : each_synonym()\n Usage   : @gs = $obj->each_synonym();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_synonym {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_synonyms\" } };\n}\n\n=head2 purge_synonyms\n\n Usage   : $obj->purge_synonym();\n Function: Deletes  the list of synonyms to this term.\n Returns : A list of scalars.\n Args    :\n\n\nsub purge_synonyms {\n    my ( $self ) = @_;\n    $self->{ \"_synonyms\" } = [];\n}\n\n\n=head2 Twig management\n\nEach MeSH term belongs to a complex tree like hierachy of terms where\neach term can appear multiple times. The immediately surrounding nodes\nof the tree are modelled in twigs.\n\nSee: L<Bio::Phenotype::MeSH::Twig>.\n\n\n=head2 add_twig\n\n Title   : add_twig\n Usage   : $obj->add_twig( @twigs );\n           or\n           $obj->add_twig( $twig );\n Function: Pushes one or more twig term names [scalars, most likely Strings]\n           into the list of twigs.\n Returns : \n Args    : scalar(s).\n\n\nsub add_twig {\n    my ( $self, @values ) = @_;\n    foreach my $twig (@values) {\n        $self->warn (\"Not a MeSH twig [$twig]\")\n            unless $twig->isa('Bio::Phenotype::MeSH::Twig');\n        $twig->term($self);\n        push( @{ $self->{ \"_twigs\" } }, $twig );\n    }\n    1;\n}\n\n=head2 each_twig\n\n Title   : each_twig()\n Usage   : @gs = $obj->each_twig();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_twig {\n    my ( $self ) = shift;\n    return @{ $self->{ \"_twigs\" } };\n}\n\n=head2 purge_twigs\n\n Usage   : $obj->purge_twig();\n Function: Deletes  the list of twigs associated with this term.\n Returns : A list of scalars.\n Args    :"}},{"definition":"sub","containerName":"main::","name":"each_parent","children":[{"definition":"my","line":304,"localvar":"my","kind":13,"containerName":"each_parent","name":"$self"},{"name":"parent","kind":12,"containerName":"each_parent","line":305},{"line":305,"containerName":"each_parent","kind":13,"name":"$self"}],"kind":12,"range":{"start":{"line":303,"character":0},"end":{"line":305,"character":9999}},"line":303}],"version":5}