{"version":5,"vars":[{"definition":1,"line":115,"containerName":"main::","kind":14,"name":"TRUE"},{"line":115,"name":"strict","kind":12,"containerName":"Bio::Ontology::TermFactory"},{"containerName":"main::","kind":14,"name":"FALSE","line":116,"definition":1},{"line":119,"containerName":"","kind":2,"name":"base"},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"line":154,"name":"$self","localvar":"my","kind":13,"containerName":"_initialize","definition":"my"},{"kind":13,"containerName":"_initialize","name":"@args","line":154},{"kind":13,"containerName":"_initialize","name":"$self","line":156},{"name":"@args","kind":13,"containerName":"_initialize","line":156},{"name":"$self","kind":13,"containerName":"_initialize","line":159},{"line":159,"name":"term_factory","containerName":"_initialize","kind":12},{"name":"new","containerName":"_initialize","kind":12,"line":159},{"line":161,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"containerName":"_initialize","name":"term_factory","line":161}],"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: soflat.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO::soflat\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) Hilmar Lapp, hlapp at gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002-3.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::soflat - a parser for the Sequence Ontology flat-file format\n\n=head1 SYNOPSIS\n\n  use Bio::OntologyIO;\n\n  # do not use directly -- use via Bio::OntologyIO\n  my $parser = Bio::OntologyIO->new\n\t( -format       => \"so\", # or soflat\n     -defs_file    => \"/home/czmasek/SO/SO.defs\",\n\t  -file         => \"/home/czmasek/SO/sofa.ontology\" );\n\n  my $sofa_ontology = $parser->next_ontology();\n\n  my $IS_A    = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  my $PART_OF = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis is essentially a very thin derivation of the dagflat base-parser.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage  Bio::OntologyIO::soflat;\n\nuse strict;\n\nuse Bio::Ontology::TermFactory;\n\nuse constant TRUE         => 1;\nuse constant FALSE        => 0;\n\n\nuse base qw(Bio::OntologyIO::dagflat);\n\n\n=head2 new\n\n Title   : new\n Usage   : $parser = Bio::OntologyIO->new(\n                             -format => \"soflat\",\n                             -files => [\"/path/to/sofa.ontology\"] );\n Function: Creates a new soflat parser.\n Returns : A new soflat parser object, implementing Bio::OntologyIO.\n Args    : -defs_file  => the name of the file holding the term\n                          definitions\n           -files      => a single ontology flat file holding the\n                          term relationships, or an array ref holding\n                          the file names\n           -file       => if there is only a single flat file, it may\n                          also be specified via the -file parameter\n           -ontology_name => the name of the ontology; if not specified the\n                          parser will auto-discover it by using the term\n                          that starts with a $, and converting underscores\n                          to spaces\n           -engine     => the Bio::Ontology::OntologyEngineI object\n                          to be reused (will be created otherwise); note\n                          that every Bio::Ontology::OntologyI will\n                          qualify as well since that one inherits from the\n                          former.\n\nSee L<Bio::Ontology::OntologyI>.\n\n in reality, we let OntologyIO::new do the instantiation, and override\n _initialize for all initialization work"},"kind":12,"range":{"start":{"character":0,"line":153},"end":{"line":163,"character":9999}},"line":153},{"kind":12,"containerName":"_initialize","name":"SUPER","line":156},{"line":159,"containerName":"Ontology::TermFactory","kind":12,"name":"Bio"}]}