{"vars":[{"line":94,"name":"base","containerName":"","kind":2},{"line":96,"name":"$record_count","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"$processed_count","containerName":null,"kind":13,"line":96},{"line":96,"name":"$is_a_rel","containerName":null,"kind":13},{"name":"$contains_rel","kind":13,"containerName":null,"line":96},{"line":96,"name":"$found_in_rel","kind":13,"containerName":null},{"line":110,"range":{"end":{"character":9999,"line":141},"start":{"character":0,"line":110}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :","label":"new($class,@args)"},"children":[{"name":"$class","kind":13,"localvar":"my","containerName":"new","line":111,"definition":"my"},{"line":111,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":112,"containerName":"new","localvar":"my","kind":13,"name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":112},{"line":112,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$eng","line":114},{"containerName":"new","kind":13,"name":"$ont","line":114},{"containerName":"new","kind":13,"name":"$name","line":114},{"line":114,"containerName":"new","kind":13,"name":"$fact"},{"name":"$self","containerName":"new","kind":13,"line":115},{"kind":12,"containerName":"new","name":"_rearrange","line":115},{"name":"@args","containerName":"new","kind":13,"line":119},{"line":121,"name":"$ont","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":122},{"name":"ontology","kind":12,"containerName":"new","line":122},{"line":122,"name":"$ont","containerName":"new","kind":13},{"line":124,"kind":13,"containerName":"new","name":"$name"},{"name":"$name","kind":13,"containerName":"new","line":124},{"kind":13,"containerName":"new","name":"$self","line":125},{"line":125,"containerName":"new","kind":12,"name":"ontology"},{"line":125,"containerName":"new","kind":12,"name":"new"},{"line":125,"kind":13,"containerName":"new","name":"$name"},{"line":127,"name":"$self","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"ontology_engine","line":127},{"line":127,"name":"$eng","containerName":"new","kind":13},{"line":127,"containerName":"new","kind":13,"name":"$eng"},{"containerName":"new","kind":13,"name":"$self","line":129},{"kind":12,"containerName":"new","name":"term_factory","line":129},{"kind":13,"containerName":"new","name":"$fact","line":129},{"line":129,"name":"$fact","kind":13,"containerName":"new"},{"line":131,"containerName":"new","kind":13,"name":"$is_a_rel"},{"kind":12,"containerName":"new","name":"get_instance","line":131},{"line":132,"name":"$contains_rel","containerName":"new","kind":13},{"line":132,"name":"get_instance","kind":12,"containerName":"new"},{"line":133,"name":"$found_in_rel","kind":13,"containerName":"new"},{"line":133,"containerName":"new","kind":12,"name":"get_instance"},{"name":"$is_a_rel","containerName":"new","kind":13,"line":134},{"kind":12,"containerName":"new","name":"ontology","line":134},{"line":134,"name":"$self","kind":13,"containerName":"new"},{"line":134,"containerName":"new","kind":12,"name":"ontology"},{"line":135,"containerName":"new","kind":13,"name":"$contains_rel"},{"line":135,"kind":12,"containerName":"new","name":"ontology"},{"line":135,"containerName":"new","kind":13,"name":"$self"},{"line":135,"name":"ontology","kind":12,"containerName":"new"},{"name":"$found_in_rel","kind":13,"containerName":"new","line":136},{"line":136,"containerName":"new","kind":12,"name":"ontology"},{"line":136,"containerName":"new","kind":13,"name":"$self"},{"line":136,"name":"ontology","containerName":"new","kind":12},{"name":"$self","containerName":"new","kind":13,"line":137},{"line":137,"containerName":"new","kind":12,"name":"_cite_skip"},{"name":"$self","containerName":"new","kind":13,"line":138},{"line":138,"containerName":"new","kind":12,"name":"secondary_accessions_map"},{"line":140,"name":"$self","containerName":"new","kind":13}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"containerName":"new","kind":12,"name":"SUPER","line":112},{"kind":12,"containerName":"Ontology::Ontology","name":"Bio","line":125},{"line":131,"containerName":"Ontology::RelationshipType","kind":12,"name":"Bio"},{"line":132,"containerName":"Ontology::RelationshipType","kind":12,"name":"Bio"},{"containerName":"Ontology::RelationshipType","kind":12,"name":"Bio","line":133},{"children":[{"line":156,"kind":13,"localvar":"my","containerName":"ontology_engine","name":"$self","definition":"my"},{"kind":13,"containerName":"ontology_engine","name":"$value","line":156},{"containerName":"ontology_engine","kind":13,"name":"$value","line":158},{"line":159,"kind":13,"containerName":"ontology_engine","name":"$self"},{"line":160,"kind":13,"containerName":"ontology_engine","name":"$self"},{"containerName":"ontology_engine","kind":12,"name":"throw","line":160},{"name":"$self","containerName":"ontology_engine","kind":13,"line":162},{"line":162,"containerName":"ontology_engine","kind":12,"name":"throw"},{"line":162,"name":"$value","containerName":"ontology_engine","kind":13},{"line":164,"name":"$value","containerName":"ontology_engine","kind":13},{"line":164,"kind":12,"containerName":"ontology_engine","name":"isa"},{"name":"$self","containerName":"ontology_engine","kind":13,"line":165},{"line":165,"kind":13,"containerName":"ontology_engine","name":"$value"},{"line":169,"containerName":"ontology_engine","localvar":"my","kind":13,"name":"$ont","definition":"my"},{"name":"$self","containerName":"ontology_engine","kind":13,"line":169},{"name":"ontology","kind":12,"containerName":"ontology_engine","line":169},{"line":170,"name":"$ont","kind":13,"containerName":"ontology_engine"},{"line":170,"kind":13,"containerName":"ontology_engine","name":"$ont"},{"line":170,"containerName":"ontology_engine","kind":12,"name":"can"},{"kind":13,"containerName":"ontology_engine","name":"$ont","line":170},{"line":170,"name":"engine","containerName":"ontology_engine","kind":12},{"line":171,"name":"$ont","kind":13,"containerName":"ontology_engine"},{"containerName":"ontology_engine","kind":12,"name":"engine","line":171},{"line":171,"name":"$value","kind":13,"containerName":"ontology_engine"},{"name":"$self","containerName":"ontology_engine","kind":13,"line":174},{"name":"debug","containerName":"ontology_engine","kind":12,"line":174},{"name":"$self","kind":13,"containerName":"ontology_engine","line":174},{"name":"$value","containerName":"ontology_engine","kind":13,"line":176},{"line":177,"containerName":"ontology_engine","kind":13,"name":"$value"},{"containerName":"ontology_engine","kind":12,"name":"to_string","line":177},{"line":181,"containerName":"ontology_engine","kind":13,"name":"$self"}],"name":"ontology_engine","containerName":"main::","definition":"sub","detail":"($self,$value)","line":155,"range":{"end":{"line":182,"character":9999},"start":{"line":155,"character":0}},"kind":12,"signature":{"label":"ontology_engine($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$ont"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.","label":"ontology($self,$ont)"},"range":{"end":{"line":209,"character":9999},"start":{"line":199,"character":0}},"kind":12,"line":199,"detail":"($self,$ont)","definition":"sub","name":"ontology","containerName":"main::","children":[{"line":200,"name":"$self","containerName":"ontology","localvar":"my","kind":13,"definition":"my"},{"line":200,"kind":13,"containerName":"ontology","name":"$ont"},{"line":202,"containerName":"ontology","kind":13,"name":"$ont"},{"line":203,"name":"$self","containerName":"ontology","kind":13},{"line":203,"name":"throw","kind":12,"containerName":"ontology"},{"line":203,"kind":13,"containerName":"ontology","name":"$ont"},{"line":205,"kind":13,"containerName":"ontology","name":"$ont"},{"name":"isa","containerName":"ontology","kind":12,"line":205},{"line":206,"containerName":"ontology","kind":13,"name":"$self"},{"containerName":"ontology","kind":13,"name":"$ont","line":206},{"name":"$self","containerName":"ontology","kind":13,"line":208}]},{"line":224,"kind":12,"range":{"end":{"line":229,"character":9999},"start":{"line":224,"character":0}},"definition":"sub","children":[{"definition":"my","line":225,"localvar":"my","containerName":"term_factory","kind":13,"name":"$self"},{"name":"$self","containerName":"term_factory","kind":13,"line":227},{"line":228,"name":"$self","kind":13,"containerName":"term_factory"}],"containerName":"main::","name":"term_factory"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"_cite_skip","children":[{"line":244,"name":"$self","containerName":"_cite_skip","localvar":"my","kind":13,"definition":"my"},{"line":244,"kind":13,"containerName":"_cite_skip","name":"$value"},{"kind":13,"containerName":"_cite_skip","name":"$value","line":246},{"name":"$self","containerName":"_cite_skip","kind":13,"line":247},{"line":247,"name":"$value","kind":13,"containerName":"_cite_skip"},{"kind":13,"containerName":"_cite_skip","name":"$self","line":250}],"signature":{"label":"_cite_skip($self,$value)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"line":251,"character":9999},"start":{"character":0,"line":243}},"line":243},{"containerName":"main::","name":"_hash","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_hash","kind":13,"line":266},{"kind":13,"containerName":"_hash","name":"$value","line":266},{"name":"$value","kind":13,"containerName":"_hash","line":268},{"kind":13,"containerName":"_hash","name":"$self","line":269},{"kind":13,"containerName":"_hash","name":"$value","line":269},{"line":272,"name":"$self","containerName":"_hash","kind":13}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":265},"end":{"character":9999,"line":273}},"kind":12,"line":265,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)","label":"_hash($self,$value)"}},{"range":{"start":{"line":287,"character":0},"end":{"character":9999,"line":294}},"kind":12,"line":287,"signature":{"label":"_stack($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)"},"name":"_stack","containerName":"main::","children":[{"definition":"my","line":288,"name":"$self","containerName":"_stack","localvar":"my","kind":13},{"line":288,"name":"$value","kind":13,"containerName":"_stack"},{"line":290,"kind":13,"containerName":"_stack","name":"$value"},{"kind":13,"containerName":"_stack","name":"$self","line":291},{"line":291,"name":"$value","kind":13,"containerName":"_stack"},{"line":293,"containerName":"_stack","kind":13,"name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"name":"_top","containerName":"main::","children":[{"line":309,"containerName":"_top","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$_stack","containerName":"_top","kind":13,"line":309},{"line":310,"localvar":"my","containerName":"_top","kind":13,"name":"@stack","definition":"my"},{"kind":13,"containerName":"_top","name":"$_stack","line":310}],"detail":"($self,$_stack)","definition":"sub","range":{"start":{"character":0,"line":308},"end":{"character":9999,"line":310}},"kind":12,"line":308,"signature":{"label":"_top($self,$_stack)","parameters":[{"label":"$self"},{"label":"$_stack"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"}},{"kind":13,"containerName":null,"name":"@stack","line":312},{"name":"@stack","containerName":null,"kind":13,"line":312},{"kind":13,"containerName":null,"name":"@stack","line":312},{"containerName":"main::","name":"_term","children":[{"definition":"my","line":328,"name":"$self","localvar":"my","containerName":"_term","kind":13},{"kind":13,"containerName":"_term","name":"$value","line":328},{"line":330,"name":"$value","containerName":"_term","kind":13},{"line":331,"containerName":"_term","kind":13,"name":"$self"},{"containerName":"_term","kind":13,"name":"$value","line":331},{"line":334,"name":"$self","kind":13,"containerName":"_term"}],"detail":"($self,$value)","definition":"sub","range":{"start":{"line":327,"character":0},"end":{"line":335,"character":9999}},"kind":12,"line":327,"signature":{"label":"_term($self,$value)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]}},{"line":349,"range":{"end":{"character":9999,"line":353},"start":{"line":349,"character":0}},"kind":12,"signature":{"label":"_clear_term($self)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"}]},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_clear_term","line":350,"definition":"my"},{"name":"$self","kind":13,"containerName":"_clear_term","line":352}],"containerName":"main::","name":"_clear_term","definition":"sub","detail":"($self)"},{"signature":{"label":"_names($self,$value)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"line":367,"range":{"end":{"character":9999,"line":375},"start":{"character":0,"line":367}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_names","kind":13,"line":368},{"containerName":"_names","kind":13,"name":"$value","line":368},{"line":370,"name":"$value","containerName":"_names","kind":13},{"line":371,"name":"$self","containerName":"_names","kind":13},{"line":371,"name":"$value","kind":13,"containerName":"_names"},{"line":374,"containerName":"_names","kind":13,"name":"$self"}],"name":"_names","containerName":"main::"},{"name":"_create_relationship","containerName":"main::","children":[{"localvar":"my","containerName":"_create_relationship","kind":13,"name":"$self","line":390,"definition":"my"},{"line":390,"name":"$ref_id","containerName":"_create_relationship","kind":13},{"name":"$rel_type_term","containerName":"_create_relationship","kind":13,"line":390},{"definition":"my","localvar":"my","kind":13,"containerName":"_create_relationship","name":"$ont","line":391},{"kind":13,"containerName":"_create_relationship","name":"$self","line":391},{"name":"ontology","containerName":"_create_relationship","kind":12,"line":391},{"definition":"my","name":"$fact","localvar":"my","kind":13,"containerName":"_create_relationship","line":392},{"name":"$self","containerName":"_create_relationship","kind":13,"line":392},{"line":392,"name":"term_factory","kind":12,"containerName":"_create_relationship"},{"definition":"my","line":393,"localvar":"my","kind":13,"containerName":"_create_relationship","name":"$term_temp"},{"name":"$ont","kind":13,"containerName":"_create_relationship","line":393},{"line":393,"kind":12,"containerName":"_create_relationship","name":"engine"},{"line":393,"name":"get_term_by_identifier","containerName":"_create_relationship","kind":12},{"containerName":"_create_relationship","kind":13,"name":"$ref_id","line":393},{"line":395,"name":"$rel","kind":13,"localvar":"my","containerName":"_create_relationship","definition":"my"},{"line":395,"kind":12,"containerName":"_create_relationship","name":"new"},{"containerName":"_create_relationship","kind":13,"name":"$rel_type_term","line":395},{"name":"$term_temp","kind":13,"containerName":"_create_relationship","line":397},{"line":398,"name":"$term_temp","containerName":"_create_relationship","kind":13},{"name":"$ont","containerName":"_create_relationship","kind":13,"line":398},{"name":"engine","containerName":"_create_relationship","kind":12,"line":398},{"line":398,"name":"add_term","kind":12,"containerName":"_create_relationship"},{"line":398,"kind":13,"containerName":"_create_relationship","name":"$fact"},{"containerName":"_create_relationship","kind":12,"name":"create_object","line":398},{"line":398,"containerName":"_create_relationship","kind":13,"name":"$ref_id"},{"line":398,"kind":13,"containerName":"_create_relationship","name":"$ref_id"},{"line":398,"containerName":"_create_relationship","kind":13,"name":"$ont"},{"kind":13,"containerName":"_create_relationship","name":"$ont","line":399},{"name":"engine","containerName":"_create_relationship","kind":12,"line":399},{"line":399,"containerName":"_create_relationship","kind":12,"name":"mark_uninstantiated"},{"containerName":"_create_relationship","kind":13,"name":"$term_temp","line":399},{"definition":"my","name":"$rel_type_name","containerName":"_create_relationship","localvar":"my","kind":13,"line":401},{"line":401,"name":"$self","kind":13,"containerName":"_create_relationship"},{"name":"_top","containerName":"_create_relationship","kind":12,"line":401},{"kind":13,"containerName":"_create_relationship","name":"$self","line":401},{"line":401,"name":"_names","containerName":"_create_relationship","kind":12},{"line":403,"name":"$rel_type_name","containerName":"_create_relationship","kind":13},{"name":"$rel_type_name","kind":13,"containerName":"_create_relationship","line":403},{"line":404,"containerName":"_create_relationship","kind":13,"name":"$rel"},{"name":"object_term","kind":12,"containerName":"_create_relationship","line":404},{"line":404,"containerName":"_create_relationship","kind":13,"name":"$term_temp"},{"name":"$rel","kind":13,"containerName":"_create_relationship","line":405},{"line":405,"name":"subject_term","kind":12,"containerName":"_create_relationship"},{"line":405,"name":"$self","containerName":"_create_relationship","kind":13},{"name":"_term","kind":12,"containerName":"_create_relationship","line":405},{"containerName":"_create_relationship","kind":13,"name":"$rel","line":407},{"name":"object_term","kind":12,"containerName":"_create_relationship","line":407},{"line":407,"name":"$self","kind":13,"containerName":"_create_relationship"},{"line":407,"name":"_term","kind":12,"containerName":"_create_relationship"},{"name":"$rel","containerName":"_create_relationship","kind":13,"line":408},{"line":408,"name":"subject_term","kind":12,"containerName":"_create_relationship"},{"line":408,"containerName":"_create_relationship","kind":13,"name":"$term_temp"},{"line":410,"name":"$rel","kind":13,"containerName":"_create_relationship"},{"line":410,"kind":12,"containerName":"_create_relationship","name":"ontology"},{"line":410,"kind":13,"containerName":"_create_relationship","name":"$ont"},{"containerName":"_create_relationship","kind":13,"name":"$ont","line":411},{"containerName":"_create_relationship","kind":12,"name":"add_relationship","line":411},{"line":411,"containerName":"_create_relationship","kind":13,"name":"$rel"}],"detail":"($self,$ref_id,$rel_type_term)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":389},"end":{"character":9999,"line":412}},"line":389,"signature":{"label":"_create_relationship($self,$ref_id,$rel_type_term)","parameters":[{"label":"$self"},{"label":"$ref_id"},{"label":"$rel_type_term"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :"}},{"name":"Bio","containerName":"Ontology::Relationship","kind":12,"line":395},{"detail":"($self,$element)","definition":"sub","containerName":"main::","name":"start_element","children":[{"definition":"my","name":"$self","containerName":"start_element","localvar":"my","kind":13,"line":430},{"line":430,"name":"$element","containerName":"start_element","kind":13},{"definition":"my","line":431,"containerName":"start_element","localvar":"my","kind":13,"name":"$ont"},{"line":431,"kind":13,"containerName":"start_element","name":"$self"},{"line":431,"containerName":"start_element","kind":12,"name":"ontology"},{"definition":"my","line":432,"name":"$fact","kind":13,"localvar":"my","containerName":"start_element"},{"name":"$self","containerName":"start_element","kind":13,"line":432},{"containerName":"start_element","kind":12,"name":"term_factory","line":432},{"name":"$element","kind":13,"containerName":"start_element","line":434},{"kind":13,"containerName":"start_element","name":"$ont","line":435},{"line":435,"containerName":"start_element","kind":12,"name":"add_term"},{"kind":13,"containerName":"start_element","name":"$fact","line":435},{"containerName":"start_element","kind":12,"name":"create_object","line":435},{"name":"$ont","kind":13,"containerName":"start_element","line":437},{"name":"add_term","containerName":"start_element","kind":12,"line":437},{"containerName":"start_element","kind":13,"name":"$fact","line":437},{"line":437,"containerName":"start_element","kind":12,"name":"create_object"},{"kind":13,"containerName":"start_element","name":"$ont","line":439},{"line":439,"kind":12,"containerName":"start_element","name":"add_term"},{"line":439,"containerName":"start_element","kind":13,"name":"$fact"},{"line":439,"name":"create_object","containerName":"start_element","kind":12},{"name":"$ont","kind":13,"containerName":"start_element","line":441},{"line":441,"containerName":"start_element","kind":12,"name":"add_term"},{"name":"$fact","kind":13,"containerName":"start_element","line":441},{"name":"create_object","containerName":"start_element","kind":12,"line":441},{"line":443,"containerName":"start_element","kind":13,"name":"$ont"},{"name":"add_term","containerName":"start_element","kind":12,"line":443},{"name":"$fact","kind":13,"containerName":"start_element","line":443},{"containerName":"start_element","kind":12,"name":"create_object","line":443},{"kind":13,"containerName":"start_element","name":"$ont","line":445},{"line":445,"name":"add_term","containerName":"start_element","kind":12},{"line":445,"name":"$fact","kind":13,"containerName":"start_element"},{"line":445,"kind":12,"containerName":"start_element","name":"create_object"},{"name":"$element","containerName":"start_element","kind":13,"line":447},{"definition":"my","line":448,"name":"%record_args","kind":13,"localvar":"my","containerName":"start_element"},{"line":448,"name":"$element","containerName":"start_element","kind":13},{"definition":"my","line":449,"containerName":"start_element","localvar":"my","kind":13,"name":"$id"},{"kind":13,"containerName":"start_element","name":"$record_args","line":449},{"line":450,"name":"$term_temp","containerName":"start_element","localvar":"my","kind":13,"definition":"my"},{"name":"$ont","kind":13,"containerName":"start_element","line":450},{"containerName":"start_element","kind":12,"name":"engine","line":450},{"name":"get_term_by_identifier","kind":12,"containerName":"start_element","line":450},{"name":"$id","kind":13,"containerName":"start_element","line":450},{"line":452,"kind":13,"containerName":"start_element","name":"$self"},{"line":452,"kind":12,"containerName":"start_element","name":"_term"},{"containerName":"start_element","kind":13,"name":"$term_temp","line":453},{"name":"$ont","kind":13,"containerName":"start_element","line":454},{"line":454,"name":"add_term","kind":12,"containerName":"start_element"},{"containerName":"start_element","kind":13,"name":"$fact","line":454},{"name":"create_object","kind":12,"containerName":"start_element","line":454},{"line":454,"name":"$id","containerName":"start_element","kind":13},{"line":454,"kind":13,"containerName":"start_element","name":"$id"},{"line":456,"name":"$term_temp","kind":13,"containerName":"start_element"},{"name":"$self","kind":13,"containerName":"start_element","line":458},{"line":458,"name":"_term","kind":12,"containerName":"start_element"},{"containerName":"start_element","kind":12,"name":"ontology","line":458},{"line":458,"containerName":"start_element","kind":13,"name":"$ont"},{"name":"$self","kind":13,"containerName":"start_element","line":459},{"line":459,"name":"_term","kind":12,"containerName":"start_element"},{"line":459,"name":"short_name","kind":12,"containerName":"start_element"},{"line":459,"name":"$record_args","containerName":"start_element","kind":13},{"name":"$self","containerName":"start_element","kind":13,"line":460},{"line":460,"kind":12,"containerName":"start_element","name":"_term"},{"kind":12,"containerName":"start_element","name":"protein_count","line":460},{"name":"$record_args","containerName":"start_element","kind":13,"line":460},{"kind":13,"containerName":"start_element","name":"$self","line":461},{"line":461,"name":"_increment_record_count","kind":12,"containerName":"start_element"},{"containerName":"start_element","kind":13,"name":"$self","line":462},{"containerName":"start_element","kind":12,"name":"_stack","line":462},{"name":"$self","kind":13,"containerName":"start_element","line":463},{"kind":12,"containerName":"start_element","name":"_names","line":463},{"definition":"my","containerName":"start_element","localvar":"my","kind":13,"name":"$rel","line":468},{"line":468,"kind":12,"containerName":"start_element","name":"new"},{"name":"$is_a_rel","containerName":"start_element","kind":13,"line":468},{"containerName":"start_element","kind":13,"name":"$rel","line":469},{"name":"object_term","containerName":"start_element","kind":12,"line":469},{"name":"$ont","kind":13,"containerName":"start_element","line":469},{"name":"engine","kind":12,"containerName":"start_element","line":469},{"line":469,"containerName":"start_element","kind":12,"name":"get_term_by_identifier"},{"name":"$record_args","containerName":"start_element","kind":13,"line":469},{"line":470,"kind":13,"containerName":"start_element","name":"$rel"},{"containerName":"start_element","kind":12,"name":"subject_term","line":470},{"line":470,"name":"$self","kind":13,"containerName":"start_element"},{"line":470,"containerName":"start_element","kind":12,"name":"_term"},{"containerName":"start_element","kind":13,"name":"$rel","line":471},{"containerName":"start_element","kind":12,"name":"ontology","line":471},{"name":"$ont","kind":13,"containerName":"start_element","line":471},{"line":472,"containerName":"start_element","kind":13,"name":"$ont"},{"line":472,"name":"add_relationship","kind":12,"containerName":"start_element"},{"line":472,"containerName":"start_element","kind":13,"name":"$rel"}],"signature":{"label":"start_element($self,$element)","parameters":[{"label":"$self"},{"label":"$element"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :"},"range":{"start":{"line":429,"character":0},"end":{"character":9999,"line":473}},"kind":12,"line":429},{"kind":12,"name":"Name","line":434},{"name":"Name","kind":12,"line":447},{"name":"Attributes","kind":12,"line":448},{"kind":12,"name":"interpro","line":462},{"containerName":"Ontology::Relationship","kind":12,"name":"Bio","line":468},{"line":474,"name":"$self","kind":13,"containerName":null},{"line":474,"name":"_stack","kind":12,"containerName":"main::"},{"line":475,"name":"%hash","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":477,"kind":13,"containerName":null,"name":"%element"},{"line":477,"name":"Attributes","kind":12},{"definition":"my","line":478,"name":"$key","localvar":"my","containerName":null,"kind":13},{"name":"%element","kind":13,"containerName":null,"line":478},{"line":478,"name":"Attributes","kind":12},{"line":479,"kind":13,"containerName":null,"name":"%hash"},{"name":"$key","containerName":null,"kind":13,"line":479},{"kind":13,"containerName":null,"name":"%element","line":479},{"name":"Attributes","kind":12,"line":479},{"line":479,"kind":13,"containerName":null,"name":"$key"},{"containerName":null,"kind":13,"name":"$self","line":482},{"name":"_stack","kind":12,"containerName":"main::","line":482},{"kind":13,"containerName":null,"name":"%hash","line":482},{"line":483,"name":"%element","kind":13,"containerName":null},{"line":483,"name":"Name","kind":12},{"line":484,"localvar":"my","kind":13,"containerName":null,"name":"$ref_id","definition":"my"},{"kind":13,"containerName":null,"name":"%element","line":484},{"line":484,"kind":12,"name":"Attributes"},{"definition":"my","line":485,"localvar":"my","kind":13,"containerName":null,"name":"$parent"},{"line":485,"name":"$self","kind":13,"containerName":null},{"line":485,"name":"_top","containerName":"main::","kind":12},{"line":485,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_names","line":485},{"line":487,"kind":13,"containerName":null,"name":"$parent"},{"name":"%parent","kind":13,"containerName":null,"line":487},{"name":"$self","containerName":null,"kind":13,"line":488},{"line":488,"name":"_create_relationship","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$ref_id","line":488},{"kind":13,"containerName":null,"name":"$is_a_rel","line":488},{"kind":13,"containerName":null,"name":"%parent","line":490},{"line":491,"containerName":null,"kind":13,"name":"$self"},{"name":"_create_relationship","containerName":"main::","kind":12,"line":491},{"line":491,"name":"$ref_id","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$contains_rel","line":491},{"line":493,"name":"%parent","containerName":null,"kind":13},{"line":494,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_create_relationship","line":494},{"name":"$ref_id","containerName":null,"kind":13,"line":494},{"line":494,"name":"$found_in_rel","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%element","line":497},{"kind":12,"name":"Name","line":497},{"line":498,"kind":13,"containerName":null,"name":"$self"},{"line":498,"containerName":"main::","kind":12,"name":"_cite_skip"},{"line":500,"name":"$self","kind":13,"containerName":null},{"line":500,"containerName":"main::","kind":12,"name":"_names"},{"kind":13,"containerName":null,"name":"%element","line":500},{"name":"Name","kind":12,"line":500},{"children":[{"line":518,"name":"$self","containerName":"_char_storage","localvar":"my","kind":13,"definition":"my"},{"line":518,"name":"$value","kind":13,"containerName":"_char_storage"},{"line":520,"name":"$value","kind":13,"containerName":"_char_storage"},{"line":521,"containerName":"_char_storage","kind":13,"name":"$self"},{"containerName":"_char_storage","kind":13,"name":"$value","line":521},{"name":"$self","containerName":"_char_storage","kind":13,"line":524}],"containerName":"main::","name":"_char_storage","definition":"sub","detail":"($self,$value)","line":517,"range":{"end":{"character":9999,"line":525},"start":{"character":0,"line":517}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)","label":"_char_storage($self,$value)"}},{"line":539,"kind":12,"range":{"start":{"line":539,"character":0},"end":{"character":9999,"line":547}},"signature":{"label":"characters($self,$characters)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _char_storage{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_char_storage'} = $value;\n  }\n\n  return $self->{'_char_storage'};\n}\n\n=head2 characters\n\n Title   : characters\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing xml characters events. Used internally only.\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$characters"}]},"children":[{"line":540,"localvar":"my","kind":13,"containerName":"characters","name":"$self","definition":"my"},{"kind":13,"containerName":"characters","name":"$characters","line":540},{"definition":"my","localvar":"my","containerName":"characters","kind":13,"name":"$text","line":541},{"name":"$characters","kind":13,"containerName":"characters","line":541},{"line":543,"kind":13,"containerName":"characters","name":"$text"},{"line":544,"name":"$text","containerName":"characters","kind":13},{"kind":13,"containerName":"characters","name":"$self","line":545},{"kind":13,"containerName":"characters","name":"$text","line":545}],"containerName":"main::","name":"characters","definition":"sub","detail":"($self,$characters)"},{"line":541,"name":"Data","kind":12},{"line":545,"name":"_char_storage","kind":12},{"signature":{"label":"end_element($self,$element)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _char_storage{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_char_storage'} = $value;\n  }\n\n  return $self->{'_char_storage'};\n}\n\n=head2 characters\n\n Title   : characters\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing xml characters events. Used internally only.\n Example :\n Returns : \n Args    :\n\n\n\nsub characters {\n  my ($self, $characters) = @_;\n  my $text = $characters->{Data};\n\n  chomp $text;\n  $text =~ s/^(\\s+)//;\n  $self->{_char_storage} .= $text;\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing end of xml element events. Used internally only.\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$element"}]},"range":{"end":{"line":578,"character":9999},"start":{"character":0,"line":561}},"kind":12,"line":561,"detail":"($self,$element)","definition":"sub","name":"end_element","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"end_element","line":562,"definition":"my"},{"kind":13,"containerName":"end_element","name":"$element","line":562},{"line":564,"name":"$element","kind":13,"containerName":"end_element"},{"line":565,"name":"$self","containerName":"end_element","kind":13},{"kind":12,"containerName":"end_element","name":"debug","line":565},{"name":"$element","containerName":"end_element","kind":13,"line":567},{"kind":13,"containerName":"end_element","name":"$self","line":568},{"line":568,"name":"_clear_term","kind":12,"containerName":"end_element"},{"line":569,"kind":13,"containerName":"end_element","name":"$self"},{"containerName":"end_element","kind":12,"name":"_increment_processed_count","line":569},{"line":571,"name":"$element","kind":13,"containerName":"end_element"},{"name":"$self","kind":13,"containerName":"end_element","line":572},{"containerName":"end_element","kind":13,"name":"$self","line":573},{"kind":12,"containerName":"end_element","name":"_stack","line":573},{"definition":"my","name":"$current_hash","localvar":"my","kind":13,"containerName":"end_element","line":574},{"line":574,"name":"$self","containerName":"end_element","kind":13},{"name":"_stack","containerName":"end_element","kind":12,"line":574},{"name":"$parent_hash","kind":13,"localvar":"my","containerName":"end_element","line":575,"definition":"my"},{"line":575,"name":"$self","containerName":"end_element","kind":13},{"name":"_top","containerName":"end_element","kind":12,"line":575},{"line":575,"kind":13,"containerName":"end_element","name":"$self"},{"line":575,"containerName":"end_element","kind":12,"name":"_stack"},{"name":"$current_hash_key","kind":13,"localvar":"my","containerName":"end_element","line":576,"definition":"my"},{"line":576,"name":"$self","containerName":"end_element","kind":13},{"line":576,"kind":12,"containerName":"end_element","name":"_names"},{"name":"$current_hash","kind":13,"containerName":"end_element","line":578}]},{"line":564,"name":"Name","kind":12},{"line":567,"name":"Name","kind":12},{"name":"Name","kind":12,"line":571},{"line":572,"kind":12,"name":"_char_storage"},{"line":578,"kind":13,"containerName":null,"name":"$self"},{"name":"_char_storage","kind":12,"containerName":"main::","line":578},{"line":579,"kind":13,"containerName":null,"name":"%current_hash"},{"name":"comment","kind":12,"line":579},{"line":579,"kind":13,"containerName":null,"name":"$self"},{"line":579,"name":"_char_storage","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"%parent_hash","line":580},{"containerName":null,"kind":13,"name":"$current_hash_key","line":580},{"line":581,"name":"$current_hash","containerName":null,"kind":13},{"line":582,"containerName":null,"kind":13,"name":"$self"},{"line":582,"name":"_char_storage","containerName":"main::","kind":12},{"name":"%parent_hash","containerName":null,"kind":13,"line":583},{"containerName":null,"kind":13,"name":"%current_hash_key","line":583},{"line":583,"containerName":null,"kind":13,"name":"$self"},{"line":583,"name":"_char_storage","kind":12,"containerName":"main::"},{"line":585,"kind":13,"containerName":null,"name":"%current_hash"},{"line":586,"kind":13,"containerName":null,"name":"%parent_hash"},{"line":586,"name":"$current_hash_key","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$current_hash","line":586},{"line":588,"containerName":null,"kind":13,"name":"%element"},{"line":588,"name":"Name","kind":12},{"definition":"my","name":"@refs","localvar":"my","kind":13,"containerName":null,"line":589},{"line":591,"containerName":null,"localvar":"my","kind":13,"name":"$pub_record","definition":"my"},{"containerName":null,"kind":13,"name":"%current_hash","line":591},{"line":591,"name":"publication","kind":12},{"line":592,"localvar":"my","containerName":null,"kind":13,"name":"$ref","definition":"my"},{"line":592,"kind":12,"containerName":"Annotation::Reference","name":"Bio"},{"name":"new","kind":12,"containerName":"main::","line":592},{"definition":"my","name":"$loc","kind":13,"localvar":"my","containerName":null,"line":593},{"containerName":null,"kind":13,"name":"%pub_record","line":593},{"line":593,"name":"location","kind":12},{"line":595,"containerName":null,"kind":13,"name":"$ref"},{"line":595,"name":"location","containerName":"main::","kind":12},{"name":"%pub_record","containerName":null,"kind":13,"line":595},{"name":"journal","kind":12,"line":595},{"line":595,"kind":12,"name":"accumulated_text_12345"},{"name":"%loc","containerName":null,"kind":13,"line":595},{"name":"firstpage","kind":12,"line":595},{"name":"%loc","kind":13,"containerName":null,"line":595},{"name":"lastpage","kind":12,"line":595},{"name":"%loc","kind":13,"containerName":null,"line":595},{"name":"volume","kind":12,"line":595},{"line":595,"name":"%pub_record","kind":13,"containerName":null},{"line":595,"kind":12,"name":"year"},{"line":595,"name":"accumulated_text_12345","kind":12},{"name":"$ref","containerName":null,"kind":13,"line":596},{"kind":12,"containerName":"main::","name":"title","line":596},{"containerName":null,"kind":13,"name":"%pub_record","line":596},{"line":596,"kind":12,"name":"title"},{"name":"accumulated_text_12345","kind":12,"line":596},{"name":"$ttt","kind":13,"localvar":"my","containerName":null,"line":597,"definition":"my"},{"line":597,"name":"%pub_record","kind":13,"containerName":null},{"line":597,"name":"author_list","kind":12},{"containerName":null,"kind":13,"name":"$ref","line":599},{"line":599,"name":"authors","kind":12,"containerName":"main::"},{"name":"%ttt","kind":13,"containerName":null,"line":599},{"kind":12,"name":"accumulated_text_12345","line":599},{"containerName":null,"kind":13,"name":"$ref","line":600},{"name":"medline","kind":12,"containerName":"main::","line":600},{"line":600,"kind":13,"containerName":null,"name":"%ttt"},{"kind":12,"name":"dbkey","line":600},{"name":"%ttt","containerName":null,"kind":13,"line":601},{"line":601,"kind":12,"name":"db"},{"containerName":null,"kind":13,"name":"%ttt","line":601},{"line":601,"name":"db","kind":12},{"name":"@refs","containerName":null,"kind":13,"line":602},{"kind":13,"containerName":null,"name":"$ref","line":602},{"name":"$self","kind":13,"containerName":null,"line":604},{"containerName":"main::","kind":12,"name":"_term","line":604},{"line":604,"name":"add_reference","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"@refs","line":604},{"line":606,"name":"%element","containerName":null,"kind":13},{"kind":12,"name":"Name","line":606},{"line":607,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_term","line":607},{"line":607,"name":"name","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$self","line":607},{"kind":12,"containerName":"main::","name":"_char_storage","line":607},{"line":609,"name":"%element","kind":13,"containerName":null},{"line":609,"name":"Name","kind":12},{"name":"$self","kind":13,"containerName":null,"line":610},{"name":"_term","kind":12,"containerName":"main::","line":610},{"line":610,"name":"definition","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$self","line":610},{"name":"_char_storage","containerName":"main::","kind":12,"line":610},{"containerName":null,"kind":13,"name":"$self","line":611},{"name":"_cite_skip","containerName":"main::","kind":12,"line":611},{"line":613,"name":"%element","containerName":null,"kind":13},{"line":613,"kind":12,"name":"Name"},{"definition":"my","name":"@refs","localvar":"my","containerName":null,"kind":13,"line":614},{"line":616,"localvar":"my","containerName":null,"kind":13,"name":"$db_xref","definition":"my"},{"line":616,"name":"%current_hash","kind":13,"containerName":null},{"kind":12,"name":"db_xref","line":616},{"line":617,"kind":13,"containerName":null,"name":"@refs"},{"line":617,"name":"Bio","kind":12,"containerName":"Annotation::DBLink"},{"line":617,"name":"new","containerName":"main::","kind":12},{"line":617,"name":"%db_xref","containerName":null,"kind":13},{"name":"db","kind":12,"line":617},{"containerName":null,"kind":13,"name":"%db_xref","line":618},{"kind":12,"name":"dbkey","line":618},{"name":"$self","kind":13,"containerName":null,"line":621},{"containerName":"main::","kind":12,"name":"_term","line":621},{"line":621,"name":"add_member","containerName":"main::","kind":12},{"line":621,"name":"@refs","kind":13,"containerName":null},{"line":623,"containerName":null,"kind":13,"name":"%element"},{"line":623,"kind":12,"name":"Name"},{"line":624,"name":"@refs","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"$sec_ac","kind":13,"localvar":"my","containerName":null,"line":626,"definition":"my"},{"line":626,"kind":13,"containerName":null,"name":"%current_hash"},{"line":626,"kind":12,"name":"sec_ac"},{"line":627,"kind":13,"containerName":null,"name":"@refs"},{"line":627,"containerName":null,"kind":13,"name":"%sec_ac"},{"kind":12,"name":"sec_ac","line":627},{"containerName":null,"kind":13,"name":"$self","line":629},{"name":"_term","containerName":"main::","kind":12,"line":629},{"name":"add_secondary_id","containerName":"main::","kind":12,"line":629},{"containerName":null,"kind":13,"name":"@refs","line":629},{"name":"$self","kind":13,"containerName":null,"line":630},{"line":630,"name":"secondary_accessions_map","kind":12,"containerName":"main::"},{"line":630,"kind":13,"containerName":null,"name":"$self"},{"name":"_term","containerName":"main::","kind":12,"line":630},{"name":"identifier","kind":12,"containerName":"main::","line":630},{"line":630,"name":"@refs","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%element","line":632},{"name":"Name","kind":12,"line":632},{"definition":"my","line":633,"kind":13,"localvar":"my","containerName":null,"name":"@refs"},{"name":"$example","containerName":null,"localvar":"my","kind":13,"line":635,"definition":"my"},{"name":"%current_hash","kind":13,"containerName":null,"line":635},{"line":635,"kind":12,"name":"example"},{"line":636,"containerName":null,"kind":13,"name":"@refs"},{"line":636,"name":"Bio","kind":12,"containerName":"Annotation::DBLink"},{"name":"new","kind":12,"containerName":"main::","line":636},{"name":"%example","containerName":null,"kind":13,"line":636},{"kind":12,"name":"db_xref","line":636},{"line":636,"name":"db","kind":12},{"containerName":null,"kind":13,"name":"%example","line":637},{"kind":12,"name":"db_xref","line":637},{"name":"dbkey","kind":12,"line":637},{"name":"%example","containerName":null,"kind":13,"line":638},{"kind":12,"name":"comment","line":638},{"line":641,"kind":13,"containerName":null,"name":"$self"},{"line":641,"name":"_term","kind":12,"containerName":"main::"},{"name":"add_example","containerName":"main::","kind":12,"line":641},{"line":641,"name":"@refs","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%element","line":643},{"kind":12,"name":"Name","line":643},{"name":"@refs","containerName":null,"localvar":"my","kind":13,"line":644,"definition":"my"},{"line":646,"localvar":"my","kind":13,"containerName":null,"name":"$db_xref","definition":"my"},{"name":"%current_hash","kind":13,"containerName":null,"line":646},{"line":646,"kind":12,"name":"db_xref"},{"name":"@refs","kind":13,"containerName":null,"line":647},{"kind":12,"containerName":"Annotation::DBLink","name":"Bio","line":647},{"line":647,"kind":12,"containerName":"main::","name":"new"},{"kind":13,"containerName":null,"name":"%db_xref","line":647},{"name":"db","kind":12,"line":647},{"line":648,"name":"%db_xref","kind":13,"containerName":null},{"name":"dbkey","kind":12,"line":648},{"line":651,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"_term","line":651},{"name":"add_external_document","containerName":"main::","kind":12,"line":651},{"line":651,"containerName":null,"kind":13,"name":"@refs"},{"containerName":null,"kind":13,"name":"%element","line":653},{"line":653,"name":"Name","kind":12},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@refs","line":654},{"localvar":"my","containerName":null,"kind":13,"name":"$classification","line":656,"definition":"my"},{"name":"%current_hash","kind":13,"containerName":null,"line":656},{"line":656,"name":"classification","kind":12},{"line":657,"name":"@refs","kind":13,"containerName":null},{"kind":12,"containerName":"Annotation::DBLink","name":"Bio","line":657},{"line":657,"name":"new","containerName":"main::","kind":12},{"line":657,"containerName":null,"kind":13,"name":"%classification"},{"line":657,"name":"class_type","kind":12},{"line":658,"containerName":null,"kind":13,"name":"%classification"},{"kind":12,"name":"id","line":658},{"name":"$self","kind":13,"containerName":null,"line":661},{"name":"_term","containerName":"main::","kind":12,"line":661},{"line":661,"containerName":"main::","kind":12,"name":"class_list"},{"kind":13,"containerName":null,"name":"@refs","line":661},{"line":663,"containerName":null,"kind":13,"name":"%element"},{"line":663,"name":"Name","kind":12},{"localvar":"my","containerName":null,"kind":13,"name":"@refs","line":664,"definition":"my"},{"definition":"my","line":666,"name":"$del_ref","kind":13,"localvar":"my","containerName":null},{"kind":13,"containerName":null,"name":"%current_hash","line":666},{"line":666,"kind":12,"name":"del_ref"},{"definition":"my","name":"$term","localvar":"my","kind":13,"containerName":null,"line":667},{"line":667,"containerName":null,"kind":13,"name":"$self"},{"line":667,"name":"ontology_engine","containerName":"main::","kind":12},{"name":"get_term_by_identifier","containerName":"main::","kind":12,"line":667},{"containerName":null,"kind":13,"name":"%del_ref","line":667},{"name":"id","kind":12,"line":667},{"name":"$term","kind":13,"containerName":null,"line":669},{"line":669,"kind":12,"containerName":"main::","name":"is_obsolete"},{"line":669,"kind":13,"containerName":null,"name":"$term"},{"line":673,"containerName":null,"kind":13,"name":"$self"},{"line":673,"kind":12,"containerName":"main::","name":"_char_storage"},{"line":673,"containerName":null,"kind":13,"name":"$self"},{"name":"_cite_skip","kind":12,"containerName":"main::","line":673},{"definition":"sub","detail":"($self,$value)","children":[{"line":692,"containerName":"secondary_accessions_map","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"secondary_accessions_map","name":"$value","line":692},{"line":694,"containerName":"secondary_accessions_map","kind":13,"name":"$value"},{"line":695,"name":"$self","containerName":"secondary_accessions_map","kind":13},{"kind":13,"containerName":"secondary_accessions_map","name":"$value","line":695},{"name":"$self","kind":13,"containerName":"secondary_accessions_map","line":698}],"name":"secondary_accessions_map","containerName":"main::","signature":{"label":"secondary_accessions_map($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _char_storage{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_char_storage'} = $value;\n  }\n\n  return $self->{'_char_storage'};\n}\n\n=head2 characters\n\n Title   : characters\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing xml characters events. Used internally only.\n Example :\n Returns : \n Args    :\n\n\n\nsub characters {\n  my ($self, $characters) = @_;\n  my $text = $characters->{Data};\n\n  chomp $text;\n  $text =~ s/^(\\s+)//;\n  $self->{_char_storage} .= $text;\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing end of xml element events. Used internally only.\n Example :\n Returns : \n Args    :\n\n\n\nsub end_element {\n  my ($self, $element) = @_;\n\n  if ($element->{Name} eq 'interprodb') {\n    $self->debug(\"Interpro DB Parser Finished: $record_count read, $processed_count processed\\n\");\n  }\n  elsif ($element->{Name} eq 'interpro') {\n    $self->_clear_term;\n    $self->_increment_processed_count();\n  }\n  elsif ($element->{Name} ne 'cite') {\n    $self->{_char_storage} =~ s/<\\/?p>//g;\n    if ((defined $self->_stack)) {\n      my $current_hash = pop @{$self->_stack};\n      my $parent_hash = $self->_top($self->_stack);\n      my $current_hash_key = pop @{$self->_names};\n\n      if (keys %{$current_hash} > 0 && $self->_char_storage ne \"\") {\n\t$current_hash->{comment} = $self->_char_storage;\n\tpush @{ $parent_hash->{$current_hash_key} }, $current_hash\n      }\n      elsif ($self->_char_storage ne \"\"){\n\tpush @{ $parent_hash->{$current_hash_key} }, { 'accumulated_text_12345' => $self->_char_storage };\n      }\n      elsif (keys %{$current_hash} > 0) {\n\tpush @{ $parent_hash->{$current_hash_key} }, $current_hash;\n      }\n      if ($element->{Name} eq 'pub_list') {\n\tmy @refs = ();\n\n\tforeach my $pub_record ( @{ $current_hash->{publication} } ) {\n\t  my $ref = Bio::Annotation::Reference->new;\n\t  my $loc = $pub_record->{location}->[0];\n\n\t  $ref->location( $pub_record->{journal}->[0]->{accumulated_text_12345}.\", \".$loc->{firstpage}.\"-\".$loc->{lastpage}.\", \".$loc->{volume}.\", \".$pub_record->{year}->[0]->{accumulated_text_12345});\n\t  $ref->title( $pub_record->{title}->[0]->{accumulated_text_12345} );\n\t  my $ttt = $pub_record->{author_list}->[0];\n\n\t  $ref->authors( $ttt->{accumulated_text_12345} );\n\t  $ref->medline( scalar($ttt->{dbkey}) )\n\t      if exists($ttt->{db}) && $ttt->{db} eq \"MEDLINE\";\n\t  push @refs, $ref;\n\t}\n \t$self->_term->add_reference(@refs);\n      }\n      elsif ($element->{Name} eq 'name') {\n \t$self->_term->name( $self->_char_storage );\n      }\n      elsif ($element->{Name} eq 'abstract') {\n\t$self->_term->definition( $self->_char_storage );\n\t$self->_cite_skip(0);\n      }\n      elsif ($element->{Name} eq 'member_list') {\n\tmy @refs = ();\n\n\tforeach my $db_xref ( @{ $current_hash->{db_xref} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $db_xref->{db},\n\t\t\t\t\t\t    -primary_id => $db_xref->{dbkey}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->add_member(@refs);\n      }\n      elsif ($element->{Name} eq 'sec_list') {\n\tmy @refs = ();\n\n\tforeach my $sec_ac ( @{ $current_hash->{sec_ac} } ) {\n\t  push @refs, $sec_ac->{sec_ac};\n\t}\n \t$self->_term->add_secondary_id(@refs);\n\t$self->secondary_accessions_map->{$self->_term->identifier} = \\@refs;\n      }\n      elsif ($element->{Name} eq 'example_list') {\n\tmy @refs = ();\n\n\tforeach my $example ( @{ $current_hash->{example} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $example->{db_xref}->[0]->{db},\n\t\t\t\t\t\t    -primary_id => $example->{db_xref}->[0]->{dbkey},\n\t\t\t\t\t\t    -comment => $example->{comment}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->add_example(@refs);\n      }\n      elsif ($element->{Name} eq 'external_doc_list') {\n\tmy @refs = ();\n\n\tforeach my $db_xref ( @{ $current_hash->{db_xref} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $db_xref->{db},\n\t\t\t\t\t\t    -primary_id => $db_xref->{dbkey}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->add_external_document(@refs);\n      }\n      elsif ($element->{Name} eq 'class_list') {\n\tmy @refs = ();\n\n\tforeach my $classification ( @{ $current_hash->{classification} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $classification->{class_type},\n\t\t\t\t\t\t    -primary_id => $classification->{id}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->class_list(\\@refs);\n      }\n      elsif ($element->{Name} eq 'deleted_entries') {\n\tmy @refs = ();\n\n\tforeach my $del_ref ( @{ $current_hash->{del_ref} } ) {\n\t  my $term = ($self->ontology_engine->get_term_by_identifier( $del_ref->{id} ))[0];\n\n\t  $term->is_obsolete(1) if defined $term;\n\t}\n      }\n    }\n    $self->_char_storage( '' ) if !$self->_cite_skip;\n  }\n}\n\n=head2 secondary_accessions_map\n\n Title   : secondary_accessions_map\n Usage   : $obj->secondary_accessions_map($newval)\n Function: \n Example : $map = $interpro_handler->secondary_accessions_map();\n Returns : Reference to a hash that maps InterPro identifier to an\n  array reference of secondary accessions following the InterPro\n xml schema.\n Args    : Empty hash reference"},"line":691,"range":{"end":{"character":9999,"line":699},"start":{"character":0,"line":691}},"kind":12},{"line":713,"range":{"start":{"line":713,"character":0},"end":{"line":715,"character":9999}},"kind":12,"definition":"sub","children":[{"line":714,"name":"$record_count","kind":13,"containerName":"_increment_record_count"}],"name":"_increment_record_count","containerName":"main::"},{"line":729,"range":{"end":{"line":732,"character":9999},"start":{"character":0,"line":729}},"kind":12,"children":[{"kind":13,"containerName":"_increment_processed_count","name":"$processed_count","line":730},{"name":"$processed_count","kind":13,"containerName":"_increment_processed_count","line":731},{"kind":13,"containerName":"_increment_processed_count","name":"$processed_count","line":731}],"name":"_increment_processed_count","containerName":"main::","definition":"sub"}],"version":5}