{"vars":[{"name":"base","containerName":"","kind":2,"line":118},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":142},{"line":142,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","line":144,"localvar":"my","containerName":"new","kind":13,"name":"$self"},{"line":144,"name":"$class","kind":13,"containerName":"new"},{"line":144,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"localvar":"my","containerName":"new","name":"$name","line":145,"definition":"my"},{"name":"$auth","containerName":"new","kind":13,"line":145},{"containerName":"new","kind":13,"name":"$def","line":145},{"line":145,"name":"$id","containerName":"new","kind":13},{"line":145,"containerName":"new","kind":13,"name":"$engine"},{"line":146,"kind":13,"containerName":"new","name":"$self"},{"line":146,"kind":12,"containerName":"new","name":"_rearrange"},{"containerName":"new","kind":13,"name":"@args","line":152},{"line":153,"name":"$name","kind":13,"containerName":"new"},{"line":153,"containerName":"new","kind":13,"name":"$self"},{"name":"name","containerName":"new","kind":12,"line":153},{"line":153,"name":"$name","kind":13,"containerName":"new"},{"name":"$auth","containerName":"new","kind":13,"line":154},{"name":"$self","kind":13,"containerName":"new","line":154},{"kind":12,"containerName":"new","name":"authority","line":154},{"line":154,"name":"$auth","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$def","line":155},{"containerName":"new","kind":13,"name":"$self","line":155},{"line":155,"name":"definition","kind":12,"containerName":"new"},{"name":"$def","containerName":"new","kind":13,"line":155},{"line":156,"containerName":"new","kind":13,"name":"$id"},{"containerName":"new","kind":13,"name":"$self","line":156},{"line":156,"kind":12,"containerName":"new","name":"identifier"},{"line":156,"containerName":"new","kind":13,"name":"$id"},{"containerName":"new","kind":13,"name":"$engine","line":157},{"line":157,"kind":13,"containerName":"new","name":"$self"},{"line":157,"name":"engine","containerName":"new","kind":12},{"name":"$engine","kind":13,"containerName":"new","line":157},{"name":"$self","containerName":"new","kind":13,"line":159}],"name":"new","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Ontology.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Ontology\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Ontology - standard implementation of an Ontology\n\n=head1 SYNOPSIS\n\n    use Bio::Ontology::Ontology;\n    use Bio::Ontology::Term;\n\n    # create ontology object\n    my $ont = Bio::Ontology::Ontology->new(-name => \"OBF\");\n\n    # add terms, relationships ...\n    my $bp = Bio::Ontology::Term->new(-identifier => '02', -name => \"Bioperl\");\n    my $obf = Bio::Ontology::Term->new(-identifier => '01', -name => \"OBF\");\n    my $partof = Bio::Ontology::RelationshipType->get_instance(\"PART_OF\");\n    $ont->add_term($bp);\n    $ont->add_term($obf);\n    $ont->add_relationship($bp, $obf, $partof);\n\n    # then query\n    my @terms = $ont->get_root_terms(); # \"OBF\"\n    my @desc = $ont->get_descendant_terms($terms[0], $partof); # \"Bioperl\"\n    # ... see methods for other ways to query\n\n    # for advanced users, you can re-use the query engine outside of an\n    # ontology to let one instance manage multiple ontologies\n    my $ont2 = Bio::Ontology::Ontology->new(-name => \"Foundations\",\n                                            -engine => $ont->engine());\n\n\n=head1 DESCRIPTION\n\nThis is a no-frills implementation of L<Bio::Ontology::OntologyI>.\n\nThe query functions are implemented by delegation to an\nOntologyEngineI implementation.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Ontology;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::SimpleOntologyEngine; # loaded dynamically now!\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Ontology::Ontology->new();\n Function: Builds a new Bio::Ontology::Ontology object\n Returns : an instance of Bio::Ontology::Ontology\n Args    : any number of named arguments. The following names will be\n           recognized by this module:\n\n            -name         the name of the ontology\n            -authority    the name of the authority for the ontology\n            -identifier   an identifier for the ontology, if any\n            -engine       the Bio::Ontology::OntologyEngineI\n                          implementation that this instance should use;\n                          default is Bio::Ontology::SimpleOntologyEngine\n\n            See the corresponding get/set methods for further documentation\n            on individual properties."},"line":141,"range":{"start":{"line":141,"character":0},"end":{"character":9999,"line":160}},"kind":12},{"name":"SUPER","kind":12,"containerName":"new","line":144},{"name":"name","containerName":"main::","children":[{"definition":"my","line":179,"name":"$self","localvar":"my","containerName":"name","kind":13},{"containerName":"name","kind":13,"name":"$self","line":181},{"line":182,"containerName":"name","kind":13,"name":"$self"}],"definition":"sub","kind":12,"range":{"start":{"line":178,"character":0},"end":{"line":183,"character":9999}},"line":178},{"kind":12,"range":{"start":{"line":205,"character":0},"end":{"character":9999,"line":210}},"line":205,"name":"authority","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"authority","line":206},{"line":208,"kind":13,"containerName":"authority","name":"$self"},{"line":209,"name":"$self","containerName":"authority","kind":13}],"definition":"sub"},{"definition":"sub","children":[{"kind":13,"localvar":"my","containerName":"definition","name":"$self","line":225,"definition":"my"},{"name":"$self","kind":13,"containerName":"definition","line":227},{"line":228,"name":"$self","containerName":"definition","kind":13}],"containerName":"main::","name":"definition","line":224,"kind":12,"range":{"start":{"character":0,"line":224},"end":{"line":229,"character":9999}}},{"kind":12,"range":{"start":{"character":0,"line":250},"end":{"line":263,"character":9999}},"line":250,"definition":"sub","containerName":"main::","name":"identifier","children":[{"definition":"my","line":251,"localvar":"my","containerName":"identifier","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"identifier","line":254},{"line":254,"kind":12,"containerName":"identifier","name":"throw"},{"kind":13,"containerName":"identifier","name":"$self","line":254},{"line":255,"name":"$self","kind":13,"containerName":"identifier"},{"line":256,"name":"$id","localvar":"my","kind":13,"containerName":"identifier","definition":"my"},{"containerName":"identifier","kind":13,"name":"$self","line":257},{"containerName":"identifier","kind":13,"name":"$id","line":257},{"line":257,"name":"$id","kind":13,"containerName":"identifier"},{"name":"$self","kind":13,"containerName":"identifier","line":259},{"name":"$self","containerName":"identifier","kind":13,"line":260},{"line":262,"name":"$self","kind":13,"containerName":"identifier"}]},{"kind":12,"range":{"end":{"line":290,"character":9999},"start":{"character":0,"line":281}},"line":281,"definition":"sub","containerName":"main::","name":"close","children":[{"line":282,"name":"$self","containerName":"close","localvar":"my","kind":13,"definition":"my"},{"localvar":"my","kind":13,"containerName":"close","name":"$store","line":285,"definition":"my"},{"line":285,"containerName":"close","kind":12,"name":"get_instance"},{"line":286,"containerName":"close","kind":13,"name":"$store"},{"name":"remove_ontology","containerName":"close","kind":12,"line":286},{"kind":13,"containerName":"close","name":"$self","line":286},{"line":288,"name":"$self","containerName":"close","kind":13},{"name":"engine","kind":12,"containerName":"close","line":288}]},{"line":285,"name":"Bio","containerName":"Ontology::OntologyStore","kind":12},{"range":{"end":{"line":338,"character":9999},"start":{"line":311,"character":0}},"kind":12,"line":311,"definition":"sub","containerName":"main::","name":"engine","children":[{"name":"$self","localvar":"my","containerName":"engine","kind":13,"line":312,"definition":"my"},{"name":"$engine","containerName":"engine","localvar":"my","kind":13,"line":315,"definition":"my"},{"line":316,"name":"$engine","containerName":"engine","kind":13},{"name":"$engine","containerName":"engine","kind":13,"line":317},{"name":"$engine","kind":13,"containerName":"engine","line":318},{"line":318,"name":"isa","containerName":"engine","kind":12},{"name":"$self","containerName":"engine","kind":13,"line":319},{"kind":12,"containerName":"engine","name":"throw","line":319},{"line":319,"kind":13,"containerName":"engine","name":"$engine"},{"line":322,"name":"$self","kind":13,"containerName":"engine"},{"name":"$engine","containerName":"engine","kind":13,"line":322},{"name":"$self","kind":13,"containerName":"engine","line":323},{"kind":13,"containerName":"engine","name":"$self","line":330},{"kind":12,"containerName":"engine","name":"throw","line":330},{"name":"$self","containerName":"engine","kind":13,"line":335},{"containerName":"engine","kind":12,"name":"new","line":335},{"name":"$self","containerName":"engine","kind":13,"line":337}]},{"line":329,"name":"Bio","kind":12,"containerName":"Ontology::SimpleOntologyEngine"},{"line":335,"containerName":"Ontology::SimpleOntologyEngine","kind":12,"name":"Bio"},{"line":361,"range":{"end":{"line":368,"character":9999},"start":{"line":361,"character":0}},"kind":12,"children":[{"definition":"my","containerName":"add_term","localvar":"my","kind":13,"name":"$self","line":362},{"definition":"my","line":363,"containerName":"add_term","localvar":"my","kind":13,"name":"$term"},{"line":366,"containerName":"add_term","kind":13,"name":"$term"},{"line":366,"kind":12,"containerName":"add_term","name":"ontology"},{"line":366,"name":"$self","containerName":"add_term","kind":13},{"name":"$term","kind":13,"containerName":"add_term","line":366},{"line":366,"kind":13,"containerName":"add_term","name":"$term"},{"line":366,"containerName":"add_term","kind":12,"name":"ontology"},{"line":367,"containerName":"add_term","kind":13,"name":"$self"},{"line":367,"containerName":"add_term","kind":12,"name":"engine"},{"line":367,"name":"add_term","kind":12,"containerName":"add_term"},{"name":"$term","kind":13,"containerName":"add_term","line":367}],"name":"add_term","containerName":"main::","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":400},"start":{"character":0,"line":383}},"line":383,"containerName":"main::","name":"add_relationship","children":[{"definition":"my","line":384,"localvar":"my","kind":13,"containerName":"add_relationship","name":"$self"},{"containerName":"add_relationship","localvar":"my","kind":13,"name":"$rel","line":385,"definition":"my"},{"name":"$rel","kind":13,"containerName":"add_relationship","line":387},{"line":387,"name":"$rel","containerName":"add_relationship","kind":13},{"detail":"($predicate,$object)","signature":{"label":"isa($predicate,$object)","parameters":[{"label":"$predicate"},{"label":"$object"}],"documentation":""},"line":387,"name":"isa","range":{"start":{}},"containerName":"add_relationship","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":"add_relationship","name":"$predicate","line":389},{"line":389,"name":"$object","kind":13,"containerName":"add_relationship"},{"line":390,"containerName":"add_relationship","kind":13,"name":"$rel"},{"line":390,"name":"new","kind":12,"containerName":"add_relationship"},{"kind":13,"containerName":"add_relationship","name":"$rel","line":391},{"name":"$object","kind":13,"containerName":"add_relationship","line":392},{"line":393,"kind":13,"containerName":"add_relationship","name":"$predicate"},{"name":"$self","kind":13,"containerName":"add_relationship","line":394},{"line":398,"containerName":"add_relationship","kind":13,"name":"$rel"},{"name":"ontology","containerName":"add_relationship","kind":12,"line":398},{"line":398,"name":"$self","kind":13,"containerName":"add_relationship"},{"kind":13,"containerName":"add_relationship","name":"$rel","line":398},{"line":398,"containerName":"add_relationship","kind":12,"name":"ontology"},{"line":399,"containerName":"add_relationship","kind":13,"name":"$self"},{"name":"engine","containerName":"add_relationship","kind":12,"line":399},{"name":"add_relationship","kind":12,"containerName":"add_relationship","line":399},{"containerName":"add_relationship","kind":13,"name":"$rel","line":399}],"definition":"sub"},{"containerName":"Ontology::Relationship","kind":12,"name":"Bio","line":390},{"line":414,"kind":12,"range":{"end":{"character":9999,"line":417},"start":{"line":414,"character":0}},"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"get_relationship_type","kind":13,"name":"$self","line":415},{"name":"$self","kind":13,"containerName":"get_relationship_type","line":416},{"line":416,"containerName":"get_relationship_type","kind":12,"name":"engine"},{"line":416,"kind":12,"containerName":"get_relationship_type","name":"get_relationship_type"}],"containerName":"main::","name":"get_relationship_type"},{"range":{"end":{"character":9999,"line":447},"start":{"line":432,"character":0}},"kind":12,"line":432,"name":"get_relationships","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"get_relationships","localvar":"my","kind":13,"line":433},{"definition":"my","line":434,"name":"$term","containerName":"get_relationships","localvar":"my","kind":13},{"line":435,"name":"$term","containerName":"get_relationships","kind":13},{"line":437,"name":"$self","containerName":"get_relationships","kind":13},{"line":437,"name":"engine","containerName":"get_relationships","kind":12},{"line":437,"name":"get_relationships","kind":12,"containerName":"get_relationships"},{"line":437,"name":"$term","kind":13,"containerName":"get_relationships"},{"name":"$ont","containerName":"get_relationships","localvar":"my","kind":13,"line":440,"definition":"my"},{"kind":12,"containerName":"get_relationships","name":"ontology","line":440},{"line":445,"kind":13,"containerName":"get_relationships","name":"$ont"},{"line":445,"name":"$self","kind":13,"containerName":"get_relationships"},{"line":445,"name":"$ont","containerName":"get_relationships","kind":13},{"line":445,"name":"name","containerName":"get_relationships","kind":12},{"name":"$self","containerName":"get_relationships","kind":13,"line":445},{"line":445,"kind":12,"containerName":"get_relationships","name":"name"},{"line":446,"kind":13,"containerName":"get_relationships","name":"$self"},{"name":"engine","containerName":"get_relationships","kind":12,"line":446},{"line":446,"containerName":"get_relationships","kind":12,"name":"get_relationships"}],"definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":461},"end":{"character":9999,"line":467}},"line":461,"definition":"sub","name":"get_predicate_terms","containerName":"main::","children":[{"definition":"my","line":462,"name":"$self","localvar":"my","kind":13,"containerName":"get_predicate_terms"},{"line":465,"containerName":"get_predicate_terms","kind":12,"name":"ontology"},{"line":465,"name":"ontology","kind":12,"containerName":"get_predicate_terms"},{"line":465,"name":"name","containerName":"get_predicate_terms","kind":12},{"containerName":"get_predicate_terms","kind":13,"name":"$self","line":465},{"line":465,"name":"name","containerName":"get_predicate_terms","kind":12},{"line":466,"name":"$self","containerName":"get_predicate_terms","kind":13},{"containerName":"get_predicate_terms","kind":12,"name":"engine","line":466},{"kind":12,"containerName":"get_predicate_terms","name":"get_predicate_terms","line":466}]},{"definition":"sub","containerName":"main::","name":"get_child_terms","children":[{"line":494,"name":"engine","kind":12,"containerName":"get_child_terms"},{"line":494,"name":"get_child_terms","kind":12,"containerName":"get_child_terms"}],"kind":12,"range":{"end":{"character":9999,"line":495},"start":{"line":493,"character":0}},"line":493},{"name":"get_descendant_terms","containerName":"main::","children":[{"line":520,"containerName":"get_descendant_terms","kind":12,"name":"engine"},{"containerName":"get_descendant_terms","kind":12,"name":"get_descendant_terms","line":520}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":521},"start":{"line":519,"character":0}},"line":519},{"line":547,"range":{"start":{"character":0,"line":547},"end":{"line":549,"character":9999}},"kind":12,"children":[{"line":548,"kind":12,"containerName":"get_parent_terms","name":"engine"},{"name":"get_parent_terms","kind":12,"containerName":"get_parent_terms","line":548}],"name":"get_parent_terms","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"line":574,"containerName":"get_ancestor_terms","kind":12,"name":"engine"},{"line":574,"name":"get_ancestor_terms","containerName":"get_ancestor_terms","kind":12}],"containerName":"main::","name":"get_ancestor_terms","line":573,"kind":12,"range":{"end":{"character":9999,"line":575},"start":{"line":573,"character":0}}},{"kind":12,"range":{"start":{"character":0,"line":590},"end":{"line":599,"character":9999}},"line":590,"containerName":"main::","name":"get_leaf_terms","children":[{"name":"$self","containerName":"get_leaf_terms","localvar":"my","kind":13,"line":591,"definition":"my"},{"name":"$ont","localvar":"my","kind":13,"containerName":"get_leaf_terms","line":592,"definition":"my"},{"containerName":"get_leaf_terms","kind":12,"name":"ontology","line":592},{"name":"$ont","kind":13,"containerName":"get_leaf_terms","line":597},{"name":"$self","containerName":"get_leaf_terms","kind":13,"line":597},{"kind":13,"containerName":"get_leaf_terms","name":"$ont","line":597},{"name":"name","kind":12,"containerName":"get_leaf_terms","line":597},{"line":597,"name":"$self","containerName":"get_leaf_terms","kind":13},{"containerName":"get_leaf_terms","kind":12,"name":"name","line":597},{"name":"$self","kind":13,"containerName":"get_leaf_terms","line":598},{"kind":12,"containerName":"get_leaf_terms","name":"engine","line":598},{"name":"get_leaf_terms","containerName":"get_leaf_terms","kind":12,"line":598}],"definition":"sub"},{"children":[{"line":615,"containerName":"get_root_terms","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$ont","localvar":"my","kind":13,"containerName":"get_root_terms","line":616,"definition":"my"},{"line":616,"containerName":"get_root_terms","kind":12,"name":"ontology"},{"line":621,"containerName":"get_root_terms","kind":13,"name":"$ont"},{"name":"$self","containerName":"get_root_terms","kind":13,"line":621},{"line":621,"containerName":"get_root_terms","kind":13,"name":"$ont"},{"line":621,"name":"name","containerName":"get_root_terms","kind":12},{"containerName":"get_root_terms","kind":13,"name":"$self","line":621},{"kind":12,"containerName":"get_root_terms","name":"name","line":621},{"containerName":"get_root_terms","kind":13,"name":"$self","line":622},{"line":622,"name":"engine","containerName":"get_root_terms","kind":12},{"name":"get_root_terms","kind":12,"containerName":"get_root_terms","line":622}],"name":"get_root_terms","containerName":"main::","definition":"sub","line":614,"kind":12,"range":{"start":{"character":0,"line":614},"end":{"character":9999,"line":623}}},{"line":641,"range":{"start":{"character":0,"line":641},"end":{"line":650,"character":9999}},"kind":12,"definition":"sub","children":[{"name":"$self","containerName":"get_all_terms","localvar":"my","kind":13,"line":642,"definition":"my"},{"definition":"my","name":"$ont","localvar":"my","kind":13,"containerName":"get_all_terms","line":643},{"name":"ontology","kind":12,"containerName":"get_all_terms","line":643},{"line":648,"name":"$ont","kind":13,"containerName":"get_all_terms"},{"line":648,"name":"$self","containerName":"get_all_terms","kind":13},{"kind":13,"containerName":"get_all_terms","name":"$ont","line":648},{"line":648,"containerName":"get_all_terms","kind":12,"name":"name"},{"containerName":"get_all_terms","kind":13,"name":"$self","line":648},{"containerName":"get_all_terms","kind":12,"name":"name","line":648},{"name":"$self","kind":13,"containerName":"get_all_terms","line":649},{"name":"engine","kind":12,"containerName":"get_all_terms","line":649},{"containerName":"get_all_terms","kind":12,"name":"get_all_terms","line":649}],"containerName":"main::","name":"get_all_terms"},{"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"find_terms","localvar":"my","kind":13,"line":674},{"line":675,"name":"ontology","kind":12,"containerName":"find_terms"},{"line":675,"name":"name","containerName":"find_terms","kind":12},{"name":"$self","kind":13,"containerName":"find_terms","line":675},{"line":675,"name":"name","kind":12,"containerName":"find_terms"},{"containerName":"find_terms","kind":13,"name":"$self","line":676},{"name":"engine","kind":12,"containerName":"find_terms","line":676},{"containerName":"find_terms","kind":12,"name":"find_terms","line":676}],"containerName":"main::","name":"find_terms","line":673,"range":{"end":{"character":9999,"line":677},"start":{"line":673,"character":0}},"kind":12},{"line":691,"kind":12,"range":{"end":{"line":695,"character":9999},"start":{"character":0,"line":691}},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"find_identical_terms","name":"$self","line":692},{"containerName":"find_identical_terms","kind":12,"name":"ontology","line":693},{"containerName":"find_identical_terms","kind":12,"name":"name","line":693},{"name":"$self","containerName":"find_identical_terms","kind":13,"line":693},{"line":693,"name":"name","kind":12,"containerName":"find_identical_terms"},{"kind":13,"containerName":"find_identical_terms","name":"$self","line":694},{"line":694,"name":"engine","containerName":"find_identical_terms","kind":12},{"kind":12,"containerName":"find_identical_terms","name":"find_identical_terms","line":694}],"containerName":"main::","name":"find_identical_terms","definition":"sub"},{"definition":"sub","containerName":"main::","name":"find_similar_terms","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"find_similar_terms","line":711,"definition":"my"},{"kind":12,"containerName":"find_similar_terms","name":"ontology","line":712},{"name":"name","kind":12,"containerName":"find_similar_terms","line":712},{"containerName":"find_similar_terms","kind":13,"name":"$self","line":712},{"containerName":"find_similar_terms","kind":12,"name":"name","line":712},{"line":713,"name":"$self","containerName":"find_similar_terms","kind":13},{"name":"engine","containerName":"find_similar_terms","kind":12,"line":713},{"name":"find_similar_terms","containerName":"find_similar_terms","kind":12,"line":713}],"range":{"end":{"line":714,"character":9999},"start":{"line":710,"character":0}},"kind":12,"line":710},{"containerName":"main::","name":"find_identically_named_terms","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"find_identically_named_terms","name":"$self","line":729},{"name":"ontology","kind":12,"containerName":"find_identically_named_terms","line":730},{"containerName":"find_identically_named_terms","kind":12,"name":"name","line":730},{"line":730,"name":"$self","containerName":"find_identically_named_terms","kind":13},{"kind":12,"containerName":"find_identically_named_terms","name":"name","line":731},{"line":731,"name":"$self","kind":13,"containerName":"find_identically_named_terms"},{"line":731,"kind":12,"containerName":"find_identically_named_terms","name":"engine"},{"name":"find_identically_named_terms","kind":12,"containerName":"find_identically_named_terms","line":731}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":732},"start":{"line":728,"character":0}},"line":728},{"line":753,"range":{"end":{"line":755,"character":9999},"start":{"line":753,"character":0}},"kind":12,"children":[{"line":754,"name":"engine","containerName":"relationship_factory","kind":12},{"name":"relationship_factory","kind":12,"containerName":"relationship_factory","line":754}],"containerName":"main::","name":"relationship_factory","definition":"sub"},{"name":"term_factory","containerName":"main::","children":[{"containerName":"term_factory","kind":12,"name":"engine","line":773},{"line":773,"containerName":"term_factory","kind":12,"name":"term_factory"}],"definition":"sub","range":{"end":{"character":9999,"line":774},"start":{"line":772,"character":0}},"kind":12,"line":772},{"range":{"end":{"line":798,"character":9999},"start":{"character":0,"line":794}},"kind":12,"line":794,"containerName":"main::","name":"annotation","children":[{"containerName":"annotation","localvar":"my","kind":13,"name":"$self","line":795,"definition":"my"},{"line":796,"name":"$self","containerName":"annotation","kind":13},{"line":797,"kind":13,"containerName":"annotation","name":"$self"}],"definition":"sub"}],"version":5}