{"version":5,"vars":[{"definition":1,"name":"TRUE","containerName":"main::","kind":14,"line":91},{"line":91,"containerName":"Bio::Ontology::RelationshipType::Bio::Ontology::RelationshipFactory::Data::Dumper","kind":12,"name":"strict"},{"definition":1,"line":92,"containerName":"main::","kind":14,"name":"FALSE"},{"name":"IS_A","containerName":"main::","kind":14,"line":93,"definition":1},{"definition":1,"line":94,"containerName":"main::","kind":14,"name":"PART_OF"},{"line":95,"containerName":"main::","kind":14,"name":"RELATED_TO","definition":1},{"definition":1,"line":96,"name":"TERM","kind":14,"containerName":"main::"},{"definition":1,"line":97,"name":"TYPE","containerName":"main::","kind":14},{"definition":1,"containerName":"main::","kind":14,"name":"ONTOLOGY","line":98},{"line":99,"containerName":"main::","kind":14,"name":"REGULATES","definition":1},{"definition":1,"kind":14,"containerName":"main::","name":"POSITIVELY_REGULATES","line":100},{"name":"NEGATIVELY_REGULATES","containerName":"main::","kind":14,"line":101,"definition":1},{"name":"base","kind":2,"containerName":"","line":104},{"range":{"start":{"character":0,"line":118},"end":{"character":9999,"line":126}},"kind":12,"line":118,"signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"localvar":"my","containerName":"new","kind":13,"name":"$class","line":119,"definition":"my"},{"line":119,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":121,"name":"$self","localvar":"my","containerName":"new","kind":13},{"name":"$class","containerName":"new","kind":13,"line":121},{"line":121,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","kind":13,"containerName":"new","line":123},{"name":"init","containerName":"new","kind":12,"line":123},{"name":"$self","kind":13,"containerName":"new","line":125}],"detail":"($class,@args)","definition":"sub"},{"line":121,"kind":12,"containerName":"new","name":"SUPER"},{"name":"init","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"init","name":"$self","line":141,"definition":"my"},{"name":"$self","containerName":"init","kind":13,"line":143},{"line":143,"kind":12,"containerName":"init","name":"get_instance"},{"line":144,"name":"$self","kind":13,"containerName":"init"},{"name":"get_instance","kind":12,"containerName":"init","line":144},{"line":145,"containerName":"init","kind":13,"name":"$self"},{"name":"get_instance","kind":12,"containerName":"init","line":145},{"line":147,"name":"$self","containerName":"init","kind":13},{"line":147,"name":"get_instance","kind":12,"containerName":"init"},{"line":148,"name":"$self","kind":13,"containerName":"init"},{"line":148,"containerName":"init","kind":12,"name":"get_instance"},{"containerName":"init","kind":13,"name":"$self","line":149},{"kind":12,"containerName":"init","name":"get_instance","line":149},{"name":"$self","containerName":"init","kind":13,"line":152},{"name":"graph","containerName":"init","kind":12,"line":152},{"containerName":"init","kind":12,"name":"new","line":152},{"containerName":"init","kind":13,"name":"$self","line":155},{"name":"relationship_factory","kind":12,"containerName":"init","line":155},{"line":155,"name":"new","kind":12,"containerName":"init"}],"detail":"($self)","definition":"sub","range":{"end":{"line":158,"character":9999},"start":{"line":140,"character":0}},"kind":12,"line":140,"signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"init($self)"}},{"name":"Bio","kind":12,"containerName":"Ontology::RelationshipType","line":143},{"line":143,"kind":12,"name":"IS_A"},{"line":144,"name":"Bio","containerName":"Ontology::RelationshipType","kind":12},{"line":144,"kind":12,"name":"PART_OF"},{"kind":12,"containerName":"Ontology::RelationshipType","name":"Bio","line":145},{"kind":12,"name":"RELATED_TO","line":145},{"name":"Bio","kind":12,"containerName":"Ontology::RelationshipType","line":147},{"line":147,"kind":12,"name":"REGULATES"},{"line":148,"name":"Bio","kind":12,"containerName":"Ontology::RelationshipType"},{"line":148,"kind":12,"name":"POSITIVELY_REGULATES"},{"name":"Bio","containerName":"Ontology::RelationshipType","kind":12,"line":149},{"line":149,"kind":12,"name":"NEGATIVELY_REGULATES"},{"kind":12,"containerName":"Ontology::SimpleGOEngine::GraphAdaptor","name":"Bio","line":152},{"containerName":"Ontology::RelationshipFactory","kind":12,"name":"Bio","line":155},{"signature":{"label":"is_a_relationship($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :"},"kind":12,"range":{"start":{"line":173,"character":0},"end":{"character":9999,"line":181}},"line":173,"detail":"($self,$value)","definition":"sub","name":"is_a_relationship","containerName":"main::","children":[{"line":174,"name":"$self","localvar":"my","containerName":"is_a_relationship","kind":13,"definition":"my"},{"kind":13,"containerName":"is_a_relationship","name":"$value","line":174},{"name":"$value","kind":13,"containerName":"is_a_relationship","line":176},{"containerName":"is_a_relationship","kind":13,"name":"$self","line":177},{"line":177,"name":"throw","kind":12,"containerName":"is_a_relationship"},{"line":180,"name":"$self","kind":13,"containerName":"is_a_relationship"}]},{"signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :","parameters":[{"label":"$self"},{"label":"$value"}],"label":"part_of_relationship($self,$value)"},"range":{"end":{"character":9999,"line":204},"start":{"character":0,"line":196}},"kind":12,"line":196,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"part_of_relationship","children":[{"definition":"my","line":197,"localvar":"my","kind":13,"containerName":"part_of_relationship","name":"$self"},{"line":197,"kind":13,"containerName":"part_of_relationship","name":"$value"},{"name":"$value","kind":13,"containerName":"part_of_relationship","line":199},{"name":"$self","kind":13,"containerName":"part_of_relationship","line":200},{"line":200,"name":"throw","kind":12,"containerName":"part_of_relationship"},{"name":"$self","kind":13,"containerName":"part_of_relationship","line":203}]},{"name":"related_to_relationship","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"related_to_relationship","kind":13,"line":219},{"line":219,"containerName":"related_to_relationship","kind":13,"name":"$value"},{"line":221,"name":"$value","containerName":"related_to_relationship","kind":13},{"name":"$self","kind":13,"containerName":"related_to_relationship","line":222},{"name":"throw","kind":12,"containerName":"related_to_relationship","line":222},{"kind":13,"containerName":"related_to_relationship","name":"$self","line":225}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":218},"end":{"character":9999,"line":226}},"kind":12,"line":218,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :","label":"related_to_relationship($self,$value)"}},{"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"regulates_relationship","line":240,"definition":"my"},{"name":"$value","containerName":"regulates_relationship","kind":13,"line":240},{"line":242,"kind":13,"containerName":"regulates_relationship","name":"$value"},{"line":243,"name":"$self","kind":13,"containerName":"regulates_relationship"},{"name":"throw","containerName":"regulates_relationship","kind":12,"line":243},{"line":246,"containerName":"regulates_relationship","kind":13,"name":"$self"}],"name":"regulates_relationship","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :","label":"regulates_relationship($self,$value)"},"line":239,"kind":12,"range":{"end":{"line":247,"character":9999},"start":{"character":0,"line":239}}},{"signature":{"label":"positively_regulates_relationship($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :"},"kind":12,"range":{"start":{"character":0,"line":260},"end":{"character":9999,"line":268}},"line":260,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"positively_regulates_relationship","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"positively_regulates_relationship","line":261},{"line":261,"name":"$value","kind":13,"containerName":"positively_regulates_relationship"},{"line":263,"name":"$value","kind":13,"containerName":"positively_regulates_relationship"},{"line":264,"name":"$self","containerName":"positively_regulates_relationship","kind":13},{"kind":12,"containerName":"positively_regulates_relationship","name":"throw","line":264},{"line":267,"name":"$self","containerName":"positively_regulates_relationship","kind":13}]},{"children":[{"containerName":"negatively_regulates_relationship","localvar":"my","kind":13,"name":"$self","line":282,"definition":"my"},{"kind":13,"containerName":"negatively_regulates_relationship","name":"$value","line":282},{"name":"$value","containerName":"negatively_regulates_relationship","kind":13,"line":284},{"line":285,"containerName":"negatively_regulates_relationship","kind":13,"name":"$self"},{"line":285,"kind":12,"containerName":"negatively_regulates_relationship","name":"throw"},{"name":"$self","kind":13,"containerName":"negatively_regulates_relationship","line":288}],"containerName":"main::","name":"negatively_regulates_relationship","definition":"sub","detail":"($self,$value)","line":281,"range":{"start":{"character":0,"line":281},"end":{"character":9999,"line":289}},"kind":12,"signature":{"label":"negatively_regulates_relationship($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :"}},{"definition":"sub","detail":"($self,$term)","children":[{"localvar":"my","kind":13,"containerName":"add_term","name":"$self","line":304,"definition":"my"},{"line":304,"containerName":"add_term","kind":13,"name":"$term"},{"line":306,"containerName":"add_term","kind":13,"name":"$self"},{"name":"has_term","kind":12,"containerName":"add_term","line":306},{"line":306,"name":"$term","kind":13,"containerName":"add_term"},{"localvar":"my","kind":13,"containerName":"add_term","name":"$goid","line":308,"definition":"my"},{"name":"$self","kind":13,"containerName":"add_term","line":308},{"line":308,"kind":12,"containerName":"add_term","name":"_get_id"},{"kind":13,"containerName":"add_term","name":"$term","line":308},{"name":"$self","kind":13,"containerName":"add_term","line":310},{"kind":12,"containerName":"add_term","name":"graph","line":310},{"line":310,"name":"add_vertex","containerName":"add_term","kind":12},{"containerName":"add_term","kind":13,"name":"$goid","line":310},{"kind":13,"containerName":"add_term","name":"$self","line":311},{"name":"graph","kind":12,"containerName":"add_term","line":311},{"line":311,"name":"set_vertex_attribute","kind":12,"containerName":"add_term"},{"line":311,"name":"$goid","containerName":"add_term","kind":13},{"containerName":"add_term","kind":13,"name":"$term","line":311}],"name":"add_term","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI","label":"add_term($self,$term)"},"line":303,"kind":12,"range":{"end":{"character":9999,"line":314},"start":{"character":0,"line":303}}},{"line":306,"kind":12,"name":"FALSE"},{"line":311,"kind":12,"name":"TERM"},{"line":312,"name":"TRUE","kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")","label":"has_term($self,$term)"},"kind":12,"range":{"start":{"line":330,"character":0},"end":{"character":9999,"line":340}},"line":330,"detail":"($self,$term)","definition":"sub","containerName":"main::","name":"has_term","children":[{"line":331,"name":"$self","kind":13,"localvar":"my","containerName":"has_term","definition":"my"},{"name":"$term","containerName":"has_term","kind":13,"line":331},{"name":"$term","containerName":"has_term","kind":13,"line":332},{"containerName":"has_term","kind":13,"name":"$self","line":332},{"line":332,"containerName":"has_term","kind":12,"name":"_get_id"},{"line":332,"name":"$term","containerName":"has_term","kind":13},{"line":333,"name":"$self","kind":13,"containerName":"has_term"},{"kind":12,"containerName":"has_term","name":"graph","line":333},{"containerName":"has_term","kind":12,"name":"has_vertex","line":333},{"line":333,"name":"$term","kind":13,"containerName":"has_term"}]},{"line":334,"name":"TRUE","kind":12},{"name":"FALSE","kind":12,"line":337},{"detail":"($self,@args)","definition":"sub","name":"add_relationship_type","containerName":"main::","children":[{"line":356,"localvar":"my","containerName":"add_relationship_type","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"add_relationship_type","name":"@args","line":356},{"definition":"my","line":359,"kind":13,"localvar":"my","containerName":"add_relationship_type","name":"$type_name"},{"line":359,"containerName":"add_relationship_type","kind":13,"name":"$args"},{"localvar":"my","kind":13,"containerName":"add_relationship_type","name":"$ont","line":360,"definition":"my"},{"line":360,"name":"$args","containerName":"add_relationship_type","kind":13},{"line":361,"name":"$self","containerName":"add_relationship_type","kind":13},{"containerName":"add_relationship_type","kind":13,"name":"$type_name","line":361},{"line":361,"kind":12,"containerName":"add_relationship_type","name":"get_instance"},{"line":361,"containerName":"add_relationship_type","kind":13,"name":"$type_name"},{"line":361,"name":"$ont","kind":13,"containerName":"add_relationship_type"}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type","label":"add_relationship_type($self,@args)"},"kind":12,"range":{"end":{"line":366,"character":9999},"start":{"character":0,"line":355}},"line":355},{"line":361,"name":"Bio","containerName":"Ontology::RelationshipType","kind":12},{"children":[{"name":"$self","containerName":"get_relationship_type","localvar":"my","kind":13,"line":381,"definition":"my"},{"containerName":"get_relationship_type","kind":13,"name":"$type_name","line":381},{"line":382,"containerName":"get_relationship_type","kind":13,"name":"$self"},{"line":382,"kind":13,"containerName":"get_relationship_type","name":"$type_name"}],"containerName":"main::","name":"get_relationship_type","definition":"sub","detail":"($self,$type_name)","line":380,"kind":12,"range":{"end":{"character":9999,"line":383},"start":{"line":380,"character":0}},"signature":{"label":"get_relationship_type($self,$type_name)","documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :","parameters":[{"label":"$self"},{"label":"$type_name"}]}},{"definition":"sub","detail":"($self,$child,$type,$parent,$ont)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"add_relationship","line":414},{"line":414,"name":"$child","containerName":"add_relationship","kind":13},{"line":414,"containerName":"add_relationship","kind":13,"name":"$type"},{"name":"$parent","kind":13,"containerName":"add_relationship","line":414},{"line":414,"containerName":"add_relationship","kind":13,"name":"$ont"},{"name":"$self","containerName":"add_relationship","kind":13,"line":417},{"line":417,"name":"_check_class","containerName":"add_relationship","kind":12},{"line":417,"kind":13,"containerName":"add_relationship","name":"$child"},{"line":418,"name":"$type","kind":13,"containerName":"add_relationship"},{"containerName":"add_relationship","kind":13,"name":"$child","line":418},{"line":418,"name":"predicate_term","kind":12,"containerName":"add_relationship"},{"name":"$parent","kind":13,"containerName":"add_relationship","line":419},{"name":"$child","containerName":"add_relationship","kind":13,"line":419},{"kind":12,"containerName":"add_relationship","name":"object_term","line":419},{"line":420,"kind":13,"containerName":"add_relationship","name":"$ont"},{"line":420,"kind":13,"containerName":"add_relationship","name":"$child"},{"line":420,"kind":12,"containerName":"add_relationship","name":"ontology"},{"line":421,"name":"$child","kind":13,"containerName":"add_relationship"},{"name":"$child","kind":13,"containerName":"add_relationship","line":421},{"line":421,"containerName":"add_relationship","kind":12,"name":"subject_term"},{"containerName":"add_relationship","kind":13,"name":"$self","line":425},{"name":"_check_class","kind":12,"containerName":"add_relationship","line":425},{"kind":13,"containerName":"add_relationship","name":"$type","line":425},{"name":"$parentid","kind":13,"localvar":"my","containerName":"add_relationship","line":427,"definition":"my"},{"line":427,"name":"$self","containerName":"add_relationship","kind":13},{"line":427,"kind":12,"containerName":"add_relationship","name":"_get_id"},{"name":"$parent","containerName":"add_relationship","kind":13,"line":427},{"line":428,"name":"$childid","localvar":"my","kind":13,"containerName":"add_relationship","definition":"my"},{"name":"$self","kind":13,"containerName":"add_relationship","line":428},{"line":428,"kind":12,"containerName":"add_relationship","name":"_get_id"},{"line":428,"containerName":"add_relationship","kind":13,"name":"$child"},{"name":"$g","containerName":"add_relationship","localvar":"my","kind":13,"line":430,"definition":"my"},{"line":430,"kind":13,"containerName":"add_relationship","name":"$self"},{"line":430,"kind":12,"containerName":"add_relationship","name":"graph"},{"kind":13,"containerName":"add_relationship","name":"$self","line":432},{"containerName":"add_relationship","kind":12,"name":"add_term","line":432},{"kind":13,"containerName":"add_relationship","name":"$child","line":432},{"containerName":"add_relationship","kind":13,"name":"$g","line":432},{"line":432,"kind":12,"containerName":"add_relationship","name":"has_vertex"},{"name":"$childid","kind":13,"containerName":"add_relationship","line":432},{"name":"$self","kind":13,"containerName":"add_relationship","line":433},{"name":"add_term","kind":12,"containerName":"add_relationship","line":433},{"line":433,"name":"$parent","containerName":"add_relationship","kind":13},{"line":433,"name":"$g","containerName":"add_relationship","kind":13},{"line":433,"name":"has_vertex","kind":12,"containerName":"add_relationship"},{"line":433,"name":"$parentid","kind":13,"containerName":"add_relationship"},{"name":"$g","containerName":"add_relationship","kind":13,"line":436},{"kind":12,"containerName":"add_relationship","name":"has_edge","line":436},{"kind":13,"containerName":"add_relationship","name":"$parentid","line":436},{"line":436,"kind":13,"containerName":"add_relationship","name":"$childid"},{"line":440,"name":"$g","containerName":"add_relationship","kind":13},{"kind":12,"containerName":"add_relationship","name":"add_edge","line":440},{"name":"$parentid","containerName":"add_relationship","kind":13,"line":440},{"containerName":"add_relationship","kind":13,"name":"$childid","line":440},{"line":441,"kind":13,"containerName":"add_relationship","name":"$g"},{"line":441,"name":"set_edge_attribute","kind":12,"containerName":"add_relationship"},{"line":441,"kind":13,"containerName":"add_relationship","name":"$parentid"},{"containerName":"add_relationship","kind":13,"name":"$childid","line":441},{"kind":13,"containerName":"add_relationship","name":"$type","line":441},{"name":"$g","kind":13,"containerName":"add_relationship","line":442},{"name":"set_edge_attribute","kind":12,"containerName":"add_relationship","line":442},{"name":"$parentid","kind":13,"containerName":"add_relationship","line":442},{"line":442,"name":"$childid","kind":13,"containerName":"add_relationship"},{"line":442,"containerName":"add_relationship","kind":13,"name":"$ont"}],"name":"add_relationship","containerName":"main::","signature":{"label":"add_relationship($self,$child,$type,$parent,$ont)","documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n term objs or term ids","parameters":[{"label":"$self"},{"label":"$child"},{"label":"$type"},{"label":"$parent"},{"label":"$ont"}]},"line":413,"kind":12,"range":{"end":{"character":9999,"line":446},"start":{"line":413,"character":0}}},{"line":437,"name":"FALSE","kind":12},{"kind":12,"name":"TYPE","line":441},{"name":"ONTOLOGY","kind":12,"line":442},{"line":444,"kind":12,"name":"TRUE"},{"definition":"sub","detail":"($self,$term)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"get_relationships","kind":13,"line":466},{"name":"$term","kind":13,"containerName":"get_relationships","line":466},{"containerName":"get_relationships","localvar":"my","kind":13,"name":"$g","line":468,"definition":"my"},{"kind":13,"containerName":"get_relationships","name":"$self","line":468},{"name":"graph","kind":12,"containerName":"get_relationships","line":468},{"line":471,"name":"$termid","kind":13,"localvar":"my","containerName":"get_relationships","definition":"my"},{"line":472,"name":"$term","kind":13,"containerName":"get_relationships"},{"line":473,"name":"$termid","containerName":"get_relationships","kind":13},{"line":473,"containerName":"get_relationships","kind":13,"name":"$self"},{"kind":12,"containerName":"get_relationships","name":"_get_id","line":473},{"name":"$term","kind":13,"containerName":"get_relationships","line":473},{"line":475,"kind":13,"containerName":"get_relationships","name":"$g"},{"line":475,"kind":12,"containerName":"get_relationships","name":"has_vertex"},{"line":475,"name":"$termid","containerName":"get_relationships","kind":13},{"kind":13,"containerName":"get_relationships","name":"$self","line":476},{"name":"throw","containerName":"get_relationships","kind":12,"line":476},{"definition":"my","line":481,"name":"$relfact","localvar":"my","kind":13,"containerName":"get_relationships"},{"name":"$self","kind":13,"containerName":"get_relationships","line":481},{"line":481,"kind":12,"containerName":"get_relationships","name":"relationship_factory"},{"definition":"my","localvar":"my","containerName":"get_relationships","kind":13,"name":"@rels","line":483},{"definition":"my","line":484,"name":"@edges","kind":13,"localvar":"my","containerName":"get_relationships"},{"line":484,"kind":13,"containerName":"get_relationships","name":"$termid"},{"kind":13,"containerName":"get_relationships","name":"$g","line":484},{"line":484,"name":"edges_at","containerName":"get_relationships","kind":12},{"line":484,"kind":13,"containerName":"get_relationships","name":"$termid"},{"kind":13,"containerName":"get_relationships","name":"$g","line":484},{"line":484,"name":"edges","containerName":"get_relationships","kind":12},{"kind":13,"containerName":"get_relationships","name":"@edges","line":485},{"definition":"my","line":486,"kind":13,"localvar":"my","containerName":"get_relationships","name":"$startid"},{"kind":13,"containerName":"get_relationships","name":"$endid","line":486},{"name":"@edges","containerName":"get_relationships","kind":13,"line":486},{"definition":"my","name":"$rel","localvar":"my","containerName":"get_relationships","kind":13,"line":487},{"kind":13,"containerName":"get_relationships","name":"$relfact","line":487},{"containerName":"get_relationships","kind":12,"name":"create_object","line":488},{"line":488,"kind":13,"containerName":"get_relationships","name":"$self"},{"line":488,"containerName":"get_relationships","kind":12,"name":"get_terms"},{"containerName":"get_relationships","kind":13,"name":"$endid","line":488},{"line":489,"containerName":"get_relationships","kind":13,"name":"$self"},{"name":"get_terms","kind":12,"containerName":"get_relationships","line":489},{"line":489,"kind":13,"containerName":"get_relationships","name":"$startid"},{"line":490,"containerName":"get_relationships","kind":13,"name":"$g"},{"line":490,"name":"get_edge_attribute","containerName":"get_relationships","kind":12},{"line":490,"containerName":"get_relationships","kind":13,"name":"$startid"},{"line":490,"kind":13,"containerName":"get_relationships","name":"$endid"},{"line":491,"name":"$g","kind":13,"containerName":"get_relationships"},{"kind":12,"containerName":"get_relationships","name":"get_edge_attribute","line":491},{"line":491,"name":"$startid","kind":13,"containerName":"get_relationships"},{"line":491,"kind":13,"containerName":"get_relationships","name":"$endid"},{"name":"@rels","containerName":"get_relationships","kind":13,"line":492},{"line":492,"containerName":"get_relationships","kind":13,"name":"$rel"}],"name":"get_relationships","containerName":"main::","signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI","parameters":[{"label":"$self"},{"label":"$term"}],"label":"get_relationships($self,$term)"},"line":465,"kind":12,"range":{"start":{"character":0,"line":465},"end":{"line":494,"character":9999}}},{"line":486,"kind":12,"name":"shift"},{"line":490,"kind":12,"name":"TYPE"},{"line":491,"name":"ONTOLOGY","kind":12},{"containerName":null,"kind":13,"name":"@rels","line":496},{"definition":"sub","children":[{"containerName":"get_all_relationships","kind":12,"name":"get_relationships","line":512}],"name":"get_all_relationships","containerName":"main::","line":511,"kind":12,"range":{"end":{"character":9999,"line":513},"start":{"character":0,"line":511}}},{"signature":{"label":"get_predicate_terms($self)","documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :","parameters":[{"label":"$self"}]},"line":527,"kind":12,"range":{"end":{"character":9999,"line":539},"start":{"character":0,"line":527}},"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","containerName":"get_predicate_terms","localvar":"my","kind":13,"line":528},{"line":530,"name":"@a","localvar":"my","kind":13,"containerName":"get_predicate_terms","definition":"my"},{"line":531,"name":"$self","containerName":"get_predicate_terms","kind":13},{"name":"is_a_relationship","kind":12,"containerName":"get_predicate_terms","line":531},{"kind":13,"containerName":"get_predicate_terms","name":"$self","line":532},{"kind":12,"containerName":"get_predicate_terms","name":"part_of_relationship","line":532},{"kind":13,"containerName":"get_predicate_terms","name":"$self","line":533},{"line":533,"name":"related_to_relationship","containerName":"get_predicate_terms","kind":12},{"kind":13,"containerName":"get_predicate_terms","name":"$self","line":534},{"line":534,"name":"regulates_relationship","containerName":"get_predicate_terms","kind":12},{"name":"$self","kind":13,"containerName":"get_predicate_terms","line":535},{"line":535,"containerName":"get_predicate_terms","kind":12,"name":"positively_regulates_relationship"},{"line":536,"kind":13,"containerName":"get_predicate_terms","name":"$self"},{"line":536,"kind":12,"containerName":"get_predicate_terms","name":"negatively_regulates_relationship"},{"name":"$termname","localvar":"my","containerName":"get_predicate_terms","kind":13,"line":539,"definition":"my"},{"line":539,"name":"$self","kind":13,"containerName":"get_predicate_terms"}],"containerName":"main::","name":"get_predicate_terms"},{"name":"@a","kind":13,"containerName":null,"line":540},{"line":540,"name":"%self","kind":13,"containerName":null},{"line":540,"name":"$termname","kind":13,"containerName":null},{"line":543,"kind":13,"containerName":null,"name":"@a"},{"signature":{"label":"get_child_terms($self,$term,@types)","documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@types"}]},"range":{"start":{"character":0,"line":565},"end":{"line":570,"character":9999}},"kind":12,"line":565,"detail":"($self,$term,@types)","definition":"sub","name":"get_child_terms","containerName":"main::","children":[{"definition":"my","containerName":"get_child_terms","localvar":"my","kind":13,"name":"$self","line":566},{"line":566,"kind":13,"containerName":"get_child_terms","name":"$term"},{"line":566,"name":"@types","kind":13,"containerName":"get_child_terms"},{"name":"$self","containerName":"get_child_terms","kind":13,"line":568},{"kind":12,"containerName":"get_child_terms","name":"_get_child_parent_terms_helper","line":568},{"line":568,"name":"$term","kind":13,"containerName":"get_child_terms"},{"containerName":"get_child_terms","kind":13,"name":"@types","line":568}]},{"kind":12,"name":"TRUE","line":568},{"range":{"start":{"line":589,"character":0},"end":{"line":609,"character":9999}},"kind":12,"line":589,"signature":{"label":"get_descendant_terms($self,$term,@types)","documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@types"}]},"containerName":"main::","name":"get_descendant_terms","children":[{"definition":"my","line":590,"name":"$self","localvar":"my","containerName":"get_descendant_terms","kind":13},{"line":590,"name":"$term","kind":13,"containerName":"get_descendant_terms"},{"containerName":"get_descendant_terms","kind":13,"name":"@types","line":590},{"line":592,"name":"%ids","localvar":"my","containerName":"get_descendant_terms","kind":13,"definition":"my"},{"localvar":"my","kind":13,"containerName":"get_descendant_terms","name":"@ids","line":593,"definition":"my"},{"line":595,"containerName":"get_descendant_terms","kind":13,"name":"$term"},{"name":"$self","kind":13,"containerName":"get_descendant_terms","line":595},{"kind":12,"containerName":"get_descendant_terms","name":"_get_id","line":595},{"kind":13,"containerName":"get_descendant_terms","name":"$term","line":595},{"name":"$self","kind":13,"containerName":"get_descendant_terms","line":597},{"line":597,"kind":12,"containerName":"get_descendant_terms","name":"graph"},{"kind":12,"containerName":"get_descendant_terms","name":"has_vertex","line":597},{"name":"$term","kind":13,"containerName":"get_descendant_terms","line":597},{"kind":13,"containerName":"get_descendant_terms","name":"$self","line":598},{"line":598,"name":"throw","containerName":"get_descendant_terms","kind":12},{"line":601,"name":"$self","kind":13,"containerName":"get_descendant_terms"},{"line":601,"kind":12,"containerName":"get_descendant_terms","name":"_get_descendant_terms_helper"},{"line":601,"containerName":"get_descendant_terms","kind":13,"name":"$term"},{"kind":13,"containerName":"get_descendant_terms","name":"%ids","line":601},{"kind":13,"containerName":"get_descendant_terms","name":"@types","line":601},{"name":"$id","localvar":"my","kind":13,"containerName":"get_descendant_terms","line":603,"definition":"my"},{"kind":13,"containerName":"get_descendant_terms","name":"%ids","line":603},{"kind":13,"containerName":"get_descendant_terms","name":"@ids","line":604},{"kind":13,"containerName":"get_descendant_terms","name":"$id","line":604},{"line":607,"containerName":"get_descendant_terms","kind":13,"name":"$self"},{"kind":12,"containerName":"get_descendant_terms","name":"get_terms","line":607},{"name":"@ids","kind":13,"containerName":"get_descendant_terms","line":607}],"detail":"($self,$term,@types)","definition":"sub"},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"get_parent_terms","name":"$self","line":629},{"line":629,"kind":13,"containerName":"get_parent_terms","name":"$term"},{"name":"@types","containerName":"get_parent_terms","kind":13,"line":629},{"containerName":"get_parent_terms","kind":13,"name":"$self","line":631},{"line":631,"kind":12,"containerName":"get_parent_terms","name":"_get_child_parent_terms_helper"},{"name":"$term","containerName":"get_parent_terms","kind":13,"line":631},{"line":631,"name":"@types","containerName":"get_parent_terms","kind":13}],"name":"get_parent_terms","containerName":"main::","definition":"sub","detail":"($self,$term,@types)","line":628,"range":{"start":{"line":628,"character":0},"end":{"character":9999,"line":633}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"@types"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned","label":"get_parent_terms($self,$term,@types)"}},{"name":"FALSE","kind":12,"line":631},{"range":{"start":{"character":0,"line":653},"end":{"character":9999,"line":673}},"kind":12,"line":653,"signature":{"label":"get_ancestor_terms($self,$term,@types)","documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned","parameters":[{"label":"$self"},{"label":"$term"},{"label":"@types"}]},"name":"get_ancestor_terms","containerName":"main::","children":[{"containerName":"get_ancestor_terms","localvar":"my","kind":13,"name":"$self","line":654,"definition":"my"},{"line":654,"containerName":"get_ancestor_terms","kind":13,"name":"$term"},{"line":654,"name":"@types","containerName":"get_ancestor_terms","kind":13},{"line":656,"kind":13,"localvar":"my","containerName":"get_ancestor_terms","name":"%ids","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"get_ancestor_terms","name":"@ids","line":657},{"line":659,"name":"$term","containerName":"get_ancestor_terms","kind":13},{"name":"$self","containerName":"get_ancestor_terms","kind":13,"line":659},{"line":659,"name":"_get_id","kind":12,"containerName":"get_ancestor_terms"},{"line":659,"containerName":"get_ancestor_terms","kind":13,"name":"$term"},{"line":661,"name":"$self","containerName":"get_ancestor_terms","kind":13},{"name":"graph","containerName":"get_ancestor_terms","kind":12,"line":661},{"name":"has_vertex","containerName":"get_ancestor_terms","kind":12,"line":661},{"name":"$term","kind":13,"containerName":"get_ancestor_terms","line":661},{"name":"$self","kind":13,"containerName":"get_ancestor_terms","line":662},{"line":662,"containerName":"get_ancestor_terms","kind":12,"name":"throw"},{"name":"$self","kind":13,"containerName":"get_ancestor_terms","line":665},{"line":665,"containerName":"get_ancestor_terms","kind":12,"name":"_get_ancestor_terms_helper"},{"kind":13,"containerName":"get_ancestor_terms","name":"$term","line":665},{"name":"%ids","containerName":"get_ancestor_terms","kind":13,"line":665},{"containerName":"get_ancestor_terms","kind":13,"name":"@types","line":665},{"definition":"my","localvar":"my","containerName":"get_ancestor_terms","kind":13,"name":"$id","line":667},{"line":667,"name":"%ids","kind":13,"containerName":"get_ancestor_terms"},{"kind":13,"containerName":"get_ancestor_terms","name":"@ids","line":668},{"name":"$id","containerName":"get_ancestor_terms","kind":13,"line":668},{"line":671,"containerName":"get_ancestor_terms","kind":13,"name":"$self"},{"line":671,"containerName":"get_ancestor_terms","kind":12,"name":"get_terms"},{"kind":13,"containerName":"get_ancestor_terms","name":"@ids","line":671}],"detail":"($self,$term,@types)","definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":689},"end":{"line":696,"character":9999}},"line":689,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :","label":"get_leaf_terms($self)"},"name":"get_leaf_terms","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"get_leaf_terms","line":690,"definition":"my"},{"definition":"my","line":692,"name":"@a","localvar":"my","kind":13,"containerName":"get_leaf_terms"},{"kind":13,"containerName":"get_leaf_terms","name":"$self","line":692},{"line":692,"name":"graph","kind":12,"containerName":"get_leaf_terms"},{"line":692,"name":"sink_vertices","kind":12,"containerName":"get_leaf_terms"},{"name":"$self","containerName":"get_leaf_terms","kind":13,"line":694},{"name":"get_terms","kind":12,"containerName":"get_leaf_terms","line":694},{"line":694,"containerName":"get_leaf_terms","kind":13,"name":"@a"}],"detail":"($self)","definition":"sub"},{"line":710,"kind":12,"range":{"end":{"line":718,"character":9999},"start":{"character":0,"line":710}},"signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :","parameters":[{"label":"$self"}],"label":"get_root_terms($self)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_root_terms","name":"$self","line":711},{"definition":"my","name":"@a","localvar":"my","kind":13,"containerName":"get_root_terms","line":714},{"containerName":"get_root_terms","kind":13,"name":"$self","line":714},{"name":"graph","kind":12,"containerName":"get_root_terms","line":714},{"kind":12,"containerName":"get_root_terms","name":"source_vertices","line":714},{"containerName":"get_root_terms","kind":13,"name":"$self","line":716},{"name":"get_terms","kind":12,"containerName":"get_root_terms","line":716},{"kind":13,"containerName":"get_root_terms","name":"@a","line":716}],"containerName":"main::","name":"get_root_terms","definition":"sub","detail":"($self)"},{"signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_root_terms {\n    my ( $self ) = @_;\n\n\n    my @a = $self->graph()->source_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n=head2 get_terms\n\n Title   : get_terms\n Usage   : @terms = $engine->get_terms( \"GO:1234567\", \"GO:2234567\" );\n Function: Returns term objects with given identifiers\n Returns : Bio::Ontology::TermI, or the term corresponding to the\n           first identifier if called in scalar context\n Args    : term ids","parameters":[{"label":"$self"},{"label":"@ids"}],"label":"get_terms($self,@ids)"},"line":732,"kind":12,"range":{"end":{"line":745,"character":9999},"start":{"line":732,"character":0}},"definition":"sub","detail":"($self,@ids)","children":[{"line":733,"name":"$self","containerName":"get_terms","localvar":"my","kind":13,"definition":"my"},{"name":"@ids","containerName":"get_terms","kind":13,"line":733},{"definition":"my","line":735,"name":"@terms","localvar":"my","containerName":"get_terms","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"get_terms","name":"$id","line":737},{"line":737,"containerName":"get_terms","kind":13,"name":"@ids"},{"kind":13,"containerName":"get_terms","name":"$self","line":738},{"kind":12,"containerName":"get_terms","name":"graph","line":738},{"line":738,"kind":12,"containerName":"get_terms","name":"has_vertex"},{"name":"$id","containerName":"get_terms","kind":13,"line":738},{"line":739,"name":"@terms","containerName":"get_terms","kind":13},{"line":739,"containerName":"get_terms","kind":13,"name":"$self"},{"line":739,"kind":12,"containerName":"get_terms","name":"graph"},{"containerName":"get_terms","kind":12,"name":"get_vertex_attribute","line":739},{"name":"$id","kind":13,"containerName":"get_terms","line":739},{"line":743,"kind":13,"containerName":"get_terms","name":"@terms"},{"line":743,"kind":13,"containerName":"get_terms","name":"@terms"}],"containerName":"main::","name":"get_terms"},{"kind":12,"name":"TERM","line":739},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_all_terms","name":"$self","line":759},{"line":761,"name":"$self","containerName":"get_all_terms","kind":13},{"name":"get_terms","kind":12,"containerName":"get_all_terms","line":761},{"kind":13,"containerName":"get_all_terms","name":"$self","line":761},{"line":761,"name":"graph","kind":12,"containerName":"get_all_terms"},{"kind":12,"containerName":"get_all_terms","name":"vertices","line":761}],"containerName":"main::","name":"get_all_terms","definition":"sub","detail":"($self)","line":758,"range":{"end":{"line":763,"character":9999},"start":{"character":0,"line":758}},"kind":12,"signature":{"label":"get_all_terms($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_root_terms {\n    my ( $self ) = @_;\n\n\n    my @a = $self->graph()->source_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n=head2 get_terms\n\n Title   : get_terms\n Usage   : @terms = $engine->get_terms( \"GO:1234567\", \"GO:2234567\" );\n Function: Returns term objects with given identifiers\n Returns : Bio::Ontology::TermI, or the term corresponding to the\n           first identifier if called in scalar context\n Args    : term ids\n\n\nsub get_terms {\n    my ( $self, @ids ) = @_;\n\n    my @terms = ();\n\n    foreach my $id ( @ids ) {\n        if ( $self->graph()->has_vertex( $id ) ) {\n          push( @terms, $self->graph()->get_vertex_attribute( $id, TERM ) ); # NG 05-02-16\n        }\n    }\n\n    return wantarray ? @terms : shift(@terms);\n\n} # get_terms\n\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : $engine->get_all_terms();\n Function: Returns all terms in this engine\n Returns : Bio::Ontology::TermI\n Args    :"}},{"containerName":"main::","name":"find_terms","children":[{"containerName":"find_terms","localvar":"my","kind":13,"name":"$self","line":786,"definition":"my"},{"name":"@args","containerName":"find_terms","kind":13,"line":786},{"line":787,"name":"@terms","kind":13,"localvar":"my","containerName":"find_terms","definition":"my"},{"name":"$id","localvar":"my","containerName":"find_terms","kind":13,"line":789,"definition":"my"},{"line":789,"kind":13,"containerName":"find_terms","name":"$name"},{"line":789,"containerName":"find_terms","kind":13,"name":"$self"},{"kind":12,"containerName":"find_terms","name":"_rearrange","line":789},{"containerName":"find_terms","kind":13,"name":"@args","line":789},{"kind":13,"containerName":"find_terms","name":"$id","line":791},{"line":792,"name":"@terms","containerName":"find_terms","kind":13},{"name":"$self","containerName":"find_terms","kind":13,"line":792},{"containerName":"find_terms","kind":12,"name":"get_terms","line":792},{"line":792,"containerName":"find_terms","kind":13,"name":"$id"},{"line":794,"kind":13,"containerName":"find_terms","name":"@terms"},{"line":794,"name":"$self","containerName":"find_terms","kind":13},{"line":794,"containerName":"find_terms","kind":12,"name":"get_all_terms"},{"name":"$name","containerName":"find_terms","kind":13,"line":796},{"line":797,"name":"@terms","kind":13,"containerName":"find_terms"},{"line":797,"name":"name","containerName":"find_terms","kind":12},{"line":797,"name":"$name","containerName":"find_terms","kind":13},{"line":797,"name":"@terms","containerName":"find_terms","kind":13},{"containerName":"find_terms","kind":13,"name":"@terms","line":799}],"detail":"($self,@args)","definition":"sub","range":{"end":{"character":9999,"line":800},"start":{"line":785,"character":0}},"kind":12,"line":785,"signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_root_terms {\n    my ( $self ) = @_;\n\n\n    my @a = $self->graph()->source_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n=head2 get_terms\n\n Title   : get_terms\n Usage   : @terms = $engine->get_terms( \"GO:1234567\", \"GO:2234567\" );\n Function: Returns term objects with given identifiers\n Returns : Bio::Ontology::TermI, or the term corresponding to the\n           first identifier if called in scalar context\n Args    : term ids\n\n\nsub get_terms {\n    my ( $self, @ids ) = @_;\n\n    my @terms = ();\n\n    foreach my $id ( @ids ) {\n        if ( $self->graph()->has_vertex( $id ) ) {\n          push( @terms, $self->graph()->get_vertex_attribute( $id, TERM ) ); # NG 05-02-16\n        }\n    }\n\n    return wantarray ? @terms : shift(@terms);\n\n} # get_terms\n\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : $engine->get_all_terms();\n Function: Returns all terms in this engine\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_all_terms {\n    my ( $self ) = @_;\n\n    return( $self->get_terms( $self->graph()->vertices() ) );\n\n} # get_all_terms\n\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name","parameters":[{"label":"$self"},{"label":"@args"}],"label":"find_terms($self,@args)"}},{"containerName":"main::","name":"find_identically_named_terms","children":[{"definition":"my","containerName":"find_identically_named_terms","localvar":"my","kind":13,"name":"$self","line":816},{"kind":13,"containerName":"find_identically_named_terms","name":"$qterm","line":816},{"line":817,"kind":13,"containerName":"find_identically_named_terms","name":"$self"},{"line":817,"name":"throw","containerName":"find_identically_named_terms","kind":12},{"name":"$qterm","kind":13,"containerName":"find_identically_named_terms","line":818},{"line":818,"kind":13,"containerName":"find_identically_named_terms","name":"$qterm"},{"name":"isa","kind":12,"containerName":"find_identically_named_terms","line":818},{"line":820,"name":"%matching_terms","kind":13,"localvar":"my","containerName":"find_identically_named_terms","definition":"my"},{"definition":"my","line":822,"containerName":"find_identically_named_terms","localvar":"my","kind":13,"name":"$term"},{"line":822,"name":"$self","containerName":"find_identically_named_terms","kind":13},{"name":"get_all_terms","kind":12,"containerName":"find_identically_named_terms","line":822},{"name":"$matching_terms","containerName":"find_identically_named_terms","kind":13,"line":823},{"name":"$term","containerName":"find_identically_named_terms","kind":13,"line":823},{"line":823,"name":"identifier","kind":12,"containerName":"find_identically_named_terms"},{"kind":13,"containerName":"find_identically_named_terms","name":"$term","line":823},{"containerName":"find_identically_named_terms","kind":13,"name":"$term","line":824},{"line":824,"name":"name","kind":12,"containerName":"find_identically_named_terms"},{"name":"$qterm","kind":13,"containerName":"find_identically_named_terms","line":824},{"name":"name","kind":12,"containerName":"find_identically_named_terms","line":824},{"name":"%matching_terms","containerName":"find_identically_named_terms","kind":13,"line":826}],"detail":"($self,$qterm)","definition":"sub","range":{"start":{"line":815,"character":0},"end":{"line":827,"character":9999}},"kind":12,"line":815,"signature":{"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_root_terms {\n    my ( $self ) = @_;\n\n\n    my @a = $self->graph()->source_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n=head2 get_terms\n\n Title   : get_terms\n Usage   : @terms = $engine->get_terms( \"GO:1234567\", \"GO:2234567\" );\n Function: Returns term objects with given identifiers\n Returns : Bio::Ontology::TermI, or the term corresponding to the\n           first identifier if called in scalar context\n Args    : term ids\n\n\nsub get_terms {\n    my ( $self, @ids ) = @_;\n\n    my @terms = ();\n\n    foreach my $id ( @ids ) {\n        if ( $self->graph()->has_vertex( $id ) ) {\n          push( @terms, $self->graph()->get_vertex_attribute( $id, TERM ) ); # NG 05-02-16\n        }\n    }\n\n    return wantarray ? @terms : shift(@terms);\n\n} # get_terms\n\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : $engine->get_all_terms();\n Function: Returns all terms in this engine\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_all_terms {\n    my ( $self ) = @_;\n\n    return( $self->get_terms( $self->graph()->vertices() ) );\n\n} # get_all_terms\n\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n        @terms = $self->get_terms($id);\n    } else {\n        @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n        @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 find_identically_named_terms\n\n Title   : find_identically_named_terms\n Usage   : ($term) = $oe->find_identically_named_terms($term0);\n Function: Find term instances where names match the query term\n           name exactly\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object","parameters":[{"label":"$self"},{"label":"$qterm"}],"label":"find_identically_named_terms($self,$qterm)"}},{"containerName":"main::","name":"find_identical_terms","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"find_identical_terms","line":843},{"containerName":"find_identical_terms","kind":13,"name":"$qterm","line":843},{"name":"$self","kind":13,"containerName":"find_identical_terms","line":844},{"kind":12,"containerName":"find_identical_terms","name":"throw","line":844},{"line":845,"name":"$qterm","containerName":"find_identical_terms","kind":13},{"line":845,"kind":13,"containerName":"find_identical_terms","name":"$qterm"},{"line":845,"name":"isa","containerName":"find_identical_terms","kind":12},{"localvar":"my","containerName":"find_identical_terms","kind":13,"name":"%matching_terms","line":847,"definition":"my"},{"definition":"my","line":849,"localvar":"my","kind":13,"containerName":"find_identical_terms","name":"$qstring"},{"line":849,"containerName":"find_identical_terms","kind":13,"name":"$qterm"},{"line":849,"name":"name","containerName":"find_identical_terms","kind":12},{"line":849,"containerName":"find_identical_terms","kind":13,"name":"$qterm"},{"containerName":"find_identical_terms","kind":12,"name":"each_synonym","line":849},{"containerName":"find_identical_terms","localvar":"my","kind":13,"name":"$term","line":850,"definition":"my"},{"name":"$self","kind":13,"containerName":"find_identical_terms","line":850},{"line":850,"kind":12,"containerName":"find_identical_terms","name":"get_all_terms"},{"definition":"my","localvar":"my","containerName":"find_identical_terms","kind":13,"name":"$string","line":851},{"line":851,"name":"$term","kind":13,"containerName":"find_identical_terms"},{"line":851,"name":"name","kind":12,"containerName":"find_identical_terms"},{"line":851,"containerName":"find_identical_terms","kind":13,"name":"$term"},{"containerName":"find_identical_terms","kind":12,"name":"each_synonym","line":851},{"line":852,"containerName":"find_identical_terms","kind":13,"name":"$matching_terms"},{"line":852,"containerName":"find_identical_terms","kind":13,"name":"$term"},{"line":852,"kind":12,"containerName":"find_identical_terms","name":"identifier"},{"kind":13,"containerName":"find_identical_terms","name":"$term","line":852},{"containerName":"find_identical_terms","kind":13,"name":"$string","line":853},{"name":"$qstring","containerName":"find_identical_terms","kind":13,"line":853},{"line":857,"name":"%matching_terms","containerName":"find_identical_terms","kind":13}],"detail":"($self,$qterm)","definition":"sub","range":{"start":{"character":0,"line":842},"end":{"character":9999,"line":858}},"kind":12,"line":842,"signature":{"label":"find_identical_terms($self,$qterm)","documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_root_terms {\n    my ( $self ) = @_;\n\n\n    my @a = $self->graph()->source_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n=head2 get_terms\n\n Title   : get_terms\n Usage   : @terms = $engine->get_terms( \"GO:1234567\", \"GO:2234567\" );\n Function: Returns term objects with given identifiers\n Returns : Bio::Ontology::TermI, or the term corresponding to the\n           first identifier if called in scalar context\n Args    : term ids\n\n\nsub get_terms {\n    my ( $self, @ids ) = @_;\n\n    my @terms = ();\n\n    foreach my $id ( @ids ) {\n        if ( $self->graph()->has_vertex( $id ) ) {\n          push( @terms, $self->graph()->get_vertex_attribute( $id, TERM ) ); # NG 05-02-16\n        }\n    }\n\n    return wantarray ? @terms : shift(@terms);\n\n} # get_terms\n\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : $engine->get_all_terms();\n Function: Returns all terms in this engine\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_all_terms {\n    my ( $self ) = @_;\n\n    return( $self->get_terms( $self->graph()->vertices() ) );\n\n} # get_all_terms\n\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n        @terms = $self->get_terms($id);\n    } else {\n        @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n        @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 find_identically_named_terms\n\n Title   : find_identically_named_terms\n Usage   : ($term) = $oe->find_identically_named_terms($term0);\n Function: Find term instances where names match the query term\n           name exactly\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object\n\n\nsub find_identically_named_terms{\n    my ($self,$qterm) = @_;\n    $self->throw(\"Argument doesn't implement Bio::Ontology::TermI. \" . \"Bummer.\" )\n        unless defined $qterm and $qterm->isa(\"Bio::Ontology::TermI\");\n\n    my %matching_terms;\n\n    foreach my $term ($self->get_all_terms) {\n        $matching_terms{$term->identifier} = $term and next\n            if $term->name eq $qterm->name;\n    }\n    return values %matching_terms;\n}\n\n\n=head2 find_identical_terms\n\n Title   : find_identical_terms\n Usage   : ($term) = $oe->find_identical_terms($term0);\n Function: Find term instances where name or synonym\n           matches the query exactly\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object","parameters":[{"label":"$self"},{"label":"$qterm"}]}},{"definition":"sub","detail":"($self,$qterm)","children":[{"line":873,"name":"$self","localvar":"my","kind":13,"containerName":"find_similar_terms","definition":"my"},{"line":873,"name":"$qterm","containerName":"find_similar_terms","kind":13},{"line":874,"name":"$self","containerName":"find_similar_terms","kind":13},{"line":874,"name":"throw","kind":12,"containerName":"find_similar_terms"},{"line":875,"kind":13,"containerName":"find_similar_terms","name":"$qterm"},{"line":875,"name":"$qterm","kind":13,"containerName":"find_similar_terms"},{"line":875,"kind":12,"containerName":"find_similar_terms","name":"isa"},{"name":"%matching_terms","kind":13,"localvar":"my","containerName":"find_similar_terms","line":877,"definition":"my"},{"containerName":"find_similar_terms","localvar":"my","kind":13,"name":"$qstring","line":879,"definition":"my"},{"line":879,"containerName":"find_similar_terms","kind":13,"name":"$qterm"},{"name":"name","kind":12,"containerName":"find_similar_terms","line":879},{"containerName":"find_similar_terms","kind":13,"name":"$qterm","line":879},{"line":879,"kind":12,"containerName":"find_similar_terms","name":"each_synonym"},{"name":"$term","containerName":"find_similar_terms","localvar":"my","kind":13,"line":880,"definition":"my"},{"line":880,"kind":13,"containerName":"find_similar_terms","name":"$self"},{"name":"get_all_terms","kind":12,"containerName":"find_similar_terms","line":880},{"definition":"my","line":882,"localvar":"my","kind":13,"containerName":"find_similar_terms","name":"$string"},{"line":882,"name":"$term","containerName":"find_similar_terms","kind":13},{"name":"name","kind":12,"containerName":"find_similar_terms","line":882},{"kind":13,"containerName":"find_similar_terms","name":"$term","line":882},{"line":882,"name":"each_synonym","containerName":"find_similar_terms","kind":12},{"line":883,"name":"$matching_terms","kind":13,"containerName":"find_similar_terms"},{"kind":13,"containerName":"find_similar_terms","name":"$term","line":883},{"line":883,"name":"identifier","kind":12,"containerName":"find_similar_terms"},{"line":883,"name":"$term","kind":13,"containerName":"find_similar_terms"},{"line":884,"containerName":"find_similar_terms","kind":13,"name":"$string"},{"name":"$qstring","kind":13,"containerName":"find_similar_terms","line":884},{"name":"%matching_terms","kind":13,"containerName":"find_similar_terms","line":888}],"containerName":"main::","name":"find_similar_terms","signature":{"label":"find_similar_terms($self,$qterm)","parameters":[{"label":"$self"},{"label":"$qterm"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_root_terms {\n    my ( $self ) = @_;\n\n\n    my @a = $self->graph()->source_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n=head2 get_terms\n\n Title   : get_terms\n Usage   : @terms = $engine->get_terms( \"GO:1234567\", \"GO:2234567\" );\n Function: Returns term objects with given identifiers\n Returns : Bio::Ontology::TermI, or the term corresponding to the\n           first identifier if called in scalar context\n Args    : term ids\n\n\nsub get_terms {\n    my ( $self, @ids ) = @_;\n\n    my @terms = ();\n\n    foreach my $id ( @ids ) {\n        if ( $self->graph()->has_vertex( $id ) ) {\n          push( @terms, $self->graph()->get_vertex_attribute( $id, TERM ) ); # NG 05-02-16\n        }\n    }\n\n    return wantarray ? @terms : shift(@terms);\n\n} # get_terms\n\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : $engine->get_all_terms();\n Function: Returns all terms in this engine\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_all_terms {\n    my ( $self ) = @_;\n\n    return( $self->get_terms( $self->graph()->vertices() ) );\n\n} # get_all_terms\n\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n        @terms = $self->get_terms($id);\n    } else {\n        @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n        @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 find_identically_named_terms\n\n Title   : find_identically_named_terms\n Usage   : ($term) = $oe->find_identically_named_terms($term0);\n Function: Find term instances where names match the query term\n           name exactly\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object\n\n\nsub find_identically_named_terms{\n    my ($self,$qterm) = @_;\n    $self->throw(\"Argument doesn't implement Bio::Ontology::TermI. \" . \"Bummer.\" )\n        unless defined $qterm and $qterm->isa(\"Bio::Ontology::TermI\");\n\n    my %matching_terms;\n\n    foreach my $term ($self->get_all_terms) {\n        $matching_terms{$term->identifier} = $term and next\n            if $term->name eq $qterm->name;\n    }\n    return values %matching_terms;\n}\n\n\n=head2 find_identical_terms\n\n Title   : find_identical_terms\n Usage   : ($term) = $oe->find_identical_terms($term0);\n Function: Find term instances where name or synonym\n           matches the query exactly\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object\n\n\nsub find_identical_terms{\n    my ($self,$qterm) = @_;\n    $self->throw(\"Argument doesn't implement Bio::Ontology::TermI. \" . \"Bummer.\" )\n        unless defined $qterm and $qterm->isa(\"Bio::Ontology::TermI\");\n\n    my %matching_terms;\n\n    foreach my $qstring ($qterm->name, $qterm->each_synonym) {\n        foreach my $term ($self->get_all_terms) {\n            foreach my $string ( $term->name, $term->each_synonym() ) {\n                $matching_terms{$term->identifier} = $term and next\n                    if $string eq $qstring;\n            }\n        }\n    }\n    return values %matching_terms;\n}\n\n=head2 find_similar_terms\n\n Title   : find_similar_terms\n Usage   : ($term) = $oe->find_similar_terms($term0);\n Function: Find term instances where name or synonym, or part of one,\n           matches the query.\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object"},"line":872,"kind":12,"range":{"start":{"line":872,"character":0},"end":{"character":9999,"line":889}}},{"definition":"sub","children":[{"containerName":"relationship_factory","localvar":"my","kind":13,"name":"$self","line":907,"definition":"my"},{"name":"$self","containerName":"relationship_factory","kind":13,"line":909},{"line":910,"containerName":"relationship_factory","kind":13,"name":"$self"}],"name":"relationship_factory","containerName":"main::","line":906,"kind":12,"range":{"end":{"line":911,"character":9999},"start":{"character":0,"line":906}}},{"line":931,"range":{"end":{"character":9999,"line":940},"start":{"character":0,"line":931}},"kind":12,"children":[{"localvar":"my","kind":13,"containerName":"term_factory","name":"$self","line":932,"definition":"my"},{"name":"$self","kind":13,"containerName":"term_factory","line":935},{"line":935,"kind":12,"containerName":"term_factory","name":"warn"},{"name":"$self","containerName":"term_factory","kind":13,"line":935},{"name":"$self","containerName":"term_factory","kind":13,"line":937},{"line":939,"name":"$self","containerName":"term_factory","kind":13}],"containerName":"main::","name":"term_factory","definition":"sub"},{"definition":"sub","detail":"($self,$value)","children":[{"line":953,"name":"$self","localvar":"my","containerName":"graph","kind":13,"definition":"my"},{"kind":13,"containerName":"graph","name":"$value","line":953},{"line":955,"kind":13,"containerName":"graph","name":"$value"},{"name":"$self","containerName":"graph","kind":13,"line":956},{"name":"_check_class","containerName":"graph","kind":12,"line":956},{"line":956,"containerName":"graph","kind":13,"name":"$value"},{"kind":13,"containerName":"graph","name":"$self","line":957},{"line":957,"containerName":"graph","kind":13,"name":"$value"},{"containerName":"graph","kind":13,"name":"$self","line":960}],"name":"graph","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OBOEngine.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::OBOEngine\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::OBOEngine - An Ontology Engine for OBO style flat file\nformat from the Gene Ontology Consortium\n\n=head1 SYNOPSIS\n\n  use Bio::Ontology::OBOEngine;\n\n  my $parser = Bio::Ontology::OBOEngine->new\n        ( -file => \"gene_ontology.obo\" );\n\n  my $engine = $parser->parse();\n\n=head1 DESCRIPTION\n\nNeeds Graph.pm from CPAN.\n\nThis module replaces SimpleGOEngine.pm, which is deprecated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSohel Merchant\n\nEmail: s-merchant@northwestern.edu\n\nAddress:\n\n  Northwestern University\n  Center for Genetic Medicine (CGM), dictyBase\n  Suite 1206,\n  676 St. Clair st\n  Chicago IL 60611\n\n=head2 CONTRIBUTOR\n\n Hilmar Lapp, hlapp at gmx.net\n Chris Mungall,   cjm at fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Ontology::OBOEngine;\n\nuse Bio::Ontology::SimpleGOEngine::GraphAdaptor;\n\nuse strict;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::RelationshipFactory;\nuse Data::Dumper;\n\nuse constant TRUE       => 1;\nuse constant FALSE      => 0;\nuse constant IS_A       => \"IS_A\";\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant TERM       => \"TERM\";\nuse constant TYPE       => \"TYPE\";\nuse constant ONTOLOGY   => \"ONTOLOGY\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Root::Root Bio::Ontology::OntologyEngineI);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $engine = Bio::Ontology::OBOEngine->new()\n Function: Creates a new OBOEngine\n Returns : A new OBOEngine object\n Args    :\n\n\nsub new {\n    my( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    $self->init();\n\n    return $self;\n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $engine->init();\n Function: Initializes this Engine.\n Returns :\n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n\n    $self->{ \"_is_a_relationship\" }       = Bio::Ontology::RelationshipType->get_instance( IS_A );\n    $self->{ \"_part_of_relationship\" }    = Bio::Ontology::RelationshipType->get_instance( PART_OF );\n    $self->{ \"_related_to_relationship\" } = Bio::Ontology::RelationshipType->get_instance( RELATED_TO );\n\n    $self->{'_regulates_relationship'} = Bio::Ontology::RelationshipType->get_instance(REGULATES);\n    $self->{'_positively_regulate'} = Bio::Ontology::RelationshipType->get_instance(POSITIVELY_REGULATES);\n    $self->{'_negatively_regulate'} = Bio::Ontology::RelationshipType->get_instance(NEGATIVELY_REGULATES);\n    \n\n    $self->graph( Bio::Ontology::SimpleGOEngine::GraphAdaptor->new() );        # NG 05-02-16\n\n    # set defaults for the factories\n    $self->relationship_factory(Bio::Ontology::RelationshipFactory->new(\n                                     -type => \"Bio::Ontology::Relationship\"));\n\n} # init\n\n\n\n=head2 is_a_relationship\n\n Title   : is_a_relationship()\n Usage   : $IS_A = $engine->is_a_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"is-a\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"IS_A\"\n Args    :\n\n\nsub is_a_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_is_a_relationship\" };\n} # is_a_relationship\n\n\n\n=head2 part_of_relationship\n\n Title   : part_of_relationship()\n Usage   : $PART_OF = $engine->part_of_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"part-of\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"PART_OF\"\n Args    :\n\n\nsub part_of_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_part_of_relationship\" };\n} # part_of_relationship\n\n\n=head2 related_to_relationship\n\n Title   : related_to_relationship()\n Usage   : $RELATED_TO = $engine->related_to_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"related-to\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"RELATED_TO\"\n Args    :\n\n\nsub related_to_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_related_to_relationship\" };\n} # related_to_relationship\n\n=head2 regulates_relationship\n\n Title   : regulates_relationship()\n Usage   : $REGULATES = $engine->regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"REGULATES\"\n Args    :\n\n\nsub regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_regulates_relationship\" };\n} # is_a_relationship\n\n=head2 positively_regulates_relationship\n\n Title   : positively_regulates_relationship()\n Usage   : $REGULATES = $engine->positively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"positively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub positively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_positively_regulate\" };\n} \n\n=head2 negatively_regulates_relationship\n\n Title   : negatively_regulates_relationship()\n Usage   : $REGULATES = $engine->negatively_regulates_relationship();\n Function: Returns a Bio::Ontology::RelationshipType object for \"negatively_regulates\"\n           relationships\n Returns : Bio::Ontology::RelationshipType set to \"POSITIVELY_REGULATES\"\n Args    :\n\n\nsub negatively_regulates_relationship {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->throw( \"Attempted to change immutable field\" );\n    }\n\n    return $self->{ \"_negatively_regulate\" };\n} \n\n\n=head2 add_term\n\n Title   : add_term\n Usage   : $engine->add_term( $term_obj );\n Function: Adds a Bio::Ontology::TermI to this engine\n Returns : true if the term was added and false otherwise (e.g., if the\n           term already existed in the ontology engine)\n Args    : Bio::Ontology::TermI\n\n\nsub add_term {\n    my ( $self, $term ) = @_;\n\n    return FALSE if $self->has_term( $term );\n\n    my $goid = $self->_get_id($term);\n\n    $self->graph()->add_vertex( $goid );\n    $self->graph()->set_vertex_attribute( $goid, TERM, $term );        # NG 05-02-16\n    return TRUE;\n\n} # add_term\n\n\n\n=head2 has_term\n\n Title   : has_term\n Usage   : $engine->has_term( $term );\n Function: Checks whether this engine contains a particular term\n Returns : true or false\n Args    : Bio::Ontology::TermI\n           or\n           Term identifier (e.g. \"GO:0012345\")\n\n\nsub has_term {\n    my ( $self, $term ) = @_;\n    $term = $self->_get_id( $term );\n    if ( $self->graph()->has_vertex( $term ) ) {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n\n} # has_term\n\n\n=head2 add_relationship_type\n\n Title   : add_relationship_type\n Usage   : $engine->add_relationship_type( $type_name, $ont );\n Function: Adds a new relationship type to the engine.  Use\n           get_relationship_type($type_name) to retrieve.\n Returns : true if successfully added, false otherwise\n Args    : relationship type name to add (scalar)\n           ontology to which to assign the relationship type\n\n\nsub add_relationship_type{\n   my ($self,@args) = @_;\n\n   if(scalar(@_) == 3){\n         my $type_name = $args[0];\n         my $ont = $args[1];\n         $self->{ \"_extra_relationship_types\" }{$type_name} = Bio::Ontology::RelationshipType->get_instance($type_name,$ont);\n#warn Dumper($self->{\"_extra_relationship_types\"}{$type_name});\n         return 1;\n   }\n   return 0;\n}\n\n\n=head2 get_relationship_type\n\n Title   : get_relationship_type\n Usage   : $engine->get_relationship_type( $type_name );\n Function: Gets a Bio::Ontology::RelationshipI object corresponding\n           to $type_name\n Returns : a Bio::Ontology::RelationshipI object\n Args    :\n\n\nsub get_relationship_type{\n   my ($self,$type_name) = @_;\n   return $self->{ \"_extra_relationship_types\" }{$type_name};\n}\n\n=head2 add_relationship\n\n Title   : add_relationship\n Usage   : $engine->add_relationship( $relationship );\n           $engine->add_relatioship( $subject_term, $predicate_term,\n                                     $object_term, $ontology );\n           $engine->add_relatioship( $subject_id, $predicate_id,\n                                     $object_id, $ontology);\n Function: Adds a relationship to this engine\n Returns : true if successfully added, false otherwise\n Args    : The relationship in one of three ways:\n\n             a) subject (or child) term id, Bio::Ontology::TermI\n                (rel.type), object (or parent) term id, ontology\n\n           or\n\n             b) subject Bio::Ontology::TermI, predicate\n                Bio::Ontology::TermI (rel.type), object\n                Bio::Ontology::TermI, ontology\n\n           or\n\n             c) Bio::Ontology::RelationshipI-compliant object\n\n\n# term objs or term ids\nsub add_relationship {\n    my ( $self, $child, $type, $parent, $ont ) = @_;\n\n    if ( scalar( @_ ) == 2 ) {\n        $self->_check_class( $child, \"Bio::Ontology::RelationshipI\" );\n        $type   = $child->predicate_term();\n        $parent = $child->object_term();\n        $ont    = $child->ontology();\n        $child  = $child->subject_term();\n    }\n\n\n    $self->_check_class( $type, \"Bio::Ontology::TermI\" );\n\n    my $parentid = $self->_get_id( $parent );\n    my $childid = $self->_get_id( $child );\n\n    my $g = $self->graph();\n\n    $self->add_term($child) unless $g->has_vertex( $childid );\n    $self->add_term($parent) unless $g->has_vertex( $parentid );\n\n    # This prevents multi graphs.\n    if ( $g->has_edge( $parentid, $childid ) ) {\n        return FALSE;\n    }\n\n    $g->add_edge( $parentid, $childid );\n    $g->set_edge_attribute( $parentid, $childid, TYPE, $type );           # NG 05-02-16\n    $g->set_edge_attribute( $parentid, $childid, ONTOLOGY, $ont ); # NG 05-02-16\n\n    return TRUE;\n\n} # add_relationship\n\n\n\n\n=head2 get_relationships\n\n\n Title   : get_relationships\n Usage   : $engine->get_relationships( $term );\n Function: Returns all relationships of a term, or all relationships in\n           the graph if no term is specified.\n Returns : Relationship\n Args    : term id\n           or\n           Bio::Ontology::TermI\n\n\nsub get_relationships {\n    my ( $self, $term ) = @_;\n\n    my $g = $self->graph();\n\n    # obtain the ID if term provided\n    my $termid;\n    if($term) {\n        $termid = $self->_get_id( $term );\n        # check for presence in the graph\n        if ( ! $g->has_vertex( $termid ) ) {\n            $self->throw( \"no term with identifier \\\"$termid\\\" in ontology\" );\n        }\n    }\n\n    # now build the relationships\n    my $relfact = $self->relationship_factory();\n    # we'll build the relationships from edges\n    my @rels = ();\n    my @edges = $termid ? $g->edges_at( $termid ) : $g->edges(); # NG 05-02-13\n    while(@edges) {\n      my ( $startid, $endid ) = @{ shift @edges }; # NG 05-02-16\n      my $rel = $relfact->create_object\n        (-subject_term   => $self->get_terms($endid),\n         -object_term    => $self->get_terms($startid),\n         -predicate_term => $g->get_edge_attribute($startid, $endid, TYPE),\n         -ontology       => $g->get_edge_attribute($startid, $endid, ONTOLOGY));\n      push( @rels, $rel );\n\n    }\n\n    return @rels;\n\n} # get_relationships\n\n=head2 get_all_relationships\n\n\n Title   : get_all_relationships\n Usage   : @rels = $engine->get_all_relationships();\n Function: Returns all relationships in the graph.\n Returns : Relationship\n Args    :\n\n\nsub get_all_relationships {\n    return shift->get_relationships(@_);\n} # get_all_relationships\n\n\n\n=head2 get_predicate_terms\n\n Title   : get_predicate_terms\n Usage   : $engine->get_predicate_terms();\n Function: Returns the types of relationships this engine contains\n Returns : Bio::Ontology::RelationshipType\n Args    :\n\n\nsub get_predicate_terms {\n    my ( $self ) = @_;\n\n    my @a = (\n            $self->is_a_relationship(),\n            $self->part_of_relationship(),\n            $self->related_to_relationship(),\n            $self->regulates_relationship(),\n            $self->positively_regulates_relationship(),\n            $self->negatively_regulates_relationship(),\n           );\n\n    foreach my $termname (keys %{$self->{ \"_extra_relationship_types\" }}){\n      push @a, $self->{ \"_extra_relationship_types\" }{ $termname };\n    }\n\n    return @a;\n} # get_predicate_terms\n\n\n\n\n=head2 get_child_terms\n\n Title   : get_child_terms\n Usage   : $engine->get_child_terms( $term_obj, @rel_types );\n           $engine->get_child_terms( $term_id, @rel_types );\n Function: Returns the children of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated: children\n           of ALL types are returned\n\n\nsub get_child_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, TRUE, @types );\n\n} # get_child_terms\n\n\n=head2 get_descendant_terms\n\n Title   : get_descendant_terms\n Usage   : $engine->get_descendant_terms( $term_obj, @rel_types );\n           $engine->get_descendant_terms( $term_id, @rel_types );\n Function: Returns the descendants of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           descendants of ALL types are returned\n\n\nsub get_descendant_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_descendant_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_descendant_terms\n\n\n=head2 get_parent_terms\n\n Title   : get_parent_terms\n Usage   : $engine->get_parent_terms( $term_obj, @rel_types );\n           $engine->get_parent_terms( $term_id, @rel_types );\n Function: Returns the parents of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           parents of ALL types are returned\n\n\nsub get_parent_terms {\n    my ( $self, $term, @types ) = @_;\n\n    return $self->_get_child_parent_terms_helper( $term, FALSE, @types );\n\n} # get_parent_terms\n\n\n\n=head2 get_ancestor_terms\n\n Title   : get_ancestor_terms\n Usage   : $engine->get_ancestor_terms( $term_obj, @rel_types );\n           $engine->get_ancestor_terms( $term_id, @rel_types );\n Function: Returns the ancestors of this term\n Returns : Bio::Ontology::TermI\n Args    : Bio::Ontology::TermI, Bio::Ontology::RelationshipType\n           or\n           term id, Bio::Ontology::RelationshipType\n\n           if NO Bio::Ontology::RelationshipType is indicated:\n           ancestors of ALL types are returned\n\n\nsub get_ancestor_terms {\n    my ( $self, $term, @types ) = @_;\n\n    my %ids = ();\n    my @ids = ();\n\n    $term = $self->_get_id( $term );\n\n    if ( ! $self->graph()->has_vertex( $term ) ) {\n        $self->throw( \"Ontology does not contain a term with an identifier of \\\"$term\\\"\" );\n    }\n\n    $self->_get_ancestor_terms_helper( $term, \\%ids, \\@types );\n\n    while( ( my $id ) = each ( %ids ) ) {\n        push( @ids, $id );\n    }\n\n    return $self->get_terms( @ids );\n\n} # get_ancestor_terms\n\n\n\n\n\n=head2 get_leaf_terms\n\n Title   : get_leaf_terms\n Usage   : $engine->get_leaf_terms();\n Function: Returns the leaf terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_leaf_terms {\n    my ( $self ) = @_;\n\n    my @a = $self->graph()->sink_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n\n=head2 get_root_terms()\n\n Title   : get_root_terms\n Usage   : $engine->get_root_terms();\n Function: Returns the root terms\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_root_terms {\n    my ( $self ) = @_;\n\n\n    my @a = $self->graph()->source_vertices();\n\n    return $self->get_terms( @a );\n\n}\n\n\n=head2 get_terms\n\n Title   : get_terms\n Usage   : @terms = $engine->get_terms( \"GO:1234567\", \"GO:2234567\" );\n Function: Returns term objects with given identifiers\n Returns : Bio::Ontology::TermI, or the term corresponding to the\n           first identifier if called in scalar context\n Args    : term ids\n\n\nsub get_terms {\n    my ( $self, @ids ) = @_;\n\n    my @terms = ();\n\n    foreach my $id ( @ids ) {\n        if ( $self->graph()->has_vertex( $id ) ) {\n          push( @terms, $self->graph()->get_vertex_attribute( $id, TERM ) ); # NG 05-02-16\n        }\n    }\n\n    return wantarray ? @terms : shift(@terms);\n\n} # get_terms\n\n\n=head2 get_all_terms\n\n Title   : get_all_terms\n Usage   : $engine->get_all_terms();\n Function: Returns all terms in this engine\n Returns : Bio::Ontology::TermI\n Args    :\n\n\nsub get_all_terms {\n    my ( $self ) = @_;\n\n    return( $self->get_terms( $self->graph()->vertices() ) );\n\n} # get_all_terms\n\n\n=head2 find_terms\n\n Title   : find_terms\n Usage   : ($term) = $oe->find_terms(-identifier => \"SO:0000263\");\n Function: Find term instances matching queries for their attributes.\n\n           This implementation can efficiently resolve queries by\n           identifier.\n\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : Named parameters. The following parameters should be recognized\n           by any implementations:\n\n              -identifier    query by the given identifier\n              -name          query by the given name\n\n\nsub find_terms{\n    my ($self,@args) = @_;\n    my @terms;\n\n    my ($id,$name) = $self->_rearrange([qw(IDENTIFIER NAME)],@args);\n\n    if(defined($id)) {\n        @terms = $self->get_terms($id);\n    } else {\n        @terms = $self->get_all_terms();\n    }\n    if(defined($name)) {\n        @terms = grep { $_->name() eq $name; } @terms;\n    }\n    return @terms;\n}\n\n\n=head2 find_identically_named_terms\n\n Title   : find_identically_named_terms\n Usage   : ($term) = $oe->find_identically_named_terms($term0);\n Function: Find term instances where names match the query term\n           name exactly\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object\n\n\nsub find_identically_named_terms{\n    my ($self,$qterm) = @_;\n    $self->throw(\"Argument doesn't implement Bio::Ontology::TermI. \" . \"Bummer.\" )\n        unless defined $qterm and $qterm->isa(\"Bio::Ontology::TermI\");\n\n    my %matching_terms;\n\n    foreach my $term ($self->get_all_terms) {\n        $matching_terms{$term->identifier} = $term and next\n            if $term->name eq $qterm->name;\n    }\n    return values %matching_terms;\n}\n\n\n=head2 find_identical_terms\n\n Title   : find_identical_terms\n Usage   : ($term) = $oe->find_identical_terms($term0);\n Function: Find term instances where name or synonym\n           matches the query exactly\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object\n\n\nsub find_identical_terms{\n    my ($self,$qterm) = @_;\n    $self->throw(\"Argument doesn't implement Bio::Ontology::TermI. \" . \"Bummer.\" )\n        unless defined $qterm and $qterm->isa(\"Bio::Ontology::TermI\");\n\n    my %matching_terms;\n\n    foreach my $qstring ($qterm->name, $qterm->each_synonym) {\n        foreach my $term ($self->get_all_terms) {\n            foreach my $string ( $term->name, $term->each_synonym() ) {\n                $matching_terms{$term->identifier} = $term and next\n                    if $string eq $qstring;\n            }\n        }\n    }\n    return values %matching_terms;\n}\n\n=head2 find_similar_terms\n\n Title   : find_similar_terms\n Usage   : ($term) = $oe->find_similar_terms($term0);\n Function: Find term instances where name or synonym, or part of one,\n           matches the query.\n Example :\n Returns : an array of zero or more Bio::Ontology::TermI objects\n Args    : a Bio::Ontology::TermI object\n\n\nsub find_similar_terms{\n    my ($self,$qterm) = @_;\n    $self->throw(\"Argument doesn't implement Bio::Ontology::TermI. \" . \"Bummer.\" )\n        unless defined $qterm and $qterm->isa(\"Bio::Ontology::TermI\");\n\n    my %matching_terms;\n\n    foreach my $qstring ($qterm->name, $qterm->each_synonym) {\n        foreach my $term ($self->get_all_terms) {\n\n            foreach my $string ( $term->name, $term->each_synonym() ) {\n                $matching_terms{$term->identifier} = $term and next\n                    if $string =~ /$qstring/ or $qstring =~ /$string/;\n            }\n        }\n    }\n    return values %matching_terms;\n}\n\n\n=head2 relationship_factory\n\n Title   : relationship_factory\n Usage   : $fact = $obj->relationship_factory()\n Function: Get/set the object factory to be used when relationship\n           objects are created by the implementation on-the-fly.\n\n Example :\n Returns : value of relationship_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub relationship_factory{\n    my $self = shift;\n\n    return $self->{'relationship_factory'} = shift if @_;\n    return $self->{'relationship_factory'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $fact = $obj->term_factory()\n Function: Get/set the object factory to be used when term objects are\n           created by the implementation on-the-fly.\n\n           Note that this ontology engine implementation does not\n           create term objects on the fly, and therefore setting this\n           attribute is meaningless.\n\n Example :\n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI\n           compliant object)\n Args    : on set, a Bio::Factory::ObjectFactoryI compliant object\n\n\nsub term_factory{\n    my $self = shift;\n\n    if(@_) {\n        $self->warn(\"setting term factory, but \".ref($self).\n                    \" does not create terms on-the-fly\");\n        return $self->{'term_factory'} = shift;\n    }\n    return $self->{'term_factory'};\n}\n\n=head2 graph\n\n Title   : graph()\n Usage   : $engine->graph();\n Function: Returns the Graph this engine is based on\n Returns : Graph\n Args    :","label":"graph($self,$value)"},"line":952,"range":{"start":{"character":0,"line":952},"end":{"character":9999,"line":961}},"kind":12},{"kind":12,"range":{"start":{"line":968,"character":0},"end":{"character":9999,"line":1004}},"line":968,"signature":{"parameters":[{"label":"$self"},{"label":"$term"}],"documentation":" Internal methods\n Checks the correct format of a GOBO-formatted id\n Gets the id out of a term or id string","label":"_get_id($self,$term)"},"name":"_get_id","containerName":"main::","children":[{"line":969,"name":"$self","localvar":"my","containerName":"_get_id","kind":13,"definition":"my"},{"line":969,"kind":13,"containerName":"_get_id","name":"$term"},{"line":970,"containerName":"_get_id","localvar":"my","kind":13,"name":"$id","definition":"my"},{"kind":13,"containerName":"_get_id","name":"$term","line":970},{"line":972,"name":"$term","kind":13,"containerName":"_get_id"},{"line":975,"name":"$self","kind":13,"containerName":"_get_id"},{"line":975,"kind":12,"containerName":"_get_id","name":"throw"},{"name":"$term","containerName":"_get_id","kind":13,"line":977},{"containerName":"_get_id","kind":12,"name":"isa","line":977},{"name":"$id","containerName":"_get_id","kind":13,"line":978},{"kind":13,"containerName":"_get_id","name":"$term","line":978},{"kind":12,"containerName":"_get_id","name":"identifier","line":978},{"kind":13,"containerName":"_get_id","name":"$id","line":982},{"line":983,"name":"$id","containerName":"_get_id","kind":13},{"line":983,"containerName":"_get_id","kind":13,"name":"$term"},{"line":983,"name":"ontology","containerName":"_get_id","kind":12},{"name":"name","containerName":"_get_id","kind":12,"line":983},{"line":983,"containerName":"_get_id","kind":13,"name":"$term"},{"name":"ontology","containerName":"_get_id","kind":12,"line":983},{"containerName":"_get_id","kind":13,"name":"$id","line":984},{"line":984,"containerName":"_get_id","kind":13,"name":"$id"},{"name":"$id","kind":13,"containerName":"_get_id","line":984},{"name":"$id","containerName":"_get_id","kind":13,"line":985},{"kind":13,"containerName":"_get_id","name":"$term","line":985},{"name":"name","containerName":"_get_id","kind":12,"line":985},{"name":"$id","kind":13,"containerName":"_get_id","line":990},{"containerName":"_get_id","kind":13,"name":"$term","line":992},{"line":992,"name":"isa","containerName":"_get_id","kind":12},{"line":992,"name":"$id","kind":13,"containerName":"_get_id"},{"line":1001,"name":"$self","kind":13,"containerName":"_get_id"},{"containerName":"_get_id","kind":12,"name":"throw","line":1001},{"kind":13,"containerName":"_get_id","name":"$self","line":1001},{"containerName":"_get_id","kind":13,"name":"$id","line":1002},{"kind":13,"containerName":"_get_id","name":"$id","line":1003}],"detail":"($self,$term)","definition":"sub"},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_get_child_parent_terms_helper","line":1008},{"containerName":"_get_child_parent_terms_helper","kind":13,"name":"$term","line":1008},{"line":1008,"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$do_get_child_terms"},{"name":"@types","containerName":"_get_child_parent_terms_helper","kind":13,"line":1008},{"name":"$type","localvar":"my","containerName":"_get_child_parent_terms_helper","kind":13,"line":1010,"definition":"my"},{"kind":13,"containerName":"_get_child_parent_terms_helper","name":"@types","line":1010},{"line":1011,"name":"$self","kind":13,"containerName":"_get_child_parent_terms_helper"},{"line":1011,"name":"_check_class","containerName":"_get_child_parent_terms_helper","kind":12},{"line":1011,"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$type"},{"localvar":"my","containerName":"_get_child_parent_terms_helper","kind":13,"name":"@relative_terms","line":1014,"definition":"my"},{"line":1016,"name":"$term","kind":13,"containerName":"_get_child_parent_terms_helper"},{"line":1016,"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$self"},{"name":"_get_id","kind":12,"containerName":"_get_child_parent_terms_helper","line":1016},{"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$term","line":1016},{"name":"$self","containerName":"_get_child_parent_terms_helper","kind":13,"line":1017},{"kind":12,"containerName":"_get_child_parent_terms_helper","name":"graph","line":1017},{"line":1017,"name":"has_vertex","containerName":"_get_child_parent_terms_helper","kind":12},{"name":"$term","kind":13,"containerName":"_get_child_parent_terms_helper","line":1017},{"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$self","line":1018},{"kind":12,"containerName":"_get_child_parent_terms_helper","name":"throw","line":1018},{"definition":"my","localvar":"my","containerName":"_get_child_parent_terms_helper","kind":13,"name":"@all_relative_terms","line":1021},{"name":"$do_get_child_terms","containerName":"_get_child_parent_terms_helper","kind":13,"line":1022},{"line":1023,"kind":13,"containerName":"_get_child_parent_terms_helper","name":"@all_relative_terms"},{"line":1023,"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$self"},{"name":"graph","kind":12,"containerName":"_get_child_parent_terms_helper","line":1023},{"kind":12,"containerName":"_get_child_parent_terms_helper","name":"successors","line":1023},{"line":1023,"name":"$term","kind":13,"containerName":"_get_child_parent_terms_helper"},{"containerName":"_get_child_parent_terms_helper","kind":13,"name":"@all_relative_terms","line":1026},{"line":1026,"containerName":"_get_child_parent_terms_helper","kind":13,"name":"$self"},{"name":"graph","kind":12,"containerName":"_get_child_parent_terms_helper","line":1026},{"name":"predecessors","containerName":"_get_child_parent_terms_helper","kind":12,"line":1026},{"line":1026,"name":"$term","kind":13,"containerName":"_get_child_parent_terms_helper"},{"localvar":"my","kind":13,"containerName":"_get_child_parent_terms_helper","name":"$relative","line":1029,"definition":"my"},{"name":"@all_relative_terms","containerName":"_get_child_parent_terms_helper","kind":13,"line":1029},{"containerName":"_get_child_parent_terms_helper","kind":13,"name":"@types","line":1030},{"definition":"my","kind":13,"localvar":"my","containerName":"_get_child_parent_terms_helper","name":"$type","line":1031},{"line":1031,"name":"@types","containerName":"_get_child_parent_terms_helper","kind":13},{"definition":"my","line":1032,"localvar":"my","kind":13,"containerName":"_get_child_parent_terms_helper","name":"$relative_type"},{"name":"$do_get_child_terms","containerName":"_get_child_parent_terms_helper","kind":13,"line":1033},{"line":1034,"containerName":"_get_child_parent_terms_helper","kind":13,"name":"$relative_type"},{"name":"$self","containerName":"_get_child_parent_terms_helper","kind":13,"line":1034},{"line":1034,"kind":12,"containerName":"_get_child_parent_terms_helper","name":"graph"},{"name":"get_edge_attribute","kind":12,"containerName":"_get_child_parent_terms_helper","line":1034},{"name":"$term","kind":13,"containerName":"_get_child_parent_terms_helper","line":1034},{"name":"$relative","kind":13,"containerName":"_get_child_parent_terms_helper","line":1034},{"line":1037,"name":"$relative_type","kind":13,"containerName":"_get_child_parent_terms_helper"},{"containerName":"_get_child_parent_terms_helper","kind":13,"name":"$self","line":1037},{"name":"graph","kind":12,"containerName":"_get_child_parent_terms_helper","line":1037},{"name":"get_edge_attribute","containerName":"_get_child_parent_terms_helper","kind":12,"line":1037},{"name":"$relative","containerName":"_get_child_parent_terms_helper","kind":13,"line":1037},{"containerName":"_get_child_parent_terms_helper","kind":13,"name":"$term","line":1037},{"containerName":"_get_child_parent_terms_helper","kind":13,"name":"$relative_type","line":1039},{"name":"equals","kind":12,"containerName":"_get_child_parent_terms_helper","line":1039},{"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$type","line":1039},{"line":1040,"containerName":"_get_child_parent_terms_helper","kind":13,"name":"@relative_terms"},{"line":1040,"kind":13,"containerName":"_get_child_parent_terms_helper","name":"$relative"},{"name":"@relative_terms","kind":13,"containerName":"_get_child_parent_terms_helper","line":1045},{"name":"$relative","kind":13,"containerName":"_get_child_parent_terms_helper","line":1045},{"line":1049,"name":"$self","containerName":"_get_child_parent_terms_helper","kind":13},{"line":1049,"name":"get_terms","kind":12,"containerName":"_get_child_parent_terms_helper"},{"containerName":"_get_child_parent_terms_helper","kind":13,"name":"@relative_terms","line":1049}],"name":"_get_child_parent_terms_helper","containerName":"main::","definition":"sub","detail":"($self,$term,$do_get_child_terms,@types)","line":1007,"kind":12,"range":{"end":{"line":1051,"character":9999},"start":{"character":0,"line":1007}},"signature":{"documentation":" Helper for getting children and parent terms","parameters":[{"label":"$self"},{"label":"$term"},{"label":"$do_get_child_terms"},{"label":"@types"}],"label":"_get_child_parent_terms_helper($self,$term,$do_get_child_terms,@types)"}},{"kind":12,"name":"TYPE","line":1034},{"name":"TYPE","kind":12,"line":1037},{"definition":"sub","detail":"($self,$term,$ids_ref,$types_ref)","children":[{"line":1056,"name":"$self","containerName":"_get_descendant_terms_helper","localvar":"my","kind":13,"definition":"my"},{"name":"$term","kind":13,"containerName":"_get_descendant_terms_helper","line":1056},{"containerName":"_get_descendant_terms_helper","kind":13,"name":"$ids_ref","line":1056},{"name":"$types_ref","kind":13,"containerName":"_get_descendant_terms_helper","line":1056},{"name":"@child_terms","kind":13,"localvar":"my","containerName":"_get_descendant_terms_helper","line":1058,"definition":"my"},{"containerName":"_get_descendant_terms_helper","kind":13,"name":"$self","line":1058},{"name":"get_child_terms","kind":12,"containerName":"_get_descendant_terms_helper","line":1058},{"line":1058,"name":"$term","containerName":"_get_descendant_terms_helper","kind":13},{"line":1058,"kind":13,"containerName":"_get_descendant_terms_helper","name":"$types_ref"},{"line":1060,"kind":13,"containerName":"_get_descendant_terms_helper","name":"@child_terms"},{"line":1064,"name":"$child_term","localvar":"my","kind":13,"containerName":"_get_descendant_terms_helper","definition":"my"},{"line":1064,"containerName":"_get_descendant_terms_helper","kind":13,"name":"@child_terms"},{"name":"$child_term_id","containerName":"_get_descendant_terms_helper","localvar":"my","kind":13,"line":1065,"definition":"my"},{"line":1065,"kind":13,"containerName":"_get_descendant_terms_helper","name":"$self"},{"line":1065,"kind":12,"containerName":"_get_descendant_terms_helper","name":"_get_id"},{"line":1065,"name":"$child_term","kind":13,"containerName":"_get_descendant_terms_helper"},{"name":"identifier","kind":12,"containerName":"_get_descendant_terms_helper","line":1065},{"name":"$ids_ref","containerName":"_get_descendant_terms_helper","kind":13,"line":1066},{"name":"$child_term_id","containerName":"_get_descendant_terms_helper","kind":13,"line":1066},{"kind":13,"containerName":"_get_descendant_terms_helper","name":"$self","line":1067},{"line":1067,"name":"_get_descendant_terms_helper","containerName":"_get_descendant_terms_helper","kind":12},{"line":1067,"kind":13,"containerName":"_get_descendant_terms_helper","name":"$child_term_id"},{"name":"$ids_ref","kind":13,"containerName":"_get_descendant_terms_helper","line":1067},{"containerName":"_get_descendant_terms_helper","kind":13,"name":"$types_ref","line":1067}],"name":"_get_descendant_terms_helper","containerName":"main::","signature":{"label":"_get_descendant_terms_helper($self,$term,$ids_ref,$types_ref)","documentation":" Recursive helper","parameters":[{"label":"$self"},{"label":"$term"},{"label":"$ids_ref"},{"label":"$types_ref"}]},"line":1055,"range":{"start":{"character":0,"line":1055},"end":{"character":9999,"line":1070}},"kind":12},{"kind":12,"range":{"start":{"line":1074,"character":0},"end":{"character":9999,"line":1089}},"line":1074,"signature":{"parameters":[{"label":"$self"},{"label":"$term"},{"label":"$ids_ref"},{"label":"$types_ref"}],"documentation":" Recursive helper","label":"_get_ancestor_terms_helper($self,$term,$ids_ref,$types_ref)"},"name":"_get_ancestor_terms_helper","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_get_ancestor_terms_helper","name":"$self","line":1075},{"line":1075,"name":"$term","containerName":"_get_ancestor_terms_helper","kind":13},{"kind":13,"containerName":"_get_ancestor_terms_helper","name":"$ids_ref","line":1075},{"name":"$types_ref","kind":13,"containerName":"_get_ancestor_terms_helper","line":1075},{"line":1077,"containerName":"_get_ancestor_terms_helper","localvar":"my","kind":13,"name":"@parent_terms","definition":"my"},{"line":1077,"kind":13,"containerName":"_get_ancestor_terms_helper","name":"$self"},{"containerName":"_get_ancestor_terms_helper","kind":12,"name":"get_parent_terms","line":1077},{"containerName":"_get_ancestor_terms_helper","kind":13,"name":"$term","line":1077},{"line":1077,"kind":13,"containerName":"_get_ancestor_terms_helper","name":"$types_ref"},{"name":"@parent_terms","kind":13,"containerName":"_get_ancestor_terms_helper","line":1079},{"line":1083,"name":"$parent_term","kind":13,"localvar":"my","containerName":"_get_ancestor_terms_helper","definition":"my"},{"line":1083,"kind":13,"containerName":"_get_ancestor_terms_helper","name":"@parent_terms"},{"line":1084,"name":"$parent_term_id","containerName":"_get_ancestor_terms_helper","localvar":"my","kind":13,"definition":"my"},{"line":1084,"kind":13,"containerName":"_get_ancestor_terms_helper","name":"$self"},{"line":1084,"kind":12,"containerName":"_get_ancestor_terms_helper","name":"_get_id"},{"line":1084,"name":"$parent_term","containerName":"_get_ancestor_terms_helper","kind":13},{"kind":12,"containerName":"_get_ancestor_terms_helper","name":"identifier","line":1084},{"containerName":"_get_ancestor_terms_helper","kind":13,"name":"$ids_ref","line":1085},{"kind":13,"containerName":"_get_ancestor_terms_helper","name":"$parent_term_id","line":1085},{"name":"$self","kind":13,"containerName":"_get_ancestor_terms_helper","line":1086},{"line":1086,"name":"_get_ancestor_terms_helper","containerName":"_get_ancestor_terms_helper","kind":12},{"kind":13,"containerName":"_get_ancestor_terms_helper","name":"$parent_term_id","line":1086},{"line":1086,"name":"$ids_ref","containerName":"_get_ancestor_terms_helper","kind":13},{"kind":13,"containerName":"_get_ancestor_terms_helper","name":"$types_ref","line":1086}],"detail":"($self,$term,$ids_ref,$types_ref)","definition":"sub"},{"line":1091,"kind":12,"range":{"end":{"line":1104,"character":9999},"start":{"line":1091,"character":0}},"signature":{"label":"_check_class($self,$value,$expected_class)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}],"documentation":""},"children":[{"localvar":"my","kind":13,"containerName":"_check_class","name":"$self","line":1092,"definition":"my"},{"containerName":"_check_class","kind":13,"name":"$value","line":1092},{"name":"$expected_class","containerName":"_check_class","kind":13,"line":1092},{"kind":13,"containerName":"_check_class","name":"$value","line":1094},{"line":1095,"name":"$self","containerName":"_check_class","kind":13},{"name":"throw","containerName":"_check_class","kind":12,"line":1095},{"line":1097,"name":"$value","kind":13,"containerName":"_check_class"},{"line":1098,"name":"$self","containerName":"_check_class","kind":13},{"name":"throw","kind":12,"containerName":"_check_class","line":1098},{"name":"$value","containerName":"_check_class","kind":13,"line":1100},{"name":"isa","kind":12,"containerName":"_check_class","line":1100},{"line":1100,"name":"$expected_class","containerName":"_check_class","kind":13},{"line":1101,"kind":13,"containerName":"_check_class","name":"$self"},{"line":1101,"name":"throw","kind":12,"containerName":"_check_class"},{"containerName":"_check_class","kind":13,"name":"$value","line":1101}],"name":"_check_class","containerName":"main::","definition":"sub","detail":"($self,$value,$expected_class)"}]}