{"vars":[{"name":"base","containerName":"","kind":2,"line":161},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$class","line":207},{"containerName":"new","kind":13,"name":"@args","line":207},{"line":208,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"line":208,"containerName":"new","kind":13,"name":"$class"},{"line":208,"name":"@args","kind":13,"containerName":"new"},{"localvar":"my","containerName":"new","kind":13,"name":"$consensus","line":209,"definition":"my"},{"definition":"my","line":212,"localvar":"my","containerName":"new","kind":13,"name":"%input"},{"name":"@args","kind":13,"containerName":"new","line":213},{"line":214,"name":"$key","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":214},{"line":215,"containerName":"new","kind":13,"name":"$input"},{"line":215,"name":"$key","kind":13,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":215},{"line":217,"containerName":"new","kind":13,"name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":218},{"line":218,"name":"$input","kind":13,"containerName":"new"},{"line":219,"containerName":"new","kind":13,"name":"$self"},{"line":219,"name":"$input","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":220},{"line":220,"kind":13,"containerName":"new","name":"$input"},{"name":"$self","kind":13,"containerName":"new","line":221},{"name":"$input","containerName":"new","kind":13,"line":221},{"name":"$self","kind":13,"containerName":"new","line":222},{"line":222,"containerName":"new","kind":13,"name":"$input"},{"kind":13,"containerName":"new","name":"$self","line":223},{"name":"$input","kind":13,"containerName":"new","line":223},{"name":"$self","kind":13,"containerName":"new","line":224},{"kind":13,"containerName":"new","name":"$input","line":224},{"name":"$self","kind":13,"containerName":"new","line":225},{"name":"$input","containerName":"new","kind":13,"line":225},{"kind":13,"containerName":"new","name":"$self","line":226},{"kind":13,"containerName":"new","name":"$input","line":226},{"line":227,"name":"$self","kind":13,"containerName":"new"},{"line":227,"kind":13,"containerName":"new","name":"$input"},{"name":"$self","kind":13,"containerName":"new","line":228},{"line":228,"name":"$input","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":229},{"kind":13,"containerName":"new","name":"$input","line":229},{"line":229,"kind":13,"containerName":"new","name":"$input"},{"line":229,"name":"$input","containerName":"new","kind":13},{"line":229,"containerName":"new","kind":13,"name":"$input"},{"name":"$input","containerName":"new","kind":13,"line":233},{"name":"$self","kind":13,"containerName":"new","line":234},{"name":"throw","containerName":"new","kind":12,"line":234},{"containerName":"new","kind":13,"name":"$input","line":234},{"line":235,"containerName":"new","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"new","line":235},{"name":"$input","containerName":"new","kind":13,"line":235},{"kind":13,"containerName":"new","name":"$self","line":236},{"line":236,"containerName":"new","kind":12,"name":"throw"},{"line":236,"containerName":"new","kind":13,"name":"$input"},{"line":237,"containerName":"new","kind":13,"name":"$self"},{"line":237,"name":"$input","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":238},{"line":238,"kind":13,"containerName":"new","name":"$input"},{"line":239,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$input","line":239},{"line":240,"kind":13,"containerName":"new","name":"$self"},{"name":"$input","containerName":"new","kind":13,"line":240},{"containerName":"new","kind":13,"name":"$self","line":243},{"name":"throw","kind":12,"containerName":"new","line":243},{"line":243,"name":"$input","containerName":"new","kind":13},{"line":244,"name":"$self","containerName":"new","kind":13},{"line":244,"containerName":"new","kind":12,"name":"throw"},{"kind":13,"containerName":"new","name":"$input","line":244},{"kind":13,"containerName":"new","name":"$self","line":245},{"name":"throw","containerName":"new","kind":12,"line":245},{"containerName":"new","kind":13,"name":"$input","line":245},{"containerName":"new","kind":13,"name":"$self","line":246},{"containerName":"new","kind":13,"name":"$input","line":246},{"name":"$self","kind":13,"containerName":"new","line":247},{"name":"$input","containerName":"new","kind":13,"line":247},{"line":248,"containerName":"new","kind":13,"name":"$self"},{"line":248,"name":"$input","kind":13,"containerName":"new"},{"line":249,"name":"$self","containerName":"new","kind":13},{"line":249,"name":"$input","kind":13,"containerName":"new"},{"localvar":"my","containerName":"new","kind":13,"name":"$i","line":250,"definition":"my"},{"name":"$i","containerName":"new","kind":13,"line":250},{"name":"$self","kind":13,"containerName":"new","line":250},{"containerName":"new","kind":13,"name":"$i","line":250},{"line":255,"containerName":"new","kind":13,"name":"$self"},{"line":255,"kind":13,"containerName":"new","name":"$i"},{"kind":13,"containerName":"new","name":"$self","line":255}],"name":"new","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.","parameters":[{"label":"$class"},{"label":"@args"}]},"line":206,"kind":12,"range":{"start":{"character":0,"line":206},"end":{"line":255,"character":9999}}},{"kind":12,"containerName":"new","name":"SUPER","line":208},{"line":217,"kind":12,"name":"_position"},{"line":218,"name":"IC","kind":12},{"name":"IC","kind":12,"line":218},{"line":219,"name":"e_val","kind":12},{"line":219,"kind":12,"name":"e_val"},{"name":"width","kind":12,"line":220},{"kind":12,"name":"width","line":220},{"name":"logA","kind":12,"line":221},{"name":"lA","kind":12,"line":221},{"line":222,"kind":12,"name":"logC"},{"line":222,"kind":12,"name":"lC"},{"line":223,"kind":12,"name":"logG"},{"line":223,"kind":12,"name":"lG"},{"name":"logT","kind":12,"line":224},{"line":224,"name":"lT","kind":12},{"line":225,"name":"sites","kind":12},{"line":225,"kind":12,"name":"sites"},{"name":"id","kind":12,"line":226},{"name":"id","kind":12,"line":226},{"kind":12,"name":"correction","line":227},{"line":227,"name":"correction","kind":12},{"kind":12,"name":"accession_number","line":228},{"name":"accession_number","kind":12,"line":228},{"name":"pA","kind":12,"line":229},{"line":229,"name":"pC","kind":12},{"line":229,"kind":12,"name":"pG"},{"line":229,"kind":12,"name":"pT"},{"line":233,"kind":12,"name":"pA"},{"line":234,"kind":12,"name":"pC"},{"name":"pG","kind":12,"line":235},{"line":236,"name":"pT","kind":12},{"name":"probA","kind":12,"line":237},{"line":237,"kind":12,"name":"pA"},{"kind":12,"name":"probC","line":238},{"line":238,"name":"pC","kind":12},{"line":239,"name":"probG","kind":12},{"line":239,"kind":12,"name":"pG"},{"name":"probT","kind":12,"line":240},{"name":"pT","kind":12,"line":240},{"kind":12,"name":"pC","line":243},{"line":244,"kind":12,"name":"pG"},{"name":"pT","kind":12,"line":245},{"line":246,"kind":12,"name":"probA"},{"kind":12,"name":"pA","line":246},{"name":"probC","kind":12,"line":247},{"line":247,"kind":12,"name":"pC"},{"line":248,"name":"probG","kind":12},{"line":248,"name":"pG","kind":12},{"kind":12,"name":"probT","line":249},{"line":249,"kind":12,"name":"pT"},{"kind":12,"name":"probA","line":250},{"line":255,"name":"probA","kind":12},{"line":255,"kind":12,"name":"probA"},{"line":255,"name":"%i","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%self","line":256},{"line":256,"name":"probA","kind":12},{"name":"$i","kind":13,"containerName":null,"line":256},{"line":258,"containerName":null,"kind":13,"name":"%self"},{"name":"probC","kind":12,"line":258},{"name":"$i","kind":13,"containerName":null,"line":258},{"name":"%self","kind":13,"containerName":null,"line":258},{"line":258,"kind":12,"name":"probC"},{"line":258,"kind":13,"containerName":null,"name":"%i"},{"name":"%self","kind":13,"containerName":null,"line":259},{"line":259,"kind":12,"name":"probC"},{"line":259,"kind":13,"containerName":null,"name":"$i"},{"name":"%self","containerName":null,"kind":13,"line":261},{"name":"probG","kind":12,"line":261},{"line":261,"name":"$i","kind":13,"containerName":null},{"line":261,"kind":13,"containerName":null,"name":"%self"},{"name":"probG","kind":12,"line":261},{"kind":13,"containerName":null,"name":"%i","line":261},{"name":"%self","kind":13,"containerName":null,"line":262},{"name":"probG","kind":12,"line":262},{"name":"$i","kind":13,"containerName":null,"line":262},{"name":"%self","kind":13,"containerName":null,"line":264},{"kind":12,"name":"probT","line":264},{"name":"$i","containerName":null,"kind":13,"line":264},{"name":"%self","kind":13,"containerName":null,"line":264},{"kind":12,"name":"probT","line":264},{"kind":13,"containerName":null,"name":"%i","line":264},{"name":"%self","containerName":null,"kind":13,"line":265},{"line":265,"kind":12,"name":"probT"},{"line":265,"containerName":null,"kind":13,"name":"$i"},{"line":271,"containerName":null,"localvar":"my","kind":13,"name":"$i","definition":"my"},{"containerName":null,"kind":13,"name":"$i","line":271},{"name":"%self","containerName":null,"kind":13,"line":271},{"name":"probA","kind":12,"line":271},{"containerName":null,"kind":13,"name":"%i","line":271},{"kind":13,"containerName":null,"name":"%self","line":272},{"kind":12,"name":"probA","line":272},{"line":272,"name":"$i","containerName":null,"kind":13},{"line":272,"kind":13,"containerName":null,"name":"%self"},{"name":"probC","kind":12,"line":272},{"line":272,"name":"$i","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":272},{"name":"probG","kind":12,"line":272},{"containerName":null,"kind":13,"name":"$i","line":272},{"name":"%self","containerName":null,"kind":13,"line":272},{"name":"probT","kind":12,"line":272},{"containerName":null,"kind":13,"name":"%i","line":272},{"name":"$self","kind":13,"containerName":null,"line":273},{"kind":12,"containerName":"main::","name":"throw","line":273},{"line":279,"name":"%self","kind":13,"containerName":null},{"line":279,"name":"correction","kind":12},{"kind":13,"containerName":null,"name":"%self","line":280},{"line":280,"name":"probA","kind":12},{"line":280,"name":"$i","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":280},{"line":280,"kind":12,"name":"correction"},{"name":"%self","kind":13,"containerName":null,"line":281},{"line":281,"kind":12,"name":"probC"},{"containerName":null,"kind":13,"name":"$i","line":281},{"containerName":null,"kind":13,"name":"%self","line":281},{"name":"correction","kind":12,"line":281},{"line":282,"name":"%self","containerName":null,"kind":13},{"line":282,"kind":12,"name":"probG"},{"name":"$i","kind":13,"containerName":null,"line":282},{"kind":13,"containerName":null,"name":"%self","line":282},{"kind":12,"name":"correction","line":282},{"line":283,"name":"%self","containerName":null,"kind":13},{"line":283,"kind":12,"name":"probT"},{"containerName":null,"kind":13,"name":"$i","line":283},{"containerName":null,"kind":13,"name":"%self","line":283},{"name":"correction","kind":12,"line":283},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$div","line":287},{"line":287,"name":"%self","containerName":null,"kind":13},{"line":287,"name":"probA","kind":12},{"line":287,"name":"$i","containerName":null,"kind":13},{"line":287,"kind":13,"containerName":null,"name":"%self"},{"line":287,"name":"probC","kind":12},{"line":287,"name":"$i","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":287},{"kind":12,"name":"probG","line":287},{"line":287,"containerName":null,"kind":13,"name":"$i"},{"line":287,"containerName":null,"kind":13,"name":"%self"},{"line":287,"name":"probT","kind":12},{"line":287,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"%self","line":288},{"line":288,"name":"probA","kind":12},{"line":288,"containerName":null,"kind":13,"name":"$i"},{"line":288,"containerName":null,"kind":13,"name":"%self"},{"line":288,"kind":12,"name":"probA"},{"line":288,"kind":13,"containerName":null,"name":"$i"},{"line":288,"name":"$div","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":289},{"line":289,"name":"probC","kind":12},{"line":289,"name":"$i","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":289},{"line":289,"name":"probC","kind":12},{"containerName":null,"kind":13,"name":"$i","line":289},{"line":289,"name":"$div","kind":13,"containerName":null},{"line":290,"name":"%self","kind":13,"containerName":null},{"line":290,"name":"probG","kind":12},{"line":290,"name":"$i","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":290},{"kind":12,"name":"probG","line":290},{"line":290,"kind":13,"containerName":null,"name":"$i"},{"name":"$div","containerName":null,"kind":13,"line":290},{"name":"%self","kind":13,"containerName":null,"line":291},{"kind":12,"name":"probT","line":291},{"kind":13,"containerName":null,"name":"$i","line":291},{"kind":13,"containerName":null,"name":"%self","line":291},{"kind":12,"name":"probT","line":291},{"line":291,"name":"$i","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$div","line":291},{"kind":13,"containerName":null,"name":"%self","line":295},{"kind":12,"name":"logA","line":295},{"name":"%input","containerName":null,"kind":13,"line":295},{"line":295,"kind":12,"name":"model"},{"name":"$self","kind":13,"containerName":null,"line":296},{"name":"calc_weight","kind":12,"containerName":"main::","line":296},{"name":"%input","containerName":null,"kind":13,"line":296},{"line":296,"kind":12,"name":"model"},{"containerName":null,"kind":13,"name":"$self","line":300},{"containerName":"main::","kind":12,"name":"_calculate_consensus","line":300},{"line":301,"kind":13,"containerName":null,"name":"$self"},{"name":"_calculate_consensus","containerName":"main::","children":[{"line":312,"name":"$self","containerName":"_calculate_consensus","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$lc","containerName":"_calculate_consensus","localvar":"my","kind":13,"line":313},{"line":313,"containerName":"_calculate_consensus","kind":13,"name":"$lt"},{"line":313,"containerName":"_calculate_consensus","kind":13,"name":"$lg"},{"containerName":"_calculate_consensus","kind":13,"name":"$self","line":313}],"definition":"sub","range":{"end":{"character":9999,"line":313},"start":{"character":0,"line":311}},"kind":12,"line":311},{"kind":12,"name":"probC","line":313},{"name":"%self","kind":13,"containerName":null,"line":313},{"name":"probT","kind":12,"line":313},{"line":313,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"probG","line":313},{"line":314,"localvar":"my","kind":13,"containerName":null,"name":"$len","definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":314},{"line":314,"name":"probA","kind":12},{"name":"$self","kind":13,"containerName":null,"line":315},{"containerName":"main::","kind":12,"name":"throw","line":315},{"line":315,"containerName":null,"kind":13,"name":"$len"},{"containerName":null,"kind":13,"name":"$lc","line":315},{"name":"$self","kind":13,"containerName":null,"line":316},{"name":"throw","kind":12,"containerName":"main::","line":316},{"line":316,"containerName":null,"kind":13,"name":"$len"},{"containerName":null,"kind":13,"name":"$lt","line":316},{"line":317,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"throw","line":317},{"line":317,"name":"$len","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$lg","line":317},{"definition":"my","line":318,"containerName":null,"localvar":"my","kind":13,"name":"$i"},{"line":318,"containerName":null,"kind":13,"name":"$i"},{"line":318,"name":"$len","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%i","line":318},{"line":320,"name":"%self","containerName":null,"kind":13},{"line":320,"name":"IUPAC","kind":12},{"line":320,"name":"$i","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":320},{"line":320,"name":"IUPACp","kind":12},{"containerName":null,"kind":13,"name":"$i","line":320},{"line":320,"name":"_to_IUPAC","kind":12},{"line":320,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"probA","line":320},{"line":320,"name":"$i","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":320},{"name":"probC","kind":12,"line":320},{"containerName":null,"kind":13,"name":"$i","line":320},{"containerName":null,"kind":13,"name":"%self","line":320},{"line":320,"kind":12,"name":"probG"},{"line":320,"containerName":null,"kind":13,"name":"$i"},{"line":320,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"probT","line":320},{"kind":13,"containerName":null,"name":"$i","line":320},{"name":"%self","containerName":null,"kind":13,"line":321},{"name":"seq","kind":12,"line":321},{"kind":13,"containerName":null,"name":"$i","line":321},{"line":321,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"seqp","line":321},{"name":"$i","containerName":null,"kind":13,"line":321},{"name":"_to_cons","kind":12,"line":321},{"name":"%self","kind":13,"containerName":null,"line":321},{"line":321,"kind":12,"name":"probA"},{"name":"$i","kind":13,"containerName":null,"line":321},{"name":"%self","containerName":null,"kind":13,"line":321},{"name":"probC","kind":12,"line":321},{"line":321,"name":"$i","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":321},{"line":321,"kind":12,"name":"probG"},{"name":"$i","kind":13,"containerName":null,"line":321},{"name":"%self","containerName":null,"kind":13,"line":321},{"name":"probT","kind":12,"line":321},{"containerName":null,"kind":13,"name":"$i","line":321},{"name":"$self","containerName":null,"kind":13,"line":323},{"detail":"($self,$model)","definition":"sub","containerName":"main::","name":"calc_weight","children":[{"localvar":"my","kind":13,"containerName":"calc_weight","name":"$self","line":339,"definition":"my"},{"containerName":"calc_weight","kind":13,"name":"$model","line":339},{"kind":13,"localvar":"my","containerName":"calc_weight","name":"%model","line":340,"definition":"my"},{"line":341,"containerName":"calc_weight","kind":13,"name":"$model"},{"line":341,"kind":13,"containerName":"calc_weight","name":"$model"},{"name":"$model","kind":13,"containerName":"calc_weight","line":342},{"kind":13,"containerName":"calc_weight","name":"$model","line":342},{"name":"$model","kind":13,"containerName":"calc_weight","line":343},{"name":"$model","kind":13,"containerName":"calc_weight","line":343},{"kind":13,"containerName":"calc_weight","name":"$model","line":344},{"kind":13,"containerName":"calc_weight","name":"$model","line":344},{"line":345,"name":"$let","localvar":"my","kind":13,"containerName":"calc_weight","definition":"my"},{"definition":"my","containerName":"calc_weight","localvar":"my","kind":13,"name":"@str","line":346},{"line":347,"name":"$self","containerName":"calc_weight","kind":13},{"line":347,"containerName":"calc_weight","kind":12,"name":"throw"},{"name":"$model","containerName":"calc_weight","kind":13,"line":347},{"line":347,"name":"$let","kind":13,"containerName":"calc_weight"},{"name":"$model","kind":13,"containerName":"calc_weight","line":347},{"name":"$let","containerName":"calc_weight","kind":13,"line":347},{"definition":"my","line":348,"localvar":"my","containerName":"calc_weight","kind":13,"name":"$f"},{"line":348,"name":"$self","containerName":"calc_weight","kind":13},{"kind":13,"containerName":"calc_weight","name":"$let","line":348},{"definition":"my","name":"$w","localvar":"my","containerName":"calc_weight","kind":13,"line":349},{"kind":13,"containerName":"calc_weight","name":"$f","line":349},{"name":"$model","containerName":"calc_weight","kind":13,"line":349},{"kind":13,"containerName":"calc_weight","name":"$let","line":349},{"name":"@str","kind":13,"containerName":"calc_weight","line":350},{"line":350,"name":"$w","containerName":"calc_weight","kind":13},{"definition":"my","name":"$llet","kind":13,"localvar":"my","containerName":"calc_weight","line":352},{"line":352,"name":"$let","containerName":"calc_weight","kind":13},{"line":353,"kind":13,"containerName":"calc_weight","name":"$llet"},{"name":"$self","containerName":"calc_weight","kind":13,"line":354},{"containerName":"calc_weight","kind":13,"name":"$llet","line":354},{"line":354,"containerName":"calc_weight","kind":13,"name":"@str"}],"signature":{"label":"calc_weight($self,$model)","parameters":[{"label":"$self"},{"label":"$model"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T"},"kind":12,"range":{"end":{"line":355,"character":9999},"start":{"character":0,"line":338}},"line":338},{"kind":12,"name":"probA","line":341},{"kind":12,"name":"probC","line":342},{"name":"probG","kind":12,"line":343},{"line":344,"kind":12,"name":"probT"},{"containerName":null,"kind":13,"name":"$self","line":356},{"name":"next_pos","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"next_pos","name":"$self","line":372,"definition":"my"},{"line":373,"kind":13,"containerName":"next_pos","name":"$self"},{"line":373,"containerName":"next_pos","kind":12,"name":"throw"},{"line":373,"name":"$self","containerName":"next_pos","kind":13},{"definition":"my","line":374,"name":"$len","containerName":"next_pos","localvar":"my","kind":13},{"line":374,"kind":13,"containerName":"next_pos","name":"$self"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":374},"start":{"line":371,"character":0}},"line":371},{"name":"seq","kind":12,"line":374},{"definition":"my","line":375,"name":"$pos","containerName":null,"localvar":"my","kind":13},{"name":"%self","kind":13,"containerName":null,"line":375},{"kind":12,"name":"_position","line":375},{"line":377,"containerName":null,"kind":13,"name":"$pos"},{"line":377,"name":"%len","containerName":null,"kind":13},{"line":378,"name":"$pA","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":378,"name":"%self","containerName":null,"kind":13},{"line":378,"kind":12,"name":"probA"},{"kind":13,"containerName":null,"name":"$pos","line":378},{"definition":"my","line":379,"localvar":"my","kind":13,"containerName":null,"name":"$pC"},{"containerName":null,"kind":13,"name":"%self","line":379},{"name":"probC","kind":12,"line":379},{"name":"$pos","kind":13,"containerName":null,"line":379},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$pG","line":380},{"line":380,"kind":13,"containerName":null,"name":"%self"},{"line":380,"name":"probG","kind":12},{"line":380,"name":"$pos","kind":13,"containerName":null},{"definition":"my","name":"$pT","kind":13,"localvar":"my","containerName":null,"line":381},{"line":381,"kind":13,"containerName":null,"name":"%self"},{"line":381,"name":"probT","kind":12},{"line":381,"kind":13,"containerName":null,"name":"$pos"},{"name":"$lA","kind":13,"localvar":"my","containerName":null,"line":382,"definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":382},{"kind":12,"name":"logA","line":382},{"containerName":null,"kind":13,"name":"$pos","line":382},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$lC","line":383},{"name":"%self","containerName":null,"kind":13,"line":383},{"kind":12,"name":"logC","line":383},{"line":383,"name":"$pos","kind":13,"containerName":null},{"definition":"my","name":"$lG","localvar":"my","containerName":null,"kind":13,"line":384},{"name":"%self","containerName":null,"kind":13,"line":384},{"line":384,"name":"logG","kind":12},{"line":384,"name":"$pos","containerName":null,"kind":13},{"line":385,"kind":13,"localvar":"my","containerName":null,"name":"$lT","definition":"my"},{"line":385,"name":"%self","containerName":null,"kind":13},{"name":"logT","kind":12,"line":385},{"name":"$pos","containerName":null,"kind":13,"line":385},{"line":386,"containerName":null,"localvar":"my","kind":13,"name":"$base","definition":"my"},{"line":386,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"seq","line":386},{"name":"$pos","containerName":null,"kind":13,"line":386},{"line":387,"name":"$prob","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"%self","line":387},{"line":387,"kind":12,"name":"seqp"},{"containerName":null,"kind":13,"name":"$pos","line":387},{"line":388,"containerName":null,"kind":13,"name":"%self"},{"line":388,"name":"_position","kind":12},{"containerName":null,"localvar":"my","kind":13,"name":"%seq","line":389,"definition":"my"},{"line":389,"name":"pA","kind":12},{"name":"$pA","kind":13,"containerName":null,"line":389},{"kind":12,"name":"pT","line":389},{"name":"$pT","containerName":null,"kind":13,"line":389},{"line":389,"kind":12,"name":"pC"},{"line":389,"containerName":null,"kind":13,"name":"$pC"},{"line":389,"name":"pG","kind":12},{"line":389,"name":"$pG","kind":13,"containerName":null},{"name":"lA","kind":12,"line":389},{"kind":13,"containerName":null,"name":"$lA","line":389},{"kind":12,"name":"lT","line":389},{"containerName":null,"kind":13,"name":"$lT","line":389},{"line":389,"name":"lC","kind":12},{"line":389,"name":"$lC","containerName":null,"kind":13},{"line":389,"name":"lG","kind":12},{"line":389,"containerName":null,"kind":13,"name":"$lG"},{"line":389,"name":"base","kind":12},{"line":389,"name":"$base","containerName":null,"kind":13},{"kind":12,"name":"rel","line":389},{"line":389,"kind":13,"containerName":null,"name":"$pos"},{"kind":12,"name":"prob","line":389},{"kind":13,"containerName":null,"name":"$prob","line":389},{"line":390,"containerName":null,"kind":13,"name":"%seq"},{"line":392,"name":"%self","containerName":null,"kind":13},{"line":392,"kind":12,"name":"_position"},{"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"curpos","kind":13,"name":"$self","line":407},{"line":408,"name":"$prev","kind":13,"localvar":"my","containerName":"curpos","definition":"my"},{"containerName":"curpos","kind":13,"name":"$self","line":408},{"line":409,"name":"$self","containerName":"curpos","kind":13},{"containerName":"curpos","kind":13,"name":"$prev","line":410}],"name":"curpos","containerName":"main::","line":406,"kind":12,"range":{"end":{"character":9999,"line":411},"start":{"line":406,"character":0}}},{"name":"_position","kind":12,"line":408},{"kind":12,"name":"_position","line":409},{"line":423,"kind":12,"range":{"end":{"character":9999,"line":428},"start":{"character":0,"line":423}},"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"e_val","localvar":"my","kind":13,"line":424},{"line":425,"localvar":"my","kind":13,"containerName":"e_val","name":"$prev","definition":"my"},{"kind":13,"containerName":"e_val","name":"$self","line":425},{"line":426,"name":"$self","kind":13,"containerName":"e_val"},{"kind":13,"containerName":"e_val","name":"$prev","line":427}],"name":"e_val","containerName":"main::"},{"line":425,"kind":12,"name":"e_val"},{"name":"e_val","kind":12,"line":426},{"kind":12,"range":{"end":{"line":445,"character":9999},"start":{"character":0,"line":440}},"line":440,"definition":"sub","name":"IC","containerName":"main::","children":[{"definition":"my","line":441,"localvar":"my","containerName":"IC","kind":13,"name":"$self"},{"localvar":"my","kind":13,"containerName":"IC","name":"$prev","line":442,"definition":"my"},{"name":"$self","containerName":"IC","kind":13,"line":442},{"kind":13,"containerName":"IC","name":"$self","line":443},{"name":"$prev","containerName":"IC","kind":13,"line":444}]},{"kind":12,"name":"IC","line":442},{"line":443,"name":"IC","kind":12},{"name":"accession_number","containerName":"main::","children":[{"definition":"my","line":459,"localvar":"my","containerName":"accession_number","kind":13,"name":"$self"},{"line":460,"name":"$prev","localvar":"my","kind":13,"containerName":"accession_number","definition":"my"},{"line":460,"name":"$self","containerName":"accession_number","kind":13},{"line":461,"name":"$self","containerName":"accession_number","kind":13},{"name":"$prev","kind":13,"containerName":"accession_number","line":462}],"definition":"sub","range":{"end":{"line":463,"character":9999},"start":{"character":0,"line":458}},"kind":12,"line":458},{"kind":12,"name":"accession_number","line":460},{"name":"accession_number","kind":12,"line":461},{"signature":{"label":"consensus($self,$thresh)","parameters":[{"label":"$self"},{"label":"$thresh"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position"},"kind":12,"range":{"end":{"line":482,"character":9999},"start":{"character":0,"line":477}},"line":477,"detail":"($self,$thresh)","definition":"sub","name":"consensus","containerName":"main::","children":[{"line":478,"name":"$self","localvar":"my","containerName":"consensus","kind":13,"definition":"my"},{"line":478,"kind":13,"containerName":"consensus","name":"$thresh"},{"line":479,"name":"$thresh","containerName":"consensus","kind":13},{"line":480,"containerName":"consensus","localvar":"my","kind":13,"name":"$len","definition":"my"},{"kind":13,"containerName":"consensus","name":"$self","line":480},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":"consensus","line":481},{"kind":13,"containerName":"consensus","name":"$i","line":481},{"line":481,"name":"$len","containerName":"consensus","kind":13},{"line":481,"name":"$i","kind":13,"containerName":"consensus"},{"line":482,"containerName":"consensus","kind":13,"name":"$self"},{"kind":13,"containerName":"consensus","name":"$i","line":482},{"line":482,"name":"$self","kind":13,"containerName":"consensus"}]},{"line":480,"kind":12,"name":"probA"},{"line":482,"kind":12,"name":"seq"},{"line":482,"name":"seqp","kind":12},{"kind":13,"containerName":null,"name":"$i","line":482},{"line":482,"name":"_to_cons","kind":12},{"line":482,"name":"%self","kind":13,"containerName":null},{"line":482,"name":"probA","kind":12},{"kind":13,"containerName":null,"name":"$i","line":482},{"line":482,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"probC","line":482},{"containerName":null,"kind":13,"name":"$i","line":482},{"line":482,"kind":13,"containerName":null,"name":"%self"},{"line":482,"name":"probG","kind":12},{"line":482,"kind":13,"containerName":null,"name":"$i"},{"line":482,"containerName":null,"kind":13,"name":"%self"},{"name":"probT","kind":12,"line":482},{"name":"$i","kind":13,"containerName":null,"line":482},{"line":482,"name":"$thresh","kind":13,"containerName":null},{"containerName":null,"localvar":"my","kind":13,"name":"$consensus","line":485,"definition":"my"},{"line":486,"name":"$letter","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":486,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"seq","line":486},{"name":"$consensus","kind":13,"containerName":null,"line":487},{"line":487,"kind":13,"containerName":null,"name":"$letter"},{"containerName":null,"kind":13,"name":"$consensus","line":489},{"children":[{"line":503,"name":"$self","localvar":"my","kind":13,"containerName":"width","definition":"my"},{"definition":"my","line":504,"name":"$width","localvar":"my","containerName":"width","kind":13},{"kind":13,"containerName":"width","name":"$self","line":504}],"containerName":"main::","name":"width","definition":"sub","line":502,"kind":12,"range":{"start":{"character":0,"line":502},"end":{"line":504,"character":9999}}},{"line":504,"name":"probA","kind":12},{"line":505,"name":"$width","kind":13,"containerName":null},{"kind":12,"range":{"end":{"line":522,"character":9999},"start":{"character":0,"line":518}},"line":518,"name":"sites","containerName":"main::","children":[{"definition":"my","line":519,"localvar":"my","containerName":"sites","kind":13,"name":"$self"},{"line":520,"containerName":"sites","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"sites","line":521}],"definition":"sub"},{"line":520,"kind":12,"name":"sites"},{"line":521,"kind":12,"name":"sites"},{"definition":"sub","detail":"($self,$thresh)","children":[{"definition":"my","line":538,"name":"$self","localvar":"my","containerName":"IUPAC","kind":13},{"line":538,"kind":13,"containerName":"IUPAC","name":"$thresh"},{"line":539,"containerName":"IUPAC","kind":13,"name":"$thresh"},{"name":"$len","localvar":"my","containerName":"IUPAC","kind":13,"line":540,"definition":"my"},{"line":540,"containerName":"IUPAC","kind":13,"name":"$self"},{"name":"$i","localvar":"my","containerName":"IUPAC","kind":13,"line":541,"definition":"my"},{"containerName":"IUPAC","kind":13,"name":"$i","line":541},{"kind":13,"containerName":"IUPAC","name":"$len","line":541},{"line":541,"name":"$i","kind":13,"containerName":"IUPAC"},{"line":542,"name":"$self","kind":13,"containerName":"IUPAC"},{"line":542,"name":"$i","kind":13,"containerName":"IUPAC"},{"containerName":"IUPAC","kind":13,"name":"$self","line":542}],"containerName":"main::","name":"IUPAC","signature":{"label":"IUPAC($self,$thresh)","parameters":[{"label":"$self"},{"label":"$thresh"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on."},"line":537,"range":{"start":{"line":537,"character":0},"end":{"character":9999,"line":542}},"kind":12},{"line":540,"name":"probA","kind":12},{"line":542,"kind":12,"name":"IUPAC"},{"line":542,"kind":12,"name":"IUPACp"},{"line":542,"name":"$i","kind":13,"containerName":null},{"name":"_to_IUPAC","kind":12,"line":542},{"line":542,"containerName":null,"kind":13,"name":"%self"},{"name":"probA","kind":12,"line":542},{"line":542,"name":"$i","kind":13,"containerName":null},{"line":542,"name":"%self","kind":13,"containerName":null},{"line":542,"kind":12,"name":"probC"},{"line":542,"containerName":null,"kind":13,"name":"$i"},{"line":542,"containerName":null,"kind":13,"name":"%self"},{"line":542,"name":"probG","kind":12},{"line":542,"name":"$i","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%self","line":542},{"kind":12,"name":"probT","line":542},{"containerName":null,"kind":13,"name":"$i","line":542},{"line":542,"name":"$thresh","kind":13,"containerName":null},{"definition":"my","line":545,"localvar":"my","containerName":null,"kind":13,"name":"$iu"},{"line":545,"containerName":null,"kind":13,"name":"%self"},{"line":545,"name":"IUPAC","kind":12},{"definition":"my","line":546,"kind":13,"localvar":"my","containerName":null,"name":"$iupac"},{"line":547,"localvar":"my","containerName":null,"kind":13,"name":"$let","definition":"my"},{"line":547,"kind":13,"containerName":null,"name":"%iu"},{"line":548,"kind":13,"containerName":null,"name":"$iupac"},{"kind":13,"containerName":null,"name":"$let","line":548},{"name":"$iupac","kind":13,"containerName":null,"line":550},{"range":{"start":{"character":0,"line":569},"end":{"line":605,"character":9999}},"kind":12,"line":569,"signature":{"label":"_to_IUPAC($a,$c,$g,$t,$thresh)","parameters":[{"label":"$a"},{"label":"$c"},{"label":"$g"},{"label":"$t"},{"label":"$thresh"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on."},"name":"_to_IUPAC","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_to_IUPAC","name":"$a","line":570,"definition":"my"},{"line":570,"containerName":"_to_IUPAC","kind":13,"name":"$c"},{"line":570,"containerName":"_to_IUPAC","kind":13,"name":"$g"},{"line":570,"kind":13,"containerName":"_to_IUPAC","name":"$t"},{"containerName":"_to_IUPAC","kind":13,"name":"$thresh","line":570},{"line":571,"name":"$thresh","containerName":"_to_IUPAC","kind":13},{"line":572,"name":"$thresh","kind":13,"containerName":"_to_IUPAC"},{"line":572,"containerName":"_to_IUPAC","kind":13,"name":"$thresh"},{"name":"$a","kind":13,"containerName":"_to_IUPAC","line":573},{"containerName":"_to_IUPAC","kind":13,"name":"$a","line":573},{"containerName":"_to_IUPAC","kind":13,"name":"$c","line":574},{"line":574,"containerName":"_to_IUPAC","kind":13,"name":"$c"},{"line":575,"containerName":"_to_IUPAC","kind":13,"name":"$g"},{"containerName":"_to_IUPAC","kind":13,"name":"$g","line":575},{"line":576,"containerName":"_to_IUPAC","kind":13,"name":"$t"},{"containerName":"_to_IUPAC","kind":13,"name":"$t","line":576},{"name":"$total","kind":13,"localvar":"my","containerName":"_to_IUPAC","line":578,"definition":"my"},{"line":578,"kind":13,"containerName":"_to_IUPAC","name":"$a"},{"containerName":"_to_IUPAC","kind":13,"name":"$c","line":578},{"line":578,"name":"$g","kind":13,"containerName":"_to_IUPAC"},{"line":578,"containerName":"_to_IUPAC","kind":13,"name":"$t"},{"name":"$a","kind":13,"containerName":"_to_IUPAC","line":580},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":580},{"containerName":"_to_IUPAC","kind":13,"name":"$g","line":581},{"containerName":"_to_IUPAC","kind":13,"name":"$total","line":581},{"name":"$c","containerName":"_to_IUPAC","kind":13,"line":582},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":582},{"containerName":"_to_IUPAC","kind":13,"name":"$t","line":583},{"line":583,"containerName":"_to_IUPAC","kind":13,"name":"$total"},{"definition":"my","localvar":"my","kind":13,"containerName":"_to_IUPAC","name":"$r","line":584},{"name":"$g","containerName":"_to_IUPAC","kind":13,"line":584},{"name":"$a","containerName":"_to_IUPAC","kind":13,"line":584},{"kind":13,"containerName":"_to_IUPAC","name":"$r","line":585},{"line":585,"containerName":"_to_IUPAC","kind":13,"name":"$total"},{"localvar":"my","containerName":"_to_IUPAC","kind":13,"name":"$y","line":586,"definition":"my"},{"containerName":"_to_IUPAC","kind":13,"name":"$t","line":586},{"line":586,"containerName":"_to_IUPAC","kind":13,"name":"$c"},{"line":587,"kind":13,"containerName":"_to_IUPAC","name":"$y"},{"line":587,"name":"$total","kind":13,"containerName":"_to_IUPAC"},{"definition":"my","localvar":"my","containerName":"_to_IUPAC","kind":13,"name":"$m","line":588},{"name":"$a","containerName":"_to_IUPAC","kind":13,"line":588},{"line":588,"kind":13,"containerName":"_to_IUPAC","name":"$c"},{"name":"$m","kind":13,"containerName":"_to_IUPAC","line":589},{"line":589,"containerName":"_to_IUPAC","kind":13,"name":"$total"},{"definition":"my","containerName":"_to_IUPAC","localvar":"my","kind":13,"name":"$k","line":590},{"containerName":"_to_IUPAC","kind":13,"name":"$g","line":590},{"name":"$t","kind":13,"containerName":"_to_IUPAC","line":590},{"line":591,"name":"$k","kind":13,"containerName":"_to_IUPAC"},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":591},{"definition":"my","name":"$s","containerName":"_to_IUPAC","localvar":"my","kind":13,"line":592},{"name":"$g","kind":13,"containerName":"_to_IUPAC","line":592},{"containerName":"_to_IUPAC","kind":13,"name":"$c","line":592},{"line":593,"kind":13,"containerName":"_to_IUPAC","name":"$s"},{"line":593,"name":"$total","kind":13,"containerName":"_to_IUPAC"},{"definition":"my","line":594,"kind":13,"localvar":"my","containerName":"_to_IUPAC","name":"$w"},{"name":"$a","kind":13,"containerName":"_to_IUPAC","line":594},{"containerName":"_to_IUPAC","kind":13,"name":"$t","line":594},{"containerName":"_to_IUPAC","kind":13,"name":"$w","line":595},{"kind":13,"containerName":"_to_IUPAC","name":"$total","line":595},{"definition":"my","line":596,"name":"$d","localvar":"my","kind":13,"containerName":"_to_IUPAC"},{"containerName":"_to_IUPAC","kind":13,"name":"$r","line":596},{"line":596,"containerName":"_to_IUPAC","kind":13,"name":"$t"},{"line":597,"kind":13,"containerName":"_to_IUPAC","name":"$d"},{"line":597,"containerName":"_to_IUPAC","kind":13,"name":"$total"},{"line":598,"localvar":"my","kind":13,"containerName":"_to_IUPAC","name":"$v","definition":"my"},{"containerName":"_to_IUPAC","kind":13,"name":"$r","line":598},{"line":598,"containerName":"_to_IUPAC","kind":13,"name":"$c"},{"name":"$v","containerName":"_to_IUPAC","kind":13,"line":599},{"containerName":"_to_IUPAC","kind":13,"name":"$total","line":599},{"line":600,"localvar":"my","containerName":"_to_IUPAC","kind":13,"name":"$b","definition":"my"},{"kind":13,"containerName":"_to_IUPAC","name":"$y","line":600},{"line":600,"kind":13,"containerName":"_to_IUPAC","name":"$g"},{"name":"$b","kind":13,"containerName":"_to_IUPAC","line":601},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":601},{"definition":"my","localvar":"my","kind":13,"containerName":"_to_IUPAC","name":"$h","line":602},{"line":602,"name":"$y","kind":13,"containerName":"_to_IUPAC"},{"line":602,"name":"$a","containerName":"_to_IUPAC","kind":13},{"containerName":"_to_IUPAC","kind":13,"name":"$h","line":603},{"containerName":"_to_IUPAC","kind":13,"name":"$total","line":603}],"detail":"($a,$c,$g,$t,$thresh)","definition":"sub"},{"definition":"sub","detail":"($A,$C,$G,$T,$thresh)","children":[{"line":622,"name":"$A","localvar":"my","containerName":"_to_cons","kind":13,"definition":"my"},{"line":622,"kind":13,"containerName":"_to_cons","name":"$C"},{"line":622,"name":"$G","containerName":"_to_cons","kind":13},{"line":622,"containerName":"_to_cons","kind":13,"name":"$T"},{"line":622,"containerName":"_to_cons","kind":13,"name":"$thresh"},{"line":623,"containerName":"_to_cons","kind":13,"name":"$thresh"},{"definition":"my","containerName":"_to_cons","localvar":"my","kind":13,"name":"$a","line":626},{"line":626,"kind":13,"containerName":"_to_cons","name":"$A"},{"line":627,"localvar":"my","containerName":"_to_cons","kind":13,"name":"$c","definition":"my"},{"line":627,"name":"$C","containerName":"_to_cons","kind":13},{"line":628,"name":"$g","kind":13,"localvar":"my","containerName":"_to_cons","definition":"my"},{"containerName":"_to_cons","kind":13,"name":"$G","line":628},{"definition":"my","containerName":"_to_cons","localvar":"my","kind":13,"name":"$t","line":629},{"line":629,"name":"$T","containerName":"_to_cons","kind":13},{"name":"$a","kind":13,"containerName":"_to_cons","line":631},{"line":631,"name":"$thresh","kind":13,"containerName":"_to_cons"},{"line":631,"containerName":"_to_cons","kind":13,"name":"$c"},{"line":631,"name":"$thresh","containerName":"_to_cons","kind":13},{"name":"$g","kind":13,"containerName":"_to_cons","line":631},{"kind":13,"containerName":"_to_cons","name":"$thresh","line":631},{"containerName":"_to_cons","kind":13,"name":"$t","line":631},{"line":631,"name":"$thresh","kind":13,"containerName":"_to_cons"},{"line":632,"name":"$a","kind":13,"containerName":"_to_cons"},{"kind":13,"containerName":"_to_cons","name":"$t","line":632},{"line":632,"name":"$a","kind":13,"containerName":"_to_cons"},{"name":"$c","kind":13,"containerName":"_to_cons","line":632},{"line":632,"containerName":"_to_cons","kind":13,"name":"$a"},{"line":632,"name":"$g","containerName":"_to_cons","kind":13},{"kind":13,"containerName":"_to_cons","name":"$a","line":636},{"kind":13,"containerName":"_to_cons","name":"$a","line":636},{"name":"$thresh","kind":13,"containerName":"_to_cons","line":636},{"containerName":"_to_cons","kind":13,"name":"$a","line":636},{"line":636,"name":"$t","kind":13,"containerName":"_to_cons"},{"line":636,"name":"$a","containerName":"_to_cons","kind":13},{"containerName":"_to_cons","kind":13,"name":"$c","line":636},{"name":"$a","containerName":"_to_cons","kind":13,"line":636},{"line":636,"name":"$g","containerName":"_to_cons","kind":13},{"line":637,"kind":13,"containerName":"_to_cons","name":"$c"},{"line":637,"containerName":"_to_cons","kind":13,"name":"$c"},{"kind":13,"containerName":"_to_cons","name":"$thresh","line":637},{"line":637,"kind":13,"containerName":"_to_cons","name":"$c"},{"line":637,"containerName":"_to_cons","kind":13,"name":"$t"},{"kind":13,"containerName":"_to_cons","name":"$c","line":637},{"name":"$a","kind":13,"containerName":"_to_cons","line":637},{"name":"$c","containerName":"_to_cons","kind":13,"line":637},{"line":637,"name":"$g","containerName":"_to_cons","kind":13},{"line":638,"containerName":"_to_cons","kind":13,"name":"$g"},{"containerName":"_to_cons","kind":13,"name":"$g","line":638},{"name":"$thresh","kind":13,"containerName":"_to_cons","line":638},{"line":638,"name":"$g","kind":13,"containerName":"_to_cons"},{"line":638,"name":"$t","containerName":"_to_cons","kind":13},{"line":638,"kind":13,"containerName":"_to_cons","name":"$g"},{"line":638,"name":"$c","kind":13,"containerName":"_to_cons"},{"name":"$g","containerName":"_to_cons","kind":13,"line":638},{"line":638,"containerName":"_to_cons","kind":13,"name":"$a"},{"name":"$t","kind":13,"containerName":"_to_cons","line":639},{"line":639,"kind":13,"containerName":"_to_cons","name":"$t"},{"line":639,"name":"$thresh","containerName":"_to_cons","kind":13},{"kind":13,"containerName":"_to_cons","name":"$t","line":639},{"line":639,"containerName":"_to_cons","kind":13,"name":"$g"},{"kind":13,"containerName":"_to_cons","name":"$t","line":639},{"containerName":"_to_cons","kind":13,"name":"$c","line":639},{"kind":13,"containerName":"_to_cons","name":"$t","line":639},{"line":639,"name":"$a","containerName":"_to_cons","kind":13}],"name":"_to_cons","containerName":"main::","signature":{"label":"_to_cons($A,$C,$G,$T,$thresh)","parameters":[{"label":"$A"},{"label":"$C"},{"label":"$G"},{"label":"$T"},{"label":"$thresh"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)"},"line":621,"kind":12,"range":{"end":{"character":9999,"line":642},"start":{"line":621,"character":0}}},{"children":[{"definition":"my","line":657,"name":"$self","containerName":"get_string","localvar":"my","kind":13},{"name":"$base","localvar":"my","kind":13,"containerName":"get_string","line":658,"definition":"my"},{"definition":"my","localvar":"my","containerName":"get_string","kind":13,"name":"$string","line":659},{"definition":"my","kind":13,"localvar":"my","containerName":"get_string","name":"@prob","line":660},{"name":"$base","containerName":"get_string","kind":13,"line":663},{"line":663,"containerName":"get_string","kind":13,"name":"@prob"},{"line":663,"name":"$self","kind":13,"containerName":"get_string"},{"line":664,"name":"$base","containerName":"get_string","kind":13},{"line":664,"name":"@prob","kind":13,"containerName":"get_string"},{"line":664,"kind":13,"containerName":"get_string","name":"$self"}],"containerName":"main::","name":"get_string","definition":"sub","line":656,"range":{"end":{"line":664,"character":9999},"start":{"line":656,"character":0}},"kind":12},{"line":662,"name":"BASE","kind":12},{"line":663,"name":"probA","kind":12},{"kind":12,"name":"BASE","line":663},{"kind":12,"name":"probC","line":664},{"line":664,"name":"BASE","kind":12},{"line":665,"kind":13,"containerName":null,"name":"%base"},{"line":665,"containerName":null,"kind":13,"name":"@prob"},{"line":665,"name":"%self","kind":13,"containerName":null},{"line":665,"kind":12,"name":"probG"},{"line":665,"kind":12,"name":"BASE"},{"line":666,"name":"%base","kind":13,"containerName":null},{"line":666,"name":"@prob","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":666},{"line":666,"name":"probT","kind":12},{"line":666,"kind":12,"name":"BASE"},{"line":667,"kind":13,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","kind":12,"line":667},{"line":670,"containerName":null,"localvar":"my","kind":13,"name":"$prob","definition":"my"},{"line":670,"kind":13,"containerName":null,"name":"@prob"},{"line":671,"name":"$corrected","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":671,"kind":13,"containerName":null,"name":"$prob"},{"definition":"my","line":672,"name":"$next","localvar":"my","containerName":null,"kind":13},{"line":672,"name":"$corrected","containerName":null,"kind":13},{"name":"$next","containerName":null,"kind":13,"line":673},{"kind":13,"containerName":null,"name":"$next","line":673},{"containerName":null,"kind":13,"name":"$string","line":674},{"line":674,"name":"$next","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$string","line":676},{"name":"get_array","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"get_array","name":"$self","line":690,"definition":"my"},{"definition":"my","localvar":"my","containerName":"get_array","kind":13,"name":"$base","line":691},{"line":692,"kind":13,"containerName":"get_array","name":"$self"}],"definition":"sub","kind":12,"range":{"start":{"line":689,"character":0},"end":{"character":9999,"line":692}},"line":689},{"line":692,"name":"probA","kind":12},{"line":692,"containerName":null,"kind":13,"name":"$base"},{"line":693,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"probC","line":693},{"line":693,"kind":13,"containerName":null,"name":"$base"},{"containerName":null,"kind":13,"name":"%self","line":694},{"kind":12,"name":"probG","line":694},{"kind":13,"containerName":null,"name":"$base","line":694},{"line":695,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"probT","line":695},{"containerName":null,"kind":13,"name":"$base","line":695},{"kind":13,"containerName":null,"name":"$self","line":696},{"containerName":"main::","kind":12,"name":"throw","line":696},{"line":709,"range":{"start":{"character":0,"line":709},"end":{"line":712,"character":9999}},"kind":12,"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"get_logs_array","line":710,"definition":"my"},{"definition":"my","line":711,"localvar":"my","containerName":"get_logs_array","kind":13,"name":"$base"},{"containerName":"get_logs_array","kind":13,"name":"$self","line":712}],"containerName":"main::","name":"get_logs_array","definition":"sub"},{"line":712,"kind":12,"name":"logA"},{"name":"$base","kind":13,"containerName":null,"line":712},{"line":712,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"logA","line":712},{"line":713,"name":"%self","containerName":null,"kind":13},{"line":713,"name":"logC","kind":12},{"line":713,"name":"$base","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":713},{"name":"logC","kind":12,"line":713},{"containerName":null,"kind":13,"name":"%self","line":714},{"line":714,"kind":12,"name":"logG"},{"containerName":null,"kind":13,"name":"$base","line":714},{"name":"%self","kind":13,"containerName":null,"line":714},{"line":714,"name":"logG","kind":12},{"name":"%self","kind":13,"containerName":null,"line":715},{"kind":12,"name":"logT","line":715},{"containerName":null,"kind":13,"name":"$base","line":715},{"line":715,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"logT","line":715},{"line":716,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"throw","line":716},{"kind":12,"range":{"end":{"character":9999,"line":735},"start":{"character":0,"line":730}},"line":730,"definition":"sub","name":"id","containerName":"main::","children":[{"line":731,"name":"$self","localvar":"my","containerName":"id","kind":13,"definition":"my"},{"line":732,"name":"$prev","containerName":"id","localvar":"my","kind":13,"definition":"my"},{"line":732,"containerName":"id","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"id","line":733},{"line":734,"name":"$prev","kind":13,"containerName":"id"}]},{"name":"id","kind":12,"line":732},{"line":733,"kind":12,"name":"id"},{"line":748,"kind":12,"range":{"start":{"line":748,"character":0},"end":{"character":9999,"line":751}},"definition":"sub","children":[{"line":749,"localvar":"my","kind":13,"containerName":"regexp","name":"$self","definition":"my"},{"definition":"my","line":750,"name":"$regexp","containerName":"regexp","localvar":"my","kind":13},{"line":751,"name":"$letter","localvar":"my","containerName":"regexp","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"regexp","line":751}],"name":"regexp","containerName":"main::"},{"name":"IUPAC","kind":12,"line":751},{"line":752,"localvar":"my","containerName":null,"kind":13,"name":"$reg","definition":"my"},{"line":753,"kind":12,"name":"LETTER"},{"line":754,"name":"%letter","kind":13,"containerName":null},{"name":"$reg","containerName":null,"kind":13,"line":754},{"kind":12,"name":"LETTER","line":754},{"line":755,"kind":13,"containerName":null,"name":"%letter"},{"line":755,"kind":13,"containerName":null,"name":"$reg"},{"line":755,"name":"LETTER","kind":12},{"line":756,"name":"%letter","containerName":null,"kind":13},{"line":756,"name":"$reg","kind":13,"containerName":null},{"line":756,"kind":12,"name":"LETTER"},{"line":757,"name":"%letter","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$reg","line":757},{"line":757,"kind":12,"name":"LETTER"},{"line":758,"kind":13,"containerName":null,"name":"%letter"},{"line":758,"name":"$reg","containerName":null,"kind":13},{"kind":12,"name":"LETTER","line":758},{"name":"%letter","containerName":null,"kind":13,"line":759},{"name":"$reg","containerName":null,"kind":13,"line":759},{"kind":12,"name":"LETTER","line":759},{"line":760,"name":"%letter","kind":13,"containerName":null},{"line":760,"name":"$reg","kind":13,"containerName":null},{"line":760,"kind":12,"name":"LETTER"},{"name":"%letter","kind":13,"containerName":null,"line":761},{"name":"$reg","kind":13,"containerName":null,"line":761},{"kind":12,"name":"LETTER","line":761},{"name":"%letter","containerName":null,"kind":13,"line":762},{"line":762,"containerName":null,"kind":13,"name":"$reg"},{"line":762,"name":"LETTER","kind":12},{"containerName":null,"kind":13,"name":"%letter","line":763},{"name":"$reg","kind":13,"containerName":null,"line":763},{"line":763,"kind":12,"name":"LETTER"},{"kind":13,"containerName":null,"name":"%letter","line":764},{"line":764,"containerName":null,"kind":13,"name":"$reg"},{"line":764,"name":"LETTER","kind":12},{"containerName":null,"kind":13,"name":"%letter","line":765},{"line":765,"name":"$reg","kind":13,"containerName":null},{"kind":12,"name":"LETTER","line":765},{"name":"%letter","containerName":null,"kind":13,"line":766},{"line":766,"name":"$reg","containerName":null,"kind":13},{"line":766,"kind":12,"name":"LETTER"},{"line":767,"containerName":null,"kind":13,"name":"%letter"},{"line":767,"name":"$reg","kind":13,"containerName":null},{"kind":12,"name":"LETTER","line":767},{"containerName":null,"kind":13,"name":"$reg","line":768},{"line":770,"containerName":null,"kind":13,"name":"$regexp"},{"line":770,"containerName":null,"kind":13,"name":"$reg"},{"kind":13,"containerName":null,"name":"$regexp","line":772},{"range":{"end":{"character":9999,"line":791},"start":{"line":788,"character":0}},"kind":12,"line":788,"definition":"sub","containerName":"main::","name":"regexp_array","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"regexp_array","kind":13,"line":789},{"definition":"my","containerName":"regexp_array","localvar":"my","kind":13,"name":"@regexp","line":790},{"localvar":"my","containerName":"regexp_array","kind":13,"name":"$letter","line":791,"definition":"my"},{"name":"$self","containerName":"regexp_array","kind":13,"line":791}]},{"line":791,"name":"IUPAC","kind":12},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$reg","line":792},{"kind":12,"name":"LETTER","line":793},{"line":794,"containerName":null,"kind":13,"name":"%letter"},{"kind":13,"containerName":null,"name":"$reg","line":794},{"name":"LETTER","kind":12,"line":794},{"line":795,"name":"%letter","kind":13,"containerName":null},{"line":795,"kind":13,"containerName":null,"name":"$reg"},{"line":795,"name":"LETTER","kind":12},{"name":"%letter","containerName":null,"kind":13,"line":796},{"line":796,"name":"$reg","containerName":null,"kind":13},{"line":796,"name":"LETTER","kind":12},{"line":797,"kind":13,"containerName":null,"name":"%letter"},{"containerName":null,"kind":13,"name":"$reg","line":797},{"line":797,"kind":12,"name":"LETTER"},{"containerName":null,"kind":13,"name":"%letter","line":798},{"line":798,"kind":13,"containerName":null,"name":"$reg"},{"name":"LETTER","kind":12,"line":798},{"line":799,"name":"%letter","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$reg","line":799},{"kind":12,"name":"LETTER","line":799},{"name":"%letter","containerName":null,"kind":13,"line":800},{"line":800,"containerName":null,"kind":13,"name":"$reg"},{"line":800,"kind":12,"name":"LETTER"},{"kind":13,"containerName":null,"name":"%letter","line":801},{"line":801,"name":"$reg","containerName":null,"kind":13},{"name":"LETTER","kind":12,"line":801},{"line":802,"containerName":null,"kind":13,"name":"%letter"},{"line":802,"containerName":null,"kind":13,"name":"$reg"},{"line":802,"name":"LETTER","kind":12},{"kind":13,"containerName":null,"name":"%letter","line":803},{"line":803,"name":"$reg","containerName":null,"kind":13},{"name":"LETTER","kind":12,"line":803},{"name":"%letter","kind":13,"containerName":null,"line":804},{"line":804,"kind":13,"containerName":null,"name":"$reg"},{"name":"LETTER","kind":12,"line":804},{"line":805,"containerName":null,"kind":13,"name":"%letter"},{"name":"$reg","kind":13,"containerName":null,"line":805},{"line":805,"kind":12,"name":"LETTER"},{"line":806,"containerName":null,"kind":13,"name":"%letter"},{"containerName":null,"kind":13,"name":"$reg","line":806},{"line":806,"kind":12,"name":"LETTER"},{"line":807,"kind":13,"containerName":null,"name":"%letter"},{"line":807,"name":"$reg","kind":13,"containerName":null},{"line":807,"name":"LETTER","kind":12},{"containerName":null,"kind":13,"name":"$reg","line":808},{"line":810,"kind":13,"containerName":null,"name":"@regexp"},{"line":810,"containerName":null,"kind":13,"name":"$reg"},{"line":812,"kind":13,"containerName":null,"name":"@regexp"},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_compress_array","name":"$array","line":830},{"line":830,"kind":13,"containerName":"_compress_array","name":"$lm"},{"name":"$direct","kind":13,"containerName":"_compress_array","line":830},{"line":831,"localvar":"my","containerName":"_compress_array","kind":13,"name":"$str","definition":"my"},{"name":"$array","containerName":"_compress_array","kind":13,"line":832},{"containerName":"_compress_array","kind":13,"name":"$lm","line":832},{"line":833,"name":"$direct","containerName":"_compress_array","kind":13},{"name":"$direct","containerName":"_compress_array","kind":13,"line":833},{"line":834,"name":"$k1","kind":13,"localvar":"my","containerName":"_compress_array","definition":"my"},{"line":834,"name":"$direct","containerName":"_compress_array","kind":13},{"line":834,"name":"$lm","kind":13,"containerName":"_compress_array"},{"line":834,"kind":13,"containerName":"_compress_array","name":"$lm"},{"line":835,"name":"$c","containerName":"_compress_array","localvar":"my","kind":13,"definition":"my"},{"name":"$array","kind":13,"containerName":"_compress_array","line":835}],"containerName":"main::","name":"_compress_array","definition":"sub","detail":"($array,$lm,$direct)","line":829,"kind":12,"range":{"start":{"character":0,"line":829},"end":{"line":835,"character":9999}},"signature":{"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)\n\n\nsub _to_cons {\n\tmy ($A, $C, $G, $T, $thresh) = @_;\n    $thresh ||= 5;\n    \n    # this multiplication by 10 is just to satisfy the thresh range of 1-10\n\tmy $a = $A * 10;\n\tmy $c = $C * 10;\n\tmy $g = $G * 10;\n\tmy $t = $T * 10;\n    \n    return 'N',10 if (($a<$thresh) && ($c<$thresh) && ($g<$thresh) && ($t<$thresh));\n\treturn 'N',10 if (($a==$t) && ($a==$c) && ($a==$g));\n    \n    # threshold could be lower than 50%, so must check is not only over\n    # threshold, but also the highest frequency\n\treturn 'A',$a if (($a>=$thresh) && ($a>$t) && ($a>$c) && ($a>$g));\n\treturn 'C',$c if (($c>=$thresh) && ($c>$t) && ($c>$a) && ($c>$g));\n\treturn 'G',$g if (($g>=$thresh) && ($g>$t) && ($g>$c) && ($g>$a));\n\treturn 'T',$t if (($t>=$thresh) && ($t>$g) && ($t>$c) && ($t>$a));\n\t\n    return 'N',10;\n}\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n           store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n    \n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{probA}}; last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{probC}}; last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{probG}}; last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{probT}}; last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n    \n    foreach  my $prob (@prob) {\n        my $corrected = $prob*10;\n        my $next=sprintf(\"%.0f\",$corrected);\n        $next='a' if ($next eq '10');\n        $string .= $next;\n    }\n    return $string;\n}\n\n=head2 get_array\n\n Title   : get_array\n Usage   :\n Function: Returns an array with frequencies for a specified base\n Returns : array\n Args    : char\n\n\nsub get_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{probA}} if ($base eq 'A');\n\treturn  @{$self->{probC}} if ($base eq 'C');\n\treturn  @{$self->{probG}} if ($base eq 'G');\n\treturn  @{$self->{probT}} if ($base eq 'T');\n\t$self->throw(\"No such base: $base!\\n\");\n}\n\n=head2 get_logs_array\n\n Title   : get_logs_array\n Usage   :\n Function: Returns an array with log_odds for a specified base\n Returns : array\n Args    : char\n\n\nsub get_logs_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{logA}} if (($base eq 'A')  && ($self->{logA}));\n\treturn  @{$self->{logC}} if (($base eq 'C')  && ($self->{logC}));\n\treturn  @{$self->{logG}} if (($base eq 'G')  && ($self->{logG}));\n\treturn  @{$self->{logT}} if (($base eq 'T')  && ($self->{logT}));\n\t$self->throw (\"No such base: $base!\\n\") if (!grep(/$base/,qw(A C G T)));\n    return;\n}\n\n=head2 id\n\n Title   : id\n Usage   :\n Function: Gets/sets the site id\n Returns : string\n Args    : string\n\n\nsub id {\n    my $self = shift;\n    my $prev = $self->{id};\n    if (@_) { $self->{id} = shift; }\n    return $prev;\n}\n\n=head2 regexp\n\n Title   : regexp\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : string\n Args    : none (works at the threshold last used for making the IUPAC string)\n\n\nsub regexp {\n\tmy $self=shift;\n\tmy $regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\t$regexp .= $reg;\n\t}\n    return $regexp;\n}\n\n=head2 regexp_array\n\n Title   : regexp_array\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : array\n Args    : none (works at the threshold last used for making the IUPAC string)\n To do   : I have separated regexp and regexp_array, but\n           maybe they can be rewritten as one - just check what should be returned\n\n\nsub regexp_array {\n\tmy $self=shift;\n\tmy @regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\tpush @regexp,$reg;\n\t}\n    return @regexp;\n}\n\n\n=head2 _compress_array\n\n Title   : _compress_array\n Usage   :\n Function: Will compress an array of real signed numbers to a string (ie vector\n           of bytes) -127 to +127 for bi-directional(signed) and 0..255 for\n           unsigned\n Returns : String\n Args    : array reference, followed by an max value and direction (optional,\n           default 1-unsigned),1 unsigned, any other is signed. ","parameters":[{"label":"$array"},{"label":"$lm"},{"label":"$direct"}],"label":"_compress_array($array,$lm,$direct)"}},{"name":"$c","containerName":null,"kind":13,"line":836},{"line":836,"name":"$lm","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$c","line":836},{"line":836,"name":"$lm","containerName":null,"kind":13},{"line":837,"name":"$c","kind":13,"containerName":null},{"line":837,"kind":13,"containerName":null,"name":"$lm"},{"containerName":null,"kind":13,"name":"$c","line":837},{"kind":13,"containerName":null,"name":"$lm","line":837},{"line":837,"name":"$direct","containerName":null,"kind":13},{"line":838,"name":"$c","kind":13,"containerName":null},{"line":838,"kind":13,"containerName":null,"name":"$c"},{"line":838,"kind":13,"containerName":null,"name":"$direct"},{"definition":"my","name":"$byte","localvar":"my","containerName":null,"kind":13,"line":839},{"line":839,"kind":13,"containerName":null,"name":"$k1"},{"line":839,"name":"$c","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$byte","line":840},{"line":840,"kind":13,"containerName":null,"name":"$byte"},{"containerName":null,"kind":13,"name":"$direct","line":840},{"definition":"my","line":841,"localvar":"my","kind":13,"containerName":null,"name":"$char"},{"line":841,"name":"$byte","containerName":null,"kind":13},{"name":"$str","kind":13,"containerName":null,"line":842},{"line":842,"kind":13,"containerName":null,"name":"$char"},{"name":"$str","kind":13,"containerName":null,"line":844},{"signature":{"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)\n\n\nsub _to_cons {\n\tmy ($A, $C, $G, $T, $thresh) = @_;\n    $thresh ||= 5;\n    \n    # this multiplication by 10 is just to satisfy the thresh range of 1-10\n\tmy $a = $A * 10;\n\tmy $c = $C * 10;\n\tmy $g = $G * 10;\n\tmy $t = $T * 10;\n    \n    return 'N',10 if (($a<$thresh) && ($c<$thresh) && ($g<$thresh) && ($t<$thresh));\n\treturn 'N',10 if (($a==$t) && ($a==$c) && ($a==$g));\n    \n    # threshold could be lower than 50%, so must check is not only over\n    # threshold, but also the highest frequency\n\treturn 'A',$a if (($a>=$thresh) && ($a>$t) && ($a>$c) && ($a>$g));\n\treturn 'C',$c if (($c>=$thresh) && ($c>$t) && ($c>$a) && ($c>$g));\n\treturn 'G',$g if (($g>=$thresh) && ($g>$t) && ($g>$c) && ($g>$a));\n\treturn 'T',$t if (($t>=$thresh) && ($t>$g) && ($t>$c) && ($t>$a));\n\t\n    return 'N',10;\n}\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n           store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n    \n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{probA}}; last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{probC}}; last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{probG}}; last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{probT}}; last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n    \n    foreach  my $prob (@prob) {\n        my $corrected = $prob*10;\n        my $next=sprintf(\"%.0f\",$corrected);\n        $next='a' if ($next eq '10');\n        $string .= $next;\n    }\n    return $string;\n}\n\n=head2 get_array\n\n Title   : get_array\n Usage   :\n Function: Returns an array with frequencies for a specified base\n Returns : array\n Args    : char\n\n\nsub get_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{probA}} if ($base eq 'A');\n\treturn  @{$self->{probC}} if ($base eq 'C');\n\treturn  @{$self->{probG}} if ($base eq 'G');\n\treturn  @{$self->{probT}} if ($base eq 'T');\n\t$self->throw(\"No such base: $base!\\n\");\n}\n\n=head2 get_logs_array\n\n Title   : get_logs_array\n Usage   :\n Function: Returns an array with log_odds for a specified base\n Returns : array\n Args    : char\n\n\nsub get_logs_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{logA}} if (($base eq 'A')  && ($self->{logA}));\n\treturn  @{$self->{logC}} if (($base eq 'C')  && ($self->{logC}));\n\treturn  @{$self->{logG}} if (($base eq 'G')  && ($self->{logG}));\n\treturn  @{$self->{logT}} if (($base eq 'T')  && ($self->{logT}));\n\t$self->throw (\"No such base: $base!\\n\") if (!grep(/$base/,qw(A C G T)));\n    return;\n}\n\n=head2 id\n\n Title   : id\n Usage   :\n Function: Gets/sets the site id\n Returns : string\n Args    : string\n\n\nsub id {\n    my $self = shift;\n    my $prev = $self->{id};\n    if (@_) { $self->{id} = shift; }\n    return $prev;\n}\n\n=head2 regexp\n\n Title   : regexp\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : string\n Args    : none (works at the threshold last used for making the IUPAC string)\n\n\nsub regexp {\n\tmy $self=shift;\n\tmy $regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\t$regexp .= $reg;\n\t}\n    return $regexp;\n}\n\n=head2 regexp_array\n\n Title   : regexp_array\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : array\n Args    : none (works at the threshold last used for making the IUPAC string)\n To do   : I have separated regexp and regexp_array, but\n           maybe they can be rewritten as one - just check what should be returned\n\n\nsub regexp_array {\n\tmy $self=shift;\n\tmy @regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\tpush @regexp,$reg;\n\t}\n    return @regexp;\n}\n\n\n=head2 _compress_array\n\n Title   : _compress_array\n Usage   :\n Function: Will compress an array of real signed numbers to a string (ie vector\n           of bytes) -127 to +127 for bi-directional(signed) and 0..255 for\n           unsigned\n Returns : String\n Args    : array reference, followed by an max value and direction (optional,\n           default 1-unsigned),1 unsigned, any other is signed. \n\n\nsub _compress_array {\n\tmy ($array,$lm,$direct)=@_;\n\tmy $str;\n\treturn  unless(($array) && ($lm));\n\t$direct=1 unless ($direct);\n\tmy $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n\tforeach my $c (@{$array}) {\n\t\t$c=$lm if ($c>$lm);\n\t\t$c=-$lm if (($c<-$lm) && ($direct !=1));\n    $c=0 if (($c<0) && ($direct ==1));\n\t\tmy $byte=int($k1*$c);\n    $byte=127+$byte if ($direct !=1);#Clumsy, should be really shift the bits\n    my $char=chr($byte);\n\t\t$str.=$char;\n\t}\n\treturn $str;\n}\n\n=head2 _uncompress_string\n\n Title   : _uncompress_string\n Usage   :\n Function: Will uncompress a string (vector of bytes) to create an array of\n           real signed numbers (opposite to_compress_array)\n Returns : string, followed by an max value and\n \t\t   direction (optional, default 1-unsigned), 1 unsigned, any other is signed.\n Args    : array","parameters":[{"label":"$str"},{"label":"$lm"},{"label":"$direct"}],"label":"_uncompress_string($str,$lm,$direct)"},"line":859,"range":{"end":{"character":9999,"line":872},"start":{"line":859,"character":0}},"kind":12,"definition":"sub","detail":"($str,$lm,$direct)","children":[{"line":860,"name":"$str","kind":13,"localvar":"my","containerName":"_uncompress_string","definition":"my"},{"line":860,"name":"$lm","kind":13,"containerName":"_uncompress_string"},{"line":860,"name":"$direct","kind":13,"containerName":"_uncompress_string"},{"definition":"my","localvar":"my","kind":13,"containerName":"_uncompress_string","name":"@array","line":861},{"line":862,"kind":13,"containerName":"_uncompress_string","name":"$str"},{"line":862,"name":"$lm","containerName":"_uncompress_string","kind":13},{"line":863,"name":"$direct","containerName":"_uncompress_string","kind":13},{"line":863,"name":"$direct","containerName":"_uncompress_string","kind":13},{"line":864,"containerName":"_uncompress_string","localvar":"my","kind":13,"name":"$k1","definition":"my"},{"name":"$direct","kind":13,"containerName":"_uncompress_string","line":864},{"line":864,"kind":13,"containerName":"_uncompress_string","name":"$lm"},{"name":"$lm","containerName":"_uncompress_string","kind":13,"line":864},{"definition":"my","line":865,"localvar":"my","containerName":"_uncompress_string","kind":13,"name":"$c"},{"line":865,"kind":13,"containerName":"_uncompress_string","name":"$str"},{"line":866,"localvar":"my","kind":13,"containerName":"_uncompress_string","name":"$byte","definition":"my"},{"line":866,"containerName":"_uncompress_string","kind":13,"name":"$c"},{"line":867,"containerName":"_uncompress_string","kind":13,"name":"$byte"},{"line":867,"name":"$byte","containerName":"_uncompress_string","kind":13},{"line":867,"containerName":"_uncompress_string","kind":13,"name":"$direct"},{"definition":"my","containerName":"_uncompress_string","localvar":"my","kind":13,"name":"$num","line":868},{"name":"$byte","kind":13,"containerName":"_uncompress_string","line":868},{"containerName":"_uncompress_string","kind":13,"name":"$k1","line":868},{"name":"@array","kind":13,"containerName":"_uncompress_string","line":869},{"kind":13,"containerName":"_uncompress_string","name":"$num","line":869},{"containerName":"_uncompress_string","kind":13,"name":"@array","line":871}],"name":"_uncompress_string","containerName":"main::"},{"line":888,"kind":12,"range":{"end":{"character":9999,"line":901},"start":{"character":0,"line":888}},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"get_compressed_freq","name":"$self","line":889},{"localvar":"my","kind":13,"containerName":"get_compressed_freq","name":"$base","line":890,"definition":"my"},{"name":"$string","localvar":"my","kind":13,"containerName":"get_compressed_freq","line":891,"definition":"my"},{"definition":"my","line":892,"name":"@prob","localvar":"my","containerName":"get_compressed_freq","kind":13},{"line":894,"name":"$base","containerName":"get_compressed_freq","kind":13},{"line":895,"kind":13,"containerName":"get_compressed_freq","name":"@prob"},{"line":895,"name":"$self","containerName":"get_compressed_freq","kind":13},{"line":895,"name":"$self","containerName":"get_compressed_freq","kind":13},{"line":898,"kind":13,"containerName":"get_compressed_freq","name":"$base"},{"line":899,"containerName":"get_compressed_freq","kind":13,"name":"@prob"},{"line":899,"name":"$self","containerName":"get_compressed_freq","kind":13},{"line":899,"kind":13,"containerName":"get_compressed_freq","name":"$self"}],"containerName":"main::","name":"get_compressed_freq","definition":"sub"},{"line":893,"name":"BASE","kind":12},{"kind":12,"name":"probA","line":895},{"line":895,"name":"probA","kind":12},{"name":"BASE","kind":12,"line":896},{"line":899,"kind":12,"name":"probG"},{"line":899,"name":"probG","kind":12},{"line":900,"name":"BASE","kind":12},{"line":902,"name":"%base","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@prob","line":903},{"name":"%self","kind":13,"containerName":null,"line":903},{"line":903,"kind":12,"name":"probC"},{"name":"%self","containerName":null,"kind":13,"line":903},{"line":903,"name":"probC","kind":12},{"line":904,"name":"BASE","kind":12},{"line":906,"name":"%base","kind":13,"containerName":null},{"name":"@prob","containerName":null,"kind":13,"line":907},{"line":907,"containerName":null,"kind":13,"name":"%self"},{"name":"probT","kind":12,"line":907},{"containerName":null,"kind":13,"name":"%self","line":907},{"line":907,"kind":12,"name":"probT"},{"line":908,"name":"BASE","kind":12},{"line":910,"containerName":null,"kind":13,"name":"$self"},{"line":910,"containerName":"main::","kind":12,"name":"throw"},{"definition":"my","line":912,"name":"$str","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"@prob","line":912},{"line":913,"name":"$str","containerName":null,"kind":13},{"children":[{"definition":"my","line":929,"localvar":"my","kind":13,"containerName":"get_compressed_logs","name":"$self"},{"localvar":"my","kind":13,"containerName":"get_compressed_logs","name":"$base","line":930,"definition":"my"},{"definition":"my","localvar":"my","containerName":"get_compressed_logs","kind":13,"name":"$string","line":931},{"name":"@prob","containerName":"get_compressed_logs","localvar":"my","kind":13,"line":932,"definition":"my"},{"line":934,"name":"$base","kind":13,"containerName":"get_compressed_logs"},{"line":934,"kind":13,"containerName":"get_compressed_logs","name":"@prob"},{"containerName":"get_compressed_logs","kind":13,"name":"$self","line":934},{"containerName":"get_compressed_logs","kind":13,"name":"$self","line":934},{"line":935,"name":"$base","kind":13,"containerName":"get_compressed_logs"},{"name":"@prob","containerName":"get_compressed_logs","kind":13,"line":935},{"line":935,"containerName":"get_compressed_logs","kind":13,"name":"$self"},{"line":935,"kind":13,"containerName":"get_compressed_logs","name":"$self"}],"containerName":"main::","name":"get_compressed_logs","definition":"sub","line":928,"range":{"end":{"character":9999,"line":935},"start":{"line":928,"character":0}},"kind":12},{"line":933,"kind":12,"name":"BASE"},{"line":934,"name":"logA","kind":12},{"line":934,"name":"logA","kind":12},{"kind":12,"name":"BASE","line":934},{"line":935,"kind":12,"name":"logC"},{"name":"logC","kind":12,"line":935},{"kind":12,"name":"BASE","line":935},{"containerName":null,"kind":13,"name":"%base","line":936},{"line":936,"containerName":null,"kind":13,"name":"@prob"},{"name":"%self","containerName":null,"kind":13,"line":936},{"name":"logG","kind":12,"line":936},{"line":936,"name":"%self","containerName":null,"kind":13},{"name":"logG","kind":12,"line":936},{"line":936,"name":"BASE","kind":12},{"kind":13,"containerName":null,"name":"%base","line":937},{"containerName":null,"kind":13,"name":"@prob","line":937},{"name":"%self","containerName":null,"kind":13,"line":937},{"line":937,"kind":12,"name":"logT"},{"name":"%self","containerName":null,"kind":13,"line":937},{"name":"logT","kind":12,"line":937},{"line":937,"kind":12,"name":"BASE"},{"name":"$self","containerName":null,"kind":13,"line":938},{"kind":12,"containerName":"main::","name":"throw","line":938},{"line":940,"name":"@prob","kind":13,"containerName":null},{"line":957,"kind":12,"range":{"end":{"line":961,"character":9999},"start":{"line":957,"character":0}},"signature":{"label":"sequence_match_weight($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)\n\n\nsub _to_cons {\n\tmy ($A, $C, $G, $T, $thresh) = @_;\n    $thresh ||= 5;\n    \n    # this multiplication by 10 is just to satisfy the thresh range of 1-10\n\tmy $a = $A * 10;\n\tmy $c = $C * 10;\n\tmy $g = $G * 10;\n\tmy $t = $T * 10;\n    \n    return 'N',10 if (($a<$thresh) && ($c<$thresh) && ($g<$thresh) && ($t<$thresh));\n\treturn 'N',10 if (($a==$t) && ($a==$c) && ($a==$g));\n    \n    # threshold could be lower than 50%, so must check is not only over\n    # threshold, but also the highest frequency\n\treturn 'A',$a if (($a>=$thresh) && ($a>$t) && ($a>$c) && ($a>$g));\n\treturn 'C',$c if (($c>=$thresh) && ($c>$t) && ($c>$a) && ($c>$g));\n\treturn 'G',$g if (($g>=$thresh) && ($g>$t) && ($g>$c) && ($g>$a));\n\treturn 'T',$t if (($t>=$thresh) && ($t>$g) && ($t>$c) && ($t>$a));\n\t\n    return 'N',10;\n}\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n           store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n    \n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{probA}}; last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{probC}}; last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{probG}}; last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{probT}}; last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n    \n    foreach  my $prob (@prob) {\n        my $corrected = $prob*10;\n        my $next=sprintf(\"%.0f\",$corrected);\n        $next='a' if ($next eq '10');\n        $string .= $next;\n    }\n    return $string;\n}\n\n=head2 get_array\n\n Title   : get_array\n Usage   :\n Function: Returns an array with frequencies for a specified base\n Returns : array\n Args    : char\n\n\nsub get_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{probA}} if ($base eq 'A');\n\treturn  @{$self->{probC}} if ($base eq 'C');\n\treturn  @{$self->{probG}} if ($base eq 'G');\n\treturn  @{$self->{probT}} if ($base eq 'T');\n\t$self->throw(\"No such base: $base!\\n\");\n}\n\n=head2 get_logs_array\n\n Title   : get_logs_array\n Usage   :\n Function: Returns an array with log_odds for a specified base\n Returns : array\n Args    : char\n\n\nsub get_logs_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{logA}} if (($base eq 'A')  && ($self->{logA}));\n\treturn  @{$self->{logC}} if (($base eq 'C')  && ($self->{logC}));\n\treturn  @{$self->{logG}} if (($base eq 'G')  && ($self->{logG}));\n\treturn  @{$self->{logT}} if (($base eq 'T')  && ($self->{logT}));\n\t$self->throw (\"No such base: $base!\\n\") if (!grep(/$base/,qw(A C G T)));\n    return;\n}\n\n=head2 id\n\n Title   : id\n Usage   :\n Function: Gets/sets the site id\n Returns : string\n Args    : string\n\n\nsub id {\n    my $self = shift;\n    my $prev = $self->{id};\n    if (@_) { $self->{id} = shift; }\n    return $prev;\n}\n\n=head2 regexp\n\n Title   : regexp\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : string\n Args    : none (works at the threshold last used for making the IUPAC string)\n\n\nsub regexp {\n\tmy $self=shift;\n\tmy $regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\t$regexp .= $reg;\n\t}\n    return $regexp;\n}\n\n=head2 regexp_array\n\n Title   : regexp_array\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : array\n Args    : none (works at the threshold last used for making the IUPAC string)\n To do   : I have separated regexp and regexp_array, but\n           maybe they can be rewritten as one - just check what should be returned\n\n\nsub regexp_array {\n\tmy $self=shift;\n\tmy @regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\tpush @regexp,$reg;\n\t}\n    return @regexp;\n}\n\n\n=head2 _compress_array\n\n Title   : _compress_array\n Usage   :\n Function: Will compress an array of real signed numbers to a string (ie vector\n           of bytes) -127 to +127 for bi-directional(signed) and 0..255 for\n           unsigned\n Returns : String\n Args    : array reference, followed by an max value and direction (optional,\n           default 1-unsigned),1 unsigned, any other is signed. \n\n\nsub _compress_array {\n\tmy ($array,$lm,$direct)=@_;\n\tmy $str;\n\treturn  unless(($array) && ($lm));\n\t$direct=1 unless ($direct);\n\tmy $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n\tforeach my $c (@{$array}) {\n\t\t$c=$lm if ($c>$lm);\n\t\t$c=-$lm if (($c<-$lm) && ($direct !=1));\n    $c=0 if (($c<0) && ($direct ==1));\n\t\tmy $byte=int($k1*$c);\n    $byte=127+$byte if ($direct !=1);#Clumsy, should be really shift the bits\n    my $char=chr($byte);\n\t\t$str.=$char;\n\t}\n\treturn $str;\n}\n\n=head2 _uncompress_string\n\n Title   : _uncompress_string\n Usage   :\n Function: Will uncompress a string (vector of bytes) to create an array of\n           real signed numbers (opposite to_compress_array)\n Returns : string, followed by an max value and\n \t\t   direction (optional, default 1-unsigned), 1 unsigned, any other is signed.\n Args    : array\n\n\nsub _uncompress_string {\n\tmy ($str,$lm,$direct)=@_;\n\tmy @array;\n\treturn unless(($str) && ($lm));\n\t$direct=1 unless ($direct);\n\tmy $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n\tforeach my $c (split(//,$str)) {\n\t\tmy $byte=ord($c);\n\t\t$byte=$byte-127 if ($direct !=1);#Clumsy, should be really shift the bits\n\t\tmy $num=$byte/$k1;\n\t\tpush @array,$num;\n\t}\n\treturn @array;\n}\n\n=head2 get_compressed_freq\n\n Title   : get_compressed_freq\n Usage   :\n Function: A method to provide a compressed frequency vector. It uses one byte\n           to code the frequence for one of the probability vectors for one\n           position. Useful for relational database. Improvment of the previous\n           0..a coding.\n Example :  my $strA=$self->get_compressed_freq('A');\n Returns :  String\n Args    :  char \n\n\nsub get_compressed_freq {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n\tBASE: {\n\t\tif ($base eq 'A') {\n      @prob= @{$self->{probA}} unless (!defined($self->{probA}));\n      last BASE;\n    }\n  \t\tif ($base eq 'G') {\n      @prob= @{$self->{probG}} unless (!defined($self->{probG}));\n      last BASE;\n    }\n  \t\tif ($base eq 'C') {\n      @prob= @{$self->{probC}} unless (!defined($self->{probC}));\n      last BASE;\n    }\n  \t\tif ($base eq 'T') {\n      @prob= @{$self->{probT}} unless (!defined($self->{probT}));\n      last BASE;\n    }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n\tmy $str= _compress_array(\\@prob,1,1);\n    return $str;\n}\n\n=head2 get_compressed_logs\n\n Title   : get_compressed_logs\n Usage   :\n Function: A method to provide a compressed log-odd vector. It uses one byte to\n \t\t   code the log value for one of the log-odds vectors for one position.\n Example : my $strA=$self->get_compressed_logs('A');\n Returns : String\n Args    : char \n\n\nsub get_compressed_logs {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{logA}} unless (!defined($self->{logA})); last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{logC}} unless (!defined($self->{logC})); last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{logG}} unless (!defined($self->{logG})); last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{logT}} unless (!defined($self->{logT})); last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n\treturn _compress_array(\\@prob,1000,2);\n}\n\n=head2 sequence_match_weight\n\n Title   : sequence_match_weight\n Usage   :\n Function: This method will calculate the score of a match, based on the PWM\n           if such is associated with the matrix object. Returns undef if no\n           PWM data is available.\n Throws  : if the length of the sequence is different from the matrix width\n Example : my $score=$matrix->sequence_match_weight('ACGGATAG');\n Returns : Floating point\n Args    : string"},"children":[{"definition":"my","line":958,"name":"$self","localvar":"my","containerName":"sequence_match_weight","kind":13},{"name":"$seq","kind":13,"containerName":"sequence_match_weight","line":958},{"line":959,"containerName":"sequence_match_weight","kind":13,"name":"$self"},{"line":960,"name":"$width","localvar":"my","kind":13,"containerName":"sequence_match_weight","definition":"my"},{"line":960,"kind":13,"containerName":"sequence_match_weight","name":"$self"},{"name":"width","kind":12,"containerName":"sequence_match_weight","line":960},{"line":961,"containerName":"sequence_match_weight","kind":13,"name":"$self"},{"containerName":"sequence_match_weight","kind":12,"name":"throw","line":961},{"line":961,"containerName":"sequence_match_weight","kind":13,"name":"$seq"},{"kind":13,"containerName":"sequence_match_weight","name":"$self","line":961}],"name":"sequence_match_weight","containerName":"main::","definition":"sub","detail":"($self,$seq)"},{"line":959,"kind":12,"name":"logA"},{"name":"logA","kind":12,"line":961},{"name":"$seq","kind":13,"containerName":null,"line":962},{"line":962,"name":"$seq","containerName":null,"kind":13},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@seq","line":963},{"kind":13,"containerName":null,"name":"$seq","line":963},{"line":964,"name":"$score","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":null,"line":965},{"line":966,"name":"$pos","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"@seq","containerName":null,"kind":13,"line":966},{"line":967,"localvar":"my","containerName":null,"kind":13,"name":"$tv","definition":"my"},{"line":967,"kind":13,"containerName":null,"name":"$pos"},{"line":968,"kind":13,"containerName":null,"name":"$self"},{"name":"warn","containerName":"main::","kind":12,"line":968},{"name":"$i","kind":13,"containerName":null,"line":968},{"line":968,"containerName":null,"kind":13,"name":"%self"},{"name":"$tv","containerName":null,"kind":13,"line":968},{"line":969,"name":"$score","kind":13,"containerName":null},{"line":969,"containerName":null,"kind":13,"name":"%self"},{"name":"$tv","kind":13,"containerName":null,"line":969},{"line":969,"name":"%self","containerName":null,"kind":13},{"line":969,"containerName":null,"kind":13,"name":"@tv"},{"name":"$i","containerName":null,"kind":13,"line":969},{"line":970,"kind":13,"containerName":null,"name":"$i"},{"line":972,"name":"$score","containerName":null,"kind":13},{"definition":"sub","name":"get_all_vectors","containerName":"main::","children":[{"definition":"my","line":989,"name":"$self","localvar":"my","containerName":"get_all_vectors","kind":13},{"definition":"my","line":990,"kind":13,"localvar":"my","containerName":"get_all_vectors","name":"$thresh"},{"line":991,"name":"$self","containerName":"get_all_vectors","kind":13},{"name":"throw","kind":12,"containerName":"get_all_vectors","line":991},{"name":"$thresh","kind":13,"containerName":"get_all_vectors","line":991},{"name":"$thresh","containerName":"get_all_vectors","kind":13,"line":991},{"definition":"my","line":992,"localvar":"my","containerName":"get_all_vectors","kind":13,"name":"@seq"},{"kind":13,"containerName":"get_all_vectors","name":"$self","line":992},{"containerName":"get_all_vectors","kind":12,"name":"consensus","line":992},{"containerName":"get_all_vectors","kind":13,"name":"$thresh","line":992},{"definition":"my","line":993,"kind":13,"localvar":"my","containerName":"get_all_vectors","name":"@perm"},{"definition":"my","name":"$i","localvar":"my","containerName":"get_all_vectors","kind":13,"line":994},{"kind":13,"containerName":"get_all_vectors","name":"$self","line":994}],"range":{"end":{"character":9999,"line":994},"start":{"line":988,"character":0}},"kind":12,"line":988},{"line":994,"kind":12,"name":"probA"},{"line":995,"name":"@perm","containerName":null,"kind":13},{"line":995,"name":"$i","containerName":null,"kind":13},{"line":995,"name":"%self","kind":13,"containerName":null},{"line":995,"kind":12,"name":"probA"},{"containerName":null,"kind":13,"name":"$i","line":995},{"containerName":null,"kind":13,"name":"$thresh","line":995},{"kind":13,"containerName":null,"name":"@perm","line":996},{"line":996,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"%self","line":996},{"name":"probC","kind":12,"line":996},{"line":996,"name":"$i","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$thresh","line":996},{"containerName":null,"kind":13,"name":"@perm","line":997},{"name":"$i","containerName":null,"kind":13,"line":997},{"name":"%self","kind":13,"containerName":null,"line":997},{"line":997,"kind":12,"name":"probG"},{"line":997,"kind":13,"containerName":null,"name":"$i"},{"name":"$thresh","containerName":null,"kind":13,"line":997},{"name":"@perm","containerName":null,"kind":13,"line":998},{"containerName":null,"kind":13,"name":"$i","line":998},{"line":998,"name":"%self","kind":13,"containerName":null},{"name":"probT","kind":12,"line":998},{"name":"$i","kind":13,"containerName":null,"line":998},{"containerName":null,"kind":13,"name":"$thresh","line":998},{"line":999,"name":"@perm","kind":13,"containerName":null},{"name":"$i","containerName":null,"kind":13,"line":999},{"name":"@seq","containerName":null,"kind":13,"line":999},{"kind":13,"containerName":null,"name":"$i","line":999},{"line":1001,"localvar":"my","containerName":null,"kind":13,"name":"$fpos","definition":"my"},{"line":1001,"name":"@perm","containerName":null,"kind":13},{"kind":13,"localvar":"my","containerName":null,"name":"@strings","line":1002,"definition":"my"},{"name":"$fpos","kind":13,"containerName":null,"line":1002},{"definition":"my","line":1003,"localvar":"my","kind":13,"containerName":null,"name":"$pos"},{"line":1003,"name":"@perm","kind":13,"containerName":null},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@newstr","line":1004},{"definition":"my","name":"%let","localvar":"my","containerName":null,"kind":13,"line":1005},{"localvar":"my","kind":13,"containerName":null,"name":"$string","line":1006,"definition":"my"},{"line":1006,"containerName":null,"kind":13,"name":"@strings"},{"kind":13,"localvar":"my","containerName":null,"name":"$newstring","line":1007,"definition":"my"},{"name":"$string","containerName":null,"kind":13,"line":1007},{"name":"$let","containerName":null,"kind":13,"line":1007},{"containerName":null,"kind":13,"name":"@newstr","line":1008},{"name":"$newstring","kind":13,"containerName":null,"line":1008},{"line":1011,"containerName":null,"kind":13,"name":"@strings"},{"kind":13,"containerName":null,"name":"@newstr","line":1011},{"line":1013,"name":"@strings","containerName":null,"kind":13}],"version":5}