{"vars":[{"name":"base","containerName":"","kind":2,"line":61},{"name":"@Bio","kind":13,"containerName":null,"line":64},{"name":"Matrix","containerName":"PSM::PsmHeader::MASTHEADER","kind":12,"line":64},{"name":"@Bio","kind":13,"containerName":null,"line":66},{"kind":12,"containerName":"PSM::PsmHeader::MEMEHEADER","name":"Matrix","line":66},{"name":"@Bio","containerName":null,"kind":13,"line":67},{"line":67,"containerName":"PSM::PsmHeader::TRANSFACHEADER","kind":12,"name":"Matrix"},{"line":68,"containerName":null,"kind":13,"name":"@Bio"},{"name":"Matrix","containerName":"PSM::PsmHeader::PSIBLASTHEADER","kind":12,"line":68},{"containerName":null,"kind":13,"name":"@Bio","line":69},{"name":"Matrix","containerName":"PSM::PsmHeader::ALLHEADER","kind":12,"line":69},{"containerName":"main::","name":"new","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$class","line":92},{"name":"@args","containerName":"new","kind":13,"line":92},{"line":93,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":93,"name":"$class","kind":13,"containerName":"new"},{"line":93,"kind":13,"containerName":"new","name":"@args"},{"line":94,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":91},"end":{"character":9999,"line":95}},"line":91,"signature":{"documentation":"1;\n# $Id: PsmHeader.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::PsmHeader - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\n  # See Bio::Matrix::PSM::IO for detailed documentation on how to use\n  # PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::PsmHeader;\n\nuse Bio::Matrix::PSM::InstanceSite;\n\nuse strict;\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::PsmHeaderI);\n\n#These define what structures within the\n@Bio::Matrix::PSM::PsmHeader::MASTHEADER=qw(html version release seq hid \n\t\t\t\t\t    length instances unstructured);\n@Bio::Matrix::PSM::PsmHeader::MEMEHEADER=qw(html version release hid weight length unstructured);\n@Bio::Matrix::PSM::PsmHeader::TRANSFACHEADER=qw(unstructured version release);\n@Bio::Matrix::PSM::PsmHeader::PSIBLASTHEADER=qw(seq width ic);\n@Bio::Matrix::PSM::PsmHeader::ALLHEADER=qw(header release type version html \n\t\t\t\t\t   release weight length id \n\t\t\t\t\t   seq instances unstructured);\n\n=head2 new\n\n Title   : new\n Usage   : my $header= Bio::Matrix::PSM::PsmHeader->new(-seq=>\\%seq, \n\t\t\t\t\t\t       -mid=>\\%mid, \n\t\t\t\t\t\t       -width=>\\%width,\n                                                       -instances=>\\%instances,\n\t\t\t\t\t\t       -header=>\\@header,\n\t\t\t\t\t\t       -type=>'mast');\n Function: Creates a new Bio::Matrix::PSM::PsmHeader object\n Throws  :\n Example :\n Returns :  Bio::Matrix::PSM::PsmHeader object\n Args    :  hash","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"line":93,"containerName":"new","kind":12,"name":"SUPER"},{"line":98,"range":{"end":{"line":103,"character":9999},"start":{"character":0,"line":98}},"kind":12,"children":[{"definition":"my","line":99,"name":"$self","kind":13,"localvar":"my","containerName":"_initialize"},{"definition":"my","localvar":"my","containerName":"_initialize","kind":13,"name":"$type","line":100},{"line":100,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"$type","containerName":"_initialize","kind":13,"line":101},{"line":102,"name":"$self","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$type","line":102},{"line":103,"name":"$dat","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"_initialize","kind":13,"line":103}],"containerName":"main::","name":"_initialize","definition":"sub"},{"kind":12,"name":"_type","line":102},{"name":"unstructured","kind":12,"line":103},{"line":104,"name":"$dat","kind":13,"containerName":null},{"line":104,"name":"%dat","containerName":null,"kind":13},{"line":105,"name":"%self","containerName":null,"kind":13},{"line":105,"kind":12,"name":"version"},{"line":105,"name":"@dat","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":106},{"line":106,"name":"version","kind":12},{"containerName":null,"kind":13,"name":"%self","line":107},{"name":"version","kind":12,"line":107},{"line":109,"kind":13,"containerName":null,"name":"$dat"},{"containerName":null,"kind":13,"name":"%dat","line":109},{"line":110,"name":"$rel","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"@dat","containerName":null,"kind":13,"line":110},{"kind":13,"containerName":null,"name":"$rel","line":111},{"line":112,"kind":13,"containerName":null,"name":"$rel"},{"line":113,"name":"%rel","containerName":null,"kind":13},{"definition":"my","line":114,"name":"$time","containerName":null,"localvar":"my","kind":13},{"kind":13,"containerName":null,"name":"@rel","line":114},{"definition":"my","line":115,"name":"$dat","kind":13,"localvar":"my","containerName":null},{"line":115,"name":"@rel","containerName":null,"kind":13},{"line":116,"containerName":null,"kind":13,"name":"%self"},{"line":116,"kind":12,"name":"release"},{"line":118,"name":"%self","containerName":null,"kind":13},{"name":"release","kind":12,"line":118},{"line":118,"containerName":null,"kind":13,"name":"$rel"},{"kind":13,"containerName":null,"name":"$self","line":120},{"definition":"sub","name":"seq","containerName":"main::","children":[{"line":138,"name":"$self","localvar":"my","kind":13,"containerName":"seq","definition":"my"},{"name":"$self","kind":13,"containerName":"seq","line":139},{"containerName":"seq","kind":12,"name":"_check","line":139},{"line":140,"kind":13,"containerName":"seq","name":"$self"}],"kind":12,"range":{"start":{"line":137,"character":0},"end":{"line":140,"character":9999}},"line":137},{"line":140,"name":"seq","kind":12},{"range":{"end":{"character":9999,"line":159},"start":{"character":0,"line":156}},"kind":12,"line":156,"definition":"sub","containerName":"main::","name":"hid","children":[{"definition":"my","line":157,"name":"$self","kind":13,"localvar":"my","containerName":"hid"},{"name":"$self","kind":13,"containerName":"hid","line":158},{"line":158,"name":"_check","containerName":"hid","kind":12},{"name":"@header","localvar":"my","containerName":"hid","kind":13,"line":159,"definition":"my"},{"name":"$self","containerName":"hid","kind":13,"line":159}]},{"kind":12,"name":"hid","line":159},{"containerName":null,"kind":13,"name":"@header","line":160},{"children":[{"line":178,"localvar":"my","containerName":"length","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"length","name":"$self","line":179},{"containerName":"length","kind":12,"name":"_check","line":179},{"kind":13,"containerName":"length","name":"$self","line":180}],"name":"length","containerName":"main::","definition":"sub","line":177,"kind":12,"range":{"end":{"character":9999,"line":181},"start":{"line":177,"character":0}}},{"line":180,"kind":12,"name":"length"},{"children":[{"line":197,"localvar":"my","containerName":"instances","kind":13,"name":"$self","definition":"my"},{"name":"$self","containerName":"instances","kind":13,"line":198},{"line":198,"kind":12,"containerName":"instances","name":"_check"},{"line":199,"containerName":"instances","kind":13,"name":"$self"}],"containerName":"main::","name":"instances","definition":"sub","line":196,"kind":12,"range":{"start":{"character":0,"line":196},"end":{"line":199,"character":9999}}},{"line":199,"kind":12,"name":"instances"},{"definition":"sub","children":[{"containerName":"weight","localvar":"my","kind":13,"name":"$self","line":217,"definition":"my"},{"line":218,"kind":13,"containerName":"weight","name":"$self"},{"line":218,"name":"_check","kind":12,"containerName":"weight"},{"name":"$self","containerName":"weight","kind":13,"line":219}],"name":"weight","containerName":"main::","line":216,"range":{"end":{"character":9999,"line":219},"start":{"line":216,"character":0}},"kind":12},{"name":"weight","kind":12,"line":219},{"range":{"end":{"character":9999,"line":239},"start":{"line":237,"character":0}},"kind":12,"line":237,"definition":"sub","name":"unstructured","containerName":"main::","children":[{"line":238,"localvar":"my","containerName":"unstructured","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"unstructured","line":239}]},{"name":"unstructured","kind":12,"line":239},{"kind":12,"range":{"end":{"line":258,"character":9999},"start":{"character":0,"line":255}},"line":255,"name":"version","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"version","name":"$self","line":256,"definition":"my"},{"containerName":"version","kind":13,"name":"$self","line":257}],"definition":"sub"},{"kind":12,"name":"version","line":257},{"definition":"sub","name":"release","containerName":"main::","children":[{"definition":"my","line":274,"containerName":"release","localvar":"my","kind":13,"name":"$self"},{"name":"$self","containerName":"release","kind":13,"line":275}],"kind":12,"range":{"start":{"character":0,"line":273},"end":{"line":276,"character":9999}},"line":273},{"name":"release","kind":12,"line":275},{"range":{"end":{"character":9999,"line":308},"start":{"character":0,"line":291}},"kind":12,"line":291,"signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: PsmHeader.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::PsmHeader - PSM mast parser implementation\n\n=head1 SYNOPSIS\n\n  # See Bio::Matrix::PSM::IO for detailed documentation on how to use\n  # PSM parsers\n\n=head1 DESCRIPTION\n\nParser for mast. This driver unlike meme or transfac for example is\ndedicated more to PSM sequence matches\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::PsmHeader;\n\nuse Bio::Matrix::PSM::InstanceSite;\n\nuse strict;\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::PsmHeaderI);\n\n#These define what structures within the\n@Bio::Matrix::PSM::PsmHeader::MASTHEADER=qw(html version release seq hid \n\t\t\t\t\t    length instances unstructured);\n@Bio::Matrix::PSM::PsmHeader::MEMEHEADER=qw(html version release hid weight length unstructured);\n@Bio::Matrix::PSM::PsmHeader::TRANSFACHEADER=qw(unstructured version release);\n@Bio::Matrix::PSM::PsmHeader::PSIBLASTHEADER=qw(seq width ic);\n@Bio::Matrix::PSM::PsmHeader::ALLHEADER=qw(header release type version html \n\t\t\t\t\t   release weight length id \n\t\t\t\t\t   seq instances unstructured);\n\n=head2 new\n\n Title   : new\n Usage   : my $header= Bio::Matrix::PSM::PsmHeader->new(-seq=>\\%seq, \n\t\t\t\t\t\t       -mid=>\\%mid, \n\t\t\t\t\t\t       -width=>\\%width,\n                                                       -instances=>\\%instances,\n\t\t\t\t\t\t       -header=>\\@header,\n\t\t\t\t\t\t       -type=>'mast');\n Function: Creates a new Bio::Matrix::PSM::PsmHeader object\n Throws  :\n Example :\n Returns :  Bio::Matrix::PSM::PsmHeader object\n Args    :  hash\n\n\n\nsub new {\n    my ($class,@args)=@_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n#parse version/release info here from the unstructured array\nsub _initialize {\n    my $self = shift;\n    my $type=ref($self);\n    $type=~s/\\w+:://g;\n    $self->{_type} = $type;\n    my $dat=join(\" \",grep(/version|release/i,@{$self->{unstructured}}));\n    if ($dat && ($dat=~/version\\b/i)) {\n\t$self->{version}=substr($dat,$+[0]+1);\n\t$self->{version}=~s/\\s.+[^\\d\\.\\:\\/]//g;\n\t$self->{version}=~s/^\\D//;\n    }\n    if ($dat && ($dat=~/release\\b/i)) {\n\tmy $rel=substr($dat,$+[0]+1);\n\t$rel=~s/[^\\d\\.\\:\\/\\-]//g;\n\t$rel=~s/^\\D//;\n\tif ($rel=~/\\d\\d:\\d\\d:\\d\\d/) { #Reformat if time is available too\n\t    my $time=substr($rel,$-[0]+1);\n\t    my $dat= substr($rel,0,$-[0]);\n\t    $self->{release}=\"$dat $time\";\n\t}\n\telse {  $self->{release}=$rel; }\n    }\n    return $self;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : my %seq= $header->seq();\n Function: Returns the sequence data as a hash, indexed by a sequence ID (motif id or accession number)\n           In case the input data is a motif it would return the consenus seq for each of them (mast).\n Throws  :\n Example :\n Returns :   hash\n Args    :\n\n\n\nsub seq {\n    my $self = shift;\n    return () unless ($self->_check('seq'));\n    return %{$self->{seq}};\n}\n\n=head2 hid\n\n Title   : hid\n Usage   : my @hid= $header->hid();\n Function: Returns array with the motif ids\n Throws  :\n Example :\n Returns :   array\n Args    :\n\n\n\nsub hid {\n    my $self = shift;\n    return unless ($self->_check('hid'));\n    my @header=@{$self->{hid}};\n    return @header;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my %length= $header->length();\n Function: Returns the length of the input sequence or motifs as a hash, indexed\n           by a sequence ID (motif id or accession number)\n Throws  :\n Example :\n Returns :  hash\n Args    :\n\n\n\nsub length {\n     my $self = shift;\n     return unless ($self->_check('length'));\n    return $self->{length};\n}\n\n=head2 instances\n\n Title   : instances\n Usage   : my %instances= $header->instances();\n Function: Returns the info about the input data, contained in the header\n Throws  :\n Example :\n Returns : hash\n Args    :\n\n\n\nsub instances {\n      my $self = shift;\n      return unless ($self->_check('instances'));\n      return %{$self->{instances}};\n}\n\n=head2 weight\n\n Title   : weight\n Usage   : my %weights= $header->weight();\n Function: Returns the weights of the input sequence as a hash, indexed\n           by a sequence ID\n Throws  :\n Example :\n Returns :  hash\n Args    :\n\n\n\nsub weight {\n    my $self = shift;\n    return () unless ($self->_check('weight'));\n    return %{$self->{weight}};\n}\n\n\n=head2 unstuctured\n\n Title   : unstuctured\n Usage   : my @unstructured= $header->unstuctured();\n Function: Returns the unstructured data in the header as an array, one line per\n           array element, all control symbols are removed with \\W\n Throws  :\n Example :\n Returns :  array\n Args    :\n\n\n\nsub unstructured {\n    my $self = shift;\n    return @{$self->{unstructured}};\n}\n\n=head2 version\n\n Title   : version\n Usage   : my $version= $header->version;\n Function: Returns the version of the file being parsed if such exists\n Throws  :\n Example :\n Returns :  string\n Args    :\n\n\n\nsub version {\n    my $self = shift;\n    return $self->{version};\n}\n\n=head2 release\n\n Title   : release\n Usage   : my $release= $header->release;\n Function: Returns the release of the file being parsed if such exists\n Throws  :\n Example :\n Returns :  string\n Args    :\n\n\n\nsub release {\n    my $self = shift;\n    return $self->{release};\n}\n\n=head2 _check\n\n Title   : _check\n Usage   : if ($self->_check('weights') { #do something} else {return 0;}\n Function: Checks if the method called is aplicable to the file format\n Throws  :\n Example :\n Returns :  boolean\n Args    :  string","label":"_check($self,$method)"},"name":"_check","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"_check","name":"$self","line":292,"definition":"my"},{"line":292,"name":"$method","containerName":"_check","kind":13},{"definition":"my","localvar":"my","containerName":"_check","kind":13,"name":"$type","line":293},{"name":"$self","containerName":"_check","kind":13,"line":293},{"line":294,"containerName":"_check","kind":13,"name":"$type"},{"name":"@Bio","containerName":"_check","kind":13,"line":296},{"containerName":"_check","kind":13,"name":"$type","line":297},{"line":299,"name":"@Bio","containerName":"_check","kind":13},{"name":"$type","containerName":"_check","kind":13,"line":300},{"containerName":"_check","kind":13,"name":"@Bio","line":302},{"line":303,"containerName":"_check","kind":13,"name":"$type"},{"line":305,"name":"@Bio","containerName":"_check","kind":13}],"detail":"($self,$method)","definition":"sub"},{"name":"Matrix","containerName":"PSM::PsmHeader::MEMEHEADER","kind":12,"line":296},{"line":299,"name":"Matrix","kind":12,"containerName":"PSM::PsmHeader::MASTHEADER"},{"line":302,"kind":12,"containerName":"PSM::PsmHeader::TRANSFACHEADER","name":"Matrix"},{"line":305,"name":"Matrix","kind":12,"containerName":"PSM::PsmHeader::PSIBLASTHEADER"}],"version":5}