{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":192},{"containerName":"main::","name":"new","children":[{"definition":"my","line":219,"kind":13,"localvar":"my","containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"@args","line":219},{"definition":"my","line":220,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$class","line":220},{"line":220,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$consensus","line":221},{"localvar":"my","containerName":"new","kind":13,"name":"%input","line":224,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":225},{"definition":"my","line":226,"localvar":"my","containerName":"new","kind":13,"name":"$key"},{"name":"@args","kind":13,"containerName":"new","line":226},{"name":"$input","containerName":"new","kind":13,"line":227},{"containerName":"new","kind":13,"name":"$key","line":227},{"line":227,"kind":13,"containerName":"new","name":"@args"},{"line":232,"localvar":"my","containerName":"new","kind":13,"name":"@alphabet","definition":"my"},{"localvar":"my","kind":13,"containerName":"new","name":"$aa","line":234,"definition":"my"},{"line":234,"containerName":"new","kind":13,"name":"@alphabet"},{"containerName":"new","kind":13,"name":"$self","line":235},{"kind":13,"containerName":"new","name":"$input","line":235},{"name":"$input","kind":13,"containerName":"new","line":235},{"name":"$self","containerName":"new","kind":13,"line":236},{"line":236,"containerName":"new","kind":12,"name":"throw"},{"name":"$self","containerName":"new","kind":13,"line":237},{"line":237,"kind":13,"containerName":"new","name":"$input"},{"name":"$input","kind":13,"containerName":"new","line":237},{"kind":13,"containerName":"new","name":"$self","line":238},{"line":238,"name":"throw","kind":12,"containerName":"new"},{"line":241,"name":"$self","containerName":"new","kind":13},{"line":242,"name":"$self","containerName":"new","kind":13},{"name":"$input","containerName":"new","kind":13,"line":242},{"line":243,"kind":13,"containerName":"new","name":"$self"},{"line":243,"name":"$input","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":244},{"line":244,"containerName":"new","kind":13,"name":"$input"},{"name":"$self","containerName":"new","kind":13,"line":245},{"line":245,"containerName":"new","kind":13,"name":"$input"},{"name":"$self","kind":13,"containerName":"new","line":246},{"name":"$input","containerName":"new","kind":13,"line":246},{"containerName":"new","kind":13,"name":"$self","line":247},{"line":247,"name":"$input","containerName":"new","kind":13},{"line":248,"name":"$input","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":250},{"kind":13,"containerName":"new","name":"$input","line":250},{"name":"$input","containerName":"new","kind":13,"line":250},{"kind":13,"containerName":"new","name":"$self","line":251},{"name":"@alphabet","kind":13,"containerName":"new","line":251},{"name":"$self","kind":13,"containerName":"new","line":254},{"line":254,"name":"$self","kind":13,"containerName":"new"},{"name":"$input","kind":13,"containerName":"new","line":254},{"line":255,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":256},"start":{"character":0,"line":218}},"line":218,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: ProtMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::ProtMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) with log-odds scoring\ninformation.\n\n=head1 SYNOPSIS\n\n   use Bio::Matrix::PSM::ProtMatrix;\n   # Create from memory by supplying probability matrix hash both as strings or\n   # arrays where the frequencies   Hash entries of the form lN refer to an array\n   # of position-specific log-odds scores for amino acid N. Hash entries of the\n   # form pN represent the position-specific probability of finding amino acid N.\n\n   my %param = (\n             'id' => 'A. thaliana protein atp1',\n             '-e_val' => $score,\n             'lS' => [ '-2', '3', '-3', '2', '-3', '1', '1', '3' ],\n             'lF' => [ '-1', '-4', '0', '-5', '0', '-5', '-4', '-4' ],\n             'lT' => [ '-1', '1', '0', '1', '-2', '-1', '0', '1' ],\n             'lN' => [ '-3', '-1', '-2', '3', '-5', '5', '-2', '0' ],\n             'lK' => [ '-2', '0', '-3', '2', '-3', '2', '-3', '-1' ],\n             'lY' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-4', '-4' ],\n             'lE' => [ '-3', '4', '-3', '2', '-4', '-2', '-3', '2' ],\n             'lV' => [ '0', '-2', '1', '-4', '1', '-4', '-1', '-3' ],\n             'lQ' => [ '-1', '0', '-2', '3', '-4', '1', '-3', '0' ],\n             'lM' => [ '8', '-3', '8', '-3', '1', '-3', '-3', '-3' ],\n             'lC' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-3', '-3' ],\n             'lL' => [ '1', '-3', '1', '-4', '3', '-4', '-2', '-4' ],\n             'lA' => [ '-2', '1', '-2', '0', '-2', '-2', '2', '2' ],\n             'lW' => [ '-2', '-4', '-3', '-5', '-4', '-5', '-5', '-5' ],\n             'lP' => [ '-3', '-2', '-4', '-3', '-1', '-3', '6', '-3' ],\n             'lH' => [ '-2', '-2', '-3', '-2', '-5', '-2', '-2', '-3' ],\n             'lD' => [ '-4', '-1', '-3', '1', '-3', '-1', '-3', '4' ],\n             'lR' => [ '-2', '-1', '-3', '0', '-4', '4', '-4', '-3' ],\n             'lI' => [ '0', '-3', '0', '-4', '6', '-4', '-2', '-2' ],\n             'lG' => [ '-4', '-2', '-4', '-2', '-5', '-3', '-1', '-2' ],\n             'pS' => [ '0', '33', '0', '16', '1', '12', '11', '25' ],\n             'pF' => [ '0', '0', '2', '0', '3', '0', '0', '0' ],\n             'pT' => [ '0', '8', '7', '10', '1', '2', '7', '8' ],\n             'pN' => [ '0', '0', '2', '13', '0', '36', '1', '4' ],\n             'pK' => [ '0', '5', '0', '13', '1', '15', '0', '2' ],\n             'pY' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pE' => [ '0', '41', '1', '12', '0', '0', '0', '15' ],\n             'pV' => [ '0', '3', '9', '0', '2', '0', '3', '1' ],\n             'pQ' => [ '0', '0', '0', '15', '0', '4', '0', '3' ],\n             'pM' => [ '100', '0', '66', '0', '2', '0', '0', '0' ],\n             'pC' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pL' => [ '0', '0', '8', '0', '25', '0', '4', '0' ],\n             'pA' => [ '0', '10', '1', '9', '2', '0', '22', '16' ],\n             'pW' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pP' => [ '0', '0', '0', '0', '3', '1', '45', '0' ],\n             'pH' => [ '0', '0', '0', '0', '0', '0', '1', '0' ],\n             'pD' => [ '0', '0', '1', '7', '2', '2', '0', '22' ],\n             'pR' => [ '0', '0', '0', '3', '0', '27', '0', '0' ],\n             'pI' => [ '0', '0', '3', '0', '59', '1', '2', '3' ],\n             'pG' => [ '0', '0', '0', '1', '0', '0', '4', '1' ],\n   );\n\n   my $matrix = Bio::Matrix::PSM::ProtMatrix( %param );\n\n\n   my $site = Bio::Matrix::PSM::ProtMatrix->new(%param);\n   # Or get it from a file:\n   use Bio::Matrix::PSM::IO;\n   my $psmIO = Bio::Matrix::PSM::IO->new(-file => $file, -format => 'psi-blast');\n   while (my $psm = $psmIO->next_psm) {\n      #Now we have a Bio::Matrix::PSM::Psm object, \n      # see Bio::Matrix::PSM::PsmI for details\n      #This is a Bio::Matrix::PSM::ProtMatrix object now\n      my $matrix = $psm->matrix;   \n   }\n\n   # Get a simple consensus, where alphabet is:\n   # {A, R, N, D, C, Q, E, G, H, I, L, K, M, F, P, S, T, W, Y, V,}\n   # choosing the highest probability or N if prob is too low\n   my $consensus = $site->consensus;\n\n   # Retrieving and using regular expressions:\n   my $regexp = $site->regexp;\n   my $count = grep($regexp,$seq);\n   my $count = ($seq=~ s/$regexp/$1/eg);\n   print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nProtMatrix is designed to provide some basic methods when working with\nposition scoring (weight) matrices related to protein sequences.  A\nprotein PSM consists of 20 vectors with 20 frequencies (one per amino\nacid per position).  This is the minimum information you should\nprovide to construct a PSM object.  The vectors can be provided as\nstrings with frequencies where the frequency is {0..a} and a=1. This\nis the way MEME compressed representation of a matrix and it is quite\nuseful when working with relational DB.  If arrays are provided as an\ninput (references to arrays actually) they can be any number, real or\ninteger (frequency or count).\n\nWhen creating the object the constructor will check for positions that\nequal 0.  If such is found it will increase the count for all\npositions by one and recalculate the frequency.  Potential bug - if\nyou are using frequencies and one of the positions is 0 it will change\nsignificantly.  However, you should never have frequency that equals\n0.\n\nThrows an exception if: You mix as an input array and string (for\nexample A matrix is given as array, C - as string).  The position\nvector is (0,0,0,0).  One of the probability vectors is shorter than\nthe rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n   iupac - return IUPAC compliant consensus as a string\n   score - Returns the score as a real number\n   IC - information content. Returns a real number\n   id - identifier. Returns a string\n   accession - accession number. Returns a string\n   next_pos - return the sequence probably for each letter, IUPAC\n         symbol, IUPAC probability and simple sequence\n   consenus letter for this position. Rewind at the end. Returns a hash.\n   pos - current position get/set. Returns an integer.\n   regexp - construct a regular expression based on IUPAC consensus.\n         For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n   width - site width\n   get_string - gets the probability vector for a single base as a string.\n   get_array - gets the probability vector for a single base as an array.\n   get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n   my $str=$matrix->get_compressed_freq('A');\nor\n\n   my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yet implemented.\nHowever you can still uncompress such string with:\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\n\nor\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.   Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Thompson\n\nEmail tex@biosysadmin.com\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::ProtMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title    : new\n Usage    : my $site = Bio::Matrix::PSM::ProtMatrix->new( \n               %probs,\n               %logs,\n               -IC    => $ic,\n               -e_val => $score, \n               -id    => $mid\n               -model => \\%model\n            );\n Function : Creates a new Bio::Matrix::PSM::ProtMatrix object from memory\n Throws   : If inconsistent data for all vectors (all 20 amino acids) is\n               provided, if you mix input types (string vs array) or if a\n               position freq is 0.\n Example  :\n Returns  : Bio::Matrix::PSM::ProtMatrix object\n Args     : Hash references to log-odds scores and probabilities for\n            position-specific scoring info, e-value (optional), information\n            content (optional), id (optional), model for background distribution\n            of proteins (optional)."}},{"line":220,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"name":"_position","line":241},{"kind":12,"name":"IC","line":242},{"line":242,"name":"IC","kind":12},{"line":243,"name":"e_val","kind":12},{"name":"e_val","kind":12,"line":243},{"name":"sites","kind":12,"line":244},{"line":244,"name":"sites","kind":12},{"name":"width","kind":12,"line":245},{"name":"width","kind":12,"line":245},{"name":"accession_number","kind":12,"line":246},{"name":"accession_number","kind":12,"line":246},{"kind":12,"name":"_correction","line":247},{"line":247,"name":"correction","kind":12},{"kind":12,"name":"correction","line":248},{"line":250,"kind":12,"name":"id"},{"line":250,"name":"id","kind":12},{"kind":12,"name":"id","line":250},{"kind":12,"name":"_alphabet","line":251},{"name":"_calculate_consensus","kind":12,"line":254},{"line":254,"kind":12,"name":"model"},{"containerName":"main::","name":"alphabet","children":[{"definition":"my","localvar":"my","containerName":"alphabet","kind":13,"name":"$self","line":272},{"line":274,"name":"$self","kind":13,"containerName":"alphabet"},{"line":276,"kind":13,"containerName":"alphabet","name":"$self"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":277},"start":{"character":0,"line":271}},"line":271},{"line":274,"name":"_alphabet","kind":12},{"line":276,"kind":12,"name":"_alphabet"},{"line":292,"range":{"end":{"character":9999,"line":297},"start":{"character":0,"line":292}},"kind":12,"children":[{"containerName":"_calculate_consensus","localvar":"my","kind":13,"name":"$self","line":293,"definition":"my"},{"name":"$thresh","kind":13,"localvar":"my","containerName":"_calculate_consensus","line":294,"definition":"my"},{"line":297,"name":"@lengths","containerName":"_calculate_consensus","localvar":"my","kind":13,"definition":"my"},{"name":"$_","containerName":"_calculate_consensus","kind":13,"line":297},{"containerName":"_calculate_consensus","kind":13,"name":"$self","line":297},{"line":297,"name":"$self","kind":13,"containerName":"_calculate_consensus"}],"name":"_calculate_consensus","containerName":"main::","definition":"sub"},{"line":297,"name":"_alphabet","kind":12},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$len","line":298},{"kind":13,"containerName":null,"name":"@lengths","line":298},{"containerName":null,"kind":13,"name":"@lengths","line":299},{"name":"%len","containerName":null,"kind":13,"line":300},{"name":"$self","kind":13,"containerName":null,"line":300},{"containerName":"main::","kind":12,"name":"throw","line":300},{"name":"$i","localvar":"my","containerName":null,"kind":13,"line":305,"definition":"my"},{"kind":13,"containerName":null,"name":"$i","line":305},{"kind":13,"containerName":null,"name":"$len","line":305},{"containerName":null,"kind":13,"name":"%i","line":305},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"@probs","line":307},{"line":307,"name":"%self","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$i","line":307},{"line":307,"containerName":null,"kind":13,"name":"%self"},{"line":307,"kind":12,"name":"_alphabet"},{"line":309,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"seq","line":309},{"containerName":null,"kind":13,"name":"$i","line":309},{"containerName":null,"kind":13,"name":"%self","line":309},{"line":309,"kind":12,"name":"seqp"},{"name":"$i","containerName":null,"kind":13,"line":309},{"line":309,"name":"$self","containerName":null,"kind":13},{"line":309,"name":"_to_cons","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"@probs","line":309},{"line":309,"kind":13,"containerName":null,"name":"$thresh"},{"line":312,"kind":13,"containerName":null,"name":"$self"},{"line":340,"range":{"end":{"line":344,"character":9999},"start":{"character":0,"line":340}},"kind":12,"children":[{"definition":"my","line":341,"localvar":"my","kind":13,"containerName":"next_pos","name":"$self"},{"name":"$self","containerName":"next_pos","kind":13,"line":342},{"kind":12,"containerName":"next_pos","name":"throw","line":342},{"containerName":"next_pos","kind":13,"name":"$self","line":342},{"definition":"my","line":344,"name":"$len","kind":13,"localvar":"my","containerName":"next_pos"},{"containerName":"next_pos","kind":13,"name":"$self","line":344}],"name":"next_pos","containerName":"main::","definition":"sub"},{"kind":12,"name":"seq","line":344},{"line":345,"containerName":null,"localvar":"my","kind":13,"name":"$pos","definition":"my"},{"containerName":null,"kind":13,"name":"%self","line":345},{"name":"_position","kind":12,"line":345},{"line":348,"name":"$pos","kind":13,"containerName":null},{"name":"%len","containerName":null,"kind":13,"line":348},{"localvar":"my","containerName":null,"kind":13,"name":"%probs","line":350,"definition":"my"},{"line":350,"name":"%self","containerName":null,"kind":13},{"line":350,"kind":13,"containerName":null,"name":"$pos"},{"line":350,"name":"%self","kind":13,"containerName":null},{"line":350,"name":"_alphabet","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"%logs","line":351},{"line":351,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$pos","line":351},{"containerName":null,"kind":13,"name":"%self","line":351},{"line":351,"name":"_alphabet","kind":12},{"line":352,"containerName":null,"localvar":"my","kind":13,"name":"$base","definition":"my"},{"line":352,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"seq","line":352},{"name":"$pos","containerName":null,"kind":13,"line":352},{"line":353,"name":"$prob","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":353,"name":"%self","kind":13,"containerName":null},{"line":353,"kind":12,"name":"seqp"},{"line":353,"name":"$pos","containerName":null,"kind":13},{"line":355,"name":"%self","kind":13,"containerName":null},{"name":"_position","kind":12,"line":355},{"definition":"my","name":"%hash","localvar":"my","kind":13,"containerName":null,"line":356},{"containerName":null,"kind":13,"name":"%probs","line":356},{"line":356,"name":"%logs","kind":13,"containerName":null},{"name":"base","kind":12,"line":356},{"line":356,"containerName":null,"kind":13,"name":"$base"},{"line":356,"kind":12,"name":"rel"},{"line":356,"name":"$pos","kind":13,"containerName":null},{"line":356,"name":"prob","kind":12},{"line":356,"containerName":null,"kind":13,"name":"%prob"},{"kind":13,"containerName":null,"name":"%hash","line":360},{"line":362,"containerName":null,"kind":13,"name":"%hash"},{"line":365,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"_position","line":365},{"kind":12,"range":{"end":{"line":387,"character":9999},"start":{"character":0,"line":383}},"line":383,"containerName":"main::","name":"curpos","children":[{"line":384,"name":"$self","containerName":"curpos","localvar":"my","kind":13,"definition":"my"},{"line":385,"name":"$self","kind":13,"containerName":"curpos"},{"line":386,"name":"$self","kind":13,"containerName":"curpos"}],"definition":"sub"},{"line":385,"kind":12,"name":"_position"},{"line":386,"kind":12,"name":"_position"},{"range":{"end":{"character":9999,"line":406},"start":{"character":0,"line":402}},"kind":12,"line":402,"name":"e_val","containerName":"main::","children":[{"line":403,"name":"$self","localvar":"my","containerName":"e_val","kind":13,"definition":"my"},{"line":404,"name":"$self","kind":13,"containerName":"e_val"},{"kind":13,"containerName":"e_val","name":"$self","line":405}],"definition":"sub"},{"line":404,"name":"e_val","kind":12},{"line":405,"name":"e_val","kind":12},{"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"IC","kind":13,"line":422,"definition":"my"},{"name":"$self","kind":13,"containerName":"IC","line":423},{"name":"$self","containerName":"IC","kind":13,"line":424}],"name":"IC","containerName":"main::","line":421,"kind":12,"range":{"end":{"character":9999,"line":425},"start":{"character":0,"line":421}}},{"kind":12,"name":"IC","line":423},{"line":424,"name":"IC","kind":12},{"range":{"start":{"line":440,"character":0},"end":{"character":9999,"line":444}},"kind":12,"line":440,"containerName":"main::","name":"accession_number","children":[{"line":441,"name":"$self","localvar":"my","kind":13,"containerName":"accession_number","definition":"my"},{"kind":13,"containerName":"accession_number","name":"$self","line":442},{"line":443,"name":"$self","containerName":"accession_number","kind":13}],"definition":"sub"},{"name":"accession_number","kind":12,"line":442},{"line":443,"kind":12,"name":"accession_number"},{"definition":"sub","containerName":"main::","name":"consensus","children":[{"line":459,"name":"$self","localvar":"my","kind":13,"containerName":"consensus","definition":"my"},{"definition":"my","name":"$thresh","localvar":"my","containerName":"consensus","kind":13,"line":460},{"line":461,"name":"$self","kind":13,"containerName":"consensus"},{"line":461,"containerName":"consensus","kind":12,"name":"_calculate_consensus"},{"line":461,"kind":13,"containerName":"consensus","name":"$thresh"},{"containerName":"consensus","kind":13,"name":"$thresh","line":461},{"definition":"my","line":462,"localvar":"my","containerName":"consensus","kind":13,"name":"$consensus"},{"name":"$letter","localvar":"my","containerName":"consensus","kind":13,"line":464,"definition":"my"},{"containerName":"consensus","kind":13,"name":"$self","line":464}],"kind":12,"range":{"end":{"line":464,"character":9999},"start":{"character":0,"line":458}},"line":458},{"line":464,"kind":12,"name":"seq"},{"line":465,"name":"$consensus","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$letter","line":465},{"name":"$consensus","kind":13,"containerName":null,"line":468},{"kind":12,"range":{"start":{"line":471,"character":0},"end":{"line":474,"character":9999}},"line":471,"definition":"sub","name":"IUPAC","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"IUPAC","name":"$self","line":472,"definition":"my"},{"name":"$self","kind":13,"containerName":"IUPAC","line":473},{"line":473,"containerName":"IUPAC","kind":12,"name":"consensus"}]},{"containerName":"main::","name":"get_string","children":[{"definition":"my","localvar":"my","containerName":"get_string","kind":13,"name":"$self","line":491},{"name":"$base","localvar":"my","kind":13,"containerName":"get_string","line":492,"definition":"my"},{"line":493,"name":"$string","kind":13,"localvar":"my","containerName":"get_string","definition":"my"},{"definition":"my","line":495,"name":"@prob","localvar":"my","containerName":"get_string","kind":13},{"kind":13,"containerName":"get_string","name":"$self","line":495}],"definition":"sub","kind":12,"range":{"start":{"line":490,"character":0},"end":{"line":495,"character":9999}},"line":490},{"kind":13,"containerName":null,"name":"@prob","line":496},{"name":"$self","kind":13,"containerName":null,"line":497},{"kind":12,"containerName":"main::","name":"throw","line":497},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$prob","line":500},{"line":500,"name":"@prob","containerName":null,"kind":13},{"kind":13,"localvar":"my","containerName":null,"name":"$corrected","line":501,"definition":"my"},{"containerName":null,"kind":13,"name":"$prob","line":501},{"name":"$next","kind":13,"localvar":"my","containerName":null,"line":502,"definition":"my"},{"line":502,"name":"$corrected","containerName":null,"kind":13},{"line":503,"kind":13,"containerName":null,"name":"$next"},{"line":503,"name":"$next","kind":13,"containerName":null},{"line":504,"name":"$string","containerName":null,"kind":13},{"line":504,"name":"$next","kind":13,"containerName":null},{"name":"$string","kind":13,"containerName":null,"line":506},{"kind":12,"range":{"start":{"line":523,"character":0},"end":{"line":525,"character":9999}},"line":523,"containerName":"main::","name":"width","children":[{"kind":13,"localvar":"my","containerName":"width","name":"$self","line":524,"definition":"my"},{"definition":"my","line":525,"name":"$width","localvar":"my","kind":13,"containerName":"width"},{"kind":13,"containerName":"width","name":"$self","line":525}],"definition":"sub"},{"line":525,"kind":12,"name":"probA"},{"name":"$width","kind":13,"containerName":null,"line":526},{"name":"get_array","containerName":"main::","children":[{"line":542,"localvar":"my","containerName":"get_array","kind":13,"name":"$self","definition":"my"},{"line":543,"name":"$letter","localvar":"my","kind":13,"containerName":"get_array","definition":"my"},{"containerName":"get_array","kind":13,"name":"$self","line":545},{"line":545,"containerName":"get_array","kind":12,"name":"throw"},{"name":"$self","kind":13,"containerName":"get_array","line":545}],"definition":"sub","range":{"end":{"line":545,"character":9999},"start":{"character":0,"line":541}},"kind":12,"line":541},{"line":545,"name":"_alphabet","kind":12},{"name":"%self","kind":13,"containerName":null,"line":547},{"definition":"sub","containerName":"main::","name":"get_logs_array","children":[{"definition":"my","line":564,"localvar":"my","kind":13,"containerName":"get_logs_array","name":"$self"},{"containerName":"get_logs_array","localvar":"my","kind":13,"name":"$letter","line":565,"definition":"my"},{"kind":13,"containerName":"get_logs_array","name":"$self","line":567},{"kind":12,"containerName":"get_logs_array","name":"throw","line":567},{"name":"$self","kind":13,"containerName":"get_logs_array","line":567}],"kind":12,"range":{"end":{"line":567,"character":9999},"start":{"character":0,"line":563}},"line":563},{"kind":12,"name":"_alphabet","line":567},{"name":"%self","containerName":null,"kind":13,"line":569},{"definition":"sub","children":[{"definition":"my","line":585,"name":"$self","containerName":"id","localvar":"my","kind":13},{"line":586,"containerName":"id","kind":13,"name":"$self"},{"name":"$self","containerName":"id","kind":13,"line":587}],"containerName":"main::","name":"id","line":584,"range":{"start":{"line":584,"character":0},"end":{"line":588,"character":9999}},"kind":12},{"line":586,"kind":12,"name":"id"},{"line":587,"name":"id","kind":12},{"children":[{"definition":"my","line":605,"name":"$self","containerName":"regexp","localvar":"my","kind":13},{"definition":"my","line":606,"name":"$threshold","localvar":"my","containerName":"regexp","kind":13},{"name":"$threshold","containerName":"regexp","localvar":"my","kind":13,"line":607,"definition":"my"},{"definition":"my","localvar":"my","containerName":"regexp","kind":13,"name":"@alphabet","line":609},{"kind":13,"containerName":"regexp","name":"$self","line":609}],"containerName":"main::","name":"regexp","definition":"sub","line":604,"kind":12,"range":{"end":{"line":609,"character":9999},"start":{"character":0,"line":604}}},{"line":609,"kind":12,"name":"_alphabet"},{"localvar":"my","containerName":null,"kind":13,"name":"$width","line":610,"definition":"my"},{"name":"$self","kind":13,"containerName":null,"line":610},{"line":610,"containerName":"main::","kind":12,"name":"width"},{"definition":"my","line":611,"name":"@regexp","localvar":"my","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":611},{"name":"$i","containerName":null,"kind":13,"line":612},{"kind":13,"containerName":null,"name":"$i","line":612},{"kind":13,"containerName":null,"name":"$width","line":612},{"name":"%i","containerName":null,"kind":13,"line":612},{"definition":"my","line":614,"name":"@letters","containerName":null,"localvar":"my","kind":13},{"line":614,"name":"%self","kind":13,"containerName":null},{"line":614,"containerName":null,"kind":13,"name":"$i"},{"line":614,"name":"$threshold","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@alphabet","line":614},{"name":"$reg","containerName":null,"localvar":"my","kind":13,"line":616,"definition":"my"},{"name":"@letters","kind":13,"containerName":null,"line":617},{"line":618,"name":"%reg","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$reg","line":620},{"line":620,"name":"@letters","kind":13,"containerName":null},{"line":622,"name":"@regexp","containerName":null,"kind":13},{"name":"%reg","containerName":null,"kind":13,"line":622},{"line":626,"name":"@regexp","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@regexp","line":628},{"children":[{"localvar":"my","containerName":"regexp_array","kind":13,"name":"$self","line":649,"definition":"my"},{"name":"$self","containerName":"regexp_array","kind":13,"line":651},{"line":651,"name":"regexp","containerName":"regexp_array","kind":12}],"name":"regexp_array","containerName":"main::","definition":"sub","line":648,"range":{"start":{"character":0,"line":648},"end":{"line":651,"character":9999}},"kind":12},{"kind":12,"range":{"start":{"line":669,"character":0},"end":{"character":9999,"line":675}},"line":669,"signature":{"label":"_compress_array($array,$lm,$direct)","documentation":"1;\n# $Id: ProtMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::ProtMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) with log-odds scoring\ninformation.\n\n=head1 SYNOPSIS\n\n   use Bio::Matrix::PSM::ProtMatrix;\n   # Create from memory by supplying probability matrix hash both as strings or\n   # arrays where the frequencies   Hash entries of the form lN refer to an array\n   # of position-specific log-odds scores for amino acid N. Hash entries of the\n   # form pN represent the position-specific probability of finding amino acid N.\n\n   my %param = (\n             'id' => 'A. thaliana protein atp1',\n             '-e_val' => $score,\n             'lS' => [ '-2', '3', '-3', '2', '-3', '1', '1', '3' ],\n             'lF' => [ '-1', '-4', '0', '-5', '0', '-5', '-4', '-4' ],\n             'lT' => [ '-1', '1', '0', '1', '-2', '-1', '0', '1' ],\n             'lN' => [ '-3', '-1', '-2', '3', '-5', '5', '-2', '0' ],\n             'lK' => [ '-2', '0', '-3', '2', '-3', '2', '-3', '-1' ],\n             'lY' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-4', '-4' ],\n             'lE' => [ '-3', '4', '-3', '2', '-4', '-2', '-3', '2' ],\n             'lV' => [ '0', '-2', '1', '-4', '1', '-4', '-1', '-3' ],\n             'lQ' => [ '-1', '0', '-2', '3', '-4', '1', '-3', '0' ],\n             'lM' => [ '8', '-3', '8', '-3', '1', '-3', '-3', '-3' ],\n             'lC' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-3', '-3' ],\n             'lL' => [ '1', '-3', '1', '-4', '3', '-4', '-2', '-4' ],\n             'lA' => [ '-2', '1', '-2', '0', '-2', '-2', '2', '2' ],\n             'lW' => [ '-2', '-4', '-3', '-5', '-4', '-5', '-5', '-5' ],\n             'lP' => [ '-3', '-2', '-4', '-3', '-1', '-3', '6', '-3' ],\n             'lH' => [ '-2', '-2', '-3', '-2', '-5', '-2', '-2', '-3' ],\n             'lD' => [ '-4', '-1', '-3', '1', '-3', '-1', '-3', '4' ],\n             'lR' => [ '-2', '-1', '-3', '0', '-4', '4', '-4', '-3' ],\n             'lI' => [ '0', '-3', '0', '-4', '6', '-4', '-2', '-2' ],\n             'lG' => [ '-4', '-2', '-4', '-2', '-5', '-3', '-1', '-2' ],\n             'pS' => [ '0', '33', '0', '16', '1', '12', '11', '25' ],\n             'pF' => [ '0', '0', '2', '0', '3', '0', '0', '0' ],\n             'pT' => [ '0', '8', '7', '10', '1', '2', '7', '8' ],\n             'pN' => [ '0', '0', '2', '13', '0', '36', '1', '4' ],\n             'pK' => [ '0', '5', '0', '13', '1', '15', '0', '2' ],\n             'pY' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pE' => [ '0', '41', '1', '12', '0', '0', '0', '15' ],\n             'pV' => [ '0', '3', '9', '0', '2', '0', '3', '1' ],\n             'pQ' => [ '0', '0', '0', '15', '0', '4', '0', '3' ],\n             'pM' => [ '100', '0', '66', '0', '2', '0', '0', '0' ],\n             'pC' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pL' => [ '0', '0', '8', '0', '25', '0', '4', '0' ],\n             'pA' => [ '0', '10', '1', '9', '2', '0', '22', '16' ],\n             'pW' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pP' => [ '0', '0', '0', '0', '3', '1', '45', '0' ],\n             'pH' => [ '0', '0', '0', '0', '0', '0', '1', '0' ],\n             'pD' => [ '0', '0', '1', '7', '2', '2', '0', '22' ],\n             'pR' => [ '0', '0', '0', '3', '0', '27', '0', '0' ],\n             'pI' => [ '0', '0', '3', '0', '59', '1', '2', '3' ],\n             'pG' => [ '0', '0', '0', '1', '0', '0', '4', '1' ],\n   );\n\n   my $matrix = Bio::Matrix::PSM::ProtMatrix( %param );\n\n\n   my $site = Bio::Matrix::PSM::ProtMatrix->new(%param);\n   # Or get it from a file:\n   use Bio::Matrix::PSM::IO;\n   my $psmIO = Bio::Matrix::PSM::IO->new(-file => $file, -format => 'psi-blast');\n   while (my $psm = $psmIO->next_psm) {\n      #Now we have a Bio::Matrix::PSM::Psm object, \n      # see Bio::Matrix::PSM::PsmI for details\n      #This is a Bio::Matrix::PSM::ProtMatrix object now\n      my $matrix = $psm->matrix;   \n   }\n\n   # Get a simple consensus, where alphabet is:\n   # {A, R, N, D, C, Q, E, G, H, I, L, K, M, F, P, S, T, W, Y, V,}\n   # choosing the highest probability or N if prob is too low\n   my $consensus = $site->consensus;\n\n   # Retrieving and using regular expressions:\n   my $regexp = $site->regexp;\n   my $count = grep($regexp,$seq);\n   my $count = ($seq=~ s/$regexp/$1/eg);\n   print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nProtMatrix is designed to provide some basic methods when working with\nposition scoring (weight) matrices related to protein sequences.  A\nprotein PSM consists of 20 vectors with 20 frequencies (one per amino\nacid per position).  This is the minimum information you should\nprovide to construct a PSM object.  The vectors can be provided as\nstrings with frequencies where the frequency is {0..a} and a=1. This\nis the way MEME compressed representation of a matrix and it is quite\nuseful when working with relational DB.  If arrays are provided as an\ninput (references to arrays actually) they can be any number, real or\ninteger (frequency or count).\n\nWhen creating the object the constructor will check for positions that\nequal 0.  If such is found it will increase the count for all\npositions by one and recalculate the frequency.  Potential bug - if\nyou are using frequencies and one of the positions is 0 it will change\nsignificantly.  However, you should never have frequency that equals\n0.\n\nThrows an exception if: You mix as an input array and string (for\nexample A matrix is given as array, C - as string).  The position\nvector is (0,0,0,0).  One of the probability vectors is shorter than\nthe rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n   iupac - return IUPAC compliant consensus as a string\n   score - Returns the score as a real number\n   IC - information content. Returns a real number\n   id - identifier. Returns a string\n   accession - accession number. Returns a string\n   next_pos - return the sequence probably for each letter, IUPAC\n         symbol, IUPAC probability and simple sequence\n   consenus letter for this position. Rewind at the end. Returns a hash.\n   pos - current position get/set. Returns an integer.\n   regexp - construct a regular expression based on IUPAC consensus.\n         For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n   width - site width\n   get_string - gets the probability vector for a single base as a string.\n   get_array - gets the probability vector for a single base as an array.\n   get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n   my $str=$matrix->get_compressed_freq('A');\nor\n\n   my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yet implemented.\nHowever you can still uncompress such string with:\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\n\nor\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.   Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Thompson\n\nEmail tex@biosysadmin.com\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::ProtMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title    : new\n Usage    : my $site = Bio::Matrix::PSM::ProtMatrix->new( \n               %probs,\n               %logs,\n               -IC    => $ic,\n               -e_val => $score, \n               -id    => $mid\n               -model => \\%model\n            );\n Function : Creates a new Bio::Matrix::PSM::ProtMatrix object from memory\n Throws   : If inconsistent data for all vectors (all 20 amino acids) is\n               provided, if you mix input types (string vs array) or if a\n               position freq is 0.\n Example  :\n Returns  : Bio::Matrix::PSM::ProtMatrix object\n Args     : Hash references to log-odds scores and probabilities for\n            position-specific scoring info, e-value (optional), information\n            content (optional), id (optional), model for background distribution\n            of proteins (optional).\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   my $consensus;\n   #Too many things to rearrange, and I am creating simultanuously >500 \n   # such objects routinely, so this becomes performance issue\n   my %input;\n   while( @args ) {\n     (my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n     $input{$key} = shift @args;\n   }\n\n   # get a protein alphabet for processing log-odds scores and probabilities\n   # maybe change this later on to allow for non-standard aa lists? \n   my @alphabet = qw/A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V/;\n\n   foreach my $aa (@alphabet) {\n      $self->{\"log$aa\"}  = defined($input{\"l$aa\"}) ? $input{\"l$aa\"} \n         : $self->throw(\"Error: No log-odds information for $aa!\");\n      $self->{\"prob$aa\"}  = defined($input{\"p$aa\"}) ? $input{\"p$aa\"} \n         : $self->throw(\"Error: No probability information for $aa!\");\n   }\n   \n   $self->{_position} = 0;\n   $self->{IC}        = $input{IC};\n   $self->{e_val}     = $input{e_val};\n   $self->{sites}     = $input{sites};\n   $self->{width}     = $input{width};\n   $self->{accession_number} = $input{accession_number};\n   $self->{_correction} = defined($input{correction}) ?\n      $input{correction} : 1 ; # Correction might be unwanted- supply your own\n   # No id provided, null for the sake of rel db\n   $self->{id} = defined($input{id}) ? $input{id} : 'null'; \n   $self->{_alphabet} = \\@alphabet;\n\n   #Make consensus, throw if any one of the vectors is shorter\n   $self = _calculate_consensus($self,$input{model});\n   return $self;\n}\n\n=head2 alphabet\n\n Title    : Returns an array (or array reference if desired) to the alphabet \n Usage    :\n Function : Returns an array (or array reference) containing all of the\n            allowable characters for this matrix.\n Throws   :\n Example  :\n Returns  : Array or arrary reference.\n Args     :\n\n\nsub alphabet {\n   my $self = shift;\n   if ( wantarray ) {\n      return $self->{_alphabet};\n   } else {\n      return @{$self->{_alphabet}};\n   }\n}\n\n=head2 _calculate_consensus\n\n Title    : _calculate_consensus\n Usage    :\n Function : Calculates the consensus sequence for this matrix. \n Throws   :\n Example  :\n Returns  :\n Args     :\n\n\nsub _calculate_consensus {\n   my $self   = shift;\n   my $thresh = shift;\n   \n   # verify that all of the array lengths in %probs are the same\n   my @lengths = map { scalar(@$_) } map {$self->{\"prob$_\"}} @{ $self->{_alphabet} };\n   my $len = shift @lengths;\n   for ( @lengths ) {\n      if ( $_ ne $len ) { $self->throw( \"Probability matrix is damaged!\\n\" ) };\n   }\n\n   # iterate over probs, generate the most likely sequence and put it into \n   # $self->{seq}. Put the probability of this sequence into $self->{seqp}.\n   for ( my $i = 0; $i < $len; $i++ ) {\n      # get a list of all the probabilities at position $i, ordered by $self->{_alphabet}\n      my @probs = map { ${$self->{\"prob$_\"}}[$i] } @{ $self->{_alphabet} };\n      # calculate the consensus of @probs, put sequence into seqp and probabilities into seqp\n      (${$self->{seq}}[$i],${$self->{seqp}}[$i]) = $self->_to_cons( @probs, $thresh );\n   }\n\n   return $self;\n}\n\n=head2 next_pos\n\n Title    : next_pos\n Usage    :\n Function : Retrives the next position features: frequencies for all 20 amino\n            acids, log-odds scores for all 20 amino acids at this position,\n            the main (consensus) letter at this position, the probability\n            for the consensus letter to occur at this position and the relative\n            current position as an integer.\n Throws   :\n Example  :\n Returns  : hash (or hash reference) (pA,pR,pN,pD,...,logA,logR,logN,logD,aa,prob,rel)\n            - pN entries represent the probability for amino acid N\n            to be at this position\n            - logN entries represent the log-odds score for having amino acid\n            N at this position\n            - aa is the consensus amino acid\n            - prob is the probability for the consensus amino acid to be at this \n            position\n            - rel is the relative index of the current position (integer)\n Args      : none\n\n\n\nsub next_pos {\n      my $self = shift;\n         $self->throw(\"instance method called on class\") unless ref $self;\n\n      my $len = @{$self->{seq}};\n      my $pos = $self->{_position};\n\n      # return a PSM if we're still within range\n      if ($pos<$len) {\n\n         my %probs = map { (\"p$_\", ${$self->{\"prob$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my %logs  = map { (\"l$_\", ${$self->{\"log$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my $base  = ${$self->{seq}}[$pos];\n         my $prob  = ${$self->{seqp}}[$pos];\n\n         $self->{_position}++;\n         my %hash = ( %probs, %logs, base => $base, rel => $pos, prob => $prob );\n         \n         # decide whether to return the hash or a reference to it\n         if ( wantarray ) {\n            return %hash;\n         } else {\n            return \\%hash;\n         }\n   } else { # otherwise, reset $self->{_position} and return nothing\n      $self->{_position} = 0; \n      return;\n   }\n}\n\n\n=head2 curpos\n\n Title    : curpos\n Usage    :\n Function : Gets/sets the current position. \n Throws   :\n Example  :\n Returns  : Current position (integer).\n Args     : New position (integer).\n\n\nsub curpos {\n      my $self = shift;\n      if (@_) { $self->{_position} = shift; }\n      return $self->{_position};\n}\n\n\n=head2 e_val\n\n Title    : e_val\n Usage    :\n Function : Gets/sets the e-value\n Throws   :\n Example  :\n Returns  : \n Args     : real number\n\n\nsub e_val {\n      my $self = shift;\n      if (@_) { $self->{e_val} = shift; }\n      return $self->{e_val};\n}\n\n\n=head2 IC\n\n Title    : IC\n Usage    :\n Function : Position-specific information content.\n Throws   :\n Example  :\n Returns  : Information content for current position.\n Args     : Information content for current position.\n\n\nsub IC {\n      my $self = shift;\n      if (@_) { $self->{IC} = shift; }\n      return $self->{IC};\n}\n\n=head2 accession_number\n\n Title    : accession_number\n Usage    :\n Function: accession number, this will be unique id for the ProtMatrix object as\n            well for any other object, inheriting from ProtMatrix.\n Throws   :\n Example  :\n Returns  : New accession number (string)\n Args     : Accession number (string)\n\n\nsub accession_number {\n      my $self = shift;\n      if (@_) { $self->{accession_number} = shift; }\n      return $self->{accession_number};\n}\n\n=head2 consensus\n\n Title    : consensus\n Usage    :\n Function : Returns the consensus sequence for this PSM.\n Throws   : if supplied with thresold outisde 5..10 range\n Example  :\n Returns  : string\n Args     : (optional) threshold value 5 to 10 (corresponds to 50-100% at each position\n\n\nsub consensus {\n   my $self = shift;\n   my $thresh=shift;\n   $self->_calculate_consensus($thresh) if ($thresh); #Change of threshold\n   my $consensus='';\n\n   foreach my $letter (@{$self->{seq}}) {\n       $consensus .= $letter;\n   }\n\n   return $consensus;\n}\n\nsub IUPAC {\n   my $self = shift;\n   return $self->consensus;\n}\n\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n            store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Example :\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n   my $self = shift;\n   my $base = shift;\n   my $string = '';\n\n   my @prob = @{$self->{\"prob$base\"}};\n   if ( ! @prob ) {\n      $self->throw( \"No such base: $base\\n\");\n   }\n\n   foreach my $prob (@prob) {\n      my $corrected = $prob*10;\n      my $next = sprintf(\"%.0f\",$corrected);\n      $next = 'a' if ($next eq '10');\n      $string .= $next;\n   }\n   return $string;\n}\n\n\n\n=head2 width\n\n Title    : width\n Usage    :\n Function : Returns the length of the site\n Throws   :\n Example  :\n Returns  : number\n Args     :\n\n\nsub width {\n   my $self = shift;\n   my $width = @{$self->{probA}};\n   return $width;\n}\n\n=head2 get_array\n\n Title    : get_array\n Usage    :\n Function : Returns an array with frequencies for a specified amino acid.\n Throws   :\n Example  :\n Returns  : Array representing frequencies for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"prob$letter\"}}; \n}\n\n\n=head2 get_logs_array\n\n Title    : get_logs_array\n Usage    :\n Function : Returns an array with log_odds for a specified base\n Throws   :\n Example  :\n Returns  : Array representing log-odds scores for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_logs_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"log$letter\"}}; \n}\n\n=head2 id\n\n Title    : id\n Usage    :\n Function : Gets/sets the site id\n Throws   :\n Example  :\n Returns  : string\n Args     : string\n\n\nsub id {\n      my $self = shift;\n      if (@_) { $self->{id} = shift; }\n      return $self->{id};\n}\n\n=head2 regexp\n\n Title    : regexp\n Usage    :\n Function : Returns a case-insensitive regular expression which matches the\n            IUPAC convention.  X's in consensus sequence will match anything.     \n Throws   :\n Example  :\n Returns  : string\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n\n\nsub regexp {\n   my $self = shift;\n   my $threshold = 20;\n   if ( @_ ) { my $threshold = shift };\n\n   my @alphabet = @{$self->{_alphabet}};\n   my $width = $self->width;\n   my (@regexp, $i);\n   for ( $i = 0; $i < $width; $i++ ) {\n      # get an array of the residues at this position with p > $threshold\n      my @letters = map { uc($_).lc($_) } grep { $self->{\"prob$_\"}->[$i] >= $threshold } @alphabet;\n\n      my $reg;\n      if ( scalar(@letters) == 0 ) {\n         $reg = '\\.';\n      } else {\n         $reg = '['.join('',@letters).']';\n      }\n      push @regexp, $reg;\n   }\n\n   if ( wantarray ) { \n      return @regexp;\n   } else {\n      return join '', @regexp;\n   }\n}\n\n\n=head2 regexp_array\n\n Title    : regexp_array\n Usage    :\n Function : Returns an array of position-specific regular expressions.\n             X's in consensus sequence will match anything.      \n Throws   :\n Example  :\n Returns  : Array of position-specific regular expressions.\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n Notes    : Simply calls regexp method in list context.\n\n\nsub regexp_array {\n   my $self = shift;\n   \n   return @{ $self->regexp };\n}\n\n\n=head2 _compress_array\n\n Title    : _compress_array\n Usage    :\n Function :  Will compress an array of real signed numbers to a string (ie vector of bytes)\n             -127 to +127 for bi-directional(signed) and 0..255 for unsigned ;\n Throws   :\n Example  :  Internal stuff\n Returns  :  String\n Args     :  array reference, followed by max value and direction (optional, defaults to 1),\n             direction of 1 is unsigned, anything else is signed. ","parameters":[{"label":"$array"},{"label":"$lm"},{"label":"$direct"}]},"containerName":"main::","name":"_compress_array","children":[{"definition":"my","line":670,"localvar":"my","kind":13,"containerName":"_compress_array","name":"$array"},{"name":"$lm","containerName":"_compress_array","kind":13,"line":670},{"name":"$direct","containerName":"_compress_array","kind":13,"line":670},{"definition":"my","line":671,"kind":13,"localvar":"my","containerName":"_compress_array","name":"$str"},{"line":672,"name":"$array","containerName":"_compress_array","kind":13},{"kind":13,"containerName":"_compress_array","name":"$lm","line":672},{"line":673,"kind":13,"containerName":"_compress_array","name":"$direct"},{"line":673,"kind":13,"containerName":"_compress_array","name":"$direct"},{"definition":"my","line":674,"localvar":"my","kind":13,"containerName":"_compress_array","name":"$k1"},{"line":674,"name":"$direct","kind":13,"containerName":"_compress_array"},{"kind":13,"containerName":"_compress_array","name":"$lm","line":674},{"name":"$lm","containerName":"_compress_array","kind":13,"line":674},{"name":"$c","localvar":"my","containerName":"_compress_array","kind":13,"line":675,"definition":"my"},{"line":675,"containerName":"_compress_array","kind":13,"name":"$array"}],"detail":"($array,$lm,$direct)","definition":"sub"},{"kind":13,"containerName":null,"name":"$c","line":676},{"name":"$lm","kind":13,"containerName":null,"line":676},{"containerName":null,"kind":13,"name":"$c","line":676},{"line":676,"containerName":null,"kind":13,"name":"$lm"},{"line":677,"containerName":null,"kind":13,"name":"$c"},{"line":677,"name":"$lm","containerName":null,"kind":13},{"name":"$c","kind":13,"containerName":null,"line":677},{"kind":13,"containerName":null,"name":"$lm","line":677},{"kind":13,"containerName":null,"name":"$direct","line":677},{"line":678,"name":"$c","containerName":null,"kind":13},{"line":678,"name":"$c","kind":13,"containerName":null},{"line":678,"containerName":null,"kind":13,"name":"$direct"},{"line":679,"name":"$byte","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"$k1","containerName":null,"kind":13,"line":679},{"line":679,"kind":13,"containerName":null,"name":"$c"},{"line":680,"name":"$byte","kind":13,"containerName":null},{"line":680,"name":"$byte","containerName":null,"kind":13},{"line":680,"name":"$direct","containerName":null,"kind":13},{"definition":"my","line":681,"localvar":"my","containerName":null,"kind":13,"name":"$char"},{"line":681,"containerName":null,"kind":13,"name":"$byte"},{"name":"$str","containerName":null,"kind":13,"line":682},{"line":682,"name":"$char","containerName":null,"kind":13},{"line":684,"name":"$str","containerName":null,"kind":13},{"definition":"sub","detail":"($str,$lm,$direct)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_uncompress_string","name":"$str","line":702},{"line":702,"kind":13,"containerName":"_uncompress_string","name":"$lm"},{"containerName":"_uncompress_string","kind":13,"name":"$direct","line":702},{"definition":"my","line":703,"kind":13,"localvar":"my","containerName":"_uncompress_string","name":"@array"},{"line":704,"name":"$str","containerName":"_uncompress_string","kind":13},{"kind":13,"containerName":"_uncompress_string","name":"$lm","line":704},{"name":"$direct","kind":13,"containerName":"_uncompress_string","line":705},{"containerName":"_uncompress_string","kind":13,"name":"$direct","line":705},{"kind":13,"localvar":"my","containerName":"_uncompress_string","name":"$k1","line":706,"definition":"my"},{"name":"$direct","containerName":"_uncompress_string","kind":13,"line":706},{"line":706,"kind":13,"containerName":"_uncompress_string","name":"$lm"},{"line":706,"name":"$lm","containerName":"_uncompress_string","kind":13},{"definition":"my","line":707,"name":"$c","containerName":"_uncompress_string","localvar":"my","kind":13},{"line":707,"name":"$str","kind":13,"containerName":"_uncompress_string"},{"line":708,"kind":13,"localvar":"my","containerName":"_uncompress_string","name":"$byte","definition":"my"},{"line":708,"name":"$c","kind":13,"containerName":"_uncompress_string"},{"name":"$byte","containerName":"_uncompress_string","kind":13,"line":709},{"line":709,"kind":13,"containerName":"_uncompress_string","name":"$byte"},{"kind":13,"containerName":"_uncompress_string","name":"$direct","line":709},{"line":710,"kind":13,"localvar":"my","containerName":"_uncompress_string","name":"$num","definition":"my"},{"line":710,"name":"$byte","containerName":"_uncompress_string","kind":13},{"name":"$k1","kind":13,"containerName":"_uncompress_string","line":710},{"line":711,"name":"@array","kind":13,"containerName":"_uncompress_string"},{"containerName":"_uncompress_string","kind":13,"name":"$num","line":711},{"containerName":"_uncompress_string","kind":13,"name":"@array","line":714}],"containerName":"main::","name":"_uncompress_string","signature":{"documentation":"1;\n# $Id: ProtMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::ProtMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) with log-odds scoring\ninformation.\n\n=head1 SYNOPSIS\n\n   use Bio::Matrix::PSM::ProtMatrix;\n   # Create from memory by supplying probability matrix hash both as strings or\n   # arrays where the frequencies   Hash entries of the form lN refer to an array\n   # of position-specific log-odds scores for amino acid N. Hash entries of the\n   # form pN represent the position-specific probability of finding amino acid N.\n\n   my %param = (\n             'id' => 'A. thaliana protein atp1',\n             '-e_val' => $score,\n             'lS' => [ '-2', '3', '-3', '2', '-3', '1', '1', '3' ],\n             'lF' => [ '-1', '-4', '0', '-5', '0', '-5', '-4', '-4' ],\n             'lT' => [ '-1', '1', '0', '1', '-2', '-1', '0', '1' ],\n             'lN' => [ '-3', '-1', '-2', '3', '-5', '5', '-2', '0' ],\n             'lK' => [ '-2', '0', '-3', '2', '-3', '2', '-3', '-1' ],\n             'lY' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-4', '-4' ],\n             'lE' => [ '-3', '4', '-3', '2', '-4', '-2', '-3', '2' ],\n             'lV' => [ '0', '-2', '1', '-4', '1', '-4', '-1', '-3' ],\n             'lQ' => [ '-1', '0', '-2', '3', '-4', '1', '-3', '0' ],\n             'lM' => [ '8', '-3', '8', '-3', '1', '-3', '-3', '-3' ],\n             'lC' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-3', '-3' ],\n             'lL' => [ '1', '-3', '1', '-4', '3', '-4', '-2', '-4' ],\n             'lA' => [ '-2', '1', '-2', '0', '-2', '-2', '2', '2' ],\n             'lW' => [ '-2', '-4', '-3', '-5', '-4', '-5', '-5', '-5' ],\n             'lP' => [ '-3', '-2', '-4', '-3', '-1', '-3', '6', '-3' ],\n             'lH' => [ '-2', '-2', '-3', '-2', '-5', '-2', '-2', '-3' ],\n             'lD' => [ '-4', '-1', '-3', '1', '-3', '-1', '-3', '4' ],\n             'lR' => [ '-2', '-1', '-3', '0', '-4', '4', '-4', '-3' ],\n             'lI' => [ '0', '-3', '0', '-4', '6', '-4', '-2', '-2' ],\n             'lG' => [ '-4', '-2', '-4', '-2', '-5', '-3', '-1', '-2' ],\n             'pS' => [ '0', '33', '0', '16', '1', '12', '11', '25' ],\n             'pF' => [ '0', '0', '2', '0', '3', '0', '0', '0' ],\n             'pT' => [ '0', '8', '7', '10', '1', '2', '7', '8' ],\n             'pN' => [ '0', '0', '2', '13', '0', '36', '1', '4' ],\n             'pK' => [ '0', '5', '0', '13', '1', '15', '0', '2' ],\n             'pY' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pE' => [ '0', '41', '1', '12', '0', '0', '0', '15' ],\n             'pV' => [ '0', '3', '9', '0', '2', '0', '3', '1' ],\n             'pQ' => [ '0', '0', '0', '15', '0', '4', '0', '3' ],\n             'pM' => [ '100', '0', '66', '0', '2', '0', '0', '0' ],\n             'pC' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pL' => [ '0', '0', '8', '0', '25', '0', '4', '0' ],\n             'pA' => [ '0', '10', '1', '9', '2', '0', '22', '16' ],\n             'pW' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pP' => [ '0', '0', '0', '0', '3', '1', '45', '0' ],\n             'pH' => [ '0', '0', '0', '0', '0', '0', '1', '0' ],\n             'pD' => [ '0', '0', '1', '7', '2', '2', '0', '22' ],\n             'pR' => [ '0', '0', '0', '3', '0', '27', '0', '0' ],\n             'pI' => [ '0', '0', '3', '0', '59', '1', '2', '3' ],\n             'pG' => [ '0', '0', '0', '1', '0', '0', '4', '1' ],\n   );\n\n   my $matrix = Bio::Matrix::PSM::ProtMatrix( %param );\n\n\n   my $site = Bio::Matrix::PSM::ProtMatrix->new(%param);\n   # Or get it from a file:\n   use Bio::Matrix::PSM::IO;\n   my $psmIO = Bio::Matrix::PSM::IO->new(-file => $file, -format => 'psi-blast');\n   while (my $psm = $psmIO->next_psm) {\n      #Now we have a Bio::Matrix::PSM::Psm object, \n      # see Bio::Matrix::PSM::PsmI for details\n      #This is a Bio::Matrix::PSM::ProtMatrix object now\n      my $matrix = $psm->matrix;   \n   }\n\n   # Get a simple consensus, where alphabet is:\n   # {A, R, N, D, C, Q, E, G, H, I, L, K, M, F, P, S, T, W, Y, V,}\n   # choosing the highest probability or N if prob is too low\n   my $consensus = $site->consensus;\n\n   # Retrieving and using regular expressions:\n   my $regexp = $site->regexp;\n   my $count = grep($regexp,$seq);\n   my $count = ($seq=~ s/$regexp/$1/eg);\n   print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nProtMatrix is designed to provide some basic methods when working with\nposition scoring (weight) matrices related to protein sequences.  A\nprotein PSM consists of 20 vectors with 20 frequencies (one per amino\nacid per position).  This is the minimum information you should\nprovide to construct a PSM object.  The vectors can be provided as\nstrings with frequencies where the frequency is {0..a} and a=1. This\nis the way MEME compressed representation of a matrix and it is quite\nuseful when working with relational DB.  If arrays are provided as an\ninput (references to arrays actually) they can be any number, real or\ninteger (frequency or count).\n\nWhen creating the object the constructor will check for positions that\nequal 0.  If such is found it will increase the count for all\npositions by one and recalculate the frequency.  Potential bug - if\nyou are using frequencies and one of the positions is 0 it will change\nsignificantly.  However, you should never have frequency that equals\n0.\n\nThrows an exception if: You mix as an input array and string (for\nexample A matrix is given as array, C - as string).  The position\nvector is (0,0,0,0).  One of the probability vectors is shorter than\nthe rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n   iupac - return IUPAC compliant consensus as a string\n   score - Returns the score as a real number\n   IC - information content. Returns a real number\n   id - identifier. Returns a string\n   accession - accession number. Returns a string\n   next_pos - return the sequence probably for each letter, IUPAC\n         symbol, IUPAC probability and simple sequence\n   consenus letter for this position. Rewind at the end. Returns a hash.\n   pos - current position get/set. Returns an integer.\n   regexp - construct a regular expression based on IUPAC consensus.\n         For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n   width - site width\n   get_string - gets the probability vector for a single base as a string.\n   get_array - gets the probability vector for a single base as an array.\n   get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n   my $str=$matrix->get_compressed_freq('A');\nor\n\n   my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yet implemented.\nHowever you can still uncompress such string with:\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\n\nor\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.   Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Thompson\n\nEmail tex@biosysadmin.com\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::ProtMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title    : new\n Usage    : my $site = Bio::Matrix::PSM::ProtMatrix->new( \n               %probs,\n               %logs,\n               -IC    => $ic,\n               -e_val => $score, \n               -id    => $mid\n               -model => \\%model\n            );\n Function : Creates a new Bio::Matrix::PSM::ProtMatrix object from memory\n Throws   : If inconsistent data for all vectors (all 20 amino acids) is\n               provided, if you mix input types (string vs array) or if a\n               position freq is 0.\n Example  :\n Returns  : Bio::Matrix::PSM::ProtMatrix object\n Args     : Hash references to log-odds scores and probabilities for\n            position-specific scoring info, e-value (optional), information\n            content (optional), id (optional), model for background distribution\n            of proteins (optional).\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   my $consensus;\n   #Too many things to rearrange, and I am creating simultanuously >500 \n   # such objects routinely, so this becomes performance issue\n   my %input;\n   while( @args ) {\n     (my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n     $input{$key} = shift @args;\n   }\n\n   # get a protein alphabet for processing log-odds scores and probabilities\n   # maybe change this later on to allow for non-standard aa lists? \n   my @alphabet = qw/A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V/;\n\n   foreach my $aa (@alphabet) {\n      $self->{\"log$aa\"}  = defined($input{\"l$aa\"}) ? $input{\"l$aa\"} \n         : $self->throw(\"Error: No log-odds information for $aa!\");\n      $self->{\"prob$aa\"}  = defined($input{\"p$aa\"}) ? $input{\"p$aa\"} \n         : $self->throw(\"Error: No probability information for $aa!\");\n   }\n   \n   $self->{_position} = 0;\n   $self->{IC}        = $input{IC};\n   $self->{e_val}     = $input{e_val};\n   $self->{sites}     = $input{sites};\n   $self->{width}     = $input{width};\n   $self->{accession_number} = $input{accession_number};\n   $self->{_correction} = defined($input{correction}) ?\n      $input{correction} : 1 ; # Correction might be unwanted- supply your own\n   # No id provided, null for the sake of rel db\n   $self->{id} = defined($input{id}) ? $input{id} : 'null'; \n   $self->{_alphabet} = \\@alphabet;\n\n   #Make consensus, throw if any one of the vectors is shorter\n   $self = _calculate_consensus($self,$input{model});\n   return $self;\n}\n\n=head2 alphabet\n\n Title    : Returns an array (or array reference if desired) to the alphabet \n Usage    :\n Function : Returns an array (or array reference) containing all of the\n            allowable characters for this matrix.\n Throws   :\n Example  :\n Returns  : Array or arrary reference.\n Args     :\n\n\nsub alphabet {\n   my $self = shift;\n   if ( wantarray ) {\n      return $self->{_alphabet};\n   } else {\n      return @{$self->{_alphabet}};\n   }\n}\n\n=head2 _calculate_consensus\n\n Title    : _calculate_consensus\n Usage    :\n Function : Calculates the consensus sequence for this matrix. \n Throws   :\n Example  :\n Returns  :\n Args     :\n\n\nsub _calculate_consensus {\n   my $self   = shift;\n   my $thresh = shift;\n   \n   # verify that all of the array lengths in %probs are the same\n   my @lengths = map { scalar(@$_) } map {$self->{\"prob$_\"}} @{ $self->{_alphabet} };\n   my $len = shift @lengths;\n   for ( @lengths ) {\n      if ( $_ ne $len ) { $self->throw( \"Probability matrix is damaged!\\n\" ) };\n   }\n\n   # iterate over probs, generate the most likely sequence and put it into \n   # $self->{seq}. Put the probability of this sequence into $self->{seqp}.\n   for ( my $i = 0; $i < $len; $i++ ) {\n      # get a list of all the probabilities at position $i, ordered by $self->{_alphabet}\n      my @probs = map { ${$self->{\"prob$_\"}}[$i] } @{ $self->{_alphabet} };\n      # calculate the consensus of @probs, put sequence into seqp and probabilities into seqp\n      (${$self->{seq}}[$i],${$self->{seqp}}[$i]) = $self->_to_cons( @probs, $thresh );\n   }\n\n   return $self;\n}\n\n=head2 next_pos\n\n Title    : next_pos\n Usage    :\n Function : Retrives the next position features: frequencies for all 20 amino\n            acids, log-odds scores for all 20 amino acids at this position,\n            the main (consensus) letter at this position, the probability\n            for the consensus letter to occur at this position and the relative\n            current position as an integer.\n Throws   :\n Example  :\n Returns  : hash (or hash reference) (pA,pR,pN,pD,...,logA,logR,logN,logD,aa,prob,rel)\n            - pN entries represent the probability for amino acid N\n            to be at this position\n            - logN entries represent the log-odds score for having amino acid\n            N at this position\n            - aa is the consensus amino acid\n            - prob is the probability for the consensus amino acid to be at this \n            position\n            - rel is the relative index of the current position (integer)\n Args      : none\n\n\n\nsub next_pos {\n      my $self = shift;\n         $self->throw(\"instance method called on class\") unless ref $self;\n\n      my $len = @{$self->{seq}};\n      my $pos = $self->{_position};\n\n      # return a PSM if we're still within range\n      if ($pos<$len) {\n\n         my %probs = map { (\"p$_\", ${$self->{\"prob$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my %logs  = map { (\"l$_\", ${$self->{\"log$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my $base  = ${$self->{seq}}[$pos];\n         my $prob  = ${$self->{seqp}}[$pos];\n\n         $self->{_position}++;\n         my %hash = ( %probs, %logs, base => $base, rel => $pos, prob => $prob );\n         \n         # decide whether to return the hash or a reference to it\n         if ( wantarray ) {\n            return %hash;\n         } else {\n            return \\%hash;\n         }\n   } else { # otherwise, reset $self->{_position} and return nothing\n      $self->{_position} = 0; \n      return;\n   }\n}\n\n\n=head2 curpos\n\n Title    : curpos\n Usage    :\n Function : Gets/sets the current position. \n Throws   :\n Example  :\n Returns  : Current position (integer).\n Args     : New position (integer).\n\n\nsub curpos {\n      my $self = shift;\n      if (@_) { $self->{_position} = shift; }\n      return $self->{_position};\n}\n\n\n=head2 e_val\n\n Title    : e_val\n Usage    :\n Function : Gets/sets the e-value\n Throws   :\n Example  :\n Returns  : \n Args     : real number\n\n\nsub e_val {\n      my $self = shift;\n      if (@_) { $self->{e_val} = shift; }\n      return $self->{e_val};\n}\n\n\n=head2 IC\n\n Title    : IC\n Usage    :\n Function : Position-specific information content.\n Throws   :\n Example  :\n Returns  : Information content for current position.\n Args     : Information content for current position.\n\n\nsub IC {\n      my $self = shift;\n      if (@_) { $self->{IC} = shift; }\n      return $self->{IC};\n}\n\n=head2 accession_number\n\n Title    : accession_number\n Usage    :\n Function: accession number, this will be unique id for the ProtMatrix object as\n            well for any other object, inheriting from ProtMatrix.\n Throws   :\n Example  :\n Returns  : New accession number (string)\n Args     : Accession number (string)\n\n\nsub accession_number {\n      my $self = shift;\n      if (@_) { $self->{accession_number} = shift; }\n      return $self->{accession_number};\n}\n\n=head2 consensus\n\n Title    : consensus\n Usage    :\n Function : Returns the consensus sequence for this PSM.\n Throws   : if supplied with thresold outisde 5..10 range\n Example  :\n Returns  : string\n Args     : (optional) threshold value 5 to 10 (corresponds to 50-100% at each position\n\n\nsub consensus {\n   my $self = shift;\n   my $thresh=shift;\n   $self->_calculate_consensus($thresh) if ($thresh); #Change of threshold\n   my $consensus='';\n\n   foreach my $letter (@{$self->{seq}}) {\n       $consensus .= $letter;\n   }\n\n   return $consensus;\n}\n\nsub IUPAC {\n   my $self = shift;\n   return $self->consensus;\n}\n\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n            store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Example :\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n   my $self = shift;\n   my $base = shift;\n   my $string = '';\n\n   my @prob = @{$self->{\"prob$base\"}};\n   if ( ! @prob ) {\n      $self->throw( \"No such base: $base\\n\");\n   }\n\n   foreach my $prob (@prob) {\n      my $corrected = $prob*10;\n      my $next = sprintf(\"%.0f\",$corrected);\n      $next = 'a' if ($next eq '10');\n      $string .= $next;\n   }\n   return $string;\n}\n\n\n\n=head2 width\n\n Title    : width\n Usage    :\n Function : Returns the length of the site\n Throws   :\n Example  :\n Returns  : number\n Args     :\n\n\nsub width {\n   my $self = shift;\n   my $width = @{$self->{probA}};\n   return $width;\n}\n\n=head2 get_array\n\n Title    : get_array\n Usage    :\n Function : Returns an array with frequencies for a specified amino acid.\n Throws   :\n Example  :\n Returns  : Array representing frequencies for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"prob$letter\"}}; \n}\n\n\n=head2 get_logs_array\n\n Title    : get_logs_array\n Usage    :\n Function : Returns an array with log_odds for a specified base\n Throws   :\n Example  :\n Returns  : Array representing log-odds scores for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_logs_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"log$letter\"}}; \n}\n\n=head2 id\n\n Title    : id\n Usage    :\n Function : Gets/sets the site id\n Throws   :\n Example  :\n Returns  : string\n Args     : string\n\n\nsub id {\n      my $self = shift;\n      if (@_) { $self->{id} = shift; }\n      return $self->{id};\n}\n\n=head2 regexp\n\n Title    : regexp\n Usage    :\n Function : Returns a case-insensitive regular expression which matches the\n            IUPAC convention.  X's in consensus sequence will match anything.     \n Throws   :\n Example  :\n Returns  : string\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n\n\nsub regexp {\n   my $self = shift;\n   my $threshold = 20;\n   if ( @_ ) { my $threshold = shift };\n\n   my @alphabet = @{$self->{_alphabet}};\n   my $width = $self->width;\n   my (@regexp, $i);\n   for ( $i = 0; $i < $width; $i++ ) {\n      # get an array of the residues at this position with p > $threshold\n      my @letters = map { uc($_).lc($_) } grep { $self->{\"prob$_\"}->[$i] >= $threshold } @alphabet;\n\n      my $reg;\n      if ( scalar(@letters) == 0 ) {\n         $reg = '\\.';\n      } else {\n         $reg = '['.join('',@letters).']';\n      }\n      push @regexp, $reg;\n   }\n\n   if ( wantarray ) { \n      return @regexp;\n   } else {\n      return join '', @regexp;\n   }\n}\n\n\n=head2 regexp_array\n\n Title    : regexp_array\n Usage    :\n Function : Returns an array of position-specific regular expressions.\n             X's in consensus sequence will match anything.      \n Throws   :\n Example  :\n Returns  : Array of position-specific regular expressions.\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n Notes    : Simply calls regexp method in list context.\n\n\nsub regexp_array {\n   my $self = shift;\n   \n   return @{ $self->regexp };\n}\n\n\n=head2 _compress_array\n\n Title    : _compress_array\n Usage    :\n Function :  Will compress an array of real signed numbers to a string (ie vector of bytes)\n             -127 to +127 for bi-directional(signed) and 0..255 for unsigned ;\n Throws   :\n Example  :  Internal stuff\n Returns  :  String\n Args     :  array reference, followed by max value and direction (optional, defaults to 1),\n             direction of 1 is unsigned, anything else is signed. \n\n\nsub _compress_array {\n   my ($array,$lm,$direct)=@_;\n   my $str;\n   return unless(($array) && ($lm));\n   $direct=1 unless ($direct);\n   my $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n   foreach my $c (@{$array}) {\n      $c=$lm if ($c>$lm);\n      $c=-$lm if (($c<-$lm) && ($direct !=1));\n      $c=0 if (($c<0) && ($direct ==1));\n      my $byte=int($k1*$c);\n      $byte=127+$byte if ($direct !=1);#Clumsy, should be really shift the bits\n      my $char=chr($byte);\n      $str.=$char;\n   }\n   return $str;\n}\n\n=head2 _uncompress_string\n\n Title    : _uncompress_string\n Usage    :\n Function :   Will uncompress a string (vector of bytes) to create an array of real\n                  signed numbers (opposite to_compress_array)\n Throws   :\n Example  :   Internal stuff\n Returns  :   string, followed by max value and direction (optional, defaults to 1),\n              direction of 1 is unsigned, anything else is signed.\n Args     :   array","parameters":[{"label":"$str"},{"label":"$lm"},{"label":"$direct"}],"label":"_uncompress_string($str,$lm,$direct)"},"line":701,"kind":12,"range":{"end":{"line":715,"character":9999},"start":{"line":701,"character":0}}},{"kind":12,"range":{"end":{"character":9999,"line":744},"start":{"character":0,"line":731}},"line":731,"name":"get_compressed_freq","containerName":"main::","children":[{"definition":"my","line":732,"name":"$self","localvar":"my","kind":13,"containerName":"get_compressed_freq"},{"line":733,"containerName":"get_compressed_freq","localvar":"my","kind":13,"name":"$base","definition":"my"},{"definition":"my","name":"$string","localvar":"my","containerName":"get_compressed_freq","kind":13,"line":734},{"localvar":"my","containerName":"get_compressed_freq","kind":13,"name":"@prob","line":735,"definition":"my"},{"line":737,"kind":13,"containerName":"get_compressed_freq","name":"$base"},{"line":738,"name":"@prob","containerName":"get_compressed_freq","kind":13},{"kind":13,"containerName":"get_compressed_freq","name":"$self","line":738},{"line":738,"name":"$self","containerName":"get_compressed_freq","kind":13},{"name":"$base","containerName":"get_compressed_freq","kind":13,"line":741},{"name":"@prob","containerName":"get_compressed_freq","kind":13,"line":742},{"name":"$self","containerName":"get_compressed_freq","kind":13,"line":742},{"line":742,"name":"$self","containerName":"get_compressed_freq","kind":13}],"definition":"sub"},{"name":"BASE","kind":12,"line":736},{"line":738,"name":"probA","kind":12},{"line":738,"kind":12,"name":"probA"},{"kind":12,"name":"BASE","line":739},{"line":742,"kind":12,"name":"probG"},{"line":742,"name":"probG","kind":12},{"kind":12,"name":"BASE","line":743},{"line":745,"name":"%base","kind":13,"containerName":null},{"line":746,"name":"@prob","containerName":null,"kind":13},{"line":746,"containerName":null,"kind":13,"name":"%self"},{"name":"probC","kind":12,"line":746},{"line":746,"name":"%self","containerName":null,"kind":13},{"kind":12,"name":"probC","line":746},{"line":747,"name":"BASE","kind":12},{"kind":13,"containerName":null,"name":"%base","line":749},{"line":750,"kind":13,"containerName":null,"name":"@prob"},{"line":750,"name":"%self","containerName":null,"kind":13},{"name":"probT","kind":12,"line":750},{"line":750,"name":"%self","kind":13,"containerName":null},{"name":"probT","kind":12,"line":750},{"kind":12,"name":"BASE","line":751},{"line":753,"name":"$self","kind":13,"containerName":null},{"name":"throw","kind":12,"containerName":"main::","line":753},{"localvar":"my","containerName":null,"kind":13,"name":"$str","line":755,"definition":"my"},{"line":755,"containerName":null,"kind":13,"name":"@prob"},{"line":756,"name":"$str","containerName":null,"kind":13},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"sequence_match_weight","line":774,"definition":"my"},{"name":"$seq","containerName":"sequence_match_weight","kind":13,"line":774},{"kind":13,"containerName":"sequence_match_weight","name":"$self","line":775},{"line":777,"name":"$seqlen","containerName":"sequence_match_weight","localvar":"my","kind":13,"definition":"my"},{"containerName":"sequence_match_weight","kind":13,"name":"$seq","line":777},{"definition":"my","line":778,"localvar":"my","kind":13,"containerName":"sequence_match_weight","name":"$width"},{"name":"$self","containerName":"sequence_match_weight","kind":13,"line":778},{"kind":12,"containerName":"sequence_match_weight","name":"width","line":778},{"containerName":"sequence_match_weight","kind":13,"name":"$self","line":779},{"kind":12,"containerName":"sequence_match_weight","name":"throw","line":779},{"line":780,"name":"$seq","kind":13,"containerName":"sequence_match_weight"},{"line":780,"name":"$self","kind":13,"containerName":"sequence_match_weight"},{"containerName":"sequence_match_weight","kind":12,"name":"width","line":780},{"definition":"my","name":"$score","localvar":"my","kind":13,"containerName":"sequence_match_weight","line":782},{"line":782,"containerName":"sequence_match_weight","kind":13,"name":"$i"},{"definition":"my","line":783,"name":"$letter","containerName":"sequence_match_weight","localvar":"my","kind":13},{"containerName":"sequence_match_weight","kind":13,"name":"$seq","line":783},{"kind":13,"containerName":"sequence_match_weight","name":"$score","line":785},{"line":785,"name":"$self","kind":13,"containerName":"sequence_match_weight"},{"line":785,"kind":13,"containerName":"sequence_match_weight","name":"$i"},{"line":786,"kind":13,"containerName":"sequence_match_weight","name":"$i"},{"line":788,"name":"$score","containerName":"sequence_match_weight","kind":13}],"containerName":"main::","name":"sequence_match_weight","definition":"sub","detail":"($self,$seq)","line":773,"range":{"start":{"character":0,"line":773},"end":{"character":9999,"line":789}},"kind":12,"signature":{"label":"sequence_match_weight($self,$seq)","documentation":"1;\n# $Id: ProtMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::ProtMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) with log-odds scoring\ninformation.\n\n=head1 SYNOPSIS\n\n   use Bio::Matrix::PSM::ProtMatrix;\n   # Create from memory by supplying probability matrix hash both as strings or\n   # arrays where the frequencies   Hash entries of the form lN refer to an array\n   # of position-specific log-odds scores for amino acid N. Hash entries of the\n   # form pN represent the position-specific probability of finding amino acid N.\n\n   my %param = (\n             'id' => 'A. thaliana protein atp1',\n             '-e_val' => $score,\n             'lS' => [ '-2', '3', '-3', '2', '-3', '1', '1', '3' ],\n             'lF' => [ '-1', '-4', '0', '-5', '0', '-5', '-4', '-4' ],\n             'lT' => [ '-1', '1', '0', '1', '-2', '-1', '0', '1' ],\n             'lN' => [ '-3', '-1', '-2', '3', '-5', '5', '-2', '0' ],\n             'lK' => [ '-2', '0', '-3', '2', '-3', '2', '-3', '-1' ],\n             'lY' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-4', '-4' ],\n             'lE' => [ '-3', '4', '-3', '2', '-4', '-2', '-3', '2' ],\n             'lV' => [ '0', '-2', '1', '-4', '1', '-4', '-1', '-3' ],\n             'lQ' => [ '-1', '0', '-2', '3', '-4', '1', '-3', '0' ],\n             'lM' => [ '8', '-3', '8', '-3', '1', '-3', '-3', '-3' ],\n             'lC' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-3', '-3' ],\n             'lL' => [ '1', '-3', '1', '-4', '3', '-4', '-2', '-4' ],\n             'lA' => [ '-2', '1', '-2', '0', '-2', '-2', '2', '2' ],\n             'lW' => [ '-2', '-4', '-3', '-5', '-4', '-5', '-5', '-5' ],\n             'lP' => [ '-3', '-2', '-4', '-3', '-1', '-3', '6', '-3' ],\n             'lH' => [ '-2', '-2', '-3', '-2', '-5', '-2', '-2', '-3' ],\n             'lD' => [ '-4', '-1', '-3', '1', '-3', '-1', '-3', '4' ],\n             'lR' => [ '-2', '-1', '-3', '0', '-4', '4', '-4', '-3' ],\n             'lI' => [ '0', '-3', '0', '-4', '6', '-4', '-2', '-2' ],\n             'lG' => [ '-4', '-2', '-4', '-2', '-5', '-3', '-1', '-2' ],\n             'pS' => [ '0', '33', '0', '16', '1', '12', '11', '25' ],\n             'pF' => [ '0', '0', '2', '0', '3', '0', '0', '0' ],\n             'pT' => [ '0', '8', '7', '10', '1', '2', '7', '8' ],\n             'pN' => [ '0', '0', '2', '13', '0', '36', '1', '4' ],\n             'pK' => [ '0', '5', '0', '13', '1', '15', '0', '2' ],\n             'pY' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pE' => [ '0', '41', '1', '12', '0', '0', '0', '15' ],\n             'pV' => [ '0', '3', '9', '0', '2', '0', '3', '1' ],\n             'pQ' => [ '0', '0', '0', '15', '0', '4', '0', '3' ],\n             'pM' => [ '100', '0', '66', '0', '2', '0', '0', '0' ],\n             'pC' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pL' => [ '0', '0', '8', '0', '25', '0', '4', '0' ],\n             'pA' => [ '0', '10', '1', '9', '2', '0', '22', '16' ],\n             'pW' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pP' => [ '0', '0', '0', '0', '3', '1', '45', '0' ],\n             'pH' => [ '0', '0', '0', '0', '0', '0', '1', '0' ],\n             'pD' => [ '0', '0', '1', '7', '2', '2', '0', '22' ],\n             'pR' => [ '0', '0', '0', '3', '0', '27', '0', '0' ],\n             'pI' => [ '0', '0', '3', '0', '59', '1', '2', '3' ],\n             'pG' => [ '0', '0', '0', '1', '0', '0', '4', '1' ],\n   );\n\n   my $matrix = Bio::Matrix::PSM::ProtMatrix( %param );\n\n\n   my $site = Bio::Matrix::PSM::ProtMatrix->new(%param);\n   # Or get it from a file:\n   use Bio::Matrix::PSM::IO;\n   my $psmIO = Bio::Matrix::PSM::IO->new(-file => $file, -format => 'psi-blast');\n   while (my $psm = $psmIO->next_psm) {\n      #Now we have a Bio::Matrix::PSM::Psm object, \n      # see Bio::Matrix::PSM::PsmI for details\n      #This is a Bio::Matrix::PSM::ProtMatrix object now\n      my $matrix = $psm->matrix;   \n   }\n\n   # Get a simple consensus, where alphabet is:\n   # {A, R, N, D, C, Q, E, G, H, I, L, K, M, F, P, S, T, W, Y, V,}\n   # choosing the highest probability or N if prob is too low\n   my $consensus = $site->consensus;\n\n   # Retrieving and using regular expressions:\n   my $regexp = $site->regexp;\n   my $count = grep($regexp,$seq);\n   my $count = ($seq=~ s/$regexp/$1/eg);\n   print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nProtMatrix is designed to provide some basic methods when working with\nposition scoring (weight) matrices related to protein sequences.  A\nprotein PSM consists of 20 vectors with 20 frequencies (one per amino\nacid per position).  This is the minimum information you should\nprovide to construct a PSM object.  The vectors can be provided as\nstrings with frequencies where the frequency is {0..a} and a=1. This\nis the way MEME compressed representation of a matrix and it is quite\nuseful when working with relational DB.  If arrays are provided as an\ninput (references to arrays actually) they can be any number, real or\ninteger (frequency or count).\n\nWhen creating the object the constructor will check for positions that\nequal 0.  If such is found it will increase the count for all\npositions by one and recalculate the frequency.  Potential bug - if\nyou are using frequencies and one of the positions is 0 it will change\nsignificantly.  However, you should never have frequency that equals\n0.\n\nThrows an exception if: You mix as an input array and string (for\nexample A matrix is given as array, C - as string).  The position\nvector is (0,0,0,0).  One of the probability vectors is shorter than\nthe rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n   iupac - return IUPAC compliant consensus as a string\n   score - Returns the score as a real number\n   IC - information content. Returns a real number\n   id - identifier. Returns a string\n   accession - accession number. Returns a string\n   next_pos - return the sequence probably for each letter, IUPAC\n         symbol, IUPAC probability and simple sequence\n   consenus letter for this position. Rewind at the end. Returns a hash.\n   pos - current position get/set. Returns an integer.\n   regexp - construct a regular expression based on IUPAC consensus.\n         For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n   width - site width\n   get_string - gets the probability vector for a single base as a string.\n   get_array - gets the probability vector for a single base as an array.\n   get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n   my $str=$matrix->get_compressed_freq('A');\nor\n\n   my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yet implemented.\nHowever you can still uncompress such string with:\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\n\nor\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.   Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Thompson\n\nEmail tex@biosysadmin.com\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::ProtMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title    : new\n Usage    : my $site = Bio::Matrix::PSM::ProtMatrix->new( \n               %probs,\n               %logs,\n               -IC    => $ic,\n               -e_val => $score, \n               -id    => $mid\n               -model => \\%model\n            );\n Function : Creates a new Bio::Matrix::PSM::ProtMatrix object from memory\n Throws   : If inconsistent data for all vectors (all 20 amino acids) is\n               provided, if you mix input types (string vs array) or if a\n               position freq is 0.\n Example  :\n Returns  : Bio::Matrix::PSM::ProtMatrix object\n Args     : Hash references to log-odds scores and probabilities for\n            position-specific scoring info, e-value (optional), information\n            content (optional), id (optional), model for background distribution\n            of proteins (optional).\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   my $consensus;\n   #Too many things to rearrange, and I am creating simultanuously >500 \n   # such objects routinely, so this becomes performance issue\n   my %input;\n   while( @args ) {\n     (my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n     $input{$key} = shift @args;\n   }\n\n   # get a protein alphabet for processing log-odds scores and probabilities\n   # maybe change this later on to allow for non-standard aa lists? \n   my @alphabet = qw/A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V/;\n\n   foreach my $aa (@alphabet) {\n      $self->{\"log$aa\"}  = defined($input{\"l$aa\"}) ? $input{\"l$aa\"} \n         : $self->throw(\"Error: No log-odds information for $aa!\");\n      $self->{\"prob$aa\"}  = defined($input{\"p$aa\"}) ? $input{\"p$aa\"} \n         : $self->throw(\"Error: No probability information for $aa!\");\n   }\n   \n   $self->{_position} = 0;\n   $self->{IC}        = $input{IC};\n   $self->{e_val}     = $input{e_val};\n   $self->{sites}     = $input{sites};\n   $self->{width}     = $input{width};\n   $self->{accession_number} = $input{accession_number};\n   $self->{_correction} = defined($input{correction}) ?\n      $input{correction} : 1 ; # Correction might be unwanted- supply your own\n   # No id provided, null for the sake of rel db\n   $self->{id} = defined($input{id}) ? $input{id} : 'null'; \n   $self->{_alphabet} = \\@alphabet;\n\n   #Make consensus, throw if any one of the vectors is shorter\n   $self = _calculate_consensus($self,$input{model});\n   return $self;\n}\n\n=head2 alphabet\n\n Title    : Returns an array (or array reference if desired) to the alphabet \n Usage    :\n Function : Returns an array (or array reference) containing all of the\n            allowable characters for this matrix.\n Throws   :\n Example  :\n Returns  : Array or arrary reference.\n Args     :\n\n\nsub alphabet {\n   my $self = shift;\n   if ( wantarray ) {\n      return $self->{_alphabet};\n   } else {\n      return @{$self->{_alphabet}};\n   }\n}\n\n=head2 _calculate_consensus\n\n Title    : _calculate_consensus\n Usage    :\n Function : Calculates the consensus sequence for this matrix. \n Throws   :\n Example  :\n Returns  :\n Args     :\n\n\nsub _calculate_consensus {\n   my $self   = shift;\n   my $thresh = shift;\n   \n   # verify that all of the array lengths in %probs are the same\n   my @lengths = map { scalar(@$_) } map {$self->{\"prob$_\"}} @{ $self->{_alphabet} };\n   my $len = shift @lengths;\n   for ( @lengths ) {\n      if ( $_ ne $len ) { $self->throw( \"Probability matrix is damaged!\\n\" ) };\n   }\n\n   # iterate over probs, generate the most likely sequence and put it into \n   # $self->{seq}. Put the probability of this sequence into $self->{seqp}.\n   for ( my $i = 0; $i < $len; $i++ ) {\n      # get a list of all the probabilities at position $i, ordered by $self->{_alphabet}\n      my @probs = map { ${$self->{\"prob$_\"}}[$i] } @{ $self->{_alphabet} };\n      # calculate the consensus of @probs, put sequence into seqp and probabilities into seqp\n      (${$self->{seq}}[$i],${$self->{seqp}}[$i]) = $self->_to_cons( @probs, $thresh );\n   }\n\n   return $self;\n}\n\n=head2 next_pos\n\n Title    : next_pos\n Usage    :\n Function : Retrives the next position features: frequencies for all 20 amino\n            acids, log-odds scores for all 20 amino acids at this position,\n            the main (consensus) letter at this position, the probability\n            for the consensus letter to occur at this position and the relative\n            current position as an integer.\n Throws   :\n Example  :\n Returns  : hash (or hash reference) (pA,pR,pN,pD,...,logA,logR,logN,logD,aa,prob,rel)\n            - pN entries represent the probability for amino acid N\n            to be at this position\n            - logN entries represent the log-odds score for having amino acid\n            N at this position\n            - aa is the consensus amino acid\n            - prob is the probability for the consensus amino acid to be at this \n            position\n            - rel is the relative index of the current position (integer)\n Args      : none\n\n\n\nsub next_pos {\n      my $self = shift;\n         $self->throw(\"instance method called on class\") unless ref $self;\n\n      my $len = @{$self->{seq}};\n      my $pos = $self->{_position};\n\n      # return a PSM if we're still within range\n      if ($pos<$len) {\n\n         my %probs = map { (\"p$_\", ${$self->{\"prob$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my %logs  = map { (\"l$_\", ${$self->{\"log$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my $base  = ${$self->{seq}}[$pos];\n         my $prob  = ${$self->{seqp}}[$pos];\n\n         $self->{_position}++;\n         my %hash = ( %probs, %logs, base => $base, rel => $pos, prob => $prob );\n         \n         # decide whether to return the hash or a reference to it\n         if ( wantarray ) {\n            return %hash;\n         } else {\n            return \\%hash;\n         }\n   } else { # otherwise, reset $self->{_position} and return nothing\n      $self->{_position} = 0; \n      return;\n   }\n}\n\n\n=head2 curpos\n\n Title    : curpos\n Usage    :\n Function : Gets/sets the current position. \n Throws   :\n Example  :\n Returns  : Current position (integer).\n Args     : New position (integer).\n\n\nsub curpos {\n      my $self = shift;\n      if (@_) { $self->{_position} = shift; }\n      return $self->{_position};\n}\n\n\n=head2 e_val\n\n Title    : e_val\n Usage    :\n Function : Gets/sets the e-value\n Throws   :\n Example  :\n Returns  : \n Args     : real number\n\n\nsub e_val {\n      my $self = shift;\n      if (@_) { $self->{e_val} = shift; }\n      return $self->{e_val};\n}\n\n\n=head2 IC\n\n Title    : IC\n Usage    :\n Function : Position-specific information content.\n Throws   :\n Example  :\n Returns  : Information content for current position.\n Args     : Information content for current position.\n\n\nsub IC {\n      my $self = shift;\n      if (@_) { $self->{IC} = shift; }\n      return $self->{IC};\n}\n\n=head2 accession_number\n\n Title    : accession_number\n Usage    :\n Function: accession number, this will be unique id for the ProtMatrix object as\n            well for any other object, inheriting from ProtMatrix.\n Throws   :\n Example  :\n Returns  : New accession number (string)\n Args     : Accession number (string)\n\n\nsub accession_number {\n      my $self = shift;\n      if (@_) { $self->{accession_number} = shift; }\n      return $self->{accession_number};\n}\n\n=head2 consensus\n\n Title    : consensus\n Usage    :\n Function : Returns the consensus sequence for this PSM.\n Throws   : if supplied with thresold outisde 5..10 range\n Example  :\n Returns  : string\n Args     : (optional) threshold value 5 to 10 (corresponds to 50-100% at each position\n\n\nsub consensus {\n   my $self = shift;\n   my $thresh=shift;\n   $self->_calculate_consensus($thresh) if ($thresh); #Change of threshold\n   my $consensus='';\n\n   foreach my $letter (@{$self->{seq}}) {\n       $consensus .= $letter;\n   }\n\n   return $consensus;\n}\n\nsub IUPAC {\n   my $self = shift;\n   return $self->consensus;\n}\n\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n            store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Example :\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n   my $self = shift;\n   my $base = shift;\n   my $string = '';\n\n   my @prob = @{$self->{\"prob$base\"}};\n   if ( ! @prob ) {\n      $self->throw( \"No such base: $base\\n\");\n   }\n\n   foreach my $prob (@prob) {\n      my $corrected = $prob*10;\n      my $next = sprintf(\"%.0f\",$corrected);\n      $next = 'a' if ($next eq '10');\n      $string .= $next;\n   }\n   return $string;\n}\n\n\n\n=head2 width\n\n Title    : width\n Usage    :\n Function : Returns the length of the site\n Throws   :\n Example  :\n Returns  : number\n Args     :\n\n\nsub width {\n   my $self = shift;\n   my $width = @{$self->{probA}};\n   return $width;\n}\n\n=head2 get_array\n\n Title    : get_array\n Usage    :\n Function : Returns an array with frequencies for a specified amino acid.\n Throws   :\n Example  :\n Returns  : Array representing frequencies for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"prob$letter\"}}; \n}\n\n\n=head2 get_logs_array\n\n Title    : get_logs_array\n Usage    :\n Function : Returns an array with log_odds for a specified base\n Throws   :\n Example  :\n Returns  : Array representing log-odds scores for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_logs_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"log$letter\"}}; \n}\n\n=head2 id\n\n Title    : id\n Usage    :\n Function : Gets/sets the site id\n Throws   :\n Example  :\n Returns  : string\n Args     : string\n\n\nsub id {\n      my $self = shift;\n      if (@_) { $self->{id} = shift; }\n      return $self->{id};\n}\n\n=head2 regexp\n\n Title    : regexp\n Usage    :\n Function : Returns a case-insensitive regular expression which matches the\n            IUPAC convention.  X's in consensus sequence will match anything.     \n Throws   :\n Example  :\n Returns  : string\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n\n\nsub regexp {\n   my $self = shift;\n   my $threshold = 20;\n   if ( @_ ) { my $threshold = shift };\n\n   my @alphabet = @{$self->{_alphabet}};\n   my $width = $self->width;\n   my (@regexp, $i);\n   for ( $i = 0; $i < $width; $i++ ) {\n      # get an array of the residues at this position with p > $threshold\n      my @letters = map { uc($_).lc($_) } grep { $self->{\"prob$_\"}->[$i] >= $threshold } @alphabet;\n\n      my $reg;\n      if ( scalar(@letters) == 0 ) {\n         $reg = '\\.';\n      } else {\n         $reg = '['.join('',@letters).']';\n      }\n      push @regexp, $reg;\n   }\n\n   if ( wantarray ) { \n      return @regexp;\n   } else {\n      return join '', @regexp;\n   }\n}\n\n\n=head2 regexp_array\n\n Title    : regexp_array\n Usage    :\n Function : Returns an array of position-specific regular expressions.\n             X's in consensus sequence will match anything.      \n Throws   :\n Example  :\n Returns  : Array of position-specific regular expressions.\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n Notes    : Simply calls regexp method in list context.\n\n\nsub regexp_array {\n   my $self = shift;\n   \n   return @{ $self->regexp };\n}\n\n\n=head2 _compress_array\n\n Title    : _compress_array\n Usage    :\n Function :  Will compress an array of real signed numbers to a string (ie vector of bytes)\n             -127 to +127 for bi-directional(signed) and 0..255 for unsigned ;\n Throws   :\n Example  :  Internal stuff\n Returns  :  String\n Args     :  array reference, followed by max value and direction (optional, defaults to 1),\n             direction of 1 is unsigned, anything else is signed. \n\n\nsub _compress_array {\n   my ($array,$lm,$direct)=@_;\n   my $str;\n   return unless(($array) && ($lm));\n   $direct=1 unless ($direct);\n   my $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n   foreach my $c (@{$array}) {\n      $c=$lm if ($c>$lm);\n      $c=-$lm if (($c<-$lm) && ($direct !=1));\n      $c=0 if (($c<0) && ($direct ==1));\n      my $byte=int($k1*$c);\n      $byte=127+$byte if ($direct !=1);#Clumsy, should be really shift the bits\n      my $char=chr($byte);\n      $str.=$char;\n   }\n   return $str;\n}\n\n=head2 _uncompress_string\n\n Title    : _uncompress_string\n Usage    :\n Function :   Will uncompress a string (vector of bytes) to create an array of real\n                  signed numbers (opposite to_compress_array)\n Throws   :\n Example  :   Internal stuff\n Returns  :   string, followed by max value and direction (optional, defaults to 1),\n              direction of 1 is unsigned, anything else is signed.\n Args     :   array\n\n\nsub _uncompress_string {\n   my ($str,$lm,$direct)=@_;\n   my @array;\n   return unless(($str) && ($lm));\n   $direct=1 unless ($direct);\n   my $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n   while (my $c=chop($str)) {\n      my $byte=ord($c);\n      $byte=$byte-127 if ($direct !=1);#Clumsy, should be really shift the bits\n      my $num=$byte/$k1;\n      unshift @array,$num;\n   }\n\n   return @array;\n}\n\n=head2 get_compressed_freq\n\n Title    : get_compressed_freq\n Usage    :\n Function:   A method to provide a compressed frequency vector. It uses one byte to\n             code the frequence for one of the probability vectors for one position.\n             Useful for relational database. Improvment of the previous 0..a coding.\n Throws   :\n Example  :   my $strA=$self->get_compressed_freq('A');\n Returns  :   String\n Args     :   char \n\n\nsub get_compressed_freq {\n   my $self=shift;\n   my $base=shift;\n   my $string='';\n   my @prob;\n   BASE: {\n      if ($base eq 'A') {\n         @prob = @{$self->{probA}} unless (!defined($self->{probA}));\n         last BASE;\n      }\n         if ($base eq 'G') {\n         @prob = @{$self->{probG}} unless (!defined($self->{probG}));\n         last BASE;\n      }\n         if ($base eq 'C') {\n         @prob = @{$self->{probC}} unless (!defined($self->{probC}));\n         last BASE;\n      }\n         if ($base eq 'T') {\n         @prob = @{$self->{probT}} unless (!defined($self->{probT}));\n         last BASE;\n      }\n      $self->throw (\"No such base: $base!\\n\");\n   }\n   my $str= _compress_array(\\@prob,1,1);\n   return $str;\n}\n\n=head2 sequence_match_weight\n\n Title    : sequence_match_weight\n Usage    :\n Function :   This method will calculate the score of a match, based on the PSM\n              if such is associated with the matrix object. Returns undef if no\n              PSM data is available.\n Throws   :   if the length of the sequence is different from the matrix width\n Example  :   my $score=$matrix->sequence_match_weight('ACGGATAG');\n Returns  :   Floating point\n Args     :   string","parameters":[{"label":"$self"},{"label":"$seq"}]}},{"name":"logA","kind":12,"line":775},{"definition":"sub","detail":"($self,@probs,$thresh)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_to_IUPAC","name":"$self","line":807},{"line":807,"containerName":"_to_IUPAC","kind":13,"name":"@probs"},{"line":807,"name":"$thresh","containerName":"_to_IUPAC","kind":13},{"line":811,"name":"$thresh","containerName":"_to_IUPAC","kind":13},{"line":811,"kind":13,"containerName":"_to_IUPAC","name":"$thresh"},{"definition":"my","name":"$IUPAC_aa","localvar":"my","kind":13,"containerName":"_to_IUPAC","line":813},{"kind":13,"containerName":"_to_IUPAC","name":"$max_prob","line":813},{"line":813,"name":"$thresh","kind":13,"containerName":"_to_IUPAC"},{"definition":"my","line":814,"kind":13,"localvar":"my","containerName":"_to_IUPAC","name":"$aa"},{"kind":13,"containerName":"_to_IUPAC","name":"$self","line":814}],"name":"_to_IUPAC","containerName":"main::","signature":{"label":"_to_IUPAC($self,@probs,$thresh)","parameters":[{"label":"$self"},{"label":"@probs"},{"label":"$thresh"}],"documentation":"1;\n# $Id: ProtMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::ProtMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) with log-odds scoring\ninformation.\n\n=head1 SYNOPSIS\n\n   use Bio::Matrix::PSM::ProtMatrix;\n   # Create from memory by supplying probability matrix hash both as strings or\n   # arrays where the frequencies   Hash entries of the form lN refer to an array\n   # of position-specific log-odds scores for amino acid N. Hash entries of the\n   # form pN represent the position-specific probability of finding amino acid N.\n\n   my %param = (\n             'id' => 'A. thaliana protein atp1',\n             '-e_val' => $score,\n             'lS' => [ '-2', '3', '-3', '2', '-3', '1', '1', '3' ],\n             'lF' => [ '-1', '-4', '0', '-5', '0', '-5', '-4', '-4' ],\n             'lT' => [ '-1', '1', '0', '1', '-2', '-1', '0', '1' ],\n             'lN' => [ '-3', '-1', '-2', '3', '-5', '5', '-2', '0' ],\n             'lK' => [ '-2', '0', '-3', '2', '-3', '2', '-3', '-1' ],\n             'lY' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-4', '-4' ],\n             'lE' => [ '-3', '4', '-3', '2', '-4', '-2', '-3', '2' ],\n             'lV' => [ '0', '-2', '1', '-4', '1', '-4', '-1', '-3' ],\n             'lQ' => [ '-1', '0', '-2', '3', '-4', '1', '-3', '0' ],\n             'lM' => [ '8', '-3', '8', '-3', '1', '-3', '-3', '-3' ],\n             'lC' => [ '-2', '-3', '-3', '-4', '-3', '-4', '-3', '-3' ],\n             'lL' => [ '1', '-3', '1', '-4', '3', '-4', '-2', '-4' ],\n             'lA' => [ '-2', '1', '-2', '0', '-2', '-2', '2', '2' ],\n             'lW' => [ '-2', '-4', '-3', '-5', '-4', '-5', '-5', '-5' ],\n             'lP' => [ '-3', '-2', '-4', '-3', '-1', '-3', '6', '-3' ],\n             'lH' => [ '-2', '-2', '-3', '-2', '-5', '-2', '-2', '-3' ],\n             'lD' => [ '-4', '-1', '-3', '1', '-3', '-1', '-3', '4' ],\n             'lR' => [ '-2', '-1', '-3', '0', '-4', '4', '-4', '-3' ],\n             'lI' => [ '0', '-3', '0', '-4', '6', '-4', '-2', '-2' ],\n             'lG' => [ '-4', '-2', '-4', '-2', '-5', '-3', '-1', '-2' ],\n             'pS' => [ '0', '33', '0', '16', '1', '12', '11', '25' ],\n             'pF' => [ '0', '0', '2', '0', '3', '0', '0', '0' ],\n             'pT' => [ '0', '8', '7', '10', '1', '2', '7', '8' ],\n             'pN' => [ '0', '0', '2', '13', '0', '36', '1', '4' ],\n             'pK' => [ '0', '5', '0', '13', '1', '15', '0', '2' ],\n             'pY' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pE' => [ '0', '41', '1', '12', '0', '0', '0', '15' ],\n             'pV' => [ '0', '3', '9', '0', '2', '0', '3', '1' ],\n             'pQ' => [ '0', '0', '0', '15', '0', '4', '0', '3' ],\n             'pM' => [ '100', '0', '66', '0', '2', '0', '0', '0' ],\n             'pC' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pL' => [ '0', '0', '8', '0', '25', '0', '4', '0' ],\n             'pA' => [ '0', '10', '1', '9', '2', '0', '22', '16' ],\n             'pW' => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n             'pP' => [ '0', '0', '0', '0', '3', '1', '45', '0' ],\n             'pH' => [ '0', '0', '0', '0', '0', '0', '1', '0' ],\n             'pD' => [ '0', '0', '1', '7', '2', '2', '0', '22' ],\n             'pR' => [ '0', '0', '0', '3', '0', '27', '0', '0' ],\n             'pI' => [ '0', '0', '3', '0', '59', '1', '2', '3' ],\n             'pG' => [ '0', '0', '0', '1', '0', '0', '4', '1' ],\n   );\n\n   my $matrix = Bio::Matrix::PSM::ProtMatrix( %param );\n\n\n   my $site = Bio::Matrix::PSM::ProtMatrix->new(%param);\n   # Or get it from a file:\n   use Bio::Matrix::PSM::IO;\n   my $psmIO = Bio::Matrix::PSM::IO->new(-file => $file, -format => 'psi-blast');\n   while (my $psm = $psmIO->next_psm) {\n      #Now we have a Bio::Matrix::PSM::Psm object, \n      # see Bio::Matrix::PSM::PsmI for details\n      #This is a Bio::Matrix::PSM::ProtMatrix object now\n      my $matrix = $psm->matrix;   \n   }\n\n   # Get a simple consensus, where alphabet is:\n   # {A, R, N, D, C, Q, E, G, H, I, L, K, M, F, P, S, T, W, Y, V,}\n   # choosing the highest probability or N if prob is too low\n   my $consensus = $site->consensus;\n\n   # Retrieving and using regular expressions:\n   my $regexp = $site->regexp;\n   my $count = grep($regexp,$seq);\n   my $count = ($seq=~ s/$regexp/$1/eg);\n   print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nProtMatrix is designed to provide some basic methods when working with\nposition scoring (weight) matrices related to protein sequences.  A\nprotein PSM consists of 20 vectors with 20 frequencies (one per amino\nacid per position).  This is the minimum information you should\nprovide to construct a PSM object.  The vectors can be provided as\nstrings with frequencies where the frequency is {0..a} and a=1. This\nis the way MEME compressed representation of a matrix and it is quite\nuseful when working with relational DB.  If arrays are provided as an\ninput (references to arrays actually) they can be any number, real or\ninteger (frequency or count).\n\nWhen creating the object the constructor will check for positions that\nequal 0.  If such is found it will increase the count for all\npositions by one and recalculate the frequency.  Potential bug - if\nyou are using frequencies and one of the positions is 0 it will change\nsignificantly.  However, you should never have frequency that equals\n0.\n\nThrows an exception if: You mix as an input array and string (for\nexample A matrix is given as array, C - as string).  The position\nvector is (0,0,0,0).  One of the probability vectors is shorter than\nthe rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n   iupac - return IUPAC compliant consensus as a string\n   score - Returns the score as a real number\n   IC - information content. Returns a real number\n   id - identifier. Returns a string\n   accession - accession number. Returns a string\n   next_pos - return the sequence probably for each letter, IUPAC\n         symbol, IUPAC probability and simple sequence\n   consenus letter for this position. Rewind at the end. Returns a hash.\n   pos - current position get/set. Returns an integer.\n   regexp - construct a regular expression based on IUPAC consensus.\n         For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n   width - site width\n   get_string - gets the probability vector for a single base as a string.\n   get_array - gets the probability vector for a single base as an array.\n   get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n   my $str=$matrix->get_compressed_freq('A');\nor\n\n   my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yet implemented.\nHowever you can still uncompress such string with:\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\n\nor\n\n   my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.   Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Thompson\n\nEmail tex@biosysadmin.com\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::ProtMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title    : new\n Usage    : my $site = Bio::Matrix::PSM::ProtMatrix->new( \n               %probs,\n               %logs,\n               -IC    => $ic,\n               -e_val => $score, \n               -id    => $mid\n               -model => \\%model\n            );\n Function : Creates a new Bio::Matrix::PSM::ProtMatrix object from memory\n Throws   : If inconsistent data for all vectors (all 20 amino acids) is\n               provided, if you mix input types (string vs array) or if a\n               position freq is 0.\n Example  :\n Returns  : Bio::Matrix::PSM::ProtMatrix object\n Args     : Hash references to log-odds scores and probabilities for\n            position-specific scoring info, e-value (optional), information\n            content (optional), id (optional), model for background distribution\n            of proteins (optional).\n\n\nsub new {\n   my ($class, @args) = @_;\n   my $self = $class->SUPER::new(@args);\n   my $consensus;\n   #Too many things to rearrange, and I am creating simultanuously >500 \n   # such objects routinely, so this becomes performance issue\n   my %input;\n   while( @args ) {\n     (my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n     $input{$key} = shift @args;\n   }\n\n   # get a protein alphabet for processing log-odds scores and probabilities\n   # maybe change this later on to allow for non-standard aa lists? \n   my @alphabet = qw/A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V/;\n\n   foreach my $aa (@alphabet) {\n      $self->{\"log$aa\"}  = defined($input{\"l$aa\"}) ? $input{\"l$aa\"} \n         : $self->throw(\"Error: No log-odds information for $aa!\");\n      $self->{\"prob$aa\"}  = defined($input{\"p$aa\"}) ? $input{\"p$aa\"} \n         : $self->throw(\"Error: No probability information for $aa!\");\n   }\n   \n   $self->{_position} = 0;\n   $self->{IC}        = $input{IC};\n   $self->{e_val}     = $input{e_val};\n   $self->{sites}     = $input{sites};\n   $self->{width}     = $input{width};\n   $self->{accession_number} = $input{accession_number};\n   $self->{_correction} = defined($input{correction}) ?\n      $input{correction} : 1 ; # Correction might be unwanted- supply your own\n   # No id provided, null for the sake of rel db\n   $self->{id} = defined($input{id}) ? $input{id} : 'null'; \n   $self->{_alphabet} = \\@alphabet;\n\n   #Make consensus, throw if any one of the vectors is shorter\n   $self = _calculate_consensus($self,$input{model});\n   return $self;\n}\n\n=head2 alphabet\n\n Title    : Returns an array (or array reference if desired) to the alphabet \n Usage    :\n Function : Returns an array (or array reference) containing all of the\n            allowable characters for this matrix.\n Throws   :\n Example  :\n Returns  : Array or arrary reference.\n Args     :\n\n\nsub alphabet {\n   my $self = shift;\n   if ( wantarray ) {\n      return $self->{_alphabet};\n   } else {\n      return @{$self->{_alphabet}};\n   }\n}\n\n=head2 _calculate_consensus\n\n Title    : _calculate_consensus\n Usage    :\n Function : Calculates the consensus sequence for this matrix. \n Throws   :\n Example  :\n Returns  :\n Args     :\n\n\nsub _calculate_consensus {\n   my $self   = shift;\n   my $thresh = shift;\n   \n   # verify that all of the array lengths in %probs are the same\n   my @lengths = map { scalar(@$_) } map {$self->{\"prob$_\"}} @{ $self->{_alphabet} };\n   my $len = shift @lengths;\n   for ( @lengths ) {\n      if ( $_ ne $len ) { $self->throw( \"Probability matrix is damaged!\\n\" ) };\n   }\n\n   # iterate over probs, generate the most likely sequence and put it into \n   # $self->{seq}. Put the probability of this sequence into $self->{seqp}.\n   for ( my $i = 0; $i < $len; $i++ ) {\n      # get a list of all the probabilities at position $i, ordered by $self->{_alphabet}\n      my @probs = map { ${$self->{\"prob$_\"}}[$i] } @{ $self->{_alphabet} };\n      # calculate the consensus of @probs, put sequence into seqp and probabilities into seqp\n      (${$self->{seq}}[$i],${$self->{seqp}}[$i]) = $self->_to_cons( @probs, $thresh );\n   }\n\n   return $self;\n}\n\n=head2 next_pos\n\n Title    : next_pos\n Usage    :\n Function : Retrives the next position features: frequencies for all 20 amino\n            acids, log-odds scores for all 20 amino acids at this position,\n            the main (consensus) letter at this position, the probability\n            for the consensus letter to occur at this position and the relative\n            current position as an integer.\n Throws   :\n Example  :\n Returns  : hash (or hash reference) (pA,pR,pN,pD,...,logA,logR,logN,logD,aa,prob,rel)\n            - pN entries represent the probability for amino acid N\n            to be at this position\n            - logN entries represent the log-odds score for having amino acid\n            N at this position\n            - aa is the consensus amino acid\n            - prob is the probability for the consensus amino acid to be at this \n            position\n            - rel is the relative index of the current position (integer)\n Args      : none\n\n\n\nsub next_pos {\n      my $self = shift;\n         $self->throw(\"instance method called on class\") unless ref $self;\n\n      my $len = @{$self->{seq}};\n      my $pos = $self->{_position};\n\n      # return a PSM if we're still within range\n      if ($pos<$len) {\n\n         my %probs = map { (\"p$_\", ${$self->{\"prob$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my %logs  = map { (\"l$_\", ${$self->{\"log$_\"}}[$pos]) } @{$self->{_alphabet}};\n         my $base  = ${$self->{seq}}[$pos];\n         my $prob  = ${$self->{seqp}}[$pos];\n\n         $self->{_position}++;\n         my %hash = ( %probs, %logs, base => $base, rel => $pos, prob => $prob );\n         \n         # decide whether to return the hash or a reference to it\n         if ( wantarray ) {\n            return %hash;\n         } else {\n            return \\%hash;\n         }\n   } else { # otherwise, reset $self->{_position} and return nothing\n      $self->{_position} = 0; \n      return;\n   }\n}\n\n\n=head2 curpos\n\n Title    : curpos\n Usage    :\n Function : Gets/sets the current position. \n Throws   :\n Example  :\n Returns  : Current position (integer).\n Args     : New position (integer).\n\n\nsub curpos {\n      my $self = shift;\n      if (@_) { $self->{_position} = shift; }\n      return $self->{_position};\n}\n\n\n=head2 e_val\n\n Title    : e_val\n Usage    :\n Function : Gets/sets the e-value\n Throws   :\n Example  :\n Returns  : \n Args     : real number\n\n\nsub e_val {\n      my $self = shift;\n      if (@_) { $self->{e_val} = shift; }\n      return $self->{e_val};\n}\n\n\n=head2 IC\n\n Title    : IC\n Usage    :\n Function : Position-specific information content.\n Throws   :\n Example  :\n Returns  : Information content for current position.\n Args     : Information content for current position.\n\n\nsub IC {\n      my $self = shift;\n      if (@_) { $self->{IC} = shift; }\n      return $self->{IC};\n}\n\n=head2 accession_number\n\n Title    : accession_number\n Usage    :\n Function: accession number, this will be unique id for the ProtMatrix object as\n            well for any other object, inheriting from ProtMatrix.\n Throws   :\n Example  :\n Returns  : New accession number (string)\n Args     : Accession number (string)\n\n\nsub accession_number {\n      my $self = shift;\n      if (@_) { $self->{accession_number} = shift; }\n      return $self->{accession_number};\n}\n\n=head2 consensus\n\n Title    : consensus\n Usage    :\n Function : Returns the consensus sequence for this PSM.\n Throws   : if supplied with thresold outisde 5..10 range\n Example  :\n Returns  : string\n Args     : (optional) threshold value 5 to 10 (corresponds to 50-100% at each position\n\n\nsub consensus {\n   my $self = shift;\n   my $thresh=shift;\n   $self->_calculate_consensus($thresh) if ($thresh); #Change of threshold\n   my $consensus='';\n\n   foreach my $letter (@{$self->{seq}}) {\n       $consensus .= $letter;\n   }\n\n   return $consensus;\n}\n\nsub IUPAC {\n   my $self = shift;\n   return $self->consensus;\n}\n\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n            store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Example :\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n   my $self = shift;\n   my $base = shift;\n   my $string = '';\n\n   my @prob = @{$self->{\"prob$base\"}};\n   if ( ! @prob ) {\n      $self->throw( \"No such base: $base\\n\");\n   }\n\n   foreach my $prob (@prob) {\n      my $corrected = $prob*10;\n      my $next = sprintf(\"%.0f\",$corrected);\n      $next = 'a' if ($next eq '10');\n      $string .= $next;\n   }\n   return $string;\n}\n\n\n\n=head2 width\n\n Title    : width\n Usage    :\n Function : Returns the length of the site\n Throws   :\n Example  :\n Returns  : number\n Args     :\n\n\nsub width {\n   my $self = shift;\n   my $width = @{$self->{probA}};\n   return $width;\n}\n\n=head2 get_array\n\n Title    : get_array\n Usage    :\n Function : Returns an array with frequencies for a specified amino acid.\n Throws   :\n Example  :\n Returns  : Array representing frequencies for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"prob$letter\"}}; \n}\n\n\n=head2 get_logs_array\n\n Title    : get_logs_array\n Usage    :\n Function : Returns an array with log_odds for a specified base\n Throws   :\n Example  :\n Returns  : Array representing log-odds scores for specified amino acid.\n Args     : Single amino acid (character).\n\n\nsub get_logs_array {\n   my $self = shift;\n   my $letter = uc(shift);\n\n   $self->throw (\"No such base: $letter!\\n\") unless grep { /$letter/ } @{$self->{_alphabet}};\n\n   return @{$self->{\"log$letter\"}}; \n}\n\n=head2 id\n\n Title    : id\n Usage    :\n Function : Gets/sets the site id\n Throws   :\n Example  :\n Returns  : string\n Args     : string\n\n\nsub id {\n      my $self = shift;\n      if (@_) { $self->{id} = shift; }\n      return $self->{id};\n}\n\n=head2 regexp\n\n Title    : regexp\n Usage    :\n Function : Returns a case-insensitive regular expression which matches the\n            IUPAC convention.  X's in consensus sequence will match anything.     \n Throws   :\n Example  :\n Returns  : string\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n\n\nsub regexp {\n   my $self = shift;\n   my $threshold = 20;\n   if ( @_ ) { my $threshold = shift };\n\n   my @alphabet = @{$self->{_alphabet}};\n   my $width = $self->width;\n   my (@regexp, $i);\n   for ( $i = 0; $i < $width; $i++ ) {\n      # get an array of the residues at this position with p > $threshold\n      my @letters = map { uc($_).lc($_) } grep { $self->{\"prob$_\"}->[$i] >= $threshold } @alphabet;\n\n      my $reg;\n      if ( scalar(@letters) == 0 ) {\n         $reg = '\\.';\n      } else {\n         $reg = '['.join('',@letters).']';\n      }\n      push @regexp, $reg;\n   }\n\n   if ( wantarray ) { \n      return @regexp;\n   } else {\n      return join '', @regexp;\n   }\n}\n\n\n=head2 regexp_array\n\n Title    : regexp_array\n Usage    :\n Function : Returns an array of position-specific regular expressions.\n             X's in consensus sequence will match anything.      \n Throws   :\n Example  :\n Returns  : Array of position-specific regular expressions.\n Args     : Threshold for calculating consensus sequence (number in range 0-100\n            representing a percentage). Threshold defaults to 20.\n Notes    : Simply calls regexp method in list context.\n\n\nsub regexp_array {\n   my $self = shift;\n   \n   return @{ $self->regexp };\n}\n\n\n=head2 _compress_array\n\n Title    : _compress_array\n Usage    :\n Function :  Will compress an array of real signed numbers to a string (ie vector of bytes)\n             -127 to +127 for bi-directional(signed) and 0..255 for unsigned ;\n Throws   :\n Example  :  Internal stuff\n Returns  :  String\n Args     :  array reference, followed by max value and direction (optional, defaults to 1),\n             direction of 1 is unsigned, anything else is signed. \n\n\nsub _compress_array {\n   my ($array,$lm,$direct)=@_;\n   my $str;\n   return unless(($array) && ($lm));\n   $direct=1 unless ($direct);\n   my $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n   foreach my $c (@{$array}) {\n      $c=$lm if ($c>$lm);\n      $c=-$lm if (($c<-$lm) && ($direct !=1));\n      $c=0 if (($c<0) && ($direct ==1));\n      my $byte=int($k1*$c);\n      $byte=127+$byte if ($direct !=1);#Clumsy, should be really shift the bits\n      my $char=chr($byte);\n      $str.=$char;\n   }\n   return $str;\n}\n\n=head2 _uncompress_string\n\n Title    : _uncompress_string\n Usage    :\n Function :   Will uncompress a string (vector of bytes) to create an array of real\n                  signed numbers (opposite to_compress_array)\n Throws   :\n Example  :   Internal stuff\n Returns  :   string, followed by max value and direction (optional, defaults to 1),\n              direction of 1 is unsigned, anything else is signed.\n Args     :   array\n\n\nsub _uncompress_string {\n   my ($str,$lm,$direct)=@_;\n   my @array;\n   return unless(($str) && ($lm));\n   $direct=1 unless ($direct);\n   my $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n   while (my $c=chop($str)) {\n      my $byte=ord($c);\n      $byte=$byte-127 if ($direct !=1);#Clumsy, should be really shift the bits\n      my $num=$byte/$k1;\n      unshift @array,$num;\n   }\n\n   return @array;\n}\n\n=head2 get_compressed_freq\n\n Title    : get_compressed_freq\n Usage    :\n Function:   A method to provide a compressed frequency vector. It uses one byte to\n             code the frequence for one of the probability vectors for one position.\n             Useful for relational database. Improvment of the previous 0..a coding.\n Throws   :\n Example  :   my $strA=$self->get_compressed_freq('A');\n Returns  :   String\n Args     :   char \n\n\nsub get_compressed_freq {\n   my $self=shift;\n   my $base=shift;\n   my $string='';\n   my @prob;\n   BASE: {\n      if ($base eq 'A') {\n         @prob = @{$self->{probA}} unless (!defined($self->{probA}));\n         last BASE;\n      }\n         if ($base eq 'G') {\n         @prob = @{$self->{probG}} unless (!defined($self->{probG}));\n         last BASE;\n      }\n         if ($base eq 'C') {\n         @prob = @{$self->{probC}} unless (!defined($self->{probC}));\n         last BASE;\n      }\n         if ($base eq 'T') {\n         @prob = @{$self->{probT}} unless (!defined($self->{probT}));\n         last BASE;\n      }\n      $self->throw (\"No such base: $base!\\n\");\n   }\n   my $str= _compress_array(\\@prob,1,1);\n   return $str;\n}\n\n=head2 sequence_match_weight\n\n Title    : sequence_match_weight\n Usage    :\n Function :   This method will calculate the score of a match, based on the PSM\n              if such is associated with the matrix object. Returns undef if no\n              PSM data is available.\n Throws   :   if the length of the sequence is different from the matrix width\n Example  :   my $score=$matrix->sequence_match_weight('ACGGATAG');\n Returns  :   Floating point\n Args     :   string\n\n\nsub sequence_match_weight {\n   my ($self,$seq)=@_;\n   return unless ($self->{logA});\n\n   my $seqlen = length($seq);\n   my $width  = $self->width;\n   $self->throw(\"Error: Input sequence size ($seqlen) not equal to PSM size ($width)!\\n\")\n      unless (length($seq) == $self->width);\n\n   my ($score,$i) = (0,0);\n   foreach my $letter ( split //, $seq ) {\n      # add up the score for this position\n      $score += $self->{\"log$letter\"}->[$i];\n      $i++;\n   }\n   return $score;\n}\n\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol and returns its probability.\n            Currently returns the most likely amino acid/probability combination.\n Throws  :\n Example :\n Returns : char, real number representing an amino acid and a probability.\n Args    : real numbers for all 20 amino acids (ordered by alphabet contained\n            in $self->{_alphabet}, minimum probability threshold."},"line":806,"kind":12,"range":{"end":{"character":9999,"line":814},"start":{"line":806,"character":0}}},{"line":814,"name":"_alphabet","kind":12},{"definition":"my","name":"$prob","kind":13,"localvar":"my","containerName":null,"line":815},{"line":815,"kind":13,"containerName":null,"name":"@probs"},{"name":"$prob","kind":13,"containerName":null,"line":816},{"kind":13,"containerName":null,"name":"%max_prob","line":816},{"line":817,"containerName":null,"kind":13,"name":"$IUPAC_aa"},{"name":"$aa","containerName":null,"kind":13,"line":817},{"name":"$max_prob","containerName":null,"kind":13,"line":818},{"line":818,"name":"$prob","kind":13,"containerName":null},{"name":"$IUPAC_aa","containerName":null,"kind":13,"line":822},{"kind":13,"containerName":null,"name":"$max_prob","line":822},{"line":838,"range":{"end":{"character":9999,"line":840},"start":{"line":838,"character":0}},"kind":12,"definition":"sub","children":[],"name":"_to_cons","containerName":"main::"}]}