{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":101},{"children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"new","line":114},{"line":114,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":115,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":115},{"name":"@args","containerName":"new","kind":13,"line":115},{"line":117,"name":"$order","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":117,"name":"$self","kind":13,"containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":117},{"name":"@args","containerName":"new","kind":13,"line":117},{"line":118,"name":"$order","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":118},{"kind":12,"containerName":"new","name":"order","line":118},{"line":118,"containerName":"new","kind":13,"name":"$order"},{"containerName":"new","kind":13,"name":"$self","line":120}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":113,"range":{"end":{"character":9999,"line":121},"start":{"line":113,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position"}},{"name":"SUPER","containerName":"new","kind":12,"line":115},{"kind":12,"range":{"end":{"line":140,"character":9999},"start":{"character":0,"line":134}},"line":134,"signature":{"label":"order($self,$order)","parameters":[{"label":"$self"},{"label":"$order"}],"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set"},"containerName":"main::","name":"order","children":[{"definition":"my","line":135,"containerName":"order","localvar":"my","kind":13,"name":"$self"},{"line":135,"name":"$order","kind":13,"containerName":"order"},{"line":136,"kind":13,"containerName":"order","name":"$order"},{"line":137,"name":"$self","kind":13,"containerName":"order"},{"name":"$order","kind":13,"containerName":"order","line":137},{"line":139,"containerName":"order","kind":13,"name":"$self"}],"detail":"($self,$order)","definition":"sub"},{"line":155,"range":{"end":{"line":158,"character":9999},"start":{"line":155,"character":0}},"kind":12,"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"sortable","name":"$self","line":156},{"name":"$self","containerName":"sortable","kind":13,"line":157},{"name":"order","kind":12,"containerName":"sortable","line":157}],"containerName":"main::","name":"sortable","definition":"sub"},{"detail":"($self,$compare)","definition":"sub","name":"equals","containerName":"main::","children":[{"definition":"my","line":171,"name":"$self","containerName":"equals","localvar":"my","kind":13},{"name":"$compare","kind":13,"containerName":"equals","line":171},{"name":"$compare","containerName":"equals","kind":13,"line":172},{"line":172,"name":"$compare","kind":13,"containerName":"equals"},{"kind":12,"containerName":"equals","name":"isa","line":172},{"line":173,"containerName":"equals","kind":13,"name":"$compare"},{"line":173,"name":"order","containerName":"equals","kind":12},{"kind":13,"containerName":"equals","name":"$self","line":173},{"containerName":"equals","kind":12,"name":"order","line":173}],"signature":{"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set\n\n\nsub order {\n    my ($self, $order) = @_;\n    if ($order) {\n        $self->{'_order'} = $order;\n    }\n    return $self->{'_order'} || return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    return $self->order;\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position.\n Returns : boolean\n Args    : Bio::Map::PositionI","parameters":[{"label":"$self"},{"label":"$compare"}],"label":"equals($self,$compare)"},"range":{"start":{"character":0,"line":170},"end":{"line":174,"character":9999}},"kind":12,"line":170},{"detail":"($self,$compare)","definition":"sub","containerName":"main::","name":"less_than","children":[{"definition":"my","line":193,"name":"$self","containerName":"less_than","localvar":"my","kind":13},{"line":193,"name":"$compare","containerName":"less_than","kind":13},{"line":194,"containerName":"less_than","kind":13,"name":"$compare"},{"line":194,"containerName":"less_than","kind":13,"name":"$compare"},{"name":"isa","kind":12,"containerName":"less_than","line":194},{"kind":13,"containerName":"less_than","name":"$compare","line":195},{"containerName":"less_than","kind":12,"name":"order","line":195},{"name":"$self","containerName":"less_than","kind":13,"line":195},{"kind":12,"containerName":"less_than","name":"order","line":195}],"signature":{"parameters":[{"label":"$self"},{"label":"$compare"}],"documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set\n\n\nsub order {\n    my ($self, $order) = @_;\n    if ($order) {\n        $self->{'_order'} = $order;\n    }\n    return $self->{'_order'} || return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    return $self->order;\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position.\n Returns : boolean\n Args    : Bio::Map::PositionI\n\n\nsub equals {\n   my ($self,$compare) = @_;\n   return 0 if (! defined $compare || ! $compare->isa('Bio::Map::OrderedPosition'));\n   return ($compare->order == $self->order);\n}\n\n# admittedly these aren't really the best comparisons in the world\n# but it is a first pass we'll need to refine the algorithm or not \n# provide general comparisions and require these to be implemented\n# by objects closer to the specific type of data\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($mappable->less_than($m2)) {...}\n Function: Tests if a position is less than another position\n           It is assumed that 2 positions are in the same map.\n Returns : boolean\n Args    : Bio::Map::PositionI","label":"less_than($self,$compare)"},"kind":12,"range":{"end":{"character":9999,"line":196},"start":{"line":192,"character":0}},"line":192},{"signature":{"label":"greater_than($self,$compare)","documentation":"1;\n# BioPerl module for Bio::Map::OrderedPosition\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::OrderedPosition - Abstracts the notion of a member\n\tof an ordered list of markers. Each marker is a certain distance\n\tfrom the one in the ordered list before it.\n\n=head1 SYNOPSIS\n\n    use Bio::Map::OrderedPosition;\n\t# the first marker in the sequence\n    my $position = Bio::Map::OrderedPosition->new(-order => 1,\n\t\t\t-positions => [ [ $map, 22.3] ] );\n\t# the second marker in the sequence, 15.6 units from the fist one\n    my $position2 = Bio::Map::OrderedPosition->new(-order => 2,\n\t\t\t-positions => [ [ $map, 37.9] ] );\n\t# the third marker in the sequence, coincidental with the second\n\t# marker\n    my $position3 = Bio::Map::OrderedPosition->new(-order => 3,\n                        -posititions => [ [ $map, 37.9]] );\n\n=head1 DESCRIPTION\n\nThis object is an implementation of the PositionI interface and the\nPosition object handles the specific values of a position.\nOrderedPosition is intended to be slightly more specific then Position\nbut only specific enough for a parser from the MarkerIO subsystem to\ncreate and then pass to a client application to bless into the proper\ntype. For an example of how this is intended to work, see the\nMapmaker.pm.\n\nNo units are assumed here - units are handled by context of which Map\na position is placed in.\n\nSe Bio::Map::Position for additional information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nLincoln Stein, lstein@cshl.org\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nJason Stajich, jason@bioperl.org\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::OrderedPosition;\nuse strict;\n\n\nuse base qw(Bio::Map::Position);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::OrderedPosition->new();\n Function: Builds a new Bio::Map::OrderedPosition object \n Returns : Bio::Map::OrderedPosition\n Args    : -order : The order of this position\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($order) = $self->_rearrange([qw(ORDER)], @args);\n    $order && $self->order($order);\n    \n    return $self;\n}\n\n=head2 order\n\n Title   : order\n Usage   : $o_position->order($new_order);\n           my $order = $o_position->order();\n Function: Get/set the order position of this position in a map.\n Returns : int, the order of this position\n Args    : none to get, OR int to set\n\n\nsub order {\n    my ($self, $order) = @_;\n    if ($order) {\n        $self->{'_order'} = $order;\n    }\n    return $self->{'_order'} || return;\n}\n\n=head2 sortable\n\n Title   : sortable\n Usage   : my $num = $position->sortable();\n Function: Read-only method that is guaranteed to return a value suitable\n           for correctly sorting this kind of position amongst other positions\n           of the same kind on the same map. Note that sorting different kinds\n           of position together is unlikely to give sane results.\n Returns : numeric\n Args    : none\n\n\nsub sortable {\n    my $self = shift;\n    return $self->order;\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if ($mappable->equals($mapable2)) {...}\n Function: Test if a position is equal to another position.\n Returns : boolean\n Args    : Bio::Map::PositionI\n\n\nsub equals {\n   my ($self,$compare) = @_;\n   return 0 if (! defined $compare || ! $compare->isa('Bio::Map::OrderedPosition'));\n   return ($compare->order == $self->order);\n}\n\n# admittedly these aren't really the best comparisons in the world\n# but it is a first pass we'll need to refine the algorithm or not \n# provide general comparisions and require these to be implemented\n# by objects closer to the specific type of data\n\n=head2 less_than\n\n Title   : less_than\n Usage   : if ($mappable->less_than($m2)) {...}\n Function: Tests if a position is less than another position\n           It is assumed that 2 positions are in the same map.\n Returns : boolean\n Args    : Bio::Map::PositionI\n\n\nsub less_than {\n   my ($self,$compare) = @_;\n   return 0 if (! defined $compare || ! $compare->isa('Bio::Map::OrderedPosition'));\n   return ($compare->order < $self->order);\n}\n\n=head2 greater_than\n\n Title   : greater_than\n Usage   : if ($mappable->greater_than($m2)) {...}\n Function: Tests if position is greater than another position.\n           It is assumed that 2 positions are in the same map.\n Returns : boolean\n Args    : Bio::Map::PositionI","parameters":[{"label":"$self"},{"label":"$compare"}]},"kind":12,"range":{"start":{"character":0,"line":209},"end":{"character":9999,"line":213}},"line":209,"detail":"($self,$compare)","definition":"sub","containerName":"main::","name":"greater_than","children":[{"definition":"my","line":210,"name":"$self","localvar":"my","containerName":"greater_than","kind":13},{"kind":13,"containerName":"greater_than","name":"$compare","line":210},{"line":211,"kind":13,"containerName":"greater_than","name":"$compare"},{"line":211,"kind":13,"containerName":"greater_than","name":"$compare"},{"containerName":"greater_than","kind":12,"name":"isa","line":211},{"line":212,"kind":13,"containerName":"greater_than","name":"$compare"},{"line":212,"kind":12,"containerName":"greater_than","name":"order"},{"line":212,"containerName":"greater_than","kind":13,"name":"$self"},{"line":212,"name":"order","containerName":"greater_than","kind":12}]}]}