{"vars":[{"containerName":"","kind":2,"name":"base","line":94},{"children":[{"line":108,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"line":108,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":109,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":109},{"line":109,"name":"@args","containerName":"new","kind":13},{"definition":"my","name":"$name","localvar":"my","kind":13,"containerName":"new","line":111},{"line":111,"name":"$id","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":111},{"line":111,"name":"_rearrange","kind":12,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":111},{"line":112,"name":"$self","kind":13,"containerName":"new"},{"name":"name","kind":12,"containerName":"new","line":112},{"line":112,"kind":13,"containerName":"new","name":"$name"},{"containerName":"new","kind":13,"name":"$name","line":112},{"kind":13,"containerName":"new","name":"$self","line":113},{"line":113,"containerName":"new","kind":12,"name":"id"},{"name":"$id","containerName":"new","kind":13,"line":113},{"containerName":"new","kind":13,"name":"$id","line":113},{"line":115,"name":"$self","kind":13,"containerName":"new"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":107,"range":{"end":{"character":9999,"line":116},"start":{"character":0,"line":107}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Mappable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Mappable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Mappable - An object representing a generic map element\nthat can have multiple locations in several maps.\n\n=head1 SYNOPSIS\n\n  # a map element in two different positions on the same map\n  $map1 = Bio::Map::SimpleMap->new();\n  $position1 = Bio::Map::Position->new(-map => $map1, -value => 100);\n  $position2 = Bio::Map::Position->new(-map => $map1, -value => 200);\n  $mappable = Bio::Map::Mappable->new(-positions => [$position1, $position2] );\n\n  # add another position on a different map\n  $map2 = Bio::Map::SimpleMap->new();\n  $position3 = Bio::Map::Position->new(-map => $map2, $value => 50);\n  $mappable->add_position($position3);\n\n  # get all the places our map element is found, on a particular map of interest\n  foreach $pos ($mappable->get_positions($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a generic map element. Mappables are\nentities with one or more positions on one or more maps.\n\nThis object is a pure perl implementation of L<Bio::Map::MappableI>. That\ninterface implements some of its own methods so check the docs there for\nthose.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Mappable;\nuse strict;\nuse Bio::Map::Relative;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $mappable = Bio::Map::Mappable->new();\n Function: Builds a new Bio::Map::Mappable object\n Returns : Bio::Map::Mappable\n Args    : -name => string : name of the mappable element\n           -id   => string : id of the mappable element","label":"new($class,@args)"}},{"line":109,"kind":12,"containerName":"new","name":"SUPER"},{"definition":"sub","containerName":"main::","name":"name","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"name","line":131},{"line":132,"name":"$self","kind":13,"containerName":"name"},{"line":133,"containerName":"name","kind":13,"name":"$self"}],"range":{"start":{"line":130,"character":0},"end":{"character":9999,"line":134}},"kind":12,"line":130},{"kind":12,"name":"_name","line":132},{"line":133,"name":"_name","kind":12},{"range":{"start":{"line":148,"character":0},"end":{"line":152,"character":9999}},"kind":12,"line":148,"definition":"sub","name":"id","containerName":"main::","children":[{"definition":"my","line":149,"localvar":"my","kind":13,"containerName":"id","name":"$self"},{"containerName":"id","kind":13,"name":"$self","line":150},{"kind":13,"containerName":"id","name":"$self","line":151}]},{"line":150,"kind":12,"name":"_id"},{"line":151,"name":"_id","kind":12},{"signature":{"label":"in_map($self,$query_map)","parameters":[{"label":"$self"},{"label":"$query_map"}],"documentation":"1;\n# $Id: Mappable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Mappable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Mappable - An object representing a generic map element\nthat can have multiple locations in several maps.\n\n=head1 SYNOPSIS\n\n  # a map element in two different positions on the same map\n  $map1 = Bio::Map::SimpleMap->new();\n  $position1 = Bio::Map::Position->new(-map => $map1, -value => 100);\n  $position2 = Bio::Map::Position->new(-map => $map1, -value => 200);\n  $mappable = Bio::Map::Mappable->new(-positions => [$position1, $position2] );\n\n  # add another position on a different map\n  $map2 = Bio::Map::SimpleMap->new();\n  $position3 = Bio::Map::Position->new(-map => $map2, $value => 50);\n  $mappable->add_position($position3);\n\n  # get all the places our map element is found, on a particular map of interest\n  foreach $pos ($mappable->get_positions($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a generic map element. Mappables are\nentities with one or more positions on one or more maps.\n\nThis object is a pure perl implementation of L<Bio::Map::MappableI>. That\ninterface implements some of its own methods so check the docs there for\nthose.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Mappable;\nuse strict;\nuse Bio::Map::Relative;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $mappable = Bio::Map::Mappable->new();\n Function: Builds a new Bio::Map::Mappable object\n Returns : Bio::Map::Mappable\n Args    : -name => string : name of the mappable element\n           -id   => string : id of the mappable element\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($name, $id) = $self->_rearrange([qw(NAME ID)], @args);\n    $self->name($name) if $name;\n    $self->id($id) if $id;\n    \n    return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : $mappable->name($new_name);\n\t       my $name = $mappable->name();\n Function: Get/Set the name for this Mappable\n Returns : A scalar representing the current name of this Mappable\n Args    : none to get\n           string to set\n\n\nsub name {\n    my $self = shift;\n    if (@_) { $self->{_name} = shift }\n    return $self->{_name} || '';\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $mappable->id();\n           $mappable->id($new_id);\n Function: Get/Set the id for this Mappable.\n Returns : A scalar representing the current id of this Mappable\n Args    : none to get\n           string to set\n\n\nsub id {\n    my $self = shift;\n    if (@_) { $self->{_id} = shift }\n    return $self->{_id} || return;\n}\n\n=head2 in_map\n\n Title   : in_map\n Usage   : if ($mappable->in_map($map)) {...}\n Function: Tests if this mappable is found on a specific map\n Returns : boolean\n Args    : L<Bio::Map::MapI>"},"range":{"start":{"line":164,"character":0},"end":{"line":175,"character":9999}},"kind":12,"line":164,"detail":"($self,$query_map)","definition":"sub","name":"in_map","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"in_map","kind":13,"name":"$self","line":165},{"name":"$query_map","containerName":"in_map","kind":13,"line":165},{"line":166,"name":"$self","kind":13,"containerName":"in_map"},{"name":"throw","kind":12,"containerName":"in_map","line":166},{"containerName":"in_map","kind":13,"name":"$query_map","line":166},{"line":167,"containerName":"in_map","kind":13,"name":"$self"},{"kind":12,"containerName":"in_map","name":"throw","line":167},{"kind":13,"containerName":"in_map","name":"$query_map","line":167},{"name":"$self","kind":13,"containerName":"in_map","line":168},{"name":"throw","kind":12,"containerName":"in_map","line":168},{"line":168,"containerName":"in_map","kind":13,"name":"$query_map"},{"containerName":"in_map","kind":12,"name":"isa","line":168},{"line":170,"localvar":"my","kind":13,"containerName":"in_map","name":"$map","definition":"my"},{"containerName":"in_map","kind":13,"name":"$self","line":170},{"line":170,"kind":12,"containerName":"in_map","name":"known_maps"},{"line":171,"name":"$map","containerName":"in_map","kind":13},{"line":171,"name":"$query_map","kind":13,"containerName":"in_map"}]},{"definition":"sub","containerName":"main::","name":"equals","children":[{"localvar":"my","containerName":"equals","kind":13,"name":"$self","line":201,"definition":"my"},{"kind":13,"containerName":"equals","name":"$self","line":202},{"line":202,"kind":12,"containerName":"equals","name":"_compare"}],"kind":12,"range":{"start":{"line":200,"character":0},"end":{"line":203,"character":9999}},"line":200},{"kind":12,"range":{"end":{"line":227,"character":9999},"start":{"character":0,"line":224}},"line":224,"containerName":"main::","name":"less_than","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"less_than","name":"$self","line":225},{"line":226,"name":"$self","kind":13,"containerName":"less_than"},{"line":226,"containerName":"less_than","kind":12,"name":"_compare"}],"definition":"sub"},{"line":248,"kind":12,"range":{"start":{"character":0,"line":248},"end":{"character":9999,"line":251}},"children":[{"localvar":"my","kind":13,"containerName":"greater_than","name":"$self","line":249,"definition":"my"},{"line":250,"kind":13,"containerName":"greater_than","name":"$self"},{"kind":12,"containerName":"greater_than","name":"_compare","line":250}],"containerName":"main::","name":"greater_than","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":275},"start":{"line":272,"character":0}},"line":272,"definition":"sub","name":"overlaps","containerName":"main::","children":[{"definition":"my","line":273,"name":"$self","containerName":"overlaps","localvar":"my","kind":13},{"line":274,"kind":13,"containerName":"overlaps","name":"$self"},{"line":274,"name":"_compare","kind":12,"containerName":"overlaps"}]},{"definition":"sub","name":"contains","containerName":"main::","children":[{"definition":"my","line":297,"name":"$self","containerName":"contains","localvar":"my","kind":13},{"kind":13,"containerName":"contains","name":"$self","line":298},{"kind":12,"containerName":"contains","name":"_compare","line":298}],"kind":12,"range":{"end":{"character":9999,"line":299},"start":{"line":296,"character":0}},"line":296},{"definition":"sub","containerName":"main::","name":"overlapping_groups","children":[{"definition":"my","name":"$self","containerName":"overlapping_groups","localvar":"my","kind":13,"line":347},{"kind":13,"containerName":"overlapping_groups","name":"$self","line":348},{"line":348,"containerName":"overlapping_groups","kind":12,"name":"_compare"}],"kind":12,"range":{"end":{"character":9999,"line":349},"start":{"character":0,"line":346}},"line":346},{"line":399,"range":{"start":{"character":0,"line":399},"end":{"character":9999,"line":402}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"disconnected_intersections","line":400},{"name":"$self","kind":13,"containerName":"disconnected_intersections","line":401},{"name":"_compare","containerName":"disconnected_intersections","kind":12,"line":401}],"name":"disconnected_intersections","containerName":"main::"},{"line":451,"range":{"start":{"character":0,"line":451},"end":{"line":454,"character":9999}},"kind":12,"children":[{"definition":"my","line":452,"name":"$self","localvar":"my","kind":13,"containerName":"disconnected_unions"},{"name":"$self","kind":13,"containerName":"disconnected_unions","line":453},{"line":453,"kind":12,"containerName":"disconnected_unions","name":"_compare"}],"containerName":"main::","name":"disconnected_unions","definition":"sub"},{"children":[{"line":459,"name":"$self","containerName":"_compare","localvar":"my","kind":13,"definition":"my"},{"line":459,"name":"$method","containerName":"_compare","kind":13},{"name":"$input","containerName":"_compare","kind":13,"line":459},{"line":459,"containerName":"_compare","kind":13,"name":"@extra_args"},{"kind":13,"containerName":"_compare","name":"$self","line":460},{"name":"throw","containerName":"_compare","kind":12,"line":460},{"kind":13,"containerName":"_compare","name":"$input","line":460},{"line":461,"containerName":"_compare","kind":13,"name":"$self"},{"line":461,"name":"throw","containerName":"_compare","kind":12},{"line":461,"kind":13,"containerName":"_compare","name":"@extra_args"},{"definition":"my","line":462,"name":"@compares","localvar":"my","containerName":"_compare","kind":13},{"kind":13,"containerName":"_compare","name":"$input","line":462},{"line":462,"name":"$input","containerName":"_compare","kind":13}],"name":"_compare","containerName":"main::","definition":"sub","detail":"($self,$method,$input,@extra_args)","line":458,"kind":12,"range":{"start":{"character":0,"line":458},"end":{"line":462,"character":9999}},"signature":{"label":"_compare($self,$method,$input,@extra_args)","documentation":" do a RangeI-related comparison by calling the corresponding PositionI method\n on all the requested Positions of our Mappables","parameters":[{"label":"$self"},{"label":"$method"},{"label":"$input"},{"label":"@extra_args"}]}},{"kind":13,"containerName":null,"name":"$input","line":462},{"definition":"my","line":464,"kind":13,"localvar":"my","containerName":null,"name":"%args"},{"name":"@extra_args","kind":13,"containerName":null,"line":467},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$map","line":468},{"line":468,"containerName":null,"kind":13,"name":"%args"},{"definition":"my","name":"$rel","localvar":"my","containerName":null,"kind":13,"line":469},{"line":469,"name":"%args","containerName":null,"kind":13},{"definition":"my","line":470,"localvar":"my","containerName":null,"kind":13,"name":"$overlap"},{"line":470,"kind":13,"containerName":null,"name":"%args"},{"line":471,"kind":13,"localvar":"my","containerName":null,"name":"$min_pos_num","definition":"my"},{"line":471,"kind":13,"containerName":null,"name":"%args"},{"localvar":"my","containerName":null,"kind":13,"name":"$min_pables_num","line":472,"definition":"my"},{"kind":13,"containerName":null,"name":"%args","line":472},{"containerName":null,"kind":13,"name":"%args","line":473},{"line":474,"localvar":"my","containerName":null,"kind":13,"name":"$mn","definition":"my"},{"line":474,"name":"@compares","containerName":null,"kind":13},{"line":474,"name":"$self","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%args","line":474},{"line":475,"containerName":null,"kind":13,"name":"$mn"},{"containerName":null,"kind":13,"name":"%min_pables_num","line":475},{"line":476,"name":"$min_pables_num","kind":13,"containerName":null},{"line":476,"kind":13,"containerName":null,"name":"$mn"},{"definition":"my","line":479,"name":"$min_map_num","localvar":"my","containerName":null,"kind":13},{"line":479,"name":"%args","kind":13,"containerName":null},{"line":480,"name":"%args","kind":13,"containerName":null},{"definition":"my","line":481,"name":"%known_maps","containerName":null,"localvar":"my","kind":13},{"name":"$pable","localvar":"my","containerName":null,"kind":13,"line":482,"definition":"my"},{"line":482,"name":"@compares","containerName":null,"kind":13},{"line":482,"kind":13,"containerName":null,"name":"$self"},{"name":"%self","containerName":null,"kind":13,"line":482},{"definition":"my","line":483,"kind":13,"localvar":"my","containerName":null,"name":"$known"},{"line":483,"containerName":null,"kind":13,"name":"$pable"},{"containerName":"main::","kind":12,"name":"known_maps","line":483},{"containerName":null,"kind":13,"name":"%known_maps","line":484},{"line":484,"name":"$known","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"unique_id","line":484},{"definition":"my","name":"$mn","kind":13,"localvar":"my","containerName":null,"line":487},{"name":"%known_maps","kind":13,"containerName":null,"line":487},{"kind":13,"containerName":null,"name":"%args","line":487},{"line":488,"kind":13,"containerName":null,"name":"$mn"},{"line":488,"kind":13,"containerName":null,"name":"%min_map_num"},{"line":489,"name":"$min_map_num","kind":13,"containerName":null},{"name":"$mn","kind":13,"containerName":null,"line":489},{"name":"%required","containerName":null,"localvar":"my","kind":13,"line":492,"definition":"my"},{"line":492,"containerName":null,"kind":13,"name":"%args"},{"name":"%args","containerName":null,"kind":13,"line":492},{"localvar":"my","kind":13,"containerName":null,"name":"@mine","line":493,"definition":"my"},{"name":"@yours","containerName":null,"kind":13,"line":493},{"line":495,"name":"%self","kind":13,"containerName":null},{"line":496,"name":"@mine","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":496},{"name":"get_positions","kind":12,"containerName":"main::","line":496},{"line":496,"name":"$map","kind":13,"containerName":null},{"name":"%args","kind":13,"containerName":null,"line":497},{"containerName":null,"kind":13,"name":"@mine","line":498},{"name":"%required","containerName":null,"kind":13,"line":499},{"line":499,"containerName":null,"kind":13,"name":"$self"},{"line":502,"localvar":"my","containerName":null,"kind":13,"name":"@required","definition":"my"},{"name":"%required","containerName":null,"kind":13,"line":502},{"localvar":"my","containerName":null,"kind":13,"name":"$compare","line":504,"definition":"my"},{"line":504,"name":"@compares","kind":13,"containerName":null},{"name":"$compare","kind":13,"containerName":null,"line":505},{"line":505,"name":"isa","kind":12,"containerName":"main::"},{"line":506,"kind":13,"containerName":null,"name":"@yours"},{"containerName":null,"kind":13,"name":"$compare","line":506},{"name":"$compare","containerName":null,"kind":13,"line":508},{"kind":12,"containerName":"main::","name":"isa","line":508},{"line":509,"containerName":null,"kind":13,"name":"@yours"},{"line":509,"name":"$compare","containerName":null,"kind":13},{"name":"get_positions","containerName":"main::","kind":12,"line":509},{"line":509,"containerName":null,"kind":13,"name":"%map"},{"line":512,"containerName":null,"kind":13,"name":"$self"},{"line":512,"name":"throw","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"@yours","line":515},{"line":517,"containerName":null,"localvar":"my","kind":13,"name":"@ok","definition":"my"},{"line":518,"kind":12,"name":"SWITCH"},{"name":"%method","kind":13,"containerName":null,"line":518},{"line":520,"name":"@mine","containerName":null,"kind":13},{"containerName":null,"localvar":"my","kind":13,"name":"$my_pos","line":521,"definition":"my"},{"line":521,"kind":13,"containerName":null,"name":"@mine"},{"name":"$your_pos","containerName":null,"localvar":"my","kind":13,"line":522,"definition":"my"},{"containerName":null,"kind":13,"name":"@yours","line":522},{"containerName":null,"kind":13,"name":"$my_pos","line":523},{"line":523,"containerName":null,"kind":13,"name":"$method"},{"name":"$your_pos","kind":13,"containerName":null,"line":523},{"containerName":null,"kind":13,"name":"%rel","line":523},{"name":"@ok","kind":13,"containerName":null,"line":524},{"line":524,"kind":13,"containerName":null,"name":"$my_pos"},{"line":529,"name":"SWITCH","kind":12},{"line":532,"containerName":null,"kind":13,"name":"@mine"},{"containerName":null,"kind":13,"name":"%method","line":533},{"line":534,"containerName":null,"kind":13,"name":"@mine"},{"line":535,"containerName":null,"kind":13,"name":"@b"},{"kind":13,"containerName":null,"name":"@a","line":535},{"line":536,"kind":12,"containerName":"main::","name":"end"},{"line":536,"name":"absolute_relative","kind":12,"containerName":"main::"},{"name":"@mine","kind":13,"containerName":null,"line":537},{"line":538,"kind":13,"containerName":null,"name":"@yours"},{"kind":13,"containerName":null,"name":"@b","line":539},{"line":539,"name":"@a","kind":13,"containerName":null},{"name":"end","kind":12,"containerName":"main::","line":540},{"line":540,"kind":12,"containerName":"main::","name":"absolute_relative"},{"containerName":null,"kind":13,"name":"@yours","line":541},{"line":543,"name":"$test_pos","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"@yours","containerName":null,"kind":13,"line":543},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$my_pos","line":545},{"line":545,"containerName":null,"kind":13,"name":"@mine"},{"name":"$my_pos","kind":13,"containerName":null,"line":546},{"containerName":null,"kind":13,"name":"$method","line":546},{"name":"$test_pos","kind":13,"containerName":null,"line":546},{"kind":13,"containerName":null,"name":"%rel","line":546},{"line":547,"name":"@ok","kind":13,"containerName":null},{"line":547,"name":"%my_pos","kind":13,"containerName":null},{"line":554,"name":"%method","containerName":null,"kind":13},{"name":"@ok","containerName":null,"kind":13,"line":555},{"containerName":null,"kind":13,"name":"@a","line":556},{"line":556,"name":"@b","containerName":null,"kind":13},{"line":557,"containerName":"main::","kind":12,"name":"sortable"},{"line":558,"name":"@ok","containerName":null,"kind":13},{"kind":12,"name":"SWITCH","line":561},{"localvar":"my","containerName":null,"kind":13,"name":"@positions","line":564,"definition":"my"},{"line":564,"kind":13,"containerName":null,"name":"@mine"},{"name":"@yours","kind":13,"containerName":null,"line":564},{"name":"$start_pos","kind":13,"localvar":"my","containerName":null,"line":565,"definition":"my"},{"name":"@positions","containerName":null,"kind":13,"line":565},{"name":"$dr_able","containerName":null,"localvar":"my","kind":13,"line":567,"definition":"my"},{"name":"$start_pos","containerName":null,"kind":13,"line":567},{"line":567,"containerName":"main::","kind":12,"name":"disconnected_ranges"},{"name":"@positions","containerName":null,"kind":13,"line":567},{"line":567,"containerName":null,"kind":13,"name":"$rel"},{"line":567,"name":"$overlap","containerName":null,"kind":13},{"name":"@disconnected_ranges","localvar":"my","containerName":null,"kind":13,"line":568,"definition":"my"},{"containerName":null,"kind":13,"name":"$dr_able","line":568},{"kind":12,"containerName":"main::","name":"get_positions","line":568},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%all_groups","line":575},{"name":"%done_ranges","containerName":null,"localvar":"my","kind":13,"line":576,"definition":"my"},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":null,"line":577},{"line":577,"name":"disconnected_ranges","kind":12},{"line":578,"name":"$range","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"@disconnected_ranges","line":578},{"line":578,"name":"$i","containerName":null,"kind":13},{"definition":"my","name":"$range_string","localvar":"my","kind":13,"containerName":null,"line":579},{"name":"$range","kind":13,"containerName":null,"line":579},{"kind":12,"containerName":"main::","name":"toString","line":579},{"containerName":null,"kind":13,"name":"%done_ranges","line":580},{"line":580,"containerName":null,"kind":13,"name":"$range_string"},{"containerName":null,"kind":13,"name":"%done_ranges","line":581},{"containerName":null,"kind":13,"name":"$range_string","line":581},{"line":583,"name":"$pos","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":583,"kind":13,"containerName":null,"name":"$start_pos"},{"line":583,"kind":13,"containerName":null,"name":"@positions"},{"line":584,"kind":13,"containerName":null,"name":"$pos"},{"line":584,"kind":12,"containerName":"main::","name":"overlaps"},{"line":584,"kind":13,"containerName":null,"name":"$range"},{"name":"%rel","kind":13,"containerName":null,"line":584},{"line":585,"name":"%all_groups","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%range_string","line":585},{"kind":13,"containerName":null,"name":"$pos","line":585},{"containerName":null,"kind":13,"name":"$pos","line":585},{"line":598,"containerName":null,"localvar":"my","kind":13,"name":"$pos","definition":"my"},{"line":598,"containerName":null,"kind":13,"name":"@disconnected_ranges"},{"line":599,"name":"$map","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$pos","containerName":null,"kind":13,"line":599},{"line":599,"kind":12,"containerName":"main::","name":"map"},{"line":600,"name":"$map","kind":13,"containerName":null},{"line":600,"kind":12,"containerName":"main::","name":"purge_positions"},{"kind":13,"containerName":null,"name":"$pos","line":600},{"line":603,"localvar":"my","containerName":null,"kind":13,"name":"@groups","definition":"my"},{"kind":12,"name":"GROUPS","line":604},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$group_range","line":604},{"containerName":null,"kind":13,"name":"%all_groups","line":604},{"definition":"my","line":605,"localvar":"my","containerName":null,"kind":13,"name":"$group"},{"line":605,"name":"%all_groups","containerName":null,"kind":13},{"name":"$group_range","kind":13,"containerName":null,"line":605},{"definition":"my","line":606,"name":"@group","kind":13,"localvar":"my","containerName":null},{"line":606,"kind":13,"containerName":null,"name":"$group"},{"containerName":null,"kind":13,"name":"@group","line":609},{"containerName":null,"kind":13,"name":"$min_pos_num","line":609},{"kind":13,"containerName":null,"name":"@group","line":610},{"name":"$min_pables_num","containerName":null,"kind":13,"line":610},{"line":611,"name":"@group","containerName":null,"kind":13},{"line":611,"containerName":null,"kind":13,"name":"$min_map_num"},{"name":"%mappables","localvar":"my","containerName":null,"kind":13,"line":613,"definition":"my"},{"line":614,"localvar":"my","containerName":null,"kind":13,"name":"$pos","definition":"my"},{"containerName":null,"kind":13,"name":"@group","line":614},{"line":615,"kind":13,"localvar":"my","containerName":null,"name":"$mappable","definition":"my"},{"line":615,"containerName":null,"kind":13,"name":"$pos"},{"name":"element","containerName":"main::","kind":12,"line":615},{"name":"%mappables","kind":13,"containerName":null,"line":616},{"line":616,"kind":13,"containerName":null,"name":"$mappable"},{"line":618,"name":"%mappables","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$min_pables_num","line":618},{"localvar":"my","containerName":null,"kind":13,"name":"%maps","line":620,"definition":"my"},{"line":621,"name":"$pos","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":621,"name":"@group","containerName":null,"kind":13},{"definition":"my","line":622,"name":"$map","kind":13,"localvar":"my","containerName":null},{"containerName":null,"kind":13,"name":"$pos","line":622},{"line":622,"containerName":"main::","kind":12,"name":"map"},{"containerName":null,"kind":13,"name":"%maps","line":623},{"line":623,"name":"$map","containerName":null,"kind":13},{"line":623,"name":"unique_id","kind":12,"containerName":"main::"},{"line":625,"name":"%maps","kind":13,"containerName":null},{"name":"$min_map_num","kind":13,"containerName":null,"line":625},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$required","line":627},{"name":"@required","kind":13,"containerName":null,"line":627},{"name":"%mappables","kind":13,"containerName":null,"line":628},{"line":628,"name":"$required","kind":13,"containerName":null},{"kind":12,"name":"GROUPS","line":628},{"definition":"my","line":631,"localvar":"my","kind":13,"containerName":null,"name":"@sorted"},{"name":"@a","kind":13,"containerName":null,"line":632},{"containerName":null,"kind":13,"name":"@b","line":632},{"line":633,"containerName":"main::","kind":12,"name":"sortable"},{"name":"@group","kind":13,"containerName":null,"line":634},{"line":635,"name":"@groups","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@sorted","line":635},{"name":"%method","kind":13,"containerName":null,"line":638},{"line":639,"containerName":null,"kind":13,"name":"@groups"},{"line":642,"name":"$group","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":642,"name":"@groups","kind":13,"containerName":null},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$start_pos","line":643},{"line":643,"name":"$group","containerName":null,"kind":13},{"line":645,"containerName":null,"kind":13,"name":"%group"},{"line":648,"name":"@ok","containerName":null,"kind":13},{"containerName":"Map::Position","kind":12,"name":"Bio","line":648},{"name":"new","containerName":"main::","kind":12,"line":648},{"name":"$start_pos","containerName":null,"kind":13,"line":648},{"name":"map","containerName":"main::","kind":12,"line":648},{"name":"$start_pos","kind":13,"containerName":null,"line":649},{"line":649,"name":"start","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$start_pos","line":650},{"name":"end","kind":12,"containerName":"main::","line":650},{"name":"@rel_arg","localvar":"my","containerName":null,"kind":13,"line":653,"definition":"my"},{"line":653,"name":"$method","kind":13,"containerName":null},{"line":653,"containerName":null,"kind":13,"name":"$rel"},{"name":"$rel","containerName":null,"kind":13,"line":653},{"line":654,"localvar":"my","containerName":null,"kind":13,"name":"$result","definition":"my"},{"containerName":null,"kind":13,"name":"$start_pos","line":654},{"containerName":null,"kind":13,"name":"$method","line":654},{"line":654,"containerName":null,"kind":13,"name":"$group"},{"name":"@rel_arg","containerName":null,"kind":13,"line":654},{"name":"@ok","kind":13,"containerName":null,"line":655},{"line":655,"kind":13,"containerName":null,"name":"$result"},{"line":655,"name":"get_positions","containerName":"main::","kind":12},{"definition":"my","line":660,"containerName":null,"localvar":"my","kind":13,"name":"$result"},{"kind":13,"containerName":null,"name":"$self","line":660},{"line":660,"name":"new","containerName":"main::","kind":12},{"name":"$result","kind":13,"containerName":null,"line":661},{"line":661,"name":"add_position","containerName":"main::","kind":12},{"line":661,"containerName":null,"kind":13,"name":"@ok"},{"line":661,"name":"@ok","containerName":null,"kind":13},{"name":"$result","kind":13,"containerName":null,"line":663},{"line":666,"kind":12,"name":"SWITCH"},{"containerName":null,"kind":13,"name":"$self","line":669},{"line":669,"name":"throw","kind":12,"containerName":"main::"},{"line":672,"kind":13,"containerName":null,"name":"@ok"},{"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"tuple","kind":13,"line":688,"definition":"my"},{"name":"$self","kind":13,"containerName":"tuple","line":689},{"line":689,"kind":12,"containerName":"tuple","name":"warn"}],"name":"tuple","containerName":"main::","line":687,"range":{"start":{"character":0,"line":687},"end":{"character":9999,"line":690}},"kind":12},{"range":{"end":{"line":709,"character":9999},"start":{"character":0,"line":705}},"kind":12,"line":705,"definition":"sub","containerName":"main::","name":"annotation","children":[{"definition":"my","line":706,"kind":13,"localvar":"my","containerName":"annotation","name":"$self"},{"name":"$self","containerName":"annotation","kind":13,"line":707},{"name":"$self","kind":13,"containerName":"annotation","line":708}]},{"kind":12,"name":"_annotation","line":707},{"line":708,"kind":12,"name":"_annotation"}],"version":5}