{"version":5,"vars":[{"line":85,"kind":2,"containerName":"","name":"vars"},{"line":89,"kind":2,"containerName":"","name":"base"},{"containerName":null,"kind":13,"name":"$MAPCOUNT","line":90},{"line":107,"kind":12,"range":{"end":{"line":117,"character":9999},"start":{"character":0,"line":107}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: CytoMap.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::CytoMap\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::CytoMap - A Bio::MapI compliant map implementation handling cytogenic bands \n\n=head1 SYNOPSIS\n\n    use Bio::Map::CytoMap;\n    my $map = Bio::Map::CytoMap->new(-name => 'human1',\n\t\t\t\t      -species => $human);\n    foreach my $marker ( @markers ) { # get a list of markers somewhere\n\t$map->add_element($marker);\n    }\n\n=head1 DESCRIPTION\n\nThis is the simple implementation of cytogenetic maps based on\nL<Bio::Map::MapI>.  It handles the essential storage of name, species,\ntype, and units as well as in memory representation of the elements of\na map.\n\nFor CytoMaps type is hard coded to be 'cytogeneticmap' and\nunits are set to '' but can be set to something else.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nJason Stajich      jason@bioperl.org\nLincoln Stein      lstein@cshl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Map::CytoMap;\nuse vars qw($MAPCOUNT);\nuse strict;\n\n\nuse base qw(Bio::Map::SimpleMap);\nBEGIN { $MAPCOUNT = 1; }\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Map::CytoMap->new();\n Function: Builds a new Bio::Map::CytoMap object\n Returns : Bio::Map::CytoMap\n Args    : -name    => name of map (string)\n           -species => species for this map (Bio::Species) [optional]\n           -elements=> elements to initialize with\n                       (arrayref of Bio::Map::MappableI objects) [optional]\n\n           -uid     => Unique Id"},"children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":108,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":108},{"definition":"my","line":110,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$class","line":110},{"line":110,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":112},{"line":112,"containerName":"new","kind":13,"name":"$MAPCOUNT"},{"name":"$uid","containerName":"new","localvar":"my","kind":13,"line":113,"definition":"my"},{"name":"$self","containerName":"new","kind":13,"line":113},{"line":113,"kind":12,"containerName":"new","name":"_rearrange"},{"line":113,"kind":13,"containerName":"new","name":"@args"},{"line":114,"name":"$uid","containerName":"new","kind":13},{"line":114,"name":"$self","containerName":"new","kind":13},{"line":114,"name":"unique_id","kind":12,"containerName":"new"},{"line":114,"containerName":"new","kind":13,"name":"$uid"},{"name":"$self","containerName":"new","kind":13,"line":116}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"name":"SUPER","containerName":"new","kind":12,"line":110},{"range":{"start":{"character":0,"line":129},"end":{"character":9999,"line":131}},"kind":12,"line":129,"name":"type","containerName":"main::","children":[],"definition":"sub"},{"range":{"end":{"character":9999,"line":145},"start":{"line":143,"character":0}},"kind":12,"line":143,"definition":"sub","containerName":"main::","name":"length","children":[]}]}