{"vars":[{"name":"base","kind":2,"containerName":"","line":80},{"line":82,"range":{"start":{"line":82,"character":0},"end":{"line":87,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"children":[{"definition":"my","line":83,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":83},{"definition":"my","line":84,"containerName":"new","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"new","name":"$class","line":84},{"containerName":"new","kind":13,"name":"@args","line":84},{"containerName":"new","kind":13,"name":"$self","line":86}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"name":"SUPER","kind":12,"containerName":"new","line":84},{"detail":"($self,$loc)","definition":"sub","name":"start","containerName":"main::","children":[{"definition":"my","line":102,"kind":13,"localvar":"my","containerName":"start","name":"$self"},{"name":"$loc","containerName":"start","kind":13,"line":102},{"definition":"my","line":106,"containerName":"start","localvar":"my","kind":13,"name":"$pos"},{"name":"$loc","kind":13,"containerName":"start","line":106},{"name":"max_start","kind":12,"containerName":"start","line":106},{"line":108,"name":"$pos","kind":13,"containerName":"start"},{"kind":13,"containerName":"start","name":"$loc","line":108},{"name":"min_start","kind":12,"containerName":"start","line":108},{"containerName":"start","kind":13,"name":"$pos","line":108},{"line":109,"containerName":"start","kind":13,"name":"$pos"}],"signature":{"documentation":"1;\n# $Id: NarrowestCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::NarrowestCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::NarrowestCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the narrowest possible and reasonable range\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that always the narrowest possible\nrange is returned, but by using some common sense. This means that e.g.\nlocations like \"E<gt>5..100\" (start before position 5) will return 5 as start\n(returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx.netE<gt>, E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::NarrowestCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Location::CoordinatePolicyI);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","parameters":[{"label":"$self"},{"label":"$loc"}],"label":"start($self,$loc)"},"kind":12,"range":{"start":{"character":0,"line":101},"end":{"character":9999,"line":110}},"line":101},{"children":[{"definition":"my","line":124,"name":"$self","localvar":"my","containerName":"end","kind":13},{"name":"$loc","containerName":"end","kind":13,"line":124},{"definition":"my","name":"$pos","kind":13,"localvar":"my","containerName":"end","line":128},{"line":128,"name":"$loc","kind":13,"containerName":"end"},{"line":128,"kind":12,"containerName":"end","name":"min_end"},{"line":130,"name":"$pos","containerName":"end","kind":13},{"name":"$loc","containerName":"end","kind":13,"line":130},{"name":"max_end","kind":12,"containerName":"end","line":130},{"line":130,"containerName":"end","kind":13,"name":"$pos"},{"kind":13,"containerName":"end","name":"$pos","line":131}],"name":"end","containerName":"main::","definition":"sub","detail":"($self,$loc)","line":123,"range":{"end":{"character":9999,"line":132},"start":{"character":0,"line":123}},"kind":12,"signature":{"label":"end($self,$loc)","parameters":[{"label":"$self"},{"label":"$loc"}],"documentation":"1;\n# $Id: NarrowestCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::NarrowestCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::NarrowestCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the narrowest possible and reasonable range\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that always the narrowest possible\nrange is returned, but by using some common sense. This means that e.g.\nlocations like \"E<gt>5..100\" (start before position 5) will return 5 as start\n(returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx.netE<gt>, E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::NarrowestCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Location::CoordinatePolicyI);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.\n\n\nsub start {\n    my ($self,$loc) = @_;\n\n    # For performance reasons we don't check that it's indeed a Bio::LocationI\n    # object. Hopefully, Location-object programmers are smart enough.\n    my $pos = $loc->max_start();\n    # if max is not defined or equals 0 we resort to min\n    $pos = $loc->min_start() if(! $pos);\n    return $pos;\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $policy->end($location);\n  Function: Get the integer-valued end coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object."}}],"version":5}