{"version":5,"vars":[{"line":86,"containerName":"","kind":2,"name":"base"},{"signature":{"label":"start($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: CoordinatePolicyI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::CoordinatePolicyI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::CoordinatePolicyI - Abstract interface for objects implementing\na certain policy of computing integer-valued coordinates of a Location\n\n=head1 SYNOPSIS\n\n    # get a location, e.g., from a SeqFeature\n    $location = $feature->location();\n    # examine its coordinate computation policy\n    print \"Location of feature \", $feature->primary_tag(), \" employs a \",\n          ref($location->coordinate_policy()), \n          \" instance for coordinate computation\\n\";\n    # change the policy, e.g. because the user chose to do so\n    $location->coordinate_policy(Bio::Location::NarrowestCoordPolicy->new());\n\n=head1 DESCRIPTION\n\nObjects implementing this interface are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it. While this may seem trivial for simple locations, there\nare different ways to do it for fuzzy or compound (split)\nlocations. Classes implementing this interface implement a certain\npolicy, like 'always widest range', 'always smallest range', 'mean for\nBETWEEN locations', etc. By installing a different policy object in a\nLocation object, the behaviour of coordinate computation can be changed\non-the-fly, and with a single line of code client-side.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail hlapp@gmx.net, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::CoordinatePolicyI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object."},"range":{"end":{"character":9999,"line":102},"start":{"line":99,"character":0}},"kind":12,"line":99,"detail":"($self)","definition":"sub","containerName":"main::","name":"start","children":[{"definition":"my","containerName":"start","localvar":"my","kind":13,"name":"$self","line":100},{"line":101,"containerName":"start","kind":13,"name":"$self"},{"line":101,"kind":12,"containerName":"start","name":"throw_not_implemented"}]},{"containerName":"main::","name":"end","children":[{"line":116,"localvar":"my","kind":13,"containerName":"end","name":"$self","definition":"my"},{"kind":13,"containerName":"end","name":"$self","line":117},{"line":117,"containerName":"end","kind":12,"name":"throw_not_implemented"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":115,"character":0},"end":{"character":9999,"line":118}},"line":115,"signature":{"label":"end($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: CoordinatePolicyI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::CoordinatePolicyI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::CoordinatePolicyI - Abstract interface for objects implementing\na certain policy of computing integer-valued coordinates of a Location\n\n=head1 SYNOPSIS\n\n    # get a location, e.g., from a SeqFeature\n    $location = $feature->location();\n    # examine its coordinate computation policy\n    print \"Location of feature \", $feature->primary_tag(), \" employs a \",\n          ref($location->coordinate_policy()), \n          \" instance for coordinate computation\\n\";\n    # change the policy, e.g. because the user chose to do so\n    $location->coordinate_policy(Bio::Location::NarrowestCoordPolicy->new());\n\n=head1 DESCRIPTION\n\nObjects implementing this interface are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it. While this may seem trivial for simple locations, there\nare different ways to do it for fuzzy or compound (split)\nlocations. Classes implementing this interface implement a certain\npolicy, like 'always widest range', 'always smallest range', 'mean for\nBETWEEN locations', etc. By installing a different policy object in a\nLocation object, the behaviour of coordinate computation can be changed\non-the-fly, and with a single line of code client-side.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail hlapp@gmx.net, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::CoordinatePolicyI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.\n\n\nsub start {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $policy->end($location);\n  Function: Get the integer-valued end coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object."}}]}