{"vars":[{"name":"base","containerName":"","kind":2,"line":82},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"line":84,"kind":12,"range":{"start":{"line":84,"character":0},"end":{"line":89,"character":9999}},"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":85,"name":"$class","containerName":"new","localvar":"my","kind":13},{"name":"@args","containerName":"new","kind":13,"line":85},{"definition":"my","line":86,"name":"$self","containerName":"new","localvar":"my","kind":13},{"line":86,"name":"$class","containerName":"new","kind":13},{"line":86,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","kind":13,"containerName":"new","line":88}],"containerName":"main::","name":"new"},{"line":86,"containerName":"new","kind":12,"name":"SUPER"},{"name":"start","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"start","name":"$self","line":105,"definition":"my"},{"line":105,"containerName":"start","kind":13,"name":"$loc"},{"line":107,"name":"$loc","kind":13,"containerName":"start"},{"name":"start_pos_type","containerName":"start","kind":12,"line":107},{"kind":13,"containerName":"start","name":"$loc","line":108},{"line":108,"name":"start_pos_type","kind":12,"containerName":"start"},{"definition":"my","line":109,"name":"$min","kind":13,"localvar":"my","containerName":"start"},{"line":109,"kind":13,"containerName":"start","name":"$max"},{"containerName":"start","kind":13,"name":"$loc","line":109},{"line":109,"containerName":"start","kind":12,"name":"min_start"},{"line":109,"containerName":"start","kind":13,"name":"$loc"},{"line":109,"kind":12,"containerName":"start","name":"max_start"},{"line":110,"name":"$min","kind":13,"containerName":"start"},{"name":"$max","kind":13,"containerName":"start","line":110},{"kind":13,"containerName":"start","name":"$min","line":110},{"line":110,"containerName":"start","kind":13,"name":"$max"},{"containerName":"start","kind":13,"name":"$self","line":112},{"line":112,"name":"$loc","containerName":"start","kind":13}],"detail":"($self,$loc)","definition":"sub","kind":12,"range":{"start":{"line":104,"character":0},"end":{"line":113,"character":9999}},"line":104,"signature":{"label":"start($self,$loc)","parameters":[{"label":"$self"},{"label":"$loc"}],"documentation":"1;\n# $Id: AvWithinCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::AvWithinCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::AvWithinCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the average for WITHIN and the widest possible and reasonable range otherwise\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that for fuzzy locations\nof type WITHIN and BETWEEN the average of the two limits will be\nreturned, and for all other locations it will return the widest\npossible range, but by using some common sense. This means that\ne.g. locations like \"E<lt>5..100\" (start before position 5) will return 5\nas start (returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx-dot-netE<gt>, E<lt>jason-at-bioperl-dot-orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::AvWithinCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Location::WidestCoordPolicy);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object."}},{"line":112,"containerName":"start","kind":12,"name":"SUPER"},{"signature":{"parameters":[{"label":"$self"},{"label":"$loc"}],"documentation":"1;\n# $Id: AvWithinCoordPolicy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::AvWithinCoordPolicy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#          and Jason Stajich <jason@bioperl.org>\n#\n# Copyright Hilmar Lapp, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::AvWithinCoordPolicy - class implementing \nBio::Location::CoordinatePolicy as the average for WITHIN and the widest possible and reasonable range otherwise\n\n=head1 SYNOPSIS\n\nSee Bio::Location::CoordinatePolicyI\n\n=head1 DESCRIPTION\n\nCoordinatePolicyI implementing objects are used by Bio::LocationI\nimplementing objects to determine integer-valued coordinates when\nasked for it.\n\nThis class will compute the coordinates such that for fuzzy locations\nof type WITHIN and BETWEEN the average of the two limits will be\nreturned, and for all other locations it will return the widest\npossible range, but by using some common sense. This means that\ne.g. locations like \"E<lt>5..100\" (start before position 5) will return 5\nas start (returned values have to be positive integers).\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp, Jason Stajich\n\nEmail E<lt>hlapp-at-gmx-dot-netE<gt>, E<lt>jason-at-bioperl-dot-orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::AvWithinCoordPolicy;\nuse strict;\n\n\nuse base qw(Bio::Location::WidestCoordPolicy);\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $policy->start($location);\n  Function: Get the integer-valued start coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.\n\n\nsub start {\n    my ($self,$loc) = @_;\n\n    if(($loc->start_pos_type() eq 'WITHIN') ||\n       ($loc->start_pos_type() eq 'BETWEEN')) {\n\tmy ($min, $max) = ($loc->min_start(), $loc->max_start());\n\treturn int(($min+$max)/2) if($min && $max);\n    }\n    return $self->SUPER::start($loc);\n}\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $policy->end($location);\n  Function: Get the integer-valued end coordinate of the given location as\n            computed by this computation policy.\n  Returns : A positive integer number.\n  Args    : A Bio::LocationI implementing object.","label":"end($self,$loc)"},"kind":12,"range":{"end":{"character":9999,"line":135},"start":{"line":126,"character":0}},"line":126,"detail":"($self,$loc)","definition":"sub","containerName":"main::","name":"end","children":[{"definition":"my","line":127,"name":"$self","localvar":"my","kind":13,"containerName":"end"},{"name":"$loc","containerName":"end","kind":13,"line":127},{"name":"$loc","containerName":"end","kind":13,"line":129},{"line":129,"name":"end_pos_type","kind":12,"containerName":"end"},{"line":130,"name":"$loc","kind":13,"containerName":"end"},{"line":130,"containerName":"end","kind":12,"name":"end_pos_type"},{"line":131,"localvar":"my","kind":13,"containerName":"end","name":"$min","definition":"my"},{"name":"$max","containerName":"end","kind":13,"line":131},{"kind":13,"containerName":"end","name":"$loc","line":131},{"line":131,"name":"min_end","containerName":"end","kind":12},{"containerName":"end","kind":13,"name":"$loc","line":131},{"kind":12,"containerName":"end","name":"max_end","line":131},{"line":132,"name":"$min","kind":13,"containerName":"end"},{"kind":13,"containerName":"end","name":"$max","line":132},{"line":132,"name":"$min","kind":13,"containerName":"end"},{"line":132,"name":"$max","containerName":"end","kind":13},{"line":134,"name":"$self","containerName":"end","kind":13},{"containerName":"end","kind":13,"name":"$loc","line":134}]},{"line":134,"kind":12,"containerName":"end","name":"SUPER"}],"version":5}