{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":48},{"range":{"start":{"character":0,"line":63},"end":{"line":92,"character":9999}},"kind":12,"line":63,"signature":{"label":"new($thing,%args)","documentation":"1;\n# $Id: Translation.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Translation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Translation - Translation class for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis stores informations about aminoacids translations of transcripts.\nThe implementation is that a Translation object is the translation of\na Transcript object, with different possibilities of manipulation,\ndifferent coordinate system and eventually its own ranges (protein domains).\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Translation;\n\nuse strict;\n#use Carp qw(croak carp cluck);\nuse Bio::LiveSeq::SeqI; # uses SeqI, inherits from it\nuse Bio::PrimarySeq;\nuse base qw(Bio::LiveSeq::Transcript);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $protein = Bio::LiveSeq::Translation->new(-transcript => $transcr);\n\n  Function: generates a new Bio::LiveSeq::Translation\n  Returns : reference to a new object of class Translation\n  Errorcode -1\n  Args    : reference to an object of class Transcript","parameters":[{"label":"$thing"},{"label":"%args"}]},"containerName":"main::","name":"new","children":[{"definition":"my","name":"$thing","containerName":"new","localvar":"my","kind":13,"line":64},{"containerName":"new","kind":13,"name":"%args","line":64},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$class","line":65},{"name":"$thing","containerName":"new","kind":13,"line":65},{"line":65,"name":"$thing","kind":13,"containerName":"new"},{"line":66,"name":"$obj","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"%translation","line":66},{"definition":"my","line":68,"localvar":"my","containerName":"new","kind":13,"name":"$transcript"},{"line":68,"kind":13,"containerName":"new","name":"$args"},{"line":70,"name":"$obj","containerName":"new","kind":13},{"line":70,"kind":13,"containerName":"new","name":"%translation"},{"name":"$obj","containerName":"new","kind":13,"line":71},{"line":71,"kind":13,"containerName":"new","name":"$obj"},{"line":71,"kind":13,"containerName":"new","name":"$class"},{"line":73,"name":"$transcript","kind":13,"containerName":"new"},{"line":74,"name":"$obj","containerName":"new","kind":13},{"name":"throw","containerName":"new","kind":12,"line":74},{"name":"$transcript","kind":13,"containerName":"new","line":76},{"kind":13,"containerName":"new","name":"$obj","line":77},{"line":77,"containerName":"new","kind":12,"name":"throw"},{"definition":"my","line":82,"name":"$strand","containerName":"new","localvar":"my","kind":13},{"kind":13,"containerName":"new","name":"$transcript","line":82},{"containerName":"new","kind":12,"name":"strand","line":82},{"name":"$seq","containerName":"new","localvar":"my","kind":13,"line":83,"definition":"my"},{"name":"$transcript","kind":13,"containerName":"new","line":83},{"line":85,"name":"$obj","containerName":"new","kind":13},{"line":85,"containerName":"new","kind":13,"name":"$strand"},{"containerName":"new","kind":13,"name":"$obj","line":86},{"line":86,"kind":13,"containerName":"new","name":"$seq"},{"line":87,"kind":13,"containerName":"new","name":"$obj"},{"containerName":"new","kind":13,"name":"$transcript","line":87},{"line":88,"name":"$obj","containerName":"new","kind":13},{"line":90,"containerName":"new","kind":13,"name":"$transcript"},{"kind":13,"containerName":"new","name":"$obj","line":90},{"name":"$obj","kind":13,"containerName":"new","line":91}],"detail":"($thing,%args)","definition":"sub"},{"line":105,"kind":12,"range":{"start":{"character":0,"line":105},"end":{"line":108,"character":9999}},"children":[{"definition":"my","line":106,"kind":13,"localvar":"my","containerName":"get_Transcript","name":"$self"},{"line":107,"name":"$self","kind":13,"containerName":"get_Transcript"}],"name":"get_Transcript","containerName":"main::","definition":"sub"},{"line":112,"kind":12,"range":{"start":{"line":112,"character":0},"end":{"character":9999,"line":116}},"signature":{"documentation":" These get redefined here, overriding the SeqI ones","parameters":[{"label":"$self"}],"label":"change($self)"},"children":[{"kind":13,"localvar":"my","containerName":"change","name":"$self","line":113,"definition":"my"},{"kind":13,"containerName":"change","name":"$self","line":114},{"line":114,"kind":12,"containerName":"change","name":"warn"}],"containerName":"main::","name":"change","definition":"sub","detail":"($self)"},{"detail":"($self)","definition":"sub","name":"positionchange","containerName":"main::","children":[{"definition":"my","line":118,"name":"$self","localvar":"my","containerName":"positionchange","kind":13},{"kind":13,"containerName":"positionchange","name":"$self","line":119},{"line":119,"kind":12,"containerName":"positionchange","name":"warn"}],"signature":{"label":"positionchange($self)","documentation":"","parameters":[{"label":"$self"}]},"range":{"end":{"line":121,"character":9999},"start":{"character":0,"line":117}},"kind":12,"line":117},{"kind":12,"range":{"start":{"character":0,"line":122},"end":{"line":126,"character":9999}},"line":122,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"labelchange($self)"},"containerName":"main::","name":"labelchange","children":[{"name":"$self","localvar":"my","containerName":"labelchange","kind":13,"line":123,"definition":"my"},{"name":"$self","containerName":"labelchange","kind":13,"line":124},{"kind":12,"containerName":"labelchange","name":"warn","line":124}],"detail":"($self)","definition":"sub"},{"kind":12,"range":{"start":{"line":130,"character":0},"end":{"line":136,"character":9999}},"line":130,"definition":"sub","name":"transl_seq","containerName":"main::","children":[{"definition":"my","line":131,"localvar":"my","containerName":"transl_seq","kind":13,"name":"$self"},{"definition":"my","line":132,"localvar":"my","kind":13,"containerName":"transl_seq","name":"$transcript"},{"containerName":"transl_seq","kind":13,"name":"$self","line":132},{"containerName":"transl_seq","kind":12,"name":"get_Transcript","line":132},{"kind":13,"localvar":"my","containerName":"transl_seq","name":"$translation","line":133,"definition":"my"},{"line":133,"name":"$transcript","kind":13,"containerName":"transl_seq"},{"line":133,"kind":12,"containerName":"transl_seq","name":"translate"},{"line":134,"containerName":"transl_seq","kind":13,"name":"$self"},{"containerName":"transl_seq","kind":12,"name":"translation_table","line":134},{"line":134,"name":"seq","kind":12,"containerName":"transl_seq"},{"line":135,"name":"$translation","kind":13,"containerName":"transl_seq"}]},{"line":139,"kind":12,"range":{"start":{"character":0,"line":139},"end":{"line":170,"character":9999}},"children":[{"line":140,"name":"$self","localvar":"my","kind":13,"containerName":"seq","definition":"my"},{"definition":"my","line":141,"name":"$proteinseq","containerName":"seq","localvar":"my","kind":13},{"line":142,"name":"$transcript","kind":13,"localvar":"my","containerName":"seq","definition":"my"},{"line":142,"name":"$self","kind":13,"containerName":"seq"},{"containerName":"seq","kind":12,"name":"get_Transcript","line":142},{"definition":"my","line":143,"localvar":"my","containerName":"seq","kind":13,"name":"$translation"},{"line":143,"containerName":"seq","kind":13,"name":"$transcript"},{"containerName":"seq","kind":12,"name":"translate","line":143},{"kind":13,"containerName":"seq","name":"$self","line":144},{"line":144,"containerName":"seq","kind":12,"name":"translation_table"},{"kind":12,"containerName":"seq","name":"seq","line":144},{"localvar":"my","containerName":"seq","kind":13,"name":"$stop_pos","line":145,"definition":"my"},{"line":145,"kind":13,"containerName":"seq","name":"$translation"},{"kind":13,"containerName":"seq","name":"$stop_pos","line":146},{"line":147,"name":"$downstreamseq","kind":13,"localvar":"my","containerName":"seq","definition":"my"},{"name":"$transcript","containerName":"seq","kind":13,"line":147},{"line":147,"containerName":"seq","kind":12,"name":"downstream_seq"},{"name":"$cdnaseq","containerName":"seq","localvar":"my","kind":13,"line":149,"definition":"my"},{"name":"$transcript","containerName":"seq","kind":13,"line":149},{"name":"seq","kind":12,"containerName":"seq","line":149},{"localvar":"my","containerName":"seq","kind":13,"name":"$extendedseq","line":150,"definition":"my"},{"line":150,"name":"new","containerName":"seq","kind":12},{"line":154,"kind":13,"containerName":"seq","name":"$translation"},{"line":154,"name":"$extendedseq","kind":13,"containerName":"seq"},{"containerName":"seq","kind":12,"name":"translate","line":154},{"name":"$self","kind":13,"containerName":"seq","line":155},{"containerName":"seq","kind":12,"name":"translation_table","line":155},{"name":"seq","kind":12,"containerName":"seq","line":155},{"line":157,"name":"$stop_pos","containerName":"seq","kind":13},{"containerName":"seq","kind":13,"name":"$translation","line":157},{"line":158,"name":"$stop_pos","containerName":"seq","kind":13},{"line":159,"name":"$self","kind":13,"containerName":"seq"},{"name":"warn","kind":12,"containerName":"seq","line":159},{"name":"$stop_pos","containerName":"seq","kind":13,"line":160},{"line":161,"name":"$proteinseq","containerName":"seq","kind":13},{"name":"$translation","kind":13,"containerName":"seq","line":161},{"name":"$proteinseq","kind":13,"containerName":"seq","line":163},{"line":163,"name":"$translation","containerName":"seq","kind":13},{"line":163,"name":"$stop_pos","containerName":"seq","kind":13},{"line":167,"name":"$proteinseq","containerName":"seq","kind":13},{"line":167,"containerName":"seq","kind":13,"name":"$translation"},{"line":167,"containerName":"seq","kind":13,"name":"$stop_pos"},{"containerName":"seq","kind":13,"name":"$proteinseq","line":169}],"name":"seq","containerName":"main::","definition":"sub"},{"kind":12,"containerName":"PrimarySeq","name":"Bio","line":150},{"containerName":"main::","name":"length","children":[{"definition":"my","line":173,"containerName":"length","localvar":"my","kind":13,"name":"$self"},{"line":174,"name":"$seq","localvar":"my","containerName":"length","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"length","line":174},{"containerName":"length","kind":12,"name":"seq","line":174},{"name":"$length","kind":13,"localvar":"my","containerName":"length","line":175,"definition":"my"},{"name":"$seq","containerName":"length","kind":13,"line":175},{"name":"$length","containerName":"length","kind":13,"line":176}],"definition":"sub","range":{"end":{"character":9999,"line":177},"start":{"line":172,"character":0}},"kind":12,"line":172},{"kind":12,"range":{"start":{"character":0,"line":179},"end":{"character":9999,"line":182}},"line":179,"definition":"sub","containerName":"main::","name":"all_labels","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"all_labels","kind":13,"line":180},{"name":"$self","containerName":"all_labels","kind":13,"line":181},{"containerName":"all_labels","kind":12,"name":"get_Transcript","line":181},{"kind":12,"containerName":"all_labels","name":"all_labels","line":181}]},{"detail":"($self,$label)","definition":"sub","name":"valid","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"valid","name":"$self","line":188},{"kind":13,"containerName":"valid","name":"$label","line":188},{"definition":"my","containerName":"valid","localvar":"my","kind":13,"name":"$i","line":189},{"localvar":"my","containerName":"valid","kind":13,"name":"@labels","line":190,"definition":"my"},{"name":"$self","kind":13,"containerName":"valid","line":190},{"line":190,"containerName":"valid","kind":12,"name":"get_Transcript"},{"line":190,"name":"all_labels","kind":12,"containerName":"valid"},{"line":191,"kind":13,"localvar":"my","containerName":"valid","name":"$length","definition":"my"},{"kind":13,"containerName":"valid","name":"$i","line":192},{"name":"$length","kind":13,"containerName":"valid","line":192},{"containerName":"valid","kind":13,"name":"$label","line":193},{"containerName":"valid","kind":13,"name":"$labels","line":193},{"containerName":"valid","kind":13,"name":"$i","line":193},{"containerName":"valid","kind":13,"name":"$i","line":196},{"kind":13,"containerName":"valid","name":"$i","line":196}],"signature":{"label":"valid($self,$label)","parameters":[{"label":"$self"},{"label":"$label"}],"documentation":" counts in triplet. Only a label matching the beginning of a triplet coding\n for an aminoacid is considered valid when setting coordinate_start\n (i.e. only in frame!)"},"range":{"end":{"line":199,"character":9999},"start":{"character":0,"line":187}},"kind":12,"line":187},{"line":191,"name":"labels","kind":12},{"children":[{"line":203,"localvar":"my","containerName":"label","kind":13,"name":"$self","definition":"my"},{"line":203,"containerName":"label","kind":13,"name":"$position"},{"line":204,"name":"$firstlabel","localvar":"my","containerName":"label","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"label","line":204},{"kind":12,"containerName":"label","name":"coordinate_start","line":204},{"name":"$position","containerName":"label","kind":13,"line":205},{"name":"$position","kind":13,"containerName":"label","line":206},{"line":206,"name":"$position","kind":13,"containerName":"label"},{"line":208,"containerName":"label","kind":13,"name":"$position"},{"name":"$position","kind":13,"containerName":"label","line":208},{"kind":13,"containerName":"label","name":"$self","line":210},{"kind":12,"containerName":"label","name":"get_Transcript","line":210},{"line":210,"name":"label","kind":12,"containerName":"label"},{"line":210,"kind":13,"containerName":"label","name":"$position"},{"line":210,"name":"$firstlabel","containerName":"label","kind":13}],"name":"label","containerName":"main::","definition":"sub","detail":"($self,$position)","line":202,"kind":12,"range":{"start":{"character":0,"line":202},"end":{"character":9999,"line":212}},"signature":{"label":"label($self,$position)","parameters":[{"label":"$self"},{"label":"$position"}],"documentation":" returns the label to the first nucleotide of the triplet coding for $position aminoacid"}},{"children":[{"line":218,"name":"$self","kind":13,"localvar":"my","containerName":"position","definition":"my"},{"line":218,"name":"$label","kind":13,"containerName":"position"},{"definition":"my","name":"$firstlabel","localvar":"my","containerName":"position","kind":13,"line":219},{"line":219,"containerName":"position","kind":13,"name":"$self"},{"line":219,"kind":12,"containerName":"position","name":"coordinate_start"},{"definition":"my","localvar":"my","containerName":"position","kind":13,"name":"$position","line":220},{"kind":13,"containerName":"position","name":"$self","line":220},{"line":220,"containerName":"position","kind":12,"name":"get_Transcript"},{"kind":12,"containerName":"position","name":"position","line":220},{"name":"$label","kind":13,"containerName":"position","line":220},{"line":220,"containerName":"position","kind":13,"name":"$firstlabel"},{"localvar":"my","containerName":"position","kind":13,"name":"$modulus","line":222,"definition":"my"},{"line":222,"name":"$position","kind":13,"containerName":"position"},{"line":223,"kind":13,"containerName":"position","name":"$position"},{"name":"$position","kind":13,"containerName":"position","line":225},{"containerName":"position","kind":13,"name":"$modulus","line":226},{"kind":13,"containerName":"position","name":"$self","line":227},{"name":"warn","containerName":"position","kind":12,"line":227},{"name":"$self","kind":13,"containerName":"position","line":228},{"containerName":"position","kind":12,"name":"verbose","line":228},{"kind":13,"containerName":"position","name":"$modulus","line":229},{"containerName":"position","kind":13,"name":"$position","line":230},{"line":232,"kind":13,"containerName":"position","name":"$position"},{"name":"$position","containerName":"position","kind":13,"line":235},{"line":237,"containerName":"position","kind":13,"name":"$modulus"},{"line":238,"containerName":"position","kind":13,"name":"$self"},{"kind":12,"containerName":"position","name":"warn","line":238},{"line":239,"kind":13,"containerName":"position","name":"$self"},{"containerName":"position","kind":12,"name":"verbose","line":239},{"line":240,"containerName":"position","kind":13,"name":"$position"},{"kind":13,"containerName":"position","name":"$position","line":242},{"line":244,"containerName":"position","kind":13,"name":"$self"},{"line":244,"containerName":"position","kind":12,"name":"throw"}],"containerName":"main::","name":"position","definition":"sub","detail":"($self,$label)","line":217,"kind":12,"range":{"start":{"line":217,"character":0},"end":{"line":246,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$label"}],"documentation":" returns position (aminoacids numbering) of a particular label\n used to return 0 for not in frame labels\n now returns the position anyway (after version 1.66)","label":"position($self,$label)"}},{"line":222,"name":"integer","kind":2,"containerName":""},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"start","kind":13,"line":251},{"containerName":"start","kind":13,"name":"$self","line":252},{"name":"start","containerName":"start","kind":12,"line":252}],"containerName":"main::","name":"start","definition":"sub","line":250,"range":{"start":{"character":0,"line":250},"end":{"character":9999,"line":253}},"kind":12},{"line":255,"range":{"end":{"character":9999,"line":258},"start":{"line":255,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"end","localvar":"my","kind":13,"line":256},{"name":"$self","containerName":"end","kind":13,"line":257},{"containerName":"end","kind":12,"name":"end","line":257}],"containerName":"main::","name":"end","definition":"sub"},{"containerName":"main::","name":"aa_ranges","children":[{"definition":"my","line":274,"containerName":"aa_ranges","localvar":"my","kind":13,"name":"$self"},{"line":275,"kind":13,"containerName":"aa_ranges","name":"$self"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":273},"end":{"line":276,"character":9999}},"line":273},{"definition":"sub","name":"translation_table","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"translation_table","kind":13,"name":"$self","line":279},{"line":280,"name":"$self","containerName":"translation_table","kind":13},{"containerName":"translation_table","kind":12,"name":"get_Transcript","line":280},{"name":"translation_table","kind":12,"containerName":"translation_table","line":280}],"range":{"start":{"character":0,"line":278},"end":{"character":9999,"line":281}},"kind":12,"line":278},{"signature":{"label":"labelsubseq($self,$start,$length,$end)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$length"},{"label":"$end"}],"documentation":" returns all aminoacids \"affected\" i.e. all aminoacids coded by any codon\n \"touched\" by the range selected between the labels, even if only partially.\n it's not optimized for performance but it's useful"},"range":{"start":{"character":0,"line":288},"end":{"character":9999,"line":314}},"kind":12,"line":288,"detail":"($self,$start,$length,$end)","definition":"sub","containerName":"main::","name":"labelsubseq","children":[{"localvar":"my","containerName":"labelsubseq","kind":13,"name":"$self","line":289,"definition":"my"},{"containerName":"labelsubseq","kind":13,"name":"$start","line":289},{"kind":13,"containerName":"labelsubseq","name":"$length","line":289},{"kind":13,"containerName":"labelsubseq","name":"$end","line":289},{"definition":"my","line":290,"containerName":"labelsubseq","localvar":"my","kind":13,"name":"$pos1"},{"kind":13,"containerName":"labelsubseq","name":"$pos2","line":290},{"definition":"my","line":291,"name":"$transcript","localvar":"my","containerName":"labelsubseq","kind":13},{"line":291,"containerName":"labelsubseq","kind":13,"name":"$self"},{"line":291,"name":"get_Transcript","kind":12,"containerName":"labelsubseq"},{"line":292,"kind":13,"containerName":"labelsubseq","name":"$start"},{"kind":13,"containerName":"labelsubseq","name":"$transcript","line":293},{"containerName":"labelsubseq","kind":12,"name":"valid","line":293},{"name":"$start","kind":13,"containerName":"labelsubseq","line":293},{"name":"$self","containerName":"labelsubseq","kind":13,"line":294},{"line":294,"kind":12,"containerName":"labelsubseq","name":"warn"},{"line":296,"kind":13,"containerName":"labelsubseq","name":"$pos1"},{"containerName":"labelsubseq","kind":13,"name":"$self","line":296},{"name":"position","containerName":"labelsubseq","kind":12,"line":296},{"containerName":"labelsubseq","kind":13,"name":"$start","line":296},{"line":298,"containerName":"labelsubseq","kind":13,"name":"$end"},{"line":299,"kind":13,"containerName":"labelsubseq","name":"$end"},{"containerName":"labelsubseq","kind":13,"name":"$start","line":299},{"line":300,"containerName":"labelsubseq","kind":13,"name":"$length"},{"line":302,"containerName":"labelsubseq","kind":13,"name":"$transcript"},{"kind":12,"containerName":"labelsubseq","name":"valid","line":302},{"name":"$end","kind":13,"containerName":"labelsubseq","line":302},{"line":303,"kind":13,"containerName":"labelsubseq","name":"$self"},{"line":303,"name":"warn","containerName":"labelsubseq","kind":12},{"line":305,"kind":13,"containerName":"labelsubseq","name":"$transcript"},{"kind":12,"containerName":"labelsubseq","name":"follows","line":305},{"line":305,"name":"$start","containerName":"labelsubseq","kind":13},{"line":305,"name":"$end","containerName":"labelsubseq","kind":13},{"kind":13,"containerName":"labelsubseq","name":"$self","line":306},{"containerName":"labelsubseq","kind":12,"name":"warn","line":306},{"containerName":"labelsubseq","kind":13,"name":"$pos2","line":308},{"line":308,"name":"$self","containerName":"labelsubseq","kind":13},{"line":308,"name":"position","containerName":"labelsubseq","kind":12},{"line":308,"name":"$end","kind":13,"containerName":"labelsubseq"},{"line":309,"name":"$length","kind":13,"containerName":"labelsubseq"},{"line":309,"containerName":"labelsubseq","kind":13,"name":"$pos2"},{"name":"$pos1","kind":13,"containerName":"labelsubseq","line":309},{"definition":"my","line":312,"name":"$sequence","localvar":"my","containerName":"labelsubseq","kind":13},{"kind":13,"containerName":"labelsubseq","name":"$self","line":312},{"kind":12,"containerName":"labelsubseq","name":"seq","line":312},{"containerName":"labelsubseq","kind":13,"name":"$sequence","line":313},{"kind":13,"containerName":"labelsubseq","name":"$pos1","line":313},{"line":313,"kind":13,"containerName":"labelsubseq","name":"$length"}]},{"line":318,"kind":12,"range":{"start":{"line":318,"character":0},"end":{"character":9999,"line":321}},"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"offset","localvar":"my","kind":13,"line":319},{"line":320,"name":"$self","kind":13,"containerName":"offset"}],"containerName":"main::","name":"offset"}]}