{"vars":[{"containerName":"","kind":2,"name":"base","line":43},{"signature":{"documentation":"1;\n# $Id: DNA.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::DNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::DNA - DNA object for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis holds the DNA sequence (or the RNA in the case of cDNA entries)\nand is accessed by exons, genes, transcripts... objects\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::DNA;\n\nuse strict;\nuse base qw(Bio::LiveSeq::SeqI);\n\n=head2 new\n\n  Title   : new\n  Usage   : $dna = Bio::LiveSeq::DNA->new(-seq => \"atcgaccaatggacctca\",\n\t\t\t\t\t  -offset => 3 );\n\n  Function: generates a new Bio::LiveSeq::DNA\n  Returns : reference to a new object of class DNA\n  Errorcode -1\n  Args    : a string\n        AND an optional offset to create nucleotide labels (default is 1, i.e.\n            starting the count of labels from \"1\") -> do not bother using it ->\n            it could be used by alternative loaders !EMBL format\n  NOTE    : strand of DNA is set to 1 by default","parameters":[{"label":"$thing"},{"label":"%args"}],"label":"new($thing,%args)"},"line":62,"range":{"start":{"character":0,"line":62},"end":{"character":9999,"line":81}},"kind":12,"definition":"sub","detail":"($thing,%args)","children":[{"definition":"my","line":63,"name":"$thing","containerName":"new","localvar":"my","kind":13},{"line":63,"name":"%args","kind":13,"containerName":"new"},{"line":64,"name":"$class","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"name":"$thing","containerName":"new","kind":13,"line":64},{"line":64,"name":"$thing","kind":13,"containerName":"new"},{"line":65,"name":"%empty","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"$obj","line":65},{"containerName":"new","kind":13,"name":"$args","line":67},{"line":68,"name":"$obj","containerName":"new","kind":13},{"name":"$thing","containerName":"new","kind":13,"line":68},{"kind":12,"containerName":"new","name":"string2chain","line":68},{"line":68,"containerName":"new","kind":13,"name":"$args"},{"kind":13,"containerName":"new","name":"$args","line":68},{"line":69,"name":"$obj","kind":13,"containerName":"new"},{"name":"$obj","kind":13,"containerName":"new","line":69},{"containerName":"new","kind":13,"name":"$class","line":69},{"line":71,"containerName":"new","kind":13,"name":"$obj"},{"name":"%empty","containerName":"new","kind":13,"line":71},{"line":72,"name":"$obj","kind":13,"containerName":"new"},{"name":"$obj","kind":13,"containerName":"new","line":72},{"kind":13,"containerName":"new","name":"$class","line":72},{"kind":13,"containerName":"new","name":"$obj","line":73},{"line":73,"name":"throw","containerName":"new","kind":12},{"name":"$obj","containerName":"new","kind":13,"line":76},{"name":"$obj","containerName":"new","kind":13,"line":77},{"line":78,"kind":13,"containerName":"new","name":"$obj"},{"line":78,"containerName":"new","kind":13,"name":"$obj"},{"name":"$obj","containerName":"new","kind":13,"line":80}],"name":"new","containerName":"main::"},{"definition":"sub","name":"start","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"start","localvar":"my","kind":13,"line":86},{"kind":13,"containerName":"start","name":"$self","line":87}],"range":{"end":{"line":88,"character":9999},"start":{"character":0,"line":85}},"kind":12,"line":85},{"name":"length","containerName":"main::","children":[{"definition":"my","line":92,"name":"$self","containerName":"length","localvar":"my","kind":13},{"kind":13,"containerName":"length","name":"$self","line":93},{"line":93,"kind":12,"containerName":"length","name":"chain_length"}],"definition":"sub","range":{"start":{"line":91,"character":0},"end":{"character":9999,"line":94}},"kind":12,"line":91},{"definition":"sub","name":"valid","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"valid","name":"$self","line":98},{"line":99,"name":"$self","containerName":"valid","kind":13},{"line":99,"name":"label_exists","containerName":"valid","kind":12}],"kind":12,"range":{"end":{"line":100,"character":9999},"start":{"line":97,"character":0}},"line":97}],"version":5}