{"vars":[{"name":"base","containerName":"","kind":2,"line":89},{"line":91,"kind":12,"range":{"end":{"character":9999,"line":97},"start":{"character":0,"line":91}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$class","line":92},{"line":92,"kind":13,"containerName":"new","name":"@args"},{"line":93,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":93},{"line":93,"name":"@args","containerName":"new","kind":13},{"line":95,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":96}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"line":93,"name":"SUPER","containerName":"new","kind":12},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_file_format","line":113},{"kind":13,"containerName":"_file_format","name":"@args","line":113},{"line":115,"name":"$pkg","localvar":"my","containerName":"_file_format","kind":13,"definition":"my"},{"kind":13,"containerName":"_file_format","name":"$self","line":115},{"line":116,"name":"$self","containerName":"_file_format","kind":13},{"name":"throw","containerName":"_file_format","kind":12,"line":116}],"containerName":"main::","name":"_file_format","definition":"sub","detail":"($self,@args)","line":112,"kind":12,"range":{"start":{"character":0,"line":112},"end":{"line":117,"character":9999}},"signature":{"label":"_file_format($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID","label":"fetch($self,$id)"},"line":130,"range":{"start":{"line":130,"character":0},"end":{"line":156,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$id)","children":[{"definition":"my","line":131,"localvar":"my","containerName":"fetch","kind":13,"name":"$self"},{"name":"$id","containerName":"fetch","kind":13,"line":131},{"definition":"my","line":132,"kind":13,"localvar":"my","containerName":"fetch","name":"$db"},{"containerName":"fetch","kind":13,"name":"$self","line":132},{"name":"db","kind":12,"containerName":"fetch","line":132},{"name":"$seq","kind":13,"localvar":"my","containerName":"fetch","line":133,"definition":"my"},{"definition":"my","line":135,"name":"$rec","localvar":"my","kind":13,"containerName":"fetch"},{"name":"$db","kind":13,"containerName":"fetch","line":135},{"name":"$id","containerName":"fetch","kind":13,"line":135},{"definition":"my","line":136,"containerName":"fetch","localvar":"my","kind":13,"name":"$file"},{"line":136,"name":"$begin","containerName":"fetch","kind":13},{"line":136,"containerName":"fetch","kind":13,"name":"$self"},{"line":136,"name":"unpack_record","containerName":"fetch","kind":12},{"name":"$rec","containerName":"fetch","kind":13,"line":136},{"definition":"my","line":139,"name":"$seqio","kind":13,"localvar":"my","containerName":"fetch"},{"kind":13,"containerName":"fetch","name":"$self","line":139},{"line":139,"name":"_get_SeqIO_object","kind":12,"containerName":"fetch"},{"name":"$file","containerName":"fetch","kind":13,"line":139},{"definition":"my","name":"$fh","containerName":"fetch","localvar":"my","kind":13,"line":140},{"name":"$seqio","containerName":"fetch","kind":13,"line":140},{"line":140,"kind":12,"containerName":"fetch","name":"_fh"},{"line":144,"kind":13,"containerName":"fetch","name":"$fh"},{"line":144,"kind":13,"containerName":"fetch","name":"$begin"},{"kind":13,"containerName":"fetch","name":"$seq","line":146},{"name":"$seqio","containerName":"fetch","kind":13,"line":146},{"kind":12,"containerName":"fetch","name":"next_seq","line":146},{"kind":13,"containerName":"fetch","name":"$seq","line":151},{"line":151,"containerName":"fetch","kind":13,"name":"$seq"},{"name":"isa","containerName":"fetch","kind":12,"line":151},{"line":152,"kind":13,"containerName":"fetch","name":"$seq"},{"name":"primary_id","containerName":"fetch","kind":12,"line":152},{"containerName":"fetch","kind":13,"name":"$seq","line":153},{"line":153,"name":"primary_id","kind":12,"containerName":"fetch"},{"name":"$seq","containerName":"fetch","kind":13,"line":153},{"kind":12,"containerName":"fetch","name":"display_id","line":153},{"line":155,"containerName":"fetch","kind":13,"name":"$seq"}],"name":"fetch","containerName":"main::"},{"signature":{"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)","parameters":[{"label":"$self"},{"label":"$i"}],"label":"_get_SeqIO_object($self,$i)"},"line":169,"kind":12,"range":{"end":{"line":180,"character":9999},"start":{"character":0,"line":169}},"definition":"sub","detail":"($self,$i)","children":[{"line":170,"name":"$self","localvar":"my","kind":13,"containerName":"_get_SeqIO_object","definition":"my"},{"name":"$i","kind":13,"containerName":"_get_SeqIO_object","line":170},{"line":172,"name":"$self","kind":13,"containerName":"_get_SeqIO_object"},{"kind":13,"containerName":"_get_SeqIO_object","name":"$i","line":172},{"definition":"my","line":173,"name":"$fh","localvar":"my","kind":13,"containerName":"_get_SeqIO_object"},{"name":"$self","kind":13,"containerName":"_get_SeqIO_object","line":173},{"line":173,"kind":12,"containerName":"_get_SeqIO_object","name":"_file_handle"},{"line":173,"containerName":"_get_SeqIO_object","kind":13,"name":"$i"},{"name":"$seqio","localvar":"my","containerName":"_get_SeqIO_object","kind":13,"line":175,"definition":"my"},{"name":"new","kind":12,"containerName":"_get_SeqIO_object","line":175},{"name":"$self","kind":13,"containerName":"_get_SeqIO_object","line":175},{"name":"_file_format","kind":12,"containerName":"_get_SeqIO_object","line":175},{"line":176,"name":"$fh","kind":13,"containerName":"_get_SeqIO_object"},{"containerName":"_get_SeqIO_object","kind":13,"name":"$self","line":177},{"name":"$i","kind":13,"containerName":"_get_SeqIO_object","line":177},{"line":177,"kind":13,"containerName":"_get_SeqIO_object","name":"$seqio"},{"containerName":"_get_SeqIO_object","kind":13,"name":"$self","line":179},{"line":179,"name":"$i","kind":13,"containerName":"_get_SeqIO_object"}],"name":"_get_SeqIO_object","containerName":"main::"},{"kind":12,"containerName":"SeqIO","name":"Bio","line":175},{"signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id","label":"get_Seq_by_id($self,$id)"},"line":194,"range":{"end":{"character":9999,"line":198},"start":{"line":194,"character":0}},"kind":12,"definition":"sub","detail":"($self,$id)","children":[{"line":195,"name":"$self","localvar":"my","kind":13,"containerName":"get_Seq_by_id","definition":"my"},{"kind":13,"containerName":"get_Seq_by_id","name":"$id","line":195},{"line":197,"containerName":"get_Seq_by_id","kind":13,"name":"$self"},{"line":197,"name":"fetch","kind":12,"containerName":"get_Seq_by_id"},{"line":197,"kind":13,"containerName":"get_Seq_by_id","name":"$id"}],"name":"get_Seq_by_id","containerName":"main::"},{"range":{"end":{"character":9999,"line":216},"start":{"character":0,"line":212}},"kind":12,"line":212,"signature":{"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id\n\n\n\nsub get_Seq_by_id {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_Seq_by_acc\n\n Title   : get_Seq_by_acc\n Usage   : $seq = $db->get_Seq_by_acc()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the accession number","parameters":[{"label":"$self"},{"label":"$id"}],"label":"get_Seq_by_acc($self,$id)"},"containerName":"main::","name":"get_Seq_by_acc","children":[{"line":213,"localvar":"my","kind":13,"containerName":"get_Seq_by_acc","name":"$self","definition":"my"},{"line":213,"name":"$id","containerName":"get_Seq_by_acc","kind":13},{"line":215,"containerName":"get_Seq_by_acc","kind":13,"name":"$self"},{"line":215,"name":"fetch","kind":12,"containerName":"get_Seq_by_acc"},{"line":215,"name":"$id","kind":13,"containerName":"get_Seq_by_acc"}],"detail":"($self,$id)","definition":"sub"},{"definition":"sub","name":"get_PrimarySeq_stream","containerName":"main::","children":[{"line":231,"name":"$self","containerName":"get_PrimarySeq_stream","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$num","containerName":"get_PrimarySeq_stream","localvar":"my","kind":13,"line":232},{"line":232,"name":"$self","containerName":"get_PrimarySeq_stream","kind":13},{"line":232,"kind":12,"containerName":"get_PrimarySeq_stream","name":"_file_count"},{"name":"@file","localvar":"my","containerName":"get_PrimarySeq_stream","kind":13,"line":233,"definition":"my"},{"line":235,"localvar":"my","kind":13,"containerName":"get_PrimarySeq_stream","name":"$i","definition":"my"},{"line":235,"name":"$i","kind":13,"containerName":"get_PrimarySeq_stream"},{"name":"$num","containerName":"get_PrimarySeq_stream","kind":13,"line":235},{"line":235,"containerName":"get_PrimarySeq_stream","kind":13,"name":"$i"},{"definition":"my","line":236,"name":"$file","localvar":"my","containerName":"get_PrimarySeq_stream","kind":13},{"kind":13,"containerName":"get_PrimarySeq_stream","name":"$stored_size","line":236},{"line":236,"name":"$self","containerName":"get_PrimarySeq_stream","kind":13},{"name":"unpack_record","containerName":"get_PrimarySeq_stream","kind":12,"line":236},{"kind":13,"containerName":"get_PrimarySeq_stream","name":"$self","line":236},{"name":"db","containerName":"get_PrimarySeq_stream","kind":12,"line":236},{"name":"@file","kind":13,"containerName":"get_PrimarySeq_stream","line":237},{"kind":13,"containerName":"get_PrimarySeq_stream","name":"$file","line":237},{"definition":"my","name":"$out","localvar":"my","kind":13,"containerName":"get_PrimarySeq_stream","line":240},{"line":240,"name":"new","kind":12,"containerName":"get_PrimarySeq_stream"},{"name":"$self","kind":13,"containerName":"get_PrimarySeq_stream","line":240},{"line":240,"kind":12,"containerName":"get_PrimarySeq_stream","name":"_file_format"},{"line":240,"name":"@file","kind":13,"containerName":"get_PrimarySeq_stream"},{"line":241,"kind":13,"containerName":"get_PrimarySeq_stream","name":"$out"}],"range":{"end":{"character":9999,"line":242},"start":{"character":0,"line":230}},"kind":12,"line":230},{"kind":12,"containerName":"SeqIO::MultiFile","name":"Bio","line":240},{"signature":{"label":"get_all_primary_ids($self,@args)","documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id\n\n\n\nsub get_Seq_by_id {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_Seq_by_acc\n\n Title   : get_Seq_by_acc\n Usage   : $seq = $db->get_Seq_by_acc()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the accession number\n\n\n\nsub get_Seq_by_acc {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_PrimarySeq_stream\n\n Title   : get_PrimarySeq_stream\n Usage   : $stream = get_PrimarySeq_stream\n Function: Makes a Bio::DB::SeqStreamI compliant object\n           which provides a single method, next_primary_seq\n Returns : Bio::DB::SeqStreamI\n Args    : none\n\n\n\nsub get_PrimarySeq_stream {\n    my $self = shift;\n    my $num  = $self->_file_count() || 0;\n    my @file;\n    \n    for (my $i = 0; $i < $num; $i++) {\n        my( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\tpush(@file,$file);\n    }\n   \n    my $out = Bio::SeqIO::MultiFile->new( '-format' => $self->_file_format , -files => \\@file);\n    return $out;\n}\n\n=head2 get_all_primary_ids\n\n Title   : get_all_primary_ids\n Usage   : @ids = $seqdb->get_all_primary_ids()\n Function: gives an array of all the primary_ids of the \n           sequence objects in the database. These\n           maybe ids (display style) or accession numbers\n           or something else completely different - they\n           *are not* meaningful outside of this database\n           implementation.\n Example :\n Returns : an array of strings\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"line":261,"kind":12,"range":{"start":{"line":261,"character":0},"end":{"character":9999,"line":288}},"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","containerName":"get_all_primary_ids","localvar":"my","kind":13,"line":262},{"line":262,"containerName":"get_all_primary_ids","kind":13,"name":"@args"},{"line":263,"name":"$db","localvar":"my","containerName":"get_all_primary_ids","kind":13,"definition":"my"},{"line":263,"name":"$self","containerName":"get_all_primary_ids","kind":13},{"containerName":"get_all_primary_ids","kind":12,"name":"db","line":263},{"name":"%bytepos","localvar":"my","containerName":"get_all_primary_ids","kind":13,"line":276,"definition":"my"},{"name":"$id","localvar":"my","kind":13,"containerName":"get_all_primary_ids","line":277,"definition":"my"},{"line":277,"name":"$rec","kind":13,"containerName":"get_all_primary_ids"},{"name":"$db","containerName":"get_all_primary_ids","kind":13,"line":277},{"line":278,"name":"$id","kind":13,"containerName":"get_all_primary_ids"},{"containerName":"get_all_primary_ids","localvar":"my","kind":13,"name":"$file","line":282,"definition":"my"},{"containerName":"get_all_primary_ids","kind":13,"name":"$begin","line":282},{"line":282,"name":"$self","kind":13,"containerName":"get_all_primary_ids"},{"line":282,"kind":12,"containerName":"get_all_primary_ids","name":"unpack_record"},{"name":"$rec","kind":13,"containerName":"get_all_primary_ids","line":282},{"line":284,"name":"$bytepos","containerName":"get_all_primary_ids","kind":13},{"line":284,"kind":13,"containerName":"get_all_primary_ids","name":"$id"},{"name":"%bytepos","kind":13,"containerName":"get_all_primary_ids","line":287}],"name":"get_all_primary_ids","containerName":"main::"},{"definition":"sub","detail":"($self,$id)","children":[{"kind":13,"localvar":"my","containerName":"get_Seq_by_primary_id","name":"$self","line":311,"definition":"my"},{"line":311,"name":"$id","kind":13,"containerName":"get_Seq_by_primary_id"},{"line":312,"kind":13,"containerName":"get_Seq_by_primary_id","name":"$self"},{"line":312,"kind":12,"containerName":"get_Seq_by_primary_id","name":"fetch"},{"name":"$id","containerName":"get_Seq_by_primary_id","kind":13,"line":312}],"containerName":"main::","name":"get_Seq_by_primary_id","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id\n\n\n\nsub get_Seq_by_id {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_Seq_by_acc\n\n Title   : get_Seq_by_acc\n Usage   : $seq = $db->get_Seq_by_acc()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the accession number\n\n\n\nsub get_Seq_by_acc {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_PrimarySeq_stream\n\n Title   : get_PrimarySeq_stream\n Usage   : $stream = get_PrimarySeq_stream\n Function: Makes a Bio::DB::SeqStreamI compliant object\n           which provides a single method, next_primary_seq\n Returns : Bio::DB::SeqStreamI\n Args    : none\n\n\n\nsub get_PrimarySeq_stream {\n    my $self = shift;\n    my $num  = $self->_file_count() || 0;\n    my @file;\n    \n    for (my $i = 0; $i < $num; $i++) {\n        my( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\tpush(@file,$file);\n    }\n   \n    my $out = Bio::SeqIO::MultiFile->new( '-format' => $self->_file_format , -files => \\@file);\n    return $out;\n}\n\n=head2 get_all_primary_ids\n\n Title   : get_all_primary_ids\n Usage   : @ids = $seqdb->get_all_primary_ids()\n Function: gives an array of all the primary_ids of the \n           sequence objects in the database. These\n           maybe ids (display style) or accession numbers\n           or something else completely different - they\n           *are not* meaningful outside of this database\n           implementation.\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_primary_ids {\n   my ($self,@args) = @_;\n    my $db = $self->db;\n   \n   # the problem is here that we have indexed things both on\n   # accession number and name. \n\n   # We could take two options\n   # here - loop over the database, returning only one copy of each\n   # id that points to the same byte position, or we rely on semantics\n   # of accession numbers.\n\n   # someone is going to index a database with no accession numbers.\n   # doh!. We have to uniquify the index...\n\n   my( %bytepos );\n   while (my($id, $rec) = each %$db) {\n       if( $id =~ /^__/ ) {\n           # internal info\n           next;\n       }\n       my ($file, $begin) = $self->unpack_record( $rec );\n       \n       $bytepos{\"$file:$begin\"} = $id;\n   }\n\n   return values %bytepos;\n}\n\n\n=head2 get_Seq_by_primary_id\n\n Title   : get_Seq_by_primary_id\n Usage   : $seq = $db->get_Seq_by_primary_id($primary_id_string);\n Function: Gets a Bio::Seq object by the primary id. The primary\n           id in these cases has to come from $db->get_all_primary_ids.\n           There is no other way to get (or guess) the primary_ids\n           in a database.\n\n           The other possibility is to get Bio::PrimarySeqI objects\n           via the get_PrimarySeq_stream and the primary_id field\n           on these objects are specified as the ids to use here.\n Returns : A Bio::Seq object\n Args    : primary id (as a string)\n Throws  : \"acc does not exist\" exception","label":"get_Seq_by_primary_id($self,$id)"},"line":310,"kind":12,"range":{"end":{"line":313,"character":9999},"start":{"line":310,"character":0}}}],"version":5}