{"vars":[{"name":"Fcntl","kind":2,"containerName":"","line":87},{"line":88,"containerName":"","kind":2,"name":"vars"},{"line":95,"name":"base","containerName":"","kind":2},{"kind":13,"localvar":"my","containerName":null,"name":"%func","line":99,"definition":"my"},{"line":100,"name":"strict","kind":12},{"definition":"my","line":101,"name":"$field","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"%func","line":103},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$self","line":104},{"line":104,"name":"$value","kind":13,"containerName":null},{"name":"%value","kind":13,"containerName":null,"line":106},{"containerName":null,"kind":13,"name":"%self","line":107},{"containerName":null,"kind":13,"name":"$field","line":107},{"line":107,"name":"$value","containerName":null,"kind":13},{"line":109,"name":"%self","containerName":null,"kind":13},{"name":"$field","kind":13,"containerName":null,"line":109},{"kind":12,"range":{"start":{"line":136,"character":0},"end":{"line":164,"character":9999}},"line":136,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#\n# $Id: Abstract.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::Abstract\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#          and James Gilbert <jgrg@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Abstract - Abstract interface for indexing a flat file\n\n=head1 SYNOPSIS\n\nYou should not be using this module directly\n\n=head1 USING DB_FILE\n\nTo use DB_File and not SDBM for this index, pass the value:\n\n    -dbm_package => 'DB_File'\n\nto new (see below).\n\n=head1 DESCRIPTION\n\nThis object provides the basic mechanism to associate positions\nin files with names. The position and filenames are stored in DBM\nwhich can then be accessed later on. It is the equivalent of flat\nfile indexing (eg, SRS or efetch).\n\nThis object is the guts to the mechanism, which will be used by the\nspecific objects inheriting from it.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, James Gilbert\n\nEmail - birney@sanger.ac.uk, jgrg@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with an \"_\" (underscore).\n\n\n\n# Let the code begin...\n\npackage Bio::Index::Abstract;\n\nuse strict;\nuse Fcntl qw( O_RDWR O_CREAT O_RDONLY );\nuse vars qw( $TYPE_AND_VERSION_KEY\n             $USE_DBM_TYPE $DB_HASH );\n\n\nuse Bio::Root::IO;\nuse Symbol;\n\nuse base qw(Bio::Root::Root);\n\n# Generate accessor methods for simple object fields\nBEGIN {\n\tforeach my $func (qw(filename write_flag)) {\n\t\tno strict 'refs';\n\t\tmy $field = \"_$func\";\n\n\t\t*$func = sub {\n\t\t\tmy( $self, $value ) = @_;\n\n\t\t\tif (defined $value) {\n\t\t\t\t$self->{$field} = $value;\n\t\t\t}\n\t\t\treturn $self->{$field};\n\t\t}\n\t}\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.","label":"new($class,@args)"},"name":"new","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":137,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":137},{"line":138,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":138},{"kind":13,"containerName":"new","name":"@args","line":138},{"localvar":"my","containerName":"new","kind":13,"name":"$filename","line":139,"definition":"my"},{"name":"$write_flag","containerName":"new","kind":13,"line":139},{"name":"$dbm_package","kind":13,"containerName":"new","line":139},{"name":"$cachesize","containerName":"new","kind":13,"line":139},{"line":139,"name":"$ffactor","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$pathtype","line":139},{"line":140,"containerName":"new","kind":13,"name":"$self"},{"line":140,"containerName":"new","kind":12,"name":"_rearrange"},{"line":146,"name":"@args","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":149},{"line":149,"kind":12,"containerName":"new","name":"filename"},{"containerName":"new","kind":13,"name":"$filename","line":149},{"name":"$filename","containerName":"new","kind":13,"line":149},{"kind":13,"containerName":"new","name":"$self","line":150},{"line":150,"name":"cachesize","containerName":"new","kind":12},{"line":150,"name":"$cachesize","containerName":"new","kind":13},{"line":150,"containerName":"new","kind":13,"name":"$cachesize"},{"line":151,"kind":13,"containerName":"new","name":"$self"},{"name":"ffactor","containerName":"new","kind":12,"line":151},{"kind":13,"containerName":"new","name":"$ffactor","line":151},{"line":151,"name":"$ffactor","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":152},{"line":152,"name":"write_flag","kind":12,"containerName":"new"},{"name":"$write_flag","containerName":"new","kind":13,"line":152},{"name":"$write_flag","containerName":"new","kind":13,"line":152},{"name":"$self","kind":13,"containerName":"new","line":153},{"line":153,"name":"dbm_package","kind":12,"containerName":"new"},{"name":"$dbm_package","kind":13,"containerName":"new","line":153},{"line":153,"kind":13,"containerName":"new","name":"$dbm_package"},{"name":"$pathtype","kind":13,"containerName":"new","line":156},{"containerName":"new","kind":13,"name":"$self","line":156},{"containerName":"new","kind":12,"name":"pathtype","line":156},{"line":156,"containerName":"new","kind":13,"name":"$pathtype"},{"containerName":"new","kind":13,"name":"$self","line":156},{"line":156,"kind":12,"containerName":"new","name":"pathtype"},{"kind":13,"containerName":"new","name":"$self","line":158},{"name":"$self","kind":13,"containerName":"new","line":159},{"kind":13,"containerName":"new","name":"$self","line":162},{"name":"open_dbm","kind":12,"containerName":"new","line":162},{"line":162,"name":"$filename","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":163}],"detail":"($class,@args)","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":138},{"line":209,"range":{"start":{"line":209,"character":0},"end":{"character":9999,"line":230}},"kind":12,"signature":{"label":"dbm_package($self,$value)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"name":"$self","containerName":"dbm_package","localvar":"my","kind":13,"line":210,"definition":"my"},{"containerName":"dbm_package","kind":13,"name":"$value","line":210},{"definition":"my","localvar":"my","kind":13,"containerName":"dbm_package","name":"$to_require","line":211},{"line":212,"name":"$value","kind":13,"containerName":"dbm_package"},{"containerName":"dbm_package","kind":13,"name":"$self","line":212},{"definition":"my","line":213,"localvar":"my","containerName":"dbm_package","kind":13,"name":"$type"},{"name":"$value","kind":13,"containerName":"dbm_package","line":213},{"name":"$USE_DBM_TYPE","containerName":"dbm_package","kind":13,"line":213},{"containerName":"dbm_package","kind":13,"name":"$type","line":214},{"line":218,"name":"$type","containerName":"dbm_package","kind":13},{"name":"$type","containerName":"dbm_package","kind":13,"line":220},{"line":222,"name":"$self","containerName":"dbm_package","kind":13},{"name":"throw","kind":12,"containerName":"dbm_package","line":222},{"name":"$self","containerName":"dbm_package","kind":13,"line":224},{"name":"$type","containerName":"dbm_package","kind":13,"line":224},{"line":225,"name":"$USE_DBM_TYPE","containerName":"dbm_package","kind":13},{"name":"$USE_DBM_TYPE","kind":13,"containerName":"dbm_package","line":226},{"line":226,"containerName":"dbm_package","kind":13,"name":"$self"},{"line":229,"containerName":"dbm_package","kind":13,"name":"$self"}],"name":"dbm_package","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"kind":12,"range":{"start":{"line":247,"character":0},"end":{"line":249,"character":9999}},"line":247,"name":"db","containerName":"main::","children":[],"definition":"sub"},{"definition":"sub","detail":"($self,$id)","children":[{"definition":"my","line":287,"name":"$self","containerName":"get_stream","localvar":"my","kind":13},{"containerName":"get_stream","kind":13,"name":"$id","line":287},{"name":"$desc","kind":13,"localvar":"my","containerName":"get_stream","line":289,"definition":"my"},{"name":"$acc","kind":13,"containerName":"get_stream","line":289},{"line":289,"name":"$out","containerName":"get_stream","kind":13},{"definition":"my","line":290,"name":"$db","containerName":"get_stream","localvar":"my","kind":13},{"line":290,"name":"$self","kind":13,"containerName":"get_stream"},{"line":290,"name":"db","kind":12,"containerName":"get_stream"},{"definition":"my","line":292,"containerName":"get_stream","localvar":"my","kind":13,"name":"$rec"},{"line":292,"containerName":"get_stream","kind":13,"name":"$db"},{"name":"$id","containerName":"get_stream","kind":13,"line":292},{"localvar":"my","containerName":"get_stream","kind":13,"name":"@record","line":293,"definition":"my"},{"containerName":"get_stream","localvar":"my","kind":13,"name":"$file","line":295,"definition":"my"},{"line":295,"containerName":"get_stream","kind":13,"name":"$begin"},{"line":295,"containerName":"get_stream","kind":13,"name":"$end"},{"line":295,"containerName":"get_stream","kind":13,"name":"$self"},{"containerName":"get_stream","kind":12,"name":"unpack_record","line":295},{"name":"$rec","containerName":"get_stream","kind":13,"line":295},{"definition":"my","line":298,"name":"$fh","kind":13,"localvar":"my","containerName":"get_stream"},{"name":"$self","containerName":"get_stream","kind":13,"line":298},{"line":298,"kind":12,"containerName":"get_stream","name":"_file_handle"},{"line":298,"containerName":"get_stream","kind":13,"name":"$file"},{"name":"$fh","containerName":"get_stream","kind":13,"line":301},{"line":301,"name":"$begin","kind":13,"containerName":"get_stream"},{"line":303,"containerName":"get_stream","kind":13,"name":"$fh"},{"kind":13,"containerName":"get_stream","name":"$self","line":305},{"line":305,"name":"throw","containerName":"get_stream","kind":12}],"containerName":"main::","name":"get_stream","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n'","label":"get_stream($self,$id)"},"line":286,"range":{"start":{"line":286,"character":0},"end":{"line":307,"character":9999}},"kind":12},{"line":320,"kind":12,"range":{"start":{"character":0,"line":320},"end":{"character":9999,"line":327}},"signature":{"label":"cachesize($self,$size)","parameters":[{"label":"$self"},{"label":"$size"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache"},"children":[{"line":321,"name":"$self","containerName":"cachesize","localvar":"my","kind":13,"definition":"my"},{"name":"$size","containerName":"cachesize","kind":13,"line":321},{"line":323,"containerName":"cachesize","kind":13,"name":"$size"},{"line":324,"containerName":"cachesize","kind":13,"name":"$self"},{"line":324,"name":"$size","containerName":"cachesize","kind":13},{"containerName":"cachesize","kind":13,"name":"$self","line":326}],"name":"cachesize","containerName":"main::","definition":"sub","detail":"($self,$size)"},{"signature":{"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache","parameters":[{"label":"$self"},{"label":"$size"}],"label":"ffactor($self,$size)"},"range":{"end":{"character":9999,"line":348},"start":{"character":0,"line":341}},"kind":12,"line":341,"detail":"($self,$size)","definition":"sub","containerName":"main::","name":"ffactor","children":[{"definition":"my","line":342,"localvar":"my","containerName":"ffactor","kind":13,"name":"$self"},{"line":342,"containerName":"ffactor","kind":13,"name":"$size"},{"line":344,"kind":13,"containerName":"ffactor","name":"$size"},{"line":345,"containerName":"ffactor","kind":13,"name":"$self"},{"name":"$size","containerName":"ffactor","kind":13,"line":345},{"kind":13,"containerName":"ffactor","name":"$self","line":347}]},{"children":[{"line":368,"kind":13,"localvar":"my","containerName":"open_dbm","name":"$self","definition":"my"},{"kind":13,"localvar":"my","containerName":"open_dbm","name":"$filename","line":370,"definition":"my"},{"line":370,"name":"$self","containerName":"open_dbm","kind":13},{"kind":12,"containerName":"open_dbm","name":"filename","line":370},{"line":371,"containerName":"open_dbm","kind":13,"name":"$self"},{"line":371,"kind":12,"containerName":"open_dbm","name":"throw"},{"definition":"my","name":"$db","containerName":"open_dbm","localvar":"my","kind":13,"line":373},{"name":"$self","containerName":"open_dbm","kind":13,"line":373},{"line":373,"name":"db","containerName":"open_dbm","kind":12},{"line":377,"name":"$db","kind":13,"containerName":"open_dbm"},{"containerName":"open_dbm","kind":13,"name":"$db","line":378},{"definition":"my","line":382,"localvar":"my","containerName":"open_dbm","kind":13,"name":"$dbm_type"},{"line":382,"name":"$self","containerName":"open_dbm","kind":13},{"containerName":"open_dbm","kind":12,"name":"dbm_package","line":382},{"line":385,"localvar":"my","containerName":"open_dbm","kind":13,"name":"$mode_flags","definition":"my"},{"line":385,"containerName":"open_dbm","kind":13,"name":"$self"},{"name":"write_flag","kind":12,"containerName":"open_dbm","line":385},{"name":"$dbm_type","kind":13,"containerName":"open_dbm","line":388},{"line":389,"containerName":"open_dbm","localvar":"my","kind":13,"name":"$hash_inf","definition":"my"},{"name":"new","kind":12,"containerName":"open_dbm","line":389},{"name":"$cache","localvar":"my","containerName":"open_dbm","kind":13,"line":390,"definition":"my"},{"name":"$self","containerName":"open_dbm","kind":13,"line":390},{"kind":12,"containerName":"open_dbm","name":"cachesize","line":390},{"line":391,"name":"$ffactor","localvar":"my","containerName":"open_dbm","kind":13,"definition":"my"},{"line":391,"kind":13,"containerName":"open_dbm","name":"$self"},{"line":391,"name":"ffactor","kind":12,"containerName":"open_dbm"},{"name":"$cache","kind":13,"containerName":"open_dbm","line":392},{"containerName":"open_dbm","kind":13,"name":"$hash_inf","line":393},{"line":393,"kind":13,"containerName":"open_dbm","name":"$cache"},{"line":395,"containerName":"open_dbm","kind":13,"name":"$ffactor"},{"name":"$hash_inf","containerName":"open_dbm","kind":13,"line":396},{"name":"$ffactor","kind":13,"containerName":"open_dbm","line":396},{"name":"$dbm_type","kind":13,"containerName":"open_dbm","line":398},{"containerName":"open_dbm","kind":13,"name":"$filename","line":398},{"line":398,"kind":13,"containerName":"open_dbm","name":"$mode_flags"},{"line":398,"containerName":"open_dbm","kind":13,"name":"$hash_inf"},{"line":399,"containerName":"open_dbm","kind":13,"name":"$self"},{"line":399,"kind":12,"containerName":"open_dbm","name":"throw"},{"line":401,"name":"$dbm_type","kind":13,"containerName":"open_dbm"},{"line":401,"name":"$filename","containerName":"open_dbm","kind":13},{"line":401,"containerName":"open_dbm","kind":13,"name":"$mode_flags"},{"name":"$self","containerName":"open_dbm","kind":13,"line":402},{"line":402,"containerName":"open_dbm","kind":12,"name":"throw"},{"line":409,"containerName":"open_dbm","kind":13,"name":"$self"},{"definition":"my","line":410,"name":"$pkg","localvar":"my","kind":13,"containerName":"open_dbm"},{"line":410,"kind":13,"containerName":"open_dbm","name":"$self"},{"line":410,"kind":12,"containerName":"open_dbm","name":"_code_base"},{"kind":13,"containerName":"open_dbm","name":"$self","line":411},{"line":411,"name":"$pkg","containerName":"open_dbm","kind":13},{"kind":13,"containerName":"open_dbm","name":"$self","line":415},{"line":415,"name":"_type_and_version","containerName":"open_dbm","kind":12},{"kind":13,"containerName":"open_dbm","name":"$self","line":418},{"line":418,"name":"_check_file_sizes","kind":12,"containerName":"open_dbm"}],"containerName":"main::","name":"open_dbm","definition":"sub","detail":"($self)","line":367,"range":{"end":{"line":421,"character":9999},"start":{"line":367,"character":0}},"kind":12,"signature":{"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success","parameters":[{"label":"$self"}],"label":"open_dbm($self)"}},{"line":385,"name":"O_RDWR","kind":12},{"line":385,"name":"O_CREAT","kind":12},{"name":"O_RDONLY","kind":12,"line":385},{"line":389,"name":"DB_File","kind":12,"containerName":"HASHINFO"},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_version","line":438,"definition":"my"},{"line":439,"name":"$self","kind":13,"containerName":"_version"},{"containerName":"_version","kind":12,"name":"throw","line":439}],"name":"_version","containerName":"main::","line":437,"kind":12,"range":{"start":{"line":437,"character":0},"end":{"line":440,"character":9999}}},{"signature":{"label":"_code_base($self)","parameters":[{"label":"$self"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :"},"kind":12,"range":{"start":{"character":0,"line":454},"end":{"character":9999,"line":467}},"line":454,"detail":"($self)","definition":"sub","name":"_code_base","containerName":"main::","children":[{"line":455,"name":"$self","localvar":"my","containerName":"_code_base","kind":13,"definition":"my"},{"name":"$code_key","localvar":"my","containerName":"_code_base","kind":13,"line":456,"definition":"my"},{"line":457,"name":"$record","localvar":"my","containerName":"_code_base","kind":13,"definition":"my"},{"line":459,"name":"$record","containerName":"_code_base","kind":13},{"line":459,"name":"$self","kind":13,"containerName":"_code_base"},{"line":459,"name":"db","kind":12,"containerName":"_code_base"},{"line":459,"containerName":"_code_base","kind":13,"name":"$code_key"},{"name":"$code","kind":13,"localvar":"my","containerName":"_code_base","line":461,"definition":"my"},{"kind":13,"containerName":"_code_base","name":"$version","line":461},{"containerName":"_code_base","kind":13,"name":"$self","line":461},{"line":461,"name":"unpack_record","containerName":"_code_base","kind":12},{"containerName":"_code_base","kind":13,"name":"$record","line":461},{"line":463,"name":"$code","kind":13,"containerName":"_code_base"},{"line":463,"name":"$version","containerName":"_code_base","kind":13},{"name":"$code","containerName":"_code_base","kind":13,"line":465}]},{"children":[{"definition":"my","line":485,"name":"$self","localvar":"my","kind":13,"containerName":"_type_and_version"},{"definition":"my","name":"$key","kind":13,"localvar":"my","containerName":"_type_and_version","line":486},{"definition":"my","line":487,"name":"$version","localvar":"my","kind":13,"containerName":"_type_and_version"},{"name":"$self","containerName":"_type_and_version","kind":13,"line":487},{"line":487,"containerName":"_type_and_version","kind":12,"name":"_version"},{"definition":"my","name":"$type","localvar":"my","kind":13,"containerName":"_type_and_version","line":488},{"name":"$self","containerName":"_type_and_version","kind":13,"line":488},{"name":"$rec","localvar":"my","kind":13,"containerName":"_type_and_version","line":491,"definition":"my"},{"containerName":"_type_and_version","kind":13,"name":"$self","line":491},{"name":"db","containerName":"_type_and_version","kind":12,"line":491},{"line":491,"containerName":"_type_and_version","kind":13,"name":"$key"},{"name":"$db_type","localvar":"my","kind":13,"containerName":"_type_and_version","line":492,"definition":"my"},{"name":"$db_version","kind":13,"containerName":"_type_and_version","line":492},{"line":492,"containerName":"_type_and_version","kind":13,"name":"$self"},{"containerName":"_type_and_version","kind":12,"name":"unpack_record","line":492},{"line":492,"containerName":"_type_and_version","kind":13,"name":"$rec"},{"name":"$self","containerName":"_type_and_version","kind":13,"line":493},{"kind":12,"containerName":"_type_and_version","name":"throw","line":493},{"containerName":"_type_and_version","kind":13,"name":"$db_version","line":494},{"line":494,"containerName":"_type_and_version","kind":13,"name":"$version"},{"line":495,"containerName":"_type_and_version","kind":13,"name":"$self"},{"kind":12,"containerName":"_type_and_version","name":"throw","line":495},{"line":496,"name":"$db_type","containerName":"_type_and_version","kind":13},{"containerName":"_type_and_version","kind":13,"name":"$type","line":496},{"name":"$self","containerName":"_type_and_version","kind":13,"line":498},{"name":"add_record","containerName":"_type_and_version","kind":12,"line":498},{"line":498,"kind":13,"containerName":"_type_and_version","name":"$key"},{"name":"$type","containerName":"_type_and_version","kind":13,"line":498},{"line":498,"name":"$version","kind":13,"containerName":"_type_and_version"},{"line":499,"name":"$self","containerName":"_type_and_version","kind":13},{"name":"throw","kind":12,"containerName":"_type_and_version","line":499}],"name":"_type_and_version","containerName":"main::","definition":"sub","line":484,"range":{"end":{"character":9999,"line":502},"start":{"character":0,"line":484}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":531},"start":{"character":0,"line":519}},"line":519,"containerName":"main::","name":"_check_file_sizes","children":[{"line":520,"localvar":"my","kind":13,"containerName":"_check_file_sizes","name":"$self","definition":"my"},{"definition":"my","name":"$num","localvar":"my","containerName":"_check_file_sizes","kind":13,"line":521},{"line":521,"containerName":"_check_file_sizes","kind":13,"name":"$self"},{"line":521,"name":"_file_count","containerName":"_check_file_sizes","kind":12},{"definition":"my","localvar":"my","containerName":"_check_file_sizes","kind":13,"name":"$i","line":523},{"line":523,"name":"$i","kind":13,"containerName":"_check_file_sizes"},{"kind":13,"containerName":"_check_file_sizes","name":"$num","line":523},{"containerName":"_check_file_sizes","kind":13,"name":"$i","line":523},{"line":524,"kind":13,"localvar":"my","containerName":"_check_file_sizes","name":"$file","definition":"my"},{"line":524,"kind":13,"containerName":"_check_file_sizes","name":"$stored_size"},{"containerName":"_check_file_sizes","kind":13,"name":"$self","line":524},{"containerName":"_check_file_sizes","kind":12,"name":"unpack_record","line":524},{"line":524,"name":"$self","containerName":"_check_file_sizes","kind":13},{"name":"db","kind":12,"containerName":"_check_file_sizes","line":524},{"definition":"my","line":525,"name":"$size","localvar":"my","containerName":"_check_file_sizes","kind":13},{"kind":13,"containerName":"_check_file_sizes","name":"$file","line":525},{"name":"$size","kind":13,"containerName":"_check_file_sizes","line":526},{"name":"$stored_size","kind":13,"containerName":"_check_file_sizes","line":526},{"line":527,"containerName":"_check_file_sizes","kind":13,"name":"$self"},{"line":527,"name":"throw","kind":12,"containerName":"_check_file_sizes"}],"definition":"sub"},{"containerName":"main::","name":"make_index","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"make_index","name":"$self","line":551},{"line":551,"containerName":"make_index","kind":13,"name":"@files"},{"line":552,"localvar":"my","kind":13,"containerName":"make_index","name":"$count","definition":"my"},{"line":553,"name":"$recs","localvar":"my","containerName":"make_index","kind":13,"definition":"my"},{"line":556,"kind":13,"containerName":"make_index","name":"$self"},{"line":556,"kind":12,"containerName":"make_index","name":"write_flag"},{"line":557,"name":"$self","containerName":"make_index","kind":13},{"name":"throw","containerName":"make_index","kind":12,"line":557},{"line":561,"containerName":"make_index","kind":13,"name":"$self"},{"containerName":"make_index","kind":12,"name":"throw","line":561},{"line":561,"name":"@files","containerName":"make_index","kind":13},{"line":562,"kind":13,"localvar":"my","containerName":"make_index","name":"$i","definition":"my"},{"containerName":"make_index","kind":13,"name":"$i","line":562},{"name":"@files","containerName":"make_index","kind":13,"line":562},{"name":"$i","containerName":"make_index","kind":13,"line":562},{"line":563,"name":"$Bio","containerName":"make_index","kind":13},{"line":563,"kind":12,"containerName":"make_index","name":"can"},{"line":564,"name":"file_name_is_absolute","kind":12,"containerName":"make_index"},{"name":"$files","kind":13,"containerName":"make_index","line":564},{"name":"$i","kind":13,"containerName":"make_index","line":564},{"line":565,"name":"$self","containerName":"make_index","kind":13},{"containerName":"make_index","kind":12,"name":"pathtype","line":565},{"line":566,"name":"$files","containerName":"make_index","kind":13},{"line":566,"kind":13,"containerName":"make_index","name":"$i"},{"line":566,"containerName":"make_index","kind":12,"name":"rel2abs"},{"kind":13,"containerName":"make_index","name":"$files","line":566},{"containerName":"make_index","kind":13,"name":"$i","line":566},{"containerName":"make_index","kind":13,"name":"$files","line":570},{"name":"$i","containerName":"make_index","kind":13,"line":570},{"name":"$self","kind":13,"containerName":"make_index","line":571},{"line":571,"containerName":"make_index","kind":12,"name":"throw"},{"line":573,"name":"$files","kind":13,"containerName":"make_index"},{"line":573,"containerName":"make_index","kind":13,"name":"$i"},{"line":574,"name":"$self","kind":13,"containerName":"make_index"},{"line":574,"containerName":"make_index","kind":12,"name":"throw"},{"line":577,"name":"$self","containerName":"make_index","kind":13},{"line":577,"name":"throw","kind":12,"containerName":"make_index"},{"containerName":"make_index","kind":13,"name":"$files","line":577},{"name":"$i","kind":13,"containerName":"make_index","line":577},{"line":582,"name":"$file","kind":13,"localvar":"my","containerName":"make_index","definition":"my"},{"line":582,"kind":13,"containerName":"make_index","name":"@files"},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":"make_index","line":584},{"definition":"my","line":587,"name":"$count","containerName":"make_index","localvar":"my","kind":13},{"kind":13,"containerName":"make_index","name":"$self","line":587},{"name":"_file_count","kind":12,"containerName":"make_index","line":587},{"line":588,"name":"$i","containerName":"make_index","kind":13},{"name":"$count","containerName":"make_index","kind":13,"line":588},{"name":"$i","containerName":"make_index","kind":13,"line":590},{"line":590,"containerName":"make_index","kind":13,"name":"$self"},{"containerName":"make_index","kind":12,"name":"_file_count","line":590},{"localvar":"my","kind":13,"containerName":"make_index","name":"$record","line":594,"definition":"my"},{"kind":13,"containerName":"make_index","name":"$number","line":594},{"line":594,"name":"$size","kind":13,"containerName":"make_index"},{"line":596,"containerName":"make_index","kind":13,"name":"$record"},{"containerName":"make_index","kind":13,"name":"$self","line":596},{"line":596,"kind":12,"containerName":"make_index","name":"db"},{"line":597,"containerName":"make_index","kind":13,"name":"$number"},{"line":597,"name":"$size","containerName":"make_index","kind":13},{"line":597,"containerName":"make_index","kind":13,"name":"$self"},{"kind":12,"containerName":"make_index","name":"unpack_record","line":597},{"name":"$record","kind":13,"containerName":"make_index","line":597},{"name":"$file","containerName":"make_index","kind":13,"line":600},{"name":"$size","containerName":"make_index","kind":13,"line":600},{"line":601,"name":"$self","containerName":"make_index","kind":13},{"line":601,"containerName":"make_index","kind":12,"name":"warn"},{"line":604,"name":"$self","containerName":"make_index","kind":13},{"line":604,"kind":12,"containerName":"make_index","name":"throw"},{"name":"$self","kind":13,"containerName":"make_index","line":609},{"containerName":"make_index","kind":12,"name":"debug","line":609},{"line":612,"name":"$recs","containerName":"make_index","kind":13},{"name":"$self","containerName":"make_index","kind":13,"line":612},{"containerName":"make_index","kind":12,"name":"_index_file","line":612},{"name":"$file","containerName":"make_index","kind":13,"line":612},{"containerName":"make_index","kind":13,"name":"$i","line":612},{"line":615,"kind":13,"containerName":"make_index","name":"$self"},{"line":615,"name":"add_record","containerName":"make_index","kind":12},{"line":615,"kind":13,"containerName":"make_index","name":"$file"},{"name":"$file","kind":13,"containerName":"make_index","line":615},{"name":"$self","kind":13,"containerName":"make_index","line":616},{"line":616,"name":"throw","containerName":"make_index","kind":12},{"containerName":"make_index","kind":13,"name":"$self","line":617},{"name":"add_record","containerName":"make_index","kind":12,"line":617},{"line":617,"name":"$i","kind":13,"containerName":"make_index"},{"line":617,"kind":13,"containerName":"make_index","name":"$file"},{"line":618,"name":"$self","containerName":"make_index","kind":13},{"line":618,"kind":12,"containerName":"make_index","name":"throw"},{"line":621,"name":"$i","containerName":"make_index","kind":13},{"line":621,"name":"$self","containerName":"make_index","kind":13},{"line":621,"name":"_file_count","containerName":"make_index","kind":12},{"kind":13,"containerName":"make_index","name":"$i","line":621},{"containerName":"make_index","localvar":"my","kind":13,"name":"$temp","line":622,"definition":"my"},{"name":"$temp","containerName":"make_index","kind":13,"line":623},{"line":623,"name":"$self","kind":13,"containerName":"make_index"},{"line":623,"containerName":"make_index","kind":12,"name":"_file_count"},{"name":"$count","containerName":"make_index","kind":13,"line":625},{"line":625,"kind":13,"containerName":"make_index","name":"$recs"}],"detail":"($self,@files)","definition":"sub","kind":12,"range":{"start":{"line":550,"character":0},"end":{"line":626,"character":9999}},"line":550,"signature":{"parameters":[{"label":"$self"},{"label":"@files"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES","label":"make_index($self,@files)"}},{"containerName":"IO::FILESPECLOADED","kind":12,"name":"Root","line":563},{"name":"File","containerName":"Spec","kind":12,"line":563},{"name":"File","containerName":"Spec","kind":12,"line":564},{"kind":12,"containerName":"Spec","name":"File","line":566},{"line":581,"name":"FILE","kind":12},{"line":602,"kind":12,"name":"FILE"},{"definition":"sub","detail":"($self,$type)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"pathtype","name":"$self","line":649},{"name":"$type","kind":13,"containerName":"pathtype","line":649},{"kind":13,"containerName":"pathtype","name":"$type","line":651},{"kind":13,"containerName":"pathtype","name":"$type","line":652},{"line":652,"containerName":"pathtype","kind":13,"name":"$type"},{"name":"$self","containerName":"pathtype","kind":13,"line":653},{"name":"throw","containerName":"pathtype","kind":12,"line":653},{"containerName":"pathtype","kind":13,"name":"$self","line":655},{"line":655,"name":"$type","containerName":"pathtype","kind":13},{"line":658,"name":"$self","kind":13,"containerName":"pathtype"}],"containerName":"main::","name":"pathtype","signature":{"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)","parameters":[{"label":"$self"},{"label":"$type"}],"label":"pathtype($self,$type)"},"line":647,"kind":12,"range":{"end":{"line":659,"character":9999},"start":{"character":0,"line":647}}},{"definition":"sub","children":[{"definition":"my","line":674,"name":"$self","localvar":"my","kind":13,"containerName":"_index_file"},{"name":"$pkg","containerName":"_index_file","localvar":"my","kind":13,"line":676,"definition":"my"},{"containerName":"_index_file","kind":13,"name":"$self","line":676},{"containerName":"_index_file","kind":13,"name":"$self","line":677},{"line":677,"containerName":"_index_file","kind":12,"name":"throw"}],"containerName":"main::","name":"_index_file","line":673,"kind":12,"range":{"start":{"character":0,"line":673},"end":{"line":678,"character":9999}}},{"kind":12,"range":{"end":{"line":710,"character":9999},"start":{"line":697,"character":0}},"line":697,"signature":{"parameters":[{"label":"$self"},{"label":"$i"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT","label":"_file_handle($self,$i)"},"containerName":"main::","name":"_file_handle","children":[{"line":698,"name":"$self","localvar":"my","containerName":"_file_handle","kind":13,"definition":"my"},{"line":698,"name":"$i","kind":13,"containerName":"_file_handle"},{"name":"$self","kind":13,"containerName":"_file_handle","line":700},{"line":700,"containerName":"_file_handle","kind":13,"name":"$i"},{"definition":"my","localvar":"my","kind":13,"containerName":"_file_handle","name":"@rec","line":701},{"line":701,"kind":13,"containerName":"_file_handle","name":"$self"},{"containerName":"_file_handle","kind":12,"name":"unpack_record","line":701},{"name":"$self","containerName":"_file_handle","kind":13,"line":701},{"line":701,"containerName":"_file_handle","kind":12,"name":"db"},{"line":702,"name":"$self","kind":13,"containerName":"_file_handle"},{"line":702,"kind":12,"containerName":"_file_handle","name":"throw"},{"definition":"my","line":703,"localvar":"my","kind":13,"containerName":"_file_handle","name":"$file"},{"name":"$rec","containerName":"_file_handle","kind":13,"line":703},{"definition":"my","line":706,"containerName":"_file_handle","localvar":"my","kind":13,"name":"$fh"},{"name":"$file","kind":13,"containerName":"_file_handle","line":706},{"line":706,"name":"$self","containerName":"_file_handle","kind":13},{"line":706,"name":"throw","containerName":"_file_handle","kind":12},{"line":707,"name":"$self","containerName":"_file_handle","kind":13},{"name":"$i","containerName":"_file_handle","kind":13,"line":707},{"containerName":"_file_handle","kind":13,"name":"$fh","line":707},{"name":"$self","containerName":"_file_handle","kind":13,"line":709},{"line":709,"name":"$i","kind":13,"containerName":"_file_handle"}],"detail":"($self,$i)","definition":"sub"},{"line":727,"kind":12,"range":{"end":{"character":9999,"line":733},"start":{"character":0,"line":727}},"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_file_count","line":728,"definition":"my"},{"kind":13,"containerName":"_file_count","name":"$self","line":730},{"line":730,"name":"db","kind":12,"containerName":"_file_count"},{"kind":13,"containerName":"_file_count","name":"$self","line":732},{"line":732,"kind":12,"containerName":"_file_count","name":"db"}],"name":"_file_count","containerName":"main::"},{"range":{"start":{"character":0,"line":751},"end":{"line":759,"character":9999}},"kind":12,"line":751,"signature":{"label":"add_record($self,$id,@rec)","parameters":[{"label":"$self"},{"label":"$id"},{"label":"@rec"}],"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST"},"name":"add_record","containerName":"main::","children":[{"definition":"my","containerName":"add_record","localvar":"my","kind":13,"name":"$self","line":752},{"line":752,"containerName":"add_record","kind":13,"name":"$id"},{"name":"@rec","kind":13,"containerName":"add_record","line":752},{"kind":13,"containerName":"add_record","name":"$self","line":753},{"line":753,"name":"debug","kind":12,"containerName":"add_record"},{"line":754,"containerName":"add_record","kind":13,"name":"$self"},{"line":754,"name":"db","kind":12,"containerName":"add_record"},{"line":754,"name":"$id","containerName":"add_record","kind":13},{"containerName":"add_record","kind":13,"name":"$self","line":755},{"line":755,"name":"warn","containerName":"add_record","kind":12},{"line":757,"containerName":"add_record","kind":13,"name":"$self"},{"name":"db","containerName":"add_record","kind":12,"line":757},{"name":"$id","containerName":"add_record","kind":13,"line":757},{"line":757,"name":"$self","kind":13,"containerName":"add_record"},{"containerName":"add_record","kind":12,"name":"pack_record","line":757},{"name":"@rec","kind":13,"containerName":"add_record","line":757}],"detail":"($self,$id,@rec)","definition":"sub"},{"children":[{"line":776,"name":"$self","localvar":"my","kind":13,"containerName":"pack_record","definition":"my"},{"line":776,"name":"@args","kind":13,"containerName":"pack_record"},{"name":"@args","kind":13,"containerName":"pack_record","line":777}],"name":"pack_record","containerName":"main::","definition":"sub","detail":"($self,@args)","line":775,"kind":12,"range":{"end":{"line":778,"character":9999},"start":{"line":775,"character":0}},"signature":{"label":"pack_record($self,@args)","documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST\n\n\nsub add_record {\n\tmy( $self, $id, @rec ) = @_;\n\t$self->debug( \"Adding key $id\\n\");\n\tif( exists $self->db->{$id} ) {\n\t\t$self->warn(\"overwriting a current value stored for $id\\n\");\n\t}\n\t$self->db->{$id} = $self->pack_record( @rec );\n\treturn 1;\n}\n\n\n=head2 pack_record\n\n  Title   : pack_record\n  Usage   : $packed_string = $index->pack_record( LIST )\n  Function: Packs an array of scalars into a single string\n            joined by ASCII 034 (which is unlikely to be used\n            in any of the strings), and returns it. \n  Example : $packed_string = $index->pack_record( $fileNumber, $begin, $end )\n  Returns : STRING or undef\n  Args    : LIST","parameters":[{"label":"$self"},{"label":"@args"}]}},{"name":"unpack_record","containerName":"main::","children":[{"definition":"my","line":793,"containerName":"unpack_record","localvar":"my","kind":13,"name":"$self"},{"line":793,"kind":13,"containerName":"unpack_record","name":"@args"},{"name":"$args","containerName":"unpack_record","kind":13,"line":794}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":795},"start":{"line":792,"character":0}},"line":792,"signature":{"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST\n\n\nsub add_record {\n\tmy( $self, $id, @rec ) = @_;\n\t$self->debug( \"Adding key $id\\n\");\n\tif( exists $self->db->{$id} ) {\n\t\t$self->warn(\"overwriting a current value stored for $id\\n\");\n\t}\n\t$self->db->{$id} = $self->pack_record( @rec );\n\treturn 1;\n}\n\n\n=head2 pack_record\n\n  Title   : pack_record\n  Usage   : $packed_string = $index->pack_record( LIST )\n  Function: Packs an array of scalars into a single string\n            joined by ASCII 034 (which is unlikely to be used\n            in any of the strings), and returns it. \n  Example : $packed_string = $index->pack_record( $fileNumber, $begin, $end )\n  Returns : STRING or undef\n  Args    : LIST\n\n\nsub pack_record {\n\tmy( $self, @args ) = @_;\n\treturn join \"\\034\", @args;\n}\n\n=head2 unpack_record\n\n  Title   : unpack_record\n  Usage   : $index->unpack_record( STRING )\n  Function: Splits the sting provided into an array,\n            splitting on ASCII 034.\n  Example : ( $fileNumber, $begin, $end ) = $index->unpack_record( $self->db->{$id} )\n  Returns : A 3 element ARRAY\n  Args    : STRING containing ASCII 034","parameters":[{"label":"$self"},{"label":"@args"}],"label":"unpack_record($self,@args)"}},{"detail":"($self,@args)","definition":"sub","name":"count_records","containerName":"main::","children":[{"definition":"my","line":810,"localvar":"my","containerName":"count_records","kind":13,"name":"$self"},{"line":810,"containerName":"count_records","kind":13,"name":"@args"},{"line":811,"name":"$db","containerName":"count_records","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"count_records","line":811},{"line":811,"kind":12,"containerName":"count_records","name":"db"},{"line":812,"localvar":"my","kind":13,"containerName":"count_records","name":"$c","definition":"my"},{"definition":"my","name":"$id","localvar":"my","containerName":"count_records","kind":13,"line":813},{"line":813,"containerName":"count_records","kind":13,"name":"$rec"},{"line":814,"name":"$id","containerName":"count_records","kind":13},{"containerName":"count_records","kind":13,"name":"$c","line":818},{"name":"$c","kind":13,"containerName":"count_records","line":820}],"signature":{"documentation":"=head2 filename\n\n Title   : filename\n Usage   : $value = $self->filename();\n           $self->filename($value);\n Function: Gets or sets the name of the dbm index file.\n Returns : The current value of filename\n Args    : Value of filename if setting, or none if\n           getting the value.\n\n=head2 write_flag\n\n Title   : write_flag\n Usage   : $value = $self->write_flag();\n           $self->write_flag($value);\n Function: Gets or sets the value of write_flag, which\n           is wether the dbm file should be opened with\n           write access.\n Returns : The current value of write_flag (default 0)\n Args    : Value of write_flag if setting, or none if\n           getting the value.\n\n=head2 dbm_package\n\n Usage   : $value = $self->dbm_package();\n           $self->dbm_package($value);\n\n Function: Gets or sets the name of the Perl dbm module used. \n           If the value is unset, then it returns the value of\n           the package variable $USE_DBM_TYPE or if that is\n           unset, then it chooses the best available dbm type,\n           choosing 'DB_File' in preference to 'SDBM_File'. \n           Bio::Abstract::Index may work with other dbm file\n           types.\n\n Returns : The current value of dbm_package\n Args    : Value of dbm_package if setting, or none if\n           getting the value.\n\n\nsub dbm_package {\n\tmy( $self, $value ) = @_;\n\tmy $to_require = 0;\n\tif( $value || ! $self->{'_dbm_package'} ) {\n\t\tmy $type = $value || $USE_DBM_TYPE || 'DB_File';\n\t\tif( $type =~ /DB_File/i ) {\n\t\t\teval {\n\t\t\t\trequire DB_File;\n\t\t\t};\n\t\t\t$type = ( $@ ) ? 'SDBM_File' : 'DB_File';\n\t\t}\n\t\tif( $type ne 'DB_File' ) {\n\t\t\teval { require \"$type.pm\"; };\n\t\t\t$self->throw($@) if( $@ );\n\t\t}\n\t\t$self->{'_dbm_package'} = $type;\n\t\tif( ! defined $USE_DBM_TYPE ) {\n\t\t\t$USE_DBM_TYPE = $self->{'_dbm_package'};\n\t\t}\n    }\n\treturn $self->{'_dbm_package'};\n}\n\n=head2 db\n\n  Title   : db\n  Usage   : $index->db\n  Function: Returns a ref to the hash which is tied to the dbm\n            file.  Used internally when adding and retrieving\n            data from the database.\n  Example : $db = $index->db();\n            $db->{ $some_key } = $data\n            $data = $index->db->{ $some_key };\n  Returns : ref to HASH\n  Args    : NONE\n\n\nsub db {\n\treturn $_[0]->{'_DB'};\n}\n\n\n=head2 get_stream\n\n Title   : get_stream\n Usage   : $stream = $index->get_stream( $id );\n Function: Returns a file handle with the file pointer\n           at the approprite place\n\n           This provides for a way to get the actual\n           file contents and not an object \n\n           WARNING: you must parse the record deliminter\n           *yourself*. Abstract wont do this for you \n           So this code\n\n           $fh = $index->get_stream($myid);\n           while( <$fh> ) {\n              # do something\n           }\n           will parse the entire file if you don't put in\n           a last statement in, like\n\n           while( <$fh> ) {\n              /^\\/\\// && last; # end of record\n              # do something\n           }\n\n Returns : A filehandle object\n Args    : string represents the accession number\n Notes   : This method should not be used without forethought \n\n\n#'\n\nsub get_stream {\n   my ($self,$id) = @_;\n\n   my ($desc,$acc,$out);\n   my $db = $self->db();\n\n   if (my $rec = $db->{ $id }) {\n\t\tmy( @record );\n\n\t\tmy ($file, $begin, $end) = $self->unpack_record( $rec );\n\n\t\t# Get the (possibly cached) filehandle\n\t\tmy $fh = $self->_file_handle( $file );\n\n\t\t# move to start\n\t\tseek($fh, $begin, 0);\n\n\t\treturn $fh;\n   } else {\n\t\t$self->throw(\"Unable to find a record for $id in the flat file index\");\n   }\n}\n\n\n=head2 cachesize\n\n  Usage   : $index->cachesize(1000000)\n  Function: Sets the dbm file cache size for the index.\n  \t    Needs to be set before the DBM file gets opened.\n  Example : $index->cachesize(1000000)\n  Returns : size of the curent cache\n\n\nsub cachesize {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_cachesize'} = $size;\n\t}\n\treturn ( $self->{'_cachesize'} );\n}\n\n\n=head2 ffactor\n\n  Usage   : $index->ffactor(1000000)\n  Function: Sets the dbm file fill factor.\n  \t\t\tNeeds to be set before the DBM file gets opened.\n\n  Example : $index->ffactor(1000000)\n  Returns : size of the curent cache\n\n\nsub ffactor {\n\tmy( $self, $size ) = @_;\n\n\tif(defined $size){\n\t\t$self->{'_ffactor'} = $size;\n\t}\n\treturn ( $self->{'_ffactor'} );\n}\n\n\n=head2 open_dbm\n\n  Usage   : $index->open_dbm()\n  Function: Opens the dbm file associated with the index\n            object.  Write access is only given if explicitly\n            asked for by calling new(-write => 1) or having set\n            the write_flag(1) on the index object.  The type of\n            dbm file opened is that returned by dbm_package(). \n            The name of the file to be is opened is obtained by\n            calling the filename() method.\n\n  Example : $index->_open_dbm()\n  Returns : 1 on success\n\n\nsub open_dbm {\n\tmy( $self ) = @_;\n\n\tmy $filename = $self->filename()\n\t  or $self->throw(\"filename() not set\");\n\n\tmy $db = $self->db();\n\n\t# Close the dbm file if already open (maybe we're getting\n\t# or dropping write access\n\tif (ref($db) ne 'HASH') {\n\t\tuntie($db);\n\t}\n\n\t# What kind of DBM file are we going to open?\n\tmy $dbm_type = $self->dbm_package;\n\n\t# Choose mode for opening dbm file (read/write+create or read-only).\n\tmy $mode_flags = $self->write_flag ? O_RDWR|O_CREAT : O_RDONLY;\n \n\t# Open the dbm file\n\tif ($dbm_type eq 'DB_File') {\n\t\tmy $hash_inf = DB_File::HASHINFO->new();\n\t\tmy $cache = $self->cachesize();\n\t\tmy $ffactor = $self->ffactor();\n\t\tif ($cache){\n\t\t\t$hash_inf->{'cachesize'} = $cache;\n\t\t}\n\t\tif ($ffactor){\n\t\t\t$hash_inf->{'ffactor'} = $ffactor;\n\t\t}\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644, $hash_inf )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t} else {\n\t\ttie( %$db, $dbm_type, $filename, $mode_flags, 0644 )\n\t\t  or $self->throw(\"Can't open '$dbm_type' dbm file '$filename' : $!\");\n\t}\n\n\t# The following methods access data in the dbm file:\n\n\t# Now, if we're a Bio::Index::Abstract caterpillar, then we\n\t# transform ourselves into a Bio::Index::<something> butterfly!\n\tif( ref($self) eq \"Bio::Index::Abstract\" ) { \n\t\tmy $pkg = $self->_code_base();\n\t\tbless $self, $pkg;\n\t}\n\n\t# Check or set this is the right kind and version of index\n\t$self->_type_and_version();\n\n\t# Check files haven't changed size since they were indexed\n\t$self->_check_file_sizes();\n\n\treturn 1;\n}\n\n=head2 _version\n\n  Title   : _version\n  Usage   : $type = $index->_version()\n  Function: Returns a string which identifes the version of an\n            index module.  Used to permanently identify an index\n            file as having been created by a particular version\n            of the index module.  Must be provided by the sub class\n  Example : \n  Returns : \n  Args    : none\n\n\nsub _version {\n\tmy $self = shift;\n\t$self->throw(\"In Bio::Index::Abstract, no _version method in sub class\");\n}\n\n=head2 _code_base\n\n Title   : _code_base\n Usage   : $code = $db->_code_base();\n Function:\n Example :\n Returns : Code package to be used with this \n Args    :\n\n\n\nsub _code_base {\n   my ($self) = @_;\n   my $code_key    = '__TYPE_AND_VERSION';\n   my $record;\n\n   $record = $self->db->{$code_key};\n\n   my($code,$version) = $self->unpack_record($record);\n   if( wantarray ) {\n       return ($code,$version);\n   } else {\n       return $code;\n   }\n}\n\n\n=head2 _type_and_version\n\n  Title   : _type_and_version\n  Usage   : Called by _initalize\n  Function: Checks that the index opened is made by the same index\n            module and version of that module that made it.  If the\n            index is empty, then it adds the information to the\n            database.\n  Example : \n  Returns : 1 or exception\n  Args    : none\n\n\nsub _type_and_version {\n\tmy $self    = shift;\n\tmy $key     = '__TYPE_AND_VERSION';\n\tmy $version = $self->_version();\n\tmy $type    = ref $self;\n\n\t# Run check or add type and version key if missing\n\tif (my $rec = $self->db->{ $key }) {\n\t\tmy( $db_type, $db_version ) = $self->unpack_record($rec);\n\t\t$self->throw(\"This index file is from version [$db_version] - You need to rebuild it to use module version [$version]\")\n\t\t  unless $db_version == $version;\n\t\t$self->throw(\"This index file is type [$db_type] - Can't access it with module for [$type]\")\n\t\t  unless $db_type eq $type;\n\t} else {\n\t\t$self->add_record( $key, $type, $version )\n\t\t  or $self->throw(\"Can't add Type and Version record\");\n\t}\n\treturn 1;\n}\n\n\n=head2 _check_file_sizes\n\n  Title   : _check_file_sizes\n  Usage   : $index->_check_file_sizes()\n  Function: Verifies that the files listed in the database\n            are the same size as when the database was built,\n            or throws an exception.  Called by the new()\n            function.\n  Example : \n  Returns : 1 or exception\n  Args    : \n\n\nsub _check_file_sizes {\n\tmy $self = shift;\n\tmy $num  = $self->_file_count() || 0;\n\n\tfor (my $i = 0; $i < $num; $i++) {\n\t\tmy( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\t\tmy $size = -s $file;\n\t\tunless ($size == $stored_size) {\n\t\t\t$self->throw(\"file $i [ $file ] has changed size $stored_size -> $size. This probably means you need to rebuild the index.\");\n\t\t}\n\t}\n\treturn 1;\n}\n\n\n=head2 make_index\n\n  Title   : make_index\n  Usage   : $index->make_index( FILE_LIST )\n  Function: Takes a list of file names, checks that they are\n            all fully qualified, and then calls _filename() on\n            each.  It supplies _filename() with the name of the\n            file, and an integer which is stored with each record\n            created by _filename().  Can be called multiple times,\n            and can be used to add to an existing index file.\n  Example : $index->make_index( '/home/seqs1', '/home/seqs2', '/nfs/pub/big_db' );\n  Returns : Number of files indexed\n  Args    : LIST OF FILES\n\n\nsub make_index {\n\tmy($self, @files) = @_;\n\tmy $count = 0;\n\tmy $recs = 0;\n\t# blow up if write flag is not set. EB fix\n\n\tif( !defined $self->write_flag ) {\n\t\t$self->throw(\"Attempting to make an index on a read-only database. What about a WRITE flag on opening the index?\");\n\t}\n\n\t# We're really fussy/lazy, expecting all file names to be fully qualified\n\t$self->throw(\"No files to index provided\") unless @files;\n\tfor(my $i=0;$i<scalar @files; $i++)  {\n\t\tif( $Bio::Root::IO::FILESPECLOADED && File::Spec->can('rel2abs') ) {\n\t\t\tif( ! File::Spec->file_name_is_absolute($files[$i])\n\t\t\t    && $self->pathtype() ne 'relative') {\n\t\t\t\t$files[$i] = File::Spec->rel2abs($files[$i]);\n\t\t\t}\n\t\t} else {\n\t\t\tif(  $^O =~ /MSWin/i ) {\n\t\t\t\t($files[$i] =~ m|^[A-Za-z]:/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\");\n\t\t\t} else {\n\t\t\t\t($files[$i] =~ m|^/|) || \n\t\t\t\t  $self->throw(\"Not an absolute file path '$files[$i]'\"); \n\t\t\t}\n\t\t}\n\t\t$self->throw(\"File does not exist '$files[$i]'\")   unless -e $files[$i];\n\t}\n\n\t# Add each file to the index\n\tFILE :\n\t\t foreach my $file (@files) {\n\n\t\t\t my $i; # index for this file\n\n\t\t\t # Get new index for this file and increment file count\n\t\t\t if ( defined(my $count = $self->_file_count) ) {\n\t\t\t\t $i = $count;\n\t\t\t } else {\n\t\t\t\t $i = 0; $self->_file_count(0);\n        }\n\n\t\t\t # see whether this file has been already indexed\n\t\t\t my ($record,$number,$size);\n\n\t\t\t if( ($record = $self->db->{\"__FILENAME_$file\"}) ) {\n\t\t\t\t ($number,$size) = $self->unpack_record($record);\n\n\t\t\t\t # if it is the same size - fine. Otherwise die \n\t\t\t\t if( -s $file == $size ) {\n\t\t\t\t\t $self->warn(\"File $file already indexed. Skipping...\"); \n\t\t\t\t\t next FILE;\n\t\t\t\t } else {\n\t\t\t\t\t $self->throw(\"In index, $file has changed size ($size). Indicates that the index is out of date\");\n\t\t\t\t }\n\t\t\t }\n\n\t\t\t # index this file\n\t\t\t $self->debug(\"Indexing file $file\\n\");\n\n\t\t\t # this is supplied by the subclass and does the serious work\n\t\t\t $recs += $self->_index_file( $file, $i ); # Specific method for each type of index\n\n\t\t\t # Save file name and size for this index\n\t\t\t $self->add_record(\"__FILE_$i\", $file, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\t\t\t $self->add_record(\"__FILENAME_$file\", $i, -s $file)\n            or $self->throw(\"Can't add data to file: $file\");\n\n\t\t\t # increment file lines\n\t\t\t $i++; $self->_file_count($i);\n\t\t\t my $temp;\n\t\t\t $temp = $self->_file_count();\n\t\t }\n\treturn ($count, $recs);\n}\n\n=head2 pathtype\n\n  Title   : pathtype\n  Usage   : $index->pathtype($pathtype)\n  Function: Set the type of the file path\n            Only two values are supported, 'relative' or 'absolute'.\n            If the user does not give any value, it is set to\n            absolute by default. Thus it mimics the default\n            behavior of Bio::Index::Abstract module.\n  Example : my $index = Bio::Index::Abstract->(-pathtype => 'relative',\n                                               -file     => $file.inx,\n                                              );\n            or\n            $index->pathtype('relative');\n  Returns : Type of the path.\n  Args    : String (relative|absolute)\n\n\nsub pathtype {\n\n    my($self, $type) = @_;\n\n    if(defined($type)){\n\tif($type ne 'absolute' && $type ne 'relative'){\n\t    $self->throw(\"Type of path can only be 'relative' or 'absolute', not [$type].\");\n\t}\n\t$self->{'_filepathtype'} = $type;\n    }\t\n\n    return $self->{'_filepathtype'};\n}\n\n\n=head2 _filename\n\n  Title   : _filename\n  Usage   : $index->_filename( FILE INT )\n  Function: Indexes the file\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy $self = shift;\n\n\tmy $pkg = ref($self);\n\t$self->throw(\"Error: '$pkg' does not provide the _index_file() method\");\n}\n\n\n\n=head2 _file_handle\n\n  Title   : _file_handle\n  Usage   : $fh = $index->_file_handle( INT )\n  Function: Returns an open filehandle for the file\n            index INT.  On opening a new filehandle it\n            caches it in the @{$index->_filehandle} array.\n            If the requested filehandle is already open,\n            it simply returns it from the array.\n  Example : $fist_file_indexed = $index->_file_handle( 0 );\n  Returns : ref to a filehandle\n  Args    : INT\n\n\nsub _file_handle {\n\tmy( $self, $i ) = @_;\n\n\tunless ($self->{'_filehandle'}[$i]) {\n\t\tmy @rec = $self->unpack_record($self->db->{\"__FILE_$i\"})\n\t\t  or $self->throw(\"Can't get filename for index : $i\");\n\t\tmy $file = $rec[0];\n#\t\tmy $fh = Symbol::gensym();\n#\t\topen $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\topen my $fh, '<', $file or $self->throw(\"Can't read file '$file' : $!\");\n\t\t$self->{'_filehandle'}[$i] = $fh; # Cache filehandle\n\t}\n\treturn $self->{'_filehandle'}[$i];\n}\n\n\n=head2 _file_count\n\n  Title   : _file_count\n  Usage   : $index->_file_count( INT )\n  Function: Used by the index building sub in a sub class to\n            track the number of files indexed.  Sets or gets\n            the number of files indexed when called with or\n            without an argument.\n  Example : \n  Returns : INT\n  Args    : INT\n\n\nsub _file_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->db->{'__FILE_COUNT'} = shift;\n\t}\n\treturn $self->db->{'__FILE_COUNT'};\n}\n\n\n=head2 add_record\n\n  Title   : add_record\n  Usage   : $index->add_record( $id, @stuff );\n  Function: Calls pack_record on @stuff, and adds the result\n            of pack_record to the index database under key $id.\n            If $id is a reference to an array, then a new entry\n            is added under a key corresponding to each element\n            of the array.\n  Example : $index->add_record( $id, $fileNumber, $begin, $end )\n  Returns : TRUE on success or FALSE on failure\n  Args    : ID LIST\n\n\nsub add_record {\n\tmy( $self, $id, @rec ) = @_;\n\t$self->debug( \"Adding key $id\\n\");\n\tif( exists $self->db->{$id} ) {\n\t\t$self->warn(\"overwriting a current value stored for $id\\n\");\n\t}\n\t$self->db->{$id} = $self->pack_record( @rec );\n\treturn 1;\n}\n\n\n=head2 pack_record\n\n  Title   : pack_record\n  Usage   : $packed_string = $index->pack_record( LIST )\n  Function: Packs an array of scalars into a single string\n            joined by ASCII 034 (which is unlikely to be used\n            in any of the strings), and returns it. \n  Example : $packed_string = $index->pack_record( $fileNumber, $begin, $end )\n  Returns : STRING or undef\n  Args    : LIST\n\n\nsub pack_record {\n\tmy( $self, @args ) = @_;\n\treturn join \"\\034\", @args;\n}\n\n=head2 unpack_record\n\n  Title   : unpack_record\n  Usage   : $index->unpack_record( STRING )\n  Function: Splits the sting provided into an array,\n            splitting on ASCII 034.\n  Example : ( $fileNumber, $begin, $end ) = $index->unpack_record( $self->db->{$id} )\n  Returns : A 3 element ARRAY\n  Args    : STRING containing ASCII 034\n\n\nsub unpack_record {\n\tmy( $self, @args ) = @_;\n\treturn split /\\034/, $args[0];\n}\n\n=head2 count_records\n\n Title   : count_records\n Usage   : $recs = $seqdb->count_records()\n Function: return count of all recs in the index \n Example :\n Returns : a scalar\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"count_records($self,@args)"},"range":{"end":{"line":821,"character":9999},"start":{"line":809,"character":0}},"kind":12,"line":809},{"range":{"start":{"line":836,"character":0},"end":{"character":9999,"line":839}},"kind":12,"line":836,"containerName":"main::","name":"DESTROY","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"DESTROY","name":"$self","line":837},{"line":838,"kind":13,"containerName":"DESTROY","name":"$self"}],"definition":"sub"}],"version":5}