{"version":5,"vars":[{"line":63,"name":"base","containerName":"","kind":2},{"signature":{"label":"_initialize($self,%arg)","documentation":"","parameters":[{"label":"$self"},{"label":"%arg"}]},"range":{"start":{"character":0,"line":77},"end":{"line":87,"character":9999}},"kind":12,"line":77,"detail":"($self,%arg)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"definition":"my","line":78,"localvar":"my","containerName":"_initialize","kind":13,"name":"$self"},{"line":78,"name":"%arg","kind":13,"containerName":"_initialize"},{"line":80,"name":"$self","kind":13,"containerName":"_initialize"},{"line":80,"kind":13,"containerName":"_initialize","name":"%arg"},{"line":81,"name":"$self","kind":13,"containerName":"_initialize"},{"line":81,"name":"xml_parser","kind":12,"containerName":"_initialize"},{"line":81,"kind":12,"containerName":"_initialize","name":"new"},{"line":82,"name":"$buf","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"line":83,"containerName":"_initialize","kind":13,"name":"$buf"},{"name":"$self","containerName":"_initialize","kind":13,"line":83},{"name":"_readline","containerName":"_initialize","kind":12,"line":83},{"line":83,"name":"$buf","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$self","line":86},{"line":86,"kind":12,"containerName":"_initialize","name":"_pushback"},{"containerName":"_initialize","kind":13,"name":"$buf","line":86}]},{"line":78,"name":"XPath","kind":2,"containerName":"Bio::SeqFeature::Annotated::Bio::OntologyIO::Bio::Annotation::Comment::Bio::Annotation::DBLink::Bio::Annotation::OntologyTerm::Bio::Annotation::SimpleValue::Bio::Annotation::Target::URI::Escape::XML::DOM::XML::DOM"},{"line":80,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":81,"name":"XML","kind":12,"containerName":"DOM::Parser"},{"range":{"start":{"line":89,"character":0},"end":{"line":164,"character":9999}},"kind":12,"line":89,"name":"next_feature","containerName":"main::","children":[{"line":90,"name":"$self","containerName":"next_feature","localvar":"my","kind":13,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_feature","name":"$buf","line":91},{"line":92,"containerName":"next_feature","localvar":"my","kind":13,"name":"$ok","definition":"my"},{"name":"$record","localvar":"my","containerName":"next_feature","kind":13,"line":93,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_feature","name":"$f","line":96},{"name":"$self","kind":13,"containerName":"next_feature","line":96},{"line":96,"name":"_shift_feature_buffer","kind":12,"containerName":"next_feature"},{"line":97,"containerName":"next_feature","kind":13,"name":"$f"},{"line":98,"name":"$f","containerName":"next_feature","kind":13},{"localvar":"my","containerName":"next_feature","kind":13,"name":"$buf","line":101,"definition":"my"},{"kind":13,"containerName":"next_feature","name":"$self","line":101},{"line":101,"kind":12,"containerName":"next_feature","name":"_readline"},{"name":"$ok","containerName":"next_feature","kind":13,"line":102},{"name":"$buf","kind":13,"containerName":"next_feature","line":102},{"line":103,"name":"$record","kind":13,"containerName":"next_feature"},{"containerName":"next_feature","kind":13,"name":"$buf","line":103},{"line":104,"name":"$buf","containerName":"next_feature","kind":13},{"containerName":"next_feature","kind":13,"name":"$ok","line":106},{"definition":"my","line":108,"kind":13,"localvar":"my","containerName":"next_feature","name":"$dom"},{"name":"$self","kind":13,"containerName":"next_feature","line":108},{"name":"xml_parser","kind":12,"containerName":"next_feature","line":108},{"line":108,"name":"parse","containerName":"next_feature","kind":12},{"line":108,"name":"$record","kind":13,"containerName":"next_feature"},{"definition":"my","containerName":"next_feature","localvar":"my","kind":13,"name":"$pNode","line":111},{"line":111,"containerName":"next_feature","kind":13,"name":"$dom"},{"line":111,"containerName":"next_feature","kind":12,"name":"findnodes"},{"localvar":"my","kind":13,"containerName":"next_feature","name":"@iNodes","line":113,"definition":"my"},{"line":113,"name":"$pNode","containerName":"next_feature","kind":13},{"name":"findnodes","containerName":"next_feature","kind":12,"line":113},{"definition":"my","kind":13,"localvar":"my","containerName":"next_feature","name":"$iNode","line":115},{"line":115,"containerName":"next_feature","kind":13,"name":"@iNodes"},{"containerName":"next_feature","localvar":"my","kind":13,"name":"@cNodes","line":116,"definition":"my"},{"line":116,"name":"$iNode","kind":13,"containerName":"next_feature"},{"line":116,"name":"findnodes","kind":12,"containerName":"next_feature"},{"definition":"my","line":117,"name":"@mNodes","kind":13,"localvar":"my","containerName":"next_feature"},{"name":"$iNode","kind":13,"containerName":"next_feature","line":117},{"line":117,"name":"findnodes","kind":12,"containerName":"next_feature"},{"definition":"my","line":123,"name":"$mNode","kind":13,"localvar":"my","containerName":"next_feature"},{"name":"@mNodes","kind":13,"containerName":"next_feature","line":123},{"definition":"my","localvar":"my","kind":13,"containerName":"next_feature","name":"@lNodes","line":124},{"line":124,"kind":13,"containerName":"next_feature","name":"$mNode"},{"line":124,"containerName":"next_feature","kind":12,"name":"findnodes"},{"definition":"my","name":"$lNode","localvar":"my","containerName":"next_feature","kind":13,"line":125},{"name":"@lNodes","containerName":"next_feature","kind":13,"line":125},{"containerName":"next_feature","localvar":"my","kind":13,"name":"$feature","line":126,"definition":"my"},{"line":126,"name":"new","containerName":"next_feature","kind":12},{"line":127,"name":"$lNode","containerName":"next_feature","kind":13},{"name":"getAttribute","containerName":"next_feature","kind":12,"line":127},{"kind":13,"containerName":"next_feature","name":"$lNode","line":128},{"name":"getAttribute","kind":12,"containerName":"next_feature","line":128},{"line":129,"name":"$lNode","containerName":"next_feature","kind":13},{"line":129,"containerName":"next_feature","kind":12,"name":"getAttribute"},{"line":132,"kind":13,"containerName":"next_feature","name":"$feature"},{"containerName":"next_feature","kind":12,"name":"seq_id","line":132},{"line":132,"containerName":"next_feature","kind":12,"name":"value"},{"line":132,"name":"$pNode","kind":13,"containerName":"next_feature"},{"line":132,"kind":12,"containerName":"next_feature","name":"getAttribute"},{"line":136,"kind":13,"containerName":"next_feature","name":"$feature"},{"kind":12,"containerName":"next_feature","name":"source","line":136},{"line":136,"name":"$lNode","containerName":"next_feature","kind":13},{"line":136,"name":"getAttribute","containerName":"next_feature","kind":12},{"definition":"my","line":138,"name":"$t","localvar":"my","containerName":"next_feature","kind":13},{"line":138,"kind":12,"containerName":"next_feature","name":"new"},{"line":139,"name":"$feature","containerName":"next_feature","kind":13},{"line":139,"kind":12,"containerName":"next_feature","name":"add_Annotation"},{"line":139,"kind":13,"containerName":"next_feature","name":"$t"},{"line":141,"name":"$c","localvar":"my","containerName":"next_feature","kind":13,"definition":"my"},{"line":141,"name":"new","kind":12,"containerName":"next_feature"},{"kind":13,"containerName":"next_feature","name":"$iNode","line":141},{"kind":12,"containerName":"next_feature","name":"getAttribute","line":141},{"line":142,"kind":13,"containerName":"next_feature","name":"$feature"},{"line":142,"name":"add_Annotation","containerName":"next_feature","kind":12},{"kind":13,"containerName":"next_feature","name":"$c","line":142},{"line":144,"containerName":"next_feature","localvar":"my","kind":13,"name":"$d","definition":"my"},{"line":144,"containerName":"next_feature","kind":12,"name":"new"},{"kind":13,"containerName":"next_feature","name":"$d","line":145},{"line":145,"containerName":"next_feature","kind":12,"name":"database"},{"line":145,"containerName":"next_feature","kind":13,"name":"$mNode"},{"name":"getAttribute","containerName":"next_feature","kind":12,"line":145},{"line":146,"name":"$d","kind":13,"containerName":"next_feature"},{"line":146,"name":"primary_id","kind":12,"containerName":"next_feature"},{"name":"$mNode","containerName":"next_feature","kind":13,"line":146},{"containerName":"next_feature","kind":12,"name":"getAttribute","line":146},{"line":147,"name":"$d","kind":13,"containerName":"next_feature"},{"line":147,"name":"optional_id","kind":12,"containerName":"next_feature"},{"line":147,"name":"$mNode","kind":13,"containerName":"next_feature"},{"name":"getAttribute","kind":12,"containerName":"next_feature","line":147},{"kind":13,"containerName":"next_feature","name":"$feature","line":148},{"line":148,"kind":12,"containerName":"next_feature","name":"annotation"},{"line":148,"name":"add_Annotation","kind":12,"containerName":"next_feature"},{"line":148,"kind":13,"containerName":"next_feature","name":"$d"},{"line":150,"kind":13,"localvar":"my","containerName":"next_feature","name":"$s","definition":"my"},{"line":150,"containerName":"next_feature","kind":12,"name":"new"},{"line":150,"name":"$lNode","kind":13,"containerName":"next_feature"},{"line":150,"containerName":"next_feature","kind":12,"name":"getAttribute"},{"line":151,"name":"$feature","containerName":"next_feature","kind":13},{"line":151,"name":"annotation","containerName":"next_feature","kind":12},{"line":151,"name":"add_Annotation","containerName":"next_feature","kind":12},{"containerName":"next_feature","kind":13,"name":"$s","line":151},{"definition":"my","line":153,"localvar":"my","kind":13,"containerName":"next_feature","name":"$cNode"},{"line":153,"name":"@cNodes","containerName":"next_feature","kind":13},{"line":154,"localvar":"my","containerName":"next_feature","kind":13,"name":"$o","definition":"my"},{"line":154,"name":"new","kind":12,"containerName":"next_feature"},{"containerName":"next_feature","kind":13,"name":"$cNode","line":154},{"line":154,"name":"getAttribute","containerName":"next_feature","kind":12},{"line":155,"name":"$feature","kind":13,"containerName":"next_feature"},{"name":"annotation","containerName":"next_feature","kind":12,"line":155},{"line":155,"containerName":"next_feature","kind":12,"name":"add_Annotation"},{"line":155,"name":"$o","kind":13,"containerName":"next_feature"},{"kind":13,"containerName":"next_feature","name":"$self","line":158},{"kind":12,"containerName":"next_feature","name":"_push_feature_buffer","line":158},{"kind":13,"containerName":"next_feature","name":"$feature","line":158},{"containerName":"next_feature","kind":13,"name":"$self","line":163},{"containerName":"next_feature","kind":12,"name":"_shift_feature_buffer","line":163}],"definition":"sub"},{"line":126,"name":"Bio","containerName":"SeqFeature::Annotated","kind":12},{"kind":12,"containerName":"Annotation::OntologyTerm","name":"Bio","line":138},{"containerName":"Annotation::Comment","kind":12,"name":"Bio","line":141},{"name":"Bio","containerName":"Annotation::DBLink","kind":12,"line":144},{"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue","line":150},{"name":"Bio","kind":12,"containerName":"Annotation::OntologyTerm","line":154},{"range":{"start":{"line":176,"character":0},"end":{"line":181,"character":9999}},"kind":12,"line":176,"signature":{"label":"_push_feature_buffer($self,$f)","documentation":"1;\n\n=head1 NAME\n\nBio::FeatureIO::interpro - read features from InterPro XML\n\n=head1 SYNOPSIS\n\n  my $in = Bio::FeatureIO(-format=>'interpro');\n  while (my $feat = $in->next_feature) {\n    # do something with the Bio::SeqFeatureI object\n  }\n\n=head1 DESCRIPTION\n\nSee L<http://www.ebi.ac.uk/interpro/documentation.html>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::interpro;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Annotated;\nuse Bio::OntologyIO;\n\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\n\nuse URI::Escape;\nuse XML::DOM;\nuse XML::DOM::XPath;\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n  $self->xml_parser(XML::DOM::Parser->new());\n  my $buf;\n  while(($buf = $self->_readline()) && $buf !~ /<protein/){\n    next;\n  }\n  $self->_pushback($buf);\n}\n\nsub next_feature {\n  my $self =shift;\n  my $buf;    #line buffer\n  my $ok = 0; #true if there is another <protein/> record in stream\n  my $record; #holds the record to be parsed and returned.\n\n  #try to dump buffer from last record before moving on to next record\n  my $f = $self->_shift_feature_buffer();\n  if($f){\n    return $f;\n  }\n\n  while(my $buf = $self->_readline()){\n    $ok = 1 if $buf =~ m!<protein!;\n    $record .= $buf;\n    last if $buf =~ m!</protein>!;\n  }\n  return unless $ok;\n\n  my $dom = $self->xml_parser->parse($record);\n\n\n  my ($pNode) = $dom->findnodes('/protein');\n\n  my @iNodes = $pNode->findnodes('/protein/interpro');\n\n  foreach my $iNode (@iNodes){\n    my @cNodes = $iNode->findnodes('classification');\n    my @mNodes = $iNode->findnodes('match');\n\n    #we don't handle these\n    #my @nNodes = $iNode->findnodes('contains');\n    #my @fNodes = $iNode->findnodes('found_in');\n\n    foreach my $mNode (@mNodes){\n      my @lNodes = $mNode->findnodes('location');\n      foreach my $lNode (@lNodes){\n        my $feature = Bio::SeqFeature::Annotated->new(\n                                                      -start  => $lNode->getAttribute('start'),\n                                                      -end    => $lNode->getAttribute('end'),\n                                                      -score  => $lNode->getAttribute('score'),\n#                                                      -seq_id => $pNode->getAttribute('id'),\n                                                     );\n        $feature->seq_id->value($pNode->getAttribute('id'));\n\n#warn $pNode->getAttribute('id');\n\n        $feature->source( $lNode->getAttribute('evidence') );\n\n        my $t = Bio::Annotation::OntologyTerm->new(-identifier => 'SO:0000417', -name => 'polypeptide_domain');\n        $feature->add_Annotation('type',$t);\n\n        my $c = Bio::Annotation::Comment->new(-tagname => 'comment', -text => $iNode->getAttribute('name'));\n        $feature->add_Annotation($c);\n\n        my $d = Bio::Annotation::DBLink->new();\n        $d->database($mNode->getAttribute('dbname'));\n        $d->primary_id($mNode->getAttribute('id'));\n        $d->optional_id($mNode->getAttribute('name'));\n        $feature->annotation->add_Annotation('dblink',$d);\n\n        my $s = Bio::Annotation::SimpleValue->new(-tagname => 'status', -value => $lNode->getAttribute('status'));\n        $feature->annotation->add_Annotation($s);\n\n        foreach my $cNode (@cNodes){\n          my $o = Bio::Annotation::OntologyTerm->new(-identifier => $cNode->getAttribute('id'));\n          $feature->annotation->add_Annotation('ontology_term',$o);\n        }\n\n        $self->_push_feature_buffer($feature);\n      }\n    }\n  }\n\n  return $self->_shift_feature_buffer;\n}\n\n=head2 _push_feature_buffer()\n\n Usage   :\n Function:\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$f"}]},"name":"_push_feature_buffer","containerName":"main::","children":[{"line":177,"name":"$self","kind":13,"localvar":"my","containerName":"_push_feature_buffer","definition":"my"},{"containerName":"_push_feature_buffer","kind":13,"name":"$f","line":177},{"line":179,"name":"$f","kind":13,"containerName":"_push_feature_buffer"},{"line":180,"name":"$self","kind":13,"containerName":"_push_feature_buffer"},{"line":180,"name":"$f","containerName":"_push_feature_buffer","kind":13}],"detail":"($self,$f)","definition":"sub"},{"line":180,"name":"feature_buffer","kind":12},{"kind":12,"range":{"start":{"character":0,"line":194},"end":{"line":196,"character":9999}},"line":194,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n\n=head1 NAME\n\nBio::FeatureIO::interpro - read features from InterPro XML\n\n=head1 SYNOPSIS\n\n  my $in = Bio::FeatureIO(-format=>'interpro');\n  while (my $feat = $in->next_feature) {\n    # do something with the Bio::SeqFeatureI object\n  }\n\n=head1 DESCRIPTION\n\nSee L<http://www.ebi.ac.uk/interpro/documentation.html>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::interpro;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Annotated;\nuse Bio::OntologyIO;\n\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\n\nuse URI::Escape;\nuse XML::DOM;\nuse XML::DOM::XPath;\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n  $self->xml_parser(XML::DOM::Parser->new());\n  my $buf;\n  while(($buf = $self->_readline()) && $buf !~ /<protein/){\n    next;\n  }\n  $self->_pushback($buf);\n}\n\nsub next_feature {\n  my $self =shift;\n  my $buf;    #line buffer\n  my $ok = 0; #true if there is another <protein/> record in stream\n  my $record; #holds the record to be parsed and returned.\n\n  #try to dump buffer from last record before moving on to next record\n  my $f = $self->_shift_feature_buffer();\n  if($f){\n    return $f;\n  }\n\n  while(my $buf = $self->_readline()){\n    $ok = 1 if $buf =~ m!<protein!;\n    $record .= $buf;\n    last if $buf =~ m!</protein>!;\n  }\n  return unless $ok;\n\n  my $dom = $self->xml_parser->parse($record);\n\n\n  my ($pNode) = $dom->findnodes('/protein');\n\n  my @iNodes = $pNode->findnodes('/protein/interpro');\n\n  foreach my $iNode (@iNodes){\n    my @cNodes = $iNode->findnodes('classification');\n    my @mNodes = $iNode->findnodes('match');\n\n    #we don't handle these\n    #my @nNodes = $iNode->findnodes('contains');\n    #my @fNodes = $iNode->findnodes('found_in');\n\n    foreach my $mNode (@mNodes){\n      my @lNodes = $mNode->findnodes('location');\n      foreach my $lNode (@lNodes){\n        my $feature = Bio::SeqFeature::Annotated->new(\n                                                      -start  => $lNode->getAttribute('start'),\n                                                      -end    => $lNode->getAttribute('end'),\n                                                      -score  => $lNode->getAttribute('score'),\n#                                                      -seq_id => $pNode->getAttribute('id'),\n                                                     );\n        $feature->seq_id->value($pNode->getAttribute('id'));\n\n#warn $pNode->getAttribute('id');\n\n        $feature->source( $lNode->getAttribute('evidence') );\n\n        my $t = Bio::Annotation::OntologyTerm->new(-identifier => 'SO:0000417', -name => 'polypeptide_domain');\n        $feature->add_Annotation('type',$t);\n\n        my $c = Bio::Annotation::Comment->new(-tagname => 'comment', -text => $iNode->getAttribute('name'));\n        $feature->add_Annotation($c);\n\n        my $d = Bio::Annotation::DBLink->new();\n        $d->database($mNode->getAttribute('dbname'));\n        $d->primary_id($mNode->getAttribute('id'));\n        $d->optional_id($mNode->getAttribute('name'));\n        $feature->annotation->add_Annotation('dblink',$d);\n\n        my $s = Bio::Annotation::SimpleValue->new(-tagname => 'status', -value => $lNode->getAttribute('status'));\n        $feature->annotation->add_Annotation($s);\n\n        foreach my $cNode (@cNodes){\n          my $o = Bio::Annotation::OntologyTerm->new(-identifier => $cNode->getAttribute('id'));\n          $feature->annotation->add_Annotation('ontology_term',$o);\n        }\n\n        $self->_push_feature_buffer($feature);\n      }\n    }\n  }\n\n  return $self->_shift_feature_buffer;\n}\n\n=head2 _push_feature_buffer()\n\n Usage   :\n Function:\n Returns : \n Args    :\n\n\n\nsub _push_feature_buffer {\n  my ($self,$f) = @_;\n\n  if(ref($f)){\n    push @{ $self->{feature_buffer} }, $f;\n  }\n}\n\n=head2 _shift_feature_buffer()\n\n Usage   :\n Function:\n Returns : \n Args    :","label":"_shift_feature_buffer($self)"},"name":"_shift_feature_buffer","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_shift_feature_buffer","name":"$self","line":195},{"line":196,"name":"$self","containerName":"_shift_feature_buffer","kind":13},{"name":"$self","kind":13,"containerName":"_shift_feature_buffer","line":196}],"detail":"($self)","definition":"sub"},{"kind":12,"name":"feature_buffer","line":196},{"name":"feature_buffer","kind":12,"line":196},{"children":[{"line":211,"name":"$self","localvar":"my","kind":13,"containerName":"xml_parser","definition":"my"},{"containerName":"xml_parser","kind":13,"name":"$val","line":211},{"kind":13,"containerName":"xml_parser","name":"$self","line":212},{"name":"$val","kind":13,"containerName":"xml_parser","line":212},{"name":"$val","kind":13,"containerName":"xml_parser","line":212},{"line":213,"containerName":"xml_parser","kind":13,"name":"$self"}],"name":"xml_parser","containerName":"main::","definition":"sub","detail":"($self,$val)","line":210,"kind":12,"range":{"start":{"character":0,"line":210},"end":{"character":9999,"line":214}},"signature":{"label":"xml_parser($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n\n=head1 NAME\n\nBio::FeatureIO::interpro - read features from InterPro XML\n\n=head1 SYNOPSIS\n\n  my $in = Bio::FeatureIO(-format=>'interpro');\n  while (my $feat = $in->next_feature) {\n    # do something with the Bio::SeqFeatureI object\n  }\n\n=head1 DESCRIPTION\n\nSee L<http://www.ebi.ac.uk/interpro/documentation.html>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::interpro;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Annotated;\nuse Bio::OntologyIO;\n\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\n\nuse URI::Escape;\nuse XML::DOM;\nuse XML::DOM::XPath;\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n  $self->xml_parser(XML::DOM::Parser->new());\n  my $buf;\n  while(($buf = $self->_readline()) && $buf !~ /<protein/){\n    next;\n  }\n  $self->_pushback($buf);\n}\n\nsub next_feature {\n  my $self =shift;\n  my $buf;    #line buffer\n  my $ok = 0; #true if there is another <protein/> record in stream\n  my $record; #holds the record to be parsed and returned.\n\n  #try to dump buffer from last record before moving on to next record\n  my $f = $self->_shift_feature_buffer();\n  if($f){\n    return $f;\n  }\n\n  while(my $buf = $self->_readline()){\n    $ok = 1 if $buf =~ m!<protein!;\n    $record .= $buf;\n    last if $buf =~ m!</protein>!;\n  }\n  return unless $ok;\n\n  my $dom = $self->xml_parser->parse($record);\n\n\n  my ($pNode) = $dom->findnodes('/protein');\n\n  my @iNodes = $pNode->findnodes('/protein/interpro');\n\n  foreach my $iNode (@iNodes){\n    my @cNodes = $iNode->findnodes('classification');\n    my @mNodes = $iNode->findnodes('match');\n\n    #we don't handle these\n    #my @nNodes = $iNode->findnodes('contains');\n    #my @fNodes = $iNode->findnodes('found_in');\n\n    foreach my $mNode (@mNodes){\n      my @lNodes = $mNode->findnodes('location');\n      foreach my $lNode (@lNodes){\n        my $feature = Bio::SeqFeature::Annotated->new(\n                                                      -start  => $lNode->getAttribute('start'),\n                                                      -end    => $lNode->getAttribute('end'),\n                                                      -score  => $lNode->getAttribute('score'),\n#                                                      -seq_id => $pNode->getAttribute('id'),\n                                                     );\n        $feature->seq_id->value($pNode->getAttribute('id'));\n\n#warn $pNode->getAttribute('id');\n\n        $feature->source( $lNode->getAttribute('evidence') );\n\n        my $t = Bio::Annotation::OntologyTerm->new(-identifier => 'SO:0000417', -name => 'polypeptide_domain');\n        $feature->add_Annotation('type',$t);\n\n        my $c = Bio::Annotation::Comment->new(-tagname => 'comment', -text => $iNode->getAttribute('name'));\n        $feature->add_Annotation($c);\n\n        my $d = Bio::Annotation::DBLink->new();\n        $d->database($mNode->getAttribute('dbname'));\n        $d->primary_id($mNode->getAttribute('id'));\n        $d->optional_id($mNode->getAttribute('name'));\n        $feature->annotation->add_Annotation('dblink',$d);\n\n        my $s = Bio::Annotation::SimpleValue->new(-tagname => 'status', -value => $lNode->getAttribute('status'));\n        $feature->annotation->add_Annotation($s);\n\n        foreach my $cNode (@cNodes){\n          my $o = Bio::Annotation::OntologyTerm->new(-identifier => $cNode->getAttribute('id'));\n          $feature->annotation->add_Annotation('ontology_term',$o);\n        }\n\n        $self->_push_feature_buffer($feature);\n      }\n    }\n  }\n\n  return $self->_shift_feature_buffer;\n}\n\n=head2 _push_feature_buffer()\n\n Usage   :\n Function:\n Returns : \n Args    :\n\n\n\nsub _push_feature_buffer {\n  my ($self,$f) = @_;\n\n  if(ref($f)){\n    push @{ $self->{feature_buffer} }, $f;\n  }\n}\n\n=head2 _shift_feature_buffer()\n\n Usage   :\n Function:\n Returns : \n Args    :\n\n\n\nsub _shift_feature_buffer {\n  my ($self) = @_;\n  return $self->{feature_buffer} ? shift @{ $self->{feature_buffer} } : undef;\n}\n\n=head2 xml_parser()\n\n Usage   : $obj->xml_parser($newval)\n Function: \n Example : \n Returns : value of xml_parser (a scalar)\n Args    : on set, new value (a scalar or undef, optional)"}}]}