{"version":5,"vars":[{"line":1,"kind":12,"name":"pod"},{"line":93,"containerName":"","kind":2,"name":"base"},{"definition":1,"line":95,"name":"DEFAULT_VERSION","containerName":"main::","kind":14},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$RESERVED_TAGS","line":96},{"definition":"sub","detail":"($self,%arg)","children":[{"line":99,"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"name":"%arg","kind":13,"containerName":"_initialize","line":99},{"name":"$self","containerName":"_initialize","kind":13,"line":101},{"line":101,"name":"%arg","containerName":"_initialize","kind":13},{"line":103,"kind":13,"containerName":"_initialize","name":"$self"},{"line":103,"containerName":"_initialize","kind":12,"name":"version"},{"line":103,"containerName":"_initialize","kind":13,"name":"$arg"},{"line":104,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"validate","containerName":"_initialize","kind":12,"line":104},{"kind":13,"containerName":"_initialize","name":"$arg","line":104},{"name":"$arg","kind":13,"containerName":"_initialize","line":106},{"line":107,"containerName":"_initialize","kind":13,"name":"$self"},{"line":107,"kind":12,"containerName":"_initialize","name":"_print"},{"containerName":"_initialize","kind":13,"name":"$self","line":107},{"kind":12,"containerName":"_initialize","name":"version","line":107},{"name":"$directive","containerName":"_initialize","localvar":"my","kind":13,"line":110,"definition":"my"},{"name":"$directive","kind":13,"containerName":"_initialize","line":111},{"name":"$self","kind":13,"containerName":"_initialize","line":111},{"line":111,"name":"_readline","containerName":"_initialize","kind":12},{"line":111,"name":"$directive","kind":13,"containerName":"_initialize"},{"line":112,"name":"$self","containerName":"_initialize","kind":13},{"name":"_handle_directive","kind":12,"containerName":"_initialize","line":112},{"line":112,"name":"$directive","kind":13,"containerName":"_initialize"},{"line":114,"name":"$self","containerName":"_initialize","kind":13},{"name":"_pushback","kind":12,"containerName":"_initialize","line":114},{"name":"$directive","containerName":"_initialize","kind":13,"line":114},{"name":"$self","kind":13,"containerName":"_initialize","line":118},{"name":"validate","containerName":"_initialize","kind":12,"line":118},{"line":119,"name":"$self","kind":13,"containerName":"_initialize"},{"line":119,"name":"so","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":12,"name":"get_ontology","line":120}],"containerName":"main::","name":"_initialize","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"%arg"}],"label":"_initialize($self,%arg)"},"line":98,"range":{"end":{"character":9999,"line":123},"start":{"character":0,"line":98}},"kind":12},{"line":101,"containerName":"_initialize","kind":12,"name":"SUPER"},{"line":103,"name":"DEFAULT_VERSION","kind":12},{"line":120,"kind":12,"containerName":"Ontology::OntologyStore","name":"Bio"},{"range":{"end":{"line":173,"character":9999},"start":{"line":134,"character":0}},"kind":12,"line":134,"definition":"sub","name":"next_feature","containerName":"main::","children":[{"name":"$self","containerName":"next_feature","localvar":"my","kind":13,"line":135,"definition":"my"},{"line":136,"name":"$gff_string","localvar":"my","containerName":"next_feature","kind":13,"definition":"my"},{"definition":"my","name":"$f","localvar":"my","containerName":"next_feature","kind":13,"line":138},{"kind":13,"containerName":"next_feature","name":"$self","line":138},{"line":138,"name":"_buffer_feature","kind":12,"containerName":"next_feature"},{"line":139,"containerName":"next_feature","kind":13,"name":"$f"},{"line":140,"containerName":"next_feature","kind":13,"name":"$f"},{"kind":13,"containerName":"next_feature","name":"$self","line":143},{"line":143,"name":"fasta_mode","containerName":"next_feature","kind":12},{"line":147,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"containerName":"next_feature","kind":13,"name":"$self","line":147},{"name":"_readline","kind":12,"containerName":"next_feature","line":147},{"line":147,"name":"$gff_string","kind":13,"containerName":"next_feature"},{"line":148,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"line":149,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"line":153,"name":"$gff_string","kind":13,"containerName":"next_feature"},{"name":"$gff_string","containerName":"next_feature","kind":13,"line":156},{"line":157,"kind":13,"containerName":"next_feature","name":"$self"},{"line":157,"containerName":"next_feature","kind":12,"name":"_pushback"},{"line":157,"name":"$gff_string","containerName":"next_feature","kind":13},{"name":"$self","kind":13,"containerName":"next_feature","line":158},{"line":158,"containerName":"next_feature","kind":12,"name":"fasta_mode"},{"line":163,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"name":"$self","kind":13,"containerName":"next_feature","line":164},{"line":164,"name":"_handle_directive","containerName":"next_feature","kind":12},{"name":"$gff_string","kind":13,"containerName":"next_feature","line":164},{"kind":13,"containerName":"next_feature","name":"$self","line":166},{"name":"next_feature","containerName":"next_feature","kind":12,"line":166},{"line":171,"containerName":"next_feature","kind":13,"name":"$self"},{"line":171,"name":"_handle_feature","containerName":"next_feature","kind":12},{"line":171,"name":"$gff_string","kind":13,"containerName":"next_feature"}]},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next_feature_group","line":198,"definition":"my"},{"name":"$feat","localvar":"my","kind":13,"containerName":"next_feature_group","line":200,"definition":"my"},{"line":201,"localvar":"my","kind":13,"containerName":"next_feature_group","name":"%seen_ids","definition":"my"},{"name":"@all_feats","kind":13,"localvar":"my","containerName":"next_feature_group","line":202,"definition":"my"},{"localvar":"my","kind":13,"containerName":"next_feature_group","name":"@toplevel_feats","line":203,"definition":"my"},{"line":205,"kind":13,"containerName":"next_feature_group","name":"$self"},{"name":"$self","containerName":"next_feature_group","kind":13,"line":207},{"line":207,"name":"$feat","kind":13,"containerName":"next_feature_group"},{"kind":13,"containerName":"next_feature_group","name":"$self","line":207},{"line":207,"containerName":"next_feature_group","kind":12,"name":"next_feature"},{"line":207,"kind":13,"containerName":"next_feature_group","name":"$feat"},{"definition":"my","line":210,"containerName":"next_feature_group","localvar":"my","kind":13,"name":"$anno_ID"},{"line":210,"name":"$feat","containerName":"next_feature_group","kind":13},{"line":210,"kind":12,"containerName":"next_feature_group","name":"get_Annotations"},{"line":211,"name":"$anno_ID","kind":13,"containerName":"next_feature_group"},{"line":212,"localvar":"my","kind":13,"containerName":"next_feature_group","name":"$attr_ID","definition":"my"},{"containerName":"next_feature_group","kind":13,"name":"$anno_ID","line":212},{"line":212,"name":"value","containerName":"next_feature_group","kind":12},{"line":213,"name":"$self","containerName":"next_feature_group","kind":13},{"line":213,"kind":12,"containerName":"next_feature_group","name":"throw"},{"line":214,"containerName":"next_feature_group","kind":13,"name":"$seen_ids"},{"line":214,"name":"$attr_ID","kind":13,"containerName":"next_feature_group"},{"line":215,"containerName":"next_feature_group","kind":13,"name":"$seen_ids"},{"name":"$attr_ID","containerName":"next_feature_group","kind":13,"line":215},{"line":215,"name":"$feat","containerName":"next_feature_group","kind":13},{"name":"@all_feats","containerName":"next_feature_group","kind":13,"line":217},{"line":217,"kind":13,"containerName":"next_feature_group","name":"$feat"},{"line":221,"containerName":"next_feature_group","kind":13,"name":"$feat"},{"containerName":"next_feature_group","kind":13,"name":"@all_feats","line":221},{"name":"@parents","localvar":"my","kind":13,"containerName":"next_feature_group","line":222,"definition":"my"},{"line":222,"name":"$feat","kind":13,"containerName":"next_feature_group"},{"line":222,"name":"get_Annotations","kind":12,"containerName":"next_feature_group"},{"name":"@parents","containerName":"next_feature_group","kind":13,"line":223},{"localvar":"my","kind":13,"containerName":"next_feature_group","name":"$parent","line":224,"definition":"my"},{"line":224,"name":"@parents","containerName":"next_feature_group","kind":13},{"definition":"my","localvar":"my","containerName":"next_feature_group","kind":13,"name":"$parent_id","line":225},{"line":225,"name":"$parent","containerName":"next_feature_group","kind":13},{"name":"value","kind":12,"containerName":"next_feature_group","line":225},{"kind":13,"containerName":"next_feature_group","name":"$self","line":226},{"name":"throw","containerName":"next_feature_group","kind":12,"line":226},{"line":226,"kind":13,"containerName":"next_feature_group","name":"$seen_ids"},{"kind":13,"containerName":"next_feature_group","name":"$parent_id","line":226},{"name":"$seen_ids","kind":13,"containerName":"next_feature_group","line":227},{"name":"$parent_id","kind":13,"containerName":"next_feature_group","line":227},{"line":227,"name":"add_SeqFeature","kind":12,"containerName":"next_feature_group"},{"line":227,"name":"$feat","containerName":"next_feature_group","kind":13},{"kind":13,"containerName":"next_feature_group","name":"@toplevel_feats","line":230},{"containerName":"next_feature_group","kind":13,"name":"$feat","line":230},{"name":"@toplevel_feats","kind":13,"containerName":"next_feature_group","line":234}],"containerName":"main::","name":"next_feature_group","definition":"sub","line":197,"range":{"start":{"character":0,"line":197},"end":{"line":235,"character":9999}},"kind":12},{"line":205,"name":"group_not_done","kind":12},{"kind":12,"name":"group_not_done","line":207},{"range":{"end":{"line":253,"character":9999},"start":{"line":244,"character":0}},"kind":12,"line":244,"signature":{"parameters":[],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled","label":"next_seq()"},"containerName":"main::","name":"next_seq","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next_seq","line":245,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_seq","line":246},{"line":246,"kind":12,"containerName":"next_seq","name":"fasta_mode"},{"line":249,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"seqio","containerName":"next_seq","kind":12,"line":249},{"line":250,"kind":13,"containerName":"next_seq","name":"$self"},{"line":250,"containerName":"next_seq","kind":12,"name":"seqio"},{"line":250,"kind":12,"containerName":"next_seq","name":"new"},{"containerName":"next_seq","kind":13,"name":"$self","line":250},{"line":250,"kind":12,"containerName":"next_seq","name":"_fh"},{"line":252,"containerName":"next_seq","kind":13,"name":"$self"},{"name":"seqio","kind":12,"containerName":"next_seq","line":252},{"containerName":"next_seq","kind":12,"name":"next_seq","line":252}],"detail":"()","definition":"sub"},{"kind":12,"containerName":"SeqIO","name":"Bio","line":250},{"range":{"end":{"character":9999,"line":284},"start":{"character":0,"line":266}},"kind":12,"line":266,"signature":{"label":"write_feature($self,$feature)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.","parameters":[{"label":"$self"},{"label":"$feature"}]},"containerName":"main::","name":"write_feature","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"write_feature","line":267},{"line":267,"name":"$feature","containerName":"write_feature","kind":13},{"line":268,"containerName":"write_feature","kind":13,"name":"$feature"},{"line":269,"kind":13,"containerName":"write_feature","name":"$self"},{"line":269,"name":"throw","containerName":"write_feature","kind":12},{"line":271,"name":"$self","kind":13,"containerName":"write_feature"},{"kind":12,"containerName":"write_feature","name":"throw","line":271},{"line":271,"name":"$feature","kind":13,"containerName":"write_feature"},{"name":"isa","kind":12,"containerName":"write_feature","line":271},{"line":273,"containerName":"write_feature","kind":13,"name":"$self"},{"name":"version","containerName":"write_feature","kind":12,"line":273},{"line":274,"kind":13,"containerName":"write_feature","name":"$self"},{"name":"_write_feature_1","containerName":"write_feature","kind":12,"line":274},{"line":274,"name":"$feature","kind":13,"containerName":"write_feature"},{"line":275,"containerName":"write_feature","kind":13,"name":"$self"},{"containerName":"write_feature","kind":12,"name":"version","line":275},{"name":"$self","kind":13,"containerName":"write_feature","line":276},{"containerName":"write_feature","kind":12,"name":"_write_feature_2","line":276},{"line":276,"kind":13,"containerName":"write_feature","name":"$feature"},{"name":"$self","containerName":"write_feature","kind":13,"line":277},{"line":277,"containerName":"write_feature","kind":12,"name":"version"},{"line":278,"name":"$self","containerName":"write_feature","kind":13},{"line":278,"name":"_write_feature_25","containerName":"write_feature","kind":12},{"line":278,"containerName":"write_feature","kind":13,"name":"$feature"},{"line":279,"kind":13,"containerName":"write_feature","name":"$self"},{"line":279,"name":"version","containerName":"write_feature","kind":12},{"kind":13,"containerName":"write_feature","name":"$self","line":280},{"name":"_write_feature_3","containerName":"write_feature","kind":12,"line":280},{"line":280,"containerName":"write_feature","kind":13,"name":"$feature"},{"line":282,"containerName":"write_feature","kind":13,"name":"$self"},{"line":282,"name":"throw","containerName":"write_feature","kind":12},{"name":"$self","containerName":"write_feature","kind":13,"line":282},{"containerName":"write_feature","kind":12,"name":"version","line":282}],"detail":"($self,$feature)","definition":"sub"},{"children":[{"line":304,"name":"$self","containerName":"fasta_mode","localvar":"my","kind":13,"definition":"my"},{"line":304,"kind":13,"containerName":"fasta_mode","name":"$val"},{"name":"$self","kind":13,"containerName":"fasta_mode","line":305},{"containerName":"fasta_mode","kind":13,"name":"$val","line":305},{"name":"$val","kind":13,"containerName":"fasta_mode","line":305},{"name":"$self","kind":13,"containerName":"fasta_mode","line":306}],"name":"fasta_mode","containerName":"main::","definition":"sub","detail":"($self,$val)","line":303,"range":{"start":{"line":303,"character":0},"end":{"character":9999,"line":307}},"kind":12,"signature":{"label":"fasta_mode($self,$val)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}]}},{"children":[{"line":320,"name":"$self","localvar":"my","kind":13,"containerName":"seqio","definition":"my"},{"line":320,"containerName":"seqio","kind":13,"name":"$val"},{"containerName":"seqio","kind":13,"name":"$self","line":321},{"line":321,"containerName":"seqio","kind":13,"name":"$val"},{"name":"$val","kind":13,"containerName":"seqio","line":321},{"name":"$self","kind":13,"containerName":"seqio","line":322}],"containerName":"main::","name":"seqio","definition":"sub","detail":"($self,$val)","line":319,"kind":12,"range":{"start":{"character":0,"line":319},"end":{"character":9999,"line":323}},"signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}],"label":"seqio($self,$val)"}},{"line":335,"range":{"start":{"line":335,"character":0},"end":{"line":347,"character":9999}},"kind":12,"signature":{"label":"sequence_region($self,$k,$v)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$k"},{"label":"$v"}]},"children":[{"line":336,"name":"$self","containerName":"sequence_region","localvar":"my","kind":13,"definition":"my"},{"line":336,"name":"$k","kind":13,"containerName":"sequence_region"},{"kind":13,"containerName":"sequence_region","name":"$v","line":336},{"name":"$k","containerName":"sequence_region","kind":13,"line":337},{"name":"$v","containerName":"sequence_region","kind":13,"line":337},{"line":338,"name":"$self","kind":13,"containerName":"sequence_region"},{"containerName":"sequence_region","kind":13,"name":"$k","line":338},{"line":338,"name":"$v","containerName":"sequence_region","kind":13},{"name":"$v","containerName":"sequence_region","kind":13,"line":339},{"line":341,"kind":13,"containerName":"sequence_region","name":"$k"},{"line":342,"name":"$self","containerName":"sequence_region","kind":13},{"containerName":"sequence_region","kind":13,"name":"$k","line":342}],"containerName":"main::","name":"sequence_region","definition":"sub","detail":"($self,$k,$v)"},{"definition":"sub","containerName":"main::","name":"so","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"so","kind":13,"line":360},{"definition":"my","line":361,"name":"$val","localvar":"my","containerName":"so","kind":13},{"line":363,"name":"$self","containerName":"so","kind":13},{"line":363,"name":"$val","containerName":"so","kind":13},{"line":363,"name":"$val","containerName":"so","kind":13},{"line":364,"name":"$self","kind":13,"containerName":"so"}],"kind":12,"range":{"end":{"line":365,"character":9999},"start":{"character":0,"line":359}},"line":359},{"line":363,"name":"so","kind":12},{"line":364,"name":"so","kind":12},{"signature":{"label":"validate($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)"},"range":{"start":{"line":378,"character":0},"end":{"line":382,"character":9999}},"kind":12,"line":378,"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"validate","children":[{"localvar":"my","kind":13,"containerName":"validate","name":"$self","line":379,"definition":"my"},{"line":379,"name":"$val","containerName":"validate","kind":13},{"name":"$self","containerName":"validate","kind":13,"line":380},{"line":380,"name":"$val","kind":13,"containerName":"validate"},{"line":380,"kind":13,"containerName":"validate","name":"$val"},{"line":381,"name":"$self","containerName":"validate","kind":13}]},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"version","line":394,"definition":"my"},{"name":"$val","localvar":"my","containerName":"version","kind":13,"line":395,"definition":"my"},{"localvar":"my","containerName":"version","kind":13,"name":"%valid","line":396,"definition":"my"},{"line":397,"kind":13,"containerName":"version","name":"$val"},{"line":397,"containerName":"version","kind":13,"name":"$valid"},{"name":"$val","kind":13,"containerName":"version","line":397},{"name":"$self","containerName":"version","kind":13,"line":398},{"line":398,"kind":13,"containerName":"version","name":"$val"},{"name":"$val","kind":13,"containerName":"version","line":400},{"line":401,"name":"$self","kind":13,"containerName":"version"},{"line":401,"kind":12,"containerName":"version","name":"throw"},{"line":401,"kind":13,"containerName":"version","name":"%valid"},{"kind":13,"containerName":"version","name":"$self","line":403}],"name":"version","containerName":"main::","definition":"sub","line":393,"range":{"start":{"line":393,"character":0},"end":{"line":404,"character":9999}},"kind":12},{"line":421,"kind":12,"range":{"start":{"character":0,"line":421},"end":{"character":9999,"line":427}},"signature":{"label":"_buffer_feature($self,$f)","parameters":[{"label":"$self"},{"label":"$f"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :"},"children":[{"definition":"my","line":422,"localvar":"my","kind":13,"containerName":"_buffer_feature","name":"$self"},{"name":"$f","containerName":"_buffer_feature","kind":13,"line":422},{"line":424,"name":"$f","kind":13,"containerName":"_buffer_feature"},{"name":"$self","kind":13,"containerName":"_buffer_feature","line":425},{"name":"$f","containerName":"_buffer_feature","kind":13,"line":425},{"line":426,"name":"$f","kind":13,"containerName":"_buffer_feature"}],"containerName":"main::","name":"_buffer_feature","definition":"sub","detail":"($self,$f)"},{"line":428,"name":"%self","containerName":null,"kind":13},{"line":429,"name":"%self","kind":13,"containerName":null},{"signature":{"label":"_handle_directive($self,$directive_string)","parameters":[{"label":"$self"},{"label":"$directive_string"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'."},"range":{"start":{"line":443,"character":0},"end":{"line":512,"character":9999}},"kind":12,"line":443,"detail":"($self,$directive_string)","definition":"sub","name":"_handle_directive","containerName":"main::","children":[{"definition":"my","line":444,"containerName":"_handle_directive","localvar":"my","kind":13,"name":"$self"},{"line":444,"name":"$directive_string","kind":13,"containerName":"_handle_directive"},{"name":"$directive_string","containerName":"_handle_directive","kind":13,"line":446},{"definition":"my","line":447,"kind":13,"localvar":"my","containerName":"_handle_directive","name":"$directive"},{"name":"@arg","containerName":"_handle_directive","kind":13,"line":447},{"containerName":"_handle_directive","kind":13,"name":"$directive_string","line":447},{"name":"$directive","containerName":"_handle_directive","kind":13,"line":449},{"line":450,"localvar":"my","kind":13,"containerName":"_handle_directive","name":"$version","definition":"my"},{"line":450,"name":"$arg","containerName":"_handle_directive","kind":13},{"line":451,"name":"$version","containerName":"_handle_directive","kind":13},{"line":452,"name":"$self","containerName":"_handle_directive","kind":13},{"containerName":"_handle_directive","kind":12,"name":"throw","line":452},{"kind":13,"containerName":"_handle_directive","name":"$directive","line":456},{"line":461,"name":"$self","containerName":"_handle_directive","kind":13},{"line":461,"kind":12,"containerName":"_handle_directive","name":"throw"},{"line":462,"name":"$arg","kind":13,"containerName":"_handle_directive"},{"name":"$arg","containerName":"_handle_directive","kind":13,"line":462},{"definition":"my","line":463,"name":"$fta","localvar":"my","containerName":"_handle_directive","kind":13},{"line":463,"name":"new","containerName":"_handle_directive","kind":12},{"line":464,"containerName":"_handle_directive","kind":13,"name":"$fta"},{"line":464,"kind":12,"containerName":"_handle_directive","name":"name"},{"definition":"my","line":466,"name":"$f","containerName":"_handle_directive","localvar":"my","kind":13},{"kind":12,"containerName":"_handle_directive","name":"new","line":466},{"name":"$f","kind":13,"containerName":"_handle_directive","line":467},{"line":467,"kind":12,"containerName":"_handle_directive","name":"seq_id"},{"line":467,"name":"$arg","containerName":"_handle_directive","kind":13},{"name":"$f","kind":13,"containerName":"_handle_directive","line":468},{"containerName":"_handle_directive","kind":12,"name":"start","line":468},{"line":468,"containerName":"_handle_directive","kind":13,"name":"$arg"},{"line":469,"name":"$f","kind":13,"containerName":"_handle_directive"},{"name":"end","containerName":"_handle_directive","kind":12,"line":469},{"line":469,"name":"$arg","containerName":"_handle_directive","kind":13},{"name":"$f","kind":13,"containerName":"_handle_directive","line":471},{"line":471,"kind":12,"containerName":"_handle_directive","name":"type"},{"name":"$fta","kind":13,"containerName":"_handle_directive","line":471},{"line":474,"kind":13,"containerName":"_handle_directive","name":"$self"},{"line":474,"kind":12,"containerName":"_handle_directive","name":"sequence_region"},{"line":474,"name":"$f","kind":13,"containerName":"_handle_directive"},{"name":"seq_id","containerName":"_handle_directive","kind":12,"line":474},{"containerName":"_handle_directive","kind":13,"name":"$f","line":474},{"line":478,"name":"$self","kind":13,"containerName":"_handle_directive"},{"containerName":"_handle_directive","kind":12,"name":"_buffer_feature","line":478},{"line":478,"containerName":"_handle_directive","kind":13,"name":"$f"},{"line":481,"name":"$directive","kind":13,"containerName":"_handle_directive"},{"name":"$self","kind":13,"containerName":"_handle_directive","line":482},{"name":"warn","kind":12,"containerName":"_handle_directive","line":482},{"name":"$directive","kind":13,"containerName":"_handle_directive","line":485},{"line":486,"name":"$self","containerName":"_handle_directive","kind":13},{"kind":12,"containerName":"_handle_directive","name":"warn","line":486},{"line":489,"name":"$directive","kind":13,"containerName":"_handle_directive"},{"line":490,"name":"$self","kind":13,"containerName":"_handle_directive"},{"name":"warn","containerName":"_handle_directive","kind":12,"line":490},{"line":493,"name":"$directive","containerName":"_handle_directive","kind":13},{"line":493,"name":"$directive","kind":13,"containerName":"_handle_directive"},{"name":"$self","containerName":"_handle_directive","kind":13,"line":495},{"line":495,"containerName":"_handle_directive","kind":12,"name":"fasta_mode"},{"line":499,"kind":13,"containerName":"_handle_directive","name":"$directive"},{"line":501,"containerName":"_handle_directive","kind":13,"name":"$self"},{"line":504,"name":"$directive","kind":13,"containerName":"_handle_directive"},{"localvar":"my","containerName":"_handle_directive","kind":13,"name":"$organism","line":505,"definition":"my"},{"name":"$arg","kind":13,"containerName":"_handle_directive","line":505},{"kind":13,"containerName":"_handle_directive","name":"$self","line":506},{"name":"organism","containerName":"_handle_directive","kind":12,"line":506},{"line":506,"name":"$organism","containerName":"_handle_directive","kind":13},{"name":"$self","containerName":"_handle_directive","kind":13,"line":510},{"line":510,"name":"throw","kind":12,"containerName":"_handle_directive"},{"containerName":"_handle_directive","kind":13,"name":"$directive","line":510}]},{"name":"Bio","containerName":"Annotation::OntologyTerm","kind":12,"line":463},{"name":"Bio","containerName":"SeqFeature::Annotated","kind":12,"line":466},{"kind":12,"name":"group_not_done","line":501},{"range":{"start":{"character":0,"line":521},"end":{"line":624,"character":9999}},"kind":12,"line":521,"signature":{"label":"_handle_feature($self,$feature_string)","parameters":[{"label":"$self"},{"label":"$feature_string"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object."},"containerName":"main::","name":"_handle_feature","children":[{"definition":"my","localvar":"my","containerName":"_handle_feature","kind":13,"name":"$self","line":522},{"line":522,"kind":13,"containerName":"_handle_feature","name":"$feature_string"},{"line":524,"name":"$feat","localvar":"my","containerName":"_handle_feature","kind":13,"definition":"my"},{"containerName":"_handle_feature","kind":12,"name":"new","line":524},{"containerName":"_handle_feature","localvar":"my","kind":13,"name":"$seq","line":526,"definition":"my"},{"containerName":"_handle_feature","kind":13,"name":"$source","line":526},{"line":526,"kind":13,"containerName":"_handle_feature","name":"$type"},{"line":526,"name":"$start","containerName":"_handle_feature","kind":13},{"line":526,"name":"$end","kind":13,"containerName":"_handle_feature"},{"line":526,"kind":13,"containerName":"_handle_feature","name":"$score"},{"name":"$strand","kind":13,"containerName":"_handle_feature","line":526},{"line":526,"name":"$phase","containerName":"_handle_feature","kind":13},{"name":"$attribute_string","kind":13,"containerName":"_handle_feature","line":526},{"line":526,"name":"$feature_string","containerName":"_handle_feature","kind":13},{"containerName":"_handle_feature","kind":13,"name":"$feat","line":528},{"name":"seq_id","kind":12,"containerName":"_handle_feature","line":528},{"containerName":"_handle_feature","kind":13,"name":"$seq","line":528},{"containerName":"_handle_feature","kind":13,"name":"$feat","line":529},{"line":529,"kind":12,"containerName":"_handle_feature","name":"source_tag"},{"kind":13,"containerName":"_handle_feature","name":"$source","line":529},{"line":530,"kind":13,"containerName":"_handle_feature","name":"$feat"},{"line":530,"kind":12,"containerName":"_handle_feature","name":"start"},{"name":"$start","kind":13,"containerName":"_handle_feature","line":530},{"kind":13,"containerName":"_handle_feature","name":"$start","line":530},{"containerName":"_handle_feature","kind":13,"name":"$feat","line":531},{"line":531,"name":"end","containerName":"_handle_feature","kind":12},{"name":"$end","kind":13,"containerName":"_handle_feature","line":531},{"line":531,"name":"$end","kind":13,"containerName":"_handle_feature"},{"containerName":"_handle_feature","kind":13,"name":"$feat","line":532},{"line":532,"kind":12,"containerName":"_handle_feature","name":"strand"},{"kind":13,"containerName":"_handle_feature","name":"$strand","line":532},{"name":"$strand","containerName":"_handle_feature","kind":13,"line":532},{"line":533,"name":"$feat","kind":13,"containerName":"_handle_feature"},{"line":533,"kind":12,"containerName":"_handle_feature","name":"score"},{"containerName":"_handle_feature","kind":13,"name":"$score","line":533},{"line":534,"name":"$feat","containerName":"_handle_feature","kind":13},{"line":534,"name":"phase","containerName":"_handle_feature","kind":12},{"line":534,"containerName":"_handle_feature","kind":13,"name":"$phase"},{"definition":"my","kind":13,"localvar":"my","containerName":"_handle_feature","name":"$fta","line":536},{"line":536,"kind":12,"containerName":"_handle_feature","name":"new"},{"containerName":"_handle_feature","kind":13,"name":"$self","line":538},{"line":538,"name":"validate","containerName":"_handle_feature","kind":12},{"line":541,"kind":13,"containerName":"_handle_feature","name":"$seq"},{"kind":13,"containerName":"_handle_feature","name":"$self","line":542},{"name":"throw","containerName":"_handle_feature","kind":12,"line":542},{"line":545,"kind":13,"containerName":"_handle_feature","name":"$seq"},{"containerName":"_handle_feature","kind":13,"name":"$self","line":546},{"name":"throw","containerName":"_handle_feature","kind":12,"line":546},{"name":"$seq","kind":13,"containerName":"_handle_feature","line":550},{"line":551,"name":"$self","kind":13,"containerName":"_handle_feature"},{"name":"throw","kind":12,"containerName":"_handle_feature","line":551},{"line":557,"kind":13,"containerName":"_handle_feature","name":"$start"},{"line":557,"kind":13,"containerName":"_handle_feature","name":"$end"},{"containerName":"_handle_feature","kind":13,"name":"$self","line":558},{"line":558,"name":"throw","containerName":"_handle_feature","kind":12},{"definition":"my","name":"$region","containerName":"_handle_feature","localvar":"my","kind":13,"line":561},{"name":"$self","kind":13,"containerName":"_handle_feature","line":561},{"containerName":"_handle_feature","kind":12,"name":"sequence_region","line":561},{"line":561,"kind":13,"containerName":"_handle_feature","name":"$seq"},{"name":"$region","containerName":"_handle_feature","kind":13,"line":565},{"name":"$start","containerName":"_handle_feature","kind":13,"line":565},{"containerName":"_handle_feature","kind":13,"name":"$region","line":565},{"name":"start","containerName":"_handle_feature","kind":12,"line":565},{"line":565,"name":"$end","containerName":"_handle_feature","kind":13},{"containerName":"_handle_feature","kind":13,"name":"$region","line":565},{"kind":12,"containerName":"_handle_feature","name":"end","line":565},{"line":566,"containerName":"_handle_feature","kind":13,"name":"$self"},{"kind":12,"containerName":"_handle_feature","name":"throw","line":566},{"line":571,"containerName":"_handle_feature","kind":13,"name":"$self"},{"line":571,"name":"throw","kind":12,"containerName":"_handle_feature"},{"line":571,"kind":13,"containerName":"_handle_feature","name":"$strand"},{"line":574,"kind":13,"containerName":"_handle_feature","name":"$self"},{"name":"throw","containerName":"_handle_feature","kind":12,"line":574},{"kind":13,"containerName":"_handle_feature","name":"$phase","line":574},{"definition":"my","line":576,"localvar":"my","containerName":"_handle_feature","kind":13,"name":"$feature_type"},{"line":577,"name":"$type","kind":13,"containerName":"_handle_feature"},{"line":579,"name":"$feature_type","containerName":"_handle_feature","kind":13},{"name":"$self","containerName":"_handle_feature","kind":13,"line":579},{"line":579,"name":"so","kind":12,"containerName":"_handle_feature"},{"line":579,"kind":12,"containerName":"_handle_feature","name":"find_terms"},{"line":579,"kind":13,"containerName":"_handle_feature","name":"$type"},{"kind":13,"containerName":"_handle_feature","name":"$feature_type","line":582},{"name":"$self","kind":13,"containerName":"_handle_feature","line":582},{"line":582,"kind":12,"containerName":"_handle_feature","name":"so"},{"line":582,"containerName":"_handle_feature","kind":12,"name":"find_terms"},{"line":582,"name":"$type","containerName":"_handle_feature","kind":13},{"kind":13,"containerName":"_handle_feature","name":"$feature_type","line":585},{"kind":13,"containerName":"_handle_feature","name":"$self","line":586},{"containerName":"_handle_feature","kind":12,"name":"throw","line":586},{"kind":13,"containerName":"_handle_feature","name":"$fta","line":588},{"line":588,"name":"term","kind":12,"containerName":"_handle_feature"},{"line":588,"containerName":"_handle_feature","kind":13,"name":"$feature_type"},{"line":591,"kind":13,"containerName":"_handle_feature","name":"$type"},{"line":593,"kind":13,"containerName":"_handle_feature","name":"$fta"},{"line":593,"containerName":"_handle_feature","kind":12,"name":"identifier"},{"line":593,"name":"$type","containerName":"_handle_feature","kind":13},{"containerName":"_handle_feature","kind":13,"name":"$fta","line":595},{"line":595,"name":"name","containerName":"_handle_feature","kind":12},{"line":595,"kind":13,"containerName":"_handle_feature","name":"$type"},{"line":599,"kind":13,"containerName":"_handle_feature","name":"$feat"},{"line":599,"name":"type","kind":12,"containerName":"_handle_feature"},{"name":"$fta","kind":13,"containerName":"_handle_feature","line":599},{"name":"%attr","localvar":"my","containerName":"_handle_feature","kind":13,"line":601,"definition":"my"},{"kind":13,"containerName":"_handle_feature","name":"$attribute_string","line":602},{"name":"$attribute_string","kind":13,"containerName":"_handle_feature","line":604},{"definition":"my","containerName":"_handle_feature","localvar":"my","kind":13,"name":"@attributes","line":605},{"line":605,"name":"$attribute_string","containerName":"_handle_feature","kind":13},{"definition":"my","containerName":"_handle_feature","localvar":"my","kind":13,"name":"$attribute","line":606},{"line":606,"kind":13,"containerName":"_handle_feature","name":"@attributes"},{"definition":"my","kind":13,"localvar":"my","containerName":"_handle_feature","name":"$key","line":607},{"line":607,"kind":13,"containerName":"_handle_feature","name":"$values"},{"name":"$attribute","containerName":"_handle_feature","kind":13,"line":607},{"containerName":"_handle_feature","kind":13,"name":"$values","line":610},{"name":"$values","containerName":"_handle_feature","kind":13,"line":611},{"kind":13,"localvar":"my","containerName":"_handle_feature","name":"@values","line":613,"definition":"my"},{"name":"$values","containerName":"_handle_feature","kind":13,"line":613},{"line":616,"kind":13,"containerName":"_handle_feature","name":"$attr"},{"containerName":"_handle_feature","kind":13,"name":"$key","line":616},{"definition":"my","line":617,"localvar":"my","containerName":"_handle_feature","kind":13,"name":"@tmparray"},{"containerName":"_handle_feature","kind":13,"name":"$attr","line":617},{"name":"$key","containerName":"_handle_feature","kind":13,"line":617},{"name":"@tmparray","containerName":"_handle_feature","kind":13,"line":618},{"line":618,"kind":13,"containerName":"_handle_feature","name":"@values"},{"line":619,"name":"$attr","containerName":"_handle_feature","kind":13},{"kind":13,"containerName":"_handle_feature","name":"$key","line":619},{"name":"@tmparray","containerName":"_handle_feature","kind":13,"line":619},{"line":621,"kind":13,"containerName":"_handle_feature","name":"$attr"},{"line":621,"kind":13,"containerName":"_handle_feature","name":"$key"},{"name":"@values","kind":13,"containerName":"_handle_feature","line":621}],"detail":"($self,$feature_string)","definition":"sub"},{"line":524,"containerName":"SeqFeature::Annotated","kind":12,"name":"Bio"},{"line":536,"kind":12,"containerName":"Annotation::OntologyTerm","name":"Bio"},{"line":613,"kind":12,"name":"uri_unescape"},{"line":627,"containerName":null,"kind":13,"name":"%attr"},{"kind":12,"name":"Dbxref","line":627},{"name":"%attr","kind":13,"containerName":null,"line":627},{"line":627,"name":"dbxref","kind":12},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$value","line":628},{"line":628,"kind":13,"containerName":null,"name":"%attr"},{"name":"Dbxref","kind":12,"line":628},{"line":628,"containerName":null,"kind":13,"name":"%attr"},{"line":628,"name":"dbxref","kind":12},{"definition":"my","line":629,"name":"$a","containerName":null,"localvar":"my","kind":13},{"line":629,"kind":12,"containerName":"Annotation::DBLink","name":"Bio"},{"line":629,"kind":12,"containerName":"main::","name":"new"},{"definition":"my","line":630,"kind":13,"localvar":"my","containerName":null,"name":"$db"},{"line":630,"kind":13,"containerName":null,"name":"$accession"},{"name":"$value","containerName":null,"kind":13,"line":630},{"line":632,"containerName":null,"kind":13,"name":"$db"},{"line":632,"kind":13,"containerName":null,"name":"%accession"},{"kind":13,"containerName":null,"name":"$self","line":633},{"containerName":"main::","kind":12,"name":"throw","line":633},{"kind":13,"containerName":null,"name":"$a","line":637},{"line":637,"kind":12,"containerName":"main::","name":"database"},{"line":637,"containerName":null,"kind":13,"name":"$db"},{"line":638,"kind":13,"containerName":null,"name":"$a"},{"line":638,"name":"primary_id","kind":12,"containerName":"main::"},{"line":638,"name":"$accession","containerName":null,"kind":13},{"line":639,"name":"$feat","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"add_Annotation","line":639},{"line":639,"containerName":null,"kind":13,"name":"$a"},{"kind":13,"containerName":null,"name":"%attr","line":644},{"kind":12,"name":"Ontology_term","line":644},{"kind":13,"localvar":"my","containerName":null,"name":"$id","line":645,"definition":"my"},{"name":"%attr","kind":13,"containerName":null,"line":645},{"line":645,"kind":12,"name":"Ontology_term"},{"localvar":"my","containerName":null,"kind":13,"name":"$a","line":646,"definition":"my"},{"name":"Bio","kind":12,"containerName":"Annotation::OntologyTerm","line":646},{"kind":12,"containerName":"main::","name":"new","line":646},{"line":648,"name":"$self","containerName":null,"kind":13},{"name":"validate","kind":12,"containerName":"main::","line":648},{"definition":"my","line":649,"name":"$ont_name","localvar":"my","containerName":null,"kind":13},{"line":649,"kind":12,"containerName":"Ontology::OntologyStore","name":"Bio"},{"line":649,"name":"guess_ontology","kind":12,"containerName":"main::"},{"name":"$id","kind":13,"containerName":null,"line":649},{"definition":"my","line":650,"kind":13,"localvar":"my","containerName":null,"name":"$ont"},{"name":"Bio","containerName":"Ontology::OntologyStore","kind":12,"line":650},{"containerName":"main::","kind":12,"name":"get_ontology","line":650},{"line":650,"name":"$ont_name","containerName":null,"kind":13},{"definition":"my","name":"$term","kind":13,"localvar":"my","containerName":null,"line":651},{"line":651,"name":"$ont","containerName":null,"kind":13},{"line":651,"kind":12,"containerName":"main::","name":"find_terms"},{"line":651,"containerName":null,"kind":13,"name":"$id"},{"line":652,"containerName":null,"kind":13,"name":"$a"},{"line":652,"name":"term","containerName":"main::","kind":12},{"line":652,"containerName":null,"kind":13,"name":"%term"},{"containerName":null,"kind":13,"name":"$a","line":654},{"line":654,"name":"identifier","containerName":"main::","kind":12},{"name":"$id","kind":13,"containerName":null,"line":654},{"line":657,"name":"$feat","containerName":null,"kind":13},{"line":657,"name":"add_Annotation","kind":12,"containerName":"main::"},{"name":"$a","containerName":null,"kind":13,"line":657},{"line":662,"name":"%attr","kind":13,"containerName":null},{"kind":12,"name":"Gap","line":662},{"definition":"my","line":663,"name":"$value","kind":13,"localvar":"my","containerName":null},{"line":663,"name":"%attr","containerName":null,"kind":13},{"name":"Gap","kind":12,"line":663},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$a","line":664},{"line":664,"name":"Bio","containerName":"Annotation::SimpleValue","kind":12},{"name":"new","kind":12,"containerName":"main::","line":664},{"containerName":null,"kind":13,"name":"$a","line":665},{"line":665,"containerName":"main::","kind":12,"name":"value"},{"line":665,"name":"$value","kind":13,"containerName":null},{"line":666,"kind":13,"containerName":null,"name":"$feat"},{"kind":12,"containerName":"main::","name":"add_Annotation","line":666},{"line":666,"kind":13,"containerName":null,"name":"$a"},{"line":671,"name":"%attr","kind":13,"containerName":null},{"kind":12,"name":"Target","line":671},{"definition":"my","line":672,"name":"$target_collection","localvar":"my","kind":13,"containerName":null},{"line":672,"name":"Bio","containerName":"Annotation::Collection","kind":12},{"line":672,"kind":12,"containerName":"main::","name":"new"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$target_string","line":674},{"name":"%attr","kind":13,"containerName":null,"line":674},{"line":674,"name":"Target","kind":12},{"line":681,"name":"$target_string","kind":13,"containerName":null},{"name":"$target_string","containerName":null,"kind":13,"line":681},{"line":683,"name":"$t_id","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"$tstart","containerName":null,"kind":13,"line":683},{"line":683,"containerName":null,"kind":13,"name":"$tend"},{"containerName":null,"kind":13,"name":"$strand","line":683},{"line":683,"containerName":null,"kind":13,"name":"$extra"},{"name":"$target_string","kind":13,"containerName":null,"line":683},{"line":684,"kind":13,"containerName":null,"name":"$tend"},{"kind":13,"containerName":null,"name":"%extra","line":684},{"name":"$self","kind":13,"containerName":null,"line":685},{"name":"throw","containerName":"main::","kind":12,"line":685},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$a","line":688},{"kind":12,"containerName":"Annotation::Target","name":"Bio","line":688},{"containerName":"main::","kind":12,"name":"new","line":688},{"line":689,"kind":13,"containerName":null,"name":"$t_id"},{"line":690,"containerName":null,"kind":13,"name":"$tstart"},{"line":691,"containerName":null,"kind":13,"name":"$tend"},{"line":694,"kind":13,"containerName":null,"name":"$strand"},{"line":694,"kind":13,"containerName":null,"name":"%strand"},{"line":695,"kind":13,"containerName":null,"name":"$strand"},{"line":696,"name":"$strand","kind":13,"containerName":null},{"line":696,"name":"%strand","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%strand","line":697},{"line":699,"containerName":null,"kind":13,"name":"$strand"},{"containerName":null,"kind":13,"name":"$a","line":702},{"name":"strand","kind":12,"containerName":"main::","line":702},{"name":"$strand","kind":13,"containerName":null,"line":702},{"line":702,"containerName":null,"kind":13,"name":"$strand"},{"name":"$feat","kind":13,"containerName":null,"line":703},{"containerName":"main::","kind":12,"name":"add_Annotation","line":703},{"line":703,"name":"$a","containerName":null,"kind":13},{"line":709,"containerName":null,"kind":13,"name":"%attr"},{"line":709,"name":"ID","kind":12},{"line":710,"name":"%attr","containerName":null,"kind":13},{"name":"ID","kind":12,"line":710},{"line":711,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"throw","line":711},{"line":715,"kind":13,"containerName":null,"name":"%self"},{"name":"%attr","containerName":null,"kind":13,"line":715},{"name":"ID","kind":12,"line":715},{"line":715,"name":"$self","kind":13,"containerName":null},{"name":"validate","containerName":"main::","kind":12,"line":715},{"kind":13,"containerName":null,"name":"$self","line":716},{"kind":12,"containerName":"main::","name":"throw","line":716},{"kind":13,"containerName":null,"name":"%self","line":718},{"line":718,"containerName":null,"kind":13,"name":"%attr"},{"line":718,"name":"ID","kind":12},{"line":721,"name":"$a","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio","line":721},{"line":721,"name":"new","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$a","line":722},{"name":"value","containerName":"main::","kind":12,"line":722},{"line":722,"kind":13,"containerName":null,"name":"%attr"},{"name":"ID","kind":12,"line":722},{"kind":13,"containerName":null,"name":"$feat","line":723},{"kind":12,"containerName":"main::","name":"add_Annotation","line":723},{"line":723,"name":"$a","kind":13,"containerName":null},{"line":727,"kind":13,"containerName":null,"name":"%attr"},{"name":"Name","kind":12,"line":727},{"line":728,"kind":13,"containerName":null,"name":"%attr"},{"line":728,"name":"Name","kind":12},{"containerName":null,"kind":13,"name":"$self","line":729},{"containerName":"main::","kind":12,"name":"throw","line":729},{"definition":"my","line":732,"kind":13,"localvar":"my","containerName":null,"name":"$a"},{"line":732,"name":"Bio","containerName":"Annotation::SimpleValue","kind":12},{"name":"new","kind":12,"containerName":"main::","line":732},{"name":"$a","kind":13,"containerName":null,"line":733},{"name":"value","containerName":"main::","kind":12,"line":733},{"kind":13,"containerName":null,"name":"%attr","line":733},{"name":"Name","kind":12,"line":733},{"kind":13,"containerName":null,"name":"$feat","line":734},{"containerName":"main::","kind":12,"name":"add_Annotation","line":734},{"name":"$a","containerName":null,"kind":13,"line":734},{"definition":"my","name":"%other_canonical","localvar":"my","containerName":null,"kind":13,"line":737},{"line":738,"kind":13,"containerName":null,"name":"%attr"},{"line":738,"name":"%other_canonical","kind":13,"containerName":null},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$value","line":739},{"containerName":null,"kind":13,"name":"%attr","line":739},{"line":739,"name":"%other_canonical","containerName":null,"kind":13},{"definition":"my","name":"$a","kind":13,"localvar":"my","containerName":null,"line":740},{"line":740,"name":"Bio","containerName":"Annotation::SimpleValue","kind":12},{"line":740,"name":"new","kind":12,"containerName":"main::"},{"line":741,"name":"$a","containerName":null,"kind":13},{"line":741,"containerName":"main::","kind":12,"name":"value"},{"line":741,"kind":13,"containerName":null,"name":"$value"},{"line":742,"kind":13,"containerName":null,"name":"$feat"},{"line":742,"kind":12,"containerName":"main::","name":"add_Annotation"},{"name":"$other_canonical","kind":13,"containerName":null,"line":742},{"kind":13,"containerName":null,"name":"$a","line":742},{"definition":"my","name":"@non_reserved_tags","localvar":"my","containerName":null,"kind":13,"line":747},{"line":747,"containerName":null,"kind":13,"name":"%attr"},{"name":"$non_reserved_tag","kind":13,"localvar":"my","containerName":null,"line":748,"definition":"my"},{"containerName":null,"kind":13,"name":"@non_reserved_tags","line":748},{"name":"$non_reserved_tag","kind":13,"containerName":null,"line":749},{"localvar":"my","containerName":null,"kind":13,"name":"$value","line":750,"definition":"my"},{"line":750,"name":"%attr","containerName":null,"kind":13},{"line":750,"name":"%non_reserved_tag","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$feat","line":751},{"line":751,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_handle_non_reserved_tag","line":751},{"line":751,"containerName":null,"kind":13,"name":"$feat"},{"kind":13,"containerName":null,"name":"$non_reserved_tag","line":751},{"name":"$value","containerName":null,"kind":13,"line":751},{"line":755,"name":"@illegal_tags","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"%attr","kind":13,"containerName":null,"line":757},{"name":"@illegal_tags","containerName":null,"kind":13,"line":759},{"definition":"my","line":760,"name":"$tags","localvar":"my","kind":13,"containerName":null},{"line":760,"containerName":null,"kind":13,"name":"@illegal_tags"},{"name":"$self","kind":13,"containerName":null,"line":761},{"line":761,"containerName":"main::","kind":12,"name":"throw"},{"line":764,"name":"$feat","containerName":null,"kind":13},{"definition":"sub","detail":"($feat,$tag,$value)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_handle_non_reserved_tag","name":"$self","line":780},{"kind":13,"localvar":"my","containerName":"_handle_non_reserved_tag","name":"$feat","line":781,"definition":"my"},{"line":781,"containerName":"_handle_non_reserved_tag","kind":13,"name":"$tag"},{"containerName":"_handle_non_reserved_tag","kind":13,"name":"$value","line":781},{"line":788,"localvar":"my","kind":13,"containerName":"_handle_non_reserved_tag","name":"$a","definition":"my"},{"line":789,"kind":13,"containerName":"_handle_non_reserved_tag","name":"$tag"},{"line":790,"name":"$a","kind":13,"containerName":"_handle_non_reserved_tag"},{"containerName":"_handle_non_reserved_tag","kind":12,"name":"new","line":790},{"containerName":"_handle_non_reserved_tag","kind":13,"name":"$a","line":793},{"line":793,"kind":12,"containerName":"_handle_non_reserved_tag","name":"new"},{"kind":13,"containerName":"_handle_non_reserved_tag","name":"$a","line":795},{"line":795,"kind":12,"containerName":"_handle_non_reserved_tag","name":"value"},{"name":"$value","kind":13,"containerName":"_handle_non_reserved_tag","line":795},{"line":796,"name":"$feat","containerName":"_handle_non_reserved_tag","kind":13},{"name":"add_Annotation","containerName":"_handle_non_reserved_tag","kind":12,"line":796},{"line":796,"kind":13,"containerName":"_handle_non_reserved_tag","name":"$tag"},{"kind":13,"containerName":"_handle_non_reserved_tag","name":"$a","line":796},{"line":798,"name":"$feat","containerName":"_handle_non_reserved_tag","kind":13}],"containerName":"main::","name":"_handle_non_reserved_tag","signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.","parameters":[{"label":"$feat"},{"label":"$tag"},{"label":"$value"}],"label":"_handle_non_reserved_tag($feat,$tag,$value)"},"line":779,"range":{"end":{"line":799,"character":9999},"start":{"character":0,"line":779}},"kind":12},{"line":790,"containerName":"Annotation::Comment","kind":12,"name":"Bio"},{"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio","line":793},{"range":{"end":{"line":812,"character":9999},"start":{"line":807,"character":0}},"kind":12,"line":807,"name":"organism","containerName":"main::","children":[{"definition":"my","line":808,"containerName":"organism","localvar":"my","kind":13,"name":"$self"},{"kind":13,"localvar":"my","containerName":"organism","name":"$organism","line":809,"definition":"my"},{"line":810,"name":"$self","kind":13,"containerName":"organism"},{"name":"$organism","kind":13,"containerName":"organism","line":810},{"line":810,"containerName":"organism","kind":13,"name":"$organism"},{"name":"$self","containerName":"organism","kind":13,"line":811}],"definition":"sub"},{"signature":{"label":"_write_feature_1($self,$feature)","parameters":[{"label":"$self"},{"label":"$feature"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented."},"range":{"end":{"line":824,"character":9999},"start":{"line":821,"character":0}},"kind":12,"line":821,"detail":"($self,$feature)","definition":"sub","containerName":"main::","name":"_write_feature_1","children":[{"line":822,"localvar":"my","kind":13,"containerName":"_write_feature_1","name":"$self","definition":"my"},{"kind":13,"containerName":"_write_feature_1","name":"$feature","line":822},{"kind":13,"containerName":"_write_feature_1","name":"$self","line":823},{"line":823,"name":"throw","kind":12,"containerName":"_write_feature_1"},{"line":823,"name":"$self","containerName":"_write_feature_1","kind":13},{"kind":12,"containerName":"_write_feature_1","name":"version","line":823}]},{"detail":"($self,$feature)","definition":"sub","containerName":"main::","name":"_write_feature_2","children":[{"definition":"my","line":833,"localvar":"my","containerName":"_write_feature_2","kind":13,"name":"$self"},{"kind":13,"containerName":"_write_feature_2","name":"$feature","line":833},{"name":"$self","kind":13,"containerName":"_write_feature_2","line":834},{"line":834,"kind":12,"containerName":"_write_feature_2","name":"throw"},{"line":834,"name":"$self","containerName":"_write_feature_2","kind":13},{"containerName":"_write_feature_2","kind":12,"name":"version","line":834}],"signature":{"parameters":[{"label":"$self"},{"label":"$feature"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented.\n\n\nsub _write_feature_1 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_2()\n\nwrite a feature in GFF v2 format.  currently not implemented.","label":"_write_feature_2($self,$feature)"},"kind":12,"range":{"start":{"line":832,"character":0},"end":{"line":835,"character":9999}},"line":832},{"children":[{"definition":"my","line":844,"name":"$self","containerName":"_write_feature_25","localvar":"my","kind":13},{"name":"$feature","containerName":"_write_feature_25","kind":13,"line":844},{"line":844,"containerName":"_write_feature_25","kind":13,"name":"$group"},{"definition":"my","line":847,"name":"$transcript_id","containerName":"_write_feature_25","localvar":"my","kind":13},{"line":847,"kind":13,"containerName":"_write_feature_25","name":"$gene_id"},{"name":"$feature","containerName":"_write_feature_25","kind":13,"line":847},{"name":"get_Annotations","containerName":"_write_feature_25","kind":12,"line":847},{"kind":13,"containerName":"_write_feature_25","name":"$feature","line":847},{"kind":12,"containerName":"_write_feature_25","name":"get_Annotations","line":847},{"kind":13,"containerName":"_write_feature_25","name":"$group","line":848},{"line":849,"name":"$group","containerName":"_write_feature_25","kind":13},{"line":849,"name":"$feature","containerName":"_write_feature_25","kind":13},{"line":849,"name":"get_Annotations","kind":12,"containerName":"_write_feature_25"},{"name":"$transcript_id","containerName":"_write_feature_25","kind":13,"line":850},{"containerName":"_write_feature_25","kind":13,"name":"$group","line":850},{"name":"$gene_id","containerName":"_write_feature_25","kind":13,"line":851},{"line":851,"kind":13,"containerName":"_write_feature_25","name":"$group"},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_feature_25","name":"$seq","line":855},{"line":855,"name":"$feature","containerName":"_write_feature_25","kind":13},{"line":855,"name":"seq_id","kind":12,"containerName":"_write_feature_25"},{"line":855,"name":"$feature","kind":13,"containerName":"_write_feature_25"},{"name":"seq_id","containerName":"_write_feature_25","kind":12,"line":855},{"name":"value","kind":12,"containerName":"_write_feature_25","line":855},{"line":855,"containerName":"_write_feature_25","kind":13,"name":"$feature"},{"kind":12,"containerName":"_write_feature_25","name":"seq_id","line":855},{"line":856,"name":"$source","localvar":"my","containerName":"_write_feature_25","kind":13,"definition":"my"},{"line":856,"containerName":"_write_feature_25","kind":13,"name":"$feature"},{"line":856,"name":"source","kind":12,"containerName":"_write_feature_25"},{"name":"value","kind":12,"containerName":"_write_feature_25","line":856},{"name":"$type","kind":13,"localvar":"my","containerName":"_write_feature_25","line":857,"definition":"my"},{"line":857,"name":"$feature","kind":13,"containerName":"_write_feature_25"},{"line":857,"name":"type","containerName":"_write_feature_25","kind":12},{"kind":12,"containerName":"_write_feature_25","name":"name","line":857},{"containerName":"_write_feature_25","kind":13,"name":"$type","line":858},{"line":858,"kind":13,"containerName":"_write_feature_25","name":"$type"},{"name":"$min","containerName":"_write_feature_25","localvar":"my","kind":13,"line":859,"definition":"my"},{"name":"$feature","kind":13,"containerName":"_write_feature_25","line":859},{"line":859,"name":"start","containerName":"_write_feature_25","kind":12},{"line":860,"containerName":"_write_feature_25","localvar":"my","kind":13,"name":"$max","definition":"my"},{"kind":13,"containerName":"_write_feature_25","name":"$feature","line":860},{"line":860,"name":"end","containerName":"_write_feature_25","kind":12},{"definition":"my","name":"$strand","containerName":"_write_feature_25","localvar":"my","kind":13,"line":861},{"line":861,"name":"$feature","kind":13,"containerName":"_write_feature_25"},{"name":"strand","containerName":"_write_feature_25","kind":12,"line":861},{"kind":13,"containerName":"_write_feature_25","name":"$feature","line":861},{"kind":12,"containerName":"_write_feature_25","name":"strand","line":861},{"definition":"my","kind":13,"localvar":"my","containerName":"_write_feature_25","name":"$score","line":862},{"name":"$feature","containerName":"_write_feature_25","kind":13,"line":862},{"containerName":"_write_feature_25","kind":12,"name":"score","line":862},{"containerName":"_write_feature_25","kind":13,"name":"$feature","line":862},{"kind":12,"containerName":"_write_feature_25","name":"score","line":862},{"line":862,"containerName":"_write_feature_25","kind":13,"name":"$feature"},{"line":862,"kind":12,"containerName":"_write_feature_25","name":"score"},{"kind":12,"containerName":"_write_feature_25","name":"value","line":862},{"line":862,"name":"$feature","kind":13,"containerName":"_write_feature_25"},{"line":862,"name":"score","containerName":"_write_feature_25","kind":12},{"definition":"my","localvar":"my","containerName":"_write_feature_25","kind":13,"name":"$frame","line":863},{"line":863,"name":"$feature","kind":13,"containerName":"_write_feature_25"},{"line":863,"name":"frame","containerName":"_write_feature_25","kind":12},{"line":863,"kind":13,"containerName":"_write_feature_25","name":"$feature"},{"line":863,"kind":12,"containerName":"_write_feature_25","name":"frame"},{"line":863,"containerName":"_write_feature_25","kind":13,"name":"$feature"},{"containerName":"_write_feature_25","kind":12,"name":"frame","line":863},{"name":"value","kind":12,"containerName":"_write_feature_25","line":863},{"line":863,"name":"$feature","kind":13,"containerName":"_write_feature_25"},{"kind":12,"containerName":"_write_feature_25","name":"frame","line":863},{"line":863,"name":"$feature","containerName":"_write_feature_25","kind":13},{"name":"phase","containerName":"_write_feature_25","kind":12,"line":863},{"line":863,"kind":13,"containerName":"_write_feature_25","name":"$feature"},{"containerName":"_write_feature_25","kind":12,"name":"phase","line":863},{"containerName":"_write_feature_25","kind":12,"name":"value","line":863},{"name":"$feature","containerName":"_write_feature_25","kind":13,"line":863},{"line":863,"name":"phase","kind":12,"containerName":"_write_feature_25"},{"name":"$type","kind":13,"containerName":"_write_feature_25","line":866},{"name":"$type","containerName":"_write_feature_25","kind":13,"line":866},{"line":866,"name":"$type","containerName":"_write_feature_25","kind":13},{"name":"$type","kind":13,"containerName":"_write_feature_25","line":866},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_feature_25","name":"$attr","line":867},{"name":"$gene_id","kind":13,"containerName":"_write_feature_25","line":867},{"name":"$gene_id","containerName":"_write_feature_25","kind":13,"line":867},{"line":867,"kind":12,"containerName":"_write_feature_25","name":"value"},{"name":"$transcript_id","containerName":"_write_feature_25","kind":13,"line":867},{"name":"$transcript_id","containerName":"_write_feature_25","kind":13,"line":867},{"line":867,"name":"value","containerName":"_write_feature_25","kind":12},{"line":868,"name":"$outstring","kind":13,"localvar":"my","containerName":"_write_feature_25","definition":"my"},{"name":"$seq","kind":13,"containerName":"_write_feature_25","line":869},{"line":869,"kind":13,"containerName":"_write_feature_25","name":"$source"},{"line":869,"kind":13,"containerName":"_write_feature_25","name":"$type"},{"line":869,"name":"$min","containerName":"_write_feature_25","kind":13},{"line":869,"kind":13,"containerName":"_write_feature_25","name":"$max"},{"line":869,"containerName":"_write_feature_25","kind":13,"name":"$score"},{"line":869,"name":"$strand","kind":13,"containerName":"_write_feature_25"},{"line":869,"name":"$frame","containerName":"_write_feature_25","kind":13},{"line":869,"kind":13,"containerName":"_write_feature_25","name":"$frame"},{"name":"$attr","kind":13,"containerName":"_write_feature_25","line":869},{"containerName":"_write_feature_25","kind":13,"name":"$self","line":871},{"line":871,"containerName":"_write_feature_25","kind":12,"name":"_print"},{"kind":13,"containerName":"_write_feature_25","name":"$outstring","line":871},{"localvar":"my","kind":13,"containerName":"_write_feature_25","name":"$subfeat","line":874,"definition":"my"},{"containerName":"_write_feature_25","kind":13,"name":"$feature","line":874},{"line":874,"name":"get_SeqFeatures","kind":12,"containerName":"_write_feature_25"},{"kind":13,"containerName":"_write_feature_25","name":"$self","line":875},{"name":"_write_feature_25","containerName":"_write_feature_25","kind":12,"line":875},{"line":875,"name":"$subfeat","kind":13,"containerName":"_write_feature_25"},{"line":875,"kind":13,"containerName":"_write_feature_25","name":"$group"}],"name":"_write_feature_25","containerName":"main::","definition":"sub","detail":"($self,$feature,$group)","line":843,"kind":12,"range":{"start":{"character":0,"line":843},"end":{"character":9999,"line":877}},"signature":{"label":"_write_feature_25($self,$feature,$group)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented.\n\n\nsub _write_feature_1 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_2()\n\nwrite a feature in GFF v2 format.  currently not implemented.\n\n\nsub _write_feature_2 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_25()\n\nwrite a feature in GFF v2.5 (aka GTF) format.","parameters":[{"label":"$self"},{"label":"$feature"},{"label":"$group"}]}},{"name":"_write_feature_3","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"_write_feature_3","kind":13,"line":886,"definition":"my"},{"line":886,"name":"$feature","containerName":"_write_feature_3","kind":13},{"name":"$seq","localvar":"my","kind":13,"containerName":"_write_feature_3","line":887,"definition":"my"},{"line":887,"name":"$feature","containerName":"_write_feature_3","kind":13},{"line":887,"name":"seq_id","containerName":"_write_feature_3","kind":12},{"line":887,"kind":13,"containerName":"_write_feature_3","name":"$feature"},{"containerName":"_write_feature_3","kind":12,"name":"seq_id","line":887},{"kind":12,"containerName":"_write_feature_3","name":"value","line":887},{"name":"$feature","kind":13,"containerName":"_write_feature_3","line":887},{"name":"seq_id","containerName":"_write_feature_3","kind":12,"line":887},{"definition":"my","name":"$source","containerName":"_write_feature_3","localvar":"my","kind":13,"line":888},{"kind":13,"containerName":"_write_feature_3","name":"$feature","line":889},{"name":"source","kind":12,"containerName":"_write_feature_3","line":889},{"line":890,"name":"$source","containerName":"_write_feature_3","kind":13},{"line":890,"name":"$feature","containerName":"_write_feature_3","kind":13},{"kind":12,"containerName":"_write_feature_3","name":"source","line":890},{"line":890,"containerName":"_write_feature_3","kind":12,"name":"value"},{"containerName":"_write_feature_3","kind":13,"name":"$source","line":893},{"line":893,"name":"$feature","containerName":"_write_feature_3","kind":13},{"kind":12,"containerName":"_write_feature_3","name":"source","line":893},{"definition":"my","line":895,"localvar":"my","kind":13,"containerName":"_write_feature_3","name":"$type"},{"containerName":"_write_feature_3","kind":13,"name":"$feature","line":896},{"name":"type","kind":12,"containerName":"_write_feature_3","line":896},{"kind":13,"containerName":"_write_feature_3","name":"$type","line":896},{"containerName":"_write_feature_3","kind":13,"name":"$feature","line":896},{"line":896,"kind":12,"containerName":"_write_feature_3","name":"type"},{"name":"name","kind":12,"containerName":"_write_feature_3","line":896},{"containerName":"_write_feature_3","kind":13,"name":"$type","line":897},{"definition":"my","name":"$min","localvar":"my","containerName":"_write_feature_3","kind":13,"line":898},{"line":898,"name":"$feature","containerName":"_write_feature_3","kind":13},{"line":898,"kind":12,"containerName":"_write_feature_3","name":"start"},{"definition":"my","line":899,"name":"$max","containerName":"_write_feature_3","localvar":"my","kind":13},{"line":899,"kind":13,"containerName":"_write_feature_3","name":"$feature"},{"line":899,"containerName":"_write_feature_3","kind":12,"name":"end"},{"definition":"my","line":900,"name":"$strand","kind":13,"localvar":"my","containerName":"_write_feature_3"},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":900},{"containerName":"_write_feature_3","kind":12,"name":"strand","line":900},{"line":900,"containerName":"_write_feature_3","kind":13,"name":"$feature"},{"line":900,"name":"strand","containerName":"_write_feature_3","kind":12},{"name":"$score","kind":13,"localvar":"my","containerName":"_write_feature_3","line":901,"definition":"my"},{"line":901,"name":"$feature","kind":13,"containerName":"_write_feature_3"},{"line":901,"name":"score","containerName":"_write_feature_3","kind":12},{"line":901,"containerName":"_write_feature_3","kind":13,"name":"$feature"},{"line":901,"kind":12,"containerName":"_write_feature_3","name":"score"},{"containerName":"_write_feature_3","kind":13,"name":"$feature","line":901},{"kind":12,"containerName":"_write_feature_3","name":"score","line":901},{"line":901,"kind":12,"containerName":"_write_feature_3","name":"value"},{"kind":13,"containerName":"_write_feature_3","name":"$feature","line":901},{"name":"score","containerName":"_write_feature_3","kind":12,"line":901},{"definition":"my","line":902,"name":"$phase","kind":13,"localvar":"my","containerName":"_write_feature_3"},{"name":"$feature","kind":13,"containerName":"_write_feature_3","line":902},{"line":902,"name":"phase","kind":12,"containerName":"_write_feature_3"},{"kind":12,"containerName":"_write_feature_3","name":"value","line":902},{"line":904,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"@attr","definition":"my"},{"name":"@v","kind":13,"localvar":"my","containerName":"_write_feature_3","line":905,"definition":"my"},{"name":"$feature","kind":13,"containerName":"_write_feature_3","line":905},{"name":"get_Annotations","kind":12,"containerName":"_write_feature_3","line":905},{"line":906,"name":"$vstring","localvar":"my","containerName":"_write_feature_3","kind":13,"definition":"my"},{"name":"value","containerName":"_write_feature_3","kind":12,"line":906},{"line":906,"kind":13,"containerName":"_write_feature_3","name":"@v"},{"line":907,"containerName":"_write_feature_3","kind":13,"name":"@attr"},{"name":"@v","kind":13,"localvar":"my","containerName":"_write_feature_3","line":909,"definition":"my"},{"line":909,"name":"$feature","containerName":"_write_feature_3","kind":13},{"name":"get_Annotations","containerName":"_write_feature_3","kind":12,"line":909},{"definition":"my","name":"$vstring","kind":13,"localvar":"my","containerName":"_write_feature_3","line":910},{"line":910,"name":"value","kind":12,"containerName":"_write_feature_3"},{"containerName":"_write_feature_3","kind":13,"name":"@v","line":910},{"name":"@attr","containerName":"_write_feature_3","kind":13,"line":911},{"name":"$self","kind":13,"containerName":"_write_feature_3","line":912},{"name":"throw","containerName":"_write_feature_3","kind":12,"line":912},{"line":912,"name":"$vstring","containerName":"_write_feature_3","kind":13},{"containerName":"_write_feature_3","kind":13,"name":"@v","line":912},{"line":914,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"@v","definition":"my"},{"line":914,"containerName":"_write_feature_3","kind":13,"name":"$feature"},{"line":914,"name":"get_Annotations","containerName":"_write_feature_3","kind":12},{"name":"$vstring","kind":13,"localvar":"my","containerName":"_write_feature_3","line":915,"definition":"my"},{"line":915,"containerName":"_write_feature_3","kind":12,"name":"value"},{"line":915,"name":"@v","kind":13,"containerName":"_write_feature_3"},{"name":"@attr","kind":13,"containerName":"_write_feature_3","line":916},{"definition":"my","localvar":"my","containerName":"_write_feature_3","kind":13,"name":"@v","line":918},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":918},{"line":918,"name":"get_Annotations","containerName":"_write_feature_3","kind":12},{"definition":"my","line":919,"name":"$vstring","localvar":"my","kind":13,"containerName":"_write_feature_3"},{"line":919,"kind":12,"containerName":"_write_feature_3","name":"database"},{"name":"primary_id","kind":12,"containerName":"_write_feature_3","line":919},{"containerName":"_write_feature_3","kind":13,"name":"@v","line":919},{"line":920,"kind":13,"containerName":"_write_feature_3","name":"@attr"},{"localvar":"my","kind":13,"containerName":"_write_feature_3","name":"@v","line":922,"definition":"my"},{"line":922,"containerName":"_write_feature_3","kind":13,"name":"$feature"},{"line":922,"containerName":"_write_feature_3","kind":12,"name":"get_Annotations"},{"definition":"my","name":"$vstring","containerName":"_write_feature_3","localvar":"my","kind":13,"line":923},{"line":923,"kind":12,"containerName":"_write_feature_3","name":"identifier"},{"line":923,"name":"@v","kind":13,"containerName":"_write_feature_3"},{"line":924,"containerName":"_write_feature_3","kind":13,"name":"@attr"},{"name":"@v","containerName":"_write_feature_3","localvar":"my","kind":13,"line":926,"definition":"my"},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":926},{"kind":12,"containerName":"_write_feature_3","name":"get_Annotations","line":926},{"line":927,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"$vstring","definition":"my"},{"line":927,"containerName":"_write_feature_3","kind":12,"name":"text"},{"line":927,"name":"@v","kind":13,"containerName":"_write_feature_3"},{"name":"@attr","kind":13,"containerName":"_write_feature_3","line":928},{"line":930,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"@v","definition":"my"},{"line":930,"name":"$feature","kind":13,"containerName":"_write_feature_3"},{"name":"get_Annotations","kind":12,"containerName":"_write_feature_3","line":930},{"line":931,"name":"%strand_map","kind":13,"localvar":"my","containerName":"_write_feature_3","definition":"my"},{"line":932,"name":"$vstring","kind":13,"localvar":"my","containerName":"_write_feature_3","definition":"my"},{"line":933,"name":"target_id","kind":12,"containerName":"_write_feature_3"},{"line":933,"name":"start","containerName":"_write_feature_3","kind":12},{"line":933,"name":"end","containerName":"_write_feature_3","kind":12},{"name":"strand","containerName":"_write_feature_3","kind":12,"line":933},{"line":933,"kind":13,"containerName":"_write_feature_3","name":"$strand_map"},{"line":933,"name":"strand","containerName":"_write_feature_3","kind":12},{"kind":13,"containerName":"_write_feature_3","name":"@v","line":934},{"kind":13,"containerName":"_write_feature_3","name":"@attr","line":935},{"localvar":"my","containerName":"_write_feature_3","kind":13,"name":"$attr","line":938,"definition":"my"},{"name":"@attr","kind":13,"containerName":"_write_feature_3","line":938},{"name":"$outstring","kind":13,"localvar":"my","containerName":"_write_feature_3","line":940,"definition":"my"},{"line":941,"containerName":"_write_feature_3","kind":13,"name":"$seq"},{"containerName":"_write_feature_3","kind":13,"name":"$source","line":941},{"name":"$type","kind":13,"containerName":"_write_feature_3","line":941},{"containerName":"_write_feature_3","kind":13,"name":"$min","line":941},{"name":"$max","containerName":"_write_feature_3","kind":13,"line":941},{"name":"$score","containerName":"_write_feature_3","kind":13,"line":941},{"line":941,"kind":13,"containerName":"_write_feature_3","name":"$strand"},{"kind":13,"containerName":"_write_feature_3","name":"$phase","line":941},{"name":"$attr","containerName":"_write_feature_3","kind":13,"line":941},{"line":943,"containerName":"_write_feature_3","kind":13,"name":"$self"},{"line":943,"name":"_print","kind":12,"containerName":"_write_feature_3"},{"line":943,"kind":13,"containerName":"_write_feature_3","name":"$outstring"},{"name":"$subfeat","containerName":"_write_feature_3","localvar":"my","kind":13,"line":945,"definition":"my"},{"line":945,"name":"$feature","kind":13,"containerName":"_write_feature_3"},{"containerName":"_write_feature_3","kind":12,"name":"get_SeqFeatures","line":945},{"line":946,"containerName":"_write_feature_3","kind":13,"name":"$self"},{"name":"_write_feature_3","containerName":"_write_feature_3","kind":12,"line":946},{"containerName":"_write_feature_3","kind":13,"name":"$subfeat","line":946}],"detail":"($self,$feature)","definition":"sub","kind":12,"range":{"end":{"line":948,"character":9999},"start":{"character":0,"line":885}},"line":885,"signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented.\n\n\nsub _write_feature_1 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_2()\n\nwrite a feature in GFF v2 format.  currently not implemented.\n\n\nsub _write_feature_2 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_25()\n\nwrite a feature in GFF v2.5 (aka GTF) format.\n\n\nsub _write_feature_25 {\n  my($self,$feature,$group) = @_;\n\n  #the top-level feature is an aggregate of all subfeatures\n  my ($transcript_id, $gene_id) = (($feature->get_Annotations('transcript_id'))[0], ($feature->get_Annotations('gene_id'))[0]);\n  if(!defined($group)){\n    $group = ($feature->get_Annotations('ID'))[0];\n    $transcript_id ||= $group;\n    $gene_id ||= $group;\n  }\n  \n\n  my $seq    = ref($feature->seq_id) ? $feature->seq_id->value : $feature->seq_id;\n  my $source = $feature->source->value;\n  my $type   = $feature->type->name;\n  $type = 'EXON' if $type eq 'exon'; #a GTF peculiarity, incosistent with the sequence ontology.\n  my $min    = $feature->start   || '.';\n  my $max    = $feature->end     || '.';\n  my $strand = $feature->strand == 1 ? '+' : $feature->strand == -1 ? '-' : '.';\n  my $score  = defined($feature->score) ? (ref($feature->score) ? $feature->score->value : $feature->score) : '.'; # score is optional\n  my $frame  = defined($feature->frame) ? (ref($feature->frame) ? $feature->frame->value : $feature->frame) : (ref($feature->phase) ? $feature->phase->value : $feature->phase);\n\n  #these are the only valid types in a GTF document\n  if($type eq 'EXON' or $type eq 'CDS' or $type eq 'start_codon' or $type eq 'stop_codon'){\n    my $attr = sprintf('gene_id \"%s\"; transcript_id \"%s\";',$gene_id ? $gene_id->value : '',$transcript_id ? $transcript_id->value : '');\n    my $outstring = sprintf(\"%s\\t%s\\t%s\\t%s\\t%s\\t%s\\t%s\\t%s\\t%s\\n\",\n                            $seq,$source,$type,$min,$max,$score,$strand,$frame eq '.' ? 0 : $frame,$attr);\n\n    $self->_print($outstring);\n  }\n\n  foreach my $subfeat ($feature->get_SeqFeatures){\n    $self->_write_feature_25($subfeat,$group);\n  }\n}\n\n=head1 _write_feature_3()\n\nwrite a feature in GFF v3 format.","parameters":[{"label":"$self"},{"label":"$feature"}],"label":"_write_feature_3($self,$feature)"}},{"line":906,"name":"uri_escape","kind":12},{"line":910,"name":"uri_escape","kind":12},{"kind":12,"name":"uri_escape","line":915},{"line":919,"name":"uri_escape","kind":12},{"name":"uri_escape","kind":12,"line":923},{"kind":12,"name":"uri_escape","line":927},{"name":"uri_escape","kind":12,"line":933}]}