{"vars":[{"name":"pod","kind":12,"line":1},{"kind":2,"containerName":"","name":"base","line":77},{"name":"Util","kind":2,"containerName":"Bio::SeqFeature::Annotated::Bio::Annotation::SimpleValue::Bio::OntologyIO::Scalar","line":81},{"containerName":"main::","name":"_initialize","children":[{"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":104,"definition":"my"},{"line":104,"containerName":"_initialize","kind":13,"name":"%arg"},{"name":"$self","containerName":"_initialize","kind":13,"line":106},{"containerName":"_initialize","kind":13,"name":"%arg","line":106},{"line":108,"kind":13,"containerName":"_initialize","name":"$self"},{"line":108,"name":"name","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$arg","line":108},{"line":109,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"containerName":"_initialize","name":"description","line":109},{"line":109,"name":"$arg","kind":13,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$self","line":110},{"kind":12,"containerName":"_initialize","name":"use_score","line":110},{"kind":13,"containerName":"_initialize","name":"$arg","line":110},{"kind":13,"containerName":"_initialize","name":"$self","line":112},{"containerName":"_initialize","kind":12,"name":"_print","line":112},{"line":113,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"name","containerName":"_initialize","kind":12,"line":113},{"line":114,"containerName":"_initialize","kind":13,"name":"$self"},{"line":114,"name":"description","kind":12,"containerName":"_initialize"},{"line":115,"containerName":"_initialize","kind":13,"name":"$self"},{"line":115,"containerName":"_initialize","kind":12,"name":"use_score"},{"line":116,"kind":13,"containerName":"_initialize","name":"$self"},{"line":116,"name":"mode","containerName":"_initialize","kind":12}],"detail":"($self,%arg)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":103},"end":{"line":117,"character":9999}},"line":103,"signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::bed - read/write features from UCSC BED format\n\n=head1 SYNOPSIS\n\n  my $in = Bio::FeatureIO(-format => 'bed', -file => 'file.bed');\n  for my $feat ($in->next_feature) {\n    # do something with $feat (a Bio::SeqFeature::Annotated object)\n  }\n\n  my $out = Bio::FeatureIO(-format=>'bed');\n  for my $feat ($seq->get_seqFeatures) {\n    $out->write_feature($feat);\n  }\n\n=head1 DESCRIPTION\n\nSee L<http://www.genome.ucsc.edu/goldenPath/help/customTrack.html#BED>.\n\nCurrently for read and write only the first 6 fields (chr, start, end, name,\nscore, strand) are supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::FeatureIO::bed;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\nuse Bio::OntologyIO;\nuse Scalar::Util qw(looks_like_number);\n\n=head2 _initialize\n\n Title   : _initialize\n Function: initializes BED for reading/writing\n Args    : all optional:\n           name          description\n           ----------------------------------------------------------\n           -name         the name for the BED track, stored in header\n                         name defaults to localtime()\n           -description  the description for the BED track, stored in\n                         header.  defaults to localtime().\n           -use_score    whether or not the score attribute of\n                         features should be used when rendering them.\n                         the higher the score the darker the color.\n                         defaults to 0 (false)","parameters":[{"label":"$self"},{"label":"%arg"}],"label":"_initialize($self,%arg)"}},{"line":106,"kind":12,"containerName":"_initialize","name":"SUPER"},{"containerName":"main::","name":"use_score","children":[{"line":132,"name":"$self","containerName":"use_score","localvar":"my","kind":13,"definition":"my"},{"line":134,"name":"$self","kind":13,"containerName":"use_score"},{"line":135,"containerName":"use_score","kind":13,"name":"$self"}],"definition":"sub","kind":12,"range":{"end":{"line":136,"character":9999},"start":{"character":0,"line":131}},"line":131},{"name":"name","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"name","line":151,"definition":"my"},{"name":"$self","containerName":"name","kind":13,"line":153},{"line":154,"kind":13,"containerName":"name","name":"$self"}],"definition":"sub","kind":12,"range":{"start":{"line":150,"character":0},"end":{"character":9999,"line":155}},"line":150},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"description","kind":13,"line":170},{"name":"$self","kind":13,"containerName":"description","line":172},{"name":"$self","containerName":"description","kind":13,"line":173}],"name":"description","containerName":"main::","line":169,"kind":12,"range":{"start":{"line":169,"character":0},"end":{"line":174,"character":9999}}},{"range":{"end":{"line":216,"character":9999},"start":{"character":0,"line":177}},"kind":12,"line":177,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$feature"}],"label":"write_feature($self,$feature)"},"containerName":"main::","name":"write_feature","children":[{"definition":"my","localvar":"my","containerName":"write_feature","kind":13,"name":"$self","line":178},{"name":"$feature","containerName":"write_feature","kind":13,"line":178},{"line":179,"name":"$self","containerName":"write_feature","kind":13},{"name":"throw","kind":12,"containerName":"write_feature","line":179},{"containerName":"write_feature","kind":13,"name":"$feature","line":179},{"line":179,"containerName":"write_feature","kind":12,"name":"isa"},{"definition":"my","localvar":"my","containerName":"write_feature","kind":13,"name":"$chrom","line":181},{"line":181,"containerName":"write_feature","kind":13,"name":"$feature"},{"line":181,"containerName":"write_feature","kind":12,"name":"seq_id"},{"definition":"my","line":182,"localvar":"my","kind":13,"containerName":"write_feature","name":"$chrom_start"},{"name":"$feature","kind":13,"containerName":"write_feature","line":182},{"line":182,"name":"start","containerName":"write_feature","kind":12},{"line":183,"name":"$chrom_end","localvar":"my","kind":13,"containerName":"write_feature","definition":"my"},{"line":183,"kind":13,"containerName":"write_feature","name":"$feature"},{"line":183,"name":"end","kind":12,"containerName":"write_feature"},{"line":186,"localvar":"my","kind":13,"containerName":"write_feature","name":"$name","definition":"my"},{"definition":"my","name":"@v","kind":13,"localvar":"my","containerName":"write_feature","line":187},{"line":188,"containerName":"write_feature","kind":13,"name":"@v"},{"name":"$feature","kind":13,"containerName":"write_feature","line":188},{"line":188,"name":"annotation","kind":12,"containerName":"write_feature"},{"line":188,"kind":12,"containerName":"write_feature","name":"get_Annotations"},{"containerName":"write_feature","kind":13,"name":"$name","line":189},{"line":189,"name":"$v","kind":13,"containerName":"write_feature"},{"line":190,"name":"$self","kind":13,"containerName":"write_feature"},{"line":190,"name":"warn","kind":12,"containerName":"write_feature"},{"name":"value","kind":12,"containerName":"write_feature","line":190},{"name":"@v","kind":13,"containerName":"write_feature","line":190},{"line":190,"name":"@v","kind":13,"containerName":"write_feature"},{"line":191,"name":"@v","containerName":"write_feature","kind":13},{"kind":13,"containerName":"write_feature","name":"$feature","line":191},{"line":191,"containerName":"write_feature","kind":12,"name":"annotation"},{"name":"get_Annotations","kind":12,"containerName":"write_feature","line":191},{"name":"$name","kind":13,"containerName":"write_feature","line":192},{"kind":13,"containerName":"write_feature","name":"$v","line":192},{"line":193,"name":"$self","containerName":"write_feature","kind":13},{"name":"warn","containerName":"write_feature","kind":12,"line":193},{"containerName":"write_feature","kind":12,"name":"value","line":193},{"line":193,"containerName":"write_feature","kind":13,"name":"@v"},{"name":"@v","kind":13,"containerName":"write_feature","line":193},{"line":195,"name":"$name","containerName":"write_feature","kind":13},{"containerName":"write_feature","kind":13,"name":"$name","line":198},{"name":"$name","kind":13,"containerName":"write_feature","line":199},{"line":199,"containerName":"write_feature","kind":13,"name":"$name"},{"containerName":"write_feature","kind":12,"name":"value","line":199},{"kind":13,"containerName":"write_feature","name":"$chrom","line":201},{"name":"$chrom","containerName":"write_feature","kind":13,"line":202},{"line":202,"name":"$chrom","containerName":"write_feature","kind":13},{"line":202,"name":"value","kind":12,"containerName":"write_feature"},{"definition":"my","line":205,"name":"$score","containerName":"write_feature","localvar":"my","kind":13},{"containerName":"write_feature","kind":13,"name":"$feature","line":205},{"line":205,"containerName":"write_feature","kind":12,"name":"score"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_feature","name":"$strand","line":206},{"line":206,"name":"$feature","kind":13,"containerName":"write_feature"},{"containerName":"write_feature","kind":12,"name":"strand","line":206},{"kind":13,"localvar":"my","containerName":"write_feature","name":"$thick_start","line":207,"definition":"my"},{"name":"$thick_end","localvar":"my","containerName":"write_feature","kind":13,"line":208,"definition":"my"},{"definition":"my","line":209,"name":"$reserved","localvar":"my","kind":13,"containerName":"write_feature"},{"definition":"my","line":210,"name":"$block_count","localvar":"my","kind":13,"containerName":"write_feature"},{"definition":"my","name":"$block_sizes","localvar":"my","containerName":"write_feature","kind":13,"line":211},{"line":212,"name":"$block_starts","localvar":"my","containerName":"write_feature","kind":13,"definition":"my"},{"name":"$self","containerName":"write_feature","kind":13,"line":214},{"line":214,"name":"_print","kind":12,"containerName":"write_feature"},{"containerName":"write_feature","kind":13,"name":"$chrom","line":214},{"line":214,"name":"$chrom_start","kind":13,"containerName":"write_feature"},{"name":"$chrom_end","containerName":"write_feature","kind":13,"line":214},{"kind":13,"containerName":"write_feature","name":"$name","line":214},{"name":"$score","containerName":"write_feature","kind":13,"line":214},{"line":214,"kind":13,"containerName":"write_feature","name":"$strand"},{"kind":13,"containerName":"write_feature","name":"$thick_start","line":214},{"line":214,"name":"$thick_end","kind":13,"containerName":"write_feature"},{"name":"$reserved","containerName":"write_feature","kind":13,"line":214},{"kind":13,"containerName":"write_feature","name":"$block_count","line":214},{"line":214,"name":"$block_sizes","kind":13,"containerName":"write_feature"},{"name":"$block_starts","containerName":"write_feature","kind":13,"line":214},{"line":215,"kind":13,"containerName":"write_feature","name":"$self"},{"kind":12,"containerName":"write_feature","name":"write_feature","line":215},{"name":"$feature","kind":13,"containerName":"write_feature","line":215},{"line":215,"name":"get_SeqFeatures","containerName":"write_feature","kind":12}],"detail":"($self,$feature)","definition":"sub"},{"line":218,"range":{"end":{"line":242,"character":9999},"start":{"character":0,"line":218}},"kind":12,"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_feature","name":"$self","line":219},{"line":220,"kind":13,"localvar":"my","containerName":"next_feature","name":"$line","definition":"my"},{"name":"$self","containerName":"next_feature","kind":13,"line":220},{"line":220,"name":"_readline","kind":12,"containerName":"next_feature"},{"definition":"my","line":222,"containerName":"next_feature","localvar":"my","kind":13,"name":"$seq_id"},{"name":"$start","kind":13,"containerName":"next_feature","line":222},{"line":222,"name":"$end","kind":13,"containerName":"next_feature"},{"containerName":"next_feature","kind":13,"name":"$name","line":222},{"name":"$score","containerName":"next_feature","kind":13,"line":222},{"line":222,"name":"$strand","containerName":"next_feature","kind":13},{"containerName":"next_feature","kind":13,"name":"$line","line":222},{"line":223,"name":"$strand","kind":13,"containerName":"next_feature"},{"name":"$start","containerName":"next_feature","kind":13,"line":225},{"name":"$end","containerName":"next_feature","kind":13,"line":225},{"line":227,"name":"$self","kind":13,"containerName":"next_feature"},{"name":"next_feature","containerName":"next_feature","kind":12,"line":227},{"line":230,"name":"$feature","containerName":"next_feature","localvar":"my","kind":13,"definition":"my"},{"line":230,"name":"new","containerName":"next_feature","kind":12},{"line":230,"kind":13,"containerName":"next_feature","name":"$start"},{"line":231,"containerName":"next_feature","kind":13,"name":"$end"},{"line":232,"kind":13,"containerName":"next_feature","name":"$score"},{"containerName":"next_feature","kind":13,"name":"$score","line":232},{"line":233,"name":"$strand","containerName":"next_feature","kind":13},{"line":233,"kind":13,"containerName":"next_feature","name":"$strand"},{"line":235,"kind":13,"containerName":"next_feature","name":"$feature"},{"name":"seq_id","kind":12,"containerName":"next_feature","line":235},{"containerName":"next_feature","kind":13,"name":"$seq_id","line":235},{"name":"$name","kind":13,"containerName":"next_feature","line":236},{"definition":"my","name":"$sv","localvar":"my","kind":13,"containerName":"next_feature","line":237},{"line":237,"name":"new","kind":12,"containerName":"next_feature"},{"containerName":"next_feature","kind":13,"name":"$name","line":237},{"kind":13,"containerName":"next_feature","name":"$feature","line":238},{"line":238,"containerName":"next_feature","kind":12,"name":"annotation"},{"containerName":"next_feature","kind":12,"name":"add_Annotation","line":238},{"line":238,"containerName":"next_feature","kind":13,"name":"$sv"},{"line":241,"containerName":"next_feature","kind":13,"name":"$feature"}],"name":"next_feature","containerName":"main::","definition":"sub"},{"line":225,"name":"looks_like_number","kind":12},{"name":"looks_like_number","kind":12,"line":225},{"line":230,"containerName":"SeqFeature::Annotated","kind":12,"name":"Bio"},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":237}],"version":5}