{"version":5,"vars":[{"containerName":"","kind":2,"name":"vars","line":155},{"kind":2,"containerName":"","name":"base","line":168},{"kind":13,"containerName":null,"name":"%COORDINATE_SYSTEMS","line":172},{"name":"peptide","kind":12,"line":173},{"name":"propeptide","kind":12,"line":174},{"name":"frame","kind":12,"line":175},{"line":176,"kind":12,"name":"cds"},{"line":177,"name":"negative_intron","kind":12},{"line":178,"name":"intron","kind":12},{"name":"exon","kind":12,"line":179},{"kind":12,"name":"inex","line":180},{"line":181,"kind":12,"name":"gene"},{"line":182,"kind":12,"name":"chr"},{"line":185,"kind":13,"containerName":null,"name":"%COORDINATE_INTS"},{"line":198,"name":"$TRANSLATION","containerName":null,"kind":13},{"line":198,"name":"%COORDINATE_SYSTEMS","containerName":null,"kind":13},{"name":"%COORDINATE_SYSTEMS","kind":13,"containerName":null,"line":199},{"containerName":null,"kind":13,"name":"%DAG","line":201},{"containerName":null,"kind":13,"name":"%NOZERO_VALUES","line":214},{"line":215,"name":"%NOZERO_KEYS","containerName":null,"kind":13},{"name":"new","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":219,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":219},{"line":220,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":220},{"containerName":"new","kind":13,"name":"@args","line":220},{"containerName":"new","localvar":"my","kind":13,"name":"$graph","line":223,"definition":"my"},{"kind":12,"containerName":"new","name":"new","line":223},{"containerName":"new","kind":13,"name":"$graph","line":224},{"name":"hash_of_arrays","containerName":"new","kind":12,"line":224},{"name":"$DAG","kind":13,"containerName":"new","line":224},{"line":225,"kind":13,"containerName":"new","name":"$self"},{"line":225,"containerName":"new","kind":12,"name":"graph"},{"line":225,"containerName":"new","kind":13,"name":"$graph"},{"line":227,"name":"$in","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":227,"name":"$out","kind":13,"containerName":"new"},{"line":227,"name":"$peptide_offset","containerName":"new","kind":13},{"line":227,"name":"$exons","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$cds","line":228},{"kind":13,"containerName":"new","name":"$nozero","line":228},{"name":"$strict","containerName":"new","kind":13,"line":228},{"line":229,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_rearrange","line":229},{"line":237,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":240},{"kind":13,"containerName":"new","name":"$in","line":242},{"line":242,"name":"$self","containerName":"new","kind":13},{"line":242,"containerName":"new","kind":12,"name":"in"},{"containerName":"new","kind":13,"name":"$in","line":242},{"name":"$out","containerName":"new","kind":13,"line":243},{"line":243,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"out","line":243},{"line":243,"containerName":"new","kind":13,"name":"$out"},{"line":244,"name":"$cds","kind":13,"containerName":"new"},{"line":244,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"cds","line":244},{"line":244,"containerName":"new","kind":13,"name":"$cds"},{"line":245,"name":"$exons","kind":13,"containerName":"new"},{"name":"$exons","kind":13,"containerName":"new","line":245},{"line":245,"containerName":"new","kind":13,"name":"$self"},{"line":245,"kind":12,"containerName":"new","name":"exons"},{"line":245,"name":"$exons","kind":13,"containerName":"new"},{"line":246,"name":"$peptide_offset","kind":13,"containerName":"new"},{"line":246,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"peptide_offset","line":246},{"containerName":"new","kind":13,"name":"$peptide_offset","line":246},{"name":"$nozero","kind":13,"containerName":"new","line":247},{"line":247,"containerName":"new","kind":13,"name":"$self"},{"line":247,"containerName":"new","kind":12,"name":"nozero"},{"kind":13,"containerName":"new","name":"$nozero","line":247},{"line":248,"kind":13,"containerName":"new","name":"$strict"},{"name":"$self","containerName":"new","kind":13,"line":248},{"containerName":"new","kind":12,"name":"strict","line":248},{"line":248,"name":"$strict","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":250}],"detail":"($class,@args)","definition":"sub","range":{"start":{"character":0,"line":218},"end":{"character":9999,"line":251}},"kind":12,"line":218,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"}},{"name":"SUPER","containerName":"new","kind":12,"line":220},{"line":223,"containerName":"Coordinate::Graph","kind":12,"name":"Bio"},{"name":"_direction","kind":12,"line":240},{"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"in($self,$value)"},"range":{"start":{"line":264,"character":0},"end":{"line":274,"character":9999}},"kind":12,"line":264,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"in","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"in","line":265},{"name":"$value","containerName":"in","kind":13,"line":265},{"name":"$value","containerName":"in","kind":13,"line":266},{"line":267,"name":"$self","containerName":"in","kind":13},{"containerName":"in","kind":12,"name":"throw","line":267},{"line":268,"containerName":"in","kind":13,"name":"%COORDINATE_SYSTEMS"},{"line":269,"kind":13,"containerName":"in","name":"$COORDINATE_SYSTEMS"},{"line":269,"containerName":"in","kind":13,"name":"$value"},{"line":271,"kind":13,"containerName":"in","name":"$self"},{"line":271,"containerName":"in","kind":13,"name":"$COORDINATE_SYSTEMS"},{"line":271,"name":"$value","containerName":"in","kind":13},{"name":"$COORDINATE_INTS","kind":13,"containerName":"in","line":273},{"kind":13,"containerName":"in","name":"$self","line":273}]},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"out","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"out","name":"$self","line":289},{"kind":13,"containerName":"out","name":"$value","line":289},{"containerName":"out","kind":13,"name":"$value","line":290},{"line":291,"kind":13,"containerName":"out","name":"$self"},{"line":291,"containerName":"out","kind":12,"name":"throw"},{"kind":13,"containerName":"out","name":"%COORDINATE_SYSTEMS","line":292},{"line":293,"containerName":"out","kind":13,"name":"$COORDINATE_SYSTEMS"},{"line":293,"kind":13,"containerName":"out","name":"$value"},{"name":"$self","containerName":"out","kind":13,"line":295},{"containerName":"out","kind":13,"name":"$COORDINATE_SYSTEMS","line":295},{"name":"$value","containerName":"out","kind":13,"line":295},{"kind":13,"containerName":"out","name":"$COORDINATE_INTS","line":297},{"line":297,"kind":13,"containerName":"out","name":"$self"}],"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"out($self,$value)"},"kind":12,"range":{"start":{"character":0,"line":288},"end":{"line":298,"character":9999}},"line":288},{"name":"strict","containerName":"main::","children":[{"definition":"my","line":314,"kind":13,"localvar":"my","containerName":"strict","name":"$self"},{"containerName":"strict","kind":13,"name":"$value","line":314},{"line":315,"containerName":"strict","kind":13,"name":"$value"},{"name":"$value","containerName":"strict","kind":13,"line":316},{"line":316,"name":"$self","kind":13,"containerName":"strict"},{"line":316,"containerName":"strict","kind":13,"name":"$self"},{"containerName":"strict","kind":13,"name":"$self","line":319}],"detail":"($self,$value)","definition":"sub","range":{"end":{"line":320,"character":9999},"start":{"line":313,"character":0}},"kind":12,"line":313,"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"strict($self,$value)"}},{"kind":12,"range":{"end":{"character":9999,"line":345},"start":{"line":337,"character":0}},"line":337,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'","label":"nozero($self,$value)"},"containerName":"main::","name":"nozero","children":[{"line":338,"name":"$self","localvar":"my","containerName":"nozero","kind":13,"definition":"my"},{"line":338,"containerName":"nozero","kind":13,"name":"$value"},{"containerName":"nozero","kind":13,"name":"$value","line":340},{"line":341,"name":"$self","kind":13,"containerName":"nozero"},{"containerName":"nozero","kind":12,"name":"throw","line":341},{"line":342,"containerName":"nozero","kind":13,"name":"$NOZERO_VALUES"},{"line":343,"containerName":"nozero","kind":13,"name":"$NOZERO_VALUES"},{"line":343,"containerName":"nozero","kind":13,"name":"$value"},{"line":344,"kind":13,"containerName":"nozero","name":"$self"},{"line":344,"name":"$NOZERO_VALUES","kind":13,"containerName":"nozero"},{"name":"$value","containerName":"nozero","kind":13,"line":344}],"detail":"($self,$value)","definition":"sub"},{"definition":"my","line":347,"name":"$res","localvar":"my","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":347},{"line":348,"kind":13,"containerName":null,"name":"%NOZERO_KEYS"},{"kind":13,"containerName":null,"name":"$res","line":348},{"containerName":"main::","name":"graph","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"graph","name":"$self","line":364},{"line":364,"name":"$value","containerName":"graph","kind":13},{"containerName":"graph","kind":13,"name":"$value","line":365},{"kind":13,"containerName":"graph","name":"$self","line":366},{"line":366,"kind":12,"containerName":"graph","name":"throw"},{"line":367,"name":"$value","containerName":"graph","kind":13},{"name":"isa","kind":12,"containerName":"graph","line":367},{"name":"$self","containerName":"graph","kind":13,"line":368},{"containerName":"graph","kind":13,"name":"$value","line":368},{"name":"$self","kind":13,"containerName":"graph","line":370}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":363},"end":{"line":371,"character":9999}},"line":363,"signature":{"label":"graph($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)"}},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":385,"localvar":"my","containerName":"peptide","kind":13,"name":"$self"},{"containerName":"peptide","kind":13,"name":"$value","line":385},{"line":386,"containerName":"peptide","kind":13,"name":"$value"},{"kind":13,"containerName":"peptide","name":"$self","line":387},{"name":"throw","containerName":"peptide","kind":12,"line":387},{"line":387,"name":"$value","kind":13,"containerName":"peptide"},{"containerName":"peptide","kind":13,"name":"$value","line":388},{"name":"isa","kind":12,"containerName":"peptide","line":388},{"containerName":"peptide","kind":13,"name":"$self","line":390},{"containerName":"peptide","kind":12,"name":"throw","line":390},{"name":"$value","containerName":"peptide","kind":13,"line":391},{"line":391,"name":"start","containerName":"peptide","kind":12},{"kind":13,"containerName":"peptide","name":"$self","line":392},{"line":392,"name":"$value","kind":13,"containerName":"peptide"},{"name":"start","kind":12,"containerName":"peptide","line":392},{"line":394,"name":"$self","containerName":"peptide","kind":13},{"line":394,"containerName":"peptide","kind":12,"name":"throw"},{"kind":13,"containerName":"peptide","name":"$value","line":395},{"line":395,"kind":12,"containerName":"peptide","name":"end"},{"name":"$self","kind":13,"containerName":"peptide","line":396},{"name":"$value","kind":13,"containerName":"peptide","line":396},{"kind":12,"containerName":"peptide","name":"end","line":396},{"line":396,"containerName":"peptide","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"peptide","name":"$a","line":399},{"line":399,"name":"$self","containerName":"peptide","kind":13},{"line":400,"name":"_create_pair","kind":12,"containerName":"peptide"},{"line":400,"kind":13,"containerName":"peptide","name":"$self"},{"kind":12,"containerName":"peptide","name":"strict","line":400},{"name":"$self","containerName":"peptide","kind":13,"line":401},{"line":401,"name":"$self","kind":13,"containerName":"peptide"},{"line":402,"name":"$mapper","localvar":"my","kind":13,"containerName":"peptide","definition":"my"},{"line":402,"containerName":"peptide","kind":13,"name":"$COORDINATE_SYSTEMS"},{"line":402,"containerName":"peptide","kind":13,"name":"$COORDINATE_SYSTEMS"},{"name":"$self","containerName":"peptide","kind":13,"line":403},{"line":403,"name":"$mapper","containerName":"peptide","kind":13},{"line":403,"name":"$a","containerName":"peptide","kind":13},{"line":406,"kind":12,"containerName":"peptide","name":"new"},{"name":"$self","containerName":"peptide","kind":13,"line":407},{"line":408,"containerName":"peptide","kind":13,"name":"$self"},{"line":408,"name":"$self","kind":13,"containerName":"peptide"},{"name":"$self","containerName":"peptide","kind":13,"line":410},{"kind":12,"containerName":"peptide","name":"verbose","line":410}],"name":"peptide","containerName":"main::","signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object","parameters":[{"label":"$self"},{"label":"$value"}],"label":"peptide($self,$value)"},"line":384,"kind":12,"range":{"end":{"character":9999,"line":412},"start":{"line":384,"character":0}}},{"kind":12,"containerName":"Location::Simple","name":"Bio","line":405},{"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$offset"},{"label":"$len"}],"label":"peptide_offset($self,$offset,$len)"},"line":424,"kind":12,"range":{"end":{"character":9999,"line":443},"start":{"character":0,"line":424}},"definition":"sub","detail":"($self,$offset,$len)","children":[{"definition":"my","name":"$self","containerName":"peptide_offset","localvar":"my","kind":13,"line":425},{"line":425,"kind":13,"containerName":"peptide_offset","name":"$offset"},{"line":425,"kind":13,"containerName":"peptide_offset","name":"$len"},{"name":"$offset","containerName":"peptide_offset","kind":13,"line":426},{"name":"$self","kind":13,"containerName":"peptide_offset","line":427},{"line":427,"kind":12,"containerName":"peptide_offset","name":"throw"},{"line":428,"name":"$offset","kind":13,"containerName":"peptide_offset"},{"containerName":"peptide_offset","kind":13,"name":"$self","line":429},{"name":"$offset","kind":13,"containerName":"peptide_offset","line":429},{"name":"$len","kind":13,"containerName":"peptide_offset","line":431},{"line":432,"name":"$self","kind":13,"containerName":"peptide_offset"},{"kind":12,"containerName":"peptide_offset","name":"throw","line":432},{"line":433,"name":"$len","containerName":"peptide_offset","kind":13},{"name":"$self","kind":13,"containerName":"peptide_offset","line":434},{"name":"$len","containerName":"peptide_offset","kind":13,"line":434},{"name":"$a","localvar":"my","kind":13,"containerName":"peptide_offset","line":437,"definition":"my"},{"name":"$self","kind":13,"containerName":"peptide_offset","line":437},{"line":438,"containerName":"peptide_offset","kind":12,"name":"_create_pair"},{"line":438,"name":"$self","kind":13,"containerName":"peptide_offset"},{"name":"strict","containerName":"peptide_offset","kind":12,"line":438},{"line":438,"name":"$offset","containerName":"peptide_offset","kind":13},{"name":"$self","containerName":"peptide_offset","kind":13,"line":438},{"line":439,"containerName":"peptide_offset","localvar":"my","kind":13,"name":"$mapper","definition":"my"},{"line":439,"kind":13,"containerName":"peptide_offset","name":"$COORDINATE_SYSTEMS"},{"kind":13,"containerName":"peptide_offset","name":"$COORDINATE_SYSTEMS","line":439},{"line":440,"name":"$self","containerName":"peptide_offset","kind":13},{"line":440,"name":"$mapper","kind":13,"containerName":"peptide_offset"},{"line":440,"containerName":"peptide_offset","kind":13,"name":"$a"},{"name":"$self","containerName":"peptide_offset","kind":13,"line":442}],"name":"peptide_offset","containerName":"main::"},{"containerName":"main::","name":"peptide_length","children":[{"line":457,"containerName":"peptide_length","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"peptide_length","kind":13,"name":"$len","line":457},{"name":"$len","kind":13,"containerName":"peptide_length","line":458},{"name":"$self","kind":13,"containerName":"peptide_length","line":459},{"kind":12,"containerName":"peptide_length","name":"throw","line":459},{"line":460,"kind":13,"containerName":"peptide_length","name":"$len"},{"line":460,"name":"$len","containerName":"peptide_length","kind":13},{"line":461,"name":"$self","kind":13,"containerName":"peptide_length"},{"name":"$len","containerName":"peptide_length","kind":13,"line":461},{"line":463,"name":"$self","containerName":"peptide_length","kind":13}],"detail":"($self,$len)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":456},"end":{"line":464,"character":9999}},"line":456,"signature":{"label":"peptide_length($self,$len)","documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$len"}]}},{"signature":{"label":"exons($self,@value)","parameters":[{"label":"$self"},{"label":"@value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates"},"kind":12,"range":{"start":{"character":0,"line":481},"end":{"line":712,"character":9999}},"line":481,"detail":"($self,@value)","definition":"sub","name":"exons","containerName":"main::","children":[{"line":482,"name":"$self","localvar":"my","containerName":"exons","kind":13,"definition":"my"},{"name":"@value","containerName":"exons","kind":13,"line":482},{"definition":"my","line":483,"kind":13,"localvar":"my","containerName":"exons","name":"$cds_mapper"},{"line":483,"name":"$COORDINATE_SYSTEMS","kind":13,"containerName":"exons"},{"name":"$COORDINATE_SYSTEMS","containerName":"exons","kind":13,"line":483},{"definition":"my","name":"$inex_mapper","localvar":"my","kind":13,"containerName":"exons","line":484},{"kind":13,"containerName":"exons","name":"$COORDINATE_SYSTEMS","line":485},{"line":485,"name":"$COORDINATE_SYSTEMS","containerName":"exons","kind":13},{"definition":"my","line":486,"containerName":"exons","localvar":"my","kind":13,"name":"$exon_mapper"},{"name":"$COORDINATE_SYSTEMS","kind":13,"containerName":"exons","line":487},{"line":487,"name":"$COORDINATE_SYSTEMS","containerName":"exons","kind":13},{"name":"$intron_mapper","localvar":"my","kind":13,"containerName":"exons","line":488,"definition":"my"},{"line":489,"name":"$COORDINATE_SYSTEMS","containerName":"exons","kind":13},{"line":489,"containerName":"exons","kind":13,"name":"$COORDINATE_SYSTEMS"},{"definition":"my","line":490,"kind":13,"localvar":"my","containerName":"exons","name":"$negative_intron_mapper"},{"line":491,"kind":13,"containerName":"exons","name":"$COORDINATE_SYSTEMS"},{"kind":13,"containerName":"exons","name":"$COORDINATE_SYSTEMS","line":491},{"definition":"my","name":"$exon_cds_mapper","localvar":"my","kind":13,"containerName":"exons","line":492},{"name":"$COORDINATE_SYSTEMS","containerName":"exons","kind":13,"line":492},{"line":492,"kind":13,"containerName":"exons","name":"$COORDINATE_SYSTEMS"},{"kind":13,"containerName":"exons","name":"@value","line":494},{"line":495,"name":"$value","containerName":"exons","kind":13},{"containerName":"exons","kind":13,"name":"$value","line":496},{"line":496,"kind":12,"containerName":"exons","name":"isa"},{"line":497,"containerName":"exons","kind":13,"name":"$value"},{"line":497,"kind":12,"containerName":"exons","name":"location"},{"line":497,"kind":12,"containerName":"exons","name":"isa"},{"name":"@value","kind":13,"containerName":"exons","line":498},{"name":"$value","containerName":"exons","kind":13,"line":498},{"line":498,"name":"location","containerName":"exons","kind":12},{"line":498,"kind":12,"containerName":"exons","name":"each_Location"},{"line":500,"name":"$self","kind":13,"containerName":"exons"},{"line":500,"name":"throw","kind":12,"containerName":"exons"},{"line":501,"kind":13,"containerName":"exons","name":"@value"},{"name":"$self","kind":13,"containerName":"exons","line":502},{"kind":12,"containerName":"exons","name":"throw","line":502},{"line":503,"name":"$value","kind":13,"containerName":"exons"},{"line":504,"name":"$value","kind":13,"containerName":"exons"},{"name":"$value","containerName":"exons","kind":13,"line":504},{"line":504,"kind":12,"containerName":"exons","name":"isa"},{"kind":13,"containerName":"exons","name":"$value","line":511},{"line":511,"name":"strand","containerName":"exons","kind":12},{"line":512,"containerName":"exons","kind":13,"name":"$value"},{"line":512,"kind":12,"containerName":"exons","name":"strand"},{"line":513,"containerName":"exons","kind":13,"name":"@value"},{"line":514,"name":"$b","kind":13,"containerName":"exons"},{"containerName":"exons","kind":13,"name":"$a","line":514},{"name":"start","kind":12,"containerName":"exons","line":515},{"line":516,"kind":13,"containerName":"exons","name":"@value"},{"line":518,"kind":13,"containerName":"exons","name":"$self"},{"line":518,"kind":12,"containerName":"exons","name":"cds"},{"line":519,"name":"$self","containerName":"exons","kind":13},{"name":"cds","kind":12,"containerName":"exons","line":519},{"line":520,"name":"new","containerName":"exons","kind":12},{"line":520,"name":"$value","containerName":"exons","kind":13},{"kind":12,"containerName":"exons","name":"start","line":520},{"name":"$value","kind":13,"containerName":"exons","line":521},{"line":521,"name":"end","containerName":"exons","kind":12},{"line":522,"name":"$value","containerName":"exons","kind":13},{"line":522,"name":"strand","kind":12,"containerName":"exons"},{"line":523,"name":"$value","kind":13,"containerName":"exons"},{"name":"seq_id","kind":12,"containerName":"exons","line":523},{"line":524,"containerName":"exons","kind":13,"name":"$self"},{"line":524,"name":"verbose","kind":12,"containerName":"exons"},{"line":529,"containerName":"exons","kind":13,"name":"@value"},{"line":530,"name":"$a","kind":13,"containerName":"exons"},{"containerName":"exons","kind":13,"name":"$b","line":530},{"line":531,"name":"start","containerName":"exons","kind":12},{"name":"@value","kind":13,"containerName":"exons","line":532},{"line":533,"kind":13,"containerName":"exons","name":"$self"},{"line":533,"name":"cds","containerName":"exons","kind":12},{"line":534,"name":"$self","kind":13,"containerName":"exons"},{"containerName":"exons","kind":12,"name":"cds","line":534},{"line":535,"name":"new","containerName":"exons","kind":12},{"line":535,"name":"$value","kind":13,"containerName":"exons"},{"line":535,"name":"start","kind":12,"containerName":"exons"},{"line":536,"name":"$value","kind":13,"containerName":"exons"},{"kind":12,"containerName":"exons","name":"end","line":536},{"line":537,"kind":13,"containerName":"exons","name":"$value"},{"line":537,"name":"strand","containerName":"exons","kind":12},{"name":"$value","containerName":"exons","kind":13,"line":538},{"line":538,"name":"seq_id","kind":12,"containerName":"exons"},{"line":539,"kind":13,"containerName":"exons","name":"$self"},{"containerName":"exons","kind":12,"name":"verbose","line":539},{"line":546,"containerName":"exons","kind":13,"name":"$self"},{"line":546,"name":"@value","kind":13,"containerName":"exons"},{"name":"@exons","containerName":"exons","localvar":"my","kind":13,"line":550,"definition":"my"},{"name":"$gene_mapper","kind":13,"localvar":"my","containerName":"exons","line":552,"definition":"my"},{"line":553,"containerName":"exons","kind":13,"name":"$self"},{"line":553,"name":"$gene_mapper","containerName":"exons","kind":13},{"kind":13,"localvar":"my","containerName":"exons","name":"$tmp_in","line":555,"definition":"my"},{"name":"$self","kind":13,"containerName":"exons","line":555},{"line":556,"kind":13,"localvar":"my","containerName":"exons","name":"$tmp_out","definition":"my"},{"name":"$self","kind":13,"containerName":"exons","line":556},{"definition":"my","line":557,"name":"$tmp_verb","kind":13,"localvar":"my","containerName":"exons"},{"line":557,"containerName":"exons","kind":13,"name":"$self"},{"name":"verbose","kind":12,"containerName":"exons","line":557},{"name":"$self","kind":13,"containerName":"exons","line":558},{"line":558,"containerName":"exons","kind":12,"name":"verbose"},{"containerName":"exons","kind":13,"name":"$self","line":560},{"kind":12,"containerName":"exons","name":"in","line":560},{"containerName":"exons","kind":13,"name":"$self","line":561},{"line":561,"name":"out","kind":12,"containerName":"exons"},{"line":562,"name":"@exons","containerName":"exons","kind":13},{"kind":13,"containerName":"exons","name":"$self","line":562},{"line":562,"name":"map","kind":12,"containerName":"exons"},{"kind":13,"containerName":"exons","name":"@value","line":562},{"name":"$self","kind":13,"containerName":"exons","line":564},{"name":"$tmp_in","containerName":"exons","kind":13,"line":564},{"line":565,"name":"$self","kind":13,"containerName":"exons"},{"containerName":"exons","kind":13,"name":"$tmp_out","line":565},{"containerName":"exons","kind":13,"name":"$self","line":566},{"line":566,"containerName":"exons","kind":12,"name":"verbose"},{"name":"$tmp_verb","kind":13,"containerName":"exons","line":566},{"name":"@exons","kind":13,"containerName":"exons","line":568},{"name":"@value","containerName":"exons","kind":13,"line":568},{"definition":"my","line":571,"name":"$cds_map","containerName":"exons","localvar":"my","kind":13},{"line":571,"name":"new","kind":12,"containerName":"exons"},{"line":572,"name":"$inex_map","containerName":"exons","localvar":"my","kind":13,"definition":"my"},{"line":572,"name":"new","kind":12,"containerName":"exons"},{"line":573,"name":"$exon_map","localvar":"my","containerName":"exons","kind":13,"definition":"my"},{"line":573,"name":"new","kind":12,"containerName":"exons"},{"definition":"my","line":574,"name":"$exon_cds_map","containerName":"exons","localvar":"my","kind":13},{"line":574,"name":"new","containerName":"exons","kind":12},{"containerName":"exons","localvar":"my","kind":13,"name":"$intron_map","line":575,"definition":"my"},{"name":"new","kind":12,"containerName":"exons","line":575},{"definition":"my","line":576,"name":"$negative_intron_map","kind":13,"localvar":"my","containerName":"exons"},{"containerName":"exons","kind":12,"name":"new","line":576},{"definition":"my","line":578,"kind":13,"localvar":"my","containerName":"exons","name":"$tr_end"},{"definition":"my","line":579,"name":"$coffset","localvar":"my","containerName":"exons","kind":13},{"definition":"my","name":"$exon_counter","localvar":"my","kind":13,"containerName":"exons","line":580},{"kind":13,"localvar":"my","containerName":"exons","name":"$prev_exon_end","line":581,"definition":"my"},{"name":"$exon","localvar":"my","kind":13,"containerName":"exons","line":583,"definition":"my"},{"line":583,"name":"@exons","containerName":"exons","kind":13},{"name":"$exon_counter","kind":13,"containerName":"exons","line":584},{"line":590,"kind":13,"localvar":"my","containerName":"exons","name":"$match1","definition":"my"},{"name":"new","kind":12,"containerName":"exons","line":591},{"name":"$exon","kind":13,"containerName":"exons","line":592},{"line":592,"kind":12,"containerName":"exons","name":"start"},{"line":593,"kind":13,"containerName":"exons","name":"$exon"},{"containerName":"exons","kind":12,"name":"end","line":593},{"line":595,"name":"$self","kind":13,"containerName":"exons"},{"line":595,"name":"verbose","kind":12,"containerName":"exons"},{"definition":"my","line":597,"name":"$match2","localvar":"my","containerName":"exons","kind":13},{"line":598,"name":"new","containerName":"exons","kind":12},{"name":"$tr_end","kind":13,"containerName":"exons","line":599},{"name":"$tr_end","containerName":"exons","kind":13,"line":600},{"name":"$exon","kind":13,"containerName":"exons","line":600},{"line":600,"name":"end","kind":12,"containerName":"exons"},{"line":600,"name":"$exon","kind":13,"containerName":"exons"},{"kind":12,"containerName":"exons","name":"start","line":600},{"line":601,"name":"$exon","containerName":"exons","kind":13},{"line":601,"name":"strand","kind":12,"containerName":"exons"},{"line":602,"name":"$self","containerName":"exons","kind":13},{"containerName":"exons","kind":12,"name":"verbose","line":602},{"line":604,"containerName":"exons","kind":13,"name":"$cds_map"},{"line":604,"kind":12,"containerName":"exons","name":"add_mapper"},{"line":605,"containerName":"exons","kind":12,"name":"new"},{"name":"$match1","containerName":"exons","kind":13,"line":605},{"name":"$match2","kind":13,"containerName":"exons","line":606},{"name":"$exon","kind":13,"containerName":"exons","line":610},{"kind":12,"containerName":"exons","name":"start","line":610},{"name":"$exon","containerName":"exons","kind":13,"line":610},{"line":610,"name":"end","kind":12,"containerName":"exons"},{"containerName":"exons","kind":13,"name":"$coffset","line":611},{"name":"$tr_end","kind":13,"containerName":"exons","line":611},{"line":611,"containerName":"exons","kind":13,"name":"$exon"},{"containerName":"exons","kind":12,"name":"start","line":611},{"kind":13,"containerName":"exons","name":"$tr_end","line":613},{"name":"$tr_end","kind":13,"containerName":"exons","line":613},{"name":"$exon","containerName":"exons","kind":13,"line":613},{"kind":12,"containerName":"exons","name":"end","line":613},{"containerName":"exons","kind":13,"name":"$exon","line":613},{"line":613,"containerName":"exons","kind":12,"name":"start"},{"name":"$prev_exon_end","containerName":"exons","kind":13,"line":619},{"definition":"my","line":620,"kind":13,"localvar":"my","containerName":"exons","name":"$match3"},{"line":621,"name":"new","kind":12,"containerName":"exons"},{"kind":13,"containerName":"exons","name":"$prev_exon_end","line":622},{"name":"$exon","containerName":"exons","kind":13,"line":623},{"line":623,"name":"start","containerName":"exons","kind":12},{"kind":13,"containerName":"exons","name":"$exon","line":624},{"line":624,"name":"strand","kind":12,"containerName":"exons"},{"name":"$self","containerName":"exons","kind":13,"line":625},{"line":625,"containerName":"exons","kind":12,"name":"verbose"},{"line":627,"localvar":"my","kind":13,"containerName":"exons","name":"$match4","definition":"my"},{"name":"new","kind":12,"containerName":"exons","line":628},{"line":628,"name":"$exon_counter","kind":13,"containerName":"exons"},{"containerName":"exons","kind":13,"name":"$exon","line":630},{"name":"start","containerName":"exons","kind":12,"line":630},{"line":630,"name":"$prev_exon_end","kind":13,"containerName":"exons"},{"line":631,"kind":13,"containerName":"exons","name":"$exon"},{"line":631,"name":"strand","kind":12,"containerName":"exons"},{"line":632,"name":"$self","kind":13,"containerName":"exons"},{"name":"verbose","kind":12,"containerName":"exons","line":632},{"definition":"my","kind":13,"localvar":"my","containerName":"exons","name":"$match5","line":635},{"name":"new","containerName":"exons","kind":12,"line":636},{"line":636,"name":"$exon_counter","kind":13,"containerName":"exons"},{"line":637,"name":"$exon","kind":13,"containerName":"exons"},{"line":637,"containerName":"exons","kind":12,"name":"start"},{"containerName":"exons","kind":13,"name":"$prev_exon_end","line":637},{"line":639,"name":"$exon","kind":13,"containerName":"exons"},{"name":"strand","containerName":"exons","kind":12,"line":639},{"name":"$self","kind":13,"containerName":"exons","line":640},{"line":640,"containerName":"exons","kind":12,"name":"verbose"},{"name":"$inex_map","kind":13,"containerName":"exons","line":642},{"line":642,"kind":12,"containerName":"exons","name":"add_mapper"},{"kind":12,"containerName":"exons","name":"new","line":643},{"name":"$match3","containerName":"exons","kind":13,"line":643},{"line":645,"kind":13,"containerName":"exons","name":"$match4"},{"containerName":"exons","kind":13,"name":"$intron_map","line":647},{"containerName":"exons","kind":12,"name":"add_mapper","line":647},{"kind":12,"containerName":"exons","name":"new","line":648},{"line":648,"name":"$self","kind":13,"containerName":"exons"},{"line":648,"containerName":"exons","kind":12,"name":"_clone_loc"},{"line":648,"name":"$match3","containerName":"exons","kind":13},{"kind":13,"containerName":"exons","name":"$self","line":649},{"line":649,"name":"_clone_loc","kind":12,"containerName":"exons"},{"line":649,"name":"$match4","kind":13,"containerName":"exons"},{"line":652,"name":"$negative_intron_map","containerName":"exons","kind":13},{"kind":12,"containerName":"exons","name":"add_mapper","line":652},{"line":653,"name":"new","kind":12,"containerName":"exons"},{"name":"$self","containerName":"exons","kind":13,"line":653},{"containerName":"exons","kind":12,"name":"_clone_loc","line":653},{"line":653,"kind":13,"containerName":"exons","name":"$match4"},{"line":655,"name":"$match5","kind":13,"containerName":"exons"},{"containerName":"exons","kind":13,"name":"$prev_exon_end","line":660},{"line":660,"kind":13,"containerName":"exons","name":"$exon"},{"line":660,"name":"end","containerName":"exons","kind":12},{"line":665,"localvar":"my","containerName":"exons","kind":13,"name":"$match6","definition":"my"},{"kind":12,"containerName":"exons","name":"new","line":666},{"line":666,"kind":13,"containerName":"exons","name":"$exon_counter"},{"line":668,"name":"$exon","kind":13,"containerName":"exons"},{"name":"end","kind":12,"containerName":"exons","line":668},{"name":"$exon","containerName":"exons","kind":13,"line":668},{"containerName":"exons","kind":12,"name":"start","line":668},{"line":669,"name":"$exon","kind":13,"containerName":"exons"},{"name":"strand","kind":12,"containerName":"exons","line":669},{"name":"$self","containerName":"exons","kind":13,"line":670},{"containerName":"exons","kind":12,"name":"verbose","line":670},{"definition":"my","localvar":"my","kind":13,"containerName":"exons","name":"$pair2","line":672},{"line":672,"name":"new","kind":12,"containerName":"exons"},{"kind":13,"containerName":"exons","name":"$self","line":672},{"containerName":"exons","kind":12,"name":"_clone_loc","line":672},{"line":672,"name":"$match1","containerName":"exons","kind":13},{"line":674,"kind":13,"containerName":"exons","name":"$match6"},{"definition":"my","kind":13,"localvar":"my","containerName":"exons","name":"$pair3","line":675},{"line":675,"name":"new","kind":12,"containerName":"exons"},{"kind":13,"containerName":"exons","name":"$self","line":675},{"line":675,"name":"_clone_loc","kind":12,"containerName":"exons"},{"line":675,"name":"$match6","kind":13,"containerName":"exons"},{"name":"$self","containerName":"exons","kind":13,"line":676},{"line":676,"kind":12,"containerName":"exons","name":"_clone_loc"},{"line":676,"kind":13,"containerName":"exons","name":"$match2"},{"line":678,"name":"$inex_map","containerName":"exons","kind":13},{"line":678,"containerName":"exons","kind":12,"name":"add_mapper"},{"line":679,"containerName":"exons","kind":12,"name":"new"},{"line":679,"kind":13,"containerName":"exons","name":"$self"},{"name":"_clone_loc","containerName":"exons","kind":12,"line":679},{"kind":13,"containerName":"exons","name":"$match1","line":679},{"line":681,"kind":13,"containerName":"exons","name":"$match6"},{"line":683,"kind":13,"containerName":"exons","name":"$exon_map"},{"line":683,"name":"add_mapper","kind":12,"containerName":"exons"},{"line":684,"name":"new","kind":12,"containerName":"exons"},{"line":684,"name":"$self","containerName":"exons","kind":13},{"name":"_clone_loc","containerName":"exons","kind":12,"line":684},{"line":684,"containerName":"exons","kind":13,"name":"$match1"},{"line":685,"kind":13,"containerName":"exons","name":"$self"},{"kind":12,"containerName":"exons","name":"_clone_loc","line":685},{"line":685,"name":"$match6","containerName":"exons","kind":13},{"containerName":"exons","kind":13,"name":"$exon_cds_map","line":688},{"name":"add_mapper","kind":12,"containerName":"exons","line":688},{"line":689,"name":"new","kind":12,"containerName":"exons"},{"line":689,"containerName":"exons","kind":13,"name":"$self"},{"line":689,"name":"_clone_loc","kind":12,"containerName":"exons"},{"name":"$match6","containerName":"exons","kind":13,"line":689},{"name":"$self","kind":13,"containerName":"exons","line":690},{"containerName":"exons","kind":12,"name":"_clone_loc","line":690},{"containerName":"exons","kind":13,"name":"$match2","line":690},{"line":697,"kind":13,"containerName":"exons","name":"$coffset"},{"definition":"my","line":698,"name":"$m","localvar":"my","kind":13,"containerName":"exons"},{"name":"$cds_map","kind":13,"containerName":"exons","line":698},{"line":698,"containerName":"exons","kind":12,"name":"each_mapper"},{"containerName":"exons","kind":13,"name":"$m","line":699},{"containerName":"exons","kind":12,"name":"out","line":699},{"line":699,"name":"start","kind":12,"containerName":"exons"},{"line":699,"kind":13,"containerName":"exons","name":"$m"},{"line":699,"kind":12,"containerName":"exons","name":"out"},{"name":"start","kind":12,"containerName":"exons","line":699},{"line":699,"kind":13,"containerName":"exons","name":"$coffset"},{"name":"$m","containerName":"exons","kind":13,"line":700},{"line":700,"name":"out","containerName":"exons","kind":12},{"line":700,"name":"end","kind":12,"containerName":"exons"},{"name":"$m","kind":13,"containerName":"exons","line":700},{"containerName":"exons","kind":12,"name":"out","line":700},{"name":"end","containerName":"exons","kind":12,"line":700},{"kind":13,"containerName":"exons","name":"$coffset","line":700},{"name":"$self","containerName":"exons","kind":13,"line":705},{"line":705,"name":"$cds_mapper","kind":13,"containerName":"exons"},{"kind":13,"containerName":"exons","name":"$cds_map","line":705},{"name":"$self","kind":13,"containerName":"exons","line":706},{"name":"$exon_cds_mapper","containerName":"exons","kind":13,"line":706},{"name":"$exon_cds_map","containerName":"exons","kind":13,"line":706},{"name":"$self","kind":13,"containerName":"exons","line":707},{"line":707,"name":"$inex_mapper","kind":13,"containerName":"exons"},{"line":707,"name":"$inex_map","kind":13,"containerName":"exons"},{"line":708,"name":"$self","kind":13,"containerName":"exons"},{"line":708,"name":"$exon_mapper","kind":13,"containerName":"exons"},{"kind":13,"containerName":"exons","name":"$exon_map","line":708},{"line":709,"kind":13,"containerName":"exons","name":"$self"},{"kind":13,"containerName":"exons","name":"$intron_mapper","line":709},{"name":"$intron_map","containerName":"exons","kind":13,"line":709},{"name":"$self","kind":13,"containerName":"exons","line":710},{"kind":13,"containerName":"exons","name":"$negative_intron_mapper","line":710},{"name":"$negative_intron_map","containerName":"exons","kind":13,"line":710},{"name":"$self","containerName":"exons","kind":13,"line":712}]},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":519},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":534},{"line":571,"kind":12,"containerName":"Coordinate::Collection","name":"Bio"},{"line":572,"containerName":"Coordinate::Collection","kind":12,"name":"Bio"},{"kind":12,"containerName":"Coordinate::Collection","name":"Bio","line":573},{"line":574,"name":"Bio","containerName":"Coordinate::Collection","kind":12},{"kind":12,"containerName":"Coordinate::Collection","name":"Bio","line":575},{"line":576,"name":"Bio","containerName":"Coordinate::Collection","kind":12},{"line":590,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"line":597,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"name":"Bio","kind":12,"containerName":"Coordinate::Pair","line":604},{"line":620,"name":"Bio","kind":12,"containerName":"Location::Simple"},{"line":627,"name":"Bio","kind":12,"containerName":"Location::Simple"},{"name":"Bio","kind":12,"containerName":"Location::Simple","line":635},{"kind":12,"containerName":"Coordinate::Pair","name":"Bio","line":642},{"name":"Bio","containerName":"Coordinate::Pair","kind":12,"line":647},{"line":652,"name":"Bio","containerName":"Coordinate::Pair","kind":12},{"line":665,"name":"Bio","kind":12,"containerName":"Location::Simple"},{"line":672,"name":"Bio","kind":12,"containerName":"Coordinate::Pair"},{"kind":12,"containerName":"Coordinate::Pair","name":"Bio","line":675},{"name":"Bio","kind":12,"containerName":"Coordinate::Pair","line":678},{"containerName":"Coordinate::Pair","kind":12,"name":"Bio","line":683},{"line":688,"kind":12,"containerName":"Coordinate::Pair","name":"Bio"},{"definition":"sub","detail":"($self,$loc)","children":[{"line":727,"localvar":"my","kind":13,"containerName":"_clone_loc","name":"$self","definition":"my"},{"kind":13,"containerName":"_clone_loc","name":"$loc","line":727},{"name":"$self","kind":13,"containerName":"_clone_loc","line":729},{"name":"throw","containerName":"_clone_loc","kind":12,"line":729},{"line":729,"containerName":"_clone_loc","kind":13,"name":"$loc"},{"name":"$loc","containerName":"_clone_loc","kind":13,"line":730},{"line":730,"name":"isa","kind":12,"containerName":"_clone_loc"},{"containerName":"_clone_loc","kind":12,"name":"new","line":733},{"containerName":"_clone_loc","kind":13,"name":"$self","line":733},{"line":733,"kind":12,"containerName":"_clone_loc","name":"verbose"},{"line":734,"kind":13,"containerName":"_clone_loc","name":"$loc"},{"name":"seq_id","kind":12,"containerName":"_clone_loc","line":734},{"line":735,"containerName":"_clone_loc","kind":13,"name":"$loc"},{"kind":12,"containerName":"_clone_loc","name":"start","line":735},{"containerName":"_clone_loc","kind":13,"name":"$loc","line":736},{"line":736,"kind":12,"containerName":"_clone_loc","name":"end"},{"containerName":"_clone_loc","kind":13,"name":"$loc","line":737},{"line":737,"containerName":"_clone_loc","kind":12,"name":"strand"},{"name":"$loc","kind":13,"containerName":"_clone_loc","line":738},{"kind":12,"containerName":"_clone_loc","name":"location_type","line":739}],"name":"_clone_loc","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$loc"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned","label":"_clone_loc($self,$loc)"},"line":726,"kind":12,"range":{"start":{"line":726,"character":0},"end":{"line":740,"character":9999}}},{"kind":12,"containerName":"Location::Simple","name":"Bio","line":732},{"line":761,"range":{"start":{"character":0,"line":761},"end":{"line":793,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"cds($self,$value)"},"children":[{"line":762,"name":"$self","localvar":"my","containerName":"cds","kind":13,"definition":"my"},{"line":762,"containerName":"cds","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"cds","line":763},{"kind":13,"containerName":"cds","name":"$value","line":764},{"definition":"my","line":765,"localvar":"my","containerName":"cds","kind":13,"name":"$loc"},{"line":765,"kind":12,"containerName":"cds","name":"new"},{"line":765,"containerName":"cds","kind":13,"name":"$value"},{"containerName":"cds","kind":13,"name":"$value","line":765},{"name":"$self","containerName":"cds","kind":13,"line":766},{"kind":12,"containerName":"cds","name":"verbose","line":766},{"name":"$self","kind":13,"containerName":"cds","line":767},{"name":"$loc","containerName":"cds","kind":13,"line":767},{"line":769,"name":"$value","containerName":"cds","kind":13},{"name":"$value","kind":13,"containerName":"cds","line":769},{"line":769,"name":"isa","containerName":"cds","kind":12},{"line":770,"name":"$self","containerName":"cds","kind":13},{"line":770,"name":"$value","containerName":"cds","kind":13},{"line":772,"name":"$self","containerName":"cds","kind":13},{"kind":12,"containerName":"cds","name":"throw","line":772},{"definition":"my","localvar":"my","kind":13,"containerName":"cds","name":"$len","line":775},{"name":"$len","kind":13,"containerName":"cds","line":777},{"name":"$self","kind":13,"containerName":"cds","line":777},{"name":"end","kind":12,"containerName":"cds","line":777},{"kind":13,"containerName":"cds","name":"$self","line":777},{"line":777,"kind":12,"containerName":"cds","name":"start"},{"line":778,"kind":13,"containerName":"cds","name":"$self"},{"line":778,"name":"end","containerName":"cds","kind":12},{"definition":"my","line":780,"kind":13,"localvar":"my","containerName":"cds","name":"$a"},{"name":"$self","containerName":"cds","kind":13,"line":780},{"name":"_create_pair","containerName":"cds","kind":12,"line":781},{"line":782,"name":"$self","containerName":"cds","kind":13},{"line":782,"name":"start","kind":12,"containerName":"cds"},{"line":783,"name":"$len","containerName":"cds","kind":13},{"containerName":"cds","kind":13,"name":"$self","line":784},{"containerName":"cds","kind":12,"name":"strand","line":784},{"name":"$mapper","containerName":"cds","localvar":"my","kind":13,"line":785,"definition":"my"},{"containerName":"cds","kind":13,"name":"$COORDINATE_SYSTEMS","line":785},{"name":"$COORDINATE_SYSTEMS","containerName":"cds","kind":13,"line":785},{"containerName":"cds","kind":13,"name":"$self","line":786},{"line":786,"name":"$mapper","containerName":"cds","kind":13},{"containerName":"cds","kind":13,"name":"$a","line":786},{"containerName":"cds","kind":13,"name":"$self","line":789},{"containerName":"cds","kind":13,"name":"$self","line":790},{"name":"exons","containerName":"cds","kind":12,"line":790},{"line":790,"name":"$self","kind":13,"containerName":"cds"}],"name":"cds","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"line":765,"name":"Bio","containerName":"Location::Simple","kind":12},{"containerName":null,"kind":13,"name":"%self","line":794},{"line":810,"range":{"end":{"line":934,"character":9999},"start":{"character":0,"line":810}},"kind":12,"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple","parameters":[{"label":"$self"},{"label":"$value"}],"label":"map($self,$value)"},"children":[{"line":811,"name":"$self","localvar":"my","containerName":"map","kind":13,"definition":"my"},{"containerName":"map","kind":13,"name":"$value","line":811},{"name":"$res","localvar":"my","kind":13,"containerName":"map","line":812,"definition":"my"},{"line":813,"name":"$self","containerName":"map","kind":13},{"containerName":"map","kind":12,"name":"throw","line":813},{"line":815,"name":"$value","kind":13,"containerName":"map"},{"line":816,"kind":13,"containerName":"map","name":"$value"},{"line":816,"kind":13,"containerName":"map","name":"$value"},{"line":816,"name":"isa","kind":12,"containerName":"map"},{"line":817,"name":"$value","containerName":"map","kind":13},{"name":"isa","containerName":"map","kind":12,"line":817},{"containerName":"map","kind":13,"name":"$value","line":818},{"name":"isa","kind":12,"containerName":"map","line":818},{"line":819,"name":"$self","containerName":"map","kind":13},{"line":819,"name":"throw","containerName":"map","kind":12},{"line":820,"containerName":"map","kind":13,"name":"$self"},{"line":821,"name":"$self","kind":13,"containerName":"map"},{"kind":12,"containerName":"map","name":"throw","line":821},{"line":822,"name":"$self","containerName":"map","kind":13},{"name":"$self","containerName":"map","kind":13,"line":823},{"line":823,"name":"throw","kind":12,"containerName":"map"},{"containerName":"map","kind":13,"name":"$self","line":825},{"name":"$self","containerName":"map","kind":13,"line":825},{"line":827,"containerName":"map","kind":13,"name":"$self"},{"line":827,"containerName":"map","kind":12,"name":"_check_direction"},{"kind":13,"containerName":"map","name":"$value","line":829},{"name":"$value","kind":13,"containerName":"map","line":829},{"kind":12,"containerName":"map","name":"location","line":829},{"name":"$value","containerName":"map","kind":13,"line":829},{"name":"isa","containerName":"map","kind":12,"line":829},{"line":830,"containerName":"map","kind":13,"name":"$self"},{"line":830,"name":"debug","kind":12,"containerName":"map"},{"line":830,"containerName":"map","kind":13,"name":"$value"},{"name":"start","kind":12,"containerName":"map","line":830},{"line":831,"containerName":"map","kind":13,"name":"$value"},{"kind":12,"containerName":"map","name":"end","line":831},{"line":831,"containerName":"map","kind":13,"name":"$value"},{"name":"strand","kind":12,"containerName":"map","line":831},{"line":834,"name":"$self","kind":13,"containerName":"map"},{"name":"$self","containerName":"map","kind":13,"line":835},{"name":"$self","kind":13,"containerName":"map","line":835},{"line":836,"name":"$value","kind":13,"containerName":"map"},{"line":836,"kind":12,"containerName":"map","name":"start"},{"line":836,"kind":13,"containerName":"map","name":"$value"},{"line":836,"kind":12,"containerName":"map","name":"start"},{"kind":13,"containerName":"map","name":"$value","line":837},{"line":837,"name":"start","containerName":"map","kind":12},{"line":837,"containerName":"map","kind":13,"name":"$value"},{"line":837,"name":"start","containerName":"map","kind":12},{"containerName":"map","kind":13,"name":"$value","line":838},{"containerName":"map","kind":12,"name":"end","line":838},{"name":"$value","containerName":"map","kind":13,"line":838},{"line":838,"containerName":"map","kind":12,"name":"end"},{"line":839,"containerName":"map","kind":13,"name":"$value"},{"containerName":"map","kind":12,"name":"end","line":839},{"line":839,"containerName":"map","kind":13,"name":"$value"},{"line":839,"name":"end","containerName":"map","kind":12},{"localvar":"my","kind":13,"containerName":"map","name":"@steps","line":842,"definition":"my"},{"line":842,"name":"$self","kind":13,"containerName":"map"},{"line":842,"containerName":"map","kind":12,"name":"_get_path"},{"line":843,"name":"$self","containerName":"map","kind":13},{"line":843,"name":"debug","containerName":"map","kind":12},{"name":"$self","kind":13,"containerName":"map","line":843},{"name":"$self","kind":13,"containerName":"map","line":843},{"kind":13,"containerName":"map","name":"@steps","line":844},{"definition":"my","line":846,"name":"$mapper","localvar":"my","containerName":"map","kind":13},{"line":846,"name":"@steps","containerName":"map","kind":13},{"line":847,"kind":13,"containerName":"map","name":"$mapper"},{"kind":13,"containerName":"map","name":"$TRANSLATION","line":847},{"line":848,"kind":13,"containerName":"map","name":"$self"},{"line":848,"kind":12,"containerName":"map","name":"direction"},{"line":850,"containerName":"map","kind":13,"name":"$value"},{"name":"$self","containerName":"map","kind":13,"line":850},{"line":850,"containerName":"map","kind":12,"name":"_translate"},{"line":850,"name":"$value","kind":13,"containerName":"map"},{"line":851,"name":"$self","containerName":"map","kind":13},{"line":851,"containerName":"map","kind":12,"name":"debug"},{"line":853,"name":"$value","containerName":"map","kind":13},{"line":853,"kind":13,"containerName":"map","name":"$self"},{"kind":12,"containerName":"map","name":"_reverse_translate","line":853},{"line":853,"containerName":"map","kind":13,"name":"$value"},{"containerName":"map","kind":13,"name":"$self","line":854},{"name":"debug","kind":12,"containerName":"map","line":854},{"line":859,"name":"$self","containerName":"map","kind":13},{"line":859,"name":"$mapper","containerName":"map","kind":13},{"line":861,"name":"$mapper","containerName":"map","kind":13},{"line":861,"containerName":"map","localvar":"my","kind":13,"name":"$counter","definition":"my"},{"name":"$value","kind":13,"containerName":"map","line":862},{"line":862,"name":"seq_id","kind":12,"containerName":"map"},{"line":862,"name":"$COORDINATE_INTS","containerName":"map","kind":13},{"line":862,"name":"$counter","containerName":"map","kind":13},{"containerName":"map","kind":13,"name":"$self","line":863},{"line":863,"name":"debug","kind":12,"containerName":"map"},{"containerName":"map","kind":13,"name":"$value","line":869},{"line":869,"name":"$self","kind":13,"containerName":"map"},{"containerName":"map","kind":13,"name":"$mapper","line":869},{"line":869,"kind":12,"containerName":"map","name":"map"},{"line":869,"name":"$value","containerName":"map","kind":13},{"name":"$value","kind":13,"containerName":"map","line":871},{"line":872,"name":"purge_gaps","kind":12,"containerName":"map"},{"name":"$value","containerName":"map","kind":13,"line":872},{"line":872,"name":"$value","kind":13,"containerName":"map"},{"kind":12,"containerName":"map","name":"isa","line":872},{"kind":13,"containerName":"map","name":"$value","line":873},{"name":"can","kind":12,"containerName":"map","line":873},{"name":"$self","kind":13,"containerName":"map","line":875},{"kind":12,"containerName":"map","name":"debug","line":875},{"line":875,"containerName":"map","kind":13,"name":"$self"},{"line":875,"name":"direction","containerName":"map","kind":12},{"containerName":"map","kind":13,"name":"$value","line":876},{"containerName":"map","kind":12,"name":"start","line":876},{"name":"$value","containerName":"map","kind":13,"line":876},{"name":"end","containerName":"map","kind":12,"line":876},{"name":"$value","containerName":"map","kind":13,"line":877},{"line":877,"containerName":"map","kind":13,"name":"$self"},{"line":877,"name":"verbose","containerName":"map","kind":12},{"line":882,"containerName":"map","kind":13,"name":"$value"},{"line":882,"containerName":"map","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"map","line":883},{"line":883,"name":"$self","containerName":"map","kind":13},{"name":"$value","kind":13,"containerName":"map","line":885},{"line":885,"containerName":"map","kind":12,"name":"start"},{"line":885,"name":"$value","containerName":"map","kind":13},{"containerName":"map","kind":12,"name":"start","line":885},{"kind":13,"containerName":"map","name":"$value","line":886},{"name":"start","kind":12,"containerName":"map","line":886},{"line":886,"name":"$value","kind":13,"containerName":"map"},{"name":"start","containerName":"map","kind":12,"line":886},{"line":887,"containerName":"map","kind":13,"name":"$value"},{"line":887,"name":"end","containerName":"map","kind":12},{"line":887,"kind":13,"containerName":"map","name":"$value"},{"line":887,"kind":12,"containerName":"map","name":"end"},{"kind":13,"containerName":"map","name":"$value","line":888},{"line":888,"kind":12,"containerName":"map","name":"end"},{"line":888,"name":"$value","containerName":"map","kind":13},{"line":888,"containerName":"map","kind":12,"name":"end"},{"containerName":"map","kind":13,"name":"$value","line":893},{"line":893,"name":"$value","kind":13,"containerName":"map"},{"name":"each_match","containerName":"map","kind":12,"line":893},{"name":"$prevloc","localvar":"my","containerName":"map","kind":13,"line":894,"definition":"my"},{"line":895,"name":"$merging","kind":13,"localvar":"my","containerName":"map","definition":"my"},{"definition":"my","name":"$newvalue","localvar":"my","containerName":"map","kind":13,"line":896},{"definition":"my","line":897,"name":"@matches","localvar":"my","kind":13,"containerName":"map"},{"definition":"my","localvar":"my","containerName":"map","kind":13,"name":"$loc","line":898},{"name":"$value","containerName":"map","kind":13,"line":898},{"kind":12,"containerName":"map","name":"each_Location","line":898},{"name":"$prevloc","kind":13,"containerName":"map","line":899},{"line":900,"kind":13,"containerName":"map","name":"$prevloc"},{"containerName":"map","kind":13,"name":"$loc","line":900},{"name":"@matches","containerName":"map","kind":13,"line":901},{"containerName":"map","kind":13,"name":"$prevloc","line":901},{"kind":13,"containerName":"map","name":"$prevloc","line":904},{"name":"end","containerName":"map","kind":12,"line":904},{"name":"$loc","kind":13,"containerName":"map","line":904},{"name":"start","containerName":"map","kind":12,"line":904},{"name":"$prevloc","kind":13,"containerName":"map","line":905},{"name":"seq_id","containerName":"map","kind":12,"line":905},{"name":"$loc","kind":13,"containerName":"map","line":905},{"line":905,"kind":12,"containerName":"map","name":"seq_id"},{"name":"$prevloc","containerName":"map","kind":13,"line":906},{"kind":12,"containerName":"map","name":"end","line":906},{"line":906,"name":"$loc","kind":13,"containerName":"map"},{"name":"end","kind":12,"containerName":"map","line":906},{"line":907,"kind":13,"containerName":"map","name":"$merging"},{"kind":13,"containerName":"map","name":"@matches","line":909},{"name":"$loc","kind":13,"containerName":"map","line":909},{"name":"$prevloc","containerName":"map","kind":13,"line":910},{"containerName":"map","kind":13,"name":"$loc","line":910},{"line":913,"containerName":"map","kind":13,"name":"$merging"},{"containerName":"map","kind":13,"name":"@matches","line":914},{"containerName":"map","kind":13,"name":"$newvalue","line":915},{"line":915,"name":"new","containerName":"map","kind":12},{"name":"$newvalue","containerName":"map","kind":13,"line":916},{"line":916,"containerName":"map","kind":12,"name":"add_sub_Location"},{"line":916,"containerName":"map","kind":13,"name":"@matches"},{"line":918,"containerName":"map","kind":13,"name":"$newvalue"},{"line":919,"containerName":"map","kind":12,"name":"new"},{"kind":13,"containerName":"map","name":"$matches","line":919},{"line":919,"containerName":"map","kind":12,"name":"seq_id"},{"line":920,"containerName":"map","kind":13,"name":"$matches"},{"line":920,"containerName":"map","kind":12,"name":"start"},{"line":921,"kind":13,"containerName":"map","name":"$matches"},{"line":921,"name":"end","kind":12,"containerName":"map"},{"name":"$matches","kind":13,"containerName":"map","line":922},{"containerName":"map","kind":12,"name":"strand","line":922},{"line":923,"containerName":"map","kind":13,"name":"$self"},{"name":"verbose","containerName":"map","kind":12,"line":923},{"line":925,"name":"$value","kind":13,"containerName":"map"},{"kind":13,"containerName":"map","name":"$newvalue","line":925},{"line":928,"kind":13,"containerName":"map","name":"$value"},{"line":929,"kind":13,"containerName":"map","name":"$value"},{"name":"each_match","containerName":"map","kind":12,"line":929},{"line":930,"name":"$value","containerName":"map","kind":13},{"containerName":"map","kind":13,"name":"$value","line":930},{"name":"match","kind":12,"containerName":"map","line":930},{"name":"$value","containerName":"map","kind":13,"line":933}],"name":"map","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"name":"Bio","containerName":"Coordinate::Result","kind":12,"line":915},{"line":918,"name":"Bio","kind":12,"containerName":"Coordinate::Result::Match"},{"detail":"($self)","definition":"sub","name":"direction","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"direction","name":"$self","line":949},{"line":950,"containerName":"direction","kind":13,"name":"$self"}],"signature":{"label":"direction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)"},"range":{"start":{"line":948,"character":0},"end":{"line":951,"character":9999}},"kind":12,"line":948},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"swap","line":967},{"kind":13,"containerName":"swap","name":"$value","line":967},{"name":"$self","containerName":"swap","kind":13,"line":969},{"name":"$self","kind":13,"containerName":"swap","line":969},{"containerName":"swap","kind":13,"name":"$self","line":969},{"kind":13,"containerName":"swap","name":"$self","line":969},{"name":"$self","containerName":"swap","kind":13,"line":970},{"kind":12,"containerName":"swap","name":"swap","line":970},{"kind":13,"containerName":"swap","name":"$self","line":970}],"name":"swap","containerName":"main::","definition":"sub","detail":"($self,$value)","line":966,"kind":12,"range":{"end":{"character":9999,"line":970},"start":{"character":0,"line":966}},"signature":{"label":"swap($self,$value)","documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :","parameters":[{"label":"$self"},{"label":"$value"}]}},{"containerName":null,"kind":13,"name":"%self","line":973},{"kind":12,"name":"_direction","line":973},{"definition":"sub","children":[{"line":991,"kind":13,"localvar":"my","containerName":"to_string","name":"$self","definition":"my"},{"definition":"my","line":996,"name":"$mapper_str","kind":13,"localvar":"my","containerName":"to_string"},{"definition":"my","name":"$mapper","localvar":"my","containerName":"to_string","kind":13,"line":997},{"line":997,"containerName":"to_string","kind":13,"name":"$self"},{"line":997,"name":"_mapper_string2code","containerName":"to_string","kind":12},{"line":997,"name":"$mapper_str","kind":13,"containerName":"to_string"},{"line":999,"containerName":"to_string","kind":13,"name":"$mapper_str"},{"containerName":"to_string","kind":13,"name":"$mapper","line":999},{"name":"$self","containerName":"to_string","kind":13,"line":1000},{"line":1000,"name":"cds","containerName":"to_string","kind":12},{"line":1001,"name":"$end","kind":13,"localvar":"my","containerName":"to_string","definition":"my"},{"line":1001,"kind":13,"containerName":"to_string","name":"$self"},{"line":1001,"name":"cds","containerName":"to_string","kind":12},{"line":1001,"kind":12,"containerName":"to_string","name":"end"},{"line":1001,"kind":13,"containerName":"to_string","name":"$self"},{"line":1001,"kind":12,"containerName":"to_string","name":"cds"},{"line":1001,"kind":12,"containerName":"to_string","name":"end"},{"line":1002,"containerName":"to_string","kind":13,"name":"$self"},{"line":1002,"name":"cds","kind":12,"containerName":"to_string"},{"kind":12,"containerName":"to_string","name":"start","line":1002},{"line":1002,"kind":13,"containerName":"to_string","name":"$end"},{"name":"$self","kind":13,"containerName":"to_string","line":1003},{"name":"cds","containerName":"to_string","kind":12,"line":1003},{"containerName":"to_string","kind":12,"name":"strand","line":1003},{"line":1007,"kind":13,"containerName":"to_string","name":"$mapper_str"},{"name":"$mapper","kind":13,"containerName":"to_string","line":1008},{"line":1008,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","kind":12,"name":"_mapper_string2code","line":1008},{"line":1008,"name":"$mapper_str","kind":13,"containerName":"to_string"},{"line":1009,"name":"$mapper_str","containerName":"to_string","kind":13},{"name":"$mapper","kind":13,"containerName":"to_string","line":1009},{"localvar":"my","containerName":"to_string","kind":13,"name":"$i","line":1011,"definition":"my"},{"definition":"my","line":1012,"name":"$pair","kind":13,"localvar":"my","containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$self","line":1012},{"line":1012,"kind":13,"containerName":"to_string","name":"$mapper"},{"name":"each_mapper","kind":12,"containerName":"to_string","line":1012},{"name":"$i","containerName":"to_string","kind":13,"line":1013},{"line":1013,"name":"$pair","kind":13,"containerName":"to_string"},{"line":1013,"kind":12,"containerName":"to_string","name":"in"},{"line":1013,"kind":12,"containerName":"to_string","name":"start"},{"line":1013,"name":"$pair","kind":13,"containerName":"to_string"},{"line":1013,"name":"out","containerName":"to_string","kind":12},{"line":1013,"name":"start","containerName":"to_string","kind":12},{"line":1014,"containerName":"to_string","kind":13,"name":"$pair"},{"name":"in","containerName":"to_string","kind":12,"line":1014},{"line":1014,"name":"end","kind":12,"containerName":"to_string"},{"line":1014,"containerName":"to_string","kind":13,"name":"$pair"},{"kind":12,"containerName":"to_string","name":"out","line":1014},{"line":1014,"containerName":"to_string","kind":12,"name":"end"},{"kind":13,"containerName":"to_string","name":"$i","line":1015},{"containerName":"to_string","kind":13,"name":"$mapper_str","line":1019},{"line":1020,"name":"$mapper","kind":13,"containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":1020},{"name":"_mapper_string2code","kind":12,"containerName":"to_string","line":1020},{"line":1020,"kind":13,"containerName":"to_string","name":"$mapper_str"},{"name":"$mapper_str","containerName":"to_string","kind":13,"line":1021},{"kind":13,"containerName":"to_string","name":"$mapper","line":1021},{"name":"$i","kind":13,"containerName":"to_string","line":1023},{"definition":"my","line":1024,"kind":13,"localvar":"my","containerName":"to_string","name":"$pair"},{"line":1024,"kind":13,"containerName":"to_string","name":"$self"},{"line":1024,"kind":13,"containerName":"to_string","name":"$mapper"},{"containerName":"to_string","kind":12,"name":"each_mapper","line":1024},{"name":"$i","containerName":"to_string","kind":13,"line":1025},{"line":1025,"containerName":"to_string","kind":13,"name":"$pair"},{"containerName":"to_string","kind":12,"name":"in","line":1025},{"kind":12,"containerName":"to_string","name":"start","line":1025},{"line":1025,"name":"$pair","containerName":"to_string","kind":13},{"line":1025,"name":"out","containerName":"to_string","kind":12},{"line":1025,"name":"start","containerName":"to_string","kind":12},{"name":"$pair","containerName":"to_string","kind":13,"line":1026},{"name":"in","kind":12,"containerName":"to_string","line":1026},{"line":1026,"name":"end","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$pair","line":1026},{"line":1026,"name":"out","containerName":"to_string","kind":12},{"line":1026,"name":"end","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$i","line":1027},{"name":"$mapper_str","kind":13,"containerName":"to_string","line":1032},{"name":"$mapper","kind":13,"containerName":"to_string","line":1033},{"line":1033,"containerName":"to_string","kind":13,"name":"$self"},{"name":"_mapper_string2code","kind":12,"containerName":"to_string","line":1033},{"name":"$mapper_str","kind":13,"containerName":"to_string","line":1033},{"line":1034,"name":"$mapper_str","kind":13,"containerName":"to_string"},{"line":1034,"kind":13,"containerName":"to_string","name":"$mapper"},{"line":1036,"name":"$i","containerName":"to_string","kind":13},{"definition":"my","line":1037,"name":"$pair","containerName":"to_string","localvar":"my","kind":13},{"line":1037,"name":"$self","kind":13,"containerName":"to_string"},{"line":1037,"name":"$mapper","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":12,"name":"each_mapper","line":1037},{"name":"$i","kind":13,"containerName":"to_string","line":1038},{"line":1038,"containerName":"to_string","kind":13,"name":"$pair"},{"line":1038,"kind":12,"containerName":"to_string","name":"in"},{"containerName":"to_string","kind":12,"name":"start","line":1038},{"name":"$pair","containerName":"to_string","kind":13,"line":1038},{"line":1038,"kind":12,"containerName":"to_string","name":"out"},{"kind":12,"containerName":"to_string","name":"start","line":1038},{"line":1039,"name":"$pair","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"in","line":1039},{"kind":12,"containerName":"to_string","name":"end","line":1039},{"containerName":"to_string","kind":13,"name":"$pair","line":1039},{"kind":12,"containerName":"to_string","name":"out","line":1039},{"line":1039,"kind":12,"containerName":"to_string","name":"end"},{"name":"$i","kind":13,"containerName":"to_string","line":1040},{"line":1045,"kind":13,"containerName":"to_string","name":"$mapper_str"},{"containerName":"to_string","kind":13,"name":"$mapper","line":1046},{"name":"$self","containerName":"to_string","kind":13,"line":1046},{"containerName":"to_string","kind":12,"name":"_mapper_string2code","line":1046},{"line":1046,"containerName":"to_string","kind":13,"name":"$mapper_str"},{"kind":13,"containerName":"to_string","name":"$mapper_str","line":1047},{"name":"$mapper","containerName":"to_string","kind":13,"line":1047},{"line":1049,"name":"$i","kind":13,"containerName":"to_string"},{"definition":"my","line":1050,"name":"$pair","containerName":"to_string","localvar":"my","kind":13},{"name":"$self","containerName":"to_string","kind":13,"line":1050},{"name":"$mapper","kind":13,"containerName":"to_string","line":1050},{"containerName":"to_string","kind":12,"name":"each_mapper","line":1050},{"kind":13,"containerName":"to_string","name":"$i","line":1051},{"line":1051,"kind":13,"containerName":"to_string","name":"$pair"},{"name":"in","containerName":"to_string","kind":12,"line":1051},{"kind":12,"containerName":"to_string","name":"start","line":1051},{"kind":13,"containerName":"to_string","name":"$pair","line":1051},{"line":1051,"name":"out","kind":12,"containerName":"to_string"},{"line":1051,"name":"start","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$pair","line":1052},{"name":"in","kind":12,"containerName":"to_string","line":1052},{"line":1052,"containerName":"to_string","kind":12,"name":"end"},{"name":"$pair","containerName":"to_string","kind":13,"line":1052},{"line":1052,"name":"out","containerName":"to_string","kind":12},{"line":1052,"name":"end","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$i","line":1053},{"line":1057,"name":"$mapper_str","containerName":"to_string","kind":13},{"line":1058,"name":"$mapper","containerName":"to_string","kind":13},{"line":1058,"name":"$self","containerName":"to_string","kind":13},{"name":"_mapper_string2code","containerName":"to_string","kind":12,"line":1058},{"line":1058,"name":"$mapper_str","kind":13,"containerName":"to_string"},{"line":1059,"name":"$mapper_str","kind":13,"containerName":"to_string"},{"name":"$mapper","kind":13,"containerName":"to_string","line":1059},{"name":"$mapper_str","containerName":"to_string","kind":13,"line":1064},{"line":1065,"kind":13,"containerName":"to_string","name":"$mapper"},{"line":1065,"name":"$self","kind":13,"containerName":"to_string"},{"kind":12,"containerName":"to_string","name":"_mapper_string2code","line":1065},{"line":1065,"name":"$mapper_str","kind":13,"containerName":"to_string"},{"line":1066,"containerName":"to_string","kind":13,"name":"$mapper_str"},{"kind":13,"containerName":"to_string","name":"$mapper","line":1066},{"kind":13,"containerName":"to_string","name":"$self","line":1067},{"line":1067,"kind":12,"containerName":"to_string","name":"peptide_offset"},{"line":1071,"kind":13,"containerName":"to_string","name":"$self"},{"name":"in","containerName":"to_string","kind":12,"line":1071},{"line":1072,"name":"$self","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"out","line":1072},{"definition":"my","line":1073,"name":"$dir","kind":13,"localvar":"my","containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":1074},{"name":"direction","kind":12,"containerName":"to_string","line":1074},{"name":"$dir","containerName":"to_string","kind":13,"line":1074},{"line":1074,"kind":13,"containerName":"to_string","name":"$dir"},{"containerName":"to_string","kind":13,"name":"$dir","line":1075},{"containerName":"to_string","kind":13,"name":"$self","line":1075},{"line":1075,"name":"direction","kind":12,"containerName":"to_string"}],"name":"to_string","containerName":"main::","line":990,"kind":12,"range":{"end":{"line":1079,"character":9999},"start":{"character":0,"line":990}}},{"line":1081,"range":{"start":{"character":0,"line":1081},"end":{"line":1086,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"","label":"_mapper_code2string($self,$code)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_mapper_code2string","line":1082,"definition":"my"},{"name":"$code","kind":13,"containerName":"_mapper_code2string","line":1082},{"line":1083,"name":"$a","containerName":"_mapper_code2string","localvar":"my","kind":13,"definition":"my"},{"containerName":"_mapper_code2string","kind":13,"name":"$b","line":1083},{"name":"$code","kind":13,"containerName":"_mapper_code2string","line":1083},{"line":1084,"containerName":"_mapper_code2string","kind":13,"name":"$COORDINATE_INTS"},{"name":"$a","kind":13,"containerName":"_mapper_code2string","line":1084},{"name":"$COORDINATE_INTS","containerName":"_mapper_code2string","kind":13,"line":1084},{"line":1084,"kind":13,"containerName":"_mapper_code2string","name":"$b"}],"containerName":"main::","name":"_mapper_code2string","definition":"sub","detail":"($self,$code)"},{"signature":{"label":"_mapper_string2code($self,$string)","documentation":"","parameters":[{"label":"$self"},{"label":"$string"}]},"line":1088,"range":{"end":{"line":1092,"character":9999},"start":{"line":1088,"character":0}},"kind":12,"definition":"sub","detail":"($self,$string)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_mapper_string2code","line":1089,"definition":"my"},{"kind":13,"containerName":"_mapper_string2code","name":"$string","line":1089},{"definition":"my","line":1090,"name":"$a","localvar":"my","kind":13,"containerName":"_mapper_string2code"},{"line":1090,"containerName":"_mapper_string2code","kind":13,"name":"$b"},{"line":1090,"kind":13,"containerName":"_mapper_string2code","name":"$string"},{"containerName":"_mapper_string2code","kind":13,"name":"$COORDINATE_SYSTEMS","line":1091},{"line":1091,"name":"$a","containerName":"_mapper_string2code","kind":13},{"kind":13,"containerName":"_mapper_string2code","name":"$COORDINATE_SYSTEMS","line":1091},{"line":1091,"name":"$b","containerName":"_mapper_string2code","kind":13}],"name":"_mapper_string2code","containerName":"main::"},{"name":"_create_pair","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_create_pair","line":1112},{"name":"$in","kind":13,"containerName":"_create_pair","line":1112},{"name":"$out","kind":13,"containerName":"_create_pair","line":1112},{"kind":13,"containerName":"_create_pair","name":"$strict","line":1112},{"line":1112,"name":"$offset","containerName":"_create_pair","kind":13},{"line":1112,"containerName":"_create_pair","kind":13,"name":"$length"},{"line":1112,"kind":13,"containerName":"_create_pair","name":"$strand"},{"line":1113,"containerName":"_create_pair","kind":13,"name":"$strict"},{"line":1114,"name":"$strand","containerName":"_create_pair","kind":13},{"kind":13,"containerName":"_create_pair","name":"$length","line":1115},{"line":1117,"name":"$match1","containerName":"_create_pair","localvar":"my","kind":13,"definition":"my"},{"line":1118,"kind":12,"containerName":"_create_pair","name":"new"},{"line":1118,"name":"$in","containerName":"_create_pair","kind":13},{"line":1119,"name":"$offset","kind":13,"containerName":"_create_pair"},{"name":"$offset","containerName":"_create_pair","kind":13,"line":1120},{"containerName":"_create_pair","kind":13,"name":"$length","line":1120},{"line":1122,"containerName":"_create_pair","kind":13,"name":"$self"},{"line":1122,"kind":12,"containerName":"_create_pair","name":"verbose"},{"definition":"my","line":1124,"localvar":"my","containerName":"_create_pair","kind":13,"name":"$match2"},{"line":1125,"name":"new","containerName":"_create_pair","kind":12},{"line":1125,"name":"$out","kind":13,"containerName":"_create_pair"},{"line":1127,"kind":13,"containerName":"_create_pair","name":"$length"},{"line":1128,"containerName":"_create_pair","kind":13,"name":"$strand"},{"line":1129,"containerName":"_create_pair","kind":13,"name":"$self"},{"containerName":"_create_pair","kind":12,"name":"verbose","line":1129},{"line":1131,"localvar":"my","kind":13,"containerName":"_create_pair","name":"$pair","definition":"my"},{"line":1132,"kind":12,"containerName":"_create_pair","name":"new"},{"containerName":"_create_pair","kind":13,"name":"$match1","line":1132},{"containerName":"_create_pair","kind":13,"name":"$match2","line":1133},{"kind":13,"containerName":"_create_pair","name":"$strict","line":1134},{"line":1135,"kind":13,"containerName":"_create_pair","name":"$self"},{"line":1135,"kind":12,"containerName":"_create_pair","name":"verbose"},{"line":1138,"name":"$pair","containerName":"_create_pair","kind":13}],"detail":"($self,$in,$out,$strict,$offset,$length,$strand)","definition":"sub","range":{"end":{"line":1140,"character":9999},"start":{"character":0,"line":1111}},"kind":12,"line":1111,"signature":{"label":"_create_pair($self,$in,$out,$strict,$offset,$length,$strand)","parameters":[{"label":"$self"},{"label":"$in"},{"label":"$out"},{"label":"$strict"},{"label":"$offset"},{"label":"$length"},{"label":"$strand"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand"}},{"containerName":"Location::Simple","kind":12,"name":"Bio","line":1117},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":1124},{"containerName":"Coordinate::ExtrapolatingPair","kind":12,"name":"Bio","line":1131},{"children":[{"line":1156,"name":"$self","kind":13,"localvar":"my","containerName":"_translate","definition":"my"},{"containerName":"_translate","kind":13,"name":"$value","line":1156},{"kind":13,"containerName":"_translate","name":"$self","line":1158},{"line":1158,"containerName":"_translate","kind":12,"name":"throw"},{"line":1159,"kind":13,"containerName":"_translate","name":"$value"},{"line":1160,"kind":13,"containerName":"_translate","name":"$value"},{"line":1161,"name":"$value","containerName":"_translate","kind":13},{"line":1161,"name":"isa","kind":12,"containerName":"_translate"},{"kind":13,"containerName":"_translate","name":"$value","line":1161},{"name":"isa","containerName":"_translate","kind":12,"line":1161},{"definition":"my","line":1163,"localvar":"my","containerName":"_translate","kind":13,"name":"$seqid"},{"line":1165,"name":"$value","containerName":"_translate","kind":13},{"name":"isa","kind":12,"containerName":"_translate","line":1165},{"definition":"my","line":1166,"localvar":"my","containerName":"_translate","kind":13,"name":"$split"},{"line":1166,"containerName":"_translate","kind":12,"name":"new"},{"name":"$seqid","kind":13,"containerName":"_translate","line":1166},{"line":1167,"name":"$loc","kind":13,"localvar":"my","containerName":"_translate","definition":"my"},{"name":"$value","containerName":"_translate","kind":13,"line":1167},{"line":1167,"name":"each_Location","containerName":"_translate","kind":12},{"name":"$match","localvar":"my","kind":13,"containerName":"_translate","line":1168,"definition":"my"},{"line":1169,"name":"new","containerName":"_translate","kind":12},{"line":1169,"name":"$loc","kind":13,"containerName":"_translate"},{"line":1169,"name":"start","containerName":"_translate","kind":12},{"line":1170,"name":"$loc","kind":13,"containerName":"_translate"},{"line":1170,"kind":12,"containerName":"_translate","name":"end"},{"name":"$seqid","containerName":"_translate","kind":13,"line":1171},{"line":1173,"name":"$self","containerName":"_translate","kind":13},{"line":1173,"name":"verbose","kind":12,"containerName":"_translate"},{"line":1175,"kind":13,"containerName":"_translate","name":"$split"},{"line":1175,"name":"add_sub_Location","kind":12,"containerName":"_translate"},{"kind":13,"containerName":"_translate","name":"$match","line":1175},{"line":1177,"kind":13,"containerName":"_translate","name":"$split"},{"kind":13,"containerName":"_translate","name":"$value","line":1180},{"line":1180,"containerName":"_translate","kind":12,"name":"start"},{"name":"$value","containerName":"_translate","kind":13,"line":1181},{"containerName":"_translate","kind":12,"name":"end","line":1181},{"line":1182,"kind":13,"containerName":"_translate","name":"$seqid"},{"line":1184,"name":"$self","kind":13,"containerName":"_translate"},{"name":"verbose","containerName":"_translate","kind":12,"line":1184}],"name":"_translate","containerName":"main::","definition":"sub","detail":"($self,$value)","line":1155,"range":{"start":{"character":0,"line":1155},"end":{"character":9999,"line":1187}},"kind":12,"signature":{"label":"_translate($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI"}},{"line":1166,"name":"Bio","kind":12,"containerName":"Location::Split"},{"line":1168,"containerName":"Location::Simple","kind":12,"name":"Bio"},{"line":1180,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"containerName":"main::","name":"_frame","children":[{"localvar":"my","containerName":"_frame","kind":13,"name":"$self","line":1190,"definition":"my"},{"name":"$value","kind":13,"containerName":"_frame","line":1190},{"containerName":"_frame","kind":13,"name":"$self","line":1192},{"name":"throw","kind":12,"containerName":"_frame","line":1192},{"name":"$value","kind":13,"containerName":"_frame","line":1193},{"line":1194,"containerName":"_frame","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"_frame","line":1195},{"name":"isa","kind":12,"containerName":"_frame","line":1195},{"line":1195,"name":"$value","kind":13,"containerName":"_frame"},{"line":1195,"name":"isa","containerName":"_frame","kind":12},{"name":"$seqid","containerName":"_frame","localvar":"my","kind":13,"line":1197,"definition":"my"},{"line":1199,"name":"$value","containerName":"_frame","kind":13},{"name":"isa","kind":12,"containerName":"_frame","line":1199},{"line":1200,"name":"$split","containerName":"_frame","localvar":"my","kind":13,"definition":"my"},{"containerName":"_frame","kind":12,"name":"new","line":1200},{"kind":13,"containerName":"_frame","name":"$seqid","line":1200},{"name":"$loc","localvar":"my","kind":13,"containerName":"_frame","line":1201,"definition":"my"},{"line":1201,"containerName":"_frame","kind":13,"name":"$value"},{"containerName":"_frame","kind":12,"name":"each_Location","line":1201},{"definition":"my","line":1203,"name":"$match","containerName":"_frame","localvar":"my","kind":13},{"containerName":"_frame","kind":12,"name":"new","line":1204},{"kind":13,"containerName":"_frame","name":"$value","line":1204},{"name":"start","kind":12,"containerName":"_frame","line":1204},{"line":1205,"containerName":"_frame","kind":13,"name":"$value"},{"line":1205,"name":"end","containerName":"_frame","kind":12},{"line":1208,"containerName":"_frame","kind":13,"name":"$self"},{"line":1208,"name":"verbose","containerName":"_frame","kind":12},{"line":1209,"kind":13,"containerName":"_frame","name":"$split"},{"line":1209,"kind":12,"containerName":"_frame","name":"add_sub_Location"},{"line":1209,"containerName":"_frame","kind":13,"name":"$match"},{"kind":13,"containerName":"_frame","name":"$split","line":1211},{"line":1213,"containerName":"_frame","kind":13,"name":"$value"},{"containerName":"_frame","kind":12,"name":"start","line":1213},{"containerName":"_frame","kind":13,"name":"$value","line":1214},{"line":1214,"name":"end","containerName":"_frame","kind":12},{"line":1217,"name":"$self","kind":13,"containerName":"_frame"},{"kind":12,"containerName":"_frame","name":"verbose","line":1217}],"detail":"($self,$value)","definition":"sub","range":{"end":{"line":1220,"character":9999},"start":{"line":1189,"character":0}},"kind":12,"line":1189,"signature":{"label":"_frame($self,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$value"}]}},{"name":"Bio","kind":12,"containerName":"Location::Split","line":1200},{"line":1203,"name":"Bio","containerName":"Location::Simple","kind":12},{"line":1213,"name":"Bio","containerName":"Location::Simple","kind":12},{"name":"_reverse_translate","containerName":"main::","children":[{"line":1238,"localvar":"my","kind":13,"containerName":"_reverse_translate","name":"$self","definition":"my"},{"line":1238,"name":"$value","containerName":"_reverse_translate","kind":13},{"containerName":"_reverse_translate","kind":13,"name":"$self","line":1241},{"containerName":"_reverse_translate","kind":12,"name":"throw","line":1241},{"name":"$value","kind":13,"containerName":"_reverse_translate","line":1242},{"containerName":"_reverse_translate","kind":13,"name":"$value","line":1243},{"kind":13,"containerName":"_reverse_translate","name":"$value","line":1244},{"line":1244,"containerName":"_reverse_translate","kind":12,"name":"isa"},{"name":"$value","kind":13,"containerName":"_reverse_translate","line":1244},{"name":"isa","kind":12,"containerName":"_reverse_translate","line":1244},{"definition":"my","localvar":"my","containerName":"_reverse_translate","kind":13,"name":"$seqid","line":1246},{"kind":13,"containerName":"_reverse_translate","name":"$value","line":1248},{"kind":12,"containerName":"_reverse_translate","name":"isa","line":1248},{"definition":"my","line":1249,"name":"$split","localvar":"my","kind":13,"containerName":"_reverse_translate"},{"name":"new","kind":12,"containerName":"_reverse_translate","line":1249},{"containerName":"_reverse_translate","kind":13,"name":"$seqid","line":1249},{"kind":13,"localvar":"my","containerName":"_reverse_translate","name":"$loc","line":1250,"definition":"my"},{"line":1250,"kind":13,"containerName":"_reverse_translate","name":"$value"},{"containerName":"_reverse_translate","kind":12,"name":"each_Location","line":1250},{"line":1252,"containerName":"_reverse_translate","localvar":"my","kind":13,"name":"$match","definition":"my"},{"line":1253,"kind":12,"containerName":"_reverse_translate","name":"new"},{"line":1253,"name":"$value","containerName":"_reverse_translate","kind":13},{"line":1253,"kind":12,"containerName":"_reverse_translate","name":"start"},{"kind":13,"containerName":"_reverse_translate","name":"$value","line":1254},{"name":"end","kind":12,"containerName":"_reverse_translate","line":1254},{"line":1255,"name":"$seqid","containerName":"_reverse_translate","kind":13},{"name":"$self","containerName":"_reverse_translate","kind":13,"line":1257},{"line":1257,"containerName":"_reverse_translate","kind":12,"name":"verbose"},{"line":1259,"name":"$split","containerName":"_reverse_translate","kind":13},{"line":1259,"name":"add_sub_Location","kind":12,"containerName":"_reverse_translate"},{"containerName":"_reverse_translate","kind":13,"name":"$match","line":1259},{"line":1261,"kind":13,"containerName":"_reverse_translate","name":"$split"},{"name":"$value","kind":13,"containerName":"_reverse_translate","line":1264},{"name":"start","containerName":"_reverse_translate","kind":12,"line":1264},{"kind":13,"containerName":"_reverse_translate","name":"$value","line":1265},{"line":1265,"name":"end","containerName":"_reverse_translate","kind":12},{"line":1266,"name":"$seqid","containerName":"_reverse_translate","kind":13},{"kind":13,"containerName":"_reverse_translate","name":"$self","line":1268},{"line":1268,"name":"verbose","containerName":"_reverse_translate","kind":12}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"line":1237,"character":0},"end":{"character":9999,"line":1271}},"line":1237,"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _translate {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n   \n   if ($value->isa(\"Bio::Location::SplitLocationI\") ) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n           my $match = Bio::Location::Simple->new\n\t       (-start   => int ($loc->start / 3 ) +1,\n\t\t-end     => int ($loc->end / 3 ) +1,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start  => int($value->start / 3 )+1,\n                                        -end    => int($value->end / 3 )+1,\n                                        -seq_id => $seqid,\n                                        -strand => 1,\n\t\t\t\t\t-verbose=> $self->verbose,\n                                       );\n   }\n}\n\nsub _frame {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start  => ($value->start-1) % 3 +1,\n\t\t-end    => ($value->end-1) % 3 +1,\n\t\t-seq_id => 'frame',\n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n   } else {\n       return new Bio::Location::Simple(-start   => ($value->start-1) % 3 +1,\n                                        -end     => ($value->end-1) % 3 +1,\n                                        -seq_id  => 'frame',\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n\t\t\t\t\t);\n   }\n}\n\n\n=head2 _reverse_translate\n\n Title   : _reverse_translate\n Usage   : $newpos = $obj->_reverse_translate(5);\n Function: Reverse translate the location from the propeptide\n           coordinate system to a new value in the CSD.\n           Note that a single peptide location expands to cover\n           the codon triplet\n Example :\n Returns : new location in the CDS coordinate system\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_reverse_translate($self,$value)"}},{"line":1249,"name":"Bio","kind":12,"containerName":"Location::Split"},{"line":1252,"containerName":"Location::Simple","kind":12,"name":"Bio"},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":1264},{"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","containerName":"_check_direction","kind":13,"line":1287,"definition":"my"},{"line":1289,"kind":13,"localvar":"my","containerName":"_check_direction","name":"$new_direction","definition":"my"},{"line":1290,"name":"$new_direction","kind":13,"containerName":"_check_direction"},{"name":"$self","kind":13,"containerName":"_check_direction","line":1290},{"name":"$self","containerName":"_check_direction","kind":13,"line":1290},{"line":1292,"kind":13,"containerName":"_check_direction","name":"$new_direction"},{"kind":13,"containerName":"_check_direction","name":"$self","line":1292},{"name":"$self","containerName":"_check_direction","kind":13,"line":1293},{"kind":12,"containerName":"_check_direction","name":"swap","line":1293},{"containerName":"_check_direction","kind":13,"name":"$self","line":1293},{"line":1295,"name":"$self","containerName":"_check_direction","kind":13}],"name":"_check_direction","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _translate {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n   \n   if ($value->isa(\"Bio::Location::SplitLocationI\") ) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n           my $match = Bio::Location::Simple->new\n\t       (-start   => int ($loc->start / 3 ) +1,\n\t\t-end     => int ($loc->end / 3 ) +1,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start  => int($value->start / 3 )+1,\n                                        -end    => int($value->end / 3 )+1,\n                                        -seq_id => $seqid,\n                                        -strand => 1,\n\t\t\t\t\t-verbose=> $self->verbose,\n                                       );\n   }\n}\n\nsub _frame {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start  => ($value->start-1) % 3 +1,\n\t\t-end    => ($value->end-1) % 3 +1,\n\t\t-seq_id => 'frame',\n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n   } else {\n       return new Bio::Location::Simple(-start   => ($value->start-1) % 3 +1,\n                                        -end     => ($value->end-1) % 3 +1,\n                                        -seq_id  => 'frame',\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n\t\t\t\t\t);\n   }\n}\n\n\n=head2 _reverse_translate\n\n Title   : _reverse_translate\n Usage   : $newpos = $obj->_reverse_translate(5);\n Function: Reverse translate the location from the propeptide\n           coordinate system to a new value in the CSD.\n           Note that a single peptide location expands to cover\n           the codon triplet\n Example :\n Returns : new location in the CDS coordinate system\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _reverse_translate {\n   my ($self,$value) = @_;\n\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'cds';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start   => $value->start * 3 - 2,\n\t\t-end     => $value->end * 3,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start   => $value->start * 3 - 2,\n                                        -end     => $value->end * 3,\n                                        -seq_id  => $seqid,\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n                                       );\n   }\n}\n\n\n=head2 _check_direction\n\n Title   : _check_direction\n Usage   : $obj->_check_direction();\n Function: Check and swap when needed the direction the location\n           mapping Pairs based on input and output values\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple","label":"_check_direction($self)"},"line":1286,"range":{"start":{"line":1286,"character":0},"end":{"character":9999,"line":1296}},"kind":12},{"line":1292,"name":"_direction","kind":12},{"name":"_direction","kind":12,"line":1295},{"children":[{"containerName":"_get_path","localvar":"my","kind":13,"name":"$self","line":1316,"definition":"my"},{"line":1318,"name":"$start","localvar":"my","kind":13,"containerName":"_get_path","definition":"my"},{"containerName":"_get_path","kind":13,"name":"$self","line":1318},{"definition":"my","name":"$end","kind":13,"localvar":"my","containerName":"_get_path","line":1319},{"kind":13,"containerName":"_get_path","name":"$self","line":1319},{"line":1323,"containerName":"_get_path","localvar":"my","kind":13,"name":"$reverse","definition":"my"},{"line":1324,"kind":13,"containerName":"_get_path","name":"$start"},{"name":"$end","kind":13,"containerName":"_get_path","line":1324},{"line":1325,"name":"$start","containerName":"_get_path","kind":13},{"line":1325,"name":"$end","containerName":"_get_path","kind":13},{"name":"$end","containerName":"_get_path","kind":13,"line":1325},{"line":1325,"name":"$start","kind":13,"containerName":"_get_path"},{"line":1326,"name":"$reverse","containerName":"_get_path","kind":13},{"definition":"my","line":1329,"name":"@mappers","localvar":"my","containerName":"_get_path","kind":13},{"containerName":"_get_path","kind":13,"name":"$self","line":1330},{"name":"$self","kind":13,"containerName":"_get_path","line":1331},{"name":"@mappers","containerName":"_get_path","kind":13,"line":1333},{"name":"$self","containerName":"_get_path","kind":13,"line":1333}],"name":"_get_path","containerName":"main::","definition":"sub","detail":"($self)","line":1315,"kind":12,"range":{"end":{"character":9999,"line":1334},"start":{"line":1315,"character":0}},"signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _translate {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n   \n   if ($value->isa(\"Bio::Location::SplitLocationI\") ) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n           my $match = Bio::Location::Simple->new\n\t       (-start   => int ($loc->start / 3 ) +1,\n\t\t-end     => int ($loc->end / 3 ) +1,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start  => int($value->start / 3 )+1,\n                                        -end    => int($value->end / 3 )+1,\n                                        -seq_id => $seqid,\n                                        -strand => 1,\n\t\t\t\t\t-verbose=> $self->verbose,\n                                       );\n   }\n}\n\nsub _frame {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start  => ($value->start-1) % 3 +1,\n\t\t-end    => ($value->end-1) % 3 +1,\n\t\t-seq_id => 'frame',\n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n   } else {\n       return new Bio::Location::Simple(-start   => ($value->start-1) % 3 +1,\n                                        -end     => ($value->end-1) % 3 +1,\n                                        -seq_id  => 'frame',\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n\t\t\t\t\t);\n   }\n}\n\n\n=head2 _reverse_translate\n\n Title   : _reverse_translate\n Usage   : $newpos = $obj->_reverse_translate(5);\n Function: Reverse translate the location from the propeptide\n           coordinate system to a new value in the CSD.\n           Note that a single peptide location expands to cover\n           the codon triplet\n Example :\n Returns : new location in the CDS coordinate system\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _reverse_translate {\n   my ($self,$value) = @_;\n\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'cds';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start   => $value->start * 3 - 2,\n\t\t-end     => $value->end * 3,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start   => $value->start * 3 - 2,\n                                        -end     => $value->end * 3,\n                                        -seq_id  => $seqid,\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n                                       );\n   }\n}\n\n\n=head2 _check_direction\n\n Title   : _check_direction\n Usage   : $obj->_check_direction();\n Function: Check and swap when needed the direction the location\n           mapping Pairs based on input and output values\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple\n\n\nsub _check_direction {\n   my ($self) = @_;\n\n   my $new_direction = 1;\n   $new_direction = -1 if $self->{'_in'} > $self->{'_out'};\n\n   unless ($new_direction == $self->{_direction} ) {\n       map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n       # record the changed direction;\n       $self->{_direction} *= -1;\n   }\n   1;\n}\n\n\n=head2 _get_path\n\n Title   : _get_path\n Usage   : $obj->_get_path('peptide');\n Function: internal method for finding that shortest path between\n           input and output coordinate systems.\n           Calculations and caching are handled by the graph class.\n           See L<Bio::Coordinate::Graph>.\n Example :\n Returns : array of the mappers\n Args    : none","parameters":[{"label":"$self"}],"label":"_get_path($self)"}},{"definition":"my","line":1335,"kind":13,"localvar":"my","containerName":null,"name":"$mapper"},{"definition":"my","line":1336,"containerName":null,"localvar":"my","kind":13,"name":"$prev_node"},{"name":"@mappers","kind":13,"containerName":null,"line":1337},{"name":"$mapper","containerName":null,"kind":13,"line":1338},{"kind":13,"containerName":null,"name":"$prev_node","line":1338},{"line":1338,"name":"$mapper","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":1339},{"line":1339,"containerName":"main::","kind":12,"name":"shortest_path"},{"line":1339,"containerName":null,"kind":13,"name":"$start"},{"name":"$end","containerName":null,"kind":13,"line":1339},{"name":"@mappers","containerName":null,"kind":13,"line":1340},{"name":"%self","containerName":null,"kind":13,"line":1342},{"line":1343,"containerName":null,"kind":13,"name":"%self"},{"line":1343,"name":"@mappers","kind":13,"containerName":null},{"name":"$reverse","kind":13,"containerName":null,"line":1346},{"line":1346,"kind":13,"containerName":null,"name":"@mappers"},{"kind":13,"containerName":null,"name":"@mappers","line":1346}]}