{"vars":[{"name":"vars","containerName":"","kind":2,"line":113},{"name":"base","containerName":"","kind":2,"line":117},{"containerName":null,"kind":13,"name":"@AA","line":120},{"line":121,"name":"%STRICTAA","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@AA","line":121},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":140,"localvar":"my","containerName":"new","kind":13,"name":"$class"},{"line":140,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":141,"definition":"my"},{"line":141,"name":"$class","containerName":"new","kind":13},{"name":"@args","containerName":"new","kind":13,"line":141},{"containerName":"new","kind":13,"name":"@args","line":142},{"kind":13,"containerName":"new","name":"$self","line":143},{"line":143,"kind":12,"containerName":"new","name":"_rearrange"},{"line":143,"kind":13,"containerName":"new","name":"@args"},{"line":144,"name":"@args","containerName":"new","kind":13},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$arg","line":145},{"line":145,"name":"@args","kind":13,"containerName":"new"},{"line":146,"name":"$self","kind":13,"containerName":"new"},{"line":146,"containerName":"new","kind":12,"name":"throw"},{"kind":13,"containerName":"new","name":"$arg","line":146},{"line":146,"kind":13,"containerName":"new","name":"$arg"},{"line":148,"localvar":"my","kind":13,"containerName":"new","name":"$is_codon_hash","definition":"my"},{"name":"$is_Aa_hash","localvar":"my","containerName":"new","kind":13,"line":149,"definition":"my"},{"definition":"my","name":"$k","localvar":"my","kind":13,"containerName":"new","line":150},{"name":"$arg","containerName":"new","kind":13,"line":150},{"name":"$k","kind":13,"containerName":"new","line":152},{"line":153,"containerName":"new","kind":13,"name":"$STRICTAA"},{"name":"$k","containerName":"new","kind":13,"line":153},{"line":154,"containerName":"new","kind":13,"name":"$is_Aa_hash"},{"name":"$k","kind":13,"containerName":"new","line":156},{"line":157,"containerName":"new","kind":13,"name":"$is_codon_hash"},{"containerName":"new","kind":13,"name":"$is_codon_hash","line":160},{"line":160,"kind":13,"containerName":"new","name":"$is_Aa_hash"},{"line":161,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"throw","line":161},{"name":"$is_Aa_hash","kind":13,"containerName":"new","line":163},{"kind":13,"containerName":"new","name":"$self","line":164},{"line":164,"name":"_init_from_aa","kind":12,"containerName":"new"},{"line":164,"kind":13,"containerName":"new","name":"$arg"},{"line":166,"name":"$is_codon_hash","containerName":"new","kind":13},{"line":167,"name":"$self","kind":13,"containerName":"new"},{"line":167,"containerName":"new","kind":12,"name":"_init_from_cod"},{"kind":13,"containerName":"new","name":"$arg","line":167},{"line":169,"name":"@args","containerName":"new","kind":13},{"definition":"my","name":"$key","localvar":"my","kind":13,"containerName":"new","line":170},{"line":170,"name":"@args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$key","line":171},{"line":173,"kind":13,"containerName":"new","name":"$self"},{"line":173,"kind":13,"containerName":"new","name":"$key"},{"line":173,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"$self","line":177}],"signature":{"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"range":{"start":{"line":139,"character":0},"end":{"line":178,"character":9999}},"kind":12,"line":139},{"name":"SUPER","kind":12,"containerName":"new","line":141},{"definition":"sub","containerName":"main::","name":"all_aa_frequencies","children":[{"name":"$self","containerName":"all_aa_frequencies","localvar":"my","kind":13,"line":192,"definition":"my"},{"definition":"my","name":"%aa_freqs","containerName":"all_aa_frequencies","localvar":"my","kind":13,"line":193},{"name":"$aa","kind":13,"localvar":"my","containerName":"all_aa_frequencies","line":194,"definition":"my"},{"containerName":"all_aa_frequencies","kind":13,"name":"%STRICTAA","line":194},{"definition":"my","line":195,"containerName":"all_aa_frequencies","localvar":"my","kind":13,"name":"$freq"},{"line":195,"name":"$self","kind":13,"containerName":"all_aa_frequencies"},{"line":195,"name":"aa_frequency","kind":12,"containerName":"all_aa_frequencies"},{"line":195,"kind":13,"containerName":"all_aa_frequencies","name":"$aa"},{"line":196,"kind":13,"containerName":"all_aa_frequencies","name":"$aa_freqs"},{"name":"$aa","containerName":"all_aa_frequencies","kind":13,"line":196},{"line":196,"name":"$freq","kind":13,"containerName":"all_aa_frequencies"},{"containerName":"all_aa_frequencies","kind":13,"name":"%aa_freqs","line":198}],"range":{"start":{"character":0,"line":191},"end":{"character":9999,"line":199}},"kind":12,"line":191},{"definition":"sub","detail":"($self,$a)","children":[{"name":"$self","localvar":"my","containerName":"codon_abs_frequency","kind":13,"line":213,"definition":"my"},{"line":213,"name":"$a","kind":13,"containerName":"codon_abs_frequency"},{"definition":"my","name":"$cod","localvar":"my","kind":13,"containerName":"codon_abs_frequency","line":214},{"line":214,"name":"$a","containerName":"codon_abs_frequency","kind":13},{"containerName":"codon_abs_frequency","kind":13,"name":"$self","line":215},{"line":215,"name":"_check_codon","kind":12,"containerName":"codon_abs_frequency"},{"line":215,"containerName":"codon_abs_frequency","kind":13,"name":"$cod"},{"line":216,"containerName":"codon_abs_frequency","localvar":"my","kind":13,"name":"$ctable","definition":"my"},{"line":216,"name":"new","containerName":"codon_abs_frequency","kind":12},{"line":217,"name":"$ctable","containerName":"codon_abs_frequency","kind":13},{"line":217,"kind":12,"containerName":"codon_abs_frequency","name":"id"},{"name":"$self","containerName":"codon_abs_frequency","kind":13,"line":217},{"line":217,"name":"genetic_code","containerName":"codon_abs_frequency","kind":12},{"definition":"my","line":218,"name":"$aa","kind":13,"localvar":"my","containerName":"codon_abs_frequency"},{"line":218,"name":"$Bio","kind":13,"containerName":"codon_abs_frequency"},{"containerName":"codon_abs_frequency","kind":13,"name":"$ctable","line":218},{"line":218,"containerName":"codon_abs_frequency","kind":12,"name":"translate"},{"name":"$cod","containerName":"codon_abs_frequency","kind":13,"line":218},{"containerName":"codon_abs_frequency","kind":13,"name":"$self","line":220},{"name":"$aa","containerName":"codon_abs_frequency","kind":13,"line":220},{"kind":13,"containerName":"codon_abs_frequency","name":"$cod","line":220}],"containerName":"main::","name":"codon_abs_frequency","signature":{"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string","parameters":[{"label":"$self"},{"label":"$a"}],"label":"codon_abs_frequency($self,$a)"},"line":212,"kind":12,"range":{"end":{"line":223,"character":9999},"start":{"line":212,"character":0}}},{"containerName":"Tools::CodonTable","kind":12,"name":"Bio","line":216},{"line":218,"name":"SeqUtils","containerName":"THREECODE","kind":12},{"detail":"($self,$a)","definition":"sub","containerName":"main::","name":"codon_rel_frequency","children":[{"definition":"my","line":239,"kind":13,"localvar":"my","containerName":"codon_rel_frequency","name":"$self"},{"kind":13,"containerName":"codon_rel_frequency","name":"$a","line":239},{"definition":"my","line":240,"name":"$cod","containerName":"codon_rel_frequency","localvar":"my","kind":13},{"containerName":"codon_rel_frequency","kind":13,"name":"$a","line":240},{"kind":13,"containerName":"codon_rel_frequency","name":"$self","line":241},{"name":"_check_codon","kind":12,"containerName":"codon_rel_frequency","line":241},{"line":241,"name":"$cod","containerName":"codon_rel_frequency","kind":13},{"definition":"my","name":"$ctable","localvar":"my","kind":13,"containerName":"codon_rel_frequency","line":242},{"containerName":"codon_rel_frequency","kind":12,"name":"new","line":242},{"line":243,"containerName":"codon_rel_frequency","kind":13,"name":"$ctable"},{"containerName":"codon_rel_frequency","kind":12,"name":"id","line":243},{"name":"$self","containerName":"codon_rel_frequency","kind":13,"line":243},{"kind":12,"containerName":"codon_rel_frequency","name":"genetic_code","line":243},{"localvar":"my","containerName":"codon_rel_frequency","kind":13,"name":"$aa","line":244,"definition":"my"},{"line":244,"containerName":"codon_rel_frequency","kind":13,"name":"$Bio"},{"line":244,"name":"$ctable","kind":13,"containerName":"codon_rel_frequency"},{"line":244,"containerName":"codon_rel_frequency","kind":12,"name":"translate"},{"line":244,"name":"$cod","containerName":"codon_rel_frequency","kind":13},{"line":245,"kind":13,"containerName":"codon_rel_frequency","name":"$self"},{"name":"$aa","containerName":"codon_rel_frequency","kind":13,"line":245},{"line":245,"kind":13,"containerName":"codon_rel_frequency","name":"$cod"}],"signature":{"label":"codon_rel_frequency($self,$a)","parameters":[{"label":"$self"},{"label":"$a"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string"},"range":{"end":{"character":9999,"line":250},"start":{"line":238,"character":0}},"kind":12,"line":238},{"name":"Bio","kind":12,"containerName":"Tools::CodonTable","line":242},{"line":244,"kind":12,"containerName":"THREECODE","name":"SeqUtils"},{"name":"probable_codons","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"probable_codons","kind":13,"name":"$self","line":266},{"name":"$threshold","containerName":"probable_codons","kind":13,"line":266},{"name":"$threshold","containerName":"probable_codons","kind":13,"line":267},{"name":"$threshold","kind":13,"containerName":"probable_codons","line":267},{"kind":13,"containerName":"probable_codons","name":"$threshold","line":267},{"line":268,"kind":13,"containerName":"probable_codons","name":"$self"},{"containerName":"probable_codons","kind":12,"name":"throw","line":268},{"definition":"my","line":270,"kind":13,"localvar":"my","containerName":"probable_codons","name":"%return_hash"},{"definition":"my","name":"$a","kind":13,"localvar":"my","containerName":"probable_codons","line":271},{"line":271,"name":"%STRICTAA","kind":13,"containerName":"probable_codons"},{"localvar":"my","containerName":"probable_codons","kind":13,"name":"@common_codons","line":272,"definition":"my"},{"line":273,"name":"$aa","kind":13,"localvar":"my","containerName":"probable_codons","definition":"my"},{"line":273,"kind":13,"containerName":"probable_codons","name":"$Bio"},{"line":273,"name":"$a","containerName":"probable_codons","kind":13},{"definition":"my","line":274,"name":"$codon","containerName":"probable_codons","localvar":"my","kind":13},{"line":274,"containerName":"probable_codons","kind":13,"name":"$self"},{"line":274,"containerName":"probable_codons","kind":13,"name":"$aa"},{"name":"$self","kind":13,"containerName":"probable_codons","line":275},{"name":"$aa","containerName":"probable_codons","kind":13,"line":275},{"kind":13,"containerName":"probable_codons","name":"$codon","line":275},{"name":"$threshold","kind":13,"containerName":"probable_codons","line":275},{"line":276,"name":"@common_codons","containerName":"probable_codons","kind":13},{"line":276,"kind":13,"containerName":"probable_codons","name":"$codon"},{"name":"$return_hash","containerName":"probable_codons","kind":13,"line":279},{"line":279,"name":"$a","containerName":"probable_codons","kind":13},{"name":"@common_codons","kind":13,"containerName":"probable_codons","line":279}],"detail":"($self,$threshold)","definition":"sub","range":{"start":{"character":0,"line":265},"end":{"character":9999,"line":280}},"kind":12,"line":265,"signature":{"label":"probable_codons($self,$threshold)","parameters":[{"label":"$self"},{"label":"$threshold"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency"}},{"containerName":"THREECODE","kind":12,"name":"SeqUtils","line":274},{"kind":13,"containerName":null,"name":"%return_hash","line":282},{"line":282,"name":"%return_hash","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":283},{"name":"warn","kind":12,"containerName":"main::","line":283},{"name":"%return_hash","containerName":null,"kind":13,"line":286},{"range":{"end":{"character":9999,"line":324},"start":{"character":0,"line":301}},"kind":12,"line":301,"containerName":"main::","name":"most_common_codons","children":[{"definition":"my","line":302,"kind":13,"localvar":"my","containerName":"most_common_codons","name":"$self"},{"line":304,"name":"%return_hash","localvar":"my","containerName":"most_common_codons","kind":13,"definition":"my"},{"containerName":"most_common_codons","localvar":"my","kind":13,"name":"$a","line":306,"definition":"my"},{"name":"%STRICTAA","containerName":"most_common_codons","kind":13,"line":306},{"kind":13,"localvar":"my","containerName":"most_common_codons","name":"$common_codon","line":308,"definition":"my"},{"definition":"my","name":"$rel_freq","containerName":"most_common_codons","localvar":"my","kind":13,"line":309},{"definition":"my","localvar":"my","containerName":"most_common_codons","kind":13,"name":"$aa","line":310},{"name":"$Bio","kind":13,"containerName":"most_common_codons","line":310},{"line":310,"containerName":"most_common_codons","kind":13,"name":"$a"},{"kind":13,"containerName":"most_common_codons","name":"$self","line":312},{"line":312,"name":"$aa","containerName":"most_common_codons","kind":13},{"line":313,"name":"$self","containerName":"most_common_codons","kind":13},{"line":313,"containerName":"most_common_codons","kind":12,"name":"warn"},{"definition":"my","line":317,"localvar":"my","containerName":"most_common_codons","kind":13,"name":"$codon"},{"line":317,"containerName":"most_common_codons","kind":13,"name":"$self"},{"name":"$aa","containerName":"most_common_codons","kind":13,"line":317},{"name":"$self","kind":13,"containerName":"most_common_codons","line":318},{"line":318,"name":"$aa","kind":13,"containerName":"most_common_codons"},{"line":318,"name":"$codon","containerName":"most_common_codons","kind":13},{"name":"$rel_freq","containerName":"most_common_codons","kind":13,"line":318},{"line":319,"name":"$common_codon","kind":13,"containerName":"most_common_codons"},{"kind":13,"containerName":"most_common_codons","name":"$codon","line":319},{"name":"$rel_freq","kind":13,"containerName":"most_common_codons","line":320},{"name":"$self","containerName":"most_common_codons","kind":13,"line":320},{"line":320,"kind":13,"containerName":"most_common_codons","name":"$aa"},{"name":"$codon","kind":13,"containerName":"most_common_codons","line":320},{"kind":13,"containerName":"most_common_codons","name":"$return_hash","line":323},{"line":323,"name":"$a","kind":13,"containerName":"most_common_codons"},{"line":323,"kind":13,"containerName":"most_common_codons","name":"$common_codon"}],"definition":"sub"},{"line":312,"kind":12,"containerName":"THREECODE","name":"SeqUtils"},{"kind":13,"containerName":null,"name":"%return_hash","line":326},{"line":340,"range":{"start":{"line":340,"character":0},"end":{"line":358,"character":9999}},"kind":12,"definition":"sub","children":[{"name":"$self","containerName":"codon_count","localvar":"my","kind":13,"line":341,"definition":"my"},{"definition":"my","localvar":"my","containerName":"codon_count","kind":13,"name":"$a","line":343},{"line":344,"name":"$cod","containerName":"codon_count","localvar":"my","kind":13,"definition":"my"},{"containerName":"codon_count","kind":13,"name":"$a","line":344},{"kind":13,"containerName":"codon_count","name":"$self","line":345},{"name":"_check_codon","kind":12,"containerName":"codon_count","line":345},{"name":"$cod","containerName":"codon_count","kind":13,"line":345},{"line":346,"name":"$ctable","localvar":"my","kind":13,"containerName":"codon_count","definition":"my"},{"line":346,"name":"new","kind":12,"containerName":"codon_count"},{"line":347,"kind":13,"containerName":"codon_count","name":"$ctable"},{"containerName":"codon_count","kind":12,"name":"id","line":347},{"line":347,"name":"$self","containerName":"codon_count","kind":13},{"kind":12,"containerName":"codon_count","name":"genetic_code","line":347},{"definition":"my","line":348,"name":"$aa","containerName":"codon_count","localvar":"my","kind":13},{"line":348,"containerName":"codon_count","kind":13,"name":"$Bio"},{"line":348,"name":"$ctable","kind":13,"containerName":"codon_count"},{"line":348,"containerName":"codon_count","kind":12,"name":"translate"},{"line":348,"name":"$cod","containerName":"codon_count","kind":13},{"kind":13,"containerName":"codon_count","name":"$self","line":349},{"name":"$aa","containerName":"codon_count","kind":13,"line":349},{"containerName":"codon_count","kind":13,"name":"$cod","line":349},{"name":"$self","kind":13,"containerName":"codon_count","line":354},{"line":354,"name":"warn","kind":12,"containerName":"codon_count"}],"containerName":"main::","name":"codon_count"},{"containerName":"Tools::CodonTable","kind":12,"name":"Bio","line":346},{"line":348,"name":"SeqUtils","kind":12,"containerName":"THREECODE"},{"kind":12,"range":{"end":{"character":9999,"line":397},"start":{"line":372,"character":0}},"line":372,"definition":"sub","name":"get_coding_gc","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"get_coding_gc","localvar":"my","kind":13,"line":373},{"kind":13,"containerName":"get_coding_gc","name":"$self","line":375},{"line":375,"containerName":"get_coding_gc","kind":12,"name":"warn"},{"definition":"my","localvar":"my","containerName":"get_coding_gc","kind":13,"name":"$n","line":379},{"name":"$self","containerName":"get_coding_gc","kind":13,"line":381},{"kind":13,"containerName":"get_coding_gc","name":"$n","line":381},{"name":"$self","containerName":"get_coding_gc","kind":13,"line":382},{"line":382,"containerName":"get_coding_gc","kind":13,"name":"$n"},{"line":385,"name":"$self","containerName":"get_coding_gc","kind":13},{"line":386,"kind":13,"containerName":"get_coding_gc","name":"$self"},{"line":386,"name":"warn","containerName":"get_coding_gc","kind":12},{"kind":13,"containerName":"get_coding_gc","name":"$self","line":387},{"line":391,"name":"$self","containerName":"get_coding_gc","kind":13},{"line":391,"name":"warn","containerName":"get_coding_gc","kind":12}]},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"set_coding_gc","line":413,"definition":"my"},{"name":"$key","containerName":"set_coding_gc","kind":13,"line":413},{"name":"$value","containerName":"set_coding_gc","kind":13,"line":413},{"line":414,"name":"@allowed","containerName":"set_coding_gc","localvar":"my","kind":13,"definition":"my"},{"containerName":"set_coding_gc","kind":13,"name":"$key","line":415},{"line":416,"kind":13,"containerName":"set_coding_gc","name":"$key"},{"line":416,"kind":13,"containerName":"set_coding_gc","name":"@allowed"},{"line":417,"containerName":"set_coding_gc","kind":13,"name":"$self"},{"kind":12,"containerName":"set_coding_gc","name":"warn","line":417},{"name":"@allowed","containerName":"set_coding_gc","kind":13,"line":417},{"kind":13,"containerName":"set_coding_gc","name":"$self","line":420},{"name":"$key","kind":13,"containerName":"set_coding_gc","line":420},{"line":420,"name":"$value","containerName":"set_coding_gc","kind":13}],"name":"set_coding_gc","containerName":"main::","definition":"sub","detail":"($self,$key,$value)","line":412,"kind":12,"range":{"start":{"character":0,"line":412},"end":{"character":9999,"line":423}},"signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..","label":"set_coding_gc($self,$key,$value)"}},{"definition":"sub","containerName":"main::","name":"species","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"species","line":436,"definition":"my"},{"line":438,"name":"$self","containerName":"species","kind":13},{"name":"$self","containerName":"species","kind":13,"line":440}],"range":{"end":{"character":9999,"line":441},"start":{"character":0,"line":435}},"kind":12,"line":435},{"line":453,"kind":12,"range":{"end":{"character":9999,"line":467},"start":{"character":0,"line":453}},"children":[{"definition":"my","name":"$self","containerName":"genetic_code","localvar":"my","kind":13,"line":454},{"line":456,"name":"$val","localvar":"my","containerName":"genetic_code","kind":13,"definition":"my"},{"name":"$val","kind":13,"containerName":"genetic_code","line":457},{"name":"$val","kind":13,"containerName":"genetic_code","line":457},{"containerName":"genetic_code","kind":13,"name":"$val","line":457},{"line":458,"containerName":"genetic_code","kind":13,"name":"$val"},{"containerName":"genetic_code","kind":13,"name":"$val","line":458},{"line":459,"containerName":"genetic_code","kind":13,"name":"$self"},{"line":459,"containerName":"genetic_code","kind":12,"name":"warn"},{"name":"$self","containerName":"genetic_code","kind":13,"line":460},{"line":463,"name":"$self","kind":13,"containerName":"genetic_code"},{"name":"$self","kind":13,"containerName":"genetic_code","line":466}],"containerName":"main::","name":"genetic_code","definition":"sub"},{"children":[{"definition":"my","line":481,"containerName":"cds_count","localvar":"my","kind":13,"name":"$self"},{"line":483,"kind":13,"localvar":"my","containerName":"cds_count","name":"$val","definition":"my"},{"line":484,"name":"$val","kind":13,"containerName":"cds_count"},{"kind":13,"containerName":"cds_count","name":"$self","line":485},{"line":485,"name":"warn","kind":12,"containerName":"cds_count"},{"containerName":"cds_count","kind":13,"name":"$self","line":486},{"line":489,"kind":13,"containerName":"cds_count","name":"$self"},{"containerName":"cds_count","kind":13,"name":"$val","line":489},{"line":492,"containerName":"cds_count","kind":13,"name":"$self"},{"name":"warn","containerName":"cds_count","kind":12,"line":492},{"line":493,"containerName":"cds_count","kind":13,"name":"$self"},{"line":495,"name":"$self","kind":13,"containerName":"cds_count"}],"name":"cds_count","containerName":"main::","definition":"sub","line":480,"kind":12,"range":{"end":{"character":9999,"line":496},"start":{"character":0,"line":480}}},{"line":510,"kind":12,"range":{"start":{"line":510,"character":0},"end":{"character":9999,"line":526}},"signature":{"parameters":[{"label":"$self"},{"label":"$a"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..\n\n\nsub set_coding_gc {\n\tmy ($self, $key, $value) = @_;\n\tmy @allowed = qw(1 2 3 all);\n\t$key =~ s/\\-//;\n\tif (!grep {$key eq $_} @allowed ) {\n\t\t$self->warn (\"invalid key! - must be one of [ \". (join \" \", @allowed) . \"]\");\n\t\treturn;\n\t\t}\n\t$self->{'_coding_gc'}{$key} = $value;\n\t\n\n}\n\n=head2 species\n\n Title     : species\n Usage     : my $sp = $cut->species();\n Purpose   : Get/setter for species name of codon table\n Returns   : Void or species name string\n Args      : None or species name string\n\n\nsub species {\n\tmy $self = shift;\n\tif (@_ ){\n\t\t$self->{'_species'} = shift;\n\t\t}\n\treturn $self->{'_species'} || \"unknown\";\n}\n\n=head2 genetic_code\n\n Title     : genetic_code\n Usage     : my $sp = $cut->genetic_code();\n Purpose   : Get/setter for genetic_code name of codon table\n Returns   : Void or genetic_code id, 1 by default\n Args      : None or genetic_code id, 1 by default if invalid argument.\n\n\nsub genetic_code {\n\tmy $self = shift;\n\tif (@_ ){\n\t\tmy $val = shift;\n\t\tif ($val < 0 || $val >16 || $val =~ /[^\\d]/ \n\t\t\t\t|| $val ==7 || $val ==8) {\n\t\t\t$self->warn (\"invalid genetic code - must be 1-16 but not 7 or 8,setting to default [1]\");\n\t\t\t$self->{'_genetic_code'} = 1;\n\t\t\t}\n\t\telse {\n\t\t\t$self->{'_genetic_code'} = shift;\n\t\t\t}\n\t\t}\n\treturn $self->{'_genetic_code'} || 1;\n}\n\n=head2 cds_count\n\n Title   : cds_count\n Usage   : my $count = $cdtable->cds_count();\n Purpose : To retrieve the total number of CDSs used to generate the Codon Table\n           for that organism. \n Returns : an integer\n Args    : none (if retrieving the value) or an integer( if setting ). \n\n\nsub cds_count {\n\tmy $self= shift;\n\tif (@_) {\n\t\tmy $val = shift;\n\t\tif ($val < 0) {\n\t\t\t$self->warn(\"can't have negative count initializing to 1\");\n\t\t\t$self->{'_cds_count'} = 0.00;\n\t\t\t}\n\t\telse{\n\t\t\t$self->{'_cds_count'} = $val;\n\t\t}\n\t}\n\t$self->warn(\"cds_count value is undefined, returning 0\") \n\t\tif !exists($self->{'_cds_count'});\n\n\treturn $self->{'_cds_count'} || 0.00;\n\t}\n\n=head2 aa_frequency\n\n Title   : aa_frequency\n Usage   : my $freq = $cdtable->aa_frequency('Leu');\n Purpose : To retrieve the frequency of an amino acid in the organism\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid","label":"aa_frequency($self,$a)"},"children":[{"definition":"my","name":"$self","containerName":"aa_frequency","localvar":"my","kind":13,"line":511},{"line":511,"kind":13,"containerName":"aa_frequency","name":"$a"},{"definition":"my","line":515,"name":"$aa","kind":13,"localvar":"my","containerName":"aa_frequency"},{"line":515,"name":"$a","containerName":"aa_frequency","kind":13},{"line":516,"containerName":"aa_frequency","kind":13,"name":"$aa"},{"line":517,"containerName":"aa_frequency","kind":13,"name":"$STRICTAA"},{"line":517,"containerName":"aa_frequency","kind":13,"name":"$aa"},{"line":517,"name":"$Bio","kind":13,"containerName":"aa_frequency"},{"name":"$aa","containerName":"aa_frequency","kind":13,"line":517},{"line":518,"containerName":"aa_frequency","kind":13,"name":"$self"},{"name":"warn","containerName":"aa_frequency","kind":12,"line":518},{"definition":"my","kind":13,"localvar":"my","containerName":"aa_frequency","name":"$aa3","line":522},{"line":522,"containerName":"aa_frequency","kind":13,"name":"$Bio"},{"name":"$aa","kind":13,"containerName":"aa_frequency","line":522},{"containerName":"aa_frequency","kind":13,"name":"$aa","line":522},{"definition":"my","line":525,"name":"$freq","localvar":"my","containerName":"aa_frequency","kind":13},{"line":526,"containerName":"aa_frequency","kind":13,"name":"$freq"},{"line":526,"kind":13,"containerName":"aa_frequency","name":"$self"},{"kind":13,"containerName":"aa_frequency","name":"$aa3","line":526},{"line":526,"name":"$self","kind":13,"containerName":"aa_frequency"},{"containerName":"aa_frequency","kind":13,"name":"$aa3","line":526}],"name":"aa_frequency","containerName":"main::","definition":"sub","detail":"($self,$a)"},{"name":"SeqUtils","containerName":"ONECODE","kind":12,"line":517},{"line":522,"containerName":"THREECODE","kind":12,"name":"SeqUtils"},{"line":527,"kind":13,"containerName":null,"name":"$freq"},{"line":540,"kind":12,"range":{"end":{"character":9999,"line":555},"start":{"character":0,"line":540}},"signature":{"label":"common_codon($self,$a)","documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..\n\n\nsub set_coding_gc {\n\tmy ($self, $key, $value) = @_;\n\tmy @allowed = qw(1 2 3 all);\n\t$key =~ s/\\-//;\n\tif (!grep {$key eq $_} @allowed ) {\n\t\t$self->warn (\"invalid key! - must be one of [ \". (join \" \", @allowed) . \"]\");\n\t\treturn;\n\t\t}\n\t$self->{'_coding_gc'}{$key} = $value;\n\t\n\n}\n\n=head2 species\n\n Title     : species\n Usage     : my $sp = $cut->species();\n Purpose   : Get/setter for species name of codon table\n Returns   : Void or species name string\n Args      : None or species name string\n\n\nsub species {\n\tmy $self = shift;\n\tif (@_ ){\n\t\t$self->{'_species'} = shift;\n\t\t}\n\treturn $self->{'_species'} || \"unknown\";\n}\n\n=head2 genetic_code\n\n Title     : genetic_code\n Usage     : my $sp = $cut->genetic_code();\n Purpose   : Get/setter for genetic_code name of codon table\n Returns   : Void or genetic_code id, 1 by default\n Args      : None or genetic_code id, 1 by default if invalid argument.\n\n\nsub genetic_code {\n\tmy $self = shift;\n\tif (@_ ){\n\t\tmy $val = shift;\n\t\tif ($val < 0 || $val >16 || $val =~ /[^\\d]/ \n\t\t\t\t|| $val ==7 || $val ==8) {\n\t\t\t$self->warn (\"invalid genetic code - must be 1-16 but not 7 or 8,setting to default [1]\");\n\t\t\t$self->{'_genetic_code'} = 1;\n\t\t\t}\n\t\telse {\n\t\t\t$self->{'_genetic_code'} = shift;\n\t\t\t}\n\t\t}\n\treturn $self->{'_genetic_code'} || 1;\n}\n\n=head2 cds_count\n\n Title   : cds_count\n Usage   : my $count = $cdtable->cds_count();\n Purpose : To retrieve the total number of CDSs used to generate the Codon Table\n           for that organism. \n Returns : an integer\n Args    : none (if retrieving the value) or an integer( if setting ). \n\n\nsub cds_count {\n\tmy $self= shift;\n\tif (@_) {\n\t\tmy $val = shift;\n\t\tif ($val < 0) {\n\t\t\t$self->warn(\"can't have negative count initializing to 1\");\n\t\t\t$self->{'_cds_count'} = 0.00;\n\t\t\t}\n\t\telse{\n\t\t\t$self->{'_cds_count'} = $val;\n\t\t}\n\t}\n\t$self->warn(\"cds_count value is undefined, returning 0\") \n\t\tif !exists($self->{'_cds_count'});\n\n\treturn $self->{'_cds_count'} || 0.00;\n\t}\n\n=head2 aa_frequency\n\n Title   : aa_frequency\n Usage   : my $freq = $cdtable->aa_frequency('Leu');\n Purpose : To retrieve the frequency of an amino acid in the organism\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid\n\n\n\t\n\nsub aa_frequency {\n\tmy ($self, $a) = @_;\n\t## process args ##\n\n\t## deal with cases ##\n\tmy $aa = lc $a;\t\n\t$aa =~ s/^(\\w)/\\U$1/;\n\tif (!exists($STRICTAA{$aa}) && !exists($Bio::SeqUtils::ONECODE{$aa}) ) {\n\t\t$self->warn(\"Invalid amino acid! must be a unique 1 letter or 3 letter identifier\");\n\t\treturn;\n\t\t}\n\t#translate to 3 letter code for Ctable #\n\tmy $aa3 = $Bio::SeqUtils::THREECODE{$aa} || $aa;\n\n\t## return % of all amino acids in organism ## \n\tmy $freq = 0;\n\tmap {$freq += $self->{'_table'}{$aa3}{$_}{'per1000'} } keys %{$self->{'_table'}{$aa3}};\n\treturn sprintf(\"%.2f\", $freq/10);\n}\n\n=head2 common_codon\n\n Title   : common_codon\n Usage   : my $freq = $cdtable->common_codon('Leu');\n Purpose : To retrieve the frequency of the most common codon of that aa\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid","parameters":[{"label":"$self"},{"label":"$a"}]},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"common_codon","line":542},{"line":542,"name":"$a","containerName":"common_codon","kind":13},{"line":543,"name":"$aa","containerName":"common_codon","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"common_codon","name":"$a","line":543},{"name":"$aa","containerName":"common_codon","kind":13,"line":544},{"name":"$self","kind":13,"containerName":"common_codon","line":546},{"containerName":"common_codon","kind":12,"name":"_check_aa","line":546},{"kind":13,"containerName":"common_codon","name":"$aa","line":546},{"definition":"my","line":547,"localvar":"my","kind":13,"containerName":"common_codon","name":"$aa3"},{"line":547,"name":"$Bio","containerName":"common_codon","kind":13},{"line":547,"name":"$aa","kind":13,"containerName":"common_codon"},{"name":"$aa3","kind":13,"containerName":"common_codon","line":548},{"kind":13,"containerName":"common_codon","name":"$aa","line":548},{"definition":"my","name":"$max","containerName":"common_codon","localvar":"my","kind":13,"line":549},{"line":550,"name":"$cod","localvar":"my","kind":13,"containerName":"common_codon","definition":"my"},{"name":"$self","kind":13,"containerName":"common_codon","line":550},{"line":550,"kind":13,"containerName":"common_codon","name":"$aa3"},{"line":551,"containerName":"common_codon","kind":13,"name":"$max"},{"line":551,"name":"$self","kind":13,"containerName":"common_codon"},{"line":551,"name":"$aa3","containerName":"common_codon","kind":13},{"line":551,"kind":13,"containerName":"common_codon","name":"$cod"},{"line":551,"name":"$max","containerName":"common_codon","kind":13},{"line":552,"name":"$self","containerName":"common_codon","kind":13},{"line":552,"containerName":"common_codon","kind":13,"name":"$aa3"},{"name":"$cod","containerName":"common_codon","kind":13,"line":552},{"line":552,"containerName":"common_codon","kind":13,"name":"$max"},{"line":554,"name":"$max","kind":13,"containerName":"common_codon"}],"containerName":"main::","name":"common_codon","definition":"sub","detail":"($self,$a)"},{"line":548,"name":"SeqUtils","containerName":"THREECODE","kind":12},{"detail":"($self,$a)","definition":"sub","name":"rare_codon","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"rare_codon","name":"$self","line":569},{"name":"$a","kind":13,"containerName":"rare_codon","line":569},{"definition":"my","containerName":"rare_codon","localvar":"my","kind":13,"name":"$aa","line":570},{"line":570,"containerName":"rare_codon","kind":13,"name":"$a"},{"line":571,"name":"$aa","kind":13,"containerName":"rare_codon"},{"name":"$self","kind":13,"containerName":"rare_codon","line":572},{"name":"_check_aa","containerName":"rare_codon","kind":12,"line":572},{"line":572,"name":"$aa","containerName":"rare_codon","kind":13},{"line":573,"localvar":"my","containerName":"rare_codon","kind":13,"name":"$aa3","definition":"my"},{"line":573,"name":"$Bio","kind":13,"containerName":"rare_codon"},{"name":"$aa","containerName":"rare_codon","kind":13,"line":573},{"line":574,"kind":13,"containerName":"rare_codon","name":"$aa3"},{"line":574,"containerName":"rare_codon","kind":13,"name":"$aa"},{"definition":"my","name":"$min","localvar":"my","containerName":"rare_codon","kind":13,"line":575},{"definition":"my","line":576,"name":"$cod","containerName":"rare_codon","localvar":"my","kind":13},{"line":576,"name":"$self","kind":13,"containerName":"rare_codon"},{"containerName":"rare_codon","kind":13,"name":"$aa3","line":576},{"name":"$min","kind":13,"containerName":"rare_codon","line":577},{"name":"$self","containerName":"rare_codon","kind":13,"line":577},{"line":577,"containerName":"rare_codon","kind":13,"name":"$aa3"},{"name":"$cod","containerName":"rare_codon","kind":13,"line":577},{"kind":13,"containerName":"rare_codon","name":"$min","line":577},{"containerName":"rare_codon","kind":13,"name":"$self","line":578},{"kind":13,"containerName":"rare_codon","name":"$aa3","line":578},{"line":578,"kind":13,"containerName":"rare_codon","name":"$cod"},{"line":578,"name":"$min","kind":13,"containerName":"rare_codon"},{"containerName":"rare_codon","kind":13,"name":"$min","line":580}],"signature":{"label":"rare_codon($self,$a)","parameters":[{"label":"$self"},{"label":"$a"}],"documentation":"1;\n# $Id: Table.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::CodonUsage::Table\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams (richard.adams@ed.ac.uk)\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::CodonUsage::Table - for access to the Codon usage Database\nat http://www.kazusa.or.jp/codon.\n\n=head1 SYNOPSIS\n\n  use Bio::CodonUsage::Table;\n  use Bio::DB::CUTG;\n  use Bio::CodonUsage::IO;\n  use Bio::Tools::SeqStats;\n\n  # Get  a codon usage table from web database\n  my $cdtable = Bio::DB::CUTG->new(-sp => 'Mus musculus',\n                                   -gc => 1);\n\n  # Or from local file\n  my $io      = Bio::CodonUsage::IO->new(-file => \"file\");\n  my $cdtable = $io->next_data();\n\n  # Or create your own from a Bio::PrimarySeq compliant object,\n  # $codonstats is a ref to a hash of codon name /count key-value pairs\n  my $codonstats = Bio::Tools::SeqStats->count_codons($Seq_objct);\n\n  # '-data' must be specified, '-species' and 'genetic_code' are optional\n  my $CUT = Bio::CodonUsage::Table->new(-data    => $codonstats,\n                                        -species => 'Hsapiens_kinase');\n\n  print \"leu frequency is \", $cdtable->aa_frequency('LEU'), \"\\n\";\n  print \"freq of ATG is \", $cdtable->codon_rel_frequency('ttc'), \"\\n\";\n  print \"abs freq of ATG is \", $cdtable->codon_abs_frequency('ATG'), \"\\n\";\n  print \"number of ATG codons is \", $cdtable->codon_count('ATG'), \"\\n\";\n  print \"GC content at position 1 is \", $cdtable->get_coding_gc('1'), \"\\n\";\n  print \"total CDSs for Mus musculus  is \", $cdtable->cds_count(), \"\\n\";\n\n=head1 DESCRIPTION\n\n\nThis class provides methods for accessing codon usage table data.\n\nAll of the methods at present are simple look-ups of the table or are\nderived from simple calculations from the table. Future methods could\ninclude measuring the codon usage of a sequence , for example, or\nprovide methods for examining codon usage in alignments.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::CodonTable>, \nL<Bio::WebAgent>,\nL<Bio::CodonUsage::IO>,\nL<Bio::DB::CUTG>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::CodonUsage::Table;\nuse strict;\nuse vars qw(%STRICTAA @AA);\nuse Bio::SeqUtils;\nuse Bio::Tools::CodonTable;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN{\n @AA = qw(A C D E F G H I K L M N P Q R S T V W Y *);\n map {$STRICTAA{$_} = undef} @AA;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $cut = Bio::CodonUsage::Table->new(-data => $cut_hash_ref,\n                                                 -species => 'H.sapiens_kinase'\n                                                 -genetic_code =>1);\n Returns : a reference to a new  Bio::CodonUsage::Table object\n Args    : none or a reference to a hash of codon counts. This constructor is\n           designed to be compatible with the output of\n           Bio::Tools::SeqUtils::count_codons()\n           Species and genetic code parameters can be entered here or via the \n           species() and genetic_code() methods separately.\n\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self= $class->SUPER::new(@args);\n\tif (@args) {\n\t\t$self->_rearrange([qw(DATA)], @args);\n\t\tshift @args; # get rid of key\n\t\tmy $arg = shift @args;\n\t\t$self->throw(\"need a hash reference, not a [\" . ref($arg). \"] reference\") if ref($arg) ne 'HASH';\n\t\t### flags to detect argument type, can be either to start with  ##\n\t\tmy $is_codon_hash = 1;\n\t\tmy $is_Aa_hash = 1;\n\t\tfor my $k (keys %$arg) {\n\t\t\t## convert to UC\n\t\t\t$k =~ s/(\\w+)/\\U$1/;\n\t\t\tif (!exists($STRICTAA{$k}) ){\n\t\t\t\t$is_Aa_hash = 0;\n\t\t\t\t}\n\t\t\telsif ($k =~ /[^ATCGatcg]/) {\n\t\t\t\t$is_codon_hash = 0;\n\t\t\t\t}\n\t\t}\n\t\tif (!$is_codon_hash && !$is_Aa_hash) {\n\t\t\t$self->throw(\" invalid key values in CUT hash - must be unique aa or nucleotide identifiers\");\n\t\t\t}\n\t\telsif ($is_Aa_hash) {\n\t\t\t$self->_init_from_aa($arg);\n\t\t\t}\n\t\telsif($is_codon_hash) {\n\t\t\t$self->_init_from_cod($arg);\n\t\t\t}\n\t\twhile (@args) {\n\t\t\tmy $key = shift @args;\n\t\t\t$key =~ s/\\-(\\w+)/\\L$1/;\n\t\t\t\n\t\t\t$self->$key(shift @args);\n\t\t\t}\n\t}\n\t\t\n\treturn $self;\n}\n\n=head2 all_aa_frequencies\n\n Title   : all_aa_frequencies\n Usage   : my $freq = $cdtable->all_aa_frequencies();\n Returns : a reference to a hash where each key is an amino acid\n           and each value is its frequency in all proteins in that\n           species.\n Args    : none\n\n\nsub all_aa_frequencies {\n\tmy $self = shift;\n\tmy %aa_freqs =();\n\tfor my $aa (keys %STRICTAA) {\n\t\tmy $freq = $self->aa_frequency($aa);\n\t\t$aa_freqs{$aa} = $freq;\n\t\t}\n\treturn \\%aa_freqs;\n}\n\n=head2 codon_abs_frequency\n\n Title   : codon_abs_frequency\n Usage   : my $freq = $cdtable->codon_abs_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of all codons in the organism. \n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\nsub codon_abs_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod))  {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code() );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\n\t\treturn $self->{'_table'}{$aa}{$cod}{'per1000'}/10 ;\n\t\t}\n\telse {return 0;}\n}\n\n=head2 codon_rel_frequency\n\n Title   : codon_rel_frequency\n Usage   : my $freq = $cdtable->codon_rel_frequency('CTG');\n Purpose : To return the frequency of that codon as a percentage\n           of codons coding for the same amino acid. E.g., ATG and TGG\n           would return 100 as those codons are unique.\n Returns : a percentage frequency\n Args    : a non-ambiguous codon string\n\n\n\nsub codon_rel_frequency {\n\tmy ($self, $a) = @_;\n\tmy $cod = uc $a;\n\tif ($self->_check_codon($cod)) {\n\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t$ctable->id($self->genetic_code () );\n\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\treturn $self->{'_table'}{$aa}{$cod}{'rel_freq'};\n\t}\n\telse {\n\t\treturn 0;\n\t\t}\n}\n\n=head2 probable_codons\n\n Title    : probable_codons\n Usage    : my $prob_codons = $cd_table->probable_codons(10);\n Purpose  : to obtain a list of codons for the amino acid above a given\n            threshold % relative frequency\n Returns  : A reference to a hash where keys are 1 letter amino acid  codes\n            and values are references to arrays of codons whose frequency\n            is above the threshold.\n Arguments: a minimum threshold frequency\n\n\nsub probable_codons {\n\tmy ($self, $threshold) = @_;\n\tif (!$threshold || $threshold < 0 || $threshold > 100) {\n\t\t$self->throw(\" I need a threshold percentage \");\n\t\t}\n\tmy %return_hash;\n\tfor my $a(keys %STRICTAA) {\n\t\tmy @common_codons;\n\t\tmy $aa =$Bio::SeqUtils::THREECODE{$a};\n\t\tfor my $codon (keys %{ $self->{'_table'}{$aa}}) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $threshold/100){\n\t\t\t\tpush @common_codons, $codon;\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = \\@common_codons;\n\t}\n    ## check to make sure that all codons are populated ##\n\tif (grep{scalar @{$return_hash{$_}} == 0} keys %return_hash) {\n\t\t$self->warn(\"Threshold is too high, some amino acids do not\" .\n\t\t\t\t\t\" have any codon above the threshold!\");\n\t\t}\n    return \\%return_hash;\n}\n\t\t\n\n=head2 most_common_codons\n\n Title    : most_common_codons\n Usage    : my $common_codons = $cd_table->most_common_codons();\n Purpose  : To obtain the most common codon for a given amino acid\n Returns  : A reference to a hash where keys are 1 letter amino acid codes\n            and the values are the single most common codons for those amino acids\n Arguments: None\n\n\nsub most_common_codons {\n\tmy $self = shift;\n\n\tmy %return_hash;\n\n\tfor my $a ( keys %STRICTAA ) {\n\n\t\tmy $common_codon = '';\n\t\tmy $rel_freq = 0;\n\t\tmy $aa = $Bio::SeqUtils::THREECODE{$a};\n\n\t\tif ( ! defined $self->{'_table'}{$aa} ) {\n\t\t\t$self->warn(\"Amino acid $aa ($a) does not have any codons!\");\n\t\t\tnext;\n\t\t}\n\n\t\tfor my $codon ( keys %{ $self->{'_table'}{$aa}} ) {\n\t\t\tif ($self->{'_table'}{$aa}{$codon}{'rel_freq'} > $rel_freq ){\n\t\t\t\t$common_codon = $codon;\n\t\t\t\t$rel_freq = $self->{'_table'}{$aa}{$codon}{'rel_freq'};\n\t\t\t}\n\t\t}\n\t\t$return_hash{$a} = $common_codon;\n\t}\n   \n\treturn \\%return_hash;\n}\n\n=head2 codon_count\n\n Title   : codon_count\n Usage   : my $count = $cdtable->codon_count('CTG');\n Purpose : To obtain the absolute number of the codons in the\n           organism. \n Returns : an integer\n Args    : a non-ambiguous codon string\n\n\nsub codon_count {\n\tmy $self = shift;\n\tif (@_) {\n\t\tmy $a = shift;\n\t\tmy $cod = uc $a;\n\t\tif ($self->_check_codon($cod)) {\n\t\t\tmy $ctable =  Bio::Tools::CodonTable->new;\n\t\t\t$ctable->id($self->genetic_code());\n\t\t\tmy $aa =$Bio::SeqUtils::THREECODE {$ctable->translate($cod)};\n\t\t\treturn $self->{'_table'}{$aa}{$cod}{'abs_count'};\n\t\t\t}\n\t\telse {return 0;}\n\t}\n\telse {\n\t\t$self->warn(\" need to give a codon sequence as a parameter \");\n\t\treturn 0;\n\t\t}\n\t\n}\n\n=head2 get_coding_gc\n\n Title   : get_coding_gc\n Usage   : my $count = $cdtable->get_coding_gc(1);\n Purpose : To return the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n          ('all').\n Returns : a number (%-age GC content) or 0 if these fields are undefined\n Args    : 1,2,3 or 'all'.\n\n\nsub get_coding_gc {\n\tmy $self  = shift;\n\tif (! @_) {\n\t\t$self->warn(\" no parameters supplied must be  a codon position (1,2,3) or 'all'\");\n\t\treturn 0;\n\t\t\t}\n\telse{\n\t\tmy $n = shift;\n\t\t##return request if valid ##\n\t\tif ( exists($self->{'_coding_gc'}{$n} ) ) {\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{$n});\n\t\t\t}\n\t\t##else return 'all' value if exists\n\t\telsif (exists($self->{'_coding_gc'}{'all'} )) {\n\t\t\t$self->warn(\"coding gc doesn't have value for [$n], returning gc content for all CDSs\");\n\t\t\treturn sprintf(\"%.2f\", $self->{'_coding_gc'}{'all'});\n\t\t\t}\n\t\t### else return 0, \n\t\telse {\n\t\t\t$self->warn(\"coding gc values aren't defined, returning 0\");\n\t\t\treturn 0;\n\t\t}\n\n\t}#end of outer else\n\t\t\n}\n\n=head2 set_coding_gc\n\n Title   : set_coding_gc\n Usage   : my $count = $cdtable->set_coding_gc(-1=>55.78);\n Purpose : To set the percentage GC composition for the organism at\n           codon positions 1,2 or 3, or an average for all coding sequence\n           ('all').  \n Returns : void\n Args    : a hash where the key must be 1,2,3 or 'all' and the value the %age GC\n           at that codon position..\n\n\nsub set_coding_gc {\n\tmy ($self, $key, $value) = @_;\n\tmy @allowed = qw(1 2 3 all);\n\t$key =~ s/\\-//;\n\tif (!grep {$key eq $_} @allowed ) {\n\t\t$self->warn (\"invalid key! - must be one of [ \". (join \" \", @allowed) . \"]\");\n\t\treturn;\n\t\t}\n\t$self->{'_coding_gc'}{$key} = $value;\n\t\n\n}\n\n=head2 species\n\n Title     : species\n Usage     : my $sp = $cut->species();\n Purpose   : Get/setter for species name of codon table\n Returns   : Void or species name string\n Args      : None or species name string\n\n\nsub species {\n\tmy $self = shift;\n\tif (@_ ){\n\t\t$self->{'_species'} = shift;\n\t\t}\n\treturn $self->{'_species'} || \"unknown\";\n}\n\n=head2 genetic_code\n\n Title     : genetic_code\n Usage     : my $sp = $cut->genetic_code();\n Purpose   : Get/setter for genetic_code name of codon table\n Returns   : Void or genetic_code id, 1 by default\n Args      : None or genetic_code id, 1 by default if invalid argument.\n\n\nsub genetic_code {\n\tmy $self = shift;\n\tif (@_ ){\n\t\tmy $val = shift;\n\t\tif ($val < 0 || $val >16 || $val =~ /[^\\d]/ \n\t\t\t\t|| $val ==7 || $val ==8) {\n\t\t\t$self->warn (\"invalid genetic code - must be 1-16 but not 7 or 8,setting to default [1]\");\n\t\t\t$self->{'_genetic_code'} = 1;\n\t\t\t}\n\t\telse {\n\t\t\t$self->{'_genetic_code'} = shift;\n\t\t\t}\n\t\t}\n\treturn $self->{'_genetic_code'} || 1;\n}\n\n=head2 cds_count\n\n Title   : cds_count\n Usage   : my $count = $cdtable->cds_count();\n Purpose : To retrieve the total number of CDSs used to generate the Codon Table\n           for that organism. \n Returns : an integer\n Args    : none (if retrieving the value) or an integer( if setting ). \n\n\nsub cds_count {\n\tmy $self= shift;\n\tif (@_) {\n\t\tmy $val = shift;\n\t\tif ($val < 0) {\n\t\t\t$self->warn(\"can't have negative count initializing to 1\");\n\t\t\t$self->{'_cds_count'} = 0.00;\n\t\t\t}\n\t\telse{\n\t\t\t$self->{'_cds_count'} = $val;\n\t\t}\n\t}\n\t$self->warn(\"cds_count value is undefined, returning 0\") \n\t\tif !exists($self->{'_cds_count'});\n\n\treturn $self->{'_cds_count'} || 0.00;\n\t}\n\n=head2 aa_frequency\n\n Title   : aa_frequency\n Usage   : my $freq = $cdtable->aa_frequency('Leu');\n Purpose : To retrieve the frequency of an amino acid in the organism\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid\n\n\n\t\n\nsub aa_frequency {\n\tmy ($self, $a) = @_;\n\t## process args ##\n\n\t## deal with cases ##\n\tmy $aa = lc $a;\t\n\t$aa =~ s/^(\\w)/\\U$1/;\n\tif (!exists($STRICTAA{$aa}) && !exists($Bio::SeqUtils::ONECODE{$aa}) ) {\n\t\t$self->warn(\"Invalid amino acid! must be a unique 1 letter or 3 letter identifier\");\n\t\treturn;\n\t\t}\n\t#translate to 3 letter code for Ctable #\n\tmy $aa3 = $Bio::SeqUtils::THREECODE{$aa} || $aa;\n\n\t## return % of all amino acids in organism ## \n\tmy $freq = 0;\n\tmap {$freq += $self->{'_table'}{$aa3}{$_}{'per1000'} } keys %{$self->{'_table'}{$aa3}};\n\treturn sprintf(\"%.2f\", $freq/10);\n}\n\n=head2 common_codon\n\n Title   : common_codon\n Usage   : my $freq = $cdtable->common_codon('Leu');\n Purpose : To retrieve the frequency of the most common codon of that aa\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid\n\n\nsub common_codon{\n\n\tmy ($self, $a) = @_;\n\tmy $aa = lc $a;\t\n\t$aa =~ s/^(\\w)/\\U$1/;\n\n\tif ($self->_check_aa($aa))\t{\n\t\tmy $aa3 = $Bio::SeqUtils::THREECODE{$aa} ;\n\t\t$aa3 ||= $aa;\n\t\tmy $max = 0;\n\t\tfor my $cod (keys %{$self->{'_table'}{$aa3}}) {\n\t\t\t$max = ($self->{'_table'}{$aa3}{$cod}{'rel_freq'} > $max) ?\n\t\t\t\t\t$self->{'_table'}{$aa3}{$cod}{'rel_freq'}:$max;\n\t\t\t}\n\t\treturn $max;\n\t\t}else {return 0;}\n}\n\n=head2 rare_codon\n\n Title   : rare_codon\n Usage   : my $freq = $cdtable->rare_codon('Leu');\n Purpose : To retrieve the frequency of the least common codon of that aa\n Returns : a percentage\n Args    : a 1 letter or 3 letter string representing the amino acid"},"kind":12,"range":{"start":{"character":0,"line":568},"end":{"line":581,"character":9999}},"line":568},{"name":"SeqUtils","kind":12,"containerName":"THREECODE","line":574},{"signature":{"label":"_check_aa($self,$aa)","documentation":"# internal sub that checks a codon is correct format","parameters":[{"label":"$self"},{"label":"$aa"}]},"line":588,"kind":12,"range":{"start":{"character":0,"line":588},"end":{"character":9999,"line":594}},"definition":"sub","detail":"($self,$aa)","children":[{"line":589,"localvar":"my","containerName":"_check_aa","kind":13,"name":"$self","definition":"my"},{"line":589,"containerName":"_check_aa","kind":13,"name":"$aa"},{"name":"$STRICTAA","containerName":"_check_aa","kind":13,"line":590},{"line":590,"name":"$aa","containerName":"_check_aa","kind":13},{"name":"$Bio","kind":13,"containerName":"_check_aa","line":590},{"line":590,"name":"$aa","kind":13,"containerName":"_check_aa"},{"line":591,"kind":13,"containerName":"_check_aa","name":"$self"},{"containerName":"_check_aa","kind":12,"name":"warn","line":591}],"containerName":"main::","name":"_check_aa"},{"name":"SeqUtils","containerName":"ONECODE","kind":12,"line":590},{"line":599,"kind":12,"range":{"start":{"line":599,"character":0},"end":{"character":9999,"line":606}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cod"}],"label":"_check_codon($self,$cod)"},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_check_codon","line":600},{"kind":13,"containerName":"_check_codon","name":"$cod","line":600},{"containerName":"_check_codon","kind":13,"name":"$cod","line":601},{"kind":13,"containerName":"_check_codon","name":"$cod","line":601},{"line":602,"containerName":"_check_codon","kind":13,"name":"$self"},{"line":602,"name":"warn","containerName":"_check_codon","kind":12}],"containerName":"main::","name":"_check_codon","definition":"sub","detail":"($self,$cod)"},{"signature":{"label":"_init_from_cod($self,$ref)","documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}]},"kind":12,"range":{"start":{"line":607,"character":0},"end":{"line":618,"character":9999}},"line":607,"detail":"($self,$ref)","definition":"sub","containerName":"main::","name":"_init_from_cod","children":[{"definition":"my","line":610,"name":"$self","localvar":"my","kind":13,"containerName":"_init_from_cod"},{"containerName":"_init_from_cod","kind":13,"name":"$ref","line":610},{"definition":"my","line":611,"name":"$ct","localvar":"my","kind":13,"containerName":"_init_from_cod"},{"line":611,"kind":12,"containerName":"_init_from_cod","name":"new"},{"line":612,"name":"%aa_hash","kind":13,"localvar":"my","containerName":"_init_from_cod","definition":"my"},{"definition":"my","line":613,"containerName":"_init_from_cod","localvar":"my","kind":13,"name":"$codon"},{"definition":"my","line":614,"name":"$aa","localvar":"my","kind":13,"containerName":"_init_from_cod"},{"name":"$ct","kind":13,"containerName":"_init_from_cod","line":614},{"line":614,"containerName":"_init_from_cod","kind":12,"name":"translate"},{"name":"$codon","kind":13,"containerName":"_init_from_cod","line":614},{"line":615,"kind":13,"containerName":"_init_from_cod","name":"$aa_hash"},{"line":615,"name":"$aa","kind":13,"containerName":"_init_from_cod"},{"name":"$codon","containerName":"_init_from_cod","kind":13,"line":615},{"line":615,"containerName":"_init_from_cod","kind":13,"name":"$ref"},{"kind":13,"containerName":"_init_from_cod","name":"$codon","line":615},{"name":"$self","kind":13,"containerName":"_init_from_cod","line":617},{"line":617,"name":"_init_from_aa","containerName":"_init_from_cod","kind":12},{"name":"%aa_hash","kind":13,"containerName":"_init_from_cod","line":617}]},{"kind":12,"containerName":"Tools::CodonTable","name":"Bio","line":611},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}],"label":"_init_from_aa($self,$ref)"},"range":{"end":{"line":633,"character":9999},"start":{"line":621,"character":0}},"kind":12,"line":621,"detail":"($self,$ref)","definition":"sub","name":"_init_from_aa","containerName":"main::","children":[{"name":"$self","containerName":"_init_from_aa","localvar":"my","kind":13,"line":622,"definition":"my"},{"line":622,"name":"$ref","kind":13,"containerName":"_init_from_aa"},{"definition":"my","line":624,"localvar":"my","kind":13,"containerName":"_init_from_aa","name":"$total_codons"},{"name":"%threeletter","containerName":"_init_from_aa","localvar":"my","kind":13,"line":625,"definition":"my"},{"line":626,"kind":13,"containerName":"_init_from_aa","name":"$threeletter"},{"kind":13,"containerName":"_init_from_aa","name":"$Bio","line":626},{"name":"$ref","kind":13,"containerName":"_init_from_aa","line":626},{"containerName":"_init_from_aa","kind":13,"name":"$ref","line":627},{"line":627,"name":"%threeletter","kind":13,"containerName":"_init_from_aa"},{"name":"$aa","localvar":"my","containerName":"_init_from_aa","kind":13,"line":628,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_init_from_aa","name":"$cod","line":629},{"name":"$ref","kind":13,"containerName":"_init_from_aa","line":629},{"kind":13,"containerName":"_init_from_aa","name":"$aa","line":629},{"name":"$self","containerName":"_init_from_aa","kind":13,"line":630},{"name":"$aa","kind":13,"containerName":"_init_from_aa","line":630},{"kind":13,"containerName":"_init_from_aa","name":"$cod","line":630},{"kind":13,"containerName":"_init_from_aa","name":"$ref","line":630},{"line":630,"name":"$aa","kind":13,"containerName":"_init_from_aa"},{"line":630,"kind":13,"containerName":"_init_from_aa","name":"$cod"},{"line":631,"name":"$total_codons","kind":13,"containerName":"_init_from_aa"},{"line":631,"name":"$ref","kind":13,"containerName":"_init_from_aa"},{"containerName":"_init_from_aa","kind":13,"name":"$aa","line":631},{"name":"$cod","kind":13,"containerName":"_init_from_aa","line":631}]},{"name":"SeqUtils","kind":12,"containerName":"THREECODE","line":626},{"definition":"my","line":636,"name":"%aa","kind":13,"localvar":"my","containerName":null},{"definition":"my","name":"$cod","kind":13,"localvar":"my","containerName":null,"line":637},{"containerName":null,"kind":13,"name":"%ref","line":637},{"name":"%aa","containerName":null,"kind":13,"line":637},{"line":638,"containerName":null,"kind":13,"name":"%self"},{"name":"%aa","containerName":null,"kind":13,"line":638},{"line":638,"name":"%cod","kind":13,"containerName":null},{"line":639,"name":"%ref","containerName":null,"kind":13},{"name":"%aa","containerName":null,"kind":13,"line":639},{"kind":13,"containerName":null,"name":"$cod","line":639},{"line":639,"name":"$total_codons","containerName":null,"kind":13},{"definition":"my","line":643,"name":"%aa","kind":13,"localvar":"my","containerName":null},{"localvar":"my","kind":13,"containerName":null,"name":"%aa_freq","line":644,"definition":"my"},{"containerName":null,"kind":13,"name":"$aa_freq","line":645},{"containerName":null,"kind":13,"name":"%ref","line":645},{"containerName":null,"kind":13,"name":"%aa","line":645},{"name":"%ref","kind":13,"containerName":null,"line":646},{"name":"$aa","kind":13,"containerName":null,"line":646},{"definition":"my","line":647,"name":"$cod","kind":13,"localvar":"my","containerName":null},{"name":"%ref","containerName":null,"kind":13,"line":647},{"kind":13,"containerName":null,"name":"%aa","line":647},{"line":648,"name":"%self","containerName":null,"kind":13},{"line":648,"name":"%aa","containerName":null,"kind":13},{"line":648,"name":"%cod","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%ref","line":649},{"line":649,"kind":13,"containerName":null,"name":"%aa"},{"kind":13,"containerName":null,"name":"$cod","line":649},{"containerName":null,"kind":13,"name":"$aa_freq","line":649},{"line":655,"name":"%GC","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"definition":"my","line":656,"name":"%aa","localvar":"my","containerName":null,"kind":13},{"definition":"my","line":657,"name":"$cod","kind":13,"localvar":"my","containerName":null},{"line":657,"name":"%ref","containerName":null,"kind":13},{"line":657,"containerName":null,"kind":13,"name":"%aa"},{"definition":"my","line":658,"name":"%index","kind":13,"localvar":"my","containerName":null},{"name":"$cod","kind":13,"containerName":null,"line":659},{"line":659,"kind":13,"containerName":null,"name":"%index"},{"line":660,"kind":13,"containerName":null,"name":"%GC"},{"containerName":null,"kind":13,"name":"$index","line":660},{"line":660,"name":"%ref","kind":13,"containerName":null},{"line":660,"name":"%aa","containerName":null,"kind":13},{"name":"$cod","containerName":null,"kind":13,"line":660},{"definition":"my","name":"%tot","kind":13,"localvar":"my","containerName":null,"line":665},{"line":666,"kind":13,"containerName":null,"name":"$tot"},{"kind":13,"containerName":null,"name":"%GC","line":666},{"line":667,"containerName":null,"kind":13,"name":"$self"},{"line":667,"name":"set_coding_gc","kind":12,"containerName":"main::"},{"name":"$tot","kind":13,"containerName":null,"line":667},{"line":667,"name":"%total_codons","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$self","line":668},{"name":"set_coding_gc","kind":12,"containerName":"main::","line":668},{"line":668,"name":"%GC","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$total_codons","line":668},{"line":671,"name":"$self","containerName":null,"kind":13},{"line":674,"kind":12,"range":{"start":{"line":674,"character":0},"end":{"line":677,"character":9999}},"definition":"sub","children":[{"kind":13,"localvar":"my","containerName":"_gb_db","name":"$self","line":675,"definition":"my"},{"kind":13,"containerName":"_gb_db","name":"$self","line":676}],"name":"_gb_db","containerName":"main::"}],"version":5}