{"vars":[{"line":85,"name":"base","kind":2,"containerName":""},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"__END__\n# $Id: ContigAnalysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::ContigAnalysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::ContigAnalysis - \n    Perform analysis on sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::ContigAnalysis;\n\n    # Assembly loading methods\n    my $ca = Bio::Assembly::ContigAnalysis->new( -contig=>$contigOBJ );\n\n    my @lcq = $ca->low_consensus_quality;\n    my @hqd = $ca->high_quality_discrepancies;\n    my @ss  = $ca->single_strand_regions;\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, when\nthe sequences in a pair may be aligned. It may also include a\nconsensus sequence. Bio::Assembly::ContigAnalysis is a module\nholding a collection of methods to analyze contig objects. It was\ndeveloped around the Bio::Assembly::Contig implementation of contigs and\ncan not work with another contig interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nEmail: rfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::ContigAnalysis;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::ContigAnalysis->new(-contig=>$contigOBJ);\n Function  : Creates a new contig analysis object\n Returns   : Bio::Assembly::ContigAnalysis\n Args      :\n             -contig : a Bio::Assembly::Contig object","label":"new($class,@args)"},"kind":12,"range":{"end":{"character":9999,"line":111},"start":{"character":0,"line":100}},"line":100,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"new","line":101},{"containerName":"new","kind":13,"name":"@args","line":101},{"definition":"my","line":102,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":102},{"line":102,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","name":"$contigOBJ","kind":13,"localvar":"my","containerName":"new","line":104},{"line":104,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":104},{"line":104,"containerName":"new","kind":13,"name":"@args"},{"kind":13,"containerName":"new","name":"$contigOBJ","line":105},{"containerName":"new","kind":12,"name":"isa","line":105},{"name":"$self","containerName":"new","kind":13,"line":106},{"line":106,"name":"throw","kind":12,"containerName":"new"},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"name":"$contigOBJ","kind":13,"containerName":"new","line":109},{"containerName":"new","kind":13,"name":"$self","line":110}]},{"line":102,"name":"SUPER","containerName":"new","kind":12},{"line":144,"range":{"start":{"character":0,"line":144},"end":{"line":238,"character":9999}},"kind":12,"children":[{"kind":13,"localvar":"my","containerName":"high_quality_discrepancies","name":"$self","line":145,"definition":"my"},{"line":145,"kind":13,"containerName":"high_quality_discrepancies","name":"@args"},{"definition":"my","name":"$threshold","localvar":"my","kind":13,"containerName":"high_quality_discrepancies","line":147},{"name":"$ignore","kind":13,"containerName":"high_quality_discrepancies","line":147},{"line":147,"kind":13,"containerName":"high_quality_discrepancies","name":"$start"},{"containerName":"high_quality_discrepancies","kind":13,"name":"$end","line":147},{"name":"$type","kind":13,"containerName":"high_quality_discrepancies","line":147},{"line":148,"name":"$self","containerName":"high_quality_discrepancies","kind":13},{"line":148,"name":"_rearrange","containerName":"high_quality_discrepancies","kind":12},{"name":"@args","containerName":"high_quality_discrepancies","kind":13,"line":148},{"line":151,"name":"$threshold","kind":13,"containerName":"high_quality_discrepancies"},{"line":151,"kind":13,"containerName":"high_quality_discrepancies","name":"$threshold"},{"name":"$ignore","kind":13,"containerName":"high_quality_discrepancies","line":152},{"name":"$ignore","containerName":"high_quality_discrepancies","kind":13,"line":152},{"line":153,"kind":13,"containerName":"high_quality_discrepancies","name":"$type"},{"name":"$type","containerName":"high_quality_discrepancies","kind":13,"line":153},{"line":156,"name":"$start","containerName":"high_quality_discrepancies","kind":13},{"line":156,"name":"$type","containerName":"high_quality_discrepancies","kind":13},{"line":157,"name":"$start","kind":13,"containerName":"high_quality_discrepancies"},{"line":157,"name":"$self","containerName":"high_quality_discrepancies","kind":13},{"name":"change_coord","kind":12,"containerName":"high_quality_discrepancies","line":157},{"line":157,"kind":13,"containerName":"high_quality_discrepancies","name":"$type"},{"containerName":"high_quality_discrepancies","kind":13,"name":"$start","line":157},{"name":"$start","containerName":"high_quality_discrepancies","kind":13,"line":158},{"line":159,"name":"$start","kind":13,"containerName":"high_quality_discrepancies"},{"line":161,"name":"$end","kind":13,"containerName":"high_quality_discrepancies"},{"line":161,"containerName":"high_quality_discrepancies","kind":13,"name":"$type"},{"kind":13,"containerName":"high_quality_discrepancies","name":"$end","line":162},{"name":"$self","kind":13,"containerName":"high_quality_discrepancies","line":162},{"containerName":"high_quality_discrepancies","kind":12,"name":"change_coord","line":162},{"containerName":"high_quality_discrepancies","kind":13,"name":"$type","line":162},{"line":162,"name":"$end","kind":13,"containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","kind":13,"name":"$end","line":163},{"name":"$end","containerName":"high_quality_discrepancies","kind":13,"line":164},{"containerName":"high_quality_discrepancies","kind":13,"name":"$self","line":164},{"line":164,"name":"get_consensus_length","kind":12,"containerName":"high_quality_discrepancies"},{"definition":"my","line":169,"name":"@seqIDs","kind":13,"localvar":"my","containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","kind":13,"name":"$self","line":169},{"containerName":"high_quality_discrepancies","kind":12,"name":"get_seq_ids","line":169},{"kind":13,"containerName":"high_quality_discrepancies","name":"$start","line":169},{"line":170,"containerName":"high_quality_discrepancies","kind":13,"name":"$end"},{"line":171,"containerName":"high_quality_discrepancies","kind":13,"name":"$type"},{"definition":"my","line":172,"kind":13,"localvar":"my","containerName":"high_quality_discrepancies","name":"$consensus"},{"line":172,"name":"$self","containerName":"high_quality_discrepancies","kind":13},{"line":172,"name":"get_consensus_sequence","containerName":"high_quality_discrepancies","kind":12},{"line":172,"kind":12,"containerName":"high_quality_discrepancies","name":"seq"},{"line":174,"name":"@HQD","kind":13,"localvar":"my","containerName":"high_quality_discrepancies","definition":"my"},{"name":"$seqID","containerName":"high_quality_discrepancies","localvar":"my","kind":13,"line":175,"definition":"my"},{"line":175,"containerName":"high_quality_discrepancies","kind":13,"name":"@seqIDs"},{"definition":"my","name":"$seq","localvar":"my","kind":13,"containerName":"high_quality_discrepancies","line":177},{"name":"$self","containerName":"high_quality_discrepancies","kind":13,"line":177},{"line":177,"name":"get_seq_by_name","kind":12,"containerName":"high_quality_discrepancies"},{"name":"$seqID","kind":13,"containerName":"high_quality_discrepancies","line":177},{"definition":"my","line":178,"name":"$qual","localvar":"my","kind":13,"containerName":"high_quality_discrepancies"},{"name":"$self","kind":13,"containerName":"high_quality_discrepancies","line":178},{"name":"get_qual_by_name","containerName":"high_quality_discrepancies","kind":12,"line":178},{"name":"$seqID","kind":13,"containerName":"high_quality_discrepancies","line":178},{"name":"$qual","kind":13,"containerName":"high_quality_discrepancies","line":179},{"line":180,"name":"$self","kind":13,"containerName":"high_quality_discrepancies"},{"line":180,"kind":12,"containerName":"high_quality_discrepancies","name":"warn"},{"line":183,"name":"$sequence","containerName":"high_quality_discrepancies","localvar":"my","kind":13,"definition":"my"},{"line":183,"name":"$seq","kind":13,"containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","kind":12,"name":"seq","line":183},{"definition":"my","name":"@quality","localvar":"my","kind":13,"containerName":"high_quality_discrepancies","line":184},{"line":184,"containerName":"high_quality_discrepancies","kind":13,"name":"$qual"},{"line":184,"containerName":"high_quality_discrepancies","kind":12,"name":"qual"},{"name":"$seq_ix","kind":13,"localvar":"my","containerName":"high_quality_discrepancies","line":187,"definition":"my"},{"definition":"my","name":"$coord","localvar":"my","kind":13,"containerName":"high_quality_discrepancies","line":188},{"line":188,"name":"$self","kind":13,"containerName":"high_quality_discrepancies"},{"name":"get_seq_feat_by_tag","containerName":"high_quality_discrepancies","kind":12,"line":188},{"name":"$seq","containerName":"high_quality_discrepancies","kind":13,"line":188},{"line":189,"containerName":"high_quality_discrepancies","kind":13,"name":"$coord"},{"line":190,"name":"$self","kind":13,"containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","kind":12,"name":"warn","line":190},{"definition":"my","line":193,"name":"$astart","kind":13,"localvar":"my","containerName":"high_quality_discrepancies"},{"line":193,"containerName":"high_quality_discrepancies","kind":13,"name":"$aend"},{"line":193,"name":"$coord","containerName":"high_quality_discrepancies","kind":13},{"line":193,"kind":12,"containerName":"high_quality_discrepancies","name":"start"},{"line":193,"name":"$coord","kind":13,"containerName":"high_quality_discrepancies"},{"line":193,"name":"end","containerName":"high_quality_discrepancies","kind":12},{"line":194,"name":"$astart","kind":13,"containerName":"high_quality_discrepancies"},{"kind":13,"containerName":"high_quality_discrepancies","name":"$astart","line":194},{"line":194,"containerName":"high_quality_discrepancies","kind":13,"name":"$ignore"},{"line":195,"containerName":"high_quality_discrepancies","kind":13,"name":"$aend"},{"kind":13,"containerName":"high_quality_discrepancies","name":"$aend","line":195},{"containerName":"high_quality_discrepancies","kind":13,"name":"$ignore","line":195},{"line":197,"localvar":"my","containerName":"high_quality_discrepancies","kind":13,"name":"$d_start","definition":"my"},{"line":197,"name":"$d_end","kind":13,"containerName":"high_quality_discrepancies"},{"name":"$i","kind":13,"containerName":"high_quality_discrepancies","line":197},{"name":"$i","kind":13,"containerName":"high_quality_discrepancies","line":198},{"line":198,"containerName":"high_quality_discrepancies","kind":13,"name":"$astart"},{"line":198,"containerName":"high_quality_discrepancies","kind":13,"name":"$i"},{"line":198,"kind":13,"containerName":"high_quality_discrepancies","name":"$aend"},{"line":198,"containerName":"high_quality_discrepancies","kind":13,"name":"$i"},{"line":200,"name":"$seq_ix","containerName":"high_quality_discrepancies","kind":13},{"line":200,"kind":13,"containerName":"high_quality_discrepancies","name":"$self"},{"line":200,"kind":12,"containerName":"high_quality_discrepancies","name":"change_coord"},{"line":200,"containerName":"high_quality_discrepancies","kind":13,"name":"$i"},{"name":"$i","containerName":"high_quality_discrepancies","kind":13,"line":201},{"line":201,"kind":13,"containerName":"high_quality_discrepancies","name":"$start"},{"kind":13,"containerName":"high_quality_discrepancies","name":"$i","line":201},{"kind":13,"containerName":"high_quality_discrepancies","name":"$end","line":201},{"line":203,"name":"$r_base","containerName":"high_quality_discrepancies","localvar":"my","kind":13,"definition":"my"},{"containerName":"high_quality_discrepancies","kind":13,"name":"$sequence","line":203},{"line":203,"kind":13,"containerName":"high_quality_discrepancies","name":"$seq_ix"},{"definition":"my","localvar":"my","containerName":"high_quality_discrepancies","kind":13,"name":"$c_base","line":204},{"name":"$consensus","kind":13,"containerName":"high_quality_discrepancies","line":204},{"line":204,"kind":13,"containerName":"high_quality_discrepancies","name":"$i"},{"name":"$d_start","kind":13,"containerName":"high_quality_discrepancies","line":207},{"line":208,"name":"$r_base","containerName":"high_quality_discrepancies","kind":13},{"kind":13,"containerName":"high_quality_discrepancies","name":"$c_base","line":208},{"line":209,"name":"$quality","containerName":"high_quality_discrepancies","kind":13},{"line":209,"name":"$seq_ix","kind":13,"containerName":"high_quality_discrepancies"},{"kind":13,"containerName":"high_quality_discrepancies","name":"$threshold","line":209},{"line":210,"kind":13,"containerName":"high_quality_discrepancies","name":"$d_start"},{"kind":13,"containerName":"high_quality_discrepancies","name":"$self","line":210},{"line":210,"name":"change_coord","containerName":"high_quality_discrepancies","kind":12},{"kind":13,"containerName":"high_quality_discrepancies","name":"$i","line":210},{"line":216,"kind":13,"containerName":"high_quality_discrepancies","name":"$d_start"},{"line":217,"containerName":"high_quality_discrepancies","kind":13,"name":"$quality"},{"name":"$seq_ix","kind":13,"containerName":"high_quality_discrepancies","line":217},{"line":217,"containerName":"high_quality_discrepancies","kind":13,"name":"$threshold"},{"line":218,"containerName":"high_quality_discrepancies","kind":13,"name":"$r_base"},{"name":"$c_base","containerName":"high_quality_discrepancies","kind":13,"line":218},{"line":219,"name":"$d_end","kind":13,"containerName":"high_quality_discrepancies"},{"line":219,"name":"$self","kind":13,"containerName":"high_quality_discrepancies"},{"kind":12,"containerName":"high_quality_discrepancies","name":"change_coord","line":219},{"line":219,"containerName":"high_quality_discrepancies","kind":13,"name":"$i"},{"kind":13,"containerName":"high_quality_discrepancies","name":"@HQD","line":221},{"line":221,"containerName":"high_quality_discrepancies","kind":12,"name":"new"},{"line":222,"name":"$d_start","containerName":"high_quality_discrepancies","kind":13},{"name":"$d_end","kind":13,"containerName":"high_quality_discrepancies","line":223},{"line":224,"containerName":"high_quality_discrepancies","kind":13,"name":"$seq"},{"kind":12,"containerName":"high_quality_discrepancies","name":"strand","line":224},{"line":225,"kind":13,"containerName":"high_quality_discrepancies","name":"$d_start"},{"line":231,"name":"$d_start","containerName":"high_quality_discrepancies","kind":13},{"name":"$d_end","containerName":"high_quality_discrepancies","kind":13,"line":232},{"name":"$self","kind":13,"containerName":"high_quality_discrepancies","line":232},{"kind":12,"containerName":"high_quality_discrepancies","name":"change_coord","line":232},{"containerName":"high_quality_discrepancies","kind":13,"name":"$i","line":232},{"line":233,"name":"@HQD","kind":13,"containerName":"high_quality_discrepancies"},{"line":233,"name":"new","containerName":"high_quality_discrepancies","kind":12},{"name":"$d_start","containerName":"high_quality_discrepancies","kind":13,"line":234},{"line":235,"name":"$d_end","kind":13,"containerName":"high_quality_discrepancies"},{"containerName":"high_quality_discrepancies","kind":13,"name":"$seq","line":236},{"line":236,"name":"strand","containerName":"high_quality_discrepancies","kind":12}],"containerName":"main::","name":"high_quality_discrepancies","definition":"sub"},{"line":221,"containerName":"SeqFeature::Generic","kind":12,"name":"Bio"},{"line":233,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"name":"@HQD","kind":13,"containerName":null,"line":240},{"name":"low_consensus_quality","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"low_consensus_quality","line":259},{"name":"@args","containerName":"low_consensus_quality","kind":13,"line":259},{"definition":"my","kind":13,"localvar":"my","containerName":"low_consensus_quality","name":"$threshold","line":261},{"name":"$start","containerName":"low_consensus_quality","kind":13,"line":261},{"line":261,"name":"$end","containerName":"low_consensus_quality","kind":13},{"line":261,"name":"$type","kind":13,"containerName":"low_consensus_quality"},{"kind":13,"containerName":"low_consensus_quality","name":"$self","line":262},{"name":"_rearrange","kind":12,"containerName":"low_consensus_quality","line":262},{"name":"@args","containerName":"low_consensus_quality","kind":13,"line":262},{"kind":13,"containerName":"low_consensus_quality","name":"$threshold","line":265},{"name":"$threshold","containerName":"low_consensus_quality","kind":13,"line":265},{"name":"@quality","localvar":"my","kind":13,"containerName":"low_consensus_quality","line":268,"definition":"my"},{"containerName":"low_consensus_quality","kind":13,"name":"$self","line":268},{"kind":12,"containerName":"low_consensus_quality","name":"get_consensus_quality","line":268},{"kind":12,"containerName":"low_consensus_quality","name":"qual","line":268}],"definition":"sub","range":{"end":{"character":9999,"line":268},"start":{"line":258,"character":0}},"kind":12,"line":258},{"line":271,"containerName":null,"kind":13,"name":"$start"},{"name":"$start","kind":13,"containerName":null,"line":271},{"line":272,"name":"$start","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$type","line":272},{"line":272,"name":"%type","kind":13,"containerName":null},{"line":273,"name":"$start","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":273},{"line":273,"containerName":"main::","kind":12,"name":"change_coord"},{"line":273,"name":"$type","kind":13,"containerName":null},{"line":273,"containerName":null,"kind":13,"name":"$start"},{"containerName":null,"kind":13,"name":"$end","line":274},{"line":274,"kind":13,"containerName":null,"name":"%self"},{"containerName":"main::","kind":12,"name":"change_coord","line":274},{"name":"$type","kind":13,"containerName":null,"line":274},{"line":274,"kind":13,"containerName":null,"name":"$end"},{"name":"$end","kind":13,"containerName":null,"line":274},{"containerName":null,"kind":13,"name":"$end","line":276},{"line":276,"name":"%self","kind":13,"containerName":null},{"line":276,"containerName":"main::","kind":12,"name":"get_consensus_length"},{"line":276,"containerName":null,"kind":13,"name":"$end"},{"definition":"my","name":"$lcq_start","localvar":"my","containerName":null,"kind":13,"line":280},{"localvar":"my","containerName":null,"kind":13,"name":"$i","line":281,"definition":"my"},{"containerName":null,"kind":13,"name":"@LCQ","line":281},{"line":282,"name":"$i","kind":13,"containerName":null},{"line":282,"kind":13,"containerName":null,"name":"$start"},{"name":"$i","kind":13,"containerName":null,"line":282},{"name":"$end","containerName":null,"kind":13,"line":282},{"containerName":null,"kind":13,"name":"%i","line":282},{"name":"$lcq_start","containerName":null,"kind":13,"line":284},{"line":284,"name":"@quality","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$i","line":284},{"name":"$threshold","kind":13,"containerName":null,"line":284},{"line":284,"name":"@quality","containerName":null,"kind":13},{"line":284,"name":"%i","kind":13,"containerName":null},{"name":"$lcq_start","containerName":null,"kind":13,"line":285},{"name":"$i","containerName":null,"kind":13,"line":285},{"line":286,"name":"$lcq_start","containerName":null,"kind":13},{"line":286,"name":"@quality","containerName":null,"kind":13},{"line":286,"name":"$i","containerName":null,"kind":13},{"name":"%threshold","containerName":null,"kind":13,"line":286},{"name":"$lcq_start","containerName":null,"kind":13,"line":287},{"line":287,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"containerName":"main::","name":"change_coord","line":287},{"name":"$lcq_start","kind":13,"containerName":null,"line":287},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$lcq_end","line":288},{"containerName":null,"kind":13,"name":"%self","line":288},{"line":288,"kind":12,"containerName":"main::","name":"change_coord"},{"kind":13,"containerName":null,"name":"$i","line":288},{"line":289,"kind":13,"containerName":null,"name":"@LCQ"},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":289},{"kind":12,"containerName":"main::","name":"new","line":289},{"kind":13,"containerName":null,"name":"$lcq_start","line":289},{"line":290,"name":"$lcq_end","kind":13,"containerName":null},{"line":292,"name":"$lcq_start","kind":13,"containerName":null},{"line":296,"name":"%lcq_start","containerName":null,"kind":13},{"name":"$lcq_start","containerName":null,"kind":13,"line":297},{"kind":13,"containerName":null,"name":"%self","line":297},{"kind":12,"containerName":"main::","name":"change_coord","line":297},{"name":"$lcq_start","kind":13,"containerName":null,"line":297},{"line":298,"name":"$lcq_end","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"%self","line":298},{"kind":12,"containerName":"main::","name":"change_coord","line":298},{"line":298,"name":"$i","kind":13,"containerName":null},{"line":299,"name":"@LCQ","kind":13,"containerName":null},{"line":299,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"name":"new","kind":12,"containerName":"main::","line":299},{"containerName":null,"kind":13,"name":"$lcq_start","line":299},{"name":"$lcq_end","containerName":null,"kind":13,"line":300},{"line":304,"kind":13,"containerName":null,"name":"@LCQ"},{"range":{"end":{"line":402,"character":9999},"start":{"character":0,"line":327}},"kind":12,"line":327,"definition":"sub","containerName":"main::","name":"not_confirmed_on_both_strands","children":[{"line":328,"localvar":"my","kind":13,"containerName":"not_confirmed_on_both_strands","name":"$self","definition":"my"},{"line":328,"name":"@args","kind":13,"containerName":"not_confirmed_on_both_strands"},{"name":"$start","kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","line":330,"definition":"my"},{"line":330,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$end"},{"line":330,"name":"$type","kind":13,"containerName":"not_confirmed_on_both_strands"},{"line":331,"name":"$self","containerName":"not_confirmed_on_both_strands","kind":13},{"line":331,"name":"_rearrange","containerName":"not_confirmed_on_both_strands","kind":12},{"line":331,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"@args"},{"line":334,"name":"$start","containerName":"not_confirmed_on_both_strands","kind":13},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$start","line":334},{"line":335,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$type"},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$type","line":335},{"line":336,"name":"$start","kind":13,"containerName":"not_confirmed_on_both_strands"},{"line":336,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$self"},{"line":336,"name":"change_coord","kind":12,"containerName":"not_confirmed_on_both_strands"},{"line":336,"name":"$type","containerName":"not_confirmed_on_both_strands","kind":13},{"line":336,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$start"},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$end","line":337},{"line":337,"name":"$self","containerName":"not_confirmed_on_both_strands","kind":13},{"kind":12,"containerName":"not_confirmed_on_both_strands","name":"change_coord","line":337},{"line":337,"name":"$type","kind":13,"containerName":"not_confirmed_on_both_strands"},{"line":337,"name":"$end","containerName":"not_confirmed_on_both_strands","kind":13},{"line":337,"name":"$end","kind":13,"containerName":"not_confirmed_on_both_strands"},{"line":339,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$end"},{"line":339,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$self"},{"name":"get_consensus_length","containerName":"not_confirmed_on_both_strands","kind":12,"line":339},{"line":339,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$end"},{"definition":"my","line":342,"name":"%confirmed","localvar":"my","containerName":"not_confirmed_on_both_strands","kind":13},{"localvar":"my","containerName":"not_confirmed_on_both_strands","kind":13,"name":"$i","line":343,"definition":"my"},{"line":344,"kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","name":"$consensus","definition":"my"},{"name":"$self","kind":13,"containerName":"not_confirmed_on_both_strands","line":344},{"name":"get_consensus_sequence","containerName":"not_confirmed_on_both_strands","kind":12,"line":344},{"line":344,"containerName":"not_confirmed_on_both_strands","kind":12,"name":"seq"},{"definition":"my","name":"$seqID","kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","line":345},{"name":"$self","kind":13,"containerName":"not_confirmed_on_both_strands","line":345},{"line":345,"containerName":"not_confirmed_on_both_strands","kind":12,"name":"get_seq_ids"},{"definition":"my","line":347,"name":"$seq","kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands"},{"line":347,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$self"},{"name":"get_seq_by_name","kind":12,"containerName":"not_confirmed_on_both_strands","line":347},{"line":347,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$seqID"},{"definition":"my","containerName":"not_confirmed_on_both_strands","localvar":"my","kind":13,"name":"$sequence","line":348},{"line":348,"name":"$seq","kind":13,"containerName":"not_confirmed_on_both_strands"},{"name":"seq","kind":12,"containerName":"not_confirmed_on_both_strands","line":348},{"line":351,"kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","name":"$contig_ix","definition":"my"},{"line":352,"name":"$coord","containerName":"not_confirmed_on_both_strands","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$self","line":352},{"line":352,"name":"get_seq_feat_by_tag","kind":12,"containerName":"not_confirmed_on_both_strands"},{"line":352,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$seq"},{"definition":"my","line":353,"localvar":"my","kind":13,"containerName":"not_confirmed_on_both_strands","name":"$astart"},{"name":"$aend","containerName":"not_confirmed_on_both_strands","kind":13,"line":353},{"name":"$orientation","kind":13,"containerName":"not_confirmed_on_both_strands","line":353},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$coord","line":353},{"name":"start","containerName":"not_confirmed_on_both_strands","kind":12,"line":353},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$coord","line":353},{"name":"end","containerName":"not_confirmed_on_both_strands","kind":12,"line":353},{"line":353,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$coord"},{"kind":12,"containerName":"not_confirmed_on_both_strands","name":"strand","line":353},{"line":354,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$astart"},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$self","line":354},{"line":354,"name":"change_coord","kind":12,"containerName":"not_confirmed_on_both_strands"},{"name":"$astart","containerName":"not_confirmed_on_both_strands","kind":13,"line":354},{"line":355,"name":"$aend","containerName":"not_confirmed_on_both_strands","kind":13},{"line":355,"name":"$self","containerName":"not_confirmed_on_both_strands","kind":13},{"line":355,"containerName":"not_confirmed_on_both_strands","kind":12,"name":"change_coord"},{"line":355,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$aend"},{"line":356,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$i"},{"name":"$astart","containerName":"not_confirmed_on_both_strands","kind":13,"line":356},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$i","line":356},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$aend","line":356},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$i","line":356},{"line":358,"name":"$contig_ix","containerName":"not_confirmed_on_both_strands","kind":13},{"line":358,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$self"},{"line":358,"name":"change_coord","containerName":"not_confirmed_on_both_strands","kind":12},{"line":358,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$i"},{"line":359,"name":"$contig_ix","kind":13,"containerName":"not_confirmed_on_both_strands"},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$start","line":359},{"line":359,"name":"$contig_ix","containerName":"not_confirmed_on_both_strands","kind":13},{"name":"$end","kind":13,"containerName":"not_confirmed_on_both_strands","line":359},{"line":360,"name":"$r_base","localvar":"my","containerName":"not_confirmed_on_both_strands","kind":13,"definition":"my"},{"line":360,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$sequence"},{"line":360,"name":"$i","containerName":"not_confirmed_on_both_strands","kind":13},{"definition":"my","line":361,"localvar":"my","containerName":"not_confirmed_on_both_strands","kind":13,"name":"$c_base"},{"line":361,"name":"$consensus","containerName":"not_confirmed_on_both_strands","kind":13},{"line":361,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$contig_ix"},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$c_base","line":362},{"name":"$confirmed","kind":13,"containerName":"not_confirmed_on_both_strands","line":363},{"line":363,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$orientation"},{"line":363,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$contig_ix"},{"name":"$r_base","containerName":"not_confirmed_on_both_strands","kind":13,"line":364},{"line":364,"name":"$c_base","kind":13,"containerName":"not_confirmed_on_both_strands"},{"line":365,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$confirmed"},{"name":"$orientation","kind":13,"containerName":"not_confirmed_on_both_strands","line":365},{"line":365,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$contig_ix"},{"definition":"my","line":371,"name":"$orientation","kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands"},{"definition":"my","name":"@NCBS","kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","line":372},{"line":373,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$orientation"},{"name":"%confirmed","containerName":"not_confirmed_on_both_strands","kind":13,"line":373},{"name":"$ncbs_start","kind":13,"localvar":"my","containerName":"not_confirmed_on_both_strands","line":374,"definition":"my"},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$ncbs_end","line":374},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$i","line":376},{"line":376,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$start"},{"line":376,"name":"$i","containerName":"not_confirmed_on_both_strands","kind":13},{"line":376,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$end"},{"line":376,"name":"$i","kind":13,"containerName":"not_confirmed_on_both_strands"},{"line":377,"name":"$ncbs_start","kind":13,"containerName":"not_confirmed_on_both_strands"},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$confirmed","line":378},{"line":378,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$orientation"},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$i","line":378},{"name":"$confirmed","containerName":"not_confirmed_on_both_strands","kind":13,"line":378},{"name":"$orientation","kind":13,"containerName":"not_confirmed_on_both_strands","line":378},{"line":378,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$i"},{"line":379,"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands","kind":13},{"name":"$self","kind":13,"containerName":"not_confirmed_on_both_strands","line":379},{"line":379,"name":"change_coord","containerName":"not_confirmed_on_both_strands","kind":12},{"line":379,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$i"},{"line":380,"name":"$ncbs_start","kind":13,"containerName":"not_confirmed_on_both_strands"},{"name":"$confirmed","kind":13,"containerName":"not_confirmed_on_both_strands","line":381},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$orientation","line":381},{"line":381,"name":"$i","kind":13,"containerName":"not_confirmed_on_both_strands"},{"line":382,"name":"$confirmed","containerName":"not_confirmed_on_both_strands","kind":13},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$orientation","line":382},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$i","line":382},{"line":383,"name":"$ncbs_end","containerName":"not_confirmed_on_both_strands","kind":13},{"name":"$self","containerName":"not_confirmed_on_both_strands","kind":13,"line":383},{"name":"change_coord","containerName":"not_confirmed_on_both_strands","kind":12,"line":383},{"line":383,"name":"$i","containerName":"not_confirmed_on_both_strands","kind":13},{"kind":13,"containerName":"not_confirmed_on_both_strands","name":"@NCBS","line":384},{"line":384,"name":"new","kind":12,"containerName":"not_confirmed_on_both_strands"},{"line":384,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$ncbs_start"},{"line":385,"name":"$ncbs_end","containerName":"not_confirmed_on_both_strands","kind":13},{"line":386,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$orientation"},{"name":"$ncbs_start","containerName":"not_confirmed_on_both_strands","kind":13,"line":388},{"name":"$ncbs_start","kind":13,"containerName":"not_confirmed_on_both_strands","line":392},{"line":393,"kind":13,"containerName":"not_confirmed_on_both_strands","name":"$ncbs_end"},{"name":"$self","containerName":"not_confirmed_on_both_strands","kind":13,"line":393},{"name":"change_coord","kind":12,"containerName":"not_confirmed_on_both_strands","line":393},{"line":393,"name":"$end","containerName":"not_confirmed_on_both_strands","kind":13},{"line":394,"containerName":"not_confirmed_on_both_strands","kind":13,"name":"@NCBS"},{"name":"new","containerName":"not_confirmed_on_both_strands","kind":12,"line":394},{"containerName":"not_confirmed_on_both_strands","kind":13,"name":"$ncbs_start","line":394},{"line":395,"name":"$ncbs_end","containerName":"not_confirmed_on_both_strands","kind":13},{"name":"$orientation","containerName":"not_confirmed_on_both_strands","kind":13,"line":396},{"name":"@NCBS","containerName":"not_confirmed_on_both_strands","kind":13,"line":401}]},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":384},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":394},{"name":"single_strand","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"single_strand","line":425,"definition":"my"},{"name":"@args","kind":13,"containerName":"single_strand","line":425},{"line":427,"name":"$start","containerName":"single_strand","localvar":"my","kind":13,"definition":"my"},{"line":427,"kind":13,"containerName":"single_strand","name":"$end"},{"line":427,"kind":13,"containerName":"single_strand","name":"$type"},{"line":428,"name":"$self","kind":13,"containerName":"single_strand"},{"line":428,"name":"_rearrange","containerName":"single_strand","kind":12},{"containerName":"single_strand","kind":13,"name":"@args","line":428},{"line":431,"name":"$type","kind":13,"containerName":"single_strand"},{"line":431,"name":"$type","kind":13,"containerName":"single_strand"},{"line":432,"name":"$start","kind":13,"containerName":"single_strand"},{"name":"$start","kind":13,"containerName":"single_strand","line":432},{"kind":13,"containerName":"single_strand","name":"$type","line":433},{"containerName":"single_strand","kind":13,"name":"$type","line":433},{"name":"$start","kind":13,"containerName":"single_strand","line":434},{"kind":13,"containerName":"single_strand","name":"$self","line":434},{"line":434,"name":"change_coord","kind":12,"containerName":"single_strand"},{"line":434,"kind":13,"containerName":"single_strand","name":"$type"},{"line":434,"kind":13,"containerName":"single_strand","name":"$start"},{"line":435,"name":"$end","containerName":"single_strand","kind":13},{"line":435,"containerName":"single_strand","kind":13,"name":"$self"},{"line":435,"kind":12,"containerName":"single_strand","name":"change_coord"},{"line":435,"containerName":"single_strand","kind":13,"name":"$type"},{"line":435,"containerName":"single_strand","kind":13,"name":"$end"},{"name":"$end","kind":13,"containerName":"single_strand","line":435},{"line":437,"kind":13,"containerName":"single_strand","name":"$end"},{"kind":13,"containerName":"single_strand","name":"$self","line":437},{"line":437,"name":"get_consensus_length","kind":12,"containerName":"single_strand"},{"kind":13,"containerName":"single_strand","name":"$end","line":437},{"definition":"my","line":440,"kind":13,"localvar":"my","containerName":"single_strand","name":"$sfc"},{"line":440,"name":"$self","containerName":"single_strand","kind":13},{"line":440,"name":"get_features_collection","containerName":"single_strand","kind":12},{"definition":"my","line":441,"name":"@forward","kind":13,"localvar":"my","containerName":"single_strand"},{"line":441,"name":"primary_tag","containerName":"single_strand","kind":12},{"kind":13,"containerName":"single_strand","name":"$sfc","line":442},{"line":442,"name":"features_in_range","containerName":"single_strand","kind":12},{"kind":13,"containerName":"single_strand","name":"$start","line":442},{"line":443,"containerName":"single_strand","kind":13,"name":"$end"},{"localvar":"my","kind":13,"containerName":"single_strand","name":"@reverse","line":447,"definition":"my"},{"name":"primary_tag","containerName":"single_strand","kind":12,"line":447},{"line":448,"name":"$sfc","containerName":"single_strand","kind":13},{"line":448,"containerName":"single_strand","kind":12,"name":"features_in_range"},{"name":"$start","kind":13,"containerName":"single_strand","line":448},{"line":449,"name":"$end","kind":13,"containerName":"single_strand"},{"line":454,"name":"@forward","containerName":"single_strand","kind":13},{"line":454,"containerName":"single_strand","kind":13,"name":"$self"},{"line":454,"kind":12,"containerName":"single_strand","name":"_merge_overlapping_features"},{"line":454,"kind":13,"containerName":"single_strand","name":"@forward"},{"kind":13,"containerName":"single_strand","name":"@reverse","line":455},{"kind":13,"containerName":"single_strand","name":"$self","line":455},{"line":455,"name":"_merge_overlapping_features","containerName":"single_strand","kind":12},{"line":455,"name":"@reverse","kind":13,"containerName":"single_strand"},{"localvar":"my","containerName":"single_strand","kind":13,"name":"$length","line":458,"definition":"my"},{"line":458,"kind":13,"containerName":"single_strand","name":"$self"},{"line":458,"containerName":"single_strand","kind":12,"name":"get_consensus_length"},{"kind":13,"containerName":"single_strand","name":"$length","line":459},{"line":459,"containerName":"single_strand","kind":13,"name":"$self"},{"line":459,"containerName":"single_strand","kind":12,"name":"change_coord"},{"line":459,"name":"$length","kind":13,"containerName":"single_strand"},{"kind":13,"containerName":"single_strand","name":"@forward","line":460},{"kind":13,"containerName":"single_strand","name":"$self","line":460},{"line":460,"name":"_complementary_features_list","containerName":"single_strand","kind":12},{"name":"$length","kind":13,"containerName":"single_strand","line":460},{"line":460,"name":"@forward","kind":13,"containerName":"single_strand"},{"line":461,"kind":13,"containerName":"single_strand","name":"@reverse"},{"line":461,"kind":13,"containerName":"single_strand","name":"$self"},{"line":461,"name":"_complementary_features_list","containerName":"single_strand","kind":12},{"containerName":"single_strand","kind":13,"name":"$length","line":461},{"line":461,"kind":13,"containerName":"single_strand","name":"@reverse"},{"definition":"my","line":463,"kind":13,"localvar":"my","containerName":"single_strand","name":"@SS"},{"definition":"my","line":464,"kind":13,"localvar":"my","containerName":"single_strand","name":"$feat"},{"containerName":"single_strand","kind":13,"name":"@forward","line":464},{"name":"@reverse","kind":13,"containerName":"single_strand","line":464},{"line":465,"name":"$feat","kind":13,"containerName":"single_strand"},{"line":465,"name":"primary_tag","kind":12,"containerName":"single_strand"},{"line":466,"name":"@SS","kind":13,"containerName":"single_strand"},{"kind":13,"containerName":"single_strand","name":"$feat","line":466},{"containerName":"single_strand","kind":13,"name":"@SS","line":469}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":424},"end":{"character":9999,"line":470}},"line":424},{"children":[{"line":486,"name":"$self","kind":13,"localvar":"my","containerName":"_merge_overlapping_features","definition":"my"},{"line":486,"kind":13,"containerName":"_merge_overlapping_features","name":"@feat"},{"line":488,"name":"$self","containerName":"_merge_overlapping_features","kind":13},{"line":488,"name":"throw_not_implemented","kind":12,"containerName":"_merge_overlapping_features"}],"containerName":"main::","name":"_merge_overlapping_features","definition":"sub","detail":"($self,@feat)","line":485,"range":{"end":{"line":489,"character":9999},"start":{"line":485,"character":0}},"kind":12,"signature":{"label":"_merge_overlapping_features($self,@feat)","parameters":[{"label":"$self"},{"label":"@feat"}],"documentation":"__END__\n# $Id: ContigAnalysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::ContigAnalysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::ContigAnalysis - \n    Perform analysis on sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::ContigAnalysis;\n\n    # Assembly loading methods\n    my $ca = Bio::Assembly::ContigAnalysis->new( -contig=>$contigOBJ );\n\n    my @lcq = $ca->low_consensus_quality;\n    my @hqd = $ca->high_quality_discrepancies;\n    my @ss  = $ca->single_strand_regions;\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, when\nthe sequences in a pair may be aligned. It may also include a\nconsensus sequence. Bio::Assembly::ContigAnalysis is a module\nholding a collection of methods to analyze contig objects. It was\ndeveloped around the Bio::Assembly::Contig implementation of contigs and\ncan not work with another contig interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nEmail: rfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::ContigAnalysis;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::ContigAnalysis->new(-contig=>$contigOBJ);\n Function  : Creates a new contig analysis object\n Returns   : Bio::Assembly::ContigAnalysis\n Args      :\n             -contig : a Bio::Assembly::Contig object\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($contigOBJ) = $self->_rearrange([qw(CONTIG)],@args);\n    unless ($contigOBJ->isa(\"Bio::Assembly::Contig\")) {\n\t$self->throw(\"ContigAnal works only on Bio::Assembly::Contig objects\\n\");\n    }\n\n    $self->{'_objref'} = $contigOBJ;\n    return $self;\n}\n\n=head1 Analysis methods\n\n=head2 high_quality_discrepancies\n\n Title     : high_quality_discrepancies\n Usage     : my $sfc = $ContigAnal->high_quality_discrepancies();\n Function  : \n\n             Locates all high quality discrepancies among aligned\n             sequences and the consensus sequence.\n\n             Note: see Bio::Assembly::Contig POD documentation,\n             section \"Coordinate System\", for a definition of\n             available types. Default coordinate system type is\n             \"gapped consensus\", i.e. consensus sequence (with gaps)\n             coordinates. If limits are not specified, the entire\n             alignment is analyzed.\n\n Returns   : Bio::SeqFeature::Collection\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 40\n             -ignore    : number of bases that will not be analysed at\n                          both ends of contig aligned elements\n                          Default: 5\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub high_quality_discrepancies {\n    my ($self,@args) = shift; # Package reference\n\n    my ($threshold,$ignore,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD IGNORE START END TYPE)],@args);\n\n    # Defining default threhold and HQD_ignore\n    $threshold  = 40 unless (defined($threshold));\n    $ignore = 5  unless (defined($ignore));\n    $type = 'gapped consensus' unless (defined($type));\n\n    # Changing input coordinates system (if needed)\n    if (defined $start && $type ne 'gapped consensus') {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n    } elsif (!defined $start) {\n\t$start = 1;\n    }\n    if (defined $end && $type ne 'gapped consensus') {\n\t$end = $self->{'_objref'}->change_coord($type,'gapped consensus',$end);\n    } elsif (!defined $end) {\n\t$end = $self->{'_objref'}->get_consensus_length();\n    }\n\n    # Scanning each read sequence and the contig sequence and\n    # adding discrepancies to Bio::SeqFeature::Collection\n    my @seqIDs = $self->{'_objref'}->get_seq_ids(-start=>$start,\n\t\t\t\t\t\t -end=>$end,\n\t\t\t\t\t\t -type=>$type);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n\n    my @HQD = ();\n    foreach my $seqID (@seqIDs) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq  = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $qual = $self->{'_objref'}->get_qual_by_name($seqID);\n\tunless (defined $qual) {\n\t    $self->warn(\"Can't correctly evaluate HQD without aligned sequence qualities for $seqID\");\n\t    next;\n\t}\n\tmy $sequence = $seq->seq;\n\tmy @quality  = @{ $qual->qual };\n\n\t# Scanning the aligned region of each read\n\tmy $seq_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n    if (!$coord) {\n        $self->warn(\"Read $seqID has no alignment coordinates; considered low quality.\\nSkipping...\");\n        next;\n    }\n\tmy ($astart,$aend) = ($coord->start,$coord->end);\n\t$astart = $astart + $ignore; # Redefining limits to evaluate HQDs (jump $ignore at start)\n\t$aend   = $aend   - $ignore; # Redefining limits to evaluate HQDs (stop $ignore before end)\n\n\tmy ($d_start,$d_end,$i);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # Changing coordinate $i+1 from 'gapped consensus' mode to \"aligned $seqID\" (coordinate $seq_ix)\n\t    $seq_ix = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$i+1);\n\t    next unless (($i >= $start) && ($i <= $end));\n\n\t    my $r_base = uc(substr($sequence,$seq_ix-1,1));\n\t    my $c_base = uc(substr($consensus,$i,1));\n\n\t    # Discrepant region start: store $d_start and $type\n\t    (!defined($d_start) &&\n\t     ($r_base ne $c_base) &&\n\t     ($quality[$seq_ix-1] >= $threshold)) && do {\n\t\t $d_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i+1);\n\t\t #print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\t next;\n\t     };\n\n\t    # Quality change or end of discrepant region: store limits and undef $d_start\n\t    if (defined($d_start) &&\n\t\t(($quality[$seq_ix-1] < $threshold) ||\n\t\t (uc($r_base) eq uc($c_base)))) {\n\t\t$d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t\t#print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\tpush(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t\t -start=>$d_start,\n\t\t\t\t\t\t\t -end=>$d_end,\n\t\t\t\t\t\t\t -strand=>$seq->strand()) );\n\t\t$d_start = undef;\n\t\tnext;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n\n\t# Loading discrepancies located at sub-sequence end, if any.\n\tif (defined($d_start)) {\n\t    $d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t     -start=>$d_start,\n\t\t\t\t\t\t     -end=>$d_end,\n\t\t\t\t\t\t     -strand=>$seq->strand()) );\n\t}\n    } # foreach my $seqID (@seqIDs)\n\n    return @HQD;\n}\n\n=head2 low_consensus_quality\n\n Title     : low_consensus_quality\n Usage     : my $sfc = $ContigAnal->low_consensus_quality();\n Function  : Locates all low quality regions in the consensus\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 25\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub low_consensus_quality {\n    my ($self,@args) = shift; # Packege reference\n\n    my ($threshold,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD START END TYPE)],@args);\n\n    # Setting default value for threshold\n    $threshold = 25 unless (defined($threshold));\n\n    # Loading qualities\n    my @quality = @{ $self->{'_objref'}->get_consensus_quality()->qual };\n\n    # Changing coordinates to gap mode noaln (consed: consensus without alignments)\n    $start = 1 unless (defined($start));\n    if (defined $start && defined $type && ($type ne 'gapped consensus')) {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined $end);\n\n    # Scanning @quality vector and storing intervals limits with base qualities less then\n    # the threshold value\n    my ($lcq_start);\n    my ($i,@LCQ);\n    for ($i=$start-1; $i<=$end-1; $i++) {\n#\tprint $quality[$i],\"\\t\",$i,\"\\n\";\n\tif (!defined($lcq_start) && (($quality[$i] <= $threshold) || ($quality[$i] == 98))) {\n\t    $lcq_start = $i+1;\n\t} elsif (defined($lcq_start) && ($quality[$i] > $threshold)) {\n\t    $lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\t    my $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t     -end=>$lcq_end,\n\t\t\t\t\t\t     -primary=>'low_consensus_quality') );\n\t    $lcq_start = undef;\n\t}\n    }\n\n    if (defined $lcq_start) {\n\t$lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\tmy $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\tpush(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t -end=>$lcq_end,\n\t\t\t\t\t\t -primary=>'low_consensus_quality') );\n    }\n\n    return @LCQ;\n}\n\n=head2 not_confirmed_on_both_strands\n\n Title     : low_quality_consensus\n Usage     : my $sfc = $ContigAnal->low_quality_consensus();\n Function  : \n\n             Locates all regions whose consensus bases were not\n             confirmed by bases from sequences aligned in both\n             orientations, i.e., in such regions, no bases in aligned\n             sequences of either +1 or -1 strand agree with the\n             consensus bases.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\nsub not_confirmed_on_both_strands {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to default system 'align' (contig sequence with alignments)\n    $start = 1 unless (defined($start));\n    if (defined($type) && ($type ne 'gapped consensus')) {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'_objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Scanning alignment\n    my %confirmed = (); # If ($confirmed{$orientation}[$i] > 0) then $i is confirmed in $orientation strand\n    my ($i);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n    foreach my $seqID ($self->{'_objref'}->get_seq_ids) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $sequence = $seq->seq;\n\n\t# Scanning the aligned regions of each read and registering confirmed sites\n\tmy $contig_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n\tmy ($astart,$aend,$orientation) = ($coord->start,$coord->end,$coord->strand);\n\t$astart = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$astart);\n\t$aend   = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$aend);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # $i+1 in 'align' mode is $contig_ix\n\t    $contig_ix = $self->{'_objref'}->change_coord(\"aligned $seqID\",'gapped consensus',$i+1);\n\t    next unless (($contig_ix >= $start) && ($contig_ix <= $end));\n\t    my $r_base = uc(substr($sequence,$i,1));\n\t    my $c_base = uc(substr($consensus,$contig_ix-1,1));\n\t    if ($c_base eq '-') {\n\t\t$confirmed{$orientation}[$contig_ix] = -1;\n\t    } elsif (uc($r_base) eq uc($c_base)) { # Non discrepant region found\n\t\t$confirmed{$orientation}[$contig_ix]++;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n    } # foreach $seqID (@reads)\n\n    # Locating non-confirmed aligned regions for each orientation in $confirmed registry\n    my ($orientation);\n    my @NCBS = ();\n    foreach $orientation (keys %confirmed) {\n\tmy ($ncbs_start,$ncbs_end);\n\n\tfor ($i=$start; $i<=$end; $i++) {\n\t    if (!defined($ncbs_start) &&\n\t\t(!defined($confirmed{$orientation}[$i]) || ($confirmed{$orientation}[$i] == 0))) {\n\t\t$ncbs_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    } elsif (defined($ncbs_start) &&\n\t\t     defined($confirmed{$orientation}[$i]) &&\n\t\t     ($confirmed{$orientation}[$i] > 0)) {\n\t\t$ncbs_end   = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i-1);\n\t\tpush(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t\t  -end=>$ncbs_end,\n\t\t\t\t\t\t\t  -strand=>$orientation,\n\t\t\t\t\t\t\t  -primary=>\"not_confirmed_on_both_strands\") );\n\t\t$ncbs_start = undef;\n\t    }\n\t}\n\n\tif (defined($ncbs_start)) { # NCBS at the end of contig\n\t    $ncbs_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$end);\n\t    push(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t      -end=>$ncbs_end,\n\t\t\t\t\t\t      -strand=>$orientation,\n\t\t\t\t\t\t      -primary=>'not_confirmed_on_both_strands') );\n\t}\n    }\n\n    return @NCBS;\n}\n\n=head2 single_strand\n\n Title     : single_strand\n Usage     : my $sfc = $ContigAnal->single_strand();\n Function  : \n\n             Locates all regions covered by aligned sequences only in\n             one of the two strands, i.e., regions for which aligned\n             sequence's strand() method returns +1 or -1 for all\n             sequences.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\n#'\nsub single_strand {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to gap mode align (consed: consensus sequence with alignments)\n    $type  = 'gapped consensus' unless(defined($type));\n    $start = 1 unless (defined($start));\n    if (defined($type) && $type ne 'gapped consensus') {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    ($end) = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Loading complete list of coordinates for aligned sequences\n    my $sfc = $self->{'_objref'}->get_features_collection();\n    my @forward = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>1,\n\t\t\t    -strandmatch=>'strong');\n    my @reverse = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>-1,\n\t\t\t    -strandmatch=>'strong');\n    # Merging overlapping features\n    @forward = $self->_merge_overlapping_features(@forward);\n    @reverse = $self->_merge_overlapping_features(@reverse);\n\n    # Finding single stranded regions\n    my ($length) = $self->{'_objref'}->get_consensus_length;\n    $length  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$length);\n    @forward = $self->_complementary_features_list(1,$length,@forward);\n    @reverse = $self->_complementary_features_list(1,$length,@reverse);\n\n    my @SS = ();\n    foreach my $feat (@forward, @reverse) {\n\t$feat->primary_tag('single_strand_region');\n\tpush(@SS,$feat);\n    }\n\n    return @SS;\n}\n\n=head1 Internal Methods\n\n=head2 _merge_overlapping_features\n\n Title     : _merge_overlapping_features\n Usage     : my @feat = $ContigAnal->_merge_overlapping_features(@features);\n Function  : Merge all overlapping features into features\n             that hold original features as sub-features\n Returns   : array of Bio::SeqFeature::Generic objects\n Args      : array of Bio::SeqFeature::Generic objects"}},{"containerName":"main::","name":"_complementary_features_list","children":[{"localvar":"my","kind":13,"containerName":"_complementary_features_list","name":"$self","line":506,"definition":"my"},{"name":"$start","kind":13,"containerName":"_complementary_features_list","line":506},{"line":506,"name":"$end","containerName":"_complementary_features_list","kind":13},{"kind":13,"containerName":"_complementary_features_list","name":"@feat","line":506},{"line":508,"kind":13,"containerName":"_complementary_features_list","name":"$self"},{"kind":12,"containerName":"_complementary_features_list","name":"throw_not_implemented","line":508}],"detail":"($self,$start,$end,@feat)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":505},"end":{"character":9999,"line":509}},"line":505,"signature":{"label":"_complementary_features_list($self,$start,$end,@feat)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"},{"label":"@feat"}],"documentation":"__END__\n# $Id: ContigAnalysis.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::ContigAnalysis\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::ContigAnalysis - \n    Perform analysis on sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::ContigAnalysis;\n\n    # Assembly loading methods\n    my $ca = Bio::Assembly::ContigAnalysis->new( -contig=>$contigOBJ );\n\n    my @lcq = $ca->low_consensus_quality;\n    my @hqd = $ca->high_quality_discrepancies;\n    my @ss  = $ca->single_strand_regions;\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, when\nthe sequences in a pair may be aligned. It may also include a\nconsensus sequence. Bio::Assembly::ContigAnalysis is a module\nholding a collection of methods to analyze contig objects. It was\ndeveloped around the Bio::Assembly::Contig implementation of contigs and\ncan not work with another contig interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nEmail: rfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::ContigAnalysis;\n\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::ContigAnalysis->new(-contig=>$contigOBJ);\n Function  : Creates a new contig analysis object\n Returns   : Bio::Assembly::ContigAnalysis\n Args      :\n             -contig : a Bio::Assembly::Contig object\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($contigOBJ) = $self->_rearrange([qw(CONTIG)],@args);\n    unless ($contigOBJ->isa(\"Bio::Assembly::Contig\")) {\n\t$self->throw(\"ContigAnal works only on Bio::Assembly::Contig objects\\n\");\n    }\n\n    $self->{'_objref'} = $contigOBJ;\n    return $self;\n}\n\n=head1 Analysis methods\n\n=head2 high_quality_discrepancies\n\n Title     : high_quality_discrepancies\n Usage     : my $sfc = $ContigAnal->high_quality_discrepancies();\n Function  : \n\n             Locates all high quality discrepancies among aligned\n             sequences and the consensus sequence.\n\n             Note: see Bio::Assembly::Contig POD documentation,\n             section \"Coordinate System\", for a definition of\n             available types. Default coordinate system type is\n             \"gapped consensus\", i.e. consensus sequence (with gaps)\n             coordinates. If limits are not specified, the entire\n             alignment is analyzed.\n\n Returns   : Bio::SeqFeature::Collection\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 40\n             -ignore    : number of bases that will not be analysed at\n                          both ends of contig aligned elements\n                          Default: 5\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub high_quality_discrepancies {\n    my ($self,@args) = shift; # Package reference\n\n    my ($threshold,$ignore,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD IGNORE START END TYPE)],@args);\n\n    # Defining default threhold and HQD_ignore\n    $threshold  = 40 unless (defined($threshold));\n    $ignore = 5  unless (defined($ignore));\n    $type = 'gapped consensus' unless (defined($type));\n\n    # Changing input coordinates system (if needed)\n    if (defined $start && $type ne 'gapped consensus') {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n    } elsif (!defined $start) {\n\t$start = 1;\n    }\n    if (defined $end && $type ne 'gapped consensus') {\n\t$end = $self->{'_objref'}->change_coord($type,'gapped consensus',$end);\n    } elsif (!defined $end) {\n\t$end = $self->{'_objref'}->get_consensus_length();\n    }\n\n    # Scanning each read sequence and the contig sequence and\n    # adding discrepancies to Bio::SeqFeature::Collection\n    my @seqIDs = $self->{'_objref'}->get_seq_ids(-start=>$start,\n\t\t\t\t\t\t -end=>$end,\n\t\t\t\t\t\t -type=>$type);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n\n    my @HQD = ();\n    foreach my $seqID (@seqIDs) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq  = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $qual = $self->{'_objref'}->get_qual_by_name($seqID);\n\tunless (defined $qual) {\n\t    $self->warn(\"Can't correctly evaluate HQD without aligned sequence qualities for $seqID\");\n\t    next;\n\t}\n\tmy $sequence = $seq->seq;\n\tmy @quality  = @{ $qual->qual };\n\n\t# Scanning the aligned region of each read\n\tmy $seq_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n    if (!$coord) {\n        $self->warn(\"Read $seqID has no alignment coordinates; considered low quality.\\nSkipping...\");\n        next;\n    }\n\tmy ($astart,$aend) = ($coord->start,$coord->end);\n\t$astart = $astart + $ignore; # Redefining limits to evaluate HQDs (jump $ignore at start)\n\t$aend   = $aend   - $ignore; # Redefining limits to evaluate HQDs (stop $ignore before end)\n\n\tmy ($d_start,$d_end,$i);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # Changing coordinate $i+1 from 'gapped consensus' mode to \"aligned $seqID\" (coordinate $seq_ix)\n\t    $seq_ix = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$i+1);\n\t    next unless (($i >= $start) && ($i <= $end));\n\n\t    my $r_base = uc(substr($sequence,$seq_ix-1,1));\n\t    my $c_base = uc(substr($consensus,$i,1));\n\n\t    # Discrepant region start: store $d_start and $type\n\t    (!defined($d_start) &&\n\t     ($r_base ne $c_base) &&\n\t     ($quality[$seq_ix-1] >= $threshold)) && do {\n\t\t $d_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i+1);\n\t\t #print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\t next;\n\t     };\n\n\t    # Quality change or end of discrepant region: store limits and undef $d_start\n\t    if (defined($d_start) &&\n\t\t(($quality[$seq_ix-1] < $threshold) ||\n\t\t (uc($r_base) eq uc($c_base)))) {\n\t\t$d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t\t#print $seqID,\" \",$r_base,\" \",$i+1,\" \",$c_base,\" \",$contig_ix-1,\" \",$quality[$i],\" $type\\n\";\n\t\tpush(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t\t -start=>$d_start,\n\t\t\t\t\t\t\t -end=>$d_end,\n\t\t\t\t\t\t\t -strand=>$seq->strand()) );\n\t\t$d_start = undef;\n\t\tnext;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n\n\t# Loading discrepancies located at sub-sequence end, if any.\n\tif (defined($d_start)) {\n\t    $d_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@HQD, Bio::SeqFeature::Generic->new(-primary=>\"high_quality_discrepancy:$seqID\",\n\t\t\t\t\t\t     -start=>$d_start,\n\t\t\t\t\t\t     -end=>$d_end,\n\t\t\t\t\t\t     -strand=>$seq->strand()) );\n\t}\n    } # foreach my $seqID (@seqIDs)\n\n    return @HQD;\n}\n\n=head2 low_consensus_quality\n\n Title     : low_consensus_quality\n Usage     : my $sfc = $ContigAnal->low_consensus_quality();\n Function  : Locates all low quality regions in the consensus\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -threshold : cutoff value for low quality (minimum high quality)\n                          Default: 25\n             -start     : start of interval that will be analyzed\n             -end       : start of interval that will be analyzed\n             -type      : coordinate system type for interval\n\n\nsub low_consensus_quality {\n    my ($self,@args) = shift; # Packege reference\n\n    my ($threshold,$start,$end,$type) = \n\t$self->_rearrange([qw(THRESHOLD START END TYPE)],@args);\n\n    # Setting default value for threshold\n    $threshold = 25 unless (defined($threshold));\n\n    # Loading qualities\n    my @quality = @{ $self->{'_objref'}->get_consensus_quality()->qual };\n\n    # Changing coordinates to gap mode noaln (consed: consensus without alignments)\n    $start = 1 unless (defined($start));\n    if (defined $start && defined $type && ($type ne 'gapped consensus')) {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined $end);\n\n    # Scanning @quality vector and storing intervals limits with base qualities less then\n    # the threshold value\n    my ($lcq_start);\n    my ($i,@LCQ);\n    for ($i=$start-1; $i<=$end-1; $i++) {\n#\tprint $quality[$i],\"\\t\",$i,\"\\n\";\n\tif (!defined($lcq_start) && (($quality[$i] <= $threshold) || ($quality[$i] == 98))) {\n\t    $lcq_start = $i+1;\n\t} elsif (defined($lcq_start) && ($quality[$i] > $threshold)) {\n\t    $lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\t    my $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    push(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t     -end=>$lcq_end,\n\t\t\t\t\t\t     -primary=>'low_consensus_quality') );\n\t    $lcq_start = undef;\n\t}\n    }\n\n    if (defined $lcq_start) {\n\t$lcq_start  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$lcq_start);\n\tmy $lcq_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\tpush(@LCQ, Bio::SeqFeature::Generic->new(-start=>$lcq_start,\n\t\t\t\t\t\t -end=>$lcq_end,\n\t\t\t\t\t\t -primary=>'low_consensus_quality') );\n    }\n\n    return @LCQ;\n}\n\n=head2 not_confirmed_on_both_strands\n\n Title     : low_quality_consensus\n Usage     : my $sfc = $ContigAnal->low_quality_consensus();\n Function  : \n\n             Locates all regions whose consensus bases were not\n             confirmed by bases from sequences aligned in both\n             orientations, i.e., in such regions, no bases in aligned\n             sequences of either +1 or -1 strand agree with the\n             consensus bases.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\nsub not_confirmed_on_both_strands {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to default system 'align' (contig sequence with alignments)\n    $start = 1 unless (defined($start));\n    if (defined($type) && ($type ne 'gapped consensus')) {\n\t$start = $self->{'_objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'_objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    $end = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Scanning alignment\n    my %confirmed = (); # If ($confirmed{$orientation}[$i] > 0) then $i is confirmed in $orientation strand\n    my ($i);\n    my $consensus = $self->{'_objref'}->get_consensus_sequence()->seq;\n    foreach my $seqID ($self->{'_objref'}->get_seq_ids) {\n\t# Setting aligned read sub-sequence limits and loading data\n\tmy $seq = $self->{'_objref'}->get_seq_by_name($seqID);\n\tmy $sequence = $seq->seq;\n\n\t# Scanning the aligned regions of each read and registering confirmed sites\n\tmy $contig_ix = 0;\n\tmy $coord = $self->{'_objref'}->get_seq_feat_by_tag($seq,\"_align_clipping:$seqID\");\n\tmy ($astart,$aend,$orientation) = ($coord->start,$coord->end,$coord->strand);\n\t$astart = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$astart);\n\t$aend   = $self->{'_objref'}->change_coord('gapped consensus',\"aligned $seqID\",$aend);\n\tfor ($i=$astart-1; $i<=$aend-1; $i++) {\n\t    # $i+1 in 'align' mode is $contig_ix\n\t    $contig_ix = $self->{'_objref'}->change_coord(\"aligned $seqID\",'gapped consensus',$i+1);\n\t    next unless (($contig_ix >= $start) && ($contig_ix <= $end));\n\t    my $r_base = uc(substr($sequence,$i,1));\n\t    my $c_base = uc(substr($consensus,$contig_ix-1,1));\n\t    if ($c_base eq '-') {\n\t\t$confirmed{$orientation}[$contig_ix] = -1;\n\t    } elsif (uc($r_base) eq uc($c_base)) { # Non discrepant region found\n\t\t$confirmed{$orientation}[$contig_ix]++;\n\t    }\n\t} # for ($i=$astart-1; $i<=$aend-1; $i++)\n    } # foreach $seqID (@reads)\n\n    # Locating non-confirmed aligned regions for each orientation in $confirmed registry\n    my ($orientation);\n    my @NCBS = ();\n    foreach $orientation (keys %confirmed) {\n\tmy ($ncbs_start,$ncbs_end);\n\n\tfor ($i=$start; $i<=$end; $i++) {\n\t    if (!defined($ncbs_start) &&\n\t\t(!defined($confirmed{$orientation}[$i]) || ($confirmed{$orientation}[$i] == 0))) {\n\t\t$ncbs_start = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i);\n\t    } elsif (defined($ncbs_start) &&\n\t\t     defined($confirmed{$orientation}[$i]) &&\n\t\t     ($confirmed{$orientation}[$i] > 0)) {\n\t\t$ncbs_end   = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$i-1);\n\t\tpush(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t\t  -end=>$ncbs_end,\n\t\t\t\t\t\t\t  -strand=>$orientation,\n\t\t\t\t\t\t\t  -primary=>\"not_confirmed_on_both_strands\") );\n\t\t$ncbs_start = undef;\n\t    }\n\t}\n\n\tif (defined($ncbs_start)) { # NCBS at the end of contig\n\t    $ncbs_end = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$end);\n\t    push(@NCBS, Bio::SeqFeature::Generic->new(-start=>$ncbs_start,\n\t\t\t\t\t\t      -end=>$ncbs_end,\n\t\t\t\t\t\t      -strand=>$orientation,\n\t\t\t\t\t\t      -primary=>'not_confirmed_on_both_strands') );\n\t}\n    }\n\n    return @NCBS;\n}\n\n=head2 single_strand\n\n Title     : single_strand\n Usage     : my $sfc = $ContigAnal->single_strand();\n Function  : \n\n             Locates all regions covered by aligned sequences only in\n             one of the two strands, i.e., regions for which aligned\n             sequence's strand() method returns +1 or -1 for all\n             sequences.\n\n Returns   : an array of Bio::SeqFeature::Generic objects\n Args      : optional arguments are\n             -start : start of interval that will be analyzed\n             -end   : start of interval that will be analyzed\n             -type  : coordinate system type for interval\n\n\n#'\nsub single_strand {\n    my ($self,@args) = shift; # Package reference\n\n    my ($start,$end,$type) = \n\t$self->_rearrange([qw(START END TYPE)],@args);\n\n    # Changing coordinates to gap mode align (consed: consensus sequence with alignments)\n    $type  = 'gapped consensus' unless(defined($type));\n    $start = 1 unless (defined($start));\n    if (defined($type) && $type ne 'gapped consensus') {\n\t$start = $self->{'objref'}->change_coord($type,'gapped consensus',$start);\n\t$end   = $self->{'objref'}->change_coord($type,'gapped consensus',$end) if (defined($end));\n    }\n    ($end) = $self->{'_objref'}->get_consensus_length unless (defined($end));\n\n    # Loading complete list of coordinates for aligned sequences\n    my $sfc = $self->{'_objref'}->get_features_collection();\n    my @forward = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>1,\n\t\t\t    -strandmatch=>'strong');\n    my @reverse = grep { $_->primary_tag =~ /^_aligned_coord:/ } \n    $sfc->features_in_range(-start=>$start,\n\t\t\t    -end=>$end,\n\t\t\t    -contain=>0,\n\t\t\t    -strand=>-1,\n\t\t\t    -strandmatch=>'strong');\n    # Merging overlapping features\n    @forward = $self->_merge_overlapping_features(@forward);\n    @reverse = $self->_merge_overlapping_features(@reverse);\n\n    # Finding single stranded regions\n    my ($length) = $self->{'_objref'}->get_consensus_length;\n    $length  = $self->{'_objref'}->change_coord('gapped consensus','ungapped consensus',$length);\n    @forward = $self->_complementary_features_list(1,$length,@forward);\n    @reverse = $self->_complementary_features_list(1,$length,@reverse);\n\n    my @SS = ();\n    foreach my $feat (@forward, @reverse) {\n\t$feat->primary_tag('single_strand_region');\n\tpush(@SS,$feat);\n    }\n\n    return @SS;\n}\n\n=head1 Internal Methods\n\n=head2 _merge_overlapping_features\n\n Title     : _merge_overlapping_features\n Usage     : my @feat = $ContigAnal->_merge_overlapping_features(@features);\n Function  : Merge all overlapping features into features\n             that hold original features as sub-features\n Returns   : array of Bio::SeqFeature::Generic objects\n Args      : array of Bio::SeqFeature::Generic objects\n\n\nsub _merge_overlapping_features {\n    my ($self,@feat) = @_;\n\n    $self->throw_not_implemented();\n}\n\n=head2 _complementary_features_list\n\n Title     : _complementary_features_list\n Usage     : @feat = $ContigAnal->_complementary_features_list($start,$end,@features);\n Function  : Build a list of features for regions\n             not covered by features in @features array\n Returns   : array of Bio::SeqFeature::Generic objects\n Args      : \n             $start    : [integer] start of first output feature\n             $end      : [integer] end of last output feature\n             @features : array of Bio::SeqFeature::Generic objects"}}],"version":5}