{"version":5,"vars":[{"line":225,"kind":2,"containerName":"strict::Bio::SeqFeature::Collection::Bio::Seq::PrimaryQual::Scalar","name":"Util"},{"line":227,"containerName":"","kind":2,"name":"base"},{"name":"new","containerName":"main::","children":[{"line":246,"containerName":"new","localvar":"my","kind":13,"name":"$class","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":246},{"line":248,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":248,"kind":13,"containerName":"new","name":"$class"},{"name":"@args","kind":13,"containerName":"new","line":248},{"name":"$src","localvar":"my","containerName":"new","kind":13,"line":250,"definition":"my"},{"name":"$id","kind":13,"containerName":"new","line":250},{"kind":13,"containerName":"new","name":"$collection","line":250},{"name":"$self","kind":13,"containerName":"new","line":250},{"name":"_rearrange","kind":12,"containerName":"new","line":250},{"line":250,"containerName":"new","kind":13,"name":"@args"},{"name":"$src","kind":13,"containerName":"new","line":251},{"containerName":"new","kind":13,"name":"$self","line":251},{"line":251,"name":"source","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$src","line":251},{"line":252,"name":"$id","containerName":"new","kind":13},{"line":252,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"id","line":252},{"line":252,"kind":13,"containerName":"new","name":"$id"},{"kind":13,"containerName":"new","name":"$self","line":252},{"line":253,"kind":13,"containerName":"new","name":"$id"},{"containerName":"new","kind":13,"name":"$self","line":253},{"containerName":"new","kind":12,"name":"id","line":253},{"kind":13,"containerName":"new","name":"$id","line":253},{"line":253,"name":"$self","containerName":"new","kind":13},{"line":257,"kind":13,"containerName":"new","name":"$self"},{"line":258,"name":"$self","containerName":"new","kind":13},{"line":261,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":264},{"line":265,"name":"$self","kind":13,"containerName":"new"},{"line":266,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":267},{"line":271,"name":"$collection","containerName":"new","kind":13},{"line":272,"containerName":"new","kind":13,"name":"$self"},{"name":"throw","containerName":"new","kind":12,"line":272},{"kind":13,"containerName":"new","name":"$collection","line":272},{"name":"isa","containerName":"new","kind":12,"line":272},{"line":273,"containerName":"new","kind":13,"name":"$self"},{"name":"$collection","containerName":"new","kind":13,"line":273},{"line":275,"name":"$self","kind":13,"containerName":"new"},{"line":275,"kind":12,"containerName":"new","name":"new"},{"kind":13,"containerName":"new","name":"$self","line":279},{"name":"$self","containerName":"new","kind":13,"line":280},{"kind":13,"containerName":"new","name":"$self","line":281},{"line":282,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$self","line":284}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"start":{"line":244,"character":0},"end":{"line":285,"character":9999}},"line":244,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance","parameters":[{"label":"$class"},{"label":"@args"}]}},{"line":248,"name":"SUPER","kind":12,"containerName":"new"},{"kind":12,"containerName":"SeqFeature::Collection","name":"Bio","line":275},{"children":[{"line":306,"localvar":"my","containerName":"source","kind":13,"name":"$self","definition":"my"},{"definition":"my","localvar":"my","containerName":"source","kind":13,"name":"$source","line":307},{"line":309,"kind":13,"containerName":"source","name":"$self"},{"containerName":"source","kind":13,"name":"$source","line":309},{"line":309,"name":"$source","containerName":"source","kind":13},{"line":310,"kind":13,"containerName":"source","name":"$self"}],"containerName":"main::","name":"source","definition":"sub","line":305,"kind":12,"range":{"start":{"line":305,"character":0},"end":{"line":311,"character":9999}}},{"line":323,"range":{"start":{"line":323,"character":0},"end":{"line":335,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","line":324,"localvar":"my","kind":13,"containerName":"assembly","name":"$self"},{"definition":"my","kind":13,"localvar":"my","containerName":"assembly","name":"$assembly","line":325},{"kind":13,"containerName":"assembly","name":"$self","line":327},{"kind":12,"containerName":"assembly","name":"throw","line":327},{"line":328,"name":"$assembly","containerName":"assembly","kind":13},{"line":328,"containerName":"assembly","kind":13,"name":"$assembly"},{"line":328,"kind":12,"containerName":"assembly","name":"isa"},{"kind":13,"containerName":"assembly","name":"$self","line":331},{"line":331,"name":"$assembly","kind":13,"containerName":"assembly"},{"kind":13,"containerName":"assembly","name":"$assembly","line":331},{"name":"$self","containerName":"assembly","kind":13,"line":332},{"line":334,"name":"$self","kind":13,"containerName":"assembly"}],"name":"assembly","containerName":"main::"},{"name":"weaken","kind":12,"line":332},{"line":352,"range":{"start":{"character":0,"line":352},"end":{"character":9999,"line":363}},"kind":12,"children":[{"containerName":"strand","localvar":"my","kind":13,"name":"$self","line":353,"definition":"my"},{"definition":"my","name":"$ori","kind":13,"localvar":"my","containerName":"strand","line":354},{"containerName":"strand","kind":13,"name":"$ori","line":356},{"containerName":"strand","kind":13,"name":"$self","line":357},{"name":"throw","kind":12,"containerName":"strand","line":357},{"line":358,"name":"$ori","containerName":"strand","kind":13},{"line":358,"name":"$ori","kind":13,"containerName":"strand"},{"line":358,"name":"$ori","containerName":"strand","kind":13},{"kind":13,"containerName":"strand","name":"$self","line":359},{"name":"$ori","containerName":"strand","kind":13,"line":359},{"name":"$self","kind":13,"containerName":"strand","line":362}],"containerName":"main::","name":"strand","definition":"sub"},{"range":{"start":{"character":0,"line":377},"end":{"character":9999,"line":386}},"kind":12,"line":377,"containerName":"main::","name":"upstream_neighbor","children":[{"line":378,"containerName":"upstream_neighbor","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"$ref","kind":13,"localvar":"my","containerName":"upstream_neighbor","line":379},{"line":381,"name":"$self","kind":13,"containerName":"upstream_neighbor"},{"name":"throw","kind":12,"containerName":"upstream_neighbor","line":381},{"name":"$ref","containerName":"upstream_neighbor","kind":13,"line":382},{"line":382,"name":"$ref","kind":13,"containerName":"upstream_neighbor"},{"line":382,"name":"isa","containerName":"upstream_neighbor","kind":12},{"kind":13,"containerName":"upstream_neighbor","name":"$self","line":384},{"line":384,"name":"$ref","kind":13,"containerName":"upstream_neighbor"},{"name":"$ref","kind":13,"containerName":"upstream_neighbor","line":384},{"name":"$self","kind":13,"containerName":"upstream_neighbor","line":385}],"definition":"sub"},{"definition":"sub","children":[{"line":401,"containerName":"downstream_neighbor","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":402,"name":"$ref","localvar":"my","containerName":"downstream_neighbor","kind":13,"definition":"my"},{"name":"$self","containerName":"downstream_neighbor","kind":13,"line":404},{"line":404,"containerName":"downstream_neighbor","kind":12,"name":"throw"},{"name":"$ref","kind":13,"containerName":"downstream_neighbor","line":405},{"containerName":"downstream_neighbor","kind":13,"name":"$ref","line":405},{"kind":12,"containerName":"downstream_neighbor","name":"isa","line":405},{"line":406,"containerName":"downstream_neighbor","kind":13,"name":"$self"},{"line":406,"name":"$ref","containerName":"downstream_neighbor","kind":13},{"line":406,"name":"$ref","kind":13,"containerName":"downstream_neighbor"},{"line":407,"kind":13,"containerName":"downstream_neighbor","name":"$self"}],"name":"downstream_neighbor","containerName":"main::","line":400,"kind":12,"range":{"end":{"character":9999,"line":408},"start":{"character":0,"line":400}}},{"line":443,"kind":12,"range":{"start":{"line":443,"character":0},"end":{"character":9999,"line":469}},"signature":{"label":"add_features($self,$args,$flag)","parameters":[{"label":"$self"},{"label":"$args"},{"label":"$flag"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false."},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_features","line":444,"definition":"my"},{"containerName":"add_features","kind":13,"name":"$args","line":444},{"name":"$flag","kind":13,"containerName":"add_features","line":444},{"line":447,"kind":13,"containerName":"add_features","name":"$flag"},{"name":"$flag","containerName":"add_features","kind":13,"line":447},{"line":448,"name":"$flag","containerName":"add_features","kind":13},{"line":448,"kind":13,"containerName":"add_features","name":"$self"},{"name":"$feat","kind":13,"localvar":"my","containerName":"add_features","line":449,"definition":"my"},{"line":449,"containerName":"add_features","kind":13,"name":"$args"},{"kind":13,"containerName":"add_features","name":"$feat","line":450},{"name":"seq","containerName":"add_features","kind":12,"line":450},{"line":451,"name":"$feat","kind":13,"containerName":"add_features"},{"kind":12,"containerName":"add_features","name":"attach_seq","line":451},{"name":"$self","containerName":"add_features","kind":13,"line":451},{"line":453,"containerName":"add_features","kind":13,"name":"$flag"},{"line":454,"containerName":"add_features","localvar":"my","kind":13,"name":"$feat","definition":"my"},{"containerName":"add_features","kind":13,"name":"$args","line":454},{"definition":"my","line":455,"localvar":"my","containerName":"add_features","kind":13,"name":"$seq"},{"line":455,"name":"$feat","containerName":"add_features","kind":13},{"line":455,"kind":12,"containerName":"add_features","name":"entire_seq"},{"localvar":"my","kind":13,"containerName":"add_features","name":"$seqID","line":456,"definition":"my"},{"containerName":"add_features","kind":13,"name":"$seq","line":456},{"name":"id","kind":12,"containerName":"add_features","line":456},{"kind":13,"containerName":"add_features","name":"$seq","line":456},{"line":456,"kind":12,"containerName":"add_features","name":"display_id"},{"containerName":"add_features","kind":13,"name":"$seq","line":456},{"line":456,"name":"primary_id","kind":12,"containerName":"add_features"},{"name":"$self","containerName":"add_features","kind":13,"line":457},{"line":457,"name":"warn","kind":12,"containerName":"add_features"},{"name":"$self","containerName":"add_features","kind":13,"line":458},{"name":"$seqID","containerName":"add_features","kind":13,"line":458},{"definition":"my","line":459,"localvar":"my","kind":13,"containerName":"add_features","name":"$tag"},{"line":459,"kind":13,"containerName":"add_features","name":"$feat"},{"containerName":"add_features","kind":12,"name":"primary_tag","line":459},{"name":"$self","kind":13,"containerName":"add_features","line":460},{"line":460,"name":"$seqID","containerName":"add_features","kind":13},{"kind":13,"containerName":"add_features","name":"$tag","line":460},{"name":"$feat","containerName":"add_features","kind":13,"line":460},{"localvar":"my","kind":13,"containerName":"add_features","name":"$nof_added","line":466,"definition":"my"},{"line":466,"containerName":"add_features","kind":13,"name":"$self"},{"name":"add_features","containerName":"add_features","kind":12,"line":466},{"line":466,"name":"$args","kind":13,"containerName":"add_features"},{"name":"$nof_added","kind":13,"containerName":"add_features","line":468}],"containerName":"main::","name":"add_features","definition":"sub","detail":"($self,$args,$flag)"},{"line":481,"range":{"start":{"line":481,"character":0},"end":{"character":9999,"line":498}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI","label":"remove_features($self,@args)"},"children":[{"definition":"my","line":482,"localvar":"my","kind":13,"containerName":"remove_features","name":"$self"},{"line":482,"containerName":"remove_features","kind":13,"name":"@args"},{"line":485,"localvar":"my","containerName":"remove_features","kind":13,"name":"$feat","definition":"my"},{"name":"@args","kind":13,"containerName":"remove_features","line":485},{"definition":"my","line":486,"name":"$seq","kind":13,"localvar":"my","containerName":"remove_features"},{"name":"$feat","containerName":"remove_features","kind":13,"line":486},{"line":486,"containerName":"remove_features","kind":12,"name":"entire_seq"},{"name":"$seqID","localvar":"my","kind":13,"containerName":"remove_features","line":487,"definition":"my"},{"line":487,"kind":13,"containerName":"remove_features","name":"$seq"},{"line":487,"containerName":"remove_features","kind":12,"name":"id"},{"line":487,"containerName":"remove_features","kind":13,"name":"$seq"},{"name":"display_id","kind":12,"containerName":"remove_features","line":487},{"kind":13,"containerName":"remove_features","name":"$seq","line":487},{"line":487,"name":"primary_id","kind":12,"containerName":"remove_features"},{"line":488,"containerName":"remove_features","localvar":"my","kind":13,"name":"$tag","definition":"my"},{"line":488,"containerName":"remove_features","kind":13,"name":"$feat"},{"line":488,"name":"primary_tag","kind":12,"containerName":"remove_features"},{"name":"$tag","kind":13,"containerName":"remove_features","line":489},{"line":490,"name":"$self","containerName":"remove_features","kind":13},{"line":490,"containerName":"remove_features","kind":13,"name":"$seqID"},{"containerName":"remove_features","kind":13,"name":"$tag","line":490},{"kind":13,"containerName":"remove_features","name":"$self","line":491},{"containerName":"remove_features","kind":13,"name":"$seqID","line":491},{"name":"$tag","containerName":"remove_features","kind":13,"line":491},{"line":492,"name":"$self","containerName":"remove_features","kind":13},{"kind":13,"containerName":"remove_features","name":"$seqID","line":492},{"containerName":"remove_features","kind":13,"name":"$tag","line":492},{"line":492,"containerName":"remove_features","kind":13,"name":"$feat"},{"kind":13,"containerName":"remove_features","name":"$self","line":497},{"line":497,"kind":12,"containerName":"remove_features","name":"remove_features"},{"line":497,"kind":13,"containerName":"remove_features","name":"@args"}],"containerName":"main::","name":"remove_features","definition":"sub","detail":"($self,@args)"},{"kind":12,"range":{"start":{"character":0,"line":510},"end":{"line":513,"character":9999}},"line":510,"definition":"sub","name":"get_features_collection","containerName":"main::","children":[{"line":511,"name":"$self","containerName":"get_features_collection","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"get_features_collection","kind":13,"line":512}]},{"kind":12,"range":{"end":{"character":9999,"line":529},"start":{"line":526,"character":0}},"line":526,"name":"remove_features_collection","containerName":"main::","children":[{"localvar":"my","containerName":"remove_features_collection","kind":13,"name":"$self","line":527,"definition":"my"},{"definition":"my","name":"$seqID","localvar":"my","containerName":"remove_features_collection","kind":13,"line":529},{"containerName":"remove_features_collection","kind":13,"name":"$self","line":529}],"definition":"sub"},{"name":"%self","containerName":null,"kind":13,"line":530},{"line":530,"name":"$seqID","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":533},{"children":[{"line":567,"name":"$self","localvar":"my","containerName":"change_coord","kind":13,"definition":"my"},{"definition":"my","line":568,"name":"$type_in","kind":13,"localvar":"my","containerName":"change_coord"},{"localvar":"my","containerName":"change_coord","kind":13,"name":"$type_out","line":569,"definition":"my"},{"line":570,"name":"$query","localvar":"my","kind":13,"containerName":"change_coord","definition":"my"},{"definition":"my","line":575,"name":"$read_in","localvar":"my","containerName":"change_coord","kind":13},{"line":575,"name":"$read_out","kind":13,"containerName":"change_coord"},{"line":576,"name":"$in_ID","kind":13,"localvar":"my","containerName":"change_coord","definition":"my"},{"containerName":"change_coord","kind":13,"name":"$type_in","line":576},{"definition":"my","line":577,"localvar":"my","kind":13,"containerName":"change_coord","name":"$out_ID"},{"containerName":"change_coord","kind":13,"name":"$type_out","line":577},{"name":"$in_ID","containerName":"change_coord","kind":13,"line":579},{"name":"$read_in","kind":13,"containerName":"change_coord","line":580},{"name":"$self","containerName":"change_coord","kind":13,"line":580},{"name":"get_seq_coord","containerName":"change_coord","kind":12,"line":580},{"line":580,"containerName":"change_coord","kind":13,"name":"$self"},{"line":580,"containerName":"change_coord","kind":12,"name":"get_seq_by_name"},{"line":580,"name":"$in_ID","kind":13,"containerName":"change_coord"},{"line":581,"name":"$self","containerName":"change_coord","kind":13},{"line":581,"containerName":"change_coord","kind":12,"name":"throw"},{"containerName":"change_coord","kind":13,"name":"$read_in","line":582},{"containerName":"change_coord","kind":13,"name":"$out_ID","line":584},{"line":585,"name":"$read_out","containerName":"change_coord","kind":13},{"line":585,"containerName":"change_coord","kind":13,"name":"$self"},{"line":585,"name":"get_seq_coord","containerName":"change_coord","kind":12},{"name":"$self","containerName":"change_coord","kind":13,"line":585},{"name":"get_seq_by_name","kind":12,"containerName":"change_coord","line":585},{"line":585,"containerName":"change_coord","kind":13,"name":"$out_ID"},{"containerName":"change_coord","kind":13,"name":"$self","line":586},{"kind":12,"containerName":"change_coord","name":"throw","line":586},{"containerName":"change_coord","kind":13,"name":"$read_out","line":587},{"name":"$type_in","containerName":"change_coord","kind":13,"line":594},{"containerName":"change_coord","kind":13,"name":"$type_out","line":594},{"kind":13,"containerName":"change_coord","name":"$self","line":595},{"line":595,"name":"throw","containerName":"change_coord","kind":12},{"kind":13,"containerName":"change_coord","name":"$self","line":596},{"containerName":"change_coord","kind":13,"name":"$query","line":597},{"kind":13,"containerName":"change_coord","name":"$self","line":597},{"containerName":"change_coord","kind":13,"name":"$query","line":597},{"line":600,"name":"$type_in","containerName":"change_coord","kind":13},{"line":600,"kind":13,"containerName":"change_coord","name":"$type_out"},{"line":601,"name":"$self","containerName":"change_coord","kind":13},{"containerName":"change_coord","kind":12,"name":"throw","line":601},{"line":602,"name":"$self","containerName":"change_coord","kind":13},{"name":"$query","containerName":"change_coord","kind":13,"line":603},{"line":603,"name":"$self","containerName":"change_coord","kind":13},{"line":603,"name":"$query","containerName":"change_coord","kind":13},{"line":608,"name":"$type_in","kind":13,"containerName":"change_coord"},{"line":609,"kind":13,"containerName":"change_coord","name":"$type_out"},{"line":609,"name":"$read_out","containerName":"change_coord","kind":13},{"line":610,"name":"$query","kind":13,"containerName":"change_coord"},{"containerName":"change_coord","kind":13,"name":"$query","line":610},{"kind":13,"containerName":"change_coord","name":"$read_out","line":610},{"name":"start","containerName":"change_coord","kind":12,"line":610},{"line":613,"kind":13,"containerName":"change_coord","name":"$type_in"},{"name":"$read_in","kind":13,"containerName":"change_coord","line":613},{"kind":13,"containerName":"change_coord","name":"$type_out","line":614},{"line":615,"kind":13,"containerName":"change_coord","name":"$query"},{"line":615,"name":"$query","containerName":"change_coord","kind":13},{"name":"$read_in","containerName":"change_coord","kind":13,"line":615},{"kind":12,"containerName":"change_coord","name":"start","line":615},{"line":620,"kind":13,"containerName":"change_coord","name":"$type_in"},{"containerName":"change_coord","kind":13,"name":"$type_out","line":621},{"containerName":"change_coord","kind":13,"name":"$read_out","line":621},{"line":622,"kind":13,"containerName":"change_coord","name":"$query"},{"name":"$self","containerName":"change_coord","kind":13,"line":622},{"line":622,"containerName":"change_coord","kind":12,"name":"change_coord"},{"line":622,"containerName":"change_coord","kind":13,"name":"$query"},{"name":"$query","kind":13,"containerName":"change_coord","line":623},{"name":"$self","kind":13,"containerName":"change_coord","line":623},{"name":"change_coord","kind":12,"containerName":"change_coord","line":623},{"line":623,"containerName":"change_coord","kind":13,"name":"$query"},{"name":"$type_in","kind":13,"containerName":"change_coord","line":626},{"line":626,"containerName":"change_coord","kind":13,"name":"$read_in"},{"containerName":"change_coord","kind":13,"name":"$type_out","line":627},{"containerName":"change_coord","kind":13,"name":"$query","line":628},{"line":628,"name":"$self","kind":13,"containerName":"change_coord"},{"containerName":"change_coord","kind":12,"name":"change_coord","line":628},{"line":628,"name":"$query","containerName":"change_coord","kind":13},{"line":629,"name":"$query","containerName":"change_coord","kind":13},{"line":629,"name":"$self","containerName":"change_coord","kind":13},{"line":629,"name":"change_coord","kind":12,"containerName":"change_coord"},{"line":629,"name":"$query","containerName":"change_coord","kind":13},{"line":634,"containerName":"change_coord","kind":13,"name":"$read_in"},{"line":634,"name":"$type_in","containerName":"change_coord","kind":13},{"line":635,"name":"$read_out","containerName":"change_coord","kind":13},{"containerName":"change_coord","kind":13,"name":"$type_out","line":635},{"containerName":"change_coord","kind":13,"name":"$query","line":636},{"line":636,"containerName":"change_coord","kind":13,"name":"$self"},{"line":636,"name":"change_coord","containerName":"change_coord","kind":12},{"name":"$query","kind":13,"containerName":"change_coord","line":636},{"line":637,"name":"$query","containerName":"change_coord","kind":13},{"line":637,"name":"$self","containerName":"change_coord","kind":13},{"kind":12,"containerName":"change_coord","name":"change_coord","line":637},{"line":637,"containerName":"change_coord","kind":13,"name":"$query"},{"line":642,"name":"$read_in","containerName":"change_coord","kind":13},{"line":642,"containerName":"change_coord","kind":13,"name":"$type_in"},{"line":643,"name":"$read_out","kind":13,"containerName":"change_coord"},{"containerName":"change_coord","kind":13,"name":"$type_out","line":643},{"kind":13,"containerName":"change_coord","name":"$read_in","line":644},{"containerName":"change_coord","kind":13,"name":"$read_out","line":644},{"name":"$query","kind":13,"containerName":"change_coord","line":645},{"line":645,"containerName":"change_coord","kind":13,"name":"$self"},{"line":645,"containerName":"change_coord","kind":12,"name":"change_coord"},{"line":645,"name":"$query","kind":13,"containerName":"change_coord"},{"line":646,"containerName":"change_coord","kind":13,"name":"$query"},{"containerName":"change_coord","kind":13,"name":"$self","line":646},{"line":646,"name":"change_coord","containerName":"change_coord","kind":12},{"name":"$query","containerName":"change_coord","kind":13,"line":646},{"definition":"my","line":648,"name":"$list_out","localvar":"my","containerName":"change_coord","kind":13},{"line":648,"kind":13,"containerName":"change_coord","name":"$self"},{"kind":13,"containerName":"change_coord","name":"$out_ID","line":648},{"line":649,"name":"$query","containerName":"change_coord","kind":13},{"line":649,"name":"$list_out","kind":13,"containerName":"change_coord"},{"line":649,"containerName":"change_coord","kind":13,"name":"$query"},{"line":651,"name":"$read_out","kind":13,"containerName":"change_coord"},{"line":651,"containerName":"change_coord","kind":12,"name":"strand"},{"kind":13,"localvar":"my","containerName":"change_coord","name":"$length","line":652,"definition":"my"},{"line":652,"name":"$read_out","kind":13,"containerName":"change_coord"},{"line":652,"name":"length","kind":12,"containerName":"change_coord"},{"name":"$length","containerName":"change_coord","kind":13,"line":653},{"line":653,"containerName":"change_coord","kind":13,"name":"$length"},{"name":"$list_out","kind":13,"containerName":"change_coord","line":653},{"kind":13,"containerName":"change_coord","name":"$length","line":653},{"containerName":"change_coord","kind":13,"name":"$query","line":654},{"line":654,"name":"$length","containerName":"change_coord","kind":13},{"name":"$query","kind":13,"containerName":"change_coord","line":654},{"line":658,"name":"$read_in","containerName":"change_coord","kind":13},{"containerName":"change_coord","kind":13,"name":"$type_in","line":658},{"line":659,"name":"$read_out","containerName":"change_coord","kind":13},{"name":"$type_out","kind":13,"containerName":"change_coord","line":659},{"definition":"my","name":"$list_in","kind":13,"localvar":"my","containerName":"change_coord","line":660},{"line":660,"containerName":"change_coord","kind":13,"name":"$self"},{"kind":13,"containerName":"change_coord","name":"$in_ID","line":660},{"name":"$read_in","containerName":"change_coord","kind":13,"line":662},{"containerName":"change_coord","kind":12,"name":"strand","line":662},{"containerName":"change_coord","localvar":"my","kind":13,"name":"$length","line":663,"definition":"my"},{"line":663,"containerName":"change_coord","kind":13,"name":"$read_in"},{"name":"length","containerName":"change_coord","kind":12,"line":663},{"line":664,"name":"$length","containerName":"change_coord","kind":13},{"containerName":"change_coord","kind":13,"name":"$length","line":664},{"name":"$list_in","kind":13,"containerName":"change_coord","line":664},{"name":"$length","containerName":"change_coord","kind":13,"line":664},{"containerName":"change_coord","kind":13,"name":"$query","line":665},{"line":665,"containerName":"change_coord","kind":13,"name":"$length"},{"name":"$query","containerName":"change_coord","kind":13,"line":665},{"name":"$query","containerName":"change_coord","kind":13,"line":667},{"containerName":"change_coord","kind":13,"name":"$list_in","line":667},{"name":"$query","containerName":"change_coord","kind":13,"line":667},{"line":668,"name":"$read_in","containerName":"change_coord","kind":13},{"name":"$read_out","kind":13,"containerName":"change_coord","line":668},{"name":"$query","containerName":"change_coord","kind":13,"line":669},{"containerName":"change_coord","kind":13,"name":"$self","line":669},{"line":669,"kind":12,"containerName":"change_coord","name":"change_coord"},{"line":669,"containerName":"change_coord","kind":13,"name":"$query"},{"line":670,"containerName":"change_coord","kind":13,"name":"$query"},{"line":670,"name":"$self","containerName":"change_coord","kind":13},{"line":670,"name":"change_coord","kind":12,"containerName":"change_coord"},{"name":"$query","containerName":"change_coord","kind":13,"line":670},{"line":676,"kind":13,"containerName":"change_coord","name":"$read_in"},{"containerName":"change_coord","kind":13,"name":"$type_in","line":676},{"line":677,"kind":13,"containerName":"change_coord","name":"$read_out"},{"line":677,"containerName":"change_coord","kind":13,"name":"$type_out"},{"name":"$query","containerName":"change_coord","kind":13,"line":678},{"name":"$self","kind":13,"containerName":"change_coord","line":678},{"line":678,"name":"change_coord","containerName":"change_coord","kind":12},{"line":678,"name":"$query","containerName":"change_coord","kind":13},{"name":"$query","containerName":"change_coord","kind":13,"line":679},{"containerName":"change_coord","kind":13,"name":"$self","line":679},{"containerName":"change_coord","kind":12,"name":"change_coord","line":679},{"containerName":"change_coord","kind":13,"name":"$query","line":679},{"kind":13,"containerName":"change_coord","name":"$type_in","line":684},{"line":685,"name":"$type_out","kind":13,"containerName":"change_coord"},{"name":"$read_out","containerName":"change_coord","kind":13,"line":685},{"name":"$query","kind":13,"containerName":"change_coord","line":686},{"line":686,"containerName":"change_coord","kind":13,"name":"$self"},{"kind":12,"containerName":"change_coord","name":"change_coord","line":686},{"line":686,"name":"$query","containerName":"change_coord","kind":13},{"line":687,"kind":13,"containerName":"change_coord","name":"$query"},{"kind":13,"containerName":"change_coord","name":"$self","line":687},{"line":687,"name":"change_coord","kind":12,"containerName":"change_coord"},{"line":687,"kind":13,"containerName":"change_coord","name":"$query"},{"line":690,"name":"$type_in","containerName":"change_coord","kind":13},{"line":690,"name":"$read_in","containerName":"change_coord","kind":13},{"line":691,"kind":13,"containerName":"change_coord","name":"$type_out"},{"line":692,"kind":13,"containerName":"change_coord","name":"$query"},{"line":692,"containerName":"change_coord","kind":13,"name":"$self"},{"line":692,"name":"change_coord","containerName":"change_coord","kind":12},{"name":"$query","kind":13,"containerName":"change_coord","line":692},{"line":693,"containerName":"change_coord","kind":13,"name":"$query"},{"name":"$self","containerName":"change_coord","kind":13,"line":693},{"line":693,"name":"change_coord","containerName":"change_coord","kind":12},{"name":"$query","kind":13,"containerName":"change_coord","line":693},{"name":"$type_in","kind":13,"containerName":"change_coord","line":698},{"kind":13,"containerName":"change_coord","name":"$type_out","line":699},{"containerName":"change_coord","kind":13,"name":"$read_out","line":699},{"line":700,"kind":13,"containerName":"change_coord","name":"$query"},{"line":700,"name":"$self","containerName":"change_coord","kind":13},{"line":700,"name":"change_coord","containerName":"change_coord","kind":12},{"line":700,"containerName":"change_coord","kind":13,"name":"$query"},{"name":"$query","kind":13,"containerName":"change_coord","line":701},{"name":"$self","containerName":"change_coord","kind":13,"line":701},{"line":701,"name":"change_coord","containerName":"change_coord","kind":12},{"containerName":"change_coord","kind":13,"name":"$query","line":701},{"line":704,"name":"$type_in","containerName":"change_coord","kind":13},{"name":"$read_in","kind":13,"containerName":"change_coord","line":704},{"name":"$type_out","containerName":"change_coord","kind":13,"line":705},{"line":706,"containerName":"change_coord","kind":13,"name":"$query"},{"containerName":"change_coord","kind":13,"name":"$self","line":706},{"name":"change_coord","containerName":"change_coord","kind":12,"line":706},{"containerName":"change_coord","kind":13,"name":"$query","line":706},{"line":707,"containerName":"change_coord","kind":13,"name":"$query"},{"line":707,"name":"$self","containerName":"change_coord","kind":13},{"line":707,"containerName":"change_coord","kind":12,"name":"change_coord"},{"line":707,"kind":13,"containerName":"change_coord","name":"$query"},{"containerName":"change_coord","kind":13,"name":"$self","line":711},{"name":"throw","containerName":"change_coord","kind":12,"line":711},{"line":712,"name":"$query","kind":13,"containerName":"change_coord"},{"name":"$query","containerName":"change_coord","kind":13,"line":715}],"name":"change_coord","containerName":"main::","definition":"sub","line":566,"range":{"start":{"line":566,"character":0},"end":{"line":716,"character":9999}},"kind":12},{"line":591,"name":"SWITCH1","kind":12},{"kind":12,"name":"_padded_unpadded","line":597},{"line":598,"name":"SWITCH1","kind":12},{"line":603,"kind":12,"name":"_unpadded_padded"},{"line":604,"kind":12,"name":"SWITCH1"},{"line":611,"kind":12,"name":"SWITCH1"},{"kind":12,"name":"SWITCH1","line":616},{"line":624,"kind":12,"name":"SWITCH1"},{"line":630,"kind":12,"name":"SWITCH1"},{"kind":12,"name":"SWITCH1","line":638},{"line":649,"name":"_padded_unpadded","kind":12},{"kind":12,"name":"_nof_gaps","line":653},{"name":"SWITCH1","kind":12,"line":656},{"line":664,"name":"_nof_gaps","kind":12},{"kind":12,"name":"_unpadded_padded","line":667},{"name":"SWITCH1","kind":12,"line":672},{"kind":12,"name":"SWITCH1","line":680},{"line":688,"kind":12,"name":"SWITCH1"},{"kind":12,"name":"SWITCH1","line":694},{"kind":12,"name":"SWITCH1","line":702},{"name":"SWITCH1","kind":12,"line":708},{"detail":"($self,$seq)","definition":"sub","name":"get_seq_coord","containerName":"main::","children":[{"line":730,"containerName":"get_seq_coord","localvar":"my","kind":13,"name":"$self","definition":"my"},{"containerName":"get_seq_coord","kind":13,"name":"$seq","line":730},{"line":732,"name":"$seq","containerName":"get_seq_coord","kind":13},{"name":"$seq","containerName":"get_seq_coord","kind":13,"line":732},{"name":"isa","containerName":"get_seq_coord","kind":12,"line":732},{"line":733,"containerName":"get_seq_coord","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"get_seq_coord","line":733},{"definition":"my","localvar":"my","kind":13,"containerName":"get_seq_coord","name":"$seqID","line":735},{"name":"$seq","kind":13,"containerName":"get_seq_coord","line":735},{"name":"id","containerName":"get_seq_coord","kind":12,"line":735},{"line":735,"kind":13,"containerName":"get_seq_coord","name":"$seq"},{"containerName":"get_seq_coord","kind":12,"name":"display_id","line":735},{"kind":13,"containerName":"get_seq_coord","name":"$seq","line":735},{"kind":12,"containerName":"get_seq_coord","name":"primary_id","line":735},{"name":"$self","kind":13,"containerName":"get_seq_coord","line":737},{"line":737,"kind":13,"containerName":"get_seq_coord","name":"$seqID"},{"containerName":"get_seq_coord","kind":13,"name":"$self","line":738},{"line":738,"name":"warn","containerName":"get_seq_coord","kind":12},{"kind":13,"containerName":"get_seq_coord","name":"$self","line":738},{"line":738,"name":"id","kind":12,"containerName":"get_seq_coord"},{"name":"$self","containerName":"get_seq_coord","kind":13,"line":741},{"containerName":"get_seq_coord","kind":13,"name":"$seqID","line":741},{"kind":13,"containerName":"get_seq_coord","name":"$self","line":746},{"line":746,"kind":13,"containerName":"get_seq_coord","name":"$seqID"}],"signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object","label":"get_seq_coord($self,$seq)"},"kind":12,"range":{"end":{"character":9999,"line":747},"start":{"character":0,"line":729}},"line":729},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"set_seq_coord","line":776,"definition":"my"},{"line":776,"name":"$feat","kind":13,"containerName":"set_seq_coord"},{"line":776,"name":"$seq","kind":13,"containerName":"set_seq_coord"},{"line":778,"name":"$seq","containerName":"set_seq_coord","kind":13},{"line":778,"containerName":"set_seq_coord","kind":13,"name":"$seq"},{"line":778,"containerName":"set_seq_coord","kind":12,"name":"isa"},{"line":779,"kind":13,"containerName":"set_seq_coord","name":"$self"},{"containerName":"set_seq_coord","kind":12,"name":"throw","line":779},{"line":779,"kind":13,"containerName":"set_seq_coord","name":"$seq"},{"line":783,"name":"$self","containerName":"set_seq_coord","kind":13},{"kind":12,"containerName":"set_seq_coord","name":"throw","line":783},{"line":784,"name":"$feat","kind":13,"containerName":"set_seq_coord"},{"name":"isa","kind":12,"containerName":"set_seq_coord","line":784},{"line":785,"name":"$self","kind":13,"containerName":"set_seq_coord"},{"kind":12,"containerName":"set_seq_coord","name":"throw","line":785},{"line":786,"name":"$feat","containerName":"set_seq_coord","kind":13},{"containerName":"set_seq_coord","kind":12,"name":"end","line":786},{"line":787,"kind":13,"containerName":"set_seq_coord","name":"$self"},{"name":"throw","kind":12,"containerName":"set_seq_coord","line":787},{"line":788,"containerName":"set_seq_coord","kind":13,"name":"$feat"},{"line":788,"kind":12,"containerName":"set_seq_coord","name":"start"},{"localvar":"my","kind":13,"containerName":"set_seq_coord","name":"$seqID","line":790,"definition":"my"},{"line":790,"kind":13,"containerName":"set_seq_coord","name":"$seq"},{"line":790,"containerName":"set_seq_coord","kind":12,"name":"id"},{"line":790,"name":"$seq","kind":13,"containerName":"set_seq_coord"},{"line":790,"name":"display_id","kind":12,"containerName":"set_seq_coord"},{"name":"$seq","containerName":"set_seq_coord","kind":13,"line":790},{"line":790,"kind":12,"containerName":"set_seq_coord","name":"primary_id"},{"line":791,"containerName":"set_seq_coord","kind":13,"name":"$self"},{"name":"$seqID","containerName":"set_seq_coord","kind":13,"line":791},{"name":"$self","containerName":"set_seq_coord","kind":13,"line":792},{"line":792,"name":"$seqID","containerName":"set_seq_coord","kind":13},{"name":"$self","containerName":"set_seq_coord","kind":13,"line":793},{"kind":13,"containerName":"set_seq_coord","name":"$seqID","line":793},{"line":794,"kind":13,"containerName":"set_seq_coord","name":"$seq"},{"line":794,"name":"$self","containerName":"set_seq_coord","kind":13},{"line":794,"name":"$seqID","containerName":"set_seq_coord","kind":13},{"containerName":"set_seq_coord","kind":13,"name":"$self","line":795},{"name":"warn","containerName":"set_seq_coord","kind":12,"line":795},{"line":796,"name":"$self","kind":13,"containerName":"set_seq_coord"},{"kind":12,"containerName":"set_seq_coord","name":"remove_seq","line":796},{"line":796,"kind":13,"containerName":"set_seq_coord","name":"$self"},{"line":796,"name":"$seqID","kind":13,"containerName":"set_seq_coord"},{"name":"$self","containerName":"set_seq_coord","kind":13,"line":798},{"name":"add_seq","containerName":"set_seq_coord","kind":12,"line":798},{"containerName":"set_seq_coord","kind":13,"name":"$seq","line":798},{"line":801,"kind":13,"containerName":"set_seq_coord","name":"$self"},{"name":"remove_features","kind":12,"containerName":"set_seq_coord","line":801},{"containerName":"set_seq_coord","kind":13,"name":"$feat","line":801},{"name":"$feat","containerName":"set_seq_coord","kind":13,"line":804},{"containerName":"set_seq_coord","kind":12,"name":"add_tag_value","line":804},{"name":"$self","kind":13,"containerName":"set_seq_coord","line":804},{"line":804,"containerName":"set_seq_coord","kind":12,"name":"id"},{"kind":13,"containerName":"set_seq_coord","name":"$feat","line":805},{"line":805,"containerName":"set_seq_coord","kind":12,"name":"has_tag"},{"line":806,"kind":13,"containerName":"set_seq_coord","name":"$feat"},{"line":806,"kind":12,"containerName":"set_seq_coord","name":"primary_tag"},{"containerName":"set_seq_coord","kind":13,"name":"$feat","line":807},{"line":807,"containerName":"set_seq_coord","kind":12,"name":"attach_seq"},{"line":807,"containerName":"set_seq_coord","kind":13,"name":"$seq"},{"line":808,"name":"$self","containerName":"set_seq_coord","kind":13},{"name":"$seqID","kind":13,"containerName":"set_seq_coord","line":808},{"name":"$feat","containerName":"set_seq_coord","kind":13,"line":808},{"containerName":"set_seq_coord","kind":13,"name":"$self","line":809},{"containerName":"set_seq_coord","kind":12,"name":"add_features","line":809},{"containerName":"set_seq_coord","kind":13,"name":"$feat","line":809}],"name":"set_seq_coord","containerName":"main::","definition":"sub","detail":"($self,$feat,$seq)","line":775,"kind":12,"range":{"start":{"character":0,"line":775},"end":{"line":810,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$seq"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object","label":"set_seq_coord($self,$feat,$seq)"}},{"range":{"end":{"character":9999,"line":841},"start":{"line":824,"character":0}},"kind":12,"line":824,"containerName":"main::","name":"set_consensus_sequence","children":[{"definition":"my","name":"$self","containerName":"set_consensus_sequence","localvar":"my","kind":13,"line":825},{"definition":"my","line":826,"name":"$seq","containerName":"set_consensus_sequence","localvar":"my","kind":13},{"line":828,"containerName":"set_consensus_sequence","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"set_consensus_sequence","line":828},{"line":829,"kind":13,"containerName":"set_consensus_sequence","name":"$seq"},{"name":"isa","kind":12,"containerName":"set_consensus_sequence","line":829},{"kind":13,"containerName":"set_consensus_sequence","name":"$self","line":831},{"line":832,"kind":13,"containerName":"set_consensus_sequence","name":"$self"},{"line":832,"name":"_register_gaps","containerName":"set_consensus_sequence","kind":12},{"line":832,"name":"$seq","containerName":"set_consensus_sequence","kind":13},{"kind":12,"containerName":"set_consensus_sequence","name":"seq","line":832},{"line":832,"name":"$self","kind":13,"containerName":"set_consensus_sequence"},{"line":833,"containerName":"set_consensus_sequence","kind":13,"name":"$self"},{"line":833,"kind":13,"containerName":"set_consensus_sequence","name":"$seq"},{"line":835,"kind":13,"containerName":"set_consensus_sequence","name":"$seq"},{"name":"start","containerName":"set_consensus_sequence","kind":12,"line":835},{"line":836,"name":"$seq","kind":13,"containerName":"set_consensus_sequence"},{"containerName":"set_consensus_sequence","kind":12,"name":"end","line":836},{"line":836,"name":"$seq","kind":13,"containerName":"set_consensus_sequence"},{"name":"_ungapped_len","kind":12,"containerName":"set_consensus_sequence","line":836},{"definition":"my","line":838,"name":"$con_len","containerName":"set_consensus_sequence","localvar":"my","kind":13},{"containerName":"set_consensus_sequence","kind":13,"name":"$seq","line":838},{"containerName":"set_consensus_sequence","kind":12,"name":"length","line":838},{"line":840,"containerName":"set_consensus_sequence","kind":13,"name":"$con_len"}],"definition":"sub"},{"line":853,"range":{"start":{"line":853,"character":0},"end":{"character":9999,"line":864}},"kind":12,"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"set_consensus_quality","kind":13,"line":854},{"containerName":"set_consensus_quality","localvar":"my","kind":13,"name":"$qual","line":855,"definition":"my"},{"kind":13,"containerName":"set_consensus_quality","name":"$self","line":857},{"line":857,"kind":12,"containerName":"set_consensus_quality","name":"throw"},{"line":858,"kind":13,"containerName":"set_consensus_quality","name":"$qual"},{"line":858,"name":"isa","containerName":"set_consensus_quality","kind":12},{"name":"$self","containerName":"set_consensus_quality","kind":13,"line":860},{"name":"throw","containerName":"set_consensus_quality","kind":12,"line":860},{"line":861,"name":"$self","kind":13,"containerName":"set_consensus_quality"},{"kind":13,"containerName":"set_consensus_quality","name":"$self","line":863},{"line":863,"name":"$qual","containerName":"set_consensus_quality","kind":13}],"containerName":"main::","name":"set_consensus_quality","definition":"sub"},{"definition":"sub","children":[{"containerName":"get_consensus_length","localvar":"my","kind":13,"name":"$self","line":877,"definition":"my"},{"line":879,"kind":13,"containerName":"get_consensus_length","name":"$self"},{"line":879,"name":"length","containerName":"get_consensus_length","kind":12}],"name":"get_consensus_length","containerName":"main::","line":876,"kind":12,"range":{"start":{"line":876,"character":0},"end":{"line":880,"character":9999}}},{"signature":{"label":"get_consensus_sequence($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none"},"kind":12,"range":{"start":{"character":0,"line":893},"end":{"character":9999,"line":897}},"line":893,"detail":"($self,@args)","definition":"sub","name":"get_consensus_sequence","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"get_consensus_sequence","line":894,"definition":"my"},{"line":894,"containerName":"get_consensus_sequence","kind":13,"name":"@args"},{"name":"$self","containerName":"get_consensus_sequence","kind":13,"line":896}]},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"get_consensus_quality","line":911,"definition":"my"},{"kind":13,"containerName":"get_consensus_quality","name":"@args","line":911},{"name":"$self","kind":13,"containerName":"get_consensus_quality","line":913}],"containerName":"main::","name":"get_consensus_quality","definition":"sub","detail":"($self,@args)","line":910,"kind":12,"range":{"start":{"line":910,"character":0},"end":{"character":9999,"line":914}},"signature":{"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_consensus_quality($self,@args)"}},{"kind":12,"range":{"start":{"line":931,"character":0},"end":{"character":9999,"line":948}},"line":931,"signature":{"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$qual"}],"label":"set_seq_qual($self,$seq,$qual)"},"containerName":"main::","name":"set_seq_qual","children":[{"line":932,"kind":13,"localvar":"my","containerName":"set_seq_qual","name":"$self","definition":"my"},{"line":932,"name":"$seq","containerName":"set_seq_qual","kind":13},{"line":932,"containerName":"set_seq_qual","kind":13,"name":"$qual"},{"containerName":"set_seq_qual","kind":13,"name":"$seq","line":934},{"name":"$seq","containerName":"set_seq_qual","kind":13,"line":934},{"line":934,"containerName":"set_seq_qual","kind":12,"name":"isa"},{"name":"$self","kind":13,"containerName":"set_seq_qual","line":935},{"line":935,"name":"throw","kind":12,"containerName":"set_seq_qual"},{"line":935,"kind":13,"containerName":"set_seq_qual","name":"$seq"},{"definition":"my","line":937,"localvar":"my","containerName":"set_seq_qual","kind":13,"name":"$seqID"},{"name":"$seq","containerName":"set_seq_qual","kind":13,"line":937},{"containerName":"set_seq_qual","kind":12,"name":"id","line":937},{"name":"$seq","kind":13,"containerName":"set_seq_qual","line":937},{"kind":12,"containerName":"set_seq_qual","name":"display_id","line":937},{"line":937,"name":"$seq","containerName":"set_seq_qual","kind":13},{"kind":12,"containerName":"set_seq_qual","name":"primary_id","line":937},{"containerName":"set_seq_qual","kind":13,"name":"$self","line":939},{"name":"throw","kind":12,"containerName":"set_seq_qual","line":939},{"kind":13,"containerName":"set_seq_qual","name":"$qual","line":940},{"line":940,"containerName":"set_seq_qual","kind":12,"name":"isa"},{"line":941,"kind":13,"containerName":"set_seq_qual","name":"$self"},{"name":"throw","kind":12,"containerName":"set_seq_qual","line":941},{"line":942,"kind":13,"containerName":"set_seq_qual","name":"$self"},{"line":942,"name":"$seqID","kind":13,"containerName":"set_seq_qual"},{"containerName":"set_seq_qual","kind":13,"name":"$self","line":943},{"containerName":"set_seq_qual","kind":12,"name":"throw","line":943},{"name":"$self","containerName":"set_seq_qual","kind":13,"line":943},{"kind":12,"containerName":"set_seq_qual","name":"get_seq_coord","line":943},{"line":943,"name":"$seq","kind":13,"containerName":"set_seq_qual"},{"line":946,"kind":13,"localvar":"my","containerName":"set_seq_qual","name":"$sequence","definition":"my"},{"containerName":"set_seq_qual","kind":13,"name":"$self","line":946},{"line":946,"kind":13,"containerName":"set_seq_qual","name":"$seqID"},{"line":946,"name":"seq","containerName":"set_seq_qual","kind":12},{"definition":"my","name":"$tmp","containerName":"set_seq_qual","localvar":"my","kind":13,"line":947},{"name":"$qual","containerName":"set_seq_qual","kind":13,"line":947},{"line":947,"containerName":"set_seq_qual","kind":12,"name":"qual"},{"line":948,"containerName":"set_seq_qual","kind":13,"name":"$tmp"}],"detail":"($self,$seq,$qual)","definition":"sub"},{"kind":13,"containerName":null,"name":"$tmp","line":948},{"line":948,"kind":13,"containerName":null,"name":"$self"},{"line":948,"name":"get_seq_coord","kind":12,"containerName":"main::"},{"name":"$seq","kind":13,"containerName":null,"line":948},{"kind":12,"containerName":"main::","name":"strand","line":948},{"definition":"my","line":949,"name":"@quality","containerName":null,"localvar":"my","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$previous","line":950},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$next","line":951},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$i","line":952},{"kind":13,"localvar":"my","containerName":null,"name":"$j","line":952,"definition":"my"},{"line":953,"kind":13,"containerName":null,"name":"$i"},{"name":"%tmp","containerName":null,"kind":13,"line":953},{"line":955,"name":"$sequence","kind":13,"containerName":null},{"name":"%j","kind":13,"containerName":null,"line":955},{"line":956,"kind":13,"containerName":null,"name":"$previous"},{"kind":13,"containerName":null,"name":"@tmp","line":956},{"kind":13,"containerName":null,"name":"$i","line":956},{"line":956,"name":"$i","containerName":null,"kind":13},{"name":"$i","kind":13,"containerName":null,"line":957},{"line":957,"name":"%tmp","containerName":null,"kind":13},{"line":958,"name":"$next","containerName":null,"kind":13},{"name":"@tmp","kind":13,"containerName":null,"line":958},{"line":958,"name":"%i","containerName":null,"kind":13},{"line":960,"containerName":null,"kind":13,"name":"$next"},{"containerName":null,"kind":13,"name":"@quality","line":962},{"name":"$previous","kind":13,"containerName":null,"line":962},{"line":962,"name":"%next","kind":13,"containerName":null},{"line":964,"name":"@quality","kind":13,"containerName":null},{"line":964,"name":"@tmp","containerName":null,"kind":13},{"line":964,"name":"$i","containerName":null,"kind":13},{"line":965,"name":"$i","containerName":null,"kind":13},{"name":"$j","containerName":null,"kind":13,"line":967},{"name":"%self","kind":13,"containerName":null,"line":970},{"kind":13,"containerName":null,"name":"%seqID","line":970},{"containerName":"Seq::PrimaryQual","kind":12,"name":"Bio","line":970},{"line":970,"kind":12,"containerName":"main::","name":"new"},{"line":971,"containerName":null,"kind":13,"name":"@quality"},{"kind":13,"containerName":null,"name":"$seqID","line":971},{"line":997,"range":{"start":{"character":0,"line":997},"end":{"character":9999,"line":1020}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps","label":"get_seq_ids($self,@args)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"get_seq_ids","line":998,"definition":"my"},{"kind":13,"containerName":"get_seq_ids","name":"@args","line":998},{"definition":"my","name":"$type","kind":13,"localvar":"my","containerName":"get_seq_ids","line":1000},{"line":1000,"name":"$start","kind":13,"containerName":"get_seq_ids"},{"name":"$end","kind":13,"containerName":"get_seq_ids","line":1000},{"line":1001,"name":"$self","containerName":"get_seq_ids","kind":13},{"name":"_rearrange","kind":12,"containerName":"get_seq_ids","line":1001},{"line":1001,"containerName":"get_seq_ids","kind":13,"name":"@args"},{"line":1003,"containerName":"get_seq_ids","kind":13,"name":"$start"},{"line":1003,"kind":13,"containerName":"get_seq_ids","name":"$end"},{"line":1004,"name":"$type","containerName":"get_seq_ids","kind":13},{"line":1004,"name":"$type","containerName":"get_seq_ids","kind":13},{"containerName":"get_seq_ids","kind":13,"name":"$start","line":1005},{"line":1005,"kind":13,"containerName":"get_seq_ids","name":"$self"},{"line":1005,"kind":12,"containerName":"get_seq_ids","name":"change_coord"},{"line":1005,"name":"$type","kind":13,"containerName":"get_seq_ids"},{"line":1005,"kind":13,"containerName":"get_seq_ids","name":"$start"},{"line":1006,"name":"$end","kind":13,"containerName":"get_seq_ids"},{"name":"$self","containerName":"get_seq_ids","kind":13,"line":1006},{"line":1006,"name":"change_coord","kind":12,"containerName":"get_seq_ids"},{"name":"$type","kind":13,"containerName":"get_seq_ids","line":1006},{"containerName":"get_seq_ids","kind":13,"name":"$end","line":1006},{"definition":"my","line":1009,"name":"@list","kind":13,"localvar":"my","containerName":"get_seq_ids"},{"line":1009,"name":"isa","containerName":"get_seq_ids","kind":12},{"line":1010,"kind":12,"containerName":"get_seq_ids","name":"primary_tag"},{"kind":13,"containerName":"get_seq_ids","name":"$self","line":1011},{"line":1011,"name":"features_in_range","kind":12,"containerName":"get_seq_ids"},{"line":1011,"name":"$start","kind":13,"containerName":"get_seq_ids"},{"kind":13,"containerName":"get_seq_ids","name":"$end","line":1012},{"name":"@list","kind":13,"containerName":"get_seq_ids","line":1015},{"name":"entire_seq","kind":12,"containerName":"get_seq_ids","line":1015},{"name":"id","containerName":"get_seq_ids","kind":12,"line":1015},{"line":1015,"name":"@list","containerName":"get_seq_ids","kind":13},{"line":1016,"name":"@list","containerName":"get_seq_ids","kind":13},{"name":"$self","kind":13,"containerName":"get_seq_ids","line":1020},{"line":1020,"name":"$a","kind":13,"containerName":"get_seq_ids"},{"line":1020,"containerName":"get_seq_ids","kind":13,"name":"$b"},{"containerName":"get_seq_ids","kind":13,"name":"$self","line":1020}],"name":"get_seq_ids","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"line":1037,"kind":12,"range":{"start":{"character":0,"line":1037},"end":{"character":9999,"line":1046}},"signature":{"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$tag"}],"label":"get_seq_feat_by_tag($self,$seq,$tag)"},"children":[{"name":"$self","containerName":"get_seq_feat_by_tag","localvar":"my","kind":13,"line":1038,"definition":"my"},{"name":"$seq","containerName":"get_seq_feat_by_tag","kind":13,"line":1038},{"containerName":"get_seq_feat_by_tag","kind":13,"name":"$tag","line":1038},{"line":1040,"name":"$seq","containerName":"get_seq_feat_by_tag","kind":13},{"line":1040,"name":"$seq","containerName":"get_seq_feat_by_tag","kind":13},{"name":"isa","kind":12,"containerName":"get_seq_feat_by_tag","line":1040},{"name":"$self","containerName":"get_seq_feat_by_tag","kind":13,"line":1041},{"name":"throw","kind":12,"containerName":"get_seq_feat_by_tag","line":1041},{"line":1041,"name":"$seq","containerName":"get_seq_feat_by_tag","kind":13},{"definition":"my","name":"$seqID","kind":13,"localvar":"my","containerName":"get_seq_feat_by_tag","line":1043},{"containerName":"get_seq_feat_by_tag","kind":13,"name":"$seq","line":1043},{"name":"id","kind":12,"containerName":"get_seq_feat_by_tag","line":1043},{"line":1043,"name":"$seq","kind":13,"containerName":"get_seq_feat_by_tag"},{"line":1043,"kind":12,"containerName":"get_seq_feat_by_tag","name":"display_id"},{"line":1043,"kind":13,"containerName":"get_seq_feat_by_tag","name":"$seq"},{"kind":12,"containerName":"get_seq_feat_by_tag","name":"primary_id","line":1043},{"line":1045,"containerName":"get_seq_feat_by_tag","kind":13,"name":"$self"},{"line":1045,"containerName":"get_seq_feat_by_tag","kind":13,"name":"$seqID"},{"line":1045,"name":"$tag","kind":13,"containerName":"get_seq_feat_by_tag"}],"containerName":"main::","name":"get_seq_feat_by_tag","definition":"sub","detail":"($self,$seq,$tag)"},{"signature":{"parameters":[{"label":"$seqID"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string","label":"get_seq_by_name($seqID)"},"kind":12,"range":{"start":{"character":0,"line":1059},"end":{"line":1069,"character":9999}},"line":1059,"detail":"($seqID)","definition":"sub","name":"get_seq_by_name","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"get_seq_by_name","name":"$self","line":1060,"definition":"my"},{"name":"$seqID","localvar":"my","kind":13,"containerName":"get_seq_by_name","line":1061,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_seq_by_name","line":1063},{"kind":13,"containerName":"get_seq_by_name","name":"$seqID","line":1063},{"line":1064,"name":"$self","containerName":"get_seq_by_name","kind":13},{"containerName":"get_seq_by_name","kind":12,"name":"throw","line":1064},{"containerName":"get_seq_by_name","kind":13,"name":"$self","line":1064},{"line":1064,"name":"id","containerName":"get_seq_by_name","kind":12},{"line":1068,"name":"$self","kind":13,"containerName":"get_seq_by_name"},{"name":"$seqID","containerName":"get_seq_by_name","kind":13,"line":1068}]},{"line":1086,"kind":12,"range":{"start":{"line":1086,"character":0},"end":{"line":1096,"character":9999}},"signature":{"label":"get_qual_by_name($seqID)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string","parameters":[{"label":"$seqID"}]},"children":[{"line":1087,"name":"$self","kind":13,"localvar":"my","containerName":"get_qual_by_name","definition":"my"},{"line":1088,"name":"$seqID","containerName":"get_qual_by_name","localvar":"my","kind":13,"definition":"my"},{"containerName":"get_qual_by_name","kind":13,"name":"$self","line":1090},{"line":1090,"name":"$seqID","kind":13,"containerName":"get_qual_by_name"},{"line":1091,"name":"$self","containerName":"get_qual_by_name","kind":13},{"line":1091,"kind":12,"containerName":"get_qual_by_name","name":"warn"},{"name":"$self","containerName":"get_qual_by_name","kind":13,"line":1095},{"line":1095,"name":"$seqID","kind":13,"containerName":"get_qual_by_name"}],"name":"get_qual_by_name","containerName":"main::","definition":"sub","detail":"($seqID)"},{"children":[{"line":1123,"name":"$self","localvar":"my","kind":13,"containerName":"add_seq","definition":"my"},{"definition":"my","name":"$seq","localvar":"my","kind":13,"containerName":"add_seq","line":1124},{"line":1126,"containerName":"add_seq","kind":13,"name":"$seq"},{"line":1126,"name":"$seq","kind":13,"containerName":"add_seq"},{"line":1126,"kind":12,"containerName":"add_seq","name":"isa"},{"line":1127,"containerName":"add_seq","kind":13,"name":"$self"},{"line":1127,"name":"throw","containerName":"add_seq","kind":12},{"line":1127,"name":"$seq","kind":13,"containerName":"add_seq"},{"definition":"my","name":"$seqID","localvar":"my","kind":13,"containerName":"add_seq","line":1130},{"line":1130,"kind":13,"containerName":"add_seq","name":"$seq"},{"line":1130,"containerName":"add_seq","kind":12,"name":"id"},{"line":1130,"name":"$seq","containerName":"add_seq","kind":13},{"name":"display_id","kind":12,"containerName":"add_seq","line":1130},{"name":"$seq","containerName":"add_seq","kind":13,"line":1130},{"containerName":"add_seq","kind":12,"name":"primary_id","line":1130},{"line":1131,"name":"$self","containerName":"add_seq","kind":13},{"line":1131,"name":"$seqID","kind":13,"containerName":"add_seq"},{"line":1131,"name":"$self","kind":13,"containerName":"add_seq"},{"containerName":"add_seq","kind":13,"name":"$seqID","line":1131},{"name":"$self","containerName":"add_seq","kind":13,"line":1133},{"line":1133,"kind":13,"containerName":"add_seq","name":"$seqID"},{"line":1134,"name":"$seq","kind":13,"containerName":"add_seq"},{"name":"$self","kind":13,"containerName":"add_seq","line":1134},{"line":1134,"name":"$seqID","containerName":"add_seq","kind":13},{"line":1135,"name":"$self","kind":13,"containerName":"add_seq"},{"line":1135,"name":"warn","kind":12,"containerName":"add_seq"},{"line":1139,"containerName":"add_seq","kind":13,"name":"$seq"},{"line":1139,"name":"start","containerName":"add_seq","kind":12},{"line":1140,"containerName":"add_seq","kind":13,"name":"$seq"},{"containerName":"add_seq","kind":12,"name":"end","line":1140},{"line":1140,"name":"$seq","kind":13,"containerName":"add_seq"},{"line":1140,"name":"_ungapped_len","kind":12,"containerName":"add_seq"},{"kind":13,"containerName":"add_seq","name":"$self","line":1142},{"name":"warn","containerName":"add_seq","kind":12,"line":1142},{"name":"$seqID","containerName":"add_seq","kind":13,"line":1142},{"name":"$seq","containerName":"add_seq","kind":13,"line":1143},{"containerName":"add_seq","kind":12,"name":"alphabet","line":1143},{"name":"$seq","kind":13,"containerName":"add_seq","line":1143},{"line":1143,"kind":12,"containerName":"add_seq","name":"alphabet"},{"line":1149,"name":"$seq","containerName":"add_seq","kind":13},{"name":"seq","kind":12,"containerName":"add_seq","line":1149},{"line":1150,"kind":13,"containerName":"add_seq","name":"$self"},{"line":1150,"containerName":"add_seq","kind":13,"name":"$seq"},{"line":1150,"containerName":"add_seq","kind":12,"name":"seq"},{"name":"$self","kind":13,"containerName":"add_seq","line":1152},{"line":1155,"name":"$seq_no","kind":13,"localvar":"my","containerName":"add_seq","definition":"my"},{"line":1155,"name":"$self","kind":13,"containerName":"add_seq"},{"line":1157,"name":"$self","containerName":"add_seq","kind":13},{"kind":13,"containerName":"add_seq","name":"$seqID","line":1157},{"line":1158,"name":"$self","containerName":"add_seq","kind":13},{"line":1158,"kind":12,"containerName":"add_seq","name":"warn"},{"line":1161,"name":"$self","kind":13,"containerName":"add_seq"},{"containerName":"add_seq","kind":13,"name":"$seq_no","line":1161},{"line":1161,"name":"$seqID","kind":13,"containerName":"add_seq"},{"containerName":"add_seq","kind":13,"name":"$self","line":1167},{"kind":13,"containerName":"add_seq","name":"$seqID","line":1167},{"line":1167,"containerName":"add_seq","kind":13,"name":"$seq"},{"line":1168,"kind":13,"containerName":"add_seq","name":"$self"},{"line":1168,"name":"$seqID","kind":13,"containerName":"add_seq"},{"line":1169,"kind":13,"containerName":"add_seq","name":"$self"},{"line":1169,"kind":13,"containerName":"add_seq","name":"$seqID"},{"containerName":"add_seq","localvar":"my","kind":13,"name":"$dbref","line":1170,"definition":"my"},{"line":1170,"name":"$self","containerName":"add_seq","kind":13},{"containerName":"add_seq","kind":13,"name":"$seqID","line":1170},{"line":1171,"kind":13,"localvar":"my","containerName":"add_seq","name":"$nofgaps","definition":"my"},{"line":1171,"name":"$self","containerName":"add_seq","kind":13},{"line":1171,"containerName":"add_seq","kind":12,"name":"_register_gaps"},{"kind":13,"containerName":"add_seq","name":"$seq","line":1171},{"line":1171,"name":"seq","kind":12,"containerName":"add_seq"},{"containerName":"add_seq","kind":13,"name":"$dbref","line":1171},{"line":1174,"kind":13,"containerName":"add_seq","name":"$self"},{"line":1174,"containerName":"add_seq","kind":13,"name":"$seq"},{"containerName":"add_seq","kind":12,"name":"length","line":1174},{"name":"$nofgaps","kind":13,"containerName":"add_seq","line":1174}],"containerName":"main::","name":"add_seq","definition":"sub","line":1122,"kind":12,"range":{"start":{"character":0,"line":1122},"end":{"line":1177,"character":9999}}},{"definition":"sub","detail":"($self,$seq)","children":[{"line":1190,"name":"$self","localvar":"my","containerName":"remove_seq","kind":13,"definition":"my"},{"kind":13,"containerName":"remove_seq","name":"$seq","line":1190},{"line":1192,"name":"$seq","kind":13,"containerName":"remove_seq"},{"containerName":"remove_seq","kind":13,"name":"$seq","line":1192},{"name":"isa","containerName":"remove_seq","kind":12,"line":1192},{"line":1193,"containerName":"remove_seq","kind":13,"name":"$self"},{"name":"throw","containerName":"remove_seq","kind":12,"line":1193},{"kind":13,"containerName":"remove_seq","name":"$seq","line":1193},{"name":"$seqID","kind":13,"localvar":"my","containerName":"remove_seq","line":1196,"definition":"my"},{"line":1196,"name":"$seq","containerName":"remove_seq","kind":13},{"containerName":"remove_seq","kind":12,"name":"id","line":1196},{"containerName":"remove_seq","kind":13,"name":"$seq","line":1196},{"line":1196,"containerName":"remove_seq","kind":12,"name":"display_id"},{"line":1196,"name":"$seq","kind":13,"containerName":"remove_seq"},{"line":1196,"name":"primary_id","kind":12,"containerName":"remove_seq"},{"line":1197,"containerName":"remove_seq","kind":13,"name":"$self"},{"line":1197,"name":"$seqID","kind":13,"containerName":"remove_seq"},{"line":1198,"kind":13,"containerName":"remove_seq","name":"$self"},{"line":1198,"containerName":"remove_seq","kind":12,"name":"warn"},{"name":"$self","kind":13,"containerName":"remove_seq","line":1203},{"containerName":"remove_seq","kind":13,"name":"$seq","line":1203},{"containerName":"remove_seq","kind":12,"name":"length","line":1203},{"line":1204,"name":"$self","containerName":"remove_seq","kind":13},{"line":1204,"kind":13,"containerName":"remove_seq","name":"$seqID"},{"line":1204,"kind":13,"containerName":"remove_seq","name":"$seq"},{"line":1204,"kind":12,"containerName":"remove_seq","name":"length"},{"containerName":"remove_seq","kind":13,"name":"$self","line":1207},{"name":"$max_order","containerName":"remove_seq","localvar":"my","kind":13,"line":1210,"definition":"my"},{"line":1210,"name":"$self","containerName":"remove_seq","kind":13},{"definition":"my","line":1211,"localvar":"my","containerName":"remove_seq","kind":13,"name":"$target_order"},{"line":1211,"name":"$max_order","kind":13,"containerName":"remove_seq"},{"definition":"my","kind":13,"localvar":"my","containerName":"remove_seq","name":"$order","line":1212},{"line":1212,"containerName":"remove_seq","kind":13,"name":"$order"},{"kind":13,"containerName":"remove_seq","name":"$max_order","line":1212},{"line":1212,"name":"$order","kind":13,"containerName":"remove_seq"},{"line":1213,"kind":13,"containerName":"remove_seq","name":"$self"},{"line":1213,"containerName":"remove_seq","kind":13,"name":"$order"},{"line":1213,"kind":13,"containerName":"remove_seq","name":"$seqID"},{"kind":13,"containerName":"remove_seq","name":"$target_order","line":1215},{"line":1215,"name":"$order","containerName":"remove_seq","kind":13},{"line":1217,"kind":13,"containerName":"remove_seq","name":"$order"},{"name":"$target_order","kind":13,"containerName":"remove_seq","line":1217},{"containerName":"remove_seq","kind":13,"name":"$self","line":1219},{"line":1219,"name":"$order","containerName":"remove_seq","kind":13},{"line":1219,"kind":13,"containerName":"remove_seq","name":"$self"},{"line":1219,"kind":13,"containerName":"remove_seq","name":"$order"},{"kind":13,"containerName":"remove_seq","name":"$order","line":1221},{"line":1221,"name":"$max_order","containerName":"remove_seq","kind":13},{"name":"$self","containerName":"remove_seq","kind":13,"line":1223},{"line":1223,"name":"$order","containerName":"remove_seq","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"remove_seq","name":"@feats","line":1228},{"definition":"my","name":"$tag","containerName":"remove_seq","localvar":"my","kind":13,"line":1229},{"name":"$self","containerName":"remove_seq","kind":13,"line":1229},{"line":1229,"containerName":"remove_seq","kind":13,"name":"$seqID"}],"containerName":"main::","name":"remove_seq","signature":{"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"remove_seq($self,$seq)"},"line":1189,"range":{"start":{"character":0,"line":1189},"end":{"line":1229,"character":9999}},"kind":12},{"name":"_nof_gaps","kind":12,"line":1204},{"name":"@feats","containerName":null,"kind":13,"line":1230},{"line":1230,"containerName":null,"kind":13,"name":"%self"},{"line":1230,"name":"%seqID","kind":13,"containerName":null},{"name":"$tag","containerName":null,"kind":13,"line":1230},{"name":"%self","containerName":null,"kind":13,"line":1232},{"name":"remove_features","kind":12,"containerName":"main::","line":1232},{"line":1232,"name":"@feats","kind":13,"containerName":null},{"line":1233,"name":"%self","containerName":null,"kind":13},{"line":1233,"containerName":null,"kind":13,"name":"$seqID"},{"name":"purge","containerName":"main::","children":[{"line":1257,"name":"$self","kind":13,"localvar":"my","containerName":"purge","definition":"my"},{"name":"$self","containerName":"purge","kind":13,"line":1258},{"line":1258,"name":"throw_not_implemented","kind":12,"containerName":"purge"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":1259},"start":{"character":0,"line":1256}},"line":1256,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:","label":"purge($self)"}},{"detail":"($self)","definition":"sub","containerName":"main::","name":"sort_alphabetically","children":[{"kind":13,"localvar":"my","containerName":"sort_alphabetically","name":"$self","line":1276,"definition":"my"},{"name":"$self","containerName":"sort_alphabetically","kind":13,"line":1277},{"line":1277,"kind":12,"containerName":"sort_alphabetically","name":"throw_not_implemented"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :","label":"sort_alphabetically($self)"},"kind":12,"range":{"end":{"character":9999,"line":1278},"start":{"line":1275,"character":0}},"line":1275},{"range":{"start":{"character":0,"line":1294},"end":{"character":9999,"line":1299}},"kind":12,"line":1294,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :","label":"each_seq($self)"},"name":"each_seq","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"each_seq","kind":13,"name":"$self","line":1295},{"definition":"my","line":1297,"name":"@arr","kind":13,"localvar":"my","containerName":"each_seq"},{"kind":13,"containerName":"each_seq","name":"$seqID","line":1297},{"line":1299,"containerName":"each_seq","kind":13,"name":"$seqID"},{"line":1299,"kind":13,"containerName":"each_seq","name":"$self"},{"name":"$a","kind":13,"containerName":"each_seq","line":1299},{"line":1299,"kind":13,"containerName":"each_seq","name":"$b"},{"line":1299,"kind":13,"containerName":"each_seq","name":"$self"}],"detail":"($self)","definition":"sub"},{"name":"@arr","containerName":null,"kind":13,"line":1300},{"containerName":null,"kind":13,"name":"%self","line":1300},{"line":1300,"kind":13,"containerName":null,"name":"%seqID"},{"name":"@arr","containerName":null,"kind":13,"line":1303},{"containerName":"main::","name":"each_alphabetically","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"each_alphabetically","line":1322},{"name":"$self","containerName":"each_alphabetically","kind":13,"line":1323},{"name":"throw_not_implemented","kind":12,"containerName":"each_alphabetically","line":1323}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":1321,"character":0},"end":{"character":9999,"line":1324}},"line":1321,"signature":{"label":"each_alphabetically($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :"}},{"line":1341,"range":{"start":{"line":1341,"character":0},"end":{"line":1344,"character":9999}},"kind":12,"signature":{"label":"each_seq_with_id($self)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :\n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $contig->each_seq_with_id() )\n Function  :\n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name","parameters":[{"label":"$self"}]},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"each_seq_with_id","line":1342,"definition":"my"},{"kind":13,"containerName":"each_seq_with_id","name":"$self","line":1343},{"line":1343,"containerName":"each_seq_with_id","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"each_seq_with_id","definition":"sub","detail":"($self)"},{"children":[{"line":1362,"localvar":"my","containerName":"get_seq_by_pos","kind":13,"name":"$self","definition":"my"},{"definition":"my","line":1363,"name":"$pos","kind":13,"localvar":"my","containerName":"get_seq_by_pos"},{"containerName":"get_seq_by_pos","kind":13,"name":"$self","line":1365},{"name":"throw","containerName":"get_seq_by_pos","kind":12,"line":1365},{"name":"$pos","containerName":"get_seq_by_pos","kind":13,"line":1366},{"line":1366,"containerName":"get_seq_by_pos","kind":13,"name":"$pos"},{"name":"$self","containerName":"get_seq_by_pos","kind":13,"line":1367},{"line":1367,"name":"throw","containerName":"get_seq_by_pos","kind":12},{"kind":13,"containerName":"get_seq_by_pos","name":"$pos","line":1368},{"name":"$self","containerName":"get_seq_by_pos","kind":13,"line":1368},{"kind":12,"containerName":"get_seq_by_pos","name":"num_sequences","line":1368},{"definition":"my","name":"$seqID","localvar":"my","containerName":"get_seq_by_pos","kind":13,"line":1370},{"line":1370,"containerName":"get_seq_by_pos","kind":13,"name":"$self"},{"name":"$pos","kind":13,"containerName":"get_seq_by_pos","line":1370},{"line":1371,"name":"$self","kind":13,"containerName":"get_seq_by_pos"},{"kind":13,"containerName":"get_seq_by_pos","name":"$seqID","line":1371}],"name":"get_seq_by_pos","containerName":"main::","definition":"sub","detail":"($pos)","line":1361,"kind":12,"range":{"end":{"character":9999,"line":1372},"start":{"line":1361,"character":0}},"signature":{"label":"get_seq_by_pos($pos)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :\n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $contig->each_seq_with_id() )\n Function  :\n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $contig->get_seq_by_pos(3)\n Function  :\n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will thow an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence osition","parameters":[{"label":"$pos"}]}},{"children":[{"definition":"my","line":1396,"name":"$self","localvar":"my","kind":13,"containerName":"select"},{"line":1397,"kind":13,"containerName":"select","name":"$self"},{"line":1397,"name":"throw_not_implemented","kind":12,"containerName":"select"}],"containerName":"main::","name":"select","definition":"sub","detail":"($self)","line":1395,"kind":12,"range":{"end":{"line":1398,"character":9999},"start":{"character":0,"line":1395}},"signature":{"label":"select($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :\n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $contig->each_seq_with_id() )\n Function  :\n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $contig->get_seq_by_pos(3)\n Function  :\n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will thow an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence osition\n\n\nsub get_seq_by_pos {\n    my $self = shift;\n    my ($pos) = @_;\n\n    $self->throw(\"Sequence position has to be a positive integer, not [$pos]\")\n        unless $pos =~ /^\\d+$/ and $pos > 0;\n    $self->throw(\"No sequence at position [$pos]\")\n        unless $pos <= $self->num_sequences ;\n\n    my $seqID = $self->{'_order'}->{--$pos};\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $contig2 = $contig->select(1, 3) # three first sequences\n Function  :\n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)"}},{"signature":{"label":"select_noncont($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :\n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $contig->each_seq_with_id() )\n Function  :\n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $contig->get_seq_by_pos(3)\n Function  :\n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will thow an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence osition\n\n\nsub get_seq_by_pos {\n    my $self = shift;\n    my ($pos) = @_;\n\n    $self->throw(\"Sequence position has to be a positive integer, not [$pos]\")\n        unless $pos =~ /^\\d+$/ and $pos > 0;\n    $self->throw(\"No sequence at position [$pos]\")\n        unless $pos <= $self->num_sequences ;\n\n    my $seqID = $self->{'_order'}->{--$pos};\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $contig2 = $contig->select(1, 3) # three first sequences\n Function  :\n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $contig2 = $contig->select_noncont(1, 3) # first and 3rd sequences\n Function  :\n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Args      : array of integers for the sequences"},"line":1416,"range":{"end":{"character":9999,"line":1419},"start":{"line":1416,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"line":1417,"localvar":"my","kind":13,"containerName":"select_noncont","name":"$self","definition":"my"},{"line":1418,"containerName":"select_noncont","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"select_noncont","line":1418}],"name":"select_noncont","containerName":"main::"},{"detail":"($self)","definition":"sub","name":"slice","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"slice","line":1440,"definition":"my"},{"name":"$self","kind":13,"containerName":"slice","line":1441},{"line":1441,"kind":12,"containerName":"slice","name":"throw_not_implemented"}],"signature":{"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :\n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $contig->each_seq_with_id() )\n Function  :\n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $contig->get_seq_by_pos(3)\n Function  :\n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will thow an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence osition\n\n\nsub get_seq_by_pos {\n    my $self = shift;\n    my ($pos) = @_;\n\n    $self->throw(\"Sequence position has to be a positive integer, not [$pos]\")\n        unless $pos =~ /^\\d+$/ and $pos > 0;\n    $self->throw(\"No sequence at position [$pos]\")\n        unless $pos <= $self->num_sequences ;\n\n    my $seqID = $self->{'_order'}->{--$pos};\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $contig2 = $contig->select(1, 3) # three first sequences\n Function  :\n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $contig2 = $contig->select_noncont(1, 3) # first and 3rd sequences\n Function  :\n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $contig2 = $contig->slice(20, 30)\n Function  :\n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for start column\n             positive integer for end column","parameters":[{"label":"$self"}],"label":"slice($self)"},"range":{"end":{"character":9999,"line":1442},"start":{"character":0,"line":1439}},"kind":12,"line":1439},{"range":{"end":{"character":9999,"line":1472},"start":{"line":1469,"character":0}},"kind":12,"line":1469,"signature":{"label":"map_chars($self)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :\n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $contig->each_seq_with_id() )\n Function  :\n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $contig->get_seq_by_pos(3)\n Function  :\n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will thow an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence osition\n\n\nsub get_seq_by_pos {\n    my $self = shift;\n    my ($pos) = @_;\n\n    $self->throw(\"Sequence position has to be a positive integer, not [$pos]\")\n        unless $pos =~ /^\\d+$/ and $pos > 0;\n    $self->throw(\"No sequence at position [$pos]\")\n        unless $pos <= $self->num_sequences ;\n\n    my $seqID = $self->{'_order'}->{--$pos};\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $contig2 = $contig->select(1, 3) # three first sequences\n Function  :\n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $contig2 = $contig->select_noncont(1, 3) # first and 3rd sequences\n Function  :\n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $contig2 = $contig->slice(20, 30)\n Function  :\n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for start column\n             positive integer for end column\n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changeing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $contig->map_chars('\\.','-')\n Function  :\n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpretted as a regex,\n             so be careful about quoting meta characters (eg\n             $contig->map_chars('.','-') wont do what you want)\n\n Returns   :\n Argument  : 'from' rexexp\n             'to' string","parameters":[{"label":"$self"}]},"name":"map_chars","containerName":"main::","children":[{"line":1470,"localvar":"my","containerName":"map_chars","kind":13,"name":"$self","definition":"my"},{"containerName":"map_chars","kind":13,"name":"$self","line":1471},{"line":1471,"kind":12,"containerName":"map_chars","name":"throw_not_implemented"}],"detail":"($self)","definition":"sub"},{"signature":{"label":"uppercase($self)","documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is only one feature class that some methods in\nBio::Assembly::Contig expect to find in the feature collection: features\nwith primary tags of the form '_aligned_coord:$seqID', where $seqID is\nthe aligned sequence id (like returned by $seq-E<gt>id()). These features\ndescribe the position (in \"gapped consensus\" coordinates) of aligned\nsequences, and the method set_seq_coord() automatically changes a\nfeature's primary tag to this form whenever the feature is added to\nthe collection by this method. Only two methods in Bio::Assembly::Contig\nwill not work unless there are features from this class:\nchange_coord() and get_seq_coord().\n\nOther feature classes will be automatically available only when\nBio::Assembly::Contig objects are created by a specific module. Such\nfeature classes are (or should be) documented in the documentation of\nthe module which create them, to which the user should refer.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Assembly::Contig;\n\nuse strict;\n\nuse Bio::SeqFeature::Collection;\nuse Bio::Seq::PrimaryQual;\n\nuse Scalar::Util qw(weaken);\n\nuse base qw(Bio::Root::Root Bio::Align::AlignI);\n\n=head1 Object creator\n\n=head2 new\n\n Title     : new\n Usage     : my $contig = Bio::Assembly::Contig->new();\n Function  : Creates a new contig object\n Returns   : Bio::Assembly::Contig\n Args      : -id => contig unique ID\n             -source => string for the sequence assembly program used\n             -collection => Bio::SeqFeature::Collection instance\n\n\n#-----------\nsub new {\n#-----------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($src, $id, $collection) = $self->_rearrange([qw(SOURCE ID COLLECTION)], @args);\n    $src && $self->source($src);\n    ($id && $self->id($id)) || ($self->{'_id'} = 'NoName'); # Alignment (contig) name\n    ($id && $self->id($id)) || ($self->{'_source'} = 'Unknown'); # Program used to build the contig\n    # we need to set up internal hashes first!\n\n    # Bio::SimpleAlign derived fields (check which ones are needed for AlignI compatibility)\n    $self->{'_elem'} = {}; # contig elements: aligned sequence objects (keyed by ID)\n    $self->{'_order'} = {}; # store sequence order\n    # $self->{'start_end_lists'} = {}; # References to entries in {'_seq'}. Keyed by seq ids.\n    # $self->{'_dis_name'} = {}; # Display names for each sequence\n    $self->{'_symbols'} = {}; # List of symbols\n\n    #Contig specific slots\n    $self->{'_consensus_sequence'} = undef;\n    $self->{'_consensus_quality'} = undef;\n    $self->{'_nof_residues'} = 0;\n    $self->{'_nof_seqs'} = 0;\n    # $self->{'_nof_segments'} = 0; # Let's not make it heavier than needed by now...\n    \n    # for cases where SF::Collection is shared between Bio::Assembly::Contig \n    if ($collection) {\n        $self->throw(\"Collection must implement Bio::SeqFeature::CollectionI\") unless $collection->isa('Bio::SeqFeature::CollectionI');\n        $self->{'_sfc'} = $collection;\n    } else {\n        $self->{'_sfc'} = Bio::SeqFeature::Collection->new()\n    }\n\n    # Assembly specifics\n    $self->{'_assembly'} = undef; # Reference to a Bio::Assembly::Scaffold object, if contig belongs to one.\n    $self->{'_strand'} = 0; # Reverse (-1) or forward (1), if contig is in a scaffold. 0 otherwise\n    $self->{'_neighbor_start'} = undef; # Will hold a reference to another contig\n    $self->{'_neighbor_end'} = undef; # Will hold a reference to another contig\n\n    return $self; # success - we hope!\n}\n\n=head1 Assembly related methods\n\nThese methods exist to enable adding information about possible\nrelations among contigs, e.g. when you already have a scaffold for\nyour assembly, describing the ordering of contigs in the final\nassembly, but no sequences covering the gaps between neighboring\ncontigs.\n\n=head2 source\n\n Title     : source\n Usage     : $contig->source($program);\n Function  : Get/Set program used to build this contig\n Returns   : string\n Argument  : [optional] string\n\n\nsub source {\n    my $self = shift;\n    my $source = shift;\n\n    $self->{'_source'} = $source if (defined $source);\n    return $self->{'_source'};\n}\n\n=head2 assembly\n\n Title     : assembly\n Usage     : $contig->assembly($assembly);\n Function  : Get/Set assembly object for this contig\n Returns   : a Bio::Assembly::Scaffold object\n Argument  : a Bio::Assembly::Scaffold object\n\n\nsub assembly {\n    my $self = shift;\n    my $assembly = shift;\n\n    $self->throw(\"Using non Bio::Assembly::Scaffold object when assign contig to assembly\")\n    if (defined $assembly && ! $assembly->isa(\"Bio::Assembly::Scaffold\"));\n    # We create a circular reference to a Scaffold object. It is made weak\n    # to prevent memory leaks.\n    $self->{'_assembly'} = $assembly if (defined $assembly); \n    weaken($self->{'_assembly'});\n\n    return $self->{'_assembly'};\n}\n\n=head2 strand\n\n Title     : strand\n Usage     : $contig->strand($num);\n Function  : Get/Set contig orientation in a scaffold/assembly.\n             Its equivalent to the strand property of sequence\n             objects and sets whether the contig consensus should\n             be reversed and complemented before being added to a\n             scaffold or assembly.\n Returns   : integer\n Argument  : 1 if orientaion is forward, -1 if reverse and\n             0 if none\n\n\nsub strand {\n    my $self = shift;\n    my $ori = shift;\n\n    if (defined $ori) {\n        $self->throw(\"Contig strand must be either 1, -1 or 0\")\n            unless $ori == 1 || $ori == 0 || $ori == -1;\n        $self->{'_strand'} = $ori;\n    }\n\n    return $self->{'_strand'};\n}\n\n=head2 upstream_neighbor\n\n Title     : upstream_neighbor\n Usage     : $contig->upstream_neighbor($contig);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The upstream neighbor is\n             located before $contig first base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub upstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to upstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n\n    $self->{'_neighbor_start'} = $ref if (defined $ref);\n    return $self->{'_neighbor_start'};\n}\n\n=head2 downstream_neighbor\n\n Title     : downstream_neighbor\n Usage     : $contig->downstream_neighbor($num);\n Function  : Get/Set a contig neighbor for the current contig when\n             building a scaffold. The downstream neighbor is\n             located after $contig last base\n Returns   : nothing\n Argument  : Bio::Assembly::Contig\n\n\nsub downstream_neighbor {\n    my $self = shift;\n    my $ref = shift;\n\n    $self->throw(\"Trying to assign a non Bio::Assembly::Contig object to downstream contig\")\n        if (defined $ref && ! $ref->isa(\"Bio::Assembly::Contig\"));\n    $self->{'_neighbor_end'} = $ref if (defined $ref);\n    return $self->{'_neighbor_end'};\n}\n\n=head1 Contig feature collection methods\n\n=head2 add_features\n\n Title     : add_features\n Usage     : $contig->add_features($feat,$flag)\n Function  :\n\n             Add an array of features to the contig feature\n             collection. The consensus sequence may be attached to the\n             added feature, if $flag is set to 1. If $flag is 0 and\n             the feature attached to one of the contig aligned\n             sequences, the feature is registered as an aligned\n             sequence feature. If $flag is 0 and the feature is not\n             attched to any sequence in the contig, the feature is\n             simply added to the feature collection and no attachment\n             or registration is made.\n\n             Note: You must attach aligned sequences to their features\n             prior to calling add_features, otherwise you won't be\n             able to access the feature through get_seq_feat_by_tag()\n             method.\n\n Returns   : number of features added.\n Argument  :\n             $feat : A reference to an array of Bio::SeqFeatureI\n             $flag : boolean - true if consensus sequence object\n                     should be attached to this feature, false if\n                     no consensus attachment should be made.\n                     Default: false.\n\n\nsub add_features {\n    my ($self, $args, $flag) = @_;\n\n    # Adding shortcuts for aligned sequence features\n    $flag = 0 unless (defined $flag);\n    if ($flag && defined $self->{'_consensus_sequence'}) {\n        foreach my $feat (@$args) {\n            next if (defined $feat->seq);\n            $feat->attach_seq($self->{'_consensus_sequence'});\n        }\n    } elsif (!$flag) { # Register aligned sequence features\n        foreach my $feat (@$args) {\n            if (my $seq = $feat->entire_seq()) {\n                my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n                $self->warn(\"Adding contig feature attached to unknown sequence $seqID!\")\n                    unless (exists $self->{'_elem'}{$seqID});\n                my $tag = $feat->primary_tag;\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} = $feat;\n            }\n        }\n    }\n\n    # Add feature to feature collection\n    my $nof_added = $self->{'_sfc'}->add_features($args);\n\n    return $nof_added;\n}\n\n=head2 remove_features\n\n Title     : remove_features\n Usage     : $contig->remove_features(@feat)\n Function  : Remove an array of contig features\n Returns   : number of features removed.\n Argument  : An array of Bio::SeqFeatureI\n\n\nsub remove_features {\n    my ($self, @args) = @_;\n\n    # Removing shortcuts for aligned sequence features\n    foreach my $feat (@args) {\n        if (my $seq = $feat->entire_seq()) {\n            my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n            my $tag = $feat->primary_tag;\n            $tag =~ s/:$seqID$/$1/g;\n            delete( $self->{'_elem'}{$seqID}{'_feat'}{$tag} )\n                if (exists $self->{'_elem'}{$seqID}{'_feat'}{$tag} &&\n                $self->{'_elem'}{$seqID}{'_feat'}{$tag} eq $feat);\n        }\n    }\n    \n    # Removing Bio::SeqFeature::Collection features\n    return $self->{'_sfc'}->remove_features(\\@args);\n}\n\n=head2 get_features_collection\n\n Title     : get_features_collection\n Usage     : $contig->get_features_collection()\n Function  : Get the collection of all contig features\n Returns   : Bio::SeqFeature::Collection\n Argument  : none\n\n\nsub get_features_collection {\n    my $self = shift;\n    return $self->{'_sfc'};\n}\n\n=head2 remove_features_collection\n\n Title     : remove_features_collection\n Usage     : $contig->remove_features_collection()\n Function  : Remove the collection of all contig features. It is useful\n             to save some memory (when contig features are not needed).\n Returns   : none\n Argument  : none\n\n\nsub remove_features_collection {\n    my $self = shift;\n    # Removing shortcuts for aligned sequence features\n    for my $seqID (keys %{$self->{'_elem'}}) {\n        delete $self->{'_elem'}{$seqID};\n    }\n    # Removing Bio::SeqFeature::Collection features\n    $self->{'_sfc'} = {};\n    return;\n}\n\n=head1 Coordinate system's related methods\n\nSee L<Coordinate_Systems> above.\n\n=head2 change_coord\n\n Title     : change_coord\n Usage     : $contig->change_coord($in,$out,$query)\n Function  :\n\n             Change coordinate system for $query.  This method\n             transforms locations between coordinate systems described\n             in section \"Coordinate Systems\" of this document.\n\n             Note: this method will throw an exception when changing\n             coordinates between \"ungapped consensus\" and other\n             systems if consensus sequence was not set. It will also\n             throw exceptions when changing coordinates among aligned\n             sequence, either with or without gaps, and other systems\n             if sequence locations were not set with set_seq_coord().\n\n Returns   : integer\n Argument  :\n             $in    : [string]  input coordinate system\n             $out   : [string]  output coordinate system\n             $query : [integer] a position in a sequence\n\n\nsub change_coord {\n    my $self     = shift;\n    my $type_in  = shift;\n    my $type_out = shift;\n    my $query    = shift;\n\n    # Parsing arguments\n    # Loading read objects (these calls will throw exceptions whether $read_in or\n    # $read_out is not found\n    my ($read_in,$read_out) = (undef,undef);\n    my $in_ID  = ( split(' ',$type_in)  )[1];\n    my $out_ID = ( split(' ',$type_out) )[1];\n\n    if ($in_ID  ne 'consensus') {\n        $read_in  = $self->get_seq_coord( $self->get_seq_by_name($in_ID)  );\n        $self->throw(\"Can't change coordinates without sequence location for $in_ID\")\n            unless (defined $read_in);\n    }\n    if ($out_ID ne 'consensus') {\n        $read_out = $self->get_seq_coord( $self->get_seq_by_name($out_ID) );\n        $self->throw(\"Can't change coordinates without sequence location for $out_ID\")\n            unless (defined $read_out);\n    }\n\n    # Performing transformation between coordinates\n    SWITCH1: {\n\n        # Transformations between contig padded and contig unpadded\n        (($type_in eq 'gapped consensus') && ($type_out eq 'ungapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_padded_unpadded($self->{'_consensus_gaps'}, $query);\n            last SWITCH1;\n        };\n        (($type_in eq 'ungapped consensus') && ($type_out eq 'gapped consensus')) && do {\n            $self->throw(\"Can't use ungapped consensus coordinates without a consensus sequence\")\n                unless (defined $self->{'_consensus_sequence'});\n            $query = &_unpadded_padded($self->{'_consensus_gaps'},$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (padded)\n        (($type_in  eq 'gapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $query - $read_out->start() + 1;\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out  eq 'gapped consensus')) && do {\n            $query = $query + $read_in->start() - 1;\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (padded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^aligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^aligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out padded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)  &&\n        defined($read_out) && ($type_out =~ /^aligned /)) && do {\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in padded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^aligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            my $list_out = $self->{'_elem'}{$out_ID}{'_gaps'};\n            $query = &_padded_unpadded($list_out,$query);\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_out->strand == -1) {\n                my ($length) = $read_out->length();\n                $length = $length - &_nof_gaps($list_out,$length);\n                $query  = $length - $query + 1;\n            }\n            last SWITCH1;\n        };\n        (defined($read_in)  && ($type_in  =~ /^unaligned /) &&\n        defined($read_out) && ($type_out =~ /^aligned /))  && do {\n            my $list_in = $self->{'_elem'}{$in_ID}{'_gaps'};\n            # Changing read orientation if read was reverse complemented when aligned\n            if ($read_in->strand == -1) {\n                my ($length) = $read_in->length();\n                $length = $length - &_nof_gaps($list_in,$length);\n                $query  = $length - $query + 1;\n            }\n            $query = &_unpadded_padded($list_in,$query);\n            if ($read_in ne $read_out) {\n                $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n                $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            }\n            last SWITCH1;\n        };\n\n        # Transformations between seq $read_in unpadded and seq $read_out unpadded\n        (defined($read_in)  && ($type_in  =~ /^unaligned /)    &&\n        defined($read_out) && ($type_out =~ /^unaligned /)) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (padded) and read (unpadded)\n        (($type_in eq 'gapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('gapped consensus',\"aligned $out_ID\",$query);\n            $query = $self->change_coord(\"aligned $out_ID\",\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'gapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",\"aligned $in_ID\",$query);\n            $query = $self->change_coord(\"aligned $in_ID\",'gapped consensus',$query);\n            last SWITCH1;\n        };\n\n        # Transformations between contig (unpadded) and read (unpadded)\n        (($type_in eq 'ungapped consensus') &&\n        ($type_out =~ /^unaligned /) && defined($read_out)) && do {\n            $query = $self->change_coord('ungapped consensus','gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus',\"unaligned $out_ID\",$query);\n            last SWITCH1;\n        };\n        (($type_in =~ /^unaligned /) && defined($read_in) &&\n        ($type_out eq 'ungapped consensus')) && do {\n            $query = $self->change_coord(\"unaligned $in_ID\",'gapped consensus',$query);\n            $query = $self->change_coord('gapped consensus','ungapped consensus',$query);\n            last SWITCH1;\n        };\n\n        $self->throw(\"Unknow coordinate system. Args: $type_in, $type_out.\");\n        $query = undef; # If a coordinate systems just requested is unknown\n    }\n\n    return $query;\n}\n\n=head2 get_seq_coord\n\n Title     : get_seq_coord\n Usage     : $contig->get_seq_coord($seq);\n Function  : Get \"gapped consensus\" location for aligned sequence\n Returns   : Bio::SeqFeature::Generic for coordinates or undef.\n             A warning is printed if sequence coordinates were not set.\n Argument  : Bio::LocatabaleSeq object\n\n\nsub get_seq_coord {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"$seq is not a Bio::LocatableSeq\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    unless (exists( $self->{'_elem'}{$seqID} )) {\n        $self->warn(\"No such sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n    unless (exists( $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} )) {\n        # $self->warn(\"Chad. Location not set for sequence ($seqID) in contig \".$self->id);\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"};\n}\n\n=head2 set_seq_coord\n\n Title     : set_seq_coord\n Usage     : $contig->set_seq_coord($feat,$seq);\n Function  :\n\n             Set \"gapped consensus\" location for an aligned\n             sequence. If the sequence was previously added using\n             add_seq, its coordinates are changed/set.  Otherwise,\n             add_seq is called and the sequence is added to the\n             contig.\n\n Returns   : Bio::SeqFeature::Generic for old coordinates or undef.\n Argument  :\n             $feat  : a Bio::SeqFeature::Generic object\n                      representing a location for the\n                      aligned sequence, in \"gapped\n                      consensus\" coordinates.\n\n             Note: the original feature primary tag will\n                   be lost.\n\n             $seq   : a Bio::LocatabaleSeq object\n\n\nsub set_seq_coord {\n    my ($self,$feat,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    # Complaining about inadequate feature object\n    $self->throw(\"Coordinates must be a Bio::SeqFeature::Generic object!\")\n        unless ( $feat->isa(\"Bio::SeqFeature::Generic\") );\n    $self->throw(\"Sequence coordinates must have an end!\")\n        unless (defined $feat->end);\n    $self->throw(\"Sequence coordinates must have a start!\")\n        unless (defined $feat->start);\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    if (exists( $self->{'_elem'}{$seqID} ) &&\n    exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    defined( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq ne $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Replacing sequence $seqID\\n\");\n        $self->remove_seq($self->{'_elem'}{$seqID}{'_seq'});\n    }\n    $self->add_seq($seq);\n\n    # Remove previous coordinates, if any\n    $self->remove_features($feat);\n\n    # Add new Bio::Generic::SeqFeature\n    $feat->add_tag_value('contig',$self->id)\n        unless ( $feat->has_tag('contig') );\n    $feat->primary_tag(\"_aligned_coord:$seqID\");\n    $feat->attach_seq($seq);\n    $self->{'_elem'}{$seqID}{'_feat'}{\"_aligned_coord:$seqID\"} = $feat;\n    $self->add_features([ $feat ]);\n}\n\n=head1 Bio::Assembly::Contig consensus methods\n\n=head2 set_consensus_sequence\n\n Title     : set_consensus_sequence\n Usage     : $contig->set_consensus_sequence($seq)\n Function  : Set the consensus sequence object for this contig\n Returns   : consensus length\n Argument  : Bio::LocatableSeq\n\n\nsub set_consensus_sequence {\n    my $self = shift;\n    my $seq  = shift;\n\n    $self->throw(\"Consensus sequence must be a Bio::LocatableSeq!\")\n        unless ($seq->isa(\"Bio::LocatableSeq\"));\n\n    $self->{'_consensus_gaps'} = []; # Consensus Gap registry\n    $self->_register_gaps( $seq->seq, $self->{'_consensus_gaps'} );\n    $self->{'_consensus_sequence'} = $seq;\n\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    my $con_len = $seq->length;\n\n    return $con_len;\n}\n\n=head2 set_consensus_quality\n\n Title     : set_consensus_quality\n Usage     : $contig->set_consensus_quality($qual)\n Function  : Set the quality object for consensus sequence\n Returns   : nothing\n Argument  : Bio::Seq::QualI object\n\n\nsub set_consensus_quality {\n    my $self = shift;\n    my $qual  = shift;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::Quality object!\")\n        unless ( $qual->isa(\"Bio::Seq::Quality\") );\n\n    $self->throw(\"Consensus quality can't be added before you set the consensus sequence!\")\n        unless (defined $self->{'_consensus_sequence'});\n\n    $self->{'_consensus_quality'} = $qual;\n}\n\n=head2 get_consensus_length\n\n Title     : get_consensus_length\n Usage     : $contig->get_consensus_length()\n Function  : Get consensus sequence length\n Returns   : integer\n Argument  : none\n\n\nsub get_consensus_length {\n    my $self = shift;\n\n    return $self->{'_consensus_sequence'}->length();\n}\n\n=head2 get_consensus_sequence\n\n Title     : get_consensus_sequence\n Usage     : $contig->get_consensus_sequence()\n Function  : Get a reference to the consensus sequence object\n             for this contig\n Returns   : Bio::SeqI object\n Argument  : none\n\n\nsub get_consensus_sequence {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_sequence'};\n}\n\n=head2 get_consensus_quality\n\n Title     : get_consensus_quality\n Usage     : $contig->get_consensus_quality()\n Function  : Get a reference to the consensus quality object\n             for this contig.\n Returns   : A Bio::QualI object\n Argument  : none\n\n\nsub get_consensus_quality {\n    my ($self, @args) = @_;\n\n    return $self->{'_consensus_quality'};\n}\n\n=head1 Bio::Assembly::Contig aligned sequences methods\n\n=head2 set_seq_qual\n\n Title     : set_seq_qual\n Usage     : $contig->set_seq_qual($seq,$qual);\n Function  : Adds quality to an aligned sequence.\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object and\n             a Bio::Seq::QualI object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub set_seq_qual {\n    my ($self,$seq,$qual) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    $self->throw(\"Consensus quality must be a Bio::Seq::QualI object!\")\n        unless ( $qual->isa(\"Bio::Seq::QualI\") );\n    $self->throw(\"Use add_seq first: aligned sequence qualities can't be added before you load the sequence!\")\n        unless (exists $self->{'_elem'}{$seqID}{'_seq'});\n    $self->throw(\"Use set_seq_coord first: aligned sequence qualities can't be added before you add coordinates for the sequence!\") unless (defined( $self->get_seq_coord($seq) ));\n\n    # Adding gaps to quality object\n    my $sequence = $self->{'_elem'}{$seqID}{'_seq'}->seq();\n    my $tmp = $qual->qual();\n    @{$tmp} = reverse(@{$tmp}) if ($self->get_seq_coord($seq)->strand() == -1);\n    my @quality  = ();\n    my $previous = 0;\n    my $next     = 0;\n    my $i = 0; my $j = 0;\n    while ($i<=$#{$tmp}) {\n        # IF base is a gap, quality is the average for neighbouring sites\n        if (substr($sequence,$j,1) eq '-') {\n            $previous = $tmp->[$i-1] unless ($i == 0);\n            if ($i < $#{$tmp}) {\n                $next = $tmp->[$i+1];\n            } else {\n                $next = 0;\n            }\n            push(@quality,int( ($previous+$next)/2 ));\n        } else {\n            push(@quality,$tmp->[$i]);\n            $i++;\n        }\n        $j++;\n    }\n\n    $self->{'_elem'}{$seqID}{'_qual'} = Bio::Seq::PrimaryQual->new(\n        -qual=>join(\" \",@quality), -id=>$seqID );\n}\n\n=head2 get_seq_ids\n\n Title     : get_seq_ids\n Usage     : $contig->get_seq_ids(-start=>$start,\n                  -end=>$end,\n                  -type=>\"gapped A0QR67B08.b\");\n Function  : Get list of sequence IDs overlapping interval [$start, $end]\n             The default interval is [1,$contig->length]\n             Default coordinate system is \"gapped contig\"\n Returns   : An array\n Argument  : A hash with optional elements:\n             -start : consensus subsequence start\n             -end   : consensus subsequence end\n             -type  : the coordinate system type for $start and $end arguments\n                      Coordinate system avaliable are:\n                      \"gapped consensus\"   : consensus coordinates with gaps\n                      \"ungapped consensus\" : consensus coordinates without gaps\n                      \"aligned $ReadID\"    : read $ReadID coordinates with gaps\n                      \"unaligned $ReadID\"  : read $ReadID coordinates without gaps\n\n\n\nsub get_seq_ids {\n    my ($self, @args) = @_;\n\n    my ($type,$start,$end) =\n    $self->_rearrange([qw(TYPE START END)], @args);\n\n    if (defined($start) && defined($end)) {\n        if (defined($type) && ($type ne 'gapped consensus')) {\n            $start = $self->change_coord($type,'gapped consensus',$start);\n            $end   = $self->change_coord($type,'gapped consensus',$end);\n        }\n\n        my @list = grep { $_->isa(\"Bio::SeqFeature::Generic\") &&\n        ($_->primary_tag =~ /^_aligned_coord:/) }\n        $self->{'_sfc'}->features_in_range( -start=>$start,\n                                            -end=>$end,\n                                            -contain=>0,\n                                            -strandmatch=>'ignore' );\n        @list = map { $_->entire_seq->id } @list;\n        return @list;\n    }\n\n    # Entire aligned sequences list\n    return map { $self->{'_order'}{$_} } sort { $a cmp $b } keys %{ $self->{'_order'} };\n}\n\n=head2 get_seq_feat_by_tag\n\n Title     : get_seq_feat_by_tag\n Usage     : $seq = $contig->get_seq_feat_by_tag($seq,\"_aligned_coord:$seqID\")\n Function  :\n\n             Get a sequence feature based on its primary_tag.\n             When you add\n\n Returns   : a Bio::SeqFeature object\n Argument  : a Bio::LocatableSeq and a string (feature primary tag)\n\n\nsub get_seq_feat_by_tag {\n    my ($self,$seq,$tag) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n\n    return $self->{'_elem'}{$seqID}{'_feat'}{$tag};\n}\n\n=head2 get_seq_by_name\n\n Title     : get_seq_by_name\n Usage     : $seq = $contig->get_seq_by_name('Seq1')\n Function  : Gets a sequence based on its id.\n Returns   : a Bio::LocatableSeq object\n             undef if name is not found\n Argument  : string\n\n\nsub get_seq_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_seq'}) {\n        $self->throw(\"Could not find sequence $seqID in contig \".$self->id);\n    return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 get_qual_by_name\n\n Title     : get_qual_by_name\n Usage     : $seq = $contig->get_qual_by_name('Seq1')\n Function  :\n\n             Gets Bio::Seq::QualI object for a sequence\n             through its id ( as given by $qual->id() ).\n\n Returns   : a Bio::Seq::QualI object.\n             undef if name is not found\n Argument  : string\n\n\nsub get_qual_by_name {\n    my $self = shift;\n    my ($seqID) = @_;\n\n    unless (exists $self->{'_elem'}{$seqID}{'_qual'}) {\n        $self->warn(\"Could not find quality for $seqID in contig!\");\n        return;\n    }\n\n    return $self->{'_elem'}{$seqID}{'_qual'};\n}\n\n=head1 Bio::Align::AlignI compatible methods\n\n=head2 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $contig->add_seq($newseq);\n Function  :\n\n             Adds a sequence to the contig. *Does*\n             *not* align it - just adds it to the\n             hashes.\n\n Returns   : nothing\n Argument  : a Bio::LocatableSeq object\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my $self = shift;\n    my $seq = shift;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    $self->{'_elem'}{$seqID} = {} unless (exists $self->{'_elem'}{$seqID});\n\n    if (exists( $self->{'_elem'}{$seqID}{'_seq'} ) &&\n    ($seq eq $self->{'_elem'}{$seqID}{'_seq'}) ) {\n        $self->warn(\"Adding sequence $seqID, which has already been added\");\n    }\n\n    # Our locatable sequences are always considered to be complete sequences\n    $seq->start(1);\n    $seq->end($seq->_ungapped_len);\n\n    $self->warn(\"Adding non-nucleotidic sequence \".$seqID)\n        if (lc($seq->alphabet) ne 'dna' && lc($seq->alphabet) ne 'rna');\n\n    # build the symbol list for this sequence,\n    # will prune out the gap and missing/match chars\n    # when actually asked for the symbol list in the\n    # symbol_chars\n    if (defined $seq->seq) {\n        map { $self->{'_symbols'}->{$_} = 1; } split(//,$seq->seq);\n    } else {\n        $self->{'_symbols'} = {};\n    }\n\n    my $seq_no = ++$self->{'_nof_seqs'};\n\n    if (ref( $self->{'_elem'}{$seqID}{'_seq'} )) {\n        $self->warn(\"Replacing one sequence [$seqID]\\n\");\n    } else {\n        #print STDERR \"Assigning $seqID to $order\\n\";\n        $self->{'_order'}->{$seq_no} = $seqID;\n        # $self->{'_start_end_lists'}->{$id} = []\n        # unless(exists $self->{'_start_end_lists'}->{$id});\n        # push @{$self->{'_start_end_lists'}->{$id}}, $seq;\n    }\n\n    $self->{'_elem'}{$seqID}{'_seq'}  = $seq;\n    $self->{'_elem'}{$seqID}{'_feat'} = {};\n    $self->{'_elem'}{$seqID}{'_gaps'} = [];\n    my $dbref = $self->{'_elem'}{$seqID}{'_gaps'};\n    my $nofgaps = $self->_register_gaps($seq->seq,$dbref);\n\n    # Updating residue count\n    $self->{'_nof_residues'} += $seq->length - $nofgaps;\n\n    return 1;\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $contig->remove_seq($seq);\n Function  : Removes a single sequence from a contig\n Returns   : 1 on success, 0 otherwise\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self,$seq) = @_;\n\n    if( !ref $seq || ! $seq->isa('Bio::LocatableSeq') ) {\n        $self->throw(\"Unable to process non locatable sequences [\".ref($seq).\"]\");\n    }\n\n    my $seqID = $seq->id() || $seq->display_id || $seq->primary_id;\n    unless (exists $self->{'_elem'}{$seqID} ) {\n        $self->warn(\"No sequence named $seqID  [$seq]\");\n        return 0;\n    }\n\n    # Updating residue count\n    $self->{'_nof_residues'} -= $seq->length() +\n    &_nof_gaps( $self->{'_elem'}{$seqID}{'_gaps'}, $seq->length );\n    \n    # Update number of sequences\n    $self->{'_nof_seqs'}--; \n    \n    # Update order of sequences (order starts at 1)\n    my $max_order = $self->{'_nof_seqs'} + 1;\n    my $target_order = $max_order + 1;\n    for (my $order = 1 ; $order <= $max_order ; $order++) {\n      if ($self->{'_order'}->{$order} eq $seqID) {\n        # Found the wanted sequence order\n        $target_order = $order;\n      }\n      if ($order > $target_order) {\n        # Decrement this sequence order by one order\n        $self->{'_order'}->{$order-1} = $self->{'_order'}->{$order};\n      }\n      if ($order == $max_order) {\n        # Remove last order\n        delete $self->{'_order'}->{$order};\n      }\n    }\n\n    # Remove all references to features of this sequence\n    my @feats = ();\n    for my $tag (keys %{ $self->{'_elem'}{$seqID}{'_feat'} }) {\n        push(@feats, $self->{'_elem'}{$seqID}{'_feat'}{$tag});\n    }\n    $self->{'_sfc'}->remove_features(\\@feats);\n    delete $self->{'_elem'}{$seqID};\n\n    return 1;\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $contig->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $contig->sort_alphabetically\n Function  :\n\n             Changes the order of the alignemnt to alphabetical on name\n             followed by numerical by number.\n\n Returns   :\n Argument  :\n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $contig->each_seq() )\n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  :\n\n\nsub each_seq {\n    my ($self) = @_;\n\n    my (@arr,$seqID);\n\n    foreach $seqID ( map { $self->{'_order'}{$_} } sort { $a <=> $b } keys %{$self->{'_order'}} ) {\n        push(@arr,$self->{'_elem'}{$seqID}{'_seq'});\n    }\n\n    return @arr;\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $contig->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically\n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   :\n Argument  :\n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $contig->each_seq_with_id() )\n Function  :\n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $contig->get_seq_by_pos(3)\n Function  :\n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will thow an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence osition\n\n\nsub get_seq_by_pos {\n    my $self = shift;\n    my ($pos) = @_;\n\n    $self->throw(\"Sequence position has to be a positive integer, not [$pos]\")\n        unless $pos =~ /^\\d+$/ and $pos > 0;\n    $self->throw(\"No sequence at position [$pos]\")\n        unless $pos <= $self->num_sequences ;\n\n    my $seqID = $self->{'_order'}->{--$pos};\n    return $self->{'_elem'}{$seqID}{'_seq'};\n}\n\n=head2 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $contig2 = $contig->select(1, 3) # three first sequences\n Function  :\n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $contig2 = $contig->select_noncont(1, 3) # first and 3rd sequences\n Function  :\n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will thow an error.\n\n Returns   : a Bio::Assembly::Contig object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $contig2 = $contig->slice(20, 30)\n Function  :\n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::Assembly::Contig object\n Argument  : positive integer for start column\n             positive integer for end column\n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changeing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $contig->map_chars('\\.','-')\n Function  :\n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpretted as a regex,\n             so be careful about quoting meta characters (eg\n             $contig->map_chars('.','-') wont do what you want)\n\n Returns   :\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $contig->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   :\n Argument  :","parameters":[{"label":"$self"}]},"line":1484,"kind":12,"range":{"start":{"character":0,"line":1484},"end":{"character":9999,"line":1487}},"definition":"sub","detail":"($self)","children":[{"containerName":"uppercase","localvar":"my","kind":13,"name":"$self","line":1485,"definition":"my"},{"containerName":"uppercase","kind":13,"name":"$self","line":1486},{"name":"throw_not_implemented","containerName":"uppercase","kind":12,"line":1486}],"containerName":"main::","name":"uppercase"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Contig.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Contig\n#   Mostly based on Bio::SimpleAlign by Ewan Birney\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Robson francisco de Souza <rfsouza@citri.iq.usp.br>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Contig - Perl module to hold and manipulate\n                     sequence assembly contigs.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\",\n                               -format=>'phrap');\n\n    $assembly = $aio->next_assembly;\n    foreach $contig ($assembly->all_contigs) {\n      # do something\n    }\n\n    # OR, if you want to build the contig yourself,\n\n    use Bio::Assembly::Contig;\n    $c = Bio::Assembly::Contig->new(-id=>\"1\");\n\n    $ls  = Bio::LocatableSeq->new(-seq=>\"ACCG-T\",\n                                  -id=>\"r1\",\n                                  -alphabet=>'dna');\n    $ls2 = Bio::LocatableSeq->new(-seq=>\"ACA-CG-T\",\n                                  -id=>\"r2\",\n                                  -alphabet=>'dna');\n\n    $ls_coord = Bio::SeqFeature::Generic->new(-start=>3,\n                                              -end=>8,\n                                              -strand=>1);\n    $ls2_coord = Bio::SeqFeature::Generic->new(-start=>1,\n                                               -end=>8,\n                                               -strand=>1);\n    $c->add_seq($ls);\n    $c->add_seq($ls2);\n    $c->set_seq_coord($ls_coord,$ls);\n    $c->set_seq_coord($ls2_coord,$ls2);\n\n    $con = Bio::LocatableSeq->new(-seq=>\"ACACCG-T\",\n                                  -alphabet=>'dna');\n    $c->set_consensus_sequence($con);\n\n    $l = $c->change_coord('unaligned r2','ungapped consensus',6);\n    print \"6 in unaligned r2 => $l in ungapped consensus\\n\";\n\n\n=head1 DESCRIPTION\n\nA contig is as a set of sequences, locally aligned to each other, so\nthat every sequence has overlapping regions with at least one sequence\nin the contig, such that a continuous of overlapping sequences is\nformed, allowing the deduction of a consensus sequence which may be\nlonger than any of the sequences from which it was deduced.\n\nIn this documentation we refer to the overlapping sequences used to\nbuild the contig as \"aligned sequences\" and to the sequence deduced\nfrom the overlap of aligned sequences as the \"consensus\". Methods to\ndeduce the consensus sequence from aligned sequences were not yet\nimplemented in this module, but its posssible to add a consensus\nsequence deduced by other means, e.g, by the assembly program used to\nbuild the alignment.\n\nAll aligned sequences in a Bio::Assembly::Contig must be Bio::Assembly::Locatable\nobjects and have a unique ID. The unique ID restriction is due to the\nnature of the module's internal data structures and is also a request\nof some assembly programs. If two sequences with the same ID are added\nto a contig, the first sequence added is replaced by the second one.\n\n=head2 Coordinate_systems\n\nThere are four base coordinate systems in Bio::Assembly::Contig.  When\nyou need to access contig elements or data that exists on a certain\nrange or location, you may be specifying coordinates in relation to\ndifferent sequences, which may be either the contig consensus or one\nof the aligned sequences that were used to do the assembly.\n\n =========================================================\n          Name           | Referenced sequence\n ---------------------------------------------------------\n   \"gapped consensus\"    | Contig (with gaps)\n   \"ungapped consensus\"  | Contig (without gaps)\n   \"aligned $seqID\"      | sequence $seqID (with gaps)\n   \"unaligned $seqID\"    | sequence $seqID (without gaps)\n =========================================================\n\n\"gapped consensus\" refers to positions in the aligned consensus\nsequence, which is the consensus sequence including the gaps inserted\nto align it agains the aligned sequences that were used to assemble\nthe contig. So, its limits are [ 1, (consensus length + number of gaps\nin consensus) ]\n\n\"ungapped consensus\" is a coordinate system based on the consensus\nsequence, but excluding consensus gaps. This is just the coordinate\nsystem that you have when considering the consensus sequence alone,\ninstead of aligned to other sequences.\n\n\"aligned $seqID\" refers to locations in the sequence $seqID after\nalignment of $seqID against the consensus sequence (reverse\ncomplementing the original sequence, if needed).  Coordinate 1 in\n\"aligned $seqID\" is equivalent to the start location (first base) of\n$seqID in the consensus sequence, just like if the aligned sequence\n$seqID was a feature of the consensus sequence.\n\n\"unaligned $seqID\" is equivalent to a location in the isolated\nsequence, just like you would have when considering the sequence\nalone, out of an alignment.  When changing coordinates from \"aligned\n$seq2\" to \"unaligned $seq2\", if $seq2 was reverse complemented when\nincluded in the alignment, the output coordinates will be reversed to\nfit that fact, i.e. 1 will be changed to length($seq2), 2 will be\nlength($seq)-1 and so on.\n\nAn important note: when you change gap coordinates from a gapped\nsystem (\"gapped consensus\" or \"aligned $seqID\") to a system that does\nnot include gaps (\"ungapped consensus\" or \"unaligned $seqID\"), the\nposition returned will be the first location before all gaps\nneighboring the input location.\n\n=head2 Feature_collection\n\nBio::Assembly::Contig stores much information about a contig in a\nBio::Assembly::SeqFeature::Collection object. Relevant information on the\nalignment is accessed by selecting features based on their primary\ntags (e.g. all features which have a primary tag of the form\n'_aligned_coord:$seqID', where $seqID is an aligned sequence ID, are\ncoordinates for sequences in the contig alignment) and, by using\nmethods from Bio::Assembly::SeqFeature::Collection, it's possible to select\nfeatures by overlap with other features.\n\nWe suggest that you use the primary tags of features as identifiers\nfor feature classes. By convention, features with primary tags\nstarting with a '_' are generated by modules that populate the contig\ndata structure and return the contig object, maybe as part of an\nassembly object, e.g.  drivers from the Bio::Assembly::IO set.\n\nFeatures in the features collection may be associated with particular\naligned sequences. To obtain this, you must attach the sequence to the\nfeature, using attach() seq from Bio::Assembly::SeqFeatureI, before you add the\nfeature to the feature collection. We also suggest to add the sequence\nid to the primary tag, so that is easy to select feature for a\nparticular sequence.\n\nThere is onl