{"vars":[{"line":113,"kind":2,"containerName":"","name":"base"},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":129,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":129},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$self","line":131},{"line":131,"kind":13,"containerName":"new","name":"$class"},{"line":131,"name":"@args","containerName":"new","kind":13},{"definition":"my","name":"$term","kind":13,"localvar":"my","containerName":"new","line":132},{"line":132,"containerName":"new","kind":13,"name":"$name"},{"kind":13,"containerName":"new","name":"$label","line":132},{"name":"$identifier","containerName":"new","kind":13,"line":132},{"name":"$definition","kind":13,"containerName":"new","line":132},{"name":"$ont","containerName":"new","kind":13,"line":132},{"containerName":"new","kind":13,"name":"$tag","line":132},{"line":133,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":133},{"kind":13,"containerName":"new","name":"@args","line":140},{"containerName":"new","kind":13,"name":"$term","line":141},{"line":142,"name":"$self","containerName":"new","kind":13},{"line":142,"name":"term","containerName":"new","kind":12},{"line":142,"name":"$term","containerName":"new","kind":13},{"line":144,"name":"$self","kind":13,"containerName":"new"},{"name":"name","kind":12,"containerName":"new","line":144},{"line":144,"name":"$name","kind":13,"containerName":"new"},{"line":144,"kind":13,"containerName":"new","name":"$label"},{"kind":13,"containerName":"new","name":"$name","line":144},{"line":144,"name":"$label","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":145},{"kind":12,"containerName":"new","name":"identifier","line":145},{"kind":13,"containerName":"new","name":"$identifier","line":145},{"containerName":"new","kind":13,"name":"$identifier","line":145},{"containerName":"new","kind":13,"name":"$self","line":146},{"name":"definition","kind":12,"containerName":"new","line":146},{"line":146,"kind":13,"containerName":"new","name":"$definition"},{"name":"$definition","kind":13,"containerName":"new","line":146},{"line":148,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"ontology","line":148},{"kind":13,"containerName":"new","name":"$ont","line":148},{"line":148,"containerName":"new","kind":13,"name":"$tag"},{"line":148,"name":"$ont","kind":13,"containerName":"new"},{"line":148,"name":"$tag","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":149}],"signature":{"documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"end":{"line":150,"character":9999},"start":{"line":128,"character":0}},"line":128},{"line":131,"name":"SUPER","kind":12,"containerName":"new"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"as_text","name":"$self","line":173},{"line":175,"kind":13,"containerName":"as_text","name":"$self"},{"containerName":"as_text","kind":12,"name":"tagname","line":175},{"kind":13,"containerName":"as_text","name":"$self","line":175},{"kind":12,"containerName":"as_text","name":"name","line":175},{"line":175,"name":"$self","containerName":"as_text","kind":13},{"name":"is_obsolete","kind":12,"containerName":"as_text","line":175}],"containerName":"main::","name":"as_text","signature":{"label":"as_text($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($term,$name,$label,$identifier,$definition,$ont,$tag) =\n\t$self->_rearrange([qw(TERM\n                          NAME\n                          LABEL\n                          IDENTIFIER\n                          DEFINITION\n                          ONTOLOGY\n                          TAGNAME)],\n                      @args);\n    if($term) {\n        $self->term($term);\n    } else {\n        $self->name($name || $label) if $name || $label;\n        $self->identifier($identifier) if $identifier;\n        $self->definition($definition) if $definition;\n    }\n    $self->ontology($ont || $tag) if $ont || $tag;\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: Returns a textual representation of the annotation that\n           this object holds. Presently, it is tag name, name of the\n           term, and the is_obsolete attribute concatenated togather\n           with a delimiter (|).\n\n Returns : string\n Args    : none"},"line":172,"range":{"start":{"character":0,"line":172},"end":{"line":176,"character":9999}},"kind":12},{"name":"%DEFAULT_CB","kind":13,"localvar":"my","containerName":null,"line":195,"definition":"my"},{"line":195,"containerName":"main::","kind":12,"name":"identifier"},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"display_text","line":198},{"kind":13,"containerName":"display_text","name":"$cb","line":198},{"name":"$cb","kind":13,"containerName":"display_text","line":199},{"line":199,"name":"$DEFAULT_CB","containerName":"display_text","kind":13},{"line":200,"kind":13,"containerName":"display_text","name":"$self"},{"line":200,"name":"throw","kind":12,"containerName":"display_text"},{"line":200,"name":"$cb","containerName":"display_text","kind":13},{"line":201,"kind":13,"containerName":"display_text","name":"$cb"},{"line":201,"containerName":"display_text","kind":13,"name":"$self"}],"containerName":"main::","name":"display_text","definition":"sub","detail":"($self,$cb)","line":197,"range":{"end":{"line":202,"character":9999},"start":{"character":0,"line":197}},"kind":12,"signature":{"label":"display_text($self,$cb)","documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}]}},{"range":{"end":{"line":226,"character":9999},"start":{"line":218,"character":0}},"kind":12,"line":218,"signature":{"label":"hash_tree($self)","documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($term,$name,$label,$identifier,$definition,$ont,$tag) =\n\t$self->_rearrange([qw(TERM\n                          NAME\n                          LABEL\n                          IDENTIFIER\n                          DEFINITION\n                          ONTOLOGY\n                          TAGNAME)],\n                      @args);\n    if($term) {\n        $self->term($term);\n    } else {\n        $self->name($name || $label) if $name || $label;\n        $self->identifier($identifier) if $identifier;\n        $self->definition($definition) if $definition;\n    }\n    $self->ontology($ont || $tag) if $ont || $tag;\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: Returns a textual representation of the annotation that\n           this object holds. Presently, it is tag name, name of the\n           term, and the is_obsolete attribute concatenated togather\n           with a delimiter (|).\n\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return $self->tagname().\"|\".$self->name().\"|\".($self->is_obsolete()||'');\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->identifier || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none","parameters":[{"label":"$self"}]},"name":"hash_tree","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"hash_tree","localvar":"my","kind":13,"line":219},{"definition":"my","line":221,"containerName":"hash_tree","localvar":"my","kind":13,"name":"$h"},{"kind":13,"containerName":"hash_tree","name":"$h","line":222},{"kind":13,"containerName":"hash_tree","name":"$self","line":222},{"kind":12,"containerName":"hash_tree","name":"name","line":222},{"line":223,"name":"$h","kind":13,"containerName":"hash_tree"},{"line":223,"containerName":"hash_tree","kind":13,"name":"$self"},{"containerName":"hash_tree","kind":12,"name":"identifier","line":223},{"line":224,"name":"$h","kind":13,"containerName":"hash_tree"},{"name":"$self","kind":13,"containerName":"hash_tree","line":224},{"line":224,"name":"definition","containerName":"hash_tree","kind":12},{"name":"$h","kind":13,"containerName":"hash_tree","line":225},{"name":"$self","kind":13,"containerName":"hash_tree","line":225},{"name":"get_synonyms","kind":12,"containerName":"hash_tree","line":225}],"detail":"($self)","definition":"sub"},{"children":[{"line":247,"containerName":"tagname","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":249,"name":"$self","containerName":"tagname","kind":13},{"line":249,"name":"ontology","kind":12,"containerName":"tagname"},{"line":251,"name":"$ont","containerName":"tagname","localvar":"my","kind":13,"definition":"my"},{"line":251,"name":"$self","containerName":"tagname","kind":13},{"line":251,"kind":12,"containerName":"tagname","name":"ontology"},{"line":252,"name":"$ont","kind":13,"containerName":"tagname"},{"name":"$ont","kind":13,"containerName":"tagname","line":252},{"name":"name","kind":12,"containerName":"tagname","line":252},{"line":252,"kind":13,"containerName":"tagname","name":"$ont"}],"name":"tagname","containerName":"main::","definition":"sub","line":246,"range":{"start":{"line":246,"character":0},"end":{"character":9999,"line":253}},"kind":12},{"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"term","line":275,"definition":"my"},{"containerName":"term","kind":13,"name":"$value","line":275},{"name":"$value","kind":13,"containerName":"term","line":276},{"name":"$self","kind":13,"containerName":"term","line":277},{"line":277,"kind":13,"containerName":"term","name":"$value"},{"line":279,"name":"$self","kind":13,"containerName":"term"},{"line":280,"kind":13,"containerName":"term","name":"$self"},{"line":280,"name":"new","kind":12,"containerName":"term"},{"line":282,"name":"$self","containerName":"term","kind":13}],"name":"term","containerName":"main::","signature":{"label":"term($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($term,$name,$label,$identifier,$definition,$ont,$tag) =\n\t$self->_rearrange([qw(TERM\n                          NAME\n                          LABEL\n                          IDENTIFIER\n                          DEFINITION\n                          ONTOLOGY\n                          TAGNAME)],\n                      @args);\n    if($term) {\n        $self->term($term);\n    } else {\n        $self->name($name || $label) if $name || $label;\n        $self->identifier($identifier) if $identifier;\n        $self->definition($definition) if $definition;\n    }\n    $self->ontology($ont || $tag) if $ont || $tag;\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: Returns a textual representation of the annotation that\n           this object holds. Presently, it is tag name, name of the\n           term, and the is_obsolete attribute concatenated togather\n           with a delimiter (|).\n\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return $self->tagname().\"|\".$self->name().\"|\".($self->is_obsolete()||'');\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->identifier || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n   my ($self) = @_;\n\n   my $h = {};\n   $h->{'name'} = $self->name();\n   $h->{'identifier'} = $self->identifier();\n   $h->{'definition'} = $self->definition();\n   $h->{'synonyms'} = [$self->get_synonyms()];\n}\n\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to AnnotationCollection when adding this object.\n\n           This is aliased to ontology() here.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->ontology(@_) if @_;\n    # if in get mode we need to get the name from the ontology\n    my $ont = $self->ontology();\n    return ref($ont) ? $ont->name() : $ont;\n}\n\n=head1 Methods for Bio::Ontology::TermI compliance\n\n\n=head2 term\n\n Title   : term\n Usage   : $obj->term($newval)\n Function: Get/set the Bio::Ontology::TermI implementing object.\n\n           We implement TermI by composition, and this method sets/gets the\n           object we delegate to.\n Example :\n Returns : value of term (a Bio::Ontology::TermI compliant object)\n Args    : new value (a Bio::Ontology::TermI compliant object, optional)"},"line":274,"kind":12,"range":{"end":{"character":9999,"line":283},"start":{"line":274,"character":0}}},{"line":280,"kind":12,"containerName":"Ontology::Term","name":"Bio"},{"range":{"start":{"line":297,"character":0},"end":{"character":9999,"line":299}},"kind":12,"line":297,"definition":"sub","name":"identifier","containerName":"main::","children":[{"containerName":"identifier","kind":12,"name":"term","line":298},{"name":"identifier","containerName":"identifier","kind":12,"line":298}]},{"line":313,"range":{"start":{"character":0,"line":313},"end":{"character":9999,"line":315}},"kind":12,"definition":"sub","children":[{"line":314,"name":"term","containerName":"name","kind":12},{"name":"name","kind":12,"containerName":"name","line":314}],"containerName":"main::","name":"name"},{"definition":"sub","children":[{"containerName":"definition","kind":12,"name":"term","line":331},{"line":331,"name":"definition","containerName":"definition","kind":12}],"containerName":"main::","name":"definition","line":330,"kind":12,"range":{"end":{"character":9999,"line":332},"start":{"character":0,"line":330}}},{"definition":"sub","children":[{"line":349,"name":"term","containerName":"ontology","kind":12},{"containerName":"ontology","kind":12,"name":"ontology","line":349}],"name":"ontology","containerName":"main::","line":348,"kind":12,"range":{"start":{"character":0,"line":348},"end":{"character":9999,"line":350}}},{"definition":"sub","containerName":"main::","name":"is_obsolete","children":[{"containerName":"is_obsolete","kind":12,"name":"term","line":365},{"containerName":"is_obsolete","kind":12,"name":"is_obsolete","line":365}],"range":{"start":{"character":0,"line":364},"end":{"line":366,"character":9999}},"kind":12,"line":364},{"definition":"sub","children":[{"line":381,"kind":12,"containerName":"comment","name":"term"},{"containerName":"comment","kind":12,"name":"comment","line":381}],"name":"comment","containerName":"main::","line":380,"kind":12,"range":{"end":{"line":382,"character":9999},"start":{"character":0,"line":380}}},{"name":"get_synonyms","containerName":"main::","children":[{"name":"term","kind":12,"containerName":"get_synonyms","line":395},{"kind":12,"containerName":"get_synonyms","name":"get_synonyms","line":395}],"definition":"sub","kind":12,"range":{"end":{"line":396,"character":9999},"start":{"line":394,"character":0}},"line":394},{"definition":"sub","name":"add_synonym","containerName":"main::","children":[{"name":"term","kind":12,"containerName":"add_synonym","line":411},{"name":"add_synonym","containerName":"add_synonym","kind":12,"line":411}],"range":{"start":{"line":410,"character":0},"end":{"character":9999,"line":412}},"kind":12,"line":410},{"range":{"start":{"character":0,"line":425},"end":{"character":9999,"line":427}},"kind":12,"line":425,"containerName":"main::","name":"remove_synonyms","children":[{"line":426,"name":"term","containerName":"remove_synonyms","kind":12},{"line":426,"kind":12,"containerName":"remove_synonyms","name":"remove_synonyms"}],"definition":"sub"},{"line":441,"kind":12,"range":{"end":{"character":9999,"line":445},"start":{"line":441,"character":0}},"children":[{"line":442,"kind":13,"localvar":"my","containerName":"get_dblinks","name":"$self","definition":"my"},{"kind":13,"containerName":"get_dblinks","name":"$self","line":443},{"kind":12,"containerName":"get_dblinks","name":"deprecated","line":443},{"name":"$self","kind":13,"containerName":"get_dblinks","line":444},{"line":444,"name":"term","containerName":"get_dblinks","kind":12},{"kind":12,"containerName":"get_dblinks","name":"get_dbxrefs","line":444}],"name":"get_dblinks","containerName":"main::","definition":"sub"},{"children":[{"line":458,"containerName":"get_dbxrefs","kind":12,"name":"term"},{"name":"get_dbxrefs","containerName":"get_dbxrefs","kind":12,"line":458}],"name":"get_dbxrefs","containerName":"main::","definition":"sub","line":457,"range":{"start":{"character":0,"line":457},"end":{"line":459,"character":9999}},"kind":12},{"definition":"sub","children":[{"definition":"my","line":478,"name":"$self","kind":13,"localvar":"my","containerName":"add_dblink"},{"containerName":"add_dblink","kind":13,"name":"$self","line":479},{"line":479,"kind":12,"containerName":"add_dblink","name":"deprecated"},{"name":"$self","containerName":"add_dblink","kind":13,"line":480},{"line":480,"name":"term","kind":12,"containerName":"add_dblink"},{"kind":12,"containerName":"add_dblink","name":"add_dbxref","line":480}],"name":"add_dblink","containerName":"main::","line":477,"range":{"end":{"character":9999,"line":481},"start":{"character":0,"line":477}},"kind":12},{"line":496,"range":{"start":{"character":0,"line":496},"end":{"line":498,"character":9999}},"kind":12,"children":[{"name":"term","containerName":"add_dbxref","kind":12,"line":497},{"name":"add_dbxref","kind":12,"containerName":"add_dbxref","line":497}],"containerName":"main::","name":"add_dbxref","definition":"sub"},{"definition":"sub","name":"remove_dblinks","containerName":"main::","children":[{"localvar":"my","containerName":"remove_dblinks","kind":13,"name":"$self","line":513,"definition":"my"},{"line":514,"name":"$self","containerName":"remove_dblinks","kind":13},{"line":514,"name":"deprecated","containerName":"remove_dblinks","kind":12},{"line":515,"name":"$self","kind":13,"containerName":"remove_dblinks"},{"containerName":"remove_dblinks","kind":12,"name":"term","line":515},{"line":515,"name":"remove_dbxrefs","kind":12,"containerName":"remove_dblinks"}],"range":{"start":{"character":0,"line":512},"end":{"line":516,"character":9999}},"kind":12,"line":512},{"children":[{"kind":12,"containerName":"remove_dbxrefs","name":"term","line":529},{"line":529,"containerName":"remove_dbxrefs","kind":12,"name":"remove_dbxrefs"}],"name":"remove_dbxrefs","containerName":"main::","definition":"sub","line":528,"kind":12,"range":{"start":{"character":0,"line":528},"end":{"line":530,"character":9999}}},{"line":546,"kind":12,"range":{"start":{"line":546,"character":0},"end":{"line":548,"character":9999}},"definition":"sub","children":[{"containerName":"get_secondary_ids","kind":12,"name":"term","line":547},{"line":547,"containerName":"get_secondary_ids","kind":12,"name":"get_secondary_ids"}],"containerName":"main::","name":"get_secondary_ids"},{"definition":"sub","children":[{"line":564,"kind":12,"containerName":"add_secondary_id","name":"term"},{"name":"add_secondary_id","kind":12,"containerName":"add_secondary_id","line":564}],"containerName":"main::","name":"add_secondary_id","line":563,"range":{"start":{"character":0,"line":563},"end":{"line":565,"character":9999}},"kind":12},{"containerName":"main::","name":"remove_secondary_ids","children":[{"line":579,"kind":12,"containerName":"remove_secondary_ids","name":"term"},{"kind":12,"containerName":"remove_secondary_ids","name":"remove_secondary_ids","line":579}],"definition":"sub","range":{"end":{"character":9999,"line":580},"start":{"line":578,"character":0}},"kind":12,"line":578}],"version":5}