{"vars":[{"line":96,"containerName":"","kind":2,"name":"base"},{"range":{"end":{"character":9999,"line":118},"start":{"character":0,"line":109}},"kind":12,"line":109,"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"name":"new","containerName":"main::","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":110,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":110},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":112,"definition":"my"},{"line":112,"kind":13,"containerName":"new","name":"$class"},{"line":112,"containerName":"new","kind":13,"name":"@args"},{"line":114,"containerName":"new","kind":13,"name":"$self"},{"line":115,"name":"$self","kind":13,"containerName":"new"},{"line":115,"kind":12,"containerName":"new","name":"_typemap"},{"kind":12,"containerName":"new","name":"new","line":115},{"name":"$self","kind":13,"containerName":"new","line":117}],"detail":"($class,@args)","definition":"sub"},{"kind":12,"containerName":"new","name":"SUPER","line":112},{"line":115,"containerName":"Annotation::TypeManager","kind":12,"name":"Bio"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"get_all_annotation_keys","children":[{"definition":"my","containerName":"get_all_annotation_keys","localvar":"my","kind":13,"name":"$self","line":136},{"name":"$self","containerName":"get_all_annotation_keys","kind":13,"line":137}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none","label":"get_all_annotation_keys($self)"},"kind":12,"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":135}},"line":135},{"detail":"($self,@keys)","definition":"sub","containerName":"main::","name":"get_Annotations","children":[{"line":159,"localvar":"my","containerName":"get_Annotations","kind":13,"name":"$self","definition":"my"},{"name":"@keys","containerName":"get_Annotations","kind":13,"line":159},{"definition":"my","line":161,"name":"@anns","kind":13,"localvar":"my","containerName":"get_Annotations"},{"name":"@keys","kind":13,"containerName":"get_Annotations","line":162},{"containerName":"get_Annotations","kind":13,"name":"$self","line":162},{"line":162,"name":"get_all_annotation_keys","containerName":"get_Annotations","kind":12},{"containerName":"get_Annotations","kind":13,"name":"@keys","line":162},{"definition":"my","line":163,"localvar":"my","containerName":"get_Annotations","kind":13,"name":"$key"},{"name":"@keys","containerName":"get_Annotations","kind":13,"line":163},{"line":164,"name":"$self","containerName":"get_Annotations","kind":13},{"line":164,"kind":13,"containerName":"get_Annotations","name":"$key"},{"line":165,"name":"@anns","kind":13,"containerName":"get_Annotations"},{"line":167,"kind":12,"containerName":"get_Annotations","name":"tagname"},{"line":167,"containerName":"get_Annotations","kind":13,"name":"$key"},{"name":"tagname","containerName":"get_Annotations","kind":12,"line":167},{"line":168,"name":"$self","kind":13,"containerName":"get_Annotations"},{"kind":13,"containerName":"get_Annotations","name":"$key","line":168}],"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)","parameters":[{"label":"$self"},{"label":"@keys"}],"label":"get_Annotations($self,@keys)"},"range":{"start":{"character":0,"line":158},"end":{"line":170,"character":9999}},"kind":12,"line":158},{"line":171,"name":"@anns","kind":13,"containerName":null},{"signature":{"label":"get_nested_Annotations($self,@args)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"range":{"start":{"line":199,"character":0},"end":{"line":216,"character":9999}},"line":199,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"get_nested_Annotations","children":[{"name":"$self","localvar":"my","containerName":"get_nested_Annotations","kind":13,"line":200,"definition":"my"},{"line":200,"containerName":"get_nested_Annotations","kind":13,"name":"@args"},{"line":201,"name":"$keys","containerName":"get_nested_Annotations","localvar":"my","kind":13,"definition":"my"},{"line":201,"containerName":"get_nested_Annotations","kind":13,"name":"$recursive"},{"line":201,"containerName":"get_nested_Annotations","kind":13,"name":"$self"},{"kind":12,"containerName":"get_nested_Annotations","name":"_rearrange","line":201},{"line":201,"containerName":"get_nested_Annotations","kind":13,"name":"@args"},{"line":202,"name":"$self","containerName":"get_nested_Annotations","kind":13},{"kind":12,"containerName":"get_nested_Annotations","name":"verbose","line":202},{"definition":"my","line":204,"containerName":"get_nested_Annotations","localvar":"my","kind":13,"name":"@anns"},{"containerName":"get_nested_Annotations","kind":13,"name":"$recursive","line":206},{"definition":"my","line":207,"name":"@keys","localvar":"my","kind":13,"containerName":"get_nested_Annotations"},{"name":"$keys","kind":13,"containerName":"get_nested_Annotations","line":207},{"line":207,"kind":13,"containerName":"get_nested_Annotations","name":"$self"},{"name":"get_all_annotation_keys","containerName":"get_nested_Annotations","kind":12,"line":207},{"definition":"my","name":"$key","localvar":"my","containerName":"get_nested_Annotations","kind":13,"line":208},{"kind":13,"containerName":"get_nested_Annotations","name":"@keys","line":208},{"line":209,"name":"$self","containerName":"get_nested_Annotations","kind":13},{"kind":13,"containerName":"get_nested_Annotations","name":"$key","line":209},{"kind":13,"containerName":"get_nested_Annotations","name":"@anns","line":210},{"line":212,"name":"tagname","kind":12,"containerName":"get_nested_Annotations"},{"line":212,"name":"$key","kind":13,"containerName":"get_nested_Annotations"},{"line":212,"name":"tagname","containerName":"get_nested_Annotations","kind":12},{"line":213,"name":"$self","kind":13,"containerName":"get_nested_Annotations"},{"name":"$key","kind":13,"containerName":"get_nested_Annotations","line":213}]},{"name":"@allkeys","localvar":"my","containerName":null,"kind":13,"line":219,"definition":"my"},{"line":219,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"get_all_annotation_keys","line":219},{"line":220,"containerName":null,"localvar":"my","kind":13,"name":"$key","definition":"my"},{"kind":13,"containerName":null,"name":"@allkeys","line":220},{"line":221,"kind":13,"localvar":"my","containerName":null,"name":"$keymatch","definition":"my"},{"definition":"my","line":222,"kind":13,"localvar":"my","containerName":null,"name":"%searchkey"},{"kind":13,"containerName":null,"name":"$key","line":223},{"line":223,"containerName":null,"kind":13,"name":"%searchkey"},{"name":"$keymatch","kind":13,"containerName":null,"line":223},{"line":225,"name":"%keymatch","kind":13,"containerName":null},{"line":226,"name":"%self","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%key","line":226},{"line":227,"name":"@anns","kind":13,"containerName":null},{"line":229,"containerName":"main::","kind":12,"name":"tagname"},{"name":"$key","containerName":null,"kind":13,"line":229},{"name":"tagname","containerName":"main::","kind":12,"line":229},{"line":230,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%key","line":230},{"line":234,"name":"@annotations","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":234,"name":"%self","containerName":null,"kind":13},{"line":234,"name":"$key","kind":13,"containerName":null},{"line":235,"name":"@annotations","kind":13,"containerName":null},{"line":236,"containerName":"main::","kind":12,"name":"isa"},{"line":237,"containerName":null,"kind":13,"name":"@anns"},{"name":"get_nested_Annotations","containerName":"main::","kind":12,"line":238},{"line":238,"name":"$keys","containerName":null,"kind":13},{"line":245,"kind":13,"containerName":null,"name":"@anns"},{"children":[{"line":270,"name":"$self","containerName":"get_all_Annotations","localvar":"my","kind":13,"definition":"my"},{"containerName":"get_all_Annotations","kind":13,"name":"@keys","line":270},{"line":273,"containerName":"get_all_Annotations","kind":12,"name":"isa"},{"line":274,"name":"get_all_Annotations","containerName":"get_all_Annotations","kind":12},{"kind":13,"containerName":"get_all_Annotations","name":"$self","line":275},{"containerName":"get_all_Annotations","kind":12,"name":"get_Annotations","line":275},{"kind":13,"containerName":"get_all_Annotations","name":"@keys","line":275}],"name":"get_all_Annotations","containerName":"main::","definition":"sub","detail":"($self,@keys)","line":269,"range":{"end":{"line":276,"character":9999},"start":{"character":0,"line":269}},"kind":12,"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)","parameters":[{"label":"$self"},{"label":"@keys"}],"label":"get_all_Annotations($self,@keys)"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none","label":"get_num_of_annotations($self)"},"line":290,"kind":12,"range":{"end":{"line":293,"character":9999},"start":{"line":290,"character":0}},"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","containerName":"get_num_of_annotations","localvar":"my","kind":13,"line":291},{"localvar":"my","kind":13,"containerName":"get_num_of_annotations","name":"$count","line":292,"definition":"my"},{"line":293,"kind":13,"containerName":"get_num_of_annotations","name":"$count"},{"line":293,"kind":13,"containerName":"get_num_of_annotations","name":"$_"},{"kind":13,"containerName":"get_num_of_annotations","name":"$self","line":293}],"name":"get_num_of_annotations","containerName":"main::"},{"kind":13,"containerName":null,"name":"$count","line":294},{"children":[{"definition":"my","line":326,"localvar":"my","kind":13,"containerName":"add_Annotation","name":"$self"},{"line":326,"containerName":"add_Annotation","kind":13,"name":"$key"},{"line":326,"name":"$object","kind":13,"containerName":"add_Annotation"},{"name":"$archetype","containerName":"add_Annotation","kind":13,"line":326},{"line":329,"kind":13,"containerName":"add_Annotation","name":"$key"},{"line":329,"containerName":"add_Annotation","kind":13,"name":"$key"},{"line":329,"name":"isa","kind":12,"containerName":"add_Annotation"},{"kind":13,"containerName":"add_Annotation","name":"$object","line":329},{"containerName":"add_Annotation","kind":13,"name":"$archetype","line":330},{"line":330,"name":"$object","containerName":"add_Annotation","kind":13},{"name":"$object","containerName":"add_Annotation","kind":13,"line":330},{"containerName":"add_Annotation","kind":13,"name":"$object","line":331},{"name":"$key","kind":13,"containerName":"add_Annotation","line":331},{"kind":13,"containerName":"add_Annotation","name":"$key","line":332},{"containerName":"add_Annotation","kind":13,"name":"$object","line":332},{"line":332,"name":"tagname","kind":12,"containerName":"add_Annotation"},{"line":333,"kind":13,"containerName":"add_Annotation","name":"$key"},{"line":333,"containerName":"add_Annotation","kind":13,"name":"$key"},{"line":333,"kind":12,"containerName":"add_Annotation","name":"name"},{"line":333,"name":"$key","kind":13,"containerName":"add_Annotation"},{"line":334,"name":"$self","containerName":"add_Annotation","kind":13},{"line":334,"kind":12,"containerName":"add_Annotation","name":"throw"},{"name":"$key","containerName":"add_Annotation","kind":13,"line":335},{"kind":13,"containerName":"add_Annotation","name":"$object","line":338},{"containerName":"add_Annotation","kind":13,"name":"$self","line":339},{"name":"throw","containerName":"add_Annotation","kind":12,"line":339},{"name":"$object","kind":13,"containerName":"add_Annotation","line":342},{"containerName":"add_Annotation","kind":13,"name":"$self","line":343},{"line":343,"kind":12,"containerName":"add_Annotation","name":"throw"},{"line":346,"kind":13,"containerName":"add_Annotation","name":"$object"},{"containerName":"add_Annotation","kind":12,"name":"isa","line":346},{"containerName":"add_Annotation","kind":13,"name":"$self","line":347},{"name":"throw","kind":12,"containerName":"add_Annotation","line":347},{"kind":13,"containerName":"add_Annotation","name":"$archetype","line":353},{"containerName":"add_Annotation","kind":13,"name":"$archetype","line":354},{"name":"$object","containerName":"add_Annotation","kind":13,"line":354},{"definition":"my","name":"$stored_map","containerName":"add_Annotation","localvar":"my","kind":13,"line":358},{"name":"$self","containerName":"add_Annotation","kind":13,"line":358},{"kind":12,"containerName":"add_Annotation","name":"_typemap","line":358},{"line":358,"kind":12,"containerName":"add_Annotation","name":"type_for_key"},{"kind":13,"containerName":"add_Annotation","name":"$key","line":358},{"line":360,"kind":13,"containerName":"add_Annotation","name":"$stored_map"},{"containerName":"add_Annotation","kind":13,"name":"$self","line":364},{"name":"_typemap","kind":12,"containerName":"add_Annotation","line":364},{"line":364,"containerName":"add_Annotation","kind":12,"name":"is_valid"},{"kind":13,"containerName":"add_Annotation","name":"$key","line":364},{"name":"$object","containerName":"add_Annotation","kind":13,"line":364},{"name":"$self","containerName":"add_Annotation","kind":13,"line":365},{"kind":12,"containerName":"add_Annotation","name":"throw","line":365},{"kind":13,"containerName":"add_Annotation","name":"$self","line":370},{"kind":12,"containerName":"add_Annotation","name":"_typemap","line":370},{"line":370,"name":"_add_type_map","kind":12,"containerName":"add_Annotation"},{"line":370,"containerName":"add_Annotation","kind":13,"name":"$key"},{"kind":13,"containerName":"add_Annotation","name":"$archetype","line":370},{"name":"$self","containerName":"add_Annotation","kind":13,"line":375},{"name":"$key","containerName":"add_Annotation","kind":13,"line":375},{"line":376,"kind":13,"containerName":"add_Annotation","name":"$self"},{"line":376,"name":"$key","containerName":"add_Annotation","kind":13},{"line":379,"name":"$self","kind":13,"containerName":"add_Annotation"},{"kind":13,"containerName":"add_Annotation","name":"$key","line":379}],"containerName":"main::","name":"add_Annotation","definition":"sub","detail":"($self,$key,$object,$archetype)","line":325,"kind":12,"range":{"start":{"character":0,"line":325},"end":{"character":9999,"line":379}},"signature":{"label":"add_Annotation($self,$key,$object,$archetype)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$object"},{"label":"$archetype"}]}},{"containerName":null,"kind":13,"name":"$object","line":379},{"range":{"end":{"character":9999,"line":410},"start":{"line":399,"character":0}},"kind":12,"line":399,"signature":{"label":"remove_Annotations($self,@keys)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)","parameters":[{"label":"$self"},{"label":"@keys"}]},"containerName":"main::","name":"remove_Annotations","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"remove_Annotations","line":400,"definition":"my"},{"line":400,"containerName":"remove_Annotations","kind":13,"name":"@keys"},{"name":"@keys","kind":13,"containerName":"remove_Annotations","line":402},{"name":"$self","containerName":"remove_Annotations","kind":13,"line":402},{"containerName":"remove_Annotations","kind":12,"name":"get_all_annotation_keys","line":402},{"line":402,"name":"@keys","containerName":"remove_Annotations","kind":13},{"line":403,"name":"@anns","containerName":"remove_Annotations","localvar":"my","kind":13,"definition":"my"},{"line":403,"kind":13,"containerName":"remove_Annotations","name":"$self"},{"containerName":"remove_Annotations","kind":12,"name":"get_Annotations","line":403},{"line":403,"name":"@keys","kind":13,"containerName":"remove_Annotations"},{"line":405,"localvar":"my","kind":13,"containerName":"remove_Annotations","name":"$key","definition":"my"},{"line":405,"kind":13,"containerName":"remove_Annotations","name":"@keys"},{"kind":13,"containerName":"remove_Annotations","name":"$self","line":406},{"line":406,"name":"$key","containerName":"remove_Annotations","kind":13},{"line":407,"name":"$self","kind":13,"containerName":"remove_Annotations"},{"name":"$key","containerName":"remove_Annotations","kind":13,"line":407},{"name":"@anns","kind":13,"containerName":"remove_Annotations","line":409}],"detail":"($self,@keys)","definition":"sub"},{"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given","parameters":[{"label":"$self"},{"label":"@keys"}],"label":"flatten_Annotations($self,@keys)"},"kind":12,"range":{"end":{"character":9999,"line":441},"start":{"character":0,"line":432}},"line":432,"detail":"($self,@keys)","definition":"sub","name":"flatten_Annotations","containerName":"main::","children":[{"line":433,"localvar":"my","kind":13,"containerName":"flatten_Annotations","name":"$self","definition":"my"},{"line":433,"name":"@keys","kind":13,"containerName":"flatten_Annotations"},{"definition":"my","name":"@anns","localvar":"my","kind":13,"containerName":"flatten_Annotations","line":435},{"line":435,"name":"$self","kind":13,"containerName":"flatten_Annotations"},{"containerName":"flatten_Annotations","kind":12,"name":"get_all_Annotations","line":435},{"line":435,"name":"@keys","containerName":"flatten_Annotations","kind":13},{"definition":"my","localvar":"my","containerName":"flatten_Annotations","kind":13,"name":"@origanns","line":436},{"kind":13,"containerName":"flatten_Annotations","name":"$self","line":436},{"line":436,"name":"remove_Annotations","kind":12,"containerName":"flatten_Annotations"},{"line":436,"name":"@keys","containerName":"flatten_Annotations","kind":13},{"line":437,"name":"@anns","kind":13,"containerName":"flatten_Annotations"},{"name":"$self","containerName":"flatten_Annotations","kind":13,"line":438},{"line":438,"name":"add_Annotation","kind":12,"containerName":"flatten_Annotations"},{"name":"@origanns","kind":13,"containerName":"flatten_Annotations","line":440}]},{"line":462,"kind":12,"range":{"end":{"line":476,"character":9999},"start":{"character":0,"line":462}},"children":[{"line":463,"containerName":"as_text","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":465,"name":"$txt","localvar":"my","containerName":"as_text","kind":13,"definition":"my"},{"line":466,"name":"@texts","containerName":"as_text","localvar":"my","kind":13,"definition":"my"},{"containerName":"as_text","localvar":"my","kind":13,"name":"$ann","line":467,"definition":"my"},{"line":467,"name":"$self","containerName":"as_text","kind":13},{"line":467,"containerName":"as_text","kind":12,"name":"get_Annotations"},{"line":468,"containerName":"as_text","kind":13,"name":"@texts"},{"name":"$ann","kind":13,"containerName":"as_text","line":468},{"line":468,"kind":12,"containerName":"as_text","name":"as_text"},{"line":470,"kind":13,"containerName":"as_text","name":"@texts"},{"line":471,"kind":13,"containerName":"as_text","name":"$txt"},{"name":"@texts","kind":13,"containerName":"as_text","line":471},{"line":473,"kind":13,"containerName":"as_text","name":"$txt"},{"line":475,"containerName":"as_text","kind":13,"name":"$txt"}],"name":"as_text","containerName":"main::","definition":"sub"},{"containerName":null,"localvar":"my","kind":13,"name":"%DEFAULT_CB","line":497,"definition":"my"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$obj","line":498},{"containerName":null,"localvar":"my","kind":13,"name":"$txt","line":499,"definition":"my"},{"definition":"my","name":"$ann","containerName":null,"localvar":"my","kind":13,"line":500},{"line":500,"name":"$obj","containerName":null,"kind":13},{"name":"get_Annotations","containerName":"main::","kind":12,"line":500},{"name":"$txt","kind":13,"containerName":null,"line":501},{"name":"$ann","containerName":null,"kind":13,"line":501},{"name":"display_text","containerName":"main::","kind":12,"line":501},{"containerName":null,"kind":13,"name":"$txt","line":503},{"detail":"($self,$cb)","definition":"sub","containerName":"main::","name":"display_text","children":[{"kind":13,"localvar":"my","containerName":"display_text","name":"$self","line":507,"definition":"my"},{"line":507,"name":"$cb","kind":13,"containerName":"display_text"},{"line":508,"kind":13,"containerName":"display_text","name":"$cb"},{"kind":13,"containerName":"display_text","name":"$DEFAULT_CB","line":508},{"line":509,"containerName":"display_text","kind":13,"name":"$self"},{"kind":12,"containerName":"display_text","name":"throw","line":509},{"line":509,"name":"$cb","kind":13,"containerName":"display_text"},{"containerName":"display_text","kind":13,"name":"$cb","line":510},{"name":"$self","kind":13,"containerName":"display_text","line":510}],"signature":{"parameters":[{"label":"$self"},{"label":"$cb"}],"documentation":"","label":"display_text($self,$cb)"},"range":{"start":{"character":0,"line":506},"end":{"line":511,"character":9999}},"kind":12,"line":506},{"definition":"sub","containerName":"main::","name":"hash_tree","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"hash_tree","kind":13,"line":528},{"definition":"my","kind":13,"localvar":"my","containerName":"hash_tree","name":"$tree","line":529},{"definition":"my","line":531,"kind":13,"localvar":"my","containerName":"hash_tree","name":"$key"},{"line":531,"containerName":"hash_tree","kind":13,"name":"$self"},{"name":"get_all_annotation_keys","kind":12,"containerName":"hash_tree","line":531},{"line":534,"name":"$tree","containerName":"hash_tree","kind":13},{"line":534,"containerName":"hash_tree","kind":13,"name":"$key"},{"line":534,"name":"$self","kind":13,"containerName":"hash_tree"},{"line":534,"name":"get_Annotations","containerName":"hash_tree","kind":12},{"containerName":"hash_tree","kind":13,"name":"$key","line":534},{"name":"$tree","containerName":"hash_tree","kind":13,"line":536}],"range":{"end":{"line":537,"character":9999},"start":{"character":0,"line":527}},"kind":12,"line":527},{"name":"tagname","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"tagname","line":560},{"line":562,"name":"$self","kind":13,"containerName":"tagname"},{"line":563,"kind":13,"containerName":"tagname","name":"$self"}],"definition":"sub","range":{"end":{"line":564,"character":9999},"start":{"line":559,"character":0}},"kind":12,"line":559},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"description","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"description","line":587,"definition":"my"},{"kind":13,"containerName":"description","name":"$value","line":587},{"line":589,"name":"$self","containerName":"description","kind":13},{"line":589,"name":"deprecated","containerName":"description","kind":12},{"line":591,"name":"$value","kind":13,"containerName":"description"},{"line":592,"localvar":"my","containerName":"description","kind":13,"name":"$val","definition":"my"},{"line":592,"kind":12,"containerName":"description","name":"new"},{"line":593,"kind":13,"containerName":"description","name":"$val"},{"containerName":"description","kind":12,"name":"value","line":593},{"line":593,"kind":13,"containerName":"description","name":"$value"},{"line":594,"name":"$self","containerName":"description","kind":13},{"line":594,"name":"add_Annotation","kind":12,"containerName":"description"},{"containerName":"description","kind":13,"name":"$val","line":594},{"definition":"my","kind":13,"localvar":"my","containerName":"description","name":"$desc","line":597},{"kind":13,"containerName":"description","name":"$self","line":597},{"containerName":"description","kind":12,"name":"get_Annotations","line":597},{"kind":13,"containerName":"description","name":"$desc","line":600},{"line":600,"name":"$desc","kind":13,"containerName":"description"},{"kind":12,"containerName":"description","name":"value","line":600}],"signature":{"label":"description($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"},"kind":12,"range":{"end":{"character":9999,"line":601},"start":{"character":0,"line":586}},"line":586},{"line":592,"name":"Bio","containerName":"Annotation::SimpleValue","kind":12},{"name":"add_gene_name","containerName":"main::","children":[{"line":617,"kind":13,"localvar":"my","containerName":"add_gene_name","name":"$self","definition":"my"},{"line":617,"name":"$value","kind":13,"containerName":"add_gene_name"},{"line":619,"name":"$self","containerName":"add_gene_name","kind":13},{"name":"deprecated","containerName":"add_gene_name","kind":12,"line":619},{"line":621,"name":"$val","containerName":"add_gene_name","localvar":"my","kind":13,"definition":"my"},{"name":"new","containerName":"add_gene_name","kind":12,"line":621},{"line":622,"kind":13,"containerName":"add_gene_name","name":"$val"},{"line":622,"kind":12,"containerName":"add_gene_name","name":"value"},{"containerName":"add_gene_name","kind":13,"name":"$value","line":622},{"line":623,"containerName":"add_gene_name","kind":13,"name":"$self"},{"line":623,"containerName":"add_gene_name","kind":12,"name":"add_Annotation"},{"kind":13,"containerName":"add_gene_name","name":"$val","line":623}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"line":616,"character":0},"end":{"character":9999,"line":624}},"line":616,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"add_gene_name($self,$value)"}},{"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio","line":621},{"signature":{"label":"each_gene_name($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"},"kind":12,"range":{"start":{"character":0,"line":638},"end":{"character":9999,"line":651}},"line":638,"detail":"($self)","definition":"sub","containerName":"main::","name":"each_gene_name","children":[{"name":"$self","localvar":"my","containerName":"each_gene_name","kind":13,"line":639,"definition":"my"},{"name":"$self","kind":13,"containerName":"each_gene_name","line":641},{"kind":12,"containerName":"each_gene_name","name":"deprecated","line":641},{"line":643,"kind":13,"localvar":"my","containerName":"each_gene_name","name":"@out","definition":"my"},{"line":644,"name":"@gene","localvar":"my","kind":13,"containerName":"each_gene_name","definition":"my"},{"line":644,"name":"$self","kind":13,"containerName":"each_gene_name"},{"name":"get_Annotations","kind":12,"containerName":"each_gene_name","line":644},{"definition":"my","line":646,"kind":13,"localvar":"my","containerName":"each_gene_name","name":"$g"},{"line":646,"containerName":"each_gene_name","kind":13,"name":"@gene"},{"name":"@out","kind":13,"containerName":"each_gene_name","line":647},{"line":647,"containerName":"each_gene_name","kind":13,"name":"$g"},{"name":"value","containerName":"each_gene_name","kind":12,"line":647},{"line":650,"kind":13,"containerName":"each_gene_name","name":"@out"}]},{"children":[{"definition":"my","line":666,"localvar":"my","kind":13,"containerName":"add_Reference","name":"$self"},{"name":"@values","kind":13,"containerName":"add_Reference","line":666},{"line":668,"kind":13,"containerName":"add_Reference","name":"$self"},{"line":668,"kind":12,"containerName":"add_Reference","name":"deprecated"},{"line":671,"kind":13,"localvar":"my","containerName":"add_Reference","name":"$value","definition":"my"},{"name":"@values","containerName":"add_Reference","kind":13,"line":671},{"line":672,"name":"$self","kind":13,"containerName":"add_Reference"},{"name":"add_Annotation","kind":12,"containerName":"add_Reference","line":672},{"kind":13,"containerName":"add_Reference","name":"$value","line":672}],"containerName":"main::","name":"add_Reference","definition":"sub","detail":"($self,@values)","line":665,"kind":12,"range":{"end":{"line":674,"character":9999},"start":{"character":0,"line":665}},"signature":{"label":"add_Reference($self,@values)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@values"}]}},{"containerName":"main::","name":"each_Reference","children":[{"line":689,"localvar":"my","kind":13,"containerName":"each_Reference","name":"$self","definition":"my"},{"name":"$self","containerName":"each_Reference","kind":13,"line":691},{"line":691,"name":"deprecated","containerName":"each_Reference","kind":12},{"name":"$self","kind":13,"containerName":"each_Reference","line":693},{"line":693,"name":"get_Annotations","kind":12,"containerName":"each_Reference"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":688},"end":{"character":9999,"line":694}},"line":688,"signature":{"label":"each_Reference($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"}},{"signature":{"label":"add_Comment($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"},"line":709,"kind":12,"range":{"start":{"line":709,"character":0},"end":{"character":9999,"line":716}},"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","containerName":"add_Comment","localvar":"my","kind":13,"line":710,"definition":"my"},{"containerName":"add_Comment","kind":13,"name":"$value","line":710},{"line":712,"kind":13,"containerName":"add_Comment","name":"$self"},{"line":712,"name":"deprecated","kind":12,"containerName":"add_Comment"},{"name":"$self","kind":13,"containerName":"add_Comment","line":714},{"line":714,"containerName":"add_Comment","kind":12,"name":"add_Annotation"},{"line":714,"name":"$value","containerName":"add_Comment","kind":13}],"name":"add_Comment","containerName":"main::"},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"each_Comment","line":731,"definition":"my"},{"line":733,"name":"$self","containerName":"each_Comment","kind":13},{"name":"deprecated","kind":12,"containerName":"each_Comment","line":733},{"line":735,"containerName":"each_Comment","kind":13,"name":"$self"},{"line":735,"name":"get_Annotations","kind":12,"containerName":"each_Comment"}],"containerName":"main::","name":"each_Comment","definition":"sub","detail":"($self)","line":730,"range":{"end":{"line":736,"character":9999},"start":{"character":0,"line":730}},"kind":12,"signature":{"label":"each_Comment($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"}},{"children":[{"definition":"my","line":753,"name":"$self","localvar":"my","containerName":"add_DBLink","kind":13},{"name":"$value","kind":13,"containerName":"add_DBLink","line":753},{"line":755,"name":"$self","containerName":"add_DBLink","kind":13},{"containerName":"add_DBLink","kind":12,"name":"deprecated","line":755},{"name":"$self","containerName":"add_DBLink","kind":13,"line":757},{"line":757,"name":"add_Annotation","containerName":"add_DBLink","kind":12},{"name":"$value","kind":13,"containerName":"add_DBLink","line":757}],"containerName":"main::","name":"add_DBLink","definition":"sub","detail":"($self,$value)","line":752,"range":{"start":{"line":752,"character":0},"end":{"character":9999,"line":759}},"kind":12,"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Comment{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Comment (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('comment');\n}\n\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$value"}],"label":"add_DBLink($self,$value)"}},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"each_DBLink","line":774,"definition":"my"},{"name":"$self","containerName":"each_DBLink","kind":13,"line":776},{"containerName":"each_DBLink","kind":12,"name":"deprecated","line":776},{"name":"$self","containerName":"each_DBLink","kind":13,"line":778},{"name":"get_Annotations","containerName":"each_DBLink","kind":12,"line":778}],"containerName":"main::","name":"each_DBLink","definition":"sub","detail":"($self)","line":773,"range":{"start":{"line":773,"character":0},"end":{"character":9999,"line":779}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Comment{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Comment (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('comment');\n}\n\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_DBLink{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_DBLink (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('dblink',$value);\n\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"each_DBLink($self)"}},{"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Comment{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Comment (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('comment');\n}\n\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_DBLink{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_DBLink (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('dblink',$value);\n\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_DBLink (old style Annotation) on new style Annotation::Collection - use get_Annotations('dblink')\");\n   \n   return $self->get_Annotations('dblink');\n}\n\n\n\n=head1 Implementation management functions\n\n\n=head2 _typemap\n\n Title   : _typemap\n Usage   : $obj->_typemap($newval)\n Function: \n Example : \n Returns : value of _typemap\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_typemap($self,$value)"},"kind":12,"range":{"start":{"character":0,"line":799},"end":{"line":806,"character":9999}},"line":799,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"_typemap","children":[{"line":800,"localvar":"my","containerName":"_typemap","kind":13,"name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"_typemap","line":800},{"line":801,"name":"$value","kind":13,"containerName":"_typemap"},{"line":802,"name":"$self","containerName":"_typemap","kind":13},{"name":"$value","kind":13,"containerName":"_typemap","line":802},{"line":804,"name":"$self","containerName":"_typemap","kind":13}]}],"version":5}