{"version":5,"vars":[{"name":"vars","kind":2,"containerName":"","line":338},{"line":347,"name":"$GapChars","containerName":null,"kind":13},{"kind":2,"containerName":"strict::Bio::Align::PairwiseStatistics::Bio::Matrix::PhylipDist::Bio::Tools","name":"IUPAC","line":347},{"line":348,"name":"$GCChhars","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@Nucleotides","line":349},{"line":350,"containerName":null,"kind":13,"name":"$SeqCount"},{"line":351,"containerName":null,"kind":13,"name":"$Precision"},{"containerName":null,"kind":13,"name":"%NucleotideIndexes","line":354},{"name":"$DefaultGapPenalty","kind":13,"containerName":null,"line":379},{"name":"%DNAChanges","containerName":null,"kind":13,"line":381},{"kind":13,"containerName":null,"name":"%DistanceMethods","line":392},{"line":402,"name":"base","kind":2,"containerName":""},{"line":405,"name":"$CODONS","kind":13,"containerName":null},{"kind":12,"name":"get_codons","line":405},{"definition":"my","line":406,"name":"@t","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"$synsites","line":408},{"line":408,"name":"get_syn_sites","kind":12},{"line":410,"name":"%synchanges","containerName":null,"kind":13},{"line":410,"name":"get_syn_changes","kind":12},{"kind":12,"range":{"start":{"character":0,"line":425},"end":{"line":432,"character":9999}},"line":425,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none","label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"name":"$class","localvar":"my","containerName":"new","kind":13,"line":426,"definition":"my"},{"line":426,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":427,"name":"$self","localvar":"my","containerName":"new","kind":13},{"name":"$class","kind":13,"containerName":"new","line":427},{"line":427,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":429},{"line":429,"containerName":"new","kind":12,"name":"pairwise_stats"},{"containerName":"new","kind":12,"name":"new","line":429},{"line":431,"name":"$self","kind":13,"containerName":"new"}],"detail":"($class,@args)","definition":"sub"},{"line":427,"containerName":"new","kind":12,"name":"SUPER"},{"line":429,"name":"Bio","containerName":"Align::PairwiseStatistics","kind":12},{"containerName":"main::","name":"distance","children":[{"definition":"my","line":451,"containerName":"distance","localvar":"my","kind":13,"name":"$self"},{"name":"@args","kind":13,"containerName":"distance","line":451},{"definition":"my","line":452,"name":"$aln","containerName":"distance","localvar":"my","kind":13},{"line":452,"kind":13,"containerName":"distance","name":"$method"},{"name":"$self","containerName":"distance","kind":13,"line":452},{"line":452,"name":"_rearrange","containerName":"distance","kind":12},{"line":452,"containerName":"distance","kind":13,"name":"@args"},{"line":453,"kind":13,"containerName":"distance","name":"$aln"},{"name":"$aln","containerName":"distance","kind":13,"line":453},{"line":453,"kind":13,"containerName":"distance","name":"$aln"},{"line":453,"kind":12,"containerName":"distance","name":"isa"},{"name":"$self","containerName":"distance","kind":13,"line":454},{"name":"throw","containerName":"distance","kind":12,"line":454},{"line":456,"kind":13,"containerName":"distance","name":"$method"},{"line":457,"localvar":"my","kind":13,"containerName":"distance","name":"$m","definition":"my"},{"containerName":"distance","kind":13,"name":"%DistanceMethods","line":457},{"line":458,"containerName":"distance","kind":13,"name":"$m"},{"containerName":"distance","kind":13,"name":"$method","line":458},{"definition":"my","line":459,"kind":13,"localvar":"my","containerName":"distance","name":"$mtd"},{"line":460,"kind":13,"containerName":"distance","name":"$self"},{"line":460,"kind":13,"containerName":"distance","name":"$mtd"},{"line":460,"name":"$aln","kind":13,"containerName":"distance"},{"kind":13,"containerName":"distance","name":"$self","line":463},{"line":463,"name":"warn","kind":12,"containerName":"distance"},{"containerName":"distance","kind":13,"name":"$self","line":464},{"line":464,"name":"available_distance_methods","containerName":"distance","kind":12}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":450},"end":{"character":9999,"line":466}},"line":450,"signature":{"label":"distance($self,@args)","documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>","parameters":[{"label":"$self"},{"label":"@args"}]}},{"line":479,"kind":12,"range":{"start":{"character":0,"line":479},"end":{"character":9999,"line":482}},"signature":{"label":"available_distance_methods($self,@args)","documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"available_distance_methods","line":480},{"containerName":"available_distance_methods","kind":13,"name":"@args","line":480},{"line":481,"containerName":"available_distance_methods","kind":13,"name":"%DistanceMethods"}],"containerName":"main::","name":"available_distance_methods","definition":"sub","detail":"($self,@args)"},{"signature":{"label":"D_JukesCantor($self,$aln,$gappenalty)","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty"},"kind":12,"range":{"end":{"line":542,"character":9999},"start":{"line":503,"character":0}},"line":503,"detail":"($self,$aln,$gappenalty)","definition":"sub","name":"D_JukesCantor","containerName":"main::","children":[{"line":504,"localvar":"my","containerName":"D_JukesCantor","kind":13,"name":"$self","definition":"my"},{"line":504,"name":"$aln","kind":13,"containerName":"D_JukesCantor"},{"line":504,"name":"$gappenalty","containerName":"D_JukesCantor","kind":13},{"line":505,"name":"$self","kind":13,"containerName":"D_JukesCantor"},{"line":505,"kind":12,"containerName":"D_JukesCantor","name":"_check_arg"},{"containerName":"D_JukesCantor","kind":13,"name":"$aln","line":505},{"line":506,"kind":13,"containerName":"D_JukesCantor","name":"$gappenalty"},{"line":506,"name":"$DefaultGapPenalty","kind":13,"containerName":"D_JukesCantor"},{"name":"$gappenalty","containerName":"D_JukesCantor","kind":13,"line":506},{"definition":"my","name":"@seqs","kind":13,"localvar":"my","containerName":"D_JukesCantor","line":508},{"line":508,"containerName":"D_JukesCantor","kind":13,"name":"@names"},{"line":508,"name":"@values","kind":13,"containerName":"D_JukesCantor"},{"line":508,"kind":13,"containerName":"D_JukesCantor","name":"%dist"},{"definition":"my","line":509,"name":"$seqct","localvar":"my","kind":13,"containerName":"D_JukesCantor"},{"line":510,"localvar":"my","containerName":"D_JukesCantor","kind":13,"name":"$seq","definition":"my"},{"name":"$aln","containerName":"D_JukesCantor","kind":13,"line":510},{"line":510,"kind":12,"containerName":"D_JukesCantor","name":"each_seq"},{"kind":13,"containerName":"D_JukesCantor","name":"@names","line":511},{"kind":13,"containerName":"D_JukesCantor","name":"$seq","line":511},{"kind":12,"containerName":"D_JukesCantor","name":"display_id","line":511},{"containerName":"D_JukesCantor","kind":13,"name":"@seqs","line":512},{"name":"$seq","kind":13,"containerName":"D_JukesCantor","line":512},{"name":"seq","containerName":"D_JukesCantor","kind":12,"line":512},{"line":513,"name":"$seqct","containerName":"D_JukesCantor","kind":13},{"line":515,"name":"$precisionstr","localvar":"my","containerName":"D_JukesCantor","kind":13,"definition":"my"},{"definition":"my","name":"$i","localvar":"my","containerName":"D_JukesCantor","kind":13,"line":516},{"name":"$i","kind":13,"containerName":"D_JukesCantor","line":516},{"line":516,"kind":13,"containerName":"D_JukesCantor","name":"$seqct"},{"line":516,"kind":13,"containerName":"D_JukesCantor","name":"$i"},{"line":518,"kind":13,"containerName":"D_JukesCantor","name":"$dist"},{"kind":13,"containerName":"D_JukesCantor","name":"$names","line":518},{"name":"$i","kind":13,"containerName":"D_JukesCantor","line":518},{"name":"$names","kind":13,"containerName":"D_JukesCantor","line":518},{"line":518,"name":"$i","kind":13,"containerName":"D_JukesCantor"},{"line":518,"kind":13,"containerName":"D_JukesCantor","name":"$i"},{"kind":13,"containerName":"D_JukesCantor","name":"$i","line":518},{"line":519,"name":"$values","kind":13,"containerName":"D_JukesCantor"},{"line":519,"containerName":"D_JukesCantor","kind":13,"name":"$i"},{"line":519,"name":"$i","containerName":"D_JukesCantor","kind":13},{"containerName":"D_JukesCantor","kind":13,"name":"$precisionstr","line":519},{"definition":"my","name":"$j","localvar":"my","containerName":"D_JukesCantor","kind":13,"line":521},{"line":521,"containerName":"D_JukesCantor","kind":13,"name":"$i"},{"name":"$j","containerName":"D_JukesCantor","kind":13,"line":521},{"name":"$seqct","kind":13,"containerName":"D_JukesCantor","line":521},{"line":521,"name":"$j","containerName":"D_JukesCantor","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"D_JukesCantor","name":"$matrix","line":522},{"line":522,"containerName":"D_JukesCantor","kind":13,"name":"$pfreq"},{"line":522,"name":"$gaps","containerName":"D_JukesCantor","kind":13},{"line":522,"containerName":"D_JukesCantor","kind":13,"name":"$self"},{"containerName":"D_JukesCantor","kind":12,"name":"_build_nt_matrix","line":522},{"name":"$seqs","containerName":"D_JukesCantor","kind":13,"line":522},{"name":"$i","kind":13,"containerName":"D_JukesCantor","line":522},{"name":"$seqs","kind":13,"containerName":"D_JukesCantor","line":523},{"line":523,"containerName":"D_JukesCantor","kind":13,"name":"$j"},{"line":525,"containerName":"D_JukesCantor","localvar":"my","kind":13,"name":"$m","definition":"my"},{"containerName":"D_JukesCantor","kind":13,"name":"$matrix","line":525},{"line":525,"containerName":"D_JukesCantor","kind":13,"name":"$matrix"},{"line":526,"containerName":"D_JukesCantor","kind":13,"name":"$matrix"},{"line":526,"containerName":"D_JukesCantor","kind":13,"name":"$matrix"},{"definition":"my","line":527,"kind":13,"localvar":"my","containerName":"D_JukesCantor","name":"$D"},{"line":527,"containerName":"D_JukesCantor","kind":13,"name":"$m"},{"kind":13,"containerName":"D_JukesCantor","name":"$aln","line":527},{"kind":12,"containerName":"D_JukesCantor","name":"length","line":527},{"containerName":"D_JukesCantor","kind":13,"name":"$gaps","line":527},{"line":527,"kind":13,"containerName":"D_JukesCantor","name":"$gaps"},{"kind":13,"containerName":"D_JukesCantor","name":"$gappenalty","line":527},{"line":528,"name":"$d","containerName":"D_JukesCantor","localvar":"my","kind":13,"definition":"my"},{"name":"$D","kind":13,"containerName":"D_JukesCantor","line":528},{"kind":13,"containerName":"D_JukesCantor","name":"$dist","line":530},{"line":530,"name":"$names","containerName":"D_JukesCantor","kind":13},{"line":530,"name":"$i","containerName":"D_JukesCantor","kind":13},{"line":530,"containerName":"D_JukesCantor","kind":13,"name":"$names"},{"name":"$j","containerName":"D_JukesCantor","kind":13,"line":530},{"line":530,"name":"$i","kind":13,"containerName":"D_JukesCantor"},{"line":530,"name":"$j","kind":13,"containerName":"D_JukesCantor"},{"line":531,"kind":13,"containerName":"D_JukesCantor","name":"$dist"},{"kind":13,"containerName":"D_JukesCantor","name":"$names","line":531},{"line":531,"containerName":"D_JukesCantor","kind":13,"name":"$j"},{"name":"$names","kind":13,"containerName":"D_JukesCantor","line":531},{"line":531,"containerName":"D_JukesCantor","kind":13,"name":"$i"},{"line":531,"name":"$i","containerName":"D_JukesCantor","kind":13},{"line":531,"name":"$j","containerName":"D_JukesCantor","kind":13},{"name":"$values","containerName":"D_JukesCantor","kind":13,"line":532},{"name":"$j","containerName":"D_JukesCantor","kind":13,"line":532},{"containerName":"D_JukesCantor","kind":13,"name":"$i","line":532},{"name":"$values","kind":13,"containerName":"D_JukesCantor","line":532},{"name":"$i","kind":13,"containerName":"D_JukesCantor","line":532},{"name":"$j","kind":13,"containerName":"D_JukesCantor","line":532},{"kind":13,"containerName":"D_JukesCantor","name":"$precisionstr","line":532},{"name":"$d","kind":13,"containerName":"D_JukesCantor","line":532},{"kind":13,"containerName":"D_JukesCantor","name":"$dist","line":534},{"name":"$names","kind":13,"containerName":"D_JukesCantor","line":534},{"line":534,"name":"$j","kind":13,"containerName":"D_JukesCantor"},{"line":534,"name":"$names","kind":13,"containerName":"D_JukesCantor"},{"line":534,"kind":13,"containerName":"D_JukesCantor","name":"$j"},{"line":534,"name":"$j","kind":13,"containerName":"D_JukesCantor"},{"containerName":"D_JukesCantor","kind":13,"name":"$j","line":534},{"line":535,"containerName":"D_JukesCantor","kind":13,"name":"$values"},{"line":535,"name":"$j","containerName":"D_JukesCantor","kind":13},{"line":535,"containerName":"D_JukesCantor","kind":13,"name":"$j"},{"line":535,"containerName":"D_JukesCantor","kind":13,"name":"$precisionstr"},{"containerName":"D_JukesCantor","kind":12,"name":"new","line":538},{"kind":13,"containerName":"D_JukesCantor","name":"%dist","line":539},{"name":"@names","containerName":"D_JukesCantor","kind":13,"line":540},{"line":541,"name":"@values","kind":13,"containerName":"D_JukesCantor"}]},{"line":538,"name":"Bio","containerName":"Matrix::PhylipDist","kind":12},{"signature":{"label":"D_F81($self,$aln,$gappenalty)","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences"},"kind":12,"range":{"start":{"character":0,"line":558},"end":{"character":9999,"line":598}},"line":558,"detail":"($self,$aln,$gappenalty)","definition":"sub","containerName":"main::","name":"D_F81","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"D_F81","kind":13,"line":559},{"containerName":"D_F81","kind":13,"name":"$aln","line":559},{"line":559,"name":"$gappenalty","containerName":"D_F81","kind":13},{"line":560,"name":"$self","kind":13,"containerName":"D_F81"},{"line":560,"name":"_check_arg","containerName":"D_F81","kind":12},{"line":560,"containerName":"D_F81","kind":13,"name":"$aln"},{"containerName":"D_F81","kind":13,"name":"$gappenalty","line":561},{"containerName":"D_F81","kind":13,"name":"$DefaultGapPenalty","line":561},{"line":561,"kind":13,"containerName":"D_F81","name":"$gappenalty"},{"definition":"my","localvar":"my","kind":13,"containerName":"D_F81","name":"@seqs","line":563},{"kind":13,"containerName":"D_F81","name":"@names","line":563},{"name":"@values","kind":13,"containerName":"D_F81","line":563},{"containerName":"D_F81","kind":13,"name":"%dist","line":563},{"line":564,"kind":13,"localvar":"my","containerName":"D_F81","name":"$seqct","definition":"my"},{"line":565,"name":"$seq","containerName":"D_F81","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"D_F81","name":"$aln","line":565},{"line":565,"kind":12,"containerName":"D_F81","name":"each_seq"},{"line":566,"name":"@names","containerName":"D_F81","kind":13},{"line":566,"containerName":"D_F81","kind":13,"name":"$seq"},{"containerName":"D_F81","kind":12,"name":"display_id","line":566},{"name":"@seqs","containerName":"D_F81","kind":13,"line":567},{"line":567,"name":"$seq","kind":13,"containerName":"D_F81"},{"line":567,"kind":12,"containerName":"D_F81","name":"seq"},{"line":568,"kind":13,"containerName":"D_F81","name":"$seqct"},{"definition":"my","localvar":"my","kind":13,"containerName":"D_F81","name":"$precisionstr","line":570},{"definition":"my","localvar":"my","kind":13,"containerName":"D_F81","name":"$i","line":571},{"name":"$i","containerName":"D_F81","kind":13,"line":571},{"name":"$seqct","containerName":"D_F81","kind":13,"line":571},{"kind":13,"containerName":"D_F81","name":"$i","line":571},{"line":573,"name":"$dist","containerName":"D_F81","kind":13},{"line":573,"name":"$names","kind":13,"containerName":"D_F81"},{"line":573,"containerName":"D_F81","kind":13,"name":"$i"},{"line":573,"name":"$names","kind":13,"containerName":"D_F81"},{"line":573,"kind":13,"containerName":"D_F81","name":"$i"},{"name":"$i","kind":13,"containerName":"D_F81","line":573},{"kind":13,"containerName":"D_F81","name":"$i","line":573},{"line":574,"name":"$values","containerName":"D_F81","kind":13},{"line":574,"name":"$i","containerName":"D_F81","kind":13},{"line":574,"name":"$i","kind":13,"containerName":"D_F81"},{"name":"$precisionstr","kind":13,"containerName":"D_F81","line":574},{"definition":"my","line":576,"localvar":"my","kind":13,"containerName":"D_F81","name":"$j"},{"name":"$i","containerName":"D_F81","kind":13,"line":576},{"line":576,"name":"$j","containerName":"D_F81","kind":13},{"name":"$seqct","kind":13,"containerName":"D_F81","line":576},{"line":576,"kind":13,"containerName":"D_F81","name":"$j"},{"kind":13,"localvar":"my","containerName":"D_F81","name":"$matrix","line":578,"definition":"my"},{"line":578,"name":"$pfreq","containerName":"D_F81","kind":13},{"line":578,"kind":13,"containerName":"D_F81","name":"$gaps"},{"line":578,"kind":13,"containerName":"D_F81","name":"$self"},{"name":"_build_nt_matrix","containerName":"D_F81","kind":12,"line":578},{"containerName":"D_F81","kind":13,"name":"$seqs","line":578},{"line":578,"name":"$i","containerName":"D_F81","kind":13},{"line":579,"name":"$seqs","kind":13,"containerName":"D_F81"},{"name":"$j","kind":13,"containerName":"D_F81","line":579},{"kind":13,"localvar":"my","containerName":"D_F81","name":"$m","line":581,"definition":"my"},{"line":581,"containerName":"D_F81","kind":13,"name":"$matrix"},{"name":"$matrix","containerName":"D_F81","kind":13,"line":581},{"name":"$matrix","containerName":"D_F81","kind":13,"line":582},{"name":"$matrix","containerName":"D_F81","kind":13,"line":582},{"definition":"my","line":583,"localvar":"my","kind":13,"containerName":"D_F81","name":"$D"},{"line":583,"containerName":"D_F81","kind":13,"name":"$m"},{"line":583,"name":"$aln","containerName":"D_F81","kind":13},{"line":583,"name":"length","containerName":"D_F81","kind":12},{"kind":13,"containerName":"D_F81","name":"$gaps","line":583},{"kind":13,"containerName":"D_F81","name":"$gaps","line":583},{"line":583,"containerName":"D_F81","kind":13,"name":"$gappenalty"},{"kind":13,"localvar":"my","containerName":"D_F81","name":"$d","line":584,"definition":"my"},{"line":584,"containerName":"D_F81","kind":13,"name":"$D"},{"kind":13,"containerName":"D_F81","name":"$dist","line":586},{"line":586,"kind":13,"containerName":"D_F81","name":"$names"},{"name":"$i","containerName":"D_F81","kind":13,"line":586},{"line":586,"kind":13,"containerName":"D_F81","name":"$names"},{"name":"$j","kind":13,"containerName":"D_F81","line":586},{"name":"$i","kind":13,"containerName":"D_F81","line":586},{"line":586,"name":"$j","containerName":"D_F81","kind":13},{"containerName":"D_F81","kind":13,"name":"$dist","line":587},{"line":587,"name":"$names","containerName":"D_F81","kind":13},{"line":587,"containerName":"D_F81","kind":13,"name":"$j"},{"kind":13,"containerName":"D_F81","name":"$names","line":587},{"line":587,"name":"$i","kind":13,"containerName":"D_F81"},{"line":587,"kind":13,"containerName":"D_F81","name":"$i"},{"line":587,"name":"$j","kind":13,"containerName":"D_F81"},{"line":588,"name":"$values","containerName":"D_F81","kind":13},{"name":"$j","kind":13,"containerName":"D_F81","line":588},{"line":588,"name":"$i","containerName":"D_F81","kind":13},{"line":588,"containerName":"D_F81","kind":13,"name":"$values"},{"line":588,"name":"$i","containerName":"D_F81","kind":13},{"line":588,"name":"$j","kind":13,"containerName":"D_F81"},{"line":588,"containerName":"D_F81","kind":13,"name":"$precisionstr"},{"line":588,"name":"$d","kind":13,"containerName":"D_F81"},{"containerName":"D_F81","kind":13,"name":"$dist","line":590},{"line":590,"name":"$names","kind":13,"containerName":"D_F81"},{"name":"$j","kind":13,"containerName":"D_F81","line":590},{"line":590,"name":"$names","kind":13,"containerName":"D_F81"},{"kind":13,"containerName":"D_F81","name":"$j","line":590},{"containerName":"D_F81","kind":13,"name":"$j","line":590},{"containerName":"D_F81","kind":13,"name":"$j","line":590},{"line":591,"name":"$values","kind":13,"containerName":"D_F81"},{"name":"$j","kind":13,"containerName":"D_F81","line":591},{"line":591,"name":"$j","kind":13,"containerName":"D_F81"},{"line":591,"name":"$precisionstr","containerName":"D_F81","kind":13},{"name":"new","containerName":"D_F81","kind":12,"line":594},{"line":595,"kind":13,"containerName":"D_F81","name":"%dist"},{"line":596,"name":"@names","kind":13,"containerName":"D_F81"},{"kind":13,"containerName":"D_F81","name":"@values","line":597}]},{"line":594,"name":"Bio","containerName":"Matrix::PhylipDist","kind":12},{"detail":"($self,$aln,$gappenalty)","definition":"sub","name":"D_Uncorrected","containerName":"main::","children":[{"line":613,"name":"$self","kind":13,"localvar":"my","containerName":"D_Uncorrected","definition":"my"},{"line":613,"name":"$aln","containerName":"D_Uncorrected","kind":13},{"name":"$gappenalty","containerName":"D_Uncorrected","kind":13,"line":613},{"line":614,"name":"$gappenalty","kind":13,"containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","kind":13,"name":"$DefaultGapPenalty","line":614},{"containerName":"D_Uncorrected","kind":13,"name":"$gappenalty","line":614},{"line":615,"containerName":"D_Uncorrected","kind":13,"name":"$self"},{"line":615,"containerName":"D_Uncorrected","kind":12,"name":"_check_arg"},{"kind":13,"containerName":"D_Uncorrected","name":"$aln","line":615},{"line":617,"name":"@seqs","localvar":"my","containerName":"D_Uncorrected","kind":13,"definition":"my"},{"containerName":"D_Uncorrected","kind":13,"name":"@names","line":617},{"name":"@values","containerName":"D_Uncorrected","kind":13,"line":617},{"name":"%dist","kind":13,"containerName":"D_Uncorrected","line":617},{"definition":"my","line":618,"name":"$seqct","localvar":"my","kind":13,"containerName":"D_Uncorrected"},{"name":"$seq","kind":13,"localvar":"my","containerName":"D_Uncorrected","line":619,"definition":"my"},{"line":619,"containerName":"D_Uncorrected","kind":13,"name":"$aln"},{"line":619,"kind":12,"containerName":"D_Uncorrected","name":"each_seq"},{"line":620,"kind":13,"containerName":"D_Uncorrected","name":"@names"},{"line":620,"name":"$seq","containerName":"D_Uncorrected","kind":13},{"kind":12,"containerName":"D_Uncorrected","name":"display_id","line":620},{"line":621,"kind":13,"containerName":"D_Uncorrected","name":"@seqs"},{"kind":13,"containerName":"D_Uncorrected","name":"$seq","line":621},{"line":621,"containerName":"D_Uncorrected","kind":12,"name":"seq"},{"name":"$seqct","containerName":"D_Uncorrected","kind":13,"line":622},{"definition":"my","name":"$precisionstr","localvar":"my","containerName":"D_Uncorrected","kind":13,"line":625},{"definition":"my","line":626,"kind":13,"localvar":"my","containerName":"D_Uncorrected","name":"$len"},{"line":626,"kind":13,"containerName":"D_Uncorrected","name":"$aln"},{"line":626,"name":"length","kind":12,"containerName":"D_Uncorrected"},{"kind":13,"localvar":"my","containerName":"D_Uncorrected","name":"$i","line":627,"definition":"my"},{"kind":13,"containerName":"D_Uncorrected","name":"$i","line":627},{"name":"$seqct","kind":13,"containerName":"D_Uncorrected","line":627},{"line":627,"containerName":"D_Uncorrected","kind":13,"name":"$i"},{"line":629,"name":"$dist","kind":13,"containerName":"D_Uncorrected"},{"name":"$names","containerName":"D_Uncorrected","kind":13,"line":629},{"line":629,"name":"$i","containerName":"D_Uncorrected","kind":13},{"kind":13,"containerName":"D_Uncorrected","name":"$names","line":629},{"line":629,"name":"$i","kind":13,"containerName":"D_Uncorrected"},{"line":629,"name":"$i","kind":13,"containerName":"D_Uncorrected"},{"line":629,"name":"$i","kind":13,"containerName":"D_Uncorrected"},{"line":630,"containerName":"D_Uncorrected","kind":13,"name":"$values"},{"kind":13,"containerName":"D_Uncorrected","name":"$i","line":630},{"line":630,"kind":13,"containerName":"D_Uncorrected","name":"$i"},{"containerName":"D_Uncorrected","kind":13,"name":"$precisionstr","line":630},{"name":"$j","localvar":"my","kind":13,"containerName":"D_Uncorrected","line":632,"definition":"my"},{"line":632,"containerName":"D_Uncorrected","kind":13,"name":"$i"},{"name":"$j","containerName":"D_Uncorrected","kind":13,"line":632},{"kind":13,"containerName":"D_Uncorrected","name":"$seqct","line":632},{"line":632,"name":"$j","kind":13,"containerName":"D_Uncorrected"},{"containerName":"D_Uncorrected","localvar":"my","kind":13,"name":"$matrix","line":633,"definition":"my"},{"line":633,"name":"$pfreq","kind":13,"containerName":"D_Uncorrected"},{"kind":13,"containerName":"D_Uncorrected","name":"$gaps","line":633},{"containerName":"D_Uncorrected","kind":13,"name":"$self","line":633},{"kind":12,"containerName":"D_Uncorrected","name":"_build_nt_matrix","line":633},{"kind":13,"containerName":"D_Uncorrected","name":"$seqs","line":633},{"kind":13,"containerName":"D_Uncorrected","name":"$i","line":633},{"line":634,"containerName":"D_Uncorrected","kind":13,"name":"$seqs"},{"containerName":"D_Uncorrected","kind":13,"name":"$j","line":634},{"definition":"my","line":635,"name":"$m","kind":13,"localvar":"my","containerName":"D_Uncorrected"},{"name":"$matrix","kind":13,"containerName":"D_Uncorrected","line":635},{"containerName":"D_Uncorrected","kind":13,"name":"$matrix","line":636},{"name":"$matrix","containerName":"D_Uncorrected","kind":13,"line":637},{"name":"$matrix","containerName":"D_Uncorrected","kind":13,"line":638},{"definition":"my","line":639,"name":"$D","containerName":"D_Uncorrected","localvar":"my","kind":13},{"containerName":"D_Uncorrected","kind":13,"name":"$m","line":639},{"name":"$len","containerName":"D_Uncorrected","kind":13,"line":639},{"containerName":"D_Uncorrected","kind":13,"name":"$gaps","line":639},{"line":639,"name":"$gaps","containerName":"D_Uncorrected","kind":13},{"name":"$gappenalty","kind":13,"containerName":"D_Uncorrected","line":639},{"line":641,"name":"$dist","kind":13,"containerName":"D_Uncorrected"},{"line":641,"containerName":"D_Uncorrected","kind":13,"name":"$names"},{"line":641,"kind":13,"containerName":"D_Uncorrected","name":"$i"},{"kind":13,"containerName":"D_Uncorrected","name":"$names","line":641},{"name":"$j","containerName":"D_Uncorrected","kind":13,"line":641},{"name":"$i","kind":13,"containerName":"D_Uncorrected","line":641},{"line":641,"name":"$j","kind":13,"containerName":"D_Uncorrected"},{"line":642,"name":"$dist","containerName":"D_Uncorrected","kind":13},{"name":"$names","kind":13,"containerName":"D_Uncorrected","line":642},{"kind":13,"containerName":"D_Uncorrected","name":"$j","line":642},{"line":642,"name":"$names","kind":13,"containerName":"D_Uncorrected"},{"name":"$i","containerName":"D_Uncorrected","kind":13,"line":642},{"line":642,"name":"$i","containerName":"D_Uncorrected","kind":13},{"name":"$j","containerName":"D_Uncorrected","kind":13,"line":642},{"containerName":"D_Uncorrected","kind":13,"name":"$values","line":643},{"line":643,"kind":13,"containerName":"D_Uncorrected","name":"$j"},{"line":643,"kind":13,"containerName":"D_Uncorrected","name":"$i"},{"line":643,"name":"$values","kind":13,"containerName":"D_Uncorrected"},{"line":643,"name":"$i","kind":13,"containerName":"D_Uncorrected"},{"line":643,"kind":13,"containerName":"D_Uncorrected","name":"$j"},{"line":643,"name":"$precisionstr","kind":13,"containerName":"D_Uncorrected"},{"line":643,"kind":13,"containerName":"D_Uncorrected","name":"$D"},{"name":"$dist","kind":13,"containerName":"D_Uncorrected","line":645},{"line":645,"name":"$names","containerName":"D_Uncorrected","kind":13},{"line":645,"kind":13,"containerName":"D_Uncorrected","name":"$j"},{"name":"$names","containerName":"D_Uncorrected","kind":13,"line":645},{"containerName":"D_Uncorrected","kind":13,"name":"$j","line":645},{"name":"$j","kind":13,"containerName":"D_Uncorrected","line":645},{"name":"$j","kind":13,"containerName":"D_Uncorrected","line":645},{"name":"$values","kind":13,"containerName":"D_Uncorrected","line":646},{"line":646,"name":"$j","kind":13,"containerName":"D_Uncorrected"},{"line":646,"containerName":"D_Uncorrected","kind":13,"name":"$j"},{"line":646,"name":"$precisionstr","kind":13,"containerName":"D_Uncorrected"},{"line":649,"name":"new","containerName":"D_Uncorrected","kind":12},{"line":650,"kind":13,"containerName":"D_Uncorrected","name":"%dist"},{"line":651,"name":"@names","containerName":"D_Uncorrected","kind":13},{"containerName":"D_Uncorrected","kind":13,"name":"@values","line":652}],"signature":{"label":"D_Uncorrected($self,$aln,$gappenalty)","documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}]},"range":{"end":{"character":9999,"line":653},"start":{"line":612,"character":0}},"kind":12,"line":612},{"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio","line":649},{"detail":"($self,$aln)","definition":"sub","name":"D_Kimura","containerName":"main::","children":[{"line":671,"name":"$self","localvar":"my","kind":13,"containerName":"D_Kimura","definition":"my"},{"line":671,"kind":13,"containerName":"D_Kimura","name":"$aln"},{"kind":13,"containerName":"D_Kimura","name":"$self","line":672},{"line":672,"kind":12,"containerName":"D_Kimura","name":"_check_arg"},{"containerName":"D_Kimura","kind":13,"name":"$aln","line":672},{"containerName":"D_Kimura","localvar":"my","kind":13,"name":"@names","line":674,"definition":"my"},{"line":674,"name":"@values","kind":13,"containerName":"D_Kimura"},{"line":674,"kind":13,"containerName":"D_Kimura","name":"%dist"},{"localvar":"my","containerName":"D_Kimura","kind":13,"name":"$seqct","line":675,"definition":"my"},{"definition":"my","line":676,"localvar":"my","containerName":"D_Kimura","kind":13,"name":"$seq"},{"name":"$aln","kind":13,"containerName":"D_Kimura","line":676},{"line":676,"containerName":"D_Kimura","kind":12,"name":"each_seq"},{"line":677,"name":"@names","containerName":"D_Kimura","kind":13},{"name":"$seq","containerName":"D_Kimura","kind":13,"line":677},{"name":"display_id","containerName":"D_Kimura","kind":12,"line":677},{"name":"$seqct","kind":13,"containerName":"D_Kimura","line":678},{"localvar":"my","kind":13,"containerName":"D_Kimura","name":"$precisionstr","line":681,"definition":"my"},{"kind":13,"localvar":"my","containerName":"D_Kimura","name":"$i","line":683,"definition":"my"},{"line":683,"containerName":"D_Kimura","kind":13,"name":"$i"},{"line":683,"name":"$seqct","kind":13,"containerName":"D_Kimura"},{"line":683,"name":"$i","kind":13,"containerName":"D_Kimura"},{"containerName":"D_Kimura","kind":13,"name":"$dist","line":685},{"kind":13,"containerName":"D_Kimura","name":"$names","line":685},{"kind":13,"containerName":"D_Kimura","name":"$i","line":685},{"line":685,"kind":13,"containerName":"D_Kimura","name":"$names"},{"containerName":"D_Kimura","kind":13,"name":"$i","line":685},{"line":685,"name":"$i","kind":13,"containerName":"D_Kimura"},{"line":685,"kind":13,"containerName":"D_Kimura","name":"$i"},{"line":686,"name":"$values","kind":13,"containerName":"D_Kimura"},{"name":"$i","kind":13,"containerName":"D_Kimura","line":686},{"line":686,"containerName":"D_Kimura","kind":13,"name":"$i"},{"name":"$precisionstr","containerName":"D_Kimura","kind":13,"line":686},{"definition":"my","line":688,"kind":13,"localvar":"my","containerName":"D_Kimura","name":"$j"},{"containerName":"D_Kimura","kind":13,"name":"$i","line":688},{"line":688,"name":"$j","containerName":"D_Kimura","kind":13},{"containerName":"D_Kimura","kind":13,"name":"$seqct","line":688},{"line":688,"name":"$j","kind":13,"containerName":"D_Kimura"},{"definition":"my","localvar":"my","kind":13,"containerName":"D_Kimura","name":"$pairwise","line":689},{"line":689,"containerName":"D_Kimura","kind":13,"name":"$aln"},{"line":689,"name":"select_noncont","containerName":"D_Kimura","kind":12},{"line":689,"name":"$i","kind":13,"containerName":"D_Kimura"},{"kind":13,"containerName":"D_Kimura","name":"$j","line":689},{"definition":"my","name":"$L","localvar":"my","containerName":"D_Kimura","kind":13,"line":690},{"line":690,"containerName":"D_Kimura","kind":13,"name":"$self"},{"line":690,"kind":12,"containerName":"D_Kimura","name":"pairwise_stats"},{"line":690,"kind":12,"containerName":"D_Kimura","name":"number_of_comparable_bases"},{"line":690,"name":"$pairwise","containerName":"D_Kimura","kind":13},{"name":"$L","kind":13,"containerName":"D_Kimura","line":691},{"line":692,"kind":13,"containerName":"D_Kimura","name":"$L"},{"localvar":"my","containerName":"D_Kimura","kind":13,"name":"$P","line":694,"definition":"my"},{"line":694,"containerName":"D_Kimura","kind":13,"name":"$self"},{"line":694,"containerName":"D_Kimura","kind":12,"name":"transitions"},{"kind":13,"containerName":"D_Kimura","name":"$pairwise","line":694},{"containerName":"D_Kimura","kind":13,"name":"$L","line":694},{"line":695,"localvar":"my","containerName":"D_Kimura","kind":13,"name":"$Q","definition":"my"},{"line":695,"kind":13,"containerName":"D_Kimura","name":"$self"},{"name":"transversions","kind":12,"containerName":"D_Kimura","line":695},{"line":695,"name":"$pairwise","kind":13,"containerName":"D_Kimura"},{"line":695,"name":"$L","containerName":"D_Kimura","kind":13},{"line":696,"containerName":"D_Kimura","localvar":"my","kind":13,"name":"$K","definition":"my"},{"definition":"my","line":697,"name":"$denom","kind":13,"localvar":"my","containerName":"D_Kimura"},{"line":697,"containerName":"D_Kimura","kind":13,"name":"$P"},{"line":697,"name":"$Q","containerName":"D_Kimura","kind":13},{"line":698,"containerName":"D_Kimura","kind":13,"name":"$denom"},{"line":699,"name":"$self","containerName":"D_Kimura","kind":13},{"line":699,"kind":12,"containerName":"D_Kimura","name":"throw"},{"name":"$i","containerName":"D_Kimura","kind":13,"line":699},{"line":700,"containerName":"D_Kimura","kind":13,"name":"$j"},{"definition":"my","name":"$a","localvar":"my","containerName":"D_Kimura","kind":13,"line":702},{"line":702,"kind":13,"containerName":"D_Kimura","name":"$P"},{"name":"$Q","kind":13,"containerName":"D_Kimura","line":702},{"definition":"my","line":703,"containerName":"D_Kimura","localvar":"my","kind":13,"name":"$b"},{"line":703,"name":"$Q","kind":13,"containerName":"D_Kimura"},{"containerName":"D_Kimura","kind":13,"name":"$a","line":704},{"kind":13,"containerName":"D_Kimura","name":"$b","line":704},{"line":705,"name":"$K","kind":13,"containerName":"D_Kimura"},{"name":"$K","containerName":"D_Kimura","kind":13,"line":707},{"line":707,"kind":13,"containerName":"D_Kimura","name":"$a"},{"kind":13,"containerName":"D_Kimura","name":"$b","line":707},{"kind":13,"containerName":"D_Kimura","name":"$dist","line":710},{"containerName":"D_Kimura","kind":13,"name":"$names","line":710},{"line":710,"name":"$i","kind":13,"containerName":"D_Kimura"},{"line":710,"kind":13,"containerName":"D_Kimura","name":"$names"},{"name":"$j","kind":13,"containerName":"D_Kimura","line":710},{"kind":13,"containerName":"D_Kimura","name":"$i","line":710},{"name":"$j","containerName":"D_Kimura","kind":13,"line":710},{"line":711,"name":"$dist","containerName":"D_Kimura","kind":13},{"line":711,"name":"$names","kind":13,"containerName":"D_Kimura"},{"line":711,"kind":13,"containerName":"D_Kimura","name":"$j"},{"line":711,"containerName":"D_Kimura","kind":13,"name":"$names"},{"containerName":"D_Kimura","kind":13,"name":"$i","line":711},{"name":"$i","containerName":"D_Kimura","kind":13,"line":711},{"line":711,"kind":13,"containerName":"D_Kimura","name":"$j"},{"name":"$values","kind":13,"containerName":"D_Kimura","line":712},{"line":712,"name":"$j","containerName":"D_Kimura","kind":13},{"line":712,"name":"$i","containerName":"D_Kimura","kind":13},{"line":712,"name":"$values","containerName":"D_Kimura","kind":13},{"line":712,"name":"$i","kind":13,"containerName":"D_Kimura"},{"name":"$j","kind":13,"containerName":"D_Kimura","line":712},{"line":712,"containerName":"D_Kimura","kind":13,"name":"$precisionstr"},{"containerName":"D_Kimura","kind":13,"name":"$K","line":712},{"line":714,"containerName":"D_Kimura","kind":13,"name":"$dist"},{"line":714,"name":"$names","kind":13,"containerName":"D_Kimura"},{"line":714,"name":"$j","kind":13,"containerName":"D_Kimura"},{"name":"$names","containerName":"D_Kimura","kind":13,"line":714},{"name":"$j","kind":13,"containerName":"D_Kimura","line":714},{"kind":13,"containerName":"D_Kimura","name":"$j","line":714},{"line":714,"name":"$j","containerName":"D_Kimura","kind":13},{"name":"$values","containerName":"D_Kimura","kind":13,"line":715},{"name":"$j","containerName":"D_Kimura","kind":13,"line":715},{"line":715,"containerName":"D_Kimura","kind":13,"name":"$j"},{"name":"$precisionstr","kind":13,"containerName":"D_Kimura","line":715},{"line":718,"name":"new","containerName":"D_Kimura","kind":12},{"containerName":"D_Kimura","kind":13,"name":"%dist","line":719},{"kind":13,"containerName":"D_Kimura","name":"@names","line":720},{"line":721,"kind":13,"containerName":"D_Kimura","name":"@values"}],"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"D_Kimura($self,$aln)"},"kind":12,"range":{"start":{"character":0,"line":670},"end":{"line":722,"character":9999}},"line":670},{"name":"Bio","containerName":"Matrix::PhylipDist","kind":12,"line":718},{"range":{"end":{"character":9999,"line":804},"start":{"character":0,"line":739}},"kind":12,"line":739,"signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences","label":"D_Kimura_variance($self,$aln)"},"name":"D_Kimura_variance","containerName":"main::","children":[{"definition":"my","line":740,"name":"$self","containerName":"D_Kimura_variance","localvar":"my","kind":13},{"kind":13,"containerName":"D_Kimura_variance","name":"$aln","line":740},{"name":"$self","containerName":"D_Kimura_variance","kind":13,"line":741},{"line":741,"name":"_check_arg","kind":12,"containerName":"D_Kimura_variance"},{"line":741,"name":"$aln","containerName":"D_Kimura_variance","kind":13},{"localvar":"my","containerName":"D_Kimura_variance","kind":13,"name":"@names","line":743,"definition":"my"},{"name":"@values","containerName":"D_Kimura_variance","kind":13,"line":743},{"kind":13,"containerName":"D_Kimura_variance","name":"%dist","line":743},{"line":743,"kind":13,"containerName":"D_Kimura_variance","name":"@var"},{"definition":"my","line":744,"name":"$seqct","containerName":"D_Kimura_variance","localvar":"my","kind":13},{"line":745,"name":"$seq","localvar":"my","kind":13,"containerName":"D_Kimura_variance","definition":"my"},{"kind":13,"containerName":"D_Kimura_variance","name":"$aln","line":745},{"line":745,"kind":12,"containerName":"D_Kimura_variance","name":"each_seq"},{"line":746,"name":"@names","containerName":"D_Kimura_variance","kind":13},{"line":746,"kind":13,"containerName":"D_Kimura_variance","name":"$seq"},{"line":746,"kind":12,"containerName":"D_Kimura_variance","name":"display_id"},{"line":747,"name":"$seqct","kind":13,"containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","localvar":"my","kind":13,"name":"$precisionstr","line":750,"definition":"my"},{"definition":"my","line":752,"kind":13,"localvar":"my","containerName":"D_Kimura_variance","name":"$i"},{"line":752,"name":"$i","kind":13,"containerName":"D_Kimura_variance"},{"name":"$seqct","containerName":"D_Kimura_variance","kind":13,"line":752},{"containerName":"D_Kimura_variance","kind":13,"name":"$i","line":752},{"line":754,"kind":13,"containerName":"D_Kimura_variance","name":"$dist"},{"line":754,"name":"$names","kind":13,"containerName":"D_Kimura_variance"},{"line":754,"name":"$i","containerName":"D_Kimura_variance","kind":13},{"name":"$names","kind":13,"containerName":"D_Kimura_variance","line":754},{"line":754,"name":"$i","containerName":"D_Kimura_variance","kind":13},{"line":754,"kind":13,"containerName":"D_Kimura_variance","name":"$i"},{"line":754,"containerName":"D_Kimura_variance","kind":13,"name":"$i"},{"line":755,"name":"$values","containerName":"D_Kimura_variance","kind":13},{"line":755,"name":"$i","containerName":"D_Kimura_variance","kind":13},{"name":"$i","kind":13,"containerName":"D_Kimura_variance","line":755},{"name":"$precisionstr","containerName":"D_Kimura_variance","kind":13,"line":755},{"line":757,"containerName":"D_Kimura_variance","localvar":"my","kind":13,"name":"$j","definition":"my"},{"line":757,"containerName":"D_Kimura_variance","kind":13,"name":"$i"},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":757},{"line":757,"kind":13,"containerName":"D_Kimura_variance","name":"$seqct"},{"name":"$j","kind":13,"containerName":"D_Kimura_variance","line":757},{"definition":"my","line":758,"name":"$pairwise","kind":13,"localvar":"my","containerName":"D_Kimura_variance"},{"line":758,"kind":13,"containerName":"D_Kimura_variance","name":"$aln"},{"name":"select_noncont","containerName":"D_Kimura_variance","kind":12,"line":758},{"name":"$i","kind":13,"containerName":"D_Kimura_variance","line":758},{"line":758,"name":"$j","containerName":"D_Kimura_variance","kind":13},{"line":759,"name":"$L","localvar":"my","kind":13,"containerName":"D_Kimura_variance","definition":"my"},{"name":"$self","containerName":"D_Kimura_variance","kind":13,"line":759},{"line":759,"name":"pairwise_stats","kind":12,"containerName":"D_Kimura_variance"},{"line":759,"kind":12,"containerName":"D_Kimura_variance","name":"number_of_comparable_bases"},{"line":759,"kind":13,"containerName":"D_Kimura_variance","name":"$pairwise"},{"name":"$L","kind":13,"containerName":"D_Kimura_variance","line":760},{"name":"$L","kind":13,"containerName":"D_Kimura_variance","line":761},{"kind":13,"localvar":"my","containerName":"D_Kimura_variance","name":"$P","line":763,"definition":"my"},{"line":763,"kind":13,"containerName":"D_Kimura_variance","name":"$self"},{"line":763,"kind":12,"containerName":"D_Kimura_variance","name":"transitions"},{"line":763,"name":"$pairwise","containerName":"D_Kimura_variance","kind":13},{"name":"$L","kind":13,"containerName":"D_Kimura_variance","line":763},{"definition":"my","line":764,"name":"$Q","localvar":"my","containerName":"D_Kimura_variance","kind":13},{"containerName":"D_Kimura_variance","kind":13,"name":"$self","line":764},{"kind":12,"containerName":"D_Kimura_variance","name":"transversions","line":764},{"name":"$pairwise","containerName":"D_Kimura_variance","kind":13,"line":764},{"line":764,"containerName":"D_Kimura_variance","kind":13,"name":"$L"},{"definition":"my","line":765,"name":"$a","localvar":"my","containerName":"D_Kimura_variance","kind":13},{"kind":13,"containerName":"D_Kimura_variance","name":"$b","line":765},{"kind":13,"containerName":"D_Kimura_variance","name":"$K","line":765},{"line":765,"containerName":"D_Kimura_variance","kind":13,"name":"$var_k"},{"line":766,"name":"$a_denom","kind":13,"localvar":"my","containerName":"D_Kimura_variance","definition":"my"},{"containerName":"D_Kimura_variance","kind":13,"name":"$P","line":766},{"line":766,"kind":13,"containerName":"D_Kimura_variance","name":"$Q"},{"line":767,"name":"$b_denom","localvar":"my","kind":13,"containerName":"D_Kimura_variance","definition":"my"},{"line":767,"kind":13,"containerName":"D_Kimura_variance","name":"$Q"},{"name":"$a_denom","kind":13,"containerName":"D_Kimura_variance","line":768},{"name":"$b_denom","kind":13,"containerName":"D_Kimura_variance","line":768},{"containerName":"D_Kimura_variance","kind":13,"name":"$a","line":769},{"kind":13,"containerName":"D_Kimura_variance","name":"$b","line":770},{"line":771,"kind":13,"containerName":"D_Kimura_variance","name":"$K"},{"line":772,"kind":13,"containerName":"D_Kimura_variance","name":"$var_k"},{"kind":13,"containerName":"D_Kimura_variance","name":"$a","line":774},{"name":"$a_denom","containerName":"D_Kimura_variance","kind":13,"line":774},{"line":775,"name":"$b","containerName":"D_Kimura_variance","kind":13},{"name":"$b_denom","kind":13,"containerName":"D_Kimura_variance","line":775},{"line":776,"name":"$K","kind":13,"containerName":"D_Kimura_variance"},{"line":776,"name":"$a","containerName":"D_Kimura_variance","kind":13},{"line":776,"kind":13,"containerName":"D_Kimura_variance","name":"$b"},{"definition":"my","line":778,"name":"$c","containerName":"D_Kimura_variance","localvar":"my","kind":13},{"line":778,"name":"$a","containerName":"D_Kimura_variance","kind":13},{"containerName":"D_Kimura_variance","kind":13,"name":"$b","line":778},{"name":"$d","containerName":"D_Kimura_variance","localvar":"my","kind":13,"line":779,"definition":"my"},{"line":779,"name":"$a","containerName":"D_Kimura_variance","kind":13},{"line":779,"containerName":"D_Kimura_variance","kind":13,"name":"$b"},{"name":"$var_k","kind":13,"containerName":"D_Kimura_variance","line":780},{"line":780,"containerName":"D_Kimura_variance","kind":13,"name":"$a"},{"name":"$P","containerName":"D_Kimura_variance","kind":13,"line":780},{"name":"$d","kind":13,"containerName":"D_Kimura_variance","line":780},{"name":"$Q","kind":13,"containerName":"D_Kimura_variance","line":780},{"kind":13,"containerName":"D_Kimura_variance","name":"$a","line":780},{"kind":13,"containerName":"D_Kimura_variance","name":"$P","line":780},{"kind":13,"containerName":"D_Kimura_variance","name":"$d","line":780},{"name":"$Q","containerName":"D_Kimura_variance","kind":13,"line":780},{"name":"$L","kind":13,"containerName":"D_Kimura_variance","line":780},{"containerName":"D_Kimura_variance","kind":13,"name":"$dist","line":784},{"kind":13,"containerName":"D_Kimura_variance","name":"$names","line":784},{"containerName":"D_Kimura_variance","kind":13,"name":"$i","line":784},{"name":"$names","containerName":"D_Kimura_variance","kind":13,"line":784},{"line":784,"kind":13,"containerName":"D_Kimura_variance","name":"$j"},{"kind":13,"containerName":"D_Kimura_variance","name":"$i","line":784},{"line":784,"kind":13,"containerName":"D_Kimura_variance","name":"$j"},{"line":785,"kind":13,"containerName":"D_Kimura_variance","name":"$dist"},{"name":"$names","kind":13,"containerName":"D_Kimura_variance","line":785},{"kind":13,"containerName":"D_Kimura_variance","name":"$j","line":785},{"name":"$names","kind":13,"containerName":"D_Kimura_variance","line":785},{"line":785,"kind":13,"containerName":"D_Kimura_variance","name":"$i"},{"line":785,"name":"$i","kind":13,"containerName":"D_Kimura_variance"},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":785},{"line":786,"name":"$values","kind":13,"containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","kind":13,"name":"$j","line":786},{"name":"$i","containerName":"D_Kimura_variance","kind":13,"line":786},{"line":786,"name":"$values","containerName":"D_Kimura_variance","kind":13},{"kind":13,"containerName":"D_Kimura_variance","name":"$i","line":786},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":786},{"containerName":"D_Kimura_variance","kind":13,"name":"$precisionstr","line":786},{"name":"$K","containerName":"D_Kimura_variance","kind":13,"line":786},{"name":"$dist","containerName":"D_Kimura_variance","kind":13,"line":788},{"line":788,"kind":13,"containerName":"D_Kimura_variance","name":"$names"},{"line":788,"name":"$j","kind":13,"containerName":"D_Kimura_variance"},{"containerName":"D_Kimura_variance","kind":13,"name":"$names","line":788},{"kind":13,"containerName":"D_Kimura_variance","name":"$j","line":788},{"name":"$j","kind":13,"containerName":"D_Kimura_variance","line":788},{"line":788,"name":"$j","containerName":"D_Kimura_variance","kind":13},{"name":"$values","kind":13,"containerName":"D_Kimura_variance","line":789},{"kind":13,"containerName":"D_Kimura_variance","name":"$j","line":789},{"containerName":"D_Kimura_variance","kind":13,"name":"$j","line":789},{"line":789,"kind":13,"containerName":"D_Kimura_variance","name":"$precisionstr"},{"kind":13,"containerName":"D_Kimura_variance","name":"$var","line":791},{"name":"$j","kind":13,"containerName":"D_Kimura_variance","line":791},{"name":"$i","containerName":"D_Kimura_variance","kind":13,"line":791},{"line":791,"kind":13,"containerName":"D_Kimura_variance","name":"$var"},{"line":791,"name":"$i","kind":13,"containerName":"D_Kimura_variance"},{"line":791,"name":"$j","kind":13,"containerName":"D_Kimura_variance"},{"line":791,"kind":13,"containerName":"D_Kimura_variance","name":"$precisionstr"},{"line":791,"name":"$var_k","containerName":"D_Kimura_variance","kind":13},{"line":792,"containerName":"D_Kimura_variance","kind":13,"name":"$var"},{"line":792,"kind":13,"containerName":"D_Kimura_variance","name":"$j"},{"kind":13,"containerName":"D_Kimura_variance","name":"$j","line":792},{"line":792,"name":"$values","containerName":"D_Kimura_variance","kind":13},{"line":792,"kind":13,"containerName":"D_Kimura_variance","name":"$j"},{"name":"$j","containerName":"D_Kimura_variance","kind":13,"line":792},{"line":795,"containerName":"D_Kimura_variance","kind":12,"name":"new"},{"line":796,"containerName":"D_Kimura_variance","kind":13,"name":"%dist"},{"name":"@names","containerName":"D_Kimura_variance","kind":13,"line":797},{"name":"@values","kind":13,"containerName":"D_Kimura_variance","line":798},{"line":799,"containerName":"D_Kimura_variance","kind":12,"name":"new"},{"line":800,"name":"%dist","kind":13,"containerName":"D_Kimura_variance"},{"line":801,"name":"@names","containerName":"D_Kimura_variance","kind":13},{"containerName":"D_Kimura_variance","kind":13,"name":"@var","line":802}],"detail":"($self,$aln)","definition":"sub"},{"line":795,"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio"},{"containerName":"Matrix::PhylipDist","kind":12,"name":"Bio","line":799},{"detail":"($self,$aln)","definition":"sub","name":"D_Tamura","containerName":"main::","children":[{"line":821,"name":"$self","kind":13,"localvar":"my","containerName":"D_Tamura","definition":"my"},{"kind":13,"containerName":"D_Tamura","name":"$aln","line":821},{"line":822,"containerName":"D_Tamura","kind":13,"name":"$self"},{"containerName":"D_Tamura","kind":12,"name":"_check_arg","line":822},{"name":"$aln","kind":13,"containerName":"D_Tamura","line":822},{"kind":13,"localvar":"my","containerName":"D_Tamura","name":"@seqs","line":824,"definition":"my"},{"name":"@names","kind":13,"containerName":"D_Tamura","line":824},{"kind":13,"containerName":"D_Tamura","name":"@values","line":824},{"name":"%dist","kind":13,"containerName":"D_Tamura","line":824},{"name":"$i","kind":13,"containerName":"D_Tamura","line":824},{"kind":13,"containerName":"D_Tamura","name":"$j","line":824},{"name":"$seqct","localvar":"my","kind":13,"containerName":"D_Tamura","line":825,"definition":"my"},{"name":"$length","localvar":"my","kind":13,"containerName":"D_Tamura","line":826,"definition":"my"},{"name":"$aln","containerName":"D_Tamura","kind":13,"line":826},{"line":826,"containerName":"D_Tamura","kind":12,"name":"length"},{"line":827,"localvar":"my","kind":13,"containerName":"D_Tamura","name":"$seq","definition":"my"},{"name":"$aln","containerName":"D_Tamura","kind":13,"line":827},{"line":827,"containerName":"D_Tamura","kind":12,"name":"each_seq"},{"line":828,"name":"@names","containerName":"D_Tamura","kind":13},{"name":"$seq","kind":13,"containerName":"D_Tamura","line":828},{"name":"display_id","kind":12,"containerName":"D_Tamura","line":828},{"line":829,"name":"@seqs","containerName":"D_Tamura","kind":13},{"name":"$seq","kind":13,"containerName":"D_Tamura","line":829},{"kind":12,"containerName":"D_Tamura","name":"seq","line":829},{"containerName":"D_Tamura","kind":13,"name":"$seqct","line":830},{"kind":13,"localvar":"my","containerName":"D_Tamura","name":"$precisionstr","line":833,"definition":"my"},{"kind":13,"localvar":"my","containerName":"D_Tamura","name":"@gap","line":834,"definition":"my"},{"name":"@gc","containerName":"D_Tamura","kind":13,"line":834},{"name":"@trans","kind":13,"containerName":"D_Tamura","line":834},{"name":"@tranv","kind":13,"containerName":"D_Tamura","line":834},{"line":834,"kind":13,"containerName":"D_Tamura","name":"@score"},{"line":835,"kind":13,"containerName":"D_Tamura","name":"$i"},{"line":836,"localvar":"my","kind":13,"containerName":"D_Tamura","name":"$t1","definition":"my"},{"line":836,"name":"@seqs","kind":13,"containerName":"D_Tamura"},{"kind":13,"containerName":"D_Tamura","name":"$j","line":837},{"name":"$t2","localvar":"my","containerName":"D_Tamura","kind":13,"line":838,"definition":"my"},{"kind":13,"containerName":"D_Tamura","name":"@seqs","line":838},{"line":839,"name":"$gap","containerName":"D_Tamura","kind":13},{"containerName":"D_Tamura","kind":13,"name":"$i","line":839},{"name":"$j","containerName":"D_Tamura","kind":13,"line":839},{"line":840,"containerName":"D_Tamura","localvar":"my","kind":13,"name":"$k","definition":"my"},{"name":"$k","kind":13,"containerName":"D_Tamura","line":840},{"line":840,"name":"$length","kind":13,"containerName":"D_Tamura"},{"name":"$k","kind":13,"containerName":"D_Tamura","line":840},{"name":"$c1","containerName":"D_Tamura","localvar":"my","kind":13,"line":841,"definition":"my"},{"line":841,"name":"$c2","kind":13,"containerName":"D_Tamura"},{"line":841,"name":"$seqs","kind":13,"containerName":"D_Tamura"},{"line":841,"name":"$i","kind":13,"containerName":"D_Tamura"},{"line":841,"name":"$k","kind":13,"containerName":"D_Tamura"},{"line":842,"name":"$seqs","kind":13,"containerName":"D_Tamura"},{"line":842,"kind":13,"containerName":"D_Tamura","name":"$j"},{"line":842,"kind":13,"containerName":"D_Tamura","name":"$k"},{"line":843,"kind":13,"containerName":"D_Tamura","name":"$c1"},{"name":"$c2","containerName":"D_Tamura","kind":13,"line":844},{"line":845,"name":"$gap","containerName":"D_Tamura","kind":13},{"line":845,"name":"$i","kind":13,"containerName":"D_Tamura"},{"containerName":"D_Tamura","kind":13,"name":"$j","line":845},{"line":846,"name":"$c2","containerName":"D_Tamura","kind":13},{"line":847,"name":"$gc","kind":13,"containerName":"D_Tamura"},{"line":847,"kind":13,"containerName":"D_Tamura","name":"$i"},{"line":847,"kind":13,"containerName":"D_Tamura","name":"$j"},{"name":"$gc","kind":13,"containerName":"D_Tamura","line":850},{"line":850,"name":"$i","kind":13,"containerName":"D_Tamura"},{"name":"$j","kind":13,"containerName":"D_Tamura","line":850},{"line":850,"kind":13,"containerName":"D_Tamura","name":"$gc"},{"kind":13,"containerName":"D_Tamura","name":"$i","line":850},{"kind":13,"containerName":"D_Tamura","name":"$j","line":850},{"containerName":"D_Tamura","kind":13,"name":"$length","line":851},{"name":"$gap","kind":13,"containerName":"D_Tamura","line":851},{"line":851,"containerName":"D_Tamura","kind":13,"name":"$i"},{"line":851,"containerName":"D_Tamura","kind":13,"name":"$j"},{"line":852,"containerName":"D_Tamura","kind":13,"name":"$j"},{"name":"$i","kind":13,"containerName":"D_Tamura","line":854},{"containerName":"D_Tamura","kind":13,"name":"$i","line":857},{"line":857,"name":"$i","containerName":"D_Tamura","kind":13},{"line":857,"name":"$seqct","containerName":"D_Tamura","kind":13},{"line":857,"containerName":"D_Tamura","kind":13,"name":"$i"},{"kind":13,"containerName":"D_Tamura","name":"$dist","line":859},{"line":859,"name":"$names","kind":13,"containerName":"D_Tamura"},{"line":859,"containerName":"D_Tamura","kind":13,"name":"$i"},{"name":"$names","kind":13,"containerName":"D_Tamura","line":859},{"kind":13,"containerName":"D_Tamura","name":"$i","line":859},{"containerName":"D_Tamura","kind":13,"name":"$i","line":859},{"line":859,"kind":13,"containerName":"D_Tamura","name":"$i"},{"line":860,"kind":13,"containerName":"D_Tamura","name":"$values"},{"line":860,"kind":13,"containerName":"D_Tamura","name":"$i"},{"name":"$i","kind":13,"containerName":"D_Tamura","line":860},{"line":860,"name":"$precisionstr","containerName":"D_Tamura","kind":13},{"line":862,"kind":13,"containerName":"D_Tamura","name":"$j"},{"line":862,"name":"$i","kind":13,"containerName":"D_Tamura"},{"line":862,"name":"$j","kind":13,"containerName":"D_Tamura"},{"name":"$seqct","kind":13,"containerName":"D_Tamura","line":862},{"name":"$j","kind":13,"containerName":"D_Tamura","line":862},{"definition":"my","name":"$pairwise","containerName":"D_Tamura","localvar":"my","kind":13,"line":864},{"line":864,"kind":13,"containerName":"D_Tamura","name":"$aln"},{"line":864,"name":"select_noncont","containerName":"D_Tamura","kind":12},{"line":864,"name":"$i","containerName":"D_Tamura","kind":13},{"line":864,"name":"$j","kind":13,"containerName":"D_Tamura"},{"definition":"my","localvar":"my","containerName":"D_Tamura","kind":13,"name":"$L","line":865},{"line":865,"containerName":"D_Tamura","kind":13,"name":"$self"},{"line":865,"containerName":"D_Tamura","kind":12,"name":"pairwise_stats"},{"line":865,"kind":12,"containerName":"D_Tamura","name":"number_of_comparable_bases"},{"line":865,"kind":13,"containerName":"D_Tamura","name":"$pairwise"},{"line":866,"kind":13,"localvar":"my","containerName":"D_Tamura","name":"$P","definition":"my"},{"name":"$self","containerName":"D_Tamura","kind":13,"line":866},{"line":866,"kind":12,"containerName":"D_Tamura","name":"transitions"},{"kind":13,"containerName":"D_Tamura","name":"$pairwise","line":866},{"line":866,"name":"$L","kind":13,"containerName":"D_Tamura"},{"kind":13,"localvar":"my","containerName":"D_Tamura","name":"$Q","line":867,"definition":"my"},{"kind":13,"containerName":"D_Tamura","name":"$self","line":867},{"line":867,"name":"transversions","kind":12,"containerName":"D_Tamura"},{"line":867,"kind":13,"containerName":"D_Tamura","name":"$pairwise"},{"name":"$L","kind":13,"containerName":"D_Tamura","line":867},{"definition":"my","line":868,"name":"$C","localvar":"my","containerName":"D_Tamura","kind":13},{"kind":13,"containerName":"D_Tamura","name":"$gc","line":868},{"name":"$i","containerName":"D_Tamura","kind":13,"line":868},{"name":"$j","containerName":"D_Tamura","kind":13,"line":868},{"name":"$gc","kind":13,"containerName":"D_Tamura","line":868},{"kind":13,"containerName":"D_Tamura","name":"$j","line":868},{"kind":13,"containerName":"D_Tamura","name":"$i","line":868},{"kind":13,"containerName":"D_Tamura","name":"$gc","line":869},{"kind":13,"containerName":"D_Tamura","name":"$i","line":869},{"kind":13,"containerName":"D_Tamura","name":"$j","line":869},{"kind":13,"containerName":"D_Tamura","name":"$gc","line":869},{"kind":13,"containerName":"D_Tamura","name":"$j","line":869},{"name":"$i","kind":13,"containerName":"D_Tamura","line":869},{"containerName":"D_Tamura","kind":13,"name":"$P","line":870},{"name":"$P","kind":13,"containerName":"D_Tamura","line":871},{"line":871,"containerName":"D_Tamura","kind":13,"name":"$P"},{"line":871,"name":"$C","containerName":"D_Tamura","kind":13},{"name":"$d","containerName":"D_Tamura","localvar":"my","kind":13,"line":873,"definition":"my"},{"line":873,"containerName":"D_Tamura","kind":13,"name":"$C"},{"line":873,"containerName":"D_Tamura","kind":13,"name":"$P"},{"line":873,"name":"$Q","containerName":"D_Tamura","kind":13},{"name":"$C","containerName":"D_Tamura","kind":13,"line":873},{"kind":13,"containerName":"D_Tamura","name":"$Q","line":873},{"kind":13,"containerName":"D_Tamura","name":"$dist","line":875},{"containerName":"D_Tamura","kind":13,"name":"$names","line":875},{"name":"$i","kind":13,"containerName":"D_Tamura","line":875},{"line":875,"name":"$names","kind":13,"containerName":"D_Tamura"},{"line":875,"name":"$j","containerName":"D_Tamura","kind":13},{"name":"$i","kind":13,"containerName":"D_Tamura","line":875},{"name":"$j","kind":13,"containerName":"D_Tamura","line":875},{"kind":13,"containerName":"D_Tamura","name":"$dist","line":876},{"line":876,"kind":13,"containerName":"D_Tamura","name":"$names"},{"containerName":"D_Tamura","kind":13,"name":"$j","line":876},{"name":"$names","kind":13,"containerName":"D_Tamura","line":876},{"line":876,"name":"$i","kind":13,"containerName":"D_Tamura"},{"kind":13,"containerName":"D_Tamura","name":"$i","line":876},{"line":876,"kind":13,"containerName":"D_Tamura","name":"$j"},{"name":"$values","kind":13,"containerName":"D_Tamura","line":877},{"containerName":"D_Tamura","kind":13,"name":"$j","line":877},{"kind":13,"containerName":"D_Tamura","name":"$i","line":877},{"line":877,"kind":13,"containerName":"D_Tamura","name":"$values"},{"containerName":"D_Tamura","kind":13,"name":"$i","line":877},{"line":877,"name":"$j","containerName":"D_Tamura","kind":13},{"kind":13,"containerName":"D_Tamura","name":"$precisionstr","line":877},{"line":877,"name":"$d","containerName":"D_Tamura","kind":13},{"name":"$dist","containerName":"D_Tamura","kind":13,"line":879},{"containerName":"D_Tamura","kind":13,"name":"$names","line":879},{"line":879,"name":"$j","containerName":"D_Tamura","kind":13},{"line":879,"name":"$names","kind":13,"containerName":"D_Tamura"},{"line":879,"name":"$j","kind":13,"containerName":"D_Tamura"},{"line":879,"kind":13,"containerName":"D_Tamura","name":"$j"},{"line":879,"kind":13,"containerName":"D_Tamura","name":"$j"},{"containerName":"D_Tamura","kind":13,"name":"$values","line":880},{"line":880,"name":"$j","kind":13,"containerName":"D_Tamura"},{"kind":13,"containerName":"D_Tamura","name":"$j","line":880},{"name":"$precisionstr","kind":13,"containerName":"D_Tamura","line":880},{"name":"new","kind":12,"containerName":"D_Tamura","line":883},{"name":"%dist","kind":13,"containerName":"D_Tamura","line":884},{"line":885,"name":"@names","kind":13,"containerName":"D_Tamura"},{"line":886,"name":"@values","kind":13,"containerName":"D_Tamura"}],"signature":{"label":"D_Tamura($self,$aln)","documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences","parameters":[{"label":"$self"},{"label":"$aln"}]},"kind":12,"range":{"start":{"character":0,"line":820},"end":{"character":9999,"line":888}},"line":820},{"line":883,"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio"},{"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$gappenalty"}],"label":"D_F84($self,$aln,$gappenalty)"},"kind":12,"range":{"start":{"character":0,"line":902},"end":{"character":9999,"line":931}},"line":902,"detail":"($self,$aln,$gappenalty)","definition":"sub","name":"D_F84","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"D_F84","localvar":"my","kind":13,"line":903},{"line":903,"name":"$aln","containerName":"D_F84","kind":13},{"line":903,"containerName":"D_F84","kind":13,"name":"$gappenalty"},{"kind":13,"containerName":"D_F84","name":"$self","line":904},{"line":904,"name":"_check_arg","kind":12,"containerName":"D_F84"},{"kind":13,"containerName":"D_F84","name":"$aln","line":904},{"kind":13,"containerName":"D_F84","name":"$self","line":905},{"line":905,"kind":12,"containerName":"D_F84","name":"throw_not_implemented"},{"name":"@seqs","containerName":"D_F84","localvar":"my","kind":13,"line":907,"definition":"my"},{"line":907,"name":"@names","containerName":"D_F84","kind":13},{"line":907,"containerName":"D_F84","kind":13,"name":"@values"},{"name":"%dist","containerName":"D_F84","kind":13,"line":907},{"definition":"my","line":908,"localvar":"my","kind":13,"containerName":"D_F84","name":"$seqct"},{"definition":"my","line":909,"name":"$seq","localvar":"my","containerName":"D_F84","kind":13},{"containerName":"D_F84","kind":13,"name":"$aln","line":909},{"name":"each_seq","kind":12,"containerName":"D_F84","line":909},{"definition":"my","name":"$id","localvar":"my","kind":13,"containerName":"D_F84","line":911},{"name":"$seq","kind":13,"containerName":"D_F84","line":911},{"line":911,"kind":12,"containerName":"D_F84","name":"display_id"},{"containerName":"D_F84","kind":13,"name":"$id","line":912},{"line":913,"kind":13,"containerName":"D_F84","name":"$id"},{"line":914,"kind":13,"containerName":"D_F84","name":"$id"},{"line":914,"name":"$seqct","kind":13,"containerName":"D_F84"},{"line":916,"name":"@names","kind":13,"containerName":"D_F84"},{"line":916,"kind":13,"containerName":"D_F84","name":"$id"},{"line":917,"containerName":"D_F84","kind":13,"name":"@seqs"},{"line":917,"name":"$seq","containerName":"D_F84","kind":13},{"containerName":"D_F84","kind":12,"name":"seq","line":917},{"name":"$seqct","containerName":"D_F84","kind":13,"line":918},{"definition":"my","line":921,"name":"$precisionstr","localvar":"my","kind":13,"containerName":"D_F84"},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":"D_F84","line":923},{"name":"$i","containerName":"D_F84","kind":13,"line":923},{"name":"$seqct","containerName":"D_F84","kind":13,"line":923},{"line":923,"kind":13,"containerName":"D_F84","name":"$i"},{"name":"$dist","containerName":"D_F84","kind":13,"line":925},{"line":925,"kind":13,"containerName":"D_F84","name":"$names"},{"line":925,"name":"$i","containerName":"D_F84","kind":13},{"name":"$names","kind":13,"containerName":"D_F84","line":925},{"line":925,"kind":13,"containerName":"D_F84","name":"$i"},{"name":"$i","kind":13,"containerName":"D_F84","line":925},{"line":925,"name":"$i","containerName":"D_F84","kind":13},{"name":"$values","kind":13,"containerName":"D_F84","line":926},{"line":926,"kind":13,"containerName":"D_F84","name":"$i"},{"name":"$i","kind":13,"containerName":"D_F84","line":926},{"line":926,"name":"$precisionstr","containerName":"D_F84","kind":13},{"name":"$j","localvar":"my","containerName":"D_F84","kind":13,"line":928,"definition":"my"},{"name":"$i","containerName":"D_F84","kind":13,"line":928},{"line":928,"name":"$j","containerName":"D_F84","kind":13},{"name":"$seqct","containerName":"D_F84","kind":13,"line":928},{"line":928,"kind":13,"containerName":"D_F84","name":"$j"}]},{"definition":"sub","detail":"($self,$aln)","children":[{"definition":"my","line":955,"name":"$self","kind":13,"localvar":"my","containerName":"D_TajimaNei"},{"line":955,"name":"$aln","containerName":"D_TajimaNei","kind":13},{"kind":13,"containerName":"D_TajimaNei","name":"$self","line":956},{"kind":12,"containerName":"D_TajimaNei","name":"_check_arg","line":956},{"line":956,"kind":13,"containerName":"D_TajimaNei","name":"$aln"},{"name":"@seqs","kind":13,"localvar":"my","containerName":"D_TajimaNei","line":958,"definition":"my"},{"line":958,"kind":13,"containerName":"D_TajimaNei","name":"@names"},{"containerName":"D_TajimaNei","kind":13,"name":"@values","line":958},{"line":958,"name":"%dist","kind":13,"containerName":"D_TajimaNei"},{"localvar":"my","containerName":"D_TajimaNei","kind":13,"name":"$seqct","line":959,"definition":"my"},{"definition":"my","containerName":"D_TajimaNei","localvar":"my","kind":13,"name":"$seq","line":960},{"containerName":"D_TajimaNei","kind":13,"name":"$aln","line":960},{"line":960,"name":"each_seq","containerName":"D_TajimaNei","kind":12},{"containerName":"D_TajimaNei","kind":13,"name":"@names","line":962},{"line":962,"name":"$seq","containerName":"D_TajimaNei","kind":13},{"line":962,"kind":12,"containerName":"D_TajimaNei","name":"display_id"},{"kind":13,"containerName":"D_TajimaNei","name":"@seqs","line":963},{"name":"$seq","containerName":"D_TajimaNei","kind":13,"line":963},{"kind":12,"containerName":"D_TajimaNei","name":"seq","line":963},{"kind":13,"containerName":"D_TajimaNei","name":"$seqct","line":964},{"definition":"my","name":"$precisionstr","containerName":"D_TajimaNei","localvar":"my","kind":13,"line":966},{"kind":13,"localvar":"my","containerName":"D_TajimaNei","name":"$i","line":967,"definition":"my"},{"line":967,"kind":13,"containerName":"D_TajimaNei","name":"$j"},{"line":967,"name":"$bs","kind":13,"containerName":"D_TajimaNei"},{"line":969,"name":"$i","containerName":"D_TajimaNei","kind":13},{"containerName":"D_TajimaNei","kind":13,"name":"$i","line":969},{"line":969,"name":"$seqct","kind":13,"containerName":"D_TajimaNei"},{"name":"$i","kind":13,"containerName":"D_TajimaNei","line":969},{"line":970,"containerName":"D_TajimaNei","kind":13,"name":"$dist"},{"name":"$names","containerName":"D_TajimaNei","kind":13,"line":970},{"line":970,"kind":13,"containerName":"D_TajimaNei","name":"$i"},{"line":970,"kind":13,"containerName":"D_TajimaNei","name":"$names"},{"name":"$i","kind":13,"containerName":"D_TajimaNei","line":970},{"name":"$i","kind":13,"containerName":"D_TajimaNei","line":970},{"line":970,"name":"$i","containerName":"D_TajimaNei","kind":13},{"kind":13,"containerName":"D_TajimaNei","name":"$values","line":971},{"line":971,"name":"$i","containerName":"D_TajimaNei","kind":13},{"kind":13,"containerName":"D_TajimaNei","name":"$i","line":971},{"line":971,"containerName":"D_TajimaNei","kind":13,"name":"$precisionstr"},{"line":973,"name":"$j","kind":13,"containerName":"D_TajimaNei"},{"line":973,"kind":13,"containerName":"D_TajimaNei","name":"$i"},{"containerName":"D_TajimaNei","kind":13,"name":"$j","line":973},{"line":973,"kind":13,"containerName":"D_TajimaNei","name":"$seqct"},{"name":"$j","kind":13,"containerName":"D_TajimaNei","line":973},{"line":974,"kind":13,"localvar":"my","containerName":"D_TajimaNei","name":"$matrix","definition":"my"},{"line":974,"name":"$pfreq","containerName":"D_TajimaNei","kind":13},{"containerName":"D_TajimaNei","kind":13,"name":"$gaps","line":974},{"line":974,"kind":13,"containerName":"D_TajimaNei","name":"$self"},{"name":"_build_nt_matrix","kind":12,"containerName":"D_TajimaNei","line":974},{"kind":13,"containerName":"D_TajimaNei","name":"$seqs","line":974},{"name":"$i","containerName":"D_TajimaNei","kind":13,"line":974},{"kind":13,"containerName":"D_TajimaNei","name":"$seqs","line":975},{"kind":13,"containerName":"D_TajimaNei","name":"$j","line":975},{"definition":"my","line":976,"containerName":"D_TajimaNei","localvar":"my","kind":13,"name":"$pairwise"},{"kind":13,"containerName":"D_TajimaNei","name":"$aln","line":976},{"kind":12,"containerName":"D_TajimaNei","name":"select_noncont","line":976},{"containerName":"D_TajimaNei","kind":13,"name":"$i","line":976},{"line":976,"name":"$j","containerName":"D_TajimaNei","kind":13},{"kind":13,"localvar":"my","containerName":"D_TajimaNei","name":"$slen","line":977,"definition":"my"},{"line":977,"kind":13,"containerName":"D_TajimaNei","name":"$self"},{"name":"pairwise_stats","kind":12,"containerName":"D_TajimaNei","line":977},{"line":977,"name":"number_of_comparable_bases","kind":12,"containerName":"D_TajimaNei"},{"name":"$pairwise","kind":13,"containerName":"D_TajimaNei","line":977},{"line":978,"localvar":"my","kind":13,"containerName":"D_TajimaNei","name":"$fij2","definition":"my"},{"name":"$bs","kind":13,"containerName":"D_TajimaNei","line":979},{"line":979,"name":"$bs","containerName":"D_TajimaNei","kind":13},{"line":979,"containerName":"D_TajimaNei","kind":13,"name":"$bs"},{"name":"$fi","containerName":"D_TajimaNei","localvar":"my","kind":13,"line":980,"definition":"my"},{"name":"$fi","containerName":"D_TajimaNei","kind":13,"line":981},{"line":981,"name":"$matrix","containerName":"D_TajimaNei","kind":13},{"containerName":"D_TajimaNei","kind":13,"name":"$bs","line":981},{"line":982,"name":"$fj","containerName":"D_TajimaNei","localvar":"my","kind":13,"definition":"my"},{"line":984,"kind":13,"containerName":"D_TajimaNei","name":"$fj"},{"name":"$matrix","containerName":"D_TajimaNei","kind":13,"line":984},{"line":984,"name":"$bs","kind":13,"containerName":"D_TajimaNei"},{"definition":"my","line":985,"name":"$fij","localvar":"my","kind":13,"containerName":"D_TajimaNei"},{"kind":13,"containerName":"D_TajimaNei","name":"$fi","line":985},{"kind":13,"containerName":"D_TajimaNei","name":"$fj","line":985},{"name":"$fi","kind":13,"containerName":"D_TajimaNei","line":985},{"kind":13,"containerName":"D_TajimaNei","name":"$fj","line":985},{"line":985,"name":"$slen","kind":13,"containerName":"D_TajimaNei"},{"line":986,"name":"$fij2","containerName":"D_TajimaNei","kind":13},{"line":986,"name":"$fij","containerName":"D_TajimaNei","kind":13},{"definition":"my","name":"$pair","kind":13,"localvar":"my","containerName":"D_TajimaNei","line":989},{"line":989,"containerName":"D_TajimaNei","kind":13,"name":"$h"},{"name":"$bs","containerName":"D_TajimaNei","kind":13,"line":990},{"line":990,"name":"$bs","kind":13,"containerName":"D_TajimaNei"},{"line":990,"kind":13,"containerName":"D_TajimaNei","name":"$bs"},{"name":"$bs1","kind":13,"localvar":"my","containerName":"D_TajimaNei","line":991,"definition":"my"},{"line":991,"containerName":"D_TajimaNei","kind":13,"name":"$bs"},{"kind":13,"containerName":"D_TajimaNei","name":"$bs1","line":991},{"line":991,"name":"$bs1","containerName":"D_TajimaNei","kind":13},{"definition":"my","name":"$fij","localvar":"my","kind":13,"containerName":"D_TajimaNei","line":992},{"line":992,"name":"$pfreq","kind":13,"containerName":"D_TajimaNei"},{"name":"$pair","kind":13,"containerName":"D_TajimaNei","line":992},{"containerName":"D_TajimaNei","kind":13,"name":"$slen","line":992},{"line":993,"kind":13,"containerName":"D_TajimaNei","name":"$fij"},{"definition":"my","line":995,"kind":13,"localvar":"my","containerName":"D_TajimaNei","name":"$ci1"},{"line":995,"name":"$ci2","kind":13,"containerName":"D_TajimaNei"},{"line":995,"name":"$cj1","containerName":"D_TajimaNei","kind":13},{"line":995,"name":"$cj2","containerName":"D_TajimaNei","kind":13},{"line":997,"name":"$ci1","kind":13,"containerName":"D_TajimaNei"},{"name":"$matrix","kind":13,"containerName":"D_TajimaNei","line":997},{"line":997,"kind":13,"containerName":"D_TajimaNei","name":"$bs"},{"line":998,"containerName":"D_TajimaNei","kind":13,"name":"$cj1"},{"line":998,"kind":13,"containerName":"D_TajimaNei","name":"$matrix"},{"kind":13,"containerName":"D_TajimaNei","name":"$bs","line":998},{"name":"$ci2","containerName":"D_TajimaNei","kind":13,"line":999},{"line":999,"name":"$matrix","kind":13,"containerName":"D_TajimaNei"},{"name":"$bs1","kind":13,"containerName":"D_TajimaNei","line":999},{"kind":13,"containerName":"D_TajimaNei","name":"$cj2","line":1000},{"containerName":"D_TajimaNei","kind":13,"name":"$matrix","line":1000},{"line":1000,"name":"$bs1","containerName":"D_TajimaNei","kind":13},{"kind":13,"containerName":"D_TajimaNei","name":"$fij","line":1002},{"kind":13,"containerName":"D_TajimaNei","name":"$h","line":1003},{"kind":13,"containerName":"D_TajimaNei","name":"$fij","line":1003},{"line":1004,"kind":13,"containerName":"D_TajimaNei","name":"$ci1"},{"line":1004,"name":"$cj1","kind":13,"containerName":"D_TajimaNei"},{"name":"$slen","kind":13,"containerName":"D_TajimaNei","line":1004},{"name":"$ci2","kind":13,"containerName":"D_TajimaNei","line":1005},{"line":1005,"name":"$cj2","containerName":"D_TajimaNei","kind":13},{"kind":13,"containerName":"D_TajimaNei","name":"$slen","line":1005},{"containerName":"D_TajimaNei","kind":13,"name":"$self","line":1008},{"line":1008,"name":"debug","containerName":"D_TajimaNei","kind":12},{"line":1014,"name":"$m","containerName":"D_TajimaNei","localvar":"my","kind":13,"definition":"my"},{"line":1014,"containerName":"D_TajimaNei","kind":13,"name":"$matrix"},{"line":1014,"name":"$matrix","containerName":"D_TajimaNei","kind":13},{"name":"$matrix","containerName":"D_TajimaNei","kind":13,"line":1015},{"containerName":"D_TajimaNei","kind":13,"name":"$matrix","line":1015},{"line":1016,"name":"$D","kind":13,"localvar":"my","containerName":"D_TajimaNei","definition":"my"},{"name":"$m","containerName":"D_TajimaNei","kind":13,"line":1016},{"kind":13,"containerName":"D_TajimaNei","name":"$slen","line":1016},{"name":"$d","localvar":"my","kind":13,"containerName":"D_TajimaNei","line":1017,"definition":"my"},{"line":1018,"name":"$h","kind":13,"containerName":"D_TajimaNei"},{"line":1019,"name":"$d","kind":13,"containerName":"D_TajimaNei"},{"definition":"my","kind":13,"localvar":"my","containerName":"D_TajimaNei","name":"$b","line":1021},{"line":1021,"name":"$fij2","kind":13,"containerName":"D_TajimaNei"},{"name":"$D","containerName":"D_TajimaNei","kind":13,"line":1021},{"line":1021,"name":"$h","containerName":"D_TajimaNei","kind":13},{"definition":"my","line":1022,"kind":13,"localvar":"my","containerName":"D_TajimaNei","name":"$c"},{"line":1022,"containerName":"D_TajimaNei","kind":13,"name":"$D"},{"line":1022,"containerName":"D_TajimaNei","kind":13,"name":"$b"},{"kind":13,"containerName":"D_TajimaNei","name":"$c","line":1024},{"name":"$d","kind":13,"containerName":"D_TajimaNei","line":1025},{"name":"$d","kind":13,"containerName":"D_TajimaNei","line":1027},{"line":1027,"name":"$b","kind":13,"containerName":"D_TajimaNei"},{"line":1027,"containerName":"D_TajimaNei","kind":13,"name":"$c"},{"line":1031,"name":"$dist","kind":13,"containerName":"D_TajimaNei"},{"line":1031,"containerName":"D_TajimaNei","kind":13,"name":"$names"},{"line":1031,"kind":13,"containerName":"D_TajimaNei","name":"$i"},{"containerName":"D_TajimaNei","kind":13,"name":"$names","line":1031},{"kind":13,"containerName":"D_TajimaNei","name":"$j","line":1031},{"line":1031,"kind":13,"containerName":"D_TajimaNei","name":"$i"},{"line":1031,"name":"$j","containerName":"D_TajimaNei","kind":13},{"name":"$dist","kind":13,"containerName":"D_TajimaNei","line":1032},{"line":1032,"name":"$names","kind":13,"containerName":"D_TajimaNei"},{"name":"$j","kind":13,"containerName":"D_TajimaNei","line":1032},{"kind":13,"containerName":"D_TajimaNei","name":"$names","line":1032},{"line":1032,"name":"$i","containerName":"D_TajimaNei","kind":13},{"containerName":"D_TajimaNei","kind":13,"name":"$i","line":1032},{"line":1032,"kind":13,"containerName":"D_TajimaNei","name":"$j"},{"line":1033,"name":"$values","kind":13,"containerName":"D_TajimaNei"},{"line":1033,"kind":13,"containerName":"D_TajimaNei","name":"$j"},{"line":1033,"containerName":"D_TajimaNei","kind":13,"name":"$i"},{"line":1033,"kind":13,"containerName":"D_TajimaNei","name":"$values"},{"line":1033,"name":"$i","kind":13,"containerName":"D_TajimaNei"},{"name":"$j","containerName":"D_TajimaNei","kind":13,"line":1033},{"line":1033,"kind":13,"containerName":"D_TajimaNei","name":"$precisionstr"},{"kind":13,"containerName":"D_TajimaNei","name":"$d","line":1033},{"line":1036,"kind":13,"containerName":"D_TajimaNei","name":"$dist"},{"line":1036,"name":"$names","containerName":"D_TajimaNei","kind":13},{"line":1036,"containerName":"D_TajimaNei","kind":13,"name":"$j"},{"kind":13,"containerName":"D_TajimaNei","name":"$names","line":1036},{"line":1036,"kind":13,"containerName":"D_TajimaNei","name":"$j"},{"line":1036,"kind":13,"containerName":"D_TajimaNei","name":"$j"},{"line":1036,"name":"$j","kind":13,"containerName":"D_TajimaNei"},{"kind":13,"containerName":"D_TajimaNei","name":"$values","line":1037},{"kind":13,"containerName":"D_TajimaNei","name":"$j","line":1037},{"line":1037,"name":"$j","kind":13,"containerName":"D_TajimaNei"},{"line":1037,"containerName":"D_TajimaNei","kind":13,"name":"$precisionstr"},{"line":1040,"containerName":"D_TajimaNei","kind":12,"name":"new"},{"name":"%dist","containerName":"D_TajimaNei","kind":13,"line":1041},{"line":1042,"containerName":"D_TajimaNei","kind":13,"name":"@names"},{"name":"@values","kind":13,"containerName":"D_TajimaNei","line":1043}],"containerName":"main::","name":"D_TajimaNei","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"D_TajimaNei($self,$aln)"},"line":954,"kind":12,"range":{"start":{"line":954,"character":0},"end":{"line":1045,"character":9999}}},{"line":1040,"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio"},{"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences","parameters":[{"label":"$self"},{"label":"@args"}],"label":"D_JinNei($self,@args)"},"range":{"end":{"line":1065,"character":9999},"start":{"line":1061,"character":0}},"kind":12,"line":1061,"detail":"($self,@args)","definition":"sub","name":"D_JinNei","containerName":"main::","children":[{"localvar":"my","containerName":"D_JinNei","kind":13,"name":"$self","line":1062,"definition":"my"},{"name":"@args","kind":13,"containerName":"D_JinNei","line":1062},{"line":1063,"containerName":"D_JinNei","kind":13,"name":"$self"},{"line":1063,"kind":12,"containerName":"D_JinNei","name":"warn"}]},{"signature":{"label":"transversions($self,$aln)","parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI"},"line":1079,"range":{"start":{"character":0,"line":1079},"end":{"character":9999,"line":1082}},"kind":12,"definition":"sub","detail":"($self,$aln)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"transversions","name":"$self","line":1080},{"line":1080,"containerName":"transversions","kind":13,"name":"$aln"},{"line":1081,"name":"$self","containerName":"transversions","kind":13},{"kind":12,"containerName":"transversions","name":"_trans_count_helper","line":1081},{"name":"$aln","kind":13,"containerName":"transversions","line":1081},{"line":1081,"name":"$DNAChanges","kind":13,"containerName":"transversions"}],"name":"transversions","containerName":"main::"},{"line":1095,"range":{"start":{"line":1095,"character":0},"end":{"character":9999,"line":1098}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object","label":"transitions($self,$aln)"},"children":[{"definition":"my","line":1096,"localvar":"my","kind":13,"containerName":"transitions","name":"$self"},{"kind":13,"containerName":"transitions","name":"$aln","line":1096},{"name":"$self","kind":13,"containerName":"transitions","line":1097},{"line":1097,"name":"_trans_count_helper","kind":12,"containerName":"transitions"},{"name":"$aln","kind":13,"containerName":"transitions","line":1097},{"line":1097,"kind":13,"containerName":"transitions","name":"$DNAChanges"}],"name":"transitions","containerName":"main::","definition":"sub","detail":"($self,$aln)"},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$type"}],"label":"_trans_count_helper($self,$aln,$type)"},"range":{"end":{"line":1119,"character":9999},"start":{"character":0,"line":1101}},"kind":12,"line":1101,"detail":"($self,$aln,$type)","definition":"sub","containerName":"main::","name":"_trans_count_helper","children":[{"line":1102,"kind":13,"localvar":"my","containerName":"_trans_count_helper","name":"$self","definition":"my"},{"line":1102,"containerName":"_trans_count_helper","kind":13,"name":"$aln"},{"line":1102,"kind":13,"containerName":"_trans_count_helper","name":"$type"},{"line":1103,"kind":13,"containerName":"_trans_count_helper","name":"$self"},{"line":1103,"name":"_check_arg","containerName":"_trans_count_helper","kind":12},{"name":"$aln","kind":13,"containerName":"_trans_count_helper","line":1103},{"line":1104,"name":"$aln","containerName":"_trans_count_helper","kind":13},{"name":"is_flush","containerName":"_trans_count_helper","kind":12,"line":1104},{"line":1104,"name":"$self","kind":13,"containerName":"_trans_count_helper"},{"containerName":"_trans_count_helper","kind":12,"name":"throw","line":1104},{"definition":"my","line":1105,"name":"@tcount","containerName":"_trans_count_helper","localvar":"my","kind":13},{"line":1106,"name":"$first","localvar":"my","kind":13,"containerName":"_trans_count_helper","definition":"my"},{"line":1106,"containerName":"_trans_count_helper","kind":13,"name":"$second"},{"line":1106,"name":"$aln","kind":13,"containerName":"_trans_count_helper"},{"name":"get_seq_by_pos","kind":12,"containerName":"_trans_count_helper","line":1106},{"name":"seq","containerName":"_trans_count_helper","kind":12,"line":1106},{"line":1107,"kind":13,"containerName":"_trans_count_helper","name":"$aln"},{"kind":12,"containerName":"_trans_count_helper","name":"get_seq_by_pos","line":1107},{"name":"seq","kind":12,"containerName":"_trans_count_helper","line":1107},{"line":1108,"kind":13,"localvar":"my","containerName":"_trans_count_helper","name":"$alen","definition":"my"},{"line":1108,"name":"$aln","kind":13,"containerName":"_trans_count_helper"},{"name":"length","containerName":"_trans_count_helper","kind":12,"line":1108},{"line":1109,"name":"$i","kind":13,"localvar":"my","containerName":"_trans_count_helper","definition":"my"},{"line":1109,"kind":13,"containerName":"_trans_count_helper","name":"$i"},{"line":1109,"name":"$alen","kind":13,"containerName":"_trans_count_helper"},{"line":1109,"containerName":"_trans_count_helper","kind":13,"name":"$i"},{"definition":"my","line":1110,"name":"$c1","containerName":"_trans_count_helper","localvar":"my","kind":13},{"line":1110,"kind":13,"containerName":"_trans_count_helper","name":"$c2"},{"line":1110,"containerName":"_trans_count_helper","kind":13,"name":"$first"},{"containerName":"_trans_count_helper","kind":13,"name":"$i","line":1110},{"line":1111,"containerName":"_trans_count_helper","kind":13,"name":"$second"},{"line":1111,"kind":13,"containerName":"_trans_count_helper","name":"$i"},{"name":"$c1","kind":13,"containerName":"_trans_count_helper","line":1112},{"kind":13,"containerName":"_trans_count_helper","name":"$c2","line":1112},{"definition":"my","localvar":"my","kind":13,"containerName":"_trans_count_helper","name":"$nt","line":1113},{"line":1113,"kind":13,"containerName":"_trans_count_helper","name":"$type"},{"line":1113,"kind":13,"containerName":"_trans_count_helper","name":"$c1"},{"kind":13,"containerName":"_trans_count_helper","name":"$nt","line":1114},{"line":1114,"name":"$c2","containerName":"_trans_count_helper","kind":13},{"line":1115,"name":"$tcount","containerName":"_trans_count_helper","kind":13},{"line":1115,"kind":13,"containerName":"_trans_count_helper","name":"$i"}]},{"line":1120,"name":"%sum","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$sum","line":1121},{"line":1121,"kind":13,"containerName":null,"name":"@tcount"},{"name":"$sum","containerName":null,"kind":13,"line":1122},{"signature":{"label":"_build_nt_matrix($self,$seqa,$seqb)","parameters":[{"label":"$self"},{"label":"$seqa"},{"label":"$seqb"}],"documentation":" this will generate a matrix which records across the row, the number\n of DNA subst"},"range":{"end":{"line":1162,"character":9999},"start":{"character":0,"line":1128}},"kind":12,"line":1128,"detail":"($self,$seqa,$seqb)","definition":"sub","name":"_build_nt_matrix","containerName":"main::","children":[{"definition":"my","line":1129,"localvar":"my","kind":13,"containerName":"_build_nt_matrix","name":"$self"},{"kind":13,"containerName":"_build_nt_matrix","name":"$seqa","line":1129},{"line":1129,"name":"$seqb","kind":13,"containerName":"_build_nt_matrix"},{"definition":"my","line":1132,"name":"$basect_matrix","localvar":"my","containerName":"_build_nt_matrix","kind":13},{"name":"$gaps","kind":13,"localvar":"my","containerName":"_build_nt_matrix","line":1136,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_build_nt_matrix","name":"$pfreq","line":1137},{"definition":"my","line":1138,"containerName":"_build_nt_matrix","localvar":"my","kind":13,"name":"$len_a"},{"line":1138,"name":"$seqa","containerName":"_build_nt_matrix","kind":13},{"definition":"my","containerName":"_build_nt_matrix","localvar":"my","kind":13,"name":"$i","line":1139},{"line":1139,"name":"$i","containerName":"_build_nt_matrix","kind":13},{"name":"$len_a","containerName":"_build_nt_matrix","kind":13,"line":1139},{"name":"$i","kind":13,"containerName":"_build_nt_matrix","line":1139},{"line":1140,"localvar":"my","kind":13,"containerName":"_build_nt_matrix","name":"$ti","definition":"my"},{"containerName":"_build_nt_matrix","kind":13,"name":"$tj","line":1140},{"line":1140,"kind":13,"containerName":"_build_nt_matrix","name":"$seqa"},{"kind":13,"containerName":"_build_nt_matrix","name":"$i","line":1140},{"line":1140,"containerName":"_build_nt_matrix","kind":13,"name":"$seqb"},{"name":"$i","kind":13,"containerName":"_build_nt_matrix","line":1140},{"kind":13,"containerName":"_build_nt_matrix","name":"$ti","line":1141},{"line":1142,"name":"$tj","kind":13,"containerName":"_build_nt_matrix"},{"name":"$ti","kind":13,"containerName":"_build_nt_matrix","line":1144},{"line":1144,"name":"$gaps","kind":13,"containerName":"_build_nt_matrix"},{"line":1145,"kind":13,"containerName":"_build_nt_matrix","name":"$tj"},{"kind":13,"containerName":"_build_nt_matrix","name":"$gaps","line":1145},{"definition":"my","name":"$ti_index","localvar":"my","containerName":"_build_nt_matrix","kind":13,"line":1147},{"name":"$NucleotideIndexes","kind":13,"containerName":"_build_nt_matrix","line":1147},{"line":1147,"containerName":"_build_nt_matrix","kind":13,"name":"$ti"},{"definition":"my","name":"$tj_index","localvar":"my","kind":13,"containerName":"_build_nt_matrix","line":1148},{"name":"$NucleotideIndexes","kind":13,"containerName":"_build_nt_matrix","line":1148},{"line":1148,"containerName":"_build_nt_matrix","kind":13,"name":"$tj"},{"name":"$ti_index","kind":13,"containerName":"_build_nt_matrix","line":1150},{"kind":13,"containerName":"_build_nt_matrix","name":"$self","line":1151},{"line":1151,"containerName":"_build_nt_matrix","kind":12,"name":"warn"},{"line":1155,"name":"$basect_matrix","containerName":"_build_nt_matrix","kind":13},{"kind":13,"containerName":"_build_nt_matrix","name":"$ti_index","line":1155},{"name":"$tj_index","kind":13,"containerName":"_build_nt_matrix","line":1155},{"line":1157,"containerName":"_build_nt_matrix","kind":13,"name":"$ti"},{"line":1157,"name":"$tj","kind":13,"containerName":"_build_nt_matrix"},{"containerName":"_build_nt_matrix","kind":13,"name":"$pfreq","line":1158},{"name":"$NucleotideIndexes","containerName":"_build_nt_matrix","kind":13,"line":1158},{"kind":13,"containerName":"_build_nt_matrix","name":"$ti","line":1158},{"line":1158,"name":"$tj","kind":13,"containerName":"_build_nt_matrix"},{"kind":13,"containerName":"_build_nt_matrix","name":"$basect_matrix","line":1161},{"line":1161,"name":"$pfreq","kind":13,"containerName":"_build_nt_matrix"},{"line":1161,"kind":13,"containerName":"_build_nt_matrix","name":"$gaps"}]},{"children":[{"definition":"my","line":1165,"localvar":"my","kind":13,"containerName":"_check_ambiguity_nucleotide","name":"$base1"},{"line":1165,"name":"$base2","kind":13,"containerName":"_check_ambiguity_nucleotide"},{"name":"%iub","kind":13,"localvar":"my","containerName":"_check_ambiguity_nucleotide","line":1166,"definition":"my"},{"name":"iupac_iub","kind":12,"containerName":"_check_ambiguity_nucleotide","line":1166},{"definition":"my","line":1167,"name":"@amb1","localvar":"my","containerName":"_check_ambiguity_nucleotide","kind":13},{"containerName":"_check_ambiguity_nucleotide","kind":13,"name":"$iub","line":1167},{"line":1167,"kind":13,"containerName":"_check_ambiguity_nucleotide","name":"$base1"}],"name":"_check_ambiguity_nucleotide","containerName":"main::","definition":"sub","detail":"($base1,$base2)","line":1164,"kind":12,"range":{"start":{"character":0,"line":1164},"end":{"line":1167,"character":9999}},"signature":{"documentation":"","parameters":[{"label":"$base1"},{"label":"$base2"}],"label":"_check_ambiguity_nucleotide($base1,$base2)"}},{"name":"Bio","kind":12,"containerName":"Tools::IUPAC","line":1166},{"definition":"my","line":1168,"name":"@amb2","kind":13,"localvar":"my","containerName":null},{"line":1168,"kind":13,"containerName":null,"name":"%iub"},{"containerName":null,"kind":13,"name":"$base2","line":1168},{"name":"$pmatch","localvar":"my","kind":13,"containerName":null,"line":1169,"definition":"my"},{"line":1170,"containerName":null,"localvar":"my","kind":13,"name":"$amb","definition":"my"},{"name":"@amb1","containerName":null,"kind":13,"line":1170},{"line":1171,"name":"$amb","containerName":null,"kind":13},{"line":1171,"name":"@amb2","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$pmatch","line":1172},{"line":1176,"containerName":null,"kind":13,"name":"%pmatch"},{"line":1177,"name":"@amb1","containerName":null,"kind":13},{"line":1177,"kind":13,"containerName":null,"name":"@amb2"},{"children":[{"localvar":"my","containerName":"_check_arg","kind":13,"name":"$self","line":1185,"definition":"my"},{"line":1185,"containerName":"_check_arg","kind":13,"name":"$aln"},{"line":1186,"containerName":"_check_arg","kind":13,"name":"$aln"},{"line":1186,"name":"$aln","kind":13,"containerName":"_check_arg"},{"name":"isa","containerName":"_check_arg","kind":12,"line":1186},{"line":1187,"name":"$self","kind":13,"containerName":"_check_arg"},{"kind":12,"containerName":"_check_arg","name":"warn","line":1187},{"name":"$aln","kind":13,"containerName":"_check_arg","line":1189},{"name":"get_seq_by_pos","kind":12,"containerName":"_check_arg","line":1189},{"line":1189,"kind":12,"containerName":"_check_arg","name":"alphabet"},{"containerName":"_check_arg","kind":13,"name":"$self","line":1190},{"line":1190,"kind":12,"containerName":"_check_arg","name":"warn"},{"line":1190,"kind":13,"containerName":"_check_arg","name":"$aln"},{"line":1190,"name":"get_seq_by_pos","containerName":"_check_arg","kind":12},{"line":1190,"name":"alphabet","containerName":"_check_arg","kind":12}],"containerName":"main::","name":"_check_arg","definition":"sub","detail":"($self,$aln)","line":1184,"range":{"start":{"character":0,"line":1184},"end":{"character":9999,"line":1194}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"","label":"_check_arg($self,$aln)"}},{"line":1211,"range":{"start":{"character":0,"line":1211},"end":{"line":1218,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)","label":"pairwise_stats($self,$value)"},"children":[{"localvar":"my","containerName":"pairwise_stats","kind":13,"name":"$self","line":1212,"definition":"my"},{"line":1212,"kind":13,"containerName":"pairwise_stats","name":"$value"},{"name":"$value","containerName":"pairwise_stats","kind":13,"line":1213},{"line":1214,"name":"$self","kind":13,"containerName":"pairwise_stats"},{"line":1214,"kind":13,"containerName":"pairwise_stats","name":"$value"},{"kind":13,"containerName":"pairwise_stats","name":"$self","line":1216}],"containerName":"main::","name":"pairwise_stats","definition":"sub","detail":"($self,$value)"},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"calc_KaKs_pair","line":1235,"definition":"my"},{"name":"$aln","containerName":"calc_KaKs_pair","kind":13,"line":1235},{"name":"$seq1_id","containerName":"calc_KaKs_pair","kind":13,"line":1235},{"name":"$seq2_id","containerName":"calc_KaKs_pair","kind":13,"line":1235},{"line":1236,"containerName":"calc_KaKs_pair","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"calc_KaKs_pair","line":1236},{"line":1238,"name":"$self","kind":13,"containerName":"calc_KaKs_pair"},{"line":1238,"containerName":"calc_KaKs_pair","kind":12,"name":"throw"},{"line":1238,"kind":13,"containerName":"calc_KaKs_pair","name":"$aln"},{"name":"$aln","containerName":"calc_KaKs_pair","kind":13,"line":1238},{"name":"isa","kind":12,"containerName":"calc_KaKs_pair","line":1238},{"name":"@seqs","containerName":"calc_KaKs_pair","localvar":"my","kind":13,"line":1239,"definition":"my"},{"kind":13,"containerName":"calc_KaKs_pair","name":"$seq1_id","line":1242},{"line":1242,"name":"$aln","containerName":"calc_KaKs_pair","kind":13},{"containerName":"calc_KaKs_pair","kind":12,"name":"each_seq_with_id","line":1242},{"name":"$seq1_id","kind":13,"containerName":"calc_KaKs_pair","line":1242},{"line":1242,"kind":12,"containerName":"calc_KaKs_pair","name":"seq"},{"kind":13,"containerName":"calc_KaKs_pair","name":"$seq2_id","line":1243},{"containerName":"calc_KaKs_pair","kind":13,"name":"$aln","line":1243},{"name":"each_seq_with_id","kind":12,"containerName":"calc_KaKs_pair","line":1243},{"line":1243,"containerName":"calc_KaKs_pair","kind":13,"name":"$seq2_id"},{"line":1243,"kind":12,"containerName":"calc_KaKs_pair","name":"seq"},{"line":1245,"name":"$seqs","containerName":"calc_KaKs_pair","kind":13},{"name":"$seqs","kind":13,"containerName":"calc_KaKs_pair","line":1245},{"containerName":"calc_KaKs_pair","kind":13,"name":"$self","line":1246},{"line":1246,"containerName":"calc_KaKs_pair","kind":12,"name":"throw"},{"definition":"my","name":"$results","containerName":"calc_KaKs_pair","localvar":"my","kind":13,"line":1248},{"line":1249,"name":"$self","containerName":"calc_KaKs_pair","kind":13},{"line":1249,"name":"_get_av_ds_dn","containerName":"calc_KaKs_pair","kind":12},{"line":1249,"name":"@seqs","kind":13,"containerName":"calc_KaKs_pair"},{"name":"$results","containerName":"calc_KaKs_pair","kind":13,"line":1249},{"name":"$results","kind":13,"containerName":"calc_KaKs_pair","line":1250}],"containerName":"main::","name":"calc_KaKs_pair","definition":"sub","detail":"($self,$aln,$seq1_id,$seq2_id)","line":1234,"range":{"end":{"character":9999,"line":1252},"start":{"line":1234,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$seq1_id"},{"label":"$seq2_id"}],"label":"calc_KaKs_pair($self,$aln,$seq1_id,$seq2_id)"}},{"kind":12,"name":"id","line":1242},{"line":1242,"name":"seq","kind":12},{"line":1243,"name":"id","kind":12},{"line":1243,"kind":12,"name":"seq"},{"definition":"sub","detail":"($self,$aln)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"calc_all_KaKs_pairs","name":"$self","line":1271},{"name":"$aln","kind":13,"containerName":"calc_all_KaKs_pairs","line":1271},{"name":"$self","kind":13,"containerName":"calc_all_KaKs_pairs","line":1272},{"kind":12,"containerName":"calc_all_KaKs_pairs","name":"throw","line":1272},{"name":"$aln","containerName":"calc_all_KaKs_pairs","kind":13,"line":1272},{"name":"$aln","containerName":"calc_all_KaKs_pairs","kind":13,"line":1272},{"line":1272,"name":"isa","containerName":"calc_all_KaKs_pairs","kind":12},{"line":1273,"name":"@seqs","localvar":"my","kind":13,"containerName":"calc_all_KaKs_pairs","definition":"my"},{"name":"$seq","containerName":"calc_all_KaKs_pairs","localvar":"my","kind":13,"line":1274,"definition":"my"},{"line":1274,"containerName":"calc_all_KaKs_pairs","kind":13,"name":"$aln"},{"line":1274,"name":"each_seq","kind":12,"containerName":"calc_all_KaKs_pairs"},{"kind":13,"containerName":"calc_all_KaKs_pairs","name":"@seqs","line":1275},{"line":1275,"kind":13,"containerName":"calc_all_KaKs_pairs","name":"$seq"},{"line":1275,"kind":12,"containerName":"calc_all_KaKs_pairs","name":"display_id"},{"kind":13,"containerName":"calc_all_KaKs_pairs","name":"$seq","line":1275},{"kind":12,"containerName":"calc_all_KaKs_pairs","name":"seq","line":1275},{"line":1277,"localvar":"my","kind":13,"containerName":"calc_all_KaKs_pairs","name":"$results","definition":"my"},{"name":"$results","kind":13,"containerName":"calc_all_KaKs_pairs","line":1278},{"kind":13,"containerName":"calc_all_KaKs_pairs","name":"$self","line":1278},{"kind":12,"containerName":"calc_all_KaKs_pairs","name":"_get_av_ds_dn","line":1278},{"name":"@seqs","kind":13,"containerName":"calc_all_KaKs_pairs","line":1278},{"name":"$results","kind":13,"containerName":"calc_all_KaKs_pairs","line":1278},{"name":"$results","kind":13,"containerName":"calc_all_KaKs_pairs","line":1279}],"containerName":"main::","name":"calc_all_KaKs_pairs","signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.\n\n\nsub calc_KaKs_pair {\n    my ( $self, $aln, $seq1_id, $seq2_id) = @_;\n    $self->throw(\"Needs 3 arguments - an alignment object, and 2 sequence ids\") \n\tif @_!= 4;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs = (\n\t\t#{id => $seq1_id, seq =>($aln->each_seq_with_id($seq1_id))[0]->seq},\n\t\t#{id => $seq2_id, seq =>($aln->each_seq_with_id($seq2_id))[0]->seq}\n\t\t{id => $seq1_id, seq => uc(($aln->each_seq_with_id($seq1_id))[0]->seq)},\n                {id => $seq2_id, seq => uc(($aln->each_seq_with_id($seq2_id))[0]->seq)}\n\t       ) ;\n    if (length($seqs[0]{'seq'}) != length($seqs[1]{'seq'})) {\n\t$self->throw(\" aligned sequences must be of equal length!\");\n    }\n    my $results = [];\n    $self->_get_av_ds_dn(\\@seqs, $results);\n    return $results;\n\n}\n\n=head2 calc_all_KaKs_pairs\n\n Title    : calc_all_KaKs_pairs\n Useage   : my $results2 = $stats->calc_KaKs_pair($alnobj).\n Function : Calculates Nei_gojobori statistics for all pairwise\n            combinations in sequence.\n Arguments: A Bio::Align::ALignI compliant object such as\n            a Bio::SimpleAlign object.\n Returns  : A reference to an array of hashes of statistics of\n            all pairwise comparisons in the alignment.","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"calc_all_KaKs_pairs($self,$aln)"},"line":1269,"range":{"start":{"character":0,"line":1269},"end":{"line":1280,"character":9999}},"kind":12},{"kind":12,"name":"id","line":1275},{"kind":12,"name":"seq","line":1275},{"signature":{"documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.\n\n\nsub calc_KaKs_pair {\n    my ( $self, $aln, $seq1_id, $seq2_id) = @_;\n    $self->throw(\"Needs 3 arguments - an alignment object, and 2 sequence ids\") \n\tif @_!= 4;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs = (\n\t\t#{id => $seq1_id, seq =>($aln->each_seq_with_id($seq1_id))[0]->seq},\n\t\t#{id => $seq2_id, seq =>($aln->each_seq_with_id($seq2_id))[0]->seq}\n\t\t{id => $seq1_id, seq => uc(($aln->each_seq_with_id($seq1_id))[0]->seq)},\n                {id => $seq2_id, seq => uc(($aln->each_seq_with_id($seq2_id))[0]->seq)}\n\t       ) ;\n    if (length($seqs[0]{'seq'}) != length($seqs[1]{'seq'})) {\n\t$self->throw(\" aligned sequences must be of equal length!\");\n    }\n    my $results = [];\n    $self->_get_av_ds_dn(\\@seqs, $results);\n    return $results;\n\n}\n\n=head2 calc_all_KaKs_pairs\n\n Title    : calc_all_KaKs_pairs\n Useage   : my $results2 = $stats->calc_KaKs_pair($alnobj).\n Function : Calculates Nei_gojobori statistics for all pairwise\n            combinations in sequence.\n Arguments: A Bio::Align::ALignI compliant object such as\n            a Bio::SimpleAlign object.\n Returns  : A reference to an array of hashes of statistics of\n            all pairwise comparisons in the alignment.\n\n\n\n\nsub calc_all_KaKs_pairs {\n#returns a multi_element_array with all pairwise comparisons\n\tmy ($self,$aln) = @_;\n\t$self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n\tmy @seqs;\n\tfor my $seq ($aln->each_seq) {\n\t\tpush @seqs, {id => $seq->display_id, seq=>$seq->seq};\n\t\t}\n\tmy $results ;\n\t$results = $self->_get_av_ds_dn(\\@seqs, $results);\n\treturn $results;\n}\n\n=head2 calc_average_KaKs\n\n Title    : calc_average_KaKs.  \n Useage   : my $res= $stats->calc_average_KaKs($alnobj, 1000).\n Function : calculates Nei_Gojobori stats for average of all \n            sequences in the alignment.\n Args     : A Bio::Align::AlignI compliant object such as a\n            Bio::SimpleAlign object, number of bootstrap iterations\n            (default 1000).\n Returns  : A reference to a hash of statistics as listed in Description.","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$bootstrap_rpt"}],"label":"calc_average_KaKs($self,$aln,$bootstrap_rpt)"},"range":{"start":{"line":1295,"character":0},"end":{"character":9999,"line":1311}},"kind":12,"line":1295,"detail":"($self,$aln,$bootstrap_rpt)","definition":"sub","containerName":"main::","name":"calc_average_KaKs","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"calc_average_KaKs","name":"$self","line":1298},{"name":"$aln","kind":13,"containerName":"calc_average_KaKs","line":1298},{"line":1298,"name":"$bootstrap_rpt","containerName":"calc_average_KaKs","kind":13},{"line":1299,"kind":13,"containerName":"calc_average_KaKs","name":"$bootstrap_rpt"},{"containerName":"calc_average_KaKs","kind":13,"name":"$self","line":1300},{"line":1300,"kind":12,"containerName":"calc_average_KaKs","name":"throw"},{"name":"$aln","containerName":"calc_average_KaKs","kind":13,"line":1300},{"name":"$aln","kind":13,"containerName":"calc_average_KaKs","line":1300},{"line":1300,"name":"isa","containerName":"calc_average_KaKs","kind":12},{"definition":"my","containerName":"calc_average_KaKs","localvar":"my","kind":13,"name":"@seqs","line":1301},{"localvar":"my","kind":13,"containerName":"calc_average_KaKs","name":"$seq","line":1302,"definition":"my"},{"line":1302,"kind":13,"containerName":"calc_average_KaKs","name":"$aln"},{"line":1302,"name":"each_seq","kind":12,"containerName":"calc_average_KaKs"},{"line":1303,"containerName":"calc_average_KaKs","kind":13,"name":"@seqs"},{"containerName":"calc_average_KaKs","kind":13,"name":"$seq","line":1303},{"line":1303,"name":"display_id","kind":12,"containerName":"calc_average_KaKs"},{"name":"$seq","containerName":"calc_average_KaKs","kind":13,"line":1303},{"line":1303,"containerName":"calc_average_KaKs","kind":12,"name":"seq"},{"containerName":"calc_average_KaKs","localvar":"my","kind":13,"name":"$results","line":1305,"definition":"my"},{"name":"$ds_orig","kind":13,"localvar":"my","containerName":"calc_average_KaKs","line":1306,"definition":"my"},{"line":1306,"name":"$dn_orig","containerName":"calc_average_KaKs","kind":13},{"line":1306,"name":"$self","containerName":"calc_average_KaKs","kind":13},{"name":"_get_av_ds_dn","containerName":"calc_average_KaKs","kind":12,"line":1306},{"line":1306,"containerName":"calc_average_KaKs","kind":13,"name":"@seqs"},{"name":"$results","kind":13,"containerName":"calc_average_KaKs","line":1308},{"line":1308,"kind":13,"containerName":"calc_average_KaKs","name":"$ds_orig"},{"containerName":"calc_average_KaKs","kind":13,"name":"$dn_orig","line":1308},{"line":1309,"name":"$self","containerName":"calc_average_KaKs","kind":13},{"line":1309,"name":"_run_bootstrap","containerName":"calc_average_KaKs","kind":12},{"name":"@seqs","kind":13,"containerName":"calc_average_KaKs","line":1309},{"line":1309,"name":"$results","containerName":"calc_average_KaKs","kind":13},{"name":"$bootstrap_rpt","kind":13,"containerName":"calc_average_KaKs","line":1309},{"line":1310,"kind":13,"containerName":"calc_average_KaKs","name":"$results"}]},{"line":1303,"kind":12,"name":"id"},{"kind":12,"name":"seq","line":1303},{"line":1308,"kind":12,"name":"D_s"},{"name":"D_n","kind":12,"line":1308},{"signature":{"label":"_run_bootstrap($self,$seq_ref,$results,$bootstrap_rpt)","parameters":[{"label":"$self"},{"label":"$seq_ref"},{"label":"$results"},{"label":"$bootstrap_rpt"}],"documentation":"############# primary internal subs for alignment comparisons ########################"},"range":{"start":{"character":0,"line":1315},"end":{"character":9999,"line":1331}},"kind":12,"line":1315,"detail":"($self,$seq_ref,$results,$bootstrap_rpt)","definition":"sub","name":"_run_bootstrap","containerName":"main::","children":[{"name":"$self","containerName":"_run_bootstrap","localvar":"my","kind":13,"line":1319,"definition":"my"},{"line":1319,"name":"$seq_ref","containerName":"_run_bootstrap","kind":13},{"name":"$results","kind":13,"containerName":"_run_bootstrap","line":1319},{"line":1319,"containerName":"_run_bootstrap","kind":13,"name":"$bootstrap_rpt"},{"definition":"my","line":1320,"name":"@seqs","localvar":"my","containerName":"_run_bootstrap","kind":13},{"line":1320,"kind":13,"containerName":"_run_bootstrap","name":"$seq_ref"},{"definition":"my","localvar":"my","containerName":"_run_bootstrap","kind":13,"name":"@btstrp_aoa","line":1321},{"name":"%bootstrap_values","localvar":"my","containerName":"_run_bootstrap","kind":13,"line":1322,"definition":"my"},{"name":"$c","localvar":"my","kind":13,"containerName":"_run_bootstrap","line":1325,"definition":"my"},{"line":1326,"name":"$c","kind":13,"containerName":"_run_bootstrap"},{"line":1326,"name":"$seqs","containerName":"_run_bootstrap","kind":13},{"containerName":"_run_bootstrap","kind":13,"name":"$btstrp_aoa","line":1328},{"line":1328,"name":"$seqs","containerName":"_run_bootstrap","kind":13},{"line":1328,"kind":13,"containerName":"_run_bootstrap","name":"$c"},{"name":"$c","kind":13,"containerName":"_run_bootstrap","line":1330}]},{"line":1322,"name":"ds","kind":12},{"kind":12,"name":"dn","line":1322},{"kind":12,"name":"seqs","line":1327},{"name":"%bootstrap_rpt","containerName":null,"kind":13,"line":1333},{"definition":"my","line":1334,"name":"$sampled","localvar":"my","kind":13,"containerName":null},{"name":"_resample","kind":12,"line":1334},{"line":1334,"kind":13,"containerName":null,"name":"@btstrp_aoa"},{"localvar":"my","kind":13,"containerName":null,"name":"$ds","line":1335,"definition":"my"},{"name":"$dn","kind":13,"containerName":null,"line":1335},{"line":1335,"name":"$self","containerName":null,"kind":13},{"name":"_get_av_ds_dn","kind":12,"containerName":"main::","line":1335},{"line":1335,"containerName":null,"kind":13,"name":"$sampled"},{"name":"%bootstrap_values","containerName":null,"kind":13,"line":1336},{"line":1336,"name":"$ds","kind":13,"containerName":null},{"line":1337,"kind":13,"containerName":null,"name":"%bootstrap_values"},{"kind":13,"containerName":null,"name":"$dn","line":1337},{"containerName":null,"kind":13,"name":"%results","line":1340},{"name":"sampling_variance","kind":12,"line":1340},{"line":1340,"kind":13,"containerName":null,"name":"%bootstrap_values"},{"name":"%results","containerName":null,"kind":13,"line":1341},{"kind":12,"name":"sampling_variance","line":1341},{"kind":13,"containerName":null,"name":"%bootstrap_values","line":1341},{"line":1342,"name":"%results","containerName":null,"kind":13},{"name":"%results","containerName":null,"kind":13,"line":1342},{"line":1342,"containerName":null,"kind":13,"name":"%results"},{"line":1343,"containerName":null,"kind":13,"name":"%results"},{"line":1343,"containerName":null,"kind":13,"name":"%results"},{"kind":12,"range":{"start":{"line":1349,"character":0},"end":{"line":1351,"character":9999}},"line":1349,"containerName":"main::","name":"_resample","children":[{"definition":"my","line":1350,"kind":13,"localvar":"my","containerName":"_resample","name":"$ref"},{"kind":13,"localvar":"my","containerName":"_resample","name":"$codon_num","line":1351,"definition":"my"},{"kind":13,"containerName":"_resample","name":"$ref","line":1351}],"definition":"sub"},{"definition":"my","line":1352,"name":"@altered","localvar":"my","kind":13,"containerName":null},{"line":1353,"kind":13,"containerName":null,"name":"%codon_num"},{"definition":"my","line":1354,"name":"$rand","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"$codon_num","line":1354},{"line":1355,"kind":13,"containerName":null,"name":"%ref"},{"name":"@altered","kind":13,"containerName":null,"line":1356},{"line":1356,"containerName":null,"kind":13,"name":"@ref"},{"line":1356,"name":"$rand","containerName":null,"kind":13},{"line":1359,"name":"@stringed","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":1359,"kind":13,"containerName":null,"name":"$_"},{"line":1359,"name":"@altered","kind":13,"containerName":null},{"name":"@return","localvar":"my","kind":13,"containerName":null,"line":1360,"definition":"my"},{"line":1362,"containerName":null,"kind":13,"name":"@stringed"},{"containerName":null,"kind":13,"name":"@return","line":1363},{"kind":12,"name":"id","line":1363},{"kind":12,"name":"seq","line":1363},{"line":1365,"kind":13,"containerName":null,"name":"@return"},{"kind":12,"range":{"end":{"character":9999,"line":1430},"start":{"line":1368,"character":0}},"line":1368,"definition":"sub","name":"_get_av_ds_dn","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_get_av_ds_dn","kind":13,"line":1370},{"line":1371,"localvar":"my","kind":13,"containerName":"_get_av_ds_dn","name":"$seq_ref","definition":"my"},{"line":1372,"name":"$result","localvar":"my","kind":13,"containerName":"_get_av_ds_dn","definition":"my"},{"definition":"my","name":"@caller","containerName":"_get_av_ds_dn","localvar":"my","kind":13,"line":1373},{"line":1374,"name":"@seqarray","localvar":"my","containerName":"_get_av_ds_dn","kind":13,"definition":"my"},{"line":1374,"name":"$seq_ref","containerName":"_get_av_ds_dn","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_get_av_ds_dn","name":"$bootstrap_score_list","line":1375},{"name":"%dsfor_average","kind":13,"localvar":"my","containerName":"_get_av_ds_dn","line":1377,"definition":"my"},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":"_get_av_ds_dn","line":1378},{"kind":13,"containerName":"_get_av_ds_dn","name":"$i","line":1378},{"containerName":"_get_av_ds_dn","kind":13,"name":"@seqarray","line":1378},{"line":1378,"name":"$i","kind":13,"containerName":"_get_av_ds_dn"},{"line":1379,"localvar":"my","containerName":"_get_av_ds_dn","kind":13,"name":"$j","definition":"my"},{"line":1379,"containerName":"_get_av_ds_dn","kind":13,"name":"$i"},{"line":1379,"name":"$j","kind":13,"containerName":"_get_av_ds_dn"},{"kind":13,"containerName":"_get_av_ds_dn","name":"@seqarray","line":1379},{"containerName":"_get_av_ds_dn","kind":13,"name":"$j","line":1379},{"line":1381,"name":"$seqarray","kind":13,"containerName":"_get_av_ds_dn"},{"line":1381,"name":"$i","kind":13,"containerName":"_get_av_ds_dn"},{"line":1381,"name":"$seqarray","containerName":"_get_av_ds_dn","kind":13},{"name":"$j","kind":13,"containerName":"_get_av_ds_dn","line":1381},{"line":1382,"name":"$self","containerName":"_get_av_ds_dn","kind":13},{"name":"warn","containerName":"_get_av_ds_dn","kind":12,"line":1382},{"localvar":"my","containerName":"_get_av_ds_dn","kind":13,"name":"$syn_site_count","line":1386,"definition":"my"},{"name":"$seqarray","kind":13,"containerName":"_get_av_ds_dn","line":1386},{"kind":13,"containerName":"_get_av_ds_dn","name":"$i","line":1386},{"line":1386,"kind":13,"containerName":"_get_av_ds_dn","name":"$synsites"},{"definition":"my","line":1387,"kind":13,"localvar":"my","containerName":"_get_av_ds_dn","name":"$syn_site_count2"},{"line":1387,"name":"$seqarray","containerName":"_get_av_ds_dn","kind":13},{"kind":13,"containerName":"_get_av_ds_dn","name":"$j","line":1387},{"line":1387,"kind":13,"containerName":"_get_av_ds_dn","name":"$synsites"},{"definition":"my","name":"$syn_count","containerName":"_get_av_ds_dn","localvar":"my","kind":13,"line":1389},{"containerName":"_get_av_ds_dn","kind":13,"name":"$non_syn_count","line":1389},{"line":1389,"kind":13,"containerName":"_get_av_ds_dn","name":"$gap_cnt"},{"line":1389,"containerName":"_get_av_ds_dn","kind":13,"name":"$seqarray"},{"kind":13,"containerName":"_get_av_ds_dn","name":"$i","line":1389},{"line":1389,"containerName":"_get_av_ds_dn","kind":13,"name":"$seqarray"},{"name":"$j","kind":13,"containerName":"_get_av_ds_dn","line":1389},{"localvar":"my","kind":13,"containerName":"_get_av_ds_dn","name":"$av_s_site","line":1391,"definition":"my"},{"name":"$syn_site_count","containerName":"_get_av_ds_dn","kind":13,"line":1391},{"name":"$syn_site_count2","kind":13,"containerName":"_get_av_ds_dn","line":1391},{"definition":"my","containerName":"_get_av_ds_dn","localvar":"my","kind":13,"name":"$av_ns_syn_site","line":1392},{"line":1392,"kind":13,"containerName":"_get_av_ds_dn","name":"$seqarray"},{"name":"$i","kind":13,"containerName":"_get_av_ds_dn","line":1392},{"containerName":"_get_av_ds_dn","kind":13,"name":"$gap_cnt","line":1392},{"line":1392,"containerName":"_get_av_ds_dn","kind":13,"name":"$av_s_site"},{"line":1395,"containerName":"_get_av_ds_dn","localvar":"my","kind":13,"name":"$syn_prop","definition":"my"},{"line":1395,"containerName":"_get_av_ds_dn","kind":13,"name":"$syn_count"},{"line":1395,"name":"$av_s_site","containerName":"_get_av_ds_dn","kind":13},{"line":1396,"name":"$nc_prop","localvar":"my","containerName":"_get_av_ds_dn","kind":13,"definition":"my"},{"line":1396,"name":"$non_syn_count","kind":13,"containerName":"_get_av_ds_dn"},{"line":1396,"containerName":"_get_av_ds_dn","kind":13,"name":"$av_ns_syn_site"},{"line":1399,"localvar":"my","kind":13,"containerName":"_get_av_ds_dn","name":"$d_syn","definition":"my"},{"line":1399,"name":"$self","containerName":"_get_av_ds_dn","kind":13},{"line":1399,"kind":12,"containerName":"_get_av_ds_dn","name":"jk"},{"name":"$syn_prop","containerName":"_get_av_ds_dn","kind":13,"line":1399},{"definition":"my","localvar":"my","containerName":"_get_av_ds_dn","kind":13,"name":"$d_nc","line":1400},{"line":1400,"name":"$self","kind":13,"containerName":"_get_av_ds_dn"},{"line":1400,"name":"jk","kind":12,"containerName":"_get_av_ds_dn"},{"kind":13,"containerName":"_get_av_ds_dn","name":"$nc_prop","line":1400},{"name":"$d_nc","kind":13,"containerName":"_get_av_ds_dn","line":1404},{"line":1404,"name":"$d_syn","kind":13,"containerName":"_get_av_ds_dn"},{"line":1407,"name":"$dsfor_average","kind":13,"containerName":"_get_av_ds_dn"},{"line":1407,"kind":13,"containerName":"_get_av_ds_dn","name":"$d_syn"},{"name":"$dsfor_average","containerName":"_get_av_ds_dn","kind":13,"line":1408},{"kind":13,"containerName":"_get_av_ds_dn","name":"$d_nc","line":1408},{"line":1411,"name":"$caller","containerName":"_get_av_ds_dn","kind":13},{"containerName":"_get_av_ds_dn","kind":13,"name":"$caller","line":1411},{"name":"$d_syn_var","containerName":"_get_av_ds_dn","localvar":"my","kind":13,"line":1413,"definition":"my"},{"line":1413,"name":"$syn_prop","kind":13,"containerName":"_get_av_ds_dn"},{"containerName":"_get_av_ds_dn","kind":13,"name":"$seqarray","line":1413},{"line":1413,"name":"$i","kind":13,"containerName":"_get_av_ds_dn"},{"kind":13,"containerName":"_get_av_ds_dn","name":"$gap_cnt","line":1413},{"definition":"my","containerName":"_get_av_ds_dn","localvar":"my","kind":13,"name":"$d_nc_var","line":1414},{"containerName":"_get_av_ds_dn","kind":13,"name":"$nc_prop","line":1414},{"line":1414,"name":"$seqarray","containerName":"_get_av_ds_dn","kind":13},{"line":1414,"containerName":"_get_av_ds_dn","kind":13,"name":"$i"},{"line":1414,"containerName":"_get_av_ds_dn","kind":13,"name":"$gap_cnt"},{"line":1418,"name":"$z","kind":13,"localvar":"my","containerName":"_get_av_ds_dn","definition":"my"},{"line":1418,"kind":13,"containerName":"_get_av_ds_dn","name":"$d_syn_var"},{"line":1418,"kind":13,"containerName":"_get_av_ds_dn","name":"$d_nc_var"},{"name":"$d_nc","kind":13,"containerName":"_get_av_ds_dn","line":1419},{"line":1419,"containerName":"_get_av_ds_dn","kind":13,"name":"$d_syn"},{"name":"$d_syn_var","kind":13,"containerName":"_get_av_ds_dn","line":1419},{"kind":13,"containerName":"_get_av_ds_dn","name":"$d_nc_var","line":1419},{"line":1421,"containerName":"_get_av_ds_dn","kind":13,"name":"$result"},{"line":1421,"name":"$av_s_site","kind":13,"containerName":"_get_av_ds_dn"},{"line":1421,"containerName":"_get_av_ds_dn","kind":13,"name":"$av_ns_syn_site"},{"line":1422,"kind":13,"containerName":"_get_av_ds_dn","name":"$syn_count"},{"line":1422,"name":"$non_syn_count","containerName":"_get_av_ds_dn","kind":13},{"line":1423,"kind":13,"containerName":"_get_av_ds_dn","name":"$syn_prop"},{"name":"$nc_prop","containerName":"_get_av_ds_dn","kind":13,"line":1423},{"kind":13,"containerName":"_get_av_ds_dn","name":"$dsfor_average","line":1424},{"kind":13,"containerName":"_get_av_ds_dn","name":"$dsfor_average","line":1425},{"line":1426,"name":"$d_nc_var","containerName":"_get_av_ds_dn","kind":13},{"line":1426,"containerName":"_get_av_ds_dn","kind":13,"name":"$d_syn_var"},{"line":1427,"kind":13,"containerName":"_get_av_ds_dn","name":"$seqarray"},{"line":1427,"containerName":"_get_av_ds_dn","kind":13,"name":"$i"},{"kind":13,"containerName":"_get_av_ds_dn","name":"$seqarray","line":1428},{"line":1428,"kind":13,"containerName":"_get_av_ds_dn","name":"$j"},{"line":1429,"name":"$z","kind":13,"containerName":"_get_av_ds_dn"}]},{"name":"ds","kind":12,"line":1377},{"line":1377,"kind":12,"name":"dn"},{"line":1386,"name":"count_syn_sites","kind":12},{"line":1387,"name":"count_syn_sites","kind":12},{"name":"analyse_mutations","kind":12,"line":1389},{"line":1413,"name":"jk_var","kind":12},{"line":1414,"kind":12,"name":"jk_var"},{"kind":12,"name":"S_d","line":1422},{"name":"N_d","kind":12,"line":1422},{"line":1423,"kind":12,"name":"P_s"},{"kind":12,"name":"P_n","line":1423},{"line":1424,"name":"D_s","kind":12},{"kind":12,"name":"D_n","line":1425},{"line":1426,"kind":12,"name":"D_n_var"},{"line":1426,"kind":12,"name":"D_s_var"},{"line":1427,"kind":12,"name":"Seq1"},{"line":1428,"kind":12,"name":"Seq2"},{"name":"z_score","kind":12,"line":1429},{"line":1431,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"warn","line":1431},{"line":1432,"containerName":null,"kind":13,"name":"$syn_count"},{"line":1432,"name":"$non_syn_count","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":1432},{"line":1432,"name":"verbose","kind":12,"containerName":"main::"},{"name":"$result","containerName":null,"kind":13,"line":1442},{"kind":13,"containerName":null,"name":"@caller","line":1442},{"containerName":null,"kind":13,"name":"@caller","line":1442},{"line":1444,"name":"mean","kind":12},{"containerName":null,"kind":13,"name":"%dsfor_average","line":1444},{"name":"mean","kind":12,"line":1444},{"line":1444,"name":"%dsfor_average","kind":13,"containerName":null},{"children":[{"definition":"my","line":1449,"name":"$self","containerName":"jk","localvar":"my","kind":13},{"name":"$p","kind":13,"containerName":"jk","line":1449},{"kind":13,"containerName":"jk","name":"$p","line":1450},{"containerName":"jk","kind":13,"name":"$self","line":1451},{"line":1451,"kind":12,"containerName":"jk","name":"warn"},{"containerName":"jk","kind":13,"name":"$p","line":1454}],"containerName":"main::","name":"jk","definition":"sub","detail":"($self,$p)","line":1448,"range":{"end":{"line":1455,"character":9999},"start":{"character":0,"line":1448}},"kind":12,"signature":{"label":"jk($self,$p)","documentation":"","parameters":[{"label":"$self"},{"label":"$p"}]}},{"signature":{"label":"jk_var($p,$n)","documentation":"works for large value of n (50?100?)","parameters":[{"label":"$p"},{"label":"$n"}]},"line":1458,"kind":12,"range":{"start":{"line":1458,"character":0},"end":{"line":1461,"character":9999}},"definition":"sub","detail":"($p,$n)","children":[{"definition":"my","line":1459,"name":"$p","kind":13,"localvar":"my","containerName":"jk_var"},{"line":1459,"name":"$n","kind":13,"containerName":"jk_var"},{"name":"$p","containerName":"jk_var","kind":13,"line":1460},{"line":1460,"name":"$p","containerName":"jk_var","kind":13},{"name":"$p","kind":13,"containerName":"jk_var","line":1460},{"line":1460,"kind":13,"containerName":"jk_var","name":"$n"}],"name":"jk_var","containerName":"main::"},{"children":[{"definition":"my","name":"$seq1","kind":13,"localvar":"my","containerName":"analyse_mutations","line":1468},{"name":"$seq2","kind":13,"containerName":"analyse_mutations","line":1468},{"name":"%mutator","kind":13,"localvar":"my","containerName":"analyse_mutations","line":1469,"definition":"my"},{"line":1483,"localvar":"my","kind":13,"containerName":"analyse_mutations","name":"$TOTAL","definition":"my"},{"line":1484,"name":"$TOTAL_n","localvar":"my","kind":13,"containerName":"analyse_mutations","definition":"my"},{"definition":"my","line":1485,"localvar":"my","kind":13,"containerName":"analyse_mutations","name":"$gap_cnt"},{"definition":"my","line":1487,"name":"%input","containerName":"analyse_mutations","localvar":"my","kind":13},{"line":1488,"kind":13,"localvar":"my","containerName":"analyse_mutations","name":"$seqlen","definition":"my"},{"name":"$seq1","kind":13,"containerName":"analyse_mutations","line":1488},{"line":1489,"name":"$j","kind":13,"localvar":"my","containerName":"analyse_mutations","definition":"my"},{"line":1489,"name":"$j","containerName":"analyse_mutations","kind":13},{"line":1489,"containerName":"analyse_mutations","kind":13,"name":"$seqlen"},{"name":"$j","kind":13,"containerName":"analyse_mutations","line":1489},{"line":1490,"name":"$input","kind":13,"containerName":"analyse_mutations"},{"line":1490,"name":"$seq1","containerName":"analyse_mutations","kind":13},{"name":"$j","containerName":"analyse_mutations","kind":13,"line":1490},{"line":1491,"containerName":"analyse_mutations","kind":13,"name":"$input"},{"name":"$seq2","containerName":"analyse_mutations","kind":13,"line":1491},{"line":1491,"name":"$j","containerName":"analyse_mutations","kind":13},{"name":"$input","kind":13,"containerName":"analyse_mutations","line":1494},{"line":1494,"name":"$input","containerName":"analyse_mutations","kind":13},{"line":1495,"containerName":"analyse_mutations","kind":13,"name":"$gap_cnt"},{"definition":"my","name":"$diff_cnt","localvar":"my","kind":13,"containerName":"analyse_mutations","line":1499},{"name":"$same","containerName":"analyse_mutations","kind":13,"line":1499},{"line":1499,"kind":13,"containerName":"analyse_mutations","name":"%input"},{"name":"$diff_cnt","kind":13,"containerName":"analyse_mutations","line":1502},{"line":1503,"kind":13,"containerName":"analyse_mutations","name":"$diff_cnt"},{"name":"$TOTAL","kind":13,"containerName":"analyse_mutations","line":1504},{"kind":13,"containerName":"analyse_mutations","name":"$synchanges","line":1504},{"line":1504,"name":"$input","kind":13,"containerName":"analyse_mutations"},{"line":1504,"kind":13,"containerName":"analyse_mutations","name":"$input"},{"line":1505,"name":"$TOTAL_n","containerName":"analyse_mutations","kind":13},{"line":1505,"kind":13,"containerName":"analyse_mutations","name":"$synchanges"},{"kind":13,"containerName":"analyse_mutations","name":"$input","line":1505},{"line":1505,"kind":13,"containerName":"analyse_mutations","name":"$input"},{"line":1508,"containerName":"analyse_mutations","kind":13,"name":"$diff_cnt"},{"definition":"my","line":1509,"name":"$s_cnt","localvar":"my","containerName":"analyse_mutations","kind":13},{"definition":"my","line":1510,"name":"$n_cnt","localvar":"my","containerName":"analyse_mutations","kind":13},{"definition":"my","name":"$tot_muts","localvar":"my","containerName":"analyse_mutations","kind":13,"line":1511},{"definition":"my","name":"$perm","containerName":"analyse_mutations","localvar":"my","kind":13,"line":1513},{"name":"$mutator","containerName":"analyse_mutations","kind":13,"line":1513},{"line":1513,"kind":13,"containerName":"analyse_mutations","name":"$same"},{"definition":"my","line":1514,"kind":13,"localvar":"my","containerName":"analyse_mutations","name":"$altered"},{"line":1514,"kind":13,"containerName":"analyse_mutations","name":"$input"},{"definition":"my","name":"$prev","kind":13,"localvar":"my","containerName":"analyse_mutations","line":1515},{"line":1515,"kind":13,"containerName":"analyse_mutations","name":"$altered"},{"line":1517,"localvar":"my","containerName":"analyse_mutations","kind":13,"name":"$mut_i","definition":"my"},{"name":"$perm","containerName":"analyse_mutations","kind":13,"line":1517},{"kind":13,"containerName":"analyse_mutations","name":"$altered","line":1518},{"line":1518,"containerName":"analyse_mutations","kind":13,"name":"$mut_i"},{"line":1518,"containerName":"analyse_mutations","kind":13,"name":"$input"},{"name":"$mut_i","kind":13,"containerName":"analyse_mutations","line":1518},{"kind":13,"containerName":"analyse_mutations","name":"$t","line":1519},{"kind":13,"containerName":"analyse_mutations","name":"$CODONS","line":1519},{"name":"$altered","containerName":"analyse_mutations","kind":13,"line":1519},{"line":1520,"kind":13,"containerName":"analyse_mutations","name":"$tot_muts"},{"line":1525,"name":"$s_cnt","containerName":"analyse_mutations","kind":13},{"line":1525,"kind":13,"containerName":"analyse_mutations","name":"$synchanges"},{"name":"$prev","containerName":"analyse_mutations","kind":13,"line":1525},{"name":"$altered","containerName":"analyse_mutations","kind":13,"line":1525},{"line":1528,"name":"$prev","kind":13,"containerName":"analyse_mutations"},{"name":"$altered","kind":13,"containerName":"analyse_mutations","line":1528},{"name":"$tot_muts","kind":13,"containerName":"analyse_mutations","line":1532},{"name":"$TOTAL","kind":13,"containerName":"analyse_mutations","line":1533},{"line":1533,"kind":13,"containerName":"analyse_mutations","name":"$s_cnt"},{"name":"$tot_muts","kind":13,"containerName":"analyse_mutations","line":1533},{"name":"$TOTAL_n","containerName":"analyse_mutations","kind":13,"line":1534},{"name":"$tot_muts","containerName":"analyse_mutations","kind":13,"line":1534},{"line":1534,"kind":13,"containerName":"analyse_mutations","name":"$s_cnt"},{"line":1534,"name":"$tot_muts","kind":13,"containerName":"analyse_mutations"},{"line":1538,"containerName":"analyse_mutations","kind":13,"name":"$diff_cnt"},{"name":"$s_cnt","localvar":"my","containerName":"analyse_mutations","kind":13,"line":1539,"definition":"my"},{"name":"$n_cnt","localvar":"my","containerName":"analyse_mutations","kind":13,"line":1540,"definition":"my"},{"definition":"my","name":"$tot_muts","localvar":"my","kind":13,"containerName":"analyse_mutations","line":1541},{"containerName":"analyse_mutations","localvar":"my","kind":13,"name":"$perm","line":1542,"definition":"my"},{"containerName":"analyse_mutations","kind":13,"name":"$mutator","line":1542},{"definition":"my","name":"$altered","containerName":"analyse_mutations","localvar":"my","kind":13,"line":1543},{"kind":13,"containerName":"analyse_mutations","name":"$input","line":1543},{"line":1544,"kind":13,"localvar":"my","containerName":"analyse_mutations","name":"$prev","definition":"my"},{"line":1544,"kind":13,"containerName":"analyse_mutations","name":"$altered"},{"kind":13,"localvar":"my","containerName":"analyse_mutations","name":"$mut_i","line":1546,"definition":"my"},{"name":"$perm","containerName":"analyse_mutations","kind":13,"line":1546},{"kind":13,"containerName":"analyse_mutations","name":"$altered","line":1547},{"line":1547,"kind":13,"containerName":"analyse_mutations","name":"$mut_i"},{"line":1547,"kind":13,"containerName":"analyse_mutations","name":"$input"},{"line":1547,"name":"$mut_i","containerName":"analyse_mutations","kind":13},{"containerName":"analyse_mutations","kind":13,"name":"$t","line":1548},{"name":"$CODONS","containerName":"analyse_mutations","kind":13,"line":1548},{"containerName":"analyse_mutations","kind":13,"name":"$altered","line":1548},{"line":1549,"name":"$tot_muts","containerName":"analyse_mutations","kind":13},{"line":1555,"containerName":"analyse_mutations","kind":13,"name":"$s_cnt"},{"line":1555,"containerName":"analyse_mutations","kind":13,"name":"$synchanges"},{"name":"$prev","containerName":"analyse_mutations","kind":13,"line":1555},{"line":1555,"name":"$altered","kind":13,"containerName":"analyse_mutations"},{"name":"$prev","containerName":"analyse_mutations","kind":13,"line":1558},{"name":"$altered","kind":13,"containerName":"analyse_mutations","line":1558},{"name":"$tot_muts","kind":13,"containerName":"analyse_mutations","line":1565},{"kind":13,"containerName":"analyse_mutations","name":"$TOTAL","line":1566},{"line":1566,"name":"$s_cnt","kind":13,"containerName":"analyse_mutations"},{"line":1566,"kind":13,"containerName":"analyse_mutations","name":"$tot_muts"},{"name":"$TOTAL_n","kind":13,"containerName":"analyse_mutations","line":1567},{"name":"$s_cnt","kind":13,"containerName":"analyse_mutations","line":1567},{"name":"$tot_muts","containerName":"analyse_mutations","kind":13,"line":1567}],"containerName":"main::","name":"analyse_mutations","definition":"sub","detail":"($seq1,$seq2)","line":1467,"kind":12,"range":{"start":{"line":1467,"character":0},"end":{"line":1569,"character":9999}},"signature":{"label":"analyse_mutations($seq1,$seq2)","parameters":[{"label":"$seq1"},{"label":"$seq2"}],"documentation":" compares 2 sequences to find the number of synonymous/non\n synonymous mutations between them"}},{"line":1499,"kind":12,"name":"count_diffs"},{"name":"OUTER","kind":12,"line":1513},{"line":1522,"name":"OUTER","kind":12},{"line":1542,"name":"OUTER","kind":12},{"line":1551,"name":"OUTER","kind":12},{"line":1571,"name":"$TOTAL","containerName":null,"kind":13},{"name":"$TOTAL_n","containerName":null,"kind":13,"line":1571},{"line":1571,"kind":13,"containerName":null,"name":"$gap_cnt"},{"range":{"start":{"character":0,"line":1575},"end":{"line":1592,"character":9999}},"kind":12,"line":1575,"definition":"sub","name":"count_diffs","containerName":"main::","children":[{"line":1580,"kind":13,"localvar":"my","containerName":"count_diffs","name":"$ref","definition":"my"},{"definition":"my","line":1581,"localvar":"my","kind":13,"containerName":"count_diffs","name":"$cnt"},{"name":"$same","localvar":"my","kind":13,"containerName":"count_diffs","line":1582,"definition":"my"},{"kind":13,"containerName":"count_diffs","name":"$ref","line":1585},{"line":1585,"containerName":"count_diffs","kind":13,"name":"$ref"},{"containerName":"count_diffs","kind":13,"name":"$cnt","line":1586},{"kind":13,"containerName":"count_diffs","name":"$same","line":1588},{"line":1591,"kind":13,"containerName":"count_diffs","name":"$cnt"},{"kind":13,"containerName":"count_diffs","name":"$same","line":1591}]},{"name":"get_syn_changes","containerName":"main::","children":[{"definition":"my","line":1616,"name":"%results","kind":13,"localvar":"my","containerName":"get_syn_changes"},{"definition":"my","line":1617,"name":"@codons","localvar":"my","containerName":"get_syn_changes","kind":13},{"line":1618,"name":"$arr_len","localvar":"my","containerName":"get_syn_changes","kind":13,"definition":"my"},{"name":"@codons","containerName":"get_syn_changes","kind":13,"line":1618},{"name":"$i","localvar":"my","kind":13,"containerName":"get_syn_changes","line":1619,"definition":"my"},{"name":"$i","containerName":"get_syn_changes","kind":13,"line":1619},{"name":"$arr_len","kind":13,"containerName":"get_syn_changes","line":1619},{"line":1619,"containerName":"get_syn_changes","kind":13,"name":"$i"},{"line":1620,"containerName":"get_syn_changes","localvar":"my","kind":13,"name":"$cod1","definition":"my"},{"line":1620,"kind":13,"containerName":"get_syn_changes","name":"$codons"},{"kind":13,"containerName":"get_syn_changes","name":"$i","line":1620},{"definition":"my","line":1621,"kind":13,"localvar":"my","containerName":"get_syn_changes","name":"$j"},{"name":"$i","kind":13,"containerName":"get_syn_changes","line":1621},{"line":1621,"kind":13,"containerName":"get_syn_changes","name":"$j"},{"line":1621,"name":"$arr_len","containerName":"get_syn_changes","kind":13},{"line":1621,"name":"$j","kind":13,"containerName":"get_syn_changes"},{"line":1622,"kind":13,"localvar":"my","containerName":"get_syn_changes","name":"$diff_cnt","definition":"my"},{"line":1623,"name":"$pos","localvar":"my","containerName":"get_syn_changes","kind":13,"definition":"my"},{"line":1624,"containerName":"get_syn_changes","kind":13,"name":"$diff_cnt"},{"name":"$cod1","containerName":"get_syn_changes","kind":13,"line":1624},{"line":1624,"kind":13,"containerName":"get_syn_changes","name":"$pos"},{"name":"$codons","kind":13,"containerName":"get_syn_changes","line":1624},{"line":1624,"kind":13,"containerName":"get_syn_changes","name":"$j"},{"line":1624,"kind":13,"containerName":"get_syn_changes","name":"$pos"},{"name":"$diff_cnt","kind":13,"containerName":"get_syn_changes","line":1626},{"name":"$t","containerName":"get_syn_changes","kind":13,"line":1629},{"kind":13,"containerName":"get_syn_changes","name":"$CODONS","line":1629},{"containerName":"get_syn_changes","kind":13,"name":"$cod1","line":1629},{"name":"$t","kind":13,"containerName":"get_syn_changes","line":1629},{"name":"$CODONS","kind":13,"containerName":"get_syn_changes","line":1629},{"name":"$codons","kind":13,"containerName":"get_syn_changes","line":1629},{"containerName":"get_syn_changes","kind":13,"name":"$j","line":1629},{"line":1630,"kind":13,"containerName":"get_syn_changes","name":"$results"},{"line":1630,"containerName":"get_syn_changes","kind":13,"name":"$cod1"},{"line":1630,"kind":13,"containerName":"get_syn_changes","name":"$codons"},{"line":1630,"name":"$j","containerName":"get_syn_changes","kind":13},{"kind":13,"containerName":"get_syn_changes","name":"$results","line":1631},{"name":"$codons","containerName":"get_syn_changes","kind":13,"line":1631},{"line":1631,"kind":13,"containerName":"get_syn_changes","name":"$j"},{"line":1631,"name":"$cod1","kind":13,"containerName":"get_syn_changes"},{"line":1634,"kind":13,"containerName":"get_syn_changes","name":"$t"},{"line":1634,"containerName":"get_syn_changes","kind":13,"name":"$CODONS"},{"line":1634,"containerName":"get_syn_changes","kind":13,"name":"$cod1"},{"kind":13,"containerName":"get_syn_changes","name":"$t","line":1634},{"name":"$CODONS","containerName":"get_syn_changes","kind":13,"line":1634},{"line":1634,"name":"$codons","containerName":"get_syn_changes","kind":13},{"kind":13,"containerName":"get_syn_changes","name":"$j","line":1634},{"line":1635,"name":"$results","containerName":"get_syn_changes","kind":13},{"kind":13,"containerName":"get_syn_changes","name":"$cod1","line":1635},{"line":1635,"containerName":"get_syn_changes","kind":13,"name":"$codons"},{"containerName":"get_syn_changes","kind":13,"name":"$j","line":1635},{"kind":13,"containerName":"get_syn_changes","name":"$results","line":1636},{"line":1636,"containerName":"get_syn_changes","kind":13,"name":"$codons"},{"name":"$j","kind":13,"containerName":"get_syn_changes","line":1636},{"containerName":"get_syn_changes","kind":13,"name":"$cod1","line":1636},{"name":"$results","containerName":"get_syn_changes","kind":13,"line":1640},{"line":1640,"name":"$cod1","kind":13,"containerName":"get_syn_changes"},{"kind":13,"containerName":"get_syn_changes","name":"$codons","line":1640},{"line":1640,"containerName":"get_syn_changes","kind":13,"name":"$j"},{"line":1641,"name":"$results","containerName":"get_syn_changes","kind":13},{"containerName":"get_syn_changes","kind":13,"name":"$codons","line":1641},{"line":1641,"name":"$j","containerName":"get_syn_changes","kind":13},{"line":1641,"name":"$cod1","containerName":"get_syn_changes","kind":13},{"line":1645,"name":"%results","kind":13,"containerName":"get_syn_changes"}],"definition":"sub","range":{"end":{"line":1646,"character":9999},"start":{"line":1613,"character":0}},"kind":12,"line":1613},{"line":1617,"name":"_make_codons","kind":12},{"detail":"($self,$aln)","definition":"sub","name":"dnds_pattern_number","containerName":"main::","children":[{"line":1660,"name":"$self","kind":13,"localvar":"my","containerName":"dnds_pattern_number","definition":"my"},{"kind":13,"containerName":"dnds_pattern_number","name":"$aln","line":1660},{"line":1661,"name":"$aln","containerName":"dnds_pattern_number","kind":13},{"line":1661,"name":"remove_gaps","kind":12,"containerName":"dnds_pattern_number"},{"kind":12,"containerName":"dnds_pattern_number","name":"length","line":1661}],"signature":{"label":"dnds_pattern_number($self,$aln)","documentation":"1;\n# $Id: DNAStatistics.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Align::DNAStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-AT-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::DNAStatistics - Calculate some statistics for a DNA alignment\n\n=head1 SYNOPSIS\n\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n\n  my $stats = Bio::Align::DNAStatistics->new();\n  my $alignin = Bio::AlignIO->new(-format => 'emboss',\n                                 -file   => 't/data/insulin.water');\n  my $aln = $alignin->next_aln;\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n\n  print $jcmatrix->print_matrix;\n  ## and for measurements of synonymous /nonsynonymous substitutions ##\n\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n                            -file   => 't/data/nei_gojobori_test.aln');\n  my $alnobj = $in->next_aln;\n  my ($seq1id,$seq2id) = map { $_->display_id } $alnobj->each_seq;\n  my $results = $stats->calc_KaKs_pair($alnobj, $seq1id, $seq2id);\n  print \"comparing \".$results->[0]{'Seq1'}.\" and \".$results->[0]{'Seq2'}.\"\\n\";\n  for (sort keys %{$results->[0]} ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $results->[0]{$_});\n  }\n\n  my $results2 = $stats->calc_all_KaKs_pairs($alnobj);\n  for my $an (@$results2){\n      print \"comparing \". $an->{'Seq1'}.\" and \". $an->{'Seq2'}. \" \\n\";\n      for (sort keys %$an ){\n\t  next if /Seq/;\n\t  printf(\"%-9s %.4f \\n\",$_ , $an->{$_});\n      }\n      print \"\\n\\n\";\n  }\n\n  my $result3 = $stats->calc_average_KaKs($alnobj, 1000);\n  for (sort keys %$result3 ){\n      next if /Seq/;\n      printf(\"%-9s %.4f \\n\",$_ , $result3->{$_});\n  }\n\n=head1 DESCRIPTION\n\nThis object contains routines for calculating various statistics and\ndistances for DNA alignments.  The routines are not well tested and do\ncontain errors at this point.  Work is underway to correct them, but\ndo not expect this code to give you the right answer currently!  Use\ndnadist/distmat in the PHLYIP or EMBOSS packages to calculate the\ndistances.\n\n\nSeveral different distance method calculations are supported.  Listed\nin brackets are the pattern which will match\n\n=over 3\n\n* *\n\nJukesCantor [jc|jukes|jukescantor|jukes-cantor]\n\n* *\n\nUncorrected [jcuncor|uncorrected]\n\n* *\n\nF81 [f81|felsenstein]\n\n* *\n\nKimura [k2|k2p|k80|kimura]\n\n* *\n\nTamura [t92|tamura|tamura92]\n\n* *\n\nF84 [f84|felsenstein84]\n\n* *\n\nTajimaNei [tajimanei|tajima\\-nei]\n\n* *\n\nJinNei [jinnei|jin\\-nei] (not implemented)\n\n\nThere are also three methods to calculate the ratio of synonymous to\nnon-synonymous mutations.  All are implementations of the Nei-Gojobori\nevolutionary pathway method and use the Jukes-Cantor method of\nnucleotide substitution. This method works well so long as the\nnucleotide frequencies are roughly equal and there is no significant\ntransition/transversion bias.  In order to use these methods there are\nseveral pre-requisites for the alignment.\n\n=over 3\n\n* 1\n\nDNA alignment must be based on protein alignment. Use the subroutine\nL<Bio::Align::Utilities/aa_to_dna_aln> to achieve this.\n\n* 2\n\nTherefore alignment gaps must be in multiples of 3 (representing an aa\ndeletion/insertion) and at present must be indicated by a '-' symbol.\n\n* 3\n\nAlignment must be solely of coding region and be in reading frame 0 to\nachieve meaningful results\n\n* 4\n\nAlignment must therefore be a multiple of 3 nucleotides long.\n\n* 5\n\nAll sequences must be the same length (including gaps). This should be\nthe case anyway if the sequences have been automatically aligned using\na program like Clustal.\n\n* 6\n\nOnly the standard codon alphabet is supported at present.\n\n\ncalc_KaKs_pair() calculates a number of statistics for a named pair of\nsequences in the alignment.\n\ncalc_all_KaKs_pairs() calculates these statistics for all pairwise\ncomparisons in an MSA.  The statistics returned are:\n\n=over 3\n\n* *\n\nS_d - Number of synonymous mutations between the 2 sequences.\n\n* *\n\nN_d - Number of non-synonymous mutations between the 2 sequences.\n\n* *\n\nS -  Mean number of  synonymous sites in both sequences.\n\n* *\n\nN -  mean number of  synonymous sites in both sequences.\n\n* *\n\nP_s - proportion of synonymous differences in both sequences given by\nP_s = S_d/S.\n\n* *\n\nP_n - proportion of non-synonymous differences in both sequences given\nby P_n = S_n/S.\n\n* *\n\nD_s - estimation of synonymous mutations per synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n - estimation of non-synonymous mutations per non-synonymous site (by\nJukes-Cantor).\n\n* *\n\nD_n_var - estimation of variance of D_n .\n\n* *\n\nD_s_var - estimation of variance of S_n.\n\n* *\n\nz_value - calculation of z value.Positive value indicates D_n E<gt> D_s,\nnegative value indicates D_s E<gt> D_n.\n\n\nThe statistics returned by calc_average_KaKs are:\n\n=over 3\n\n* *\n\nD_s - Average number of synonymous mutations/synonymous site.\n\n* *\n\nD_n - Average number of non-synonymous mutations/non-synonymous site.\n\n* *\n\nD_s_var - Estimated variance of Ds from bootstrapped alignments.\n\n* *\n\nD_n_var - Estimated variance of Dn from bootstrapped alignments.\n\n* *\n\nz_score - calculation of z value. Positive value indicates D_n E<gt>D_s,\nnegative values vice versa.\n\n\nThe design of the code is based around the explanation of the\nNei-Gojobori algorithm in the excellent book \"Molecular Evolution and\nPhylogenetics\" by Nei and Kumar, published by Oxford University\nPress. The methods have been tested using the worked example 4.1 in\nthe book, and reproduce those results. If people like having this sort\nof analysis in BioPerl other methods for estimating Ds and Dn can be\nprovided later.\n\nMuch of the DNA distance code is based on implementations in EMBOSS\n(Rice et al, www.emboss.org) [distmat.c] and PHYLIP (J. Felsenstein et\nal) [dnadist.c].  Insight also gained from Eddy, Durbin, Krogh, &\nMitchison.\n\n=head1 REFERENCES\n\n=over 3\n\n* *\n\nD_JukesCantor \n\n\"Phylogenetic Inference\", Swoffrod, Olsen, Waddell and Hillis, in\nMol. Systematics, 2nd ed, 1996, Ch 11.  Derived from \"Evolution of\nProtein Molecules\", Jukes & Cantor, in Mammalian Prot. Metab., III,\n1969, pp. 21-132.\n\n* *\n\nD_Tamura\n\nK Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n* *\n\nD_Kimura \n\nM Kimura, J. Mol. Evol., 1980, 16, 111.\n\n* *\n\nJinNei \n\nJin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n* *\n\nD_TajimaNei\n\nTajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nRichard Adams, richard.adams@ed.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::DNAStatistics;\nuse vars qw(%DNAChanges @Nucleotides %NucleotideIndexes\n\t    $GapChars $SeqCount $DefaultGapPenalty %DistanceMethods\n            $CODONS %synchanges $synsites $Precision $GCChhars);\nuse strict;\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::IUPAC;\n\nBEGIN {\n    $GapChars = '[\\.\\-]';\n    $GCChhars = '[GCS]';\n    @Nucleotides = qw(A G T C);\n    $SeqCount = 2;\n    $Precision = 5;\n    \n    # these values come from EMBOSS distmat implementation\n    %NucleotideIndexes = ( 'A' => 0,\n\t\t\t   'T' => 1,\n\t\t\t   'C' => 2,\n\t\t\t   'G' => 3,\n\n\t\t\t   'AT' => 0,\n\t\t\t   'AC' => 1,\n\t\t\t   'AG' => 2,\n\t\t\t   'CT' => 3,\n\t\t\t   'GT' => 4,\n\t\t\t   'CG' => 5,\n\n# these are wrong now\n#\t\t\t   'S' => [ 1, 3],\n#\t\t\t   'W' => [ 0, 4],\n#\t\t\t   'Y' => [ 2, 3],\n#\t\t\t   'R' => [ 0, 1],\n#\t\t\t   'M' => [ 0, 3],\n#\t\t\t   'K' => [ 1, 2],\n#\t\t\t   'B' => [ 1, 2, 3],\n#\t\t\t   'H' => [ 0, 2, 3],\n#\t\t\t   'V' => [ 0, 1, 3],\n#\t\t\t   'D' => [ 0, 1, 2],\n\t\t\t   );\n\n    $DefaultGapPenalty = 0;\n    # could put ambiguities here?\n    %DNAChanges = ( 'Transversions' => { 'A' => [ 'T', 'C'],\n\t\t\t\t\t 'T' => [ 'A', 'G'],\n\t\t\t\t\t 'C' => [ 'A', 'G'],\n\t\t\t\t\t 'G' => [ 'C', 'T'],\n\t\t\t\t     },\n\t\t    'Transitions'   => { 'A' => [ 'G' ],\n\t\t\t\t\t 'G' => [ 'A' ],\n\t\t\t\t\t 'C' => [ 'T' ],\n\t\t\t\t\t 'T' => [ 'C' ],\n\t\t\t\t     },\n\t\t    );\n    %DistanceMethods = ( 'jc|jukes|jukescantor|jukes\\-cantor' => 'JukesCantor',\n\t\t\t 'jcuncor|uncorrected'   => 'Uncorrected',\n\t\t\t 'f81|felsenstein81'     => 'F81',\n\t\t\t 'k2|k2p|k80|kimura'     => 'Kimura',\n\t\t\t 't92|tamura|tamura92'   => 'Tamura',\n\t\t\t 'f84|felsenstein84'     => 'F84',\n\t\t\t 'tajimanei|tajima\\-nei' => 'TajimaNei',\n\t\t\t 'jinnei|jin\\-nei'       => 'JinNei');\n\n}\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n## generate look up hashes for Nei_Gojobori methods##\n$CODONS = get_codons();\nmy @t = split '', \"FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG\";\n#create look up hash of number of possible synonymous mutations per codon\n$synsites = get_syn_sites();\n#create reference look up hash of single basechanges in codons\n%synchanges = get_syn_changes();\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::DNAStatistics->new();\n Function: Builds a new Bio::Align::DNAStatistics object \n Returns : Bio::Align::DNAStatistics\n Args    : none\n\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n    return $self;\n}\n\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\nSee also: L<Bio::Matrix::PhylipDist>\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'JukesCantor';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_JukesCantor\n\n Title   : D_JukesCantor\n Usage   : my $d = $stat->D_JukesCantor($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jukes-Cantor 1 parameter model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           double - gap penalty\n\n\n\nsub D_JukesCantor{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j][$j] = sprintf($precisionstr,0);\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_F81\n\n Title   : D_F81\n Usage   : my $d = $stat->D_F81($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1981 distance model. \n           Relaxes the assumption of equal base frequencies that is\n           in JC.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_F81{\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   for(my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);        \n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   # just want diagonals\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / ($aln->length - $gaps + ( $gaps * $gappenalty)));\n\t   my $d = (- 3 / 4) * log ( 1 - (4 * $D/ 3));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values);   \n}\n\n=head2 D_Uncorrected\n\n Title   : D_Uncorrected\n Usage   : my $d = $stats->D_Uncorrected($aln)\n Function: Calculate a distance D, no correction for multiple substitutions \n           is used.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> (DNA Alignment)\n           [optional] gap penalty\n\n\nsub D_Uncorrected {\n   my ($self,$aln,$gappenalty) = @_;\n   $gappenalty = $DefaultGapPenalty unless defined $gappenalty;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my $len = $aln->length;\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $m = ( $matrix->[0]->[0] + \n\t\t     $matrix->[1]->[1] +\n\t\t     $matrix->[2]->[2] +\n\t\t     $matrix->[3]->[3] ); \n\t   my $D = 1 - ( $m / ( $len - $gaps + ( $gaps * $gappenalty)));\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n# M Kimura, J. Mol. Evol., 1980, 16, 111.\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $K = 0;\n\t   my $denom = ( 1 - (2 * $P) - $Q);\n\t   if( $denom == 0 ) {\n\t       $self->throw(\"cannot find distance for \",$i+1,\n\t\t\t    \",\",$j+1,\" $P, $Q\\n\");\n\t   }\n\t   my $a = 1 / ( 1 - (2 * $P) - $Q);\n\t   my $b = 1 / ( 1 - 2 * $Q );\n\t   if( $a < 0 || $b < 0 ) { \n\t       $K = -1;\n\t   } else{ \n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n}\n\n\n=head2 D_Kimura_variance\n\n Title   : D_Kimura\n Usage   : my $d = $stat->D_Kimura_variance($aln)\n Function: Calculates D (pairwise distance) between all pairs of sequences \n           in an alignment using the Kimura 2 parameter model.\n Returns : array of 2 L<Bio::Matrix::PhylipDist>,\n           the first is the Kimura distance and the second is\n           a matrix of variance V(K)\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Kimura_variance {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@names,@values,%dist,@var);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   unless( $L ) { \n\t       $L = 1;\n\t   }\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my ($a,$b,$K,$var_k);\n\t   my $a_denom = ( 1 - (2 * $P) - $Q);\n\t   my $b_denom = 1 - 2 * $Q;\n\t   unless( $a_denom > 0 && $b_denom > 0 ) {\n\t       $a = 1;\n\t       $b = 1;\n\t       $K = -1;\n\t       $var_k = -1;\n\t   } else { \n\t       $a = 1 / $a_denom;\n\t       $b = 1 / $b_denom;\n\t       $K = (1/2) * log ( $a ) + (1/4) * log($b);\n\t       # from Wu and Li 1985 which in turn is from Kimura 1980\n\t       my $c = ( $a - $b ) / 2;\n\t       my $d = ( $a + $b ) / 2;\n\t       $var_k = ( $a**2 * $P + $d**2 * $Q - ( $a * $P + $d * $Q)**2 ) / $L;\n\t   }\n\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$K);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];   \n\t   $values[$j]->[$j] = sprintf($precisionstr,0); \n\t   \n\t   $var[$j]->[$i] = $var[$i]->[$j] = sprintf($precisionstr,$var_k);\n\t   $var[$j]->[$j] = $values[$j]->[$j];\n       }\n   }\n   return ( Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@values),\n\t    Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t\t -matrix  => \\%dist,\n\t\t\t\t\t -names   => \\@names,\n\t\t\t\t\t -values  => \\@var)\n\t    );\n}\n\n\n#  K Tamura, Mol. Biol. Evol. 1992, 9, 678.\n\n=head2 D_Tamura\n\n Title   : D_Tamura\n Usage   : Calculates D (pairwise distance) between 2 sequences in an \n           alignment using Tamura 1992 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_Tamura {\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist,$i,$j);\n   my $seqct = 0;\n   my $length = $aln->length;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my (@gap,@gc,@trans,@tranv,@score);\n   $i = 0;\n   for my $t1 ( @seqs ) {\n       $j = 0;\n       for my $t2 ( @seqs ) {\n\t   $gap[$i][$j] = 0;\n\t   for( my $k = 0; $k < $length; $k++ ) {\n\t       my ($c1,$c2) = ( substr($seqs[$i],$k,1),\n\t\t\t\tsubstr($seqs[$j],$k,1) );\n\t       if( $c1 =~ /^$GapChars$/ ||\n\t\t   $c2 =~ /^$GapChars$/ ) {\n\t\t   $gap[$i][$j]++;\t\n\t       } elsif( $c2 =~ /^$GCChhars$/i ) {\n\t\t   $gc[$i][$j]++;\n\t       } \n\t   }\n\t   $gc[$i][$j] = ( $gc[$i][$j] / \n\t\t\t   ($length - $gap[$i][$j]) );\n\t   $j++;\n       }\n       $i++;\n   }\n   \n   for( $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       \n       for( $j = $i+1; $j < $seqct; $j++ ) {\n\t   \n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t   my $P = $self->transitions($pairwise) / $L;\n\t   my $Q = $self->transversions($pairwise) / $L;\n\t   my $C = $gc[$i][$j] + $gc[$j][$i]- \n\t       ( 2 * $gc[$i][$j] * $gc[$j][$i] );\n\t   if( $P ) {\n\t       $P = $P / $C;\n\t   }\n\t   my $d = -($C * log(1- $P - $Q)) -(0.5* ( 1 - $C) * log(1 - 2 * $Q));\n           # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n=head2 D_F84\n\n Title   : D_F84\n Usage   : my $d = $stat->D_F84($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Felsenstein 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n           [optional] double - gap penalty\n\n\nsub D_F84 {\n   my ($self,$aln,$gappenalty) = @_;\n   return 0 unless $self->_check_arg($aln);\n   $self->throw_not_implemented();\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       my $id = $seq->display_id;\n       if( ! length($id) ||       # deal with empty names\n\t   $id =~ /^\\s+$/ ) {\n\t   $id = $seqct+1;\n       }\n       push @names, $id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n       }\n   }   \n}\n\n# Tajima and Nei, Mol. Biol. Evol. 1984, 1, 269.\n#  Tajima-Nei correction used for multiple substitutions in the calc\n# of the distance matrix. Nucleic acids only.\n#\n#  D = p-distance = 1 - (matches/(posns_scored + gaps)\n#\n#  distance = -b * ln(1-D/b)\n#\n\n=head2 D_TajimaNei\n\n Title   : D_TajimaNei\n Usage   : my $d = $stat->D_TajimaNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the TajimaNei 1984 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : Bio::Align::AlignI of DNA sequences\n\n\n\nsub D_TajimaNei{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       # if there is no name, \n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $precisionstr = \"%.$Precision\".\"f\";\n   my ($i,$j,$bs);\n   # pairwise\n   for( $i =0; $i < $seqct -1; $i++ ) {\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n\n       for ( $j = $i+1; $j <$seqct;$j++ ) {\n\t   my ($matrix,$pfreq,$gaps) = $self->_build_nt_matrix($seqs[$i],\n\t\t\t\t\t\t\t       $seqs[$j]);\n\t   my $pairwise = $aln->select_noncont($i+1,$j+1);\n\t   my $slen = $self->pairwise_stats->number_of_comparable_bases($pairwise);\t    \n\t   my $fij2 = 0;\n\t   for( $bs = 0; $bs < 4; $bs++ ) {\n\t       my $fi = 0;\n\t       map {$fi += $matrix->[$bs]->[$_] } 0..3;\n\t       my $fj = 0;\n\t       # summation \n\t       map { $fj += $matrix->[$_]->[$bs] } 0..3;\n\t       my $fij = ( $fi && $fj ) ? ($fi + $fj) /( 2 * $slen) : 0;\n\t       $fij2 += $fij**2;\n\t   }\n\t   \n\t   my ($pair,$h) = (0,0);\n\t   for( $bs = 0; $bs < 3; $bs++ ) {\n\t       for(my $bs1 = $bs+1; $bs1 <= 3; $bs1++ ) {\n\t\t   my $fij = $pfreq->[$pair++] / $slen;\n\t\t   if( $fij ) {\n\t\t       \n\t\t       my ($ci1,$ci2,$cj1,$cj2) = (0,0,0,0);\n\n\t\t       map { $ci1 += $matrix->[$_]->[$bs] } 0..3;\n\t\t       map { $cj1 += $matrix->[$bs]->[$_] } 0..3;\n\t\t       map { $ci2 += $matrix->[$_]->[$bs1] } 0..3;\n\t\t       map { $cj2 += $matrix->[$bs1]->[$_] } 0..3;\n\t\t       \n\t\t       if( $fij ) {\n\t\t\t   $h += ( ($fij**2) / 2 ) / \n\t\t\t       (  ( ( $ci1 + $cj1 ) / (2 * $slen) ) *\n\t\t\t\t  ( ( $ci2 + $cj2 ) / (2 * $slen) ) \n\t\t\t\t  );\n\t\t       }\n\t\t       $self->debug( \"slen is $slen h is $h fij = $fij ci1 =$ci1 cj1=$cj1 ci2=$ci2 cj2=$cj2\\n\");\n\t\t   }\n\t       }\n\t   }\n\t   # just want diagonals which are matches (A matched A, C -> C)\n\n\t   my $m = ( $matrix->[0]->[0] + $matrix->[1]->[1] + \n\t\t     $matrix->[2]->[2] + $matrix->[3]->[3] );\n\t   my $D = 1 - ( $m / $slen);\n\t   my $d;\n\t   if( $h == 0 ) {\n\t       $d = -1;\n\t   } else {\n\t       my $b = (1 - $fij2 + (($D**2)/$h)) / 2;\n\t       my $c = 1- $D/ $b;\n\n\t       if( $c < 0 ) {\n\t\t   $d = -1;\n\t       } else { \n\t\t   $d = (-1 * $b) * log ( $c);\n\t       }\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\t   $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$d);\n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_DNAstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n\n}\n\n# Jin and Nei, Mol. Biol. Evol. 82, 7, 1990.\n\n=head2 D_JinNei\n\n Title   : D_JinNei\n Usage   : my $d = $stat->D_JinNei($aln)\n Function: Calculates D (pairwise distance) between 2 sequences in an \n           alignment using the Jin-Nei 1990 distance model. \n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI> of DNA sequences\n\n\n\nsub D_JinNei{\n   my ($self,@args) = @_;\n   $self->warn(\"JinNei implementation not completed\");\n   return;\n}\n\n=head2 transversions\n\n Title   : transversions\n Usage   : my $transversions = $stats->transversion($aln);\n Function: Calculates the number of transversions between two sequences in \n           an alignment\n Returns : integer\n Args    : Bio::Align::AlignI\n\n\n\nsub transversions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transversions'});\n}\n\n=head2 transitions\n\n Title   : transitions\n Usage   : my $transitions = Bio::Align::DNAStatistics->transitions($aln);\n Function: Calculates the number of transitions in a given DNA alignment\n Returns : integer representing the number of transitions\n Args    : Bio::Align::AlignI object\n\n\n\nsub transitions{\n   my ($self,$aln) = @_;\n   return $self->_trans_count_helper($aln, $DNAChanges{'Transitions'});\n}\n\n\nsub _trans_count_helper {\n    my ($self,$aln,$type) = @_;\n    return 0 unless( $self->_check_arg($aln) );\n    if( ! $aln->is_flush ) { $self->throw(\"must be flush\") }\n    my (@tcount);\n    my ($first,$second) = ( uc $aln->get_seq_by_pos(1)->seq(),\n\t\t\t    uc $aln->get_seq_by_pos(2)->seq() );\n    my $alen = $aln->length; \n    for (my $i = 0;$i<$alen; $i++ ) { \n\tmy ($c1,$c2) = ( substr($first,$i,1),\n\t\t\t substr($second,$i,1) );\n\tif( $c1 ne $c2 ) { \n\t    foreach my $nt ( @{$type->{$c1}} ) {\n\t\tif( $nt eq $c2) {\n\t\t   $tcount[$i]++;\n\t       }\n\t    }\n\t}\n    }\n    my $sum = 0;\n    map { if( $_) { $sum += $_} } @tcount;\n    return $sum;\n}\n\n# this will generate a matrix which records across the row, the number\n# of DNA subst \n# \nsub _build_nt_matrix {\n    my ($self,$seqa,$seqb) = @_;\n    \n\n    my $basect_matrix = [ [ qw(0 0 0 0) ],  # number of bases that match\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ],\n\t\t\t  [ qw(0 0 0 0) ] ];\n    my $gaps = 0;                           # number of gaps\n    my $pfreq = [ qw( 0 0 0 0 0 0)];        # matrix for pair frequency\n    my $len_a = length($seqa);\n    for( my $i = 0; $i < $len_a; $i++) {\n\tmy ($ti,$tj) = (substr($seqa,$i,1),substr($seqb,$i,1));\n\t$ti =~ tr/U/T/;\n\t$tj =~ tr/U/T/;\n\n\tif( $ti =~ /^$GapChars$/) { $gaps++; next; }\n\tif( $tj =~ /^$GapChars$/) { $gaps++; next }\n\n\tmy $ti_index = $NucleotideIndexes{$ti};\t\t\n\tmy $tj_index = $NucleotideIndexes{$tj};\t    \n\n\tif( ! defined $ti_index ) {\n\t    $self->warn(\"ti_index not defined for $ti\\n\");\n\t    next;\n\t}\n\t\n\t$basect_matrix->[$ti_index]->[$tj_index]++;\n\t\n\tif( $ti ne $tj ) {\n\t    $pfreq->[$NucleotideIndexes{join('',sort ($ti,$tj))}]++;\n\t}\n    }\n    return ($basect_matrix,$pfreq,$gaps);\n}\n\nsub _check_ambiguity_nucleotide {\n    my ($base1,$base2) = @_;\n    my %iub = Bio::Tools::IUPAC->iupac_iub();\n    my @amb1 = @{ $iub{uc($base1)} };\n    my @amb2 = @{ $iub{uc($base2)} };    \n    my ($pmatch) = (0);\n    for my $amb ( @amb1 ) {\n\tif( grep { $amb eq $_ } @amb2 ) {\n\t    $pmatch = 1;\n\t    last;\n\t}\n    }\n    if( $pmatch ) { \n\treturn (1 / scalar @amb1) * (1 / scalar @amb2);\n    } else { \n\treturn 0;\n    }\n}\n\n\nsub _check_arg {\n    my($self,$aln ) = @_;\n    if( ! defined $aln || ! $aln->isa('Bio::Align::AlignI') ) {\n\t$self->warn(\"Must provide a Bio::Align::AlignI compliant object to Bio::Align::DNAStatistics\");\n\treturn 0;\n    } elsif( $aln->get_seq_by_pos(1)->alphabet ne 'dna' ) { \n\t$self->warn(\"Must provide a DNA alignment to Bio::Align::DNAStatistics, you provided a \" . $aln->get_seq_by_pos(1)->alphabet);\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)\n\n\n\nsub pairwise_stats{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_pairwise_stats'} = $value;\n    }\n    return $self->{'_pairwise_stats'};\n\n}\n\n=head2 calc_KaKs_pair\n\n Title    : calc_KaKs_pair\n Useage   : my $results = $stats->calc_KaKs_pair($alnobj,\n            $name1, $name2).\n Function : calculates Nei-Gojobori statistics for pairwise \n            comparison.\n Args     : A Bio::Align::AlignI compliant object such as a \n            Bio::SimpleAlign object, and 2 sequence name strings.\n Returns  : a reference to a hash of statistics with keys as \n            listed in Description.\n\n\nsub calc_KaKs_pair {\n    my ( $self, $aln, $seq1_id, $seq2_id) = @_;\n    $self->throw(\"Needs 3 arguments - an alignment object, and 2 sequence ids\") \n\tif @_!= 4;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs = (\n\t\t#{id => $seq1_id, seq =>($aln->each_seq_with_id($seq1_id))[0]->seq},\n\t\t#{id => $seq2_id, seq =>($aln->each_seq_with_id($seq2_id))[0]->seq}\n\t\t{id => $seq1_id, seq => uc(($aln->each_seq_with_id($seq1_id))[0]->seq)},\n                {id => $seq2_id, seq => uc(($aln->each_seq_with_id($seq2_id))[0]->seq)}\n\t       ) ;\n    if (length($seqs[0]{'seq'}) != length($seqs[1]{'seq'})) {\n\t$self->throw(\" aligned sequences must be of equal length!\");\n    }\n    my $results = [];\n    $self->_get_av_ds_dn(\\@seqs, $results);\n    return $results;\n\n}\n\n=head2 calc_all_KaKs_pairs\n\n Title    : calc_all_KaKs_pairs\n Useage   : my $results2 = $stats->calc_KaKs_pair($alnobj).\n Function : Calculates Nei_gojobori statistics for all pairwise\n            combinations in sequence.\n Arguments: A Bio::Align::ALignI compliant object such as\n            a Bio::SimpleAlign object.\n Returns  : A reference to an array of hashes of statistics of\n            all pairwise comparisons in the alignment.\n\n\n\n\nsub calc_all_KaKs_pairs {\n#returns a multi_element_array with all pairwise comparisons\n\tmy ($self,$aln) = @_;\n\t$self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n\tmy @seqs;\n\tfor my $seq ($aln->each_seq) {\n\t\tpush @seqs, {id => $seq->display_id, seq=>$seq->seq};\n\t\t}\n\tmy $results ;\n\t$results = $self->_get_av_ds_dn(\\@seqs, $results);\n\treturn $results;\n}\n\n=head2 calc_average_KaKs\n\n Title    : calc_average_KaKs.  \n Useage   : my $res= $stats->calc_average_KaKs($alnobj, 1000).\n Function : calculates Nei_Gojobori stats for average of all \n            sequences in the alignment.\n Args     : A Bio::Align::AlignI compliant object such as a\n            Bio::SimpleAlign object, number of bootstrap iterations\n            (default 1000).\n Returns  : A reference to a hash of statistics as listed in Description.\n\n\nsub calc_average_KaKs {\n#calculates global value for sequences in alignment using bootstrapping\n#this is quite slow (~10 seconds per  3 X 200nt seqs); \n    my ($self, $aln, $bootstrap_rpt) = @_;\n    $bootstrap_rpt ||= 1000;\n    $self->throw (\"This calculation needs a Bio::Align::AlignI compatible object, not a [ \" . ref($aln) . \" ]object\") unless $aln->isa('Bio::Align::AlignI');\n    my @seqs;\n    for my $seq ($aln->each_seq) {\n\tpush @seqs, {id => $seq->display_id, seq=>$seq->seq};\n    }\n    my $results ;\n    my ($ds_orig, $dn_orig) = $self->_get_av_ds_dn(\\@seqs);\n    #print \"ds = $ds_orig, dn = $dn_orig\\n\";\n    $results = {D_s => $ds_orig, D_n => $dn_orig};\n    $self->_run_bootstrap(\\@seqs, $results, $bootstrap_rpt);\n    return $results;\n}\n\n############## primary internal subs for alignment comparisons ########################\n\nsub _run_bootstrap {\n    ### generates sampled sequences, calculates Ds and Dn values,\n    ### then calculates variance of sampled sequences and add results to results hash\n    ### \n    my ($self,$seq_ref, $results, $bootstrap_rpt) = @_;\t\n    my @seqs = @$seq_ref;\n    my @btstrp_aoa; # to hold array of array of nucleotides for resampling\n    my %bootstrap_values = (ds => [], dn =>[]);\t# to hold list of av values \n\n    #1st make alternative array of codons;\n    my $c = 0;\n    while ($c < length $seqs[0]{'seq'}) {\n\tfor (0..$#seqs) {\n\t    push @{$btstrp_aoa[$_]}, substr ($seqs[$_]{'seq'}, $c, 3);\n\t}\n\t$c+=3;\n    }\n\n    for (1..$bootstrap_rpt) {\n\tmy $sampled = _resample (\\@btstrp_aoa);\n\tmy ($ds, $dn) = $self->_get_av_ds_dn ($sampled) ; # is array ref\n\tpush @{$bootstrap_values{'ds'}}, $ds;\n\tpush @{$bootstrap_values{'dn'}}, $dn;\n    }\t\n\n    $results->{'D_s_var'} = sampling_variance($bootstrap_values{'ds'});\n    $results->{'D_n_var'} = sampling_variance($bootstrap_values{'dn'});\n    $results->{'z_score'} = \t($results->{'D_n'} - $results->{'D_s'}) / \n\tsqrt($results->{'D_s_var'} + $results->{'D_n_var'} ); \n    #print \"bootstrapped var_syn = \t$results->{'D_s_var'} \\n\" ;\n    #print \"bootstrapped var_nc = \t$results->{'D_n_var'} \\n\"; \n    #print \"z is $results->{'z_score'}\\n\";\t### end of global set up of/perm look up data\n}\n\nsub _resample {\n    my $ref = shift;\n    my $codon_num = scalar (@{$ref->[0]});\n    my @altered;\n    for (0..$codon_num -1) {\t#for each codon\n\tmy $rand = int (rand ($codon_num));\n\tfor (0..$#$ref) {\n\t    push @{$altered[$_]}, $ref->[$_][$rand];\n\t}\n    }\n    my @stringed = map {join '', @$_}@altered;\n    my @return;\n    #now out in random name to keep other subs happy\n    for (@stringed) {\n\tpush @return, {id=>'1', seq=> $_};\n    }\n    return \\@return;\n}\n\nsub _get_av_ds_dn {\n    # takes array of hashes of sequence strings and ids   #\n    my $self = shift;\n    my $seq_ref = shift;\n    my $result = shift if @_;\n    my @caller = caller(1);\n    my @seqarray = @$seq_ref;\n    my $bootstrap_score_list;\n    #for a multiple alignment considers all pairwise combinations#\n    my %dsfor_average = (ds => [], dn => []); \n    for (my $i = 0; $i < scalar @seqarray; $i++) {\n\tfor (my $j = $i +1; $j<scalar @seqarray; $j++ ){\n#\t\t\tprint \"comparing $i and $j\\n\";\n\t    if (length($seqarray[$i]{'seq'}) != length($seqarray[$j]{'seq'})) {\n\t\t$self->warn(\" aligned sequences must be of equal length!\");\n\t\tnext;\n\t    }\n\n\t    my $syn_site_count = count_syn_sites($seqarray[$i]{'seq'}, $synsites);\n\t    my $syn_site_count2 = count_syn_sites($seqarray[$j]{'seq'}, $synsites);\n#\t\t\tprint \"syn 1 is $syn_site_count , syn2 is $syn_site_count2\\n\";\n\t    my ($syn_count, $non_syn_count, $gap_cnt) = analyse_mutations($seqarray[$i]{'seq'}, $seqarray[$j]{'seq'});\t\n\t    #get averages\n\t    my $av_s_site = ($syn_site_count + $syn_site_count2)/2;\n\t    my $av_ns_syn_site = length($seqarray[$i]{'seq'}) - $gap_cnt- $av_s_site ;\n\n\t    #calculate ps and pn  (p54)\n\t    my $syn_prop = $syn_count / $av_s_site;\n\t    my $nc_prop = $non_syn_count / $av_ns_syn_site\t;\n\n\t    #now use jukes/cantor to calculate D_s and D_n, would alter here if needed a different method\n\t    my $d_syn = $self->jk($syn_prop);\n\t    my $d_nc = $self->jk($nc_prop);\n\n\t    #JK calculation must succeed for continuation of calculation\n\t    #ret_value = -1 if error\n\t    next unless $d_nc >=0 && $d_syn >=0;\n\n\n\t    push @{$dsfor_average{'ds'}}, $d_syn;\n\t    push @{$dsfor_average{'dn'}}, $d_nc;\n\n\t    #if not doing bootstrap, calculate the pairwise comparisin stats\n\t    if ($caller[3] =~ /calc_KaKs_pair/ || $caller[3] =~ /calc_all_KaKs_pairs/) {\n\t\t\t\t#now calculate variances assuming large sample\n\t\tmy $d_syn_var =  jk_var($syn_prop, length($seqarray[$i]{'seq'})  - $gap_cnt );\n\t\tmy $d_nc_var =  jk_var($nc_prop, length ($seqarray[$i]{'seq'}) - $gap_cnt);\n\t\t#now calculate z_value\n\t\t#print \"d_syn_var is  $d_syn_var,and d_nc_var is $d_nc_var\\n\";\n\t\t#my $z = ($d_nc - $d_syn) / sqrt($d_syn_var + $d_nc_var);\n\t\tmy $z = ($d_syn_var + $d_nc_var) ? \n\t\t  ($d_nc - $d_syn) / sqrt($d_syn_var + $d_nc_var) : 0;\n\t\t#\tprint \"z is $z\\n\";\n\t\tpush @$result , {S => $av_s_site, N=>$av_ns_syn_site,\n\t\t\t\t S_d => $syn_count, N_d =>$non_syn_count,\n\t\t\t\t P_s => $syn_prop, P_n=>$nc_prop,\n\t\t\t\t D_s => @{$dsfor_average{'ds'}}[-1],\n\t\t\t\t D_n => @{$dsfor_average{'dn'}}[-1],\n\t\t\t\t D_n_var =>$d_nc_var, D_s_var => $d_syn_var,\n\t\t\t\t Seq1 => $seqarray[$i]{'id'},\n\t\t\t\t Seq2 => $seqarray[$j]{'id'},\n\t\t\t\t z_score => $z,\n\t\t\t     };\n\t\t$self->warn (\" number of mutations too small to justify normal test for  $seqarray[$i]{'id'} and $seqarray[$j]{'id'}\\n- use Fisher's exact, or bootstrap a MSA\")\n\t\t    if ($syn_count < 10 || $non_syn_count < 10 ) && $self->verbose > -1 ;\n\t    }#endif\n\t    }\n    }\n\n    #warn of failure if no results hashes are present\n    #will fail if Jukes Cantor has failed for all pairwise combinations\n    #$self->warn(\"calculation failed!\") if scalar @$result ==0;\n\n    #return results unless bootstrapping\n    return $result if $caller[3]=~ /calc_all_KaKs/ || $caller[3] =~ /calc_KaKs_pair/; \n    #else if getting average for bootstrap\n    return( mean ($dsfor_average{'ds'}),mean ($dsfor_average{'dn'})) ;\n}\n\n\nsub jk {\n    my ($self, $p) = @_;\n    if ($p > 0.75) {\n\t$self->warn( \" Jukes Cantor won't  work -too divergent!\");\n\treturn -1;\n    }\n    return -1 * (3/4) * (log(1 - (4/3) * $p));\n}\n\n#works for large value of n (50?100?)\nsub jk_var {\n    my ($p, $n) = @_;\n    return (9 * $p * (1 -$p))/(((3 - 4 *$p) **2) * $n);\n}\n\n\n# compares 2 sequences to find the number of synonymous/non\n# synonymous mutations between them\n\nsub analyse_mutations {\n    my ($seq1, $seq2) = @_;\n    my %mutator = ( 2=> {0=>[[1,2],  # codon positions to be altered \n\t\t\t     [2,1]], # depend on which is the same\n\t\t\t 1=>[[0,2],\n\t\t\t     [2,0]],\n\t\t\t 2=>[[0,1],\n\t\t\t     [1,0]],\t\n\t\t     },\n\t\t    3=> [ [0,1,2],  # all need to be altered \n\t\t\t  [1,0,2],\n\t\t\t  [0,2,1],\n\t\t\t  [1,2,0],\n\t\t\t  [2,0,1],\n\t\t\t  [2,1,0] ],\n\t\t    );\n    my $TOTAL   = 0;    # total synonymous changes\n    my $TOTAL_n = 0;\t# total non-synonymous changes\n    my $gap_cnt = 0;\n\n    my %input;\n    my $seqlen = length($seq1);\n    for (my $j=0; $j< $seqlen; $j+=3) {\n\t$input{'cod1'} = substr($seq1, $j,3);\n\t$input{'cod2'} = substr($seq2, $j,3);\n\n\t#ignore codon if beeing compared with gaps! \n\tif ($input{'cod1'} =~ /\\-/ || $input{'cod2'} =~ /\\-/){\n\t    $gap_cnt += 3; #just increments once if there is a pair of gaps\n\t    next;\n\t}\n\n\tmy ($diff_cnt, $same) = count_diffs(\\%input);\n\n\t#ignore if codons are identical\n\tnext if $diff_cnt == 0 ;\n\tif ($diff_cnt == 1) {\n\t    $TOTAL += $synchanges{$input{'cod1'}}{$input{'cod2'}};\n\t    $TOTAL_n += 1 - $synchanges{$input{'cod1'}}{$input{'cod2'}};\n\t    #print \" \\nfordiff is 1 , total now $TOTAL, total n now $TOTAL_n\\n\\n\"\n\t}\n\telsif ($diff_cnt ==2) {\n\t    my $s_cnt = 0;\n\t    my $n_cnt = 0;\n\t    my $tot_muts = 4;\n\t    #will stay 4 unless there are stop codons at intervening point\n\t  OUTER:for my $perm (@{$mutator{'2'}{$same}}) {\n\t      my $altered = $input{'cod1'};\n\t      my $prev= $altered;\n\t      #\t\tprint \"$prev -> (\", $t[$CODONS->{$altered}], \")\";\n\t      for \tmy $mut_i (@$perm) { #index of codon mutated\n\t\t  substr($altered, $mut_i,1) = substr($input{'cod2'}, $mut_i, 1);\n\t\t  if ($t[$CODONS->{$altered}] eq '*') {\n\t\t      $tot_muts -=2;\n\t\t      #print \"changes to stop codon!!\\n\";\n\t\t      next OUTER;\n\t\t  }\n\t\t  else {\n\t\t      $s_cnt += $synchanges{$prev}{$altered};\n\t\t      #\t\t\t\t\tprint \"$altered ->(\", $t[$CODONS->{$altered}], \") \";\n\t\t  }\n\t\t  $prev = $altered;\n\t      }\n\t      #\t\tprint \"\\n\";\n\t  }\n\t    if ($tot_muts != 0) {\n\t\t$TOTAL += ($s_cnt/($tot_muts/2));\n\t\t$TOTAL_n += ($tot_muts - $s_cnt)/ ($tot_muts / 2);\n\t    }\n\n\t}\n\telsif ($diff_cnt ==3 ) {\n\t    my $s_cnt = 0;\n\t    my $n_cnt = 0;\n\t    my $tot_muts = 18;\t#potential number  of mutations\n\t  OUTER: for my $perm (@{$mutator{'3'}}) {\n\t      my $altered = $input{'cod1'};\n\t      my $prev= $altered;\n\t      #\tprint \"$prev -> (\", $t[$CODONS->{$altered}], \")\";\n\t      for my $mut_i (@$perm) { #index of codon mutated\n\t\t  substr($altered, $mut_i,1) = substr($input{'cod2'}, $mut_i, 1);\n\t\t  if ($t[$CODONS->{$altered}] eq '*') {\n\t\t      $tot_muts -=3;\n\t\t      #\tprint \"changes to stop codon!!\\n\";\n\t\t      next OUTER;\n\n\t\t  }\n\t\t  else {\n\t\t      $s_cnt += $synchanges{$prev}{$altered};\n\t\t      #\t\t\tprint \"$altered ->(\", $t[$CODONS->{$altered}], \") \";\n\t\t  }\n\t\t  $prev = $altered;\n\t      }\n\t      #\tprint \"\\n\";\n\n\t  }#end OUTER loop\n\t      #calculate number of synonymous/non synonymous mutations for that codon\n\t      # and add to total\n\t      if ($tot_muts != 0) {\n\t\t  $TOTAL += ($s_cnt / ($tot_muts /3));\n\t\t  $TOTAL_n += 3 - ($s_cnt / ($tot_muts /3));\n\t      }\n\t}\t\t\t#endif $diffcnt = 3\n    }\t\t\t\t#end of sequencetraversal\n    return ($TOTAL, $TOTAL_n, $gap_cnt);\n}\n\n\nsub count_diffs {\n    #counts the number of nucleotide differences between 2 codons\n    # returns this value plus the codon index of which nucleotide is the same when 2\n    #nucleotides are different. This is so analyse_mutations() knows which nucleotides\n    # to change.\n    my $ref = shift;\n    my $cnt = 0;\n    my $same= undef;\n    #just for 2 differences\n    for (0..2) {\n\tif (substr($ref->{'cod1'}, $_,1) ne substr($ref->{'cod2'}, $_, 1)){\n\t    $cnt++;\n\t} else {\n\t    $same = $_;\n\t}\n    }\n    return ($cnt, $same);\n}\n\n=head2 get_syn_changes\n\n Title   : get_syn_changes\n Usage   : Bio::Align::DNAStatitics->get_syn_changes\n Function: Generate a hashref of all pairwise combinations of codns\n           differing by 1\n Returns : Symetic matrix using hashes\n           First key is codon\n           and each codon points to a hashref of codons\n           the values of which describe type of change.\n           my $type = $hash{$codon1}->{$codon2};\n           values are :\n             1   synonymous\n             0   non-syn\n            -1   either codon is a stop codon\n Args    : none\n\n\nsub get_syn_changes {\n#hash of all pairwise combinations of codons differing by 1\n# 1 = syn, 0 = non-syn, -1 = stop\n    my %results;\n    my @codons = _make_codons ();\n    my $arr_len = scalar @codons;\n    for (my $i = 0; $i < $arr_len -1; $i++) {\n\tmy $cod1 = $codons[$i];\n\tfor (my $j = $i +1; $j < $arr_len; $j++) {\n\t    my $diff_cnt = 0;\n\t    for my $pos(0..2) {\n\t\t$diff_cnt++ if substr($cod1, $pos, 1) ne substr($codons[$j], $pos, 1);\n\t    }\n\t    next if $diff_cnt !=1;\n\n\t    #synon change\n\t    if($t[$CODONS->{$cod1}] eq $t[$CODONS->{$codons[$j]}]) {\n\t\t$results{$cod1}{$codons[$j]} =1;\n\t\t$results{$codons[$j]}{$cod1} = 1;\n\t    }\n\t    #stop codon\n\t    elsif ($t[$CODONS->{$cod1}] eq '*' or $t[$CODONS->{$codons[$j]}] eq '*') {\n\t\t$results{$cod1}{$codons[$j]} = -1;\n\t\t$results{$codons[$j]}{$cod1} = -1;\n\t    }\n\t    # nc change\n\t    else {\n\t\t$results{$cod1}{$codons[$j]} = 0;\n\t\t$results{$codons[$j]}{$cod1} = 0;\n\t    }\n\t}\n    }\n    return %results;\n}\n\n=head2 dnds_pattern_number\n\n Title   : dnds_pattern_number\n Usage   : my $patterns = $stats->dnds_pattern_number($alnobj);\n Function: Counts the number of codons with no gaps in the MSA\n Returns : Number of codons with no gaps ('patterns' in PAML notation)\n Args    : A Bio::Align::AlignI compliant object such as a\n            Bio::SimpleAlign object.","parameters":[{"label":"$self"},{"label":"$aln"}]},"range":{"end":{"line":1662,"character":9999},"start":{"line":1659,"character":0}},"kind":12,"line":1659},{"signature":{"documentation":"","parameters":[{"label":"$seq"},{"label":"$synsite"}],"label":"count_syn_sites($seq,$synsite)"},"kind":12,"range":{"start":{"character":0,"line":1664},"end":{"line":1676,"character":9999}},"line":1664,"detail":"($seq,$synsite)","definition":"sub","containerName":"main::","name":"count_syn_sites","children":[{"definition":"my","localvar":"my","containerName":"count_syn_sites","kind":13,"name":"$seq","line":1666},{"containerName":"count_syn_sites","kind":13,"name":"$synsite","line":1666},{"kind":12,"containerName":"count_syn_sites","name":"throw","line":1667},{"name":"$seq","containerName":"count_syn_sites","kind":13,"line":1667},{"name":"$S","localvar":"my","kind":13,"containerName":"count_syn_sites","line":1668,"definition":"my"},{"line":1669,"name":"$i","kind":13,"localvar":"my","containerName":"count_syn_sites","definition":"my"},{"line":1669,"name":"$i","kind":13,"containerName":"count_syn_sites"},{"line":1669,"containerName":"count_syn_sites","kind":13,"name":"$seq"},{"line":1669,"kind":13,"containerName":"count_syn_sites","name":"$i"},{"kind":13,"localvar":"my","containerName":"count_syn_sites","name":"$cod","line":1670,"definition":"my"},{"line":1670,"name":"$seq","kind":13,"containerName":"count_syn_sites"},{"name":"$i","kind":13,"containerName":"count_syn_sites","line":1670},{"line":1671,"containerName":"count_syn_sites","kind":13,"name":"$cod"},{"kind":13,"containerName":"count_syn_sites","name":"$S","line":1672},{"line":1672,"kind":13,"containerName":"count_syn_sites","name":"$synsite"},{"kind":13,"containerName":"count_syn_sites","name":"$cod","line":1672},{"kind":13,"containerName":"count_syn_sites","name":"$S","line":1675}]},{"line":1680,"kind":12,"range":{"end":{"line":1718,"character":9999},"start":{"line":1680,"character":0}},"definition":"sub","children":[{"definition":"my","line":1682,"name":"@nucs","localvar":"my","containerName":"get_syn_sites","kind":13},{"definition":"my","line":1683,"name":"%raw_results","localvar":"my","kind":13,"containerName":"get_syn_sites"},{"name":"$i","kind":13,"localvar":"my","containerName":"get_syn_sites","line":1684,"definition":"my"},{"containerName":"get_syn_sites","kind":13,"name":"@nucs","line":1684},{"definition":"my","name":"$j","containerName":"get_syn_sites","localvar":"my","kind":13,"line":1685},{"line":1685,"containerName":"get_syn_sites","kind":13,"name":"@nucs"},{"definition":"my","line":1686,"containerName":"get_syn_sites","localvar":"my","kind":13,"name":"$k"},{"name":"@nucs","kind":13,"containerName":"get_syn_sites","line":1686},{"definition":"my","name":"$cod","kind":13,"localvar":"my","containerName":"get_syn_sites","line":1688},{"definition":"my","line":1689,"name":"$aa","containerName":"get_syn_sites","localvar":"my","kind":13},{"line":1689,"containerName":"get_syn_sites","kind":13,"name":"$t"},{"kind":13,"containerName":"get_syn_sites","name":"$CODONS","line":1689},{"name":"$cod","containerName":"get_syn_sites","kind":13,"line":1689},{"line":1691,"containerName":"get_syn_sites","localvar":"my","kind":13,"name":"$i","definition":"my"},{"definition":"my","line":1692,"kind":13,"localvar":"my","containerName":"get_syn_sites","name":"$s"},{"name":"$n","containerName":"get_syn_sites","localvar":"my","kind":13,"line":1693,"definition":"my"},{"definition":"my","line":1694,"name":"$nuc","localvar":"my","containerName":"get_syn_sites","kind":13},{"name":"$cod","containerName":"get_syn_sites","kind":13,"line":1695},{"name":"$i","containerName":"get_syn_sites","kind":13,"line":1695},{"line":1695,"kind":13,"containerName":"get_syn_sites","name":"$nuc"},{"definition":"my","line":1696,"name":"$test","containerName":"get_syn_sites","localvar":"my","kind":13},{"name":"$cod","kind":13,"containerName":"get_syn_sites","line":1696},{"containerName":"get_syn_sites","kind":13,"name":"$test","line":1697},{"line":1697,"name":"$i","kind":13,"containerName":"get_syn_sites"},{"containerName":"get_syn_sites","kind":13,"name":"$nuc","line":1697},{"name":"$t","kind":13,"containerName":"get_syn_sites","line":1698},{"line":1698,"kind":13,"containerName":"get_syn_sites","name":"$CODONS"},{"line":1698,"kind":13,"containerName":"get_syn_sites","name":"$test"},{"line":1698,"name":"$aa","containerName":"get_syn_sites","kind":13},{"name":"$s","containerName":"get_syn_sites","kind":13,"line":1699},{"line":1701,"kind":13,"containerName":"get_syn_sites","name":"$t"},{"line":1701,"kind":13,"containerName":"get_syn_sites","name":"$CODONS"},{"name":"$test","kind":13,"containerName":"get_syn_sites","line":1701},{"line":1702,"containerName":"get_syn_sites","kind":13,"name":"$n"},{"name":"$raw_results","kind":13,"containerName":"get_syn_sites","line":1705},{"line":1705,"name":"$cod","containerName":"get_syn_sites","kind":13},{"name":"$i","kind":13,"containerName":"get_syn_sites","line":1705},{"name":"$s","kind":13,"containerName":"get_syn_sites","line":1705},{"kind":13,"containerName":"get_syn_sites","name":"$n","line":1706},{"definition":"my","line":1712,"name":"%final_results","containerName":"get_syn_sites","localvar":"my","kind":13},{"name":"$cod","kind":13,"localvar":"my","containerName":"get_syn_sites","line":1714,"definition":"my"},{"kind":13,"containerName":"get_syn_sites","name":"%raw_results","line":1714},{"definition":"my","localvar":"my","kind":13,"containerName":"get_syn_sites","name":"$t","line":1715},{"line":1716,"name":"$t","kind":13,"containerName":"get_syn_sites"},{"kind":13,"containerName":"get_syn_sites","name":"$raw_results","line":1716},{"kind":13,"containerName":"get_syn_sites","name":"$cod","line":1716},{"name":"$final_results","kind":13,"containerName":"get_syn_sites","line":1717},{"name":"$cod","kind":13,"containerName":"get_syn_sites","line":1717},{"line":1717,"containerName":"get_syn_sites","kind":13,"name":"$t"},{"line":1717,"name":"$t","containerName":"get_syn_sites","kind":13}],"name":"get_syn_sites","containerName":"main::"},{"kind":13,"containerName":null,"name":"%final_results","line":1719},{"range":{"start":{"line":1722,"character":0},"end":{"line":1734,"character":9999}},"kind":12,"line":1722,"definition":"sub","containerName":"main::","name":"_make_codons","children":[{"definition":"my","line":1724,"containerName":"_make_codons","localvar":"my","kind":13,"name":"@nucs"},{"definition":"my","line":1725,"name":"@codons","localvar":"my","containerName":"_make_codons","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_make_codons","name":"$i","line":1726},{"name":"@nucs","kind":13,"containerName":"_make_codons","line":1726},{"name":"$j","localvar":"my","kind":13,"containerName":"_make_codons","line":1727,"definition":"my"},{"kind":13,"containerName":"_make_codons","name":"@nucs","line":1727},{"definition":"my","line":1728,"name":"$k","containerName":"_make_codons","localvar":"my","kind":13},{"line":1728,"containerName":"_make_codons","kind":13,"name":"@nucs"},{"name":"@codons","containerName":"_make_codons","kind":13,"line":1729},{"line":1733,"name":"@codons","kind":13,"containerName":"_make_codons"}]},{"line":1736,"kind":12,"range":{"start":{"character":0,"line":1736},"end":{"line":1745,"character":9999}},"definition":"sub","children":[{"definition":"my","name":"$x","localvar":"my","containerName":"get_codons","kind":13,"line":1738},{"definition":"my","line":1739,"name":"$CODONS","containerName":"get_codons","localvar":"my","kind":13},{"containerName":"get_codons","localvar":"my","kind":13,"name":"$codon","line":1740,"definition":"my"},{"kind":13,"containerName":"get_codons","name":"$CODONS","line":1741},{"kind":13,"containerName":"get_codons","name":"$codon","line":1741},{"line":1741,"name":"$x","containerName":"get_codons","kind":13},{"line":1742,"containerName":"get_codons","kind":13,"name":"$x"},{"name":"$CODONS","kind":13,"containerName":"get_codons","line":1744}],"containerName":"main::","name":"get_codons"},{"definition":"sub","containerName":"main::","name":"mean","children":[{"kind":13,"localvar":"my","containerName":"mean","name":"$ref","line":1749,"definition":"my"},{"line":1750,"name":"$el_num","localvar":"my","kind":13,"containerName":"mean","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"mean","name":"$tot","line":1751},{"line":1752,"kind":13,"containerName":"mean","name":"$tot"},{"line":1753,"kind":13,"containerName":"mean","name":"$tot"},{"kind":13,"containerName":"mean","name":"$el_num","line":1753}],"range":{"end":{"line":1754,"character":9999},"start":{"line":1748,"character":0}},"kind":12,"line":1748},{"kind":12,"range":{"end":{"line":1762,"character":9999},"start":{"line":1756,"character":0}},"line":1756,"definition":"sub","name":"variance","containerName":"main::","children":[{"containerName":"variance","localvar":"my","kind":13,"name":"$ref","line":1757,"definition":"my"},{"definition":"my","name":"$mean","containerName":"variance","localvar":"my","kind":13,"line":1758},{"name":"$ref","kind":13,"containerName":"variance","line":1758},{"line":1759,"name":"$sum_of_squares","kind":13,"localvar":"my","containerName":"variance","definition":"my"},{"name":"$sum_of_squares","kind":13,"containerName":"variance","line":1760},{"kind":13,"containerName":"variance","name":"$mean","line":1760},{"line":1761,"kind":13,"containerName":"variance","name":"$sum_of_squares"}]},{"definition":"sub","containerName":"main::","name":"sampling_variance","children":[{"definition":"my","line":1765,"containerName":"sampling_variance","localvar":"my","kind":13,"name":"$ref"},{"name":"$ref","containerName":"sampling_variance","kind":13,"line":1766}],"range":{"end":{"line":1767,"character":9999},"start":{"character":0,"line":1764}},"kind":12,"line":1764}]}