{"version":5,"vars":[{"containerName":"","name":"Carp","kind":2,"line":5},{"containerName":"","name":"vars","line":7,"kind":2},{"containerName":null,"name":"$Debug","line":9,"kind":13},{"kind":13,"line":10,"name":"$VERSION","containerName":null},{"children":[{"line":288,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"line":289,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":289,"name":"$class","containerName":"new"},{"line":289,"kind":13,"name":"$class","containerName":"new"},{"line":291,"kind":13,"localvar":"my","definition":"my","name":"$o","containerName":"new"},{"line":292,"kind":13,"localvar":"my","name":"$it","definition":"my","containerName":"new"},{"line":292,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":293,"name":"$Debug","containerName":"new"},{"line":294,"kind":13,"name":"$it","containerName":"new"},{"kind":12,"line":294,"containerName":"new","name":"_init"},{"containerName":"new","name":"$o","line":294,"kind":13},{"name":"$it","containerName":"new","line":295,"kind":13}],"line":285,"kind":12,"range":{"start":{"line":285,"character":0},"end":{"line":296,"character":9999}},"name":"new","definition":"sub","containerName":"main::"},{"kind":12,"line":319,"children":[{"kind":13,"line":320,"name":"$this","definition":"my","containerName":"_init","localvar":"my"},{"containerName":"_init","definition":"my","name":"$o","localvar":"my","kind":13,"line":321},{"name":"$this","containerName":"_init","kind":13,"line":324},{"containerName":"_init","name":"_init_mother","line":324,"kind":12},{"line":324,"kind":13,"containerName":"_init","name":"$o"},{"containerName":"_init","name":"$this","kind":13,"line":325},{"name":"_init_daughters","containerName":"_init","kind":12,"line":325},{"kind":13,"line":325,"name":"$o","containerName":"_init"},{"line":326,"kind":13,"name":"$this","containerName":"_init"},{"line":326,"kind":12,"containerName":"_init","name":"_init_name"},{"containerName":"_init","name":"$o","line":326,"kind":13},{"kind":13,"line":327,"containerName":"_init","name":"$this"},{"line":327,"kind":12,"name":"_init_attributes","containerName":"_init"},{"name":"$o","containerName":"_init","line":327,"kind":13}],"containerName":"main::","name":"_init","definition":"sub","range":{"start":{"character":0,"line":319},"end":{"line":330,"character":9999}}},{"range":{"start":{"character":0,"line":332},"end":{"line":343,"character":9999}},"name":"_init_mother","signature":{"parameters":[{"label":"$this"},{"label":"$o"}],"documentation":"","label":"_init_mother($this,$o)"},"detail":"($this,$o)","definition":"sub","containerName":"main::","children":[{"line":333,"kind":13,"localvar":"my","containerName":"_init_mother","name":"$this","definition":"my"},{"name":"$o","containerName":"_init_mother","kind":13,"line":333},{"containerName":"_init_mother","name":"$this","line":335,"kind":13},{"kind":13,"line":338,"name":"$o","containerName":"_init_mother"},{"line":338,"kind":12,"name":"add_daughter","containerName":"_init_mother"},{"containerName":"_init_mother","name":"$this","line":338,"kind":13},{"containerName":"_init_mother","name":"$o","line":339,"kind":13},{"name":"$o","containerName":"_init_mother","kind":13,"line":339}],"line":332,"kind":12},{"detail":"($this,$o)","signature":{"label":"_init_daughters($this,$o)","parameters":[{"label":"$this"},{"label":"$o"}],"documentation":""},"containerName":"main::","definition":"sub","line":345,"children":[{"kind":13,"line":346,"containerName":"_init_daughters","definition":"my","name":"$this","localvar":"my"},{"containerName":"_init_daughters","name":"$o","line":346,"kind":13},{"line":348,"kind":13,"containerName":"_init_daughters","name":"$this"},{"line":351,"kind":13,"containerName":"_init_daughters","name":"$this"},{"line":351,"kind":12,"name":"set_daughters","containerName":"_init_daughters"},{"line":351,"kind":13,"name":"$o","containerName":"_init_daughters"}],"kind":12,"range":{"start":{"character":0,"line":345},"end":{"character":9999,"line":351}},"name":"_init_daughters"},{"name":"%o","containerName":null,"line":352,"kind":13},{"line":352,"kind":13,"name":"%o","containerName":null},{"kind":12,"children":[{"localvar":"my","name":"$this","definition":"my","containerName":"_init_name","line":359,"kind":13},{"line":359,"kind":13,"name":"$o","containerName":"_init_name"},{"containerName":"_init_name","name":"$this","kind":13,"line":361},{"line":364,"kind":13,"containerName":"_init_name","name":"$this"},{"kind":12,"line":364,"containerName":"_init_name","name":"name"},{"name":"$o","containerName":"_init_name","kind":13,"line":364},{"line":364,"kind":13,"containerName":"_init_name","name":"$o"}],"line":358,"definition":"sub","containerName":"main::","signature":{"label":"_init_name($this,$o)","parameters":[{"label":"$this"},{"label":"$o"}],"documentation":""},"detail":"($this,$o)","name":"_init_name","range":{"end":{"character":9999,"line":365},"start":{"character":0,"line":358}}},{"name":"_init_attributes","range":{"start":{"character":0,"line":367},"end":{"line":374,"character":9999}},"kind":12,"line":367,"children":[{"kind":13,"line":368,"name":"$this","definition":"my","containerName":"_init_attributes","localvar":"my"},{"line":368,"kind":13,"containerName":"_init_attributes","name":"$o"},{"line":370,"kind":13,"containerName":"_init_attributes","name":"$this"},{"kind":13,"line":373,"containerName":"_init_attributes","name":"$this"},{"kind":12,"line":373,"containerName":"_init_attributes","name":"attributes"},{"containerName":"_init_attributes","name":"$o","kind":13,"line":373},{"name":"$o","containerName":"_init_attributes","kind":13,"line":373}],"containerName":"main::","definition":"sub","detail":"($this,$o)","signature":{"parameters":[{"label":"$this"},{"label":"$o"}],"documentation":"","label":"_init_attributes($this,$o)"}},{"definition":"sub","name":"daughters","containerName":"main::","range":{"start":{"line":389,"character":0},"end":{"character":9999,"line":399}},"kind":12,"children":[{"line":390,"kind":13,"localvar":"my","name":"$this","definition":"my","containerName":"daughters"},{"name":"$this","containerName":"daughters","line":395,"kind":13},{"containerName":"daughters","name":"$this","line":396,"kind":13},{"kind":12,"line":396,"name":"_update_daughter_links","containerName":"daughters"},{"line":399,"kind":13,"containerName":"daughters","name":"$this"}],"line":389},{"name":"Carp","containerName":"croak::Carp::carp","line":394,"kind":12},{"range":{"start":{"line":411,"character":0},"end":{"character":9999,"line":415}},"containerName":"main::","name":"mother","definition":"sub","line":411,"children":[{"localvar":"my","definition":"my","name":"$this","containerName":"mother","line":412,"kind":13},{"name":"$this","containerName":"mother","line":414,"kind":13}],"kind":12},{"name":"Carp","containerName":"croak","line":414,"kind":12},{"line":443,"children":[{"localvar":"my","definition":"my","name":"$mother","containerName":"add_daughters","line":444,"kind":13},{"containerName":"add_daughters","name":"@daughters","kind":13,"line":444},{"line":445,"kind":13,"name":"@daughters","containerName":"add_daughters"},{"kind":13,"line":447,"containerName":"add_daughters","name":"$mother"},{"containerName":"add_daughters","name":"_add_daughters_wrapper","kind":12,"line":447}],"kind":12,"detail":"($mother,@daughters)","signature":{"label":"add_daughters($mother,@daughters)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)","parameters":[{"label":"$mother"},{"label":"@daughters"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":443},"end":{"character":9999,"line":448}},"name":"add_daughters"},{"line":450,"kind":13,"name":"@daughters","containerName":null},{"children":[{"localvar":"my","containerName":"add_daughter","definition":"my","name":"$it","line":454,"kind":13},{"containerName":"add_daughter","name":"@them","kind":13,"line":454},{"kind":13,"line":454,"name":"$it","containerName":"add_daughter"},{"kind":12,"line":454,"containerName":"add_daughter","name":"add_daughters"},{"containerName":"add_daughter","name":"@them","line":454,"kind":13}],"line":453,"kind":12,"signature":{"label":"add_daughter($it,@them)","documentation":"","parameters":[{"label":"$it"},{"label":"@them"}]},"detail":"($it,@them)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":455},"start":{"character":0,"line":453}},"name":"add_daughter"},{"line":469,"children":[{"line":470,"kind":13,"localvar":"my","name":"$mother","definition":"my","containerName":"add_daughters_left"},{"line":470,"kind":13,"name":"@daughters","containerName":"add_daughters_left"},{"kind":13,"line":471,"name":"@daughters","containerName":"add_daughters_left"},{"line":473,"kind":13,"containerName":"add_daughters_left","name":"$mother"},{"containerName":"add_daughters_left","name":"_add_daughters_wrapper","line":473,"kind":12}],"kind":12,"detail":"($mother,@daughters)","signature":{"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )","parameters":[{"label":"$mother"},{"label":"@daughters"}],"label":"add_daughters_left($mother,@daughters)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":469},"end":{"line":474,"character":9999}},"name":"add_daughters_left"},{"kind":13,"line":476,"containerName":null,"name":"@daughters"},{"children":[{"line":480,"kind":13,"localvar":"my","containerName":"add_daughter_left","definition":"my","name":"$it"},{"name":"@them","containerName":"add_daughter_left","line":480,"kind":13},{"kind":13,"line":480,"containerName":"add_daughter_left","name":"$it"},{"name":"add_daughters_left","containerName":"add_daughter_left","kind":12,"line":480},{"line":480,"kind":13,"name":"@them","containerName":"add_daughter_left"}],"line":479,"kind":12,"signature":{"label":"add_daughter_left($it,@them)","documentation":"","parameters":[{"label":"$it"},{"label":"@them"}]},"detail":"($it,@them)","definition":"sub","containerName":"main::","range":{"start":{"line":479,"character":0},"end":{"character":9999,"line":481}},"name":"add_daughter_left"},{"name":"_add_daughters_wrapper","range":{"start":{"line":509,"character":0},"end":{"line":547,"character":9999}},"containerName":"main::","definition":"sub","detail":"($mother,$callback,@daughters)","signature":{"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n#  Used by the adding methods\n    (except maybe new_daughter, and new_daughter_left)","parameters":[{"label":"$mother"},{"label":"$callback"},{"label":"@daughters"}],"label":"_add_daughters_wrapper($mother,$callback,@daughters)"},"kind":12,"line":509,"children":[{"name":"$mother","definition":"my","containerName":"_add_daughters_wrapper","localvar":"my","kind":13,"line":510},{"line":510,"kind":13,"containerName":"_add_daughters_wrapper","name":"$callback"},{"kind":13,"line":510,"name":"@daughters","containerName":"_add_daughters_wrapper"},{"line":511,"kind":13,"name":"@daughters","containerName":"_add_daughters_wrapper"},{"kind":13,"line":513,"definition":"my","name":"%ancestors","containerName":"_add_daughters_wrapper","localvar":"my"},{"containerName":"_add_daughters_wrapper","name":"@ancestors","kind":13,"line":514},{"name":"$mother","containerName":"_add_daughters_wrapper","kind":13,"line":514},{"name":"ancestors","containerName":"_add_daughters_wrapper","line":514,"kind":12},{"localvar":"my","definition":"my","name":"$daughter","containerName":"_add_daughters_wrapper","line":521,"kind":13},{"kind":13,"line":521,"containerName":"_add_daughters_wrapper","name":"@daughters"},{"name":"$daughter","containerName":"_add_daughters_wrapper","kind":13,"line":522},{"name":"$mother","containerName":"_add_daughters_wrapper","line":524,"kind":13},{"containerName":"_add_daughters_wrapper","name":"$mother","kind":13,"line":524},{"name":"$Debug","containerName":"_add_daughters_wrapper","kind":13,"line":524},{"containerName":"_add_daughters_wrapper","name":"$daughter","kind":13,"line":525},{"name":"$daughter","containerName":"_add_daughters_wrapper","line":525,"kind":13},{"name":"$Debug","containerName":"_add_daughters_wrapper","line":525,"kind":13},{"name":"$daughter","containerName":"_add_daughters_wrapper","line":527,"kind":13},{"name":"name","containerName":"_add_daughters_wrapper","line":527,"kind":12},{"containerName":"_add_daughters_wrapper","name":"$daughter","line":527,"kind":13},{"name":"$mother","containerName":"_add_daughters_wrapper","kind":13,"line":528},{"line":528,"kind":12,"containerName":"_add_daughters_wrapper","name":"name"},{"kind":13,"line":528,"containerName":"_add_daughters_wrapper","name":"$mother"},{"name":"$Debug","containerName":"_add_daughters_wrapper","kind":13,"line":528},{"containerName":"_add_daughters_wrapper","name":"$mother","line":530,"kind":13},{"name":"$daughter","containerName":"_add_daughters_wrapper","kind":13,"line":530},{"name":"$daughter","containerName":"_add_daughters_wrapper","line":532,"kind":13},{"name":"cyclicity_fault","containerName":"_add_daughters_wrapper","kind":12,"line":532},{"name":"$daughter","containerName":"_add_daughters_wrapper","line":533,"kind":13},{"line":533,"kind":12,"name":"name","containerName":"_add_daughters_wrapper"},{"line":534,"kind":13,"containerName":"_add_daughters_wrapper","name":"$mother"},{"containerName":"_add_daughters_wrapper","name":"name","line":534,"kind":12},{"line":536,"kind":13,"name":"$ancestors","containerName":"_add_daughters_wrapper"},{"line":536,"kind":13,"containerName":"_add_daughters_wrapper","name":"$daughter"},{"kind":13,"line":538,"name":"$old_mother","definition":"my","containerName":"_add_daughters_wrapper","localvar":"my"},{"kind":13,"line":538,"containerName":"_add_daughters_wrapper","name":"$daughter"},{"line":540,"kind":13,"containerName":"_add_daughters_wrapper","name":"$old_mother"},{"line":540,"kind":13,"containerName":"_add_daughters_wrapper","name":"$old_mother"},{"containerName":"_add_daughters_wrapper","name":"$old_mother","line":540,"kind":13},{"kind":13,"line":540,"containerName":"_add_daughters_wrapper","name":"$mother"},{"line":543,"kind":13,"containerName":"_add_daughters_wrapper","name":"$old_mother"},{"kind":12,"line":543,"containerName":"_add_daughters_wrapper","name":"remove_daughters"},{"kind":13,"line":543,"name":"$daughter","containerName":"_add_daughters_wrapper"},{"name":"$old_mother","containerName":"_add_daughters_wrapper","line":544,"kind":13},{"name":"$old_mother","containerName":"_add_daughters_wrapper","line":544,"kind":13},{"name":"$callback","containerName":"_add_daughters_wrapper","line":546,"kind":13},{"line":546,"kind":13,"containerName":"_add_daughters_wrapper","name":"$mother"},{"line":546,"kind":13,"containerName":"_add_daughters_wrapper","name":"$daughter"}]},{"name":"Carp","containerName":"croak::UNIVERSAL::can","kind":12,"line":522},{"containerName":"croak","name":"Carp","kind":12,"line":532},{"kind":13,"line":548,"containerName":null,"name":"$mother"},{"name":"_update_daughter_links","containerName":"main::","line":548,"kind":12},{"containerName":"main::","name":"_update_daughter_links","definition":"sub","range":{"start":{"line":556,"character":0},"end":{"character":9999,"line":573}},"kind":12,"line":556,"children":[{"localvar":"my","containerName":"_update_daughter_links","definition":"my","name":"$this","line":559,"kind":13},{"line":561,"kind":13,"localvar":"my","definition":"my","name":"$them","containerName":"_update_daughter_links"},{"line":561,"kind":13,"containerName":"_update_daughter_links","name":"$this"},{"line":564,"kind":13,"localvar":"my","containerName":"_update_daughter_links","definition":"my","name":"%seen"},{"line":565,"kind":13,"name":"$them","containerName":"_update_daughter_links"},{"kind":13,"line":565,"name":"$seen","containerName":"_update_daughter_links"},{"line":565,"kind":13,"containerName":"_update_daughter_links","name":"$them"},{"name":"$one","definition":"my","containerName":"_update_daughter_links","localvar":"my","kind":13,"line":568},{"line":568,"kind":13,"name":"$them","containerName":"_update_daughter_links"},{"containerName":"_update_daughter_links","name":"$one","line":569,"kind":13},{"line":570,"kind":13,"name":"$one","containerName":"_update_daughter_links"},{"line":570,"kind":13,"containerName":"_update_daughter_links","name":"$this"}]},{"name":"Carp","containerName":"croak","line":570,"kind":12},{"kind":12,"line":579,"children":[{"line":583,"kind":13,"localvar":"my","containerName":"_update_links","definition":"my","name":"$this"},{"containerName":"_update_links","name":"$this","line":585,"kind":13},{"kind":12,"line":585,"containerName":"_update_links","name":"walk_down"},{"localvar":"my","containerName":"_update_links","name":"$this","definition":"my","line":587,"kind":13},{"name":"$this","containerName":"_update_links","kind":13,"line":588},{"line":588,"kind":12,"name":"_update_daughter_links","containerName":"_update_links"}],"containerName":"main::","name":"_update_links","definition":"sub","range":{"end":{"character":9999,"line":592},"start":{"line":579,"character":0}}},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$mother","containerName":"new_daughter","line":623,"kind":13},{"line":623,"kind":13,"containerName":"new_daughter","name":"@options"},{"kind":13,"line":624,"name":"$daughter","definition":"my","containerName":"new_daughter","localvar":"my"},{"name":"$mother","containerName":"new_daughter","line":624,"kind":13},{"containerName":"new_daughter","name":"new","kind":12,"line":624},{"kind":13,"line":624,"name":"@options","containerName":"new_daughter"},{"line":626,"kind":13,"containerName":"new_daughter","name":"$mother"}],"line":622,"definition":"sub","containerName":"main::","signature":{"label":"new_daughter($mother,@options)","parameters":[{"label":"$mother"},{"label":"@options"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n Note that if you radically change 'mother'/'daughters' bookkeeping,\n you may have to change this routine, since it's one of the places\n that directly writes to 'daughters' and 'mother'."},"detail":"($mother,@options)","name":"new_daughter","range":{"start":{"line":622,"character":0},"end":{"character":9999,"line":626}}},{"line":626,"kind":13,"name":"$daughter","containerName":null},{"name":"%daughter","containerName":null,"line":627,"kind":13},{"line":627,"kind":13,"containerName":null,"name":"$mother"},{"line":629,"kind":13,"name":"$daughter","containerName":null},{"range":{"end":{"character":9999,"line":649},"start":{"character":0,"line":645}},"name":"new_daughter_left","signature":{"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n Note that if you radically change 'mother'/'daughters' bookkeeping,\n you may have to change this routine, since it's one of the places\n that directly writes to 'daughters' and 'mother'.","parameters":[{"label":"$mother"},{"label":"@options"}],"label":"new_daughter_left($mother,@options)"},"detail":"($mother,@options)","definition":"sub","containerName":"main::","children":[{"containerName":"new_daughter_left","definition":"my","name":"$mother","localvar":"my","kind":13,"line":646},{"name":"@options","containerName":"new_daughter_left","line":646,"kind":13},{"line":647,"kind":13,"localvar":"my","containerName":"new_daughter_left","name":"$daughter","definition":"my"},{"line":647,"kind":13,"containerName":"new_daughter_left","name":"$mother"},{"name":"new","containerName":"new_daughter_left","line":647,"kind":12},{"kind":13,"line":647,"containerName":"new_daughter_left","name":"@options"},{"line":649,"kind":13,"name":"$mother","containerName":"new_daughter_left"}],"line":645,"kind":12},{"kind":13,"line":649,"name":"$daughter","containerName":null},{"line":650,"kind":13,"containerName":null,"name":"%daughter"},{"name":"$mother","containerName":null,"kind":13,"line":650},{"name":"$daughter","containerName":null,"line":652,"kind":13},{"detail":"($mother,@daughters)","signature":{"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.","parameters":[{"label":"$mother"},{"label":"@daughters"}],"label":"remove_daughters($mother,@daughters)"},"containerName":"main::","definition":"sub","line":667,"children":[{"kind":13,"line":668,"containerName":"remove_daughters","name":"$mother","definition":"my","localvar":"my"},{"kind":13,"line":668,"name":"@daughters","containerName":"remove_daughters"},{"kind":13,"line":669,"containerName":"remove_daughters","name":"$mother"},{"line":670,"kind":13,"name":"@daughters","containerName":"remove_daughters"},{"kind":13,"line":672,"definition":"my","name":"%to_delete","containerName":"remove_daughters","localvar":"my"},{"name":"@daughters","containerName":"remove_daughters","kind":13,"line":673},{"line":675,"kind":13,"name":"$mother","containerName":"remove_daughters"},{"line":676,"kind":13,"name":"@daughters","containerName":"remove_daughters"},{"kind":13,"line":677,"name":"@daughters","containerName":"remove_daughters"},{"kind":13,"line":678,"containerName":"remove_daughters","name":"@to_delete"},{"containerName":"remove_daughters","name":"@daughters","line":678,"kind":13},{"containerName":"remove_daughters","name":"$daughter","definition":"my","localvar":"my","kind":13,"line":681},{"line":681,"kind":13,"name":"@daughters","containerName":"remove_daughters"},{"kind":13,"line":682,"name":"$daughter","containerName":"remove_daughters"},{"line":684,"kind":13,"localvar":"my","definition":"my","name":"$them","containerName":"remove_daughters"},{"name":"$mother","containerName":"remove_daughters","kind":13,"line":684},{"name":"$them","containerName":"remove_daughters","line":685,"kind":13},{"line":685,"kind":13,"containerName":"remove_daughters","name":"$to_delete"},{"kind":13,"line":685,"name":"$them","containerName":"remove_daughters"}],"kind":12,"range":{"start":{"line":667,"character":0},"end":{"line":689,"character":9999}},"name":"remove_daughters"},{"kind":12,"line":673,"containerName":"croak","name":"Carp"},{"name":"remove_daughter","range":{"start":{"character":0,"line":697},"end":{"character":9999,"line":699}},"kind":12,"line":697,"children":[{"localvar":"my","containerName":"remove_daughter","definition":"my","name":"$it","line":698,"kind":13},{"containerName":"remove_daughter","name":"@them","line":698,"kind":13},{"name":"$it","containerName":"remove_daughter","kind":13,"line":698},{"line":698,"kind":12,"name":"remove_daughters","containerName":"remove_daughter"},{"line":698,"kind":13,"name":"@them","containerName":"remove_daughter"}],"containerName":"main::","definition":"sub","detail":"($it,@them)","signature":{"label":"remove_daughter($it,@them)","parameters":[{"label":"$it"},{"label":"@them"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )"}},{"kind":12,"children":[{"line":711,"kind":13,"localvar":"my","containerName":"unlink_from_mother","name":"$node","definition":"my"},{"definition":"my","name":"$mother","containerName":"unlink_from_mother","localvar":"my","kind":13,"line":712},{"kind":13,"line":712,"containerName":"unlink_from_mother","name":"$node"},{"containerName":"unlink_from_mother","name":"$mother","line":713,"kind":13},{"containerName":"unlink_from_mother","name":"remove_daughters","line":713,"kind":12},{"line":713,"kind":13,"name":"$node","containerName":"unlink_from_mother"},{"name":"$mother","containerName":"unlink_from_mother","kind":13,"line":713},{"line":713,"kind":13,"containerName":"unlink_from_mother","name":"$mother"},{"name":"$mother","containerName":"unlink_from_mother","kind":13,"line":714}],"line":710,"name":"unlink_from_mother","definition":"sub","containerName":"main::","range":{"start":{"line":710,"character":0},"end":{"character":9999,"line":715}}},{"range":{"start":{"character":0,"line":728},"end":{"character":9999,"line":730}},"containerName":"main::","name":"clear_daughters","definition":"sub","line":728,"children":[{"localvar":"my","name":"$mother","definition":"my","containerName":"clear_daughters","line":729,"kind":13},{"kind":13,"line":730,"definition":"my","name":"@daughters","containerName":"clear_daughters","localvar":"my"},{"line":730,"kind":13,"containerName":"clear_daughters","name":"$mother"}],"kind":12},{"kind":13,"line":732,"containerName":null,"name":"%mother"},{"name":"$one","definition":"my","containerName":null,"localvar":"my","kind":13,"line":733},{"containerName":null,"name":"@daughters","line":733,"kind":13},{"containerName":"can","name":"UNIVERSAL","kind":12,"line":734},{"name":"$one","containerName":null,"line":734,"kind":13},{"containerName":null,"name":"%one","kind":13,"line":735},{"containerName":null,"name":"@daughters","kind":13,"line":740},{"kind":12,"children":[{"kind":13,"line":755,"name":"$mother","definition":"my","containerName":"set_daughters","localvar":"my"},{"containerName":"set_daughters","name":"@them","line":755,"kind":13},{"name":"$mother","containerName":"set_daughters","line":756,"kind":13},{"name":"clear_daughters","containerName":"set_daughters","line":756,"kind":12},{"line":757,"kind":13,"containerName":"set_daughters","name":"$mother"},{"name":"add_daughters","containerName":"set_daughters","kind":12,"line":757},{"containerName":"set_daughters","name":"@them","kind":13,"line":757},{"kind":13,"line":757,"name":"@them","containerName":"set_daughters"}],"line":754,"definition":"sub","containerName":"main::","signature":{"label":"set_daughters($mother,@them)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).","parameters":[{"label":"$mother"},{"label":"@them"}]},"detail":"($mother,@them)","name":"set_daughters","range":{"start":{"line":754,"character":0},"end":{"character":9999,"line":759}}},{"name":"replace_with","range":{"start":{"character":0,"line":810},"end":{"line":841,"character":9999}},"containerName":"main::","definition":"sub","detail":"($this,@replacements)","signature":{"label":"replace_with($this,@replacements)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.","parameters":[{"label":"$this"},{"label":"@replacements"}]},"kind":12,"line":810,"children":[{"kind":13,"line":811,"containerName":"replace_with","name":"$this","definition":"my","localvar":"my"},{"kind":13,"line":811,"name":"@replacements","containerName":"replace_with"},{"containerName":"replace_with","name":"$this","line":813,"kind":13},{"kind":13,"line":813,"containerName":"replace_with","name":"$this"},{"line":814,"kind":13,"localvar":"my","definition":"my","name":"$replacement","containerName":"replace_with"},{"containerName":"replace_with","name":"@replacements","kind":13,"line":814},{"kind":13,"line":815,"containerName":"replace_with","name":"$replacement"},{"line":815,"kind":12,"name":"remove_daughters","containerName":"replace_with"},{"containerName":"replace_with","name":"$replacement","kind":13,"line":815},{"name":"$replacement","containerName":"replace_with","kind":13,"line":816},{"name":"$mother","definition":"my","containerName":"replace_with","localvar":"my","kind":13,"line":820},{"kind":13,"line":820,"containerName":"replace_with","name":"$this"},{"kind":13,"line":824,"name":"@replacements","containerName":"replace_with"},{"kind":13,"line":825,"name":"$this","containerName":"replace_with"},{"kind":13,"line":828,"name":"$mother","containerName":"replace_with"},{"name":"@replacements","containerName":"replace_with","line":830,"kind":13},{"line":834,"kind":13,"name":"$mother","containerName":"replace_with"},{"line":834,"kind":12,"name":"set_daughters","containerName":"replace_with"},{"containerName":"replace_with","name":"$this","kind":13,"line":835},{"name":"@replacements","containerName":"replace_with","kind":13,"line":835},{"containerName":"replace_with","name":"$mother","kind":13,"line":836}]},{"kind":13,"line":842,"name":"$this","containerName":null},{"name":"@replacements","containerName":null,"kind":13,"line":842},{"line":868,"children":[{"kind":13,"line":869,"containerName":"replace_with_daughters","definition":"my","name":"$this","localvar":"my"},{"localvar":"my","definition":"my","name":"$mother","containerName":"replace_with_daughters","line":870,"kind":13},{"name":"$this","containerName":"replace_with_daughters","kind":13,"line":870},{"name":"$this","containerName":"replace_with_daughters","kind":13,"line":871},{"line":871,"kind":13,"name":"$this","containerName":"replace_with_daughters"},{"name":"clear_daughters","containerName":"replace_with_daughters","line":871,"kind":12},{"name":"$mother","containerName":"replace_with_daughters","line":872,"kind":13},{"containerName":"replace_with_daughters","name":"$mother","line":872,"kind":13},{"line":874,"kind":13,"localvar":"my","containerName":"replace_with_daughters","definition":"my","name":"@daughters"},{"kind":13,"line":874,"name":"$this","containerName":"replace_with_daughters"},{"containerName":"replace_with_daughters","name":"clear_daughters","kind":12,"line":874},{"line":875,"kind":13,"localvar":"my","containerName":"replace_with_daughters","name":"$sib_r","definition":"my"},{"kind":13,"line":875,"containerName":"replace_with_daughters","name":"$mother"},{"kind":13,"line":876,"containerName":"replace_with_daughters","name":"$sib_r"},{"containerName":"replace_with_daughters","name":"$this","kind":13,"line":876},{"line":876,"kind":13,"containerName":"replace_with_daughters","name":"@daughters"},{"kind":13,"line":877,"name":"$sib_r","containerName":"replace_with_daughters"},{"containerName":"replace_with_daughters","name":"$daughter","definition":"my","localvar":"my","kind":13,"line":879},{"name":"@daughters","containerName":"replace_with_daughters","line":879,"kind":13},{"kind":13,"line":880,"containerName":"replace_with_daughters","name":"$daughter"},{"kind":13,"line":880,"name":"$mother","containerName":"replace_with_daughters"},{"line":882,"kind":13,"containerName":"replace_with_daughters","name":"$this"},{"containerName":"replace_with_daughters","name":"@daughters","line":882,"kind":13}],"kind":12,"range":{"start":{"line":868,"character":0},"end":{"character":9999,"line":883}},"containerName":"main::","definition":"sub","name":"replace_with_daughters"},{"line":906,"children":[{"containerName":"add_left_sisters","name":"$this","definition":"my","localvar":"my","kind":13,"line":907},{"line":907,"kind":13,"name":"@new","containerName":"add_left_sisters"},{"kind":13,"line":908,"name":"@new","containerName":"add_left_sisters"},{"containerName":"add_left_sisters","name":"@new","line":910,"kind":13},{"containerName":"add_left_sisters","name":"$this","line":910,"kind":13},{"line":910,"kind":12,"name":"replace_with","containerName":"add_left_sisters"},{"kind":13,"line":910,"containerName":"add_left_sisters","name":"@new"},{"line":910,"kind":13,"containerName":"add_left_sisters","name":"$this"},{"containerName":"add_left_sisters","name":"@new","line":911,"kind":13},{"kind":13,"line":911,"name":"@new","containerName":"add_left_sisters"},{"kind":13,"line":912,"containerName":"add_left_sisters","name":"@new"}],"kind":12,"detail":"($this,@new)","signature":{"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).","parameters":[{"label":"$this"},{"label":"@new"}],"label":"add_left_sisters($this,@new)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":913},"start":{"character":0,"line":906}},"name":"add_left_sisters"},{"signature":{"label":"add_left_sister($it,@them)","parameters":[{"label":"$it"},{"label":"@them"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)"},"detail":"($it,@them)","definition":"sub","containerName":"main::","children":[{"containerName":"add_left_sister","name":"$it","definition":"my","localvar":"my","kind":13,"line":922},{"name":"@them","containerName":"add_left_sister","kind":13,"line":922},{"name":"$it","containerName":"add_left_sister","line":922,"kind":13},{"kind":12,"line":922,"containerName":"add_left_sister","name":"add_left_sisters"},{"kind":13,"line":922,"name":"@them","containerName":"add_left_sister"}],"line":921,"kind":12,"range":{"start":{"character":0,"line":921},"end":{"line":923,"character":9999}},"name":"add_left_sister"},{"line":936,"children":[{"line":937,"kind":13,"localvar":"my","containerName":"add_right_sisters","definition":"my","name":"$this"},{"line":937,"kind":13,"containerName":"add_right_sisters","name":"@new"},{"containerName":"add_right_sisters","name":"@new","line":938,"kind":13},{"containerName":"add_right_sisters","name":"@new","line":939,"kind":13},{"line":939,"kind":13,"name":"$this","containerName":"add_right_sisters"},{"containerName":"add_right_sisters","name":"replace_with","line":939,"kind":12},{"containerName":"add_right_sisters","name":"$this","kind":13,"line":939},{"name":"@new","containerName":"add_right_sisters","line":939,"kind":13},{"kind":13,"line":940,"containerName":"add_right_sisters","name":"@new"},{"line":940,"kind":13,"containerName":"add_right_sisters","name":"@new"},{"name":"@new","containerName":"add_right_sisters","kind":13,"line":941}],"kind":12,"detail":"($this,@new)","signature":{"label":"add_right_sisters($this,@new)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).","parameters":[{"label":"$this"},{"label":"@new"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":936},"end":{"line":942,"character":9999}},"name":"add_right_sisters"},{"range":{"end":{"character":9999,"line":952},"start":{"character":0,"line":950}},"name":"add_right_sister","detail":"($it,@them)","signature":{"label":"add_right_sister($it,@them)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)","parameters":[{"label":"$it"},{"label":"@them"}]},"containerName":"main::","definition":"sub","line":950,"children":[{"line":951,"kind":13,"localvar":"my","containerName":"add_right_sister","name":"$it","definition":"my"},{"line":951,"kind":13,"containerName":"add_right_sister","name":"@them"},{"name":"$it","containerName":"add_right_sister","line":951,"kind":13},{"containerName":"add_right_sister","name":"add_right_sisters","line":951,"kind":12},{"name":"@them","containerName":"add_right_sister","kind":13,"line":951}],"kind":12},{"range":{"end":{"character":9999,"line":978},"start":{"character":0,"line":974}},"name":"name","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$this","containerName":"name","localvar":"my","kind":13,"line":975},{"name":"$this","containerName":"name","line":976,"kind":13},{"kind":13,"line":977,"name":"$this","containerName":"name"}],"line":974,"kind":12},{"range":{"start":{"character":0,"line":999},"end":{"line":1007,"character":9999}},"name":"attributes","definition":"sub","containerName":"main::","children":[{"line":1001,"kind":13,"localvar":"my","name":"$this","definition":"my","containerName":"attributes"},{"containerName":"attributes","name":"$this","line":1004,"kind":13},{"name":"$this","containerName":"attributes","kind":13,"line":1006}],"line":999,"kind":12},{"name":"Carp","containerName":"carp","kind":12,"line":1003},{"containerName":"main::","definition":"sub","detail":"($it,@them)","signature":{"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)","parameters":[{"label":"$it"},{"label":"@them"}],"label":"attribute($it,@them)"},"kind":12,"line":1015,"children":[{"kind":13,"line":1016,"containerName":"attribute","name":"$it","definition":"my","localvar":"my"},{"kind":13,"line":1016,"containerName":"attribute","name":"@them"},{"name":"$it","containerName":"attribute","kind":13,"line":1016},{"line":1016,"kind":12,"containerName":"attribute","name":"attributes"},{"containerName":"attribute","name":"@them","kind":13,"line":1016}],"name":"attribute","range":{"start":{"line":1015,"character":0},"end":{"line":1017,"character":9999}}},{"range":{"start":{"character":0,"line":1022},"end":{"character":9999,"line":1031}},"definition":"sub","name":"no_cyclicity","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$it","containerName":"no_cyclicity","line":1023,"kind":13},{"kind":13,"line":1028,"name":"$it","containerName":"no_cyclicity"},{"kind":12,"line":1028,"name":"cyclicity_fault","containerName":"no_cyclicity"},{"containerName":"no_cyclicity","name":"$it","line":1029,"kind":13},{"line":1029,"kind":12,"containerName":"no_cyclicity","name":"cyclicity_allowed"}],"line":1022,"kind":12},{"range":{"end":{"line":1036,"character":9999},"start":{"character":0,"line":1033}},"name":"cyclicity_fault","line":1033,"children":[{"kind":13,"line":1034,"containerName":"cyclicity_fault","name":"$it","definition":"my","localvar":"my"},{"containerName":"cyclicity_fault","name":"$bitch","kind":13,"line":1034}],"kind":12,"detail":"($it,$bitch)","signature":{"documentation":"","parameters":[{"label":"$it"},{"label":"$bitch"}],"label":"cyclicity_fault($it,$bitch)"},"containerName":"main::","definition":"sub"},{"line":1038,"children":[],"kind":12,"range":{"end":{"character":9999,"line":1040},"start":{"character":0,"line":1038}},"containerName":"main::","name":"cyclicity_allowed","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$it"},{"label":"$tree"}],"documentation":" More secret stuff.  Currently unused.","label":"inaugurate_root($it,$tree)"},"detail":"($it,$tree)","kind":12,"children":[{"name":"$it","definition":"my","containerName":"inaugurate_root","localvar":"my","kind":13,"line":1046},{"name":"$tree","containerName":"inaugurate_root","kind":13,"line":1046}],"line":1045,"name":"inaugurate_root","range":{"start":{"character":0,"line":1045},"end":{"line":1049,"character":9999}}},{"line":1046,"kind":12,"name":"Carp","containerName":"croak"},{"line":1051,"children":[],"kind":12,"range":{"start":{"character":0,"line":1051},"end":{"character":9999,"line":1054}},"containerName":"main::","name":"decommission_root","definition":"sub"},{"children":[],"line":1073,"kind":12,"range":{"end":{"character":9999,"line":1073},"start":{"character":0,"line":1073}},"definition":"sub","name":"is_node","containerName":"main::"},{"kind":12,"line":1093,"children":[{"line":1094,"kind":13,"localvar":"my","containerName":"ancestors","definition":"my","name":"$this"},{"line":1095,"kind":13,"localvar":"my","name":"$mama","definition":"my","containerName":"ancestors"},{"kind":13,"line":1095,"name":"$this","containerName":"ancestors"},{"containerName":"ancestors","name":"$mama","line":1096,"kind":13},{"definition":"my","name":"@ancestors","containerName":"ancestors","localvar":"my","kind":13,"line":1109},{"containerName":"ancestors","name":"$mama","line":1109,"kind":13},{"containerName":"ancestors","name":"$mama","line":1110,"kind":13},{"containerName":"ancestors","name":"$mama","line":1110,"kind":13},{"line":1110,"kind":13,"containerName":"ancestors","name":"$mama"},{"line":1112,"kind":13,"name":"@ancestors","containerName":"ancestors"},{"line":1112,"kind":13,"containerName":"ancestors","name":"$mama"},{"kind":13,"line":1116,"name":"@ancestors","containerName":"ancestors"}],"containerName":"main::","name":"ancestors","definition":"sub","range":{"start":{"character":0,"line":1093},"end":{"character":9999,"line":1117}}},{"containerName":"main::","name":"root","definition":"sub","range":{"start":{"line":1128,"character":0},"end":{"character":9999,"line":1132}},"kind":12,"line":1128,"children":[{"line":1129,"kind":13,"localvar":"my","definition":"my","name":"$it","containerName":"root"},{"kind":13,"line":1130,"definition":"my","name":"@ancestors","containerName":"root","localvar":"my"},{"kind":13,"line":1130,"name":"$it","containerName":"root"},{"name":"$it","containerName":"root","line":1130,"kind":13},{"containerName":"root","name":"ancestors","line":1130,"kind":12},{"line":1131,"kind":13,"containerName":"root","name":"$ancestors"}]},{"name":"is_daughter_of","range":{"end":{"line":1146,"character":9999},"start":{"line":1143,"character":0}},"containerName":"main::","definition":"sub","detail":"($it,$mama)","signature":{"parameters":[{"label":"$it"},{"label":"$mama"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).","label":"is_daughter_of($it,$mama)"},"kind":12,"line":1143,"children":[{"line":1144,"kind":13,"localvar":"my","containerName":"is_daughter_of","name":"$it","definition":"my"},{"containerName":"is_daughter_of","name":"$mama","kind":13,"line":1144},{"name":"$it","containerName":"is_daughter_of","line":1145,"kind":13},{"kind":13,"line":1145,"containerName":"is_daughter_of","name":"$mama"}]},{"name":"self_and_descendants","definition":"sub","containerName":"main::","range":{"start":{"line":1160,"character":0},"end":{"character":9999,"line":1169}},"kind":12,"children":[{"name":"$node","definition":"my","containerName":"self_and_descendants","localvar":"my","kind":13,"line":1162},{"containerName":"self_and_descendants","name":"@List","definition":"my","localvar":"my","kind":13,"line":1163},{"name":"$node","containerName":"self_and_descendants","line":1165,"kind":13},{"line":1165,"kind":12,"containerName":"self_and_descendants","name":"walk_down"},{"containerName":"self_and_descendants","name":"@List","kind":13,"line":1165},{"kind":13,"line":1166,"containerName":"self_and_descendants","name":"@List"},{"containerName":"self_and_descendants","name":"@List","line":1168,"kind":13}],"line":1160},{"line":1182,"children":[{"localvar":"my","name":"$node","definition":"my","containerName":"descendants","line":1184,"kind":13},{"line":1185,"kind":13,"localvar":"my","name":"@list","definition":"my","containerName":"descendants"},{"name":"$node","containerName":"descendants","line":1185,"kind":13},{"kind":12,"line":1185,"name":"self_and_descendants","containerName":"descendants"},{"containerName":"descendants","name":"@list","line":1186,"kind":13},{"kind":13,"line":1187,"name":"@list","containerName":"descendants"}],"kind":12,"range":{"start":{"line":1182,"character":0},"end":{"character":9999,"line":1188}},"containerName":"main::","definition":"sub","name":"descendants"},{"containerName":"croak","name":"Carp","line":1184,"kind":12},{"kind":12,"children":[{"line":1204,"kind":13,"localvar":"my","containerName":"leaves_under","definition":"my","name":"$node"},{"containerName":"leaves_under","name":"@List","definition":"my","localvar":"my","kind":13,"line":1205},{"name":"$node","containerName":"leaves_under","kind":13,"line":1207},{"line":1207,"kind":12,"name":"walk_down","containerName":"leaves_under"},{"line":1209,"kind":13,"localvar":"my","definition":"my","name":"$node","containerName":"leaves_under"},{"kind":13,"line":1210,"definition":"my","name":"@daughters","containerName":"leaves_under","localvar":"my"},{"name":"$node","containerName":"leaves_under","kind":13,"line":1210},{"name":"@List","containerName":"leaves_under","kind":13,"line":1211},{"kind":13,"line":1211,"containerName":"leaves_under","name":"$node"},{"name":"@daughters","containerName":"leaves_under","line":1211,"kind":13}],"line":1201,"definition":"sub","name":"leaves_under","containerName":"main::","range":{"start":{"character":0,"line":1201},"end":{"line":1214,"character":9999}}},{"kind":13,"line":1215,"containerName":null,"name":"@List"},{"containerName":null,"name":"@List","kind":13,"line":1217},{"containerName":"main::","name":"depth_under","definition":"sub","range":{"end":{"line":1244,"character":9999},"start":{"character":0,"line":1232}},"kind":12,"line":1232,"children":[{"kind":13,"line":1233,"name":"$node","definition":"my","containerName":"depth_under","localvar":"my"},{"localvar":"my","name":"$max_depth","definition":"my","containerName":"depth_under","line":1234,"kind":13},{"kind":13,"line":1235,"containerName":"depth_under","name":"$node"},{"name":"walk_down","containerName":"depth_under","line":1235,"kind":12},{"containerName":"depth_under","definition":"my","name":"$depth","localvar":"my","kind":13,"line":1238},{"name":"$max_depth","containerName":"depth_under","line":1239,"kind":13},{"kind":13,"line":1239,"containerName":"depth_under","name":"$depth"},{"kind":13,"line":1239,"name":"$depth","containerName":"depth_under"},{"line":1239,"kind":13,"containerName":"depth_under","name":"$max_depth"},{"line":1243,"kind":13,"name":"$max_depth","containerName":"depth_under"}]},{"kind":12,"line":1233,"containerName":"croak","name":"Carp"},{"name":"generation","range":{"end":{"line":1295,"character":9999},"start":{"line":1286,"character":0}},"kind":12,"line":1286,"children":[{"kind":13,"line":1287,"containerName":"generation","definition":"my","name":"$node","localvar":"my"},{"kind":13,"line":1287,"containerName":"generation","name":"$limit"},{"line":1290,"kind":13,"name":"$node","containerName":"generation"},{"containerName":"generation","name":"$node","kind":13,"line":1290},{"name":"$limit","containerName":"generation","line":1290,"kind":13},{"line":1291,"kind":13,"name":"$node","containerName":"generation"},{"containerName":"generation","name":"$node","line":1292,"kind":13}],"containerName":"main::","definition":"sub","detail":"($node,$limit)","signature":{"label":"generation($node,$limit)","parameters":[{"label":"$node"},{"label":"$limit"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation()."}},{"line":1295,"kind":13,"containerName":null,"name":"%node"},{"name":"generation","containerName":"main::","kind":12,"line":1295},{"name":"$limit","containerName":null,"line":1295,"kind":13},{"line":1300,"children":[{"name":"$node","definition":"my","containerName":"generation_under","localvar":"my","kind":13,"line":1301},{"kind":13,"line":1301,"name":"@rest","containerName":"generation_under"},{"kind":13,"line":1302,"containerName":"generation_under","name":"$node"},{"name":"generation","containerName":"generation_under","line":1302,"kind":12},{"kind":13,"line":1302,"name":"@rest","containerName":"generation_under"}],"kind":12,"detail":"($node,@rest)","signature":{"label":"generation_under($node,@rest)","documentation":"","parameters":[{"label":"$node"},{"label":"@rest"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":1303,"character":9999},"start":{"line":1300,"character":0}},"name":"generation_under"},{"kind":12,"children":[{"line":1320,"kind":13,"localvar":"my","containerName":"self_and_sisters","name":"$node","definition":"my"},{"line":1321,"kind":13,"localvar":"my","definition":"my","name":"$mother","containerName":"self_and_sisters"},{"line":1321,"kind":13,"name":"$node","containerName":"self_and_sisters"},{"kind":13,"line":1322,"name":"$node","containerName":"self_and_sisters"},{"line":1322,"kind":13,"containerName":"self_and_sisters","name":"$mother"},{"line":1322,"kind":13,"name":"$mother","containerName":"self_and_sisters"},{"containerName":"self_and_sisters","name":"$node","kind":13,"line":1323}],"line":1319,"name":"self_and_sisters","definition":"sub","containerName":"main::","range":{"start":{"line":1319,"character":0},"end":{"line":1323,"character":9999}}},{"children":[{"containerName":"sisters","definition":"my","name":"$node","localvar":"my","kind":13,"line":1337},{"kind":13,"line":1338,"containerName":"sisters","definition":"my","name":"$mother","localvar":"my"},{"containerName":"sisters","name":"$node","kind":13,"line":1338},{"kind":13,"line":1339,"name":"$mother","containerName":"sisters"},{"line":1340,"kind":13,"containerName":"sisters","name":"$node"},{"kind":13,"line":1341,"name":"$node","containerName":"sisters"}],"line":1336,"kind":12,"range":{"end":{"line":1341,"character":9999},"start":{"character":0,"line":1336}},"name":"sisters","definition":"sub","containerName":"main::"},{"children":[{"line":1358,"kind":13,"localvar":"my","definition":"my","name":"$it","containerName":"left_sister"},{"containerName":"left_sister","name":"$mother","definition":"my","localvar":"my","kind":13,"line":1359},{"line":1359,"kind":13,"name":"$it","containerName":"left_sister"},{"kind":13,"line":1360,"name":"$mother","containerName":"left_sister"},{"localvar":"my","containerName":"left_sister","definition":"my","name":"@sisters","line":1361,"kind":13},{"containerName":"left_sister","name":"$mother","line":1361,"kind":13}],"line":1357,"kind":12,"range":{"start":{"character":0,"line":1357},"end":{"line":1361,"character":9999}},"name":"left_sister","definition":"sub","containerName":"main::"},{"name":"@sisters","containerName":null,"line":1363,"kind":13},{"kind":13,"line":1365,"name":"$left","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"definition":"my","name":"$one","localvar":"my","kind":13,"line":1366},{"name":"@sisters","containerName":null,"kind":13,"line":1366},{"name":"$left","containerName":null,"kind":13,"line":1367},{"kind":13,"line":1367,"containerName":null,"name":"$one"},{"kind":13,"line":1367,"name":"$it","containerName":null},{"name":"$left","containerName":null,"line":1368,"kind":13},{"containerName":null,"name":"$one","line":1368,"kind":13},{"kind":12,"line":1384,"children":[{"kind":13,"line":1385,"containerName":"left_sisters","name":"$it","definition":"my","localvar":"my"},{"line":1386,"kind":13,"localvar":"my","definition":"my","name":"$mother","containerName":"left_sisters"},{"line":1386,"kind":13,"containerName":"left_sisters","name":"$it"},{"kind":13,"line":1387,"containerName":"left_sisters","name":"$mother"},{"line":1388,"kind":13,"localvar":"my","name":"@sisters","definition":"my","containerName":"left_sisters"},{"line":1388,"kind":13,"containerName":"left_sisters","name":"$mother"}],"containerName":"main::","name":"left_sisters","definition":"sub","range":{"start":{"line":1384,"character":0},"end":{"line":1388,"character":9999}}},{"kind":13,"line":1389,"containerName":null,"name":"@sisters"},{"kind":13,"line":1391,"containerName":null,"name":"@out","definition":"my","localvar":"my"},{"kind":13,"line":1392,"definition":"my","name":"$one","containerName":null,"localvar":"my"},{"line":1392,"kind":13,"name":"@sisters","containerName":null},{"containerName":null,"name":"@out","kind":13,"line":1393},{"line":1393,"kind":13,"name":"$one","containerName":null},{"name":"$it","containerName":null,"line":1393,"kind":13},{"containerName":null,"name":"@out","line":1394,"kind":13},{"name":"$one","containerName":null,"kind":13,"line":1394},{"children":[{"kind":13,"line":1410,"containerName":"right_sister","definition":"my","name":"$it","localvar":"my"},{"localvar":"my","definition":"my","name":"$mother","containerName":"right_sister","line":1411,"kind":13},{"containerName":"right_sister","name":"$it","kind":13,"line":1411},{"kind":13,"line":1412,"containerName":"right_sister","name":"$mother"},{"localvar":"my","containerName":"right_sister","definition":"my","name":"@sisters","line":1413,"kind":13},{"containerName":"right_sister","name":"$mother","line":1413,"kind":13}],"line":1409,"kind":12,"range":{"start":{"line":1409,"character":0},"end":{"line":1413,"character":9999}},"name":"right_sister","definition":"sub","containerName":"main::"},{"line":1414,"kind":13,"containerName":null,"name":"@sisters"},{"localvar":"my","name":"$seen","definition":"my","containerName":null,"line":1416,"kind":13},{"kind":13,"line":1417,"definition":"my","name":"$one","containerName":null,"localvar":"my"},{"line":1417,"kind":13,"containerName":null,"name":"@sisters"},{"kind":13,"line":1418,"containerName":null,"name":"$one"},{"containerName":null,"name":"$seen","kind":13,"line":1418},{"containerName":null,"name":"$seen","line":1419,"kind":13},{"name":"$one","containerName":null,"line":1419,"kind":13},{"kind":13,"line":1419,"containerName":null,"name":"$it"},{"kind":13,"line":1422,"name":"$seen","containerName":null},{"line":1436,"children":[{"definition":"my","name":"$it","containerName":"right_sisters","localvar":"my","kind":13,"line":1437},{"definition":"my","name":"$mother","containerName":"right_sisters","localvar":"my","kind":13,"line":1438},{"name":"$it","containerName":"right_sisters","line":1438,"kind":13},{"containerName":"right_sisters","name":"$mother","line":1439,"kind":13},{"containerName":"right_sisters","definition":"my","name":"@sisters","localvar":"my","kind":13,"line":1440},{"containerName":"right_sisters","name":"$mother","line":1440,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":1440},"start":{"line":1436,"character":0}},"containerName":"main::","name":"right_sisters","definition":"sub"},{"line":1441,"kind":13,"containerName":null,"name":"@sisters"},{"kind":13,"line":1443,"definition":"my","name":"@out","containerName":null,"localvar":"my"},{"kind":13,"line":1444,"definition":"my","name":"$seen","containerName":null,"localvar":"my"},{"kind":13,"line":1445,"name":"$one","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"@sisters","kind":13,"line":1445},{"line":1446,"kind":13,"name":"@out","containerName":null},{"kind":13,"line":1446,"containerName":null,"name":"$one"},{"line":1446,"kind":13,"name":"$seen","containerName":null},{"name":"$seen","containerName":null,"line":1447,"kind":13},{"kind":13,"line":1447,"containerName":null,"name":"$one"},{"line":1447,"kind":13,"name":"$it","containerName":null},{"name":"$seen","containerName":null,"line":1450,"kind":13},{"name":"@out","containerName":null,"line":1451,"kind":13},{"containerName":"main::","name":"my_daughter_index","definition":"sub","range":{"end":{"line":1474,"character":9999},"start":{"character":0,"line":1466}},"kind":12,"line":1466,"children":[{"kind":13,"line":1469,"name":"$node","definition":"my","containerName":"my_daughter_index","localvar":"my"},{"localvar":"my","definition":"my","name":"$ord","containerName":"my_daughter_index","line":1470,"kind":13},{"localvar":"my","name":"$mother","definition":"my","containerName":"my_daughter_index","line":1471,"kind":13},{"containerName":"my_daughter_index","name":"$node","line":1471,"kind":13},{"containerName":"my_daughter_index","name":"$mother","line":1473,"kind":13},{"kind":13,"line":1474,"containerName":"my_daughter_index","name":"@sisters","definition":"my","localvar":"my"},{"containerName":"my_daughter_index","name":"$mother","line":1474,"kind":13}]},{"kind":13,"line":1476,"containerName":null,"name":"@sisters"},{"line":1478,"kind":12,"name":"Find_Self"},{"kind":13,"line":1479,"containerName":null,"name":"$i","definition":"my","localvar":"my"},{"kind":13,"line":1479,"name":"$i","containerName":null},{"containerName":null,"name":"@sisters","line":1479,"kind":13},{"kind":13,"line":1479,"containerName":null,"name":"%i"},{"name":"@sisters","containerName":null,"kind":13,"line":1480},{"containerName":null,"name":"$i","line":1480,"kind":13},{"containerName":null,"name":"%node","kind":13,"line":1480},{"kind":13,"line":1481,"name":"$ord","containerName":null},{"line":1481,"kind":13,"name":"$i","containerName":null},{"kind":12,"line":1482,"name":"Find_Self"},{"line":1485,"kind":13,"name":"$ord","containerName":null},{"kind":13,"line":1486,"containerName":null,"name":"$ord"},{"containerName":"main::","definition":"sub","detail":"($it,$address)","signature":{"label":"address($it,$address)","parameters":[{"label":"$it"},{"label":"$address"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)"},"kind":12,"line":1535,"children":[{"containerName":"address","definition":"my","name":"$it","localvar":"my","kind":13,"line":1536},{"containerName":"address","name":"$address","kind":13,"line":1536},{"line":1537,"kind":13,"containerName":"address","name":"$address"},{"line":1537,"kind":13,"containerName":"address","name":"$address"},{"containerName":"address","name":"$root","definition":"my","localvar":"my","kind":13,"line":1539},{"containerName":"address","name":"$it","kind":13,"line":1539},{"name":"root","containerName":"address","kind":12,"line":1539},{"localvar":"my","containerName":"address","name":"@parts","definition":"my","line":1540,"kind":13},{"kind":13,"line":1541,"containerName":"address","name":"$address"},{"kind":13,"line":1542,"containerName":"address","name":"@parts"},{"name":"@parts","containerName":"address","line":1543,"kind":13},{"kind":13,"line":1545,"containerName":"address","name":"$current_node","definition":"my","localvar":"my"},{"containerName":"address","name":"$root","line":1545,"kind":13},{"name":"@parts","containerName":"address","kind":13,"line":1546},{"definition":"my","name":"$ord","containerName":"address","localvar":"my","kind":13,"line":1547},{"name":"@parts","containerName":"address","kind":13,"line":1547},{"localvar":"my","containerName":"address","name":"@daughters","definition":"my","line":1548,"kind":13},{"name":"$current_node","containerName":"address","line":1548,"kind":13},{"kind":13,"line":1550,"containerName":"address","name":"$ord"},{"containerName":"address","name":"$Debug","line":1551,"kind":13},{"kind":13,"line":1554,"containerName":"address","name":"$current_node"},{"name":"$daughters","containerName":"address","line":1554,"kind":13},{"line":1554,"kind":13,"name":"$ord","containerName":"address"},{"kind":13,"line":1555,"name":"$current_node","containerName":"address"},{"containerName":"address","name":"$Debug","kind":13,"line":1556},{"kind":13,"line":1560,"containerName":"address","name":"$current_node"}],"name":"address","range":{"end":{"line":1562,"character":9999},"start":{"character":0,"line":1535}}},{"kind":12,"line":1543,"containerName":"croak::Carp::croak","name":"Carp"},{"name":"daughters","line":1550,"kind":12},{"localvar":"my","definition":"my","name":"@parts","containerName":null,"line":1563,"kind":13},{"localvar":"my","definition":"my","name":"$current_node","containerName":null,"line":1564,"kind":13},{"line":1564,"kind":13,"name":"$it","containerName":null},{"line":1565,"kind":13,"localvar":"my","name":"$mother","definition":"my","containerName":null},{"kind":13,"line":1567,"name":"$mother","containerName":null},{"line":1567,"kind":13,"name":"%current_node","containerName":null},{"name":"%mother","containerName":null,"line":1567,"kind":13},{"containerName":null,"name":"@parts","kind":13,"line":1568},{"line":1568,"kind":13,"containerName":null,"name":"$current_node"},{"kind":12,"line":1568,"containerName":"main::","name":"my_daughter_index"},{"name":"$current_node","containerName":null,"kind":13,"line":1569},{"line":1569,"kind":13,"name":"$mother","containerName":null},{"name":"@parts","containerName":null,"kind":13,"line":1571},{"name":"common","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1621},"start":{"line":1591,"character":0}},"kind":12,"children":[{"containerName":"common","name":"@ones","definition":"my","localvar":"my","kind":13,"line":1593},{"kind":13,"line":1594,"name":"$first","definition":"my","containerName":"common","localvar":"my"},{"line":1594,"kind":13,"name":"@others","containerName":"common"},{"containerName":"common","name":"$first","line":1596,"kind":13},{"kind":13,"line":1596,"containerName":"common","name":"@others"},{"localvar":"my","containerName":"common","name":"%ones","definition":"my","line":1598,"kind":13},{"kind":13,"line":1599,"containerName":"common","name":"@ones"},{"line":1599,"kind":13,"name":"@ones","containerName":"common"},{"kind":13,"line":1601,"containerName":"common","definition":"my","name":"$node","localvar":"my"},{"containerName":"common","name":"@others","kind":13,"line":1601},{"line":1603,"kind":13,"containerName":"common","name":"$node"},{"localvar":"my","name":"%first_lineage","definition":"my","containerName":"common","line":1604,"kind":13},{"line":1605,"kind":13,"containerName":"common","name":"@first_lineage"},{"line":1605,"kind":13,"containerName":"common","name":"$first"},{"kind":13,"line":1605,"containerName":"common","name":"$first"},{"line":1605,"kind":12,"name":"ancestors","containerName":"common"},{"line":1606,"kind":13,"localvar":"my","containerName":"common","name":"$higher","definition":"my"},{"name":"@my_lineage","definition":"my","containerName":"common","localvar":"my","kind":13,"line":1607},{"name":"$node","containerName":"common","kind":13,"line":1607},{"name":"ancestors","containerName":"common","kind":12,"line":1607},{"line":1610,"kind":13,"containerName":"common","name":"@my_lineage"},{"line":1611,"kind":13,"containerName":"common","name":"$first_lineage"},{"containerName":"common","name":"$my_lineage","line":1611,"kind":13},{"containerName":"common","name":"$higher","kind":13,"line":1612},{"name":"$my_lineage","containerName":"common","line":1612,"kind":13},{"kind":13,"line":1615,"name":"@my_lineage","containerName":"common"},{"name":"$higher","containerName":"common","line":1617,"kind":13},{"containerName":"common","name":"$first","line":1618,"kind":13},{"name":"$higher","containerName":"common","kind":13,"line":1618},{"containerName":"common","name":"$first","kind":13,"line":1620}],"line":1591},{"containerName":"croak::UNIVERSAL::can","name":"Carp","line":1603,"kind":12},{"line":1609,"kind":12,"name":"Find_Common"},{"name":"Find_Common","line":1613,"kind":12},{"containerName":"main::","name":"common_ancestor","definition":"sub","range":{"end":{"line":1662,"character":9999},"start":{"line":1644,"character":0}},"kind":12,"line":1644,"children":[{"kind":13,"line":1645,"definition":"my","name":"@ones","containerName":"common_ancestor","localvar":"my"},{"kind":13,"line":1646,"definition":"my","name":"$first","containerName":"common_ancestor","localvar":"my"},{"containerName":"common_ancestor","name":"@others","line":1646,"kind":13},{"name":"$first","containerName":"common_ancestor","kind":13,"line":1648},{"containerName":"common_ancestor","name":"@others","kind":13,"line":1648},{"kind":13,"line":1651,"definition":"my","name":"%ones","containerName":"common_ancestor","localvar":"my"},{"name":"@ones","containerName":"common_ancestor","line":1652,"kind":13},{"line":1652,"kind":13,"name":"@ones","containerName":"common_ancestor"},{"kind":13,"line":1654,"containerName":"common_ancestor","name":"$common","definition":"my","localvar":"my"},{"line":1654,"kind":13,"name":"$first","containerName":"common_ancestor"},{"name":"common","containerName":"common_ancestor","kind":12,"line":1654},{"line":1654,"kind":13,"containerName":"common_ancestor","name":"@others"},{"kind":13,"line":1655,"name":"$ones","containerName":"common_ancestor"},{"containerName":"common_ancestor","name":"$common","kind":13,"line":1655},{"containerName":"common_ancestor","name":"$common","kind":13,"line":1656},{"name":"$common","containerName":"common_ancestor","line":1659,"kind":13}]},{"containerName":"main::","definition":"sub","detail":"($this,$o)","signature":{"parameters":[{"label":"$this"},{"label":"$o"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)\n\n\nsub address {\n  my($it, $address) = @_[0,1];\n  if(defined($address) && length($address)) { # given the address, return the node.\n    # invalid addresses return undef\n    my $root = $it->root;\n    my @parts = map {$_ + 0}\n                    $address =~ m/(\\d+)/g; # generous!\n    Carp::croak \"Address \\\"$address\\\" is an ill-formed address\" unless @parts;\n    Carp::croak \"Address \\\"$address\\\" must start with '0'\" unless shift(@parts) == 0;\n\n    my $current_node = $root;\n    while(@parts) { # no-op for root\n      my $ord = shift @parts;\n      my @daughters = @{$current_node->{'daughters'}};\n\n      if($#daughters < $ord) { # illegal address\n        print \"* $address has an out-of-range index ($ord)!\" if $Debug;\n        return undef;\n      }\n      $current_node = $daughters[$ord];\n      unless(ref($current_node)) {\n        print \"* $address points to or thru a non-node!\" if $Debug;\n        return undef;\n      }\n    }\n    return $current_node;\n\n  } else { # given the node, return the address\n    my @parts = ();\n    my $current_node = $it;\n    my $mother;\n\n    while(defined( $mother = $current_node->{'mother'} ) && ref($mother)) {\n      unshift @parts, $current_node->my_daughter_index;\n      $current_node = $mother;\n    }\n    return join(':', 0, @parts);\n  }\n}\n\n###########################################################################\n\n* $node->common(LIST)\n\nReturns the lowest node in the tree that is ancestor-or-self to the\nnodes $node and LIST.\n\nIf the nodes are far enough apart in the tree, the answer is just the\nroot.\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node.\n\n\nsub common { # Return the lowest node common to all these nodes...\n  # Called as $it->common($other) or $it->common(@others)\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first unless @others; # degenerate case\n\n  my %ones;\n  @ones{ @ones } = undef;\n\n  foreach my $node (@others) {\n    Carp::croak \"TILT: node \\\"$node\\\" is not a node\"\n      unless UNIVERSAL::can($node, 'is_node');\n    my %first_lineage;\n    @first_lineage{$first, $first->ancestors} = undef;\n    my $higher = undef; # the common of $first and $node\n    my @my_lineage = $node->ancestors;\n\n   Find_Common:\n    while(@my_lineage) {\n      if(exists $first_lineage{$my_lineage[0]}) {\n        $higher = $my_lineage[0];\n        last Find_Common;\n      }\n      shift @my_lineage;\n    }\n    return undef unless $higher;\n    $first = $higher;\n  } \n  return $first;\n}\n\n\n###########################################################################\n\n* $node->common_ancestor(LIST)\n\nReturns the lowest node that is ancestor to all the nodes given (in\nnodes $node and LIST).  In other words, it answers the question: \"What\nnode in the tree, as low as possible, is ancestor to the nodes given\n($node and LIST)?\"\n\nIf the nodes are far enough apart, the answer is just the root --\nexcept if any of the nodes are the root itself, in which case the\nanswer is undef (since the root has no ancestor).\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node's mother;\nthat'll be undef if $node is root.\n\n\nsub common_ancestor {\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first->{'mother'} unless @others;\n    # which may be undef if $first is the root!\n\n  my %ones;\n  @ones{ @ones } = undef; # my arguments\n\n  my $common = $first->common(@others);\n  if(exists($ones{$common})) { # if the common is one of my nodes...\n    return $common->{'mother'};\n    # and this might be undef, if $common is root!\n  } else {\n    return $common;\n    # which might be null if that's all common came up with\n  }\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 YET MORE METHODS\n\n\n* $node->walk_down({ callback => \\&foo, callbackback => \\&foo, ... })\n\nPerforms a depth-first traversal of the structure at and under $node.\nWhat it does at each node depends on the value of the options hashref,\nwhich you must provide.  There are three options, \"callback\" and\n\"callbackback\" (at least one of which must be defined, as a sub\nreference), and \"_depth\".  This is what C<walk_down> does, in\npseudocode form:\n\n* Start at the $node given.\n\n* If there's a C<callback>, call it with $node as the first argument,\nand the options hashref as the second argument (which contains the\npotentially useful C<_depth>, remember).  This function must return\ntrue or false -- if false, it will block the next step:\n\n* If $node has any daughter nodes, increment C<_depth>, and call\n$daughter->walk_down(options_hashref) for each daughter (in order, of\ncourse), where options_hashref is the same hashref it was called with.\nWhen this returns, decrements C<_depth>.\n\n* If there's a C<callbackback>, call just it as with C<callback> (but\ntossing out the return value).  Note that C<callback> returning false\nblocks traversal below $node, but doesn't block calling callbackback\nfor $node.  (Incidentally, in the unlikely case that $node has stopped\nbeing a node object, C<callbackback> won't get called.)\n\n* Return.\n\n$node->walk_down is the way to recursively do things to a tree (if you\nstart at the root) or part of a tree; if what you're doing is best done\nvia pre-pre order traversal, use C<callback>; if what you're doing is\nbest done with post-order traversal, use C<callbackback>.\nC<walk_down> is even the basis for plenty of the methods in this\nclass.  See the source code for examples both simple and horrific.\n\nNote that if you don't specify C<_depth>, it effectively defaults to\n0.  You should set it to scalar($node->ancestors) if you want\nC<_depth> to reflect the true depth-in-the-tree for the nodes called,\ninstead of just the depth below $node.  (If $node is the root, there's\ndifference, of course.)\n\nAnd B<by the way>, it's a bad idea to modify the tree from the callback.\nUnpredictable things may happen.  I instead suggest having your callback\nadd to a stack of things that need changing, and then, once C<walk_down>\nis all finished, changing those nodes from that stack.\n\nNote that the existence of C<walk_down> doesn't mean you can't write\nyou own special-use traversers.","label":"walk_down($this,$o)"},"kind":12,"line":1725,"children":[{"kind":13,"line":1726,"definition":"my","name":"$this","containerName":"walk_down","localvar":"my"},{"kind":13,"line":1726,"containerName":"walk_down","name":"$o"},{"name":"$o","containerName":"walk_down","kind":13,"line":1731},{"kind":13,"line":1733,"name":"$o","containerName":"walk_down"},{"name":"$o","containerName":"walk_down","kind":13,"line":1733},{"line":1736,"kind":13,"localvar":"my","containerName":"walk_down","name":"$callback","definition":"my"},{"name":"$o","containerName":"walk_down","line":1736,"kind":13},{"name":"$o","containerName":"walk_down","kind":13,"line":1736},{"kind":13,"line":1737,"containerName":"walk_down","name":"$callbackback","definition":"my","localvar":"my"},{"line":1737,"kind":13,"name":"$o","containerName":"walk_down"},{"name":"$o","containerName":"walk_down","line":1737,"kind":13},{"localvar":"my","containerName":"walk_down","name":"$callback_status","definition":"my","line":1738,"kind":13},{"containerName":"walk_down","name":"$Debug","line":1740,"kind":13},{"kind":13,"line":1742,"containerName":"walk_down","name":"$this"},{"line":1742,"kind":12,"name":"name","containerName":"walk_down"},{"kind":13,"line":1742,"containerName":"walk_down","name":"$this"},{"kind":13,"line":1742,"containerName":"walk_down","name":"$Debug"},{"name":"$callback_status","containerName":"walk_down","kind":13,"line":1743},{"name":"$callback","containerName":"walk_down","kind":13,"line":1743}],"name":"walk_down","range":{"end":{"line":1743,"character":9999},"start":{"line":1725,"character":0}}},{"name":"Carp","containerName":"croak","line":1731,"kind":12},{"line":1733,"kind":12,"name":"Carp","containerName":"croak"},{"containerName":null,"name":"$this","kind":13,"line":1743},{"name":"$o","containerName":null,"line":1743,"kind":13},{"name":"$callback","containerName":null,"kind":13,"line":1743},{"containerName":null,"name":"%callback_status","kind":13,"line":1745},{"localvar":"my","containerName":null,"definition":"my","name":"@daughters","line":1748,"kind":13},{"containerName":"can","name":"UNIVERSAL","line":1748,"kind":12},{"kind":13,"line":1748,"containerName":null,"name":"$this"},{"line":1748,"kind":13,"name":"%this","containerName":null},{"line":1749,"kind":13,"name":"@daughters","containerName":null},{"line":1750,"kind":13,"name":"%o","containerName":null},{"localvar":"my","containerName":null,"name":"$one","definition":"my","line":1752,"kind":13},{"containerName":null,"name":"@daughters","line":1752,"kind":13},{"name":"$one","containerName":null,"kind":13,"line":1753},{"name":"walk_down","containerName":"main::","line":1753,"kind":12},{"line":1753,"kind":13,"containerName":null,"name":"$o"},{"line":1753,"kind":12,"containerName":"can","name":"UNIVERSAL"},{"name":"$one","containerName":null,"line":1753,"kind":13},{"name":"%o","containerName":null,"kind":13,"line":1756},{"containerName":null,"name":"$this","line":1759,"kind":13},{"containerName":"main::","name":"name","kind":12,"line":1759},{"name":"$this","containerName":null,"line":1759,"kind":13},{"name":"$Debug","containerName":null,"kind":13,"line":1759},{"line":1763,"kind":13,"containerName":null,"name":"%callbackback"},{"kind":12,"line":1764,"name":"UNIVERSAL","containerName":"can"},{"containerName":null,"name":"%this","line":1764,"kind":13},{"name":"$Debug","containerName":null,"line":1765,"kind":13},{"containerName":null,"name":"$callbackback","kind":13,"line":1766},{"containerName":null,"name":"$this","line":1766,"kind":13},{"kind":13,"line":1766,"containerName":null,"name":"%o"},{"kind":13,"line":1770,"containerName":null,"name":"$Debug"},{"kind":13,"line":1773,"name":"%Debug","containerName":null},{"containerName":"can","name":"UNIVERSAL","kind":12,"line":1774},{"kind":13,"line":1774,"containerName":null,"name":"%this"},{"containerName":null,"name":"$this","kind":13,"line":1775},{"containerName":"main::","name":"name","kind":12,"line":1775},{"containerName":null,"name":"%this","kind":13,"line":1775},{"range":{"end":{"character":9999,"line":1831},"start":{"character":0,"line":1808}},"name":"dump_names","line":1808,"children":[{"containerName":"dump_names","definition":"my","name":"$it","localvar":"my","kind":13,"line":1809},{"name":"$o","containerName":"dump_names","line":1809,"kind":13},{"containerName":"dump_names","name":"$o","kind":13,"line":1810},{"name":"$o","containerName":"dump_names","kind":13,"line":1810},{"line":1811,"kind":13,"localvar":"my","containerName":"dump_names","name":"@out","definition":"my"},{"containerName":"dump_names","name":"$o","line":1812,"kind":13},{"name":"$o","containerName":"dump_names","kind":13,"line":1813},{"kind":13,"line":1814,"containerName":"dump_names","name":"$o"},{"line":1816,"kind":13,"containerName":"dump_names","name":"$o"},{"definition":"my","name":"$this","containerName":"dump_names","localvar":"my","kind":13,"line":1817},{"name":"$o","containerName":"dump_names","line":1817,"kind":13},{"line":1818,"kind":13,"containerName":"dump_names","name":"@out"},{"kind":13,"line":1820,"containerName":"dump_names","name":"$o"},{"kind":13,"line":1820,"name":"$o","containerName":"dump_names"},{"line":1821,"kind":13,"containerName":"dump_names","name":"$o"},{"containerName":"dump_names","name":"$this","kind":13,"line":1822},{"name":"name","containerName":"dump_names","kind":12,"line":1822},{"containerName":"dump_names","name":"$this","kind":13,"line":1822},{"name":"$it","containerName":"dump_names","kind":13,"line":1829},{"line":1829,"kind":12,"name":"walk_down","containerName":"dump_names"},{"line":1829,"kind":13,"containerName":"dump_names","name":"$o"},{"containerName":"dump_names","name":"@out","line":1830,"kind":13}],"kind":12,"detail":"($it,$o)","signature":{"label":"dump_names($it,$o)","parameters":[{"label":"$it"},{"label":"$o"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)\n\n\nsub address {\n  my($it, $address) = @_[0,1];\n  if(defined($address) && length($address)) { # given the address, return the node.\n    # invalid addresses return undef\n    my $root = $it->root;\n    my @parts = map {$_ + 0}\n                    $address =~ m/(\\d+)/g; # generous!\n    Carp::croak \"Address \\\"$address\\\" is an ill-formed address\" unless @parts;\n    Carp::croak \"Address \\\"$address\\\" must start with '0'\" unless shift(@parts) == 0;\n\n    my $current_node = $root;\n    while(@parts) { # no-op for root\n      my $ord = shift @parts;\n      my @daughters = @{$current_node->{'daughters'}};\n\n      if($#daughters < $ord) { # illegal address\n        print \"* $address has an out-of-range index ($ord)!\" if $Debug;\n        return undef;\n      }\n      $current_node = $daughters[$ord];\n      unless(ref($current_node)) {\n        print \"* $address points to or thru a non-node!\" if $Debug;\n        return undef;\n      }\n    }\n    return $current_node;\n\n  } else { # given the node, return the address\n    my @parts = ();\n    my $current_node = $it;\n    my $mother;\n\n    while(defined( $mother = $current_node->{'mother'} ) && ref($mother)) {\n      unshift @parts, $current_node->my_daughter_index;\n      $current_node = $mother;\n    }\n    return join(':', 0, @parts);\n  }\n}\n\n###########################################################################\n\n* $node->common(LIST)\n\nReturns the lowest node in the tree that is ancestor-or-self to the\nnodes $node and LIST.\n\nIf the nodes are far enough apart in the tree, the answer is just the\nroot.\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node.\n\n\nsub common { # Return the lowest node common to all these nodes...\n  # Called as $it->common($other) or $it->common(@others)\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first unless @others; # degenerate case\n\n  my %ones;\n  @ones{ @ones } = undef;\n\n  foreach my $node (@others) {\n    Carp::croak \"TILT: node \\\"$node\\\" is not a node\"\n      unless UNIVERSAL::can($node, 'is_node');\n    my %first_lineage;\n    @first_lineage{$first, $first->ancestors} = undef;\n    my $higher = undef; # the common of $first and $node\n    my @my_lineage = $node->ancestors;\n\n   Find_Common:\n    while(@my_lineage) {\n      if(exists $first_lineage{$my_lineage[0]}) {\n        $higher = $my_lineage[0];\n        last Find_Common;\n      }\n      shift @my_lineage;\n    }\n    return undef unless $higher;\n    $first = $higher;\n  } \n  return $first;\n}\n\n\n###########################################################################\n\n* $node->common_ancestor(LIST)\n\nReturns the lowest node that is ancestor to all the nodes given (in\nnodes $node and LIST).  In other words, it answers the question: \"What\nnode in the tree, as low as possible, is ancestor to the nodes given\n($node and LIST)?\"\n\nIf the nodes are far enough apart, the answer is just the root --\nexcept if any of the nodes are the root itself, in which case the\nanswer is undef (since the root has no ancestor).\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node's mother;\nthat'll be undef if $node is root.\n\n\nsub common_ancestor {\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first->{'mother'} unless @others;\n    # which may be undef if $first is the root!\n\n  my %ones;\n  @ones{ @ones } = undef; # my arguments\n\n  my $common = $first->common(@others);\n  if(exists($ones{$common})) { # if the common is one of my nodes...\n    return $common->{'mother'};\n    # and this might be undef, if $common is root!\n  } else {\n    return $common;\n    # which might be null if that's all common came up with\n  }\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 YET MORE METHODS\n\n\n* $node->walk_down({ callback => \\&foo, callbackback => \\&foo, ... })\n\nPerforms a depth-first traversal of the structure at and under $node.\nWhat it does at each node depends on the value of the options hashref,\nwhich you must provide.  There are three options, \"callback\" and\n\"callbackback\" (at least one of which must be defined, as a sub\nreference), and \"_depth\".  This is what C<walk_down> does, in\npseudocode form:\n\n* Start at the $node given.\n\n* If there's a C<callback>, call it with $node as the first argument,\nand the options hashref as the second argument (which contains the\npotentially useful C<_depth>, remember).  This function must return\ntrue or false -- if false, it will block the next step:\n\n* If $node has any daughter nodes, increment C<_depth>, and call\n$daughter->walk_down(options_hashref) for each daughter (in order, of\ncourse), where options_hashref is the same hashref it was called with.\nWhen this returns, decrements C<_depth>.\n\n* If there's a C<callbackback>, call just it as with C<callback> (but\ntossing out the return value).  Note that C<callback> returning false\nblocks traversal below $node, but doesn't block calling callbackback\nfor $node.  (Incidentally, in the unlikely case that $node has stopped\nbeing a node object, C<callbackback> won't get called.)\n\n* Return.\n\n$node->walk_down is the way to recursively do things to a tree (if you\nstart at the root) or part of a tree; if what you're doing is best done\nvia pre-pre order traversal, use C<callback>; if what you're doing is\nbest done with post-order traversal, use C<callbackback>.\nC<walk_down> is even the basis for plenty of the methods in this\nclass.  See the source code for examples both simple and horrific.\n\nNote that if you don't specify C<_depth>, it effectively defaults to\n0.  You should set it to scalar($node->ancestors) if you want\nC<_depth> to reflect the true depth-in-the-tree for the nodes called,\ninstead of just the depth below $node.  (If $node is the root, there's\ndifference, of course.)\n\nAnd B<by the way>, it's a bad idea to modify the tree from the callback.\nUnpredictable things may happen.  I instead suggest having your callback\nadd to a stack of things that need changing, and then, once C<walk_down>\nis all finished, changing those nodes from that stack.\n\nNote that the existence of C<walk_down> doesn't mean you can't write\nyou own special-use traversers.\n\n\nsub walk_down {\n  my($this, $o) = @_[0,1];\n\n  # All the can()s are in case an object changes class while I'm\n  # looking at it.\n\n  Carp::croak \"I need options!\" unless ref($o);\n  Carp::croak \"I need a callback or a callbackback\" unless\n    ( ref($o->{'callback'}) || ref($o->{'callbackback'}) );\n\n  # $this->no_cyclicity;\n  my $callback = ref($o->{'callback'}) ? $o->{'callback'} : undef;\n  my $callbackback = ref($o->{'callbackback'}) ? $o->{'callbackback'} : undef;\n  my $callback_status = 1;\n\n  print \"Callback: $callback   Callbackback: $callbackback\\n\" if $Debug;\n\n  printf \"* Entering %s\\n\", ($this->name || $this) if $Debug;\n  $callback_status = &{ $callback }( $this, $o ) if $callback;\n\n  if($callback_status) {\n    # Keep recursing unless callback returned false... and if there's\n    # anything to recurse into, of course.\n    my @daughters = UNIVERSAL::can($this, 'is_node') ? @{$this->{'daughters'}} : ();\n    if(@daughters) {\n      $o->{'_depth'} += 1;\n      #print \"Depth \" , $o->{'_depth'}, \"\\n\";\n      foreach my $one (@daughters) {\n        $one->walk_down($o) if UNIVERSAL::can($one, 'is_node');\n        # and if it can do \"is_node\", it should provide a walk_down!\n      }\n      $o->{'_depth'} -= 1;\n    }\n  } else {\n    printf \"* Recursing below %s pruned\\n\", ($this->name || $this) if $Debug;\n  }\n\n  # Note that $callback_status doesn't block callbackback from being called\n  if($callbackback){\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      print \"* Calling callbackback\\n\" if $Debug;\n      scalar( &{ $callbackback }( $this, $o ) );\n      # scalar to give it the same context as callback\n    } else {\n      print \"* Can't call callbackback -- $this isn't a node anymore\\n\"\n        if $Debug;\n    }\n  }\n  if($Debug) {\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      printf \"* Leaving %s\\n\", ($this->name || $this)\n    } else {\n      print \"* Leaving [no longer a node]\\n\";\n    }\n  }\n  return;\n}\n\n###########################################################################\n\n* @lines = $node->dump_names({ ...options... });\n\nDumps, as an indented list, the names of the nodes starting at $node,\nand continuing under it.  Options are:\n\n* _depth -- A nonnegative number.  Indicating the depth to consider\n$node as being at (and so the generation under that is that plus one,\netc.).  Defaults to 0.  You may choose to use set _depth =>\nscalar($node->ancestors).\n\n* tick -- a string to preface each entry with, between the\nindenting-spacing and the node's name.  Defaults to empty-string.  You\nmay prefer \"*\" or \"-> \" or someting.\n\n* indent -- the string used to indent with.  Defaults to \"  \" (two\nspaces).  Another sane value might be \". \" (period, space).  Setting it\nto empty-string suppresses indenting.\n\nThe dump is not printed, but is returned as a list, where each\nitem is a line, with a \"\\n\" at the end."},"containerName":"main::","definition":"sub"},{"name":"Tree","containerName":"DAG_Node::_dump_quote","kind":12,"line":1822},{"line":1870,"children":[{"kind":13,"line":1871,"definition":"my","name":"$class","containerName":"random_network","localvar":"my"},{"line":1872,"kind":13,"localvar":"my","containerName":"random_network","definition":"my","name":"$o"},{"kind":13,"line":1873,"containerName":"random_network","name":"$am_cons","definition":"my","localvar":"my"},{"name":"$root","definition":"my","containerName":"random_network","localvar":"my","kind":13,"line":1874},{"name":"$class","containerName":"random_network","line":1876,"kind":13},{"containerName":"random_network","name":"$root","kind":13,"line":1877},{"line":1878,"kind":13,"containerName":"random_network","name":"$class"},{"line":1878,"kind":13,"containerName":"random_network","name":"$class"},{"name":"$am_cons","containerName":"random_network","line":1879,"kind":13},{"line":1881,"kind":13,"containerName":"random_network","name":"$root"},{"name":"$class","containerName":"random_network","line":1881,"kind":13},{"name":"new","containerName":"random_network","kind":12,"line":1881},{"kind":13,"line":1882,"name":"$root","containerName":"random_network"},{"kind":12,"line":1882,"containerName":"random_network","name":"name"},{"line":1883,"kind":13,"name":"$am_cons","containerName":"random_network"},{"containerName":"random_network","name":"$min_depth","definition":"my","localvar":"my","kind":13,"line":1886},{"kind":13,"line":1886,"name":"$o","containerName":"random_network"},{"kind":13,"line":1887,"definition":"my","name":"$max_depth","containerName":"random_network","localvar":"my"},{"name":"$o","containerName":"random_network","line":1887,"kind":13},{"kind":13,"line":1887,"containerName":"random_network","name":"$min_depth"},{"localvar":"my","name":"$max_children","definition":"my","containerName":"random_network","line":1888,"kind":13},{"line":1888,"kind":13,"name":"$o","containerName":"random_network"},{"line":1889,"kind":13,"localvar":"my","containerName":"random_network","definition":"my","name":"$max_node_count"},{"containerName":"random_network","name":"$o","kind":13,"line":1889},{"name":"$max_children","containerName":"random_network","line":1891,"kind":13},{"containerName":"random_network","name":"@mothers","definition":"my","localvar":"my","kind":13,"line":1893},{"line":1893,"kind":13,"containerName":"random_network","name":"$root"},{"kind":13,"line":1894,"containerName":"random_network","definition":"my","name":"@children","localvar":"my"},{"localvar":"my","name":"$node_count","definition":"my","containerName":"random_network","line":1895,"kind":13},{"kind":13,"line":1898,"containerName":"random_network","definition":"my","name":"$depth","localvar":"my"},{"line":1898,"kind":13,"name":"$max_depth","containerName":"random_network"},{"containerName":"random_network","name":"$node_count","line":1899,"kind":13},{"containerName":"random_network","name":"$max_node_count","line":1899,"kind":13},{"line":1901,"kind":13,"localvar":"my","containerName":"random_network","definition":"my","name":"$mother"},{"name":"@mothers","containerName":"random_network","kind":13,"line":1901},{"kind":13,"line":1902,"name":"$node_count","containerName":"random_network"},{"name":"$max_node_count","containerName":"random_network","line":1902,"kind":13},{"kind":13,"line":1903,"definition":"my","name":"$children_number","containerName":"random_network","localvar":"my"},{"line":1904,"kind":13,"name":"$depth","containerName":"random_network"},{"containerName":"random_network","name":"$min_depth","line":1904,"kind":13},{"line":1905,"kind":13,"name":"$children_number","containerName":"random_network"},{"kind":13,"line":1905,"name":"$max_children","containerName":"random_network"},{"name":"$children_number","containerName":"random_network","kind":13,"line":1907},{"kind":13,"line":1907,"name":"$max_children","containerName":"random_network"},{"name":"$children_number","containerName":"random_network","line":1910,"kind":13},{"containerName":"random_network","name":"$node_count","line":1911,"kind":13},{"kind":13,"line":1911,"containerName":"random_network","name":"$max_node_count"},{"kind":13,"line":1912,"containerName":"random_network","name":"$node","definition":"my","localvar":"my"},{"kind":13,"line":1912,"name":"$mother","containerName":"random_network"},{"kind":12,"line":1912,"name":"new_daughter","containerName":"random_network"},{"line":1913,"kind":13,"containerName":"random_network","name":"$node"},{"name":"name","containerName":"random_network","kind":12,"line":1913},{"kind":13,"line":1914,"name":"$node_count","containerName":"random_network"},{"containerName":"random_network","name":"@children","line":1915,"kind":13},{"kind":13,"line":1915,"name":"$node","containerName":"random_network"},{"name":"@mothers","containerName":"random_network","kind":13,"line":1918},{"line":1918,"kind":13,"containerName":"random_network","name":"@children"},{"name":"@children","containerName":"random_network","line":1919,"kind":13},{"line":1920,"kind":13,"name":"@mothers","containerName":"random_network"},{"line":1923,"kind":13,"name":"$root","containerName":"random_network"}],"kind":12,"range":{"start":{"line":1870,"character":0},"end":{"character":9999,"line":1924}},"containerName":"main::","name":"random_network","definition":"sub"},{"containerName":"croak","name":"Carp","line":1891,"kind":12},{"line":1897,"kind":12,"name":"Gen"},{"line":1900,"kind":12,"name":"Mother"},{"line":1902,"kind":12,"name":"Gen"},{"name":"Beget","kind":12,"line":1909},{"line":1911,"kind":12,"name":"Gen"},{"name":"lol_to_tree","range":{"start":{"line":1991,"character":0},"end":{"line":2018,"character":9999}},"containerName":"main::","definition":"sub","detail":"($class,$lol,$seen_r)","signature":{"label":"lol_to_tree($class,$lol,$seen_r)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)\n\n\nsub address {\n  my($it, $address) = @_[0,1];\n  if(defined($address) && length($address)) { # given the address, return the node.\n    # invalid addresses return undef\n    my $root = $it->root;\n    my @parts = map {$_ + 0}\n                    $address =~ m/(\\d+)/g; # generous!\n    Carp::croak \"Address \\\"$address\\\" is an ill-formed address\" unless @parts;\n    Carp::croak \"Address \\\"$address\\\" must start with '0'\" unless shift(@parts) == 0;\n\n    my $current_node = $root;\n    while(@parts) { # no-op for root\n      my $ord = shift @parts;\n      my @daughters = @{$current_node->{'daughters'}};\n\n      if($#daughters < $ord) { # illegal address\n        print \"* $address has an out-of-range index ($ord)!\" if $Debug;\n        return undef;\n      }\n      $current_node = $daughters[$ord];\n      unless(ref($current_node)) {\n        print \"* $address points to or thru a non-node!\" if $Debug;\n        return undef;\n      }\n    }\n    return $current_node;\n\n  } else { # given the node, return the address\n    my @parts = ();\n    my $current_node = $it;\n    my $mother;\n\n    while(defined( $mother = $current_node->{'mother'} ) && ref($mother)) {\n      unshift @parts, $current_node->my_daughter_index;\n      $current_node = $mother;\n    }\n    return join(':', 0, @parts);\n  }\n}\n\n###########################################################################\n\n* $node->common(LIST)\n\nReturns the lowest node in the tree that is ancestor-or-self to the\nnodes $node and LIST.\n\nIf the nodes are far enough apart in the tree, the answer is just the\nroot.\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node.\n\n\nsub common { # Return the lowest node common to all these nodes...\n  # Called as $it->common($other) or $it->common(@others)\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first unless @others; # degenerate case\n\n  my %ones;\n  @ones{ @ones } = undef;\n\n  foreach my $node (@others) {\n    Carp::croak \"TILT: node \\\"$node\\\" is not a node\"\n      unless UNIVERSAL::can($node, 'is_node');\n    my %first_lineage;\n    @first_lineage{$first, $first->ancestors} = undef;\n    my $higher = undef; # the common of $first and $node\n    my @my_lineage = $node->ancestors;\n\n   Find_Common:\n    while(@my_lineage) {\n      if(exists $first_lineage{$my_lineage[0]}) {\n        $higher = $my_lineage[0];\n        last Find_Common;\n      }\n      shift @my_lineage;\n    }\n    return undef unless $higher;\n    $first = $higher;\n  } \n  return $first;\n}\n\n\n###########################################################################\n\n* $node->common_ancestor(LIST)\n\nReturns the lowest node that is ancestor to all the nodes given (in\nnodes $node and LIST).  In other words, it answers the question: \"What\nnode in the tree, as low as possible, is ancestor to the nodes given\n($node and LIST)?\"\n\nIf the nodes are far enough apart, the answer is just the root --\nexcept if any of the nodes are the root itself, in which case the\nanswer is undef (since the root has no ancestor).\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node's mother;\nthat'll be undef if $node is root.\n\n\nsub common_ancestor {\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first->{'mother'} unless @others;\n    # which may be undef if $first is the root!\n\n  my %ones;\n  @ones{ @ones } = undef; # my arguments\n\n  my $common = $first->common(@others);\n  if(exists($ones{$common})) { # if the common is one of my nodes...\n    return $common->{'mother'};\n    # and this might be undef, if $common is root!\n  } else {\n    return $common;\n    # which might be null if that's all common came up with\n  }\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 YET MORE METHODS\n\n\n* $node->walk_down({ callback => \\&foo, callbackback => \\&foo, ... })\n\nPerforms a depth-first traversal of the structure at and under $node.\nWhat it does at each node depends on the value of the options hashref,\nwhich you must provide.  There are three options, \"callback\" and\n\"callbackback\" (at least one of which must be defined, as a sub\nreference), and \"_depth\".  This is what C<walk_down> does, in\npseudocode form:\n\n* Start at the $node given.\n\n* If there's a C<callback>, call it with $node as the first argument,\nand the options hashref as the second argument (which contains the\npotentially useful C<_depth>, remember).  This function must return\ntrue or false -- if false, it will block the next step:\n\n* If $node has any daughter nodes, increment C<_depth>, and call\n$daughter->walk_down(options_hashref) for each daughter (in order, of\ncourse), where options_hashref is the same hashref it was called with.\nWhen this returns, decrements C<_depth>.\n\n* If there's a C<callbackback>, call just it as with C<callback> (but\ntossing out the return value).  Note that C<callback> returning false\nblocks traversal below $node, but doesn't block calling callbackback\nfor $node.  (Incidentally, in the unlikely case that $node has stopped\nbeing a node object, C<callbackback> won't get called.)\n\n* Return.\n\n$node->walk_down is the way to recursively do things to a tree (if you\nstart at the root) or part of a tree; if what you're doing is best done\nvia pre-pre order traversal, use C<callback>; if what you're doing is\nbest done with post-order traversal, use C<callbackback>.\nC<walk_down> is even the basis for plenty of the methods in this\nclass.  See the source code for examples both simple and horrific.\n\nNote that if you don't specify C<_depth>, it effectively defaults to\n0.  You should set it to scalar($node->ancestors) if you want\nC<_depth> to reflect the true depth-in-the-tree for the nodes called,\ninstead of just the depth below $node.  (If $node is the root, there's\ndifference, of course.)\n\nAnd B<by the way>, it's a bad idea to modify the tree from the callback.\nUnpredictable things may happen.  I instead suggest having your callback\nadd to a stack of things that need changing, and then, once C<walk_down>\nis all finished, changing those nodes from that stack.\n\nNote that the existence of C<walk_down> doesn't mean you can't write\nyou own special-use traversers.\n\n\nsub walk_down {\n  my($this, $o) = @_[0,1];\n\n  # All the can()s are in case an object changes class while I'm\n  # looking at it.\n\n  Carp::croak \"I need options!\" unless ref($o);\n  Carp::croak \"I need a callback or a callbackback\" unless\n    ( ref($o->{'callback'}) || ref($o->{'callbackback'}) );\n\n  # $this->no_cyclicity;\n  my $callback = ref($o->{'callback'}) ? $o->{'callback'} : undef;\n  my $callbackback = ref($o->{'callbackback'}) ? $o->{'callbackback'} : undef;\n  my $callback_status = 1;\n\n  print \"Callback: $callback   Callbackback: $callbackback\\n\" if $Debug;\n\n  printf \"* Entering %s\\n\", ($this->name || $this) if $Debug;\n  $callback_status = &{ $callback }( $this, $o ) if $callback;\n\n  if($callback_status) {\n    # Keep recursing unless callback returned false... and if there's\n    # anything to recurse into, of course.\n    my @daughters = UNIVERSAL::can($this, 'is_node') ? @{$this->{'daughters'}} : ();\n    if(@daughters) {\n      $o->{'_depth'} += 1;\n      #print \"Depth \" , $o->{'_depth'}, \"\\n\";\n      foreach my $one (@daughters) {\n        $one->walk_down($o) if UNIVERSAL::can($one, 'is_node');\n        # and if it can do \"is_node\", it should provide a walk_down!\n      }\n      $o->{'_depth'} -= 1;\n    }\n  } else {\n    printf \"* Recursing below %s pruned\\n\", ($this->name || $this) if $Debug;\n  }\n\n  # Note that $callback_status doesn't block callbackback from being called\n  if($callbackback){\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      print \"* Calling callbackback\\n\" if $Debug;\n      scalar( &{ $callbackback }( $this, $o ) );\n      # scalar to give it the same context as callback\n    } else {\n      print \"* Can't call callbackback -- $this isn't a node anymore\\n\"\n        if $Debug;\n    }\n  }\n  if($Debug) {\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      printf \"* Leaving %s\\n\", ($this->name || $this)\n    } else {\n      print \"* Leaving [no longer a node]\\n\";\n    }\n  }\n  return;\n}\n\n###########################################################################\n\n* @lines = $node->dump_names({ ...options... });\n\nDumps, as an indented list, the names of the nodes starting at $node,\nand continuing under it.  Options are:\n\n* _depth -- A nonnegative number.  Indicating the depth to consider\n$node as being at (and so the generation under that is that plus one,\netc.).  Defaults to 0.  You may choose to use set _depth =>\nscalar($node->ancestors).\n\n* tick -- a string to preface each entry with, between the\nindenting-spacing and the node's name.  Defaults to empty-string.  You\nmay prefer \"*\" or \"-> \" or someting.\n\n* indent -- the string used to indent with.  Defaults to \"  \" (two\nspaces).  Another sane value might be \". \" (period, space).  Setting it\nto empty-string suppresses indenting.\n\nThe dump is not printed, but is returned as a list, where each\nitem is a line, with a \"\\n\" at the end.\n\n\nsub dump_names {\n  my($it, $o) = @_[0,1];\n  $o = {} unless ref $o;\n  my @out = ();\n  $o->{'_depth'} ||= 0;\n  $o->{'indent'} ||= '  ';\n  $o->{'tick'} ||= '';\n\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      push(@out,\n        join('',\n             $o->{'indent'} x $o->{'_depth'},\n             $o->{'tick'},\n             &Tree::DAG_Node::_dump_quote($this->name || $this),\n             \"\\n\"\n        )\n      );      \n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  return @out;\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor CLASS->random_network({...options...})\n\n* the method $node->random_network({...options...})\n\nIn the first case, constructs a randomly arranged network under a new\nnode, and returns the root node of that tree.  In the latter case,\nconstructs the network under $node.\n\nCurrently, this is implemented a bit half-heartedly, and\nhalf-wittedly.  I basically needed to make up random-looking networks\nto stress-test the various tree-dumper methods, and so wrote this.  If\nyou actually want to rely on this for any application more\nserious than that, I suggest examining the source code and seeing if\nthis does really what you need (say, in reliability of randomness);\nand feel totally free to suggest changes to me (especially in the form\nof \"I rewrote C<random_network>, here's the code...\")\n\nIt takes four options:\n\n* max_node_count -- maximum number of nodes this tree will be allowed\nto have (counting the root).  Defaults to 25.\n\n* min_depth -- minimum depth for the tree.  Defaults to 2.  Leaves can\nbe generated only after this depth is reached, so the tree will be at\nleast this deep -- unless max_node_count is hit first.\n\n* max_depth -- maximum depth for the tree.  Defaults to 3 plus\nmin_depth.  The tree will not be deeper than this.\n\n* max_children -- maximum number of children any mother in the tree\ncan have.  Defaults to 4.\n\n\nsub random_network { # constructor or method.\n  my $class = $_[0];\n  my $o = ref($_[1]) ? $_[1] : {};\n  my $am_cons = 0;\n  my $root;\n\n  if(ref($class)){ # I'm a method.\n    $root = $_[0]; # build under the given node, from same class.\n    $class = ref $class;\n    $am_cons = 0;\n  } else { # I'm a constructor\n    $root = $class->new; # build under a new node, with class named.\n    $root->name(\"Root\");\n    $am_cons = 1;\n  }\n\n  my $min_depth = $o->{'min_depth'} || 2;\n  my $max_depth = $o->{'max_depth'} || ($min_depth + 3);\n  my $max_children = $o->{'max_children'} || 4;\n  my $max_node_count = $o->{'max_node_count'} || 25;\n\n  Carp::croak \"max_children has to be positive\" if int($max_children) < 1;\n\n  my @mothers = ( $root );\n  my @children = ( );\n  my $node_count = 1; # the root\n\n Gen:\n  foreach my $depth (1 .. $max_depth) {\n    last if $node_count > $max_node_count;\n   Mother:\n    foreach my $mother (@mothers) {\n      last Gen if $node_count > $max_node_count;\n      my $children_number;    \n      if($depth <= $min_depth) {\n        until( $children_number = int(rand(1 + $max_children)) ) {}\n      } else {\n        $children_number = int(rand($max_children));\n      }\n     Beget:\n      foreach (1 .. $children_number) {\n        last Gen if $node_count > $max_node_count;\n        my $node = $mother->new_daughter;\n        $node->name(\"Node$node_count\");\n        ++$node_count;\n        push(@children, $node);\n      }\n    }\n    @mothers = @children;\n    @children = ();\n    last unless @mothers;\n  }\n\n  return $root;\n}\n\n* the constructor CLASS->lol_to_tree($lol);\n\nConverts something like bracket-notation for \"Chomsky trees\" (or\nrather, the closest you can come with Perl\nlist-of-lists(-of-lists(-of-lists))) into a tree structure.  Returns\nthe root of the tree converted.\n\nThe conversion rules are that:  1) if the last (possibly the only) item\nin a given list is a scalar, then that is used as the \"name\" attribute\nfor the node based on this list.  2) All other items in the list\nrepresent daughter nodes of the current node -- recursively so, if\nthey are list references; otherwise, (non-terminal) scalars are\nconsidered to denote nodes with that name.  So ['Foo', 'Bar', 'N'] is\nan alternate way to represent [['Foo'], ['Bar'], 'N'].\n\nAn example will illustrate:\n\n  use Tree::DAG_Node;\n  $lol =\n    [\n      [\n        [ [ 'Det:The' ],\n          [ [ 'dog' ], 'N'], 'NP'],\n        [ '/with rabies\\\\', 'PP'],\n        'NP'\n      ],\n      [ 'died', 'VP'],\n      'S'\n    ];\n   $tree = Tree::DAG_Node->lol_to_tree($lol);\n   $diagram = $tree->draw_ascii_tree;\n   print map \"$_\\n\", @$diagram;\n\n...returns this tree:\n\n                   |                   \n                  <S>                  \n                   |                   \n                /------------------\\   \n                |                  |   \n              <NP>                <VP> \n                |                  |   \n        /---------------\\        <died>\n        |               |              \n      <NP>            <PP>             \n        |               |              \n     /-------\\   </with rabies\\>       \n     |       |                         \n <Det:The>  <N>                        \n             |                         \n           <dog>                       \n\nBy the way (and this rather follows from the above rules), when\ndenoting a LoL tree consisting of just one node, this:\n\n  $tree = Tree::DAG_Node->lol_to_tree( 'Lonely' );\n\nis okay, although it'd probably occur to you to denote it only as:\n\n  $tree = Tree::DAG_Node->lol_to_tree( ['Lonely'] );\n\nwhich is of course fine, too.","parameters":[{"label":"$class"},{"label":"$lol"},{"label":"$seen_r"}]},"kind":12,"line":1991,"children":[{"kind":13,"line":1992,"definition":"my","name":"$class","containerName":"lol_to_tree","localvar":"my"},{"name":"$lol","containerName":"lol_to_tree","kind":13,"line":1992},{"containerName":"lol_to_tree","name":"$seen_r","kind":13,"line":1992},{"containerName":"lol_to_tree","name":"$seen_r","kind":13,"line":1993},{"line":1993,"kind":13,"name":"$seen_r","containerName":"lol_to_tree"},{"containerName":"lol_to_tree","name":"$lol","kind":13,"line":1994},{"containerName":"lol_to_tree","name":"$seen_r","line":1994,"kind":13},{"name":"$lol","containerName":"lol_to_tree","line":1994,"kind":13},{"kind":13,"line":1996,"containerName":"lol_to_tree","name":"$class"},{"name":"$class","containerName":"lol_to_tree","line":1996,"kind":13},{"containerName":"lol_to_tree","name":"$class","kind":13,"line":1996},{"localvar":"my","containerName":"lol_to_tree","definition":"my","name":"$node","line":1997,"kind":13},{"name":"$class","containerName":"lol_to_tree","line":1997,"kind":13},{"name":"new","containerName":"lol_to_tree","kind":12,"line":1997},{"containerName":"lol_to_tree","name":"$lol","kind":13,"line":1999},{"kind":13,"line":2000,"name":"$node","containerName":"lol_to_tree"},{"kind":12,"line":2000,"containerName":"lol_to_tree","name":"name"},{"containerName":"lol_to_tree","name":"$lol","line":2000,"kind":13},{"kind":13,"line":2000,"name":"$lol","containerName":"lol_to_tree"},{"kind":13,"line":2001,"name":"$node","containerName":"lol_to_tree"},{"containerName":"lol_to_tree","name":"$node","kind":13,"line":2003},{"containerName":"lol_to_tree","name":"$lol","line":2003,"kind":13},{"name":"@options","definition":"my","containerName":"lol_to_tree","localvar":"my","kind":13,"line":2007},{"line":2007,"kind":13,"name":"$lol","containerName":"lol_to_tree"},{"kind":13,"line":2008,"name":"$options","containerName":"lol_to_tree"},{"line":2010,"kind":13,"containerName":"lol_to_tree","name":"$node"},{"containerName":"lol_to_tree","name":"name","line":2010,"kind":12},{"containerName":"lol_to_tree","name":"@options","line":2010,"kind":13},{"localvar":"my","containerName":"lol_to_tree","definition":"my","name":"$d","line":2013,"kind":13},{"kind":13,"line":2013,"name":"@options","containerName":"lol_to_tree"},{"name":"$node","containerName":"lol_to_tree","line":2014,"kind":13},{"containerName":"lol_to_tree","name":"add_daughter","line":2014,"kind":12},{"line":2014,"kind":13,"containerName":"lol_to_tree","name":"$class"},{"line":2014,"kind":12,"name":"lol_to_tree","containerName":"lol_to_tree"},{"name":"$d","containerName":"lol_to_tree","kind":13,"line":2014},{"name":"$seen_r","containerName":"lol_to_tree","kind":13,"line":2014},{"line":2017,"kind":13,"containerName":"lol_to_tree","name":"$node"}]},{"line":2053,"children":[{"localvar":"my","definition":"my","name":"$root","containerName":"tree_to_lol_notation","line":2054,"kind":13},{"line":2055,"kind":13,"localvar":"my","name":"$it","definition":"my","containerName":"tree_to_lol_notation"},{"name":"$o","containerName":"tree_to_lol_notation","kind":13,"line":2055},{"name":"$o","containerName":"tree_to_lol_notation","line":2056,"kind":13},{"line":2056,"kind":13,"name":"$o","containerName":"tree_to_lol_notation"},{"line":2057,"kind":13,"localvar":"my","containerName":"tree_to_lol_notation","name":"@out","definition":"my"},{"name":"$o","containerName":"tree_to_lol_notation","kind":13,"line":2058},{"line":2059,"kind":13,"name":"$o","containerName":"tree_to_lol_notation"},{"name":"$o","containerName":"tree_to_lol_notation","line":2059,"kind":13},{"localvar":"my","name":"$line_end","definition":"my","containerName":"tree_to_lol_notation","line":2061,"kind":13},{"containerName":"tree_to_lol_notation","name":"$o","line":2062,"kind":13},{"line":2063,"kind":13,"containerName":"tree_to_lol_notation","name":"$o"},{"line":2064,"kind":13,"name":"$line_end","containerName":"tree_to_lol_notation"},{"kind":13,"line":2066,"name":"$o","containerName":"tree_to_lol_notation"},{"containerName":"tree_to_lol_notation","name":"$line_end","line":2067,"kind":13},{"kind":13,"line":2070,"name":"$o","containerName":"tree_to_lol_notation"},{"line":2071,"kind":13,"localvar":"my","name":"$this","definition":"my","containerName":"tree_to_lol_notation"},{"containerName":"tree_to_lol_notation","name":"$o","line":2071,"kind":13},{"kind":13,"line":2072,"containerName":"tree_to_lol_notation","name":"@out"},{"containerName":"tree_to_lol_notation","name":"$o","kind":13,"line":2073},{"containerName":"tree_to_lol_notation","name":"$o","line":2073,"kind":13},{"line":2079,"kind":13,"name":"$o","containerName":"tree_to_lol_notation"},{"kind":13,"line":2080,"name":"$this","definition":"my","containerName":"tree_to_lol_notation","localvar":"my"},{"kind":13,"line":2080,"name":"$o","containerName":"tree_to_lol_notation"},{"localvar":"my","containerName":"tree_to_lol_notation","name":"$name","definition":"my","line":2081,"kind":13},{"name":"$this","containerName":"tree_to_lol_notation","line":2081,"kind":13},{"line":2081,"kind":12,"containerName":"tree_to_lol_notation","name":"name"},{"kind":13,"line":2082,"name":"$name","containerName":"tree_to_lol_notation"},{"line":2083,"kind":13,"name":"$name","containerName":"tree_to_lol_notation"},{"line":2085,"kind":13,"containerName":"tree_to_lol_notation","name":"$name"},{"containerName":"tree_to_lol_notation","name":"$name","kind":13,"line":2085},{"kind":13,"line":2087,"containerName":"tree_to_lol_notation","name":"@out"},{"name":"$o","containerName":"tree_to_lol_notation","line":2088,"kind":13},{"containerName":"tree_to_lol_notation","name":"$o","line":2088,"kind":13},{"containerName":"tree_to_lol_notation","name":"$o","kind":13,"line":2090},{"kind":13,"line":2090,"containerName":"tree_to_lol_notation","name":"$o"},{"name":"$it","containerName":"tree_to_lol_notation","kind":13,"line":2096},{"line":2096,"kind":12,"containerName":"tree_to_lol_notation","name":"walk_down"},{"name":"$o","containerName":"tree_to_lol_notation","line":2096,"kind":13},{"name":"@out","containerName":"tree_to_lol_notation","line":2097,"kind":13}],"kind":12,"detail":"($it,$o)","signature":{"label":"tree_to_lol_notation($it,$o)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)\n\n\nsub address {\n  my($it, $address) = @_[0,1];\n  if(defined($address) && length($address)) { # given the address, return the node.\n    # invalid addresses return undef\n    my $root = $it->root;\n    my @parts = map {$_ + 0}\n                    $address =~ m/(\\d+)/g; # generous!\n    Carp::croak \"Address \\\"$address\\\" is an ill-formed address\" unless @parts;\n    Carp::croak \"Address \\\"$address\\\" must start with '0'\" unless shift(@parts) == 0;\n\n    my $current_node = $root;\n    while(@parts) { # no-op for root\n      my $ord = shift @parts;\n      my @daughters = @{$current_node->{'daughters'}};\n\n      if($#daughters < $ord) { # illegal address\n        print \"* $address has an out-of-range index ($ord)!\" if $Debug;\n        return undef;\n      }\n      $current_node = $daughters[$ord];\n      unless(ref($current_node)) {\n        print \"* $address points to or thru a non-node!\" if $Debug;\n        return undef;\n      }\n    }\n    return $current_node;\n\n  } else { # given the node, return the address\n    my @parts = ();\n    my $current_node = $it;\n    my $mother;\n\n    while(defined( $mother = $current_node->{'mother'} ) && ref($mother)) {\n      unshift @parts, $current_node->my_daughter_index;\n      $current_node = $mother;\n    }\n    return join(':', 0, @parts);\n  }\n}\n\n###########################################################################\n\n* $node->common(LIST)\n\nReturns the lowest node in the tree that is ancestor-or-self to the\nnodes $node and LIST.\n\nIf the nodes are far enough apart in the tree, the answer is just the\nroot.\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node.\n\n\nsub common { # Return the lowest node common to all these nodes...\n  # Called as $it->common($other) or $it->common(@others)\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first unless @others; # degenerate case\n\n  my %ones;\n  @ones{ @ones } = undef;\n\n  foreach my $node (@others) {\n    Carp::croak \"TILT: node \\\"$node\\\" is not a node\"\n      unless UNIVERSAL::can($node, 'is_node');\n    my %first_lineage;\n    @first_lineage{$first, $first->ancestors} = undef;\n    my $higher = undef; # the common of $first and $node\n    my @my_lineage = $node->ancestors;\n\n   Find_Common:\n    while(@my_lineage) {\n      if(exists $first_lineage{$my_lineage[0]}) {\n        $higher = $my_lineage[0];\n        last Find_Common;\n      }\n      shift @my_lineage;\n    }\n    return undef unless $higher;\n    $first = $higher;\n  } \n  return $first;\n}\n\n\n###########################################################################\n\n* $node->common_ancestor(LIST)\n\nReturns the lowest node that is ancestor to all the nodes given (in\nnodes $node and LIST).  In other words, it answers the question: \"What\nnode in the tree, as low as possible, is ancestor to the nodes given\n($node and LIST)?\"\n\nIf the nodes are far enough apart, the answer is just the root --\nexcept if any of the nodes are the root itself, in which case the\nanswer is undef (since the root has no ancestor).\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node's mother;\nthat'll be undef if $node is root.\n\n\nsub common_ancestor {\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first->{'mother'} unless @others;\n    # which may be undef if $first is the root!\n\n  my %ones;\n  @ones{ @ones } = undef; # my arguments\n\n  my $common = $first->common(@others);\n  if(exists($ones{$common})) { # if the common is one of my nodes...\n    return $common->{'mother'};\n    # and this might be undef, if $common is root!\n  } else {\n    return $common;\n    # which might be null if that's all common came up with\n  }\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 YET MORE METHODS\n\n\n* $node->walk_down({ callback => \\&foo, callbackback => \\&foo, ... })\n\nPerforms a depth-first traversal of the structure at and under $node.\nWhat it does at each node depends on the value of the options hashref,\nwhich you must provide.  There are three options, \"callback\" and\n\"callbackback\" (at least one of which must be defined, as a sub\nreference), and \"_depth\".  This is what C<walk_down> does, in\npseudocode form:\n\n* Start at the $node given.\n\n* If there's a C<callback>, call it with $node as the first argument,\nand the options hashref as the second argument (which contains the\npotentially useful C<_depth>, remember).  This function must return\ntrue or false -- if false, it will block the next step:\n\n* If $node has any daughter nodes, increment C<_depth>, and call\n$daughter->walk_down(options_hashref) for each daughter (in order, of\ncourse), where options_hashref is the same hashref it was called with.\nWhen this returns, decrements C<_depth>.\n\n* If there's a C<callbackback>, call just it as with C<callback> (but\ntossing out the return value).  Note that C<callback> returning false\nblocks traversal below $node, but doesn't block calling callbackback\nfor $node.  (Incidentally, in the unlikely case that $node has stopped\nbeing a node object, C<callbackback> won't get called.)\n\n* Return.\n\n$node->walk_down is the way to recursively do things to a tree (if you\nstart at the root) or part of a tree; if what you're doing is best done\nvia pre-pre order traversal, use C<callback>; if what you're doing is\nbest done with post-order traversal, use C<callbackback>.\nC<walk_down> is even the basis for plenty of the methods in this\nclass.  See the source code for examples both simple and horrific.\n\nNote that if you don't specify C<_depth>, it effectively defaults to\n0.  You should set it to scalar($node->ancestors) if you want\nC<_depth> to reflect the true depth-in-the-tree for the nodes called,\ninstead of just the depth below $node.  (If $node is the root, there's\ndifference, of course.)\n\nAnd B<by the way>, it's a bad idea to modify the tree from the callback.\nUnpredictable things may happen.  I instead suggest having your callback\nadd to a stack of things that need changing, and then, once C<walk_down>\nis all finished, changing those nodes from that stack.\n\nNote that the existence of C<walk_down> doesn't mean you can't write\nyou own special-use traversers.\n\n\nsub walk_down {\n  my($this, $o) = @_[0,1];\n\n  # All the can()s are in case an object changes class while I'm\n  # looking at it.\n\n  Carp::croak \"I need options!\" unless ref($o);\n  Carp::croak \"I need a callback or a callbackback\" unless\n    ( ref($o->{'callback'}) || ref($o->{'callbackback'}) );\n\n  # $this->no_cyclicity;\n  my $callback = ref($o->{'callback'}) ? $o->{'callback'} : undef;\n  my $callbackback = ref($o->{'callbackback'}) ? $o->{'callbackback'} : undef;\n  my $callback_status = 1;\n\n  print \"Callback: $callback   Callbackback: $callbackback\\n\" if $Debug;\n\n  printf \"* Entering %s\\n\", ($this->name || $this) if $Debug;\n  $callback_status = &{ $callback }( $this, $o ) if $callback;\n\n  if($callback_status) {\n    # Keep recursing unless callback returned false... and if there's\n    # anything to recurse into, of course.\n    my @daughters = UNIVERSAL::can($this, 'is_node') ? @{$this->{'daughters'}} : ();\n    if(@daughters) {\n      $o->{'_depth'} += 1;\n      #print \"Depth \" , $o->{'_depth'}, \"\\n\";\n      foreach my $one (@daughters) {\n        $one->walk_down($o) if UNIVERSAL::can($one, 'is_node');\n        # and if it can do \"is_node\", it should provide a walk_down!\n      }\n      $o->{'_depth'} -= 1;\n    }\n  } else {\n    printf \"* Recursing below %s pruned\\n\", ($this->name || $this) if $Debug;\n  }\n\n  # Note that $callback_status doesn't block callbackback from being called\n  if($callbackback){\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      print \"* Calling callbackback\\n\" if $Debug;\n      scalar( &{ $callbackback }( $this, $o ) );\n      # scalar to give it the same context as callback\n    } else {\n      print \"* Can't call callbackback -- $this isn't a node anymore\\n\"\n        if $Debug;\n    }\n  }\n  if($Debug) {\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      printf \"* Leaving %s\\n\", ($this->name || $this)\n    } else {\n      print \"* Leaving [no longer a node]\\n\";\n    }\n  }\n  return;\n}\n\n###########################################################################\n\n* @lines = $node->dump_names({ ...options... });\n\nDumps, as an indented list, the names of the nodes starting at $node,\nand continuing under it.  Options are:\n\n* _depth -- A nonnegative number.  Indicating the depth to consider\n$node as being at (and so the generation under that is that plus one,\netc.).  Defaults to 0.  You may choose to use set _depth =>\nscalar($node->ancestors).\n\n* tick -- a string to preface each entry with, between the\nindenting-spacing and the node's name.  Defaults to empty-string.  You\nmay prefer \"*\" or \"-> \" or someting.\n\n* indent -- the string used to indent with.  Defaults to \"  \" (two\nspaces).  Another sane value might be \". \" (period, space).  Setting it\nto empty-string suppresses indenting.\n\nThe dump is not printed, but is returned as a list, where each\nitem is a line, with a \"\\n\" at the end.\n\n\nsub dump_names {\n  my($it, $o) = @_[0,1];\n  $o = {} unless ref $o;\n  my @out = ();\n  $o->{'_depth'} ||= 0;\n  $o->{'indent'} ||= '  ';\n  $o->{'tick'} ||= '';\n\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      push(@out,\n        join('',\n             $o->{'indent'} x $o->{'_depth'},\n             $o->{'tick'},\n             &Tree::DAG_Node::_dump_quote($this->name || $this),\n             \"\\n\"\n        )\n      );      \n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  return @out;\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor CLASS->random_network({...options...})\n\n* the method $node->random_network({...options...})\n\nIn the first case, constructs a randomly arranged network under a new\nnode, and returns the root node of that tree.  In the latter case,\nconstructs the network under $node.\n\nCurrently, this is implemented a bit half-heartedly, and\nhalf-wittedly.  I basically needed to make up random-looking networks\nto stress-test the various tree-dumper methods, and so wrote this.  If\nyou actually want to rely on this for any application more\nserious than that, I suggest examining the source code and seeing if\nthis does really what you need (say, in reliability of randomness);\nand feel totally free to suggest changes to me (especially in the form\nof \"I rewrote C<random_network>, here's the code...\")\n\nIt takes four options:\n\n* max_node_count -- maximum number of nodes this tree will be allowed\nto have (counting the root).  Defaults to 25.\n\n* min_depth -- minimum depth for the tree.  Defaults to 2.  Leaves can\nbe generated only after this depth is reached, so the tree will be at\nleast this deep -- unless max_node_count is hit first.\n\n* max_depth -- maximum depth for the tree.  Defaults to 3 plus\nmin_depth.  The tree will not be deeper than this.\n\n* max_children -- maximum number of children any mother in the tree\ncan have.  Defaults to 4.\n\n\nsub random_network { # constructor or method.\n  my $class = $_[0];\n  my $o = ref($_[1]) ? $_[1] : {};\n  my $am_cons = 0;\n  my $root;\n\n  if(ref($class)){ # I'm a method.\n    $root = $_[0]; # build under the given node, from same class.\n    $class = ref $class;\n    $am_cons = 0;\n  } else { # I'm a constructor\n    $root = $class->new; # build under a new node, with class named.\n    $root->name(\"Root\");\n    $am_cons = 1;\n  }\n\n  my $min_depth = $o->{'min_depth'} || 2;\n  my $max_depth = $o->{'max_depth'} || ($min_depth + 3);\n  my $max_children = $o->{'max_children'} || 4;\n  my $max_node_count = $o->{'max_node_count'} || 25;\n\n  Carp::croak \"max_children has to be positive\" if int($max_children) < 1;\n\n  my @mothers = ( $root );\n  my @children = ( );\n  my $node_count = 1; # the root\n\n Gen:\n  foreach my $depth (1 .. $max_depth) {\n    last if $node_count > $max_node_count;\n   Mother:\n    foreach my $mother (@mothers) {\n      last Gen if $node_count > $max_node_count;\n      my $children_number;    \n      if($depth <= $min_depth) {\n        until( $children_number = int(rand(1 + $max_children)) ) {}\n      } else {\n        $children_number = int(rand($max_children));\n      }\n     Beget:\n      foreach (1 .. $children_number) {\n        last Gen if $node_count > $max_node_count;\n        my $node = $mother->new_daughter;\n        $node->name(\"Node$node_count\");\n        ++$node_count;\n        push(@children, $node);\n      }\n    }\n    @mothers = @children;\n    @children = ();\n    last unless @mothers;\n  }\n\n  return $root;\n}\n\n* the constructor CLASS->lol_to_tree($lol);\n\nConverts something like bracket-notation for \"Chomsky trees\" (or\nrather, the closest you can come with Perl\nlist-of-lists(-of-lists(-of-lists))) into a tree structure.  Returns\nthe root of the tree converted.\n\nThe conversion rules are that:  1) if the last (possibly the only) item\nin a given list is a scalar, then that is used as the \"name\" attribute\nfor the node based on this list.  2) All other items in the list\nrepresent daughter nodes of the current node -- recursively so, if\nthey are list references; otherwise, (non-terminal) scalars are\nconsidered to denote nodes with that name.  So ['Foo', 'Bar', 'N'] is\nan alternate way to represent [['Foo'], ['Bar'], 'N'].\n\nAn example will illustrate:\n\n  use Tree::DAG_Node;\n  $lol =\n    [\n      [\n        [ [ 'Det:The' ],\n          [ [ 'dog' ], 'N'], 'NP'],\n        [ '/with rabies\\\\', 'PP'],\n        'NP'\n      ],\n      [ 'died', 'VP'],\n      'S'\n    ];\n   $tree = Tree::DAG_Node->lol_to_tree($lol);\n   $diagram = $tree->draw_ascii_tree;\n   print map \"$_\\n\", @$diagram;\n\n...returns this tree:\n\n                   |                   \n                  <S>                  \n                   |                   \n                /------------------\\   \n                |                  |   \n              <NP>                <VP> \n                |                  |   \n        /---------------\\        <died>\n        |               |              \n      <NP>            <PP>             \n        |               |              \n     /-------\\   </with rabies\\>       \n     |       |                         \n <Det:The>  <N>                        \n             |                         \n           <dog>                       \n\nBy the way (and this rather follows from the above rules), when\ndenoting a LoL tree consisting of just one node, this:\n\n  $tree = Tree::DAG_Node->lol_to_tree( 'Lonely' );\n\nis okay, although it'd probably occur to you to denote it only as:\n\n  $tree = Tree::DAG_Node->lol_to_tree( ['Lonely'] );\n\nwhich is of course fine, too.\n\n\nsub lol_to_tree {\n  my($class, $lol, $seen_r) = @_[0,1,2];\n  $seen_r = {} unless ref($seen_r) eq 'HASH';\n  return if ref($lol) && $seen_r->{$lol}++; # catch circularity\n\n  $class = ref($class) || $class;\n  my $node = $class->new();\n\n  unless(ref($lol) eq 'ARRAY') {  # It's a terminal node.\n    $node->name($lol) if defined $lol;\n    return $node;\n  }\n  return $node unless @$lol;  # It's a terminal node, oddly represented\n\n  #  It's a non-terminal node.\n\n  my @options = @$lol; \n  unless(ref($options[-1]) eq 'ARRAY') {\n    # This is what separates this method from simple_lol_to_tree\n    $node->name(pop(@options));\n  }\n\n  foreach my $d (@options) {  # Scan daughters (whether scalars or listrefs)\n    $node->add_daughter( $class->lol_to_tree($d, $seen_r) );  # recurse!\n  }\n\n  return $node;\n}\n\n#--------------------------------------------------------------------------\n\n* $node->tree_to_lol_notation({...options...})\n\nDumps a tree (starting at $node) as the sort of LoL-like bracket\nnotation you see in the above example code.  Returns just one big\nblock of text.  The only option is \"multiline\" -- if true, it dumps\nthe text as the sort of indented structure as seen above; if false\n(and it defaults to false), dumps it all on one line (with no\nindenting, of course).\n\nFor example, starting with the tree from the above example,\nthis:\n\n  print $tree->tree_to_lol_notation, \"\\n\";\n\nprints the following (which I've broken over two lines for sake of\nprintablitity of documentation):\n\n  [[[['Det:The'], [['dog'], 'N'], 'NP'], [[\"/with rabies\\x5c\"],\n  'PP'], 'NP'], [['died'], 'VP'], 'S'], \n\nDoing this:\n\n  print $tree->tree_to_lol_notation({ multiline => 1 });\n\nprints the same content, just spread over many lines, and prettily\nindented.","parameters":[{"label":"$it"},{"label":"$o"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":2098,"character":9999},"start":{"character":0,"line":2053}},"name":"tree_to_lol_notation"},{"kind":12,"line":2085,"name":"Tree","containerName":"DAG_Node::_dump_quote"},{"line":2115,"children":[{"containerName":"tree_to_lol","name":"$it","definition":"my","localvar":"my","kind":13,"line":2117},{"name":"$o","containerName":"tree_to_lol","kind":13,"line":2117},{"name":"$o","containerName":"tree_to_lol","line":2118,"kind":13},{"containerName":"tree_to_lol","name":"$o","line":2118,"kind":13},{"kind":13,"line":2120,"definition":"my","name":"$out","containerName":"tree_to_lol","localvar":"my"},{"line":2121,"kind":13,"localvar":"my","definition":"my","name":"@lol_stack","containerName":"tree_to_lol"},{"line":2121,"kind":13,"containerName":"tree_to_lol","name":"$out"},{"name":"$o","containerName":"tree_to_lol","line":2122,"kind":13},{"line":2123,"kind":13,"localvar":"my","name":"$this","definition":"my","containerName":"tree_to_lol"},{"name":"$o","containerName":"tree_to_lol","line":2123,"kind":13},{"line":2124,"kind":13,"localvar":"my","containerName":"tree_to_lol","name":"$new","definition":"my"},{"line":2125,"kind":13,"name":"$lol_stack","containerName":"tree_to_lol"},{"line":2125,"kind":13,"containerName":"tree_to_lol","name":"$new"},{"containerName":"tree_to_lol","name":"@lol_stack","kind":13,"line":2126},{"name":"$new","containerName":"tree_to_lol","kind":13,"line":2126}],"kind":12,"detail":"($it,$o)","signature":{"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)\n\n\nsub address {\n  my($it, $address) = @_[0,1];\n  if(defined($address) && length($address)) { # given the address, return the node.\n    # invalid addresses return undef\n    my $root = $it->root;\n    my @parts = map {$_ + 0}\n                    $address =~ m/(\\d+)/g; # generous!\n    Carp::croak \"Address \\\"$address\\\" is an ill-formed address\" unless @parts;\n    Carp::croak \"Address \\\"$address\\\" must start with '0'\" unless shift(@parts) == 0;\n\n    my $current_node = $root;\n    while(@parts) { # no-op for root\n      my $ord = shift @parts;\n      my @daughters = @{$current_node->{'daughters'}};\n\n      if($#daughters < $ord) { # illegal address\n        print \"* $address has an out-of-range index ($ord)!\" if $Debug;\n        return undef;\n      }\n      $current_node = $daughters[$ord];\n      unless(ref($current_node)) {\n        print \"* $address points to or thru a non-node!\" if $Debug;\n        return undef;\n      }\n    }\n    return $current_node;\n\n  } else { # given the node, return the address\n    my @parts = ();\n    my $current_node = $it;\n    my $mother;\n\n    while(defined( $mother = $current_node->{'mother'} ) && ref($mother)) {\n      unshift @parts, $current_node->my_daughter_index;\n      $current_node = $mother;\n    }\n    return join(':', 0, @parts);\n  }\n}\n\n###########################################################################\n\n* $node->common(LIST)\n\nReturns the lowest node in the tree that is ancestor-or-self to the\nnodes $node and LIST.\n\nIf the nodes are far enough apart in the tree, the answer is just the\nroot.\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node.\n\n\nsub common { # Return the lowest node common to all these nodes...\n  # Called as $it->common($other) or $it->common(@others)\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first unless @others; # degenerate case\n\n  my %ones;\n  @ones{ @ones } = undef;\n\n  foreach my $node (@others) {\n    Carp::croak \"TILT: node \\\"$node\\\" is not a node\"\n      unless UNIVERSAL::can($node, 'is_node');\n    my %first_lineage;\n    @first_lineage{$first, $first->ancestors} = undef;\n    my $higher = undef; # the common of $first and $node\n    my @my_lineage = $node->ancestors;\n\n   Find_Common:\n    while(@my_lineage) {\n      if(exists $first_lineage{$my_lineage[0]}) {\n        $higher = $my_lineage[0];\n        last Find_Common;\n      }\n      shift @my_lineage;\n    }\n    return undef unless $higher;\n    $first = $higher;\n  } \n  return $first;\n}\n\n\n###########################################################################\n\n* $node->common_ancestor(LIST)\n\nReturns the lowest node that is ancestor to all the nodes given (in\nnodes $node and LIST).  In other words, it answers the question: \"What\nnode in the tree, as low as possible, is ancestor to the nodes given\n($node and LIST)?\"\n\nIf the nodes are far enough apart, the answer is just the root --\nexcept if any of the nodes are the root itself, in which case the\nanswer is undef (since the root has no ancestor).\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node's mother;\nthat'll be undef if $node is root.\n\n\nsub common_ancestor {\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first->{'mother'} unless @others;\n    # which may be undef if $first is the root!\n\n  my %ones;\n  @ones{ @ones } = undef; # my arguments\n\n  my $common = $first->common(@others);\n  if(exists($ones{$common})) { # if the common is one of my nodes...\n    return $common->{'mother'};\n    # and this might be undef, if $common is root!\n  } else {\n    return $common;\n    # which might be null if that's all common came up with\n  }\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 YET MORE METHODS\n\n\n* $node->walk_down({ callback => \\&foo, callbackback => \\&foo, ... })\n\nPerforms a depth-first traversal of the structure at and under $node.\nWhat it does at each node depends on the value of the options hashref,\nwhich you must provide.  There are three options, \"callback\" and\n\"callbackback\" (at least one of which must be defined, as a sub\nreference), and \"_depth\".  This is what C<walk_down> does, in\npseudocode form:\n\n* Start at the $node given.\n\n* If there's a C<callback>, call it with $node as the first argument,\nand the options hashref as the second argument (which contains the\npotentially useful C<_depth>, remember).  This function must return\ntrue or false -- if false, it will block the next step:\n\n* If $node has any daughter nodes, increment C<_depth>, and call\n$daughter->walk_down(options_hashref) for each daughter (in order, of\ncourse), where options_hashref is the same hashref it was called with.\nWhen this returns, decrements C<_depth>.\n\n* If there's a C<callbackback>, call just it as with C<callback> (but\ntossing out the return value).  Note that C<callback> returning false\nblocks traversal below $node, but doesn't block calling callbackback\nfor $node.  (Incidentally, in the unlikely case that $node has stopped\nbeing a node object, C<callbackback> won't get called.)\n\n* Return.\n\n$node->walk_down is the way to recursively do things to a tree (if you\nstart at the root) or part of a tree; if what you're doing is best done\nvia pre-pre order traversal, use C<callback>; if what you're doing is\nbest done with post-order traversal, use C<callbackback>.\nC<walk_down> is even the basis for plenty of the methods in this\nclass.  See the source code for examples both simple and horrific.\n\nNote that if you don't specify C<_depth>, it effectively defaults to\n0.  You should set it to scalar($node->ancestors) if you want\nC<_depth> to reflect the true depth-in-the-tree for the nodes called,\ninstead of just the depth below $node.  (If $node is the root, there's\ndifference, of course.)\n\nAnd B<by the way>, it's a bad idea to modify the tree from the callback.\nUnpredictable things may happen.  I instead suggest having your callback\nadd to a stack of things that need changing, and then, once C<walk_down>\nis all finished, changing those nodes from that stack.\n\nNote that the existence of C<walk_down> doesn't mean you can't write\nyou own special-use traversers.\n\n\nsub walk_down {\n  my($this, $o) = @_[0,1];\n\n  # All the can()s are in case an object changes class while I'm\n  # looking at it.\n\n  Carp::croak \"I need options!\" unless ref($o);\n  Carp::croak \"I need a callback or a callbackback\" unless\n    ( ref($o->{'callback'}) || ref($o->{'callbackback'}) );\n\n  # $this->no_cyclicity;\n  my $callback = ref($o->{'callback'}) ? $o->{'callback'} : undef;\n  my $callbackback = ref($o->{'callbackback'}) ? $o->{'callbackback'} : undef;\n  my $callback_status = 1;\n\n  print \"Callback: $callback   Callbackback: $callbackback\\n\" if $Debug;\n\n  printf \"* Entering %s\\n\", ($this->name || $this) if $Debug;\n  $callback_status = &{ $callback }( $this, $o ) if $callback;\n\n  if($callback_status) {\n    # Keep recursing unless callback returned false... and if there's\n    # anything to recurse into, of course.\n    my @daughters = UNIVERSAL::can($this, 'is_node') ? @{$this->{'daughters'}} : ();\n    if(@daughters) {\n      $o->{'_depth'} += 1;\n      #print \"Depth \" , $o->{'_depth'}, \"\\n\";\n      foreach my $one (@daughters) {\n        $one->walk_down($o) if UNIVERSAL::can($one, 'is_node');\n        # and if it can do \"is_node\", it should provide a walk_down!\n      }\n      $o->{'_depth'} -= 1;\n    }\n  } else {\n    printf \"* Recursing below %s pruned\\n\", ($this->name || $this) if $Debug;\n  }\n\n  # Note that $callback_status doesn't block callbackback from being called\n  if($callbackback){\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      print \"* Calling callbackback\\n\" if $Debug;\n      scalar( &{ $callbackback }( $this, $o ) );\n      # scalar to give it the same context as callback\n    } else {\n      print \"* Can't call callbackback -- $this isn't a node anymore\\n\"\n        if $Debug;\n    }\n  }\n  if($Debug) {\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      printf \"* Leaving %s\\n\", ($this->name || $this)\n    } else {\n      print \"* Leaving [no longer a node]\\n\";\n    }\n  }\n  return;\n}\n\n###########################################################################\n\n* @lines = $node->dump_names({ ...options... });\n\nDumps, as an indented list, the names of the nodes starting at $node,\nand continuing under it.  Options are:\n\n* _depth -- A nonnegative number.  Indicating the depth to consider\n$node as being at (and so the generation under that is that plus one,\netc.).  Defaults to 0.  You may choose to use set _depth =>\nscalar($node->ancestors).\n\n* tick -- a string to preface each entry with, between the\nindenting-spacing and the node's name.  Defaults to empty-string.  You\nmay prefer \"*\" or \"-> \" or someting.\n\n* indent -- the string used to indent with.  Defaults to \"  \" (two\nspaces).  Another sane value might be \". \" (period, space).  Setting it\nto empty-string suppresses indenting.\n\nThe dump is not printed, but is returned as a list, where each\nitem is a line, with a \"\\n\" at the end.\n\n\nsub dump_names {\n  my($it, $o) = @_[0,1];\n  $o = {} unless ref $o;\n  my @out = ();\n  $o->{'_depth'} ||= 0;\n  $o->{'indent'} ||= '  ';\n  $o->{'tick'} ||= '';\n\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      push(@out,\n        join('',\n             $o->{'indent'} x $o->{'_depth'},\n             $o->{'tick'},\n             &Tree::DAG_Node::_dump_quote($this->name || $this),\n             \"\\n\"\n        )\n      );      \n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  return @out;\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor CLASS->random_network({...options...})\n\n* the method $node->random_network({...options...})\n\nIn the first case, constructs a randomly arranged network under a new\nnode, and returns the root node of that tree.  In the latter case,\nconstructs the network under $node.\n\nCurrently, this is implemented a bit half-heartedly, and\nhalf-wittedly.  I basically needed to make up random-looking networks\nto stress-test the various tree-dumper methods, and so wrote this.  If\nyou actually want to rely on this for any application more\nserious than that, I suggest examining the source code and seeing if\nthis does really what you need (say, in reliability of randomness);\nand feel totally free to suggest changes to me (especially in the form\nof \"I rewrote C<random_network>, here's the code...\")\n\nIt takes four options:\n\n* max_node_count -- maximum number of nodes this tree will be allowed\nto have (counting the root).  Defaults to 25.\n\n* min_depth -- minimum depth for the tree.  Defaults to 2.  Leaves can\nbe generated only after this depth is reached, so the tree will be at\nleast this deep -- unless max_node_count is hit first.\n\n* max_depth -- maximum depth for the tree.  Defaults to 3 plus\nmin_depth.  The tree will not be deeper than this.\n\n* max_children -- maximum number of children any mother in the tree\ncan have.  Defaults to 4.\n\n\nsub random_network { # constructor or method.\n  my $class = $_[0];\n  my $o = ref($_[1]) ? $_[1] : {};\n  my $am_cons = 0;\n  my $root;\n\n  if(ref($class)){ # I'm a method.\n    $root = $_[0]; # build under the given node, from same class.\n    $class = ref $class;\n    $am_cons = 0;\n  } else { # I'm a constructor\n    $root = $class->new; # build under a new node, with class named.\n    $root->name(\"Root\");\n    $am_cons = 1;\n  }\n\n  my $min_depth = $o->{'min_depth'} || 2;\n  my $max_depth = $o->{'max_depth'} || ($min_depth + 3);\n  my $max_children = $o->{'max_children'} || 4;\n  my $max_node_count = $o->{'max_node_count'} || 25;\n\n  Carp::croak \"max_children has to be positive\" if int($max_children) < 1;\n\n  my @mothers = ( $root );\n  my @children = ( );\n  my $node_count = 1; # the root\n\n Gen:\n  foreach my $depth (1 .. $max_depth) {\n    last if $node_count > $max_node_count;\n   Mother:\n    foreach my $mother (@mothers) {\n      last Gen if $node_count > $max_node_count;\n      my $children_number;    \n      if($depth <= $min_depth) {\n        until( $children_number = int(rand(1 + $max_children)) ) {}\n      } else {\n        $children_number = int(rand($max_children));\n      }\n     Beget:\n      foreach (1 .. $children_number) {\n        last Gen if $node_count > $max_node_count;\n        my $node = $mother->new_daughter;\n        $node->name(\"Node$node_count\");\n        ++$node_count;\n        push(@children, $node);\n      }\n    }\n    @mothers = @children;\n    @children = ();\n    last unless @mothers;\n  }\n\n  return $root;\n}\n\n* the constructor CLASS->lol_to_tree($lol);\n\nConverts something like bracket-notation for \"Chomsky trees\" (or\nrather, the closest you can come with Perl\nlist-of-lists(-of-lists(-of-lists))) into a tree structure.  Returns\nthe root of the tree converted.\n\nThe conversion rules are that:  1) if the last (possibly the only) item\nin a given list is a scalar, then that is used as the \"name\" attribute\nfor the node based on this list.  2) All other items in the list\nrepresent daughter nodes of the current node -- recursively so, if\nthey are list references; otherwise, (non-terminal) scalars are\nconsidered to denote nodes with that name.  So ['Foo', 'Bar', 'N'] is\nan alternate way to represent [['Foo'], ['Bar'], 'N'].\n\nAn example will illustrate:\n\n  use Tree::DAG_Node;\n  $lol =\n    [\n      [\n        [ [ 'Det:The' ],\n          [ [ 'dog' ], 'N'], 'NP'],\n        [ '/with rabies\\\\', 'PP'],\n        'NP'\n      ],\n      [ 'died', 'VP'],\n      'S'\n    ];\n   $tree = Tree::DAG_Node->lol_to_tree($lol);\n   $diagram = $tree->draw_ascii_tree;\n   print map \"$_\\n\", @$diagram;\n\n...returns this tree:\n\n                   |                   \n                  <S>                  \n                   |                   \n                /------------------\\   \n                |                  |   \n              <NP>                <VP> \n                |                  |   \n        /---------------\\        <died>\n        |               |              \n      <NP>            <PP>             \n        |               |              \n     /-------\\   </with rabies\\>       \n     |       |                         \n <Det:The>  <N>                        \n             |                         \n           <dog>                       \n\nBy the way (and this rather follows from the above rules), when\ndenoting a LoL tree consisting of just one node, this:\n\n  $tree = Tree::DAG_Node->lol_to_tree( 'Lonely' );\n\nis okay, although it'd probably occur to you to denote it only as:\n\n  $tree = Tree::DAG_Node->lol_to_tree( ['Lonely'] );\n\nwhich is of course fine, too.\n\n\nsub lol_to_tree {\n  my($class, $lol, $seen_r) = @_[0,1,2];\n  $seen_r = {} unless ref($seen_r) eq 'HASH';\n  return if ref($lol) && $seen_r->{$lol}++; # catch circularity\n\n  $class = ref($class) || $class;\n  my $node = $class->new();\n\n  unless(ref($lol) eq 'ARRAY') {  # It's a terminal node.\n    $node->name($lol) if defined $lol;\n    return $node;\n  }\n  return $node unless @$lol;  # It's a terminal node, oddly represented\n\n  #  It's a non-terminal node.\n\n  my @options = @$lol; \n  unless(ref($options[-1]) eq 'ARRAY') {\n    # This is what separates this method from simple_lol_to_tree\n    $node->name(pop(@options));\n  }\n\n  foreach my $d (@options) {  # Scan daughters (whether scalars or listrefs)\n    $node->add_daughter( $class->lol_to_tree($d, $seen_r) );  # recurse!\n  }\n\n  return $node;\n}\n\n#--------------------------------------------------------------------------\n\n* $node->tree_to_lol_notation({...options...})\n\nDumps a tree (starting at $node) as the sort of LoL-like bracket\nnotation you see in the above example code.  Returns just one big\nblock of text.  The only option is \"multiline\" -- if true, it dumps\nthe text as the sort of indented structure as seen above; if false\n(and it defaults to false), dumps it all on one line (with no\nindenting, of course).\n\nFor example, starting with the tree from the above example,\nthis:\n\n  print $tree->tree_to_lol_notation, \"\\n\";\n\nprints the following (which I've broken over two lines for sake of\nprintablitity of documentation):\n\n  [[[['Det:The'], [['dog'], 'N'], 'NP'], [[\"/with rabies\\x5c\"],\n  'PP'], 'NP'], [['died'], 'VP'], 'S'], \n\nDoing this:\n\n  print $tree->tree_to_lol_notation({ multiline => 1 });\n\nprints the same content, just spread over many lines, and prettily\nindented.\n\n\n#--------------------------------------------------------------------------\n\nsub tree_to_lol_notation {\n  my $root = $_[0];\n  my($it, $o) = @_[0,1];\n  $o = {} unless ref $o;\n  my @out = ();\n  $o->{'_depth'} ||= 0;\n  $o->{'multiline'} = 0 unless exists($o->{'multiline'});\n\n  my $line_end;\n  if($o->{'multiline'}) {\n    $o->{'indent'} ||= '  ';\n    $line_end = \"\\n\";\n  } else {\n    $o->{'indent'} ||= '';\n    $line_end = '';\n  }\n\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      push(@out,\n             $o->{'indent'} x $o->{'_depth'},\n             \"[$line_end\",\n      );      \n      return 1;\n    }\n  ;\n  $o->{'callbackback'} = sub {\n      my($this, $o) = @_[0,1];\n      my $name = $this->name;\n      if(!defined($name)) {\n        $name = 'undef';\n      } else {\n        $name = &Tree::DAG_Node::_dump_quote($name);\n      }\n      push(@out,\n             $o->{'indent'} x ($o->{'_depth'} + 1),\n             \"$name$line_end\",\n             $o->{'indent'} x $o->{'_depth'},\n             \"], $line_end\",\n      );\n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  return join('', @out);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->tree_to_lol\n\nReturns that tree (starting at $node) represented as a LoL, like what\n$lol, above, holds.  (This is as opposed to C<tree_to_lol_notation>,\nwhich returns the viewable code like what gets evaluated and stored in\n$lol, above.)\n\nLord only knows what you use this for -- maybe for feeding to\nData::Dumper, in case C<tree_to_lol_notation> doesn't do just what you\nwant?","parameters":[{"label":"$it"},{"label":"$o"}],"label":"tree_to_lol($it,$o)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":2128},"start":{"character":0,"line":2115}},"name":"tree_to_lol"},{"containerName":null,"name":"%o","kind":13,"line":2130},{"kind":13,"line":2131,"definition":"my","name":"$this","containerName":null,"localvar":"my"},{"containerName":null,"name":"@o","kind":13,"line":2131},{"containerName":null,"name":"@lol_stack","line":2132,"kind":13},{"line":2132,"kind":13,"containerName":null,"name":"$this"},{"kind":12,"line":2132,"name":"name","containerName":"main::"},{"containerName":null,"name":"@lol_stack","line":2133,"kind":13},{"kind":13,"line":2137,"containerName":null,"name":"$it"},{"name":"walk_down","containerName":"main::","kind":12,"line":2137},{"containerName":null,"name":"$o","line":2137,"kind":13},{"name":"@out","containerName":null,"line":2138,"kind":13},{"line":2139,"kind":13,"containerName":null,"name":"$out"},{"line":2139,"kind":13,"name":"@out","containerName":null},{"kind":13,"line":2140,"name":"$out","containerName":null},{"range":{"start":{"line":2171,"character":0},"end":{"line":2190,"character":9999}},"name":"simple_lol_to_tree","line":2171,"children":[{"kind":13,"line":2172,"definition":"my","name":"$class","containerName":"simple_lol_to_tree","localvar":"my"},{"name":"$lol","containerName":"simple_lol_to_tree","line":2172,"kind":13},{"line":2172,"kind":13,"containerName":"simple_lol_to_tree","name":"$seen_r"},{"line":2173,"kind":13,"name":"$class","containerName":"simple_lol_to_tree"},{"containerName":"simple_lol_to_tree","name":"$class","kind":13,"line":2173},{"name":"$class","containerName":"simple_lol_to_tree","line":2173,"kind":13},{"kind":13,"line":2174,"containerName":"simple_lol_to_tree","name":"$seen_r"},{"name":"$seen_r","containerName":"simple_lol_to_tree","kind":13,"line":2174},{"line":2175,"kind":13,"name":"$lol","containerName":"simple_lol_to_tree"},{"name":"$seen_r","containerName":"simple_lol_to_tree","kind":13,"line":2175},{"kind":13,"line":2175,"containerName":"simple_lol_to_tree","name":"$lol"},{"line":2177,"kind":13,"localvar":"my","name":"$node","definition":"my","containerName":"simple_lol_to_tree"},{"line":2177,"kind":13,"containerName":"simple_lol_to_tree","name":"$class"},{"name":"new","containerName":"simple_lol_to_tree","line":2177,"kind":12},{"containerName":"simple_lol_to_tree","name":"$lol","line":2179,"kind":13},{"containerName":"simple_lol_to_tree","name":"$node","line":2180,"kind":13},{"containerName":"simple_lol_to_tree","name":"name","line":2180,"kind":12},{"containerName":"simple_lol_to_tree","name":"$lol","kind":13,"line":2180},{"line":2180,"kind":13,"containerName":"simple_lol_to_tree","name":"$lol"},{"line":2181,"kind":13,"containerName":"simple_lol_to_tree","name":"$node"},{"kind":13,"line":2185,"name":"$d","definition":"my","containerName":"simple_lol_to_tree","localvar":"my"},{"line":2185,"kind":13,"containerName":"simple_lol_to_tree","name":"$lol"},{"containerName":"simple_lol_to_tree","name":"$node","kind":13,"line":2186},{"name":"add_daughter","containerName":"simple_lol_to_tree","line":2186,"kind":12},{"line":2186,"kind":13,"name":"$class","containerName":"simple_lol_to_tree"},{"containerName":"simple_lol_to_tree","name":"simple_lol_to_tree","line":2186,"kind":12},{"name":"$d","containerName":"simple_lol_to_tree","kind":13,"line":2186},{"line":2186,"kind":13,"name":"$seen_r","containerName":"simple_lol_to_tree"},{"containerName":"simple_lol_to_tree","name":"$node","kind":13,"line":2189}],"kind":12,"detail":"($class,$lol,$seen_r)","signature":{"label":"simple_lol_to_tree($class,$lol,$seen_r)","documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)\n\n\nsub address {\n  my($it, $address) = @_[0,1];\n  if(defined($address) && length($address)) { # given the address, return the node.\n    # invalid addresses return undef\n    my $root = $it->root;\n    my @parts = map {$_ + 0}\n                    $address =~ m/(\\d+)/g; # generous!\n    Carp::croak \"Address \\\"$address\\\" is an ill-formed address\" unless @parts;\n    Carp::croak \"Address \\\"$address\\\" must start with '0'\" unless shift(@parts) == 0;\n\n    my $current_node = $root;\n    while(@parts) { # no-op for root\n      my $ord = shift @parts;\n      my @daughters = @{$current_node->{'daughters'}};\n\n      if($#daughters < $ord) { # illegal address\n        print \"* $address has an out-of-range index ($ord)!\" if $Debug;\n        return undef;\n      }\n      $current_node = $daughters[$ord];\n      unless(ref($current_node)) {\n        print \"* $address points to or thru a non-node!\" if $Debug;\n        return undef;\n      }\n    }\n    return $current_node;\n\n  } else { # given the node, return the address\n    my @parts = ();\n    my $current_node = $it;\n    my $mother;\n\n    while(defined( $mother = $current_node->{'mother'} ) && ref($mother)) {\n      unshift @parts, $current_node->my_daughter_index;\n      $current_node = $mother;\n    }\n    return join(':', 0, @parts);\n  }\n}\n\n###########################################################################\n\n* $node->common(LIST)\n\nReturns the lowest node in the tree that is ancestor-or-self to the\nnodes $node and LIST.\n\nIf the nodes are far enough apart in the tree, the answer is just the\nroot.\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node.\n\n\nsub common { # Return the lowest node common to all these nodes...\n  # Called as $it->common($other) or $it->common(@others)\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first unless @others; # degenerate case\n\n  my %ones;\n  @ones{ @ones } = undef;\n\n  foreach my $node (@others) {\n    Carp::croak \"TILT: node \\\"$node\\\" is not a node\"\n      unless UNIVERSAL::can($node, 'is_node');\n    my %first_lineage;\n    @first_lineage{$first, $first->ancestors} = undef;\n    my $higher = undef; # the common of $first and $node\n    my @my_lineage = $node->ancestors;\n\n   Find_Common:\n    while(@my_lineage) {\n      if(exists $first_lineage{$my_lineage[0]}) {\n        $higher = $my_lineage[0];\n        last Find_Common;\n      }\n      shift @my_lineage;\n    }\n    return undef unless $higher;\n    $first = $higher;\n  } \n  return $first;\n}\n\n\n###########################################################################\n\n* $node->common_ancestor(LIST)\n\nReturns the lowest node that is ancestor to all the nodes given (in\nnodes $node and LIST).  In other words, it answers the question: \"What\nnode in the tree, as low as possible, is ancestor to the nodes given\n($node and LIST)?\"\n\nIf the nodes are far enough apart, the answer is just the root --\nexcept if any of the nodes are the root itself, in which case the\nanswer is undef (since the root has no ancestor).\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node's mother;\nthat'll be undef if $node is root.\n\n\nsub common_ancestor {\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first->{'mother'} unless @others;\n    # which may be undef if $first is the root!\n\n  my %ones;\n  @ones{ @ones } = undef; # my arguments\n\n  my $common = $first->common(@others);\n  if(exists($ones{$common})) { # if the common is one of my nodes...\n    return $common->{'mother'};\n    # and this might be undef, if $common is root!\n  } else {\n    return $common;\n    # which might be null if that's all common came up with\n  }\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 YET MORE METHODS\n\n\n* $node->walk_down({ callback => \\&foo, callbackback => \\&foo, ... })\n\nPerforms a depth-first traversal of the structure at and under $node.\nWhat it does at each node depends on the value of the options hashref,\nwhich you must provide.  There are three options, \"callback\" and\n\"callbackback\" (at least one of which must be defined, as a sub\nreference), and \"_depth\".  This is what C<walk_down> does, in\npseudocode form:\n\n* Start at the $node given.\n\n* If there's a C<callback>, call it with $node as the first argument,\nand the options hashref as the second argument (which contains the\npotentially useful C<_depth>, remember).  This function must return\ntrue or false -- if false, it will block the next step:\n\n* If $node has any daughter nodes, increment C<_depth>, and call\n$daughter->walk_down(options_hashref) for each daughter (in order, of\ncourse), where options_hashref is the same hashref it was called with.\nWhen this returns, decrements C<_depth>.\n\n* If there's a C<callbackback>, call just it as with C<callback> (but\ntossing out the return value).  Note that C<callback> returning false\nblocks traversal below $node, but doesn't block calling callbackback\nfor $node.  (Incidentally, in the unlikely case that $node has stopped\nbeing a node object, C<callbackback> won't get called.)\n\n* Return.\n\n$node->walk_down is the way to recursively do things to a tree (if you\nstart at the root) or part of a tree; if what you're doing is best done\nvia pre-pre order traversal, use C<callback>; if what you're doing is\nbest done with post-order traversal, use C<callbackback>.\nC<walk_down> is even the basis for plenty of the methods in this\nclass.  See the source code for examples both simple and horrific.\n\nNote that if you don't specify C<_depth>, it effectively defaults to\n0.  You should set it to scalar($node->ancestors) if you want\nC<_depth> to reflect the true depth-in-the-tree for the nodes called,\ninstead of just the depth below $node.  (If $node is the root, there's\ndifference, of course.)\n\nAnd B<by the way>, it's a bad idea to modify the tree from the callback.\nUnpredictable things may happen.  I instead suggest having your callback\nadd to a stack of things that need changing, and then, once C<walk_down>\nis all finished, changing those nodes from that stack.\n\nNote that the existence of C<walk_down> doesn't mean you can't write\nyou own special-use traversers.\n\n\nsub walk_down {\n  my($this, $o) = @_[0,1];\n\n  # All the can()s are in case an object changes class while I'm\n  # looking at it.\n\n  Carp::croak \"I need options!\" unless ref($o);\n  Carp::croak \"I need a callback or a callbackback\" unless\n    ( ref($o->{'callback'}) || ref($o->{'callbackback'}) );\n\n  # $this->no_cyclicity;\n  my $callback = ref($o->{'callback'}) ? $o->{'callback'} : undef;\n  my $callbackback = ref($o->{'callbackback'}) ? $o->{'callbackback'} : undef;\n  my $callback_status = 1;\n\n  print \"Callback: $callback   Callbackback: $callbackback\\n\" if $Debug;\n\n  printf \"* Entering %s\\n\", ($this->name || $this) if $Debug;\n  $callback_status = &{ $callback }( $this, $o ) if $callback;\n\n  if($callback_status) {\n    # Keep recursing unless callback returned false... and if there's\n    # anything to recurse into, of course.\n    my @daughters = UNIVERSAL::can($this, 'is_node') ? @{$this->{'daughters'}} : ();\n    if(@daughters) {\n      $o->{'_depth'} += 1;\n      #print \"Depth \" , $o->{'_depth'}, \"\\n\";\n      foreach my $one (@daughters) {\n        $one->walk_down($o) if UNIVERSAL::can($one, 'is_node');\n        # and if it can do \"is_node\", it should provide a walk_down!\n      }\n      $o->{'_depth'} -= 1;\n    }\n  } else {\n    printf \"* Recursing below %s pruned\\n\", ($this->name || $this) if $Debug;\n  }\n\n  # Note that $callback_status doesn't block callbackback from being called\n  if($callbackback){\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      print \"* Calling callbackback\\n\" if $Debug;\n      scalar( &{ $callbackback }( $this, $o ) );\n      # scalar to give it the same context as callback\n    } else {\n      print \"* Can't call callbackback -- $this isn't a node anymore\\n\"\n        if $Debug;\n    }\n  }\n  if($Debug) {\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      printf \"* Leaving %s\\n\", ($this->name || $this)\n    } else {\n      print \"* Leaving [no longer a node]\\n\";\n    }\n  }\n  return;\n}\n\n###########################################################################\n\n* @lines = $node->dump_names({ ...options... });\n\nDumps, as an indented list, the names of the nodes starting at $node,\nand continuing under it.  Options are:\n\n* _depth -- A nonnegative number.  Indicating the depth to consider\n$node as being at (and so the generation under that is that plus one,\netc.).  Defaults to 0.  You may choose to use set _depth =>\nscalar($node->ancestors).\n\n* tick -- a string to preface each entry with, between the\nindenting-spacing and the node's name.  Defaults to empty-string.  You\nmay prefer \"*\" or \"-> \" or someting.\n\n* indent -- the string used to indent with.  Defaults to \"  \" (two\nspaces).  Another sane value might be \". \" (period, space).  Setting it\nto empty-string suppresses indenting.\n\nThe dump is not printed, but is returned as a list, where each\nitem is a line, with a \"\\n\" at the end.\n\n\nsub dump_names {\n  my($it, $o) = @_[0,1];\n  $o = {} unless ref $o;\n  my @out = ();\n  $o->{'_depth'} ||= 0;\n  $o->{'indent'} ||= '  ';\n  $o->{'tick'} ||= '';\n\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      push(@out,\n        join('',\n             $o->{'indent'} x $o->{'_depth'},\n             $o->{'tick'},\n             &Tree::DAG_Node::_dump_quote($this->name || $this),\n             \"\\n\"\n        )\n      );      \n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  return @out;\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor CLASS->random_network({...options...})\n\n* the method $node->random_network({...options...})\n\nIn the first case, constructs a randomly arranged network under a new\nnode, and returns the root node of that tree.  In the latter case,\nconstructs the network under $node.\n\nCurrently, this is implemented a bit half-heartedly, and\nhalf-wittedly.  I basically needed to make up random-looking networks\nto stress-test the various tree-dumper methods, and so wrote this.  If\nyou actually want to rely on this for any application more\nserious than that, I suggest examining the source code and seeing if\nthis does really what you need (say, in reliability of randomness);\nand feel totally free to suggest changes to me (especially in the form\nof \"I rewrote C<random_network>, here's the code...\")\n\nIt takes four options:\n\n* max_node_count -- maximum number of nodes this tree will be allowed\nto have (counting the root).  Defaults to 25.\n\n* min_depth -- minimum depth for the tree.  Defaults to 2.  Leaves can\nbe generated only after this depth is reached, so the tree will be at\nleast this deep -- unless max_node_count is hit first.\n\n* max_depth -- maximum depth for the tree.  Defaults to 3 plus\nmin_depth.  The tree will not be deeper than this.\n\n* max_children -- maximum number of children any mother in the tree\ncan have.  Defaults to 4.\n\n\nsub random_network { # constructor or method.\n  my $class = $_[0];\n  my $o = ref($_[1]) ? $_[1] : {};\n  my $am_cons = 0;\n  my $root;\n\n  if(ref($class)){ # I'm a method.\n    $root = $_[0]; # build under the given node, from same class.\n    $class = ref $class;\n    $am_cons = 0;\n  } else { # I'm a constructor\n    $root = $class->new; # build under a new node, with class named.\n    $root->name(\"Root\");\n    $am_cons = 1;\n  }\n\n  my $min_depth = $o->{'min_depth'} || 2;\n  my $max_depth = $o->{'max_depth'} || ($min_depth + 3);\n  my $max_children = $o->{'max_children'} || 4;\n  my $max_node_count = $o->{'max_node_count'} || 25;\n\n  Carp::croak \"max_children has to be positive\" if int($max_children) < 1;\n\n  my @mothers = ( $root );\n  my @children = ( );\n  my $node_count = 1; # the root\n\n Gen:\n  foreach my $depth (1 .. $max_depth) {\n    last if $node_count > $max_node_count;\n   Mother:\n    foreach my $mother (@mothers) {\n      last Gen if $node_count > $max_node_count;\n      my $children_number;    \n      if($depth <= $min_depth) {\n        until( $children_number = int(rand(1 + $max_children)) ) {}\n      } else {\n        $children_number = int(rand($max_children));\n      }\n     Beget:\n      foreach (1 .. $children_number) {\n        last Gen if $node_count > $max_node_count;\n        my $node = $mother->new_daughter;\n        $node->name(\"Node$node_count\");\n        ++$node_count;\n        push(@children, $node);\n      }\n    }\n    @mothers = @children;\n    @children = ();\n    last unless @mothers;\n  }\n\n  return $root;\n}\n\n* the constructor CLASS->lol_to_tree($lol);\n\nConverts something like bracket-notation for \"Chomsky trees\" (or\nrather, the closest you can come with Perl\nlist-of-lists(-of-lists(-of-lists))) into a tree structure.  Returns\nthe root of the tree converted.\n\nThe conversion rules are that:  1) if the last (possibly the only) item\nin a given list is a scalar, then that is used as the \"name\" attribute\nfor the node based on this list.  2) All other items in the list\nrepresent daughter nodes of the current node -- recursively so, if\nthey are list references; otherwise, (non-terminal) scalars are\nconsidered to denote nodes with that name.  So ['Foo', 'Bar', 'N'] is\nan alternate way to represent [['Foo'], ['Bar'], 'N'].\n\nAn example will illustrate:\n\n  use Tree::DAG_Node;\n  $lol =\n    [\n      [\n        [ [ 'Det:The' ],\n          [ [ 'dog' ], 'N'], 'NP'],\n        [ '/with rabies\\\\', 'PP'],\n        'NP'\n      ],\n      [ 'died', 'VP'],\n      'S'\n    ];\n   $tree = Tree::DAG_Node->lol_to_tree($lol);\n   $diagram = $tree->draw_ascii_tree;\n   print map \"$_\\n\", @$diagram;\n\n...returns this tree:\n\n                   |                   \n                  <S>                  \n                   |                   \n                /------------------\\   \n                |                  |   \n              <NP>                <VP> \n                |                  |   \n        /---------------\\        <died>\n        |               |              \n      <NP>            <PP>             \n        |               |              \n     /-------\\   </with rabies\\>       \n     |       |                         \n <Det:The>  <N>                        \n             |                         \n           <dog>                       \n\nBy the way (and this rather follows from the above rules), when\ndenoting a LoL tree consisting of just one node, this:\n\n  $tree = Tree::DAG_Node->lol_to_tree( 'Lonely' );\n\nis okay, although it'd probably occur to you to denote it only as:\n\n  $tree = Tree::DAG_Node->lol_to_tree( ['Lonely'] );\n\nwhich is of course fine, too.\n\n\nsub lol_to_tree {\n  my($class, $lol, $seen_r) = @_[0,1,2];\n  $seen_r = {} unless ref($seen_r) eq 'HASH';\n  return if ref($lol) && $seen_r->{$lol}++; # catch circularity\n\n  $class = ref($class) || $class;\n  my $node = $class->new();\n\n  unless(ref($lol) eq 'ARRAY') {  # It's a terminal node.\n    $node->name($lol) if defined $lol;\n    return $node;\n  }\n  return $node unless @$lol;  # It's a terminal node, oddly represented\n\n  #  It's a non-terminal node.\n\n  my @options = @$lol; \n  unless(ref($options[-1]) eq 'ARRAY') {\n    # This is what separates this method from simple_lol_to_tree\n    $node->name(pop(@options));\n  }\n\n  foreach my $d (@options) {  # Scan daughters (whether scalars or listrefs)\n    $node->add_daughter( $class->lol_to_tree($d, $seen_r) );  # recurse!\n  }\n\n  return $node;\n}\n\n#--------------------------------------------------------------------------\n\n* $node->tree_to_lol_notation({...options...})\n\nDumps a tree (starting at $node) as the sort of LoL-like bracket\nnotation you see in the above example code.  Returns just one big\nblock of text.  The only option is \"multiline\" -- if true, it dumps\nthe text as the sort of indented structure as seen above; if false\n(and it defaults to false), dumps it all on one line (with no\nindenting, of course).\n\nFor example, starting with the tree from the above example,\nthis:\n\n  print $tree->tree_to_lol_notation, \"\\n\";\n\nprints the following (which I've broken over two lines for sake of\nprintablitity of documentation):\n\n  [[[['Det:The'], [['dog'], 'N'], 'NP'], [[\"/with rabies\\x5c\"],\n  'PP'], 'NP'], [['died'], 'VP'], 'S'], \n\nDoing this:\n\n  print $tree->tree_to_lol_notation({ multiline => 1 });\n\nprints the same content, just spread over many lines, and prettily\nindented.\n\n\n#--------------------------------------------------------------------------\n\nsub tree_to_lol_notation {\n  my $root = $_[0];\n  my($it, $o) = @_[0,1];\n  $o = {} unless ref $o;\n  my @out = ();\n  $o->{'_depth'} ||= 0;\n  $o->{'multiline'} = 0 unless exists($o->{'multiline'});\n\n  my $line_end;\n  if($o->{'multiline'}) {\n    $o->{'indent'} ||= '  ';\n    $line_end = \"\\n\";\n  } else {\n    $o->{'indent'} ||= '';\n    $line_end = '';\n  }\n\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      push(@out,\n             $o->{'indent'} x $o->{'_depth'},\n             \"[$line_end\",\n      );      \n      return 1;\n    }\n  ;\n  $o->{'callbackback'} = sub {\n      my($this, $o) = @_[0,1];\n      my $name = $this->name;\n      if(!defined($name)) {\n        $name = 'undef';\n      } else {\n        $name = &Tree::DAG_Node::_dump_quote($name);\n      }\n      push(@out,\n             $o->{'indent'} x ($o->{'_depth'} + 1),\n             \"$name$line_end\",\n             $o->{'indent'} x $o->{'_depth'},\n             \"], $line_end\",\n      );\n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  return join('', @out);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->tree_to_lol\n\nReturns that tree (starting at $node) represented as a LoL, like what\n$lol, above, holds.  (This is as opposed to C<tree_to_lol_notation>,\nwhich returns the viewable code like what gets evaluated and stored in\n$lol, above.)\n\nLord only knows what you use this for -- maybe for feeding to\nData::Dumper, in case C<tree_to_lol_notation> doesn't do just what you\nwant?\n\n\nsub tree_to_lol {\n  # I haven't /rigorously/ tested this.\n  my($it, $o) = @_[0,1]; # $o is currently unused anyway\n  $o = {} unless ref $o;\n\n  my $out = [];\n  my @lol_stack = ($out);\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      my $new = [];\n      push @{$lol_stack[-1]}, $new;\n      push(@lol_stack, $new);\n      return 1;\n    }\n  ;\n  $o->{'callbackback'} = sub {\n      my($this, $o) = @_[0,1];\n      push @{$lol_stack[-1]}, $this->name;\n      pop @lol_stack;\n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  die \"totally bizarre error 12416\" unless ref($out->[0]);\n  $out = $out->[0]; # the real root\n  return $out;\n}\n\n###########################################################################\n\n* the constructor CLASS->simple_lol_to_tree($simple_lol);\n\nThis is like lol_to_tree, except that rule 1 doesn't apply -- i.e.,\nall scalars (or really, anything not a listref) in the LoL-structure\nend up as named terminal nodes, and only terminal nodes get names\n(and, of course, that name comes from that scalar value).  This method\nis useful for making things like expression trees, or at least\nstarting them off.  Consider that this:\n\n    $tree = Tree::DAG_Node->simple_lol_to_tree(\n      [ 'foo', ['bar', ['baz'], 'quux'], 'zaz', 'pati' ]\n    );\n\nconverts from something like a Lispish or Iconish tree, if you pretend\nthe brackets are parentheses.\n\nNote that there is a (possibly surprising) degenerate case of what I'm\ncalling a \"simple-LoL\", and it's like this:\n\n  $tree = Tree::DAG_Node->simple_lol_to_tree('Lonely');\n\nThis is the (only) way you can specify a tree consisting of only a\nsingle node, which here gets the name 'Lonely'.","parameters":[{"label":"$class"},{"label":"$lol"},{"label":"$seen_r"}]},"containerName":"main::","definition":"sub"},{"children":[{"containerName":"tree_to_simple_lol","definition":"my","name":"$root","localvar":"my","kind":13,"line":2210},{"name":"$root","containerName":"tree_to_simple_lol","kind":13,"line":2212},{"line":2212,"kind":12,"containerName":"tree_to_simple_lol","name":"name"},{"containerName":"tree_to_simple_lol","name":"$root","line":2212,"kind":13},{"name":"daughters","range":{"start":{}},"containerName":"tree_to_simple_lol","detail":"($it,$o)","signature":{"documentation":"","parameters":[{"label":"$it"},{"label":"$o"}],"label":"daughters($it,$o)"},"kind":12,"line":2212},{"line":2215,"kind":13,"localvar":"my","name":"$it","definition":"my","containerName":"tree_to_simple_lol"},{"name":"$o","containerName":"tree_to_simple_lol","line":2215,"kind":13},{"name":"$o","containerName":"tree_to_simple_lol","line":2216,"kind":13},{"kind":13,"line":2216,"name":"$o","containerName":"tree_to_simple_lol"},{"definition":"my","name":"$out","containerName":"tree_to_simple_lol","localvar":"my","kind":13,"line":2218},{"kind":13,"line":2219,"containerName":"tree_to_simple_lol","definition":"my","name":"@lol_stack","localvar":"my"},{"kind":13,"line":2219,"name":"$out","containerName":"tree_to_simple_lol"},{"name":"$o","containerName":"tree_to_simple_lol","line":2220,"kind":13},{"localvar":"my","containerName":"tree_to_simple_lol","definition":"my","name":"$this","line":2221,"kind":13},{"name":"$o","containerName":"tree_to_simple_lol","kind":13,"line":2221},{"line":2222,"kind":13,"localvar":"my","containerName":"tree_to_simple_lol","name":"$new","definition":"my"},{"line":2223,"kind":13,"name":"$new","containerName":"tree_to_simple_lol"},{"line":2223,"kind":13,"containerName":"tree_to_simple_lol","name":"$this"},{"kind":12,"line":2223,"containerName":"tree_to_simple_lol","name":"daughters"},{"name":"$this","containerName":"tree_to_simple_lol","line":2223,"kind":13},{"name":"name","containerName":"tree_to_simple_lol","line":2223,"kind":12},{"name":"$lol_stack","containerName":"tree_to_simple_lol","kind":13,"line":2226},{"kind":13,"line":2226,"containerName":"tree_to_simple_lol","name":"$new"},{"containerName":"tree_to_simple_lol","name":"@lol_stack","kind":13,"line":2227},{"name":"$new","containerName":"tree_to_simple_lol","kind":13,"line":2227}],"line":2208,"kind":12,"range":{"start":{"character":0,"line":2208},"end":{"line":2229,"character":9999}},"name":"tree_to_simple_lol","definition":"sub","containerName":"main::"},{"name":"%o","containerName":null,"kind":13,"line":2231},{"containerName":null,"name":"@lol_stack","line":2231,"kind":13},{"name":"$it","containerName":null,"kind":13,"line":2232},{"name":"walk_down","containerName":"main::","line":2232,"kind":12},{"name":"$o","containerName":null,"line":2232,"kind":13},{"name":"@out","containerName":null,"kind":13,"line":2233},{"name":"$out","containerName":null,"kind":13,"line":2234},{"name":"@out","containerName":null,"line":2234,"kind":13},{"containerName":null,"name":"$out","kind":13,"line":2235},{"name":"tree_to_simple_lol_notation","range":{"start":{"line":2247,"character":0},"end":{"line":2292,"character":9999}},"containerName":"main::","definition":"sub","detail":"($it,$o)","signature":{"parameters":[{"label":"$it"},{"label":"$o"}],"documentation":"__END__\n\n# -*-Perl-*-  Time-stamp: \"2004-12-29 18:17:58 AST\"\n\nrequire 5;\npackage Tree::DAG_Node;\nuse Carp ();\nuse strict;\nuse vars qw(@ISA $Debug $VERSION);\n\n$Debug = 0;\n$VERSION = \"1.05\";\n\n=head1 NAME\n\nTree::DAG_Node - (super)class for representing nodes in a tree\n\n=head1 SYNOPSIS\n\nUsing as a base class:\n\n  package Game::Tree::Node; # or whatever you're doing\n  use Tree::DAG_Node;\n  @ISA = qw(Tree::DAG_Node);\n  ...your own methods overriding/extending\n    the methods in Tree::DAG_Node...\n\nUsing as a class of its own:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  my $new_daughter = $root->new_daughter;\n  $new_daughter->name(\"More\");\n  ...\n\n=head1 DESCRIPTION\n\nThis class encapsulates/makes/manipulates objects that represent nodes\nin a tree structure. The tree structure is not an object itself, but\nis emergent from the linkages you create between nodes.  This class\nprovides the methods for making linkages that can be used to build up\na tree, while preventing you from ever making any kinds of linkages\nwhich are not allowed in a tree (such as having a node be its own\nmother or ancestor, or having a node have two mothers).\n\nThis is what I mean by a \"tree structure\", a bit redundantly stated:\n\n* A tree is a special case of an acyclic directed graph.\n\n* A tree is a network of nodes where there's exactly one root\nnode (i.e., 'the top'), and the only primary relationship between nodes\nis the mother-daugher relationship.\n\n* No node can be its own mother, or its mother's mother, etc.\n\n* Each node in the tree has exactly one \"parent\" (node in the \"up\"\ndirection) -- except the root, which is parentless.\n\n* Each node can have any number (0 to any finite number) of daughter\nnodes.  A given node's daughter nodes constitute an I<ordered> list.\n(However, you are free to consider this ordering irrelevant.\nSome applications do need daughters to be ordered, so I chose to\nconsider this the general case.)\n\n* A node can appear in only one tree, and only once in that tree.\nNotably (notable because it doesn't follow from the two above points),\na node cannot appear twice in its mother's daughter list.\n\n* In other words, there's an idea of up (toward the root) versus\ndown (away from the root), and left (i.e., toward the start (index 0)\nof a given node's daughter list) versus right (toward the end of a\ngiven node's daughter list).\n\nTrees as described above have various applications, among them:\nrepresenting syntactic constituency, in formal linguistics;\nrepresenting contingencies in a game tree; representing abstract\nsyntax in the parsing of any computer language -- whether in\nexpression trees for programming languages, or constituency in the\nparse of a markup language document.  (Some of these might not use the\nfact that daughters are ordered.)\n\n(Note: B-Trees are a very special case of the above kinds of trees,\nand are best treated with their own class.  Check CPAN for modules\nencapsulating B-Trees; or if you actually want a database, and for\nsome reason ended up looking here, go look at L<AnyDBM_File>.)\n\nMany base classes are not usable except as such -- but Tree::DAG_Node\ncan be used as a normal class.  You can go ahead and say:\n\n  use Tree::DAG_Node;\n  my $root = Tree::DAG_Node->new();\n  $root->name(\"I'm the tops\");\n  $new_daughter = Tree::DAG_Node->new();\n  $new_daughter->name(\"More\");\n  $root->add_daughter($new_daughter);\n\nand so on, constructing and linking objects from Tree::DAG_Node and\nmaking useful tree structures out of them.\n\n=head1 A NOTE TO THE READER\n\nThis class is big and provides lots of methods.  If your problem is\nsimple (say, just representing a simple parse tree), this class might\nseem like using an atomic sledgehammer to swat a fly.  But the\ncomplexity of this module's bells and whistles shouldn't detract from\nthe efficiency of using this class for a simple purpose.  In fact, I'd\nbe very surprised if any one user ever had use for more that even a\nthird of the methods in this class.  And remember: an atomic\nsledgehammer B<will> kill that fly.\n\n=head1 OBJECT CONTENTS\n\nImplementationally, each node in a tree is an object, in the sense of\nbeing an arbitrarily complex data structure that belongs to a class\n(presumably Tree::DAG_Node, or ones derived from it) that provides\nmethods.\n\nThe attributes of a node-object are:\n\n\n* mother -- this node's mother.  undef if this is a root.\n\n* daughters -- the (possibly empty) list of daughters of this node.\n\n* name -- the name for this node.\n\nNeed not be unique, or even printable.  This is printed in some of the\nvarious dumper methods, but it's up to you if you don't put anything\nmeaningful or printable here.\n\n* attributes -- whatever the user wants to use it for.\n\nPresumably a hashref to whatever other attributes the user wants to\nstore without risk of colliding with the object's real attributes.\n(Example usage: attributes to an SGML tag -- you definitely wouldn't\nwant the existence of a \"mother=foo\" pair in such a tag to collide with\na node object's 'mother' attribute.)\n\nAside from (by default) initializing it to {}, and having the access\nmethod called \"attributes\" (described a ways below), I don't do\nanything with the \"attributes\" in this module.  I basically intended\nthis so that users who don't want/need to bother deriving a class\nfrom Tree::DAG_Node, could still attach whatever data they wanted in a\nnode.\n\n\n\"mother\" and \"daughters\" are attributes that relate to linkage -- they\nare never written to directly, but are changed as appropriate by the\n\"linkage methods\", discussed below.\n\nThe other two (and whatever others you may add in derived classes) are\nsimply accessed thru the same-named methods, discussed further below.\n\n=head2 ABOUT THE DOCUMENTED INTERFACE\n\nStick to the documented interface (and comments in the source --\nespecially ones saying \"undocumented!\" and/or \"disfavored!\" -- do not\ncount as documentation!), and don't rely on any behavior that's not in\nthe documented interface.\n\nSpecifically, unless the documentation for a particular method says\n\"this method returns thus-and-such a value\", then you should not rely on\nit returning anything meaningful.\n\nA I<passing> acquintance with at least the broader details of the source\ncode for this class is assumed for anyone using this class as a base\nclass -- especially if you're overriding existing methods, and\nB<definitely> if you're overriding linkage methods.\n\n=head1 MAIN CONSTRUCTOR, AND INITIALIZER\n\n\n* the constructor CLASS->new() or CLASS->new({...options...})\n\nThis creates a new node object, calls $object->_init({...options...})\nto provide it sane defaults (like: undef name, undef mother, no\ndaughters, 'attributes' setting of a new empty hashref), and returns\nthe object created.  (If you just said \"CLASS->new()\" or \"CLASS->new\",\nthen it pretends you called \"CLASS->new({})\".)\n\nCurrently no options for putting in {...options...} are part\nof the documented interface, but the options is here in case\nyou want to add such behavior in a derived class.\n\nRead on if you plan on using Tree::DAG_New as a base class.\n(Otherwise feel free to skip to the description of _init.)\n\nThere are, in my mind, two ways to do object construction:\n\nWay 1: create an object, knowing that it'll have certain uninteresting\nsane default values, and then call methods to change those values to\nwhat you want.  Example:\n\n    $node = Tree::DAG_Node->new;\n    $node->name('Supahnode!');\n    $root->add_daughter($node);\n    $node->add_daughters(@some_others)\n\nWay 2: be able to specify some/most/all the object's attributes in\nthe call to the constructor.  Something like:\n\n    $node = Tree::DAG_Node->new({\n      name => 'Supahnode!',\n      mother => $root,\n      daughters => \\@some_others\n    });\n\nAfter some deliberation, I've decided that the second way is a Bad\nThing.  First off, it is B<not> markedly more concise than the first\nway.  Second off, it often requires subtly different syntax (e.g.,\n\\@some_others vs @some_others).  It just complicates things for the\nprogrammer and the user, without making either appreciably happier.\n\n(This is not to say that options in general for a constructor are bad\n-- C<random_network>, discussed far below, necessarily takes options.\nBut note that those are not options for the default values of\nattributes.)\n\nAnyway, if you use Tree::DAG_Node as a superclass, and you add\nattributes that need to be initialized, what you need to do is provide\nan _init method that calls $this->SUPER::_init($options) to use its\nsuperclass's _init method, and then initializes the new attributes:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options); # call my superclass's _init to\n      # init all the attributes I'm inheriting\n    \n    # Now init /my/ new attributes:\n    $this->{'amigos'} = []; # for example\n  }\n\n...or, as I prefer when I'm being a neat freak:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my $this = $_[0];\n    # Or my($this,$options) = @_[0,1]; if I'm using $options\n    $this->{'amigos'} = [];\n  }\n\n\nIn other words, I like to have each attribute initialized thru a\nmethod named _init_[attribute], which should expect the object as\n$_[0] and the the options hashref (or {} if none was given) as $_[1].\nIf you insist on having your _init recognize options for setting\nattributes, you might as well have them dealt with by the appropriate\n_init_[attribute] method, like this:\n\n  sub _init {\n    my($this, $options) = @_[0,1];\n    $this->SUPER::_init($options);\n    \n    $this->_init_amigos($options);\n  }\n  \n  sub _init_amigos {\n    my($this,$options) = @_[0,1]; # I need options this time\n    $this->{'amigos'} = [];\n    $this->amigos(@{$options->{'amigos'}}) if $options->{'amigos'};\n  }\n\nAll this bookkeeping looks silly with just one new attribute in a\nclass derived straight from Tree::DAG_Node, but if there's lots of new\nattributes running around, and if you're deriving from a class derived\nfrom a class derived from Tree::DAG_Node, then tidy\nstratification/modularization like this can keep you sane.\n\n* the constructor $obj->new() or $obj->new({...options...})\n\nJust another way to get at the C<new> method. This B<does not copy>\n$obj, but merely constructs a new object of the same class as it.\nSaves you the bother of going $class = ref $obj; $obj2 = $class->new;\n\n\nsub new { # constructor\n  # Presumably you won't EVER need to override this -- _init is what\n  # you'd override in order to set an object's default attribute values.\n  my $class = shift;\n  $class = ref($class) if ref($class); # tchristic style.  why not?\n\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {}; # o for options hashref\n  my $it = bless( {}, $class );\n  print \"Constructing $it in class $class\\n\" if $Debug;\n  $it->_init( $o );\n  return $it;\n}\n\n###########################################################################\n\n* the method $node->_init({...options...})\n\nInitialize the object's attribute values.  See the discussion above.\nPresumably this should be called only by the guts of the C<new>\nconstructor -- never by the end user.\n\nCurrently there are no documented options for putting in\n{...options...}, but (in case you want to disregard the above rant)\nthe option exists for you to use {...options...} for something useful\nin a derived class.\n\nPlease see the source for more information.\n\n* see also (below) the constructors \"new_daughter\" and \"new_daughter_left\"\n\n\n\nsub _init { # method\n  my $this = shift;\n  my $o = ref($_[0]) eq 'HASH' ? $_[0] : {};\n\n  # Sane initialization.\n  $this->_init_mother($o);\n  $this->_init_daughters($o);\n  $this->_init_name($o);\n  $this->_init_attributes($o);\n\n  return;\n}\n\nsub _init_mother { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'mother'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  ( $o->{'mother'} )->add_daughter($this)\n    if defined($o->{'mother'}) && ref($o->{'mother'});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_daughters { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'daughters'} = [];\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->set_daughters( @{$o->{'daughters'}} )\n    if ref($o->{'daughters'}) && (@{$o->{'daughters'}});\n  # DO NOT use this option (as implemented) with new_daughter or\n  #  new_daughter_left!!!!!\n  # BAD THINGS MAY HAPPEN!!!\n}\n\nsub _init_name { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'name'} = undef;\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->name( $o->{'name'} ) if exists $o->{'name'};\n}\n\nsub _init_attributes { # to be called by an _init\n  my($this, $o) = @_[0,1];\n\n  $this->{'attributes'} = {};\n\n  # Undocumented and disfavored.  Consider this just an example.\n  $this->attributes( $o->{'attributes'} ) if exists $o->{'attributes'};\n}\n\n###########################################################################\n###########################################################################\n\n=head1 LINKAGE-RELATED METHODS\n\n\n* $node->daughters\n\nThis returns the (possibly empty) list of daughters for $node.\n\n\nsub daughters { # read-only attrib-method: returns a list.\n  my $this = shift;\n\n  if(@_) { # undoc'd and disfavored to use as a write-method\n    Carp::croak \"Don't set daughters with doughters anymore\\n\";\n    Carp::carp \"my parameter must be a listref\" unless ref($_[0]);\n    $this->{'daughters'} = $_[0];\n    $this->_update_daughter_links;\n  }\n  #return $this->{'daughters'};\n  return @{$this->{'daughters'} || []};\n}\n\n###########################################################################\n\n* $node->mother\n\nThis returns what node is $node's mother.  This is undef if $node has\nno mother -- i.e., if it is a root.\n\n\nsub mother { # read-only attrib-method: returns an object (the mother node)\n  my $this = shift;\n  Carp::croak \"I'm a read-only method!\" if @_;\n  return $this->{'mother'};\n}\n\n###########################################################################\n###########################################################################\n\n* $mother->add_daughters( LIST )\n\nThis method adds the node objects in LIST to the (right) end of\n$mother's C<daughter> list.  Making a node N1 the daughter of another\nnode N2 also means that N1's C<mother> attribute is \"automatically\" set\nto N2; it also means that N1 stops being anything else's daughter as\nit becomes N2's daughter.\n\nIf you try to make a node its own mother, a fatal error results.  If\nyou try to take one of a a node N1's ancestors and make it also a\ndaughter of N1, a fatal error results.  A fatal error results if\nanything in LIST isn't a node object.\n\nIf you try to make N1 a daughter of N2, but it's B<already> a daughter\nof N2, then this is a no-operation -- it won't move such nodes to the\nend of the list or anything; it just skips doing anything with them.\n\n* $node->add_daughter( LIST )\n\nAn exact synonym for $node->add_daughters(LIST)\n\n\nsub add_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters; # no-op\n  return\n    $mother->_add_daughters_wrapper(\n      sub { push @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter { # alias\n  my($it,@them) = @_;  $it->add_daughters(@them);\n}\n\n* $mother->add_daughters_left( LIST )\n\nThis method is just like C<add_daughters>, except that it adds the\nnode objects in LIST to the (left) beginning of $mother's daughter\nlist, instead of the (right) end of it.\n\n* $node->add_daughter_left( LIST )\n\nAn exact synonym for $node->add_daughters_left( LIST )\n\n\nsub add_daughters_left { # write-only method\n  my($mother, @daughters) = @_;\n  return unless @daughters;\n  return\n    $mother->_add_daughters_wrapper(\n      sub { unshift @{$_[0]}, $_[1]; },\n      @daughters\n    );\n}\n\nsub add_daughter_left { # alias\n  my($it,@them) = @_;  $it->add_daughters_left(@them);\n}\n\n* Note:\n\nThe above link-making methods perform basically an C<unshift> or\nC<push> on the mother node's daughter list.  To get the full range of\nlist-handling functionality, copy the daughter list, and change it,\nand then call C<set_daughters> on the result:\n\n          @them = $mother->daughters;\n          @removed = splice(@them, 0,2, @new_nodes);\n          $mother->set_daughters(@them);\n\nOr consider a structure like:\n\n          $mother->set_daughters(\n                                 grep($_->name =~ /NP/ ,\n                                      $mother->daughters\n                                     )\n                                );\n\n\n\n###\n##  Used by the adding methods\n#    (except maybe new_daughter, and new_daughter_left)\n\nsub _add_daughters_wrapper {\n  my($mother, $callback, @daughters) = @_;\n  return unless @daughters;\n\n  my %ancestors;\n  @ancestors{ $mother->ancestors } = undef;\n  # This could be made more efficient by not bothering to compile\n  # the ancestor list for $mother if all the nodes to add are\n  # daughterless.\n  # But then you have to CHECK if they're daughterless.\n  # If $mother is [big number] generations down, then it's worth checking.\n\n  foreach my $daughter (@daughters) { # which may be ()\n    Carp::croak \"daughter must be a node object!\" unless UNIVERSAL::can($daughter, 'is_node');\n\n    printf \"Mother  : %s (%s)\\n\", $mother, ref $mother if $Debug;\n    printf \"Daughter: %s (%s)\\n\", $daughter, ref $daughter if $Debug;\n    printf \"Adding %s to %s\\n\",\n      ($daughter->name() || $daughter),\n      ($mother->name()   || $mother)     if $Debug > 1;\n\n    Carp::croak \"mother can't be its own daughter!\" if $mother eq $daughter;\n\n    $daughter->cyclicity_fault(\n      \"$daughter (\" . ($daughter->name || 'no_name') .\n      \") is an ancestor of $mother (\" . ($mother->name || 'no_name') .\n      \"), so can't became its daughter.\"\n    ) if exists $ancestors{$daughter};\n\n    my $old_mother = $daughter->{'mother'};\n\n    next if defined($old_mother) && ref($old_mother) && $old_mother eq $mother;\n      # noop if $daughter is already $mother's daughter\n\n    $old_mother->remove_daughters($daughter)\n      if defined($old_mother) && ref($old_mother);\n\n    &{$callback}($mother->{'daughters'}, $daughter);\n  }\n  $mother->_update_daughter_links; # need only do this at the end\n\n  return;\n}\n\n###########################################################################\n###########################################################################\n\nsub _update_daughter_links {\n  # Eliminate any duplicates in my daughters list, and update\n  #  all my daughters' links to myself.\n  my $this = shift;\n\n  my $them = $this->{'daughters'};\n\n  # Eliminate duplicate daughters.\n  my %seen = ();\n  @$them = grep { ref($_) && not($seen{$_}++) } @$them;\n   # not that there should ever be duplicate daughters anyhoo.\n\n  foreach my $one (@$them) { # linkage bookkeeping\n    Carp::croak \"daughter <$one> isn't an object!\" unless ref $one;\n    $one->{'mother'} = $this;\n  }\n  return;\n}\n\n###########################################################################\n\n# Currently unused.\n\nsub _update_links { # update all descendant links for ancestorship below\n  # this point\n  # note: it's \"descendant\", not \"descendent\"\n  # see <http://www.lenzo.com/~sburke/stuff/english_ant_and_ent.html>\n  my $this = shift;\n  # $this->no_cyclicity;\n  $this->walk_down({\n    'callback' => sub {\n      my $this = $_[0];\n      $this->_update_daughter_links;\n      return 1;\n    },\n  });\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor $daughter = $mother->new_daughter, or\n\n* the constructor $daughter = $mother->new_daughter({...options...})\n\nThis B<constructs> a B<new> node (of the same class as $mother), and\nadds it to the (right) end of the daughter list of $mother. This is\nessentially the same as going\n\n      $daughter = $mother->new;\n      $mother->add_daughter($daughter);\n\nbut is rather more efficient because (since $daughter is guaranteed new\nand isn't linked to/from anything), it doesn't have to check that\n$daughter isn't an ancestor of $mother, isn't already daughter to a\nmother it needs to be unlinked from, isn't already in $mother's \ndaughter list, etc.\n\nAs you'd expect for a constructor, it returns the node-object created.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  push @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n* the constructor $mother->new_daughter_left, or\n\n* $mother->new_daughter_left({...options...})\n\nThis is just like $mother->new_daughter, but adds the new daughter\nto the left (start) of $mother's daughter list.\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub new_daughter_left {\n  my($mother, @options) = @_;\n  my $daughter = $mother->new(@options);\n\n  unshift @{$mother->{'daughters'}}, $daughter;\n  $daughter->{'mother'} = $mother;\n\n  return $daughter;\n}\n\n###########################################################################\n\n* $mother->remove_daughters( LIST )\n\nThis removes the nodes listed in LIST from $mother's daughter list.\nThis is a no-operation if LIST is empty.  If there are things in LIST\nthat aren't a current daughter of $mother, they are ignored.\n\nNot to be confused with $mother->clear_daughters.\n\n\nsub remove_daughters { # write-only method\n  my($mother, @daughters) = @_;\n  Carp::croak \"mother must be an object!\" unless ref $mother;\n  return unless @daughters;\n\n  my %to_delete;\n  @daughters = grep {ref($_)\n\t\t       and defined($_->{'mother'})\n\t\t       and $mother eq $_->{'mother'}\n                    } @daughters;\n  return unless @daughters;\n  @to_delete{ @daughters } = undef;\n\n  # This could be done better and more efficiently, I guess.\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = undef;\n  }\n  my $them = $mother->{'daughters'};\n  @$them = grep { !exists($to_delete{$_}) } @$them;\n\n  # $mother->_update_daughter_links; # unnecessary\n  return;\n}\n\n* $node->remove_daughter( LIST )\n\nAn exact synonym for $node->remove_daughters( LIST )\n\n\nsub remove_daughter { # alias\n  my($it,@them) = @_;  $it->remove_daughters(@them);\n}\n\n* $node->unlink_from_mother\n\nThis removes node from the daughter list of its mother.  If it has no\nmother, this is a no-operation.\n\nReturns the mother unlinked from (if any).\n\n\nsub unlink_from_mother {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  $mother->remove_daughters($node) if defined($mother) && ref($mother);\n  return $mother;\n}\n\n###########################################################################\n\n* $mother->clear_daughters\n\nThis unlinks all $mother's daughters.\nReturns the the list of what used to be $mother's daughters.\n\nNot to be confused with $mother->remove_daughters( LIST ).\n\n\nsub clear_daughters { # write-only method\n  my($mother) = $_[0];\n  my @daughters = @{$mother->{'daughters'}};\n\n  @{$mother->{'daughters'}} = ();\n  foreach my $one (@daughters) {\n    next unless UNIVERSAL::can($one, 'is_node'); # sanity check\n    $one->{'mother'} = undef;\n  }\n  # Another, simpler, way to do it:\n  #  $mother->remove_daughters($mother->daughters);\n\n  return @daughters; # NEW\n}\n#--------------------------------------------------------------------------\n\n* $mother->set_daughters( LIST )\n\nThis unlinks all $mother's daughters, and replaces them with the\ndaughters in LIST.\n\nCurrently implemented as just $mother->clear_daughters followed by\n$mother->add_daughters( LIST ).\n\n\nsub set_daughters { # write-only method\n  my($mother, @them) = @_;\n  $mother->clear_daughters;\n  $mother->add_daughters(@them) if @them;\n  # yup, it's that simple\n}\n\n#--------------------------------------------------------------------------\n\n* $node->replace_with( LIST )\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with the items in LIST.  This returns a list consisting\nof $node followed by LIST, i.e., the nodes that replaced it.\n\nLIST can include $node itself (presumably at most once).  LIST can\nalso be empty-list.  However, if any items in LIST are sisters to\n$node, they are ignored, and are not in the copy of LIST passed as the\nreturn value.\n\nAs you might expect for any linking operation, the items in LIST\ncannot be $node's mother, or any ancestor to it; and items in LIST are,\nof course, unlinked from their mothers (if they have any) as they're\nlinked to $node's mother.\n\n(In the special (and bizarre) case where $node is root, this simply calls\n$this->unlink_from_mother on all the items in LIST, making them roots of\ntheir own trees.)\n\nNote that the daughter-list of $node is not necessarily affected; nor\nare the daughter-lists of the items in LIST.  I mention this in case you\nthink replace_with switches one node for another, with respect to its\nmother list B<and> its daughter list, leaving the rest of the tree\nunchanged. If that's what you want, replacing $Old with $New, then you\nwant:\n\n  $New->set_daughters($Old->clear_daughters);\n  $Old->replace_with($New);\n\n(I can't say $node's and LIST-items' daughter lists are B<never>\naffected my replace_with -- they can be affected in this case:\n\n  $N1 = ($node->daughters)[0]; # first daughter of $node\n  $N2 = ($N1->daughters)[0];   # first daughter of $N1;\n  $N3 = Tree::DAG_Node->random_network; # or whatever\n  $node->replace_with($N1, $N2, $N3);\n\nAs a side affect of attaching $N1 and $N2 to $node's mother, they're\nunlinked from their parents ($node, and $N1, replectively).\nBut N3's daughter list is unaffected.\n\nIn other words, this method does what it has to, as you'd expect it\nto.\n\n\nsub replace_with { # write-only method\n  my($this, @replacements) = @_;\n  \n  if(not( defined($this->{'mother'}) && ref($this->{'mother'}) )) { # if root\n    foreach my $replacement (@replacements) {\n      $replacement->{'mother'}->remove_daughters($replacement)\n        if $replacement->{'mother'};\n    }\n      # make 'em roots\n  } else { # I have a mother\n    my $mother = $this->{'mother'};\n\n    #@replacements = grep(($_ eq $this  ||  $_->{'mother'} ne $mother),\n    #                     @replacements);\n    @replacements = grep { $_ eq $this\n                           || not(defined($_->{'mother'}) &&\n                                  ref($_->{'mother'}) &&\n                                  $_->{'mother'} eq $mother\n                                 )\n                         }\n                         @replacements;\n    # Eliminate sisters (but not self)\n    # i.e., I want myself or things NOT with the same mother as myself.\n\n    $mother->set_daughters(   # old switcheroo\n                           map($_ eq $this ? (@replacements) : $_ ,\n                               @{$mother->{'daughters'}}\n                              )\n                          );\n    # and set_daughters does all the checking and possible\n    # unlinking\n  }\n  return($this, @replacements);\n}\n\n* $node->replace_with_daughters\n\nThis replaces $node in its mother's daughter list, by unlinking $node\nand replacing it with its daughters.  In other words, $node becomes\nmotherless and daughterless as its daughters move up and take its place.\nThis returns a list consisting of $node followed by the nodes that were\nits daughters.\n\nIn the special (and bizarre) case where $node is root, this simply\nunlinks its daughters from it, making them roots of their own trees.\n\nEffectively the same as $node->replace_with($node->daughters), but more\nefficient, since less checking has to be done.  (And I also think\n$node->replace_with_daughters is a more common operation in\ntree-wrangling than $node->replace_with(LIST), so deserves a named\nmethod of its own, but that's just me.)\n\n\n# Note that if you radically change 'mother'/'daughters' bookkeeping,\n# you may have to change this routine, since it's one of the places\n# that directly writes to 'daughters' and 'mother'.\n\nsub replace_with_daughters { # write-only method\n  my($this) = $_[0]; # takes no params other than the self\n  my $mother = $this->{'mother'};\n  return($this, $this->clear_daughters)\n    unless defined($mother) && ref($mother);\n\n  my @daughters = $this->clear_daughters;\n  my $sib_r = $mother->{'daughters'};\n  @$sib_r = map($_ eq $this ? (@daughters) : $_,\n                @$sib_r   # old switcheroo\n            );\n  foreach my $daughter (@daughters) {\n    $daughter->{'mother'} = $mother;\n  }\n  return($this, @daughters);\n}\n\n#--------------------------------------------------------------------------\n\n* $node->add_left_sisters( LIST )\n\nThis adds the elements in LIST (in that order) as immediate left sisters of\n$node.  In other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_left_sisters(X,Y) makes B's mother's daughter-list\n(A,X,Y,B,C,D).\n\nIf LIST is empty, this is a no-op, and returns empty-list.\n\nThis is basically implemented as a call to $node->replace_with(LIST,\n$node), and so all replace_with's limitations and caveats apply.\n\nThe return value of $node->add_left_sisters( LIST ) is the elements of\nLIST that got added, as returned by replace_with -- minus the copies\nof $node you'd get from a straight call to $node->replace_with(LIST,\n$node).\n\n\nsub add_left_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  \n  @new = $this->replace_with(@new, $this);\n  shift @new; pop @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_left_sister( LIST )\n\nAn exact synonym for $node->add_left_sisters(LIST)\n\n\nsub add_left_sister { # alias\n  my($it,@them) = @_;  $it->add_left_sisters(@them);\n}\n\n* $node->add_right_sisters( LIST )\n\nJust like add_left_sisters (which see), except that the the elements\nin LIST (in that order) as immediate B<right> sisters of $node;\n\nIn other words, given that B's mother's daughter-list is (A,B,C,D),\ncalling B->add_right_sisters(X,Y) makes B's mother's daughter-list\n(A,B,X,Y,C,D).\n\n\nsub add_right_sisters { # write-only method\n  my($this, @new) = @_;\n  return() unless @new;\n  @new = $this->replace_with($this, @new);\n  shift @new; shift @new; # kill the copies of $this\n  return @new;\n}\n\n* $node->add_right_sister( LIST )\n\nAn exact synonym for $node->add_right_sisters(LIST)\n\n\nsub add_right_sister { # alias\n  my($it,@them) = @_;  $it->add_right_sisters(@them);\n}\n\n###########################################################################\n\n\n\n###########################################################################\n###########################################################################\n\n=head1 OTHER ATTRIBUTE METHODS\n\n\n* $node->name or $node->name(SCALAR)\n\nIn the first form, returns the value of the node object's \"name\"\nattribute.  In the second form, sets it to the value of SCALAR.\n\n\nsub name { # read/write attribute-method.  returns/expects a scalar\n  my $this = shift;\n  $this->{'name'} = $_[0] if @_;\n  return $this->{'name'};\n}\n\n\n###########################################################################\n\n* $node->attributes or $node->attributes(SCALAR)\n\nIn the first form, returns the value of the node object's \"attributes\"\nattribute.  In the second form, sets it to the value of SCALAR.  I\nintend this to be used to store a reference to a (presumably\nanonymous) hash the user can use to store whatever attributes he\ndoesn't want to have to store as object attributes.  In this case, you\nneedn't ever set the value of this.  (_init has already initialized it\nto {}.)  Instead you can just do...\n\n  $node->attributes->{'foo'} = 'bar';\n\n...to write foo => bar.\n\n\nsub attributes { # read/write attribute-method\n  # expects a ref, presumably a hashref\n  my $this = shift;\n  if(@_) {\n    Carp::carp \"my parameter must be a reference\" unless ref($_[0]);\n    $this->{'attributes'} = $_[0];\n  }\n  return $this->{'attributes'};\n}\n\n* $node->attribute or $node->attribute(SCALAR)\n\nAn exact synonym for $node->attributes or $node->attributes(SCALAR)\n\n\nsub attribute { # alias\n  my($it,@them) = @_;  $it->attributes(@them);\n}\n\n###########################################################################\n# Secret Stuff.\n\nsub no_cyclicity { # croak iff I'm in a CYCLIC class. \n  my($it) = $_[0];\n  # If, God forbid, I use this to make a cyclic class, then I'd\n  # expand the functionality of this routine to actually look for\n  # cyclicity.  Or something like that.  Maybe.\n\n  $it->cyclicity_fault(\"You can't do that in a cyclic class!\")\n    if $it->cyclicity_allowed;\n  return;\n}\n\nsub cyclicity_fault {\n  my($it, $bitch) = @_[0,1];\n  Carp::croak \"Cyclicity fault: $bitch\"; # never return\n}\n\nsub cyclicity_allowed {\n  return 0;\n}\n\n###########################################################################\n# More secret stuff.  Currently unused.\n\nsub inaugurate_root { # no-op\n  my($it, $tree) = @_[0,1];\n  # flag this node as being the root of the tree $tree.\n  return;\n}\n\nsub decommission_root { # no-op\n  # flag this node as no longer being the root of the tree $tree.\n  return;\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 OTHER METHODS TO DO WITH RELATIONSHIPS\n\n\n* $node->is_node\n\nThis always returns true.  More pertinently, $object->can('is_node')\nis true (regardless of what C<is_node> would do if called) for objects\nbelonging to this class or for any class derived from it.\n\n\nsub is_node { return 1; } # always true.\n# NEVER override this with anything that returns false in the belief\n#  that this'd signal \"not a node class\".  The existence of this method\n#  is what I test for, with the various \"can()\" uses in this class.\n\n###########################################################################\n\n* $node->ancestors\n\nReturns the list of this node's ancestors, starting with its mother,\nthen grandmother, and ending at the root.  It does this by simply\nfollowing the 'mother' attributes up as far as it can.  So if $item IS\nthe root, this returns an empty list.\n\nConsider that scalar($node->ancestors) returns the ply of this node\nwithin the tree -- 2 for a granddaughter of the root, etc., and 0 for\nroot itself.\n\n\nsub ancestors {\n  my $this = shift;\n  my $mama = $this->{'mother'}; # initial condition\n  return () unless ref($mama); # I must be root!\n\n  # $this->no_cyclicity; # avoid infinite loops\n\n  # Could be defined recursively, as:\n  # if(ref($mama = $this->{'mother'})){\n  #   return($mama, $mama->ancestors);\n  # } else {\n  #   return ();\n  # }\n  # But I didn't think of that until I coded the stuff below, which is\n  # faster.\n\n  my @ancestors = ( $mama ); # start off with my mama\n  while(defined( $mama = $mama->{'mother'} ) && ref($mama)) {\n    # Walk up the tree\n    push(@ancestors, $mama);\n    # This turns into an infinite loop if someone gets stupid\n    #  and makes this tree cyclic!  Don't do it!\n  }\n  return @ancestors;\n}\n\n###########################################################################\n\n* $node->root\n\nReturns the root of whatever tree $node is a member of.  If $node is\nthe root, then the result is $node itself.\n\n\nsub root {\n  my $it = $_[0];\n  my @ancestors = ($it, $it->ancestors);\n  return $ancestors[-1];\n}\n\n###########################################################################\n\n* $node->is_daughter_of($node2)\n\nReturns true iff $node is a daughter of $node2.\nCurrently implemented as just a test of ($it->mother eq $node2).\n\n\nsub is_daughter_of {\n  my($it,$mama) = @_[0,1];\n  return $it->{'mother'} eq $mama;\n}\n\n###########################################################################\n\n* $node->self_and_descendants\n\nReturns a list consisting of itself (as element 0) and all the\ndescendants of $node.  Returns just itself if $node is a\nterminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub self_and_descendants {\n  # read-only method:  return a list of myself and any/all descendants\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' => sub { push @List, $_[0]; return 1;}});\n  Carp::croak \"Spork Error 919: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->descendants\n\nReturns a list consisting of all the descendants of $node.  Returns\nempty-list if $node is a terminal_node.\n\n(Note that it's spelled \"descendants\", not \"descendents\".)\n\n\nsub descendants {\n  # read-only method:  return a list of my descendants\n  my $node = shift;\n  my @list = $node->self_and_descendants;\n  shift @list; # lose myself.\n  return @list;\n}\n\n###########################################################################\n\n* $node->leaves_under\n\nReturns a list (going left-to-right) of all the leaf nodes under\n$node.  (\"Leaf nodes\" are also called \"terminal nodes\" -- i.e., nodes\nthat have no daughters.)  Returns $node in the degenerate case of\n$node being a leaf itself.\n\n\nsub leaves_under {\n  # read-only method:  return a list of all leaves under myself.\n  # Returns myself in the degenerate case of being a leaf myself.\n  my $node = shift;\n  my @List = ();\n  # $node->no_cyclicity;\n  $node->walk_down({ 'callback' =>\n    sub {\n      my $node = $_[0];\n      my @daughters = @{$node->{'daughters'}};\n      push(@List, $node) unless @daughters;\n      return 1;\n    }\n  });\n  Carp::croak \"Spork Error 861: \\@List has no contents!?!?\" unless @List;\n    # impossible\n  return @List;\n}\n\n###########################################################################\n\n* $node->depth_under\n\nReturns an integer representing the number of branches between this\n$node and the most distant leaf under it.  (In other words, this\nreturns the ply of subtree starting of $node.  Consider\nscalar($it->ancestors) if you want the ply of a node within the whole\ntree.)\n\n\nsub depth_under {\n  my $node = shift;\n  my $max_depth = 0;\n  $node->walk_down({\n    '_depth' => 0,\n    'callback' => sub {\n      my $depth = $_[1]->{'_depth'};\n      $max_depth = $depth if $depth > $max_depth;\n      return 1;\n    },\n  });\n  return $max_depth;\n}\n\n###########################################################################\n\n* $node->generation\n\nReturns a list of all nodes (going left-to-right) that are in $node's\ngeneration -- i.e., that are the some number of nodes down from\nthe root.  $root->generation is just $root.\n\nOf course, $node is always in its own generation.\n\n* $node->generation_under(NODE2)\n\nLike $node->generation, but returns only the nodes in $node's generation\nthat are also descendants of NODE2 -- in other words,\n\n    @us = $node->generation_under( $node->mother->mother );\n\nis all $node's first cousins (to borrow yet more kinship terminology) --\nassuming $node does indeed have a grandmother.  Actually \"cousins\" isn't\nquite an apt word, because C<@us> ends up including $node's siblings and\n$node.\n\nActually, C<generation_under> is just an alias to C<generation>, but I\nfigure that this:\n\n   @us = $node->generation_under($way_upline);\n\nis a bit more readable than this:\n\n   @us = $node->generation($way_upline);\n\nBut it's up to you.\n\n$node->generation_under($node) returns just $node.\n\nIf you call $node->generation_under($node) but NODE2 is not $node or an\nancestor of $node, it behaves as if you called just $node->generation().\n\n\nsub generation {\n  my($node, $limit) = @_[0,1]; \n  # $node->no_cyclicity;\n  return $node\n    if $node eq $limit || not(\n\t\t\t      defined($node->{'mother'}) &&\n\t\t\t      ref($node->{'mother'})\n\t\t\t     ); # bailout\n\n  return map(@{$_->{'daughters'}}, $node->{'mother'}->generation($limit));\n    # recurse!\n    # Yup, my generation is just all the daughters of my mom's generation.\n}\n\nsub generation_under {\n  my($node, @rest) = @_; \n  return $node->generation(@rest);\n}\n\n###########################################################################\n\n* $node->self_and_sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- including $node itself. This is just like\n$node->mother->daughters, except that that fails where $node is root,\nwhereas $root->self_and_siblings, as a special case, returns $root.\n\n(Contrary to how you may interpret how this method is named, \"self\" is\nnot (necessarily) the first element of what's returned.)\n\n\nsub self_and_sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return $node unless defined($mother) && ref($mother);  # special case\n  return @{$node->{'mother'}->{'daughters'}};\n}\n\n###########################################################################\n\n* $node->sisters\n\nReturns a list of all nodes (going left-to-right) that have the same\nmother as $node -- B<not including> $node itself.  If $node is root,\nthis returns empty-list.\n\n\nsub sisters {\n  my $node = $_[0];\n  my $mother = $node->{'mother'};\n  return() unless $mother;  # special case\n  return grep($_ ne $node,\n              @{$node->{'mother'}->{'daughters'}}\n             );\n}\n\n###########################################################################\n\n* $node->left_sister\n\nReturns the node that's the immediate left sister of $node.  If $node\nis the leftmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  \n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $left = undef;\n  foreach my $one (@sisters) {\n    return $left if $one eq $it;\n    $left = $one;\n  }\n  die \"SPORK ERROR 9757: I'm not in my mother's daughter list!?!?\";\n}\n\n\n* $node->left_sisters\n\nReturns a list of nodes that're sisters to the left of $node.  If\n$node is the leftmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_left_sisters(LIST).)\n\n\nsub left_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out = ();\n  foreach my $one (@sisters) {\n    return @out if $one eq $it;\n    push @out, $one;\n  }\n  die \"SPORK ERROR 9767: I'm not in my mother's daughter list!?!?\";\n}\n\n* $node->right_sister\n\nReturns the node that's the immediate right sister of $node.  If $node\nis the rightmost (or only) daughter of its mother (or has no mother),\nthen this returns undef.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sister {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return undef unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return undef if @sisters  == 1; # I'm an only daughter\n\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    return $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9777: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return undef;\n}\n\n* $node->right_sisters\n\nReturns a list of nodes that're sisters to the right of $node. If\n$node is the rightmost (or only) daughter of its mother (or has no\nmother), then this returns an empty list.\n\n(See also $node->add_right_sisters(LIST).)\n\n\nsub right_sisters {\n  my $it = $_[0];\n  my $mother = $it->{'mother'};\n  return() unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n  return() if @sisters  == 1; # I'm an only daughter\n\n  my @out;\n  my $seen = 0;\n  foreach my $one (@sisters) {\n    push @out, $one if $seen;\n    $seen = 1 if $one eq $it;\n  }\n  die \"SPORK ERROR 9787: I'm not in my mother's daughter list!?!?\"\n    unless $seen;\n  return @out;\n}\n\n###########################################################################\n\n* $node->my_daughter_index\n\nReturns what index this daughter is, in its mother's C<daughter> list.\nIn other words, if $node is ($node->mother->daughters)[3], then\n$node->my_daughter_index returns 3.\n\nAs a special case, returns 0 if $node has no mother.\n\n\nsub my_daughter_index {\n  # returns what number is my index in my mother's daughter list\n  # special case: 0 for root.\n  my $node = $_[0];\n  my $ord = -1;\n  my $mother = $node->{'mother'};\n\n  return 0 unless $mother;\n  my @sisters = @{$mother->{'daughters'}};\n\n  die \"SPORK ERROR 6512:  My mother has no kids!!!\" unless @sisters;\n\n Find_Self:\n  for(my $i = 0; $i < @sisters; $i++) {\n    if($sisters[$i] eq $node) {\n      $ord = $i;\n      last Find_Self;\n    }\n  }\n  die \"SPORK ERROR 2837: I'm not a daughter of my mother?!?!\" if $ord == -1;\n  return $ord;\n}\n\n###########################################################################\n\n* $node->address or $anynode->address(ADDRESS)\n\nWith the first syntax, returns the address of $node within its tree,\nbased on its position within the tree.  An address is formed by noting\nthe path between the root and $node, and concatenating the\ndaughter-indices of the nodes this passes thru (starting with 0 for\nthe root, and ending with $node).\n\nFor example, if to get from node ROOT to node $node, you pass thru\nROOT, A, B, and $node, then the address is determined as:\n\n* ROOT's my_daughter_index is 0.\n\n* A's my_daughter_index is, suppose, 2. (A is index 2 in ROOT's\ndaughter list.)\n\n* B's my_daughter_index is, suppose, 0. (B is index 0 in A's\ndaughter list.)\n\n* $node's my_daughter_index is, suppose, 4. ($node is index 4 in\nB's daughter list.)\n\nThe address of the above-described $node is, therefore, \"0:2:0:4\".\n\n(As a somewhat special case, the address of the root is always \"0\";\nand since addresses start from the root, all addresses start with a\n\"0\".)\n\nThe second syntax, where you provide an address, starts from the root\nof the tree $anynode belongs to, and returns the node corresponding to\nthat address.  Returns undef if no node corresponds to that address.\nNote that this routine may be somewhat liberal in its interpretation\nof what can constitute an address; i.e., it accepts \"0.2.0.4\", besides\n\"0:2:0:4\".\n\nAlso note that the address of a node in a tree is meaningful only in\nthat tree as currently structured.\n\n(Consider how ($address1 cmp $address2) may be magically meaningful\nto you, if you mant to figure out what nodes are to the right of what\nother nodes.)\n\n\nsub address {\n  my($it, $address) = @_[0,1];\n  if(defined($address) && length($address)) { # given the address, return the node.\n    # invalid addresses return undef\n    my $root = $it->root;\n    my @parts = map {$_ + 0}\n                    $address =~ m/(\\d+)/g; # generous!\n    Carp::croak \"Address \\\"$address\\\" is an ill-formed address\" unless @parts;\n    Carp::croak \"Address \\\"$address\\\" must start with '0'\" unless shift(@parts) == 0;\n\n    my $current_node = $root;\n    while(@parts) { # no-op for root\n      my $ord = shift @parts;\n      my @daughters = @{$current_node->{'daughters'}};\n\n      if($#daughters < $ord) { # illegal address\n        print \"* $address has an out-of-range index ($ord)!\" if $Debug;\n        return undef;\n      }\n      $current_node = $daughters[$ord];\n      unless(ref($current_node)) {\n        print \"* $address points to or thru a non-node!\" if $Debug;\n        return undef;\n      }\n    }\n    return $current_node;\n\n  } else { # given the node, return the address\n    my @parts = ();\n    my $current_node = $it;\n    my $mother;\n\n    while(defined( $mother = $current_node->{'mother'} ) && ref($mother)) {\n      unshift @parts, $current_node->my_daughter_index;\n      $current_node = $mother;\n    }\n    return join(':', 0, @parts);\n  }\n}\n\n###########################################################################\n\n* $node->common(LIST)\n\nReturns the lowest node in the tree that is ancestor-or-self to the\nnodes $node and LIST.\n\nIf the nodes are far enough apart in the tree, the answer is just the\nroot.\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node.\n\n\nsub common { # Return the lowest node common to all these nodes...\n  # Called as $it->common($other) or $it->common(@others)\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first unless @others; # degenerate case\n\n  my %ones;\n  @ones{ @ones } = undef;\n\n  foreach my $node (@others) {\n    Carp::croak \"TILT: node \\\"$node\\\" is not a node\"\n      unless UNIVERSAL::can($node, 'is_node');\n    my %first_lineage;\n    @first_lineage{$first, $first->ancestors} = undef;\n    my $higher = undef; # the common of $first and $node\n    my @my_lineage = $node->ancestors;\n\n   Find_Common:\n    while(@my_lineage) {\n      if(exists $first_lineage{$my_lineage[0]}) {\n        $higher = $my_lineage[0];\n        last Find_Common;\n      }\n      shift @my_lineage;\n    }\n    return undef unless $higher;\n    $first = $higher;\n  } \n  return $first;\n}\n\n\n###########################################################################\n\n* $node->common_ancestor(LIST)\n\nReturns the lowest node that is ancestor to all the nodes given (in\nnodes $node and LIST).  In other words, it answers the question: \"What\nnode in the tree, as low as possible, is ancestor to the nodes given\n($node and LIST)?\"\n\nIf the nodes are far enough apart, the answer is just the root --\nexcept if any of the nodes are the root itself, in which case the\nanswer is undef (since the root has no ancestor).\n\nIf the nodes aren't all in the same tree, the answer is undef.\n\nAs a degenerate case, if LIST is empty, returns $node's mother;\nthat'll be undef if $node is root.\n\n\nsub common_ancestor {\n  my @ones = @_; # all nodes I was given\n  my($first, @others) = @_;\n\n  return $first->{'mother'} unless @others;\n    # which may be undef if $first is the root!\n\n  my %ones;\n  @ones{ @ones } = undef; # my arguments\n\n  my $common = $first->common(@others);\n  if(exists($ones{$common})) { # if the common is one of my nodes...\n    return $common->{'mother'};\n    # and this might be undef, if $common is root!\n  } else {\n    return $common;\n    # which might be null if that's all common came up with\n  }\n}\n\n###########################################################################\n###########################################################################\n\n\n=head1 YET MORE METHODS\n\n\n* $node->walk_down({ callback => \\&foo, callbackback => \\&foo, ... })\n\nPerforms a depth-first traversal of the structure at and under $node.\nWhat it does at each node depends on the value of the options hashref,\nwhich you must provide.  There are three options, \"callback\" and\n\"callbackback\" (at least one of which must be defined, as a sub\nreference), and \"_depth\".  This is what C<walk_down> does, in\npseudocode form:\n\n* Start at the $node given.\n\n* If there's a C<callback>, call it with $node as the first argument,\nand the options hashref as the second argument (which contains the\npotentially useful C<_depth>, remember).  This function must return\ntrue or false -- if false, it will block the next step:\n\n* If $node has any daughter nodes, increment C<_depth>, and call\n$daughter->walk_down(options_hashref) for each daughter (in order, of\ncourse), where options_hashref is the same hashref it was called with.\nWhen this returns, decrements C<_depth>.\n\n* If there's a C<callbackback>, call just it as with C<callback> (but\ntossing out the return value).  Note that C<callback> returning false\nblocks traversal below $node, but doesn't block calling callbackback\nfor $node.  (Incidentally, in the unlikely case that $node has stopped\nbeing a node object, C<callbackback> won't get called.)\n\n* Return.\n\n$node->walk_down is the way to recursively do things to a tree (if you\nstart at the root) or part of a tree; if what you're doing is best done\nvia pre-pre order traversal, use C<callback>; if what you're doing is\nbest done with post-order traversal, use C<callbackback>.\nC<walk_down> is even the basis for plenty of the methods in this\nclass.  See the source code for examples both simple and horrific.\n\nNote that if you don't specify C<_depth>, it effectively defaults to\n0.  You should set it to scalar($node->ancestors) if you want\nC<_depth> to reflect the true depth-in-the-tree for the nodes called,\ninstead of just the depth below $node.  (If $node is the root, there's\ndifference, of course.)\n\nAnd B<by the way>, it's a bad idea to modify the tree from the callback.\nUnpredictable things may happen.  I instead suggest having your callback\nadd to a stack of things that need changing, and then, once C<walk_down>\nis all finished, changing those nodes from that stack.\n\nNote that the existence of C<walk_down> doesn't mean you can't write\nyou own special-use traversers.\n\n\nsub walk_down {\n  my($this, $o) = @_[0,1];\n\n  # All the can()s are in case an object changes class while I'm\n  # looking at it.\n\n  Carp::croak \"I need options!\" unless ref($o);\n  Carp::croak \"I need a callback or a callbackback\" unless\n    ( ref($o->{'callback'}) || ref($o->{'callbackback'}) );\n\n  # $this->no_cyclicity;\n  my $callback = ref($o->{'callback'}) ? $o->{'callback'} : undef;\n  my $callbackback = ref($o->{'callbackback'}) ? $o->{'callbackback'} : undef;\n  my $callback_status = 1;\n\n  print \"Callback: $callback   Callbackback: $callbackback\\n\" if $Debug;\n\n  printf \"* Entering %s\\n\", ($this->name || $this) if $Debug;\n  $callback_status = &{ $callback }( $this, $o ) if $callback;\n\n  if($callback_status) {\n    # Keep recursing unless callback returned false... and if there's\n    # anything to recurse into, of course.\n    my @daughters = UNIVERSAL::can($this, 'is_node') ? @{$this->{'daughters'}} : ();\n    if(@daughters) {\n      $o->{'_depth'} += 1;\n      #print \"Depth \" , $o->{'_depth'}, \"\\n\";\n      foreach my $one (@daughters) {\n        $one->walk_down($o) if UNIVERSAL::can($one, 'is_node');\n        # and if it can do \"is_node\", it should provide a walk_down!\n      }\n      $o->{'_depth'} -= 1;\n    }\n  } else {\n    printf \"* Recursing below %s pruned\\n\", ($this->name || $this) if $Debug;\n  }\n\n  # Note that $callback_status doesn't block callbackback from being called\n  if($callbackback){\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      print \"* Calling callbackback\\n\" if $Debug;\n      scalar( &{ $callbackback }( $this, $o ) );\n      # scalar to give it the same context as callback\n    } else {\n      print \"* Can't call callbackback -- $this isn't a node anymore\\n\"\n        if $Debug;\n    }\n  }\n  if($Debug) {\n    if(UNIVERSAL::can($this, 'is_node')) { # if it's still a node!\n      printf \"* Leaving %s\\n\", ($this->name || $this)\n    } else {\n      print \"* Leaving [no longer a node]\\n\";\n    }\n  }\n  return;\n}\n\n###########################################################################\n\n* @lines = $node->dump_names({ ...options... });\n\nDumps, as an indented list, the names of the nodes starting at $node,\nand continuing under it.  Options are:\n\n* _depth -- A nonnegative number.  Indicating the depth to consider\n$node as being at (and so the generation under that is that plus one,\netc.).  Defaults to 0.  You may choose to use set _depth =>\nscalar($node->ancestors).\n\n* tick -- a string to preface each entry with, between the\nindenting-spacing and the node's name.  Defaults to empty-string.  You\nmay prefer \"*\" or \"-> \" or someting.\n\n* indent -- the string used to indent with.  Defaults to \"  \" (two\nspaces).  Another sane value might be \". \" (period, space).  Setting it\nto empty-string suppresses indenting.\n\nThe dump is not printed, but is returned as a list, where each\nitem is a line, with a \"\\n\" at the end.\n\n\nsub dump_names {\n  my($it, $o) = @_[0,1];\n  $o = {} unless ref $o;\n  my @out = ();\n  $o->{'_depth'} ||= 0;\n  $o->{'indent'} ||= '  ';\n  $o->{'tick'} ||= '';\n\n  $o->{'callback'} = sub {\n      my($this, $o) = @_[0,1];\n      push(@out,\n        join('',\n             $o->{'indent'} x $o->{'_depth'},\n             $o->{'tick'},\n             &Tree::DAG_Node::_dump_quote($this->name || $this),\n             \"\\n\"\n        )\n      );      \n      return 1;\n    }\n  ;\n  $it->walk_down($o);\n  return @out;\n}\n\n###########################################################################\n###########################################################################\n\n* the constructor CLASS->random_network({...options...})\n\n* the method $node->random_network({...options...})\n\nIn the first case, constructs a randomly arranged network under a new\nnode, and returns the root node of that tree.  In the latter case,\nconstructs the network under $node.\n\nCurrently, this is implemented a bit half-heartedly, and\nhalf-wittedly.  I basically needed to make up random-looking networks\nto stress-test the various tree-dumper methods, and so wrote this.  If\nyou actually want to rely on this for any application more\nserious than that, I suggest examining the source code and seeing if\nthis does really what you need (say, in reliability of randomness);\nand feel totally free to suggest changes to me (especially in the form\nof \"I rewrote C<random_network>, here's the code...\")\n\nIt takes four options:\n\n* max_node_count -- maximum number of nodes this tree will be allowed\nto have (counting the root).  Defaults to 25.\n\n* min_depth -- minimum depth for the tree.  Defaults to 2.  Leaves can\nbe generated only after this depth is reached, so the tree will be at\nleast this deep -- unless max_node_count is hit first.\n\n* max_depth -- maximum depth for the tree.  Defaults to 3 plus\nmin_depth.  The tree will not be deeper than this.\n\n* max_children -- maximum number of children any mother in the tree\ncan have.  Defaults to 4.\n\n\nsub random_network { # constructor or method.\n  my $class = $_[0];\n  my $o = ref($_[1]) ? $_[1] : {};\n  my $am_cons = 0;\n  my $root;\n\n  if(ref($class)){ # I'm a method.\n    $root = $_[0]; # build under the given node, from same class.\n    $class = ref $class;\n    $am_cons = 0;\n  } else { # I'm a constructor\n    $root = $class->new; # build under a new node, with class named.\n    $root->name(\"Root\");\n    $am_cons = 1;\n  }\n\n  my $min_depth = $o->{'min_depth'} || 2;\n  my $max_depth = $o->{'max_depth'} || ($min_depth + 3);\n  my $max_children = $o->{'max_children'} || 4;\n  my $max_node_count = $o->{'max_node_count'} || 25;\n\n  Carp::croak \"max_children has to be positive\" if int($max_children) < 1;\n\n  my @mothers = ( $root );\n  my @children = ( );\n  my $node_count = 1; # the root\n\n Gen:\n  foreach my $depth (1 .. $max_depth) {\n    last if $node_count > $max_node_count;\n   Mother:\n    foreach my $mother (@mothers) {\n      last Gen if $node_count > $max_node_count;\n      my $children_number;    \n      if($depth <= $min_depth) {\n        until( $children_number = int(rand(1 + $max_children)) ) {}\n      } else {\n        $children_number = int(rand($max_children));\n      }\n     Beget:\n      foreach (1 .. $children_number) {\n        last Gen if $node_count > $max_node_count;\n        my $node = $mother->new_daughter;\n        $node->name(\"Node$node_count\");\n        ++$node_count;\n        push(@children, $node);\n      }\n    }\n    @mothers = @children;\n    @children = ();\n    last unless @mothers;\n  }\n\n  return $root;\n}\n\n* the constructor CLASS->lol_to_tree($lol);\n\nConverts something like bracket-notation for \"Chomsky trees\" (or\nrather, the closest you can come with Perl\nlist-of-lists(-of-lists(-of-lists))) into a tree structure.  Returns\nthe root of the tree converted.\n\nThe conversion rules are that:  1) if the last (possibly the only) item\nin a given list is a scalar, then that is used as the \"name\" attribute\nfor the node based on this list.  2) All other items in the list\nrepresent daughter nodes of the current node -- recursively so, if\nthey are list references; otherwise, (non-terminal) scalars are\nconsidered to denote nodes with that name.  So ['Foo', 'Bar', 'N'] is\nan alternate way to represent [['Foo'], ['Bar'], 'N'].\n\nAn example will illustrate:\n\n  use Tree::DAG_Node;\n  $lol =\n    [\n      [\n        [ [ 'Det:The' ],\n          [ [ 'dog' ], 'N'], 'NP'],\n        [ '/with rabies\\\\', 'PP'],\n        'NP'\n      ],\n      [ 'died', 'VP'],\n      'S'\n    ];\n   $tree = Tree::DAG_Node->lol_to_tree($lol);\n   $diagram = $tree->draw_ascii_tree;\n   print map \"$_\\n\", @$diagram;\n\n...returns this tree:\n\n                   |                   \n                  <S>                  \n                   |                   \n                /------------------\\   \n                |                  |   \n              <NP>                <VP> \n                |                  |   \n        /---------------\\        <died>\n        |               |              \n      <NP>            <PP>             \n        |               |              \n     /-------\\   </with rabies\\>       \n     |       |                         \n <Det:The>  <N>                        \n             |                         \n           <dog>                       \n\nBy the way (and this rather follows from the above rules), when\ndenoting a LoL tree consisting of just one node, this:\n\n  $tree = Tree::DAG_Node->lol_to_tree( 'Lonely' );\n\nis okay, although it'd probably occur to you to denote it only as:\n\n  $tree = Tree::DAG_Node->lol_to_tree( ['Lonely'] );\n\nwhich is of course fine, too.\n\n\nsub lol_to_tree {\n  my($class, $lol, $seen_r) = @_[0,1,2];\n  $seen_r = {} unless ref($seen_r) eq 'HASH';\n  return if ref($lol) && $seen_r->{$lol}++; # catch circularity\n\n  $class = ref($class) || $class;\n  my $node = $class->new();\n\n  unless(ref($lol) eq 'ARRAY') {  # It's a terminal node.\n    $node->name($lol) if defined $lol;\n    return $node;\n  }\n  return $node unless @$lol;  # It's a terminal node, oddly represented\n\n  #  It's a non-terminal node.\n\n  my @options = @$lol; \n  unless(ref($options[-1]) eq 'ARRAY') {\n    # This is what separates this method from simple_lol_to_tree\n    $node->name(pop(@options));\n  }\n\n  foreach my $d (@options) {  # Scan daughters (wh