{"vars":[{"line":112,"kind":2,"containerName":"","name":"base"},{"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":126},{"name":"@args","containerName":"new","kind":13,"line":126},{"kind":13,"line":127,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$class","line":127,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":127},{"localvar":"my","name":"$id","definition":"my","containerName":"new","line":129,"kind":13},{"line":129,"kind":13,"containerName":"new","name":"$sysname"},{"name":"$trivname","containerName":"new","line":129,"kind":13},{"kind":13,"line":129,"name":"$chr","containerName":"new"},{"containerName":"new","name":"$gene_symbol","line":129,"kind":13},{"line":130,"kind":13,"containerName":"new","name":"$desc"},{"containerName":"new","name":"$alphabet","kind":13,"line":130},{"containerName":"new","name":"$numbering","kind":13,"line":130},{"kind":13,"line":130,"containerName":"new","name":"$offset"},{"kind":13,"line":130,"name":"$rna_offset","containerName":"new"},{"name":"$rna_id","containerName":"new","kind":13,"line":130},{"line":130,"kind":13,"name":"$cds_end","containerName":"new"},{"line":131,"kind":13,"name":"$dna_ori","containerName":"new"},{"kind":13,"line":131,"name":"$dna_mut","containerName":"new"},{"line":131,"kind":13,"name":"$rna_ori","containerName":"new"},{"line":131,"kind":13,"name":"$rna_mut","containerName":"new"},{"containerName":"new","name":"$aa_ori","kind":13,"line":131},{"name":"$aa_mut","containerName":"new","kind":13,"line":132},{"kind":13,"line":134,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","line":134,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":152},{"line":156,"kind":13,"name":"$id","containerName":"new"},{"line":156,"kind":13,"containerName":"new","name":"$self"},{"name":"id","containerName":"new","kind":12,"line":156},{"name":"$id","containerName":"new","line":156,"kind":13},{"kind":13,"line":157,"containerName":"new","name":"$sysname"},{"containerName":"new","name":"$self","line":157,"kind":13},{"line":157,"kind":12,"name":"sysname","containerName":"new"},{"name":"$sysname","containerName":"new","kind":13,"line":157},{"line":158,"kind":13,"name":"$trivname","containerName":"new"},{"kind":13,"line":158,"containerName":"new","name":"$self"},{"line":158,"kind":12,"containerName":"new","name":"trivname"},{"containerName":"new","name":"$trivname","line":158,"kind":13},{"containerName":"new","name":"$chr","line":159,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":159},{"name":"chromosome","containerName":"new","kind":12,"line":159},{"kind":13,"line":159,"name":"$chr","containerName":"new"},{"line":160,"kind":13,"name":"$gene_symbol","containerName":"new"},{"kind":13,"line":160,"containerName":"new","name":"$self"},{"containerName":"new","name":"gene_symbol","kind":12,"line":160},{"containerName":"new","name":"$chr","line":160,"kind":13},{"kind":13,"line":161,"containerName":"new","name":"$desc"},{"containerName":"new","name":"$self","line":161,"kind":13},{"line":161,"kind":12,"containerName":"new","name":"description"},{"line":161,"kind":13,"containerName":"new","name":"$desc"},{"line":162,"kind":13,"name":"$alphabet","containerName":"new"},{"line":162,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"alphabet","line":162,"kind":12},{"line":162,"kind":13,"containerName":"new","name":"$alphabet"},{"line":163,"kind":13,"name":"$numbering","containerName":"new"},{"kind":13,"line":163,"containerName":"new","name":"$self"},{"kind":12,"line":163,"containerName":"new","name":"numbering"},{"line":163,"kind":13,"name":"$numbering","containerName":"new"},{"name":"$offset","containerName":"new","line":164,"kind":13},{"containerName":"new","name":"$self","line":164,"kind":13},{"containerName":"new","name":"offset","line":164,"kind":12},{"containerName":"new","name":"$offset","line":164,"kind":13},{"name":"$rna_offset","containerName":"new","kind":13,"line":165},{"containerName":"new","name":"$self","line":165,"kind":13},{"line":165,"kind":12,"name":"rna_offset","containerName":"new"},{"kind":13,"line":165,"name":"$rna_offset","containerName":"new"},{"line":166,"kind":13,"name":"$rna_id","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":166},{"name":"rna_id","containerName":"new","kind":12,"line":166},{"name":"$rna_id","containerName":"new","line":166,"kind":13},{"containerName":"new","name":"$cds_end","line":167,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":167},{"containerName":"new","name":"cds_end","kind":12,"line":167},{"line":167,"kind":13,"containerName":"new","name":"$cds_end"},{"containerName":"new","name":"$dna_ori","kind":13,"line":169},{"line":169,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"dna_ori","line":169,"kind":12},{"containerName":"new","name":"$dna_ori","kind":13,"line":169},{"name":"$dna_mut","containerName":"new","kind":13,"line":170},{"line":170,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":170,"containerName":"new","name":"dna_mut"},{"line":170,"kind":13,"name":"$dna_mut","containerName":"new"},{"name":"$rna_ori","containerName":"new","line":171,"kind":13},{"line":171,"kind":13,"name":"$self","containerName":"new"},{"name":"rna_ori","containerName":"new","kind":12,"line":171},{"name":"$rna_ori","containerName":"new","line":171,"kind":13},{"line":172,"kind":13,"containerName":"new","name":"$rna_mut"},{"line":172,"kind":13,"containerName":"new","name":"$self"},{"line":172,"kind":12,"name":"rna_mut","containerName":"new"},{"line":172,"kind":13,"containerName":"new","name":"$rna_mut"},{"kind":13,"line":173,"containerName":"new","name":"$aa_ori"},{"kind":13,"line":173,"containerName":"new","name":"$self"},{"containerName":"new","name":"aa_ori","kind":12,"line":173},{"name":"$aa_ori","containerName":"new","kind":13,"line":173},{"line":174,"kind":13,"name":"$aa_mut","containerName":"new"},{"kind":13,"line":174,"name":"$self","containerName":"new"},{"name":"aa_mut","containerName":"new","kind":12,"line":174},{"line":174,"kind":13,"name":"$aa_mut","containerName":"new"},{"line":176,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":179,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":182,"kind":13}],"line":125,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : ","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"start":{"line":125,"character":0},"end":{"line":183,"character":9999}},"name":"new"},{"line":127,"kind":12,"containerName":"new","name":"SUPER"},{"name":"id","range":{"start":{"line":203,"character":0},"end":{"line":211,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"id($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)"},"kind":12,"line":203,"children":[{"kind":13,"line":204,"name":"$self","definition":"my","containerName":"id","localvar":"my"},{"containerName":"id","name":"$value","kind":13,"line":204},{"name":"$value","containerName":"id","kind":13,"line":205},{"kind":13,"line":206,"name":"$self","containerName":"id"},{"line":206,"kind":13,"name":"$value","containerName":"id"},{"containerName":"id","name":"$self","line":209,"kind":13}]},{"kind":12,"line":233,"children":[{"kind":13,"line":234,"definition":"my","name":"$self","containerName":"sysname","localvar":"my"},{"kind":13,"line":234,"name":"$value","containerName":"sysname"},{"line":235,"kind":13,"containerName":"sysname","name":"$value"},{"name":"$self","containerName":"sysname","kind":13,"line":236},{"kind":13,"line":236,"name":"$value","containerName":"sysname"},{"containerName":"sysname","name":"$self","line":238,"kind":13},{"localvar":"my","name":"$sysname","definition":"my","containerName":"sysname","line":240,"kind":13},{"kind":13,"line":241,"definition":"my","name":"$c","containerName":"sysname","localvar":"my"},{"line":242,"kind":13,"localvar":"my","definition":"my","name":"$mut","containerName":"sysname"},{"line":242,"kind":13,"name":"$self","containerName":"sysname"},{"containerName":"sysname","name":"each_Variant","line":242,"kind":12},{"containerName":"sysname","name":"$mut","kind":13,"line":243},{"line":243,"kind":12,"containerName":"sysname","name":"isa"},{"name":"$c","containerName":"sysname","line":244,"kind":13},{"name":"$c","containerName":"sysname","kind":13,"line":245},{"kind":13,"line":246,"containerName":"sysname","name":"$sysname"},{"containerName":"sysname","name":"$mut","kind":13,"line":246},{"containerName":"sysname","name":"sysname","kind":12,"line":246},{"containerName":"sysname","name":"$sysname","line":249,"kind":13},{"containerName":"sysname","name":"$mut","kind":13,"line":249},{"containerName":"sysname","name":"sysname","kind":12,"line":249},{"kind":13,"line":253,"name":"$sysname","containerName":"sysname"},{"line":253,"kind":13,"containerName":"sysname","name":"$sysname"},{"line":253,"kind":13,"containerName":"sysname","name":"$c"},{"kind":13,"line":254,"name":"$self","containerName":"sysname"},{"line":254,"kind":13,"name":"$sysname","containerName":"sysname"},{"name":"$self","containerName":"sysname","kind":13,"line":256}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"sysname($self,$value)"},"name":"sysname","range":{"end":{"character":9999,"line":257},"start":{"character":0,"line":233}}},{"line":279,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"trivname","line":280,"kind":13},{"line":280,"kind":13,"containerName":"trivname","name":"$value"},{"kind":13,"line":281,"containerName":"trivname","name":"$value"},{"line":282,"kind":13,"name":"$self","containerName":"trivname"},{"containerName":"trivname","name":"$value","line":282,"kind":13},{"containerName":"trivname","name":"$self","kind":13,"line":284},{"kind":13,"line":286,"definition":"my","name":"$trivname","containerName":"trivname","localvar":"my"},{"kind":13,"line":287,"name":"$c","definition":"my","containerName":"trivname","localvar":"my"},{"kind":13,"line":288,"containerName":"trivname","definition":"my","name":"$mut","localvar":"my"},{"containerName":"trivname","name":"$self","kind":13,"line":288},{"name":"each_Variant","containerName":"trivname","kind":12,"line":288},{"containerName":"trivname","name":"$mut","line":289,"kind":13},{"kind":12,"line":289,"name":"isa","containerName":"trivname"},{"kind":13,"line":290,"name":"$c","containerName":"trivname"},{"containerName":"trivname","name":"$c","line":291,"kind":13},{"line":292,"kind":13,"containerName":"trivname","name":"$trivname"},{"containerName":"trivname","name":"$mut","kind":13,"line":292},{"kind":12,"line":292,"name":"trivname","containerName":"trivname"},{"line":295,"kind":13,"containerName":"trivname","name":"$trivname"},{"containerName":"trivname","name":"$mut","kind":13,"line":295},{"name":"trivname","containerName":"trivname","line":295,"kind":12},{"kind":13,"line":299,"name":"$trivname","containerName":"trivname"},{"name":"$trivname","containerName":"trivname","kind":13,"line":299},{"kind":13,"line":299,"name":"$c","containerName":"trivname"},{"containerName":"trivname","name":"$self","kind":13,"line":300},{"name":"$trivname","containerName":"trivname","line":300,"kind":13},{"line":304,"kind":13,"containerName":"trivname","name":"$self"}],"kind":12,"detail":"($self,$value)","signature":{"label":"trivname($self,$value)","documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":306,"character":9999},"start":{"line":279,"character":0}},"name":"trivname"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)","label":"chromosome($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":325,"kind":13,"localvar":"my","containerName":"chromosome","name":"$self","definition":"my"},{"kind":13,"line":325,"name":"$value","containerName":"chromosome"},{"name":"$value","containerName":"chromosome","kind":13,"line":326},{"containerName":"chromosome","name":"$self","line":327,"kind":13},{"line":327,"kind":13,"name":"$value","containerName":"chromosome"},{"name":"$self","containerName":"chromosome","kind":13,"line":330}],"line":324,"name":"chromosome","range":{"start":{"line":324,"character":0},"end":{"character":9999,"line":332}}},{"range":{"start":{"line":350,"character":0},"end":{"character":9999,"line":358}},"name":"gene_symbol","line":350,"children":[{"line":351,"kind":13,"localvar":"my","containerName":"gene_symbol","name":"$self","definition":"my"},{"line":351,"kind":13,"containerName":"gene_symbol","name":"$value"},{"containerName":"gene_symbol","name":"$value","kind":13,"line":352},{"containerName":"gene_symbol","name":"$self","line":353,"kind":13},{"kind":13,"line":353,"containerName":"gene_symbol","name":"$value"},{"kind":13,"line":356,"name":"$self","containerName":"gene_symbol"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)","label":"gene_symbol($self,$value)"},"containerName":"main::","definition":"sub"},{"range":{"end":{"line":385,"character":9999},"start":{"line":377,"character":0}},"name":"description","detail":"($self,$value)","signature":{"label":"description($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)"},"containerName":"main::","definition":"sub","line":377,"children":[{"kind":13,"line":378,"definition":"my","name":"$self","containerName":"description","localvar":"my"},{"kind":13,"line":378,"name":"$value","containerName":"description"},{"line":379,"kind":13,"containerName":"description","name":"$value"},{"line":380,"kind":13,"name":"$self","containerName":"description"},{"line":380,"kind":13,"containerName":"description","name":"$value"},{"kind":13,"line":383,"containerName":"description","name":"$self"}],"kind":12},{"range":{"end":{"character":9999,"line":414},"start":{"character":0,"line":401}},"name":"alphabet","line":401,"children":[{"line":402,"kind":13,"localvar":"my","containerName":"alphabet","name":"$self","definition":"my"},{"name":"$value","containerName":"alphabet","kind":13,"line":402},{"localvar":"my","containerName":"alphabet","definition":"my","name":"%type","line":403,"kind":13},{"line":406,"kind":13,"containerName":"alphabet","name":"$value"},{"containerName":"alphabet","name":"$type","line":407,"kind":13},{"name":"$value","containerName":"alphabet","kind":13,"line":407},{"kind":13,"line":408,"name":"$self","containerName":"alphabet"},{"name":"$value","containerName":"alphabet","line":408,"kind":13},{"kind":13,"line":410,"name":"$self","containerName":"alphabet"},{"line":410,"kind":12,"containerName":"alphabet","name":"throw"},{"kind":13,"line":413,"containerName":"alphabet","name":"$self"}],"kind":12,"detail":"($self,$value)","signature":{"label":"alphabet($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none"},"containerName":"main::","definition":"sub"},{"name":"dna","line":403,"kind":12},{"kind":12,"line":404,"name":"rna"},{"name":"protein","line":405,"kind":12},{"line":434,"children":[{"line":435,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"numbering"},{"name":"$value","containerName":"numbering","line":435,"kind":13},{"name":"$value","containerName":"numbering","kind":13,"line":436},{"containerName":"numbering","name":"$self","kind":13,"line":437},{"kind":13,"line":437,"containerName":"numbering","name":"$value"},{"name":"$self","containerName":"numbering","line":440,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"label":"numbering($self,$value)","documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":442},"start":{"character":0,"line":434}},"name":"numbering"},{"name":"offset","range":{"start":{"character":0,"line":464},"end":{"character":9999,"line":475}},"kind":12,"line":464,"children":[{"line":465,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"offset"},{"containerName":"offset","name":"$value","line":465,"kind":13},{"containerName":"offset","name":"$value","kind":13,"line":466},{"kind":13,"line":467,"name":"$self","containerName":"offset"},{"name":"$value","containerName":"offset","line":467,"kind":13},{"kind":13,"line":469,"name":"$self","containerName":"offset"},{"line":470,"kind":13,"containerName":"offset","name":"$self"},{"name":"$self","containerName":"offset","kind":13,"line":473}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"offset($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)"}},{"kind":12,"children":[{"kind":13,"line":498,"definition":"my","name":"$self","containerName":"cds_start","localvar":"my"},{"name":"$value","containerName":"cds_start","kind":13,"line":498},{"kind":13,"line":499,"name":"$value","containerName":"cds_start"},{"line":500,"kind":13,"containerName":"cds_start","name":"$self"},{"name":"$value","containerName":"cds_start","line":500,"kind":13},{"name":"$self","containerName":"cds_start","kind":13,"line":503}],"line":497,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)","label":"cds_start($self,$value)"},"detail":"($self,$value)","name":"cds_start","range":{"start":{"character":0,"line":497},"end":{"line":505,"character":9999}}},{"name":"cds_end","range":{"start":{"character":0,"line":525},"end":{"line":534,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"cds_end($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)"},"detail":"($self,$value)","kind":12,"children":[{"line":526,"kind":13,"localvar":"my","containerName":"cds_end","definition":"my","name":"$self"},{"containerName":"cds_end","name":"$value","kind":13,"line":526},{"containerName":"cds_end","name":"$value","line":527,"kind":13},{"kind":13,"line":528,"name":"$self","containerName":"cds_end"},{"name":"$value","containerName":"cds_end","line":528,"kind":13},{"name":"$self","containerName":"cds_end","kind":13,"line":531}],"line":525},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"rna_offset($self,$value)"},"kind":12,"line":555,"children":[{"containerName":"rna_offset","name":"$self","definition":"my","localvar":"my","kind":13,"line":556},{"name":"$value","containerName":"rna_offset","line":556,"kind":13},{"kind":13,"line":557,"containerName":"rna_offset","name":"$value"},{"line":558,"kind":13,"containerName":"rna_offset","name":"$self"},{"line":558,"kind":13,"name":"$value","containerName":"rna_offset"},{"name":"$self","containerName":"rna_offset","kind":13,"line":560},{"name":"$self","containerName":"rna_offset","line":561,"kind":13},{"kind":13,"line":564,"containerName":"rna_offset","name":"$self"}],"name":"rna_offset","range":{"end":{"line":566,"character":9999},"start":{"character":0,"line":555}}},{"line":584,"children":[{"line":585,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"rna_id"},{"kind":13,"line":585,"containerName":"rna_id","name":"$value"},{"name":"$value","containerName":"rna_id","kind":13,"line":586},{"line":587,"kind":13,"name":"$self","containerName":"rna_id"},{"line":587,"kind":13,"name":"$value","containerName":"rna_id"},{"name":"$self","containerName":"rna_id","line":590,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)","label":"rna_id($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"line":592,"character":9999},"start":{"line":584,"character":0}},"name":"rna_id"},{"definition":"sub","containerName":"main::","signature":{"label":"add_Variant($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object"},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":613,"name":"$self","definition":"my","containerName":"add_Variant","localvar":"my"},{"line":613,"kind":13,"name":"$value","containerName":"add_Variant"},{"containerName":"add_Variant","name":"$value","line":614,"kind":13},{"kind":13,"line":615,"containerName":"add_Variant","name":"$value"},{"line":615,"kind":12,"containerName":"add_Variant","name":"isa"},{"containerName":"add_Variant","name":"$self","kind":13,"line":616},{"name":"throw","containerName":"add_Variant","line":616,"kind":12},{"line":620,"kind":13,"containerName":"add_Variant","name":"$self"},{"containerName":"add_Variant","name":"$value","line":620,"kind":13},{"name":"$value","containerName":"add_Variant","kind":13,"line":621},{"name":"SeqDiff","containerName":"add_Variant","line":621,"kind":12},{"name":"$self","containerName":"add_Variant","kind":13,"line":621}],"line":612,"name":"add_Variant","range":{"start":{"line":612,"character":0},"end":{"character":9999,"line":624}}},{"range":{"end":{"line":648,"character":9999},"start":{"line":645,"character":0}},"name":"each_Variant","line":645,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"each_Variant","line":646,"kind":13},{"line":646,"kind":13,"name":"@args","containerName":"each_Variant"},{"kind":13,"line":648,"containerName":"each_Variant","name":"$self"}],"kind":12,"detail":"($self,@args)","signature":{"label":"each_Variant($self,@args)","documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"kind":12,"children":[{"line":671,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"add_Gene"},{"line":671,"kind":13,"containerName":"add_Gene","name":"$value"},{"name":"$value","containerName":"add_Gene","kind":13,"line":672},{"containerName":"add_Gene","name":"$value","line":673,"kind":13},{"containerName":"add_Gene","name":"isa","kind":12,"line":673},{"kind":13,"line":674,"containerName":"add_Gene","name":"$value"},{"kind":12,"line":674,"name":"throw","containerName":"add_Gene"},{"line":678,"kind":13,"name":"$self","containerName":"add_Gene"},{"line":678,"kind":13,"containerName":"add_Gene","name":"$value"}],"line":670,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.","label":"add_Gene($self,$value)"},"detail":"($self,$value)","name":"add_Gene","range":{"end":{"line":681,"character":9999},"start":{"character":0,"line":670}}},{"kind":12,"children":[{"kind":13,"line":703,"containerName":"each_Gene","name":"$self","definition":"my","localvar":"my"},{"containerName":"each_Gene","name":"@args","kind":13,"line":703},{"line":705,"kind":13,"name":"$self","containerName":"each_Gene"}],"line":702,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none","label":"each_Gene($self,@args)"},"detail":"($self,@args)","name":"each_Gene","range":{"end":{"line":705,"character":9999},"start":{"character":0,"line":702}}},{"children":[{"localvar":"my","containerName":"dna_ori","name":"$self","definition":"my","line":725,"kind":13},{"containerName":"dna_ori","name":"$value","kind":13,"line":725},{"name":"$value","containerName":"dna_ori","kind":13,"line":726},{"line":727,"kind":13,"containerName":"dna_ori","name":"$self"},{"name":"$value","containerName":"dna_ori","line":727,"kind":13},{"containerName":"dna_ori","name":"$self","kind":13,"line":730}],"line":724,"kind":12,"signature":{"label":"dna_ori($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none\n\n\nsub each_Gene{\n   my ($self,@args) = @_;\n\n   return @{$self->{'genes'}}; \n}\n\n\n=head2 dna_ori\n\n Title   : dna_ori\n Usage   : $obj->dna_ori('atgctgctgctgct'); $dna_ori = $obj->dna_ori();\n Function: \n\n\t    Sets or returns the original DNA sequence string of the seqDiff.\n\n Example : \n Returns : value of dna_ori, a scalar\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":732},"start":{"character":0,"line":724}},"name":"dna_ori"},{"range":{"end":{"line":761,"character":9999},"start":{"line":752,"character":0}},"name":"dna_mut","children":[{"line":753,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"dna_mut"},{"containerName":"dna_mut","name":"$value","kind":13,"line":753},{"line":754,"kind":13,"name":"$value","containerName":"dna_mut"},{"name":"$self","containerName":"dna_mut","kind":13,"line":755},{"containerName":"dna_mut","name":"$value","kind":13,"line":755},{"kind":13,"line":758,"containerName":"dna_mut","name":"$self"},{"line":758,"kind":12,"containerName":"dna_mut","name":"_set_dnamut"},{"name":"$self","containerName":"dna_mut","kind":13,"line":758},{"line":759,"kind":13,"containerName":"dna_mut","name":"$self"}],"line":752,"kind":12,"signature":{"label":"dna_mut($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none\n\n\nsub each_Gene{\n   my ($self,@args) = @_;\n\n   return @{$self->{'genes'}}; \n}\n\n\n=head2 dna_ori\n\n Title   : dna_ori\n Usage   : $obj->dna_ori('atgctgctgctgct'); $dna_ori = $obj->dna_ori();\n Function: \n\n\t    Sets or returns the original DNA sequence string of the seqDiff.\n\n Example : \n Returns : value of dna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_ori'} = $value;\n  }\n  else {\n      return $self->{'dna_ori'};\n  }\n}\n\n\n=head2 dna_mut\n\n Title   : dna_mut\n Usage   : $obj->dna_mut('atgctggtgctgct'); $dna_mut = $obj->dna_mut();\n Function: \n\n\t    Sets or returns the mutated DNA sequence of the seqDiff.\n            If sequence has not been set generates it from the\n            original sequence and DNA mutations.\n\n Example : \n Returns : value of dna_mut, a scalar\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"range":{"end":{"line":801,"character":9999},"start":{"character":0,"line":763}},"containerName":"main::","name":"_set_dnamut","definition":"sub","line":763,"children":[{"kind":13,"line":764,"containerName":"_set_dnamut","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"_set_dnamut","kind":13,"line":766},{"kind":13,"line":766,"name":"$self","containerName":"_set_dnamut"},{"containerName":"_set_dnamut","name":"each_Variant","line":766,"kind":12},{"containerName":"_set_dnamut","name":"$self","line":768,"kind":13},{"line":768,"kind":13,"name":"$self","containerName":"_set_dnamut"},{"kind":13,"line":769,"containerName":"_set_dnamut","name":"$self"},{"kind":12,"line":769,"containerName":"_set_dnamut","name":"each_Variant"},{"name":"isa","containerName":"_set_dnamut","kind":12,"line":770},{"line":771,"kind":12,"name":"isMutation","containerName":"_set_dnamut"},{"containerName":"_set_dnamut","definition":"my","name":"$s","localvar":"my","kind":13,"line":773},{"name":"$la","containerName":"_set_dnamut","kind":13,"line":773},{"line":773,"kind":13,"containerName":"_set_dnamut","name":"$le"},{"kind":12,"line":775,"containerName":"_set_dnamut","name":"start"},{"name":"$s","containerName":"_set_dnamut","kind":13,"line":776},{"line":776,"kind":13,"name":"$la","containerName":"_set_dnamut"},{"kind":12,"line":776,"name":"start","containerName":"_set_dnamut"},{"kind":13,"line":778,"name":"$s","containerName":"_set_dnamut"},{"line":778,"kind":12,"name":"start","containerName":"_set_dnamut"},{"containerName":"_set_dnamut","name":"$la","line":778,"kind":13},{"containerName":"_set_dnamut","name":"end","kind":12,"line":782},{"kind":12,"line":782,"name":"start","containerName":"_set_dnamut"},{"containerName":"_set_dnamut","name":"allele_ori","line":782,"kind":12},{"name":"seq","containerName":"_set_dnamut","line":782,"kind":12},{"line":786,"kind":12,"name":"end","containerName":"_set_dnamut"},{"containerName":"_set_dnamut","name":"$self","kind":13,"line":786},{"name":"$le","containerName":"_set_dnamut","line":787,"kind":13},{"line":787,"kind":13,"containerName":"_set_dnamut","name":"$self"},{"kind":12,"line":787,"name":"end","containerName":"_set_dnamut"},{"kind":13,"line":789,"containerName":"_set_dnamut","name":"$le"},{"kind":12,"line":792,"containerName":"_set_dnamut","name":"dnStreamSeq"},{"name":"$self","containerName":"_set_dnamut","kind":13,"line":792},{"line":792,"kind":13,"name":"$s","containerName":"_set_dnamut"},{"name":"$la","containerName":"_set_dnamut","line":792,"kind":13},{"containerName":"_set_dnamut","name":"upStreamSeq","line":793,"kind":12},{"containerName":"_set_dnamut","name":"$self","kind":13,"line":793},{"line":793,"kind":12,"containerName":"_set_dnamut","name":"end"},{"containerName":"_set_dnamut","name":"$le","kind":13,"line":793},{"line":795,"kind":13,"localvar":"my","name":"$s_ori","definition":"my","containerName":"_set_dnamut"},{"name":"dnStreamSeq","containerName":"_set_dnamut","line":795,"kind":12},{"containerName":"_set_dnamut","name":"allele_ori","kind":12,"line":795},{"containerName":"_set_dnamut","name":"seq","line":795,"kind":12},{"line":795,"kind":12,"containerName":"_set_dnamut","name":"upStreamSeq"},{"line":796,"kind":13,"localvar":"my","containerName":"_set_dnamut","name":"$s_mut","definition":"my"},{"kind":12,"line":796,"containerName":"_set_dnamut","name":"dnStreamSeq"},{"name":"allele_mut","containerName":"_set_dnamut","kind":12,"line":796},{"containerName":"_set_dnamut","name":"seq","kind":12,"line":796},{"containerName":"_set_dnamut","name":"upStreamSeq","line":796,"kind":12},{"localvar":"my","containerName":"_set_dnamut","name":"$str","definition":"my","line":798,"kind":13},{"name":"$self","containerName":"_set_dnamut","kind":13,"line":798},{"kind":13,"line":799,"containerName":"_set_dnamut","name":"$self"},{"line":799,"kind":13,"containerName":"_set_dnamut","name":"$str"}],"kind":12},{"name":"rna_ori","range":{"start":{"character":0,"line":819},"end":{"line":827,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"rna_ori($self,$value)","documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none\n\n\nsub each_Gene{\n   my ($self,@args) = @_;\n\n   return @{$self->{'genes'}}; \n}\n\n\n=head2 dna_ori\n\n Title   : dna_ori\n Usage   : $obj->dna_ori('atgctgctgctgct'); $dna_ori = $obj->dna_ori();\n Function: \n\n\t    Sets or returns the original DNA sequence string of the seqDiff.\n\n Example : \n Returns : value of dna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_ori'} = $value;\n  }\n  else {\n      return $self->{'dna_ori'};\n  }\n}\n\n\n=head2 dna_mut\n\n Title   : dna_mut\n Usage   : $obj->dna_mut('atgctggtgctgct'); $dna_mut = $obj->dna_mut();\n Function: \n\n\t    Sets or returns the mutated DNA sequence of the seqDiff.\n            If sequence has not been set generates it from the\n            original sequence and DNA mutations.\n\n Example : \n Returns : value of dna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_mut'} = $value;\n  }\n  else {\n      $self->_set_dnamut() unless $self->{'dna_mut'};\n      return $self->{'dna_mut'};\n  }\n}\n\nsub _set_dnamut {\n    my $self = shift;\n\n    return unless $self->{'dna_ori'}  && $self->each_Variant;\n\n    $self->{'dna_mut'} = $self->{'dna_ori'};\n    foreach ($self->each_Variant) {\n\tnext unless $_->isa('Bio::Variation::DNAMutation');\n\tnext unless $_->isMutation;\n\n\tmy ($s, $la, $le);\n\t#lies the mutation less than 25 bases after the start of sequence?\n\tif ($_->start < 25) {\n\t    $s = 0; $la = $_->start - 1;\n\t} else {\n\t    $s = $_->start - 25; $la = 25;\n\t}\n\n\t#is the mutation an insertion?\n\t$_->end($_->start) unless $_->allele_ori->seq;\n\n\t#does the mutation end greater than 25 bases before the end of\n\t#sequence?\n\tif (($_->end + 25) > length($self->{'dna_mut'})) {\n\t    $le = length($self->{'dna_mut'}) - $_->end;\n\t} else {\n\t    $le = 25;\n\t}\n\n\t$_->dnStreamSeq(substr($self->{'dna_mut'}, $s, $la));\n\t$_->upStreamSeq(substr($self->{'dna_mut'}, $_->end, $le));\n\n\tmy $s_ori = $_->dnStreamSeq . $_->allele_ori->seq . $_->upStreamSeq;\n\tmy $s_mut = $_->dnStreamSeq . $_->allele_mut->seq . $_->upStreamSeq;\n\n\t(my $str = $self->{'dna_mut'}) =~ s/$s_ori/$s_mut/;\n\t$self->{'dna_mut'} = $str;\n    }\n}\n\n\n=head2 rna_ori\n\n Title   : rna_ori\n Usage   : $obj->rna_ori('atgctgctgctgct'); $rna_ori = $obj->rna_ori();\n Function: \n\n\t    Sets or returns the original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_ori, a scalar\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"containerName":"rna_ori","name":"$self","definition":"my","localvar":"my","kind":13,"line":820},{"kind":13,"line":820,"containerName":"rna_ori","name":"$value"},{"kind":13,"line":821,"containerName":"rna_ori","name":"$value"},{"name":"$self","containerName":"rna_ori","kind":13,"line":822},{"kind":13,"line":822,"name":"$value","containerName":"rna_ori"},{"kind":13,"line":825,"name":"$self","containerName":"rna_ori"}],"line":819},{"range":{"start":{"character":0,"line":845},"end":{"character":9999,"line":853}},"name":"rna_mut","line":845,"children":[{"kind":13,"line":846,"containerName":"rna_mut","name":"$self","definition":"my","localvar":"my"},{"line":846,"kind":13,"containerName":"rna_mut","name":"$value"},{"kind":13,"line":847,"name":"$value","containerName":"rna_mut"},{"kind":13,"line":848,"name":"$self","containerName":"rna_mut"},{"name":"$value","containerName":"rna_mut","kind":13,"line":848},{"line":851,"kind":13,"name":"$self","containerName":"rna_mut"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none\n\n\nsub each_Gene{\n   my ($self,@args) = @_;\n\n   return @{$self->{'genes'}}; \n}\n\n\n=head2 dna_ori\n\n Title   : dna_ori\n Usage   : $obj->dna_ori('atgctgctgctgct'); $dna_ori = $obj->dna_ori();\n Function: \n\n\t    Sets or returns the original DNA sequence string of the seqDiff.\n\n Example : \n Returns : value of dna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_ori'} = $value;\n  }\n  else {\n      return $self->{'dna_ori'};\n  }\n}\n\n\n=head2 dna_mut\n\n Title   : dna_mut\n Usage   : $obj->dna_mut('atgctggtgctgct'); $dna_mut = $obj->dna_mut();\n Function: \n\n\t    Sets or returns the mutated DNA sequence of the seqDiff.\n            If sequence has not been set generates it from the\n            original sequence and DNA mutations.\n\n Example : \n Returns : value of dna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_mut'} = $value;\n  }\n  else {\n      $self->_set_dnamut() unless $self->{'dna_mut'};\n      return $self->{'dna_mut'};\n  }\n}\n\nsub _set_dnamut {\n    my $self = shift;\n\n    return unless $self->{'dna_ori'}  && $self->each_Variant;\n\n    $self->{'dna_mut'} = $self->{'dna_ori'};\n    foreach ($self->each_Variant) {\n\tnext unless $_->isa('Bio::Variation::DNAMutation');\n\tnext unless $_->isMutation;\n\n\tmy ($s, $la, $le);\n\t#lies the mutation less than 25 bases after the start of sequence?\n\tif ($_->start < 25) {\n\t    $s = 0; $la = $_->start - 1;\n\t} else {\n\t    $s = $_->start - 25; $la = 25;\n\t}\n\n\t#is the mutation an insertion?\n\t$_->end($_->start) unless $_->allele_ori->seq;\n\n\t#does the mutation end greater than 25 bases before the end of\n\t#sequence?\n\tif (($_->end + 25) > length($self->{'dna_mut'})) {\n\t    $le = length($self->{'dna_mut'}) - $_->end;\n\t} else {\n\t    $le = 25;\n\t}\n\n\t$_->dnStreamSeq(substr($self->{'dna_mut'}, $s, $la));\n\t$_->upStreamSeq(substr($self->{'dna_mut'}, $_->end, $le));\n\n\tmy $s_ori = $_->dnStreamSeq . $_->allele_ori->seq . $_->upStreamSeq;\n\tmy $s_mut = $_->dnStreamSeq . $_->allele_mut->seq . $_->upStreamSeq;\n\n\t(my $str = $self->{'dna_mut'}) =~ s/$s_ori/$s_mut/;\n\t$self->{'dna_mut'} = $str;\n    }\n}\n\n\n=head2 rna_ori\n\n Title   : rna_ori\n Usage   : $obj->rna_ori('atgctgctgctgct'); $rna_ori = $obj->rna_ori();\n Function: \n\n\t    Sets or returns the original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_ori'} = $value;\n  }\n  else {\n      return $self->{'rna_ori'};\n  }\n}\n\n\n=head2 rna_mut\n\n Title   : rna_mut\n Usage   : $obj->rna_mut('atgctggtgctgct'); $rna_mut = $obj->rna_mut();\n Function: \n\n\t    Sets or returns the mutated RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_mut, a scalar\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"rna_mut($self,$value)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none\n\n\nsub each_Gene{\n   my ($self,@args) = @_;\n\n   return @{$self->{'genes'}}; \n}\n\n\n=head2 dna_ori\n\n Title   : dna_ori\n Usage   : $obj->dna_ori('atgctgctgctgct'); $dna_ori = $obj->dna_ori();\n Function: \n\n\t    Sets or returns the original DNA sequence string of the seqDiff.\n\n Example : \n Returns : value of dna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_ori'} = $value;\n  }\n  else {\n      return $self->{'dna_ori'};\n  }\n}\n\n\n=head2 dna_mut\n\n Title   : dna_mut\n Usage   : $obj->dna_mut('atgctggtgctgct'); $dna_mut = $obj->dna_mut();\n Function: \n\n\t    Sets or returns the mutated DNA sequence of the seqDiff.\n            If sequence has not been set generates it from the\n            original sequence and DNA mutations.\n\n Example : \n Returns : value of dna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_mut'} = $value;\n  }\n  else {\n      $self->_set_dnamut() unless $self->{'dna_mut'};\n      return $self->{'dna_mut'};\n  }\n}\n\nsub _set_dnamut {\n    my $self = shift;\n\n    return unless $self->{'dna_ori'}  && $self->each_Variant;\n\n    $self->{'dna_mut'} = $self->{'dna_ori'};\n    foreach ($self->each_Variant) {\n\tnext unless $_->isa('Bio::Variation::DNAMutation');\n\tnext unless $_->isMutation;\n\n\tmy ($s, $la, $le);\n\t#lies the mutation less than 25 bases after the start of sequence?\n\tif ($_->start < 25) {\n\t    $s = 0; $la = $_->start - 1;\n\t} else {\n\t    $s = $_->start - 25; $la = 25;\n\t}\n\n\t#is the mutation an insertion?\n\t$_->end($_->start) unless $_->allele_ori->seq;\n\n\t#does the mutation end greater than 25 bases before the end of\n\t#sequence?\n\tif (($_->end + 25) > length($self->{'dna_mut'})) {\n\t    $le = length($self->{'dna_mut'}) - $_->end;\n\t} else {\n\t    $le = 25;\n\t}\n\n\t$_->dnStreamSeq(substr($self->{'dna_mut'}, $s, $la));\n\t$_->upStreamSeq(substr($self->{'dna_mut'}, $_->end, $le));\n\n\tmy $s_ori = $_->dnStreamSeq . $_->allele_ori->seq . $_->upStreamSeq;\n\tmy $s_mut = $_->dnStreamSeq . $_->allele_mut->seq . $_->upStreamSeq;\n\n\t(my $str = $self->{'dna_mut'}) =~ s/$s_ori/$s_mut/;\n\t$self->{'dna_mut'} = $str;\n    }\n}\n\n\n=head2 rna_ori\n\n Title   : rna_ori\n Usage   : $obj->rna_ori('atgctgctgctgct'); $rna_ori = $obj->rna_ori();\n Function: \n\n\t    Sets or returns the original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_ori'} = $value;\n  }\n  else {\n      return $self->{'rna_ori'};\n  }\n}\n\n\n=head2 rna_mut\n\n Title   : rna_mut\n Usage   : $obj->rna_mut('atgctggtgctgct'); $rna_mut = $obj->rna_mut();\n Function: \n\n\t    Sets or returns the mutated RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_mut'} = $value;\n  }\n  else {\n      return $self->{'rna_mut'};\n  }\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori('MAGVLL*'); $aa_ori = $obj->aa_ori();\n Function: \n\n\t    Sets or returns the original protein sequence of the seqDiff.\n\n Example : \n Returns : value of aa_ori, a scalar\n Args    : newvalue (optional)","label":"aa_ori($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"containerName":"aa_ori","name":"$self","definition":"my","localvar":"my","kind":13,"line":872},{"line":872,"kind":13,"name":"$value","containerName":"aa_ori"},{"name":"$value","containerName":"aa_ori","kind":13,"line":873},{"line":874,"kind":13,"name":"$self","containerName":"aa_ori"},{"kind":13,"line":874,"name":"$value","containerName":"aa_ori"},{"kind":13,"line":877,"name":"$self","containerName":"aa_ori"}],"line":871,"name":"aa_ori","range":{"end":{"character":9999,"line":879},"start":{"character":0,"line":871}}},{"kind":12,"line":897,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"aa_mut","line":898,"kind":13},{"containerName":"aa_mut","name":"$value","line":898,"kind":13},{"kind":13,"line":899,"containerName":"aa_mut","name":"$value"},{"containerName":"aa_mut","name":"$self","line":900,"kind":13},{"line":900,"kind":13,"containerName":"aa_mut","name":"$value"},{"kind":13,"line":903,"name":"$self","containerName":"aa_mut"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none\n\n\nsub each_Gene{\n   my ($self,@args) = @_;\n\n   return @{$self->{'genes'}}; \n}\n\n\n=head2 dna_ori\n\n Title   : dna_ori\n Usage   : $obj->dna_ori('atgctgctgctgct'); $dna_ori = $obj->dna_ori();\n Function: \n\n\t    Sets or returns the original DNA sequence string of the seqDiff.\n\n Example : \n Returns : value of dna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_ori'} = $value;\n  }\n  else {\n      return $self->{'dna_ori'};\n  }\n}\n\n\n=head2 dna_mut\n\n Title   : dna_mut\n Usage   : $obj->dna_mut('atgctggtgctgct'); $dna_mut = $obj->dna_mut();\n Function: \n\n\t    Sets or returns the mutated DNA sequence of the seqDiff.\n            If sequence has not been set generates it from the\n            original sequence and DNA mutations.\n\n Example : \n Returns : value of dna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_mut'} = $value;\n  }\n  else {\n      $self->_set_dnamut() unless $self->{'dna_mut'};\n      return $self->{'dna_mut'};\n  }\n}\n\nsub _set_dnamut {\n    my $self = shift;\n\n    return unless $self->{'dna_ori'}  && $self->each_Variant;\n\n    $self->{'dna_mut'} = $self->{'dna_ori'};\n    foreach ($self->each_Variant) {\n\tnext unless $_->isa('Bio::Variation::DNAMutation');\n\tnext unless $_->isMutation;\n\n\tmy ($s, $la, $le);\n\t#lies the mutation less than 25 bases after the start of sequence?\n\tif ($_->start < 25) {\n\t    $s = 0; $la = $_->start - 1;\n\t} else {\n\t    $s = $_->start - 25; $la = 25;\n\t}\n\n\t#is the mutation an insertion?\n\t$_->end($_->start) unless $_->allele_ori->seq;\n\n\t#does the mutation end greater than 25 bases before the end of\n\t#sequence?\n\tif (($_->end + 25) > length($self->{'dna_mut'})) {\n\t    $le = length($self->{'dna_mut'}) - $_->end;\n\t} else {\n\t    $le = 25;\n\t}\n\n\t$_->dnStreamSeq(substr($self->{'dna_mut'}, $s, $la));\n\t$_->upStreamSeq(substr($self->{'dna_mut'}, $_->end, $le));\n\n\tmy $s_ori = $_->dnStreamSeq . $_->allele_ori->seq . $_->upStreamSeq;\n\tmy $s_mut = $_->dnStreamSeq . $_->allele_mut->seq . $_->upStreamSeq;\n\n\t(my $str = $self->{'dna_mut'}) =~ s/$s_ori/$s_mut/;\n\t$self->{'dna_mut'} = $str;\n    }\n}\n\n\n=head2 rna_ori\n\n Title   : rna_ori\n Usage   : $obj->rna_ori('atgctgctgctgct'); $rna_ori = $obj->rna_ori();\n Function: \n\n\t    Sets or returns the original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_ori'} = $value;\n  }\n  else {\n      return $self->{'rna_ori'};\n  }\n}\n\n\n=head2 rna_mut\n\n Title   : rna_mut\n Usage   : $obj->rna_mut('atgctggtgctgct'); $rna_mut = $obj->rna_mut();\n Function: \n\n\t    Sets or returns the mutated RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_mut'} = $value;\n  }\n  else {\n      return $self->{'rna_mut'};\n  }\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori('MAGVLL*'); $aa_ori = $obj->aa_ori();\n Function: \n\n\t    Sets or returns the original protein sequence of the seqDiff.\n\n Example : \n Returns : value of aa_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub aa_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'aa_ori'} = $value;\n  }\n  else {\n      return $self->{'aa_ori'};\n  }\n}\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $obj->aa_mut('MA*'); $aa_mut = $obj->aa_mut();\n Function: \n\n\t    Sets or returns the mutated protein sequence of the seqDiff.\n\n Example : \n Returns : value of aa_mut, a scalar\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"aa_mut($self,$value)"},"name":"aa_mut","range":{"end":{"line":905,"character":9999},"start":{"line":897,"character":0}}},{"name":"seqobj","range":{"start":{"character":0,"line":925},"end":{"character":9999,"line":944}},"kind":12,"line":925,"children":[{"localvar":"my","containerName":"seqobj","definition":"my","name":"$self","line":926,"kind":13},{"name":"$value","containerName":"seqobj","line":926,"kind":13},{"localvar":"my","name":"$out","definition":"my","containerName":"seqobj","line":927,"kind":13},{"containerName":"seqobj","name":"%valid_obj","definition":"my","localvar":"my","kind":13,"line":928},{"kind":13,"line":930,"name":"$valid_obj","containerName":"seqobj"},{"name":"$value","containerName":"seqobj","line":930,"kind":13},{"line":931,"kind":13,"containerName":"seqobj","name":"$self"},{"containerName":"seqobj","name":"throw","line":931,"kind":12},{"containerName":"seqobj","name":"%valid_obj","kind":13,"line":932},{"kind":13,"line":933,"containerName":"seqobj","name":"$alphabet","definition":"my","localvar":"my"},{"line":933,"kind":13,"containerName":"seqobj","name":"$value"},{"definition":"my","name":"$id","containerName":"seqobj","localvar":"my","kind":13,"line":934},{"containerName":"seqobj","name":"$self","kind":13,"line":934},{"name":"id","containerName":"seqobj","kind":12,"line":934},{"line":935,"kind":13,"containerName":"seqobj","name":"$id"},{"kind":13,"line":935,"name":"$self","containerName":"seqobj"},{"line":935,"kind":12,"name":"rna_id","containerName":"seqobj"},{"kind":13,"line":935,"containerName":"seqobj","name":"$self"},{"kind":12,"line":935,"name":"rna_id","containerName":"seqobj"},{"containerName":"seqobj","name":"$alphabet","kind":13,"line":936},{"line":936,"kind":13,"name":"$alphabet","containerName":"seqobj"},{"name":"$out","containerName":"seqobj","kind":13,"line":937},{"containerName":"seqobj","name":"new","kind":12,"line":938},{"name":"$self","containerName":"seqobj","kind":13,"line":938},{"line":938,"kind":13,"name":"$value","containerName":"seqobj"},{"name":"$id","containerName":"seqobj","line":939,"kind":13},{"kind":13,"line":940,"containerName":"seqobj","name":"$self"},{"name":"id","containerName":"seqobj","line":940,"kind":12},{"name":"$alphabet","containerName":"seqobj","line":942,"kind":13},{"kind":13,"line":942,"containerName":"seqobj","name":"$self"},{"kind":13,"line":942,"containerName":"seqobj","name":"$value"},{"kind":13,"line":943,"containerName":"seqobj","name":"$out"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: SeqDiff.pm 16123 2009-09-17 12:57:27Z cjfields $\n# bioperl module for Bio::Variation::SeqDiff\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n# cds_end definition?\n\n=head1 NAME\n\nBio::Variation::SeqDiff - Container class for mutation/variant descriptions\n\n=head1 SYNOPSIS\n\n  $seqDiff = Bio::Variation::SeqDiff->new (\n                                           -id => $M20132,\n\t\t\t\t\t   -alphabet => 'rna',\n                                           -gene_symbol => 'AR'\n                                           -chromosome => 'X',\n                                           -numbering => 'coding'\n                                           );\n  # get a DNAMutation object somehow\n  $seqDiff->add_Variant($dnamut);\n  print  $seqDiff->sys_name(), \"\\n\"; \n\n=head1 DESCRIPTION\n\nSeqDiff stores Bio::Variation::VariantI object references and\ndescriptive information common to all changes in a sequence. Mutations\nare understood to be any kind of sequence markers and are expected to\noccur in the same chromosome. See L<Bio::Variation::VariantI> for details.\n\nThe methods of SeqDiff are geared towards describing mutations in\nhuman genes using gene-based coordinate system where 'A' of the\ninitiator codon has number 1 and the one before it -1. This is\naccording to conventions of human genetics.\n\nThere will be class Bio::Variation::Genotype to describe markers in\ndifferent chromosomes and diploid genototypes.\n\nClasses implementing Bio::Variation::VariantI interface are \nBio::Variation::DNAMutation, Bio::Variation::RNAChange, and\nBio::Variation::AAChange. See L<Bio::Variation::VariantI>,\nL<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>, and\nL<Bio::Variation::AAChange> for more information.\n\nVariant objects can be added using two ways: an array passed to the\nconstructor or as individual Variant objects with add_Variant\nmethod.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEckhard Lehmann, ecky@e-lehmann.de\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::SeqDiff;\n\nuse strict;\nuse Bio::Tools::CodonTable;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $seqDiff = Bio::Variation::SeqDiff->new;\n  Function: generates a new Bio::Variation::SeqDiff\n  Returns : reference to a new object of class SeqDiff\n  Args    : \n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($id, $sysname, $trivname, $chr, $gene_symbol, \n       $desc, $alphabet, $numbering, $offset, $rna_offset, $rna_id, $cds_end,\n       $dna_ori, $dna_mut, $rna_ori, $rna_mut, $aa_ori, $aa_mut\n       #@variants, @genes\n       ) =\n\t   $self->_rearrange([qw(ID\n\t\t\t\t SYSNAME\n\t\t\t\t TRIVNAME\n\t\t\t\t CHR\n\t\t\t\t GENE_SYMBOL\n\t\t\t\t DESC\n\t\t\t\t ALPHABET\n\t\t\t\t NUMBERING\n\t\t\t\t OFFSET\n\t\t\t\t RNA_OFFSET\n\t\t\t\t RNA_ID\n\t\t\t\t CDS_END\n\t\t\t\t DNA_ORI\n\t\t\t\t DNA_MUT\n\t\t\t\t RNA_ORI\n\t\t\t\t AA_ORI\n\t\t\t\t AA_MUT\n\t\t\t\t )],\n\t\t\t    @args);\n    \n    #my $make = $self->SUPER::_initialize(@args);\n    \n    $id        && $self->id($id);           \n    $sysname   && $self->sysname($sysname); \n    $trivname  && $self->trivname($trivname);\n    $chr       && $self->chromosome($chr);  \n    $gene_symbol && $self->gene_symbol($chr);\n    $desc      && $self->description($desc);\n    $alphabet   && $self->alphabet($alphabet);\n    $numbering && $self->numbering($numbering);\n    $offset    && $self->offset($offset);   \n    $rna_offset && $self->rna_offset($rna_offset);   \n    $rna_id    && $self->rna_id($rna_id);   \n    $cds_end   && $self->cds_end($cds_end);   \n\n    $dna_ori   && $self->dna_ori($dna_ori); \n    $dna_mut   && $self->dna_mut($dna_mut); \n    $rna_ori   && $self->rna_ori($rna_ori); \n    $rna_mut   && $self->rna_mut($rna_mut); \n    $aa_ori    && $self->aa_ori ($aa_ori);  \n    $aa_mut    && $self->aa_mut ($aa_mut);  \n\n    $self->{ 'variants' } = [];\n    #@variants && push(@{$self->{'variants'}},@variants);\n\n    $self->{ 'genes' } = [];\n    #@genes && push(@{$self->{'genes'}},@genes);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id(H0001); $id = $obj->id();\n Function: \n\n           Sets or returns the id of the seqDiff.\n           Should be used to give the collection of variants a UID\n           without semantic associations.\n\n Example : \n Returns : value of id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'id'} = $value;\n  }\n  else {\n      return $self->{'id'};\n  }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $obj->sysname('5C>G'); $sysname = $obj->sysname();\n Function: \n\n           Sets or returns the systematic name of the seqDiff.  The\n           name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::DNAMutation>\n           objects attached.\n\n Example : \n Returns : value of sysname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub sysname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'sysname'} = $value;\n    }\n    elsif (not defined $self->{'sysname'}) {\n\n\tmy $sysname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::DNAMutation') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $sysname = $mut->sysname ;\n\t\t}\n\t\telse {\n\t\t    $sysname .= \";\". $mut->sysname;\n\t\t}\n\t    }\n\t}\n\t$sysname  = \"[\". $sysname. \"]\" if $c > 1;\n\t$self->{'sysname'} = $sysname;\n    }\n    return $self->{'sysname'};\n}\n\n\n=head2 trivname\n\n Title   : trivname\n Usage   : $obj->trivname('[A2G;T56G]'); $trivname = $obj->trivname();\n Function: \n\n           Sets or returns the trivial name of the seqDiff.\n           The name should follow the HUGO Mutation Database Initiative\n           approved nomenclature. If called without first setting the\n           value, will generate it from L<Bio::Variation::AAChange>\n           objects attached.\n\n Example : \n Returns : value of trivname, a scalar\n Args    : newvalue (optional)\n\n\n\nsub trivname {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'trivname'} = $value;\n    }\n    elsif (not defined $self->{'trivname'}) {\n\t\n\tmy $trivname = ''; \n\tmy $c = 0;\n\tforeach my $mut ($self->each_Variant) {\n\t    if( $mut->isa('Bio::Variation::AAChange') ) {\n\t\t$c++;\n\t\tif ($c == 1 ) {\n\t\t    $trivname = $mut->trivname ;\n\t\t}\n\t\telse {\n\t\t    $trivname .= \";\". $mut->trivname;\n\t\t}\n\t    }\n\t}\n\t$trivname  = \"[\". $trivname. \"]\" if $c > 1;\n\t$self->{'trivname'} = $trivname;\n    }\n\n  else {\n      return $self->{'trivname'};\n  }\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : $obj->chromosome('X'); $chromosome = $obj->chromosome();\n Function: \n\n           Sets or returns the chromosome (\"linkage group\") of the seqDiff.\n\n Example : \n Returns : value of chromosome, a scalar\n Args    : newvalue (optional)\n\n\n\nsub chromosome {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'chromosome'} = $value;\n  }\n  else {\n      return $self->{'chromosome'};\n  }\n}\n\n\n=head2 gene_symbol\n\n Title   : gene_symbol\n Usage   : $obj->gene_symbol('FOS'); $gene_symbol = $obj->gene_symbol;\n Function: \n\n           Sets or returns the gene symbol for the studied CDS.\n\n Example : \n Returns : value of gene_symbol, a scalar\n Args    : newvalue (optional)\n\n\n\nsub gene_symbol {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'gene_symbol'} = $value;\n  }\n  else {\n      return $self->{'gene_symbol'};\n  }\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description('short description'); $descr = $obj->description();\n Function: \n\n           Sets or returns the short description of the seqDiff.\n\n Example : \n Returns : value of description, a scalar\n Args    : newvalue (optional)\n\n\n\nsub description {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'description'} = $value;\n  }\n  else {\n      return $self->{'description'};\n  }\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the type of primary reference sequence being one of \n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n Returns : a string either 'dna','rna','protein'. \n Args    : none\n\n\n\nsub alphabet {\n   my ($self,$value) = @_;\n   my %type = (dna => 1,\n\t       rna => 1,\n\t       protein => 1);\n   if( defined $value ) {\n       if ($type{$value}) {\n\t   $self->{'alphabet'} = $value;\n       } else {\n\t   $self->throw(\"$value is not valid alphabet value!\");\n       }\n   }\n   return $self->{'alphabet'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering('coding'); $numbering = $obj->numbering();\n Function: \n\n           Sets or returns the string giving the numbering schema used\n           to describe the variants.\n\n Example : \n Returns : value of numbering, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub numbering {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'numbering'} = $value;\n  }\n  else {\n      return $self->{'numbering'};\n  }\n}\n\n\n=head2 offset\n\n Title   : offset\n Usage   : $obj->offset(124); $offset = $obj->offset();\n Function: \n\n           Sets or returns the offset from the beginning of the DNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n           The cds_start should be 1 + offset.\n\n Example : \n Returns : value of offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value;\n  }\n  elsif (not defined $self->{'offset'} ) {\n      return $self->{'offset'} = 0;\n  }\n  else {\n      return $self->{'offset'};\n  }\n}\n\n\n=head2 cds_start\n\n Title   : cds_start\n Usage   : $obj->cds_start(123); $cds_start = $obj->cds_start();\n Function: \n\n           Sets or returns the cds_start from the beginning of the DNA\n           sequence to the coordinate start used to describe\n           variants. Typically the beginning of the coding region of\n           the gene. Needs to be and is implemented as 1 + offset.\n\n Example : \n Returns : value of cds_start, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_start {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'offset'} = $value - 1;\n  }\n  else {\n      return $self->{'offset'} + 1;\n  }\n}\n\n\n=head2 cds_end\n\n Title   : cds_end\n Usage   : $obj->cds_end(321); $cds_end = $obj->cds_end();\n Function: \n\n           Sets or returns the position of the last nucleotitide of the\n           termination codon. The coordinate system starts from cds_start.\n\n Example : \n Returns : value of cds_end, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub cds_end {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'cds_end'} = $value;\n  }\n  else {\n      return $self->{'cds_end'};\n      #$self->{'cds_end'} = CORE::length($self->SeqDiff->rna_ori)/3;\n  }\n}\n\n\n=head2 rna_offset\n\n Title   : rna_offset\n Usage   : $obj->rna_offset(124); $rna_offset = $obj->rna_offset();\n Function: \n\n           Sets or returns the rna_offset from the beginning of the RNA sequence \n           to the coordinate start used to describe variants. Typically\n           the beginning of the coding region of the gene. \n\n Example : \n Returns : value of rna_offset, a scalar\n Args    : newvalue (optional)\n\n\n\n\nsub rna_offset {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_offset'} = $value;\n  }\n  elsif (not defined $self->{'rna_offset'} ) {\n      return $self->{'rna_offset'} = 0;\n  }\n  else {\n      return $self->{'rna_offset'};\n  }\n}\n\n\n=head2 rna_id\n\n Title   : rna_id\n Usage   : $obj->rna_id('transcript#3'); $rna_id = $obj->rna_id();\n Function: \n\n\t    Sets or returns the ID for original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_id, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_id {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_id'} = $value;\n  }\n  else {\n      return $self->{'rna_id'};\n  }\n}\n\n\n\n=head2 add_Variant\n\n Title   : add_Variant\n Usage   : $obj->add_Variant($variant)\n Function: \n\n           Pushes one Bio::Variation::Variant into the list of variants.\n           At the same time, creates a link from the Variant to SeqDiff\n           using its SeqDiff method.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Variant object\n\n\nsub add_Variant {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::VariantI') ) {\n\t  $self->throw(\"Is not a VariantI complying  object but a [$self]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'variants'}},$value);\n\t  $value->SeqDiff($self);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none\n\n\nsub each_Variant{\n   my ($self,@args) = @_;\n   \n   return @{$self->{'variants'}}; \n}\n\n\n\n=head2 add_Gene\n\n Title   : add_Gene\n Usage   : $obj->add_Gene($gene)\n Function: \n\n           Pushes one L<Bio::LiveSeq::Gene> into the list of genes.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Bio::LiveSeq::Gene object\n\nSee L<Bio::LiveSeq::Gene> for more information.\n\n\n\nsub add_Gene {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::LiveSeq::Gene') ) {\n\t  $value->throw(\"Is not a Bio::LiveSeq::Gene object but a  [$value]\");\n\t  return 0;\n      }\n      else {\n\t  push(@{$self->{'genes'}},$value);\n\t  return 1;\n      }\n  }\n  else {\n      return 0;\n  }\n}\n\n\n=head2 each_Gene\n\n Title   : each_Gene\n Usage   : $obj->each_Gene();\n Function: \n\n            Returns a list of L<Bio::LiveSeq::Gene>s.\n\n Example : \n Returns : list of Genes\n Args    : none\n\n\nsub each_Gene{\n   my ($self,@args) = @_;\n\n   return @{$self->{'genes'}}; \n}\n\n\n=head2 dna_ori\n\n Title   : dna_ori\n Usage   : $obj->dna_ori('atgctgctgctgct'); $dna_ori = $obj->dna_ori();\n Function: \n\n\t    Sets or returns the original DNA sequence string of the seqDiff.\n\n Example : \n Returns : value of dna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_ori'} = $value;\n  }\n  else {\n      return $self->{'dna_ori'};\n  }\n}\n\n\n=head2 dna_mut\n\n Title   : dna_mut\n Usage   : $obj->dna_mut('atgctggtgctgct'); $dna_mut = $obj->dna_mut();\n Function: \n\n\t    Sets or returns the mutated DNA sequence of the seqDiff.\n            If sequence has not been set generates it from the\n            original sequence and DNA mutations.\n\n Example : \n Returns : value of dna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub dna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      $self->{'dna_mut'} = $value;\n  }\n  else {\n      $self->_set_dnamut() unless $self->{'dna_mut'};\n      return $self->{'dna_mut'};\n  }\n}\n\nsub _set_dnamut {\n    my $self = shift;\n\n    return unless $self->{'dna_ori'}  && $self->each_Variant;\n\n    $self->{'dna_mut'} = $self->{'dna_ori'};\n    foreach ($self->each_Variant) {\n\tnext unless $_->isa('Bio::Variation::DNAMutation');\n\tnext unless $_->isMutation;\n\n\tmy ($s, $la, $le);\n\t#lies the mutation less than 25 bases after the start of sequence?\n\tif ($_->start < 25) {\n\t    $s = 0; $la = $_->start - 1;\n\t} else {\n\t    $s = $_->start - 25; $la = 25;\n\t}\n\n\t#is the mutation an insertion?\n\t$_->end($_->start) unless $_->allele_ori->seq;\n\n\t#does the mutation end greater than 25 bases before the end of\n\t#sequence?\n\tif (($_->end + 25) > length($self->{'dna_mut'})) {\n\t    $le = length($self->{'dna_mut'}) - $_->end;\n\t} else {\n\t    $le = 25;\n\t}\n\n\t$_->dnStreamSeq(substr($self->{'dna_mut'}, $s, $la));\n\t$_->upStreamSeq(substr($self->{'dna_mut'}, $_->end, $le));\n\n\tmy $s_ori = $_->dnStreamSeq . $_->allele_ori->seq . $_->upStreamSeq;\n\tmy $s_mut = $_->dnStreamSeq . $_->allele_mut->seq . $_->upStreamSeq;\n\n\t(my $str = $self->{'dna_mut'}) =~ s/$s_ori/$s_mut/;\n\t$self->{'dna_mut'} = $str;\n    }\n}\n\n\n=head2 rna_ori\n\n Title   : rna_ori\n Usage   : $obj->rna_ori('atgctgctgctgct'); $rna_ori = $obj->rna_ori();\n Function: \n\n\t    Sets or returns the original RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_ori'} = $value;\n  }\n  else {\n      return $self->{'rna_ori'};\n  }\n}\n\n\n=head2 rna_mut\n\n Title   : rna_mut\n Usage   : $obj->rna_mut('atgctggtgctgct'); $rna_mut = $obj->rna_mut();\n Function: \n\n\t    Sets or returns the mutated RNA sequence of the seqDiff.\n\n Example : \n Returns : value of rna_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub rna_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'rna_mut'} = $value;\n  }\n  else {\n      return $self->{'rna_mut'};\n  }\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori('MAGVLL*'); $aa_ori = $obj->aa_ori();\n Function: \n\n\t    Sets or returns the original protein sequence of the seqDiff.\n\n Example : \n Returns : value of aa_ori, a scalar\n Args    : newvalue (optional)\n\n\n\nsub aa_ori {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'aa_ori'} = $value;\n  }\n  else {\n      return $self->{'aa_ori'};\n  }\n}\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $obj->aa_mut('MA*'); $aa_mut = $obj->aa_mut();\n Function: \n\n\t    Sets or returns the mutated protein sequence of the seqDiff.\n\n Example : \n Returns : value of aa_mut, a scalar\n Args    : newvalue (optional)\n\n\n\nsub aa_mut {\n  my ($self,$value) = @_;\n  if (defined $value) {\n    $self->{'aa_mut'} = $value;\n  }\n  else {\n      return $self->{'aa_mut'};\n  }\n}\n\n\n=head2 seqobj\n\n Title   : seqobj\n Usage   : $dnaobj = $obj->seqobj('dna_mut');\n Function: \n\n\t    Returns the any original or mutated sequences as a\n\t    Bio::PrimarySeq object.\n\n Example : \n Returns : Bio::PrimarySeq object for the requested sequence\n Args    : string, method name for the sequence requested\n\nSee L<Bio::PrimarySeq> for more information.","label":"seqobj($self,$value)"}},{"name":"Bio","containerName":"PrimarySeq","line":937,"kind":12},{"containerName":"main::","definition":"sub","name":"alignment","range":{"end":{"character":9999,"line":1145},"start":{"line":963,"character":0}},"kind":12,"line":963,"children":[{"kind":13,"line":964,"containerName":"alignment","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":965,"containerName":"alignment","definition":"my","name":"@entry","localvar":"my"},{"kind":13,"line":965,"containerName":"alignment","name":"$text"},{"line":967,"kind":13,"localvar":"my","definition":"my","name":"$maxflanklen","containerName":"alignment"},{"kind":13,"line":969,"definition":"my","name":"$mut","containerName":"alignment","localvar":"my"},{"kind":13,"line":969,"containerName":"alignment","name":"$self"},{"line":969,"kind":12,"containerName":"alignment","name":"each_Variant"},{"kind":13,"line":970,"containerName":"alignment","name":"$mut"},{"containerName":"alignment","name":"isa","line":970,"kind":12},{"localvar":"my","name":"$upflank","definition":"my","containerName":"alignment","line":972,"kind":13},{"containerName":"alignment","name":"$mut","kind":13,"line":972},{"containerName":"alignment","name":"upStreamSeq","kind":12,"line":972},{"containerName":"alignment","definition":"my","name":"$dnflank","localvar":"my","kind":13,"line":973},{"containerName":"alignment","name":"$mut","line":973,"kind":13},{"containerName":"alignment","name":"dnStreamSeq","kind":12,"line":973},{"definition":"my","name":"$cposd","containerName":"alignment","localvar":"my","kind":13,"line":974},{"line":974,"kind":13,"name":"$mut","containerName":"alignment"},{"kind":12,"line":974,"name":"codon_pos","containerName":"alignment"},{"localvar":"my","containerName":"alignment","name":"$rori","definition":"my","line":975,"kind":13},{"name":"$mut","containerName":"alignment","line":975,"kind":13},{"kind":12,"line":975,"containerName":"alignment","name":"allele_ori"},{"name":"seq","containerName":"alignment","kind":12,"line":975},{"line":976,"kind":13,"localvar":"my","containerName":"alignment","name":"$rmut","definition":"my"},{"kind":13,"line":976,"name":"$mut","containerName":"alignment"},{"line":976,"kind":12,"name":"allele_mut","containerName":"alignment"},{"line":976,"kind":12,"name":"seq","containerName":"alignment"},{"localvar":"my","containerName":"alignment","definition":"my","name":"$rseqoriu","line":977,"kind":13},{"definition":"my","name":"$rseqmutu","containerName":"alignment","localvar":"my","kind":13,"line":978},{"kind":13,"line":979,"containerName":"alignment","name":"$rseqorid","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"$rseqmutd","containerName":"alignment","line":980,"kind":13},{"containerName":"alignment","definition":"my","name":"$aaseqmutu","localvar":"my","kind":13,"line":981},{"kind":13,"line":982,"containerName":"alignment","definition":"my","name":"@rseqori","localvar":"my"},{"kind":13,"line":982,"name":"@rseqmut","containerName":"alignment"},{"line":985,"kind":13,"name":"$mut","containerName":"alignment"},{"kind":12,"line":985,"containerName":"alignment","name":"DNAMutation"},{"containerName":"alignment","name":"label","kind":12,"line":985},{"line":986,"kind":13,"name":"$cposd","containerName":"alignment"},{"line":987,"kind":13,"localvar":"my","containerName":"alignment","definition":"my","name":"$nt2d"},{"containerName":"alignment","name":"$dnflank","kind":13,"line":987},{"kind":13,"line":988,"name":"@rseqori","containerName":"alignment"},{"name":"$rori","containerName":"alignment","kind":13,"line":988},{"containerName":"alignment","name":"$nt2d","kind":13,"line":988},{"kind":13,"line":989,"containerName":"alignment","name":"@rseqmut"},{"containerName":"alignment","name":"$rmut","kind":13,"line":989},{"line":989,"kind":13,"containerName":"alignment","name":"$nt2d"},{"name":"$dnflank","containerName":"alignment","line":990,"kind":13},{"containerName":"alignment","name":"$dnflank","kind":13,"line":990},{"name":"$cposd","containerName":"alignment","line":992,"kind":13},{"line":993,"kind":13,"localvar":"my","name":"$ntu","definition":"my","containerName":"alignment"},{"line":993,"kind":13,"containerName":"alignment","name":"$upflank"},{"localvar":"my","containerName":"alignment","definition":"my","name":"$ntd","line":994,"kind":13},{"name":"$dnflank","containerName":"alignment","line":994,"kind":13},{"line":995,"kind":13,"containerName":"alignment","name":"@rseqori"},{"containerName":"alignment","name":"$ntu","line":995,"kind":13},{"line":995,"kind":13,"containerName":"alignment","name":"$rori"},{"containerName":"alignment","name":"$ntd","line":995,"kind":13},{"kind":13,"line":996,"name":"@rseqmut","containerName":"alignment"},{"containerName":"alignment","name":"$ntu","line":996,"kind":13},{"name":"$rmut","containerName":"alignment","line":996,"kind":13},{"name":"$ntd","containerName":"alignment","line":996,"kind":13},{"kind":13,"line":997,"containerName":"alignment","name":"$dnflank"},{"name":"$dnflank","containerName":"alignment","kind":13,"line":997},{"kind":13,"line":999,"containerName":"alignment","name":"$cposd"},{"name":"$ntu1","definition":"my","containerName":"alignment","localvar":"my","kind":13,"line":1000},{"kind":13,"line":1000,"name":"$upflank","containerName":"alignment"},{"localvar":"my","containerName":"alignment","definition":"my","name":"$ntu2","line":1001,"kind":13},{"line":1001,"kind":13,"containerName":"alignment","name":"$upflank"},{"kind":13,"line":1002,"containerName":"alignment","name":"@rseqori"},{"name":"$ntu2","containerName":"alignment","kind":13,"line":1002},{"line":1002,"kind":13,"containerName":"alignment","name":"$ntu1"},{"kind":13,"line":1002,"name":"$rori","containerName":"alignment"},{"containerName":"alignment","name":"@rseqmut","line":1003,"kind":13},{"kind":13,"line":1003,"containerName":"alignment","name":"$ntu2"},{"kind":13,"line":1003,"name":"$ntu1","containerName":"alignment"},{"containerName":"alignment","name":"$rmut","line":1003,"kind":13},{"name":"$mut","containerName":"alignment","kind":13,"line":1007},{"containerName":"alignment","name":"DNAMutation","kind":12,"line":1007},{"name":"label","containerName":"alignment","kind":12,"line":1007},{"kind":13,"line":1008,"containerName":"alignment","name":"$cposd"},{"name":"$rseqorid","containerName":"alignment","kind":13,"line":1009},{"kind":13,"line":1009,"containerName":"alignment","name":"$upflank"},{"containerName":"alignment","name":"$rseqmutd","line":1010,"kind":13},{"kind":13,"line":1010,"name":"$rseqorid","containerName":"alignment"},{"kind":13,"line":1012,"definition":"my","name":"$i","containerName":"alignment","localvar":"my"},{"kind":13,"line":1012,"name":"$i","containerName":"alignment"},{"containerName":"alignment","name":"$mut","line":1012,"kind":13},{"kind":12,"line":1012,"containerName":"alignment","name":"length"},{"containerName":"alignment","name":"$i","line":1012,"kind":13},{"line":1013,"kind":13,"localvar":"my","containerName":"alignment","definition":"my","name":"$ntd"},{"name":"$mut","containerName":"alignment","kind":13,"line":1013},{"containerName":"alignment","name":"allele_ori","kind":12,"line":1013},{"line":1013,"kind":13,"name":"$i","containerName":"alignment"},{"containerName":"alignment","name":"$rseqorid","line":1014,"kind":13},{"name":"$ntd","containerName":"alignment","line":1014,"kind":13},{"containerName":"alignment","name":"$rseqorid","kind":13,"line":1015},{"containerName":"alignment","name":"@rseqori","kind":13,"line":1016},{"kind":13,"line":1016,"name":"$rseqorid","containerName":"alignment"},{"line":1017,"kind":13,"name":"@rseqmut","containerName":"alignment"},{"containerName":"alignment","name":"$rseqorid","line":1018,"kind":13},{"containerName":"alignment","name":"$rseqorid","kind":13,"line":1022},{"kind":13,"line":1023,"name":"$rseqorid","containerName":"alignment"},{"kind":13,"line":1023,"containerName":"alignment","name":"$dnflank"},{"kind":13,"line":1023,"containerName":"alignment","name":"$rseqorid"},{"containerName":"alignment","name":"@rseqori","line":1024,"kind":13},{"kind":13,"line":1024,"name":"$rseqorid","containerName":"alignment"},{"kind":13,"line":1025,"containerName":"alignment","name":"@rseqmut"},{"line":1026,"kind":13,"containerName":"alignment","name":"$dnflank"},{"kind":13,"line":1026,"name":"$dnflank","containerName":"alignment"},{"name":"$rseqorid","containerName":"alignment","line":1026,"kind":13},{"name":"$upflank","containerName":"alignment","line":1029,"kind":13},{"containerName":"alignment","name":"$upflank","kind":13,"line":1029},{"localvar":"my","name":"$i","definition":"my","containerName":"alignment","line":1031,"kind":13},{"line":1031,"kind":13,"name":"$i","containerName":"alignment"},{"kind":13,"line":1031,"containerName":"alignment","name":"$dnflank"},{"containerName":"alignment","name":"$i","kind":13,"line":1031},{"containerName":"alignment","name":"$i","kind":13,"line":1033},{"containerName":"alignment","name":"$maxflanklen","kind":13,"line":1033},{"containerName":"alignment","definition":"my","name":"$ntd","localvar":"my","kind":13,"line":1035},{"name":"$dnflank","containerName":"alignment","line":1035,"kind":13},{"containerName":"alignment","name":"$i","kind":13,"line":1035},{"line":1036,"kind":13,"localvar":"my","name":"$ntu","definition":"my","containerName":"alignment"},{"kind":13,"line":1036,"containerName":"alignment","name":"$upflank"},{"kind":13,"line":1036,"containerName":"alignment","name":"$i"},{"line":1038,"kind":13,"name":"$rseqmutd","containerName":"alignment"},{"containerName":"alignment","name":"$ntd","line":1038,"kind":13},{"containerName":"alignment","name":"$rseqorid","kind":13,"line":1039},{"name":"$ntd","containerName":"alignment","kind":13,"line":1039},{"containerName":"alignment","name":"$rseqmutu","kind":13,"line":1040},{"containerName":"alignment","name":"$ntu","line":1040,"kind":13},{"containerName":"alignment","name":"$rseqmutu","line":1040,"kind":13},{"line":1041,"kind":13,"containerName":"alignment","name":"$rseqoriu"},{"containerName":"alignment","name":"$ntu","line":1041,"kind":13},{"line":1041,"kind":13,"containerName":"alignment","name":"$rseqoriu"},{"kind":13,"line":1043,"containerName":"alignment","name":"$rseqorid"},{"line":1043,"kind":13,"containerName":"alignment","name":"$rseqorid"},{"containerName":"alignment","name":"@rseqori","line":1044,"kind":13},{"line":1044,"kind":13,"name":"$rseqorid","containerName":"alignment"},{"kind":13,"line":1045,"containerName":"alignment","name":"@rseqmut"},{"name":"$rseqmutd","containerName":"alignment","line":1045,"kind":13},{"kind":13,"line":1046,"name":"$rseqorid","containerName":"alignment"},{"name":"$rseqmutd","containerName":"alignment","kind":13,"line":1046},{"line":1048,"kind":13,"containerName":"alignment","name":"$rseqoriu"},{"kind":13,"line":1048,"containerName":"alignment","name":"$rseqoriu"},{"line":1049,"kind":13,"name":"@rseqori","containerName":"alignment"},{"line":1049,"kind":13,"containerName":"alignment","name":"$rseqoriu"},{"containerName":"alignment","name":"@rseqmut","kind":13,"line":1050},{"line":1050,"kind":13,"name":"$rseqmutu","containerName":"alignment"},{"kind":13,"line":1051,"name":"$rseqoriu","containerName":"alignment"},{"kind":13,"line":1051,"containerName":"alignment","name":"$rseqmutu"},{"containerName":"alignment","name":"@rseqori","kind":13,"line":1059},{"name":"$rseqorid","containerName":"alignment","kind":13,"line":1059},{"kind":13,"line":1060,"name":"@rseqori","containerName":"alignment"},{"kind":13,"line":1060,"name":"$rseqoriu","containerName":"alignment"},{"line":1061,"kind":13,"name":"@rseqmut","containerName":"alignment"},{"name":"$rseqmutd","containerName":"alignment","kind":13,"line":1061},{"name":"@rseqmut","containerName":"alignment","kind":13,"line":1062},{"containerName":"alignment","name":"$rseqmutu","kind":13,"line":1062},{"kind":13,"line":1064,"containerName":"alignment","name":"$mut"},{"line":1064,"kind":12,"containerName":"alignment","name":"AAChange"},{"kind":13,"line":1066,"name":"$tr","definition":"my","containerName":"alignment","localvar":"my"},{"containerName":"alignment","name":"new","kind":12,"line":1066},{"containerName":"alignment","name":"$mut","kind":13,"line":1066},{"kind":12,"line":1066,"name":"codon_table","containerName":"alignment"},{"line":1067,"kind":13,"localvar":"my","containerName":"alignment","definition":"my","name":"$apos"},{"kind":13,"line":1067,"name":"$mut","containerName":"alignment"},{"line":1067,"kind":12,"name":"AAChange","containerName":"alignment"},{"name":"start","containerName":"alignment","kind":12,"line":1067},{"line":1068,"kind":13,"localvar":"my","containerName":"alignment","name":"$aposmax","definition":"my"},{"line":1068,"kind":13,"containerName":"alignment","name":"$self"},{"kind":12,"line":1068,"containerName":"alignment","name":"aa_ori"},{"localvar":"my","containerName":"alignment","definition":"my","name":"$rseqori","line":1069,"kind":13},{"definition":"my","name":"$rseqmut","containerName":"alignment","localvar":"my","kind":13,"line":1070},{"localvar":"my","containerName":"alignment","name":"$aaseqori","definition":"my","line":1071,"kind":13},{"containerName":"alignment","definition":"my","name":"$aaseqmut","localvar":"my","kind":13,"line":1072},{"localvar":"my","containerName":"alignment","name":"$i","definition":"my","line":1073,"kind":13},{"line":1073,"kind":13,"containerName":"alignment","name":"$i"},{"kind":13,"line":1073,"containerName":"alignment","name":"$i"},{"localvar":"my","containerName":"alignment","name":"$a","definition":"my","line":1074,"kind":13},{"line":1076,"kind":13,"containerName":"alignment","name":"$a"},{"kind":13,"line":1076,"containerName":"alignment","name":"$tr"},{"kind":12,"line":1076,"name":"translate","containerName":"alignment"},{"containerName":"alignment","name":"$rseqori","kind":13,"line":1076},{"kind":13,"line":1076,"containerName":"alignment","name":"$i"},{"kind":13,"line":1076,"containerName":"alignment","name":"$rseqori"},{"line":1076,"kind":13,"name":"$i","containerName":"alignment"},{"kind":13,"line":1078,"containerName":"alignment","name":"$a"},{"name":"$apos","containerName":"alignment","kind":13,"line":1079},{"kind":13,"line":1079,"name":"$maxflanklen","containerName":"alignment"},{"line":1079,"kind":13,"containerName":"alignment","name":"$i"},{"line":1080,"kind":13,"containerName":"alignment","name":"$apos"},{"line":1080,"kind":13,"name":"$maxflanklen","containerName":"alignment"},{"containerName":"alignment","name":"$i","line":1080,"kind":13},{"kind":13,"line":1080,"containerName":"alignment","name":"$aposmax"},{"kind":13,"line":1081,"name":"$aaseqori","containerName":"alignment"},{"line":1083,"kind":13,"name":"$aaseqori","containerName":"alignment"},{"name":"$a","containerName":"alignment","kind":13,"line":1083},{"containerName":"alignment","definition":"my","name":"$b","localvar":"my","kind":13,"line":1085},{"line":1086,"kind":13,"containerName":"alignment","name":"$rseqmut"},{"kind":13,"line":1086,"containerName":"alignment","name":"$i"},{"line":1087,"kind":13,"containerName":"alignment","name":"$rseqmut"},{"name":"$i","containerName":"alignment","line":1087,"kind":13},{"line":1088,"kind":13,"name":"$b","containerName":"alignment"},{"name":"$b","containerName":"alignment","line":1090,"kind":13},{"name":"$tr","containerName":"alignment","kind":13,"line":1090},{"name":"translate","containerName":"alignment","line":1090,"kind":12},{"kind":13,"line":1090,"name":"$rseqmut","containerName":"alignment"},{"line":1090,"kind":13,"containerName":"alignment","name":"$i"},{"kind":13,"line":1093,"containerName":"alignment","name":"$b"},{"containerName":"alignment","name":"$a","kind":13,"line":1093},{"kind":13,"line":1094,"containerName":"alignment","name":"$b"},{"name":"$apos","containerName":"alignment","kind":13,"line":1095},{"line":1095,"kind":13,"containerName":"alignment","name":"$maxflanklen"},{"name":"$i","containerName":"alignment","line":1095,"kind":13},{"kind":13,"line":1096,"containerName":"alignment","name":"$apos"},{"line":1096,"kind":13,"containerName":"alignment","name":"$maxflanklen"},{"name":"$i","containerName":"alignment","line":1096,"kind":13},{"containerName":"alignment","name":"$aposmax","kind":13,"line":1096},{"name":"$mut","containerName":"alignment","kind":13,"line":1097},{"containerName":"alignment","name":"label","line":1097,"kind":12},{"containerName":"alignment","name":"$aaseqmut","line":1099,"kind":13},{"line":1099,"kind":13,"name":"$b","containerName":"alignment"},{"kind":13,"line":1101,"containerName":"alignment","name":"$aaseqmut"},{"kind":13,"line":1104,"name":"$i","containerName":"alignment"},{"line":1104,"kind":13,"containerName":"alignment","name":"$rseqori"},{"containerName":"alignment","name":"$i","line":1104,"kind":13},{"kind":13,"line":1105,"containerName":"alignment","name":"$l","definition":"my","localvar":"my"},{"name":"$rseqori","containerName":"alignment","kind":13,"line":1105},{"kind":13,"line":1105,"name":"$i","containerName":"alignment"},{"name":"$rseqori","containerName":"alignment","line":1106,"kind":13},{"kind":13,"line":1106,"name":"$i","containerName":"alignment"},{"kind":13,"line":1106,"containerName":"alignment","name":"$l"},{"line":1106,"kind":13,"name":"$rseqori","containerName":"alignment"},{"kind":13,"line":1106,"name":"$i","containerName":"alignment"},{"kind":13,"line":1107,"name":"$rseqmut","containerName":"alignment"},{"name":"$i","containerName":"alignment","kind":13,"line":1107},{"name":"$l","containerName":"alignment","kind":13,"line":1107},{"kind":13,"line":1107,"containerName":"alignment","name":"$rseqmut"},{"kind":13,"line":1107,"name":"$i","containerName":"alignment"},{"containerName":"alignment","name":"$rseqori","kind":13,"line":1109},{"containerName":"alignment","name":"$rseqori","kind":13,"line":1109},{"line":1109,"kind":13,"name":"$i","containerName":"alignment"},{"line":1109,"kind":13,"containerName":"alignment","name":"$rseqori"},{"line":1109,"kind":13,"containerName":"alignment","name":"$i"},{"line":1110,"kind":13,"containerName":"alignment","name":"$rseqmut"},{"kind":13,"line":1110,"containerName":"alignment","name":"$rseqmut"},{"kind":13,"line":1110,"name":"$i","containerName":"alignment"},{"kind":13,"line":1110,"containerName":"alignment","name":"$rseqmut"},{"name":"$i","containerName":"alignment","kind":13,"line":1110},{"kind":13,"line":1114,"name":"@entry","containerName":"alignment"},{"name":"$text","containerName":"alignment","kind":13,"line":1117},{"name":"$aaseqmut","containerName":"alignment","kind":13,"line":1117},{"line":1118,"kind":13,"containerName":"alignment","name":"@entry"},{"kind":13,"line":1120,"name":"$text","containerName":"alignment"},{"containerName":"alignment","name":"$text","kind":13,"line":1121},{"line":1121,"kind":13,"name":"$rseqmut","containerName":"alignment"},{"kind":13,"line":1122,"name":"@entry","containerName":"alignment"},{"name":"$text","containerName":"alignment","line":1124,"kind":13},{"name":"$text","containerName":"alignment","kind":13,"line":1125},{"line":1125,"kind":13,"name":"$rseqori","containerName":"alignment"},{"kind":13,"line":1126,"name":"@entry","containerName":"alignment"},{"kind":13,"line":1128,"containerName":"alignment","name":"$text"},{"line":1129,"kind":13,"name":"$text","containerName":"alignment"},{"containerName":"alignment","name":"$aaseqori","line":1129,"kind":13},{"containerName":"alignment","name":"@entry","line":1130,"kind":13},{"line":1132,"kind":13,"containerName":"alignment","name":"$text"},{"name":"@entry","containerName":"alignment","line":1133,"kind":13},{"containerName":"alignment","name":"$res","definition":"my","localvar":"my","kind":13,"line":1140},{"line":1141,"kind":13,"localvar":"my","containerName":"alignment","name":"$line","definition":"my"},{"kind":13,"line":1141,"name":"@entry","containerName":"alignment"},{"containerName":"alignment","name":"$res","kind":13,"line":1142},{"name":"$res","containerName":"alignment","line":1144,"kind":13}]},{"name":"Bio","containerName":"Tools::CodonTable","kind":12,"line":1066},{"kind":12,"line":1068,"containerName":"length","name":"CORE"},{"name":"rseqori","kind":12,"line":1073}],"version":5}