{"vars":[{"name":"base","containerName":"","kind":2,"line":90},{"name":"_initialize","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":102},"end":{"character":9999,"line":114}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":103},{"kind":13,"line":104,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"$hdr","definition":"my","localvar":"my","kind":13,"line":105},{"line":105,"kind":13,"containerName":"_initialize","name":"$trans"},{"line":105,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":105,"containerName":"_initialize","name":"_rearrange"},{"kind":13,"line":112,"name":"$self","containerName":"_initialize"},{"name":"header","containerName":"_initialize","line":112,"kind":12},{"line":112,"kind":13,"containerName":"_initialize","name":"$hdr"},{"line":112,"kind":13,"containerName":"_initialize","name":"$hdr"},{"line":113,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":113,"containerName":"_initialize","name":"translate_node"},{"containerName":"_initialize","name":"$trans","kind":13,"line":113},{"containerName":"_initialize","name":"$trans","kind":13,"line":113}],"line":102},{"containerName":"_initialize","name":"SUPER","line":104,"kind":12},{"name":"next_tree","range":{"end":{"line":133,"character":9999},"start":{"line":127,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nexus\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-open-bio-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nexus - A TreeIO driver module for parsing Nexus tree output from PAUP\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 't/data/cat_tre.tre');\n  while( my $tree = $in->next_tree ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver module for parsing PAUP Nexus tree format which\nbasically is just a remapping of trees.\n\n=head2 Comments\n\nThe nexus format allows node comments that are placed inside square\nbrackets. Usually the comments (implemented as tags for nodes) are\nused to give a name for an internal node or record the bootstap value,\nbut other uses are possible.\n\nThe FigTree program by Andrew Rambaut adds various rendering\nparameters inside comments and flags these comments by starting them\nwith '&!'. The parameters implemented here are 'label' and 'color'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-open-bio-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::TreeIO::nexus;\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\nuse IO::String;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Args    : -header    => boolean  default is true \n                         print/do not print #NEXUS header\n           -translate => boolean default is true\n                         print/do not print Node Id translation to a number\n\n\nsub _initialize {\n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ( $hdr, $trans ) = $self->_rearrange(\n        [\n            qw(HEADER\n              TRANSLATE)\n        ],\n        @_\n    );\n    $self->header( defined $hdr           ? $hdr   : 1 );\n    $self->translate_node( defined $trans ? $trans : 1 );\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none","label":"next_tree($self)"},"detail":"($self)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_tree","line":128,"kind":13},{"name":"$self","containerName":"next_tree","line":129,"kind":13},{"line":130,"kind":13,"containerName":"next_tree","name":"$self"},{"line":130,"kind":12,"name":"_parse","containerName":"next_tree"},{"line":132,"kind":13,"name":"$self","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","kind":13,"line":132}],"line":127},{"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":135}},"containerName":"main::","name":"rewind","definition":"sub","line":135,"children":[],"kind":12},{"detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse($self)"},"containerName":"main::","definition":"sub","line":139,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_parse","line":140,"kind":13},{"line":142,"kind":13,"containerName":"_parse","name":"$self"},{"containerName":"_parse","name":"$self","line":143,"kind":13},{"kind":13,"line":145,"containerName":"_parse","name":"$self"},{"line":145,"kind":12,"name":"_readline","containerName":"_parse"},{"name":"$self","containerName":"_parse","line":152,"kind":13},{"containerName":"_parse","name":"warn","line":152,"kind":12},{"kind":13,"line":156,"name":"$line","definition":"my","containerName":"_parse","localvar":"my"},{"name":"$self","containerName":"_parse","line":157,"kind":13},{"name":"_readline","containerName":"_parse","kind":12,"line":157},{"containerName":"_parse","name":"$line","kind":13,"line":158},{"kind":13,"line":160,"containerName":"_parse","definition":"my","name":"@sections","localvar":"my"},{"kind":13,"line":160,"containerName":"_parse","name":"$line"},{"line":161,"kind":13,"localvar":"my","definition":"my","name":"$s","containerName":"_parse"},{"name":"@sections","containerName":"_parse","line":161,"kind":13},{"kind":13,"line":162,"containerName":"_parse","name":"%translate","definition":"my","localvar":"my"},{"containerName":"_parse","name":"$self","kind":13,"line":163},{"line":163,"kind":12,"name":"verbose","containerName":"_parse"},{"kind":13,"line":164,"name":"$s","containerName":"_parse"},{"containerName":"_parse","name":"$self","line":165,"kind":13},{"containerName":"_parse","name":"debug","line":165,"kind":12},{"containerName":"_parse","name":"$s","kind":13,"line":169},{"kind":13,"line":172,"containerName":"_parse","name":"$s"},{"line":173,"kind":13,"localvar":"my","containerName":"_parse","name":"$trees","definition":"my"},{"line":174,"kind":13,"containerName":"_parse","name":"$trees"},{"localvar":"my","definition":"my","name":"@trans","containerName":"_parse","line":175,"kind":13},{"definition":"my","name":"$tr","containerName":"_parse","localvar":"my","kind":13,"line":176},{"kind":13,"line":178,"name":"$tr","containerName":"_parse"},{"line":179,"kind":13,"containerName":"_parse","name":"@trans"},{"localvar":"my","containerName":"_parse","definition":"my","name":"$n","line":181,"kind":13},{"name":"@trans","containerName":"_parse","kind":13,"line":181},{"name":"$n","containerName":"_parse","kind":13,"line":182},{"localvar":"my","name":"$id","definition":"my","containerName":"_parse","line":183,"kind":13},{"line":183,"kind":13,"name":"$tag","containerName":"_parse"},{"line":184,"kind":13,"name":"$tag","containerName":"_parse"},{"name":"$translate","containerName":"_parse","kind":13,"line":185},{"line":185,"kind":13,"name":"$id","containerName":"_parse"},{"kind":13,"line":185,"name":"$tag","containerName":"_parse"},{"containerName":"_parse","name":"$self","line":190,"kind":13},{"name":"debug","containerName":"_parse","line":190,"kind":12},{"kind":13,"line":192,"containerName":"_parse","name":"$trees"},{"containerName":"_parse","name":"$tree_name","definition":"my","localvar":"my","kind":13,"line":195},{"kind":13,"line":195,"name":"$tree_str","containerName":"_parse"},{"line":199,"kind":13,"localvar":"my","containerName":"_parse","name":"$buf","definition":"my"},{"line":199,"kind":12,"containerName":"_parse","name":"new"},{"name":"$tree_str","containerName":"_parse","line":199,"kind":13},{"line":200,"kind":13,"localvar":"my","name":"$treeio","definition":"my","containerName":"_parse"},{"containerName":"_parse","name":"new","line":200,"kind":12},{"line":203,"kind":13,"containerName":"_parse","name":"$buf"},{"containerName":"_parse","name":"$tree","definition":"my","localvar":"my","kind":13,"line":204},{"name":"$treeio","containerName":"_parse","line":204,"kind":13},{"line":204,"kind":12,"containerName":"_parse","name":"next_tree"},{"line":205,"kind":13,"localvar":"my","containerName":"_parse","name":"$node","definition":"my"},{"name":"is_Leaf","containerName":"_parse","kind":12,"line":205},{"containerName":"_parse","name":"$tree","line":205,"kind":13},{"name":"get_nodes","containerName":"_parse","kind":12,"line":205},{"localvar":"my","containerName":"_parse","definition":"my","name":"$id","line":206,"kind":13},{"containerName":"_parse","name":"$node","kind":13,"line":206},{"line":206,"kind":12,"containerName":"_parse","name":"id"},{"kind":13,"line":207,"definition":"my","name":"$lookup","containerName":"_parse","localvar":"my"},{"name":"$translate","containerName":"_parse","line":207,"kind":13},{"containerName":"_parse","name":"$id","line":207,"kind":13},{"containerName":"_parse","name":"$node","kind":13,"line":208},{"kind":12,"line":208,"name":"id","containerName":"_parse"},{"containerName":"_parse","name":"$lookup","kind":13,"line":208},{"containerName":"_parse","name":"$id","line":208,"kind":13},{"containerName":"_parse","name":"$tree","kind":13,"line":210},{"name":"id","containerName":"_parse","kind":12,"line":210},{"containerName":"_parse","name":"$tree_name","line":210,"kind":13},{"containerName":"_parse","name":"$tree_name","line":210,"kind":13},{"name":"$self","containerName":"_parse","line":211,"kind":13},{"kind":13,"line":211,"name":"$tree","containerName":"_parse"},{"containerName":"_parse","name":"$self","kind":13,"line":215},{"line":215,"kind":12,"name":"debug","containerName":"_parse"}],"kind":12,"range":{"end":{"line":217,"character":9999},"start":{"character":0,"line":139}},"name":"_parse"},{"line":199,"kind":12,"name":"IO","containerName":"String"},{"line":200,"kind":12,"name":"Bio","containerName":"TreeIO"},{"line":218,"kind":13,"containerName":null,"name":"@sections"},{"line":219,"kind":13,"containerName":null,"name":"$self"},{"name":"debug","containerName":"main::","line":219,"kind":12},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nexus\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-open-bio-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nexus - A TreeIO driver module for parsing Nexus tree output from PAUP\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 't/data/cat_tre.tre');\n  while( my $tree = $in->next_tree ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver module for parsing PAUP Nexus tree format which\nbasically is just a remapping of trees.\n\n=head2 Comments\n\nThe nexus format allows node comments that are placed inside square\nbrackets. Usually the comments (implemented as tags for nodes) are\nused to give a name for an internal node or record the bootstap value,\nbut other uses are possible.\n\nThe FigTree program by Andrew Rambaut adds various rendering\nparameters inside comments and flags these comments by starting them\nwith '&!'. The parameters implemented here are 'label' and 'color'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-open-bio-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::TreeIO::nexus;\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\nuse IO::String;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Args    : -header    => boolean  default is true \n                         print/do not print #NEXUS header\n           -translate => boolean default is true\n                         print/do not print Node Id translation to a number\n\n\nsub _initialize {\n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ( $hdr, $trans ) = $self->_rearrange(\n        [\n            qw(HEADER\n              TRANSLATE)\n        ],\n        @_\n    );\n    $self->header( defined $hdr           ? $hdr   : 1 );\n    $self->translate_node( defined $trans ? $trans : 1 );\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none\n\n\n\nsub next_tree {\n    my ($self) = @_;\n    unless ( $self->{'_parsed'} ) {\n        $self->_parse;\n    }\n    return $self->{'_trees'}->[ $self->{'_treeiter'}++ ];\n}\n\nsub rewind {\n    shift->{'_treeiter'} = 0;\n}\n\nsub _parse {\n    my ($self) = @_;\n\n    $self->{'_parsed'}   = 1;\n    $self->{'_treeiter'} = 0;\n\n    while ( defined( $_ = $self->_readline ) ) {\n        next if /^\\s+$/;\n        last;\n    }\n    return unless ( defined $_ );\n\n    unless (/^\\#NEXUS/i) {\n        $self->warn(\"File does not start with #NEXUS\");    #'\n        return;\n    }\n\n    my $line;\n    while ( defined( $_ = $self->_readline ) ) {\n        $line .= $_;\n    }\n    my @sections = split( /#NEXUS/i, $line );\n    for my $s (@sections) {\n        my %translate;        \n        if ( $self->verbose > 0 ) {\n            while ( $s =~ s/(\\[[^\\]]+\\])// ) {\n                $self->debug(\"removing comment $1\\n\");\n            }\n        }\n        else {\n            $s =~ s/(\\[[^\\]]+\\])//g;\n        }\n        \n        if ( $s =~ /begin trees;(.+)(end;)?/si ) {\n            my $trees = $1;\n            if ( $trees =~ s/\\s+translate\\s+([^;]+);//i ) {\n                my @trans;\n                my $tr = $1;\n\n                while ($tr =~ m{\\s*([^,\\s]+?\\s+(?:'[^']+'|[^'\\s]+)),?}gc) {\n\t            push @trans, $1;\n                }\n                for my $n ( @trans ) {\n                    if ($n  =~ /^\\s*(\\S+)\\s+(.+)$/) {\n                        my ($id,$tag) = ($1,$2);\n                        $tag =~ s/[\\s,]+$//;  # remove the extra spaces of the last taxon\n                        $translate{$id} = $tag;\n                    }                    \n                }\n            }\n            else {\n                $self->debug(\"no translate in: $trees\\n\");\n            }\n            while ($trees =~ /\\s+tree\\s+\\*?\\s*(\\S+)\\s*\\=\n             \\s*(?:\\[\\S+\\])?\\s*([^\\;]+;)/igx)\n            {\n                my ( $tree_name, $tree_str ) = ( $1, $2 );\n\n                # MrBayes does not print colons for node label\n                # $tree_str =~ s/\\)(\\d*\\.\\d+)\\)/:$1/g;\n                my $buf    = IO::String->new($tree_str);\n                my $treeio = Bio::TreeIO->new(\n                    -format => 'newick',\n                    -fh     => $buf\n                );\n                my $tree = $treeio->next_tree;\n                foreach my $node ( grep { $_->is_Leaf } $tree->get_nodes ) {\n                    my $id     = $node->id;\n                    my $lookup = $translate{$id};\n                    $node->id( $lookup || $id );\n                }\n                $tree->id($tree_name) if defined $tree_name;\n                push @{ $self->{'_trees'} }, $tree;\n            }\n        }\n        else {\n            $self->debug(\"begin_trees failed: $s\\n\");\n        }\n    }\n    if ( !@sections ) {\n        $self->debug(\"warn no sections: $line\\n\");\n    }\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI","parameters":[{"label":"$self"},{"label":"@trees"}],"label":"write_tree($self,@trees)"},"detail":"($self,@trees)","kind":12,"children":[{"line":235,"kind":13,"localvar":"my","containerName":"write_tree","name":"$self","definition":"my"},{"kind":13,"line":235,"name":"@trees","containerName":"write_tree"},{"name":"$self","containerName":"write_tree","kind":13,"line":236},{"line":236,"kind":12,"name":"header","containerName":"write_tree"},{"name":"$self","containerName":"write_tree","line":237,"kind":13},{"line":237,"kind":12,"containerName":"write_tree","name":"_print"},{"localvar":"my","name":"$translate","definition":"my","containerName":"write_tree","line":239,"kind":13},{"line":239,"kind":13,"name":"$self","containerName":"write_tree"},{"containerName":"write_tree","name":"translate_node","kind":12,"line":239},{"kind":13,"line":240,"definition":"my","name":"$time","containerName":"write_tree","localvar":"my"},{"kind":13,"line":241,"name":"$self","containerName":"write_tree"},{"kind":12,"line":241,"name":"_print","containerName":"write_tree"},{"name":"$time","containerName":"write_tree","kind":13,"line":241},{"line":243,"kind":13,"localvar":"my","definition":"my","name":"$first","containerName":"write_tree"},{"name":"$nodecter","containerName":"write_tree","kind":13,"line":243},{"kind":13,"line":243,"containerName":"write_tree","name":"%node2num"},{"definition":"my","name":"$tree","containerName":"write_tree","localvar":"my","kind":13,"line":244},{"containerName":"write_tree","name":"@trees","line":244,"kind":13},{"kind":13,"line":246,"name":"$first","containerName":"write_tree"},{"name":"$translate","containerName":"write_tree","line":247,"kind":13},{"name":"$self","containerName":"write_tree","kind":13,"line":249},{"kind":12,"line":249,"name":"_print","containerName":"write_tree"},{"line":250,"kind":13,"name":"$self","containerName":"write_tree"},{"name":"_print","containerName":"write_tree","kind":12,"line":250},{"kind":13,"line":254,"name":"$node2num","containerName":"write_tree"},{"line":254,"kind":12,"name":"id","containerName":"write_tree"},{"name":"$nodecter","containerName":"write_tree","line":254,"kind":13},{"line":255,"kind":13,"containerName":"write_tree","name":"$nodecter"},{"containerName":"write_tree","name":"id","line":255,"kind":12},{"name":"is_Leaf","containerName":"write_tree","kind":12,"line":257},{"containerName":"write_tree","name":"$tree","line":257,"kind":13},{"line":258,"kind":12,"name":"get_nodes","containerName":"write_tree"},{"kind":13,"line":262,"name":"@data","definition":"my","containerName":"write_tree","localvar":"my"},{"kind":13,"line":262,"name":"$tree","containerName":"write_tree"},{"name":"get_root_node","containerName":"write_tree","kind":12,"line":262},{"line":262,"kind":13,"name":"%node2num","containerName":"write_tree"},{"containerName":"write_tree","name":"$data","line":263,"kind":13},{"name":"$data","containerName":"write_tree","kind":13,"line":264},{"line":264,"kind":13,"containerName":"write_tree","name":"$data"},{"line":265,"kind":13,"containerName":"write_tree","name":"$data"},{"line":270,"kind":13,"containerName":"write_tree","name":"$self"},{"containerName":"write_tree","name":"_print","line":270,"kind":12},{"line":273,"kind":13,"containerName":"write_tree","name":"$tree"},{"containerName":"write_tree","name":"id","line":273,"kind":12},{"line":273,"kind":13,"containerName":"write_tree","name":"$first"},{"line":274,"kind":13,"containerName":"write_tree","name":"$tree"},{"name":"get_root_node","containerName":"write_tree","line":274,"kind":12},{"kind":13,"line":275,"name":"@data","containerName":"write_tree"},{"containerName":"write_tree","name":"$first","line":278,"kind":13},{"containerName":"write_tree","name":"$self","line":280,"kind":13},{"name":"_print","containerName":"write_tree","line":280,"kind":12},{"kind":13,"line":281,"containerName":"write_tree","name":"$self"},{"name":"flush","containerName":"write_tree","kind":12,"line":281},{"line":281,"kind":13,"name":"$self","containerName":"write_tree"},{"line":281,"kind":12,"name":"_flush_on_write","containerName":"write_tree"},{"line":281,"kind":13,"containerName":"write_tree","name":"$self"},{"line":281,"kind":12,"name":"_fh","containerName":"write_tree"}],"line":234,"name":"write_tree","range":{"end":{"line":283,"character":9999},"start":{"line":234,"character":0}}},{"kind":12,"line":262,"name":"_write_tree_Helper"},{"signature":{"parameters":[{"label":"$node"},{"label":"$node2num"}],"documentation":"","label":"_write_tree_Helper($node,$node2num)"},"detail":"($node,$node2num)","definition":"sub","containerName":"main::","children":[{"line":286,"kind":13,"localvar":"my","name":"$node","definition":"my","containerName":"_write_tree_Helper"},{"name":"$node2num","containerName":"_write_tree_Helper","kind":13,"line":286},{"kind":13,"line":287,"name":"$node","containerName":"_write_tree_Helper"},{"kind":13,"line":288,"containerName":"_write_tree_Helper","definition":"my","name":"@data","localvar":"my"},{"containerName":"_write_tree_Helper","name":"$n","definition":"my","localvar":"my","kind":13,"line":290},{"containerName":"_write_tree_Helper","name":"$node","kind":13,"line":290},{"name":"each_Descendent","containerName":"_write_tree_Helper","kind":12,"line":290},{"kind":13,"line":291,"containerName":"_write_tree_Helper","name":"@data"},{"line":291,"kind":13,"containerName":"_write_tree_Helper","name":"$n"},{"kind":13,"line":291,"name":"$node2num","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"@data","line":293,"kind":13},{"kind":13,"line":294,"name":"$data","containerName":"_write_tree_Helper"},{"kind":13,"line":294,"name":"$data","containerName":"_write_tree_Helper"},{"name":"$data","containerName":"_write_tree_Helper","kind":13,"line":295},{"line":298,"kind":13,"localvar":"my","definition":"my","name":"$b","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","definition":"my","name":"$bl","localvar":"my","kind":13,"line":300},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":300},{"line":300,"kind":12,"containerName":"_write_tree_Helper","name":"branch_length"},{"name":"$bl","containerName":"_write_tree_Helper","kind":13,"line":301},{"kind":13,"line":303,"name":"$bl","containerName":"_write_tree_Helper"},{"kind":13,"line":304,"name":"$data","containerName":"_write_tree_Helper"},{"line":304,"kind":13,"name":"$bl","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$data","line":307,"kind":13},{"name":"$b","containerName":"_write_tree_Helper","kind":13,"line":309},{"line":309,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"line":309,"kind":12,"name":"bootstrap","containerName":"_write_tree_Helper"},{"line":310,"kind":13,"name":"$data","containerName":"_write_tree_Helper"},{"line":310,"kind":13,"name":"$b","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$b","line":312,"kind":13},{"containerName":"_write_tree_Helper","name":"$node","kind":13,"line":312},{"kind":12,"line":312,"name":"id","containerName":"_write_tree_Helper"},{"line":313,"kind":13,"containerName":"_write_tree_Helper","name":"$b"},{"name":"$node2num","containerName":"_write_tree_Helper","kind":13,"line":313},{"containerName":"_write_tree_Helper","name":"$b","kind":13,"line":313},{"name":"$node2num","containerName":"_write_tree_Helper","line":313,"kind":13},{"kind":13,"line":313,"name":"$b","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$data","line":314,"kind":13},{"kind":13,"line":314,"containerName":"_write_tree_Helper","name":"$b"},{"containerName":"_write_tree_Helper","name":"$b","line":314,"kind":13},{"kind":13,"line":318,"containerName":"_write_tree_Helper","name":"$comment_flag","definition":"my","localvar":"my"},{"containerName":"_write_tree_Helper","name":"$comment_flag","line":319,"kind":13},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":320},{"containerName":"_write_tree_Helper","name":"has_tag","line":320,"kind":12},{"kind":13,"line":320,"containerName":"_write_tree_Helper","name":"$node"},{"name":"has_tag","containerName":"_write_tree_Helper","kind":12,"line":320},{"kind":13,"line":322,"containerName":"_write_tree_Helper","name":"$data"},{"kind":13,"line":322,"name":"$comment_flag","containerName":"_write_tree_Helper"},{"line":324,"kind":13,"name":"$node","containerName":"_write_tree_Helper"},{"name":"has_tag","containerName":"_write_tree_Helper","line":324,"kind":12},{"kind":13,"line":325,"containerName":"_write_tree_Helper","name":"$color","definition":"my","localvar":"my"},{"line":325,"kind":13,"name":"$node","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"get_tag_values","line":325,"kind":12},{"kind":13,"line":326,"name":"$data","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$comment_flag","line":327,"kind":13},{"name":"$node","containerName":"_write_tree_Helper","line":329,"kind":13},{"kind":12,"line":329,"name":"has_tag","containerName":"_write_tree_Helper"},{"localvar":"my","containerName":"_write_tree_Helper","name":"$label","definition":"my","line":330,"kind":13},{"containerName":"_write_tree_Helper","name":"$node","line":330,"kind":13},{"line":330,"kind":12,"name":"get_tag_values","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$data","line":331,"kind":13},{"line":331,"kind":13,"containerName":"_write_tree_Helper","name":"$comment_flag"},{"containerName":"_write_tree_Helper","name":"$data","kind":13,"line":332},{"line":332,"kind":13,"name":"$label","containerName":"_write_tree_Helper"},{"line":334,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"containerName":"_write_tree_Helper","name":"$comment_flag","line":334,"kind":13},{"name":"$node","containerName":"_write_tree_Helper","line":340,"kind":13},{"name":"id","containerName":"_write_tree_Helper","kind":12,"line":340},{"line":340,"kind":13,"name":"$node","containerName":"_write_tree_Helper"},{"line":340,"kind":12,"containerName":"_write_tree_Helper","name":"branch_length"},{"line":341,"kind":13,"localvar":"my","name":"$id","definition":"my","containerName":"_write_tree_Helper"},{"kind":13,"line":341,"name":"$node","containerName":"_write_tree_Helper"},{"kind":12,"line":341,"name":"id","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$node","line":341,"kind":13},{"name":"id","containerName":"_write_tree_Helper","kind":12,"line":341},{"line":342,"kind":13,"containerName":"_write_tree_Helper","name":"$id"},{"containerName":"_write_tree_Helper","name":"$node2num","line":342,"kind":13},{"line":342,"kind":13,"containerName":"_write_tree_Helper","name":"$id"},{"line":343,"kind":13,"name":"$id","containerName":"_write_tree_Helper"},{"name":"$node2num","containerName":"_write_tree_Helper","line":343,"kind":13},{"name":"$id","containerName":"_write_tree_Helper","kind":13,"line":343},{"line":345,"kind":13,"name":"$node","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"has_tag","kind":12,"line":345},{"kind":13,"line":346,"containerName":"_write_tree_Helper","name":"$color","definition":"my","localvar":"my"},{"containerName":"_write_tree_Helper","name":"$node","line":346,"kind":13},{"kind":12,"line":346,"name":"get_tag_values","containerName":"_write_tree_Helper"},{"kind":13,"line":347,"name":"$id","containerName":"_write_tree_Helper"},{"line":349,"kind":13,"containerName":"_write_tree_Helper","name":"@data"},{"line":351,"kind":13,"containerName":"_write_tree_Helper","name":"$id"},{"line":352,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"kind":12,"line":353,"name":"branch_length","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$node","kind":13,"line":353},{"containerName":"_write_tree_Helper","name":"branch_length","line":354,"kind":12},{"containerName":"_write_tree_Helper","name":"@data","kind":13,"line":357}],"line":285,"kind":12,"range":{"end":{"character":9999,"line":358},"start":{"line":285,"character":0}},"name":"_write_tree_Helper"},{"kind":12,"children":[{"line":373,"kind":13,"localvar":"my","containerName":"header","definition":"my","name":"$self"},{"line":375,"kind":13,"containerName":"header","name":"$self"},{"kind":13,"line":376,"name":"$self","containerName":"header"}],"line":372,"definition":"sub","name":"header","containerName":"main::","range":{"start":{"line":372,"character":0},"end":{"character":9999,"line":377}}},{"kind":12,"children":[{"line":392,"kind":13,"localvar":"my","containerName":"translate_node","definition":"my","name":"$self"},{"kind":13,"line":394,"containerName":"translate_node","name":"$self"},{"line":395,"kind":13,"name":"$self","containerName":"translate_node"}],"line":391,"definition":"sub","name":"translate_node","containerName":"main::","range":{"end":{"line":396,"character":9999},"start":{"character":0,"line":391}}}],"version":5}