{"version":5,"vars":[{"line":124,"kind":2,"containerName":"","name":"vars"},{"containerName":"","name":"base","line":128,"kind":2},{"containerName":null,"name":"%Defaults","kind":13,"line":129},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: lintree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::lintree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::lintree - Parser for lintree output trees\n\n=head1 SYNOPSIS\n\n  # do not use directly, use through Bio::TreeIO\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'lintree',\n                               -file   => 't/data/crab.nj');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nParser for the lintree output which looks like this\n\n  13 sequences     1000 bootstraping\n1 A-salina\n2 C-vittat\n3 C-sp.\n4 L-aequit\n5 P-camtsc\n6 E-tenuim\n7 L-splend\n8 P-bernha\n9 P-acadia\n10 P-p(NE)\n11 P-p(GU)\n12 P-l(NE)\n13 P-l(GU)\n 14 and   2        0.098857      1000\n 14 and   3        0.127932      1000\n 15 and   1        0.197471      1000\n 15 and  14        0.029273       874\n 16 and  10        0.011732      1000\n 16 and  11        0.004529      1000\n 17 and  12        0.002258      1000\n 17 and  13        0.000428      1000\n 18 and  16        0.017512      1000\n 18 and  17        0.010824       998\n 19 and   4        0.006534      1000\n 19 and   5        0.006992      1000\n 20 and  15        0.070461      1000\n 20 and  18        0.030579       998\n 21 and   8        0.003339      1000\n 21 and   9        0.002042      1000\n 22 and   6        0.011142      1000\n 22 and  21        0.010693       983\n 23 and  20        0.020714       996\n 23 and  19        0.020350      1000\n 24 and  23        0.008665       826\n 24 and  22        0.013457       972\n 24 and   7        0.025598      1000\n\nSee http://www.bio.psu.edu/People/Faculty/Nei/Lab/software.htm for access\nto the program and N Takezaki, A Rzhetsky, and M Nei, \"Phylogenetic test\nof the molecular clock and linearized trees.\" Mol Biol Evol 12(5):823-33.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nIdeas and discussion from:\n Alan Christoffels\n Avril Coghlan\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::lintree;\nuse vars qw(%Defaults);\nuse strict;\n\n\nuse base qw(Bio::TreeIO);\n$Defaults{'NodeType'} = \"Bio::Tree::Node\";\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::lintree->new();\n Function: Builds a new Bio::TreeIO::lintree object \n Returns : an instance of Bio::TreeIO::lintree\n Args    : -nodetype => Node type to create [default Bio::Tree::Node]","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"kind":12,"line":142,"children":[{"kind":13,"line":143,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"_initialize","kind":13,"line":143},{"kind":13,"line":144,"containerName":"_initialize","name":"$self"},{"line":144,"kind":13,"name":"@args","containerName":"_initialize"},{"name":"$nodetype","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":145},{"line":145,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":145},{"kind":13,"line":145,"containerName":"_initialize","name":"@args"},{"name":"$nodetype","containerName":"_initialize","line":146,"kind":13},{"containerName":"_initialize","name":"$Defaults","kind":13,"line":146},{"line":147,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"nodetype","containerName":"_initialize","kind":12,"line":147},{"line":147,"kind":13,"name":"$nodetype","containerName":"_initialize"}],"name":"_initialize","range":{"end":{"character":9999,"line":148},"start":{"character":0,"line":142}}},{"kind":12,"line":144,"containerName":"_initialize","name":"SUPER"},{"range":{"start":{"line":161,"character":0},"end":{"line":198,"character":9999}},"name":"next_tree","line":161,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_tree","line":162,"kind":13},{"localvar":"my","name":"$seentop","definition":"my","containerName":"next_tree","line":163,"kind":13},{"definition":"my","name":"$tipcount","containerName":"next_tree","localvar":"my","kind":13,"line":164},{"containerName":"next_tree","name":"%data","line":164,"kind":13},{"kind":13,"line":164,"containerName":"next_tree","name":"@nodes"},{"localvar":"my","definition":"my","name":"$nodetype","containerName":"next_tree","line":165,"kind":13},{"line":165,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"line":165,"name":"nodetype","containerName":"next_tree"},{"name":"$self","containerName":"next_tree","line":167,"kind":13},{"kind":12,"line":167,"containerName":"next_tree","name":"_readline"},{"line":169,"kind":13,"containerName":"next_tree","name":"$seentop"},{"containerName":"next_tree","name":"$self","line":170,"kind":13},{"line":170,"kind":12,"containerName":"next_tree","name":"_pushback"},{"kind":13,"line":173,"containerName":"next_tree","name":"$tipcount"},{"containerName":"next_tree","name":"$seentop","kind":13,"line":174},{"containerName":"next_tree","name":"$data","kind":13,"line":177},{"containerName":"next_tree","name":"$data","kind":13,"line":178},{"containerName":"next_tree","name":"$nodes","kind":13,"line":180},{"name":"$node","definition":"my","containerName":"next_tree","localvar":"my","kind":13,"line":182},{"name":"$descend","containerName":"next_tree","line":182,"kind":13},{"kind":13,"line":182,"name":"$blength","containerName":"next_tree"},{"containerName":"next_tree","name":"$bootstrap","line":182,"kind":13},{"line":185,"kind":13,"name":"$node","containerName":"next_tree"},{"containerName":"next_tree","name":"$descend","kind":13,"line":185},{"name":"$nodes","containerName":"next_tree","line":186,"kind":13},{"name":"$descend","containerName":"next_tree","line":186,"kind":13},{"line":186,"kind":13,"name":"$blength","containerName":"next_tree"},{"containerName":"next_tree","name":"$nodes","kind":13,"line":187},{"line":187,"kind":13,"name":"$descend","containerName":"next_tree"},{"kind":13,"line":187,"containerName":"next_tree","name":"$bootstrap"},{"containerName":"next_tree","name":"$nodes","line":188,"kind":13},{"kind":13,"line":188,"name":"$node","containerName":"next_tree"},{"containerName":"next_tree","name":"$node","line":188,"kind":13},{"name":"$nodes","containerName":"next_tree","line":189,"kind":13},{"name":"$node","containerName":"next_tree","line":189,"kind":13},{"name":"$descend","containerName":"next_tree","line":189,"kind":13},{"containerName":"next_tree","name":"$data","line":192,"kind":13},{"containerName":"next_tree","name":"$data","kind":13,"line":194},{"name":"$data","containerName":"next_tree","line":196,"kind":13}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: lintree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::lintree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::lintree - Parser for lintree output trees\n\n=head1 SYNOPSIS\n\n  # do not use directly, use through Bio::TreeIO\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'lintree',\n                               -file   => 't/data/crab.nj');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nParser for the lintree output which looks like this\n\n  13 sequences     1000 bootstraping\n1 A-salina\n2 C-vittat\n3 C-sp.\n4 L-aequit\n5 P-camtsc\n6 E-tenuim\n7 L-splend\n8 P-bernha\n9 P-acadia\n10 P-p(NE)\n11 P-p(GU)\n12 P-l(NE)\n13 P-l(GU)\n 14 and   2        0.098857      1000\n 14 and   3        0.127932      1000\n 15 and   1        0.197471      1000\n 15 and  14        0.029273       874\n 16 and  10        0.011732      1000\n 16 and  11        0.004529      1000\n 17 and  12        0.002258      1000\n 17 and  13        0.000428      1000\n 18 and  16        0.017512      1000\n 18 and  17        0.010824       998\n 19 and   4        0.006534      1000\n 19 and   5        0.006992      1000\n 20 and  15        0.070461      1000\n 20 and  18        0.030579       998\n 21 and   8        0.003339      1000\n 21 and   9        0.002042      1000\n 22 and   6        0.011142      1000\n 22 and  21        0.010693       983\n 23 and  20        0.020714       996\n 23 and  19        0.020350      1000\n 24 and  23        0.008665       826\n 24 and  22        0.013457       972\n 24 and   7        0.025598      1000\n\nSee http://www.bio.psu.edu/People/Faculty/Nei/Lab/software.htm for access\nto the program and N Takezaki, A Rzhetsky, and M Nei, \"Phylogenetic test\nof the molecular clock and linearized trees.\" Mol Biol Evol 12(5):823-33.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nIdeas and discussion from:\n Alan Christoffels\n Avril Coghlan\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::lintree;\nuse vars qw(%Defaults);\nuse strict;\n\n\nuse base qw(Bio::TreeIO);\n$Defaults{'NodeType'} = \"Bio::Tree::Node\";\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::lintree->new();\n Function: Builds a new Bio::TreeIO::lintree object \n Returns : an instance of Bio::TreeIO::lintree\n Args    : -nodetype => Node type to create [default Bio::Tree::Node]\n\n\n\nsub _initialize { \n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($nodetype) = $self->_rearrange([qw(NODETYPE)],@args);\n    $nodetype ||= $Defaults{'NodeType'};\n    $self->nodetype($nodetype);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none","label":"next_tree($self)"},"containerName":"main::","definition":"sub"},{"kind":13,"line":199,"name":"@nodes","containerName":null},{"name":"@treenodes","definition":"my","containerName":null,"localvar":"my","kind":13,"line":200},{"kind":13,"line":201,"containerName":null,"definition":"my","name":"$n","localvar":"my"},{"containerName":null,"name":"@nodes","line":201,"kind":13},{"name":"@treenodes","containerName":null,"kind":13,"line":202},{"containerName":null,"name":"$nodetype","line":202,"kind":13},{"name":"new","containerName":"main::","kind":12,"line":202},{"name":"$n","containerName":null,"line":202,"kind":13},{"line":205,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$tn"},{"name":"@treenodes","containerName":null,"line":205,"kind":13},{"line":206,"kind":13,"localvar":"my","definition":"my","name":"$n","containerName":null},{"name":"@nodes","containerName":null,"line":206,"kind":13},{"kind":13,"line":207,"definition":"my","name":"$ptr","containerName":null,"localvar":"my"},{"name":"%n","containerName":null,"line":207,"kind":13},{"containerName":null,"name":"$tn","line":208,"kind":13},{"kind":12,"line":208,"name":"add_Descendent","containerName":"main::"},{"line":208,"kind":13,"containerName":null,"name":"@treenodes"},{"kind":13,"line":208,"containerName":null,"name":"$ptr"},{"kind":13,"line":211,"definition":"my","name":"$T","containerName":null,"localvar":"my"},{"name":"Bio","containerName":"Tree::Tree","line":211,"kind":12},{"kind":12,"line":211,"containerName":"main::","name":"new"},{"containerName":null,"name":"@treenodes","line":211,"kind":13},{"line":212,"kind":13,"containerName":null,"name":"%data"},{"localvar":"my","containerName":null,"name":"$outgroup","definition":"my","line":213,"kind":13},{"line":213,"kind":13,"name":"@treenodes","containerName":null},{"line":213,"kind":13,"containerName":null,"name":"%data"},{"kind":13,"line":214,"containerName":null,"name":"%outgroup"},{"kind":13,"line":215,"name":"$self","containerName":null},{"line":215,"kind":12,"name":"warn","containerName":"main::"},{"containerName":null,"name":"%data","line":215,"kind":13},{"kind":13,"line":217,"name":"$T","containerName":null},{"line":217,"kind":12,"name":"reroot","containerName":"main::"},{"containerName":null,"name":"$outgroup","kind":13,"line":217},{"kind":12,"line":217,"name":"ancestor","containerName":"main::"},{"kind":13,"line":220,"containerName":null,"name":"$T"},{"kind":12,"line":238,"children":[{"line":239,"kind":13,"localvar":"my","containerName":"nodetype","definition":"my","name":"$self"},{"line":239,"kind":13,"name":"$value","containerName":"nodetype"},{"containerName":"nodetype","name":"$value","kind":13,"line":240},{"name":"$self","containerName":"nodetype","kind":13,"line":242},{"name":"throw","containerName":"nodetype","kind":12,"line":242},{"kind":13,"line":242,"containerName":"nodetype","name":"$self"},{"line":245,"kind":13,"localvar":"my","containerName":"nodetype","name":"$a","definition":"my"},{"kind":13,"line":245,"containerName":"nodetype","name":"$value"},{"kind":13,"line":246,"name":"$a","containerName":"nodetype"},{"name":"isa","containerName":"nodetype","kind":12,"line":246},{"containerName":"nodetype","name":"$self","kind":13,"line":247},{"line":247,"kind":12,"name":"throw","containerName":"nodetype"},{"kind":13,"line":249,"containerName":"nodetype","name":"$self"},{"name":"$value","containerName":"nodetype","kind":13,"line":249},{"line":251,"kind":13,"containerName":"nodetype","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: lintree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::lintree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::lintree - Parser for lintree output trees\n\n=head1 SYNOPSIS\n\n  # do not use directly, use through Bio::TreeIO\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'lintree',\n                               -file   => 't/data/crab.nj');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nParser for the lintree output which looks like this\n\n  13 sequences     1000 bootstraping\n1 A-salina\n2 C-vittat\n3 C-sp.\n4 L-aequit\n5 P-camtsc\n6 E-tenuim\n7 L-splend\n8 P-bernha\n9 P-acadia\n10 P-p(NE)\n11 P-p(GU)\n12 P-l(NE)\n13 P-l(GU)\n 14 and   2        0.098857      1000\n 14 and   3        0.127932      1000\n 15 and   1        0.197471      1000\n 15 and  14        0.029273       874\n 16 and  10        0.011732      1000\n 16 and  11        0.004529      1000\n 17 and  12        0.002258      1000\n 17 and  13        0.000428      1000\n 18 and  16        0.017512      1000\n 18 and  17        0.010824       998\n 19 and   4        0.006534      1000\n 19 and   5        0.006992      1000\n 20 and  15        0.070461      1000\n 20 and  18        0.030579       998\n 21 and   8        0.003339      1000\n 21 and   9        0.002042      1000\n 22 and   6        0.011142      1000\n 22 and  21        0.010693       983\n 23 and  20        0.020714       996\n 23 and  19        0.020350      1000\n 24 and  23        0.008665       826\n 24 and  22        0.013457       972\n 24 and   7        0.025598      1000\n\nSee http://www.bio.psu.edu/People/Faculty/Nei/Lab/software.htm for access\nto the program and N Takezaki, A Rzhetsky, and M Nei, \"Phylogenetic test\nof the molecular clock and linearized trees.\" Mol Biol Evol 12(5):823-33.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nIdeas and discussion from:\n Alan Christoffels\n Avril Coghlan\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::lintree;\nuse vars qw(%Defaults);\nuse strict;\n\n\nuse base qw(Bio::TreeIO);\n$Defaults{'NodeType'} = \"Bio::Tree::Node\";\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::lintree->new();\n Function: Builds a new Bio::TreeIO::lintree object \n Returns : an instance of Bio::TreeIO::lintree\n Args    : -nodetype => Node type to create [default Bio::Tree::Node]\n\n\n\nsub _initialize { \n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($nodetype) = $self->_rearrange([qw(NODETYPE)],@args);\n    $nodetype ||= $Defaults{'NodeType'};\n    $self->nodetype($nodetype);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none\n\n\n\nsub next_tree {\n    my ($self) = @_;\n    my $seentop = 0;\n    my ($tipcount,%data,@nodes) = (0);\n    my $nodetype = $self->nodetype;   \n\n    while( defined( $_ = $self->_readline) ) {\n\tif( /^\\s*(\\d+)\\s+sequences/ox ) {\n\t    if( $seentop ) { \n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $tipcount = $1;\n\t    $seentop = 1;\n\t} elsif( /^(\\d+)\\s+(\\S+)\\s*$/ox ) {\n\t    # deal with setting an outgroup\n\t    unless( defined $data{'outgroup'} ) {\n\t\t$data{'outgroup'} = [$1,$2];\n\t    }\n\t    $nodes[$1 - 1] = { '-id' => $2 }; \n\t} elsif( m/^\\s*(\\d+)\\s+and\\s+(\\d+)\\s+(\\-?\\d+\\.\\d+)(?:\\s+(\\d+))?/ox ) {\n\t    my ($node,$descend,$blength,$bootstrap) = ( $1, $2, $3, $4 );\n\t    # need to -- descend and node because\n\t    # array is 0 based\n\t    $node--;$descend--;\n\t    $nodes[$descend]->{'-branch_length'} = $blength;\n\t    $nodes[$descend]->{'-bootstrap'}     = $bootstrap; #? here\n\t    $nodes[$node]->{'-id'} = $node+1;\n\t    push @{$nodes[$node]->{'-d'}}, $descend;\n\t    \n\t} elsif( /\\s+(\\S+)\\-distance was used\\./ox ) {\n\t    $data{'method'} = $1;\n\t} elsif( /\\s*seed=(\\d+)/ox ) {\n\t    $data{'seed'} = $1;\n\t} elsif( m/^outgroup:\\s+(\\d+)\\s+(\\S+)/ox ) {\n\t    $data{'outgroup'} = [$1,$2];\n\t}\n    }\n    if( @nodes ) {\n\tmy @treenodes;\n\tforeach my $n ( @nodes ) { \t\n\t    push @treenodes, $nodetype->new(%{$n});\n\t}\n\t\n\tforeach my $tn ( @treenodes ) {\n\t    my $n = shift @nodes;\n\t    for my $ptr ( @{ $n->{'-d'} || [] } ) {\n\t\t$tn->add_Descendent($treenodes[$ptr]);\n\t    }\n\t}\n\tmy $T = Bio::Tree::Tree->new(-root => (pop @treenodes) );\n\tif( $data{'outgroup'} ) {\n\t    my ($outgroup) = $treenodes[$data{'outgroup'}->[0]];\n\t    if( ! defined $outgroup) {\n\t\t$self->warn(\"cannot find '\". $data{'outgroup'}->[1]. \"'\\n\");\n\t    } else { \n\t\t$T->reroot($outgroup->ancestor);\n\t    }\n\t}\n\treturn $T;\n    }\n    return; # if there are no more trees, return undef\n\t\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Example : \n Returns : value of nodetype (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","label":"nodetype($self,$value)"},"name":"nodetype","range":{"end":{"character":9999,"line":252},"start":{"character":0,"line":238}}}]}