{"version":5,"vars":[{"line":89,"kind":2,"name":"base","containerName":""},{"kind":12,"line":101,"children":[{"kind":13,"line":102,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"line":102,"kind":13,"name":"@args","containerName":"new"},{"line":103,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"kind":13,"line":103,"name":"$class","containerName":"new"},{"line":103,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$to_string_cb","definition":"my","localvar":"my","kind":13,"line":104},{"kind":13,"line":104,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":104,"kind":12},{"kind":13,"line":104,"name":"@args","containerName":"new"},{"containerName":"new","name":"$to_string_cb","line":105,"kind":13},{"kind":13,"line":106,"name":"$self","containerName":"new"},{"name":"to_string_callback","containerName":"new","kind":12,"line":106},{"kind":13,"line":106,"name":"$to_string_cb","containerName":"new"},{"kind":13,"line":108,"containerName":"new","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)","label":"new($class,@args)"},"name":"new","range":{"start":{"line":101,"character":0},"end":{"line":109,"character":9999}}},{"containerName":"new","name":"SUPER","kind":12,"line":103},{"range":{"start":{"character":0,"line":111},"end":{"character":9999,"line":115}},"name":"DESTROY","detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"DESTROY($self)"},"containerName":"main::","definition":"sub","line":111,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"DESTROY","line":112,"kind":13},{"name":"$self","containerName":"DESTROY","kind":13,"line":114}],"kind":12},{"containerName":"DESTROY","name":"SUPER","line":114,"kind":12},{"name":"annotation","range":{"end":{"character":9999,"line":147},"start":{"character":0,"line":134}},"kind":12,"children":[{"containerName":"annotation","definition":"my","name":"$self","localvar":"my","kind":13,"line":136},{"kind":13,"line":136,"name":"$value","containerName":"annotation"},{"line":137,"kind":13,"containerName":"annotation","name":"$value"},{"line":138,"kind":13,"name":"$self","containerName":"annotation"},{"name":"throw","containerName":"annotation","line":138,"kind":12},{"containerName":"annotation","name":"$value","kind":13,"line":138},{"line":139,"kind":13,"containerName":"annotation","name":"$value"},{"name":"isa","containerName":"annotation","line":139,"kind":12},{"kind":13,"line":140,"name":"$self","containerName":"annotation"},{"name":"$value","containerName":"annotation","kind":13,"line":140},{"containerName":"annotation","name":"$self","kind":13,"line":142},{"line":144,"kind":13,"containerName":"annotation","name":"$self"},{"line":144,"kind":12,"containerName":"annotation","name":"new"},{"kind":13,"line":146,"containerName":"annotation","name":"$self"}],"line":134,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information","parameters":[{"label":"$self"},{"label":"$value"}],"label":"annotation($self,$value)"},"detail":"($self,$value)"},{"kind":12,"line":144,"name":"Bio","containerName":"Annotation::Collection"},{"range":{"end":{"character":9999,"line":175},"start":{"line":165,"character":0}},"name":"add_tag_value","line":165,"children":[{"containerName":"add_tag_value","definition":"my","name":"$self","localvar":"my","kind":13,"line":167},{"line":167,"kind":13,"name":"$tag","containerName":"add_tag_value"},{"kind":13,"line":167,"name":"$value","containerName":"add_tag_value"},{"containerName":"add_tag_value","name":"$tag","line":168,"kind":13},{"name":"$value","containerName":"add_tag_value","line":168,"kind":13},{"line":169,"kind":13,"name":"$self","containerName":"add_tag_value"},{"kind":12,"line":169,"containerName":"add_tag_value","name":"warn"},{"line":171,"kind":13,"localvar":"my","containerName":"add_tag_value","name":"$ac","definition":"my"},{"kind":13,"line":171,"name":"$self","containerName":"add_tag_value"},{"containerName":"add_tag_value","name":"annotation","line":171,"kind":12},{"kind":13,"line":172,"definition":"my","name":"$sv","containerName":"add_tag_value","localvar":"my"},{"kind":12,"line":172,"containerName":"add_tag_value","name":"new"},{"name":"$value","containerName":"add_tag_value","line":172,"kind":13},{"line":173,"kind":13,"name":"$ac","containerName":"add_tag_value"},{"name":"add_Annotation","containerName":"add_tag_value","line":173,"kind":12},{"name":"$tag","containerName":"add_tag_value","line":173,"kind":13},{"line":173,"kind":13,"name":"$sv","containerName":"add_tag_value"},{"containerName":"add_tag_value","name":"$ac","line":174,"kind":13},{"containerName":"add_tag_value","name":"get_Annotations","kind":12,"line":174},{"containerName":"add_tag_value","name":"$tag","line":174,"kind":13}],"kind":12,"detail":"($self,$tag,$value)","signature":{"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"$value"}],"label":"add_tag_value($self,$tag,$value)"},"containerName":"main::","definition":"sub"},{"line":172,"kind":12,"name":"Bio","containerName":"Annotation::SimpleValue"},{"range":{"end":{"line":192,"character":9999},"start":{"character":0,"line":188}},"name":"remove_tag","detail":"($self,$tag)","signature":{"parameters":[{"label":"$self"},{"label":"$tag"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove","label":"remove_tag($self,$tag)"},"containerName":"main::","definition":"sub","line":188,"children":[{"localvar":"my","containerName":"remove_tag","definition":"my","name":"$self","line":190,"kind":13},{"containerName":"remove_tag","name":"$tag","line":190,"kind":13},{"localvar":"my","name":"$ac","definition":"my","containerName":"remove_tag","line":191,"kind":13},{"kind":13,"line":191,"name":"$self","containerName":"remove_tag"},{"containerName":"remove_tag","name":"annotation","kind":12,"line":191},{"containerName":"remove_tag","name":"$ac","kind":13,"line":192},{"line":192,"kind":12,"containerName":"remove_tag","name":"get_Annotations"},{"kind":13,"line":192,"name":"$tag","containerName":"remove_tag"}],"kind":12},{"line":193,"kind":13,"name":"$ac","containerName":null},{"containerName":"main::","name":"remove_Annotations","kind":12,"line":193},{"line":193,"kind":13,"name":"$tag","containerName":null},{"name":"remove_all_tags","range":{"start":{"line":209,"character":0},"end":{"character":9999,"line":215}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"remove_all_tags","line":211,"kind":13},{"kind":13,"line":212,"name":"$ac","definition":"my","containerName":"remove_all_tags","localvar":"my"},{"kind":13,"line":212,"name":"$self","containerName":"remove_all_tags"},{"kind":12,"line":212,"containerName":"remove_all_tags","name":"annotation"},{"line":213,"kind":13,"containerName":"remove_all_tags","name":"$ac"},{"name":"remove_Annotations","containerName":"remove_all_tags","line":213,"kind":12}],"line":209,"definition":"sub","containerName":"main::","signature":{"label":"remove_all_tags($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None"},"detail":"($self)"},{"name":"get_all_tags","range":{"end":{"character":9999,"line":233},"start":{"character":0,"line":227}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None","label":"get_all_tags($self)"},"kind":12,"line":227,"children":[{"localvar":"my","containerName":"get_all_tags","name":"$self","definition":"my","line":228,"kind":13},{"localvar":"my","containerName":"get_all_tags","name":"$ac","definition":"my","line":229,"kind":13},{"name":"$self","containerName":"get_all_tags","kind":13,"line":229},{"kind":12,"line":229,"containerName":"get_all_tags","name":"annotation"},{"localvar":"my","definition":"my","name":"@tags","containerName":"get_all_tags","line":230,"kind":13},{"containerName":"get_all_tags","name":"$ac","kind":13,"line":230},{"containerName":"get_all_tags","name":"get_all_annotation_keys","line":230,"kind":12},{"line":232,"kind":13,"containerName":"get_all_tags","name":"@tags"}]},{"line":245,"children":[{"localvar":"my","containerName":"get_tag_values","definition":"my","name":"$self","line":246,"kind":13},{"kind":13,"line":246,"name":"$tag","containerName":"get_tag_values"},{"localvar":"my","containerName":"get_tag_values","name":"$ac","definition":"my","line":247,"kind":13},{"line":247,"kind":13,"name":"$self","containerName":"get_tag_values"},{"kind":12,"line":247,"containerName":"get_tag_values","name":"annotation"},{"kind":13,"line":248,"containerName":"get_tag_values","definition":"my","name":"@values","localvar":"my"},{"name":"value","containerName":"get_tag_values","line":248,"kind":12},{"name":"$ac","containerName":"get_tag_values","line":248,"kind":13},{"containerName":"get_tag_values","name":"get_Annotations","line":248,"kind":12},{"containerName":"get_tag_values","name":"$tag","line":248,"kind":13},{"name":"@values","containerName":"get_tag_values","kind":13,"line":249}],"kind":12,"detail":"($self,$tag)","signature":{"label":"get_tag_values($self,$tag)","documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name","parameters":[{"label":"$self"},{"label":"$tag"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":245,"character":0},"end":{"character":9999,"line":250}},"name":"get_tag_values"},{"line":262,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"has_tag","line":263,"kind":13},{"containerName":"has_tag","name":"$tag","line":263,"kind":13},{"kind":13,"line":264,"containerName":"has_tag","name":"$ac","definition":"my","localvar":"my"},{"kind":13,"line":264,"containerName":"has_tag","name":"$self"},{"name":"annotation","containerName":"has_tag","kind":12,"line":264},{"containerName":"has_tag","name":"$ac","line":265,"kind":13},{"containerName":"has_tag","name":"get_Annotations","kind":12,"line":265},{"name":"$tag","containerName":"has_tag","line":265,"kind":13}],"kind":12,"detail":"($self,$tag)","signature":{"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"has_tag($self,$tag)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":266},"start":{"line":262,"character":0}},"name":"has_tag"},{"range":{"end":{"character":9999,"line":296},"start":{"line":283,"character":0}},"name":"to_string_callback","signature":{"label":"to_string_callback($self,$foo)","documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  return ( scalar $ac->get_Annotations($tag) > 0);\n}\n\n\n=head1 Methods for implementing to_string\n\n\n=head2 to_string_callback\n\n Title   : to_string_callback\n Usage   : $node->to_string_callback(\\&func)\n Function: get/set callback for to_string\n Returns : code reference for the to_string callback function\n Args    : \\&func - code reference to be set as the callback function","parameters":[{"label":"$self"},{"label":"$foo"}]},"detail":"($self,$foo)","definition":"sub","containerName":"main::","children":[{"line":285,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"to_string_callback"},{"kind":13,"line":285,"name":"$foo","containerName":"to_string_callback"},{"containerName":"to_string_callback","name":"$foo","line":286,"kind":13},{"line":288,"kind":13,"name":"$self","containerName":"to_string_callback"},{"name":"$foo","containerName":"to_string_callback","kind":13,"line":288},{"name":"$self","containerName":"to_string_callback","line":291,"kind":13},{"name":"$self","containerName":"to_string_callback","kind":13,"line":292},{"line":295,"kind":13,"name":"$self","containerName":"to_string_callback"}],"line":283,"kind":12},{"kind":12,"line":295,"containerName":"Tree::NodeI::to_string","name":"Bio"},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"to_string","localvar":"my","kind":13,"line":299},{"kind":13,"line":300,"definition":"my","name":"$cb","containerName":"to_string","localvar":"my"},{"containerName":"to_string","name":"$self","line":300,"kind":13},{"containerName":"to_string","name":"to_string_callback","line":300,"kind":12},{"kind":13,"line":301,"containerName":"to_string","name":"$cb"},{"line":301,"kind":13,"containerName":"to_string","name":"$self"}],"line":298,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"to_string($self)"},"detail":"($self)","name":"to_string","range":{"end":{"line":302,"character":9999},"start":{"line":298,"character":0}}},{"range":{"end":{"character":9999,"line":328},"start":{"character":0,"line":321}},"name":"sequence","children":[{"localvar":"my","containerName":"sequence","name":"$self","definition":"my","line":323,"kind":13},{"name":"$value","containerName":"sequence","kind":13,"line":323},{"containerName":"sequence","name":"$value","kind":13,"line":324},{"containerName":"sequence","name":"$self","line":325,"kind":13},{"line":325,"kind":12,"containerName":"sequence","name":"throw"},{"name":"$value","containerName":"sequence","kind":13,"line":325},{"name":"$value","containerName":"sequence","kind":13,"line":326},{"containerName":"sequence","name":"isa","kind":12,"line":326},{"kind":13,"line":327,"name":"$self","containerName":"sequence"},{"containerName":"sequence","name":"$value","kind":13,"line":327}],"line":321,"kind":12,"signature":{"label":"sequence($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  return ( scalar $ac->get_Annotations($tag) > 0);\n}\n\n\n=head1 Methods for implementing to_string\n\n\n=head2 to_string_callback\n\n Title   : to_string_callback\n Usage   : $node->to_string_callback(\\&func)\n Function: get/set callback for to_string\n Returns : code reference for the to_string callback function\n Args    : \\&func - code reference to be set as the callback function\n\n\nsub to_string_callback {\n    # get/set callback, using $DEFAULT_CB if nothing is set\n    my ($self, $foo) = @_;\n    if ($foo) {\n      # $foo is callback code ref, self as first arg (so you have access to object data)\n      $self->{'_to_string_cb'} = $foo;\n    }\n    else {\n      if (! defined $self->{'_to_string_cb'}) {\n        $self->{'_to_string_cb'} = \\&Bio::Tree::NodeI::to_string;\n      }\n    }\n    return $self->{'_to_string_cb'};\n}\n\nsub to_string {\n  my ($self) = @_;\n  my $cb = $self->to_string_callback();\n  return $cb->($self);\n}\n\n=head1 Methods for accessing Bio::Seq\n\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $ann = $node->sequence or \n           $node->sequence($seq)\n Function: Gets or sets the sequence\n Returns : array reference of Bio::SeqI objects\n Args    : None or Bio::SeqI object\nSee L<Bio::SeqI> and L<Bio::Seq>\nfor more information"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"containerName":null,"name":"%self","kind":13,"line":333},{"name":"has_sequence","range":{"end":{"line":349,"character":9999},"start":{"line":346,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"has_sequence($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  return ( scalar $ac->get_Annotations($tag) > 0);\n}\n\n\n=head1 Methods for implementing to_string\n\n\n=head2 to_string_callback\n\n Title   : to_string_callback\n Usage   : $node->to_string_callback(\\&func)\n Function: get/set callback for to_string\n Returns : code reference for the to_string callback function\n Args    : \\&func - code reference to be set as the callback function\n\n\nsub to_string_callback {\n    # get/set callback, using $DEFAULT_CB if nothing is set\n    my ($self, $foo) = @_;\n    if ($foo) {\n      # $foo is callback code ref, self as first arg (so you have access to object data)\n      $self->{'_to_string_cb'} = $foo;\n    }\n    else {\n      if (! defined $self->{'_to_string_cb'}) {\n        $self->{'_to_string_cb'} = \\&Bio::Tree::NodeI::to_string;\n      }\n    }\n    return $self->{'_to_string_cb'};\n}\n\nsub to_string {\n  my ($self) = @_;\n  my $cb = $self->to_string_callback();\n  return $cb->($self);\n}\n\n=head1 Methods for accessing Bio::Seq\n\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $ann = $node->sequence or \n           $node->sequence($seq)\n Function: Gets or sets the sequence\n Returns : array reference of Bio::SeqI objects\n Args    : None or Bio::SeqI object\nSee L<Bio::SeqI> and L<Bio::Seq>\nfor more information\n\n\nsub sequence\n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::SeqI. Too bad.\")      unless $value->isa(\"Bio::SeqI\");\n    push (@{$self->{'_sequence'}}, $value);\n  } \n  #elsif( ! defined $self->{'_sequence'}) \n  #{\n  #  $self->{'_sequence'} = Bio::Seq->new();\n  #}\n  return $self->{'_sequence'};\n}\n\n=head2 has_sequence\n\n Title   : has_sequence\n Usage   : if( $node->has_sequence) { # do something } \n Function: tells if node has sequence attached\n Returns : Boolean for whether or not node has Bio::SeqI attached.\n Args    : None "},"detail":"($self)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"has_sequence","localvar":"my","kind":13,"line":348},{"name":"$self","containerName":"has_sequence","kind":13,"line":349},{"containerName":"has_sequence","name":"$self","line":349,"kind":13}],"line":346}]}