{"version":5,"vars":[{"containerName":"","name":"base","line":211,"kind":2},{"definition":1,"name":"DPALIGN_LOCAL_MILLER_MYERS","containerName":"main::","kind":14,"line":219},{"containerName":"main::","name":"DPALIGN_GLOBAL_MILLER_MYERS","definition":1,"kind":14,"line":220},{"line":221,"kind":14,"containerName":"main::","name":"DPALIGN_ENDSFREE_MILLER_MYERS","definition":1},{"line":235,"kind":12,"name":"Bio","containerName":"Ext::Align"},{"range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":241}},"name":"new","line":241,"children":[{"kind":13,"line":242,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","line":242,"kind":13},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":244,"kind":13},{"line":244,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":244,"kind":13},{"line":246,"kind":13,"localvar":"my","containerName":"new","name":"$match","definition":"my"},{"line":246,"kind":13,"name":"$mismatch","containerName":"new"},{"line":246,"kind":13,"containerName":"new","name":"$gap"},{"kind":13,"line":246,"containerName":"new","name":"$ext"},{"containerName":"new","name":"$alg","line":246,"kind":13},{"containerName":"new","name":"$matrix","kind":13,"line":246},{"name":"$self","containerName":"new","kind":13,"line":246},{"containerName":"new","name":"_rearrange","line":246,"kind":12},{"containerName":"new","name":"@args","line":252,"kind":13},{"kind":13,"line":254,"name":"$self","containerName":"new"},{"containerName":"new","name":"match","line":254,"kind":12},{"name":"$match","containerName":"new","kind":13,"line":254},{"containerName":"new","name":"$self","line":255,"kind":13},{"name":"mismatch","containerName":"new","line":255,"kind":12},{"kind":13,"line":255,"name":"$mismatch","containerName":"new"},{"kind":13,"line":256,"containerName":"new","name":"$self"},{"line":256,"kind":12,"name":"gap","containerName":"new"},{"name":"$gap","containerName":"new","kind":13,"line":256},{"kind":13,"line":257,"name":"$self","containerName":"new"},{"kind":12,"line":257,"name":"ext","containerName":"new"},{"name":"$ext","containerName":"new","line":257,"kind":13},{"containerName":"new","name":"$self","line":258,"kind":13},{"kind":12,"line":258,"containerName":"new","name":"alg"},{"line":258,"kind":13,"containerName":"new","name":"$alg"},{"containerName":"new","name":"$match","line":260,"kind":13},{"kind":13,"line":261,"containerName":"new","name":"$match"},{"name":"$self","containerName":"new","kind":13,"line":262},{"name":"match","containerName":"new","line":262,"kind":12},{"name":"$match","containerName":"new","line":262,"kind":13},{"line":265,"kind":13,"name":"$self","containerName":"new"},{"line":265,"kind":12,"containerName":"new","name":"throw"},{"name":"$mismatch","containerName":"new","kind":13,"line":269},{"kind":13,"line":270,"containerName":"new","name":"$match"},{"containerName":"new","name":"$self","line":271,"kind":13},{"line":271,"kind":12,"name":"mismatch","containerName":"new"},{"line":271,"kind":13,"containerName":"new","name":"$mismatch"},{"containerName":"new","name":"$self","line":274,"kind":13},{"kind":12,"line":274,"name":"throw","containerName":"new"},{"line":278,"kind":13,"name":"$gap","containerName":"new"},{"kind":13,"line":279,"containerName":"new","name":"$gap"},{"line":280,"kind":13,"containerName":"new","name":"$self"},{"line":280,"kind":12,"name":"gap","containerName":"new"},{"containerName":"new","name":"$gap","line":280,"kind":13},{"containerName":"new","name":"$self","line":283,"kind":13},{"line":283,"kind":12,"name":"throw","containerName":"new"},{"containerName":"new","name":"$ext","kind":13,"line":287},{"kind":13,"line":288,"containerName":"new","name":"$ext"},{"line":289,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"ext","line":289,"kind":12},{"name":"$ext","containerName":"new","line":289,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":292},{"line":292,"kind":12,"containerName":"new","name":"throw"},{"name":"$alg","containerName":"new","kind":13,"line":296},{"name":"$alg","containerName":"new","line":297,"kind":13},{"kind":13,"line":297,"containerName":"new","name":"$alg"},{"containerName":"new","name":"$alg","kind":13,"line":297},{"kind":13,"line":298,"name":"$self","containerName":"new"},{"name":"alg","containerName":"new","line":298,"kind":12},{"kind":13,"line":298,"containerName":"new","name":"$alg"},{"name":"$self","containerName":"new","kind":13,"line":301},{"kind":12,"line":301,"name":"throw","containerName":"new"},{"name":"$matrix","containerName":"new","line":305,"kind":13},{"line":305,"kind":13,"name":"$matrix","containerName":"new"},{"kind":12,"line":305,"containerName":"new","name":"isa"},{"containerName":"new","name":"$self","kind":13,"line":306},{"containerName":"new","name":"new","kind":12,"line":306},{"kind":13,"line":306,"containerName":"new","name":"$matrix"},{"containerName":"new","name":"row_names","line":306,"kind":12},{"line":306,"kind":13,"name":"$self","containerName":"new"},{"name":"gap","containerName":"new","line":306,"kind":12},{"line":306,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":306,"name":"ext","containerName":"new"},{"kind":13,"line":307,"containerName":"new","name":"$rowname"},{"kind":13,"line":307,"containerName":"new","name":"$matrix"},{"containerName":"new","name":"row_names","line":307,"kind":12},{"containerName":"new","name":"$colname","line":308,"kind":13},{"line":308,"kind":13,"containerName":"new","name":"$matrix"},{"kind":12,"line":308,"name":"column_names","containerName":"new"},{"line":309,"kind":12,"name":"set_entry","containerName":"new"},{"containerName":"new","name":"$self","line":309,"kind":13},{"kind":13,"line":309,"containerName":"new","name":"$rowname"},{"line":309,"kind":13,"name":"$colname","containerName":"new"},{"name":"$matrix","containerName":"new","line":309,"kind":13},{"name":"entry","containerName":"new","line":309,"kind":12},{"containerName":"new","name":"$rowname","kind":13,"line":309},{"line":309,"kind":13,"containerName":"new","name":"$colname"},{"containerName":"new","name":"$self","kind":13,"line":314},{"line":317,"kind":13,"name":"$self","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","line":244,"kind":12},{"name":"DPALIGN_LOCAL_MILLER_MYERS","line":258,"kind":12},{"line":297,"kind":12,"name":"DPALIGN_LOCAL_MILLER_MYERS"},{"name":"DPALIGN_GLOBAL_MILLER_MYERS","line":297,"kind":12},{"kind":12,"line":297,"name":"DPALIGN_ENDSFREE_MILLER_MYERS"},{"name":"Bio","containerName":"Ext::Align::ScoringMatrix","line":306,"kind":12},{"line":309,"kind":12,"containerName":"Ext::Align::ScoringMatrix","name":"Bio"},{"name":"sequence_profile","range":{"start":{"character":0,"line":331},"end":{"line":362,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$seq1)","signature":{"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence","parameters":[{"label":"$self"},{"label":"$seq1"}],"label":"sequence_profile($self,$seq1)"},"kind":12,"line":331,"children":[{"containerName":"sequence_profile","name":"$self","definition":"my","localvar":"my","kind":13,"line":332},{"containerName":"sequence_profile","name":"$seq1","kind":13,"line":332},{"name":"$seq1","containerName":"sequence_profile","line":334,"kind":13},{"line":334,"kind":13,"name":"$seq1","containerName":"sequence_profile"},{"line":334,"kind":12,"containerName":"sequence_profile","name":"isa"},{"line":335,"kind":13,"containerName":"sequence_profile","name":"$self"},{"containerName":"sequence_profile","name":"warn","line":335,"kind":12},{"name":"$seq1","containerName":"sequence_profile","kind":13,"line":340},{"name":"length","containerName":"sequence_profile","kind":12,"line":340},{"containerName":"sequence_profile","name":"$self","kind":13,"line":341},{"name":"warn","containerName":"sequence_profile","line":341,"kind":12},{"name":"$seq1","containerName":"sequence_profile","kind":13,"line":344},{"name":"isa","containerName":"sequence_profile","kind":12,"line":344},{"line":345,"kind":13,"localvar":"my","definition":"my","name":"$seqstr","containerName":"sequence_profile"},{"containerName":"sequence_profile","name":"$seq1","kind":13,"line":345},{"name":"seq","containerName":"sequence_profile","line":345,"kind":12},{"name":"$seqstr","containerName":"sequence_profile","kind":13,"line":346},{"containerName":"sequence_profile","name":"$seq1","kind":13,"line":347},{"name":"new","containerName":"sequence_profile","line":347,"kind":12},{"line":347,"kind":13,"containerName":"sequence_profile","name":"$seq1"},{"line":347,"kind":12,"containerName":"sequence_profile","name":"id"},{"line":347,"kind":13,"name":"$seqstr","containerName":"sequence_profile"},{"line":347,"kind":13,"containerName":"sequence_profile","name":"$seq1"},{"line":347,"kind":12,"containerName":"sequence_profile","name":"alphabet"},{"containerName":"sequence_profile","name":"$seq1","line":350,"kind":13},{"name":"display_id","containerName":"sequence_profile","kind":12,"line":350},{"containerName":"sequence_profile","name":"$seq1","kind":13,"line":350},{"kind":12,"line":350,"containerName":"sequence_profile","name":"id"},{"kind":13,"line":352,"name":"$seq1","containerName":"sequence_profile"},{"name":"alphabet","containerName":"sequence_profile","kind":12,"line":352},{"line":353,"kind":12,"containerName":"sequence_profile","name":"dna_new"},{"line":353,"kind":13,"containerName":"sequence_profile","name":"$seq1"},{"containerName":"sequence_profile","name":"seq","kind":12,"line":353},{"name":"$self","containerName":"sequence_profile","line":353,"kind":13},{"name":"$self","containerName":"sequence_profile","kind":13,"line":353},{"name":"$self","containerName":"sequence_profile","kind":13,"line":353},{"kind":13,"line":353,"name":"$self","containerName":"sequence_profile"},{"name":"$seq1","containerName":"sequence_profile","line":355,"kind":13},{"name":"alphabet","containerName":"sequence_profile","line":355,"kind":12},{"containerName":"sequence_profile","name":"protein_new","line":356,"kind":12},{"name":"$seq1","containerName":"sequence_profile","kind":13,"line":356},{"name":"seq","containerName":"sequence_profile","line":356,"kind":12},{"line":356,"kind":13,"name":"$self","containerName":"sequence_profile"}]},{"kind":12,"line":347,"name":"Bio","containerName":"Seq"},{"containerName":"Ext::Align::SequenceProfile","name":"Bio","line":353,"kind":12},{"containerName":"Ext::Align::SequenceProfile","name":"Bio","kind":12,"line":356},{"kind":12,"line":359,"name":"croak"},{"signature":{"parameters":[{"label":"$self"},{"label":"$prof"},{"label":"$seq2"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.","label":"pairwise_alignment_score($self,$prof,$seq2)"},"detail":"($self,$prof,$seq2)","definition":"sub","containerName":"main::","children":[{"line":381,"kind":13,"localvar":"my","containerName":"pairwise_alignment_score","definition":"my","name":"$self"},{"line":381,"kind":13,"name":"$prof","containerName":"pairwise_alignment_score"},{"name":"$seq2","containerName":"pairwise_alignment_score","line":381,"kind":13},{"kind":13,"line":383,"containerName":"pairwise_alignment_score","name":"$prof"},{"line":383,"kind":13,"containerName":"pairwise_alignment_score","name":"$prof"},{"name":"isa","containerName":"pairwise_alignment_score","line":383,"kind":12},{"containerName":"pairwise_alignment_score","name":"$seq2","line":384,"kind":13},{"name":"$seq2","containerName":"pairwise_alignment_score","line":384,"kind":13},{"name":"isa","containerName":"pairwise_alignment_score","line":384,"kind":12},{"name":"$self","containerName":"pairwise_alignment_score","line":385,"kind":13},{"kind":12,"line":385,"name":"warn","containerName":"pairwise_alignment_score"},{"name":"$seq2","containerName":"pairwise_alignment_score","line":389,"kind":13},{"containerName":"pairwise_alignment_score","name":"length","line":389,"kind":12},{"line":390,"kind":13,"name":"$self","containerName":"pairwise_alignment_score"},{"line":390,"kind":12,"name":"warn","containerName":"pairwise_alignment_score"},{"line":393,"kind":13,"containerName":"pairwise_alignment_score","name":"$seq2"},{"kind":12,"line":393,"name":"isa","containerName":"pairwise_alignment_score"},{"line":394,"kind":13,"localvar":"my","definition":"my","name":"$seqstr","containerName":"pairwise_alignment_score"},{"line":394,"kind":13,"name":"$seq2","containerName":"pairwise_alignment_score"},{"name":"seq","containerName":"pairwise_alignment_score","kind":12,"line":394},{"name":"$seqstr","containerName":"pairwise_alignment_score","line":395,"kind":13},{"kind":13,"line":396,"name":"$seq2","containerName":"pairwise_alignment_score"},{"line":396,"kind":12,"name":"new","containerName":"pairwise_alignment_score"},{"name":"$seq2","containerName":"pairwise_alignment_score","kind":13,"line":396},{"kind":12,"line":396,"containerName":"pairwise_alignment_score","name":"id"},{"name":"$seqstr","containerName":"pairwise_alignment_score","kind":13,"line":396},{"name":"$seq2","containerName":"pairwise_alignment_score","line":396,"kind":13},{"name":"alphabet","containerName":"pairwise_alignment_score","kind":12,"line":396},{"name":"$self","containerName":"pairwise_alignment_score","line":398,"kind":13},{"line":398,"kind":12,"name":"set_memory_and_report","containerName":"pairwise_alignment_score"},{"containerName":"pairwise_alignment_score","name":"$seq2","line":400,"kind":13},{"line":400,"kind":12,"name":"display_id","containerName":"pairwise_alignment_score"},{"name":"$seq2","containerName":"pairwise_alignment_score","kind":13,"line":400},{"line":400,"kind":12,"name":"id","containerName":"pairwise_alignment_score"},{"name":"$prof","containerName":"pairwise_alignment_score","kind":13,"line":402},{"name":"alphabet","containerName":"pairwise_alignment_score","line":402,"kind":12},{"line":402,"kind":13,"containerName":"pairwise_alignment_score","name":"$seq2"},{"line":402,"kind":12,"containerName":"pairwise_alignment_score","name":"alphabet"},{"name":"$prof","containerName":"pairwise_alignment_score","line":403,"kind":13},{"line":403,"kind":13,"containerName":"pairwise_alignment_score","name":"$seq2"},{"containerName":"pairwise_alignment_score","name":"seq","kind":12,"line":403},{"containerName":"pairwise_alignment_score","name":"$prof","line":405,"kind":13},{"line":405,"kind":12,"name":"alphabet","containerName":"pairwise_alignment_score"},{"line":405,"kind":13,"name":"$seq2","containerName":"pairwise_alignment_score"},{"name":"alphabet","containerName":"pairwise_alignment_score","kind":12,"line":405},{"kind":13,"line":406,"name":"$prof","containerName":"pairwise_alignment_score"},{"name":"$seq2","containerName":"pairwise_alignment_score","kind":13,"line":406},{"kind":12,"line":406,"name":"seq","containerName":"pairwise_alignment_score"}],"line":380,"kind":12,"range":{"end":{"line":412,"character":9999},"start":{"character":0,"line":380}},"name":"pairwise_alignment_score"},{"line":396,"kind":12,"containerName":"Seq","name":"Bio"},{"kind":12,"line":403,"containerName":"Ext::Align::Score_DNA_Sequences","name":"Bio"},{"line":406,"kind":12,"containerName":"Ext::Align::Score_Protein_Sequences","name":"Bio"},{"name":"croak","kind":12,"line":409},{"range":{"end":{"character":9999,"line":484},"start":{"line":426,"character":0}},"name":"pairwise_alignment","detail":"($self,$seq1,$seq2)","signature":{"parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.","label":"pairwise_alignment($self,$seq1,$seq2)"},"containerName":"main::","definition":"sub","line":426,"children":[{"line":427,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"pairwise_alignment"},{"kind":13,"line":427,"name":"$seq1","containerName":"pairwise_alignment"},{"line":427,"kind":13,"name":"$seq2","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","definition":"my","name":"$aln","localvar":"my","kind":13,"line":428},{"kind":13,"line":428,"containerName":"pairwise_alignment","name":"$out"},{"containerName":"pairwise_alignment","name":"$seq1","line":430,"kind":13},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":430},{"name":"isa","containerName":"pairwise_alignment","line":430,"kind":12},{"name":"$seq2","containerName":"pairwise_alignment","line":431,"kind":13},{"containerName":"pairwise_alignment","name":"$seq2","kind":13,"line":431},{"name":"isa","containerName":"pairwise_alignment","kind":12,"line":431},{"containerName":"pairwise_alignment","name":"$self","line":432,"kind":13},{"line":432,"kind":12,"name":"warn","containerName":"pairwise_alignment"},{"kind":13,"line":436,"containerName":"pairwise_alignment","name":"$seq1"},{"name":"length","containerName":"pairwise_alignment","line":436,"kind":12},{"name":"$seq2","containerName":"pairwise_alignment","line":437,"kind":13},{"name":"length","containerName":"pairwise_alignment","kind":12,"line":437},{"line":438,"kind":13,"name":"$self","containerName":"pairwise_alignment"},{"name":"warn","containerName":"pairwise_alignment","line":438,"kind":12},{"name":"$seq1","containerName":"pairwise_alignment","line":441,"kind":13},{"kind":12,"line":441,"name":"isa","containerName":"pairwise_alignment"},{"name":"$seqstr","definition":"my","containerName":"pairwise_alignment","localvar":"my","kind":13,"line":442},{"line":442,"kind":13,"name":"$seq1","containerName":"pairwise_alignment"},{"line":442,"kind":12,"containerName":"pairwise_alignment","name":"seq"},{"containerName":"pairwise_alignment","name":"$seqstr","kind":13,"line":443},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":444},{"line":444,"kind":12,"name":"new","containerName":"pairwise_alignment"},{"kind":13,"line":444,"containerName":"pairwise_alignment","name":"$seq1"},{"name":"id","containerName":"pairwise_alignment","kind":12,"line":444},{"containerName":"pairwise_alignment","name":"$seqstr","kind":13,"line":444},{"kind":13,"line":444,"containerName":"pairwise_alignment","name":"$seq1"},{"name":"alphabet","containerName":"pairwise_alignment","kind":12,"line":444},{"name":"$seq2","containerName":"pairwise_alignment","line":446,"kind":13},{"line":446,"kind":12,"name":"isa","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","definition":"my","name":"$seqstr","localvar":"my","kind":13,"line":447},{"name":"$seq2","containerName":"pairwise_alignment","kind":13,"line":447},{"line":447,"kind":12,"containerName":"pairwise_alignment","name":"seq"},{"name":"$seqstr","containerName":"pairwise_alignment","line":448,"kind":13},{"name":"$seq2","containerName":"pairwise_alignment","kind":13,"line":449},{"containerName":"pairwise_alignment","name":"new","line":449,"kind":12},{"kind":13,"line":449,"containerName":"pairwise_alignment","name":"$seq2"},{"kind":12,"line":449,"containerName":"pairwise_alignment","name":"id"},{"name":"$seqstr","containerName":"pairwise_alignment","kind":13,"line":449},{"line":449,"kind":13,"name":"$seq2","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"alphabet","line":449,"kind":12},{"containerName":"pairwise_alignment","name":"$self","line":451,"kind":13},{"kind":12,"line":451,"containerName":"pairwise_alignment","name":"set_memory_and_report"},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":453},{"line":453,"kind":12,"name":"display_id","containerName":"pairwise_alignment"},{"kind":13,"line":453,"containerName":"pairwise_alignment","name":"$seq1"},{"containerName":"pairwise_alignment","name":"id","line":453,"kind":12},{"line":454,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"name":"display_id","containerName":"pairwise_alignment","kind":12,"line":454},{"line":454,"kind":13,"name":"$seq2","containerName":"pairwise_alignment"},{"kind":12,"line":454,"containerName":"pairwise_alignment","name":"id"},{"kind":13,"line":456,"containerName":"pairwise_alignment","name":"$seq1"},{"kind":12,"line":456,"name":"alphabet","containerName":"pairwise_alignment"},{"line":456,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"kind":12,"line":456,"containerName":"pairwise_alignment","name":"alphabet"},{"kind":13,"line":457,"name":"$aln","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$seq1","line":457,"kind":13},{"containerName":"pairwise_alignment","name":"seq","kind":12,"line":457},{"kind":13,"line":457,"containerName":"pairwise_alignment","name":"$seq2"},{"containerName":"pairwise_alignment","name":"seq","line":457,"kind":12},{"kind":13,"line":457,"containerName":"pairwise_alignment","name":"$self"},{"kind":13,"line":457,"containerName":"pairwise_alignment","name":"$self"},{"line":457,"kind":13,"name":"$self","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$self","line":457,"kind":13},{"name":"$self","containerName":"pairwise_alignment","line":457,"kind":13},{"containerName":"pairwise_alignment","name":"$seq1","line":459,"kind":13},{"line":459,"kind":12,"name":"alphabet","containerName":"pairwise_alignment"},{"name":"$seq2","containerName":"pairwise_alignment","line":459,"kind":13},{"containerName":"pairwise_alignment","name":"alphabet","kind":12,"line":459},{"name":"$aln","containerName":"pairwise_alignment","line":460,"kind":13},{"name":"$seq1","containerName":"pairwise_alignment","line":460,"kind":13},{"kind":12,"line":460,"name":"seq","containerName":"pairwise_alignment"},{"line":460,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"name":"seq","containerName":"pairwise_alignment","line":460,"kind":12},{"line":460,"kind":13,"name":"$self","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"$self","line":460,"kind":13},{"kind":13,"line":467,"containerName":"pairwise_alignment","name":"$aln"},{"kind":13,"line":467,"name":"$aln","containerName":"pairwise_alignment"},{"line":471,"kind":13,"name":"$out","containerName":"pairwise_alignment"},{"kind":12,"line":471,"name":"new","containerName":"pairwise_alignment"},{"kind":13,"line":473,"containerName":"pairwise_alignment","name":"$out"},{"kind":12,"line":473,"name":"add_seq","containerName":"pairwise_alignment"},{"name":"new","containerName":"pairwise_alignment","line":473,"kind":12},{"kind":13,"line":473,"containerName":"pairwise_alignment","name":"$aln"},{"name":"aln1","containerName":"pairwise_alignment","kind":12,"line":473},{"kind":13,"line":474,"name":"$aln","containerName":"pairwise_alignment"},{"kind":12,"line":474,"containerName":"pairwise_alignment","name":"start1"},{"name":"$aln","containerName":"pairwise_alignment","kind":13,"line":475},{"kind":12,"line":475,"name":"end1","containerName":"pairwise_alignment"},{"line":476,"kind":13,"name":"$seq1","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"id","line":476,"kind":12},{"name":"$out","containerName":"pairwise_alignment","kind":13,"line":478},{"line":478,"kind":12,"containerName":"pairwise_alignment","name":"add_seq"},{"line":478,"kind":12,"name":"new","containerName":"pairwise_alignment"},{"kind":13,"line":478,"name":"$aln","containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","name":"aln2","line":478,"kind":12},{"line":479,"kind":13,"containerName":"pairwise_alignment","name":"$aln"},{"containerName":"pairwise_alignment","name":"start2","line":479,"kind":12},{"kind":13,"line":480,"containerName":"pairwise_alignment","name":"$aln"},{"containerName":"pairwise_alignment","name":"end2","kind":12,"line":480},{"kind":13,"line":481,"name":"$seq2","containerName":"pairwise_alignment"},{"name":"id","containerName":"pairwise_alignment","kind":12,"line":481},{"containerName":"pairwise_alignment","name":"$out","line":482,"kind":13},{"line":482,"kind":12,"containerName":"pairwise_alignment","name":"score"},{"line":482,"kind":13,"name":"$aln","containerName":"pairwise_alignment"},{"name":"score","containerName":"pairwise_alignment","line":482,"kind":12},{"kind":13,"line":483,"containerName":"pairwise_alignment","name":"$out"}],"kind":12},{"kind":12,"line":444,"containerName":"Seq","name":"Bio"},{"name":"Bio","containerName":"Seq","kind":12,"line":449},{"containerName":"Ext::Align::Align_DNA_Sequences","name":"Bio","kind":12,"line":457},{"containerName":"Ext::Align::Align_Protein_Sequences","name":"Bio","kind":12,"line":460},{"line":463,"kind":12,"name":"croak"},{"containerName":"SimpleAlign","name":"Bio","kind":12,"line":471},{"name":"Bio","containerName":"LocatableSeq","line":473,"kind":12},{"line":478,"kind":12,"name":"Bio","containerName":"LocatableSeq"},{"children":[{"kind":13,"line":494,"containerName":"align_and_show","definition":"my","name":"$self","localvar":"my"},{"containerName":"align_and_show","name":"$seq1","kind":13,"line":494},{"line":494,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"name":"$fh","containerName":"align_and_show","kind":13,"line":494},{"kind":13,"line":495,"name":"$aln","definition":"my","containerName":"align_and_show","localvar":"my"},{"kind":13,"line":495,"containerName":"align_and_show","name":"$out"},{"name":"$fh","containerName":"align_and_show","line":497,"kind":13},{"name":"$fh","containerName":"align_and_show","line":498,"kind":13},{"line":500,"kind":13,"name":"$seq1","containerName":"align_and_show"},{"line":500,"kind":13,"containerName":"align_and_show","name":"$seq1"},{"containerName":"align_and_show","name":"isa","kind":12,"line":500},{"kind":13,"line":501,"containerName":"align_and_show","name":"$seq2"},{"kind":13,"line":501,"containerName":"align_and_show","name":"$seq2"},{"name":"isa","containerName":"align_and_show","line":501,"kind":12},{"kind":13,"line":502,"containerName":"align_and_show","name":"$self"},{"line":502,"kind":12,"containerName":"align_and_show","name":"warn"},{"line":506,"kind":13,"containerName":"align_and_show","name":"$seq1"},{"containerName":"align_and_show","name":"length","line":506,"kind":12},{"name":"$seq2","containerName":"align_and_show","kind":13,"line":507},{"kind":12,"line":507,"name":"length","containerName":"align_and_show"},{"containerName":"align_and_show","name":"$self","line":508,"kind":13},{"kind":12,"line":508,"name":"warn","containerName":"align_and_show"},{"line":511,"kind":13,"name":"$seq1","containerName":"align_and_show"},{"line":511,"kind":12,"containerName":"align_and_show","name":"isa"},{"localvar":"my","containerName":"align_and_show","definition":"my","name":"$seqstr","line":512,"kind":13},{"containerName":"align_and_show","name":"$seq1","line":512,"kind":13},{"name":"seq","containerName":"align_and_show","kind":12,"line":512},{"containerName":"align_and_show","name":"$seqstr","line":513,"kind":13},{"containerName":"align_and_show","name":"$seq1","kind":13,"line":514},{"name":"new","containerName":"align_and_show","line":514,"kind":12},{"name":"$seq1","containerName":"align_and_show","line":514,"kind":13},{"kind":12,"line":514,"name":"id","containerName":"align_and_show"},{"kind":13,"line":514,"containerName":"align_and_show","name":"$seqstr"},{"kind":13,"line":514,"containerName":"align_and_show","name":"$seq1"},{"containerName":"align_and_show","name":"alphabet","line":514,"kind":12},{"name":"$seq2","containerName":"align_and_show","kind":13,"line":516},{"name":"isa","containerName":"align_and_show","kind":12,"line":516},{"kind":13,"line":517,"containerName":"align_and_show","definition":"my","name":"$seqstr","localvar":"my"},{"containerName":"align_and_show","name":"$seq2","kind":13,"line":517},{"line":517,"kind":12,"name":"seq","containerName":"align_and_show"},{"name":"$seqstr","containerName":"align_and_show","kind":13,"line":518},{"containerName":"align_and_show","name":"$seq2","line":519,"kind":13},{"name":"new","containerName":"align_and_show","kind":12,"line":519},{"containerName":"align_and_show","name":"$seq2","line":519,"kind":13},{"line":519,"kind":12,"name":"id","containerName":"align_and_show"},{"line":519,"kind":13,"name":"$seqstr","containerName":"align_and_show"},{"containerName":"align_and_show","name":"$seq2","line":519,"kind":13},{"kind":12,"line":519,"containerName":"align_and_show","name":"alphabet"},{"kind":13,"line":521,"containerName":"align_and_show","name":"$self"},{"containerName":"align_and_show","name":"set_memory_and_report","kind":12,"line":521},{"kind":13,"line":523,"containerName":"align_and_show","name":"$seq1"},{"kind":12,"line":523,"containerName":"align_and_show","name":"display_id"},{"line":523,"kind":13,"name":"$seq1","containerName":"align_and_show"},{"name":"id","containerName":"align_and_show","kind":12,"line":523},{"containerName":"align_and_show","name":"$seq2","line":524,"kind":13},{"kind":12,"line":524,"containerName":"align_and_show","name":"display_id"},{"kind":13,"line":524,"name":"$seq2","containerName":"align_and_show"},{"kind":12,"line":524,"name":"id","containerName":"align_and_show"},{"line":526,"kind":13,"containerName":"align_and_show","name":"$seq1"},{"kind":12,"line":526,"name":"alphabet","containerName":"align_and_show"},{"kind":13,"line":526,"containerName":"align_and_show","name":"$seq2"},{"kind":12,"line":526,"name":"alphabet","containerName":"align_and_show"},{"kind":13,"line":527,"containerName":"align_and_show","name":"$aln"},{"name":"$seq1","containerName":"align_and_show","line":527,"kind":13},{"line":527,"kind":12,"containerName":"align_and_show","name":"seq"},{"containerName":"align_and_show","name":"$seq2","line":527,"kind":13},{"containerName":"align_and_show","name":"seq","line":527,"kind":12},{"line":527,"kind":13,"containerName":"align_and_show","name":"$self"},{"containerName":"align_and_show","name":"$self","kind":13,"line":527},{"containerName":"align_and_show","name":"$self","kind":13,"line":527},{"line":527,"kind":13,"name":"$self","containerName":"align_and_show"},{"line":527,"kind":13,"containerName":"align_and_show","name":"$self"},{"kind":13,"line":529,"containerName":"align_and_show","name":"$seq1"},{"kind":12,"line":529,"name":"alphabet","containerName":"align_and_show"},{"line":529,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"kind":12,"line":529,"name":"alphabet","containerName":"align_and_show"},{"name":"$aln","containerName":"align_and_show","line":530,"kind":13},{"kind":13,"line":530,"containerName":"align_and_show","name":"$seq1"},{"containerName":"align_and_show","name":"seq","line":530,"kind":12},{"name":"$seq2","containerName":"align_and_show","line":530,"kind":13},{"line":530,"kind":12,"containerName":"align_and_show","name":"seq"},{"name":"$self","containerName":"align_and_show","kind":13,"line":530},{"containerName":"align_and_show","name":"$self","line":530,"kind":13},{"kind":13,"line":536,"containerName":"align_and_show","name":"$out"},{"name":"new","containerName":"align_and_show","kind":12,"line":536},{"localvar":"my","definition":"my","name":"$s1","containerName":"align_and_show","line":537,"kind":13},{"kind":12,"line":537,"name":"new","containerName":"align_and_show"},{"containerName":"align_and_show","definition":"my","name":"$s2","localvar":"my","kind":13,"line":538},{"kind":12,"line":538,"name":"new","containerName":"align_and_show"},{"localvar":"my","containerName":"align_and_show","name":"$a1","definition":"my","line":539,"kind":13},{"name":"$aln","containerName":"align_and_show","line":539,"kind":13},{"line":539,"kind":12,"name":"aln1","containerName":"align_and_show"},{"containerName":"align_and_show","definition":"my","name":"$a2","localvar":"my","kind":13,"line":540},{"kind":13,"line":540,"containerName":"align_and_show","name":"$aln"},{"containerName":"align_and_show","name":"aln2","kind":12,"line":540},{"containerName":"align_and_show","definition":"my","name":"$first_col","localvar":"my","kind":13,"line":541},{"kind":13,"line":542,"definition":"my","name":"$last_col","containerName":"align_and_show","localvar":"my"},{"kind":13,"line":543,"containerName":"align_and_show","name":"$col","definition":"my","localvar":"my"},{"kind":13,"line":544,"definition":"my","name":"$alu1","containerName":"align_and_show","localvar":"my"},{"localvar":"my","containerName":"align_and_show","definition":"my","name":"$alu2","line":545,"kind":13},{"kind":13,"line":546,"containerName":"align_and_show","name":"$g1","definition":"my","localvar":"my"},{"containerName":"align_and_show","name":"$g2","definition":"my","localvar":"my","kind":13,"line":547},{"line":550,"kind":13,"localvar":"my","containerName":"align_and_show","name":"$i","definition":"my"},{"containerName":"align_and_show","name":"$i","kind":13,"line":550},{"kind":13,"line":550,"name":"$a1","containerName":"align_and_show"},{"kind":13,"line":550,"containerName":"align_and_show","name":"$i"},{"line":551,"kind":13,"name":"$col","containerName":"align_and_show"},{"line":551,"kind":12,"containerName":"align_and_show","name":"new"},{"kind":13,"line":552,"containerName":"align_and_show","name":"$alu1"},{"containerName":"align_and_show","name":"new","kind":12,"line":552},{"kind":13,"line":553,"name":"$alu2","containerName":"align_and_show"},{"line":553,"kind":12,"name":"new","containerName":"align_and_show"},{"line":554,"kind":13,"containerName":"align_and_show","name":"$first_col"},{"containerName":"align_and_show","name":"$col","line":554,"kind":13},{"kind":13,"line":554,"name":"$first_col","containerName":"align_and_show"},{"name":"$last_col","containerName":"align_and_show","line":555,"kind":13},{"line":555,"kind":13,"name":"$col","containerName":"align_and_show"},{"name":"$last_col","containerName":"align_and_show","line":555,"kind":13},{"line":557,"kind":13,"name":"$a1","containerName":"align_and_show"},{"kind":13,"line":557,"name":"$i","containerName":"align_and_show"},{"containerName":"align_and_show","name":"$alu1","line":558,"kind":13},{"containerName":"align_and_show","name":"$alu2","kind":13,"line":559},{"name":"$g1","containerName":"align_and_show","kind":13,"line":560},{"kind":13,"line":562,"containerName":"align_and_show","name":"$a2"},{"kind":13,"line":562,"containerName":"align_and_show","name":"$i"},{"kind":13,"line":563,"name":"$alu1","containerName":"align_and_show"},{"kind":13,"line":564,"name":"$alu2","containerName":"align_and_show"},{"containerName":"align_and_show","name":"$g2","kind":13,"line":565},{"line":568,"kind":13,"containerName":"align_and_show","name":"$alu1"},{"kind":13,"line":569,"containerName":"align_and_show","name":"$alu2"},{"name":"$alu1","containerName":"align_and_show","line":572,"kind":13},{"containerName":"align_and_show","name":"$aln","line":572,"kind":13},{"name":"start1","containerName":"align_and_show","kind":12,"line":572},{"name":"$i","containerName":"align_and_show","line":572,"kind":13},{"kind":13,"line":572,"containerName":"align_and_show","name":"$g1"},{"line":573,"kind":13,"name":"$alu1","containerName":"align_and_show"},{"name":"$aln","containerName":"align_and_show","line":573,"kind":13},{"line":573,"kind":12,"containerName":"align_and_show","name":"start1"},{"line":573,"kind":13,"name":"$i","containerName":"align_and_show"},{"name":"$g1","containerName":"align_and_show","kind":13,"line":573},{"kind":13,"line":574,"name":"$alu2","containerName":"align_and_show"},{"name":"$aln","containerName":"align_and_show","line":574,"kind":13},{"name":"start2","containerName":"align_and_show","line":574,"kind":12},{"line":574,"kind":13,"containerName":"align_and_show","name":"$i"},{"name":"$g2","containerName":"align_and_show","kind":13,"line":574},{"name":"$alu2","containerName":"align_and_show","line":575,"kind":13},{"kind":13,"line":575,"name":"$aln","containerName":"align_and_show"},{"name":"start2","containerName":"align_and_show","line":575,"kind":12},{"containerName":"align_and_show","name":"$i","kind":13,"line":575},{"line":575,"kind":13,"containerName":"align_and_show","name":"$g2"},{"kind":13,"line":576,"name":"$col","containerName":"align_and_show"},{"kind":13,"line":576,"name":"$alu1","containerName":"align_and_show"},{"kind":13,"line":577,"name":"$col","containerName":"align_and_show"},{"name":"$alu2","containerName":"align_and_show","line":577,"kind":13},{"name":"$last_col","containerName":"align_and_show","line":578,"kind":13},{"name":"$col","containerName":"align_and_show","kind":13,"line":578},{"name":"$out","containerName":"align_and_show","kind":13,"line":580},{"kind":13,"line":580,"name":"$first_col","containerName":"align_and_show"},{"name":"$col","containerName":"align_and_show","kind":13,"line":581},{"kind":12,"line":581,"containerName":"align_and_show","name":"new"},{"name":"$alu1","containerName":"align_and_show","kind":13,"line":582},{"line":582,"kind":12,"containerName":"align_and_show","name":"new"},{"kind":13,"line":583,"name":"$alu2","containerName":"align_and_show"},{"line":583,"kind":12,"name":"new","containerName":"align_and_show"},{"line":584,"kind":13,"containerName":"align_and_show","name":"$alu1"},{"kind":13,"line":584,"containerName":"align_and_show","name":"$aln"},{"kind":12,"line":584,"containerName":"align_and_show","name":"end1"},{"name":"$alu1","containerName":"align_and_show","line":585,"kind":13},{"containerName":"align_and_show","name":"$aln","line":585,"kind":13},{"containerName":"align_and_show","name":"end1","kind":12,"line":585},{"name":"$alu1","containerName":"align_and_show","kind":13,"line":586},{"kind":13,"line":587,"containerName":"align_and_show","name":"$alu2"},{"containerName":"align_and_show","name":"$aln","kind":13,"line":587},{"kind":12,"line":587,"containerName":"align_and_show","name":"end2"},{"containerName":"align_and_show","name":"$alu2","line":588,"kind":13},{"line":588,"kind":13,"containerName":"align_and_show","name":"$aln"},{"line":588,"kind":12,"name":"end2","containerName":"align_and_show"},{"name":"$alu2","containerName":"align_and_show","line":589,"kind":13},{"containerName":"align_and_show","name":"$col","line":590,"kind":13},{"name":"$alu1","containerName":"align_and_show","kind":13,"line":590},{"name":"$col","containerName":"align_and_show","line":591,"kind":13},{"line":591,"kind":13,"containerName":"align_and_show","name":"$alu2"},{"containerName":"align_and_show","name":"$last_col","kind":13,"line":592},{"line":592,"kind":13,"containerName":"align_and_show","name":"$col"},{"containerName":"align_and_show","name":"$out","kind":13,"line":594},{"kind":13,"line":594,"containerName":"align_and_show","name":"$seq1"},{"line":594,"kind":12,"containerName":"align_and_show","name":"id"},{"kind":13,"line":594,"name":"$seq1","containerName":"align_and_show"},{"line":594,"kind":12,"name":"seq","containerName":"align_and_show"},{"name":"$seq2","containerName":"align_and_show","line":594,"kind":13},{"line":594,"kind":12,"name":"id","containerName":"align_and_show"},{"line":594,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"name":"seq","containerName":"align_and_show","line":594,"kind":12},{"line":594,"kind":13,"name":"$fh","containerName":"align_and_show"}],"line":493,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"},{"label":"$fh"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)","label":"align_and_show($self,$seq1,$seq2,$fh)"},"detail":"($self,$seq1,$seq2,$fh)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":595},"start":{"character":0,"line":493}},"name":"align_and_show"},{"kind":12,"line":514,"name":"Bio","containerName":"Seq"},{"line":519,"kind":12,"name":"Bio","containerName":"Seq"},{"name":"Bio","containerName":"Ext::Align::Align_DNA_Sequences","line":527,"kind":12},{"kind":12,"line":530,"containerName":"Ext::Align::Align_Protein_Sequences","name":"Bio"},{"name":"croak","kind":12,"line":533},{"line":536,"kind":12,"name":"Bio","containerName":"Ext::Align::AlnBlock"},{"kind":12,"line":537,"containerName":"Ext::Align::AlnSequence","name":"Bio"},{"line":538,"kind":12,"containerName":"Ext::Align::AlnSequence","name":"Bio"},{"line":551,"kind":12,"containerName":"Ext::Align::AlnColumn","name":"Bio"},{"kind":12,"line":552,"containerName":"Ext::Align::AlnUnit","name":"Bio"},{"line":553,"kind":12,"containerName":"Ext::Align::AlnUnit","name":"Bio"},{"name":"Bio","containerName":"Ext::Align::AlnColumn::set_next","line":555,"kind":12},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_text_label","kind":12,"line":558},{"kind":12,"line":559,"containerName":"Ext::Align::AlnUnit::set_text_label","name":"Bio"},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_text_label","line":563,"kind":12},{"containerName":"Ext::Align::AlnUnit::set_text_label","name":"Bio","line":564,"kind":12},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_text_label","kind":12,"line":568},{"kind":12,"line":569,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_text_label"},{"line":572,"kind":12,"containerName":"Ext::Align::AlnUnit::set_start","name":"Bio"},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_end","kind":12,"line":573},{"line":574,"kind":12,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_start"},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_end","kind":12,"line":575},{"kind":12,"line":576,"name":"Bio","containerName":"Ext::Align::AlnColumn::add_alu"},{"containerName":"Ext::Align::AlnColumn::add_alu","name":"Bio","line":577,"kind":12},{"name":"Bio","containerName":"Ext::Align::AlnBlock::set_start","line":580,"kind":12},{"name":"Bio","containerName":"Ext::Align::AlnColumn","line":581,"kind":12},{"kind":12,"line":582,"containerName":"Ext::Align::AlnUnit","name":"Bio"},{"containerName":"Ext::Align::AlnUnit","name":"Bio","kind":12,"line":583},{"kind":12,"line":584,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_start"},{"kind":12,"line":585,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_end"},{"kind":12,"line":586,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_text_label"},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_start","line":587,"kind":12},{"kind":12,"line":588,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_end"},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_text_label","kind":12,"line":589},{"kind":12,"line":590,"name":"Bio","containerName":"Ext::Align::AlnColumn::add_alu"},{"kind":12,"line":591,"name":"Bio","containerName":"Ext::Align::AlnColumn::add_alu"},{"name":"Bio","containerName":"Ext::Align::AlnColumn::set_next","kind":12,"line":592},{"name":"Bio","containerName":"Ext::Align::write_pretty_str_align","line":594,"kind":12},{"name":"match","range":{"start":{"character":0,"line":609},"end":{"line":620,"character":9999}},"kind":12,"line":609,"children":[{"definition":"my","name":"$self","containerName":"match","localvar":"my","kind":13,"line":610},{"line":610,"kind":13,"containerName":"match","name":"$val"},{"name":"$val","containerName":"match","kind":13,"line":613},{"kind":13,"line":614,"name":"$val","containerName":"match"},{"kind":13,"line":615,"containerName":"match","name":"$self"},{"name":"throw","containerName":"match","line":615,"kind":12},{"containerName":"match","name":"$self","kind":13,"line":617},{"kind":13,"line":617,"containerName":"match","name":"$val"},{"line":619,"kind":13,"name":"$self","containerName":"match"}],"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}],"label":"match($self,$val)"}},{"children":[{"definition":"my","name":"$self","containerName":"mismatch","localvar":"my","kind":13,"line":635},{"line":635,"kind":13,"containerName":"mismatch","name":"$val"},{"line":638,"kind":13,"name":"$val","containerName":"mismatch"},{"name":"$val","containerName":"mismatch","kind":13,"line":639},{"containerName":"mismatch","name":"$self","line":640,"kind":13},{"name":"throw","containerName":"mismatch","line":640,"kind":12},{"containerName":"mismatch","name":"$self","kind":13,"line":642},{"kind":13,"line":642,"containerName":"mismatch","name":"$val"},{"containerName":"mismatch","name":"$self","kind":13,"line":644}],"line":634,"kind":12,"signature":{"label":"mismatch($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value"},"detail":"($self,$val)","definition":"sub","containerName":"main::","range":{"end":{"line":645,"character":9999},"start":{"character":0,"line":634}},"name":"mismatch"},{"name":"gap","range":{"end":{"line":671,"character":9999},"start":{"line":660,"character":0}},"kind":12,"line":660,"children":[{"containerName":"gap","name":"$self","definition":"my","localvar":"my","kind":13,"line":661},{"name":"$val","containerName":"gap","line":661,"kind":13},{"name":"$val","containerName":"gap","line":664,"kind":13},{"kind":13,"line":665,"containerName":"gap","name":"$val"},{"line":666,"kind":13,"name":"$self","containerName":"gap"},{"line":666,"kind":12,"containerName":"gap","name":"throw"},{"containerName":"gap","name":"$self","line":668,"kind":13},{"name":"$val","containerName":"gap","kind":13,"line":668},{"name":"$self","containerName":"gap","kind":13,"line":670}],"containerName":"main::","definition":"sub","detail":"($self,$val)","signature":{"label":"gap($self,$val)","documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value\n\n\nsub mismatch {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val > 0 ) {    # Fixed so that mismatch==0 is allowed /AE\n            $self->throw(\"Can't have a mismatch penalty greater than 0\");\n        }\n        $self->{'mismatch'} = $val;\n    }\n    return $self->{'mismatch'};\n}\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value\n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}]}},{"children":[{"kind":13,"line":686,"definition":"my","name":"$self","containerName":"ext","localvar":"my"},{"kind":13,"line":686,"name":"$val","containerName":"ext"},{"line":688,"kind":13,"containerName":"ext","name":"$val"},{"containerName":"ext","name":"$val","kind":13,"line":689},{"line":690,"kind":13,"name":"$self","containerName":"ext"},{"kind":12,"line":690,"name":"throw","containerName":"ext"},{"name":"$self","containerName":"ext","line":692,"kind":13},{"name":"$val","containerName":"ext","kind":13,"line":692},{"containerName":"ext","name":"$self","line":694,"kind":13}],"line":685,"kind":12,"signature":{"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value\n\n\nsub mismatch {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val > 0 ) {    # Fixed so that mismatch==0 is allowed /AE\n            $self->throw(\"Can't have a mismatch penalty greater than 0\");\n        }\n        $self->{'mismatch'} = $val;\n    }\n    return $self->{'mismatch'};\n}\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value\n Arguments : new value\n\n\nsub gap {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that gap==0 is allowed /AE\n            $self->throw(\"Can't have a gap penalty less than 0\");\n        }\n        $self->{'gap'} = $val;\n    }\n    return $self->{'gap'};\n}\n\n=head2 ext\n\n Title     : ext\n Usage     : $ext = $factory->ext() #get\n           : $factory->ext($value) #set\n Function  : the set get for the ext penalty\n Example   :\n Returns   : ext value\n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}],"label":"ext($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":695},"start":{"character":0,"line":685}},"name":"ext"},{"line":709,"children":[{"line":710,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"alg"},{"line":710,"kind":13,"containerName":"alg","name":"$val"},{"kind":13,"line":712,"name":"$val","containerName":"alg"},{"containerName":"alg","name":"$val","kind":13,"line":713},{"containerName":"alg","name":"$val","line":713,"kind":13},{"containerName":"alg","name":"$val","line":713,"kind":13},{"line":714,"kind":13,"name":"$self","containerName":"alg"},{"kind":12,"line":714,"containerName":"alg","name":"throw"},{"containerName":"alg","name":"$self","kind":13,"line":716},{"kind":13,"line":716,"containerName":"alg","name":"$val"},{"containerName":"alg","name":"$self","kind":13,"line":718}],"kind":12,"detail":"($self,$val)","signature":{"label":"alg($self,$val)","documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value\n\n\nsub mismatch {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val > 0 ) {    # Fixed so that mismatch==0 is allowed /AE\n            $self->throw(\"Can't have a mismatch penalty greater than 0\");\n        }\n        $self->{'mismatch'} = $val;\n    }\n    return $self->{'mismatch'};\n}\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value\n Arguments : new value\n\n\nsub gap {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that gap==0 is allowed /AE\n            $self->throw(\"Can't have a gap penalty less than 0\");\n        }\n        $self->{'gap'} = $val;\n    }\n    return $self->{'gap'};\n}\n\n=head2 ext\n\n Title     : ext\n Usage     : $ext = $factory->ext() #get\n           : $factory->ext($value) #set\n Function  : the set get for the ext penalty\n Example   :\n Returns   : ext value\n Arguments : new value\n\n\nsub ext {\n    my ($self,$val) = @_;\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that ext==0 is allowed /AE\n            $self->throw(\"Can't have a extension penalty less than 0\");\n        }\n        $self->{'ext'} = $val;\n    }\n    return $self->{'ext'};\n}\n\n=head2 alg\n\n Title     : alg\n Usage     : $alg = $factory->alg() #get\n           : $factory->alg($value) #set\n Function  : the set get for the algorithm\n Example   :\n Returns   : alg value\n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":709,"character":0},"end":{"line":719,"character":9999}},"name":"alg"},{"name":"DPALIGN_LOCAL_MILLER_MYERS","kind":12,"line":713},{"name":"DPALIGN_GLOBAL_MILLER_MYERS","kind":12,"line":713},{"name":"DPALIGN_ENDSFREE_MILLER_MYERS","kind":12,"line":713}]}