{"version":5,"vars":[{"name":"base","containerName":"","line":135,"kind":2},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize_state($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"_initialize_state","localvar":"my","kind":13,"line":139},{"name":"@args","containerName":"_initialize_state","kind":13,"line":139},{"line":142,"kind":13,"localvar":"my","containerName":"_initialize_state","name":"$make","definition":"my"},{"name":"$self","containerName":"_initialize_state","line":142,"kind":13},{"kind":13,"line":142,"containerName":"_initialize_state","name":"@args"},{"kind":13,"line":144,"containerName":"_initialize_state","name":"$est_is_first","definition":"my","localvar":"my"},{"containerName":"_initialize_state","name":"$self","kind":13,"line":144},{"line":144,"kind":12,"containerName":"_initialize_state","name":"_rearrange"},{"containerName":"_initialize_state","name":"@args","line":144,"kind":13},{"containerName":"_initialize_state","name":"$self","kind":13,"line":146},{"line":147,"kind":13,"name":"$self","containerName":"_initialize_state"},{"containerName":"_initialize_state","name":"$est_is_first","kind":13,"line":147},{"name":"$est_is_first","containerName":"_initialize_state","kind":13,"line":147},{"line":148,"kind":13,"name":"$self","containerName":"_initialize_state"},{"containerName":"_initialize_state","name":"analysis_method","kind":12,"line":148}],"line":138,"name":"_initialize_state","range":{"end":{"character":9999,"line":149},"start":{"line":138,"character":0}}},{"name":"SUPER","containerName":"_initialize_state","kind":12,"line":142},{"name":"analysis_method","range":{"end":{"line":169,"character":9999},"start":{"character":0,"line":162}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Sim4::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney-at-sanger.ac.uk>\n#          and Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Ewan Birney and Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Sim4::Results - Results of one Sim4 run\n\n=head1 SYNOPSIS\n\n   # to preset the order of EST and genomic file as given on the sim4 \n   # command line:\n   my $sim4 = Bio::Tools::Sim4::Results->new(-file => 'result.sim4',\n                                             -estfirst => 1);\n   # to let the order be determined automatically (by length comparison):\n   $sim4 = Bio::Tools::Sim4::Results->new( -file => 'sim4.results' );\n   # filehandle:\n   $sim4 = Bio::Tools::Sim4::Results->new( -fh   => \\*INPUT );\n\n   # parse the results\n   while(my $exonset = $sim4->next_exonset()) {\n       # $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Sim4::Exons\n       # as sub features\n       print \"Delimited on sequence \", $exonset->seq_id(), \n             \"from \", $exonset->start(), \" to \", $exonset->end(), \"\\n\";\n       foreach my $exon ( $exonset->sub_SeqFeature() ) {\n\t  # $exon is-a Bio::SeqFeature::FeaturePair\n\t  print \"Exon from \", $exon->start, \" to \", $exon->end, \n                \" on strand \", $exon->strand(), \"\\n\";\n          # you can get out what it matched using the est_hit attribute\n          my $homol = $exon->est_hit();\n          print \"Matched to sequence \", $homol->seq_id, \n                \" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n      }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # stays open)\n   $sim4->close();\n\n=head1 DESCRIPTION\n\nThe sim4 module provides a parser and results object for sim4 output. The\nsim4 results are specialised types of SeqFeatures, meaning you can add them\nto AnnSeq objects fine, and manipulate them in the \"normal\" seqfeature manner.\n\nThe sim4 Exon objects are Bio::SeqFeature::FeaturePair inherited objects. The \n$esthit = $exon-E<gt>est_hit() is the alignment as a feature on the matching \nobject (normally, an EST), in which the start/end points are where the hit\nlies.\n\nTo make this module work sensibly you need to run\n\n     sim4 genomic.fasta est.database.fasta\nor\n     sim4 est.fasta genomic.database.fasta\n\nTo get the sequence identifiers recorded for the first sequence, too, use\nA=4 as output option for sim4.\n\nOne fiddle here is that there are only two real possibilities to the matching\ncriteria: either one sequence needs reversing or not. Because of this, it\nis impossible to tell whether the match is in the forward or reverse strand\nof the genomic DNA. We solve this here by assuming that the genomic DNA is\nalways forward. As a consequence, the strand attribute of the matching EST is\nunknown, and the strand attribute of the genomic DNA (i.e., the Exon object)\nwill reflect the direction of the hit.\n\nSee the documentation of parse_next_alignment() for abilities of the parser\nto deal with the different output format options of sim4.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Hilmar Lapp\n\nEwan Birney E<lt>birney-at-sanger.ac.ukE<gt>\nHilmar Lapp E<lt>hlapp-at-gmx.netE<gt> or E<lt>hilmar.lapp-at-pharma.novartis.comE<gt>.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Sim4::Results;\nuse strict;\n\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Sim4::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n    delete($self->{'_est_is_first'});\n    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Sim4\");\n}\n\n=head2 analysis_method\n\n Usage     : $sim4->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /sim4/i.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"detail":"($self,$method)","kind":12,"children":[{"line":164,"kind":13,"localvar":"my","containerName":"analysis_method","name":"$self","definition":"my"},{"kind":13,"line":164,"containerName":"analysis_method","name":"$method"},{"containerName":"analysis_method","name":"$method","line":165,"kind":13},{"name":"$method","containerName":"analysis_method","line":165,"kind":13},{"name":"$self","containerName":"analysis_method","line":166,"kind":13},{"containerName":"analysis_method","name":"throw","kind":12,"line":166},{"name":"$self","containerName":"analysis_method","line":166,"kind":13},{"name":"$self","containerName":"analysis_method","line":168,"kind":13},{"name":"$method","containerName":"analysis_method","kind":13,"line":168}],"line":162},{"kind":12,"line":168,"containerName":"analysis_method","name":"SUPER"},{"name":"parse_next_alignment","range":{"end":{"character":9999,"line":361},"start":{"character":0,"line":208}},"definition":"sub","containerName":"main::","signature":{"label":"parse_next_alignment($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Sim4::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney-at-sanger.ac.uk>\n#          and Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Ewan Birney and Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Sim4::Results - Results of one Sim4 run\n\n=head1 SYNOPSIS\n\n   # to preset the order of EST and genomic file as given on the sim4 \n   # command line:\n   my $sim4 = Bio::Tools::Sim4::Results->new(-file => 'result.sim4',\n                                             -estfirst => 1);\n   # to let the order be determined automatically (by length comparison):\n   $sim4 = Bio::Tools::Sim4::Results->new( -file => 'sim4.results' );\n   # filehandle:\n   $sim4 = Bio::Tools::Sim4::Results->new( -fh   => \\*INPUT );\n\n   # parse the results\n   while(my $exonset = $sim4->next_exonset()) {\n       # $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Sim4::Exons\n       # as sub features\n       print \"Delimited on sequence \", $exonset->seq_id(), \n             \"from \", $exonset->start(), \" to \", $exonset->end(), \"\\n\";\n       foreach my $exon ( $exonset->sub_SeqFeature() ) {\n\t  # $exon is-a Bio::SeqFeature::FeaturePair\n\t  print \"Exon from \", $exon->start, \" to \", $exon->end, \n                \" on strand \", $exon->strand(), \"\\n\";\n          # you can get out what it matched using the est_hit attribute\n          my $homol = $exon->est_hit();\n          print \"Matched to sequence \", $homol->seq_id, \n                \" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n      }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # stays open)\n   $sim4->close();\n\n=head1 DESCRIPTION\n\nThe sim4 module provides a parser and results object for sim4 output. The\nsim4 results are specialised types of SeqFeatures, meaning you can add them\nto AnnSeq objects fine, and manipulate them in the \"normal\" seqfeature manner.\n\nThe sim4 Exon objects are Bio::SeqFeature::FeaturePair inherited objects. The \n$esthit = $exon-E<gt>est_hit() is the alignment as a feature on the matching \nobject (normally, an EST), in which the start/end points are where the hit\nlies.\n\nTo make this module work sensibly you need to run\n\n     sim4 genomic.fasta est.database.fasta\nor\n     sim4 est.fasta genomic.database.fasta\n\nTo get the sequence identifiers recorded for the first sequence, too, use\nA=4 as output option for sim4.\n\nOne fiddle here is that there are only two real possibilities to the matching\ncriteria: either one sequence needs reversing or not. Because of this, it\nis impossible to tell whether the match is in the forward or reverse strand\nof the genomic DNA. We solve this here by assuming that the genomic DNA is\nalways forward. As a consequence, the strand attribute of the matching EST is\nunknown, and the strand attribute of the genomic DNA (i.e., the Exon object)\nwill reflect the direction of the hit.\n\nSee the documentation of parse_next_alignment() for abilities of the parser\nto deal with the different output format options of sim4.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Hilmar Lapp\n\nEwan Birney E<lt>birney-at-sanger.ac.ukE<gt>\nHilmar Lapp E<lt>hlapp-at-gmx.netE<gt> or E<lt>hilmar.lapp-at-pharma.novartis.comE<gt>.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Sim4::Results;\nuse strict;\n\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Sim4::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n    delete($self->{'_est_is_first'});\n    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Sim4\");\n}\n\n=head2 analysis_method\n\n Usage     : $sim4->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /sim4/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /sim4/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $sim4_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Sim4 result file and returns the\n           found exons as an array of Bio::Tools::Sim4::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n\n           The $exon->seq_id() attribute will be set to the identifier of the\n           respective sequence for both sequences if A=4 was used in the sim4\n           run, and otherwise for the second sequence only. If the output does\n           not contain the identifier, the filename stripped of path and \n           extension is used instead. In addition, the full filename \n           will be recorded for both features ($exon inherits off \n           Bio::SeqFeature::SimilarityPair) as tag 'filename'. The length\n           is accessible via the seqlength() attribute of $exon->query() and\n           $exon->est_hit().\n\n           Note that this method is capable of dealing with outputs generated\n           with format 0,1,3, and 4 (via the A=n option to sim4). It\n           automatically determines which of the two sequences has been \n           reversed, and adjusts the coordinates for that sequence. It will\n           also detect whether the EST sequence(s) were given as first or as\n           second file to sim4, unless this has been specified at creation\n           time of the object.\n\n Example :\n Returns : An array of Bio::Tools::Sim4::Exon objects\n Args    :"},"detail":"($self)","kind":12,"children":[{"line":209,"kind":13,"localvar":"my","containerName":"parse_next_alignment","definition":"my","name":"$self"},{"localvar":"my","containerName":"parse_next_alignment","name":"@exons","definition":"my","line":210,"kind":13},{"name":"%seq1props","definition":"my","containerName":"parse_next_alignment","localvar":"my","kind":13,"line":211},{"line":212,"kind":13,"localvar":"my","containerName":"parse_next_alignment","name":"%seq2props","definition":"my"},{"kind":13,"line":214,"containerName":"parse_next_alignment","name":"$estseq","definition":"my","localvar":"my"},{"kind":13,"line":214,"name":"$genomseq","containerName":"parse_next_alignment"},{"kind":13,"line":214,"name":"$to_reverse","containerName":"parse_next_alignment"},{"line":215,"kind":13,"localvar":"my","definition":"my","name":"$started","containerName":"parse_next_alignment"},{"localvar":"my","name":"$hit_direction","definition":"my","containerName":"parse_next_alignment","line":216,"kind":13},{"kind":13,"line":217,"definition":"my","name":"$output_fmt","containerName":"parse_next_alignment","localvar":"my"},{"kind":13,"line":220,"name":"$self","containerName":"parse_next_alignment"},{"name":"_readline","containerName":"parse_next_alignment","line":220,"kind":12},{"containerName":"parse_next_alignment","name":"$started","kind":13,"line":226},{"kind":13,"line":227,"name":"$self","containerName":"parse_next_alignment"},{"kind":12,"line":227,"name":"_pushback","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$started","kind":13,"line":230},{"line":234,"kind":13,"containerName":"parse_next_alignment","name":"$self"},{"name":"throw","containerName":"parse_next_alignment","kind":12,"line":234},{"kind":13,"line":235,"containerName":"parse_next_alignment","name":"$seq1props"},{"name":"$seq1props","containerName":"parse_next_alignment","line":236,"kind":13},{"name":"$self","containerName":"parse_next_alignment","line":243,"kind":13},{"containerName":"parse_next_alignment","name":"throw","kind":12,"line":243},{"kind":13,"line":244,"containerName":"parse_next_alignment","name":"$seq2props"},{"kind":13,"line":245,"name":"$seq2props","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$seq2props","kind":13,"line":246},{"kind":13,"line":253,"name":"$seq1props","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$seq1props","kind":13,"line":254},{"kind":13,"line":255,"containerName":"parse_next_alignment","name":"$output_fmt"},{"containerName":"parse_next_alignment","name":"$self","line":257,"kind":13},{"line":257,"kind":12,"name":"_readline","containerName":"parse_next_alignment"},{"line":258,"kind":13,"containerName":"parse_next_alignment","name":"$seq2props"},{"name":"$seq2props","containerName":"parse_next_alignment","kind":13,"line":259},{"containerName":"parse_next_alignment","name":"$hit_direction","line":264,"kind":13},{"containerName":"parse_next_alignment","name":"$seq1props","kind":13,"line":270},{"line":271,"kind":13,"containerName":"parse_next_alignment","name":"$seq1props"},{"name":"$seq2props","containerName":"parse_next_alignment","line":272,"kind":13},{"name":"$seq2props","containerName":"parse_next_alignment","line":273,"kind":13},{"kind":13,"line":274,"definition":"my","name":"$pctid","containerName":"parse_next_alignment","localvar":"my"},{"line":276,"kind":13,"name":"$estseq","containerName":"parse_next_alignment"},{"name":"$self","containerName":"parse_next_alignment","line":279,"kind":13},{"kind":13,"line":284,"name":"$seq1props","containerName":"parse_next_alignment"},{"name":"$seq2props","containerName":"parse_next_alignment","kind":13,"line":284},{"name":"$self","containerName":"parse_next_alignment","line":285,"kind":13},{"line":287,"kind":13,"containerName":"parse_next_alignment","name":"$self"},{"containerName":"parse_next_alignment","name":"$self","line":290,"kind":13},{"containerName":"parse_next_alignment","name":"$estseq","kind":13,"line":291},{"containerName":"parse_next_alignment","name":"%seq1props","kind":13,"line":291},{"kind":13,"line":292,"name":"$genomseq","containerName":"parse_next_alignment"},{"name":"%seq2props","containerName":"parse_next_alignment","kind":13,"line":292},{"line":295,"kind":13,"containerName":"parse_next_alignment","name":"$to_reverse"},{"line":295,"kind":13,"name":"$output_fmt","containerName":"parse_next_alignment"},{"kind":13,"line":295,"containerName":"parse_next_alignment","name":"$genomseq"},{"containerName":"parse_next_alignment","name":"$estseq","kind":13,"line":295},{"name":"$estseq","containerName":"parse_next_alignment","kind":13,"line":297},{"containerName":"parse_next_alignment","name":"%seq2props","line":297,"kind":13},{"containerName":"parse_next_alignment","name":"$genomseq","kind":13,"line":298},{"name":"%seq1props","containerName":"parse_next_alignment","line":298,"kind":13},{"kind":13,"line":301,"containerName":"parse_next_alignment","name":"$to_reverse"},{"name":"$estseq","containerName":"parse_next_alignment","line":301,"kind":13},{"kind":13,"line":304,"containerName":"parse_next_alignment","name":"$hit_direction"},{"containerName":"parse_next_alignment","name":"$tmp","definition":"my","localvar":"my","kind":13,"line":306},{"name":"$to_reverse","containerName":"parse_next_alignment","line":306,"kind":13},{"containerName":"parse_next_alignment","name":"$to_reverse","kind":13,"line":307},{"containerName":"parse_next_alignment","name":"$to_reverse","line":308,"kind":13},{"line":308,"kind":13,"name":"$to_reverse","containerName":"parse_next_alignment"},{"name":"$to_reverse","containerName":"parse_next_alignment","line":309,"kind":13},{"kind":13,"line":309,"name":"$to_reverse","containerName":"parse_next_alignment"},{"name":"$tmp","containerName":"parse_next_alignment","kind":13,"line":309},{"line":312,"kind":13,"localvar":"my","containerName":"parse_next_alignment","definition":"my","name":"$exon"},{"line":312,"kind":12,"containerName":"parse_next_alignment","name":"new"},{"line":313,"kind":13,"name":"$genomseq","containerName":"parse_next_alignment"},{"kind":13,"line":314,"name":"$genomseq","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$hit_direction","line":315,"kind":13},{"name":"$genomseq","containerName":"parse_next_alignment","kind":13,"line":316},{"kind":13,"line":317,"name":"$exon","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"seq_id","kind":12,"line":317},{"line":317,"kind":13,"containerName":"parse_next_alignment","name":"$genomseq"},{"name":"$basename","definition":"my","containerName":"parse_next_alignment","localvar":"my","kind":13,"line":320},{"line":320,"kind":13,"containerName":"parse_next_alignment","name":"$genomseq"},{"kind":13,"line":321,"name":"$exon","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"seq_id","kind":12,"line":321},{"line":321,"kind":13,"containerName":"parse_next_alignment","name":"$basename"},{"line":323,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"kind":12,"line":323,"name":"feature1","containerName":"parse_next_alignment"},{"line":323,"kind":12,"name":"add_tag_value","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$genomseq","line":324,"kind":13},{"containerName":"parse_next_alignment","name":"$exon","line":327,"kind":13},{"containerName":"parse_next_alignment","name":"feature1","line":327,"kind":12},{"name":"can","containerName":"parse_next_alignment","kind":12,"line":327},{"name":"$exon","containerName":"parse_next_alignment","kind":13,"line":328},{"name":"feature1","containerName":"parse_next_alignment","line":328,"kind":12},{"name":"seqlength","containerName":"parse_next_alignment","line":328,"kind":12},{"kind":13,"line":328,"containerName":"parse_next_alignment","name":"$genomseq"},{"kind":13,"line":330,"containerName":"parse_next_alignment","name":"$exon"},{"kind":12,"line":330,"containerName":"parse_next_alignment","name":"feature1"},{"name":"add_tag_value","containerName":"parse_next_alignment","kind":12,"line":330},{"line":331,"kind":13,"name":"$genomseq","containerName":"parse_next_alignment"},{"kind":13,"line":334,"name":"$fea2","definition":"my","containerName":"parse_next_alignment","localvar":"my"},{"line":334,"kind":12,"containerName":"parse_next_alignment","name":"new"},{"name":"$estseq","containerName":"parse_next_alignment","kind":13,"line":335},{"name":"$estseq","containerName":"parse_next_alignment","kind":13,"line":336},{"line":339,"kind":13,"name":"$estseq","containerName":"parse_next_alignment"},{"line":340,"kind":13,"containerName":"parse_next_alignment","name":"$fea2"},{"name":"seq_id","containerName":"parse_next_alignment","line":340,"kind":12},{"containerName":"parse_next_alignment","name":"$estseq","kind":13,"line":340},{"line":343,"kind":13,"localvar":"my","containerName":"parse_next_alignment","definition":"my","name":"$basename"},{"containerName":"parse_next_alignment","name":"$estseq","kind":13,"line":344},{"name":"$fea2","containerName":"parse_next_alignment","kind":13,"line":345},{"line":345,"kind":12,"containerName":"parse_next_alignment","name":"seq_id"},{"kind":13,"line":345,"name":"$basename","containerName":"parse_next_alignment"},{"kind":13,"line":347,"name":"$fea2","containerName":"parse_next_alignment"},{"name":"add_tag_value","containerName":"parse_next_alignment","line":347,"kind":12},{"line":347,"kind":13,"name":"$estseq","containerName":"parse_next_alignment"},{"name":"$fea2","containerName":"parse_next_alignment","line":348,"kind":13},{"kind":12,"line":348,"name":"seqlength","containerName":"parse_next_alignment"},{"kind":13,"line":348,"name":"$estseq","containerName":"parse_next_alignment"},{"kind":13,"line":350,"name":"$exon","containerName":"parse_next_alignment"},{"line":350,"kind":12,"containerName":"parse_next_alignment","name":"est_hit"},{"containerName":"parse_next_alignment","name":"$fea2","line":350,"kind":13},{"name":"$exon","containerName":"parse_next_alignment","line":352,"kind":13},{"kind":12,"line":352,"containerName":"parse_next_alignment","name":"source_tag"},{"line":352,"kind":13,"containerName":"parse_next_alignment","name":"$self"},{"name":"analysis_method","containerName":"parse_next_alignment","kind":12,"line":352},{"containerName":"parse_next_alignment","name":"$exon","line":353,"kind":13},{"line":353,"kind":12,"name":"percentage_id","containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","name":"$pctid","kind":13,"line":353},{"containerName":"parse_next_alignment","name":"$exon","kind":13,"line":354},{"name":"score","containerName":"parse_next_alignment","kind":12,"line":354},{"kind":13,"line":354,"containerName":"parse_next_alignment","name":"$exon"},{"line":354,"kind":12,"name":"percentage_id","containerName":"parse_next_alignment"},{"kind":13,"line":356,"name":"@exons","containerName":"parse_next_alignment"},{"line":356,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"line":360,"kind":13,"containerName":"parse_next_alignment","name":"@exons"}],"line":208},{"kind":12,"line":263,"name":"complement"},{"kind":12,"line":312,"name":"Bio","containerName":"Tools::Sim4::Exon"},{"name":"File","containerName":"Basename::fileparse","line":320,"kind":12},{"line":334,"kind":12,"name":"Bio","containerName":"SeqFeature::Similarity"},{"line":344,"kind":12,"containerName":"Basename::fileparse","name":"File"},{"name":"next_exonset","definition":"sub","containerName":"main::","range":{"end":{"line":412,"character":9999},"start":{"line":388,"character":0}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_exonset","line":389,"kind":13},{"line":390,"kind":13,"localvar":"my","definition":"my","name":"$exonset","containerName":"next_exonset"},{"containerName":"next_exonset","name":"@exons","definition":"my","localvar":"my","kind":13,"line":393},{"containerName":"next_exonset","name":"$self","kind":13,"line":393},{"line":393,"kind":12,"name":"parse_next_alignment","containerName":"next_exonset"},{"kind":13,"line":394,"containerName":"next_exonset","name":"@exons"},{"line":395,"kind":13,"name":"$self","containerName":"next_exonset"},{"containerName":"next_exonset","name":"_fh","line":395,"kind":12},{"containerName":"next_exonset","name":"$self","line":396,"kind":13},{"containerName":"next_exonset","name":"next_exonset","line":396,"kind":12},{"name":"$exonset","containerName":"next_exonset","kind":13,"line":400},{"kind":12,"line":400,"name":"new","containerName":"next_exonset"},{"containerName":"next_exonset","name":"$exons","kind":13,"line":400},{"containerName":"next_exonset","name":"start","kind":12,"line":400},{"line":401,"kind":13,"containerName":"next_exonset","name":"$exons"},{"containerName":"next_exonset","name":"end","line":401,"kind":12},{"line":402,"kind":13,"containerName":"next_exonset","name":"$exons"},{"name":"strand","containerName":"next_exonset","line":402,"kind":12},{"containerName":"next_exonset","name":"$exonset","line":404,"kind":13},{"name":"source_tag","containerName":"next_exonset","line":404,"kind":12},{"kind":13,"line":404,"name":"$exons","containerName":"next_exonset"},{"containerName":"next_exonset","name":"source_tag","kind":12,"line":404},{"containerName":"next_exonset","name":"$exonset","kind":13,"line":405},{"containerName":"next_exonset","name":"seq_id","kind":12,"line":405},{"line":405,"kind":13,"containerName":"next_exonset","name":"$exons"},{"kind":12,"line":405,"containerName":"next_exonset","name":"seq_id"},{"kind":13,"line":408,"name":"$exon","definition":"my","containerName":"next_exonset","localvar":"my"},{"name":"@exons","containerName":"next_exonset","kind":13,"line":408},{"line":409,"kind":13,"containerName":"next_exonset","name":"$exonset"},{"line":409,"kind":12,"name":"add_sub_SeqFeature","containerName":"next_exonset"},{"containerName":"next_exonset","name":"$exon","line":409,"kind":13},{"kind":13,"line":411,"name":"$exonset","containerName":"next_exonset"}],"line":388},{"name":"Bio","containerName":"SeqFeature::Generic","line":400,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"next_feature($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Sim4::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney-at-sanger.ac.uk>\n#          and Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Ewan Birney and Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Sim4::Results - Results of one Sim4 run\n\n=head1 SYNOPSIS\n\n   # to preset the order of EST and genomic file as given on the sim4 \n   # command line:\n   my $sim4 = Bio::Tools::Sim4::Results->new(-file => 'result.sim4',\n                                             -estfirst => 1);\n   # to let the order be determined automatically (by length comparison):\n   $sim4 = Bio::Tools::Sim4::Results->new( -file => 'sim4.results' );\n   # filehandle:\n   $sim4 = Bio::Tools::Sim4::Results->new( -fh   => \\*INPUT );\n\n   # parse the results\n   while(my $exonset = $sim4->next_exonset()) {\n       # $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Sim4::Exons\n       # as sub features\n       print \"Delimited on sequence \", $exonset->seq_id(), \n             \"from \", $exonset->start(), \" to \", $exonset->end(), \"\\n\";\n       foreach my $exon ( $exonset->sub_SeqFeature() ) {\n\t  # $exon is-a Bio::SeqFeature::FeaturePair\n\t  print \"Exon from \", $exon->start, \" to \", $exon->end, \n                \" on strand \", $exon->strand(), \"\\n\";\n          # you can get out what it matched using the est_hit attribute\n          my $homol = $exon->est_hit();\n          print \"Matched to sequence \", $homol->seq_id, \n                \" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n      }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # stays open)\n   $sim4->close();\n\n=head1 DESCRIPTION\n\nThe sim4 module provides a parser and results object for sim4 output. The\nsim4 results are specialised types of SeqFeatures, meaning you can add them\nto AnnSeq objects fine, and manipulate them in the \"normal\" seqfeature manner.\n\nThe sim4 Exon objects are Bio::SeqFeature::FeaturePair inherited objects. The \n$esthit = $exon-E<gt>est_hit() is the alignment as a feature on the matching \nobject (normally, an EST), in which the start/end points are where the hit\nlies.\n\nTo make this module work sensibly you need to run\n\n     sim4 genomic.fasta est.database.fasta\nor\n     sim4 est.fasta genomic.database.fasta\n\nTo get the sequence identifiers recorded for the first sequence, too, use\nA=4 as output option for sim4.\n\nOne fiddle here is that there are only two real possibilities to the matching\ncriteria: either one sequence needs reversing or not. Because of this, it\nis impossible to tell whether the match is in the forward or reverse strand\nof the genomic DNA. We solve this here by assuming that the genomic DNA is\nalways forward. As a consequence, the strand attribute of the matching EST is\nunknown, and the strand attribute of the genomic DNA (i.e., the Exon object)\nwill reflect the direction of the hit.\n\nSee the documentation of parse_next_alignment() for abilities of the parser\nto deal with the different output format options of sim4.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Hilmar Lapp\n\nEwan Birney E<lt>birney-at-sanger.ac.ukE<gt>\nHilmar Lapp E<lt>hlapp-at-gmx.netE<gt> or E<lt>hilmar.lapp-at-pharma.novartis.comE<gt>.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Sim4::Results;\nuse strict;\n\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Sim4::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n    delete($self->{'_est_is_first'});\n    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Sim4\");\n}\n\n=head2 analysis_method\n\n Usage     : $sim4->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /sim4/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /sim4/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $sim4_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Sim4 result file and returns the\n           found exons as an array of Bio::Tools::Sim4::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n\n           The $exon->seq_id() attribute will be set to the identifier of the\n           respective sequence for both sequences if A=4 was used in the sim4\n           run, and otherwise for the second sequence only. If the output does\n           not contain the identifier, the filename stripped of path and \n           extension is used instead. In addition, the full filename \n           will be recorded for both features ($exon inherits off \n           Bio::SeqFeature::SimilarityPair) as tag 'filename'. The length\n           is accessible via the seqlength() attribute of $exon->query() and\n           $exon->est_hit().\n\n           Note that this method is capable of dealing with outputs generated\n           with format 0,1,3, and 4 (via the A=n option to sim4). It\n           automatically determines which of the two sequences has been \n           reversed, and adjusts the coordinates for that sequence. It will\n           also detect whether the EST sequence(s) were given as first or as\n           second file to sim4, unless this has been specified at creation\n           time of the object.\n\n Example :\n Returns : An array of Bio::Tools::Sim4::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n   my ($self) = @_;\n   my @exons = ();\n   my %seq1props = ();\n   my %seq2props = ();\n   # we refer to the properties of each seq by reference\n   my ($estseq, $genomseq, $to_reverse);\n   my $started = 0;\n   my $hit_direction = 1;\n   my $output_fmt = 3; # same as 0 and 1 (we cannot deal with A=2 produced\n                       # output yet)\n   \n   while(defined($_ = $self->_readline())) {\n       #chomp();\n       #\n       # bascially, each sim4 'hit' starts with seq1...\n       #\n       /^seq1/ && do {\n\t   if($started) {\n\t       $self->_pushback($_);\n\t       last;\n\t   }\n\t   $started = 1;\n\n\t   # filename and length of seq 1\n\t   /^seq1\\s+=\\s+(\\S+)\\,\\s+(\\d+)/ ||\n\t       $self->throw(\"Sim4 parsing error on seq1 [$_] line. Sorry!\");\n\t   $seq1props{'filename'} = $1;\n\t   $seq1props{'length'} = $2;\n\t   next;\n       };\n       /^seq2/ && do {\n\t   # the second hit has also the database name in the >name syntax \n\t   # (in brackets).\n\t   /^seq2\\s+=\\s+(\\S+)\\s+\\(>?(\\S+)\\s*\\)\\,\\s+(\\d+)/||\n\t       $self->throw(\"Sim4 parsing error on seq2 [$_] line. Sorry!\");\n\t   $seq2props{'filename'} = $1;\n\t   $seq2props{'seqname'} = $2;\n\t   $seq2props{'length'} = $3;\n\t   next;\n       };\n       if(/^>(\\S+)\\s*(.*)$/) {\n\t   # output option was A=4, which not only gives the complete\n\t   # description lines, but also causes the longer sequence to be\n\t   # reversed if the second file contained one (genomic) sequence\n\t   $seq1props{'seqname'} = $1;\n\t   $seq1props{'description'} = $2 if $2;\n\t   $output_fmt = 4;\n\t   # we handle seq1 and seq2 both here\n\t   if(defined($_ = $self->_readline()) && (/^>(\\S+)\\s*(.*)$/)) {\n\t       $seq2props{'seqname'} = $1; # redundant, since already set above\n\t       $seq2props{'description'} = $2 if $2;\n\t   }\n\t   next;\n       }\n       /^\\(complement\\)/ && do {\n\t   $hit_direction = -1;\n\t   next;\n       };\n       # this matches\n       # start-end (start-end) pctid%\n       if(/(\\d+)-(\\d+)\\s+\\((\\d+)-(\\d+)\\)\\s+(\\d+)%/) {\n \t   $seq1props{'start'} = $1;\n \t   $seq1props{'end'} = $2;\n \t   $seq2props{'start'} = $3;\n \t   $seq2props{'end'} = $4;\n\t   my $pctid   = $5;\n\t   \n\t   if(! defined($estseq)) {\n\t       # for the first time here: need to set the references referring\n\t       # to seq1 and seq2 \n\t       if(! exists($self->{'_est_is_first'})) {\n\t\t   # detect which one is the EST by looking at the lengths,\n\t\t   # and assume that this holds throughout the entire result\n\t\t   # file (i.e., when this method is called for the next\n\t\t   # alignment, this will not be checked again)\n\t\t   if($seq1props{'length'} > $seq2props{'length'}) {\n\t\t       $self->{'_est_is_first'} = 0;\n\t\t   } else {\n\t\t       $self->{'_est_is_first'} = 1;\n\t\t   }\n\t       }\n\t       if($self->{'_est_is_first'}) {\n\t\t   $estseq = \\%seq1props;\n\t\t   $genomseq = \\%seq2props;\n\t\t   # if the EST is given first, A=4 selects the genomic\n\t\t   # seq for being reversed (reversing the EST is default)\n\t\t   $to_reverse = ($output_fmt == 4) ? $genomseq : $estseq;\n\t       } else {\n\t\t   $estseq = \\%seq2props;\n\t\t   $genomseq = \\%seq1props;\n\t\t   # if the EST is the second, A=4 does not change the\n\t\t   # seq being reversed (always the EST is reversed)\n\t\t   $to_reverse = $estseq;\n\t       }\n\t   }\n\t   if($hit_direction == -1) {\n\t       # we have to reverse the coordinates of one of both seqs\n\t       my $tmp = $to_reverse->{'start'};\n\t       $to_reverse->{'start'} =\n\t\t   $to_reverse->{'length'} - $to_reverse->{'end'} + 1;\n\t       $to_reverse->{'end'} = $to_reverse->{'length'} - $tmp + 1;\n\t   }\n\t   # create and initialize the exon object\n\t   my $exon = Bio::Tools::Sim4::Exon->new(\n\t\t\t\t\t    '-start' => $genomseq->{'start'},\n\t\t\t\t\t    '-end'   => $genomseq->{'end'},\n\t\t\t\t\t    '-strand' => $hit_direction);\n\t   if(exists($genomseq->{'seqname'})) {\n\t       $exon->seq_id($genomseq->{'seqname'});\n\t   } else {\n\t       # take filename stripped of path as fall back\n\t       my ($basename) = &File::Basename::fileparse($genomseq->{'filename'}, '\\..*');\n\t       $exon->seq_id($basename);\n\t   }\n\t   $exon->feature1()->add_tag_value('filename',\n\t\t\t\t\t    $genomseq->{'filename'});\n\t   # feature1 is supposed to be initialized to a Similarity object,\n           # but we provide a safety net\n\t   if($exon->feature1()->can('seqlength')) {\n\t       $exon->feature1()->seqlength($genomseq->{'length'});\n\t   } else {\n\t       $exon->feature1()->add_tag_value('SeqLength',\n\t\t\t\t\t\t$genomseq->{'length'});\n\t   }\n\t   # create and initialize the feature wrapping the 'hit' (the EST)\n\t   my $fea2 = Bio::SeqFeature::Similarity->new(\n                                            '-start' => $estseq->{'start'},\n\t\t\t\t\t    '-end'   => $estseq->{'end'},\n\t\t\t\t\t    '-strand' => 0,\n\t\t\t\t\t    '-primary' => \"aligning_EST\");\n\t   if(exists($estseq->{'seqname'})) {\n\t       $fea2->seq_id($estseq->{'seqname'});\n\t   } else {\n\t       # take filename stripped of path as fall back\n\t       my ($basename) =\n\t\t   &File::Basename::fileparse($estseq->{'filename'}, '\\..*');\n\t       $fea2->seq_id($basename);\n\t   }\n\t   $fea2->add_tag_value('filename', $estseq->{'filename'});\n\t   $fea2->seqlength($estseq->{'length'});\n\t   # store\n\t   $exon->est_hit($fea2);\t   \n\t   # general properties\n\t   $exon->source_tag($self->analysis_method());\n\t   $exon->percentage_id($pctid);\n\t   $exon->score($exon->percentage_id());\n\t   # push onto array\n\t   push(@exons, $exon);\n\t   next; # back to while loop\n       }\n   }\n   return @exons;\n}\n\n=head2 next_exonset\n\n Title   : next_exonset\n Usage   : $exonset = $sim4_result->parse_next_exonset;\n           print \"Exons start at \", $exonset->start(), \n                 \"and end at \", $exonset->end(), \"\\n\";\n           foreach $exon ($exonset->sub_SeqFeature()) {\n               # do something\n           }\n Function: Parses the next alignment of the Sim4 result file and returns the\n           set of exons as a container of features. The container is itself\n           a Bio::SeqFeature::Generic object, with the Bio::Tools::Sim4::Exon\n           objects as sub features. Start, end, and strand of the container\n           will represent the total region covered by the exons of this set.\n\n           See the documentation of parse_next_alignment() for further\n           reference about parsing and how the information is stored.\n\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Sim4::Exon\n           objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my @exons = $self->parse_next_alignment();\n    unless( @exons ) {\n\treturn if eof($self->_fh);\n\treturn $self->next_exonset;\n    } \n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons[0]->start(),\n\t\t\t\t\t     '-end' => $exons[0]->end(),\n\t\t\t\t\t     '-strand' => $exons[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons[0]->source_tag());\n    $exonset->seq_id($exons[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($exonset = $sim4->next_feature()) {\n                  # do something\n           }\n Function: Does the same as L<next_exonset()>. See there for documentation of\n           the functionality. Call this method repeatedly until FALSE is\n           returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_exonset() at present.\n\n Example :\n Returns : A Bio::SeqFeature::Generic object.\n Args    :"},"kind":12,"line":435,"children":[{"containerName":"next_feature","name":"$self","definition":"my","localvar":"my","kind":13,"line":436},{"containerName":"next_feature","name":"@args","kind":13,"line":436},{"name":"$self","containerName":"next_feature","line":440,"kind":13},{"line":440,"kind":12,"containerName":"next_feature","name":"next_exonset"},{"kind":13,"line":440,"name":"@args","containerName":"next_feature"}],"name":"next_feature","range":{"start":{"character":0,"line":435},"end":{"line":441,"character":9999}}}]}