{"version":5,"vars":[{"line":98,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"end":{"character":9999,"line":119},"start":{"line":112,"character":0}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: Signalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Parser module for Signalp Bio::Tools::Signalp\n#\n# \n# Based on the EnsEMBL module\n# Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp originally\n# written by Marc Sohrmann (ms2@sanger.ac.uk) Written in BioPipe by\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Balamurugan Kumarasamy <savikalpa@fugu-sg.org> Cared for by the Fugu\n# Informatics team (fuguteam@fugu-sg.org)\n\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp - parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp;\n\n my $parser = Bio::Tools::Signalp->new(-fh =>$filehandle );\n\n while( my $sp_feat = $parser->next_result ) {\n   if ($sp_feat->score > 0.9) {\n      push @likely_sigpep, $sp_feat;\n   }\n }\n\n=head1 DESCRIPTION\n\nC<SignalP> predicts the presence and location of signal peptide\ncleavage sites in amino acid sequences.\n\nL<Bio::Tools::Signalp> parses the output of C<SignalP> to provide a \nL<Bio::SeqFeature::Generic> object describing the signal peptide\nfound, if any. It returns a variety of tags extracted from the NN and HMM\nanalysis. Most importantly, the C<score()> attribute contains the\nNN probability of this being a true signal peptide.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted va the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2_AT_sanger.ac.uk). Written in BioPipe by\nBalamurugan Kumarasamy savikalpa_AT_fugu-sg.org. Cared for by the Fugu\nInformatics team (fuguteam_AT_fugu-sg.org)\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann - torsten.seemann AT infotech.monash.edu.au\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Signalp->new();\n Function: Builds a new Bio::Tools::Signalp object\n Returns : Bio::Tools::Signalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"line":112,"children":[{"line":113,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"containerName":"new","name":"@args","kind":13,"line":113},{"kind":13,"line":115,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":115,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":115,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":116,"kind":13},{"name":"_initialize_io","containerName":"new","line":116,"kind":12},{"line":116,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":118}]},{"kind":12,"line":115,"name":"SUPER","containerName":"new"},{"range":{"end":{"line":183,"character":9999},"start":{"character":0,"line":131}},"name":"next_result","line":131,"children":[{"line":132,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$self"},{"localvar":"my","name":"$line","definition":"my","containerName":"next_result","line":134,"kind":13},{"line":134,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_readline","containerName":"next_result","line":134,"kind":12},{"containerName":"next_result","name":"$line","line":135,"kind":13},{"kind":13,"line":137,"name":"$line","containerName":"next_result"},{"kind":13,"line":138,"containerName":"next_result","name":"$self"},{"kind":12,"line":138,"containerName":"next_result","name":"_seqname"},{"kind":13,"line":140,"containerName":"next_result","name":"$line"},{"kind":13,"line":141,"containerName":"next_result","name":"$self"},{"name":"_fact1","containerName":"next_result","kind":12,"line":141},{"name":"$line","containerName":"next_result","kind":13,"line":143},{"localvar":"my","containerName":"next_result","name":"$fact2","definition":"my","line":144,"kind":13},{"line":146,"kind":13,"name":"$fact2","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":146},{"containerName":"next_result","name":"_fact1","line":146,"kind":12},{"localvar":"my","name":"$line","definition":"my","containerName":"next_result","line":148,"kind":13},{"kind":13,"line":148,"containerName":"next_result","name":"$self"},{"line":148,"kind":12,"name":"_readline","containerName":"next_result"},{"line":153,"kind":13,"name":"$line","containerName":"next_result"},{"containerName":"next_result","name":"$line","kind":13,"line":155},{"containerName":"next_result","name":"$line","line":156,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":156},{"containerName":"next_result","name":"_readline","line":156,"kind":12},{"name":"$end","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":159},{"name":"$line","containerName":"next_result","kind":13,"line":163},{"definition":"my","name":"$end","containerName":"next_result","localvar":"my","kind":13,"line":164},{"containerName":"next_result","definition":"my","name":"%feature","localvar":"my","kind":13,"line":165},{"line":166,"kind":13,"containerName":"next_result","name":"$feature"},{"name":"$self","containerName":"next_result","kind":13,"line":166},{"name":"_seqname","containerName":"next_result","line":166,"kind":12},{"line":167,"kind":13,"name":"$feature","containerName":"next_result"},{"containerName":"next_result","name":"$feature","kind":13,"line":168},{"line":168,"kind":13,"name":"$end","containerName":"next_result"},{"kind":13,"line":169,"containerName":"next_result","name":"$feature"},{"name":"$feature","containerName":"next_result","line":170,"kind":13},{"line":171,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":171,"containerName":"next_result","name":"_parse_hmm_result"},{"line":171,"kind":13,"containerName":"next_result","name":"%feature"},{"line":172,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$new_feat"},{"name":"$self","containerName":"next_result","line":172,"kind":13},{"name":"_create_feature","containerName":"next_result","line":172,"kind":12},{"kind":13,"line":172,"name":"%feature","containerName":"next_result"},{"kind":13,"line":173,"name":"$new_feat","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":176,"kind":13},{"name":"throw","containerName":"next_result","kind":12,"line":176}],"kind":12,"detail":"($self)","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Signalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Parser module for Signalp Bio::Tools::Signalp\n#\n# \n# Based on the EnsEMBL module\n# Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp originally\n# written by Marc Sohrmann (ms2@sanger.ac.uk) Written in BioPipe by\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Balamurugan Kumarasamy <savikalpa@fugu-sg.org> Cared for by the Fugu\n# Informatics team (fuguteam@fugu-sg.org)\n\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp - parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp;\n\n my $parser = Bio::Tools::Signalp->new(-fh =>$filehandle );\n\n while( my $sp_feat = $parser->next_result ) {\n   if ($sp_feat->score > 0.9) {\n      push @likely_sigpep, $sp_feat;\n   }\n }\n\n=head1 DESCRIPTION\n\nC<SignalP> predicts the presence and location of signal peptide\ncleavage sites in amino acid sequences.\n\nL<Bio::Tools::Signalp> parses the output of C<SignalP> to provide a \nL<Bio::SeqFeature::Generic> object describing the signal peptide\nfound, if any. It returns a variety of tags extracted from the NN and HMM\nanalysis. Most importantly, the C<score()> attribute contains the\nNN probability of this being a true signal peptide.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted va the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2_AT_sanger.ac.uk). Written in BioPipe by\nBalamurugan Kumarasamy savikalpa_AT_fugu-sg.org. Cared for by the Fugu\nInformatics team (fuguteam_AT_fugu-sg.org)\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann - torsten.seemann AT infotech.monash.edu.au\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Signalp->new();\n Function: Builds a new Bio::Tools::Signalp object\n Returns : Bio::Tools::Signalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $signalp->next_result\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"name":"seq_id","kind":12,"line":166},{"name":"start","line":167,"kind":12},{"name":"end","line":168,"kind":12},{"line":169,"kind":12,"name":"source_tag"},{"kind":12,"line":170,"name":"primary"},{"range":{"start":{"line":195,"character":0},"end":{"line":208,"character":9999}},"name":"_parse_hmm_result","line":195,"children":[{"line":196,"kind":13,"localvar":"my","containerName":"_parse_hmm_result","definition":"my","name":"$self"},{"line":196,"kind":13,"containerName":"_parse_hmm_result","name":"$feature_hash"},{"localvar":"my","definition":"my","name":"$line","containerName":"_parse_hmm_result","line":197,"kind":13},{"name":"$self","containerName":"_parse_hmm_result","line":197,"kind":13},{"containerName":"_parse_hmm_result","name":"_readline","kind":12,"line":197},{"kind":13,"line":198,"name":"$line","containerName":"_parse_hmm_result"},{"line":199,"kind":13,"name":"$line","containerName":"_parse_hmm_result"},{"containerName":"_parse_hmm_result","name":"$feature_hash","kind":13,"line":200},{"name":"$line","containerName":"_parse_hmm_result","line":201,"kind":13},{"containerName":"_parse_hmm_result","name":"$feature_hash","kind":13,"line":202},{"line":203,"kind":13,"containerName":"_parse_hmm_result","name":"$line"},{"line":204,"kind":13,"name":"$feature_hash","containerName":"_parse_hmm_result"}],"kind":12,"detail":"($self,$feature_hash)","signature":{"documentation":"1;\n# $Id: Signalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Parser module for Signalp Bio::Tools::Signalp\n#\n# \n# Based on the EnsEMBL module\n# Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp originally\n# written by Marc Sohrmann (ms2@sanger.ac.uk) Written in BioPipe by\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Balamurugan Kumarasamy <savikalpa@fugu-sg.org> Cared for by the Fugu\n# Informatics team (fuguteam@fugu-sg.org)\n\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp - parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp;\n\n my $parser = Bio::Tools::Signalp->new(-fh =>$filehandle );\n\n while( my $sp_feat = $parser->next_result ) {\n   if ($sp_feat->score > 0.9) {\n      push @likely_sigpep, $sp_feat;\n   }\n }\n\n=head1 DESCRIPTION\n\nC<SignalP> predicts the presence and location of signal peptide\ncleavage sites in amino acid sequences.\n\nL<Bio::Tools::Signalp> parses the output of C<SignalP> to provide a \nL<Bio::SeqFeature::Generic> object describing the signal peptide\nfound, if any. It returns a variety of tags extracted from the NN and HMM\nanalysis. Most importantly, the C<score()> attribute contains the\nNN probability of this being a true signal peptide.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted va the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2_AT_sanger.ac.uk). Written in BioPipe by\nBalamurugan Kumarasamy savikalpa_AT_fugu-sg.org. Cared for by the Fugu\nInformatics team (fuguteam_AT_fugu-sg.org)\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann - torsten.seemann AT infotech.monash.edu.au\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Signalp->new();\n Function: Builds a new Bio::Tools::Signalp object\n Returns : Bio::Tools::Signalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $signalp->next_result\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\nsub next_result {\n        my ($self) = @_;\n        \n        while (my $line=$self->_readline()) {\n           chomp $line;\n           \n           if ($line=~/^\\>(\\S+)/) {\n              $self->_seqname($1);\n           }\n           elsif ($line=~/max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              $self->_fact1($2);\n           }\n           elsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              my $fact2 = $2;\n              \n              if ($fact2 eq 'YES' and $self->_fact1 eq 'YES') {\n                  \n                  my $line = $self->_readline();\n                  \n                  ###########################################\n                  # modification to suit new SignalP output\n                  ###########################################\n\t\t\t\t\tchomp $line;\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t\t\t\tif ($line =~ /\\s+D\\s+.*/) {\n\t\t\t\t  \t\t$line = $self->_readline();\n\t\t\t\t\t}\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t  \t\t\tmy $end;\n\t\t  \t\t  ###########################################\n\t\t  \n              \n                  if ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n                      my $end = $1;\n                      my (%feature);\n                      $feature{seq_id} = $self->_seqname;\n                      $feature{start} = 1;\n                      $feature{end} = $end;\n                      $feature{source_tag} = 'Signalp';\n                      $feature{primary}= 'signal_peptide';\n                      $self->_parse_hmm_result(\\%feature);\n                      my $new_feat = $self->_create_feature (\\%feature);\n                      return $new_feat;\n                  }\n                  else {\n                      $self->throw (\"parsing problem in signalp\");\n                  }\n                  \n              }\n           }\n        \n        }\n}\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : $self->_parse_hmm_result(\\%feature)\n Function: Internal (not to be used directly)\n Returns : hash of feature values\n Args    : hash of more feature values","parameters":[{"label":"$self"},{"label":"$feature_hash"}],"label":"_parse_hmm_result($self,$feature_hash)"},"containerName":"main::","definition":"sub"},{"name":"hmmProdiction","kind":12,"line":200},{"line":202,"kind":12,"name":"peptideProb"},{"name":"anchorProb","line":204,"kind":12},{"name":"_create_feature","range":{"end":{"line":243,"character":9999},"start":{"line":220,"character":0}},"kind":12,"line":220,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_create_feature","line":221,"kind":13},{"name":"$feat","containerName":"_create_feature","kind":13,"line":221},{"localvar":"my","name":"$feature","definition":"my","containerName":"_create_feature","line":224,"kind":13},{"name":"new","containerName":"_create_feature","kind":12,"line":224},{"kind":13,"line":225,"name":"$feat","containerName":"_create_feature"},{"line":226,"kind":13,"containerName":"_create_feature","name":"$feat"},{"containerName":"_create_feature","name":"$feat","line":227,"kind":13},{"name":"$feat","containerName":"_create_feature","line":228,"kind":13},{"name":"$feat","containerName":"_create_feature","line":229,"kind":13},{"name":"$feat","containerName":"_create_feature","kind":13,"line":230},{"containerName":"_create_feature","name":"$feat","line":231,"kind":13},{"kind":13,"line":234,"containerName":"_create_feature","name":"$feature"},{"kind":12,"line":234,"name":"score","containerName":"_create_feature"},{"name":"$feat","containerName":"_create_feature","line":234,"kind":13},{"name":"$feature","containerName":"_create_feature","line":235,"kind":13},{"containerName":"_create_feature","name":"add_tag_value","line":235,"kind":12},{"line":235,"kind":13,"containerName":"_create_feature","name":"$feat"},{"containerName":"_create_feature","name":"$feature","kind":13,"line":236},{"containerName":"_create_feature","name":"add_tag_value","kind":12,"line":236},{"containerName":"_create_feature","name":"$feat","line":236,"kind":13},{"containerName":"_create_feature","name":"$feature","line":237,"kind":13},{"kind":12,"line":237,"name":"add_tag_value","containerName":"_create_feature"},{"kind":13,"line":237,"containerName":"_create_feature","name":"$feat"},{"kind":13,"line":238,"containerName":"_create_feature","name":"$feature"},{"line":238,"kind":12,"containerName":"_create_feature","name":"add_tag_value"},{"kind":13,"line":239,"name":"$feature","containerName":"_create_feature"},{"name":"add_tag_value","containerName":"_create_feature","line":239,"kind":12},{"name":"$feat","containerName":"_create_feature","line":239,"kind":13},{"name":"$feature","containerName":"_create_feature","line":240,"kind":13},{"line":240,"kind":12,"containerName":"_create_feature","name":"add_tag_value"},{"kind":13,"line":240,"containerName":"_create_feature","name":"$feat"},{"line":241,"kind":13,"containerName":"_create_feature","name":"$feature"}],"containerName":"main::","definition":"sub","detail":"($self,$feat)","signature":{"parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: Signalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Parser module for Signalp Bio::Tools::Signalp\n#\n# \n# Based on the EnsEMBL module\n# Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp originally\n# written by Marc Sohrmann (ms2@sanger.ac.uk) Written in BioPipe by\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Balamurugan Kumarasamy <savikalpa@fugu-sg.org> Cared for by the Fugu\n# Informatics team (fuguteam@fugu-sg.org)\n\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp - parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp;\n\n my $parser = Bio::Tools::Signalp->new(-fh =>$filehandle );\n\n while( my $sp_feat = $parser->next_result ) {\n   if ($sp_feat->score > 0.9) {\n      push @likely_sigpep, $sp_feat;\n   }\n }\n\n=head1 DESCRIPTION\n\nC<SignalP> predicts the presence and location of signal peptide\ncleavage sites in amino acid sequences.\n\nL<Bio::Tools::Signalp> parses the output of C<SignalP> to provide a \nL<Bio::SeqFeature::Generic> object describing the signal peptide\nfound, if any. It returns a variety of tags extracted from the NN and HMM\nanalysis. Most importantly, the C<score()> attribute contains the\nNN probability of this being a true signal peptide.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted va the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2_AT_sanger.ac.uk). Written in BioPipe by\nBalamurugan Kumarasamy savikalpa_AT_fugu-sg.org. Cared for by the Fugu\nInformatics team (fuguteam_AT_fugu-sg.org)\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann - torsten.seemann AT infotech.monash.edu.au\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Signalp->new();\n Function: Builds a new Bio::Tools::Signalp object\n Returns : Bio::Tools::Signalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $signalp->next_result\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\nsub next_result {\n        my ($self) = @_;\n        \n        while (my $line=$self->_readline()) {\n           chomp $line;\n           \n           if ($line=~/^\\>(\\S+)/) {\n              $self->_seqname($1);\n           }\n           elsif ($line=~/max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              $self->_fact1($2);\n           }\n           elsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              my $fact2 = $2;\n              \n              if ($fact2 eq 'YES' and $self->_fact1 eq 'YES') {\n                  \n                  my $line = $self->_readline();\n                  \n                  ###########################################\n                  # modification to suit new SignalP output\n                  ###########################################\n\t\t\t\t\tchomp $line;\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t\t\t\tif ($line =~ /\\s+D\\s+.*/) {\n\t\t\t\t  \t\t$line = $self->_readline();\n\t\t\t\t\t}\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t  \t\t\tmy $end;\n\t\t  \t\t  ###########################################\n\t\t  \n              \n                  if ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n                      my $end = $1;\n                      my (%feature);\n                      $feature{seq_id} = $self->_seqname;\n                      $feature{start} = 1;\n                      $feature{end} = $end;\n                      $feature{source_tag} = 'Signalp';\n                      $feature{primary}= 'signal_peptide';\n                      $self->_parse_hmm_result(\\%feature);\n                      my $new_feat = $self->_create_feature (\\%feature);\n                      return $new_feat;\n                  }\n                  else {\n                      $self->throw (\"parsing problem in signalp\");\n                  }\n                  \n              }\n           }\n        \n        }\n}\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : $self->_parse_hmm_result(\\%feature)\n Function: Internal (not to be used directly)\n Returns : hash of feature values\n Args    : hash of more feature values\n\n\nsub _parse_hmm_result {\n    my ($self, $feature_hash) = @_;\n    while(my $line = $self->_readline){\n        chomp $line;\n        if($line =~ /Prediction: (.+)$/){\n            $feature_hash->{hmmProdiction} = $1;\n        }elsif($line =~ /Signal peptide probability: ([0-9\\.]+)/){\n            $feature_hash->{peptideProb} = $1;\n        }elsif($line =~ /Signal anchor probability: ([0-9\\.]+)/){\n            $feature_hash->{anchorProb} = $1;\n            last;\n        }\n    }\n}\n\n=head2 _create_feature\n\n Title   : _create_feature\n Usage   : $self->create_feature(\\%feature)\n Function: Internal (not to be used directly)\n Returns : hash of feature values\n Args    : hash of more feature values","label":"_create_feature($self,$feat)"}},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":224},{"kind":12,"line":225,"name":"name"},{"name":"start","kind":12,"line":226},{"name":"end","kind":12,"line":227},{"name":"score","kind":12,"line":228},{"name":"source","kind":12,"line":229},{"kind":12,"line":230,"name":"primary"},{"name":"logic_name","kind":12,"line":231},{"name":"peptideProb","line":234,"kind":12},{"name":"peptideProb","kind":12,"line":235},{"name":"anchorProb","line":236,"kind":12},{"kind":12,"line":237,"name":"anchorProb"},{"line":239,"kind":12,"name":"primary"},{"kind":12,"line":240,"name":"hmmProdiction"},{"containerName":"main::","definition":"sub","detail":"($self,$seqname)","signature":{"label":"_seqname($self,$seqname)","parameters":[{"label":"$self"},{"label":"$seqname"}],"documentation":"1;\n# $Id: Signalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Parser module for Signalp Bio::Tools::Signalp\n#\n# \n# Based on the EnsEMBL module\n# Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp originally\n# written by Marc Sohrmann (ms2@sanger.ac.uk) Written in BioPipe by\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Balamurugan Kumarasamy <savikalpa@fugu-sg.org> Cared for by the Fugu\n# Informatics team (fuguteam@fugu-sg.org)\n\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp - parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp;\n\n my $parser = Bio::Tools::Signalp->new(-fh =>$filehandle );\n\n while( my $sp_feat = $parser->next_result ) {\n   if ($sp_feat->score > 0.9) {\n      push @likely_sigpep, $sp_feat;\n   }\n }\n\n=head1 DESCRIPTION\n\nC<SignalP> predicts the presence and location of signal peptide\ncleavage sites in amino acid sequences.\n\nL<Bio::Tools::Signalp> parses the output of C<SignalP> to provide a \nL<Bio::SeqFeature::Generic> object describing the signal peptide\nfound, if any. It returns a variety of tags extracted from the NN and HMM\nanalysis. Most importantly, the C<score()> attribute contains the\nNN probability of this being a true signal peptide.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted va the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2_AT_sanger.ac.uk). Written in BioPipe by\nBalamurugan Kumarasamy savikalpa_AT_fugu-sg.org. Cared for by the Fugu\nInformatics team (fuguteam_AT_fugu-sg.org)\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann - torsten.seemann AT infotech.monash.edu.au\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Signalp->new();\n Function: Builds a new Bio::Tools::Signalp object\n Returns : Bio::Tools::Signalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $signalp->next_result\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\nsub next_result {\n        my ($self) = @_;\n        \n        while (my $line=$self->_readline()) {\n           chomp $line;\n           \n           if ($line=~/^\\>(\\S+)/) {\n              $self->_seqname($1);\n           }\n           elsif ($line=~/max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              $self->_fact1($2);\n           }\n           elsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              my $fact2 = $2;\n              \n              if ($fact2 eq 'YES' and $self->_fact1 eq 'YES') {\n                  \n                  my $line = $self->_readline();\n                  \n                  ###########################################\n                  # modification to suit new SignalP output\n                  ###########################################\n\t\t\t\t\tchomp $line;\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t\t\t\tif ($line =~ /\\s+D\\s+.*/) {\n\t\t\t\t  \t\t$line = $self->_readline();\n\t\t\t\t\t}\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t  \t\t\tmy $end;\n\t\t  \t\t  ###########################################\n\t\t  \n              \n                  if ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n                      my $end = $1;\n                      my (%feature);\n                      $feature{seq_id} = $self->_seqname;\n                      $feature{start} = 1;\n                      $feature{end} = $end;\n                      $feature{source_tag} = 'Signalp';\n                      $feature{primary}= 'signal_peptide';\n                      $self->_parse_hmm_result(\\%feature);\n                      my $new_feat = $self->_create_feature (\\%feature);\n                      return $new_feat;\n                  }\n                  else {\n                      $self->throw (\"parsing problem in signalp\");\n                  }\n                  \n              }\n           }\n        \n        }\n}\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : $self->_parse_hmm_result(\\%feature)\n Function: Internal (not to be used directly)\n Returns : hash of feature values\n Args    : hash of more feature values\n\n\nsub _parse_hmm_result {\n    my ($self, $feature_hash) = @_;\n    while(my $line = $self->_readline){\n        chomp $line;\n        if($line =~ /Prediction: (.+)$/){\n            $feature_hash->{hmmProdiction} = $1;\n        }elsif($line =~ /Signal peptide probability: ([0-9\\.]+)/){\n            $feature_hash->{peptideProb} = $1;\n        }elsif($line =~ /Signal anchor probability: ([0-9\\.]+)/){\n            $feature_hash->{anchorProb} = $1;\n            last;\n        }\n    }\n}\n\n=head2 _create_feature\n\n Title   : _create_feature\n Usage   : $self->create_feature(\\%feature)\n Function: Internal (not to be used directly)\n Returns : hash of feature values\n Args    : hash of more feature values\n\n\nsub _create_feature {\n    my ($self, $feat) = @_;\n\n    # create feature object\n    my $feature = Bio::SeqFeature::Generic->new(\n         -seq_id      => $feat->{name},\n         -start       => $feat->{start},\n         -end         => $feat->{end},\n         -score       => $feat->{score},\n         -source      => $feat->{source},\n         -primary     => $feat->{primary},\n         -logic_name  => $feat->{logic_name}, \n    );\n           \n    $feature->score($feat->{peptideProb});\n    $feature->add_tag_value('peptideProb', $feat->{peptideProb});\n    $feature->add_tag_value('anchorProb', $feat->{anchorProb});\n    $feature->add_tag_value('evalue',$feat->{anchorProb});\n    $feature->add_tag_value('percent_id','NULL');\n    $feature->add_tag_value(\"hid\",$feat->{primary});\n    $feature->add_tag_value('SignalpPrediction', $feat->{hmmProdiction});\n    return $feature; \n\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $self->_seqname($name)\n Function: Internal (not to be used directly)\n Returns :\n Args    :"},"kind":12,"line":255,"children":[{"definition":"my","name":"$self","containerName":"_seqname","localvar":"my","kind":13,"line":256},{"name":"$seqname","containerName":"_seqname","kind":13,"line":256},{"line":258,"kind":13,"name":"$seqname","containerName":"_seqname"},{"line":259,"kind":13,"name":"$self","containerName":"_seqname"},{"name":"$seqname","containerName":"_seqname","kind":13,"line":259},{"name":"$self","containerName":"_seqname","line":261,"kind":13}],"name":"_seqname","range":{"end":{"character":9999,"line":262},"start":{"character":0,"line":255}}},{"range":{"end":{"character":9999,"line":281},"start":{"character":0,"line":274}},"name":"_fact1","children":[{"localvar":"my","containerName":"_fact1","definition":"my","name":"$self","line":275,"kind":13},{"name":"$fact1","containerName":"_fact1","line":275,"kind":13},{"line":277,"kind":13,"containerName":"_fact1","name":"$fact1"},{"line":278,"kind":13,"containerName":"_fact1","name":"$self"},{"containerName":"_fact1","name":"$fact1","kind":13,"line":278},{"containerName":"_fact1","name":"$self","kind":13,"line":280}],"line":274,"kind":12,"signature":{"label":"_fact1($self,$fact1)","parameters":[{"label":"$self"},{"label":"$fact1"}],"documentation":"1;\n# $Id: Signalp.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Parser module for Signalp Bio::Tools::Signalp\n#\n# \n# Based on the EnsEMBL module\n# Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp originally\n# written by Marc Sohrmann (ms2@sanger.ac.uk) Written in BioPipe by\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Balamurugan Kumarasamy <savikalpa@fugu-sg.org> Cared for by the Fugu\n# Informatics team (fuguteam@fugu-sg.org)\n\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Signalp - parser for Signalp output\n\n=head1 SYNOPSIS\n\n use Bio::Tools::Signalp;\n\n my $parser = Bio::Tools::Signalp->new(-fh =>$filehandle );\n\n while( my $sp_feat = $parser->next_result ) {\n   if ($sp_feat->score > 0.9) {\n      push @likely_sigpep, $sp_feat;\n   }\n }\n\n=head1 DESCRIPTION\n\nC<SignalP> predicts the presence and location of signal peptide\ncleavage sites in amino acid sequences.\n\nL<Bio::Tools::Signalp> parses the output of C<SignalP> to provide a \nL<Bio::SeqFeature::Generic> object describing the signal peptide\nfound, if any. It returns a variety of tags extracted from the NN and HMM\nanalysis. Most importantly, the C<score()> attribute contains the\nNN probability of this being a true signal peptide.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted va the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n# Please direct questions and support issues to I<bioperl-l@bioperl.org> \n\nBased on the EnsEMBL module Bio::EnsEMBL::Pipeline::Runnable::Protein::Signalp\noriginally written by Marc Sohrmann (ms2_AT_sanger.ac.uk). Written in BioPipe by\nBalamurugan Kumarasamy savikalpa_AT_fugu-sg.org. Cared for by the Fugu\nInformatics team (fuguteam_AT_fugu-sg.org)\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann - torsten.seemann AT infotech.monash.edu.au\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Signalp;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Signalp->new();\n Function: Builds a new Bio::Tools::Signalp object\n Returns : Bio::Tools::Signalp\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $signalp->next_result\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\nsub next_result {\n        my ($self) = @_;\n        \n        while (my $line=$self->_readline()) {\n           chomp $line;\n           \n           if ($line=~/^\\>(\\S+)/) {\n              $self->_seqname($1);\n           }\n           elsif ($line=~/max\\.\\s+Y\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              $self->_fact1($2);\n           }\n           elsif ($line=~/mean\\s+S\\s+(\\S+)\\s+\\S+\\s+\\S+\\s+(\\S+)/) {\n              my $fact2 = $2;\n              \n              if ($fact2 eq 'YES' and $self->_fact1 eq 'YES') {\n                  \n                  my $line = $self->_readline();\n                  \n                  ###########################################\n                  # modification to suit new SignalP output\n                  ###########################################\n\t\t\t\t\tchomp $line;\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t\t\t\tif ($line =~ /\\s+D\\s+.*/) {\n\t\t\t\t  \t\t$line = $self->_readline();\n\t\t\t\t\t}\n\t\t\t\t\t#print STDERR \"********** <$line>\\n\";\n\t\t  \t\t\tmy $end;\n\t\t  \t\t  ###########################################\n\t\t  \n              \n                  if ($line =~ /Most likely cleavage site between pos\\.\\s+(\\d+)/) {\n                      my $end = $1;\n                      my (%feature);\n                      $feature{seq_id} = $self->_seqname;\n                      $feature{start} = 1;\n                      $feature{end} = $end;\n                      $feature{source_tag} = 'Signalp';\n                      $feature{primary}= 'signal_peptide';\n                      $self->_parse_hmm_result(\\%feature);\n                      my $new_feat = $self->_create_feature (\\%feature);\n                      return $new_feat;\n                  }\n                  else {\n                      $self->throw (\"parsing problem in signalp\");\n                  }\n                  \n              }\n           }\n        \n        }\n}\n\n=head2 _parse_hmm_result\n\n Title   : _parse_hmm_result\n Usage   : $self->_parse_hmm_result(\\%feature)\n Function: Internal (not to be used directly)\n Returns : hash of feature values\n Args    : hash of more feature values\n\n\nsub _parse_hmm_result {\n    my ($self, $feature_hash) = @_;\n    while(my $line = $self->_readline){\n        chomp $line;\n        if($line =~ /Prediction: (.+)$/){\n            $feature_hash->{hmmProdiction} = $1;\n        }elsif($line =~ /Signal peptide probability: ([0-9\\.]+)/){\n            $feature_hash->{peptideProb} = $1;\n        }elsif($line =~ /Signal anchor probability: ([0-9\\.]+)/){\n            $feature_hash->{anchorProb} = $1;\n            last;\n        }\n    }\n}\n\n=head2 _create_feature\n\n Title   : _create_feature\n Usage   : $self->create_feature(\\%feature)\n Function: Internal (not to be used directly)\n Returns : hash of feature values\n Args    : hash of more feature values\n\n\nsub _create_feature {\n    my ($self, $feat) = @_;\n\n    # create feature object\n    my $feature = Bio::SeqFeature::Generic->new(\n         -seq_id      => $feat->{name},\n         -start       => $feat->{start},\n         -end         => $feat->{end},\n         -score       => $feat->{score},\n         -source      => $feat->{source},\n         -primary     => $feat->{primary},\n         -logic_name  => $feat->{logic_name}, \n    );\n           \n    $feature->score($feat->{peptideProb});\n    $feature->add_tag_value('peptideProb', $feat->{peptideProb});\n    $feature->add_tag_value('anchorProb', $feat->{anchorProb});\n    $feature->add_tag_value('evalue',$feat->{anchorProb});\n    $feature->add_tag_value('percent_id','NULL');\n    $feature->add_tag_value(\"hid\",$feat->{primary});\n    $feature->add_tag_value('SignalpPrediction', $feat->{hmmProdiction});\n    return $feature; \n\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $self->_seqname($name)\n Function: Internal (not to be used directly)\n Returns :\n Args    :\n\n\nsub _seqname{\n    my ($self,$seqname)=@_;\n\n    if (defined$seqname){\n        $self->{'seqname'}=$seqname;\n    }\n    return $self->{'seqname'};\n}\n\n=head2 _fact1\n\n Title   : _fact1\n Usage   : $self->fact1($fact1)\n Function: Internal (not to be used directly)\n Returns : \n Args    :"},"detail":"($self,$fact1)","definition":"sub","containerName":"main::"}]}