{"vars":[{"kind":2,"line":195,"containerName":"","name":"base"},{"containerName":"","name":"vars","line":197,"kind":2},{"line":198,"kind":13,"containerName":null,"name":"$ID"},{"containerName":null,"name":"%WeightTable_euc","kind":13,"line":200},{"containerName":null,"name":"%WeightTable_pro","line":225,"kind":13},{"definition":"my","name":"$i","containerName":null,"localvar":"my","kind":13,"line":264},{"containerName":null,"name":"%WeightTable_euc","kind":13,"line":264},{"localvar":"my","containerName":null,"name":"$expected","definition":"my","line":265,"kind":13},{"line":265,"kind":13,"name":"%WeightTable_euc","containerName":null},{"containerName":null,"name":"@i","kind":13,"line":265},{"kind":13,"line":266,"name":"%expected","containerName":null},{"localvar":"my","name":"$j","definition":"my","containerName":null,"line":267,"kind":13},{"containerName":null,"name":"$j","kind":13,"line":267},{"name":"%j","containerName":null,"line":267,"kind":13},{"containerName":null,"name":"%WeightTable_euc","line":268,"kind":13},{"containerName":null,"name":"@i","line":268,"kind":13},{"containerName":null,"name":"%j","line":268,"kind":13},{"kind":13,"line":269,"name":"%WeightTable_euc","containerName":null},{"kind":13,"line":269,"containerName":null,"name":"@i"},{"name":"$j","containerName":null,"line":269,"kind":13},{"kind":13,"line":270,"containerName":null,"name":"$j"},{"containerName":null,"name":"%j","kind":13,"line":270},{"containerName":null,"name":"%WeightTable_euc","kind":13,"line":271},{"line":271,"kind":13,"containerName":null,"name":"@i"},{"line":271,"kind":13,"containerName":null,"name":"$j"},{"line":274,"kind":13,"containerName":null,"name":"%WeightTable_euc"},{"kind":13,"line":274,"name":"@i","containerName":null},{"kind":13,"line":274,"name":"$j","containerName":null},{"kind":13,"line":274,"containerName":null,"name":"%WeightTable_euc"},{"line":274,"kind":13,"name":"@i","containerName":null},{"kind":13,"line":274,"name":"$j","containerName":null},{"kind":13,"line":274,"containerName":null,"name":"$expected"},{"containerName":null,"name":"$i","definition":"my","localvar":"my","kind":13,"line":280},{"line":280,"kind":13,"name":"%WeightTable_pro","containerName":null},{"line":281,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$expected"},{"kind":13,"line":281,"containerName":null,"name":"%WeightTable_pro"},{"name":"@i","containerName":null,"line":281,"kind":13},{"containerName":null,"name":"%expected","kind":13,"line":282},{"containerName":null,"definition":"my","name":"$j","localvar":"my","kind":13,"line":283},{"containerName":null,"name":"$j","line":283,"kind":13},{"kind":13,"line":283,"containerName":null,"name":"%j"},{"kind":13,"line":284,"name":"%WeightTable_pro","containerName":null},{"containerName":null,"name":"@i","line":284,"kind":13},{"name":"%j","containerName":null,"kind":13,"line":284},{"containerName":null,"name":"%WeightTable_pro","line":285,"kind":13},{"name":"@i","containerName":null,"kind":13,"line":285},{"containerName":null,"name":"$j","line":285,"kind":13},{"containerName":null,"name":"$j","kind":13,"line":286},{"line":286,"kind":13,"containerName":null,"name":"%j"},{"containerName":null,"name":"%WeightTable_pro","kind":13,"line":287},{"kind":13,"line":287,"containerName":null,"name":"@i"},{"containerName":null,"name":"$j","kind":13,"line":287},{"line":290,"kind":13,"name":"%WeightTable_pro","containerName":null},{"containerName":null,"name":"@i","line":290,"kind":13},{"name":"$j","containerName":null,"line":290,"kind":13},{"line":290,"kind":13,"containerName":null,"name":"%WeightTable_pro"},{"line":290,"kind":13,"name":"@i","containerName":null},{"containerName":null,"name":"$j","line":290,"kind":13},{"line":290,"kind":13,"name":"$expected","containerName":null},{"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":301},{"kind":13,"line":301,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":303,"kind":13},{"name":"$class","containerName":"new","line":303,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":303},{"line":306,"kind":13,"localvar":"my","containerName":"new","name":"$seq","definition":"my"},{"kind":13,"line":306,"containerName":"new","name":"$threshold"},{"kind":13,"line":306,"name":"$matrix","containerName":"new"},{"line":306,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","kind":12,"line":306},{"containerName":"new","name":"@args","line":306,"kind":13},{"line":308,"kind":13,"name":"$threshold","containerName":"new"},{"name":"$self","containerName":"new","line":308,"kind":13},{"containerName":"new","name":"threshold","line":308,"kind":12},{"kind":13,"line":308,"containerName":"new","name":"$threshold"},{"name":"$matrix","containerName":"new","kind":13,"line":309},{"containerName":"new","name":"$self","line":309,"kind":13},{"kind":12,"line":309,"containerName":"new","name":"matrix"},{"line":309,"kind":13,"containerName":"new","name":"$matrix"},{"line":310,"kind":13,"name":"$seq","containerName":"new"},{"line":310,"kind":13,"name":"$self","containerName":"new"},{"name":"seq","containerName":"new","line":310,"kind":12},{"containerName":"new","name":"$seq","line":310,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":312}],"line":300,"kind":12,"signature":{"label":"new($class,@args)","documentation":"#                                 CONSTRUCTOR                                     ##","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":313},"start":{"line":300,"character":0}},"name":"new"},{"name":"SUPER","containerName":"new","kind":12,"line":303},{"range":{"end":{"line":340,"character":9999},"start":{"character":0,"line":331}},"name":"threshold","line":331,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"threshold","line":333,"kind":13},{"kind":13,"line":333,"containerName":"threshold","name":"$value"},{"name":"$value","containerName":"threshold","line":334,"kind":13},{"line":335,"kind":13,"containerName":"threshold","name":"$self"},{"line":335,"kind":12,"containerName":"threshold","name":"throw"},{"line":336,"kind":13,"containerName":"threshold","name":"$value"},{"name":"$self","containerName":"threshold","line":337,"kind":13},{"containerName":"threshold","name":"$value","line":337,"kind":13},{"containerName":"threshold","name":"$self","kind":13,"line":339}],"kind":12,"detail":"($self,$value)","signature":{"label":"threshold($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"#########################################################################\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::Tools::Sigcleave\n# AUTHOR  : Chris Dagdigian, dag@sonsorol.org\n# CREATED : Jan 28 1999\n# REVISION: $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chris Dagdigian and others. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or \n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Object framework ripped from Steve Chervits's SeqPattern.pm\n# \n# Core EGCG Sigcleave emulation from perl code developed by\n# Danh Nguyen & Kamalakar Gulukota which itself was based \n# loosely on Colgrove's signal.c program.\n#\n# The overall idea is to replicate the output of the sigcleave\n# program which was distributed with the EGCG extension to the GCG sequence\n# analysis package. There is also an accessor method for just getting at\n# the raw results.\n#\n#-----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::Sigcleave - Bioperl object for sigcleave analysis\n\n=head1 SYNOPSIS\n\n=head2 Object Creation\n\n  use Bio::Tools::Sigcleave ();\n\n  # to keep the module backwar compatible, you can pass it a sequence string, but\n  # there recommended say is to pass it a Seq object\n\n  # this works\n  $seq = \"MVLLLILSVLLLKEDVRGSAQSSERRVVAHMPGDIIIGALFSVHHQPTVDKVHERKCGAVREQYGI\";\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seq,\n                                                -type => 'protein',\n                                                -threshold=>'3.5',\n                                                );\n  # but you do:\n  $seqobj = Bio::PrimarySeq->new(-seq => $seq);\n\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seqobj,\n                                                -threshold=>'3.5',\n                                                );\n\n  # now you can detect procaryotic signal sequences as well as eucaryotic\n  $sig->matrix('eucaryotic'); # or 'procaryotic'\n\n\n=head2 Object Methods & Accessors\n\n  # you can use this method to fine tune the threshod before printing out the results\n  $sig->result_count:\n\n  %raw_results      = $sig->signals;\n  $formatted_output = $sig->pretty_print;\n\n=head1 DESCRIPTION\n\n\"Sigcleave\" was a program distributed as part of the free EGCG add-on\nto earlier versions of the GCG Sequence Analysis package. A new\nimplementation of the algorithm is now part of EMBOSS package.\n\nFrom the EGCG documentation:\n\n  SigCleave uses the von Heijne method to locate signal sequences, and\n  to identify the cleavage site. The method is 95% accurate in\n  resolving signal sequences from non-signal sequences with a cutoff\n  score of 3.5, and 75-80% accurate in identifying the cleavage\n  site. The program reports all hits above a minimum value.\n\nThe EGCG Sigcleave program was written by Peter Rice (E-mail:\npmr@sanger.ac.uk Post: Informatics Division, The Sanger Centre,\nWellcome Trust Genome Campus, Hinxton, Cambs, CB10 1SA, UK).\n\nSince EGCG is no longer distributed for the latest versions of GCG,\nthis code was developed to emulate the output of the original program\nas much as possible for those who lost access to sigcleave when\nupgrading to newer versions of GCG.\n\nThere are 2 accessor methods for this object. \"signals\" will return a\nperl associative array containing the sigcleave scores keyed by amino\nacid position.  \"pretty_print\" returns a formatted string similar to\nthe output of the original sigcleave utility.\n\nIn both cases, the \"threshold\" setting controls the score reporting\nlevel. If no value for threshold is passed in by the user, the code\ndefaults to a reporting value of 3.5.\n\nIn this implemntation the accessor will never return any\nscore/position pair which does not meet the threshold limit. This is\nthe slightly different from the behaviour of the 8.1 EGCG sigcleave\nprogram which will report the highest of the under-threshold results\nif nothing else is found.\n\n\nExample of pretty_print output:\n\n\tSIGCLEAVE of sigtest from: 1 to 146\n\n\tReport scores over 3.5\n\tMaximum score 4.9 at residue 131\n\n\t Sequence:  FVILAAMSIQGSA-NLQTQWKSTASLALET\n        \t    | (signal)    | (mature peptide)\n          \t118            131\n\n\t Other entries above 3.5\n\n\tMaximum score 3.7 at residue 112\n\n\t Sequence:  CSRQLFGWLFCKV-HPGAIVFVILAAMSIQGSANLQTQWKSTASLALET\n         \t   | (signal)    | (mature peptide)\n           \t99            112\n\n\n=head1 FEEDBACK\n\nWhen updating and maintaining a module, it helps to know that people\nare actually using it. Let us know if you find a bug, think this code\nis useful or have any improvements/features to suggest.\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChris Dagdigian, dag-at-sonsorol.org  & others\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 VERSION\n\nBio::Tools::Sigcleave, $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999 Chris Dagdigian & others. All Rights Reserved.\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 REFERENCES / SEE ALSO\n\nvon Heijne G. (1986) \"A new method for predicting signal sequences\ncleavage sites.\"  Nucleic Acids Res. 14, 4683-4690.\n\nvon Heijne G. (1987) in \"Sequence Analysis in Molecular Biology:\nTreasure Trove or Trivial Pursuit\" (Acad. Press, (1987), 113-117).\n\n\n=head1 APPENDIX\n\nThe following documentation describes the various functions\ncontained in this module. Some functions are for internal \nuse and are not meant to be called by the user; they are \npreceded by an underscore (\"_\").\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#\n\npackage Bio::Tools::Sigcleave;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID %WeightTable_euc  %WeightTable_pro );\n$ID  = 'Bio::Tools::Sigcleave';\n\n  %WeightTable_euc = (\n#Sample: 161 aligned sequences\n# R     -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n 'A' => [16, 13, 14, 15, 20, 18, 18, 17, 25, 15, 47,  6, 80, 18,  6, 14.5],\n 'C' => [ 3,  6,  9,  7,  9, 14,  6,  8,  5,  6, 19,  3,  9,  8,  3,  4.5],\n 'D' => [ 0,  0,  0,  0,  0,  0,  0,  0,  5,  3,  0,  5,  0, 10, 11,  8.9],\n 'E' => [ 0,  0,  0,  1,  0,  0,  0,  0,  3,  7,  0,  7,  0, 13, 14, 10.0],\n 'F' => [13,  9, 11, 11,  6,  7, 18, 13,  4,  5,  0, 13,  0,  6,  4,  5.6],\n 'G' => [ 4,  4,  3,  6,  3, 13,  3,  2, 19, 34,  5,  7, 39, 10,  7, 12.1],\n 'H' => [ 0,  0,  0,  0,  0,  1,  1,  0,  5,  0,  0,  6,  0,  4,  2,  3.4],\n 'I' => [15, 15,  8,  6, 11,  5,  4,  8,  5,  1, 10,  5,  0,  8,  7,  7.4],\n 'K' => [ 0,  0,  0,  1,  0,  0,  1,  0,  0,  4,  0,  2,  0, 11,  9, 11.3],\n 'L' => [71, 68, 72, 79, 78, 45, 64, 49, 10, 23,  8, 20,  1,  8,  4, 12.1],\n 'M' => [ 0,  3,  7,  4,  1,  6,  2,  2,  0,  0,  0,  1,  0,  1,  2,  2.7],\n 'N' => [ 0,  1,  0,  1,  1,  0,  0,  0,  3,  3,  0, 10,  0,  4,  7,  7.1],\n 'P' => [ 2,  0,  2,  0,  0,  4,  1,  8, 20, 14,  0,  1,  3,  0, 22,  7.4],\n 'Q' => [ 0,  0,  0,  1,  0,  6,  1,  0, 10,  8,  0, 18,  3, 19, 10,  6.3],\n 'R' => [ 2,  0,  0,  0,  0,  1,  0,  0,  7,  4,  0, 15,  0, 12,  9,  7.6],\n 'S' => [ 9,  3,  8,  6, 13, 10, 15, 16, 26, 11, 23, 17, 20, 15, 10, 11.4],\n 'T' => [ 2, 10,  5,  4,  5, 13,  7,  7, 12,  6, 17,  8,  6,  3, 10,  9.7],\n 'V' => [20, 25, 15, 18, 13, 15, 11, 27,  0, 12, 32,  3,  0,  8, 17, 11.1],\n 'W' => [ 4,  3,  3,  1,  1,  2,  6,  3,  1,  3,  0,  9,  0,  2,  0,  1.8],\n 'Y' => [ 0,  1,  4,  0,  0,  1,  3,  1,  1,  2,  0,  5,  0,  1,  7,  5.6]\n);\n\n  %WeightTable_pro = (\n#Sample: 36 aligned sequences\n#  R    -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n  'A' => [0,  8,  8,  9,  6,  7,  5,  6,  7,  7, 24,  2, 31, 18,  4,  3.2],\n  'C' => [1,  0,  0,  1,  1,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,  1.0],\n  'D' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  8,  2.0],\n  'E' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  4,  8,  2.2],\n  'F' => [2,  4,  3,  4,  1,  1,  8,  0,  4,  1,  0,  7,  0,  1,  0,  1.3],\n  'G' => [4,  2,  2,  2,  3,  5,  2,  4,  2,  2,  0,  2,  2,  1,  0,  2.7],\n  'H' => [0,  0,  1,  0,  0,  0,  0,  1,  1,  0,  0,  7,  0,  1,  0,  0.8],\n  'I' => [3,  1,  5,  1,  5,  0,  1,  3,  0,  0,  0,  0,  0,  0,  2,  1.7],\n  'K' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  2,  0,  3,  0,  2.5],\n  'L' => [8, 11,  9,  8,  9, 13,  1,  0,  2,  2,  1,  2,  0,  0,  1,  2.7],\n  'M' => [0,  2,  1,  1,  3,  2,  3,  0,  1,  2,  0,  4,  0,  0,  1,  0.6],\n  'N' => [0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  0,  3,  0,  1,  4,  1.6],\n  'P' => [0,  1,  1,  1,  1,  1,  2,  3,  5,  2,  0,  0,  0,  0,  5,  1.7],\n  'Q' => [0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  0,  3,  0,  0,  1,  1.4],\n  'R' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  1.7],\n  'S' => [1,  0,  1,  4,  4,  1,  5, 15,  5,  8,  5,  2,  2,  0,  0,  2.6],\n  'T' => [2,  0,  4,  2,  2,  2,  2,  2,  5,  1,  3,  0,  1,  1,  2,  2.2],\n  'V' => [5,  7,  1,  3,  1,  4,  7,  0,  0,  4,  3,  0,  0,  2,  0,  2.5],\n  'W' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0.4],\n  'Y' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  1.3]\n);\n\n\n##\n## Now we calculate the _real_ values for the weight tables\n##\n##\n## yeah yeah yeah there is lots of math here that gets repeated\n## every single time a sigcleave object gets created. This is\n## a quick hack to make sure that we get the scores as accurate as\n## possible. Need all those significant digits....\n##\n## suggestions for speedup aproaches welcome\n##\n\n\nforeach my $i (keys %WeightTable_euc) {\n\tmy $expected = $WeightTable_euc{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_euc{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_euc{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_euc{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_euc{$i}[$j] = log($WeightTable_euc{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n\nforeach my $i (keys %WeightTable_pro) {\n\tmy $expected = $WeightTable_pro{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_pro{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_pro{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_pro{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_pro{$i}[$j] = log($WeightTable_pro{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    #my $self = Bio::Seq->new(@args);\n\n    my ($seq, $threshold, $matrix) = $self->_rearrange([qw(SEQ THRESHOLD MATRIX)],@args);\n\n    defined $threshold && $self->threshold($threshold);\n    $matrix && $self->matrix($matrix);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n\n=head1 threshold\n\n Title     : threshold\n Usage     : $value = $self->threshold\n Purpose   : Read/write method sigcleave score reporting threshold.\n Returns   : float.\n Argument  : new value, float\n Throws    : on non-number argument\n Comments  : defaults to 3.5\n See Also   : n/a"},"containerName":"main::","definition":"sub"},{"kind":12,"line":356,"children":[{"name":"$self","definition":"my","containerName":"matrix","localvar":"my","kind":13,"line":358},{"containerName":"matrix","name":"$value","kind":13,"line":358},{"line":359,"kind":13,"name":"$value","containerName":"matrix"},{"containerName":"matrix","name":"$self","kind":13,"line":360},{"line":360,"kind":12,"name":"throw","containerName":"matrix"},{"name":"$value","containerName":"matrix","kind":13,"line":361},{"kind":13,"line":361,"containerName":"matrix","name":"$value"},{"name":"$self","containerName":"matrix","kind":13,"line":362},{"containerName":"matrix","name":"$value","kind":13,"line":362},{"kind":13,"line":364,"containerName":"matrix","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"#########################################################################\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::Tools::Sigcleave\n# AUTHOR  : Chris Dagdigian, dag@sonsorol.org\n# CREATED : Jan 28 1999\n# REVISION: $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chris Dagdigian and others. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or \n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Object framework ripped from Steve Chervits's SeqPattern.pm\n# \n# Core EGCG Sigcleave emulation from perl code developed by\n# Danh Nguyen & Kamalakar Gulukota which itself was based \n# loosely on Colgrove's signal.c program.\n#\n# The overall idea is to replicate the output of the sigcleave\n# program which was distributed with the EGCG extension to the GCG sequence\n# analysis package. There is also an accessor method for just getting at\n# the raw results.\n#\n#-----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::Sigcleave - Bioperl object for sigcleave analysis\n\n=head1 SYNOPSIS\n\n=head2 Object Creation\n\n  use Bio::Tools::Sigcleave ();\n\n  # to keep the module backwar compatible, you can pass it a sequence string, but\n  # there recommended say is to pass it a Seq object\n\n  # this works\n  $seq = \"MVLLLILSVLLLKEDVRGSAQSSERRVVAHMPGDIIIGALFSVHHQPTVDKVHERKCGAVREQYGI\";\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seq,\n                                                -type => 'protein',\n                                                -threshold=>'3.5',\n                                                );\n  # but you do:\n  $seqobj = Bio::PrimarySeq->new(-seq => $seq);\n\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seqobj,\n                                                -threshold=>'3.5',\n                                                );\n\n  # now you can detect procaryotic signal sequences as well as eucaryotic\n  $sig->matrix('eucaryotic'); # or 'procaryotic'\n\n\n=head2 Object Methods & Accessors\n\n  # you can use this method to fine tune the threshod before printing out the results\n  $sig->result_count:\n\n  %raw_results      = $sig->signals;\n  $formatted_output = $sig->pretty_print;\n\n=head1 DESCRIPTION\n\n\"Sigcleave\" was a program distributed as part of the free EGCG add-on\nto earlier versions of the GCG Sequence Analysis package. A new\nimplementation of the algorithm is now part of EMBOSS package.\n\nFrom the EGCG documentation:\n\n  SigCleave uses the von Heijne method to locate signal sequences, and\n  to identify the cleavage site. The method is 95% accurate in\n  resolving signal sequences from non-signal sequences with a cutoff\n  score of 3.5, and 75-80% accurate in identifying the cleavage\n  site. The program reports all hits above a minimum value.\n\nThe EGCG Sigcleave program was written by Peter Rice (E-mail:\npmr@sanger.ac.uk Post: Informatics Division, The Sanger Centre,\nWellcome Trust Genome Campus, Hinxton, Cambs, CB10 1SA, UK).\n\nSince EGCG is no longer distributed for the latest versions of GCG,\nthis code was developed to emulate the output of the original program\nas much as possible for those who lost access to sigcleave when\nupgrading to newer versions of GCG.\n\nThere are 2 accessor methods for this object. \"signals\" will return a\nperl associative array containing the sigcleave scores keyed by amino\nacid position.  \"pretty_print\" returns a formatted string similar to\nthe output of the original sigcleave utility.\n\nIn both cases, the \"threshold\" setting controls the score reporting\nlevel. If no value for threshold is passed in by the user, the code\ndefaults to a reporting value of 3.5.\n\nIn this implemntation the accessor will never return any\nscore/position pair which does not meet the threshold limit. This is\nthe slightly different from the behaviour of the 8.1 EGCG sigcleave\nprogram which will report the highest of the under-threshold results\nif nothing else is found.\n\n\nExample of pretty_print output:\n\n\tSIGCLEAVE of sigtest from: 1 to 146\n\n\tReport scores over 3.5\n\tMaximum score 4.9 at residue 131\n\n\t Sequence:  FVILAAMSIQGSA-NLQTQWKSTASLALET\n        \t    | (signal)    | (mature peptide)\n          \t118            131\n\n\t Other entries above 3.5\n\n\tMaximum score 3.7 at residue 112\n\n\t Sequence:  CSRQLFGWLFCKV-HPGAIVFVILAAMSIQGSANLQTQWKSTASLALET\n         \t   | (signal)    | (mature peptide)\n           \t99            112\n\n\n=head1 FEEDBACK\n\nWhen updating and maintaining a module, it helps to know that people\nare actually using it. Let us know if you find a bug, think this code\nis useful or have any improvements/features to suggest.\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChris Dagdigian, dag-at-sonsorol.org  & others\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 VERSION\n\nBio::Tools::Sigcleave, $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999 Chris Dagdigian & others. All Rights Reserved.\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 REFERENCES / SEE ALSO\n\nvon Heijne G. (1986) \"A new method for predicting signal sequences\ncleavage sites.\"  Nucleic Acids Res. 14, 4683-4690.\n\nvon Heijne G. (1987) in \"Sequence Analysis in Molecular Biology:\nTreasure Trove or Trivial Pursuit\" (Acad. Press, (1987), 113-117).\n\n\n=head1 APPENDIX\n\nThe following documentation describes the various functions\ncontained in this module. Some functions are for internal \nuse and are not meant to be called by the user; they are \npreceded by an underscore (\"_\").\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#\n\npackage Bio::Tools::Sigcleave;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID %WeightTable_euc  %WeightTable_pro );\n$ID  = 'Bio::Tools::Sigcleave';\n\n  %WeightTable_euc = (\n#Sample: 161 aligned sequences\n# R     -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n 'A' => [16, 13, 14, 15, 20, 18, 18, 17, 25, 15, 47,  6, 80, 18,  6, 14.5],\n 'C' => [ 3,  6,  9,  7,  9, 14,  6,  8,  5,  6, 19,  3,  9,  8,  3,  4.5],\n 'D' => [ 0,  0,  0,  0,  0,  0,  0,  0,  5,  3,  0,  5,  0, 10, 11,  8.9],\n 'E' => [ 0,  0,  0,  1,  0,  0,  0,  0,  3,  7,  0,  7,  0, 13, 14, 10.0],\n 'F' => [13,  9, 11, 11,  6,  7, 18, 13,  4,  5,  0, 13,  0,  6,  4,  5.6],\n 'G' => [ 4,  4,  3,  6,  3, 13,  3,  2, 19, 34,  5,  7, 39, 10,  7, 12.1],\n 'H' => [ 0,  0,  0,  0,  0,  1,  1,  0,  5,  0,  0,  6,  0,  4,  2,  3.4],\n 'I' => [15, 15,  8,  6, 11,  5,  4,  8,  5,  1, 10,  5,  0,  8,  7,  7.4],\n 'K' => [ 0,  0,  0,  1,  0,  0,  1,  0,  0,  4,  0,  2,  0, 11,  9, 11.3],\n 'L' => [71, 68, 72, 79, 78, 45, 64, 49, 10, 23,  8, 20,  1,  8,  4, 12.1],\n 'M' => [ 0,  3,  7,  4,  1,  6,  2,  2,  0,  0,  0,  1,  0,  1,  2,  2.7],\n 'N' => [ 0,  1,  0,  1,  1,  0,  0,  0,  3,  3,  0, 10,  0,  4,  7,  7.1],\n 'P' => [ 2,  0,  2,  0,  0,  4,  1,  8, 20, 14,  0,  1,  3,  0, 22,  7.4],\n 'Q' => [ 0,  0,  0,  1,  0,  6,  1,  0, 10,  8,  0, 18,  3, 19, 10,  6.3],\n 'R' => [ 2,  0,  0,  0,  0,  1,  0,  0,  7,  4,  0, 15,  0, 12,  9,  7.6],\n 'S' => [ 9,  3,  8,  6, 13, 10, 15, 16, 26, 11, 23, 17, 20, 15, 10, 11.4],\n 'T' => [ 2, 10,  5,  4,  5, 13,  7,  7, 12,  6, 17,  8,  6,  3, 10,  9.7],\n 'V' => [20, 25, 15, 18, 13, 15, 11, 27,  0, 12, 32,  3,  0,  8, 17, 11.1],\n 'W' => [ 4,  3,  3,  1,  1,  2,  6,  3,  1,  3,  0,  9,  0,  2,  0,  1.8],\n 'Y' => [ 0,  1,  4,  0,  0,  1,  3,  1,  1,  2,  0,  5,  0,  1,  7,  5.6]\n);\n\n  %WeightTable_pro = (\n#Sample: 36 aligned sequences\n#  R    -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n  'A' => [0,  8,  8,  9,  6,  7,  5,  6,  7,  7, 24,  2, 31, 18,  4,  3.2],\n  'C' => [1,  0,  0,  1,  1,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,  1.0],\n  'D' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  8,  2.0],\n  'E' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  4,  8,  2.2],\n  'F' => [2,  4,  3,  4,  1,  1,  8,  0,  4,  1,  0,  7,  0,  1,  0,  1.3],\n  'G' => [4,  2,  2,  2,  3,  5,  2,  4,  2,  2,  0,  2,  2,  1,  0,  2.7],\n  'H' => [0,  0,  1,  0,  0,  0,  0,  1,  1,  0,  0,  7,  0,  1,  0,  0.8],\n  'I' => [3,  1,  5,  1,  5,  0,  1,  3,  0,  0,  0,  0,  0,  0,  2,  1.7],\n  'K' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  2,  0,  3,  0,  2.5],\n  'L' => [8, 11,  9,  8,  9, 13,  1,  0,  2,  2,  1,  2,  0,  0,  1,  2.7],\n  'M' => [0,  2,  1,  1,  3,  2,  3,  0,  1,  2,  0,  4,  0,  0,  1,  0.6],\n  'N' => [0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  0,  3,  0,  1,  4,  1.6],\n  'P' => [0,  1,  1,  1,  1,  1,  2,  3,  5,  2,  0,  0,  0,  0,  5,  1.7],\n  'Q' => [0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  0,  3,  0,  0,  1,  1.4],\n  'R' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  1.7],\n  'S' => [1,  0,  1,  4,  4,  1,  5, 15,  5,  8,  5,  2,  2,  0,  0,  2.6],\n  'T' => [2,  0,  4,  2,  2,  2,  2,  2,  5,  1,  3,  0,  1,  1,  2,  2.2],\n  'V' => [5,  7,  1,  3,  1,  4,  7,  0,  0,  4,  3,  0,  0,  2,  0,  2.5],\n  'W' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0.4],\n  'Y' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  1.3]\n);\n\n\n##\n## Now we calculate the _real_ values for the weight tables\n##\n##\n## yeah yeah yeah there is lots of math here that gets repeated\n## every single time a sigcleave object gets created. This is\n## a quick hack to make sure that we get the scores as accurate as\n## possible. Need all those significant digits....\n##\n## suggestions for speedup aproaches welcome\n##\n\n\nforeach my $i (keys %WeightTable_euc) {\n\tmy $expected = $WeightTable_euc{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_euc{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_euc{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_euc{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_euc{$i}[$j] = log($WeightTable_euc{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n\nforeach my $i (keys %WeightTable_pro) {\n\tmy $expected = $WeightTable_pro{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_pro{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_pro{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_pro{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_pro{$i}[$j] = log($WeightTable_pro{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    #my $self = Bio::Seq->new(@args);\n\n    my ($seq, $threshold, $matrix) = $self->_rearrange([qw(SEQ THRESHOLD MATRIX)],@args);\n\n    defined $threshold && $self->threshold($threshold);\n    $matrix && $self->matrix($matrix);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n\n=head1 threshold\n\n Title     : threshold\n Usage     : $value = $self->threshold\n Purpose   : Read/write method sigcleave score reporting threshold.\n Returns   : float.\n Argument  : new value, float\n Throws    : on non-number argument\n Comments  : defaults to 3.5\n See Also   : n/a\n\n\n#----------------\nsub threshold {\n#----------------\n\tmy ($self, $value) = @_;\n\tif( defined $value) {\n\t\t$self->throw(\"I need a number, not [$value]\")\n\t\t  if  $value !~ /^[+-]?[\\d\\.]+$/;\n\t\t$self->{'_threshold'} = $value;\n\t}\n\treturn $self->{'_threshold'} || 3.5 ;\n}\n\n=head1 matrix\n\n Title     : matrix\n Usage     : $value = $self->matrix('procaryotic')\n Purpose   : Read/write method sigcleave matrix.\n Returns   : float.\n Argument  : new value: 'eucaryotic' or 'procaryotic'\n Throws    : on non-number argument\n Comments  : defaults to 3.5\n See Also   : n/a","parameters":[{"label":"$self"},{"label":"$value"}],"label":"matrix($self,$value)"},"name":"matrix","range":{"end":{"character":9999,"line":365},"start":{"character":0,"line":356}}},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"#########################################################################\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::Tools::Sigcleave\n# AUTHOR  : Chris Dagdigian, dag@sonsorol.org\n# CREATED : Jan 28 1999\n# REVISION: $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chris Dagdigian and others. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or \n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Object framework ripped from Steve Chervits's SeqPattern.pm\n# \n# Core EGCG Sigcleave emulation from perl code developed by\n# Danh Nguyen & Kamalakar Gulukota which itself was based \n# loosely on Colgrove's signal.c program.\n#\n# The overall idea is to replicate the output of the sigcleave\n# program which was distributed with the EGCG extension to the GCG sequence\n# analysis package. There is also an accessor method for just getting at\n# the raw results.\n#\n#-----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::Sigcleave - Bioperl object for sigcleave analysis\n\n=head1 SYNOPSIS\n\n=head2 Object Creation\n\n  use Bio::Tools::Sigcleave ();\n\n  # to keep the module backwar compatible, you can pass it a sequence string, but\n  # there recommended say is to pass it a Seq object\n\n  # this works\n  $seq = \"MVLLLILSVLLLKEDVRGSAQSSERRVVAHMPGDIIIGALFSVHHQPTVDKVHERKCGAVREQYGI\";\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seq,\n                                                -type => 'protein',\n                                                -threshold=>'3.5',\n                                                );\n  # but you do:\n  $seqobj = Bio::PrimarySeq->new(-seq => $seq);\n\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seqobj,\n                                                -threshold=>'3.5',\n                                                );\n\n  # now you can detect procaryotic signal sequences as well as eucaryotic\n  $sig->matrix('eucaryotic'); # or 'procaryotic'\n\n\n=head2 Object Methods & Accessors\n\n  # you can use this method to fine tune the threshod before printing out the results\n  $sig->result_count:\n\n  %raw_results      = $sig->signals;\n  $formatted_output = $sig->pretty_print;\n\n=head1 DESCRIPTION\n\n\"Sigcleave\" was a program distributed as part of the free EGCG add-on\nto earlier versions of the GCG Sequence Analysis package. A new\nimplementation of the algorithm is now part of EMBOSS package.\n\nFrom the EGCG documentation:\n\n  SigCleave uses the von Heijne method to locate signal sequences, and\n  to identify the cleavage site. The method is 95% accurate in\n  resolving signal sequences from non-signal sequences with a cutoff\n  score of 3.5, and 75-80% accurate in identifying the cleavage\n  site. The program reports all hits above a minimum value.\n\nThe EGCG Sigcleave program was written by Peter Rice (E-mail:\npmr@sanger.ac.uk Post: Informatics Division, The Sanger Centre,\nWellcome Trust Genome Campus, Hinxton, Cambs, CB10 1SA, UK).\n\nSince EGCG is no longer distributed for the latest versions of GCG,\nthis code was developed to emulate the output of the original program\nas much as possible for those who lost access to sigcleave when\nupgrading to newer versions of GCG.\n\nThere are 2 accessor methods for this object. \"signals\" will return a\nperl associative array containing the sigcleave scores keyed by amino\nacid position.  \"pretty_print\" returns a formatted string similar to\nthe output of the original sigcleave utility.\n\nIn both cases, the \"threshold\" setting controls the score reporting\nlevel. If no value for threshold is passed in by the user, the code\ndefaults to a reporting value of 3.5.\n\nIn this implemntation the accessor will never return any\nscore/position pair which does not meet the threshold limit. This is\nthe slightly different from the behaviour of the 8.1 EGCG sigcleave\nprogram which will report the highest of the under-threshold results\nif nothing else is found.\n\n\nExample of pretty_print output:\n\n\tSIGCLEAVE of sigtest from: 1 to 146\n\n\tReport scores over 3.5\n\tMaximum score 4.9 at residue 131\n\n\t Sequence:  FVILAAMSIQGSA-NLQTQWKSTASLALET\n        \t    | (signal)    | (mature peptide)\n          \t118            131\n\n\t Other entries above 3.5\n\n\tMaximum score 3.7 at residue 112\n\n\t Sequence:  CSRQLFGWLFCKV-HPGAIVFVILAAMSIQGSANLQTQWKSTASLALET\n         \t   | (signal)    | (mature peptide)\n           \t99            112\n\n\n=head1 FEEDBACK\n\nWhen updating and maintaining a module, it helps to know that people\nare actually using it. Let us know if you find a bug, think this code\nis useful or have any improvements/features to suggest.\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChris Dagdigian, dag-at-sonsorol.org  & others\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 VERSION\n\nBio::Tools::Sigcleave, $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999 Chris Dagdigian & others. All Rights Reserved.\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 REFERENCES / SEE ALSO\n\nvon Heijne G. (1986) \"A new method for predicting signal sequences\ncleavage sites.\"  Nucleic Acids Res. 14, 4683-4690.\n\nvon Heijne G. (1987) in \"Sequence Analysis in Molecular Biology:\nTreasure Trove or Trivial Pursuit\" (Acad. Press, (1987), 113-117).\n\n\n=head1 APPENDIX\n\nThe following documentation describes the various functions\ncontained in this module. Some functions are for internal \nuse and are not meant to be called by the user; they are \npreceded by an underscore (\"_\").\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#\n\npackage Bio::Tools::Sigcleave;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID %WeightTable_euc  %WeightTable_pro );\n$ID  = 'Bio::Tools::Sigcleave';\n\n  %WeightTable_euc = (\n#Sample: 161 aligned sequences\n# R     -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n 'A' => [16, 13, 14, 15, 20, 18, 18, 17, 25, 15, 47,  6, 80, 18,  6, 14.5],\n 'C' => [ 3,  6,  9,  7,  9, 14,  6,  8,  5,  6, 19,  3,  9,  8,  3,  4.5],\n 'D' => [ 0,  0,  0,  0,  0,  0,  0,  0,  5,  3,  0,  5,  0, 10, 11,  8.9],\n 'E' => [ 0,  0,  0,  1,  0,  0,  0,  0,  3,  7,  0,  7,  0, 13, 14, 10.0],\n 'F' => [13,  9, 11, 11,  6,  7, 18, 13,  4,  5,  0, 13,  0,  6,  4,  5.6],\n 'G' => [ 4,  4,  3,  6,  3, 13,  3,  2, 19, 34,  5,  7, 39, 10,  7, 12.1],\n 'H' => [ 0,  0,  0,  0,  0,  1,  1,  0,  5,  0,  0,  6,  0,  4,  2,  3.4],\n 'I' => [15, 15,  8,  6, 11,  5,  4,  8,  5,  1, 10,  5,  0,  8,  7,  7.4],\n 'K' => [ 0,  0,  0,  1,  0,  0,  1,  0,  0,  4,  0,  2,  0, 11,  9, 11.3],\n 'L' => [71, 68, 72, 79, 78, 45, 64, 49, 10, 23,  8, 20,  1,  8,  4, 12.1],\n 'M' => [ 0,  3,  7,  4,  1,  6,  2,  2,  0,  0,  0,  1,  0,  1,  2,  2.7],\n 'N' => [ 0,  1,  0,  1,  1,  0,  0,  0,  3,  3,  0, 10,  0,  4,  7,  7.1],\n 'P' => [ 2,  0,  2,  0,  0,  4,  1,  8, 20, 14,  0,  1,  3,  0, 22,  7.4],\n 'Q' => [ 0,  0,  0,  1,  0,  6,  1,  0, 10,  8,  0, 18,  3, 19, 10,  6.3],\n 'R' => [ 2,  0,  0,  0,  0,  1,  0,  0,  7,  4,  0, 15,  0, 12,  9,  7.6],\n 'S' => [ 9,  3,  8,  6, 13, 10, 15, 16, 26, 11, 23, 17, 20, 15, 10, 11.4],\n 'T' => [ 2, 10,  5,  4,  5, 13,  7,  7, 12,  6, 17,  8,  6,  3, 10,  9.7],\n 'V' => [20, 25, 15, 18, 13, 15, 11, 27,  0, 12, 32,  3,  0,  8, 17, 11.1],\n 'W' => [ 4,  3,  3,  1,  1,  2,  6,  3,  1,  3,  0,  9,  0,  2,  0,  1.8],\n 'Y' => [ 0,  1,  4,  0,  0,  1,  3,  1,  1,  2,  0,  5,  0,  1,  7,  5.6]\n);\n\n  %WeightTable_pro = (\n#Sample: 36 aligned sequences\n#  R    -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n  'A' => [0,  8,  8,  9,  6,  7,  5,  6,  7,  7, 24,  2, 31, 18,  4,  3.2],\n  'C' => [1,  0,  0,  1,  1,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,  1.0],\n  'D' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  8,  2.0],\n  'E' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  4,  8,  2.2],\n  'F' => [2,  4,  3,  4,  1,  1,  8,  0,  4,  1,  0,  7,  0,  1,  0,  1.3],\n  'G' => [4,  2,  2,  2,  3,  5,  2,  4,  2,  2,  0,  2,  2,  1,  0,  2.7],\n  'H' => [0,  0,  1,  0,  0,  0,  0,  1,  1,  0,  0,  7,  0,  1,  0,  0.8],\n  'I' => [3,  1,  5,  1,  5,  0,  1,  3,  0,  0,  0,  0,  0,  0,  2,  1.7],\n  'K' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  2,  0,  3,  0,  2.5],\n  'L' => [8, 11,  9,  8,  9, 13,  1,  0,  2,  2,  1,  2,  0,  0,  1,  2.7],\n  'M' => [0,  2,  1,  1,  3,  2,  3,  0,  1,  2,  0,  4,  0,  0,  1,  0.6],\n  'N' => [0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  0,  3,  0,  1,  4,  1.6],\n  'P' => [0,  1,  1,  1,  1,  1,  2,  3,  5,  2,  0,  0,  0,  0,  5,  1.7],\n  'Q' => [0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  0,  3,  0,  0,  1,  1.4],\n  'R' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  1.7],\n  'S' => [1,  0,  1,  4,  4,  1,  5, 15,  5,  8,  5,  2,  2,  0,  0,  2.6],\n  'T' => [2,  0,  4,  2,  2,  2,  2,  2,  5,  1,  3,  0,  1,  1,  2,  2.2],\n  'V' => [5,  7,  1,  3,  1,  4,  7,  0,  0,  4,  3,  0,  0,  2,  0,  2.5],\n  'W' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0.4],\n  'Y' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  1.3]\n);\n\n\n##\n## Now we calculate the _real_ values for the weight tables\n##\n##\n## yeah yeah yeah there is lots of math here that gets repeated\n## every single time a sigcleave object gets created. This is\n## a quick hack to make sure that we get the scores as accurate as\n## possible. Need all those significant digits....\n##\n## suggestions for speedup aproaches welcome\n##\n\n\nforeach my $i (keys %WeightTable_euc) {\n\tmy $expected = $WeightTable_euc{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_euc{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_euc{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_euc{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_euc{$i}[$j] = log($WeightTable_euc{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n\nforeach my $i (keys %WeightTable_pro) {\n\tmy $expected = $WeightTable_pro{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_pro{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_pro{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_pro{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_pro{$i}[$j] = log($WeightTable_pro{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    #my $self = Bio::Seq->new(@args);\n\n    my ($seq, $threshold, $matrix) = $self->_rearrange([qw(SEQ THRESHOLD MATRIX)],@args);\n\n    defined $threshold && $self->threshold($threshold);\n    $matrix && $self->matrix($matrix);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n\n=head1 threshold\n\n Title     : threshold\n Usage     : $value = $self->threshold\n Purpose   : Read/write method sigcleave score reporting threshold.\n Returns   : float.\n Argument  : new value, float\n Throws    : on non-number argument\n Comments  : defaults to 3.5\n See Also   : n/a\n\n\n#----------------\nsub threshold {\n#----------------\n\tmy ($self, $value) = @_;\n\tif( defined $value) {\n\t\t$self->throw(\"I need a number, not [$value]\")\n\t\t  if  $value !~ /^[+-]?[\\d\\.]+$/;\n\t\t$self->{'_threshold'} = $value;\n\t}\n\treturn $self->{'_threshold'} || 3.5 ;\n}\n\n=head1 matrix\n\n Title     : matrix\n Usage     : $value = $self->matrix('procaryotic')\n Purpose   : Read/write method sigcleave matrix.\n Returns   : float.\n Argument  : new value: 'eucaryotic' or 'procaryotic'\n Throws    : on non-number argument\n Comments  : defaults to 3.5\n See Also   : n/a\n\n\n#----------------\nsub matrix {\n#----------------\n\tmy ($self, $value) = @_;\n\tif( defined $value) {\n\t\t$self->throw(\"I need 'eucaryotic' or 'procaryotic', not [$value]\")\n\t\t  unless  $value eq 'eucaryotic' or $value eq 'procaryotic';\n\t\t$self->{'_matrix'} = $value;\n\t}\n\treturn $self->{'_matrix'} || 'eucaryotic' ;\n}\n\n=head1 seq\n\n Title     : seq\n Usage     : $value = $self->seq($seq_object)\n Purpose   : set the Seq object to be used\n Returns   : Seq object\n Argument  : protein sequence or Seq object\n See Also   : n/a","label":"seq($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":381,"definition":"my","name":"$self","containerName":"seq","localvar":"my"},{"name":"$value","containerName":"seq","line":381,"kind":13},{"containerName":"seq","name":"$value","kind":13,"line":382},{"name":"$value","containerName":"seq","line":383,"kind":13},{"kind":12,"line":383,"name":"isa","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":384},{"kind":13,"line":384,"name":"$value","containerName":"seq"},{"kind":13,"line":386,"name":"$self","containerName":"seq"},{"name":"new","containerName":"seq","kind":12,"line":386},{"containerName":"seq","name":"$value","kind":13,"line":386},{"name":"$self","containerName":"seq","kind":13,"line":390}],"line":379,"name":"seq","range":{"end":{"line":391,"character":9999},"start":{"line":379,"character":0}}},{"kind":12,"line":386,"name":"Bio","containerName":"PrimarySeq"},{"name":"_Analyze","range":{"start":{"character":0,"line":414},"end":{"character":9999,"line":465}},"kind":12,"line":414,"children":[{"line":416,"kind":13,"localvar":"my","containerName":"_Analyze","definition":"my","name":"$self"},{"kind":13,"line":418,"definition":"my","name":"%signals","containerName":"_Analyze","localvar":"my"},{"name":"@hitWeight","definition":"my","containerName":"_Analyze","localvar":"my","kind":13,"line":419},{"localvar":"my","name":"@hitsort","definition":"my","containerName":"_Analyze","line":420,"kind":13},{"kind":13,"line":421,"containerName":"_Analyze","definition":"my","name":"@hitpos","localvar":"my"},{"localvar":"my","name":"$maxSite","definition":"my","containerName":"_Analyze","line":422,"kind":13},{"kind":13,"line":423,"definition":"my","name":"$seqPos","containerName":"_Analyze","localvar":"my"},{"localvar":"my","definition":"my","name":"$istart","containerName":"_Analyze","line":424,"kind":13},{"localvar":"my","containerName":"_Analyze","name":"$iend","definition":"my","line":425,"kind":13},{"kind":13,"line":426,"containerName":"_Analyze","definition":"my","name":"$icol","localvar":"my"},{"line":427,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"_Analyze"},{"localvar":"my","name":"$weight","definition":"my","containerName":"_Analyze","line":428,"kind":13},{"containerName":"_Analyze","name":"$k","definition":"my","localvar":"my","kind":13,"line":429},{"kind":13,"line":430,"definition":"my","name":"$c","containerName":"_Analyze","localvar":"my"},{"kind":13,"line":431,"name":"$seqBegin","definition":"my","containerName":"_Analyze","localvar":"my"},{"definition":"my","name":"$pVal","containerName":"_Analyze","localvar":"my","kind":13,"line":432},{"localvar":"my","name":"$nVal","definition":"my","containerName":"_Analyze","line":433,"kind":13},{"kind":13,"line":434,"containerName":"_Analyze","name":"$nHits","definition":"my","localvar":"my"},{"name":"$seqEnd","definition":"my","containerName":"_Analyze","localvar":"my","kind":13,"line":435},{"containerName":"_Analyze","name":"$self","line":435,"kind":13},{"line":435,"kind":12,"name":"seq","containerName":"_Analyze"},{"kind":12,"line":435,"name":"length","containerName":"_Analyze"},{"kind":13,"line":436,"name":"$pep","definition":"my","containerName":"_Analyze","localvar":"my"},{"containerName":"_Analyze","name":"$self","line":436,"kind":13},{"name":"seq","containerName":"_Analyze","kind":12,"line":436},{"containerName":"_Analyze","name":"seq","kind":12,"line":436},{"line":437,"kind":13,"localvar":"my","containerName":"_Analyze","name":"$minWeight","definition":"my"},{"line":437,"kind":13,"name":"$self","containerName":"_Analyze"},{"containerName":"_Analyze","name":"threshold","kind":12,"line":437},{"localvar":"my","containerName":"_Analyze","name":"$matrix","definition":"my","line":438,"kind":13},{"line":438,"kind":13,"containerName":"_Analyze","name":"$self"},{"kind":12,"line":438,"name":"matrix","containerName":"_Analyze"},{"line":444,"kind":13,"name":"$pep","containerName":"_Analyze"},{"containerName":"_Analyze","name":"$seqPos","kind":13,"line":446},{"containerName":"_Analyze","name":"$seqBegin","line":446,"kind":13},{"name":"$seqPos","containerName":"_Analyze","line":446,"kind":13},{"name":"$seqEnd","containerName":"_Analyze","kind":13,"line":446},{"name":"$seqPos","containerName":"_Analyze","kind":13,"line":446},{"name":"$istart","containerName":"_Analyze","kind":13,"line":447},{"name":"$seqPos","containerName":"_Analyze","kind":13,"line":447},{"containerName":"_Analyze","name":"$pVal","kind":13,"line":447},{"containerName":"_Analyze","name":"$seqPos","line":447,"kind":13},{"line":447,"kind":13,"containerName":"_Analyze","name":"$pVal"},{"containerName":"_Analyze","name":"$iend","kind":13,"line":448},{"containerName":"_Analyze","name":"$seqPos","line":448,"kind":13},{"line":448,"kind":13,"containerName":"_Analyze","name":"$nVal"},{"name":"$seqEnd","containerName":"_Analyze","kind":13,"line":448},{"containerName":"_Analyze","name":"$seqPos","kind":13,"line":448},{"containerName":"_Analyze","name":"$nVal","line":448,"kind":13},{"kind":13,"line":448,"containerName":"_Analyze","name":"$seqEnd"},{"kind":13,"line":449,"containerName":"_Analyze","name":"$icol"},{"name":"$iend","containerName":"_Analyze","line":449,"kind":13},{"line":449,"kind":13,"containerName":"_Analyze","name":"$istart"},{"containerName":"_Analyze","name":"$weight","line":450,"kind":13},{"name":"$k","containerName":"_Analyze","kind":13,"line":451},{"containerName":"_Analyze","name":"$k","kind":13,"line":451},{"kind":13,"line":451,"containerName":"_Analyze","name":"$icol"},{"name":"$k","containerName":"_Analyze","line":451,"kind":13},{"name":"$c","containerName":"_Analyze","kind":13,"line":452},{"containerName":"_Analyze","name":"$pep","line":452,"kind":13},{"name":"$istart","containerName":"_Analyze","kind":13,"line":452},{"name":"$k","containerName":"_Analyze","kind":13,"line":452},{"line":456,"kind":13,"name":"$matrix","containerName":"_Analyze"},{"kind":13,"line":457,"name":"$weight","containerName":"_Analyze"},{"kind":13,"line":457,"containerName":"_Analyze","name":"$WeightTable_euc"},{"containerName":"_Analyze","name":"$c","line":457,"kind":13},{"line":457,"kind":13,"name":"$k","containerName":"_Analyze"},{"line":457,"kind":13,"name":"$WeightTable_euc","containerName":"_Analyze"},{"name":"$c","containerName":"_Analyze","line":457,"kind":13},{"name":"$k","containerName":"_Analyze","line":457,"kind":13},{"name":"$weight","containerName":"_Analyze","kind":13,"line":459},{"name":"$WeightTable_pro","containerName":"_Analyze","kind":13,"line":459},{"kind":13,"line":459,"containerName":"_Analyze","name":"$c"},{"name":"$k","containerName":"_Analyze","line":459,"kind":13},{"containerName":"_Analyze","name":"$WeightTable_pro","kind":13,"line":459},{"line":459,"kind":13,"containerName":"_Analyze","name":"$c"},{"kind":13,"line":459,"name":"$k","containerName":"_Analyze"},{"kind":13,"line":462,"name":"$signals","containerName":"_Analyze"},{"containerName":"_Analyze","name":"$seqPos","line":462,"kind":13},{"kind":13,"line":462,"name":"$weight","containerName":"_Analyze"},{"name":"$weight","containerName":"_Analyze","kind":13,"line":462},{"line":462,"kind":13,"containerName":"_Analyze","name":"$minWeight"},{"kind":13,"line":464,"name":"$self","containerName":"_Analyze"},{"containerName":"_Analyze","name":"%signals","kind":13,"line":464}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"#########################################################################\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::Tools::Sigcleave\n# AUTHOR  : Chris Dagdigian, dag@sonsorol.org\n# CREATED : Jan 28 1999\n# REVISION: $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Chris Dagdigian and others. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or \n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Object framework ripped from Steve Chervits's SeqPattern.pm\n# \n# Core EGCG Sigcleave emulation from perl code developed by\n# Danh Nguyen & Kamalakar Gulukota which itself was based \n# loosely on Colgrove's signal.c program.\n#\n# The overall idea is to replicate the output of the sigcleave\n# program which was distributed with the EGCG extension to the GCG sequence\n# analysis package. There is also an accessor method for just getting at\n# the raw results.\n#\n#-----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::Sigcleave - Bioperl object for sigcleave analysis\n\n=head1 SYNOPSIS\n\n=head2 Object Creation\n\n  use Bio::Tools::Sigcleave ();\n\n  # to keep the module backwar compatible, you can pass it a sequence string, but\n  # there recommended say is to pass it a Seq object\n\n  # this works\n  $seq = \"MVLLLILSVLLLKEDVRGSAQSSERRVVAHMPGDIIIGALFSVHHQPTVDKVHERKCGAVREQYGI\";\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seq,\n                                                -type => 'protein',\n                                                -threshold=>'3.5',\n                                                );\n  # but you do:\n  $seqobj = Bio::PrimarySeq->new(-seq => $seq);\n\n  $sig = Bio::Tools::Sigcleave->new(-seq  => $seqobj,\n                                                -threshold=>'3.5',\n                                                );\n\n  # now you can detect procaryotic signal sequences as well as eucaryotic\n  $sig->matrix('eucaryotic'); # or 'procaryotic'\n\n\n=head2 Object Methods & Accessors\n\n  # you can use this method to fine tune the threshod before printing out the results\n  $sig->result_count:\n\n  %raw_results      = $sig->signals;\n  $formatted_output = $sig->pretty_print;\n\n=head1 DESCRIPTION\n\n\"Sigcleave\" was a program distributed as part of the free EGCG add-on\nto earlier versions of the GCG Sequence Analysis package. A new\nimplementation of the algorithm is now part of EMBOSS package.\n\nFrom the EGCG documentation:\n\n  SigCleave uses the von Heijne method to locate signal sequences, and\n  to identify the cleavage site. The method is 95% accurate in\n  resolving signal sequences from non-signal sequences with a cutoff\n  score of 3.5, and 75-80% accurate in identifying the cleavage\n  site. The program reports all hits above a minimum value.\n\nThe EGCG Sigcleave program was written by Peter Rice (E-mail:\npmr@sanger.ac.uk Post: Informatics Division, The Sanger Centre,\nWellcome Trust Genome Campus, Hinxton, Cambs, CB10 1SA, UK).\n\nSince EGCG is no longer distributed for the latest versions of GCG,\nthis code was developed to emulate the output of the original program\nas much as possible for those who lost access to sigcleave when\nupgrading to newer versions of GCG.\n\nThere are 2 accessor methods for this object. \"signals\" will return a\nperl associative array containing the sigcleave scores keyed by amino\nacid position.  \"pretty_print\" returns a formatted string similar to\nthe output of the original sigcleave utility.\n\nIn both cases, the \"threshold\" setting controls the score reporting\nlevel. If no value for threshold is passed in by the user, the code\ndefaults to a reporting value of 3.5.\n\nIn this implemntation the accessor will never return any\nscore/position pair which does not meet the threshold limit. This is\nthe slightly different from the behaviour of the 8.1 EGCG sigcleave\nprogram which will report the highest of the under-threshold results\nif nothing else is found.\n\n\nExample of pretty_print output:\n\n\tSIGCLEAVE of sigtest from: 1 to 146\n\n\tReport scores over 3.5\n\tMaximum score 4.9 at residue 131\n\n\t Sequence:  FVILAAMSIQGSA-NLQTQWKSTASLALET\n        \t    | (signal)    | (mature peptide)\n          \t118            131\n\n\t Other entries above 3.5\n\n\tMaximum score 3.7 at residue 112\n\n\t Sequence:  CSRQLFGWLFCKV-HPGAIVFVILAAMSIQGSANLQTQWKSTASLALET\n         \t   | (signal)    | (mature peptide)\n           \t99            112\n\n\n=head1 FEEDBACK\n\nWhen updating and maintaining a module, it helps to know that people\nare actually using it. Let us know if you find a bug, think this code\nis useful or have any improvements/features to suggest.\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChris Dagdigian, dag-at-sonsorol.org  & others\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 VERSION\n\nBio::Tools::Sigcleave, $Id: Sigcleave.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999 Chris Dagdigian & others. All Rights Reserved.\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 REFERENCES / SEE ALSO\n\nvon Heijne G. (1986) \"A new method for predicting signal sequences\ncleavage sites.\"  Nucleic Acids Res. 14, 4683-4690.\n\nvon Heijne G. (1987) in \"Sequence Analysis in Molecular Biology:\nTreasure Trove or Trivial Pursuit\" (Acad. Press, (1987), 113-117).\n\n\n=head1 APPENDIX\n\nThe following documentation describes the various functions\ncontained in this module. Some functions are for internal \nuse and are not meant to be called by the user; they are \npreceded by an underscore (\"_\").\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#\n\npackage Bio::Tools::Sigcleave;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID %WeightTable_euc  %WeightTable_pro );\n$ID  = 'Bio::Tools::Sigcleave';\n\n  %WeightTable_euc = (\n#Sample: 161 aligned sequences\n# R     -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n 'A' => [16, 13, 14, 15, 20, 18, 18, 17, 25, 15, 47,  6, 80, 18,  6, 14.5],\n 'C' => [ 3,  6,  9,  7,  9, 14,  6,  8,  5,  6, 19,  3,  9,  8,  3,  4.5],\n 'D' => [ 0,  0,  0,  0,  0,  0,  0,  0,  5,  3,  0,  5,  0, 10, 11,  8.9],\n 'E' => [ 0,  0,  0,  1,  0,  0,  0,  0,  3,  7,  0,  7,  0, 13, 14, 10.0],\n 'F' => [13,  9, 11, 11,  6,  7, 18, 13,  4,  5,  0, 13,  0,  6,  4,  5.6],\n 'G' => [ 4,  4,  3,  6,  3, 13,  3,  2, 19, 34,  5,  7, 39, 10,  7, 12.1],\n 'H' => [ 0,  0,  0,  0,  0,  1,  1,  0,  5,  0,  0,  6,  0,  4,  2,  3.4],\n 'I' => [15, 15,  8,  6, 11,  5,  4,  8,  5,  1, 10,  5,  0,  8,  7,  7.4],\n 'K' => [ 0,  0,  0,  1,  0,  0,  1,  0,  0,  4,  0,  2,  0, 11,  9, 11.3],\n 'L' => [71, 68, 72, 79, 78, 45, 64, 49, 10, 23,  8, 20,  1,  8,  4, 12.1],\n 'M' => [ 0,  3,  7,  4,  1,  6,  2,  2,  0,  0,  0,  1,  0,  1,  2,  2.7],\n 'N' => [ 0,  1,  0,  1,  1,  0,  0,  0,  3,  3,  0, 10,  0,  4,  7,  7.1],\n 'P' => [ 2,  0,  2,  0,  0,  4,  1,  8, 20, 14,  0,  1,  3,  0, 22,  7.4],\n 'Q' => [ 0,  0,  0,  1,  0,  6,  1,  0, 10,  8,  0, 18,  3, 19, 10,  6.3],\n 'R' => [ 2,  0,  0,  0,  0,  1,  0,  0,  7,  4,  0, 15,  0, 12,  9,  7.6],\n 'S' => [ 9,  3,  8,  6, 13, 10, 15, 16, 26, 11, 23, 17, 20, 15, 10, 11.4],\n 'T' => [ 2, 10,  5,  4,  5, 13,  7,  7, 12,  6, 17,  8,  6,  3, 10,  9.7],\n 'V' => [20, 25, 15, 18, 13, 15, 11, 27,  0, 12, 32,  3,  0,  8, 17, 11.1],\n 'W' => [ 4,  3,  3,  1,  1,  2,  6,  3,  1,  3,  0,  9,  0,  2,  0,  1.8],\n 'Y' => [ 0,  1,  4,  0,  0,  1,  3,  1,  1,  2,  0,  5,  0,  1,  7,  5.6]\n);\n\n  %WeightTable_pro = (\n#Sample: 36 aligned sequences\n#  R    -13 -12 -11 -10  -9  -8  -7  -6  -5  -4  -3  -2  -1  +1  +2 Expect\n  'A' => [0,  8,  8,  9,  6,  7,  5,  6,  7,  7, 24,  2, 31, 18,  4,  3.2],\n  'C' => [1,  0,  0,  1,  1,  0,  0,  1,  1,  0,  0,  0,  0,  0,  0,  1.0],\n  'D' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  8,  2.0],\n  'E' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  4,  8,  2.2],\n  'F' => [2,  4,  3,  4,  1,  1,  8,  0,  4,  1,  0,  7,  0,  1,  0,  1.3],\n  'G' => [4,  2,  2,  2,  3,  5,  2,  4,  2,  2,  0,  2,  2,  1,  0,  2.7],\n  'H' => [0,  0,  1,  0,  0,  0,  0,  1,  1,  0,  0,  7,  0,  1,  0,  0.8],\n  'I' => [3,  1,  5,  1,  5,  0,  1,  3,  0,  0,  0,  0,  0,  0,  2,  1.7],\n  'K' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  2,  0,  3,  0,  2.5],\n  'L' => [8, 11,  9,  8,  9, 13,  1,  0,  2,  2,  1,  2,  0,  0,  1,  2.7],\n  'M' => [0,  2,  1,  1,  3,  2,  3,  0,  1,  2,  0,  4,  0,  0,  1,  0.6],\n  'N' => [0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  0,  3,  0,  1,  4,  1.6],\n  'P' => [0,  1,  1,  1,  1,  1,  2,  3,  5,  2,  0,  0,  0,  0,  5,  1.7],\n  'Q' => [0,  0,  0,  0,  0,  0,  0,  0,  2,  2,  0,  3,  0,  0,  1,  1.4],\n  'R' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  1.7],\n  'S' => [1,  0,  1,  4,  4,  1,  5, 15,  5,  8,  5,  2,  2,  0,  0,  2.6],\n  'T' => [2,  0,  4,  2,  2,  2,  2,  2,  5,  1,  3,  0,  1,  1,  2,  2.2],\n  'V' => [5,  7,  1,  3,  1,  4,  7,  0,  0,  4,  3,  0,  0,  2,  0,  2.5],\n  'W' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0.4],\n  'Y' => [0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  1.3]\n);\n\n\n##\n## Now we calculate the _real_ values for the weight tables\n##\n##\n## yeah yeah yeah there is lots of math here that gets repeated\n## every single time a sigcleave object gets created. This is\n## a quick hack to make sure that we get the scores as accurate as\n## possible. Need all those significant digits....\n##\n## suggestions for speedup aproaches welcome\n##\n\n\nforeach my $i (keys %WeightTable_euc) {\n\tmy $expected = $WeightTable_euc{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_euc{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_euc{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_euc{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_euc{$i}[$j] = log($WeightTable_euc{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n\nforeach my $i (keys %WeightTable_pro) {\n\tmy $expected = $WeightTable_pro{$i}[15];\n\tif ($expected > 0) {\n\t\tfor (my $j=0; $j<16; $j++) {\n\t\t\tif ($WeightTable_pro{$i}[$j] == 0) {\n\t\t\t\t$WeightTable_pro{$i}[$j] = 1; \n\t\t\t\tif ($j == 10 || $j == 12) {\n\t\t\t\t\t$WeightTable_pro{$i}[$j] = 1.e-10;\n\t\t\t\t}\n\t\t\t}\n\t\t\t$WeightTable_pro{$i}[$j] = log($WeightTable_pro{$i}[$j]/$expected);\n\t\t}\n\t}\n}\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    #my $self = Bio::Seq->new(@args);\n\n    my ($seq, $threshold, $matrix) = $self->_rearrange([qw(SEQ THRESHOLD MATRIX)],@args);\n\n    defined $threshold && $self->threshold($threshold);\n    $matrix && $self->matrix($matrix);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n\n=head1 threshold\n\n Title     : threshold\n Usage     : $value = $self->threshold\n Purpose   : Read/write method sigcleave score reporting threshold.\n Returns   : float.\n Argument  : new value, float\n Throws    : on non-number argument\n Comments  : defaults to 3.5\n See Also   : n/a\n\n\n#----------------\nsub threshold {\n#----------------\n\tmy ($self, $value) = @_;\n\tif( defined $value) {\n\t\t$self->throw(\"I need a number, not [$value]\")\n\t\t  if  $value !~ /^[+-]?[\\d\\.]+$/;\n\t\t$self->{'_threshold'} = $value;\n\t}\n\treturn $self->{'_threshold'} || 3.5 ;\n}\n\n=head1 matrix\n\n Title     : matrix\n Usage     : $value = $self->matrix('procaryotic')\n Purpose   : Read/write method sigcleave matrix.\n Returns   : float.\n Argument  : new value: 'eucaryotic' or 'procaryotic'\n Throws    : on non-number argument\n Comments  : defaults to 3.5\n See Also   : n/a\n\n\n#----------------\nsub matrix {\n#----------------\n\tmy ($self, $value) = @_;\n\tif( defined $value) {\n\t\t$self->throw(\"I need 'eucaryotic' or 'procaryotic', not [$value]\")\n\t\t  unless  $value eq 'eucaryotic' or $value eq 'procaryotic';\n\t\t$self->{'_matrix'} = $value;\n\t}\n\treturn $self->{'_matrix'} || 'eucaryotic' ;\n}\n\n=head1 seq\n\n Title     : seq\n Usage     : $value = $self->seq($seq_object)\n Purpose   : set the Seq object to be used\n Returns   : Seq object\n Argument  : protein sequence or Seq object\n See Also   : n/a\n\n\n#----------------\nsub seq {\n#----------------\n\tmy ($self, $value) = @_;\n\tif( defined $value) {\n\t\tif ($value->isa('Bio::PrimarySeqI')) {\n\t\t\t$self->{'_seq'} = $value;\n\t\t} else {\n\t\t\t$self->{'_seq'} = Bio::PrimarySeq->new(-seq => $value, \n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-alphabet => 'protein');\n\t\t}\n\t}\n\treturn $self->{'_seq'};\n}\n\n=head1 _Analyze\n\n Title     : _Analyze\n Usage     : N/A This is an internal method. Not meant to be called from outside\n           : the package\n           :\n Purpose   : calculates sigcleave score and amino acid position for the\n           : given protein sequence. The score reporting threshold can\n           : be adjusted by passing in the \"threshold\" parameter during\n           : object construction. If no threshold is passed in, the code\n           : defaults to reporting any scores equal to or above 3.5\n           :\n Returns   : nothing. results are added to the object\n Argument  : none.\n Throws    : nothing.\n Comments  : nothing.\nSee Also   : n/a","parameters":[{"label":"$self"}],"label":"_Analyze($self)"}},{"range":{"start":{"line":487,"character":0},"end":{"line":496,"character":9999}},"definition":"sub","name":"signals","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"signals","line":489,"kind":13},{"name":"%results","definition":"my","containerName":"signals","localvar":"my","kind":13,"line":490},{"localvar":"my","containerName":"signals","name":"$position","definition":"my","line":491,"kind":13},{"containerName":"signals","name":"$self","line":494,"kind":13},{"kind":12,"line":494,"name":"_Analyze","containerName":"signals"},{"containerName":"signals","name":"$position","kind":13,"line":496},{"name":"$self","containerName":"signals","line":496,"kind":13}],"line":487,"kind":12},{"kind":13,"line":497,"containerName":null,"name":"%results"},{"containerName":null,"name":"$position","line":497,"kind":13},{"name":"%self","containerName":null,"line":497,"kind":13},{"kind":13,"line":497,"containerName":null,"name":"$position"},{"line":499,"kind":13,"containerName":null,"name":"%results"},{"kind":12,"line":521,"children":[{"kind":13,"line":523,"name":"$self","definition":"my","containerName":"result_count","localvar":"my"},{"containerName":"result_count","name":"$self","kind":13,"line":524},{"line":524,"kind":12,"containerName":"result_count","name":"_Analyze"},{"kind":13,"line":525,"containerName":"result_count","name":"$self"}],"containerName":"main::","definition":"sub","name":"result_count","range":{"start":{"line":521,"character":0},"end":{"line":525,"character":9999}}},{"name":"pretty_print","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":547},"end":{"character":9999,"line":590}},"kind":12,"children":[{"kind":13,"line":549,"name":"$self","definition":"my","containerName":"pretty_print","localvar":"my"},{"kind":13,"line":550,"definition":"my","name":"$pos","containerName":"pretty_print","localvar":"my"},{"containerName":"pretty_print","definition":"my","name":"$output","localvar":"my","kind":13,"line":551},{"kind":13,"line":552,"definition":"my","name":"$cnt","containerName":"pretty_print","localvar":"my"},{"kind":13,"line":553,"name":"%results","definition":"my","containerName":"pretty_print","localvar":"my"},{"containerName":"pretty_print","name":"$self","line":553,"kind":13},{"kind":12,"line":553,"name":"signals","containerName":"pretty_print"},{"line":554,"kind":13,"localvar":"my","containerName":"pretty_print","definition":"my","name":"@hits"},{"name":"%results","containerName":"pretty_print","line":554,"kind":13},{"localvar":"my","definition":"my","name":"$hitcount","containerName":"pretty_print","line":555,"kind":13},{"name":"$hitcount","containerName":"pretty_print","kind":13,"line":555},{"localvar":"my","definition":"my","name":"$thresh","containerName":"pretty_print","line":556,"kind":13},{"containerName":"pretty_print","name":"$self","line":556,"kind":13},{"line":556,"kind":12,"name":"threshold","containerName":"pretty_print"},{"containerName":"pretty_print","definition":"my","name":"$seqlen","localvar":"my","kind":13,"line":557},{"name":"$self","containerName":"pretty_print","kind":13,"line":557},{"name":"seq","containerName":"pretty_print","kind":12,"line":557},{"kind":12,"line":557,"containerName":"pretty_print","name":"length"},{"containerName":"pretty_print","name":"$name","definition":"my","localvar":"my","kind":13,"line":558},{"name":"$self","containerName":"pretty_print","kind":13,"line":558},{"name":"seq","containerName":"pretty_print","line":558,"kind":12},{"name":"id","containerName":"pretty_print","kind":12,"line":558},{"containerName":"pretty_print","definition":"my","name":"$pep","localvar":"my","kind":13,"line":559},{"line":559,"kind":13,"name":"$self","containerName":"pretty_print"},{"kind":12,"line":559,"containerName":"pretty_print","name":"seq"},{"kind":12,"line":559,"containerName":"pretty_print","name":"seq"},{"kind":13,"line":560,"name":"$pep","containerName":"pretty_print"},{"line":562,"kind":13,"containerName":"pretty_print","name":"$output"},{"kind":13,"line":564,"containerName":"pretty_print","name":"$hitcount"},{"name":"$output","containerName":"pretty_print","line":565,"kind":13},{"line":566,"kind":13,"containerName":"pretty_print","name":"$pos"},{"kind":13,"line":566,"containerName":"pretty_print","name":"$results"},{"line":566,"kind":13,"containerName":"pretty_print","name":"$b"},{"line":566,"kind":13,"containerName":"pretty_print","name":"$results"},{"containerName":"pretty_print","name":"$a","line":566,"kind":13},{"kind":13,"line":566,"containerName":"pretty_print","name":"%results"},{"containerName":"pretty_print","definition":"my","name":"$start","localvar":"my","kind":13,"line":567},{"kind":13,"line":567,"name":"$pos","containerName":"pretty_print"},{"kind":13,"line":568,"name":"$start","containerName":"pretty_print"},{"name":"$start","containerName":"pretty_print","kind":13,"line":568},{"localvar":"my","name":"$sig","definition":"my","containerName":"pretty_print","line":569,"kind":13},{"name":"$pep","containerName":"pretty_print","kind":13,"line":569},{"containerName":"pretty_print","name":"$start","kind":13,"line":569},{"name":"$pos","containerName":"pretty_print","kind":13,"line":569},{"kind":13,"line":569,"containerName":"pretty_print","name":"$start"},{"containerName":"pretty_print","name":"$output","kind":13,"line":571},{"kind":13,"line":571,"name":"$results","containerName":"pretty_print"},{"line":571,"kind":13,"name":"$pos","containerName":"pretty_print"},{"containerName":"pretty_print","name":"$pos","line":571,"kind":13},{"containerName":"pretty_print","name":"$output","kind":13,"line":572},{"containerName":"pretty_print","name":"$output","line":573,"kind":13},{"containerName":"pretty_print","name":"$output","line":574,"kind":13},{"kind":13,"line":574,"containerName":"pretty_print","name":"$sig"},{"name":"$output","containerName":"pretty_print","line":575,"kind":13},{"containerName":"pretty_print","name":"$sig","line":575,"kind":13},{"name":"$output","containerName":"pretty_print","kind":13,"line":576},{"name":"$output","containerName":"pretty_print","line":577,"kind":13},{"line":577,"kind":13,"containerName":"pretty_print","name":"$pep"},{"name":"$pos","containerName":"pretty_print","line":577,"kind":13},{"kind":13,"line":578,"containerName":"pretty_print","name":"$output"},{"name":"$output","containerName":"pretty_print","line":579,"kind":13},{"containerName":"pretty_print","name":"$output","kind":13,"line":580},{"name":"$output","containerName":"pretty_print","kind":13,"line":581},{"name":"$start","containerName":"pretty_print","line":581,"kind":13},{"containerName":"pretty_print","name":"$pos","line":581,"kind":13},{"line":583,"kind":13,"name":"$hitcount","containerName":"pretty_print"},{"kind":13,"line":583,"containerName":"pretty_print","name":"$cnt"},{"containerName":"pretty_print","name":"$output","line":584,"kind":13},{"containerName":"pretty_print","name":"$cnt","line":586,"kind":13},{"name":"$output","containerName":"pretty_print","kind":13,"line":589}],"line":547},{"name":"hits","kind":12,"line":555}],"version":5}