{"vars":[{"kind":2,"line":108,"containerName":"","name":"base"},{"line":110,"kind":13,"containerName":"main::","name":"%PATTERNS","definition":"our"},{"kind":12,"line":113,"name":"Pol3"},{"kind":13,"line":116,"containerName":"main::","name":"$DEFAULT_CUTOFF","definition":"our"},{"range":{"end":{"line":134,"character":9999},"start":{"character":0,"line":127}},"name":"new","line":127,"children":[{"kind":13,"line":128,"containerName":"new","name":"$proto","definition":"my","localvar":"my"},{"kind":13,"line":128,"containerName":"new","name":"%args"},{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":129,"kind":13},{"line":129,"kind":13,"containerName":"new","name":"$proto"},{"line":129,"kind":13,"name":"$proto","containerName":"new"},{"kind":13,"line":131,"name":"$args","containerName":"new"},{"kind":13,"line":133,"containerName":"new","name":"$class"},{"containerName":"new","name":"%args","kind":13,"line":133}],"kind":12,"detail":"($proto,%args)","signature":{"label":"new($proto,%args)","parameters":[{"label":"$proto"},{"label":"%args"}],"documentation":"1;\n#\n#\n# BioPerl module for Bio::Tools::SiRNA::Ruleset::tuschl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SiRNA::Ruleset::tuschl - Perl object implementing the\ntuschl group's rules for designing small inhibitory RNAs\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Instead, use Bio::Tools::SiRNA and\nspecify the tuschl ruleset:\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'tuschl'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis package implements the rules for designing siRNA reagents\ndeveloped by Tuschl and colleagues (see\nhttp://www.rockefeller.edu/labheads/tuschl/sirna.html). It looks for\noligos that match the following patterns in the target sequence:\n\n  1. AA(N19)TT (rank 1)\n  2. AA(N21) (rank 2)\n  3. NA(N21) (rank 3)\n\nThe package also supports selection of siRNA seqences that can be\ntranscribed by pol3:\n\n    A[A,G]N17[C,T]\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::SiRNA::Ruleset::tuschl;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::SiRNA);\n\nour %PATTERNS = ( 1 \t=> '(AA.{19}TT)',\n\t\t  2 \t=> '(AA.{19}[ACG][ACG])',\n\t\t  3 \t=> '([CGT]A.{21})',\n\t\t  Pol3\t=> '(.A[AG].{17}[CT]..)'\n\t\t  );\n\nour $DEFAULT_CUTOFF = 2;\n\n=head2 new\n\n  Title\t: new\n  Usage\t: Do not call directly - use Bio::Tools::SiRNA->new instead.\n  Returns : Bio::Tools::SiRNA::Ruleset::saigo object\n  Args\t: none"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":133},{"line":136,"children":[{"definition":"my","name":"$self","containerName":"_regex","localvar":"my","kind":13,"line":137},{"line":137,"kind":13,"containerName":"_regex","name":"$rank"},{"kind":13,"line":138,"name":"$PATTERNS","containerName":"_regex"},{"containerName":"_regex","name":"$rank","line":138,"kind":13}],"kind":12,"detail":"($self,$rank)","signature":{"label":"_regex($self,$rank)","parameters":[{"label":"$self"},{"label":"$rank"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":139},"start":{"character":0,"line":136}},"name":"_regex"},{"name":"cutoff","range":{"end":{"line":150,"character":9999},"start":{"line":141,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"cutoff($self,$cutoff)","documentation":"","parameters":[{"label":"$self"},{"label":"$cutoff"}]},"detail":"($self,$cutoff)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"cutoff","localvar":"my","kind":13,"line":142},{"line":142,"kind":13,"name":"$cutoff","containerName":"cutoff"},{"name":"$cutoff","containerName":"cutoff","kind":13,"line":143},{"kind":13,"line":144,"containerName":"cutoff","name":"$self"},{"name":"$cutoff","containerName":"cutoff","kind":13,"line":144},{"containerName":"cutoff","name":"$self","kind":13,"line":146},{"name":"$self","containerName":"cutoff","kind":13,"line":147},{"name":"$DEFAULT_CUTOFF","containerName":"cutoff","kind":13,"line":147},{"containerName":"cutoff","name":"$self","line":149,"kind":13}],"line":141},{"range":{"start":{"line":153,"character":0},"end":{"line":196,"character":9999}},"name":"_get_oligos","children":[{"line":155,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_get_oligos"},{"name":"@ranks","definition":"my","containerName":"_get_oligos","localvar":"my","kind":13,"line":157},{"containerName":"_get_oligos","name":"$self","line":158,"kind":13},{"name":"cutoff","containerName":"_get_oligos","kind":12,"line":158},{"line":159,"kind":13,"name":"@ranks","containerName":"_get_oligos"},{"kind":13,"line":162,"containerName":"_get_oligos","name":"@ranks"},{"line":162,"kind":13,"name":"$self","containerName":"_get_oligos"},{"line":162,"kind":12,"containerName":"_get_oligos","name":"cutoff"},{"localvar":"my","name":"$rank","definition":"my","containerName":"_get_oligos","line":165,"kind":13},{"kind":13,"line":165,"containerName":"_get_oligos","name":"@ranks"},{"line":166,"kind":13,"localvar":"my","name":"$regex","definition":"my","containerName":"_get_oligos"},{"kind":13,"line":166,"name":"$self","containerName":"_get_oligos"},{"kind":12,"line":166,"containerName":"_get_oligos","name":"_regex"},{"name":"$rank","containerName":"_get_oligos","kind":13,"line":166},{"kind":13,"line":174,"name":"$seq","definition":"my","containerName":"_get_oligos","localvar":"my"},{"containerName":"_get_oligos","name":"$targstart","kind":13,"line":174},{"containerName":"_get_oligos","name":"$self","line":174,"kind":13},{"name":"_get_targetregion","containerName":"_get_oligos","kind":12,"line":174},{"kind":13,"line":176,"name":"$seq","containerName":"_get_oligos"},{"line":177,"kind":13,"localvar":"my","name":"$target","definition":"my","containerName":"_get_oligos"},{"name":"$target","containerName":"_get_oligos","line":180,"kind":13},{"name":"$target","containerName":"_get_oligos","kind":13,"line":181},{"name":"$target","containerName":"_get_oligos","kind":13,"line":183},{"containerName":"_get_oligos","definition":"my","name":"$start","localvar":"my","kind":13,"line":185},{"containerName":"_get_oligos","name":"$targstart","line":185,"kind":13},{"kind":13,"line":186,"name":"$stop","definition":"my","containerName":"_get_oligos","localvar":"my"},{"line":186,"kind":13,"containerName":"_get_oligos","name":"$start"},{"line":186,"kind":13,"name":"$target","containerName":"_get_oligos"},{"line":188,"kind":13,"localvar":"my","definition":"my","name":"@gc","containerName":"_get_oligos"},{"line":188,"kind":13,"containerName":"_get_oligos","name":"$target"},{"kind":13,"line":189,"containerName":"_get_oligos","name":"$fxGC","definition":"my","localvar":"my"},{"line":189,"kind":13,"containerName":"_get_oligos","name":"@gc"},{"name":"$target","containerName":"_get_oligos","kind":13,"line":189},{"name":"$fxGC","containerName":"_get_oligos","line":190,"kind":13},{"line":190,"kind":13,"containerName":"_get_oligos","name":"$self"},{"name":"min_gc","containerName":"_get_oligos","line":190,"kind":12},{"name":"$fxGC","containerName":"_get_oligos","line":191,"kind":13},{"name":"$self","containerName":"_get_oligos","line":191,"kind":13},{"name":"max_gc","containerName":"_get_oligos","line":191,"kind":12},{"name":"$self","containerName":"_get_oligos","kind":13,"line":193},{"containerName":"_get_oligos","name":"add_oligos","line":193,"kind":12},{"containerName":"_get_oligos","name":"$target","kind":13,"line":193},{"kind":13,"line":193,"name":"$start","containerName":"_get_oligos"},{"containerName":"_get_oligos","name":"$rank","line":193,"kind":13}],"line":153,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_get_oligos($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"children":[{"line":200,"kind":13,"localvar":"my","containerName":"_get_sense","name":"$self","definition":"my"},{"name":"$target","containerName":"_get_sense","line":200,"kind":13},{"kind":13,"line":202,"containerName":"_get_sense","name":"$target"},{"line":204,"kind":13,"name":"$target","containerName":"_get_sense"},{"name":"$target","containerName":"_get_sense","kind":13,"line":206},{"name":"$target","containerName":"_get_sense","kind":13,"line":208}],"line":199,"kind":12,"signature":{"label":"_get_sense($self,$target)","parameters":[{"label":"$self"},{"label":"$target"}],"documentation":""},"detail":"($self,$target)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":209},"start":{"character":0,"line":199}},"name":"_get_sense"},{"name":"_get_anti","range":{"end":{"line":228,"character":9999},"start":{"character":0,"line":211}},"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$target"}],"label":"_get_anti($self,$target)"},"detail":"($self,$target)","kind":12,"children":[{"localvar":"my","containerName":"_get_anti","name":"$self","definition":"my","line":212,"kind":13},{"kind":13,"line":212,"name":"$target","containerName":"_get_anti"},{"containerName":"_get_anti","definition":"my","name":"@target","localvar":"my","kind":13,"line":213},{"containerName":"_get_anti","name":"$target","line":213,"kind":13},{"localvar":"my","name":"$nt","definition":"my","containerName":"_get_anti","line":214,"kind":13},{"containerName":"_get_anti","name":"@antitarget","line":214,"kind":13},{"containerName":"_get_anti","name":"$nt","line":216,"kind":13},{"line":216,"kind":13,"containerName":"_get_anti","name":"@target"},{"containerName":"_get_anti","name":"@antitarget","kind":13,"line":217},{"line":217,"kind":13,"containerName":"_get_anti","name":"$self"},{"name":"_comp","containerName":"_get_anti","kind":12,"line":217},{"line":217,"kind":13,"containerName":"_get_anti","name":"$nt"},{"containerName":"_get_anti","name":"$anti","definition":"my","localvar":"my","kind":13,"line":219},{"line":219,"kind":13,"containerName":"_get_anti","name":"@antitarget"},{"kind":13,"line":221,"containerName":"_get_anti","name":"$anti"},{"name":"$anti","containerName":"_get_anti","kind":13,"line":223},{"kind":13,"line":225,"name":"$anti","containerName":"_get_anti"},{"name":"$anti","containerName":"_get_anti","kind":13,"line":227}],"line":211}],"version":5}