{"vars":[{"containerName":"","name":"vars","kind":2,"line":134},{"name":"base","containerName":"","kind":2,"line":142},{"definition":"our","name":"%COMP","containerName":"main::","kind":13,"line":145},{"containerName":"main::","definition":"our","name":"@ARGNAMES","kind":13,"line":152},{"name":"new","range":{"end":{"character":9999,"line":212},"start":{"character":0,"line":181}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$proto"},{"label":"@args"}],"documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().","label":"new($proto,@args)"},"detail":"($proto,@args)","kind":12,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$proto","line":182,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":182},{"name":"$pkg","definition":"my","containerName":"new","localvar":"my","kind":13,"line":183},{"name":"$proto","containerName":"new","line":183,"kind":13},{"line":183,"kind":13,"containerName":"new","name":"$proto"},{"kind":13,"line":185,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":186,"containerName":"new","name":"$self"},{"line":186,"kind":13,"name":"$pkg","containerName":"new"},{"kind":13,"line":188,"name":"%args","definition":"my","containerName":"new","localvar":"my"},{"line":190,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"@ARGNAMES","kind":13,"line":190},{"name":"$self","containerName":"new","kind":13,"line":190},{"line":190,"kind":12,"containerName":"new","name":"_rearrange"},{"line":190,"kind":13,"name":"@ARGNAMES","containerName":"new"},{"containerName":"new","name":"@args","line":190,"kind":13},{"line":192,"kind":13,"name":"$args","containerName":"new"},{"kind":13,"line":193,"containerName":"new","name":"$self"},{"line":193,"kind":12,"name":"rules","containerName":"new"},{"containerName":"new","name":"$args","kind":13,"line":193},{"name":"$self","containerName":"new","kind":13,"line":196},{"kind":13,"line":196,"name":"$args","containerName":"new"},{"kind":13,"line":197,"containerName":"new","name":"$self"},{"kind":13,"line":197,"name":"$args","containerName":"new"},{"kind":13,"line":198,"containerName":"new","name":"$self"},{"containerName":"new","name":"$args","kind":13,"line":198},{"name":"$self","containerName":"new","line":199,"kind":13},{"kind":13,"line":199,"containerName":"new","name":"$args"},{"containerName":"new","name":"$self","line":200,"kind":13},{"name":"$args","containerName":"new","line":200,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":201},{"line":201,"kind":13,"containerName":"new","name":"$args"},{"kind":13,"line":202,"name":"$self","containerName":"new"},{"kind":13,"line":203,"containerName":"new","name":"$args"},{"kind":13,"line":203,"name":"$self","containerName":"new"},{"name":"$args","containerName":"new","line":203,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":204},{"name":"$self","containerName":"new","line":205,"kind":13},{"containerName":"new","name":"$args","line":205,"kind":13},{"kind":13,"line":206,"name":"$self","containerName":"new"},{"line":206,"kind":13,"containerName":"new","name":"$args"},{"line":206,"kind":13,"name":"$ENV","containerName":"new"},{"kind":13,"line":206,"containerName":"new","name":"$ENV"},{"name":"$self","containerName":"new","line":207,"kind":13},{"kind":13,"line":207,"name":"$args","containerName":"new"},{"line":209,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":209,"name":"target","containerName":"new"},{"name":"$args","containerName":"new","line":209,"kind":13},{"line":209,"kind":13,"containerName":"new","name":"$args"},{"kind":13,"line":211,"name":"$self","containerName":"new"}],"line":181},{"name":"target","range":{"start":{"character":0,"line":227},"end":{"line":258,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"target($self,$target)","documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)","parameters":[{"label":"$self"},{"label":"$target"}]},"detail":"($self,$target)","kind":12,"children":[{"line":228,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"target"},{"name":"$target","containerName":"target","kind":13,"line":228},{"containerName":"target","name":"$target","kind":13,"line":230},{"containerName":"target","name":"$target","kind":13,"line":231},{"kind":12,"line":231,"containerName":"target","name":"isa"},{"containerName":"target","name":"$self","line":232,"kind":13},{"line":232,"kind":12,"containerName":"target","name":"throw"},{"line":235,"kind":13,"name":"$target","containerName":"target"},{"containerName":"target","name":"can","kind":12,"line":235},{"line":236,"kind":13,"containerName":"target","name":"$target"},{"name":"molecule","containerName":"target","line":236,"kind":12},{"containerName":"target","name":"$self","line":237,"kind":13},{"containerName":"target","name":"throw","line":237,"kind":12},{"kind":13,"line":238,"containerName":"target","name":"$target"},{"name":"molecule","containerName":"target","kind":12,"line":238},{"name":"$target","containerName":"target","line":242,"kind":13},{"name":"alphabet","containerName":"target","line":242,"kind":12},{"name":"$self","containerName":"target","kind":13,"line":243},{"name":"throw","containerName":"target","line":243,"kind":12},{"name":"$target","containerName":"target","line":244,"kind":13},{"kind":12,"line":244,"containerName":"target","name":"alphabet"},{"kind":13,"line":248,"name":"$self","containerName":"target"},{"containerName":"target","name":"$target","kind":13,"line":248},{"line":252,"kind":13,"containerName":"target","name":"$self"},{"line":253,"kind":13,"containerName":"target","name":"$self"},{"name":"$self","containerName":"target","line":256,"kind":13},{"containerName":"target","name":"throw","line":256,"kind":12}],"line":227},{"signature":{"documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)\n\n\nsub target {\n    my ($self, $target) = @_;\n\n    if ($target) {\n\tunless ($target->isa('Bio::SeqI')) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Target must be passed as a Bio::Seq object\" );\n\t}\n\tif ($target->can('molecule')) {\n\t    ( grep { uc($target->molecule) eq $_ } qw(DNA MRNA CDNA)) or\n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of type \". $target->molecule. \" are not supported\"\n\t\t\t       );\n\t}\n\telse {\n\t    ($target->alphabet eq 'dna') or \n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of alphabet \". $target->alphabet. \" are not supported\"\n\t\t\t       );\n\t}\n\t\n\t$self->{'target'} = $target;\n\treturn 1;\n\n    }\n    elsif ($self->{'target'}) {\n\treturn $self->{'target'};\n    }\n    else {\n\t$self->throw(\"Target sequence not defined\");\n    }\n}\n\n=head2 rules\n\n    Title\t: rules\n    Usage\t: $sirna->rules('ruleset')\n    Purpose\t: set/get ruleset to use for selecting SiRNA oligo pairs.\n    Returns\t: not sure yet\n    Args\t: a ruleset name (currently supported: Tuschl, Saigo)\n                  or a Bio::Tools::SiRNA::RulesetI compliant object","parameters":[{"label":"$self"},{"label":"$rules"}],"label":"rules($self,$rules)"},"detail":"($self,$rules)","definition":"sub","containerName":"main::","children":[{"line":272,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"rules"},{"line":272,"kind":13,"name":"$rules","containerName":"rules"},{"kind":13,"line":274,"name":"$rules","containerName":"rules"},{"kind":13,"line":275,"name":"$self","containerName":"rules"},{"name":"_load_ruleset","containerName":"rules","kind":12,"line":275},{"name":"$rules","containerName":"rules","kind":13,"line":275},{"name":"$self","containerName":"rules","kind":13,"line":278},{"kind":13,"line":279,"name":"$self","containerName":"rules"},{"line":279,"kind":12,"containerName":"rules","name":"_load_ruleset"},{"kind":13,"line":281,"containerName":"rules","name":"$self"}],"line":271,"kind":12,"range":{"end":{"character":9999,"line":282},"start":{"character":0,"line":271}},"name":"rules"},{"name":"_rules","line":278,"kind":12},{"name":"_rules","line":281,"kind":12},{"line":284,"children":[{"definition":"my","name":"$self","containerName":"_load_ruleset","localvar":"my","kind":13,"line":285},{"name":"$ruleset","containerName":"_load_ruleset","line":285,"kind":13},{"kind":13,"line":287,"containerName":"_load_ruleset","definition":"my","name":"$rule_module","localvar":"my"},{"containerName":"_load_ruleset","name":"$self","line":287,"kind":13},{"line":287,"kind":13,"name":"$ruleset","containerName":"_load_ruleset"},{"containerName":"_load_ruleset","name":"$self","kind":13,"line":293},{"line":293,"kind":12,"containerName":"_load_ruleset","name":"throw"},{"line":298,"kind":13,"containerName":"_load_ruleset","name":"$self"},{"containerName":"_load_ruleset","name":"$rule_module","line":298,"kind":13},{"name":"$self","containerName":"_load_ruleset","kind":13,"line":299},{"name":"$rule_module","containerName":"_load_ruleset","line":299,"kind":13}],"kind":12,"detail":"($self,$ruleset)","signature":{"parameters":[{"label":"$self"},{"label":"$ruleset"}],"documentation":"","label":"_load_ruleset($self,$ruleset)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":284},"end":{"character":9999,"line":303}},"name":"_load_ruleset"},{"kind":12,"line":298,"name":"_rules"},{"line":315,"children":[{"line":316,"kind":13,"localvar":"my","containerName":"design","name":"$self","definition":"my"},{"name":"$self","containerName":"design","line":318,"kind":13},{"containerName":"design","name":"rules","kind":12,"line":318},{"name":"$self","containerName":"design","line":318,"kind":13},{"name":"throw","containerName":"design","kind":12,"line":318},{"definition":"my","name":"@oligos","containerName":"design","localvar":"my","kind":13,"line":324},{"kind":13,"line":324,"containerName":"design","name":"$self"},{"kind":12,"line":324,"name":"_get_oligos","containerName":"design"},{"kind":12,"line":326,"name":"isa","containerName":"design"},{"name":"$self","containerName":"design","kind":13,"line":326},{"containerName":"design","name":"target","kind":12,"line":326},{"containerName":"design","name":"top_SeqFeatures","kind":12,"line":326}],"kind":12,"detail":"($self)","signature":{"label":"design($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)\n\n\nsub target {\n    my ($self, $target) = @_;\n\n    if ($target) {\n\tunless ($target->isa('Bio::SeqI')) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Target must be passed as a Bio::Seq object\" );\n\t}\n\tif ($target->can('molecule')) {\n\t    ( grep { uc($target->molecule) eq $_ } qw(DNA MRNA CDNA)) or\n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of type \". $target->molecule. \" are not supported\"\n\t\t\t       );\n\t}\n\telse {\n\t    ($target->alphabet eq 'dna') or \n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of alphabet \". $target->alphabet. \" are not supported\"\n\t\t\t       );\n\t}\n\t\n\t$self->{'target'} = $target;\n\treturn 1;\n\n    }\n    elsif ($self->{'target'}) {\n\treturn $self->{'target'};\n    }\n    else {\n\t$self->throw(\"Target sequence not defined\");\n    }\n}\n\n=head2 rules\n\n    Title\t: rules\n    Usage\t: $sirna->rules('ruleset')\n    Purpose\t: set/get ruleset to use for selecting SiRNA oligo pairs.\n    Returns\t: not sure yet\n    Args\t: a ruleset name (currently supported: Tuschl, Saigo)\n                  or a Bio::Tools::SiRNA::RulesetI compliant object\n\n\nsub rules {\n    my ($self, $rules) = @_;\n\n    if ($rules) {\n\t$self->_load_ruleset($rules);\n    }\n    # default: use tuschl rules\n    unless ($self->{_rules}) {\n\t$self->_load_ruleset('tuschl');\n    }\n    return $self->{_rules};\n}\n\nsub _load_ruleset {\n    my ($self, $ruleset) = @_;\n\n    my $rule_module = join('::', ref($self), 'Ruleset', lc($ruleset));\n\n    eval \"require $rule_module\";\n    \n    if ($@) {\n\t#warn join(\"\\n\", '@INC contains:', @INC, undef);\n\t$self->throw(\"Unable to load $rule_module: $@\");\n\treturn;\n    }\n\n    else {\n\t$self->{_rules} = $rule_module;\n\tbless($self, $rule_module); # recast as subclass\n    }\n\t\n    return 1;\n}\n\n=head2 design\n\n  Title\t\t: design\n  Usage\t\t: my @pairs = $sirna_designer->design();\n  Purpose\t: Design SiRNA oligo pairs.  \n  Returns\t: A list of SiRNA pairs as Bio::SeqFeature::SiRNA::Pair objects\n  Args\t\t: none"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":315},"end":{"line":327,"character":9999}},"name":"design"},{"name":"_define_target","range":{"end":{"character":9999,"line":374},"start":{"line":329,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"_define_target","name":"$self","definition":"my","line":330,"kind":13},{"kind":13,"line":331,"containerName":"_define_target","name":"$feat","definition":"my","localvar":"my"},{"kind":13,"line":331,"name":"$cds","containerName":"_define_target"},{"name":"$left","containerName":"_define_target","line":331,"kind":13},{"containerName":"_define_target","name":"$right","kind":13,"line":331},{"localvar":"my","containerName":"_define_target","name":"$target","definition":"my","line":333,"kind":13},{"line":333,"kind":13,"name":"$self","containerName":"_define_target"},{"line":333,"kind":12,"name":"target","containerName":"_define_target"},{"name":"$self","containerName":"_define_target","line":334,"kind":13},{"containerName":"_define_target","name":"throw","kind":12,"line":334},{"kind":13,"line":336,"name":"$cds","containerName":"_define_target"},{"containerName":"_define_target","name":"primary_tag","kind":12,"line":336},{"kind":13,"line":336,"containerName":"_define_target","name":"$target"},{"containerName":"_define_target","name":"top_SeqFeatures","line":336,"kind":12},{"kind":13,"line":336,"containerName":"_define_target","name":"$target"},{"line":336,"kind":12,"containerName":"_define_target","name":"can"},{"kind":13,"line":338,"containerName":"_define_target","name":"$cds"},{"containerName":"_define_target","name":"$left","kind":13,"line":339},{"kind":13,"line":339,"containerName":"_define_target","name":"$cds"},{"line":339,"kind":12,"name":"start","containerName":"_define_target"},{"kind":13,"line":339,"name":"$self","containerName":"_define_target"},{"kind":12,"line":339,"name":"start_pad","containerName":"_define_target"},{"kind":13,"line":340,"name":"$self","containerName":"_define_target"},{"containerName":"_define_target","name":"include_3pr","kind":12,"line":340},{"line":341,"kind":13,"name":"$right","containerName":"_define_target"},{"kind":13,"line":341,"name":"$cds","containerName":"_define_target"},{"name":"end","containerName":"_define_target","line":341,"kind":12},{"line":341,"kind":13,"containerName":"_define_target","name":"$self"},{"containerName":"_define_target","name":"end_pad","kind":12,"line":341},{"line":344,"kind":13,"name":"$right","containerName":"_define_target"},{"name":"$target","containerName":"_define_target","kind":13,"line":344},{"name":"length","containerName":"_define_target","kind":12,"line":344},{"kind":13,"line":344,"name":"$self","containerName":"_define_target"},{"name":"end_pad","containerName":"_define_target","line":344,"kind":12},{"kind":13,"line":348,"containerName":"_define_target","name":"$left"},{"kind":13,"line":348,"name":"$self","containerName":"_define_target"},{"containerName":"_define_target","name":"start_pad","line":348,"kind":12},{"kind":13,"line":349,"containerName":"_define_target","name":"$right"},{"kind":13,"line":349,"name":"$target","containerName":"_define_target"},{"name":"length","containerName":"_define_target","line":349,"kind":12},{"kind":13,"line":349,"name":"$self","containerName":"_define_target"},{"name":"end_pad","containerName":"_define_target","line":349,"kind":12},{"kind":13,"line":354,"containerName":"_define_target","name":"$right"},{"kind":13,"line":354,"name":"$left","containerName":"_define_target"},{"line":355,"kind":13,"containerName":"_define_target","name":"$self"},{"kind":12,"line":355,"containerName":"_define_target","name":"throw"},{"kind":13,"line":358,"name":"$targregion","definition":"my","containerName":"_define_target","localvar":"my"},{"kind":12,"line":358,"name":"new","containerName":"_define_target"},{"containerName":"_define_target","name":"$left","kind":13,"line":358},{"name":"$right","containerName":"_define_target","line":359,"kind":13},{"kind":13,"line":361,"name":"$self","containerName":"_define_target"},{"containerName":"_define_target","name":"target","kind":12,"line":361},{"name":"add_SeqFeature","containerName":"_define_target","kind":12,"line":361},{"name":"$targregion","containerName":"_define_target","kind":13,"line":361},{"localvar":"my","name":"@excluded","definition":"my","containerName":"_define_target","line":364,"kind":13},{"kind":12,"line":364,"containerName":"_define_target","name":"primary_tag"},{"name":"$self","containerName":"_define_target","line":364,"kind":13},{"name":"target","containerName":"_define_target","line":364,"kind":12},{"line":364,"kind":12,"containerName":"_define_target","name":"top_SeqFeatures"},{"line":366,"kind":13,"name":"$self","containerName":"_define_target"},{"name":"avoid_snps","containerName":"_define_target","kind":12,"line":366},{"kind":13,"line":367,"name":"@snps","definition":"my","containerName":"_define_target","localvar":"my"},{"line":367,"kind":12,"name":"primary_tag","containerName":"_define_target"},{"line":367,"kind":13,"name":"$self","containerName":"_define_target"},{"line":367,"kind":12,"containerName":"_define_target","name":"target"},{"line":367,"kind":12,"containerName":"_define_target","name":"top_SeqFeatures"},{"kind":13,"line":368,"containerName":"_define_target","name":"@excluded"},{"line":368,"kind":13,"name":"@snps","containerName":"_define_target"},{"line":371,"kind":13,"name":"$self","containerName":"_define_target"},{"line":371,"kind":12,"containerName":"_define_target","name":"excluded"},{"line":371,"kind":13,"name":"@excluded","containerName":"_define_target"},{"line":373,"kind":13,"name":"$targregion","containerName":"_define_target"}],"line":329,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_define_target($self)"},"detail":"($self)"},{"containerName":"SeqFeature::Generic","name":"Bio","line":358,"kind":12},{"kind":12,"line":376,"children":[{"kind":13,"line":377,"containerName":"_get_targetregion","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":379,"name":"$targregion","definition":"my","containerName":"_get_targetregion","localvar":"my"},{"line":379,"kind":12,"containerName":"_get_targetregion","name":"primary_tag"},{"containerName":"_get_targetregion","name":"$self","line":379,"kind":13},{"name":"target","containerName":"_get_targetregion","line":379,"kind":12},{"kind":12,"line":379,"name":"top_SeqFeatures","containerName":"_get_targetregion"},{"kind":13,"line":380,"name":"$targregion","containerName":"_get_targetregion"},{"line":380,"kind":13,"containerName":"_get_targetregion","name":"$self"},{"kind":12,"line":380,"containerName":"_get_targetregion","name":"_define_target"},{"containerName":"_get_targetregion","name":"$self","kind":13,"line":382},{"kind":12,"line":382,"name":"throw","containerName":"_get_targetregion"},{"containerName":"_get_targetregion","name":"$targregion","line":382,"kind":13},{"localvar":"my","containerName":"_get_targetregion","name":"$seq","definition":"my","line":384,"kind":13},{"kind":13,"line":384,"name":"$targregion","containerName":"_get_targetregion"},{"containerName":"_get_targetregion","name":"seq","kind":12,"line":384},{"name":"seq","containerName":"_get_targetregion","kind":12,"line":384},{"containerName":"_get_targetregion","name":"$targstart","definition":"my","localvar":"my","kind":13,"line":386},{"kind":13,"line":386,"name":"$targregion","containerName":"_get_targetregion"},{"name":"start","containerName":"_get_targetregion","kind":12,"line":386},{"name":"$seq","containerName":"_get_targetregion","kind":13,"line":388},{"line":388,"kind":13,"name":"$targstart","containerName":"_get_targetregion"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_get_targetregion($self)","parameters":[{"label":"$self"}],"documentation":""},"name":"_get_targetregion","range":{"end":{"line":389,"character":9999},"start":{"character":0,"line":376}}},{"signature":{"label":"add_oligos($self,$seq,$start,$rank)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$start"},{"label":"$rank"}],"documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)\n\n\nsub target {\n    my ($self, $target) = @_;\n\n    if ($target) {\n\tunless ($target->isa('Bio::SeqI')) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Target must be passed as a Bio::Seq object\" );\n\t}\n\tif ($target->can('molecule')) {\n\t    ( grep { uc($target->molecule) eq $_ } qw(DNA MRNA CDNA)) or\n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of type \". $target->molecule. \" are not supported\"\n\t\t\t       );\n\t}\n\telse {\n\t    ($target->alphabet eq 'dna') or \n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of alphabet \". $target->alphabet. \" are not supported\"\n\t\t\t       );\n\t}\n\t\n\t$self->{'target'} = $target;\n\treturn 1;\n\n    }\n    elsif ($self->{'target'}) {\n\treturn $self->{'target'};\n    }\n    else {\n\t$self->throw(\"Target sequence not defined\");\n    }\n}\n\n=head2 rules\n\n    Title\t: rules\n    Usage\t: $sirna->rules('ruleset')\n    Purpose\t: set/get ruleset to use for selecting SiRNA oligo pairs.\n    Returns\t: not sure yet\n    Args\t: a ruleset name (currently supported: Tuschl, Saigo)\n                  or a Bio::Tools::SiRNA::RulesetI compliant object\n\n\nsub rules {\n    my ($self, $rules) = @_;\n\n    if ($rules) {\n\t$self->_load_ruleset($rules);\n    }\n    # default: use tuschl rules\n    unless ($self->{_rules}) {\n\t$self->_load_ruleset('tuschl');\n    }\n    return $self->{_rules};\n}\n\nsub _load_ruleset {\n    my ($self, $ruleset) = @_;\n\n    my $rule_module = join('::', ref($self), 'Ruleset', lc($ruleset));\n\n    eval \"require $rule_module\";\n    \n    if ($@) {\n\t#warn join(\"\\n\", '@INC contains:', @INC, undef);\n\t$self->throw(\"Unable to load $rule_module: $@\");\n\treturn;\n    }\n\n    else {\n\t$self->{_rules} = $rule_module;\n\tbless($self, $rule_module); # recast as subclass\n    }\n\t\n    return 1;\n}\n\n=head2 design\n\n  Title\t\t: design\n  Usage\t\t: my @pairs = $sirna_designer->design();\n  Purpose\t: Design SiRNA oligo pairs.  \n  Returns\t: A list of SiRNA pairs as Bio::SeqFeature::SiRNA::Pair objects\n  Args\t\t: none\n\n\nsub design {\t\n    my ($self) = @_;\n\n    ($self->rules) or $self->throw('Unable to design siRNAs: no rule set specified');\n\n#     unless ( grep { $_->primary_tag eq 'Target' } $self->target->top_SeqFeatures ) {\n# \t$self->_define_target();\n#     }\n\n    my @oligos = $self->_get_oligos();\n       \n    return ( grep { $_->isa('Bio::SeqFeature::SiRNA::Pair') } $self->target->top_SeqFeatures );\n}\n    \nsub _define_target {\n    my ($self) = @_;\n    my ($feat, $cds, $left, $right);\n\n    my $target = $self->target or \n\t$self->throw(\"Unable to design oligos - no target provided\");\n\n    ($cds) = grep { $_->primary_tag eq 'CDS' } $target->top_SeqFeatures if ($target->can('top_SeqFeatures'));\n    \n    if ($cds) {\n\t$left = $cds->start + $self->start_pad;\n\tif (!$self->include_3pr) {\n\t    $right = $cds->end - $self->end_pad;\n\t}\n\telse {\n\t    $right = $target->length - $self->end_pad;\n\t}\n    }\n    else {\n\t$left = 0 + $self->start_pad;\n\t$right = $target->length - $self->end_pad;\n    }\n\n\n    # is there anything left?\n    if (($right - $left) < 20) {\n\t$self->throw(\"There isn't enough sequence to design oligos.  Please reduce start_pad and end_pad or supply more sequence\");\n    }\n    # define target region \n    my $targregion = Bio::SeqFeature::Generic->new( -start \t\t=> $left,\n\t\t\t\t\t\t    -end \t\t=> $right,\n\t\t\t\t\t\t    -primary\t\t=> 'Target' );\n    $self->target->add_SeqFeature($targregion);\n\n    # locate excluded regions\n    my @excluded = grep { $_->primary_tag eq 'Excluded' } $self->target->top_SeqFeatures;\n\n    if ($self->avoid_snps) {\n\tmy @snps =  grep { $_->primary_tag eq 'variation' } $self->target->top_SeqFeatures;\n\tpush(@excluded, @snps);\n    }\n    \n    $self->excluded(\\@excluded);\n\n    return $targregion;\n}\n\nsub _get_targetregion {\n    my ($self) = @_;\n    \n    my ($targregion) = grep { $_->primary_tag eq 'Target' } $self->target->top_SeqFeatures;\n    $targregion ||= $self->_define_target;\n\n    $self->throw(\"Target region for SiRNA design not defined\") unless ($targregion);\n\n    my $seq = $targregion->seq->seq;\n    # but this way I loose start info\n     my $targstart = $targregion->start;\n\n    return ($seq, $targstart);\n}   \n\n# MOVE to SiRNA::Ruleset::tuschl\n# sub _regex {\n#     my ($self, $rank) = @_;\n#     return $PATTERNS{$rank};\n# }\n\n# sub _get_oligos {\n#     # use regular expressions to pull out oligos\n\n#     my ($self, $rank) = @_;\n#     my $regex = $self->_regex($rank);\n#     my @exclude;\n\n\n#     my ($targregion) = grep { $_->primary_tag eq 'Target' } $self->target->top_SeqFeatures;\n#     my $seq = $targregion->seq->seq;\n#     # but this way I loose start info\n#     my $targstart = $targregion->start;\n    \n#     # exclude masked region\n#     push(@exclude, grep { $_->primary_tag eq 'Excluded' } $self->target->top_SeqFeatures);\n\n#     # add SNP checking\n#     if ($self->avoid_snps) {\n# \tmy @snps =  grep { $_->primary_tag eq 'variation' } $self->target->top_SeqFeatures;\n# \tpush(@exclude, @snps);\n#     }\n\n#     while ( $seq =~ /$regex/gi ) {\n# \tmy $target = $1;\n\n# \t# check for too many Gs (or Cs on the other strand)\n# \tnext if ( $target =~ /G{ $self->gstring,}/io );\n# \tnext if ( $target =~ /C{ $self->gstring,}/io );\n# \t# skip Ns (for filtering)\n# \tnext if ( $target =~ /N/i);\n\n# \tmy $start = length($`) + $targstart;\n# \tmy $stop = $start + length($target) -1;\n\n# \tmy @gc = ( $target =~ /G|C/gi);\n# \tmy $fxGC = sprintf(\"%2.2f\", (scalar(@gc) / length($target)));\n# \tnext if ($fxGC < $self->min_gc);\n# \tnext if ($fxGC > $self->max_gc);\n\n# \tmy $sense = Bio::SeqFeature::SiRNA::Oligo->new( -start \t\t=> $start,\n# \t\t\t\t\t\t\t-end \t\t=> $stop,\n# \t\t\t\t\t\t\t-strand \t=> 1,\n# \t\t\t\t\t\t\t-seq \t\t=> _get_sense($target),\n# \t\t\t\t\t\t\t-source_tag\t=> ref($self),\n# \t\t\t\t\t\t       );\t\n\n# \tmy $asense = Bio::SeqFeature::SiRNA::Oligo->new( -start \t=> $start,\n# \t\t\t\t\t\t\t -end\t\t=> $stop,\n# \t\t\t\t\t\t\t -strand\t=> -1,\n# \t\t\t\t\t\t\t -seq \t\t=> _get_anti($target), \n# \t\t\t\t\t\t\t -source_tag\t=> ref($self),\n# \t\t\t\t\t\t\t );\n\n#   \tmy $sirna = Bio::SeqFeature::SiRNA::Pair->new( -rank \t\t=> $rank,\n# \t\t\t\t\t\t       -fxGC\t\t=> $fxGC,\n# \t\t\t\t\t\t       -sense \t\t=> $sense,\n# \t\t\t\t\t\t       -antisense \t=> $asense,     \n# \t\t\t\t\t\t       -source_tag\t=> ref($self),\n# \t\t\t\t\t\t       );\n\n# \tunless ($self->_has_overlap($sirna, \\@exclude)) {\n# \t    $self->target->add_SeqFeature($sirna);\n# \t}\n#     }\n# }    \n\n=head2 add_oligos\n\n  Title\t\t: add_oligos\n  Usage\t \t: $sirna_designer->add_oligos($sequence, $start, $rank);\n  Purpose\t: Add SiRNA olgos to target Bio::Seq as Bio::SeqFeature::SiRNA::Pair objects\n  Args\t\t: Oligo sequence and start position (required), rank/score (optional)"},"detail":"($self,$seq,$start,$rank)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"add_oligos","localvar":"my","kind":13,"line":473},{"containerName":"add_oligos","name":"$seq","kind":13,"line":473},{"name":"$start","containerName":"add_oligos","line":473,"kind":13},{"name":"$rank","containerName":"add_oligos","line":473,"kind":13},{"name":"$seq","containerName":"add_oligos","kind":13,"line":475},{"name":"$start","containerName":"add_oligos","kind":13,"line":476},{"kind":13,"line":478,"containerName":"add_oligos","definition":"my","name":"$end","localvar":"my"},{"name":"$start","containerName":"add_oligos","kind":13,"line":478},{"kind":13,"line":478,"name":"$seq","containerName":"add_oligos"},{"name":"$sseq","definition":"my","containerName":"add_oligos","localvar":"my","kind":13,"line":480},{"name":"$self","containerName":"add_oligos","kind":13,"line":480},{"line":480,"kind":12,"containerName":"add_oligos","name":"_get_sense"},{"containerName":"add_oligos","name":"$seq","line":480,"kind":13},{"line":481,"kind":13,"localvar":"my","containerName":"add_oligos","name":"$sense","definition":"my"},{"kind":12,"line":481,"name":"new","containerName":"add_oligos"},{"containerName":"add_oligos","name":"$start","line":481,"kind":13},{"containerName":"add_oligos","name":"$start","kind":13,"line":482},{"name":"$sseq","containerName":"add_oligos","kind":13,"line":482},{"name":"$sseq","containerName":"add_oligos","line":484,"kind":13},{"name":"$self","containerName":"add_oligos","line":485,"kind":13},{"containerName":"add_oligos","definition":"my","name":"$aseq","localvar":"my","kind":13,"line":488},{"line":488,"kind":13,"name":"$self","containerName":"add_oligos"},{"name":"_get_anti","containerName":"add_oligos","kind":12,"line":488},{"containerName":"add_oligos","name":"$seq","kind":13,"line":488},{"localvar":"my","containerName":"add_oligos","name":"$asense","definition":"my","line":489,"kind":13},{"name":"new","containerName":"add_oligos","kind":12,"line":489},{"name":"$end","containerName":"add_oligos","line":489,"kind":13},{"containerName":"add_oligos","name":"$end","kind":13,"line":490},{"line":490,"kind":13,"containerName":"add_oligos","name":"$aseq"},{"kind":13,"line":492,"containerName":"add_oligos","name":"$aseq"},{"containerName":"add_oligos","name":"$self","kind":13,"line":493},{"containerName":"add_oligos","name":"$sirna","definition":"my","localvar":"my","kind":13,"line":496},{"name":"new","containerName":"add_oligos","line":496,"kind":12},{"kind":13,"line":496,"name":"$rank","containerName":"add_oligos"},{"name":"$sense","containerName":"add_oligos","kind":13,"line":498},{"name":"$asense","containerName":"add_oligos","line":499,"kind":13},{"containerName":"add_oligos","name":"$self","line":500,"kind":13},{"kind":13,"line":503,"name":"$self","containerName":"add_oligos"},{"line":503,"kind":12,"name":"_has_overlap","containerName":"add_oligos"},{"line":503,"kind":13,"name":"$sirna","containerName":"add_oligos"},{"containerName":"add_oligos","name":"$self","line":503,"kind":13},{"name":"excluded","containerName":"add_oligos","line":503,"kind":12},{"kind":13,"line":504,"name":"$self","containerName":"add_oligos"},{"containerName":"add_oligos","name":"target","kind":12,"line":504},{"line":504,"kind":12,"name":"add_SeqFeature","containerName":"add_oligos"},{"name":"$sirna","containerName":"add_oligos","kind":13,"line":504}],"line":472,"kind":12,"range":{"start":{"line":472,"character":0},"end":{"character":9999,"line":506}},"name":"add_oligos"},{"line":475,"kind":12,"name":"throw"},{"line":476,"kind":12,"name":"throw"},{"containerName":"SeqFeature::SiRNA::Oligo","name":"Bio","line":481,"kind":12},{"kind":12,"line":489,"containerName":"SeqFeature::SiRNA::Oligo","name":"Bio"},{"kind":12,"line":496,"containerName":"SeqFeature::SiRNA::Pair","name":"Bio"},{"detail":"($self,$test,$flist)","signature":{"label":"_has_overlap($self,$test,$flist)","documentation":"","parameters":[{"label":"$self"},{"label":"$test"},{"label":"$flist"}]},"containerName":"main::","definition":"sub","line":508,"children":[{"line":512,"kind":13,"localvar":"my","containerName":"_has_overlap","definition":"my","name":"$self"},{"line":512,"kind":13,"name":"$test","containerName":"_has_overlap"},{"line":512,"kind":13,"containerName":"_has_overlap","name":"$flist"},{"kind":13,"line":513,"containerName":"_has_overlap","name":"$test"},{"line":513,"kind":12,"name":"start","containerName":"_has_overlap"},{"line":513,"kind":13,"containerName":"_has_overlap","name":"$test"},{"kind":12,"line":513,"containerName":"_has_overlap","name":"end"},{"name":"$self","containerName":"_has_overlap","line":514,"kind":13},{"line":514,"kind":12,"name":"debug","containerName":"_has_overlap"},{"line":516,"kind":13,"localvar":"my","containerName":"_has_overlap","definition":"my","name":"$feat"},{"line":516,"kind":13,"name":"$flist","containerName":"_has_overlap"},{"line":517,"kind":13,"containerName":"_has_overlap","name":"$test"},{"line":517,"kind":12,"containerName":"_has_overlap","name":"start"},{"name":"$feat","containerName":"_has_overlap","kind":13,"line":517},{"name":"end","containerName":"_has_overlap","kind":12,"line":517},{"name":"$test","containerName":"_has_overlap","kind":13,"line":517},{"line":517,"kind":12,"name":"end","containerName":"_has_overlap"},{"line":517,"kind":13,"name":"$feat","containerName":"_has_overlap"},{"containerName":"_has_overlap","name":"start","kind":12,"line":517},{"line":518,"kind":13,"containerName":"_has_overlap","name":"$feat"},{"name":"primary_tag","containerName":"_has_overlap","line":518,"kind":12},{"name":"$feat","containerName":"_has_overlap","kind":13,"line":519},{"containerName":"_has_overlap","name":"start","line":519,"kind":12},{"containerName":"_has_overlap","name":"$feat","kind":13,"line":519},{"line":519,"kind":12,"containerName":"_has_overlap","name":"end"},{"line":519,"kind":13,"containerName":"_has_overlap","name":"$self"},{"line":519,"kind":12,"name":"debug","containerName":"_has_overlap"}],"kind":12,"range":{"start":{"line":508,"character":0},"end":{"character":9999,"line":524}},"name":"_has_overlap"},{"signature":{"label":"AUTOLOAD($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" MOVE to SiRNA::Ruleset::tuschl\n sub _get_sense {\n     my ($target) = @_;\n     # trim off 1st 2 nt to get overhang\n     $target =~ s/^..//;\n     # convert T's to U's (transcribe)\n     $target =~ s/T/U/gi;\n     # force last 2 nt to be T's\n     $target =~ s/..$/TT/;\n     return $target;\n }\n sub _get_anti {\n     my ($target) = @_;\n     my @target = split(//, $target);\n     my ($nt,@antitarget);\n     while ($nt = pop @target) {\n \tpush(@antitarget, $COMP{$nt});\n     }\n     my $anti = join('', @antitarget);\n     # trim off 1st 2 nt to get overhang\n     $anti =~ s/^..//;\n     # convert T's to U's\n     $anti =~ s/T/U/gi;\n     # convert last 2 NT's to T\n     $anti =~ s/..$/TT/;\n     return $anti;\n }"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":561,"containerName":"AUTOLOAD","name":"$self","definition":"my","localvar":"my"},{"containerName":"AUTOLOAD","name":"$value","line":561,"kind":13},{"containerName":"AUTOLOAD","definition":"my","name":"$name","localvar":"my","kind":13,"line":562},{"kind":13,"line":562,"containerName":"AUTOLOAD","name":"$AUTOLOAD"},{"kind":13,"line":563,"name":"$name","containerName":"AUTOLOAD"},{"kind":13,"line":565,"name":"$name","containerName":"AUTOLOAD"},{"name":"$value","containerName":"AUTOLOAD","line":568,"kind":13},{"kind":13,"line":569,"containerName":"AUTOLOAD","name":"$self"},{"kind":13,"line":569,"name":"$name","containerName":"AUTOLOAD"},{"line":569,"kind":13,"name":"$value","containerName":"AUTOLOAD"},{"name":"$self","containerName":"AUTOLOAD","kind":13,"line":572},{"containerName":"AUTOLOAD","name":"$name","line":572,"kind":13},{"containerName":"AUTOLOAD","name":"$self","kind":13,"line":573},{"line":573,"kind":12,"name":"throw","containerName":"AUTOLOAD"},{"containerName":"AUTOLOAD","name":"$self","line":573,"kind":13},{"name":"$self","containerName":"AUTOLOAD","kind":13,"line":576},{"line":576,"kind":13,"name":"$name","containerName":"AUTOLOAD"}],"line":560,"kind":12,"range":{"end":{"line":577,"character":9999},"start":{"line":560,"character":0}},"name":"AUTOLOAD"},{"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$char"}],"label":"_comp($self,$char)"},"detail":"($self,$char)","kind":12,"children":[{"kind":13,"line":580,"containerName":"_comp","definition":"my","name":"$self","localvar":"my"},{"name":"$char","containerName":"_comp","kind":13,"line":580},{"name":"$char","containerName":"_comp","line":582,"kind":13},{"kind":13,"line":583,"name":"$char","containerName":"_comp"},{"kind":13,"line":583,"containerName":"_comp","name":"$char"},{"kind":13,"line":584,"containerName":"_comp","name":"$COMP"},{"name":"$char","containerName":"_comp","line":584,"kind":13}],"line":579,"name":"_comp","range":{"end":{"line":585,"character":9999},"start":{"line":579,"character":0}}}],"version":5}