{"version":5,"vars":[{"containerName":"","name":"base","line":136,"kind":2},{"name":"new","range":{"start":{"character":0,"line":138},"end":{"character":9999,"line":155}},"kind":12,"line":138,"children":[{"kind":13,"line":139,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"line":139,"kind":13,"name":"@args","containerName":"new"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":141},{"kind":13,"line":141,"name":"$class","containerName":"new"},{"line":141,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","definition":"my","name":"$seqobj","line":143,"kind":13},{"kind":13,"line":143,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":143},{"containerName":"new","name":"@args","kind":13,"line":143},{"name":"$seqobj","containerName":"new","kind":13,"line":144},{"containerName":"new","name":"@args","kind":13,"line":144},{"name":"$args","containerName":"new","line":144,"kind":13},{"kind":13,"line":146,"name":"$seqobj","containerName":"new"},{"line":146,"kind":13,"name":"$args","containerName":"new"},{"containerName":"new","name":"$seqobj","line":149,"kind":13},{"kind":12,"line":149,"containerName":"new","name":"isa"},{"name":"$self","containerName":"new","kind":13,"line":150},{"name":"throw","containerName":"new","line":150,"kind":12},{"line":150,"kind":13,"containerName":"new","name":"$self"},{"line":153,"kind":13,"containerName":"new","name":"$self"},{"name":"$seqobj","containerName":"new","kind":13,"line":153},{"kind":13,"line":154,"containerName":"new","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"}},{"name":"SUPER","containerName":"new","kind":12,"line":141},{"detail":"($self,$seqobj,$word_length)","signature":{"label":"count_words($self,$seqobj,$word_length)","parameters":[{"label":"$self"},{"label":"$seqobj"},{"label":"$word_length"}],"documentation":"1;\n# $Id: SeqWords.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------------------------\n# PACKAGE    : Bio::Tools::SeqWords\n# PURPOSE    : To count n-mers in any sequence of characters\n# AUTHOR     : Derek Gatherer (d.gatherer@vir.gla.ac.uk)\n# SOURCE     : \n# CREATED    : 21st March 2000\n# MODIFIED   : 11th November 2003 (DG - new method, count_overlap_words)\n# LICENCE    : You may distribute this module under the same terms \n#\t          : as the rest of BioPerl.\n#---------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::SeqWords - Object holding n-mer statistics for a sequence\n\n=head1 SYNOPSIS\n\n  # Create the SeqWords object, e.g.:\n\n  my $inputstream = Bio::SeqIO->new(-file => \"seqfile\", \n\t                                 -format => 'Fasta');\n  my $seqobj = $inputstream->next_seq();\n  my $seq_word = Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # Or:\n  my $seqobj = Bio::PrimarySeq->new(-seq => \"agggtttccc\",\n                                    -alphabet => 'dna',\n                                    -id => 'test');\n  my $seq_word  =  Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # obtain a hash of word counts, eg:\n  my $hash_ref = $seq_stats->count_words($word_length);\n\n  # display hash table, eg:\n  my %hash = %$hash_ref;\n  foreach my $key(sort keys %hash)\n  {\n    print \"\\n$key\\t$hash{$key}\";\n  }\n\n  # Or:\n\n  my $hash_ref =\n     Bio::Tools::SeqWords->count_words($seqobj,$word_length);\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqWords> is a featherweight object for the calculation\nof n-mer word occurrences in a single sequence.  It is envisaged that\nthe object will be useful for construction of scripts which use n-mer\nword tables as the raw material for statistical calculations; for\ninstance, hexamer frequency for the calculation of coding protential,\nor the calculation of periodicity in repetitive DNA.  Triplet\nfrequency is already handled by L<Bio::Tools::SeqStats> (author: Peter\nSchattner).\n\nThere are a few possible applications for protein, e.g. hypothesised\namino acid 7-mers in heat shock proteins, or proteins with multiple\nsimple motifs.  Sometimes these protein periodicities are best seen\nwhen the amino acid alphabet is truncated, e.g. Shulman alphabet.\nSince there are quite a few of these shortened alphabets, this module\ndoes not specify any particular alphabet.\n\nSee Synopsis above for object creation code.\n\n=head2 Rationale\n\nTake a sequence object and create an object for the purposes of\nholding n-mer word statistics about that sequence. The sequence can be\nnucleic acid or protein.\n\nIn count_words() the words are counted in a non-overlapping manner,\nie. in the style of a codon table, but with any word length.\n\nIn count_overlap_words() the words are counted in an overlapping\nmanner.\n\nFor counts on opposite strand (DNA/RNA), a reverse complement method\nshould be performed, and then the count repeated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer, in the loosest sense of the word 'author'.  The\ngeneral shape of the module is lifted directly from the SeqStat module\nof Peter Schattner. The central subroutine to count the words is\nadapted from original code provided by Dave Shivak, in response to a\nquery on the bioperl mailing list.  At least 2 other people provided\nalternative means (equally good but not used in the end) of performing\nthe same calculation.  Thanks to all for your assistance.\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SeqWords;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    # our new standard way of instantiation\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    \n    if(! $seqobj->isa(\"Bio::PrimarySeqI\")) { \n\t$self->throw(ref($self) . \" works only on PrimarySeqI objects\\n\");\n    }\n\t\n    $self->{'_seqref'} = $seqobj;\n    return $self; \n}\n\n\n=head2 count_words\n\n Title   : count_words\n Usage   : $word_count = $seq_stats->count_words($word_length)\n                or \n           $word_count = $seq_stats->Bio::Tools::SeqWords->($seqobj,$word_length);\n Function: Counts non-overlapping words within a string, any alphabet is \n           used\n Example : a sequence ACCGTCCGT, counted at word length 4, will give the hash\n           {ACCG => 1, TCCG => 1}\n Returns : Reference to a hash in which keys are words (any length) of the\n           alphabet used and values are number of occurrences of the word \n           in the sequence.\n Args    : Word length as scalar and, reference to sequence object if\n           required\n\n           Throws an exception word length is not a positive integer\n           or if word length is longer than the sequence."},"containerName":"main::","definition":"sub","line":179,"children":[{"containerName":"count_words","definition":"my","name":"$self","localvar":"my","kind":13,"line":181},{"line":181,"kind":13,"name":"$seqobj","containerName":"count_words"},{"name":"$word_length","containerName":"count_words","line":181,"kind":13},{"containerName":"count_words","name":"$seqobj","line":184,"kind":13},{"name":"$seqobj","containerName":"count_words","kind":13,"line":186},{"kind":12,"line":186,"containerName":"count_words","name":"isa"},{"name":"$self","containerName":"count_words","line":187,"kind":13},{"containerName":"count_words","name":"throw","line":187,"kind":12},{"name":"$word_length","containerName":"count_words","line":191,"kind":13},{"name":"$seqobj","containerName":"count_words","line":191,"kind":13},{"kind":13,"line":192,"name":"$seqobj","containerName":"count_words"},{"kind":13,"line":195,"containerName":"count_words","name":"$seqobj"},{"name":"$seqobj","containerName":"count_words","line":196,"kind":13},{"line":196,"kind":13,"name":"$self","containerName":"count_words"},{"line":199,"kind":13,"name":"$word_length","containerName":"count_words"},{"containerName":"count_words","name":"$word_length","kind":13,"line":199},{"kind":13,"line":200,"name":"$self","containerName":"count_words"},{"name":"throw","containerName":"count_words","line":200,"kind":12},{"name":"$word_length","containerName":"count_words","kind":13,"line":202},{"containerName":"count_words","name":"$word_length","line":202,"kind":13},{"name":"$word_length","containerName":"count_words","kind":13,"line":202},{"containerName":"count_words","name":"$self","kind":13,"line":203},{"containerName":"count_words","name":"throw","kind":12,"line":203},{"localvar":"my","containerName":"count_words","definition":"my","name":"$seqstring","line":207,"kind":13},{"line":207,"kind":13,"name":"$seqobj","containerName":"count_words"},{"kind":12,"line":207,"name":"seq","containerName":"count_words"},{"line":209,"kind":13,"name":"$word_length","containerName":"count_words"},{"kind":13,"line":209,"name":"$seqstring","containerName":"count_words"},{"name":"$self","containerName":"count_words","line":210,"kind":13},{"kind":12,"line":210,"name":"throw","containerName":"count_words"},{"localvar":"my","name":"$type","definition":"my","containerName":"count_words","line":214,"kind":13},{"kind":13,"line":215,"definition":"my","name":"$words","containerName":"count_words","localvar":"my"},{"name":"$seqobj","containerName":"count_words","kind":13,"line":215},{"name":"$word_length","containerName":"count_words","line":215,"kind":13},{"kind":13,"line":215,"name":"$type","containerName":"count_words"},{"name":"$words","containerName":"count_words","line":216,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":217},"start":{"character":0,"line":179}},"name":"count_words"},{"name":"_count","line":215,"kind":12},{"name":"count_overlap_words","range":{"end":{"line":264,"character":9999},"start":{"character":0,"line":236}},"kind":12,"line":236,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"count_overlap_words","line":238,"kind":13},{"line":238,"kind":13,"containerName":"count_overlap_words","name":"$seqobj"},{"containerName":"count_overlap_words","name":"$word_length","kind":13,"line":238},{"containerName":"count_overlap_words","name":"$seqobj","kind":13,"line":240},{"line":242,"kind":13,"name":"$seqobj","containerName":"count_overlap_words"},{"line":242,"kind":12,"containerName":"count_overlap_words","name":"isa"},{"containerName":"count_overlap_words","name":"$self","kind":13,"line":243},{"line":243,"kind":12,"name":"throw","containerName":"count_overlap_words"},{"kind":13,"line":247,"name":"$word_length","containerName":"count_overlap_words"},{"name":"$seqobj","containerName":"count_overlap_words","line":247,"kind":13},{"kind":13,"line":248,"name":"$seqobj","containerName":"count_overlap_words"},{"kind":13,"line":251,"containerName":"count_overlap_words","name":"$seqobj"},{"name":"$seqobj","containerName":"count_overlap_words","line":252,"kind":13},{"containerName":"count_overlap_words","name":"$self","line":252,"kind":13},{"localvar":"my","definition":"my","name":"$seqstring","containerName":"count_overlap_words","line":254,"kind":13},{"containerName":"count_overlap_words","name":"$seqobj","kind":13,"line":254},{"kind":12,"line":254,"containerName":"count_overlap_words","name":"seq"},{"line":256,"kind":13,"name":"$word_length","containerName":"count_overlap_words"},{"containerName":"count_overlap_words","name":"$seqstring","kind":13,"line":256},{"kind":13,"line":257,"name":"$self","containerName":"count_overlap_words"},{"kind":12,"line":257,"containerName":"count_overlap_words","name":"throw"},{"line":261,"kind":13,"localvar":"my","containerName":"count_overlap_words","definition":"my","name":"$type"},{"containerName":"count_overlap_words","definition":"my","name":"$words","localvar":"my","kind":13,"line":262},{"name":"$seqobj","containerName":"count_overlap_words","kind":13,"line":262},{"name":"$word_length","containerName":"count_overlap_words","line":262,"kind":13},{"kind":13,"line":262,"name":"$type","containerName":"count_overlap_words"},{"line":263,"kind":13,"containerName":"count_overlap_words","name":"$words"}],"containerName":"main::","definition":"sub","detail":"($self,$seqobj,$word_length)","signature":{"label":"count_overlap_words($self,$seqobj,$word_length)","parameters":[{"label":"$self"},{"label":"$seqobj"},{"label":"$word_length"}],"documentation":"1;\n# $Id: SeqWords.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------------------------\n# PACKAGE    : Bio::Tools::SeqWords\n# PURPOSE    : To count n-mers in any sequence of characters\n# AUTHOR     : Derek Gatherer (d.gatherer@vir.gla.ac.uk)\n# SOURCE     : \n# CREATED    : 21st March 2000\n# MODIFIED   : 11th November 2003 (DG - new method, count_overlap_words)\n# LICENCE    : You may distribute this module under the same terms \n#\t          : as the rest of BioPerl.\n#---------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::SeqWords - Object holding n-mer statistics for a sequence\n\n=head1 SYNOPSIS\n\n  # Create the SeqWords object, e.g.:\n\n  my $inputstream = Bio::SeqIO->new(-file => \"seqfile\", \n\t                                 -format => 'Fasta');\n  my $seqobj = $inputstream->next_seq();\n  my $seq_word = Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # Or:\n  my $seqobj = Bio::PrimarySeq->new(-seq => \"agggtttccc\",\n                                    -alphabet => 'dna',\n                                    -id => 'test');\n  my $seq_word  =  Bio::Tools::SeqWords->new(-seq => $seqobj);\n\n  # obtain a hash of word counts, eg:\n  my $hash_ref = $seq_stats->count_words($word_length);\n\n  # display hash table, eg:\n  my %hash = %$hash_ref;\n  foreach my $key(sort keys %hash)\n  {\n    print \"\\n$key\\t$hash{$key}\";\n  }\n\n  # Or:\n\n  my $hash_ref =\n     Bio::Tools::SeqWords->count_words($seqobj,$word_length);\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqWords> is a featherweight object for the calculation\nof n-mer word occurrences in a single sequence.  It is envisaged that\nthe object will be useful for construction of scripts which use n-mer\nword tables as the raw material for statistical calculations; for\ninstance, hexamer frequency for the calculation of coding protential,\nor the calculation of periodicity in repetitive DNA.  Triplet\nfrequency is already handled by L<Bio::Tools::SeqStats> (author: Peter\nSchattner).\n\nThere are a few possible applications for protein, e.g. hypothesised\namino acid 7-mers in heat shock proteins, or proteins with multiple\nsimple motifs.  Sometimes these protein periodicities are best seen\nwhen the amino acid alphabet is truncated, e.g. Shulman alphabet.\nSince there are quite a few of these shortened alphabets, this module\ndoes not specify any particular alphabet.\n\nSee Synopsis above for object creation code.\n\n=head2 Rationale\n\nTake a sequence object and create an object for the purposes of\nholding n-mer word statistics about that sequence. The sequence can be\nnucleic acid or protein.\n\nIn count_words() the words are counted in a non-overlapping manner,\nie. in the style of a codon table, but with any word length.\n\nIn count_overlap_words() the words are counted in an overlapping\nmanner.\n\nFor counts on opposite strand (DNA/RNA), a reverse complement method\nshould be performed, and then the count repeated.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer, in the loosest sense of the word 'author'.  The\ngeneral shape of the module is lifted directly from the SeqStat module\nof Peter Schattner. The central subroutine to count the words is\nadapted from original code provided by Dave Shivak, in response to a\nquery on the bioperl mailing list.  At least 2 other people provided\nalternative means (equally good but not used in the end) of performing\nthe same calculation.  Thanks to all for your assistance.\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SeqWords;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    # our new standard way of instantiation\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    \n    if(! $seqobj->isa(\"Bio::PrimarySeqI\")) { \n\t$self->throw(ref($self) . \" works only on PrimarySeqI objects\\n\");\n    }\n\t\n    $self->{'_seqref'} = $seqobj;\n    return $self; \n}\n\n\n=head2 count_words\n\n Title   : count_words\n Usage   : $word_count = $seq_stats->count_words($word_length)\n                or \n           $word_count = $seq_stats->Bio::Tools::SeqWords->($seqobj,$word_length);\n Function: Counts non-overlapping words within a string, any alphabet is \n           used\n Example : a sequence ACCGTCCGT, counted at word length 4, will give the hash\n           {ACCG => 1, TCCG => 1}\n Returns : Reference to a hash in which keys are words (any length) of the\n           alphabet used and values are number of occurrences of the word \n           in the sequence.\n Args    : Word length as scalar and, reference to sequence object if\n           required\n\n           Throws an exception word length is not a positive integer\n           or if word length is longer than the sequence.\n\n\nsub count_words\n{\n    my ($self,$seqobj,$word_length) = @_;\n\n    # check how we were called, and if necessary rearrange arguments\n    if(ref($seqobj)) {\n\t# call as SeqWords->count_words($seq, $wordlen)\n\tif(! $seqobj->isa(\"Bio::PrimarySeqI\")) { \n\t    $self->throw(\"SeqWords works only on PrimarySeqI objects\\n\");\n\t}\n    } else {\n\t# call as $obj->count_words($wordlen)\n\t$word_length = $seqobj;\n\t$seqobj = undef;\n    }\n\n    if(! defined($seqobj)){\n\t      $seqobj =  $self->{'_seqref'};\n    }\n    \n    if($word_length eq \"\" || $word_length =~ /[a-z]/i){\n\t      $self->throw(\"SeqWords cannot accept non-numeric characters\".\n\t\t     \" or a null value in the \\$word_length variable\\n\");\n    }elsif ($word_length <1 || ($word_length - int($word_length)) >0){\n\t      $self->throw(\"SeqWords requires the word length to be a \".\n\t\t     \"positive integer\\n\");\n    }\n\n    my $seqstring = uc $seqobj->seq();\n\n    if($word_length > length($seqstring)){\n\t      $self->throw(\"die in _count, \\$word_length is bigger \".\n\t\t    \"than sequence length\\n\");\n    }\n\n    my $type = \"non-overlap\";\n    my $words = _count($seqobj, $word_length, $type);\n    return $words;   # ref. to a hash\n}\n\n=head2 count_overlap_words\n\n Title   : count_overlap_words\n Usage   : $word_count = $word_obj->count_overlap_words($word_length);\n Function: Counts overlapping words within a string, any alphabet is used\n Example : A sequence ACCAACCA, counted at word length 4, will give the hash\n\t        {ACCA=>2, CCAA=>1, CAAC=>1, AACC=>1}\n Returns : Reference to a hash in which keys are words (any length) of the \n           alphabet used and values are number of occurrences of the word in \n           the sequence.\n Args    : Word length as scalar\n\n           Throws an exception if word length is not a positive integer\n           or if word length is longer than the sequence."}},{"name":"_count","kind":12,"line":262},{"range":{"end":{"line":295,"character":9999},"start":{"line":268,"character":0}},"name":"_count","children":[{"line":269,"kind":13,"localvar":"my","containerName":"_count","definition":"my","name":"$seqobj"},{"line":269,"kind":13,"name":"$word_length","containerName":"_count"},{"containerName":"_count","name":"$type","line":269,"kind":13},{"line":270,"kind":13,"localvar":"my","name":"%codon","definition":"my","containerName":"_count"},{"line":275,"kind":13,"localvar":"my","containerName":"_count","definition":"my","name":"$seqstring"},{"line":275,"kind":13,"containerName":"_count","name":"$seqobj"},{"name":"seq","containerName":"_count","line":275,"kind":12},{"line":276,"kind":13,"containerName":"_count","name":"$type"},{"containerName":"_count","name":"$seqstring","kind":13,"line":278},{"kind":13,"line":279,"containerName":"_count","name":"$codon"},{"line":281,"kind":13,"containerName":"_count","name":"$type"},{"localvar":"my","containerName":"_count","definition":"my","name":"$seqlen","line":282,"kind":13},{"containerName":"_count","name":"$seqobj","line":282,"kind":13},{"kind":12,"line":282,"containerName":"_count","name":"length"},{"localvar":"my","name":"$frame","definition":"my","containerName":"_count","line":283,"kind":13},{"containerName":"_count","name":"$frame","line":283,"kind":13},{"name":"$word_length","containerName":"_count","kind":13,"line":283},{"kind":13,"line":283,"name":"$frame","containerName":"_count"},{"localvar":"my","containerName":"_count","definition":"my","name":"$seqstring","line":285,"kind":13},{"kind":13,"line":285,"containerName":"_count","name":"$seqobj"},{"line":285,"kind":12,"name":"subseq","containerName":"_count"},{"containerName":"_count","name":"$frame","line":285,"kind":13},{"name":"$seqlen","containerName":"_count","line":285,"kind":13},{"name":"$seqstring","containerName":"_count","line":287,"kind":13},{"line":288,"kind":13,"name":"$codon","containerName":"_count"},{"kind":12,"line":292,"name":"throw","containerName":"_count"},{"line":294,"kind":13,"containerName":"_count","name":"%codon"}],"line":268,"kind":12,"signature":{"parameters":[{"label":"$seqobj"},{"label":"$word_length"},{"label":"$type"}],"documentation":" the actual counting routine\n used by both count_words and count_overlap_words","label":"_count($seqobj,$word_length,$type)"},"detail":"($seqobj,$word_length,$type)","definition":"sub","containerName":"main::"},{"kind":12,"line":292,"containerName":"Root::Root","name":"Bio"}]}