{"vars":[{"line":89,"kind":2,"name":"vars","containerName":""},{"kind":2,"line":95,"containerName":"","name":"base"},{"detail":"($self,$lambda)","signature":{"label":"rand_birth_distribution($self,$lambda)","parameters":[{"label":"$self"},{"label":"$lambda"}],"documentation":"1;\n# $Id: RandomDistFunctions.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RandomDistFunctions\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RandomDistFunctions - A set of routines useful for\ngenerating random data in different distributions\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RandomDistFunctions;\n  my $dist = Bio::Tools::RandomDistFunctions->new();\n  for my $v ( 1..1000 ) { \n    my $birth_dist = $dist->rand_birth_distribution($lambda);\n    # ... do something with the variable\n  }\n\n=head1 DESCRIPTION\n\nMost of the code is based on the C implementation of these routines in\nMike Sanderson's r8s's package.  See http://loco.biosci.arizona.edu/r8s/ for\ninformation on his software.\n\nThis code tries to be fast and use available faster BigInt and GMP\nlibrary methods when those modules are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nThanks to Mike Sanderson for assistance in the getting this\nimplementation together.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RandomDistFunctions;\nrequire Exporter;\nuse vars qw(%LOADED @EXPORT_OK); use strict;\n\n#use Math::BigFloat lib => 'GMP,Bit::Vector';\n#use Math::BigInt lib  => 'GMP,Bit::Vector';\nuse POSIX;\n\nuse base qw(Bio::Root::Root);\n\n=head2 birth_distribution\n\n Title   : rand_birth_distribution\n Usage   : my $randvar = $dist->\n            rand_birth_distribution($lambda);\n Function: Returns a random number from a birth process waiting \n           time with a fixed interval\n           1.0.  Times are measured from 0=present,1=root;\n Returns : floating point number\n Args    : $lambda ( > 0 )\n References : This is based on code by Mike Sanders in r8s.\n              Ross, Stochastic Processes, p. 145 for the density"},"containerName":"main::","definition":"sub","line":112,"children":[{"localvar":"my","containerName":"rand_birth_distribution","definition":"my","name":"$self","line":113,"kind":13},{"containerName":"rand_birth_distribution","name":"$lambda","line":113,"kind":13},{"line":114,"kind":13,"name":"$self","containerName":"rand_birth_distribution"},{"line":115,"kind":13,"containerName":"rand_birth_distribution","name":"$self"},{"kind":13,"line":116,"name":"$lambda","containerName":"rand_birth_distribution"},{"name":"$self","containerName":"rand_birth_distribution","line":116,"kind":13},{"kind":13,"line":118,"name":"$lambda","containerName":"rand_birth_distribution"},{"containerName":"rand_birth_distribution","name":"$self","kind":13,"line":119},{"line":119,"kind":12,"name":"throw","containerName":"rand_birth_distribution"},{"containerName":"rand_birth_distribution","name":"$lambda","line":121,"kind":13},{"kind":13,"line":121,"name":"$lambda","containerName":"rand_birth_distribution"}],"kind":12,"range":{"end":{"character":9999,"line":122},"start":{"line":112,"character":0}},"name":"rand_birth_distribution"},{"line":138,"children":[{"definition":"my","name":"$self","containerName":"rand_geometric_distribution","localvar":"my","kind":13,"line":139},{"kind":13,"line":139,"containerName":"rand_geometric_distribution","name":"$param"},{"name":"$self","containerName":"rand_geometric_distribution","kind":13,"line":140},{"line":141,"kind":13,"name":"$self","containerName":"rand_geometric_distribution"},{"containerName":"rand_geometric_distribution","name":"$param","kind":13,"line":142},{"name":"$self","containerName":"rand_geometric_distribution","line":142,"kind":13},{"containerName":"rand_geometric_distribution","name":"$param","line":144,"kind":13},{"line":145,"kind":13,"containerName":"rand_geometric_distribution","name":"$self"},{"line":145,"kind":12,"name":"throw","containerName":"rand_geometric_distribution"},{"localvar":"my","containerName":"rand_geometric_distribution","definition":"my","name":"$den","line":148,"kind":13},{"name":"$param","containerName":"rand_geometric_distribution","kind":13,"line":149},{"name":"$den","containerName":"rand_geometric_distribution","kind":13,"line":150},{"line":150,"kind":13,"containerName":"rand_geometric_distribution","name":"$param"},{"line":150,"kind":13,"name":"$param","containerName":"rand_geometric_distribution"},{"containerName":"rand_geometric_distribution","name":"$param","kind":13,"line":150},{"containerName":"rand_geometric_distribution","name":"$den","line":152,"kind":13},{"kind":13,"line":152,"containerName":"rand_geometric_distribution","name":"$param"},{"localvar":"my","definition":"my","name":"$z","containerName":"rand_geometric_distribution","line":154,"kind":13},{"line":154,"kind":13,"name":"$den","containerName":"rand_geometric_distribution"},{"kind":13,"line":155,"name":"$z","containerName":"rand_geometric_distribution"}],"kind":12,"detail":"($self,$param)","signature":{"documentation":"1;\n# $Id: RandomDistFunctions.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RandomDistFunctions\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RandomDistFunctions - A set of routines useful for\ngenerating random data in different distributions\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RandomDistFunctions;\n  my $dist = Bio::Tools::RandomDistFunctions->new();\n  for my $v ( 1..1000 ) { \n    my $birth_dist = $dist->rand_birth_distribution($lambda);\n    # ... do something with the variable\n  }\n\n=head1 DESCRIPTION\n\nMost of the code is based on the C implementation of these routines in\nMike Sanderson's r8s's package.  See http://loco.biosci.arizona.edu/r8s/ for\ninformation on his software.\n\nThis code tries to be fast and use available faster BigInt and GMP\nlibrary methods when those modules are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nThanks to Mike Sanderson for assistance in the getting this\nimplementation together.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RandomDistFunctions;\nrequire Exporter;\nuse vars qw(%LOADED @EXPORT_OK); use strict;\n\n#use Math::BigFloat lib => 'GMP,Bit::Vector';\n#use Math::BigInt lib  => 'GMP,Bit::Vector';\nuse POSIX;\n\nuse base qw(Bio::Root::Root);\n\n=head2 birth_distribution\n\n Title   : rand_birth_distribution\n Usage   : my $randvar = $dist->\n            rand_birth_distribution($lambda);\n Function: Returns a random number from a birth process waiting \n           time with a fixed interval\n           1.0.  Times are measured from 0=present,1=root;\n Returns : floating point number\n Args    : $lambda ( > 0 )\n References : This is based on code by Mike Sanders in r8s.\n              Ross, Stochastic Processes, p. 145 for the density\n\n\nsub rand_birth_distribution{\n   my ($self,$lambda) = @_;\n   if( ! ref($self) && \n       $self !~ /RandomDistFunctions/ ) { \n       $lambda = $self;\n   }\n   unless( $lambda ) { \n       $self->throw(\"Cannot call birth_distribution without a valid lambda value (>0)\");\n   }\n   return 1 - (log(rand(1) * (exp($lambda) - 1)+1)/ $lambda); \n}\n\n\n=head2 rand_geometric_distribution\n\n Title   : rand_geometric_distribution\n Usage   : my $randvar = $dist->rand_geometric_distribution($param);\n Function: Returns a random geometric variate distributed with \n           paramater $param, according to\n           c.d.f. 1 - ( 1- param) ^ n \n Returns : integer\n Args    : $param ( 0 > $param < 1 )","parameters":[{"label":"$self"},{"label":"$param"}],"label":"rand_geometric_distribution($self,$param)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":163},"start":{"character":0,"line":138}},"name":"rand_geometric_distribution"},{"line":155,"kind":12,"name":"POSIX","containerName":"floor"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: RandomDistFunctions.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RandomDistFunctions\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RandomDistFunctions - A set of routines useful for\ngenerating random data in different distributions\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RandomDistFunctions;\n  my $dist = Bio::Tools::RandomDistFunctions->new();\n  for my $v ( 1..1000 ) { \n    my $birth_dist = $dist->rand_birth_distribution($lambda);\n    # ... do something with the variable\n  }\n\n=head1 DESCRIPTION\n\nMost of the code is based on the C implementation of these routines in\nMike Sanderson's r8s's package.  See http://loco.biosci.arizona.edu/r8s/ for\ninformation on his software.\n\nThis code tries to be fast and use available faster BigInt and GMP\nlibrary methods when those modules are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nThanks to Mike Sanderson for assistance in the getting this\nimplementation together.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RandomDistFunctions;\nrequire Exporter;\nuse vars qw(%LOADED @EXPORT_OK); use strict;\n\n#use Math::BigFloat lib => 'GMP,Bit::Vector';\n#use Math::BigInt lib  => 'GMP,Bit::Vector';\nuse POSIX;\n\nuse base qw(Bio::Root::Root);\n\n=head2 birth_distribution\n\n Title   : rand_birth_distribution\n Usage   : my $randvar = $dist->\n            rand_birth_distribution($lambda);\n Function: Returns a random number from a birth process waiting \n           time with a fixed interval\n           1.0.  Times are measured from 0=present,1=root;\n Returns : floating point number\n Args    : $lambda ( > 0 )\n References : This is based on code by Mike Sanders in r8s.\n              Ross, Stochastic Processes, p. 145 for the density\n\n\nsub rand_birth_distribution{\n   my ($self,$lambda) = @_;\n   if( ! ref($self) && \n       $self !~ /RandomDistFunctions/ ) { \n       $lambda = $self;\n   }\n   unless( $lambda ) { \n       $self->throw(\"Cannot call birth_distribution without a valid lambda value (>0)\");\n   }\n   return 1 - (log(rand(1) * (exp($lambda) - 1)+1)/ $lambda); \n}\n\n\n=head2 rand_geometric_distribution\n\n Title   : rand_geometric_distribution\n Usage   : my $randvar = $dist->rand_geometric_distribution($param);\n Function: Returns a random geometric variate distributed with \n           paramater $param, according to\n           c.d.f. 1 - ( 1- param) ^ n \n Returns : integer\n Args    : $param ( 0 > $param < 1 )\n\n\n\nsub rand_geometric_distribution{\n   my ($self,$param) = @_;\n   if( ! ref($self) && \n       $self !~ /RandomDistFunctions/ ) { \n       $param = $self;\n   }\n   unless( $param ) { \n       $self->throw(\"Cannot call rand_geometric_distribution without a valid param value (>0)\");\n   }\n\n   my $den;\n   if( $param < 1e-8) { \n       $den = (-1 * $param) - ( $param * $param ) / 2;\n   } else { \n       $den = log(1 - $param);\n   }\n   my $z = log(1 - rand(1)) / $den;\n   return POSIX::floor($z) + 1;\n   # MSanderson comments from r8s code\n   # Is this the right truncation of the real-valued expression above?\n   # YES\n   # Checked by reference to the expected mean of the distribution in\n   # 100,000 replicates\n   # EX = 1/param Var = (1-param)/param^2 See Olkin, Gleser, and\n   # Derman, p. 193ff. Probability Models and Applications, 1980.\n}\n\n=head2 rand_exponentional_distribution\n\n Title   : rand_exponentional_distribution\n Usage   : my $var = $dist->rand_exponentional_distribution($param);\n Function: Returns a random exponential variate distributed with parameter\n           $param, according to c.d.f 1 - e^(-param * x)\n Returns : floating point number \n Args    : $param ( > 0 )","parameters":[{"label":"$self"},{"label":"$param"}],"label":"rand_exponentional_distribution($self,$param)"},"detail":"($self,$param)","kind":12,"children":[{"containerName":"rand_exponentional_distribution","name":"$self","definition":"my","localvar":"my","kind":13,"line":178},{"line":178,"kind":13,"name":"$param","containerName":"rand_exponentional_distribution"},{"name":"$self","containerName":"rand_exponentional_distribution","kind":13,"line":179},{"containerName":"rand_exponentional_distribution","name":"$self","line":180,"kind":13},{"containerName":"rand_exponentional_distribution","name":"$param","kind":13,"line":181},{"name":"$self","containerName":"rand_exponentional_distribution","line":181,"kind":13},{"containerName":"rand_exponentional_distribution","name":"$param","line":183,"kind":13},{"kind":13,"line":184,"containerName":"rand_exponentional_distribution","name":"$self"},{"kind":12,"line":184,"name":"throw","containerName":"rand_exponentional_distribution"},{"name":"$param","containerName":"rand_exponentional_distribution","line":186,"kind":13}],"line":177,"name":"rand_exponentional_distribution","range":{"start":{"line":177,"character":0},"end":{"line":187,"character":9999}}},{"definition":"sub","name":"rand_normal_distribution","containerName":"main::","range":{"end":{"line":211,"character":9999},"start":{"character":0,"line":200}},"kind":12,"children":[{"kind":13,"line":201,"containerName":"rand_normal_distribution","name":"$gset","definition":"my","localvar":"my"},{"kind":13,"line":202,"definition":"my","name":"$rsq","containerName":"rand_normal_distribution","localvar":"my"},{"line":202,"kind":13,"name":"$v1","containerName":"rand_normal_distribution"},{"containerName":"rand_normal_distribution","name":"$v2","kind":13,"line":202},{"line":204,"kind":13,"containerName":"rand_normal_distribution","name":"$v1"},{"kind":13,"line":205,"name":"$v2","containerName":"rand_normal_distribution"},{"kind":13,"line":206,"containerName":"rand_normal_distribution","name":"$rsq"},{"line":206,"kind":13,"name":"$v1","containerName":"rand_normal_distribution"},{"containerName":"rand_normal_distribution","name":"$v2","kind":13,"line":206},{"line":207,"kind":13,"containerName":"rand_normal_distribution","name":"$rsq"},{"kind":13,"line":207,"name":"$rsq","containerName":"rand_normal_distribution"},{"localvar":"my","containerName":"rand_normal_distribution","name":"$fac","definition":"my","line":208,"kind":13},{"containerName":"rand_normal_distribution","name":"$rsq","line":208,"kind":13},{"containerName":"rand_normal_distribution","name":"$rsq","line":208,"kind":13},{"containerName":"rand_normal_distribution","name":"$gset","line":209,"kind":13},{"line":209,"kind":13,"name":"$v1","containerName":"rand_normal_distribution"},{"name":"$fac","containerName":"rand_normal_distribution","kind":13,"line":209},{"line":210,"kind":13,"containerName":"rand_normal_distribution","name":"$v2"},{"containerName":"rand_normal_distribution","name":"$fac","line":210,"kind":13}],"line":200}],"version":5}