{"version":5,"vars":[{"containerName":"","name":"base","line":77,"kind":2},{"name":"new","range":{"start":{"line":91,"character":0},"end":{"line":98,"character":9999}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":91,"children":[{"kind":13,"line":92,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"kind":13,"line":92,"containerName":"new","name":"@args"},{"kind":13,"line":94,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","line":94,"kind":13},{"kind":13,"line":94,"name":"@args","containerName":"new"},{"kind":13,"line":95,"containerName":"new","name":"$self"},{"line":95,"kind":12,"name":"_initialize_io","containerName":"new"},{"line":95,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","kind":13,"line":97}]},{"kind":12,"line":94,"containerName":"new","name":"SUPER"},{"detail":"($self)","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $prints_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":111,"children":[{"kind":13,"line":112,"containerName":"next_result","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":113,"containerName":"next_result","definition":"my","name":"%printsac","localvar":"my"},{"localvar":"my","containerName":"next_result","name":"@features","definition":"my","line":114,"kind":13},{"localvar":"my","containerName":"next_result","name":"$line","definition":"my","line":115,"kind":13},{"containerName":"next_result","name":"$sequenceId","definition":"my","localvar":"my","kind":13,"line":116},{"containerName":"next_result","name":"$self","line":118,"kind":13},{"containerName":"next_result","name":"_readline","kind":12,"line":118},{"name":"$line","containerName":"next_result","line":120,"kind":13},{"line":121,"kind":13,"name":"$line","containerName":"next_result"},{"name":"$line","containerName":"next_result","kind":13,"line":123},{"name":"$sequenceId","containerName":"next_result","line":125,"kind":13},{"name":"$line","containerName":"next_result","kind":13,"line":125},{"name":"$self","containerName":"next_result","line":126,"kind":13},{"kind":12,"line":126,"containerName":"next_result","name":"seqname"},{"name":"$sequenceId","containerName":"next_result","kind":13,"line":126},{"line":130,"kind":13,"containerName":"next_result","name":"$line"},{"name":"$id","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":131},{"name":"$line","containerName":"next_result","kind":13,"line":131},{"line":132,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$ac"},{"kind":13,"line":132,"containerName":"next_result","name":"$line"},{"name":"$printsac","containerName":"next_result","line":133,"kind":13},{"name":"$id","containerName":"next_result","kind":13,"line":133},{"name":"$ac","containerName":"next_result","kind":13,"line":133},{"kind":13,"line":134,"name":"$self","containerName":"next_result"},{"line":134,"kind":12,"containerName":"next_result","name":"print_sac"},{"line":134,"kind":13,"name":"%printsac","containerName":"next_result"},{"containerName":"next_result","name":"$line","kind":13,"line":138},{"name":"$line","containerName":"next_result","kind":13,"line":140},{"kind":13,"line":141,"containerName":"next_result","name":"$num","definition":"my","localvar":"my"},{"name":"$line","containerName":"next_result","line":142,"kind":13},{"localvar":"my","containerName":"next_result","definition":"my","name":"@elements","line":144,"kind":13},{"containerName":"next_result","name":"$line","line":144,"kind":13},{"kind":13,"line":146,"containerName":"next_result","name":"$fingerprintName","definition":"my","localvar":"my"},{"containerName":"next_result","name":"$motifNumber","kind":13,"line":146},{"kind":13,"line":146,"containerName":"next_result","name":"$temp"},{"containerName":"next_result","name":"$tot","line":146,"kind":13},{"containerName":"next_result","name":"$percentageIdentity","kind":13,"line":146},{"name":"$profileScore","containerName":"next_result","line":146,"kind":13},{"name":"$pvalue","containerName":"next_result","line":146,"kind":13},{"line":146,"kind":13,"name":"$subsequence","containerName":"next_result"},{"name":"$motifLength","containerName":"next_result","line":146,"kind":13},{"line":146,"kind":13,"name":"$lowestMotifPosition","containerName":"next_result"},{"kind":13,"line":146,"name":"$matchPosition","containerName":"next_result"},{"line":146,"kind":13,"name":"$highestMotifPosition","containerName":"next_result"},{"name":"@elements","containerName":"next_result","kind":13,"line":146},{"kind":13,"line":148,"containerName":"next_result","definition":"my","name":"$start","localvar":"my"},{"containerName":"next_result","name":"$matchPosition","kind":13,"line":148},{"kind":13,"line":149,"name":"$end","definition":"my","containerName":"next_result","localvar":"my"},{"name":"$matchPosition","containerName":"next_result","line":149,"kind":13},{"kind":13,"line":149,"containerName":"next_result","name":"$motifLength"},{"line":150,"kind":13,"localvar":"my","definition":"my","name":"$print_sac","containerName":"next_result"},{"kind":13,"line":150,"containerName":"next_result","name":"$self"},{"name":"print_sac","containerName":"next_result","kind":12,"line":150},{"name":"%printsac","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":152},{"containerName":"next_result","name":"$print_sac","line":152,"kind":13},{"line":153,"kind":13,"localvar":"my","name":"$print","definition":"my","containerName":"next_result"},{"line":153,"kind":13,"containerName":"next_result","name":"$printsac"},{"containerName":"next_result","name":"$fingerprintName","line":153,"kind":13},{"localvar":"my","containerName":"next_result","name":"$seqname","definition":"my","line":154,"kind":13},{"name":"$self","containerName":"next_result","line":154,"kind":13},{"name":"seqname","containerName":"next_result","kind":12,"line":154},{"localvar":"my","definition":"my","name":"$feat","containerName":"next_result","line":155,"kind":13},{"kind":13,"line":156,"containerName":"next_result","definition":"my","name":"$new_feat","localvar":"my"},{"kind":13,"line":156,"containerName":"next_result","name":"$self"},{"name":"create_feature","containerName":"next_result","line":156,"kind":12},{"containerName":"next_result","name":"$feat","line":156,"kind":13},{"kind":13,"line":156,"containerName":"next_result","name":"$seqname"},{"line":157,"kind":13,"name":"$new_feat","containerName":"next_result"},{"line":159,"kind":13,"containerName":"next_result","name":"$line"}],"kind":12,"range":{"end":{"character":9999,"line":166},"start":{"line":111,"character":0}},"name":"next_result"},{"kind":12,"children":[{"kind":13,"line":182,"containerName":"create_feature","name":"$self","definition":"my","localvar":"my"},{"line":182,"kind":13,"containerName":"create_feature","name":"$feat"},{"containerName":"create_feature","name":"$sequenceId","line":182,"kind":13},{"localvar":"my","containerName":"create_feature","name":"@f","definition":"my","line":184,"kind":13},{"line":184,"kind":13,"name":"$feat","containerName":"create_feature"},{"kind":13,"line":186,"definition":"my","name":"$feature","containerName":"create_feature","localvar":"my"},{"name":"new","containerName":"create_feature","line":186,"kind":12},{"name":"$sequenceId","containerName":"create_feature","line":187,"kind":13},{"name":"$f","containerName":"create_feature","line":188,"kind":13},{"kind":13,"line":189,"containerName":"create_feature","name":"$f"},{"line":190,"kind":13,"name":"$f","containerName":"create_feature"},{"kind":13,"line":192,"containerName":"create_feature","name":"$f"},{"kind":13,"line":195,"containerName":"create_feature","name":"$feature"},{"containerName":"create_feature","name":"add_tag_value","line":195,"kind":12},{"containerName":"create_feature","name":"$f","kind":13,"line":195},{"line":196,"kind":13,"name":"$feature","containerName":"create_feature"},{"line":196,"kind":12,"name":"add_tag_value","containerName":"create_feature"},{"name":"$f","containerName":"create_feature","kind":13,"line":196},{"containerName":"create_feature","name":"$feature2","definition":"my","localvar":"my","kind":13,"line":198},{"kind":12,"line":198,"name":"new","containerName":"create_feature"},{"containerName":"create_feature","name":"$f","kind":13,"line":199},{"name":"$fp","definition":"my","containerName":"create_feature","localvar":"my","kind":13,"line":203},{"containerName":"create_feature","name":"new","line":203,"kind":12},{"kind":13,"line":204,"containerName":"create_feature","name":"$feature"},{"line":206,"kind":13,"name":"$feature2","containerName":"create_feature"},{"name":"$fp","containerName":"create_feature","kind":13,"line":207}],"line":181,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$sequenceId"}],"documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $prints_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my %printsac;\n    my @features;\n    my $line;\n    my $sequenceId;\n     \n    while ($_=$self->_readline()) {\n      \n           $line = $_;\n           chomp $line;\n\n           if ($line =~ s/^Sn;//) { # We have identified a Sn; line so there should be the following:\n\n              ($sequenceId) = $line =~ /^\\s*(\\w+)/;\n              $self->seqname($sequenceId);\n              next;\n           }\n              \n           if ($line =~ s/^1TBH//) {\n               my  ($id) = $line =~ /^\\s*(\\w+)/;\n               my ($ac) = $line =~ /(PR\\w+)\\s*$/;\n               $printsac{$id} = $ac;\n               $self->print_sac(\\%printsac);\n               next;\n           }\n             \n           if ($line =~ s/^3TB//) {\n              \n              if ($line =~ s/^[HN]//) {\n                   my($num)=\"\";\n                   $line =~ s/^\\s+//;\n\n                   my @elements = split /\\s+/, $line;\n\n                   my ($fingerprintName,$motifNumber,$temp,$tot,$percentageIdentity,$profileScore,$pvalue,$subsequence,$motifLength,$lowestMotifPosition,$matchPosition,$highestMotifPosition) = @elements;\n    \n                   my $start = $matchPosition;\n                   my $end = $matchPosition + $motifLength - 1;\n                   my $print_sac = $self->print_sac;\n                   \n                   my %printsac =  %{$print_sac};\n                   my $print =  $printsac{$fingerprintName};\n                   my $seqname=$self->seqname;\n                   my $feat = \"$print,$start,$end,$percentageIdentity,$profileScore,$pvalue\";\n                   my $new_feat =  $self->create_feature($feat,$seqname);\n                   return $new_feat;\n               }\n               if ($line =~ s/^F//) {\n                   return;  \n               }\n                   next;                                                       \n               }\n            next;         \n \n      }\n\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$prints_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::FeaturePair>\n Args    :","label":"create_feature($self,$feat,$sequenceId)"},"detail":"($self,$feat,$sequenceId)","name":"create_feature","range":{"start":{"line":181,"character":0},"end":{"character":9999,"line":208}}},{"line":186,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":198},{"name":"Bio","containerName":"SeqFeature::FeaturePair","line":203,"kind":12},{"children":[{"containerName":"print_sac","name":"$self","definition":"my","localvar":"my","kind":13,"line":222},{"containerName":"print_sac","name":"$self","line":223,"kind":13},{"containerName":"print_sac","name":"$self","kind":13,"line":224}],"line":221,"kind":12,"range":{"end":{"line":225,"character":9999},"start":{"line":221,"character":0}},"name":"print_sac","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self,$seqname)","signature":{"parameters":[{"label":"$self"},{"label":"$seqname"}],"documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $prints_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my %printsac;\n    my @features;\n    my $line;\n    my $sequenceId;\n     \n    while ($_=$self->_readline()) {\n      \n           $line = $_;\n           chomp $line;\n\n           if ($line =~ s/^Sn;//) { # We have identified a Sn; line so there should be the following:\n\n              ($sequenceId) = $line =~ /^\\s*(\\w+)/;\n              $self->seqname($sequenceId);\n              next;\n           }\n              \n           if ($line =~ s/^1TBH//) {\n               my  ($id) = $line =~ /^\\s*(\\w+)/;\n               my ($ac) = $line =~ /(PR\\w+)\\s*$/;\n               $printsac{$id} = $ac;\n               $self->print_sac(\\%printsac);\n               next;\n           }\n             \n           if ($line =~ s/^3TB//) {\n              \n              if ($line =~ s/^[HN]//) {\n                   my($num)=\"\";\n                   $line =~ s/^\\s+//;\n\n                   my @elements = split /\\s+/, $line;\n\n                   my ($fingerprintName,$motifNumber,$temp,$tot,$percentageIdentity,$profileScore,$pvalue,$subsequence,$motifLength,$lowestMotifPosition,$matchPosition,$highestMotifPosition) = @elements;\n    \n                   my $start = $matchPosition;\n                   my $end = $matchPosition + $motifLength - 1;\n                   my $print_sac = $self->print_sac;\n                   \n                   my %printsac =  %{$print_sac};\n                   my $print =  $printsac{$fingerprintName};\n                   my $seqname=$self->seqname;\n                   my $feat = \"$print,$start,$end,$percentageIdentity,$profileScore,$pvalue\";\n                   my $new_feat =  $self->create_feature($feat,$seqname);\n                   return $new_feat;\n               }\n               if ($line =~ s/^F//) {\n                   return;  \n               }\n                   next;                                                       \n               }\n            next;         \n \n      }\n\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$prints_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::FeaturePair>\n Args    :\n\n\n\nsub create_feature {\n    my ($self, $feat,$sequenceId) = @_;\n\n    my @f = split (/,/,$feat);\n    # create feature object\n    my $feature= Bio::SeqFeature::Generic->new(\n        -seq_id    =>$sequenceId,\n        -start=>$f[1],\n        -end  => $f[2],\n        -score      => $f[4],\n        -source     => \"PRINTS\",\n        -primary    =>$f[0],\n        -logic_name => \"PRINTS\",\n    );\n    $feature->add_tag_value('evalue',$f[5]);\n    $feature->add_tag_value('percent_id',$f[3]);\n        \n    my $feature2 = Bio::SeqFeature::Generic->new(\n        -seq_id => $f[0],\n        -start => 0,\n        -end => 0,\n    );\n    my $fp = Bio::SeqFeature::FeaturePair->new(\n        -feature1 => $feature,\n        -feature2 => $feature2\n    );\n    return  $fp; \n}\n\n=head2 print_sac\n\n Title   : print_sac\n Usage   : $prints_parser->print_sac($print_sac)\n Function: get/set for print_sac\n Returns :\n Args    :\n\n\n\nsub print_sac {\n    my $self = shift;\n    return $self->{'print_sac'} = shift if @_;\n    return $self->{'print_sac'};\n}\n\n=head2 seqname \n\n Title   : seqname\n Usage   : $prints_parser->seqname($seqname)\n Function: get/set for seqname\n Returns :\n Args    :","label":"seqname($self,$seqname)"},"kind":12,"line":238,"children":[{"kind":13,"line":239,"containerName":"seqname","name":"$self","definition":"my","localvar":"my"},{"containerName":"seqname","name":"$seqname","kind":13,"line":239},{"line":240,"kind":13,"name":"$self","containerName":"seqname"},{"line":240,"kind":13,"name":"$seqname","containerName":"seqname"},{"line":240,"kind":13,"containerName":"seqname","name":"$seqname"},{"kind":13,"line":241,"containerName":"seqname","name":"$self"}],"name":"seqname","range":{"end":{"character":9999,"line":242},"start":{"line":238,"character":0}}}]}