{"version":5,"vars":[{"line":123,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"end":{"line":169,"character":9999},"start":{"line":136,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : ","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"kind":13,"line":137,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"name":"@args","containerName":"new","line":137,"kind":13},{"kind":13,"line":139,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"name":"$class","containerName":"new","kind":13,"line":139},{"name":"@args","containerName":"new","line":139,"kind":13},{"name":"$trees","definition":"my","containerName":"new","localvar":"my","kind":13,"line":140},{"line":140,"kind":13,"name":"$smat","containerName":"new"},{"containerName":"new","name":"$freq","kind":13,"line":140},{"kind":13,"line":141,"containerName":"new","name":"$model"},{"kind":13,"line":141,"name":"$sspace","containerName":"new"},{"kind":13,"line":142,"containerName":"new","name":"$self"},{"line":142,"kind":12,"name":"_rearrange","containerName":"new"},{"line":144,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":146,"name":"$trees","containerName":"new"},{"kind":13,"line":147,"containerName":"new","name":"$trees"},{"kind":13,"line":148,"name":"$self","containerName":"new"},{"line":148,"kind":12,"containerName":"new","name":"warn"},{"localvar":"my","name":"$t","definition":"my","containerName":"new","line":150,"kind":13},{"kind":13,"line":150,"containerName":"new","name":"$trees"},{"containerName":"new","name":"$self","line":151,"kind":13},{"name":"add_tree","containerName":"new","kind":12,"line":151},{"name":"$t","containerName":"new","line":151,"kind":13},{"containerName":"new","name":"$smat","line":157,"kind":13},{"name":"$self","containerName":"new","line":158,"kind":13},{"line":158,"kind":12,"containerName":"new","name":"substitution_matrix"},{"containerName":"new","name":"$smat","kind":13,"line":158},{"containerName":"new","name":"$freq","line":160,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":161},{"containerName":"new","name":"residue_frequencies","kind":12,"line":161},{"containerName":"new","name":"$freq","kind":13,"line":161},{"containerName":"new","name":"$model","kind":13,"line":164},{"line":164,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":164,"name":"model","containerName":"new"},{"name":"$model","containerName":"new","line":164,"kind":13},{"containerName":"new","name":"$sspace","kind":13,"line":165},{"line":165,"kind":13,"name":"$self","containerName":"new"},{"line":165,"kind":12,"containerName":"new","name":"search_space"},{"kind":13,"line":165,"containerName":"new","name":"$sspace"},{"name":"$self","containerName":"new","line":166,"kind":13},{"kind":13,"line":168,"name":"$self","containerName":"new"}],"line":136},{"name":"SUPER","containerName":"new","line":139,"kind":12},{"range":{"end":{"line":189,"character":9999},"start":{"line":182,"character":0}},"name":"model","signature":{"label":"model($self,$value)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":183,"containerName":"model","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":183,"name":"$value","containerName":"model"},{"line":184,"kind":13,"containerName":"model","name":"$value"},{"containerName":"model","name":"$self","kind":13,"line":185},{"name":"$value","containerName":"model","line":185,"kind":13},{"name":"$self","containerName":"model","kind":13,"line":187}],"line":182,"kind":12},{"range":{"end":{"character":9999,"line":219},"start":{"character":0,"line":204}},"name":"substitution_matrix","children":[{"containerName":"substitution_matrix","name":"$self","definition":"my","localvar":"my","kind":13,"line":205},{"name":"$val","containerName":"substitution_matrix","line":205,"kind":13},{"kind":13,"line":206,"name":"$val","containerName":"substitution_matrix"},{"kind":13,"line":207,"name":"$val","containerName":"substitution_matrix"},{"kind":13,"line":208,"containerName":"substitution_matrix","definition":"my","name":"$v","localvar":"my"},{"containerName":"substitution_matrix","name":"$val","kind":13,"line":208},{"kind":13,"line":209,"name":"$v","containerName":"substitution_matrix"},{"name":"$self","containerName":"substitution_matrix","kind":13,"line":210},{"kind":12,"line":210,"name":"warn","containerName":"substitution_matrix"},{"containerName":"substitution_matrix","name":"$self","kind":13,"line":214},{"line":214,"kind":13,"name":"$val","containerName":"substitution_matrix"},{"kind":13,"line":216,"name":"$self","containerName":"substitution_matrix"},{"kind":12,"line":216,"name":"warn","containerName":"substitution_matrix"}],"line":204,"kind":12,"signature":{"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none","parameters":[{"label":"$self"},{"label":"$val"}],"label":"substitution_matrix($self,$val)"},"detail":"($self,$val)","definition":"sub","containerName":"main::"},{"kind":13,"line":220,"name":"%self","containerName":null},{"name":"transition_probability_matrix","range":{"start":{"character":0,"line":235},"end":{"character":9999,"line":251}},"containerName":"main::","definition":"sub","detail":"($self,$type,$val)","signature":{"label":"transition_probability_matrix($self,$type,$val)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$val"}]},"kind":12,"line":235,"children":[{"line":236,"kind":13,"localvar":"my","containerName":"transition_probability_matrix","definition":"my","name":"$self"},{"kind":13,"line":236,"name":"$type","containerName":"transition_probability_matrix"},{"line":236,"kind":13,"name":"$val","containerName":"transition_probability_matrix"},{"containerName":"transition_probability_matrix","name":"$type","line":237,"kind":13},{"name":"$type","containerName":"transition_probability_matrix","line":237,"kind":13},{"containerName":"transition_probability_matrix","name":"$val","kind":13,"line":238},{"line":239,"kind":13,"containerName":"transition_probability_matrix","name":"$val"},{"line":240,"kind":13,"localvar":"my","containerName":"transition_probability_matrix","name":"$v","definition":"my"},{"kind":13,"line":240,"containerName":"transition_probability_matrix","name":"$val"},{"line":241,"kind":13,"containerName":"transition_probability_matrix","name":"$v"},{"kind":13,"line":242,"containerName":"transition_probability_matrix","name":"$self"},{"name":"warn","containerName":"transition_probability_matrix","kind":12,"line":242},{"line":246,"kind":13,"name":"$self","containerName":"transition_probability_matrix"},{"kind":13,"line":246,"containerName":"transition_probability_matrix","name":"$type"},{"containerName":"transition_probability_matrix","name":"$val","line":246,"kind":13},{"kind":13,"line":248,"name":"$self","containerName":"transition_probability_matrix"},{"containerName":"transition_probability_matrix","name":"warn","kind":12,"line":248}]},{"kind":13,"line":255,"containerName":null,"name":"%self"},{"line":255,"kind":13,"containerName":null,"name":"$type"},{"line":276,"children":[{"name":"$self","definition":"my","containerName":"residue_frequencies","localvar":"my","kind":13,"line":277},{"kind":13,"line":277,"name":"$val","containerName":"residue_frequencies"},{"kind":13,"line":278,"name":"$val","containerName":"residue_frequencies"},{"kind":13,"line":279,"name":"$val","containerName":"residue_frequencies"},{"name":"$self","containerName":"residue_frequencies","kind":13,"line":280},{"name":"$val","containerName":"residue_frequencies","kind":13,"line":280},{"kind":13,"line":282,"containerName":"residue_frequencies","name":"$self"},{"kind":12,"line":282,"name":"warn","containerName":"residue_frequencies"},{"name":"$self","containerName":"residue_frequencies","kind":13,"line":285}],"kind":12,"detail":"($self,$val)","signature":{"label":"residue_frequencies($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n'"},"containerName":"main::","definition":"sub","range":{"start":{"line":276,"character":0},"end":{"line":285,"character":9999}},"name":"residue_frequencies"},{"name":"next_tree","range":{"start":{"character":0,"line":298},"end":{"line":301,"character":9999}},"kind":12,"line":298,"children":[{"kind":13,"line":299,"containerName":"next_tree","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":299,"containerName":"next_tree","name":"@args"},{"name":"$self","containerName":"next_tree","kind":13,"line":300},{"name":"$self","containerName":"next_tree","line":300,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n\n#'\n\nsub residue_frequencies {\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   $self->{'_residue_frequencies'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for residue_frequencies\");\n       }\n   }\n   return %{$self->{'_residue_frequencies'}};\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get the next tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_tree($self,@args)"}},{"children":[],"line":314,"kind":12,"range":{"end":{"character":9999,"line":316},"start":{"character":0,"line":314}},"name":"rewind_tree_iterator","definition":"sub","containerName":"main::"},{"name":"add_tree","range":{"end":{"line":332,"character":9999},"start":{"character":0,"line":328}},"containerName":"main::","definition":"sub","detail":"($self,$tree)","signature":{"parameters":[{"label":"$self"},{"label":"$tree"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n\n#'\n\nsub residue_frequencies {\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   $self->{'_residue_frequencies'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for residue_frequencies\");\n       }\n   }\n   return %{$self->{'_residue_frequencies'}};\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get the next tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none\n\n\nsub next_tree{\n   my ($self,@args) = @_;\n   return $self->{'_trees'}->[$self->{'_treeiterator'}++] || undef;\n}\n\n=head2 rewind_tree\n\n Title   : rewind_tree_iterator\n Usage   : $result->rewind_tree()\n Function: Rewinds the tree iterator so that next_tree can be \n           called again from the beginning\n Returns : none\n Args    : none\n\n\nsub rewind_tree_iterator {\n    shift->{'_treeiterator'} = 0;\n}\n\n=head2 add_tree\n\n Title   : add_tree\n Usage   : $result->add_tree($tree);\n Function: Adds a tree \n Returns : integer which is the number of trees stored\n Args    : L<Bio::Tree::TreeI>","label":"add_tree($self,$tree)"},"kind":12,"line":328,"children":[{"name":"$self","definition":"my","containerName":"add_tree","localvar":"my","kind":13,"line":329},{"name":"$tree","containerName":"add_tree","kind":13,"line":329},{"containerName":"add_tree","name":"$tree","kind":13,"line":330},{"kind":13,"line":330,"name":"$tree","containerName":"add_tree"},{"containerName":"add_tree","name":"$tree","kind":13,"line":330},{"line":330,"kind":12,"containerName":"add_tree","name":"isa"},{"line":331,"kind":13,"containerName":"add_tree","name":"$self"},{"name":"$tree","containerName":"add_tree","kind":13,"line":331}]},{"line":333,"kind":13,"containerName":null,"name":"%self"},{"name":"search_space","range":{"start":{"line":347,"character":0},"end":{"character":9999,"line":353}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n\n#'\n\nsub residue_frequencies {\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   $self->{'_residue_frequencies'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for residue_frequencies\");\n       }\n   }\n   return %{$self->{'_residue_frequencies'}};\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get the next tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none\n\n\nsub next_tree{\n   my ($self,@args) = @_;\n   return $self->{'_trees'}->[$self->{'_treeiterator'}++] || undef;\n}\n\n=head2 rewind_tree\n\n Title   : rewind_tree_iterator\n Usage   : $result->rewind_tree()\n Function: Rewinds the tree iterator so that next_tree can be \n           called again from the beginning\n Returns : none\n Args    : none\n\n\nsub rewind_tree_iterator {\n    shift->{'_treeiterator'} = 0;\n}\n\n=head2 add_tree\n\n Title   : add_tree\n Usage   : $result->add_tree($tree);\n Function: Adds a tree \n Returns : integer which is the number of trees stored\n Args    : L<Bio::Tree::TreeI>\n\n\nsub add_tree{\n   my ($self,$tree) = @_;\n   if( $tree && ref($tree) && $tree->isa('Bio::Tree::TreeI') ) {\n       push @{$self->{'_trees'}},$tree;\n   }\n   return scalar @{$self->{'_trees'}};\n}\n\n=head2 search_space\n\n Title   : search_space\n Usage   : $obj->search_space($newval)\n Function: \n Returns : value of search_space\n Args    : newvalue (optional)","label":"search_space($self,$value)"},"kind":12,"line":347,"children":[{"containerName":"search_space","definition":"my","name":"$self","localvar":"my","kind":13,"line":348},{"kind":13,"line":348,"name":"$value","containerName":"search_space"},{"line":349,"kind":13,"name":"$value","containerName":"search_space"},{"containerName":"search_space","name":"$self","line":350,"kind":13},{"kind":13,"line":350,"name":"$value","containerName":"search_space"},{"containerName":"search_space","name":"$self","line":352,"kind":13}]}]}