{"vars":[{"name":"vars","containerName":"","kind":2,"line":89},{"containerName":"","name":"base","kind":2,"line":98},{"containerName":null,"name":"$SOURCE_TAG","kind":13,"line":99},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>"},"kind":12,"line":112,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":114,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":114},{"line":115,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":115},{"containerName":"new","name":"@args","kind":13,"line":115},{"kind":13,"line":116,"containerName":"new","name":"$self"},{"name":"_initialize_io","containerName":"new","line":116,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":116},{"line":117,"kind":13,"name":"$self","containerName":"new"}],"name":"new","range":{"start":{"character":0,"line":112},"end":{"character":9999,"line":118}}},{"containerName":"new","name":"SUPER","line":115,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None","parameters":[{"label":"$self"}]},"kind":12,"line":134,"children":[{"name":"$self","definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"line":136},{"kind":13,"line":138,"containerName":"next_prediction","definition":"my","name":"$gene","localvar":"my"},{"name":"$transcript","containerName":"next_prediction","kind":13,"line":138},{"kind":13,"line":138,"name":"$current_gene_id","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$transcript_score","definition":"my","localvar":"my","kind":13,"line":139},{"definition":"my","name":"$gene_id","containerName":"next_prediction","localvar":"my","kind":13,"line":141},{"containerName":"next_prediction","name":"$exon_type","kind":13,"line":141},{"name":"$exon_start","containerName":"next_prediction","line":141,"kind":13},{"name":"$exon_end","containerName":"next_prediction","line":141,"kind":13},{"line":141,"kind":13,"name":"$exon_score","containerName":"next_prediction"},{"line":142,"kind":13,"name":"$exon_strand","containerName":"next_prediction"},{"line":142,"kind":13,"containerName":"next_prediction","name":"$start_phase"},{"line":142,"kind":13,"name":"$end_phase","containerName":"next_prediction"},{"name":"$start_sig_score","containerName":"next_prediction","kind":13,"line":142},{"name":"$end_sig_score","containerName":"next_prediction","kind":13,"line":143},{"name":"$coding_pot_score","containerName":"next_prediction","line":143,"kind":13},{"name":"$homol_score","containerName":"next_prediction","line":143,"kind":13},{"name":"$self","containerName":"next_prediction","kind":13,"line":145},{"containerName":"next_prediction","name":"_readline","kind":12,"line":145},{"name":"$self","containerName":"next_prediction","line":147,"kind":13},{"containerName":"next_prediction","name":"debug","kind":12,"line":147},{"line":164,"kind":13,"localvar":"my","definition":"my","name":"$target_id","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":165},{"kind":12,"line":165,"containerName":"next_prediction","name":"_target_id"},{"kind":13,"line":165,"containerName":"next_prediction","name":"$target_id"},{"localvar":"my","containerName":"next_prediction","name":"@fields","definition":"my","line":171,"kind":13},{"line":175,"kind":13,"name":"$gene_id","containerName":"next_prediction"},{"kind":13,"line":175,"name":"@fields","containerName":"next_prediction"},{"line":177,"kind":13,"name":"$exon_type","containerName":"next_prediction"},{"name":"$exon_start","containerName":"next_prediction","kind":13,"line":177},{"containerName":"next_prediction","name":"$exon_end","line":177,"kind":13},{"containerName":"next_prediction","name":"$exon_score","line":177,"kind":13},{"line":178,"kind":13,"containerName":"next_prediction","name":"$exon_strand"},{"name":"$start_phase","containerName":"next_prediction","line":178,"kind":13},{"kind":13,"line":178,"name":"$end_phase","containerName":"next_prediction"},{"kind":13,"line":178,"containerName":"next_prediction","name":"$start_sig_score"},{"line":179,"kind":13,"containerName":"next_prediction","name":"$end_sig_score"},{"line":179,"kind":13,"containerName":"next_prediction","name":"$coding_pot_score"},{"line":179,"kind":13,"containerName":"next_prediction","name":"$homol_score"},{"containerName":"next_prediction","name":"@fields","kind":13,"line":179},{"kind":13,"line":181,"containerName":"next_prediction","name":"$current_gene_id"},{"name":"$current_gene_id","containerName":"next_prediction","kind":13,"line":184},{"line":184,"kind":13,"name":"$gene_id","containerName":"next_prediction"},{"name":"$transcript_score","containerName":"next_prediction","kind":13,"line":185},{"containerName":"next_prediction","name":"$exon_score","line":185,"kind":13},{"line":187,"kind":13,"name":"$gene","containerName":"next_prediction"},{"kind":12,"line":187,"name":"new","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$SOURCE_TAG","line":188,"kind":13},{"kind":13,"line":189,"name":"$transcript","containerName":"next_prediction"},{"name":"new","containerName":"next_prediction","kind":12,"line":189},{"line":190,"kind":13,"name":"$SOURCE_TAG","containerName":"next_prediction"},{"kind":13,"line":192,"containerName":"next_prediction","name":"$self"},{"kind":12,"line":192,"name":"_add_exon","containerName":"next_prediction"},{"kind":13,"line":192,"containerName":"next_prediction","name":"$gene"},{"line":192,"kind":13,"name":"$transcript","containerName":"next_prediction"},{"line":192,"kind":13,"containerName":"next_prediction","name":"$exon_type"},{"name":"$exon_start","containerName":"next_prediction","line":192,"kind":13},{"name":"$exon_end","containerName":"next_prediction","line":192,"kind":13},{"kind":13,"line":192,"containerName":"next_prediction","name":"$exon_score"},{"kind":13,"line":193,"containerName":"next_prediction","name":"$exon_strand"},{"kind":13,"line":193,"name":"$start_phase","containerName":"next_prediction"},{"kind":13,"line":193,"containerName":"next_prediction","name":"$end_phase"},{"containerName":"next_prediction","name":"$start_sig_score","kind":13,"line":193},{"kind":13,"line":194,"containerName":"next_prediction","name":"$end_sig_score"},{"kind":13,"line":194,"name":"$coding_pot_score","containerName":"next_prediction"},{"line":194,"kind":13,"containerName":"next_prediction","name":"$homol_score"},{"name":"$gene_id","containerName":"next_prediction","line":196,"kind":13},{"name":"$current_gene_id","containerName":"next_prediction","line":196,"kind":13},{"kind":13,"line":199,"name":"$transcript_score","containerName":"next_prediction"},{"name":"$exon_score","containerName":"next_prediction","line":199,"kind":13},{"line":201,"kind":13,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":201,"containerName":"next_prediction","name":"_add_exon"},{"line":201,"kind":13,"name":"$gene","containerName":"next_prediction"},{"name":"$transcript","containerName":"next_prediction","line":201,"kind":13},{"kind":13,"line":201,"containerName":"next_prediction","name":"$exon_type"},{"containerName":"next_prediction","name":"$exon_start","line":201,"kind":13},{"name":"$exon_end","containerName":"next_prediction","kind":13,"line":201},{"line":201,"kind":13,"name":"$exon_score","containerName":"next_prediction"},{"line":202,"kind":13,"name":"$exon_strand","containerName":"next_prediction"},{"kind":13,"line":202,"name":"$start_phase","containerName":"next_prediction"},{"name":"$end_phase","containerName":"next_prediction","kind":13,"line":202},{"line":202,"kind":13,"containerName":"next_prediction","name":"$start_sig_score"},{"name":"$end_sig_score","containerName":"next_prediction","line":203,"kind":13},{"containerName":"next_prediction","name":"$coding_pot_score","kind":13,"line":203},{"line":203,"kind":13,"name":"$homol_score","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","line":208,"kind":13},{"name":"_pushback","containerName":"next_prediction","line":208,"kind":12},{"containerName":"next_prediction","name":"$gene","kind":13,"line":213},{"kind":13,"line":215,"containerName":"next_prediction","name":"$transcript"},{"line":215,"kind":12,"containerName":"next_prediction","name":"seq_id"},{"containerName":"next_prediction","name":"$self","line":215,"kind":13},{"containerName":"next_prediction","name":"_target_id","kind":12,"line":215},{"kind":13,"line":216,"name":"$transcript","containerName":"next_prediction"},{"name":"score","containerName":"next_prediction","kind":12,"line":216},{"name":"$transcript_score","containerName":"next_prediction","kind":13,"line":216},{"containerName":"next_prediction","name":"$gene","line":217,"kind":13},{"name":"add_transcript","containerName":"next_prediction","line":217,"kind":12},{"line":217,"kind":13,"containerName":"next_prediction","name":"$transcript"},{"line":218,"kind":13,"containerName":"next_prediction","name":"$gene"},{"line":218,"kind":12,"containerName":"next_prediction","name":"seq_id"},{"kind":13,"line":218,"containerName":"next_prediction","name":"$self"},{"line":218,"kind":12,"containerName":"next_prediction","name":"_target_id"},{"localvar":"my","containerName":"next_prediction","name":"$exon","definition":"my","line":220,"kind":13},{"line":220,"kind":13,"name":"$gene","containerName":"next_prediction"},{"kind":12,"line":220,"containerName":"next_prediction","name":"exons"},{"name":"$exon","containerName":"next_prediction","kind":13,"line":222},{"line":222,"kind":12,"containerName":"next_prediction","name":"seq_id"},{"name":"$self","containerName":"next_prediction","line":222,"kind":13},{"containerName":"next_prediction","name":"_target_id","line":222,"kind":12},{"name":"$self","containerName":"next_prediction","kind":13,"line":225},{"name":"_set_strand","containerName":"next_prediction","kind":12,"line":225},{"kind":13,"line":225,"name":"$gene","containerName":"next_prediction"},{"line":228,"kind":13,"name":"$gene","containerName":"next_prediction"}],"name":"next_prediction","range":{"start":{"line":134,"character":0},"end":{"character":9999,"line":229}}},{"kind":12,"line":187,"name":"Bio","containerName":"SeqFeature::Gene::GeneStructure"},{"containerName":"SeqFeature::Gene::Transcript","name":"Bio","line":189,"kind":12},{"line":242,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_add_exon","line":244,"kind":13},{"name":"$gene","containerName":"_add_exon","kind":13,"line":244},{"name":"$transcript","containerName":"_add_exon","line":244,"kind":13},{"kind":13,"line":244,"name":"$exon_type","containerName":"_add_exon"},{"containerName":"_add_exon","name":"$exon_start","line":244,"kind":13},{"kind":13,"line":244,"name":"$exon_end","containerName":"_add_exon"},{"name":"$exon_score","containerName":"_add_exon","line":245,"kind":13},{"name":"$exon_strand","containerName":"_add_exon","kind":13,"line":245},{"line":245,"kind":13,"name":"$start_phase","containerName":"_add_exon"},{"containerName":"_add_exon","name":"$end_phase","kind":13,"line":245},{"containerName":"_add_exon","name":"$start_sig_score","line":245,"kind":13},{"line":246,"kind":13,"containerName":"_add_exon","name":"$end_sig_score"},{"containerName":"_add_exon","name":"$coding_pot_score","kind":13,"line":246},{"line":246,"kind":13,"name":"$homol_score","containerName":"_add_exon"},{"name":"$exon_type","containerName":"_add_exon","kind":13,"line":248},{"line":250,"kind":13,"localvar":"my","containerName":"_add_exon","name":"$strand","definition":"my"},{"kind":13,"line":250,"containerName":"_add_exon","name":"$exon_strand"},{"line":252,"kind":13,"localvar":"my","containerName":"_add_exon","definition":"my","name":"$exon"},{"line":252,"kind":12,"name":"new","containerName":"_add_exon"},{"name":"$SOURCE_TAG","containerName":"_add_exon","kind":13,"line":252},{"kind":13,"line":253,"containerName":"_add_exon","name":"$exon_start"},{"kind":13,"line":254,"containerName":"_add_exon","name":"$exon_end"},{"containerName":"_add_exon","name":"$strand","kind":13,"line":255},{"kind":13,"line":256,"name":"$exon_score","containerName":"_add_exon"},{"line":257,"kind":13,"name":"$exon","containerName":"_add_exon"},{"name":"is_coding","containerName":"_add_exon","line":257,"kind":12},{"containerName":"_add_exon","name":"$exon","line":258,"kind":13},{"kind":12,"line":258,"name":"add_tag_value","containerName":"_add_exon"},{"line":258,"kind":13,"containerName":"_add_exon","name":"$exon_type"},{"name":"$exon","containerName":"_add_exon","kind":13,"line":259},{"containerName":"_add_exon","name":"add_tag_value","kind":12,"line":259},{"kind":13,"line":259,"name":"$start_phase","containerName":"_add_exon"},{"kind":13,"line":260,"name":"$exon","containerName":"_add_exon"},{"containerName":"_add_exon","name":"add_tag_value","line":260,"kind":12},{"kind":13,"line":260,"name":"$end_phase","containerName":"_add_exon"},{"kind":13,"line":261,"name":"$exon","containerName":"_add_exon"},{"containerName":"_add_exon","name":"add_tag_value","line":261,"kind":12},{"name":"$start_sig_score","containerName":"_add_exon","kind":13,"line":261},{"containerName":"_add_exon","name":"$exon","line":262,"kind":13},{"kind":12,"line":262,"name":"add_tag_value","containerName":"_add_exon"},{"name":"$end_sig_score","containerName":"_add_exon","line":262,"kind":13},{"containerName":"_add_exon","name":"$exon","kind":13,"line":263},{"name":"add_tag_value","containerName":"_add_exon","line":263,"kind":12},{"line":263,"kind":13,"containerName":"_add_exon","name":"$coding_pot_score"},{"line":264,"kind":13,"containerName":"_add_exon","name":"$exon"},{"kind":12,"line":264,"containerName":"_add_exon","name":"add_tag_value"},{"kind":13,"line":264,"name":"$homol_score","containerName":"_add_exon"},{"containerName":"_add_exon","name":"$transcript","kind":13,"line":266},{"name":"strand","containerName":"_add_exon","line":266,"kind":12},{"line":266,"kind":13,"name":"$strand","containerName":"_add_exon"},{"containerName":"_add_exon","name":"$transcript","kind":13,"line":266},{"line":266,"kind":12,"name":"strand","containerName":"_add_exon"},{"containerName":"_add_exon","name":"$transcript","kind":13,"line":267},{"line":267,"kind":12,"name":"add_exon","containerName":"_add_exon"},{"name":"$exon","containerName":"_add_exon","line":267,"kind":13},{"containerName":"_add_exon","name":"$exon_type","line":267,"kind":13}],"kind":12,"detail":"($self,$gene,$transcript,$exon_type,$exon_start,$exon_end,$exon_score,$exon_strand,$start_phase,$end_phase,$start_sig_score,$end_sig_score,$coding_pot_score,$homol_score)","signature":{"parameters":[{"label":"$self"},{"label":"$gene"},{"label":"$transcript"},{"label":"$exon_type"},{"label":"$exon_start"},{"label":"$exon_end"},{"label":"$exon_score"},{"label":"$exon_strand"},{"label":"$start_phase"},{"label":"$end_phase"},{"label":"$start_sig_score"},{"label":"$end_sig_score"},{"label":"$coding_pot_score"},{"label":"$homol_score"}],"documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None\n\n\nsub next_prediction\n{\n    my ($self) = @_;\n\n    my ($gene, $transcript, $current_gene_id);\n    my $transcript_score = 0;\n\n    my ($gene_id, $exon_type, $exon_start, $exon_end, $exon_score,\n        $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score);\n\n    while (defined($_ = $self->_readline))\n    {\n        $self->debug($_);\n\n        s/^\\s+//;\n        s/\\s+$//;\n\n        # We have a choice of geneid, gff or XML formats. The native\n        # geneid format has more information than gff. However, we\n        # then need to perform the hack of extracting the sequence ID\n        # from the header of the embedded Fasta file which comes after\n        # the exon data, as it is not stored elsewhere. Ack.\n        # the new version of geneID includes the sequence ID in a slightly\n        # different format and a new \"or\" statement was added below\n        # also removed \"unless defined $self->_target_id;\" inorder to continue\n        # generating new sequence IDs.\n        \n        if (/^>(\\S+)\\|GeneId/ or /^# Sequence (\\S+)/)\n        {\n            my $target_id = $1;\n            $self->_target_id($target_id);\n            next;\n        }\n\n        next unless (/(Single|First|Internal|Terminal)/);\n\n        my @fields = split(/\\s+/, $_);\n\n        # Grab gene_id from eol first as there are issues with\n        # inconsistent whitespace in the AA coords field\n        $gene_id = pop @fields;\n\n        ($exon_type, $exon_start, $exon_end, $exon_score,\n         $exon_strand, $start_phase, $end_phase, $start_sig_score,\n         $end_sig_score, $coding_pot_score, $homol_score) = @fields[0..10];\n\n        if (! defined $current_gene_id)\n        {\n            # Starting the requested prediction\n            $current_gene_id = $gene_id;\n            $transcript_score = $exon_score;\n\n            $gene = Bio::SeqFeature::Gene::GeneStructure->new(-source =>\n                                                              $SOURCE_TAG);\n            $transcript = Bio::SeqFeature::Gene::Transcript->new(-source =>\n                                                                 $SOURCE_TAG);\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        elsif ($gene_id eq $current_gene_id)\n        {\n            # Still in requested prediction\n            $transcript_score += $exon_score;\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        else\n        {\n            # Found following prediction\n            $self->_pushback($_);\n            last;\n        }\n    }\n\n    if (defined $gene)\n    {\n        $transcript->seq_id($self->_target_id);\n        $transcript->score($transcript_score);\n        $gene->add_transcript($transcript);\n        $gene->seq_id($self->_target_id);\n\n        foreach my $exon ($gene->exons)\n        {\n            $exon->seq_id($self->_target_id);\n        }\n\n        $self->_set_strand($gene);\n    }\n\n    return $gene;\n}\n\n=head2 _add_exon\n\n Title   : _add_exon\n Usage   : $obj->_add_exon($gene, $transcript, ... exon data ...)\n Function: Adds a new exon to both gene and transcript from the data\n         : supplied as args\n Example :\n Returns : Nothing","label":"_add_exon($self,$gene,$transcript,$exon_type,$exon_start,$exon_end,$exon_score,$exon_strand,$start_phase,$end_phase,$start_sig_score,$end_sig_score,$coding_pot_score,$homol_score)"},"containerName":"main::","definition":"sub","range":{"end":{"line":268,"character":9999},"start":{"character":0,"line":242}},"name":"_add_exon"},{"containerName":"SeqFeature::Gene::Exon","name":"Bio","kind":12,"line":252},{"name":"_set_strand","range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":282}},"containerName":"main::","definition":"sub","detail":"($self,$gene)","signature":{"label":"_set_strand($self,$gene)","parameters":[{"label":"$self"},{"label":"$gene"}],"documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None\n\n\nsub next_prediction\n{\n    my ($self) = @_;\n\n    my ($gene, $transcript, $current_gene_id);\n    my $transcript_score = 0;\n\n    my ($gene_id, $exon_type, $exon_start, $exon_end, $exon_score,\n        $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score);\n\n    while (defined($_ = $self->_readline))\n    {\n        $self->debug($_);\n\n        s/^\\s+//;\n        s/\\s+$//;\n\n        # We have a choice of geneid, gff or XML formats. The native\n        # geneid format has more information than gff. However, we\n        # then need to perform the hack of extracting the sequence ID\n        # from the header of the embedded Fasta file which comes after\n        # the exon data, as it is not stored elsewhere. Ack.\n        # the new version of geneID includes the sequence ID in a slightly\n        # different format and a new \"or\" statement was added below\n        # also removed \"unless defined $self->_target_id;\" inorder to continue\n        # generating new sequence IDs.\n        \n        if (/^>(\\S+)\\|GeneId/ or /^# Sequence (\\S+)/)\n        {\n            my $target_id = $1;\n            $self->_target_id($target_id);\n            next;\n        }\n\n        next unless (/(Single|First|Internal|Terminal)/);\n\n        my @fields = split(/\\s+/, $_);\n\n        # Grab gene_id from eol first as there are issues with\n        # inconsistent whitespace in the AA coords field\n        $gene_id = pop @fields;\n\n        ($exon_type, $exon_start, $exon_end, $exon_score,\n         $exon_strand, $start_phase, $end_phase, $start_sig_score,\n         $end_sig_score, $coding_pot_score, $homol_score) = @fields[0..10];\n\n        if (! defined $current_gene_id)\n        {\n            # Starting the requested prediction\n            $current_gene_id = $gene_id;\n            $transcript_score = $exon_score;\n\n            $gene = Bio::SeqFeature::Gene::GeneStructure->new(-source =>\n                                                              $SOURCE_TAG);\n            $transcript = Bio::SeqFeature::Gene::Transcript->new(-source =>\n                                                                 $SOURCE_TAG);\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        elsif ($gene_id eq $current_gene_id)\n        {\n            # Still in requested prediction\n            $transcript_score += $exon_score;\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        else\n        {\n            # Found following prediction\n            $self->_pushback($_);\n            last;\n        }\n    }\n\n    if (defined $gene)\n    {\n        $transcript->seq_id($self->_target_id);\n        $transcript->score($transcript_score);\n        $gene->add_transcript($transcript);\n        $gene->seq_id($self->_target_id);\n\n        foreach my $exon ($gene->exons)\n        {\n            $exon->seq_id($self->_target_id);\n        }\n\n        $self->_set_strand($gene);\n    }\n\n    return $gene;\n}\n\n=head2 _add_exon\n\n Title   : _add_exon\n Usage   : $obj->_add_exon($gene, $transcript, ... exon data ...)\n Function: Adds a new exon to both gene and transcript from the data\n         : supplied as args\n Example :\n Returns : Nothing\n\n\nsub _add_exon\n{\n    my ($self, $gene, $transcript, $exon_type, $exon_start, $exon_end,\n        $exon_score, $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score) = @_;\n\n    $exon_type =~ s/First/Initial/;\n\n    my $strand = $exon_strand eq '+' ? 1 : -1;\n\n    my $exon = Bio::SeqFeature::Gene::Exon->new(-source => $SOURCE_TAG,\n                                                -start  => $exon_start,\n                                                -end    => $exon_end,\n                                                -strand => $strand,\n                                                -score  => $exon_score);\n    $exon->is_coding(1);\n    $exon->add_tag_value(\"Type\", $exon_type);\n    $exon->add_tag_value('phase', $start_phase);\n    $exon->add_tag_value('end_phase', $end_phase);\n    $exon->add_tag_value('start_signal_score', $start_sig_score);\n    $exon->add_tag_value('end_signal_score', $end_sig_score);\n    $exon->add_tag_value('coding_potential_score', $coding_pot_score);\n    $exon->add_tag_value('homology_score', $homol_score);\n\n    $transcript->strand($strand) unless $transcript->strand != 0;\n    $transcript->add_exon($exon, $exon_type);\n}\n\n=head2 _set_strand\n\n Title   : _set_strand\n Usage   : $obj->_set_strand($gene)\n Function: Sets the overall gene strand to the same strand as all\n         : the exons if they are all on the same strand, or to strand 0\n         : if the exons are on different strands.\n Example :\n Returns : Nothing"},"kind":12,"line":282,"children":[{"containerName":"_set_strand","definition":"my","name":"$self","localvar":"my","kind":13,"line":284},{"name":"$gene","containerName":"_set_strand","line":284,"kind":13},{"containerName":"_set_strand","definition":"my","name":"$fwd","localvar":"my","kind":13,"line":286},{"localvar":"my","containerName":"_set_strand","definition":"my","name":"$rev","line":287,"kind":13},{"definition":"my","name":"@exons","containerName":"_set_strand","localvar":"my","kind":13,"line":289},{"kind":13,"line":289,"name":"$gene","containerName":"_set_strand"},{"containerName":"_set_strand","name":"exons","line":289,"kind":12},{"definition":"my","name":"$exon","containerName":"_set_strand","localvar":"my","kind":13,"line":290},{"line":290,"kind":13,"name":"@exons","containerName":"_set_strand"},{"line":292,"kind":13,"localvar":"my","containerName":"_set_strand","name":"$strand","definition":"my"},{"line":292,"kind":13,"name":"$exon","containerName":"_set_strand"},{"line":292,"kind":12,"containerName":"_set_strand","name":"strand"},{"kind":13,"line":294,"containerName":"_set_strand","name":"$strand"},{"kind":13,"line":296,"containerName":"_set_strand","name":"$fwd"},{"kind":13,"line":298,"name":"$strand","containerName":"_set_strand"},{"kind":13,"line":300,"containerName":"_set_strand","name":"$rev"},{"containerName":"_set_strand","name":"$fwd","kind":13,"line":304},{"name":"$gene","containerName":"_set_strand","kind":13,"line":306},{"line":306,"kind":12,"containerName":"_set_strand","name":"strand"},{"name":"$rev","containerName":"_set_strand","kind":13,"line":308},{"name":"$gene","containerName":"_set_strand","line":310,"kind":13},{"line":310,"kind":12,"name":"strand","containerName":"_set_strand"},{"kind":13,"line":314,"name":"$gene","containerName":"_set_strand"},{"kind":12,"line":314,"containerName":"_set_strand","name":"strand"},{"kind":13,"line":317,"name":"$gene","containerName":"_set_strand"}]},{"name":"exons","kind":12,"line":304},{"name":"exons","line":308,"kind":12},{"range":{"end":{"line":339,"character":9999},"start":{"character":0,"line":330}},"name":"_target_id","detail":"($self,$val)","signature":{"label":"_target_id($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None\n\n\nsub next_prediction\n{\n    my ($self) = @_;\n\n    my ($gene, $transcript, $current_gene_id);\n    my $transcript_score = 0;\n\n    my ($gene_id, $exon_type, $exon_start, $exon_end, $exon_score,\n        $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score);\n\n    while (defined($_ = $self->_readline))\n    {\n        $self->debug($_);\n\n        s/^\\s+//;\n        s/\\s+$//;\n\n        # We have a choice of geneid, gff or XML formats. The native\n        # geneid format has more information than gff. However, we\n        # then need to perform the hack of extracting the sequence ID\n        # from the header of the embedded Fasta file which comes after\n        # the exon data, as it is not stored elsewhere. Ack.\n        # the new version of geneID includes the sequence ID in a slightly\n        # different format and a new \"or\" statement was added below\n        # also removed \"unless defined $self->_target_id;\" inorder to continue\n        # generating new sequence IDs.\n        \n        if (/^>(\\S+)\\|GeneId/ or /^# Sequence (\\S+)/)\n        {\n            my $target_id = $1;\n            $self->_target_id($target_id);\n            next;\n        }\n\n        next unless (/(Single|First|Internal|Terminal)/);\n\n        my @fields = split(/\\s+/, $_);\n\n        # Grab gene_id from eol first as there are issues with\n        # inconsistent whitespace in the AA coords field\n        $gene_id = pop @fields;\n\n        ($exon_type, $exon_start, $exon_end, $exon_score,\n         $exon_strand, $start_phase, $end_phase, $start_sig_score,\n         $end_sig_score, $coding_pot_score, $homol_score) = @fields[0..10];\n\n        if (! defined $current_gene_id)\n        {\n            # Starting the requested prediction\n            $current_gene_id = $gene_id;\n            $transcript_score = $exon_score;\n\n            $gene = Bio::SeqFeature::Gene::GeneStructure->new(-source =>\n                                                              $SOURCE_TAG);\n            $transcript = Bio::SeqFeature::Gene::Transcript->new(-source =>\n                                                                 $SOURCE_TAG);\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        elsif ($gene_id eq $current_gene_id)\n        {\n            # Still in requested prediction\n            $transcript_score += $exon_score;\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        else\n        {\n            # Found following prediction\n            $self->_pushback($_);\n            last;\n        }\n    }\n\n    if (defined $gene)\n    {\n        $transcript->seq_id($self->_target_id);\n        $transcript->score($transcript_score);\n        $gene->add_transcript($transcript);\n        $gene->seq_id($self->_target_id);\n\n        foreach my $exon ($gene->exons)\n        {\n            $exon->seq_id($self->_target_id);\n        }\n\n        $self->_set_strand($gene);\n    }\n\n    return $gene;\n}\n\n=head2 _add_exon\n\n Title   : _add_exon\n Usage   : $obj->_add_exon($gene, $transcript, ... exon data ...)\n Function: Adds a new exon to both gene and transcript from the data\n         : supplied as args\n Example :\n Returns : Nothing\n\n\nsub _add_exon\n{\n    my ($self, $gene, $transcript, $exon_type, $exon_start, $exon_end,\n        $exon_score, $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score) = @_;\n\n    $exon_type =~ s/First/Initial/;\n\n    my $strand = $exon_strand eq '+' ? 1 : -1;\n\n    my $exon = Bio::SeqFeature::Gene::Exon->new(-source => $SOURCE_TAG,\n                                                -start  => $exon_start,\n                                                -end    => $exon_end,\n                                                -strand => $strand,\n                                                -score  => $exon_score);\n    $exon->is_coding(1);\n    $exon->add_tag_value(\"Type\", $exon_type);\n    $exon->add_tag_value('phase', $start_phase);\n    $exon->add_tag_value('end_phase', $end_phase);\n    $exon->add_tag_value('start_signal_score', $start_sig_score);\n    $exon->add_tag_value('end_signal_score', $end_sig_score);\n    $exon->add_tag_value('coding_potential_score', $coding_pot_score);\n    $exon->add_tag_value('homology_score', $homol_score);\n\n    $transcript->strand($strand) unless $transcript->strand != 0;\n    $transcript->add_exon($exon, $exon_type);\n}\n\n=head2 _set_strand\n\n Title   : _set_strand\n Usage   : $obj->_set_strand($gene)\n Function: Sets the overall gene strand to the same strand as all\n         : the exons if they are all on the same strand, or to strand 0\n         : if the exons are on different strands.\n Example :\n Returns : Nothing\n\n\nsub _set_strand\n{\n    my ($self, $gene) = @_;\n\n    my $fwd = 0;\n    my $rev = 0;\n\n    my @exons = $gene->exons;\n    foreach my $exon (@exons)\n    {\n        my $strand = $exon->strand;\n\n        if ($strand == 1)\n        {\n            $fwd++;\n        }\n        elsif ($strand == -1)\n        {\n            $rev++;\n        }\n    }\n\n    if ($#exons == $fwd)\n    {\n        $gene->strand(1);\n    }\n    elsif ($#exons == $rev)\n    {\n        $gene->strand(-1);\n    }\n    else\n    {\n        $gene->strand(0);\n    }\n\n    return $gene;\n}\n\n=head2 _target_id\n\n Title   : _target_id\n Usage   : $obj->_target_id\n Function: get/set for genomic sequence id\n Example :\n Returns : A target ID"},"containerName":"main::","definition":"sub","line":330,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_target_id","line":332,"kind":13},{"kind":13,"line":332,"containerName":"_target_id","name":"$val"},{"line":333,"kind":13,"name":"$val","containerName":"_target_id"},{"name":"$self","containerName":"_target_id","line":335,"kind":13},{"containerName":"_target_id","name":"$val","kind":13,"line":335},{"kind":13,"line":338,"containerName":"_target_id","name":"$self"}],"kind":12}],"version":5}