{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":108},{"name":"new","range":{"end":{"character":9999,"line":129},"start":{"character":0,"line":120}},"kind":12,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":121},{"kind":13,"line":121,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":122},{"containerName":"new","name":"$class","kind":13,"line":122},{"line":122,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":123,"definition":"my","name":"$type","containerName":"new","localvar":"my"},{"line":123,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":123,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","line":123,"kind":13},{"line":124,"kind":13,"name":"$type","containerName":"new"},{"name":"$self","containerName":"new","line":125,"kind":13},{"kind":12,"line":125,"containerName":"new","name":"datatype"},{"kind":13,"line":125,"containerName":"new","name":"$type"},{"line":126,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":126,"name":"eutil","containerName":"new"},{"kind":13,"line":127,"name":"$self","containerName":"new"},{"name":"rewind","containerName":"new","kind":12,"line":127},{"kind":13,"line":128,"containerName":"new","name":"$self"}],"line":120,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : ","label":"new($class,@args)"},"detail":"($class,@args)"},{"name":"SUPER","containerName":"new","kind":12,"line":122},{"line":144,"children":[{"kind":13,"line":145,"name":"$self","definition":"my","containerName":"get_ids","localvar":"my"},{"containerName":"get_ids","name":"$self","line":146,"kind":13}],"kind":12,"range":{"start":{"line":144,"character":0},"end":{"line":147,"character":9999}},"containerName":"main::","definition":"sub","name":"get_ids"},{"name":"get_id","definition":"sub","containerName":"main::","range":{"end":{"line":162,"character":9999},"start":{"character":0,"line":159}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"get_id","localvar":"my","kind":13,"line":160},{"name":"$self","containerName":"get_id","line":161,"kind":13}],"line":159},{"containerName":"main::","name":"next_ListItem","definition":"sub","range":{"start":{"character":0,"line":174},"end":{"character":9999,"line":183}},"kind":12,"line":174,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_ListItem","line":175,"kind":13},{"line":176,"kind":13,"name":"$self","containerName":"next_ListItem"},{"line":177,"kind":13,"localvar":"my","definition":"my","name":"@lists","containerName":"next_ListItem"},{"containerName":"next_ListItem","name":"$self","kind":13,"line":177},{"line":177,"kind":12,"containerName":"next_ListItem","name":"get_ListItems"},{"name":"$self","containerName":"next_ListItem","line":179,"kind":13},{"name":"$self","containerName":"next_ListItem","kind":13,"line":179},{"line":180,"kind":13,"name":"$self","containerName":"next_ListItem"},{"kind":13,"line":180,"containerName":"next_ListItem","name":"@lists"},{"kind":13,"line":182,"name":"$self","containerName":"next_ListItem"}]},{"range":{"start":{"character":0,"line":195},"end":{"line":199,"character":9999}},"name":"get_ListItems","definition":"sub","containerName":"main::","children":[{"line":196,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_ListItems"},{"line":197,"kind":13,"localvar":"my","containerName":"get_ListItems","definition":"my","name":"@items"},{"name":"$self","containerName":"get_ListItems","kind":13,"line":197},{"name":"get_type","containerName":"get_ListItems","kind":12,"line":197},{"line":197,"kind":13,"name":"$self","containerName":"get_ListItems"},{"containerName":"get_ListItems","name":"get_subItems","line":197,"kind":12},{"kind":13,"line":198,"name":"@items","containerName":"get_ListItems"}],"line":195,"kind":12},{"children":[{"definition":"my","name":"$self","containerName":"next_StructureItem","localvar":"my","kind":13,"line":212},{"name":"$self","containerName":"next_StructureItem","kind":13,"line":213},{"name":"@structs","definition":"my","containerName":"next_StructureItem","localvar":"my","kind":13,"line":214},{"containerName":"next_StructureItem","name":"$self","kind":13,"line":214},{"containerName":"next_StructureItem","name":"get_StructureItems","kind":12,"line":214},{"kind":13,"line":215,"containerName":"next_StructureItem","name":"$self"},{"kind":13,"line":215,"name":"@structs","containerName":"next_StructureItem"},{"name":"$self","containerName":"next_StructureItem","line":217,"kind":13}],"line":211,"kind":12,"range":{"end":{"character":9999,"line":218},"start":{"character":0,"line":211}},"name":"next_StructureItem","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"line":231,"kind":13,"localvar":"my","containerName":"get_StructureItems","definition":"my","name":"$self"},{"localvar":"my","containerName":"get_StructureItems","definition":"my","name":"@items","line":232,"kind":13},{"containerName":"get_StructureItems","name":"$self","kind":13,"line":232},{"name":"get_type","containerName":"get_StructureItems","kind":12,"line":232},{"line":232,"kind":13,"containerName":"get_StructureItems","name":"$self"},{"name":"get_subItems","containerName":"get_StructureItems","line":232,"kind":12},{"kind":13,"line":233,"containerName":"get_StructureItems","name":"@items"}],"line":230,"definition":"sub","name":"get_StructureItems","containerName":"main::","range":{"start":{"character":0,"line":230},"end":{"character":9999,"line":234}}},{"line":248,"children":[{"kind":13,"line":249,"containerName":"next_subItem","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"next_subItem","kind":13,"line":250},{"definition":"my","name":"@structs","containerName":"next_subItem","localvar":"my","kind":13,"line":251},{"kind":13,"line":251,"name":"$self","containerName":"next_subItem"},{"containerName":"next_subItem","name":"get_subItems","line":251,"kind":12},{"name":"$self","containerName":"next_subItem","line":252,"kind":13},{"kind":13,"line":252,"containerName":"next_subItem","name":"@structs"},{"line":254,"kind":13,"name":"$self","containerName":"next_subItem"}],"kind":12,"range":{"end":{"line":255,"character":9999},"start":{"line":248,"character":0}},"containerName":"main::","name":"next_subItem","definition":"sub"},{"kind":12,"children":[{"line":270,"kind":13,"localvar":"my","containerName":"get_subItems","name":"$self","definition":"my"},{"line":271,"kind":13,"name":"$self","containerName":"get_subItems"},{"name":"$self","containerName":"get_subItems","kind":13,"line":271}],"line":269,"name":"get_subItems","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":269},"end":{"line":271,"character":9999}}},{"range":{"start":{"character":0,"line":284},"end":{"character":9999,"line":287}},"definition":"sub","name":"get_name","containerName":"main::","children":[{"containerName":"get_name","definition":"my","name":"$self","localvar":"my","kind":13,"line":285},{"line":286,"kind":13,"name":"$self","containerName":"get_name"}],"line":284,"kind":12},{"name":"get_type","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":301},"end":{"character":9999,"line":304}},"kind":12,"children":[{"line":302,"kind":13,"localvar":"my","containerName":"get_type","definition":"my","name":"$self"},{"containerName":"get_type","name":"$self","line":303,"kind":13}],"line":301},{"name":"get_content","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":316},"end":{"character":9999,"line":319}},"kind":12,"children":[{"kind":13,"line":317,"name":"$self","definition":"my","containerName":"get_content","localvar":"my"},{"containerName":"get_content","name":"$self","kind":13,"line":318}],"line":316},{"line":333,"children":[{"localvar":"my","containerName":"rewind","name":"$self","definition":"my","line":334,"kind":13},{"name":"$request","containerName":"rewind","kind":13,"line":334},{"containerName":"rewind","name":"$request","line":335,"kind":13},{"kind":13,"line":335,"name":"$request","containerName":"rewind"},{"line":336,"kind":12,"name":"rewind","containerName":"rewind"},{"name":"$self","containerName":"rewind","line":336,"kind":13},{"line":336,"kind":12,"name":"get_ListItems","containerName":"rewind"},{"name":"$self","containerName":"rewind","kind":13,"line":338},{"name":"$self","containerName":"rewind","line":338,"kind":13},{"line":339,"kind":13,"name":"$self","containerName":"rewind"},{"kind":13,"line":339,"name":"$self","containerName":"rewind"}],"kind":12,"detail":"($self,$request)","signature":{"label":"rewind($self,$request)","parameters":[{"label":"$self"},{"label":"$request"}],"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":340},"start":{"line":333,"character":0}},"name":"rewind"},{"containerName":"main::","definition":"sub","detail":"($self,$request)","signature":{"label":"next_Item($self,$request)","documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()","parameters":[{"label":"$self"},{"label":"$request"}]},"kind":12,"line":358,"children":[{"kind":13,"line":359,"containerName":"next_Item","name":"$self","definition":"my","localvar":"my"},{"line":359,"kind":13,"containerName":"next_Item","name":"$request"},{"kind":13,"line":360,"containerName":"next_Item","name":"$self"},{"kind":13,"line":362,"definition":"my","name":"@items","containerName":"next_Item","localvar":"my"},{"line":362,"kind":13,"containerName":"next_Item","name":"$request"},{"line":362,"kind":13,"containerName":"next_Item","name":"$request"},{"kind":13,"line":363,"name":"$self","containerName":"next_Item"},{"containerName":"next_Item","name":"get_all_Items","kind":12,"line":363},{"name":"$self","containerName":"next_Item","line":364,"kind":13},{"line":364,"kind":12,"name":"get_Items","containerName":"next_Item"},{"containerName":"next_Item","name":"$self","line":365,"kind":13},{"line":365,"kind":13,"containerName":"next_Item","name":"@items"},{"kind":13,"line":367,"containerName":"next_Item","name":"$self"}],"name":"next_Item","range":{"start":{"line":358,"character":0},"end":{"character":9999,"line":368}}},{"containerName":"main::","definition":"sub","name":"get_Items","range":{"end":{"character":9999,"line":382},"start":{"character":0,"line":380}},"kind":12,"line":380,"children":[{"localvar":"my","containerName":"get_Items","definition":"my","name":"$self","line":381,"kind":13},{"containerName":"get_Items","name":"$self","line":382,"kind":13},{"name":"$self","containerName":"get_Items","kind":13,"line":382}]},{"range":{"start":{"line":407,"character":0},"end":{"line":417,"character":9999}},"definition":"sub","name":"get_all_Items","containerName":"main::","children":[{"line":408,"kind":13,"localvar":"my","containerName":"get_all_Items","definition":"my","name":"$self"},{"containerName":"get_all_Items","name":"$self","line":409,"kind":13},{"name":"$item","definition":"my","containerName":"get_all_Items","localvar":"my","kind":13,"line":410},{"containerName":"get_all_Items","name":"$self","line":410,"kind":13},{"kind":12,"line":410,"containerName":"get_all_Items","name":"get_Items"},{"kind":13,"line":411,"name":"$self","containerName":"get_all_Items"},{"kind":13,"line":411,"name":"$item","containerName":"get_all_Items"},{"kind":13,"line":412,"name":"$ls","definition":"my","containerName":"get_all_Items","localvar":"my"},{"name":"$item","containerName":"get_all_Items","line":412,"kind":13},{"line":412,"kind":12,"name":"get_ListItems","containerName":"get_all_Items"},{"kind":13,"line":413,"name":"$self","containerName":"get_all_Items"},{"line":413,"kind":13,"containerName":"get_all_Items","name":"$ls"},{"line":414,"kind":13,"localvar":"my","containerName":"get_all_Items","definition":"my","name":"$st"},{"containerName":"get_all_Items","name":"$ls","line":414,"kind":13},{"containerName":"get_all_Items","name":"get_StructureItems","line":414,"kind":12},{"line":415,"kind":13,"containerName":"get_all_Items","name":"$self"},{"name":"$st","containerName":"get_all_Items","line":415,"kind":13}],"line":407,"kind":12},{"kind":13,"line":420,"name":"%self","containerName":null},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none","label":"get_all_names($self)"},"containerName":"main::","definition":"sub","line":433,"children":[{"localvar":"my","containerName":"get_all_names","name":"$self","definition":"my","line":434,"kind":13},{"localvar":"my","name":"%tmp","definition":"my","containerName":"get_all_names","line":435,"kind":13},{"containerName":"get_all_names","definition":"my","name":"@data","localvar":"my","kind":13,"line":436},{"containerName":"get_all_names","name":"$tmp","line":436,"kind":13},{"name":"get_name","containerName":"get_all_names","kind":12,"line":437},{"line":437,"kind":13,"name":"$self","containerName":"get_all_names"},{"kind":12,"line":437,"name":"get_all_Items","containerName":"get_all_names"},{"containerName":"get_all_names","name":"@data","kind":13,"line":438}],"kind":12,"range":{"end":{"line":439,"character":9999},"start":{"character":0,"line":433}},"name":"get_all_names"},{"containerName":"main::","definition":"sub","detail":"($self,$key)","signature":{"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)","parameters":[{"label":"$self"},{"label":"$key"}],"label":"get_Items_by_name($self,$key)"},"kind":12,"line":451,"children":[{"containerName":"get_Items_by_name","name":"$self","definition":"my","localvar":"my","kind":13,"line":452},{"name":"$key","containerName":"get_Items_by_name","line":452,"kind":13},{"name":"$key","containerName":"get_Items_by_name","kind":13,"line":453},{"line":454,"kind":13,"localvar":"my","name":"@data","definition":"my","containerName":"get_Items_by_name"},{"name":"get_name","containerName":"get_Items_by_name","line":454,"kind":12},{"containerName":"get_Items_by_name","name":"$key","kind":13,"line":454},{"line":455,"kind":13,"name":"$self","containerName":"get_Items_by_name"},{"containerName":"get_Items_by_name","name":"get_all_Items","line":455,"kind":12},{"kind":13,"line":456,"name":"@data","containerName":"get_Items_by_name"}],"name":"get_Items_by_name","range":{"start":{"character":0,"line":451},"end":{"line":457,"character":9999}}},{"name":"get_contents_by_name","range":{"end":{"line":477,"character":9999},"start":{"line":470,"character":0}},"kind":12,"line":470,"children":[{"localvar":"my","containerName":"get_contents_by_name","definition":"my","name":"$self","line":471,"kind":13},{"name":"$key","containerName":"get_contents_by_name","kind":13,"line":471},{"line":472,"kind":13,"name":"$key","containerName":"get_contents_by_name"},{"localvar":"my","containerName":"get_contents_by_name","name":"@data","definition":"my","line":473,"kind":13},{"name":"get_content","containerName":"get_contents_by_name","kind":12,"line":473},{"name":"get_name","containerName":"get_contents_by_name","kind":12,"line":474},{"line":474,"kind":13,"containerName":"get_contents_by_name","name":"$key"},{"containerName":"get_contents_by_name","name":"$self","line":475,"kind":13},{"name":"get_all_Items","containerName":"get_contents_by_name","line":475,"kind":12},{"kind":13,"line":476,"name":"@data","containerName":"get_contents_by_name"}],"containerName":"main::","definition":"sub","detail":"($self,$key)","signature":{"label":"get_contents_by_name($self,$key)","documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)\n\n\nsub get_Items_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_contents_by_name\n\n Title    : get_contents_by_name\n Usage    : my ($data) = get_contents_by_name('CreateDate')\n Function : Returns content for named Item(s) in DocSum (indicated by\n            passed argument)\n Returns  : array of values (type varies per Item)\n Args     : string (Item name)","parameters":[{"label":"$self"},{"label":"$key"}]}},{"name":"get_type_by_name","range":{"start":{"line":490,"character":0},"end":{"line":495,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$key)","signature":{"label":"get_type_by_name($self,$key)","documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)\n\n\nsub get_Items_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_contents_by_name\n\n Title    : get_contents_by_name\n Usage    : my ($data) = get_contents_by_name('CreateDate')\n Function : Returns content for named Item(s) in DocSum (indicated by\n            passed argument)\n Returns  : array of values (type varies per Item)\n Args     : string (Item name)\n\n\nsub get_contents_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = map {$_->get_content} \n        grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_type_by_name\n\n Title    : get_type_by_name\n Usage    : my $data = get_type_by_name('CreateDate')\n Function : Returns data type for named Item in DocSum (indicated by\n            passed argument)\n Returns  : scalar value (string) if present\n Args     : string (Item name)","parameters":[{"label":"$self"},{"label":"$key"}]},"kind":12,"line":490,"children":[{"definition":"my","name":"$self","containerName":"get_type_by_name","localvar":"my","kind":13,"line":491},{"line":491,"kind":13,"containerName":"get_type_by_name","name":"$key"},{"containerName":"get_type_by_name","name":"$key","kind":13,"line":492},{"localvar":"my","name":"$it","definition":"my","containerName":"get_type_by_name","line":493,"kind":13},{"kind":12,"line":493,"containerName":"get_type_by_name","name":"get_name"},{"line":493,"kind":13,"containerName":"get_type_by_name","name":"$key"},{"name":"$self","containerName":"get_type_by_name","kind":13,"line":493},{"name":"get_all_Items","containerName":"get_type_by_name","kind":12,"line":493},{"line":494,"kind":13,"name":"$it","containerName":"get_type_by_name"},{"line":494,"kind":12,"name":"get_type","containerName":"get_type_by_name"}]},{"range":{"end":{"line":511,"character":9999},"start":{"line":499,"character":0}},"name":"_add_data","detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":" private data method","label":"_add_data($self,$data)"},"containerName":"main::","definition":"sub","line":499,"children":[{"kind":13,"line":500,"name":"$self","definition":"my","containerName":"_add_data","localvar":"my"},{"name":"$data","containerName":"_add_data","kind":13,"line":500},{"kind":13,"line":501,"containerName":"_add_data","name":"$data"},{"localvar":"my","name":"$objtype","definition":"my","containerName":"_add_data","line":502,"kind":13},{"name":"$data","containerName":"_add_data","kind":13,"line":502},{"kind":13,"line":503,"name":"$self","containerName":"_add_data"},{"containerName":"_add_data","name":"$data","line":503,"kind":13},{"line":503,"kind":13,"name":"$data","containerName":"_add_data"},{"localvar":"my","containerName":"_add_data","definition":"my","name":"$sd","line":504,"kind":13},{"name":"$data","containerName":"_add_data","line":504,"kind":13},{"line":505,"kind":13,"containerName":"_add_data","name":"$sd"},{"containerName":"_add_data","name":"$data","line":505,"kind":13},{"line":505,"kind":13,"containerName":"_add_data","name":"$data"},{"kind":13,"line":506,"containerName":"_add_data","name":"$subdoc","definition":"my","localvar":"my"},{"line":506,"kind":12,"containerName":"_add_data","name":"new"},{"containerName":"_add_data","name":"$objtype","kind":13,"line":507},{"line":508,"kind":13,"containerName":"_add_data","name":"$self"},{"containerName":"_add_data","name":"verbose","line":508,"kind":12},{"name":"$subdoc","containerName":"_add_data","line":509,"kind":13},{"line":509,"kind":12,"name":"_add_data","containerName":"_add_data"},{"kind":13,"line":509,"name":"$sd","containerName":"_add_data"},{"name":"$self","containerName":"_add_data","line":510,"kind":13},{"line":510,"kind":13,"name":"$subdoc","containerName":"_add_data"}],"kind":12},{"kind":12,"line":501,"name":"Item"},{"name":"Type","kind":12,"line":502},{"name":"Id","kind":12,"line":503},{"name":"Id","kind":12,"line":503},{"name":"Item","kind":12,"line":504},{"line":505,"kind":12,"name":"Id"},{"name":"Id","kind":12,"line":505},{"name":"Id","line":505,"kind":12},{"kind":12,"line":506,"containerName":"Tools::EUtilities::Summary::Item","name":"Bio"},{"localvar":"my","name":"%nm","definition":"my","containerName":null,"line":513,"kind":13},{"name":"%self","containerName":null,"line":514,"kind":13},{"kind":13,"line":514,"name":"$nm","containerName":null},{"line":514,"kind":13,"containerName":null,"name":"%data"},{"name":"$nm","containerName":null,"kind":13,"line":514},{"containerName":null,"name":"%data","line":514,"kind":13},{"line":514,"kind":13,"name":"$nm","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":516},{"containerName":null,"name":"%data","line":516,"kind":13},{"line":516,"kind":12,"name":"Id"},{"kind":13,"line":516,"name":"%data","containerName":null},{"name":"Id","kind":12,"line":516},{"definition":"sub","name":"to_string","containerName":"main::","range":{"end":{"line":549,"character":9999},"start":{"character":0,"line":533}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"to_string","localvar":"my","kind":13,"line":534},{"kind":13,"line":535,"definition":"my","name":"$level","containerName":"to_string","localvar":"my"},{"line":537,"kind":13,"localvar":"my","containerName":"to_string","name":"$pad","definition":"my"},{"kind":13,"line":537,"containerName":"to_string","name":"$level"},{"line":538,"kind":13,"localvar":"my","definition":"my","name":"$content","containerName":"to_string"},{"containerName":"to_string","name":"$self","line":538,"kind":13},{"kind":12,"line":538,"name":"get_content","containerName":"to_string"},{"kind":13,"line":539,"name":"$string","definition":"my","containerName":"to_string","localvar":"my"},{"line":540,"kind":13,"containerName":"to_string","name":"$level"},{"name":"$pad","containerName":"to_string","line":541,"kind":13},{"name":"$self","containerName":"to_string","line":541,"kind":13},{"line":541,"kind":12,"containerName":"to_string","name":"get_name"},{"containerName":"to_string","name":"$self","line":542,"kind":13},{"name":"_text_wrap","containerName":"to_string","kind":12,"line":542},{"kind":13,"line":543,"name":"$pad","containerName":"to_string"},{"name":"$content","containerName":"to_string","line":544,"kind":13},{"kind":13,"line":545,"name":"$sub","definition":"my","containerName":"to_string","localvar":"my"},{"line":545,"kind":13,"containerName":"to_string","name":"$self"},{"line":545,"kind":12,"name":"get_subItems","containerName":"to_string"},{"containerName":"to_string","name":"$string","line":546,"kind":13},{"line":546,"kind":13,"containerName":"to_string","name":"$sub"},{"kind":12,"line":546,"containerName":"to_string","name":"to_string"},{"containerName":"to_string","name":"$level","kind":13,"line":546},{"kind":13,"line":548,"containerName":"to_string","name":"$string"}],"line":533}]}