{"vars":[{"containerName":"","name":"base","line":96,"kind":2},{"range":{"end":{"line":119,"character":9999},"start":{"line":111,"character":0}},"name":"new","line":111,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":112},{"containerName":"new","name":"@args","line":112,"kind":13},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":113},{"line":113,"kind":13,"name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":113},{"kind":13,"line":114,"containerName":"new","name":"$eutil","definition":"my","localvar":"my"},{"kind":13,"line":114,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","kind":12,"line":114},{"line":114,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":115,"name":"$eutil","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":116},{"containerName":"new","name":"eutil","line":116,"kind":12},{"containerName":"new","name":"$eutil","line":116,"kind":13},{"kind":13,"line":117,"name":"$self","containerName":"new"},{"name":"datatype","containerName":"new","line":117,"kind":12},{"kind":13,"line":118,"containerName":"new","name":"$self"}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: LinkInfo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Info::LinkInfo\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n# \n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Info::LinkInfo - class for storing einfo link data \n\n=head1 SYNOPSIS\n\n    ## should not create instance directly; Bio::Tools::EUtilities does this ##\n\n    # get a LinkInfo object using Bio:Tools::EUtilities    \n    print \"Link name: \",$link->get_link_name,\"\\n\";\n    print \"Link name: \",$link->get_link_menu_name,\"\\n\";\n    print \"Link desc: \",$link->get_link_description,\"\\n\";\n    print \"DBFrom: \",$link->get_dbfrom,\"\\n\"; # database linked from\n    print \"DBTo: \",$link->get_dbto,\"\\n\"; # database linked to\n\n=head1 DESCRIPTION\n\nThis class handles data output (XML) from einfo and elink.\n\neinfo is capable of returning two types of information: 1) a list of all\navailable databases (when called w/o parameters) and 2) information about a\nspecific database. The latter information includes the database description,\nrecord count, and date/time stamp for the last update, among other things. It\nalso includes a list of fields (indices by which record data is stored which can\nbe used in queries) and links (crossrefs between related records in other\ndatabases at NCBI). Data from the latter two are stored in two small subclasses\n(Field and Link) which can be iterated through or retrieved all at once, as\ndemonstrated above. NOTE: Methods described for the Link and Field subclasses\nare unique to those classes (as they retrieve data unique to those data types). \n\nFurther documentation for Link and Field subclass methods is included below.\n\nFor more information on einfo see:\n\n   http://eutils.ncbi.nlm.nih.gov/entrez/query/static/einfo_help.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other Bioperl\nmodules. Send your comments and suggestions preferably to one of the Bioperl\nmailing lists. Your participation is much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track the bugs\nand their resolution. Bug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Info::LinkInfo;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\nuse strict;\nuse warnings;\n\n=head2 new\n\n Title    : new\n Note     : *** should not be called by end-users ***  \n Usage    : my $ct = Bio::Tools::EUtilities::Info::LinkInfo;\n Function : returns new LinkInfo instance\n Returns  : Bio::Tools::EUtilities::Info::LinkInfo instance\n Args     : none (all data added via _add_data, most methods are getters only)","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"name":"warnings","containerName":"","line":112,"kind":2},{"kind":12,"line":113,"containerName":"new","name":"SUPER"},{"line":133,"children":[],"kind":12,"range":{"end":{"line":135,"character":9999},"start":{"line":133,"character":0}},"containerName":"main::","definition":"sub","name":"get_database"},{"range":{"start":{"character":0,"line":141},"end":{"line":143,"character":9999}},"containerName":"main::","name":"get_db","definition":"sub","line":141,"children":[{"kind":12,"line":142,"containerName":"get_db","name":"get_database"}],"kind":12},{"line":149,"children":[{"name":"get_database","containerName":"get_dbto","kind":12,"line":150}],"kind":12,"range":{"end":{"line":151,"character":9999},"start":{"character":0,"line":149}},"containerName":"main::","definition":"sub","name":"get_dbto"},{"name":"get_dbfrom","definition":"sub","containerName":"main::","range":{"start":{"line":164,"character":0},"end":{"line":164,"character":9999}},"kind":12,"children":[],"line":164},{"name":"get_link_name","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":183},"start":{"line":176,"character":0}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_link_name","line":177,"kind":13},{"name":"$self","containerName":"get_link_name","kind":13,"line":178},{"kind":12,"line":178,"containerName":"get_link_name","name":"eutil"},{"containerName":"get_link_name","name":"$self","kind":13,"line":179},{"line":181,"kind":13,"name":"$self","containerName":"get_link_name"}],"line":176},{"kind":12,"line":195,"children":[],"containerName":"main::","definition":"sub","name":"get_link_description","range":{"end":{"line":195,"character":9999},"start":{"line":195,"character":0}}},{"definition":"sub","name":"get_link_menu_name","containerName":"main::","range":{"end":{"line":210,"character":9999},"start":{"character":0,"line":207}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_link_menu_name","line":208,"kind":13},{"name":"$self","containerName":"get_link_menu_name","kind":13,"line":209},{"line":209,"kind":12,"name":"eutil","containerName":"get_link_menu_name"},{"kind":13,"line":209,"name":"$self","containerName":"get_link_menu_name"},{"line":209,"kind":13,"containerName":"get_link_menu_name","name":"$self"}],"line":207},{"containerName":"main::","definition":"sub","name":"get_priority","range":{"end":{"character":9999,"line":223},"start":{"character":0,"line":223}},"kind":12,"line":223,"children":[]},{"range":{"start":{"line":236,"character":0},"end":{"line":236,"character":9999}},"name":"get_html_tag","definition":"sub","containerName":"main::","children":[],"line":236,"kind":12},{"children":[],"line":250,"kind":12,"range":{"end":{"line":250,"character":9999},"start":{"character":0,"line":250}},"definition":"sub","name":"get_url","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self,$simple)","signature":{"documentation":" private method","parameters":[{"label":"$self"},{"label":"$simple"}],"label":"_add_data($self,$simple)"},"kind":12,"line":254,"children":[{"localvar":"my","containerName":"_add_data","definition":"my","name":"$self","line":255,"kind":13},{"name":"$simple","containerName":"_add_data","kind":13,"line":255},{"line":256,"kind":13,"containerName":"_add_data","name":"$self"},{"containerName":"_add_data","name":"$simple","kind":13,"line":256},{"containerName":"_add_data","name":"$simple","line":256,"kind":13},{"containerName":"_add_data","name":"$simple","line":256,"kind":13}],"name":"_add_data","range":{"end":{"line":257,"character":9999},"start":{"line":254,"character":0}}},{"children":[{"kind":13,"line":271,"name":"$self","definition":"my","containerName":"to_string","localvar":"my"},{"kind":13,"line":272,"definition":"my","name":"$level","containerName":"to_string","localvar":"my"},{"line":273,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$pad"},{"kind":13,"line":273,"containerName":"to_string","name":"$level"},{"localvar":"my","name":"%tags","definition":"my","containerName":"to_string","line":275,"kind":13},{"kind":13,"line":284,"containerName":"to_string","definition":"my","name":"$string","localvar":"my"},{"kind":13,"line":285,"containerName":"to_string","definition":"my","name":"$tag","localvar":"my"},{"name":"$a","containerName":"to_string","kind":13,"line":285},{"name":"$b","containerName":"to_string","kind":13,"line":285},{"containerName":"to_string","name":"%tags","line":285,"kind":13},{"localvar":"my","name":"$m","definition":"my","containerName":"to_string","line":286,"kind":13},{"name":"$nm","containerName":"to_string","line":286,"kind":13},{"kind":13,"line":286,"containerName":"to_string","name":"$tags"},{"line":286,"kind":13,"containerName":"to_string","name":"$tag"},{"containerName":"to_string","name":"$tags","line":286,"kind":13},{"kind":13,"line":286,"name":"$tag","containerName":"to_string"},{"name":"$content","definition":"my","containerName":"to_string","localvar":"my","kind":13,"line":287},{"line":287,"kind":13,"containerName":"to_string","name":"$self"},{"name":"$m","containerName":"to_string","kind":13,"line":287},{"containerName":"to_string","name":"$content","line":288,"kind":13},{"kind":13,"line":289,"name":"$string","containerName":"to_string"},{"containerName":"to_string","name":"$level","line":290,"kind":13},{"kind":13,"line":291,"containerName":"to_string","name":"$pad"},{"line":291,"kind":13,"containerName":"to_string","name":"$nm"},{"kind":13,"line":292,"name":"$self","containerName":"to_string"},{"containerName":"to_string","name":"_text_wrap","line":292,"kind":12},{"name":"$pad","containerName":"to_string","line":293,"kind":13},{"line":294,"kind":13,"name":"$content","containerName":"to_string"},{"name":"$string","containerName":"to_string","kind":13,"line":296}],"line":270,"kind":12,"range":{"start":{"character":0,"line":270},"end":{"character":9999,"line":297}},"name":"to_string","definition":"sub","containerName":"main::"}],"version":5}