{"vars":[{"line":132,"kind":2,"containerName":"","name":"base"},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: FieldInfo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Info\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n# \n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Info::FieldInfo - class for storing einfo field data\n\n=head1 SYNOPSIS\n\n    #### should not create instance directly; Bio::Tools::EUtilities does this ####\n\n    my $info = Bio::Tools::EUtilities->new(-eutil => 'einfo',\n                                           -file => 'einfo.xml');\n    # can also use '-response' (for HTTP::Response objects) or '-fh' (for filehandles)\n\n    # print available databases (if data is present)\n    print join(', ',$info->get_available_databases),\"\\n\";\n\n    # get database info\n    my $db = $info->get_database; # in case you forgot...\n    my $desc = $info->get_description;\n    my $nm = $info->get_menu_name;\n    my $ct = $info->get_record_count;\n    my $dt = $info->get_last_update;\n    # EUtilDataI interface methods\n    my $eutil = $info->eutil;\n    my $type = $info->type;\n\n    # iterate through Field and Link objects\n    while (my $field = $info->next_Field) {\n        print \"Field code: \",$field->get_field_code,\"\\n\";\n        print \"Field name: \",$field->get_field_name,\"\\n\";\n        print \"Field desc: \",$field->get_field_description,\"\\n\";\n        print \"DB  : \",$field->get_database,\"\\n\";\n        print \"Term ct   : \",$field->get_term_count,\"\\n\";\n        for my $att (qw(is_date is_singletoken is_hierarchy is_hidden is_numerical)) {\n            print \"\\tField $att\\n\" if $field->$att;\n        }\n    }\n\n    my @fields = $info->get_Fields; # grab them all (useful for grep)\n\n    while (my $link = $info->next_Link) {\n        print \"Link name: \",$link->get_link_name,\"\\n\";\n        print \"Link desc: \",$link->get_link_description,\"\\n\";\n        print \"DBFrom: \",$link->get_dbfrom,\"\\n\"; # same as get_database()\n        print \"DBTo: \",$link->get_dbto,\"\\n\"; # database linked to\n    }\n\n    my @links = $info->get_Links; # grab them all (useful for grep)\n\n    $info->rewind(); # rewinds all iterators\n    $info->rewind('links'); # rewinds Link iterator\n    $info->rewind('fields'); # rewinds Field iterator\n\n=head1 DESCRIPTION\n\nThis class handles data output (XML) from einfo.\n\neinfo is capable of returning two types of information: 1) a list of all\navailable databases (when called w/o parameters) and 2) information about a\nspecific database. The latter information includes the database description,\nrecord count, and date/time stamp for the last update, among other things. It\nalso includes a list of fields (indices by which record data is stored which can\nbe used in queries) and links (crossrefs between related records in other\ndatabases at NCBI). Data from the latter two are stored in two small subclasses\n(Field and Link) which can be iterated through or retrieved all at once, as\ndemonstrated above. NOTE: Methods described for the Link and Field subclasses\nare unique to those classes (as they retrieve data unique to those data types).\n\nFurther documentation for Link and Field subclass methods is included below.\n\nFor more information on einfo see:\n\n   http://eutils.ncbi.nlm.nih.gov/entrez/query/static/einfo_help.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other Bioperl\nmodules. Send your comments and suggestions preferably to one of the Bioperl\nmailing lists. Your participation is much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track the bugs\nand their resolution. Bug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Info::FieldInfo;\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\nuse strict;\nuse warnings;\n\n=head2 new\n\n Title    : new\n Note     : *** should not be called by end-users ***  \n Usage    : my $ct = Bio::Tools::EUtilities::Info::FieldInfo;\n Function : returns new FieldInfo instance\n Returns  : Bio::Tools::EUtilities::Info::FieldInfo instance\n Args     : none (all data added via _add_data, most methods are getters only)","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":148,"kind":13},{"name":"@args","containerName":"new","line":148,"kind":13},{"kind":13,"line":149,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"name":"$class","containerName":"new","line":149,"kind":13},{"kind":13,"line":149,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","kind":13,"line":150},{"containerName":"new","name":"eutil","kind":12,"line":150},{"containerName":"new","name":"$self","kind":13,"line":151},{"name":"datatype","containerName":"new","kind":12,"line":151},{"containerName":"new","name":"$self","line":152,"kind":13}],"line":147,"kind":12,"range":{"end":{"line":153,"character":9999},"start":{"line":147,"character":0}},"name":"new"},{"containerName":"","name":"warnings","line":148,"kind":2},{"kind":12,"line":149,"name":"SUPER","containerName":"new"},{"range":{"end":{"character":9999,"line":165},"start":{"character":0,"line":165}},"containerName":"main::","definition":"sub","name":"get_term_count","line":165,"children":[],"kind":12},{"line":177,"children":[],"kind":12,"range":{"start":{"character":0,"line":177},"end":{"line":177,"character":9999}},"containerName":"main::","definition":"sub","name":"get_field_name"},{"children":[],"line":198,"kind":12,"range":{"start":{"line":198,"character":0},"end":{"character":9999,"line":198}},"name":"get_field_code","definition":"sub","containerName":"main::"},{"line":211,"children":[],"kind":12,"range":{"end":{"line":211,"character":9999},"start":{"character":0,"line":211}},"containerName":"main::","definition":"sub","name":"get_field_description"},{"definition":"sub","name":"is_date","containerName":"main::","range":{"start":{"character":0,"line":223},"end":{"line":226,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"is_date","localvar":"my","kind":13,"line":224},{"containerName":"is_date","name":"$self","line":225,"kind":13},{"name":"$self","containerName":"is_date","line":225,"kind":13}],"line":223},{"range":{"start":{"line":238,"character":0},"end":{"character":9999,"line":241}},"containerName":"main::","definition":"sub","name":"is_singletoken","line":238,"children":[{"line":239,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"is_singletoken"},{"containerName":"is_singletoken","name":"$self","kind":13,"line":240},{"kind":13,"line":240,"containerName":"is_singletoken","name":"$self"}],"kind":12},{"name":"is_hierarchy","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":256},"start":{"character":0,"line":253}},"kind":12,"children":[{"kind":13,"line":254,"containerName":"is_hierarchy","name":"$self","definition":"my","localvar":"my"},{"containerName":"is_hierarchy","name":"$self","kind":13,"line":255},{"containerName":"is_hierarchy","name":"$self","line":255,"kind":13}],"line":253},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"is_hidden","line":269,"kind":13},{"line":270,"kind":13,"name":"$self","containerName":"is_hidden"},{"name":"$self","containerName":"is_hidden","line":270,"kind":13}],"line":268,"kind":12,"range":{"start":{"line":268,"character":0},"end":{"line":271,"character":9999}},"definition":"sub","name":"is_hidden","containerName":"main::"},{"containerName":"main::","name":"is_numerical","definition":"sub","range":{"start":{"line":283,"character":0},"end":{"character":9999,"line":286}},"kind":12,"line":283,"children":[{"kind":13,"line":284,"containerName":"is_numerical","name":"$self","definition":"my","localvar":"my"},{"line":285,"kind":13,"name":"$self","containerName":"is_numerical"},{"containerName":"is_numerical","name":"$self","kind":13,"line":285}]},{"children":[{"name":"$self","definition":"my","containerName":"_add_data","localvar":"my","kind":13,"line":291},{"kind":13,"line":291,"containerName":"_add_data","name":"$simple"},{"containerName":"_add_data","name":"$self","kind":13,"line":292},{"name":"$simple","containerName":"_add_data","kind":13,"line":292},{"line":292,"kind":13,"name":"$simple","containerName":"_add_data"},{"kind":13,"line":292,"containerName":"_add_data","name":"$simple"}],"line":290,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$simple"}],"documentation":" private EUtilDataI method","label":"_add_data($self,$simple)"},"detail":"($self,$simple)","definition":"sub","containerName":"main::","range":{"end":{"line":293,"character":9999},"start":{"character":0,"line":290}},"name":"_add_data"},{"kind":12,"line":306,"children":[{"line":307,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$self"},{"line":309,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"%tags"},{"line":313,"kind":13,"localvar":"my","definition":"my","name":"$string","containerName":"to_string"},{"line":314,"kind":13,"localvar":"my","name":"$tag","definition":"my","containerName":"to_string"},{"name":"$a","containerName":"to_string","line":314,"kind":13},{"name":"$b","containerName":"to_string","line":314,"kind":13},{"containerName":"to_string","name":"%tags","line":314,"kind":13},{"localvar":"my","containerName":"to_string","name":"$m","definition":"my","line":315,"kind":13},{"name":"$nm","containerName":"to_string","line":315,"kind":13},{"containerName":"to_string","name":"$tags","line":315,"kind":13},{"line":315,"kind":13,"containerName":"to_string","name":"$tag"},{"containerName":"to_string","name":"$tags","line":315,"kind":13},{"line":315,"kind":13,"containerName":"to_string","name":"$tag"},{"kind":13,"line":316,"containerName":"to_string","name":"$string"},{"containerName":"to_string","name":"$nm","line":316,"kind":13},{"name":"$self","containerName":"to_string","kind":13,"line":317},{"name":"_text_wrap","containerName":"to_string","line":317,"kind":12},{"kind":13,"line":317,"containerName":"to_string","name":"$self"},{"kind":13,"line":317,"name":"$m","containerName":"to_string"},{"line":319,"kind":13,"containerName":"to_string","name":"$string"},{"containerName":"to_string","name":"$self","line":320,"kind":13},{"line":320,"kind":12,"containerName":"to_string","name":"_text_wrap"},{"line":320,"kind":13,"containerName":"to_string","name":"$self"},{"line":322,"kind":13,"containerName":"to_string","name":"$string"}],"containerName":"main::","definition":"sub","name":"to_string","range":{"start":{"line":306,"character":0},"end":{"character":9999,"line":323}}},{"line":317,"kind":12,"name":"x20"},{"kind":12,"line":320,"name":"x20"}],"version":5}