{"version":5,"vars":[{"name":"base","containerName":"","line":96,"kind":2},{"name":"new","range":{"end":{"line":141,"character":9999},"start":{"character":0,"line":127}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: EPCR.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EPCR\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EPCR - Parse ePCR output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ePCR data\n    # assuming ePCR data is already generated in file seq1.epcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::EPCR;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::EPCR->new(-file => 'seq1.epcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add EPCR annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ePCR data, creating a\nBio::SeqFeatureI for each ePCR hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::EPCR;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $epcr = Bio::Tools::EPCR->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new EPCR parser\n Returns : Bio::Tools::EPCR\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       'sts'.  (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'e-PCR'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"line":128,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"name":"@args","containerName":"new","line":128,"kind":13},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":130,"kind":13},{"line":130,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","kind":13,"line":130},{"containerName":"new","definition":"my","name":"$primary","localvar":"my","kind":13,"line":131},{"kind":13,"line":131,"name":"$source","containerName":"new"},{"name":"$groupclass","containerName":"new","kind":13,"line":132},{"line":132,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","kind":12,"line":132},{"name":"@args","containerName":"new","kind":13,"line":134},{"name":"$self","containerName":"new","line":135,"kind":13},{"name":"primary","containerName":"new","kind":12,"line":135},{"containerName":"new","name":"$primary","kind":13,"line":135},{"name":"$primary","containerName":"new","kind":13,"line":135},{"containerName":"new","name":"$self","line":136,"kind":13},{"line":136,"kind":12,"containerName":"new","name":"source"},{"containerName":"new","name":"$source","line":136,"kind":13},{"containerName":"new","name":"$source","kind":13,"line":136},{"name":"$self","containerName":"new","line":137,"kind":13},{"containerName":"new","name":"groupclass","kind":12,"line":137},{"containerName":"new","name":"$groupclass","kind":13,"line":137},{"name":"$groupclass","containerName":"new","kind":13,"line":137},{"kind":13,"line":139,"containerName":"new","name":"$self"},{"containerName":"new","name":"_initialize_io","line":139,"kind":12},{"name":"@args","containerName":"new","line":139,"kind":13},{"line":140,"kind":13,"name":"$self","containerName":"new"}],"line":127},{"kind":12,"line":130,"name":"SUPER","containerName":"new"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: EPCR.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EPCR\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EPCR - Parse ePCR output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ePCR data\n    # assuming ePCR data is already generated in file seq1.epcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::EPCR;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::EPCR->new(-file => 'seq1.epcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add EPCR annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ePCR data, creating a\nBio::SeqFeatureI for each ePCR hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::EPCR;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $epcr = Bio::Tools::EPCR->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new EPCR parser\n Returns : Bio::Tools::EPCR\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       'sts'.  (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'e-PCR'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($primary, $source, \n      $groupclass) = $self->_rearrange([qw(PRIMARY\n\t\t\t\t\t   SOURCE \n\t\t\t\t\t   GROUPCLASS)],@args);\n  $self->primary(defined $primary ? $primary : 'sts');\n  $self->source(defined $source ? $source : 'e-PCR');\n  $self->groupclass(defined $groupclass ? $groupclass : 'name');\n\n  $self->_initialize_io(@args);\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    ","label":"next_feature($self)"},"detail":"($self)","kind":12,"children":[{"line":157,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_feature"},{"kind":13,"line":158,"containerName":"next_feature","name":"$line","definition":"my","localvar":"my"},{"line":158,"kind":13,"containerName":"next_feature","name":"$self"},{"line":158,"kind":12,"containerName":"next_feature","name":"_readline"},{"kind":13,"line":159,"containerName":"next_feature","name":"$line"},{"name":"$line","containerName":"next_feature","kind":13,"line":160},{"kind":13,"line":161,"name":"$seqname","definition":"my","containerName":"next_feature","localvar":"my"},{"containerName":"next_feature","name":"$location","kind":13,"line":161},{"line":161,"kind":13,"containerName":"next_feature","name":"$mkrname"},{"name":"$rest","containerName":"next_feature","line":161,"kind":13},{"kind":13,"line":161,"name":"$line","containerName":"next_feature"},{"kind":13,"line":163,"definition":"my","name":"$start","containerName":"next_feature","localvar":"my"},{"name":"$end","containerName":"next_feature","line":163,"kind":13},{"line":163,"kind":13,"name":"$location","containerName":"next_feature"},{"localvar":"my","name":"$strandsign","definition":"my","containerName":"next_feature","line":166,"kind":13},{"line":167,"kind":13,"containerName":"next_feature","name":"$rest"},{"name":"$strandsign","containerName":"next_feature","line":168,"kind":13},{"name":"$rest","containerName":"next_feature","kind":13,"line":168},{"name":"$strandsign","containerName":"next_feature","kind":13,"line":170},{"containerName":"next_feature","definition":"my","name":"$strand","localvar":"my","kind":13,"line":172},{"containerName":"next_feature","name":"$strandsign","line":172,"kind":13},{"line":172,"kind":13,"name":"$strandsign","containerName":"next_feature"},{"localvar":"my","definition":"my","name":"$markerfeature","containerName":"next_feature","line":174,"kind":13},{"line":174,"kind":12,"name":"new","containerName":"next_feature"},{"line":175,"kind":13,"name":"$start","containerName":"next_feature"},{"containerName":"next_feature","name":"$end","line":176,"kind":13},{"kind":13,"line":177,"name":"$strand","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","kind":13,"line":178},{"line":178,"kind":12,"name":"source","containerName":"next_feature"},{"kind":13,"line":179,"name":"$self","containerName":"next_feature"},{"line":179,"kind":12,"containerName":"next_feature","name":"primary"},{"name":"$seqname","containerName":"next_feature","kind":13,"line":180},{"line":182,"kind":13,"containerName":"next_feature","name":"$self"},{"containerName":"next_feature","name":"groupclass","line":182,"kind":12},{"line":182,"kind":13,"containerName":"next_feature","name":"$mkrname"},{"name":"$rest","containerName":"next_feature","line":183,"kind":13},{"kind":13,"line":183,"containerName":"next_feature","name":"$rest"},{"line":186,"kind":13,"containerName":"next_feature","name":"$markerfeature"}],"line":156,"name":"next_feature","range":{"end":{"line":187,"character":9999},"start":{"line":156,"character":0}}},{"name":"Bio","containerName":"SeqFeature::Generic","line":174,"kind":12},{"name":"source","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":205},"start":{"character":0,"line":201}},"kind":12,"children":[{"kind":13,"line":202,"containerName":"source","definition":"my","name":"$self","localvar":"my"},{"line":203,"kind":13,"name":"$self","containerName":"source"},{"name":"$self","containerName":"source","kind":13,"line":204}],"line":201},{"line":219,"children":[{"kind":13,"line":220,"containerName":"primary","definition":"my","name":"$self","localvar":"my"},{"line":221,"kind":13,"containerName":"primary","name":"$self"},{"kind":13,"line":222,"containerName":"primary","name":"$self"}],"kind":12,"range":{"end":{"line":223,"character":9999},"start":{"character":0,"line":219}},"containerName":"main::","definition":"sub","name":"primary"},{"containerName":"main::","name":"groupclass","definition":"sub","range":{"end":{"line":242,"character":9999},"start":{"line":237,"character":0}},"kind":12,"line":237,"children":[{"localvar":"my","containerName":"groupclass","definition":"my","name":"$self","line":238,"kind":13},{"line":240,"kind":13,"containerName":"groupclass","name":"$self"},{"name":"$self","containerName":"groupclass","kind":13,"line":241}]}]}