{"version":5,"vars":[{"line":133,"kind":14,"containerName":"main::","definition":1,"name":"DEFAULT"},{"containerName":"","name":"strict","line":133,"kind":12},{"line":134,"kind":14,"definition":1,"name":"TRUE","containerName":"main::"},{"kind":14,"line":135,"containerName":"main::","definition":1,"name":"FALSE"},{"kind":2,"line":137,"name":"base","containerName":""},{"range":{"end":{"character":9999,"line":173},"start":{"line":158,"character":0}},"name":"new","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\"."},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":159},{"line":159,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":161},{"containerName":"new","name":"$class","kind":13,"line":161},{"line":161,"kind":13,"name":"@args","containerName":"new"},{"line":163,"kind":13,"localvar":"my","definition":"my","name":"$EC_string","containerName":"new"},{"line":163,"kind":13,"name":"$comment","containerName":"new"},{"line":164,"kind":13,"name":"$self","containerName":"new"},{"line":164,"kind":12,"name":"_rearrange","containerName":"new"},{"kind":13,"line":164,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":166,"kind":13},{"kind":12,"line":166,"name":"init","containerName":"new"},{"containerName":"new","name":"$EC_string","kind":13,"line":168},{"kind":13,"line":168,"name":"$self","containerName":"new"},{"line":168,"kind":12,"containerName":"new","name":"EC_string"},{"name":"$EC_string","containerName":"new","kind":13,"line":168},{"line":169,"kind":13,"containerName":"new","name":"$comment"},{"name":"$self","containerName":"new","kind":13,"line":169},{"name":"comment","containerName":"new","line":169,"kind":12},{"containerName":"new","name":"$comment","kind":13,"line":169},{"kind":13,"line":171,"containerName":"new","name":"$self"}],"line":158,"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":161},{"name":"init","range":{"end":{"line":196,"character":9999},"start":{"line":187,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"init($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :"},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"init","definition":"my","name":"$self","line":188,"kind":13},{"name":"$self","containerName":"init","line":190,"kind":13},{"kind":12,"line":190,"containerName":"init","name":"enzyme_class"},{"kind":13,"line":191,"containerName":"init","name":"$self"},{"name":"sub_class","containerName":"init","line":191,"kind":12},{"kind":13,"line":192,"containerName":"init","name":"$self"},{"name":"sub_sub_class","containerName":"init","line":192,"kind":12},{"kind":13,"line":193,"containerName":"init","name":"$self"},{"containerName":"init","name":"serial_number","kind":12,"line":193},{"kind":13,"line":194,"name":"$self","containerName":"init"},{"containerName":"init","name":"comment","line":194,"kind":12}],"line":187},{"name":"DEFAULT","line":190,"kind":12},{"kind":12,"line":191,"name":"DEFAULT"},{"name":"DEFAULT","line":192,"kind":12},{"name":"DEFAULT","line":193,"kind":12},{"range":{"start":{"character":0,"line":211},"end":{"line":222,"character":9999}},"name":"copy","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :","label":"copy($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"copy","localvar":"my","kind":13,"line":212},{"line":214,"kind":13,"localvar":"my","containerName":"copy","name":"$new_ec","definition":"my"},{"containerName":"copy","name":"$self","line":214,"kind":13},{"containerName":"copy","name":"new","line":214,"kind":12},{"containerName":"copy","name":"$new_ec","kind":13,"line":215},{"name":"enzyme_class","containerName":"copy","line":215,"kind":12},{"kind":13,"line":215,"name":"$self","containerName":"copy"},{"containerName":"copy","name":"enzyme_class","kind":12,"line":215},{"line":216,"kind":13,"containerName":"copy","name":"$new_ec"},{"containerName":"copy","name":"sub_class","line":216,"kind":12},{"kind":13,"line":216,"name":"$self","containerName":"copy"},{"containerName":"copy","name":"sub_class","line":216,"kind":12},{"containerName":"copy","name":"$new_ec","line":217,"kind":13},{"kind":12,"line":217,"containerName":"copy","name":"sub_sub_class"},{"name":"$self","containerName":"copy","line":217,"kind":13},{"name":"sub_sub_class","containerName":"copy","line":217,"kind":12},{"kind":13,"line":218,"containerName":"copy","name":"$new_ec"},{"line":218,"kind":12,"name":"serial_number","containerName":"copy"},{"name":"$self","containerName":"copy","kind":13,"line":218},{"name":"serial_number","containerName":"copy","kind":12,"line":218},{"containerName":"copy","name":"$new_ec","kind":13,"line":219},{"containerName":"copy","name":"comment","kind":12,"line":219},{"kind":13,"line":219,"name":"$self","containerName":"copy"},{"name":"comment","containerName":"copy","line":219,"kind":12},{"line":220,"kind":13,"containerName":"copy","name":"$new_ec"}],"line":211,"kind":12},{"range":{"start":{"line":241,"character":0},"end":{"line":262,"character":9999}},"name":"EC_string","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.","label":"EC_string($self,$value)"},"containerName":"main::","definition":"sub","line":241,"children":[{"kind":13,"line":242,"definition":"my","name":"$self","containerName":"EC_string","localvar":"my"},{"name":"$value","containerName":"EC_string","kind":13,"line":242},{"line":244,"kind":13,"name":"$value","containerName":"EC_string"},{"containerName":"EC_string","name":"$value","line":245,"kind":13},{"kind":13,"line":246,"name":"$value","containerName":"EC_string"},{"containerName":"EC_string","name":"$value","kind":13,"line":247},{"name":"$value","containerName":"EC_string","kind":13,"line":249},{"containerName":"EC_string","name":"$self","line":250,"kind":13},{"kind":12,"line":250,"name":"enzyme_class","containerName":"EC_string"},{"name":"$self","containerName":"EC_string","line":251,"kind":13},{"kind":12,"line":251,"containerName":"EC_string","name":"sub_class"},{"containerName":"EC_string","name":"$self","kind":13,"line":252},{"line":252,"kind":12,"containerName":"EC_string","name":"sub_sub_class"},{"kind":13,"line":253,"containerName":"EC_string","name":"$self"},{"kind":12,"line":253,"name":"serial_number","containerName":"EC_string"},{"line":256,"kind":13,"containerName":"EC_string","name":"$self"},{"name":"throw","containerName":"EC_string","kind":12,"line":256},{"name":"$self","containerName":"EC_string","line":260,"kind":13},{"name":"to_string","containerName":"EC_string","line":260,"kind":12}],"kind":12},{"name":"to_string","range":{"start":{"line":277,"character":0},"end":{"character":9999,"line":286}},"kind":12,"children":[{"line":278,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"to_string"},{"line":280,"kind":13,"localvar":"my","containerName":"to_string","name":"$s","definition":"my"},{"name":"$self","containerName":"to_string","line":280,"kind":13},{"line":280,"kind":12,"containerName":"to_string","name":"enzyme_class"},{"name":"$s","containerName":"to_string","line":281,"kind":13},{"containerName":"to_string","name":"$self","kind":13,"line":281},{"kind":12,"line":281,"name":"sub_class","containerName":"to_string"},{"containerName":"to_string","name":"$s","line":282,"kind":13},{"containerName":"to_string","name":"$self","line":282,"kind":13},{"containerName":"to_string","name":"sub_sub_class","line":282,"kind":12},{"kind":13,"line":283,"containerName":"to_string","name":"$s"},{"kind":13,"line":283,"name":"$self","containerName":"to_string"},{"line":283,"kind":12,"containerName":"to_string","name":"serial_number"},{"containerName":"to_string","name":"$s","line":284,"kind":13}],"line":277,"definition":"sub","containerName":"main::","signature":{"label":"to_string($self)","documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)"},{"name":"is_equal","range":{"start":{"line":303,"character":0},"end":{"line":327,"character":9999}},"kind":12,"children":[{"containerName":"is_equal","name":"$self","definition":"my","localvar":"my","kind":13,"line":304},{"containerName":"is_equal","name":"$value","kind":13,"line":304},{"line":306,"kind":13,"containerName":"is_equal","name":"$self"},{"line":306,"kind":12,"name":"_is_not_reference","containerName":"is_equal"},{"name":"$value","containerName":"is_equal","line":306,"kind":13},{"kind":13,"line":307,"containerName":"is_equal","name":"$value"},{"kind":13,"line":307,"name":"$self","containerName":"is_equal"},{"containerName":"is_equal","name":"new","line":307,"kind":12},{"kind":13,"line":307,"name":"$value","containerName":"is_equal"},{"line":310,"kind":13,"containerName":"is_equal","name":"$self"},{"kind":12,"line":310,"name":"_is_ECnumber_object","containerName":"is_equal"},{"line":310,"kind":13,"name":"$value","containerName":"is_equal"},{"kind":13,"line":313,"containerName":"is_equal","name":"$self"},{"line":313,"kind":12,"name":"enzyme_class","containerName":"is_equal"},{"kind":13,"line":313,"containerName":"is_equal","name":"$value"},{"line":313,"kind":12,"name":"enzyme_class","containerName":"is_equal"},{"kind":13,"line":316,"containerName":"is_equal","name":"$self"},{"containerName":"is_equal","name":"sub_class","kind":12,"line":316},{"name":"$value","containerName":"is_equal","line":316,"kind":13},{"containerName":"is_equal","name":"sub_class","kind":12,"line":316},{"name":"$self","containerName":"is_equal","line":319,"kind":13},{"line":319,"kind":12,"name":"sub_sub_class","containerName":"is_equal"},{"kind":13,"line":319,"name":"$value","containerName":"is_equal"},{"containerName":"is_equal","name":"sub_sub_class","kind":12,"line":319},{"line":322,"kind":13,"containerName":"is_equal","name":"$self"},{"name":"serial_number","containerName":"is_equal","kind":12,"line":322},{"line":322,"kind":13,"name":"$value","containerName":"is_equal"},{"kind":12,"line":322,"name":"serial_number","containerName":"is_equal"}],"line":303,"definition":"sub","containerName":"main::","signature":{"label":"is_equal($self,$value)","documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :\n\n\nsub to_string {\n    my ( $self ) = @_;\n\n    my $s  = $self->enzyme_class() . \".\";\n    $s    .= $self->sub_class() . \".\";\n    $s    .= $self->sub_sub_class() . \".\";   \n    $s    .= $self->serial_number();\n    return $s;\n    \n} # to_string\n\n\n\n=head2 is_equal\n\n Title   : is_equal\n Usage   : if ( $EC3->is_equal( $EC2 ) )\n           or\n           if ( $EC3->is_equal( \"1.1.1.-\" ) )\n Function: Checks whether this ECnumber is equal to the argument\n           EC number (please note: \"1.1.1.1\" != \"1.1.1.-\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)"},{"line":314,"kind":12,"name":"FALSE"},{"kind":12,"line":317,"name":"FALSE"},{"kind":12,"line":320,"name":"FALSE"},{"kind":12,"line":323,"name":"FALSE"},{"line":325,"kind":12,"name":"TRUE"},{"kind":12,"children":[{"line":346,"kind":13,"localvar":"my","containerName":"is_member","name":"$self","definition":"my"},{"line":346,"kind":13,"name":"$value","containerName":"is_member"},{"containerName":"is_member","name":"$self","kind":13,"line":348},{"line":348,"kind":12,"name":"_is_not_reference","containerName":"is_member"},{"line":348,"kind":13,"containerName":"is_member","name":"$value"},{"name":"$value","containerName":"is_member","kind":13,"line":349},{"name":"$self","containerName":"is_member","line":349,"kind":13},{"kind":12,"line":349,"containerName":"is_member","name":"new"},{"kind":13,"line":349,"containerName":"is_member","name":"$value"},{"name":"$self","containerName":"is_member","kind":13,"line":352},{"line":352,"kind":12,"name":"_is_ECnumber_object","containerName":"is_member"},{"name":"$value","containerName":"is_member","kind":13,"line":352},{"kind":13,"line":354,"containerName":"is_member","name":"$self"},{"name":"_check_for_illegal_defaults","containerName":"is_member","line":354,"kind":12},{"containerName":"is_member","name":"$value","line":355,"kind":13},{"name":"_check_for_illegal_defaults","containerName":"is_member","kind":12,"line":355},{"containerName":"is_member","name":"$value","line":357,"kind":13},{"containerName":"is_member","name":"enzyme_class","kind":12,"line":357},{"line":358,"kind":13,"name":"$self","containerName":"is_member"},{"kind":12,"line":358,"name":"enzyme_class","containerName":"is_member"},{"kind":13,"line":358,"name":"$value","containerName":"is_member"},{"kind":12,"line":358,"name":"enzyme_class","containerName":"is_member"},{"kind":13,"line":361,"name":"$value","containerName":"is_member"},{"kind":12,"line":361,"name":"sub_class","containerName":"is_member"},{"containerName":"is_member","name":"$self","line":362,"kind":13},{"line":362,"kind":12,"containerName":"is_member","name":"sub_class"},{"name":"$value","containerName":"is_member","kind":13,"line":362},{"containerName":"is_member","name":"sub_class","kind":12,"line":362},{"name":"$value","containerName":"is_member","kind":13,"line":365},{"line":365,"kind":12,"containerName":"is_member","name":"sub_sub_class"},{"line":366,"kind":13,"containerName":"is_member","name":"$self"},{"kind":12,"line":366,"name":"sub_sub_class","containerName":"is_member"},{"name":"$value","containerName":"is_member","line":366,"kind":13},{"kind":12,"line":366,"containerName":"is_member","name":"sub_sub_class"},{"containerName":"is_member","name":"$value","kind":13,"line":369},{"line":369,"kind":12,"name":"serial_number","containerName":"is_member"},{"kind":13,"line":370,"containerName":"is_member","name":"$self"},{"containerName":"is_member","name":"serial_number","line":370,"kind":12},{"containerName":"is_member","name":"$value","kind":13,"line":370},{"kind":12,"line":370,"containerName":"is_member","name":"serial_number"}],"line":345,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :\n\n\nsub to_string {\n    my ( $self ) = @_;\n\n    my $s  = $self->enzyme_class() . \".\";\n    $s    .= $self->sub_class() . \".\";\n    $s    .= $self->sub_sub_class() . \".\";   \n    $s    .= $self->serial_number();\n    return $s;\n    \n} # to_string\n\n\n\n=head2 is_equal\n\n Title   : is_equal\n Usage   : if ( $EC3->is_equal( $EC2 ) )\n           or\n           if ( $EC3->is_equal( \"1.1.1.-\" ) )\n Function: Checks whether this ECnumber is equal to the argument\n           EC number (please note: \"1.1.1.1\" != \"1.1.1.-\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_equal {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    \n    unless ( $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_equal\n\n\n\n=head2 is_member\n\n Title   : is_member\n Usage   : if ( $EC1->is_member( $EC5 ) )\n           or\n           if ( $EC1->is_member( \"4.3.-.-\" ) )\n Function: Checks whether this ECnumber is a member of the (incomplete)\n           argument EC number (e.g. \"1.1.1.1\" is a member of \"1.1.1.-\"\n           but not of \"1.1.1.2\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"is_member($self,$value)"},"detail":"($self,$value)","name":"is_member","range":{"start":{"character":0,"line":345},"end":{"line":375,"character":9999}}},{"line":358,"kind":12,"name":"DEFAULT"},{"name":"FALSE","kind":12,"line":359},{"kind":12,"line":361,"name":"DEFAULT"},{"line":363,"kind":12,"name":"FALSE"},{"kind":12,"line":366,"name":"DEFAULT"},{"name":"FALSE","kind":12,"line":367},{"kind":12,"line":370,"name":"DEFAULT"},{"line":371,"kind":12,"name":"FALSE"},{"name":"TRUE","line":373,"kind":12},{"children":[{"name":"$self","definition":"my","containerName":"enzyme_class","localvar":"my","kind":13,"line":392},{"kind":13,"line":392,"name":"$value","containerName":"enzyme_class"},{"containerName":"enzyme_class","name":"$value","line":394,"kind":13},{"containerName":"enzyme_class","name":"$self","kind":13,"line":395},{"line":395,"kind":13,"name":"$self","containerName":"enzyme_class"},{"line":395,"kind":12,"name":"_check_number","containerName":"enzyme_class"},{"kind":13,"line":395,"containerName":"enzyme_class","name":"$value"},{"name":"$self","containerName":"enzyme_class","line":398,"kind":13}],"line":391,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :\n\n\nsub to_string {\n    my ( $self ) = @_;\n\n    my $s  = $self->enzyme_class() . \".\";\n    $s    .= $self->sub_class() . \".\";\n    $s    .= $self->sub_sub_class() . \".\";   \n    $s    .= $self->serial_number();\n    return $s;\n    \n} # to_string\n\n\n\n=head2 is_equal\n\n Title   : is_equal\n Usage   : if ( $EC3->is_equal( $EC2 ) )\n           or\n           if ( $EC3->is_equal( \"1.1.1.-\" ) )\n Function: Checks whether this ECnumber is equal to the argument\n           EC number (please note: \"1.1.1.1\" != \"1.1.1.-\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_equal {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    \n    unless ( $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_equal\n\n\n\n=head2 is_member\n\n Title   : is_member\n Usage   : if ( $EC1->is_member( $EC5 ) )\n           or\n           if ( $EC1->is_member( \"4.3.-.-\" ) )\n Function: Checks whether this ECnumber is a member of the (incomplete)\n           argument EC number (e.g. \"1.1.1.1\" is a member of \"1.1.1.-\"\n           but not of \"1.1.1.2\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_member {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    $self->_check_for_illegal_defaults();\n    $value->_check_for_illegal_defaults();\n\n    unless ( $value->enzyme_class() eq DEFAULT\n    ||       $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless (  $value->sub_class() eq DEFAULT \n    ||        $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->sub_sub_class() eq DEFAULT\n    ||       $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->serial_number() eq DEFAULT\n    ||       $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_member \n\n\n\n=head2 enzyme_class\n\n Title   : enzyme_class\n Usage   : $EC1->enzyme_class( 1 );\n           or \n           print $EC1->enzyme_class(); \n Function: Set/get for the enzyme class number of ECnumbers.\n Returns : The enzyme class number of this ECnumber.\n Args    : A positive integer or \"-\".","label":"enzyme_class($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"line":391,"character":0},"end":{"line":400,"character":9999}},"name":"enzyme_class"},{"detail":"($self,$value)","signature":{"label":"sub_class($self,$value)","documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :\n\n\nsub to_string {\n    my ( $self ) = @_;\n\n    my $s  = $self->enzyme_class() . \".\";\n    $s    .= $self->sub_class() . \".\";\n    $s    .= $self->sub_sub_class() . \".\";   \n    $s    .= $self->serial_number();\n    return $s;\n    \n} # to_string\n\n\n\n=head2 is_equal\n\n Title   : is_equal\n Usage   : if ( $EC3->is_equal( $EC2 ) )\n           or\n           if ( $EC3->is_equal( \"1.1.1.-\" ) )\n Function: Checks whether this ECnumber is equal to the argument\n           EC number (please note: \"1.1.1.1\" != \"1.1.1.-\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_equal {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    \n    unless ( $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_equal\n\n\n\n=head2 is_member\n\n Title   : is_member\n Usage   : if ( $EC1->is_member( $EC5 ) )\n           or\n           if ( $EC1->is_member( \"4.3.-.-\" ) )\n Function: Checks whether this ECnumber is a member of the (incomplete)\n           argument EC number (e.g. \"1.1.1.1\" is a member of \"1.1.1.-\"\n           but not of \"1.1.1.2\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_member {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    $self->_check_for_illegal_defaults();\n    $value->_check_for_illegal_defaults();\n\n    unless ( $value->enzyme_class() eq DEFAULT\n    ||       $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless (  $value->sub_class() eq DEFAULT \n    ||        $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->sub_sub_class() eq DEFAULT\n    ||       $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->serial_number() eq DEFAULT\n    ||       $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_member \n\n\n\n=head2 enzyme_class\n\n Title   : enzyme_class\n Usage   : $EC1->enzyme_class( 1 );\n           or \n           print $EC1->enzyme_class(); \n Function: Set/get for the enzyme class number of ECnumbers.\n Returns : The enzyme class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub enzyme_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_enzyme_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_enzyme_class\" };\n    \n} # enzyme_class\n\n\n\n=head2 sub_class\n\n Title   : sub_class\n Usage   : $EC1->sub_class( 4 );\n           or \n           print $EC1->sub_class(); \n Function: Set/get for the enzyme sub class number of ECnumbers.\n Returns : The enzyme sub class number of this ECnumber.\n Args    : A positive integer or \"-\".","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":416,"children":[{"containerName":"sub_class","name":"$self","definition":"my","localvar":"my","kind":13,"line":417},{"containerName":"sub_class","name":"$value","line":417,"kind":13},{"line":419,"kind":13,"containerName":"sub_class","name":"$value"},{"containerName":"sub_class","name":"$self","line":420,"kind":13},{"line":420,"kind":13,"containerName":"sub_class","name":"$self"},{"line":420,"kind":12,"containerName":"sub_class","name":"_check_number"},{"kind":13,"line":420,"name":"$value","containerName":"sub_class"},{"containerName":"sub_class","name":"$self","line":423,"kind":13}],"kind":12,"range":{"start":{"line":416,"character":0},"end":{"line":425,"character":9999}},"name":"sub_class"},{"name":"sub_sub_class","range":{"end":{"line":450,"character":9999},"start":{"line":441,"character":0}},"kind":12,"children":[{"line":442,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"sub_sub_class"},{"containerName":"sub_sub_class","name":"$value","line":442,"kind":13},{"line":444,"kind":13,"containerName":"sub_sub_class","name":"$value"},{"kind":13,"line":445,"containerName":"sub_sub_class","name":"$self"},{"line":445,"kind":13,"name":"$self","containerName":"sub_sub_class"},{"containerName":"sub_sub_class","name":"_check_number","line":445,"kind":12},{"name":"$value","containerName":"sub_sub_class","kind":13,"line":445},{"containerName":"sub_sub_class","name":"$self","line":448,"kind":13}],"line":441,"definition":"sub","containerName":"main::","signature":{"label":"sub_sub_class($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :\n\n\nsub to_string {\n    my ( $self ) = @_;\n\n    my $s  = $self->enzyme_class() . \".\";\n    $s    .= $self->sub_class() . \".\";\n    $s    .= $self->sub_sub_class() . \".\";   \n    $s    .= $self->serial_number();\n    return $s;\n    \n} # to_string\n\n\n\n=head2 is_equal\n\n Title   : is_equal\n Usage   : if ( $EC3->is_equal( $EC2 ) )\n           or\n           if ( $EC3->is_equal( \"1.1.1.-\" ) )\n Function: Checks whether this ECnumber is equal to the argument\n           EC number (please note: \"1.1.1.1\" != \"1.1.1.-\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_equal {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    \n    unless ( $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_equal\n\n\n\n=head2 is_member\n\n Title   : is_member\n Usage   : if ( $EC1->is_member( $EC5 ) )\n           or\n           if ( $EC1->is_member( \"4.3.-.-\" ) )\n Function: Checks whether this ECnumber is a member of the (incomplete)\n           argument EC number (e.g. \"1.1.1.1\" is a member of \"1.1.1.-\"\n           but not of \"1.1.1.2\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_member {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    $self->_check_for_illegal_defaults();\n    $value->_check_for_illegal_defaults();\n\n    unless ( $value->enzyme_class() eq DEFAULT\n    ||       $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless (  $value->sub_class() eq DEFAULT \n    ||        $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->sub_sub_class() eq DEFAULT\n    ||       $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->serial_number() eq DEFAULT\n    ||       $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_member \n\n\n\n=head2 enzyme_class\n\n Title   : enzyme_class\n Usage   : $EC1->enzyme_class( 1 );\n           or \n           print $EC1->enzyme_class(); \n Function: Set/get for the enzyme class number of ECnumbers.\n Returns : The enzyme class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub enzyme_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_enzyme_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_enzyme_class\" };\n    \n} # enzyme_class\n\n\n\n=head2 sub_class\n\n Title   : sub_class\n Usage   : $EC1->sub_class( 4 );\n           or \n           print $EC1->sub_class(); \n Function: Set/get for the enzyme sub class number of ECnumbers.\n Returns : The enzyme sub class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub sub_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_sub_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_sub_class\" };\n    \n} # sub_class\n\n\n\n=head2 sub_sub_class \n\n Title   : sub_sub_class\n Usage   : $EC1->sub_sub_class( 12 );\n           or \n           print $EC1->sub_sub_class(); \n Function: Set/get for the enzyme sub sub class number of ECnumbers.\n Returns : The enzyme sub sub class number of this ECnumber.\n Args    : A positive integer or \"-\"."},"detail":"($self,$value)"},{"line":466,"children":[{"line":467,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"serial_number"},{"name":"$value","containerName":"serial_number","kind":13,"line":467},{"kind":13,"line":469,"name":"$value","containerName":"serial_number"},{"containerName":"serial_number","name":"$self","line":470,"kind":13},{"name":"$self","containerName":"serial_number","kind":13,"line":470},{"kind":12,"line":470,"containerName":"serial_number","name":"_check_number"},{"name":"$value","containerName":"serial_number","kind":13,"line":470},{"line":473,"kind":13,"name":"$self","containerName":"serial_number"}],"kind":12,"detail":"($self,$value)","signature":{"label":"serial_number($self,$value)","documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :\n\n\nsub to_string {\n    my ( $self ) = @_;\n\n    my $s  = $self->enzyme_class() . \".\";\n    $s    .= $self->sub_class() . \".\";\n    $s    .= $self->sub_sub_class() . \".\";   \n    $s    .= $self->serial_number();\n    return $s;\n    \n} # to_string\n\n\n\n=head2 is_equal\n\n Title   : is_equal\n Usage   : if ( $EC3->is_equal( $EC2 ) )\n           or\n           if ( $EC3->is_equal( \"1.1.1.-\" ) )\n Function: Checks whether this ECnumber is equal to the argument\n           EC number (please note: \"1.1.1.1\" != \"1.1.1.-\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_equal {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    \n    unless ( $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_equal\n\n\n\n=head2 is_member\n\n Title   : is_member\n Usage   : if ( $EC1->is_member( $EC5 ) )\n           or\n           if ( $EC1->is_member( \"4.3.-.-\" ) )\n Function: Checks whether this ECnumber is a member of the (incomplete)\n           argument EC number (e.g. \"1.1.1.1\" is a member of \"1.1.1.-\"\n           but not of \"1.1.1.2\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_member {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    $self->_check_for_illegal_defaults();\n    $value->_check_for_illegal_defaults();\n\n    unless ( $value->enzyme_class() eq DEFAULT\n    ||       $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless (  $value->sub_class() eq DEFAULT \n    ||        $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->sub_sub_class() eq DEFAULT\n    ||       $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->serial_number() eq DEFAULT\n    ||       $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_member \n\n\n\n=head2 enzyme_class\n\n Title   : enzyme_class\n Usage   : $EC1->enzyme_class( 1 );\n           or \n           print $EC1->enzyme_class(); \n Function: Set/get for the enzyme class number of ECnumbers.\n Returns : The enzyme class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub enzyme_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_enzyme_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_enzyme_class\" };\n    \n} # enzyme_class\n\n\n\n=head2 sub_class\n\n Title   : sub_class\n Usage   : $EC1->sub_class( 4 );\n           or \n           print $EC1->sub_class(); \n Function: Set/get for the enzyme sub class number of ECnumbers.\n Returns : The enzyme sub class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub sub_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_sub_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_sub_class\" };\n    \n} # sub_class\n\n\n\n=head2 sub_sub_class \n\n Title   : sub_sub_class\n Usage   : $EC1->sub_sub_class( 12 );\n           or \n           print $EC1->sub_sub_class(); \n Function: Set/get for the enzyme sub sub class number of ECnumbers.\n Returns : The enzyme sub sub class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub sub_sub_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_sub_sub_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_sub_sub_class\" };\n    \n} # sub_sub_class\n\n\n\n=head2 serial_number\n\n Title   : serial_number\n Usage   : $EC1->serial_number( 482 );\n           or \n           print $EC1->serial_number(); \n Function: Set/get for the serial number of ECnumbers.\n Returns : The serial number of this ECnumber.\n Args    : A positive integer or \"-\".","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":466,"character":0},"end":{"line":475,"character":9999}},"name":"serial_number"},{"range":{"end":{"character":9999,"line":500},"start":{"character":0,"line":491}},"name":"comment","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"comment","line":492,"kind":13},{"kind":13,"line":492,"name":"$value","containerName":"comment"},{"line":494,"kind":13,"containerName":"comment","name":"$value"},{"kind":13,"line":495,"containerName":"comment","name":"$self"},{"containerName":"comment","name":"$value","kind":13,"line":495},{"kind":13,"line":498,"name":"$self","containerName":"comment"}],"line":491,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ECnumber.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ECnumber\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::ECnumber - representation of EC numbers (Enzyme Classification)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ECnumber;\n\n  # Creation of ECnumber objects\n  my $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n  my $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"EC 1.1.1.1\" );\n  my $EC3 = Bio::Tools::ECnumber->new();\n\n  # Copying\n  my $EC4 = $EC1->copy();\n\n  # Modification/canonicalization of ECnumber objects\n  print $EC3->EC_string( \"1.01.01.001\" ); # Prints \"1.1.1.1\".\n\n  # Stringify\n  print $EC3->EC_string();\n  # or\n  print $EC3->to_string();\n\n  # Test for equality\n  # -- Against ECnumber object:\n  if ( $EC3->is_equal( $EC2 ) ) { # Prints \"equal\".\n      print \"equal\";\n  }\n  # -- Against string representation of EC number:\n  if ( ! $EC3->is_equal( \"1.1.1.-\" ) ) { # Prints \"not equal\".\n      print \"not equal\";\n  }\n\n  # Test for membership\n  my $EC5 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.-\" ); \n  # -- Against ECnumber object.\n  if ( $EC1->is_member( $EC5 ) ) { # Prints \"member\".\n      print \"member\"; \n  }\n  # -- Against string representation of EC number.\n  if ( ! $EC1->is_member( \"4.3.1.-\" ) ) { # Prints \"not member\".\n      print \"not member\";\n  }\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::ECnumber> is a representation of EC numbers, \nthe numerical heirarchy for Enzyme Classification.\n\nSee L<http://www.chem.qmul.ac.uk/iubmb/enzyme/> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::ECnumber;\nuse strict;\n\nuse constant DEFAULT => \"-\";\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $EC1 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.1\" );\n           or\n           $EC2 = Bio::Tools::ECnumber->new( -ec_string => \"4.3.2.2\",\n                                             -comment   => \"Is EC 4.3.2.2\" );\n           or                      \n           $EC3 = Bio::Tools::ECnumber->new(); # EC3 is now \"-.-.-.-\"                      \n Function: Creates a new ECnumber object.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A new ECnumber object.\n Args    : A string representing a EC number, e.g. \"4.3.2.1\"\n           or \"EC 4.3.2.1\" or \"1.-.-.-\".\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $EC_string, $comment )\n    = $self->_rearrange( [ qw( EC_STRING COMMENT ) ], @args );\n\n    $self->init(); \n \n    $EC_string && $self->EC_string( $EC_string );\n    $comment   && $self->comment( $comment );\n                        \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $EC1->init(); # EC1 is now \"-.-.-.-\"    \n Function: Initializes this ECnumber to default values.\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->enzyme_class( DEFAULT );\n    $self->sub_class( DEFAULT );\n    $self->sub_sub_class( DEFAULT );\n    $self->serial_number( DEFAULT );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n=head2 copy\n\n Title   : copy()\n Usage   : $EC2 = $EC1->copy();\n Function: Creates a new ECnumber object which is an exact copy\n           of this ECnumber.\n Returns : A copy of this ECnumber.\n Args    :\n\n\nsub copy {\n    my( $self ) = @_;\n    \n    my $new_ec = $self->new();\n    $new_ec->enzyme_class(  $self->enzyme_class() );\n    $new_ec->sub_class(     $self->sub_class() );\n    $new_ec->sub_sub_class( $self->sub_sub_class() );\n    $new_ec->serial_number( $self->serial_number() );\n    $new_ec->comment(       $self->comment() );\n    return $new_ec; \n\n} # copy\n\n\n\n=head2 EC_string\n\n Title   : EC_string\n Usage   : $EC3->EC_string( \"1.1.1.-\" );\n           or\n           print $EC3->EC_string();\n Function: Set/get for string representations of EC numbers.\n           Parses a EC number from \"x.x.x.x\", \"EC x.x.x.x\",\n           \"ECx.x.x.x\", or \"EC:x.x.x.x\";\n           x being either a positive integer or a \"-\".\n Returns : A string representations of a EC number.\n Args    : A string representations of a EC number.\n\n\nsub EC_string {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $value =~ s/\\s+//g; # Removes white space.\n        $value =~ s/^EC//i; # Removes \"EC\".\n        $value =~ s/^://;   # Removes \":\".\n\n        if ( $value =~ /^([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)\\.([\\d-]*)$/ ) {\n            $self->enzyme_class( $1 );\n            $self->sub_class( $2 );\n            $self->sub_sub_class( $3 );\n            $self->serial_number( $4 );\n        }\n        else {\n            $self->throw( \"Illegal format error [$value]\" );\n        }\n    }\n\n    return $self->to_string();\n\n} # EC_string\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $EC3->to_string();\n Function: To string method for EC numbers\n           (equals the \"get\" functionality of \"EC_string\").\n Returns : A string representations of a EC number.\n Args    :\n\n\nsub to_string {\n    my ( $self ) = @_;\n\n    my $s  = $self->enzyme_class() . \".\";\n    $s    .= $self->sub_class() . \".\";\n    $s    .= $self->sub_sub_class() . \".\";   \n    $s    .= $self->serial_number();\n    return $s;\n    \n} # to_string\n\n\n\n=head2 is_equal\n\n Title   : is_equal\n Usage   : if ( $EC3->is_equal( $EC2 ) )\n           or\n           if ( $EC3->is_equal( \"1.1.1.-\" ) )\n Function: Checks whether this ECnumber is equal to the argument\n           EC number (please note: \"1.1.1.1\" != \"1.1.1.-\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_equal {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    \n    unless ( $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_equal\n\n\n\n=head2 is_member\n\n Title   : is_member\n Usage   : if ( $EC1->is_member( $EC5 ) )\n           or\n           if ( $EC1->is_member( \"4.3.-.-\" ) )\n Function: Checks whether this ECnumber is a member of the (incomplete)\n           argument EC number (e.g. \"1.1.1.1\" is a member of \"1.1.1.-\"\n           but not of \"1.1.1.2\").\n Returns : True (1) or false (0).\n Args    : A ECnumber object or a string representation of a EC number.\n\n\nsub is_member {\n    my ( $self, $value ) = @_;\n\n    if ( $self->_is_not_reference( $value ) ) {\n        $value = $self->new( -ec_string => $value );\n    }\n    else {\n        $self->_is_ECnumber_object( $value );\n    }\n    $self->_check_for_illegal_defaults();\n    $value->_check_for_illegal_defaults();\n\n    unless ( $value->enzyme_class() eq DEFAULT\n    ||       $self->enzyme_class() eq $value->enzyme_class() ) {\n        return FALSE;\n    } \n    unless (  $value->sub_class() eq DEFAULT \n    ||        $self->sub_class() eq $value->sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->sub_sub_class() eq DEFAULT\n    ||       $self->sub_sub_class() eq $value->sub_sub_class() ) {\n        return FALSE;\n    } \n    unless ( $value->serial_number() eq DEFAULT\n    ||       $self->serial_number() eq $value->serial_number() ) {\n        return FALSE;\n    } \n    return TRUE;\n\n} # is_member \n\n\n\n=head2 enzyme_class\n\n Title   : enzyme_class\n Usage   : $EC1->enzyme_class( 1 );\n           or \n           print $EC1->enzyme_class(); \n Function: Set/get for the enzyme class number of ECnumbers.\n Returns : The enzyme class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub enzyme_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_enzyme_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_enzyme_class\" };\n    \n} # enzyme_class\n\n\n\n=head2 sub_class\n\n Title   : sub_class\n Usage   : $EC1->sub_class( 4 );\n           or \n           print $EC1->sub_class(); \n Function: Set/get for the enzyme sub class number of ECnumbers.\n Returns : The enzyme sub class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub sub_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_sub_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_sub_class\" };\n    \n} # sub_class\n\n\n\n=head2 sub_sub_class \n\n Title   : sub_sub_class\n Usage   : $EC1->sub_sub_class( 12 );\n           or \n           print $EC1->sub_sub_class(); \n Function: Set/get for the enzyme sub sub class number of ECnumbers.\n Returns : The enzyme sub sub class number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub sub_sub_class {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_sub_sub_class\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_sub_sub_class\" };\n    \n} # sub_sub_class\n\n\n\n=head2 serial_number\n\n Title   : serial_number\n Usage   : $EC1->serial_number( 482 );\n           or \n           print $EC1->serial_number(); \n Function: Set/get for the serial number of ECnumbers.\n Returns : The serial number of this ECnumber.\n Args    : A positive integer or \"-\".\n\n\nsub serial_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value) {\n        $self->{ \"_serial_number\" } = $self->_check_number( $value );\n    }\n   \n    return $self->{ \"_serial_number\" };\n    \n} # serial_number\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $EC1->comment( \"deprecated\" );\n           or \n           print $EC1->comment();\n Function: Set/get for a arbitrary comment.\n Returns : A comment [scalar].\n Args    : A comment [scalar].","label":"comment($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"line":509,"children":[{"containerName":"_check_number","name":"$self","definition":"my","localvar":"my","kind":13,"line":510},{"kind":13,"line":510,"containerName":"_check_number","name":"$value"},{"kind":13,"line":512,"name":"$original_value","definition":"my","containerName":"_check_number","localvar":"my"},{"kind":13,"line":512,"containerName":"_check_number","name":"$value"},{"line":513,"kind":13,"name":"$value","containerName":"_check_number"},{"kind":13,"line":514,"containerName":"_check_number","name":"$value"},{"kind":13,"line":515,"name":"$value","containerName":"_check_number"},{"containerName":"_check_number","name":"$value","line":517,"kind":13},{"name":"$value","containerName":"_check_number","kind":13,"line":518},{"kind":13,"line":519,"containerName":"_check_number","name":"$value"},{"name":"$value","containerName":"_check_number","line":521,"kind":13},{"name":"$value","containerName":"_check_number","kind":13,"line":522},{"line":523,"kind":13,"name":"$self","containerName":"_check_number"},{"line":523,"kind":12,"containerName":"_check_number","name":"throw"},{"kind":13,"line":525,"name":"$value","containerName":"_check_number"}],"kind":12,"detail":"($self,$value)","signature":{"label":"_check_number($self,$value)","documentation":" Title   : _check_number\n Function: Checks and standardizes the individual numbers of a EC number\n           (removes leading zeros, removes white spaces).\n Returns : A standardized number.\n Args    : A string representing a number in a EC number.","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":509},"end":{"line":527,"character":9999}},"name":"_check_number"},{"line":515,"kind":12,"name":"DEFAULT"},{"name":"DEFAULT","kind":12,"line":521},{"range":{"start":{"line":536,"character":0},"end":{"line":549,"character":9999}},"name":"_check_for_illegal_defaults","children":[{"line":537,"kind":13,"localvar":"my","containerName":"_check_for_illegal_defaults","name":"$self","definition":"my"},{"kind":13,"line":539,"containerName":"_check_for_illegal_defaults","name":"$self"},{"line":539,"kind":12,"name":"sub_sub_class","containerName":"_check_for_illegal_defaults"},{"kind":13,"line":540,"name":"$self","containerName":"_check_for_illegal_defaults"},{"name":"serial_number","containerName":"_check_for_illegal_defaults","kind":12,"line":540},{"name":"$self","containerName":"_check_for_illegal_defaults","kind":13,"line":541},{"containerName":"_check_for_illegal_defaults","name":"sub_class","kind":12,"line":541},{"containerName":"_check_for_illegal_defaults","name":"$self","line":542,"kind":13},{"line":542,"kind":12,"name":"sub_sub_class","containerName":"_check_for_illegal_defaults"},{"line":543,"kind":13,"name":"$self","containerName":"_check_for_illegal_defaults"},{"containerName":"_check_for_illegal_defaults","name":"enzyme_class","kind":12,"line":543},{"name":"$self","containerName":"_check_for_illegal_defaults","kind":13,"line":544},{"containerName":"_check_for_illegal_defaults","name":"sub_class","kind":12,"line":544},{"line":545,"kind":13,"containerName":"_check_for_illegal_defaults","name":"$self"},{"line":545,"kind":12,"name":"throw","containerName":"_check_for_illegal_defaults"},{"containerName":"_check_for_illegal_defaults","name":"$self","kind":13,"line":546},{"line":546,"kind":12,"containerName":"_check_for_illegal_defaults","name":"to_string"}],"line":536,"kind":12,"signature":{"documentation":" Title   : _check_for_illegal_defaults()\n Function: Checks for situations like \"1.-.1.1\", which\n           are illegal in membership tests.\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"_check_for_illegal_defaults($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"line":539,"kind":12,"name":"DEFAULT"},{"kind":12,"line":540,"name":"DEFAULT"},{"name":"DEFAULT","kind":12,"line":541},{"name":"DEFAULT","kind":12,"line":542},{"name":"DEFAULT","line":543,"kind":12},{"kind":12,"line":544,"name":"DEFAULT"},{"range":{"start":{"character":0,"line":557},"end":{"character":9999,"line":562}},"name":"_is_not_reference","signature":{"documentation":" Title   : _is_not_reference\n Function: Checks whether the argument is not a reference.\n Returns : True or false.\n Args    : A scalar.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_is_not_reference($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_is_not_reference","name":"$self","definition":"my","line":558,"kind":13},{"kind":13,"line":558,"containerName":"_is_not_reference","name":"$value"},{"kind":13,"line":560,"name":"$value","containerName":"_is_not_reference"}],"line":557,"kind":12},{"range":{"start":{"line":570,"character":0},"end":{"character":9999,"line":578}},"name":"_is_ECnumber_object","line":570,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_is_ECnumber_object","line":571,"kind":13},{"containerName":"_is_ECnumber_object","name":"$value","kind":13,"line":571},{"containerName":"_is_ECnumber_object","name":"$value","kind":13,"line":573},{"name":"isa","containerName":"_is_ECnumber_object","line":573,"kind":12},{"containerName":"_is_ECnumber_object","name":"$self","kind":13,"line":574},{"kind":12,"line":574,"containerName":"_is_ECnumber_object","name":"throw"},{"line":574,"kind":13,"containerName":"_is_ECnumber_object","name":"$value"}],"kind":12,"detail":"($self,$value)","signature":{"label":"_is_ECnumber_object($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Title   : _is_ECnumber_object\n Function: Checks whether the arument is a ECnumber.\n Returns :\n Args    : A reference."},"containerName":"main::","definition":"sub"}]}